/*
 * rat.h --
 *
 *      Declarations for things used internally by the Ratatosk
 *      procedures but not exported outside the module.
 *
 * TkRat software and its included text is Copyright 1996-1999 by
 * Martin Forssn
 *
 * The full text of the legal notice is contained in the file called
 * COPYRIGHT, included with this distribution.
 */

#ifndef _RAT_H
#define _RAT_H

#include "../config.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <stdlib.h>
#include <ctype.h>
#include <mail.h>
#include <nl.h>
#include <rfc822.h>
#include <env.h>
#include <smtp.h>
#include <misc.h>
#include <string.h>
#include <pwd.h>
#include <utime.h>
#ifdef TM_IN_SYS_TIME
# include <sys/time.h>
#else
# include <time.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#ifdef __STDC__
# include <stdarg.h>
#else
# include <varargs.h>
#endif

/*
 * dirent definitions
 */
#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

/*
 * Wait
 */
#include <sys/types.h>
#if HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
# define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8) 
#endif
#ifndef WIFEXITED
# define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif  
/* Last chance guess for WNOHANG */
#ifndef WNOHANG
#define WNOHANG 1
#endif

/*
 * snprintf
 * Redefine to sprintf for systems which does not have snprintf
 */
#ifndef HAVE_SNPRINTF
# define snprintf(b, l, a...)	sprintf(b, ##a)
#endif

#include <tcl.h>

/*
 * Sigh, tcl uses different prototypes for its replacement functions for
 * malloc, realloc and free than in the original functions. Also tcl
 * version 8.2 does always use these replacement functions.
 */

#ifdef TCL_MEM_DEBUG
#   undef ckalloc
#   undef ckfree
#   undef ckrealloc
#   define ckalloc(x) Tcl_DbCkalloc(x, __FILE__, __LINE__)
#   define ckfree(x)  Tcl_DbCkfree((char*)x, __FILE__, __LINE__)
#   define ckrealloc(x,y) ((x)?Tcl_DbCkrealloc((char*)(x), (y),__FILE__, __LINE__) : Tcl_DbCkalloc((y), __FILE__, __LINE__))
#else /* TCL_MEM_DEBUG */
#   if TCL_MAJOR_VERSION == 8 && TCL_MINOR_VERSION >= 2
#       undef ckalloc
#       undef ckfree
#       undef ckrealloc
#       define ckalloc(x)	Tcl_Alloc(x)
#       define ckfree(x)  	Tcl_Free((char*)x)
#       define ckrealloc(x,y)	((x) ? Tcl_Realloc((char*)x, y) : Tcl_Alloc(y))
#   else /* TCL_MAJOR_VERSION == 8 && TCL_MINOR_VERSION >= 2 */
#       undef ckrealloc
#       define ckrealloc(x,y)	((x) ? realloc(x, y) : malloc(y))
#   endif /* TCL_MAJOR_VERSION == 8 && TCL_MINOR_VERSION >= 2 */
#endif /* TCL_MEM_DEBUG */

#define FILEMODE 0600		/* The mode of created files */
#define DIRMODE 0700		/* The mode of created directories */

/*
 * The structure returned by RatDbGet which describes an entry in the
 * database.
 */

typedef enum {
    TO, FROM, CC, MESSAGE_ID, REFERENCE, SUBJECT, DATE, KEYWORDS, RSIZE, STATUS,
    EX_TIME, EX_TYPE, FILENAME, RATDBETYPE_END
} RatDbEType;

typedef struct RatDbEntry {
    char *content[RATDBETYPE_END];
} RatDbEntry;

/*
 * The different classes of log messages
 */
typedef enum {
    RAT_BABBLE, RAT_PARSE, RAT_WARN, RAT_ERROR, RAT_FATAL, RAT_INFO
} RatLogLevel;
typedef enum {
    RATLOG_TIME, RATLOG_EXPLICIT, RATLOG_NOWAIT
} RatLogType;

typedef struct RatFolderInfo *RatFolderInfoPtr;

/*
 * A SMTP channel
 */
typedef void *SMTPChannel;

/*
 * A DSN handle
 */
typedef void *DSNhandle;

/*
 * Hexadecimal characters
 */
extern char alphabetHEX[17];

/* ratAppInit.c */
extern Tcl_Interp *timerInterp;
extern char *currentHost;
extern char *currentDomain;
extern char *currentMailboxName;
extern char *currentPersonalName;
extern char *dayName[];
extern char *monthName[];
extern void RatLog (Tcl_Interp *interp, RatLogLevel level, char *message,
	RatLogType type);
extern void RatLogF (Tcl_Interp *interp, RatLogLevel level, char *tag,
	RatLogType type, ...);
extern Tcl_Obj *RatMangleNumber(int number);
extern int RatSearch (char *searchFor, char *searchIn);
extern long RatTclPuts (void *stream_x, char *string);
extern long RatStringPuts (void *stream_x, char *string);
extern long RatDelaySoutr (void *stream_x, char *string);
extern void RatInitDelaySoutr(void);
extern MESSAGE *RatParseMsg (Tcl_Interp *interp, char *message);
extern int RatIsEmpty (char *string);
extern int RatEncodingCompat (Tcl_Interp *interp, char *wanted, char *avail);
extern char* RatLindex (Tcl_Interp *interp, char *list, int index);
extern Tcl_CmdProc RatGenId;
extern Tcl_Obj *RatFormatDate(Tcl_Interp *interp, int month, int day);
extern int RatGetTimeZone(unsigned long currentTime);
extern char *RatStrNCpy(char *dst, const char *src, size_t n);
extern void Rat_DStringApendNoCRLF(Tcl_DString *ds, const char *s, int length);

/* ratHold.c */
extern Tcl_CmdProc RatHold;
extern int RatHoldInsert(Tcl_Interp *interp, char *dir, char *handler,
	char *description);
extern int RatHoldList(Tcl_Interp *interp, char *dir, Tcl_DString *fileListPtr);
extern int RatHoldExtract(Tcl_Interp *interp, char *prefix,
	Tcl_DString *usedVariablesPtr, Tcl_DString *filesPtr);
extern void RatHoldInitVars(Tcl_Interp *interp);
extern void RatHoldUpdateVars(Tcl_Interp *interp, char *dir, int diff);

/* RatSender.c */
extern void RatSender(Tcl_Interp *interp);
extern char *RatSendPGPCommand(char *cmd);

/* ratFolder.c */
extern int RatFolderInit (Tcl_Interp *interp);

/* ratStdFolder.c */
extern void AppendToIMAP(Tcl_Interp *interp, char *mailbox, char *user,
			 char *flags, char *date, char *msg, int length);
extern void ClearStdPasswds(int freethem);
extern Tcl_ObjCmdProc RatCheckEncodingsCmd;

/* ratCode.c */
extern char *RatDecodeHeader(Tcl_Interp *interp, char *string, int adr);
extern Tcl_DString *RatDecode(Tcl_Interp *interp, int cte,
	char *data, int length, char *charset);
extern char *RatEncodeHeaderLine(Tcl_Interp *interp, Tcl_Obj *line,
	int nameLength);
extern void RatEncodeAddresses(Tcl_Interp *interp, ADDRESS *adrPtr);
extern Tcl_Encoding RatGetEncoding(Tcl_Interp *interp, char *name);
extern Tcl_Obj *RatCode64(Tcl_Obj *oPtr);

/* ratAddress.c */
extern Tcl_HashTable aliasTable;
extern Tcl_ObjCmdProc RatCreateAddressCmd;
extern void RatInitAddresses (Tcl_Interp *interp, ADDRESS *addressPtr);
extern int RatAddress (ClientData dummy, Tcl_Interp *interp, int argc,
	char *argv[]);
extern Tcl_CmdDeleteProc RatDeleteAddress;
extern int RatAddressIsMe (Tcl_Interp *interp, ADDRESS *adrPtr, int useUP);
extern int RatAddressCompare (ADDRESS *adr1Ptr, ADDRESS* adr2Ptr);
extern void RatAddressTranslate (Tcl_Interp *interp, ADDRESS *adrPtr);
extern Tcl_ObjCmdProc RatAliasCmd;
extern void RatAddressTranslate (Tcl_Interp *interp, ADDRESS *adrPtr);
extern char *RatAddressMail(ADDRESS *adrPtr);
extern Tcl_CmdProc RatSplitAddresses;
extern size_t RatAddressSize(ADDRESS *adrPtr, int all);

/* ratDbase.c */
extern int RatDbInsert (Tcl_Interp *interp, char *to, char *from, char *cc,
	char *msgid, char *ref, char *subject, long date, char *flags,
	char *keywords, long exDate, char *exType, char *fromline, char *mail,
	int length);
extern int RatDbSetStatus (Tcl_Interp *interp, int index, char *status);
extern int RatDbSearch (Tcl_Interp *interp, char *exp, int *numFoundPtr,
	int **foundPtrPtr);
extern RatDbEntry *RatDbGetEntry (int index);
extern MESSAGE *RatDbGetMessage (Tcl_Interp *interp, int index, char **bufPtr);
extern char *RatDbGetHeaders (Tcl_Interp *interp, int index);
extern char *RatDbGetFrom(Tcl_Interp *interp, int index);
extern char *RatDbGetText (Tcl_Interp *interp, int index);
extern int RatDbDelete (Tcl_Interp *interp, int index);
extern int RatDbExpunge (Tcl_Interp *interp);
extern int RatDbDaysSinceExpire (Tcl_Interp *interp);
extern int RatDbExpire (Tcl_Interp *interp, char *infolder,
	char *backupDirectory);
extern void RatDbClose(void);
extern int RatDbCheck(Tcl_Interp *interp, int fix);

/* ratSMTP.c */
extern SMTPChannel RatSMTPOpen (Tcl_Interp *interp, char *host, int verbose);
extern void RatSMTPClose (Tcl_Interp *interp, SMTPChannel channel, int verbose);
extern int RatSMTPSend (Tcl_Interp *interp, SMTPChannel channel,
	ENVELOPE *envelopePtr, BODY *bodyPtr, int requestDSN, int verbose);
extern Tcl_CmdProc RatSMTPSupportDSN;
extern long RatTclPutsSMTP (void *stream_x, char *string);
extern size_t RatHeaderSize(ENVELOPE *env,BODY *body);

/* ratDSN.c */
extern int RatDSNInit (Tcl_Interp *interp);
extern DSNhandle RatDSNStartMessage (Tcl_Interp *interp, char *id,
	char *subject);
extern void RatDSNAddRecipient (Tcl_Interp *interp, DSNhandle handle,
	char *recipient);
extern void RatDSNAbort (Tcl_Interp *interp, DSNhandle handle);
extern void RatDSNFinish (Tcl_Interp *interp, DSNhandle handle);
extern int RatDSNHandle (Tcl_Interp *interp, char *msg);
extern int RatDSNExtract (Tcl_Interp *interp, Tcl_Obj *body);

/* ratMessage.c */
extern int RatMessageGetHeader(Tcl_Interp *interp, char *srcHeader);
Tcl_Obj *RatWrapMessage(Tcl_Interp *interp, Tcl_Obj *oPtr);

/* ratMailcap.c */
extern Tcl_CmdProc RatMailcapReload;

/* ratCompat.c */
extern Tcl_CmdProc RatFile;

/* ratPwCache.c */
extern char *RatGetCachedPassword(Tcl_Interp *interp, const char *host,
	unsigned int port, const char *user, const char *service);
extern void RatCachePassword(Tcl_Interp *interp, const char *host,
        unsigned int port, const char *user, const char *passwd,
	const char *service, int store);
extern void RatPasswdCachePurge(Tcl_Interp *interp, int disk_also);
extern Tcl_ObjCmdProc RatPasswdCachePurgeCmd;

/* ratPrint.c */
extern Tcl_ObjCmdProc RatPrettyPrintMsg;

#endif /* _RAT_H */
