#
#  Copyright (c) 1994-1997 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: viewBatch.t,v 1.3 1996/12/31 01:49:44 andy Exp $
#

proc initBatch { args } {

    global Th_Info
    global env

    # Where to find the local database of batch aliases. FAXALIASES is
    # a fully qualified pathname of a file. E.g. "./tkhylafax/faxaliases"
    if {[info exists env(FAXALIASES)]} {
         set Th_Info(batchAliasdb) $env(FAXALIASES)
         if {![file exists $Th_Info(batchAliasdb)]} { 
             set in [open $Th_Info(batchAliasdb) {CREAT WRONLY}]
             close $in
         }
    } else {
         set Th_Info(batchAliasdb) {}
    }

    set Th_Info(batchDest) {}
}

#
# Make a listbox to view the batch entries.
#

proc viewBatch { top } {

    global Th_Info 

    set t [mkToplevel $top {Batch Recipients}]
    wm geometry $t 630x200

    set hdr [format "$Th_Info(style)" "Name" "Company" "Phone"]

    set list [mkFrame $t list {-side top -fill both}]
    set oper [mkFrame $t oper {-side bottom -fill x}]
    set lb [mkLabeledListbox $t $hdr -selectmode browse]
    set Th_Info(viewBatch) $lb ;# For later refernce
    mkButton $oper search {-side left} -text Remove \
        -command "removeRecipient $lb"
    mkButton $oper alias {-side left} -text Alias -command "aliasBatch $lb" 
    mkButton $oper clear {-side left} -text Clear -command "clearBatch $lb" 
    mkButton $oper dismiss {-side left} -text Dismiss -command "destroy $t" 

    foreach i $Th_Info(batchDest) {
	$lb insert end $i
    }

}

proc clearBatch { lb } {

    global Th_Info

    set Th_Info(batchDest) {}

    # Clear the batch listbox. Check
    # for window, since this procedure
    # may be called from main panel.
    if {[winfo exists $lb]} {
        $lb delete 0 end
    }
}

proc aliasBatch { lb } {

    global Th_Info
    global batchAliaslist
        
    # If the cache was not initialized, initialize it.
    if {[checkCacheDB $Th_Info(batchAliasdb) batchAliaslist]} {
        return
    }

    set alias [dialog_main -message "Enter alias name for this batch"]
    if {$alias == ""} {
    	return
    }

    # If batch alias already exists, replace it with the new
    # recipient list.
    if {[lsearch -exact [array name batchAliaslist] $alias] >= 0} {
	set "batchAliaslist($alias)" {}
    }

    set batchSize [$lb size]
    for {set idx 0} {$idx < $batchSize} {incr idx} {
	set entry [$lb get $idx]
	# Extract the name.
	set name [extractName $entry]
    	lappend "batchAliaslist([string trim $alias])" $name 
    }

    # Update database on disk
    updateDB $Th_Info(batchAliasdb) batchAliaslist
}

proc removeRecipient { lb } {

    global Th_Info

    set idx [$lb curselection]
    if {$idx == ""} {
	return
    }
    $lb delete $idx 
    set Th_Info(batchDest) {}
    set size [$lb size]
    for {set i 0} {$i < $size} {incr i} {
	lappend Th_Info(batchDest) [$lb get $i]
    }
}
