#  Copyright (c) 1994-1997 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: listBatches.t,v 1.2 1996/12/31 01:49:40 andy Exp $
#

#
# Make a listbox to view the batch aliases.
#

proc listBatches { top } {

    global Th_Info
    global batchAliaslist
    global phonelist

    # If the cache was not initialized, initialize it.
    if {[checkCacheDB $Th_Info(phonedb) phonelist]} {
	return
    }

    # If the cache was not initialized, initialize it.
    if {[checkCacheDB $Th_Info(batchAliasdb) batchAliaslist]} {
        return
    }

    set t [mkToplevel $top {Batch Alias List}]
    wm geometry $t 630x200

    set list [mkFrame $t list {-side top -fill both}]
    set oper [mkFrame $t oper {-side bottom -fill x}]
    set lb [mkListbox $t -selectmode browse]
    mkButton $oper remove {-side left} -text Remove -command "removeAlias $lb"
    mkButton $oper select {-side left} -text Select -command "selectAlias $lb"
    mkButton $oper dismiss {-side left} -text Dismiss -command "destroy $t"

    foreach i [array name batchAliaslist] {
	$lb insert end $i
    }
}

proc removeAlias { lb } {

    global batchAliaslist
    global Th_Info
        
    set idx [$lb curselection]
    if {$idx == ""} {
	return
    }
    set name [$lb get $idx]

    unset "batchAliaslist($name)"

    # Update database on disk
    updateDB $Th_Info(batchAliasdb) batchAliaslist

    # Show updated fax aliases
    $lb delete $idx
}

proc selectAlias { lb } {

    global phonelist
    global batchAliaslist
    global Th_Info

    set idx [$lb curselection]
    if {$idx == ""} {
	return
    }
    set name [$lb get $idx]

    # For each name associated with this alias, load the batch
    # destination list.
    foreach n $batchAliaslist($name) {
	if {![info exists phonelist($n)]} {
	    continue
	}
	set company [lindex $phonelist($n) 0]
	set phone [lindex $phonelist($n) 1]
	set entry [format "$Th_Info(style)" $n $company $phone]
	lappend Th_Info(batchDest) $entry
    }

    # Update the batch listbox
    if {[info exists Th_Info(viewBatch)] &&
        [winfo exists $Th_Info(viewBatch)]} {
	$Th_Info(viewBatch) delete 0 end
	foreach d $Th_Info(batchDest) {
	    $Th_Info(viewBatch) insert end $d
	}
    }

    # Clear selection
    $lb select clear 0 end
}
