# 
#  Copyright (c) 1994-1997 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: fileSelect.t,v 1.2 1996/12/31 01:49:40 andy Exp $
#
# Make a toplevel window that shows the files in a directory and allow user
# to navigate around.
#

proc fileSelect { w } {

    global Th_Info
    mkToplevel $w {Directory Browser} 
    wm geometry $w 450x250
    wm minsize $w 100 100

    set Th_Info(curWorkDir) [exec pwd]
    set Th_Info(curFltr) {*}

    set list [mkFrame $w list] 
    set lb [mkListbox $list -selectmode browse]
    set f [mkFrame $w f {-side bottom -fill x}]
    set f1 [mkLabeledEntry $f f1 {Current Directory:} Th_Info(curWorkDir) 35]
    mkButton $f1 select {-side right} -text SELECT -command "select_cb $lb"
    set f2 [mkLabeledEntry $f f2 {Files of Type:} Th_Info(curFltr) 10]
    mkButton $f2 dismiss {-side right} -text DISMISS -command "destroy $w"
	
    getDirListing $lb
    bind $lb <Double-Button-1> "navigate_cb $lb"
    bind $f2.entry <FocusOut> "getDirListing $lb"
    bind $f1.entry <FocusOut> "getDirListing $lb"
}

proc getDirListing { lb } {

    global Th_Info 

    if {![file isdirectory $Th_Info(curWorkDir)]} {
	tk_dialog .err "Ooops!" \
	    "$Th_Info(curWorkDir) is not a directory" info 0 OK
	return
    }

    if {![file readable $Th_Info(curWorkDir)]} {
	tk_dialog .err "Ooops!" \
	    "You have no read access to that directory" info 0 OK
	return
    }

    if {[catch {set files [split [exec ls -al $Th_Info(curWorkDir)] \n]} res]} {
	tk_dialog .err "Ooops!" "$res" info 0 OK
	$lb select clear 0 end
	set Th_Info(curWorkDir) [file dirname $Th_Info(curWorkDir)] 
	return
    }
    $lb delete 0 end
    foreach ln $files {
	regexp {[^ ]+$} $ln filename
	if {[file isdirectory $Th_Info(curWorkDir)/$filename] ||
	    [string match $Th_Info(curFltr) $filename]} { 
	    $lb insert end $ln
	}
    }
}

proc navigate_cb { lb } {

    global Th_Info

    set idx [$lb curselection]
    if {$idx == ""} {
        return
    }
    set filename [$lb get $idx]
    # Extract the filename from the selected item.
    regexp {[^ ]+$} $filename choice
    if {[file isdirectory $Th_Info(curWorkDir)/$choice]} {
	switch -exact -- $choice .. {
	    set Th_Info(curWorkDir) [file dirname $Th_Info(curWorkDir)] 
	} . {
	    # Nothing to do -just rescan 
	} default {
	    if {![regexp {.*/$} $Th_Info(curWorkDir) junk]} {
		set Th_Info(curWorkDir) $Th_Info(curWorkDir)/$choice
	    } else {
		set Th_Info(curWorkDir) $Th_Info(curWorkDir)$choice
	    }
	}
	if {[file readable $Th_Info(curWorkDir)]} {
	    getDirListing $lb
	} else {
	    tk_dialog .err "Ooops!" \
		"You have no read access to that directory" info 0 OK
	    set Th_Info(curWorkDir) [file dirname $Th_Info(curWorkDir)] 
	}
    } elseif {[file isfile $Th_Info(curWorkDir)/$choice]} {
	# Enter this file in the list to fax
	if {![regexp {.*/$} $Th_Info(curWorkDir) junk]} {
	    $Th_Info(docsLB) insert end $Th_Info(curWorkDir)/$choice
	} else {
	    $Th_Info(docsLB) insert end $Th_Info(curWorkDir)$choice
	}
    }
    $lb select clear 0 end
}

proc select_cb { lb } {

    global Th_Info

    set idx [$lb curselection]
    if {$idx == ""} {
        return
    }
    set filename [$lb get $idx]
    # Extract the filename from the selected item.
    regexp {[^ ]+$} $filename choice
    if {[file isfile $Th_Info(curWorkDir)/$choice]} {
	# Enter this file in the list to fax
	$Th_Info(docsLB) insert end $Th_Info(curWorkDir)/$choice
	$lb select clear 0 end
    }
}
