#!/bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

#    Copyright 2003,2007 Regis Damongeot

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#window title
wm title . "TkDVD 4.0.6"
wm geometry . 700x550
wm protocol . WM_DELETE_WINDOW { save_options; destroy . }
set burn_type "burn_dvd"
set v_create_iso "no"
set burning_device "/dev/sr0"
#used when creating ISO to save CD/DVD device
set temp_burning_device ""
set burn_command "growisofs"
set volume_id ""
set volume_id_o ""
set option_udf_ext ""
set option_joliet_ext "-J"
set option_rr_ext "-r"
set option_pad "-pad"
set file_list ""
set excluded_file_list ""
set only_one_file ""
set input ""
set total_file_size_f "0 KB"
set space_left_f "4.377 GB"
set dvd_size "4589850"
set selected_directory "[pwd]"
set iso_file ""
set t_session "-use-the-force-luke=tty -Z"
set option_dvd_compat "-dvd-compat"
set option_auto_refresh_space "1"
set option_overburn ""
set option_eject_cd ""
set option_tao_dao_cd "-tao"
set cd_session_type ""
set burn_speed ""
set language "English"
set i18n_language_list ""
set command_line "growisofs $t_session $burning_device $option_joliet_ext $option_rr_ext $burn_speed $option_dvd_compat $option_pad -graft-points"
#needed to not have too large precision when showing total files size
set tcl_precision 4

#set fullpath to source scripts (if TkDVD not launch from it install direcotory)
set source_directory "[info script]"
if { [file pathtype $source_directory] == "absolute" } {
	set source_directory [file dirname $source_directory]
} else {
	set source_directory "[file dirname [pwd]/[info script]]"
}

#we need to set a variable to fix compatibility problems between tcl 8.4 and 8.5
# 8.5 has a tristate value for checkbuttons which is by default "" that conflits with offvalue for TkDVD advanced options
# so we need to set a different tristate value with -tristatevalue option but, as tk 8.4 doesn't have this option, we must not set this option in this case. So a global variable set to "" when tk 8.4 is detected and set to "-tristatevalue "tristate"" will do the job.
set tristatecompatibility "no"
if { [string equal -length 3 $tk_patchLevel "8.5"] == 1 } {
  set tristatecompatibility "yes"
}

#source combobox code
if { [catch { package require combobox 2.3 } ] } {
#do not leave space before the following line or install.tcl will not work
source ${source_directory}/src/combobox.tcl
}
#source save/load config options procedure
source ${source_directory}/src/save_load_options.tcl
#load user default options
load_options
#change command line variable according to loaded values
set command_line "growisofs $t_session $burning_device $option_joliet_ext $option_rr_ext $option_dvd_compat $option_pad -graft-points"
#source internationalisation variables
source ${source_directory}/src/internationalization.tcl
#source of the total file size count procedure
source ${source_directory}/src/proc_total_file_size.tcl
#source of the refresh command line procedure (main procedure)
source ${source_directory}/src/proc_refresh_cmd_line.tcl
#source of excluded file window and its needed procedures
source ${source_directory}/src/excluded_file_window.tcl
#source advanced options window procedure
source ${source_directory}/src/advanced_options_window.tcl
#source main TkDVD window
source ${source_directory}/src/main_window.tcl
#source all procedures left
source ${source_directory}/src/other_procedures.tcl
#refresh space left for initial DVD size loaded from config file
refresh_total_file_size
#refresh cmd line (mkisofs for exemple if dvd size == CD size
refresh_cmd_line

