/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.utils.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.jgraph.pad.resources.ImageLoader;
import org.jgraph.pad.resources.LocaleChangeEvent;
import org.jgraph.pad.resources.LocaleChangeListener;
import org.jgraph.pad.resources.ProperNameProvider;
import org.jgraph.pad.resources.Translator;
import org.jgraph.pad.resources.TranslatorConstants;

public class LocaleChangeAdapter
implements LocaleChangeListener,
ProperNameProvider,
TranslatorConstants {
    public static final String SET_TEXT_IF_ICON_NOT_AVAILABLE = "SetTextIfIconNotAvailable";
    public static final String DONT_SET_TOOL_TIP_TEXT = "DontSetToolTipText";
    public static final String DONT_SET_MNEMONIC = "DontSetMnemonic";
    Hashtable properNames = new Hashtable();
    static final NumberFormat numberFormat = new DecimalFormat("000");
    protected static LocaleChangeAdapter localeChangeAdapter = new LocaleChangeAdapter();
    protected static Vector containers = new Vector();

    public LocaleChangeAdapter() {
        Translator.addLocaleChangeListener(this);
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = 0;
        while (n < lookAndFeelInfoArray.length) {
            if (lookAndFeelInfoArray[n].getName() != null) {
                this.properNames.put("Component." + lookAndFeelInfoArray[n].getName() + ".Text", lookAndFeelInfoArray[n].getName());
                this.properNames.put("Component." + lookAndFeelInfoArray[n].getName() + ".ToolTipText", lookAndFeelInfoArray[n].getName());
                this.properNames.put("Component." + lookAndFeelInfoArray[n].getName() + ".Mnemonic", lookAndFeelInfoArray[n].getName());
                if (lookAndFeelInfoArray[n].getClassName() != null) {
                    this.properNames.put("Component." + lookAndFeelInfoArray[n].getClassName() + ".Text", lookAndFeelInfoArray[n].getName());
                    this.properNames.put("Component." + lookAndFeelInfoArray[n].getClassName() + ".ToolTipText", lookAndFeelInfoArray[n].getName());
                    this.properNames.put("Component." + lookAndFeelInfoArray[n].getClassName() + ".Mnemonic", lookAndFeelInfoArray[n].getName());
                }
            }
            ++n;
        }
        Translator.getDefaultResourceBundle().addProperNameProvider(this);
    }

    protected static LocaleChangeAdapter getLocaleChangeAdapter() {
        return localeChangeAdapter;
    }

    public static void addContainer(Container container) {
        containers.add(container);
        LocaleChangeAdapter.updateContainer(container);
    }

    public static void removeContainer(Container container) {
        containers.remove(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localeChanged(LocaleChangeEvent localeChangeEvent) {
        Vector vector;
        Vector vector2 = containers;
        synchronized (vector2) {
            vector = (Vector)containers.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LocaleChangeAdapter.updateContainer((Container)enumeration.nextElement());
        }
    }

    public static void updateContainer(Container container) {
        Component component;
        if (container == null) {
            return;
        }
        LocaleChangeAdapter.updateComponent(container);
        if (container instanceof JFrame) {
            LocaleChangeAdapter.updateContainer(((JFrame)container).getJMenuBar());
            LocaleChangeAdapter.updateContainer(((JFrame)container).getContentPane());
        }
        int n = 0;
        while (n < container.getComponentCount()) {
            component = container.getComponent(n);
            if (component instanceof Container) {
                LocaleChangeAdapter.updateContainer((Container)component);
            } else {
                LocaleChangeAdapter.updateComponent(component);
            }
            ++n;
        }
        if (container instanceof JMenu) {
            component = (JMenu)container;
            int n2 = 0;
            while (n2 < ((JMenu)component).getItemCount()) {
                JMenuItem jMenuItem = ((JMenu)component).getItem(n2);
                if (jMenuItem instanceof Container) {
                    LocaleChangeAdapter.updateContainer(jMenuItem);
                } else {
                    LocaleChangeAdapter.updateComponent(jMenuItem);
                }
                ++n2;
            }
        }
    }

    public static void updateComponent(Component component) {
        block41: {
            Object object;
            String string;
            if (component == null || component.getName() == null) {
                return;
            }
            try {
                if ((component instanceof Frame || component instanceof Dialog || component instanceof JInternalFrame) && (string = Translator.getString("Component." + component.getName() + ".Title")) != null) {
                    if (component instanceof Frame) {
                        ((Frame)component).setTitle(string);
                    }
                    if (component instanceof Dialog) {
                        ((Dialog)component).setTitle(string);
                    }
                    if (component instanceof JInternalFrame) {
                        ((JInternalFrame)component).setTitle(string);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            try {
                if (component instanceof JComponent) {
                    string = Translator.getString("Component." + component.getName() + ".ToolTipText");
                    if (string == null) {
                        string = Translator.getString("Component." + component.getName() + ".Text");
                    }
                    if ((object = (Boolean)((JComponent)component).getClientProperty(DONT_SET_TOOL_TIP_TEXT)) != null && ((Boolean)object).booleanValue()) {
                        string = null;
                    }
                    if (string != null) {
                        ((JComponent)component).setToolTipText(string);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            try {
                if (component instanceof AbstractButton) {
                    string = Translator.getString("Component." + component.getName() + ".Mnemonic");
                    object = (Boolean)((JComponent)component).getClientProperty(DONT_SET_MNEMONIC);
                    if (object != null && ((Boolean)object).booleanValue()) {
                        string = null;
                    }
                    if (string != null && string.length() > 0) {
                        ((AbstractButton)component).setMnemonic(string.toCharArray()[0]);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            try {
                if (component instanceof JMenuItem && (string = Translator.getString("Component." + component.getName() + ".Accelerator")) != null && string != null && string.length() > 0) {
                    object = KeyStroke.getKeyStroke(string);
                    ((JMenuItem)component).setAccelerator((KeyStroke)object);
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            boolean bl = false;
            try {
                if ((component instanceof JOptionPane || component instanceof AbstractButton || component instanceof JLabel) && (object = ImageLoader.getImageIcon(Translator.getString("Component." + component.getName() + ".Icon"))) != null) {
                    bl = true;
                    if (component instanceof JOptionPane) {
                        ((JOptionPane)component).setIcon((Icon)object);
                    }
                    if (component instanceof AbstractButton) {
                        ((AbstractButton)component).setIcon((Icon)object);
                    }
                    if (component instanceof JLabel) {
                        ((JLabel)component).setIcon((Icon)object);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            try {
                if ((component instanceof Label || component instanceof AbstractButton || component instanceof JLabel) && (object = Translator.getString("Component." + component.getName() + ".Text")) != null) {
                    Boolean bl2 = null;
                    if (component instanceof JComponent) {
                        bl2 = (Boolean)((JComponent)component).getClientProperty(SET_TEXT_IF_ICON_NOT_AVAILABLE);
                    }
                    if (bl2 != null && bl2.booleanValue() && bl) {
                        object = null;
                    }
                    if (component instanceof Label) {
                        ((Label)component).setText((String)object);
                    }
                    if (component instanceof AbstractButton) {
                        ((AbstractButton)component).setText((String)object);
                    }
                    if (component instanceof JLabel) {
                        ((JLabel)component).setText((String)object);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            try {
                if (!(component instanceof JTabbedPane)) break block41;
                object = (JTabbedPane)component;
                int n = 0;
                while (n < ((JTabbedPane)object).getTabCount()) {
                    String string2;
                    String string3;
                    String string4 = Translator.getString("Component." + component.getName() + ".Title" + numberFormat.format(n));
                    if (string4 != null) {
                        ((JTabbedPane)object).setTitleAt(n, string4);
                    }
                    if ((string3 = Translator.getString("Component." + component.getName() + ".ToolTipText" + numberFormat.format(n))) != null) {
                        ((JTabbedPane)object).setToolTipTextAt(n, string3);
                    }
                    if ((string2 = Translator.getString("Component." + component.getName() + ".Mnemonic" + numberFormat.format(n))) != null && string2.length() > 0) {
                        ((JTabbedPane)component).setMnemonicAt(n, string2.toCharArray()[0]);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    public Enumeration getKeys() {
        return this.properNames.keys();
    }

    public String getString(String string) {
        return (String)this.properNames.get(string);
    }
}

