/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.pad.GPDocument;
import org.jgraph.pad.GPGraph;

public class GPOverviewPanel
extends JPanel
implements ComponentListener,
GraphModelListener,
Observer {
    protected GPGraph graph;
    protected JGraph originalGraph;
    protected PannerViewfinder v;
    protected Rectangle r;
    double graphWindowToPannerScale = 0.5;
    static final int PANEL_BUFFER = 2;

    protected GPOverviewPanel(JGraph jGraph, GPDocument gPDocument) {
        this.originalGraph = jGraph;
        this.v = new PannerViewfinder(this, gPDocument.getScrollPane().getViewport());
        ViewRedirector viewRedirector = new ViewRedirector(jGraph, jGraph.getGraphLayoutCache());
        this.graph = new GPGraph(jGraph.getModel(), viewRedirector);
        this.graph.setAntiAliased(true);
        this.graph.getModel().addGraphModelListener(this);
        this.graph.setEnabled(false);
        this.graph.addMouseListener(this.v);
        this.graph.addMouseMotionListener(this.v);
        jGraph.addPropertyChangeListener("scale", this.v);
        this.addComponentListener(this);
        jGraph.getGraphLayoutCache().addObserver(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.graph, "Center");
    }

    public static JPanel createOverviewPanel(JGraph jGraph, GPDocument gPDocument) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new MatteBorder(2, 2, 2, 2, Color.WHITE));
        jPanel.add((Component)new GPOverviewPanel(jGraph, gPDocument), "Center");
        return jPanel;
    }

    public void update(Observable observable, Object object) {
        this.componentResized(null);
    }

    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        this.v.update(graphics);
    }

    public void graphChanged(GraphModelEvent graphModelEvent) {
        this.componentResized(null);
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.v.getViewport().getView().getSize();
        dimension.setSize((double)(dimension.width * 1) / this.v.zoomScale, (double)(dimension.height * 1) / this.v.zoomScale);
        Dimension dimension2 = this.getSize();
        double d = dimension2.getWidth() / dimension.getWidth();
        double d2 = dimension2.getHeight() / dimension.getHeight();
        this.graphWindowToPannerScale = Math.min(d, d2);
        this.graph.setScale(this.graphWindowToPannerScale);
        this.v.synchViewportWithPanner();
        this.repaint();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.componentResized(componentEvent);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    class PannerViewfinder
    implements MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    ChangeListener {
        public final int LEFT_VERTICAL = 1;
        public final int RIGHT_VERTICAL = 2;
        public final int UPPER_HORIZONTAL = 4;
        public final int LOWER_HORIZONTAL = 8;
        public final int NW_CORNER = 5;
        public final int NE_CORNER = 6;
        public final int SW_CORNER = 9;
        public final int SE_CORNER = 10;
        int scaledWidth = 50;
        int scaledHeight = 25;
        int last_x;
        int last_y;
        Rectangle pannerContainerRectangle;
        Rectangle pannerViewRectangle;
        Rectangle pannerViewRectangleCopy;
        Rectangle pannerContainerRectangleCopy;
        Rectangle pannerResizeDecoration;
        Container container;
        JViewport viewport;
        double zoomScale = 1.0;
        double combinedScale;
        boolean isActive;
        boolean isResizing;
        BasicStroke stroke;
        float[] dash1;
        BasicStroke dashStroke;
        private Point viewportPosition;
        static final int DECORATION_SIZE = 4;

        public PannerViewfinder(Container container, JViewport jViewport) {
            this.combinedScale = GPOverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
            this.isActive = false;
            this.isResizing = false;
            this.stroke = new BasicStroke(1.0f);
            this.dash1 = new float[]{2.5f};
            this.dashStroke = new BasicStroke(1.0f, 0, 0, 1.0f, this.dash1, 0.0f);
            this.container = container;
            this.viewport = jViewport;
            this.viewport.addChangeListener(this);
            this.pannerViewRectangle = new Rectangle(0, 0, this.scaledWidth, this.scaledHeight);
            this.viewportPosition = new Point(0, 0);
            this.pannerResizeDecoration = new Rectangle(4, 4);
        }

        private boolean isContained(MouseEvent mouseEvent) {
            return this.pannerViewRectangle.contains(mouseEvent.getX(), mouseEvent.getY());
        }

        public JViewport getViewport() {
            return this.viewport;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!this.isResizing) {
                this.synchViewportWithPanner();
                this.container.repaint();
            }
        }

        public void synchViewportWithPanner() {
            Point point = this.viewport.getViewPosition();
            this.combinedScale = GPOverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
            int n = (int)(point.getX() * this.combinedScale);
            int n2 = (int)(point.getY() * this.combinedScale);
            this.pannerViewRectangle.setLocation(n, n2);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!this.isResizing) {
                this.zoomScale = (Double)propertyChangeEvent.getNewValue();
                this.combinedScale = GPOverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
                this.container.repaint();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Cursor cursor = this.container.getCursor();
            int n = cursor.getType();
            if (n == 0) {
                this.last_x = this.pannerViewRectangle.x - mouseEvent.getX();
                this.last_y = this.pannerViewRectangle.y - mouseEvent.getY();
                if (this.isContained(mouseEvent)) {
                    this.updatePannerLocation(mouseEvent);
                    this.isActive = true;
                }
            } else {
                this.isResizing = true;
                this.pannerViewRectangleCopy = new Rectangle(this.pannerViewRectangle);
                this.pannerContainerRectangleCopy = new Rectangle(this.pannerContainerRectangle);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.isActive) {
                this.updatePannerLocation(mouseEvent);
                this.updateViewPort(mouseEvent);
            } else if (this.isResizing) {
                Cursor cursor = this.container.getCursor();
                int n = cursor.getType();
                switch (n) {
                    case 5: {
                        this.SECornerResize(mouseEvent);
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
            }
        }

        private void SECornerResize(MouseEvent mouseEvent) {
            double d;
            int n = (int)this.pannerViewRectangleCopy.getX();
            int n2 = (int)this.pannerViewRectangleCopy.getY();
            double d2 = (double)mouseEvent.getX() - this.pannerViewRectangleCopy.getMinX();
            if (d2 > (d = (double)mouseEvent.getY() - this.pannerViewRectangleCopy.getMinY())) {
                d = d2 * this.pannerViewRectangleCopy.getHeight() / this.pannerViewRectangleCopy.getWidth();
            } else {
                d2 = d * this.pannerViewRectangleCopy.getWidth() / this.pannerViewRectangleCopy.getHeight();
            }
            this.pannerViewRectangle.setBounds(n, n2, (int)d2, (int)d);
            this.ensureMinResize();
            this.ensureMaxResize();
            double d3 = this.pannerViewRectangle.getWidth() / this.pannerViewRectangleCopy.getWidth();
            GPOverviewPanel.this.originalGraph.setScale(1.0 / d3 * this.zoomScale);
            this.container.repaint();
        }

        private void SWCornerResize(MouseEvent mouseEvent) {
        }

        private void NWCornerResize(MouseEvent mouseEvent) {
        }

        private void NECornerResize(MouseEvent mouseEvent) {
        }

        private int findClosestDragPoint(MouseEvent mouseEvent, double d) {
            double d2 = mouseEvent.getX();
            double d3 = mouseEvent.getY();
            double d4 = this.pannerViewRectangle.getX();
            double d5 = this.pannerViewRectangle.getY();
            double d6 = d4 + this.pannerViewRectangle.getWidth();
            double d7 = d5 + this.pannerViewRectangle.getHeight();
            int n = 0;
            if (Math.abs(d2 - d4) < d && d3 + d > d5 && d3 < d7 + d) {
                n |= 1;
            }
            if (Math.abs(d2 - d6) < d && d3 + d > d5 && d3 < d7 + d) {
                n |= 2;
            }
            if (Math.abs(d3 - d5) < d && d2 + d > d4 && d2 < d6 + d) {
                n |= 4;
            }
            if (Math.abs(d3 - d7) < d && d2 + d > d4 && d2 < d6 + d) {
                n |= 8;
            }
            return n;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isActive) {
                this.isActive = false;
            }
            if (this.isResizing) {
                this.zoomScale = GPOverviewPanel.this.originalGraph.getScale();
                this.combinedScale = GPOverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
                this.isResizing = false;
                this.updateViewPort(mouseEvent);
            }
        }

        private void updateViewPort(MouseEvent mouseEvent) {
            int n = (int)(1.0 / this.combinedScale * this.pannerViewRectangle.getX());
            int n2 = (int)(1.0 / this.combinedScale * this.pannerViewRectangle.getY());
            Rectangle rectangle = this.viewport.getViewRect();
            if ((double)n + rectangle.getWidth() > this.viewport.getViewSize().getWidth()) {
                n = (int)(this.viewport.getViewSize().getWidth() - rectangle.getWidth());
            }
            if ((double)n2 + rectangle.getHeight() > this.viewport.getViewSize().getHeight()) {
                n2 = (int)(this.viewport.getViewSize().getHeight() - rectangle.getHeight());
            }
            this.viewportPosition.setLocation(n, n2);
            this.viewport.setViewPosition(this.viewportPosition);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.isContained(mouseEvent)) {
                this.isActive = true;
                this.pannerViewRectangle.setLocation(mouseEvent.getPoint());
                this.container.repaint();
                this.isActive = false;
                this.updateViewPort(mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.findClosestDragPoint(mouseEvent, 5.0);
            int n2 = this.convertDragPointToCursor(n);
            this.container.setCursor(Cursor.getPredefinedCursor(n2));
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        private int convertDragPointToCursor(int n) {
            int n2 = 0;
            switch (n) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    n2 = 0;
                    break;
                }
                case 10: {
                    n2 = 5;
                }
            }
            return n2;
        }

        public void updatePannerLocation(MouseEvent mouseEvent) {
            this.pannerViewRectangle.setLocation(this.last_x + mouseEvent.getX(), this.last_y + mouseEvent.getY());
            this.ensureWithinPannerBounds();
            this.container.repaint();
        }

        public void update(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = this.viewport.getViewRect();
            Dimension dimension = this.viewport.getView().getSize();
            this.combinedScale = GPOverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
            if (this.pannerContainerRectangle == null) {
                this.pannerContainerRectangle = new Rectangle();
            }
            this.pannerContainerRectangle.setSize((int)(dimension.getWidth() * this.combinedScale) - 2, (int)(dimension.getHeight() * this.combinedScale) - 2);
            this.scaledWidth = (int)(rectangle.getWidth() * this.pannerContainerRectangle.getWidth() / dimension.getWidth());
            this.scaledHeight = (int)(rectangle.getHeight() * this.pannerContainerRectangle.getHeight() / dimension.getHeight());
            if (!this.isResizing) {
                graphics2D.setStroke(this.stroke);
                this.pannerViewRectangle.setSize(this.scaledWidth, this.scaledHeight);
            } else {
                graphics2D.setStroke(this.dashStroke);
            }
            int n = (int)this.pannerViewRectangle.getMaxX();
            int n2 = (int)this.pannerViewRectangle.getMaxY();
            this.pannerResizeDecoration.setLocation(n - 2, n2 - 2);
            graphics2D.setColor(Color.red);
            graphics2D.fill(this.pannerResizeDecoration);
            graphics2D.draw(this.pannerViewRectangle);
        }

        private void ensureWithinPannerBounds() {
            int n = this.pannerViewRectangle.x;
            int n2 = this.pannerViewRectangle.y;
            if ((double)(this.pannerViewRectangle.x + this.scaledWidth) > this.pannerContainerRectangle.getWidth()) {
                n = (int)this.pannerContainerRectangle.getWidth() - this.scaledWidth;
            }
            if (this.pannerViewRectangle.x < 0) {
                n = 1;
            }
            if ((double)(this.pannerViewRectangle.y + this.scaledHeight) > this.pannerContainerRectangle.getHeight()) {
                n2 = (int)this.pannerContainerRectangle.getHeight() - this.scaledHeight;
            }
            if (this.pannerViewRectangle.y < 0) {
                n2 = 1;
            }
            this.pannerViewRectangle.setLocation(n, n2);
        }

        private void ensureMaxResize() {
            if (!this.pannerContainerRectangle.contains(this.pannerViewRectangle)) {
                Rectangle rectangle = this.pannerViewRectangle.intersection(this.pannerContainerRectangleCopy);
                if (rectangle.width < this.pannerViewRectangle.width) {
                    this.pannerViewRectangle.width = rectangle.width;
                    this.pannerViewRectangle.height = this.pannerViewRectangle.width * this.pannerViewRectangleCopy.height / this.pannerViewRectangleCopy.width;
                }
                if (rectangle.height < this.pannerViewRectangle.height) {
                    this.pannerViewRectangle.height = rectangle.height;
                    this.pannerViewRectangle.width = this.pannerViewRectangle.height * this.pannerViewRectangleCopy.width / this.pannerViewRectangleCopy.height;
                }
            }
        }

        private void ensureMinResize() {
            int n = 20;
            Rectangle rectangle = this.pannerViewRectangleCopy;
            if (rectangle.width > rectangle.height && this.pannerViewRectangle.width < n) {
                this.pannerViewRectangle.width = n;
                this.pannerViewRectangle.height = (int)(rectangle.getHeight() * (double)n / rectangle.getWidth());
            } else if (rectangle.height > rectangle.width && this.pannerViewRectangle.height < n) {
                this.pannerViewRectangle.height = n;
                this.pannerViewRectangle.width = (int)(rectangle.getHeight() * (double)n / rectangle.getWidth());
            }
        }
    }

    public class ViewRedirector
    extends GraphLayoutCache {
        protected GraphLayoutCache realView;

        public ViewRedirector(JGraph jGraph, GraphLayoutCache graphLayoutCache) {
            super(null, jGraph);
            this.realView = graphLayoutCache;
            this.setModel(jGraph.getModel());
        }

        public CellView[] getRoots() {
            return this.realView.getRoots();
        }

        public CellView getMapping(Object object, boolean bl) {
            if (this.realView != null) {
                return this.realView.getMapping(object, bl);
            }
            return null;
        }

        public void putMapping(Object object, CellView cellView) {
            if (this.realView != null) {
                this.realView.putMapping(object, cellView);
            }
        }
    }
}

