<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"You do not have permission to use this feature." => "شما حق دسترسي كافي براي استفاده از اين خصيصه را نداريد.",
"Process %s is imported" => "فرايند %s وارد شد",
"uploaded by" => "بارگذاري شده به‌وسيله‌ي",
"not specified" => "نامشخص",
"There was a problem with your upload." => "مشكلي در بارگذاري شما بوجود آمده است.",
"The file you are trying to upload is too big." => "پرونده‌اي كه مي‌خواهيد بارگذاري كنيد، بسيار حجيم است",
"The file you are trying to upload was only partially uploaded." => "پرونده‌اي كه مي‌خواستيد بارگذاري كنيد، نيمه‌كاره بارگذاري شد!",
"You must select a file for upload." => "شما بايد يك پرونده براي بارگذاري انتخاب كنيد.",
" line " => " خط ",
"Error: No" => "خطاي شماره‌ي:",
"permission." => "حقوق دسترسي.",
"Error: Invalid" => "خطا: بي اعتباري",
"Error: Call to hw_page_fetch_by_id failed!" => "خطا: صدازدن hw_page_fetch_by_id موفق نبود!",
"%s is an empty archive file" => "%s يك پرونده‌ي بايگاني خالي است",
"Invalid remote file on url %s" => "پرونده‌ي راه‌دور در آدرس %s معتبر نيست",
"Project Group for " => "گروه پروژه براي ",
"Project Admin Group for " => "گروه مديريت پروژه براي ",
"%A %d of %B, %Y" => "%A %d از %B, %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d از %B, %Y[%H:%M:%S %Z]",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"%a %d of %b, %Y" => "%a %d از %b, %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d از %b, %Y[%H:%M %Z]",
"no description" => "بدون شرح",
"Updated" => "به‌روز رساني شد",
"User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "اختيارات: از اختيارات براي تغذيه‌ي خودكار ستون استفاده كنيد. مي‌توانيد از 1 براي مولف و 2 براي تغييردهنده استفاده كنيد.",
"Category options: parentId" => "اختيارات: parentId",
"Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "اختيارات: trackerId,fieldId,linkToItem پيوند به اقلامي از trackerid هستند كه fielded معادل محتويات اين ستون است. linkToItem 0و1 براي ايجاد يك پيوند به فقره در حالت نمايش و تغيير.",
"~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} درج مقاله‌ها در يك صفحه‌ي ويكي",
"num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "شماره(num) اختياري است و ترتيب ضمايم را در فهرست مشخص مي‌كند. اگر وارد نشود، فهرستي از تمام ضمايم نمايش داده مي‌شود. Inline باعث مي‌شود نظر به متن پيوند تبديل شود.",
"~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} درج خروجي تغذيه‌ي RSS در يك صفحه‌ي ويكي",
"You need to supply information for : " => "شما بايد در اين خصوص اطلاعات بيشتري فراهم كنيد: ",
"missing tracker ID for plugin TRACKER" => "براي Plugin مربوط به tracker، شناسه‌ي tracker مفقود است",
"User \$a_user can not receive messages" => "كاربر \$a_user نتوانست پيغام را دريافت كند",
"Invalid user: \$a_user" => "كاربر: \$a_user معتبر نيست",
"name" => "نام",
"delete" => "حذف",
"show categories" => "طبقات را نمايش بده",
"Tip: hold down CTRL to select multiple categories" => "نكته: براي انتخاب چندين طبقه، دكمه‌ي CTRL را نگه‌داريد‌‌",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "نكته: براي از طبقه‌بندي در آوردن اين شيء، گزينه‌ي بالا را رفع انتخاب كنيد",
"author" => "مؤلف",
"user level" => "سطح كاربر",
"send email to user" => "ارسال پست الكترونيكي به كاربر",
"score" => "امتياز",
"delete selected" => "انتخاب شده‌ها را حذف كن",
"move" => "انتقال",
"Posted messages" => "پيغام‌هاي الصاق شده",
"set" => "تغيير بده",
"replies" => "پاسخ داده‌شده",
"new reply" => "پاسخ جديد",
"preview" => "پيش‌نمايش",
"post" => "الصاق",
"cancel" => "لغو",
"add" => "اضافه كن",
"Click here to create it" => "براي ساخت اين‌جا را كليك كنيد",
"To the event:" => "به اين رويداد:",
"Event:" => "رويداد:",
"You can unsubscribe from this event following this link" => "با دنبال كردن اين پيوند، مي‌توانيد از اين رويداد لغو اشتراك كنيد",
"Welcome to our event!" => "به رويدادهاي ما خوش‌آمديد!",
"someone coming from IP Address" => "كسي از اين آدرس مي‌آيد",
"requested a reminder of the password for the" => "درخواست يادآوري كلمه‌ي عبور براي",
"since this is your registered email address we inform that the" => "از آن‌جايي كه اين آدرس پست الكترونيكي ثبت شده‌ي شما است، به اطلاع مي‌رساند كه",
"password for this account is" => "كلمه‌ي عبور اين حساب عبارت است از",
"Information:" => "اطلاعات:",
"The page {\$mail_page} was changed by {\$mail_user} at\n{\$mail_date|tiki_short_datetime}" => "صفحه‌ي {\$mail_page} به‌وسيله‌ي{\$mail_user}  در\n{\$mail_date|tiki_short_datetime} تغيير كرد",
"You can view the page by following this link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}" => "با دنبال كردن اين پيوند، مي‌توانيد اين صفحه را مشاهده كنيد:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "با دنبال كردن اين پيوند مي‌توانيد اين صفحه را ويرايش كنيد::\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "با دنبال كردن اين پيوند مي‌توانيد تفاوت اين نسخه با نسخه‌ي قبلي را مشاهده كنيد \nاين صفحه:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"stop monitoring this map" => "ديده‌باني اين نقشه را متوقف كن",
"create" => "ايحاد كن",
"save" => "ذخيره كن",
"DATE-of" => "ام",
"edit template" => "ويرايش الگو",
"send" => "بفرست",
"up" => "انتقال به بالا",
"down" => "انتقال به پايين",
"remove" => "حذفش كن",
"Projects Menu" => "منوي پروژه‌ها",
"Register New Project" => "ثبت پروژه‌ي جديد",
"HomeworkMenu" => "منوي مشق شب",
"List Courses" => "فهرست دوه‌ها",
"Admin->Modules" => "مديريت -> ماژول‌ها",
"Last visitors" => "آخرين بازديد كنندگان",
"register" => "ثبت‌نام",
"standard" => "معمولي",
"secure" => "امن",
"stay in ssl mode" => "در باب ssl بمان",
"new messages" => "پيغام‌هاي جديد داريد",
"new message" => "پيغام جديد داريد",
"go" => "برو",
"cache" => "زمان نگهداري در نهانگان(Cache)",
"use" => "استفاده از ساختار",
"refresh" => "بازيابي كن",
"print" => "چاپش كن",
"create pdf" => "ساخت PDF",
"monitor this page" => "اين صفحه را ديده‌باني كن",
"stop monitoring this page" => "ديده‌باني اين صفحه را متوقف كن",
"backlinks" => "پيوند به‌عقب‌ها",
"last modification" => "آخرين تغييرات",
"click here" => "اين‌جا را كليك كنيد",
"rename" => "تغيير نام",
"unlock" => "بازكردن قفل",
"lock" => "قفلش كن",
"perms" => "حقوق دسترسي‌ها",
"history" => "تاريخچه",
"similar" => "مشابهات",
"undo" => "برگشت عمل",
"slides" => "اسلايدها",
"export" => "صدور",
"discuss" => "بحث",
"add comment" => "افزودن نظريه",
"attach file" => "ضميمه‌كردن پرونده",
"translation" => "ترجمه",
"attachments" => "ضمايم",
"stats" => "آمار",
"last changes" => "آخرين تغييرات",
"list pages" => "فهرست صفحات",
"back to homepage" => "بازگشت به صفحه‌ي مبدا",
"Please" => "لطفا",
"log in" => "به برنامه وارد شويد",
"to access full functionalities" => "تا به تمام خصايص دسترسي پيدا كنيد",
"cancel edit" => "تغييرات را لغو كن",
"No attachments for this page" => "اين صفحه، ضميمه‌اي ندارد",
"Skip to navigation" => "پرش به ناوبري",
"reads" => "تعداد دفعات مشاهده",
"cached" => "cache شده",
"Jukebox" => "Jukebox",
"Site Calendar" => "تقويم پايگاه",
"to add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "براي اضافه/حذف بلاگ‌ها، در فهرست استفاده به قسمت 'ساخت/ويرايش بلاگ' در بخش 'بلاگ‌ها' برويد، ويا",
"Blog settings" => "تنظيمات بلاگ",
"ok" => "قبول",
"Users see and add events in their timezone" => "كاربران رويدادها را در ساعت محلي خود ببينند و ايجاد كننده",
"look under \"Articles\" on the application menu for links to" => "براي پيوندهايي اين‌چنين، بخش \"مقالات\" را پيوييد",
"Friendship network" => "شبكه‌ي رفاقت",
"Allow permissions for friendship network" => "حقوق دسترسي براي شبكه‌ي رفاقت اعمال شود",
"Max friendship distance" => "حداكثر فاصله‌ي رفاقت",
"to configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "براي پيكربندي پوشه‌ي خود،  \"مديريت پوشه\" را تحت  \"پوشه\" در منوي برنامه بيابيد، يا",
"new window" => "پنجره‌ي جديد",
"to add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "براي حذف/اضافه‌ي FAQ\tها، دنبال \"مديريت FAQها\" تحت \"FAQها\" در منوي برنامه بگرديد، يا",
"FAQs settings" => "تنظيمات FAQ",
"FAQ comments" => "نظرات مربوط به بخش سئوالات متداول",
"TikiTabs" => "برگه‌هاي تيكي",
"Best language" => "بهترين زبان",
"Tiki Projects" => "پروژه‌هاي تيكي",
"to add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "براي حذف/اضافه كردن سرسراها، به 'سرسراهاي پرونده' در منو برنامه مراجعه كنيد، يا",
"to add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "براي حذف/اضافه كردن انجمن‌ها دنبال \"مديريت انجمن\" زير \"انجمن‌ها\"در منوي برنامه بگرديد، يا",
"to add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "براي حذف/اضافه كردن سرسراهاي تصاوير، سراغ \"سرسراهاي تصاوير\" در منوي برنامه برويد، يا",
"PHP error reporting level for non-admin:" => "سطح گزارش خطاي PHP براي غير سرپرست‌ها",
"Report PHP errors only for admin" => "خطاهاي PHP رو فقط براي سرپرست گزارش بده",
"Server name (for absolute URIs)" => "نام سرور(server)-(براي URIهاي مطلق)",
"HTTPS Server" => "سرور HTTPS",
"Automatic (uses HTTPS variable)" => "خودكار (از متغييرهاي HTTPS استفاده كن)",
"Wiki_Tiki_Title" => "عنوان تيكي‌ويكي",
"Jukebox settings" => "تنظيمات jukebox",
"Jukebox tracks location" => "محل آثار(tracks)‌‌ jukebox",
"Jukebox features" => "خصيصه‌ها jukebox",
"Default ordering for album listing" => "ترتيب پيش‌فرض براي فهرست كردن آلبوم‌ها",
"Album title (asc)" => "تيتر آلبوم(صعودي)",
"Number of tracks (desc)" => "تعداد آثار(tracks) (نزولي)",
"In album listing show user as" => "در فهرست آلبوم‌ها، كاربر را با اين عنوان نشان بده",
"Jukebox listing configuration (when listing available albums)" => "پيكربندي فهرست جوك‌باكس (هنگامي كه آلبوم‌هاي موجود فهرست مي‌شوند)",
"Tracks" => "Trackها",
"Genre" => "قسم",
"Create a group for each user <br />(with the same\nname as the user)" => "براي هر كاربر، يك گروه همنام خودش بساز",
"Validate email address (may not work)" => "آدرس پست الكترونيكي را تاييد اعتبار كن(ممكن است كار نكند)",
"Remind passwords by email" => "كلمه‌ي عبور را به كمك پست الكترونيكي يادآوري كن",
"Require HTTP Basic authentication" => "نياز به تصديق هويت ابتدايي HTTP است",
"HTTP server name" => "نام خدمت رسان HTTP",
"HTTP URL prefix" => "پيشوند آدرس URL مربوط به HTTP",
"HTTPS server name" => "نام خدمت‌رسان HTTPS",
"HTTPS URL prefix" => " پيشوند آدرس URL مربوط به HTTPS ",
"Only for users" => "تنها براي كاربران",
"Users and admins" => "كاربران و مديران",
"to add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "براي حذف/اضافه كردن 'راي‌گيري‌ها'، دنبال \"راي‌گيري‌ها\" تحت بخش \"مديريت\" در منوي برنامه برويد، يا",
"Poll settings" => "تنظيمات راي‌گيري‌ها",
"Users choose project categories" => "كاربران طبقات پروژه را انتخاب مي‌كنند",
"Prefix for Project Admin groups" => "پيشوند براي گروه‌هاي مديريت پروژه",
"Prefix for Project groups" => "پيشوند براي گروه‌هاي پروژه",
"Prefix for Wiki project home page" => "پيشوند براي صفحه‌ي مبدا پروژه‌ي ويكي",
"Prefix for File Galleries" => "پيشنود براي سرسراهاي پرونده",
"Project Admins group template" => "الگوي گروه‌هاي مديريت پروژه",
"Create New Group" => "ساخت گروه جديد",
"Project Members group template" => "الگوي گروه‌هاي اعضاي پروژه",
"<b>Title</b>" => "<b>عنوان</b>",
"<b>Description</b>" => "<b>شرح</b>",
"Append CSS file to feed urls" => "پرونده‌هاي CSS را به URLهاي تغذيه، اضافه كن",
"Publisher" => "ناشر",
"you can see users rank by score in the module users_rank, for that go to" => "مي‌توانيد رتبه‌ي كاربران را امتياز آن‌ها در ماژول users_rank ببينيد، براي اين‌كار به اين‌جا مراجعه كنيد",
"Full Text Search" => "جستجوي متني كامل",
"Dont forget to use feature you will need to enable it on the <a href=\"tiki-admin.php?page=features\">Features</a> icon." => "فراموش نكنيد كه از اين خصيصيه استفاده كنيد، بايد آن را در  <a href=\"tiki-admin.php?page=features\">خصيصه‌ها</a> فعال كنيد.",
"Site Identity Settings" => "تنظيمات هويت پايگاه",
"Site logo" => "نماد پايگاه",
"Site logo source" => "آدرس پرونده‌ي نماد پايگاه",
"Site ads and banners" => "درفش‌ها و تنليغات پايگاه",
"to configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "براي پيكربندي trackerهاي خود، به دنبال \"مديريت trackerها\" تحت \"trackerها\" در منوي برنامه بگرديد، يا",
"change" => "تغيير بده",
"Manage attachment preferences" => "مديريت تنظيمات ضمايم",
"Wiki page list configuration" => "پيكربندي فهرست صفحات ويكي",
"HTML in Wiki Pages" => "HTML در صفحات ويكي",
"Like pages" => "پيوند صفحات",
"Enable Feature" => "فعال باشد",
"admin banning tpl" => "الگوي مديريت تحريم‌ها",
"List Calendars" => "فهرست تقويم‌ها",
"loc" => "مكان",
"cat" => "طبقه",
"lang" => "زبان",
"prio" => "اولويت",
"event" => "رويداد",
"perso" => "شخصي",
"permissions" => "دسترسي‌ها",
"Custom Events" => "رويدادهاي متناسب",
"admin categories" => "مديريت طبقه‌بندي‌ها",
"admin categories tpl" => "الگوي مديريت طبقه‌بندي‌ها",
"create new" => "ساخت جديد",
"edit chart" => "ويرايش نمودار",
"update" => "به‌روز رساني كن",
"admin charts template" => "مديريت الگوي نمودارها",
"admin content templates" => "مديريت الگوهاي محتوي",
"admin content templates template" => "مديريت الگوي 'اگوهاي محتوي'",
"use in cms" => "استفاده در سامانه‌ي مديريت محتوا",
"use in wiki" => "استفاده در ويكي",
"use in newsletters" => "استفاده در خبرنامه‌ها؟",
"use in events" => "استفاده در رويدادها؟",
"use in HTML pages" => "استفاده در اين صفحات HTML",
"last modif" => "تاريخ آخرين تغيير",
"sections" => "بخش‌ها",
"admin FortuneCookie" => "مديريت كوكي بخت",
"admin FortuneCookie tpl" => "الگوي مديريت كوكي بخت",
"upload" => "بارگذاري",
"admin Drawings" => "مديريت نقاشي‌ها",
"admin Drawings tpl" => "الگوي مديريت نقاشي‌ها",
"dsn" => "dsn",
"Admin event subscriptions" => "مديريت عضويت رويدادها",
"list events" => "فهرست رويدادها",
"admin events" => "مديريت رويدادها",
"send events" => "ارسال رويدادها",
"Add a subscription event" => "افزودن به عضويت رويدادها",
"Add all your site users to this event (broadcast)" => "تمام كاربران پايگاه خود را به اين رويداد اضافه كنيد (خبرگزاي)",
"Add all users" => "اضافه كردن تمام كاربران",
"fname" => "نام كوچك",
"lname" => "نام خانوادگي",
"company" => "شركت",
"admin events template" => "مديريت الگوي رويدادها",
"Create/edit events" => "ايجاد/ويرايش رويدادها",
"There are individual permissions set for this event" => "حقوق دسترسي فردي براي اين رويداد تنظيم شده است",
"Add unsubscribe instructions to each event" => "اطلاعات مربوط به لغو عضويت را به تمام رويدادها اضافه كن",
"editions" => "نسخه‌ها",
"last sent" => "آخرين ارسال",
"send event" => "ارسال رويداد",
"admin External Wikis" => "سرپرستي ويكي‌هاي خارجي",
"extwiki" => "ويكي خارجي",
"admin forums template" => "مديريت الگوي انجمن‌ها",
"Edit existing forums" => "ويرايش انجمن‌هاي كنوني",
"avatar" => "شكلك",
"flag" => "پرچم",
"posts" => "الصاق‌ها",
"online" => "روي خط",
"topics" => "عناوين",
"coms" => "نظرات",
"age" => "سن",
"ppd" => "ppd",
"last post" => "آخرين الصاق",
"hits" => " ضربت‌ها(Hits)",
"Assign Permissions (Active)" => "تخصيص حقوق دسترسي (فعال)",
"Click here to delete this forum" => "براي حذف اين انجمن اين‌جا را كليك كنيد",
"admin hotwords" => "مديريت واژگان آتشين",
"admin hotwords template" => "مديريت الگوي واژگان آتشين",
"admin HTML page dynamic zones" => "مديريت قلمرو پوياي صفحات HTML",
"admin Html Pages" => "مديريت صفحات HTML",
"admin Html Pages template" => "مديريت الگوي صفحات HTML",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => " از {literal}{{/literal}ed شناسه=نام} يا {literal}{{/literal}ted شناسه=نام} براي ايجاد قلمروهاي پويا استفاده كنيد",
"list repositories" => "فهرست مخازن",
"new repository" => "مخزن جديد",
"view repository" => "مشاهده‌ي مخزن",
"view this repository" => "مشاهده‌ي اين مخزن",
"new rule" => "قانون جديد",
"admin featured links" => "مديريت پيوندهاي خاص",
"admin featured links template" => "الگوي مديريت پيوندهاي خاص",
"url" => "آدرس اينترنتي",
"position" => "موقعيت",
"admin Webmail" => "مديريت پست تحت وب",
"admin mailin template" => "مديريت الگوي دريافت پست الكترونيكي",
"section" => "بخش",
"sorted section" => "بخش‌هاي مرتب شده",
"admin menu builder" => "مديريت سازنده‌ي منو",
"admin menus template" => "الگوي مديريت منوها",
"options" => "اختيارات",
"admin modules" => "مديريت ماژول‌ها",
"admin modules template" => "الگوي مديريت ماژول‌ها",
"assign module" => "تخصيص ماژول‌ها",
"left modules" => "ماژول‌هاي سمت چپ",
"right modules" => "ماژول‌هاي سمت راست",
"edit/create" => "ويرايش/ايجاد ",
"clear cache" => "پاك‌سازي حافظه نهان(cache)",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>نكته 1</b>درصورتي كه با كاربران اجازه‌ي پيكربندي ماژول‌ها را بدهيد، آن‌گاه 'ماژول‌هاي تخصيص‌داده شده' در صفحه نمايش داده نخواهد شد، مگر آن‌كه آن‌ها را در 'تيكي من -> ماژول‌ها' پيكربندي كنيد.<br />\n<b>نكته 2</b>: درصورتي كه ماژولي را به گروه خاصي اختصاص مي‌دهيد، به‌خاظر داشته باشيد كه گزينه‌ي 'نمايش همواره‌ي ماژول‌ها به تمام گروه‌ها' را در 'مديريت -> عمومي' غيرفعال كنيد.",
"assign" => "اختصاص بده",
"left" => "راست",
"right" => "چپ",
"parameters" => "پارامترها",
"order" => "ترتيب",
"rows" => "رديف",
"groups" => "گروه‌هاي كاربري",
"create/edit" => "ايجاد/حذف",
"use poll" => "از اين راي‌گيري استفاده كن",
"use gallery" => "از اين سرسراها استفاده كن",
"use dynamic  content" => "از محتوي پويا استفاده كن",
"use rss module" => "از اين ماژول RSS استفاده كن",
"use menu" => "از اين فهرست استفاده كن",
"use phplayermenu" => "از اين فهرست لايه‌اي PHP استفاده كن ",
"use banner zone" => "از قلمرو درفش استفاده كن",
"list newsletters" => "فهرست خبرنامه‌ها",
"admin newsletters" => "مديريت خبرنامه‌ها",
"send newsletters" => "ارسال خبرنامه‌ها",
"admin newsletters template" => "مديريت الگوي خبرنامه‌ها",
"send newsletter" => "خبرنامه را بفرست",
"admin Email Notifications" => "مديريت اطلاع‌رساني‌هاي پست الكترونيكي",
"admin notifications template" => "مديريت الگوي اطلاع‌رساني‌ها",
"use admin email" => "از پست الكترونيك سرپرست استفاده كن",
"admin polls" => "مديريت راي‌گيري‌ها",
"admin polls template" => "مديريت الگوي راي‌گيري‌ها",
"admin QuickTags" => " مديريت تگ‌هاي سريع ",
"label" => "برچسب",
"Category: wiki, tracker, etc." => "طبقه: ويكي، tracker، ساير",
"admin RSS modules" => "مديريت ماژول RSS",
"admin RSSmodules template" => "مديريت الگوي ماژول RSS",
"edit tpl" => "ويرايش الگو",
"admin shoutbox words" => "مديريت كلمات فريادگاه",
"admin shoutbox words template" => "الگوي مديريت كلمات فريادگاه",
"admin structures template" => "سرپرستي الگوي ساختارها",
"export pages" => "صدور صفحه",
"dump tree" => "dumpكردن درختواره",
"create webhelp" => "ساخت كمك وبي",
"view webhelp" => "مشاهده‌ي كمك وبي",
"tree" => "درختواره",
"create new structure" => "ايجاد ساختار جديد",
"survey stats" => "آمار نظرسنجي‌",
"edit this survey" => "ويرايش اين نظرسنجي‌",
"admin surveys" => "مديريت نظرسنجي‌ها",
"list surveys" => "فهرست نظرسنجي‌ها",
"questions" => "سئوالات",
"files" => "پرونده",
"admin topics template" => "الگوي مديريت عناوين",
"Field is public? (for use thru trackerlist plugin)" => "ستون عمومي است؟ (براي استفاده در pluginهاي trackerها)",
"admin Trackers tpl" => "مديريت الگوي trackerها",
"Edit fields for tracker" => "ويرايش ستون‌هاي trackerها",
"items" => "اقلام",
"version" => "نسخه",
"admin groups" => "مديريت گروه‌هاي كاربري",
"admin groups template" => "الگوي مديريت گروه‌هاي كاربري",
"assign permissions" => "تخصيص حقوق دسترسي به ",
"admin" => "مديريت تقويم‌ها",
"admin users" => "مديريت كاربران",
"admin users template" => "الگوي مديريت كاربران",
"edit account settings" => "ويرايش تنظيمات حساب كاربر",
"assign to groups" => "انتصاب به گروه‌ها",
"Added users" => "كاربران اضافه شده",
"edit article tpl" => "الگوي ويرايش مقالات",
"all" => "همه موارد",
"Assign user" => "تخصيص كاربر",
"to groups" => "به گروه(هاي)",
"Available groups" => "گروه‌هاي موجود",
"assign perms to this group" => "حقوق دسترسي اختصاص يافته به اين گروه",
"save_to" => "to",
"admin backups" => "مديريت نسخ پشتيبان",
"admin admin tpl" => "مديريت الگوي مديريت",
"List of available backups" => "فهرست نسخ پشتيبان موجود",
"Restoring a backup" => "بازيابي يك نسخه‌ي پشتيبان",
"Warning!" => "اخطار!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "بازيابي يك نسخه‌ي پشتيبان، تمام اطلاعات بانك اطلاعاتي تيكي شما را نابود خواهد كرد. تمام جداول شما با اطلاعات موجود در نسخه‌ي پشتيبان جايگزين خواهند شد",
"Click here to confirm restoring" => "براي تاييد بازيابي نسخه‌ي پشتيبان، اين‌جا را كليك كنيد",
"Create new backup" => "تهيه‌ي يك نسخه‌ي پشتيبان جديد",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "تهيه‌ي نسخ پشتيبان ممكن است مدت زمان زيادي به طول انجامد. اگر فرايند تكميل نشود، شما يك صفحه‌ي خالي مشاهده خالي كرد. بهتر از حداكثر زمان اجراي دستخط(script)ها را در پرونده‌ي php.ini خود بالا ببريد.",
"Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "منبع ذخيره‌ي سراسري تصاوير شما بر روي  \"{\$gal_use_dir}\", تنظيم شده است. بايد از ظريق FTP يا SCP از آن پشتيبان تهيه كنيد",
"Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "منبع ذخيره‌ي سراسري پرونده‌ي شما بر روي  \"{\$fgal_use_dir}\", تنظيم شده است. بايد از ظريق FTP يا SCP از آن پشتيبان تهيه كنيد",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "درصورتي كه انجمن‌هاي شما پرونده‌هايي خارج از بانك اطلاعاتي دارند، بايد از آن‌ها به كمك FTP با SCP به‌صورت جداگانه پشتيبان تهيه كنيد.",
"Upload a backup" => "بارگذاري يك نسخه‌ي پشتيبان",
"Upload backup" => "بارگذاري نسخ پشتيبان",
"view blog" => "مشاهده‌ي بلاگ",
"list blogs" => "فهرست بلاگ‌ها",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "نكته: براي استفاده از تصاوير، لطفا متن خود را الصاق كنيد تا قادر به ايجاد/ويرايش تصاوير شويد. از &lt;img&gt براي قرار دادن تصوير در متن نوشته شده‌ي خود و يا از URL تصوير براي افزودن تصاوير در ` WYSIWYG استفاده كنيد.",
"save and exit" => "ذخيره كن و خارج شو",
"admin category" => "مديريت طبقه",
"search category" => "طبقه را بگرد",
"deep" => "عميق",
"edit gallery" => "ويرايش سرسرا",
"rebuild thumbnails" => "تصويرك‌ها را مجددا بساز",
"upload image" => "بارگذاري تصوير",
"list gallery" => "نمايش اقلام",
"hit" => "ضربه(hit)",
"original size" => "اندازه‌ي سازمان",
"return to gallery" => "بازگشت به سرسرا",
"edit image" => "ويرايش تصوير",
"smaller" => "كوچكتر",
"bigger" => "بزرگتر",
"prev image" => "تصوير قبلي",
"next image" => "تصوير بعدي",
"popup window" => "پنجره‌ي popup",
"add item" => "افزودن فقره",
"or create a new category" => "يا يك طبقه‌ي جديد ايجاد كنيد",
"or create a new location" => "يا يك محل جديد ايجاد كنيد",
"comma separated usernames" => "نام‌هاي كاربر(جداشده به‌وسيله‌ي كاما)",
"comma separated username:role" => "نام‌هاي كاربر(جداشده به‌وسيله‌ي كاما): قانون",
"with roles" => "؛با قوانين",
"Chair" => "مقر",
"Optional" => "اختياري",
"Syntax error" => "خطا در نحو",
"Format: mm/dd/yyyy hh:mm<br />...See strtotime php function" => "شكل: mm/dd/yyyy hh:mm<br />...تابع strtotime php را ببينيد",
"Format: mm/dd/yyy hh:mm" => "شكل: mm/dd/yyy hh:mm",
"Event ID" => "شناسه‌ي رويداد",
"Add Calendar Item" => "افزوردن فقره در تقويم",
"Calendrier" => "تقويم‌وار!",
"permission" => "حقوق دسترسي",
"remove from this category &amp; all its children" => "از اين طبقه و طبقات فرزندش حذف كن",
"remove from this category only" => "تنها از اين طبقه حذفش كن",
"Font" => "قلم",
"Textheight" => "ارتفاع متن",
"Height of top Heading" => "ارتفاع سرصفحه‌ي بالايي",
"Height of mid Heading" => "ارتفاع سرصفحه‌ي وسطي",
"Height of inner Heading" => "ارتفاع سرصفحه‌ي مياني",
"tbheight" => "ارتفاع جدول",
"imagescale" => "مقياس تصوير",
"Automatic Page Breaks" => "جدا كردن خودكار صفحات",
"remove page" => "صفحه را حذف كن",
"admin directory tpl" => "الگوي مديريت پوشه",
"browse" => "مرور",
"related" => "مرتبط",
"validate" => "تاييد",
"admin directory categories tpl" => "الگوي مديريت طبقات پوشه",
"add a site" => "اضافه كردن يك پاگاه",
"search" => "جستجو",
"list articles" => "فهرست مقالات",
"view articles" => "مشاهده‌ي مقالات",
"create zone" => "ايجاد قلمرو",
"save the banner" => "درفش را ذخيره كن",
"edit blog tpl" => "ويرايش الگوي بلاگ",
"try" => "تلاش",
"display" => "نمايش",
"wiki help" => "كمك از ويكي",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "براي اطلاعات بيشتر، لطفا نگاهي به <a href=\"{\$helpurl}WikiSyntax\">نحو ويكي</a> بياندازيد",
"Emphasis" => "تاكيد",
"italics" => "مورب",
"both" => "هردو",
"use ...page... to separate pages" => "از ...page... براي جاسازس صفحات استفاده كن",
"make_headings" => "ساخت سرصفحه‌ها",
"underlines text" => "متن را زيرخط دار كن",
"make a line break" => "يك خط افقي بكش",
"creates an editable drawing named foo" => "يك نقاشي قابل ويرايش با نام foo بساز",
"Simple box" => "جعبه‌ي ساده",
"Will display using the indicated HTML color" => "با كمك رنگ مشخص شده‌ي HTML نمايش داده مي‌شود",
"Center" => "مركز",
"Will display the text centered" => "متن را در مركز نمايش خواهد داد",
"Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "كد/متن‌هاي از پيش شكل گرفته را نمايش بده. هيچ پردازشي توسط ويكي داخل اين بخش انجام نخواهد شد.",
"Insert Module Output" => "درج خروجي ماژول",
"{literal}{MODULE(module=>some_module)}text{MODULE}{/literal}  can be used to insert the output of module \"some_module\" into your Wiki page. See <a href=\"{\$helpurl}PluginModule\">PluginModule</a> for more information. " => "{literal}{MODULE(module=>يك ماژول)}متن{MODULE}{/literal} مي‌تواند براي درج خروجي ماژول \"يك ماژول\" در صفحه‌ي ويكي شما استفاده شود. براي اطلاعات بيشتر، <a href=\"{\$helpurl}PluginModule\">PluginModule</a> را ببينيد.",
"Rendering Program Code" => "ترجمه‌ي كد برنامه",
"{literal}{CODE()}some code{CODE} {/literal} will render \"some code\" as program code. This plugin has other options; see <a href=\"{\$helpurl}PluginCode\">PluginCode</a>." => "{literal}{CODE()}يك‌سري كد{CODE} {/literal}، \"يك‌سري كد\" را به عنوان برنامه ترجمه خواهند كرد. اين Plugin  اختيارات ديگري نيز دارد؛ <a href=\"{\$helpurl}PluginCode\">كد Plugin</a> را ببينيد.",
"admin quicktags" => "مديريت تگ‌هاي سريع",
"create new block" => "يك بلوك جديد ايجاد كن",
"Project Object Created Successfully" => "شيء پروژه با موفقيت ساخته شد",
"Project Name:" => "نام پروژه:",
"Project Description:" => "توضيحات پروژه",
"Project Active" => "پروژه فعال است",
"Current Objects:" => "اشياء جاري:",
"Add a File Gallery" => "افزودن يك سرسراي پرونده",
"Project Admin" => "مدير پروژه",
"Project Members" => "اعضاي پروژه",
"Not Set" => "تنظيم نشده است",
"list quizzes" => "فهرست آزمون‌ها",
"quiz stats" => "وضعيت آزمون",
"edit this quiz" => "اين آزمون را ويرايش كن",
"admin quizzes" => "مديريت آزمون‌ها",
"admin quizzes tpl" => "الگوي مديريت آزمون‌ها",
"results" => "نتايج",
"edit quiz questions" => "سئوالات آزمون را ويرايش كن",
"edit quiz questions tpl" => "الگوي ويرايش سئوالات آزمون",
"create page" => "ساخت صفحه",
"Edit Submissions" => "ويرايش ارائه‌ها",
"edit submissions tpl" => "الگوي ويرايش ارائه‌ها",
"list submissions" => "فهرست ارائه‌ها",
"<b>زيرنويس</b>=small line below Title" => "<b>Subtitle</b>=خط كوچك بايين تيتر",
"edit translations" => "ويرايش ترجمه‌ها",
"edit translations template" => "الگوي ويرايش ترجمه‌ها",
"add to the set" => "افزودن به مجموعه",
"Admin ephemerides" => "مديريت سالنامه‌ها",
"admin Ephemerides tpl" => "مديريت الگوي سالنامه‌ها",
"All ephemerides" => "تمام سالنامه‌ها",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No events will be sent to you until the subscription is confirmed." => "از عضويت شما متشكريم. به‌زودي براي تاييد عضويت خود يك پيام دريافت خواهيد كرد. تا زماني كه عضوت را تاييد نكرده‌اي، هيچ رويدادي براي شما ارسال نخواهد شد.",
"Subscribe to event" => "عضويت در رويداد",
"First Name:" => "نام:",
"Last Name:" => "نام خانوادگي:",
"Company:" => "سازمان:",
"new question" => "سئوال جديد",
"approve" => "تاييد",
"configure listing" => "پيكربندي فهرست‌ها",
"create new gallery" => "ايجاد سرسراي جديد",
"topic" => "موضوع",
"save and approve" => "ذخيره و تاييد",
"new topic" => "عنوان جديد",
"reject" => "مردود",
"visits" => "بازديدها",
"create new user" => "ايجاد كاربر جديد",
"accept" => "قبول مي‌كنم",
"refuse" => "رد مي‌كنم",
"switch" => "گزينه",
"add new" => "جديد",
"add role" => "قانون را اضافه كن",
"new minor" => "كهاد جديد",
"new major" => "مهاد جديد",
"admin processes" => "مديريت فرايندها",
"admin activities" => "مديريت فعاليت‌ها",
"admin roles" => "مديريت قوانين",
"edit this process" => "اين فرايند را ويرايش كن",
"monitor" => "ديده‌باني",
"Activs" => "فعال",
"Ins" => "درج",
"time" => "زمان",
"send instance" => "نمونه را ارسال كن",
"stop" => "توقف",
"Wiki quick help" => "كمك سريع ويكي",
"Quicklinks" => "پيوندهاي سريع",
"Last Edit:" => "آخرين ويرايش",
"Grade Paper" => "كاغذ درجه‌بندي",
"Due Date:" => "تاريخ انجام",
"Comparing versions" => "مقايسه‌ي نسخ",
"Actual_version" => "نسخه‌ي واقعي",
"Diff to version" => "متفاوت از نسخه‌ي",
"source" => "منبع",
"Assignments List" => "فهرست منصوبات",
"My Work" => "كارهاي من",
"Assignment" => "منصوبات",
"Due Date" => "تاريخ انجام",
"Grading Queue " => "صف درجه‌بندي ",
"paper" => "كاغذ",
"papers" => "كاغذ",
"Edit Assignment" => "ويرايش منصوبات",
"list assignments" => "فهرست منصوبات",
"Due" => "مقرر",
"create assignment" => "ايجاد منصوبات",
"Import A PHPBB Dump" => "يك PHPBB Dump وارد كن",
"tiki-import_phpbb tpl" => "الگوي واردات PHP تيكي",
"Name of the SQL dump file (relative to\ntiki basedir, e.g. dump/phpbb_db_backup.sql )" => "نام پرونده‌ي SQL Dump (نسبت به پوشه‌ي منبع تيكي، مثلا: dump/phpbb_db_backup.sql)",
"Overwrite existing threads if the name is\nthe same" => "درصورتي كه رگه‌اي با همين نام وجود دارد، روي آن بنويس",
"Excerpt" => "گلچين كردن",
"result" => "نتيجه",
"edit repository" => "مخزن را ويرايش كن",
"list articles tpl" => "الگوي فهرست مقالات",
"edit new article" => "ويرايش مقاله‌ي جديد",
"admin Banners" => "مديريت درفش‌ها",
"admin Banners tpl" => "الگوي مديريت درفش‌ها",
"create new blog" => "يك بلاگ جديد ايجاد كن",
"admin cache" => "مديريت Cache",
"admin cache tpl" => "الگوي مديريت Cashe",
"admin DynamicContent" => "مديريت محتوي پويا",
"admin DynamicContent tpl" => "الگوي مديريت محتوي پويا",
"list faqs tpl" => "الگوي فهرست سئوالات متداول",
"upload file" => "بارگذاري پرونده",
"Edit a file using this form" => "با استفاده از اين فرم، يك پرونده را ويرايش كن",
"delete selected files" => "پرونده‌هاي انتخاب شده را حذف كن",
"browse gallery" => "مرور سرسرا",
"Flash binary (.sqf or .dcr)" => "فلاش‌هاي دودويي (.sqf or .dcr)",
"list posts tpl" => "الگوي فهرست الصاق‌ها",
"edit blog" => "ويرايش بلاگ",
"Number Members" => "تعداد اعضا",
"Number Admins" => "تعداد مديران",
"No projects found" => "پروژه‌اي پيدا نشد.",
"list quizzes tpl" => "الگوي فهرست آزمون‌ها",
"edit new submission" => "ويرايش ارائه‌ي جديد",
"edit quiz stats tpl" => "ويرايش الگوي آمار آزمون",
"actions" => "اعمال",
"take survey" => "به اجرا گذاشتن",
"adm" => "مديريت",
"list trackers tpl" => "الگوي فهرست trackerها",
"admin live support tpl" => "الگوي مديريت پشتيباني زنده",
"set as operator" => "به عنوان پشتيبان قرارش بده",
"add topic" => "افزودن موضوع",
"Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./fixperms.sh fix\" for example)." => "آپاچي(Apache) اجازه‌ي نوشتن در پرونده‌هاي شما را دارد، كه اين امر نصب، حذف و به‌روز رساني بسته‌ها را ممكن مي‌سازد. هنگامي كه كار شما با اين اعمال به پايان رسيد، به‌خاطر داشته باشيد كه حقوق دسترسي مربوط را به حالت امن برگردانيد(مثلا با استفاده از \"./fixperms.sh fix\")",
"To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that permission (using \"./fixperms.sh fix\")." => "به منظور نصب، حذف و به‌روز رساني بسته‌ها بايد به آپاچي(Apache) اجازه‌ي نوشتن در پرونده‌هاي خود را بدهيد.(مي‌توانيد از \"./fixperms.sh open\" بهره بگيريد). پس از نصب، بايد اين دسترسي را از اين كاربر صلب كنيد.(مثلا با استفاده از \"./fixperms.sh fix\")",
"install" => "نصب",
"The newsletter was sent to {\$edition.users} email addresses" => "خبرنامه به اين آدرس‌هاي الكترونيكي ارسال شد: {\$edition.users}",
"wiki create" => "ساخت ويكي",
"wiki overwrite" => "نوشتن ويكي(جايگزيني روي قبلي‌ها)",
"back" => "بازگشت",
"Assign permissions to page" => " تخصيص حقوق دسترسي به صفحه‌ي",
"Current permissions for this page" => "حقوق دسترسي كنوني براي اين صفحه",
"remove from this page" => "از اين صفحه حذفش كن",
"remove from this structure" => "از اين ساختار حذف كن",
"No individual permissions; category or global permissions apply" => "حقوق دسترسي فردي تنظيم نشده است، دسترسي‌هاي طبقه يا دسترسي‌هاي عمومي اعمال خواهند شد.",
"this page" => "اين صفحه",
"this structure" => "اين ساختار",
"Current permissions for categories that this page belongs to" => "دسترسي‌هاي جاري براي طبقه‌هايي كه اين صفحه به آن‌ها تعلق دارد",
"Send email notifications when this page changes to" => "هنگامي كه اين صفحه تغيير مي‌كند، به اين آدرس‌ها پست الكترونيكي بفرست",
"add email" => "آدرس پست الكترونيكي",
"Notifications" => "آگاه‌سازي‌ها",
"view comments" => "مشاهده‌ي نظرها",
"clear" => "پاك كن",
"Project Created:" => "پروژه ساخته شده:",
"Project Info" => "اطلاعات پروژه",
"Project Admins:" => "مديريت پروژه:",
"Project Members:" => "اعضاي پروژه:",
"View Details" => "مشاهده‌ي جرئيات",
"Edit Project" => "ويرايش پروژه",
"Add Blog" => "افزودن بلاگ",
"Add Articles" => "افزودن مقاله",
"Add Calendar" => "افزودن تقويم",
"Add FAQ" => "افزودن FAQ",
"Add File Gallery" => "افزودن سرسراي پرونده",
"Add Forum" => "افزودن انجمن",
"Add Image Gallery" => "افزودن سرسراي تصوير",
"Add Newsletter" => "افزودن خبرنامه",
"Add URL" => "افزودن URL",
"Project Registration" => "ثبت‌نام",
"Your project was successfully submitted.  It may be subject\nto approval. Once available, you can create/link your project objects\nto your project page." => "پروژه‌ي شما با موفقيت ارائه شد. بايد در معرض تصويب قرار بگيرد. هنگامي كه تاييد شد مي‌توانيد در صفحه‌ي پروژه‌ي خود اشياء پروژه را بسازيد و براي آن‌ها پيوند ايجاد كنيد",
"List all projects" => "فهرست تمام پروژه‌ها",
"Take care when you register your project, the project name\ncannot be changed afterwards. Please also provide an accurate \nproject description. If you havent worked out these details please\ndo so before your register the project." => "هنگامي كه پروژه‌ي خود را ثبت مي‌كنيد، مراقب باشيد، نام پروژه پس از ثبت نمي‌تواند تغيير كند. اگر هنوز در خصوص آن تصميم نگرفته‌ايد، قبل از ثبت پروژه ترتيب آن را بدهيد.",
"Please choose your project categories carefully. You can\nhowever change this later on your project admin panel." => "لطفا طبقات پروژه‌ي خود را با دقت انتخاب كنيد. هرچند مي‌توانيد در بخش مديريت پروژه آن‌ها را تغيير دهيد.",
"All project names are converted to lowercase." => "نام تمام پروژه‌ها به حروف كوچك تبديل خواهد شد.",
"clear stats" => "آمار را پاك كن",
"Communcation Center" => "مركز ارتباطات",
"Edit received page" => "ويرايش صفحات دريافت شده",
"admin Referer stats" => "آمار مراجعات به سرپرست",
"admin Referer stats tpl" => "الگوي آمار مراجعات به سرپرست",
"last" => "آخرين بار",
"send me my password" => "براي من كلمه‌ي عبورم را ارسال كن",
"searched" => "جستجو شد",
"galleries" => "سرسراها",
"images" => "تصاوير",
"blog posts" => "الصاق‌هاي بلاگ",
"articles" => "مقالات",
"The event was sent to {\$sent} email addresses" => "اين رويداد براي آدرس‌هاي پست الكترونيكي {\$sent} ارسال شد",
"This event will be sent to {\$subscribers} email addresses." => "اين رويداد براي آدرس‌هاي پست الكترونيكي {\$subscribers} ارسال خواهد شد",
"Prepare a event to be sent" => "آماده‌سازي يك رويداد براي ارسال",
"Send Events" => "رويداد را بفرست",
"admin send objects tpl" => "الگوي مديريت ارسال اشياء",
"site" => "نام پايگاه",
"path" => "مسير",
"add article" => "مقاله را اضافه كن",
"create new sheet" => "ساخت ورق جديد",
"admin Tiki Shoutbox" => "مديريت فريادگاه تيكي",
"admin Tiki Shoutbox tpl" => "الگوي مديريت فريادگاه تيكي",
"Search : " => "جستجو:",
"first" => "اولين",
"send answers" => "پاسخ‌ها را ارسال كن",
"{if \$editFileId}Edit File: {\$fileInfo.filename}{else}Upload File{/if}" => "{if \$editFileId}ويرايش پرونده‌ي: {\$fileInfo.filename}{else}بارگذاري پرونده{/if}",
"move to right column" => "انتقال به ستون چپ",
"unassign" => "حذف",
"move to left column" => "انتقال به ستون راست",
"remove folder" => "پوشه را حذف كنت",
"refresh cache" => "بازيابي cache",
"General preferences" => "تنظيمات عمومي",
"Other preferences" => "ساير تنظيمات",
"HomePage" => "صفحه‌ي مبدا",
"Edit information" => "ويرايش اطلاعات",
"Change information" => "تغيير اطلاعات",
"empty trash" => "تخليه‌ي خاكرويه",
"remove from trash" => "از خاكروبه هم حذفش كن",
"Maked as deleted" => "با عنوان حذف شده علامت بخورند",
"reload" => "باركردن مجدد",
"trash" => "خاكروبه",
"edit user files" => "ويرايش پرونده‌هاي كاربر",
"no comments" => "بدون شرح",
"stop monitoring this blog" => "ديده‌باني اين بلاگ را متوقف كن",
"edit items" => "ويرايش اقلام",
"list charts" => "فهرست نمودارها",
"last chart" => "آخرين نمودار",
"perm" => "قطعيت",
"item" => "قلم",
"view faq" => "مشاهده‌ي FAQ",
"view faq tpl" => "الگوي مشاهده‌ي FAQ",
"admin menus tpl" => "الگوي مديريت منوها",
"add suggestion" => "افزودن پيشنهاد",
"monitor this forum" => "اين انجمن را ديده‌باني كن",
"stop monitoring this forum" => "ديده‌باني اين انجمن را متوقف كن",
"delete selected topics" => "عناوين منتخب را حذف كن",
"topics in this forum" => "عناوين اين انجمن",
"stop monitoring this topic" => "ديده‌باني اين عنوان با متوقف كن",
"Comments below your current threshold" => "نظرات پايين‌تر از حد آستانه‌ي شما",
"list attachments" => "فهرست ضمايم",
"Editing tracker item" => "ويرايش فقره tracker",
"Not rated yet" => "هنوز رتبه‌بندي نشده است.",
"add contacts" => "افزودن گيرنده",
"No event indicated" => "هيچ رويداد مشخص نشده است.",
"This is not a Tikiwiki File. Check if this file was uploaded and if it is dangerous." => "اين يك پرونده‌ي تيك ويكي نيست. بررسي كنيد كه آيا پرونده بارگزاي شده است يا خير و اين‌كه خطرناك نباشد.",
"This file is modified." => "اين پرونده تغيير كرده است.",
"The passwords dont match" => "كلمه‌ي عبور با تكرارش همخواني ندارد",
"Removed %s from group %s" => "%s از %s حذف شد",
"The passwords didn't match" => "كلمه‌ي عبور هم‌خواني ندارد",
"No project reference assigned" => "هيچ ارجاع پروژه‌اي منصوب نشده است",
"File Gallery successfully added to the project." => "سرسراي پرونده با موفقيت به پروژه اضافه شد.",
"You do not have permission to write the template" => "متاسفانه شما حقوق دسترسي كافي براي نوشتن الگو نداريد",
"You cannot edit this page because it is a user personal page" => "از آن‌جايي كه اين صفحه، يك صفحه‌ي شخصي كاربر است، شما نمي‌توانيد اين صفحه را ويرايش كنيد",
"You must be logged in to subscribe to events" => "براي عضويت در رويدادها بايد ابتدا وارد سامانه شويد.",
"Go to your <a href=\"tiki-friends.php\">friendship network</a> to accept or refuse this request" => "براي پذيرش يا رد كردن اين درخواست به <a href=\"tiki-friends.php\">شبكه‌ي رفاقت خود</a> برويد.",
"Frienship request sent to %s" => "درخواست رفاقت براي %s ارسال شد",
"Individual Order" => "ترتيب فردي",
"You must be a student to edit homework pages." => "براي ويرايش صفحات مشق شب، شما بايد دانش‌آموز باشيد",
"No assignment indicated" => "هيچ انتصابي مشخصي نشده است.",
"Error: Invalid id for hw_pages table." => "خطا: شناسه‌ي نامعتبر براي جدول hw_pages.",
"Error: This page is being edited by another user." => "خطا: كاربر ديگري در حال ويرياش اين صفحه است",
"Permission denied: Students may only view or edit their own work." => "دسترسي ممنوع است: دانش‌آموزان تنها مي‌توانند تكاليف خود را مشاهده يا ويرايش كنند",
"Error: Assignment not found." => "خطا: انتصاب يافت نشد.",
"Permission denied: Students may NOT edit their work after the due date." => "دسترسي ممنوع است: دانش‌آموزان نمي‌توانند تكاليف خود را پس از تاريخ انجام تغيير دهند",
"Permission denied: The teacher must wait until the due date to edit students' work." => "دسترسي ممنوع است: معلم بايد تا پايان زمان انجام تكليف صبر كند تا بتواند كار دانش‌آموزان را ويرايش كنيد",
"No entries available yet!" => "هنوز هيچ فقره‌اي ثبت نشده است!",
"Permission denied: you must be a teacher to access this page." => "دسترسي ممنوع است: براي دسترسي به اين صفحه بايد معلم باشيد",
"Error: No assignment indicated." => "خطا: هيچ انتصابي يافت نشد",
"Error: assignment not found." => "خطا: انتصاب يافت نشد",
"You must be a student to view this page." => "براي مشاهده‌ي اين صفحه، شما بايد يك دانش‌آموز باشيد",
" is not a student." => " يك دانش‌آموزي نيست",
"specified." => "مشخص شده است.",
"Assignment not found" => "انتصاب پيدا نشد",
"Anonymous Grader" => "مصحح بي‌نام",
"Anonymous Peer Reviewer" => "مروركننده‌ي همتاي بي‌نام",
"No homework page indicated!" => "هيچ صفحه‌ي مشق شبي مشخص نشده است!",
"Error: Could not fetch page" => "خطا: نمي‌توانيم صفحه را واكشسي كنم",
"You must be a student to view this page!" => "براي ديدن اين صفحه بايد يك دانش‌آموزي باشيد!",
"Students may only view their own work!" => "دانش‌آموزيين تنها مي‌توانند كار خود را ببينند!",
"This function is deprecated in favor of the improved quizzes outside of the Homework feature." => "اين تابع باتوجه به آزمون‌هاي بهبوديافته‌ي خارج از خصيصه‌ي مشق شب، منسوخ شده است",
"Permission denied: You cannot rollback this page." => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين صفحه را به حالت قبل برگردانيد.",
"No hw page indicated" => "هيچ صفحه‌ي مشق شبي مشخص نشده است.",
"Error: nonexistant version specified." => "خطا: نسخه‌ي مشخص شده وجود ندارد.",
"Error: Could not fetch assignment " => "خطا: نمي‌توانم انتصاب را واكشي كنم ",
"You must be a student to view homework assignments." => "براي مشاهده‌ي انتصابات مشق شب بايد يك دانش‌آموز باشيد.",
"Permission denied you must be a student to view assignments." => "دسترسي ممنوع است: شما بايد يك دانش‌آموزي باشيد تا بتوانيد انتصاب‌ها را مشاهده كنيد",
"You must be a teacher or grader to access this page." => "براي دسترسي به اين صفحه، شما بايد يك معلم يا مصحح باشيد",
"Permission denied: You must be a teacher to edit assignments." => "دسترسي ممنوع است: براي ويرايش انتصابات شما بايد يك معلم باشيد.",
" error: Can not find assignment " => " خطا: نتوانستم پيدا كنم: ",
"updated by the phpbb import process" => "به‌روز رساني شده توسط فرايند واردات phpbb",
"created from phpbb import" => "ساخت شده از واردات phpbb",
"You dont have permission to use this feature" => "متاسفانه شما حقوق دسترسي كافي براي استفاده از اين خصيصه را نداريد",
"Sorry, \"\$page\" has not been created." => "متاسفم، صفحه‌ي  \"\$page\" ايجاد نشد هاست",
"Permission denied you cannot assign permissions for this page" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد براي اين صفحه تخصيص حقوق دسترسي كنيد",
"You must provide a project name" => "بايد يك نام براي پروژه فراهم كنيد",
"You must provide a project description" => "بايد يك توضيح براي پروژه فراهم كنيد",
"A project with that name already exists" => "پروژه‌اي با اين نام قبلا ايجاد شده بود",
"A new password and your IP address has been sent " => "آدرس Ip شما و يك كلمه‌ب عبور جديد ارسال شد",
"Tiki RSS Feed Error Message" => "پيغام‌هاي خطاي تغذيه‌ي RSS تيكي",
"You have to type a searchword" => "شما بايد يك كلمه براي جستجو وارد كنيد",
"Invalid variable value : " => "مقدار متغيير نامعتبر است : ",
"You do not have permission to edit messages" => "متاسفانه شما حقوق دسترسي كافي براي ويرايش پيام‌ها را نداريد",
"Cannot read file" => "نمي‌توانم پرونده را بخوانم",
"File update was succesful" => "پرونده با موفقيت به‌روز رساني شد",
"Permission denied you cannot upload files" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد پرونده‌اي بارگذاري كنيد",
"cannot process upload" => "اشكال در بارگذاري تصوير(cannot process upload)",
"You have to provide a name to the image" => "بايد براي اين تصوير يك نام فراهم كنيد",
"Feature" => "خصيصه",
"Sorry this problems by writing into the database" => "متاسفانه در نوشتن در بانك اطلاعات با اشكال روبرو شدم",
"forum_post_topic" => "عنوان الصاق انجمن",
"wiki_page_changed" => "صفحه‌ي ويكي تغيير كرده است",
"forum_post_thread" => "رگه‌ي الصاق انجمن",
"Your email address has been removed from the list of addresses monitoring this tracker" => "آدرس پست الكترونيكي شما از فهرست ديده‌بانان اين tracker حذف شد",
"Your email address has been added to the list of addresses monitoring this tracker" => "آدرس پست الكترونيكي شما به فهرست ديده‌بانان اين tracker اضافه شد",
"Cancel monitoring" => "لغو ديده‌باني",
"Your email address has been removed from the list of addresses monitoring this item" => "آدرسي الكترونيكي شما از فهرست ديده‌بانان اين فقره حذف شد",
"Your email address has been added to the list of addresses monitoring this item" => "آدرس پست الكترونيكي شما به فهرست ديده‌بانان اين فقره اضافه شد",
"wiki pages" => "صفحات ويكي",
"Allow trackback pings" => "اجازه‌ي pingهاي مسيريابي معكوس را بده(trackback pings)",
"Admin mods" => "مديريت ماژول‌ها",
"remove users and their userpages" => "كاربران و صفحات آن‌ها را حذف كن",
"Tiki Logs" => "ثبت وقايع تيكي",
"structure" => "",
"must be turned on and notification is sent to the admin's" => "بايد روشن باشد، آگاه‌سازها براي سرپرستان ارسال مي‌شود",
"inter-user message inbox" => "صندوق پستي بين كاربري",
"Auth Type" => "گونه‌ي تصديق هويت",
"IMAP/POP3/LDAP Host" => "ميزبان IMAP/POP3/LDAP",
"IMAP/POP3/LDAP Port" => "درگاه IMAP/POP3/LDAP",
"IMAP/POP3 BaseDSN" => "DSN پايه درIMAP/POP3/LDAP",
"Dec" => "دسامبر",
"Nov" => "نوامبر",
"list galleries" => "فهرست سرسراها",
"Enable cache images to all galleries" => "براي تمام سرسراها، نهانگاه(cache) تصاوير فعال باشد",
"Images cache directory" => "پوشه‌ي نهانگاه تصاوير(cache dir)",
"Wiki attachments preferences" => "تنظيمات ضمايم ويكي",
"Wiki syntax used when a page contains HTML" => "نحو ويكي، هنگامي كه صفحه‌اي شامل كدهاي HTML است",
"full" => "كامل",
"partial" => "ناقص",
"Search and replace" => "جستجو و جايگزيني",
"Custom Code" => "كد متناسب‌سازي",
"Site breadcrumbs" => "خرده نان فعال باشد",
"Site search bar" => "نوار جستجوي پايگاه",
"Site Menu" => "منو پايگاه",
"Note: This feature also requires phplayers to be turned on in Admin->Features" => " نكته: اين خصيصه نياز به فعال بودن لايه‌هاي PHP يا همان PHPLayers در بخش 'مديريت->خصيصه‌ها' نيز دارد.",
"as master" => "به عنوان كارفرما",
"add a category" => "اضافه كردن يك طبقه",
"The tracker needs a text field named Subject" => "(tracker احتياج به يك رشته‌ي متني به‌نام Subject دارد)",
"n" => "خير",
"list view" => "نمايش فهرستي",
"participants" => "شركت‌كنندگان",
"subscription" => "اشتراك",
"Subscription List" => "فهرست اشتراك",
"Layer Management" => "مديريت لايه‌ها",
"reply to" => "پاسخ داده‌شده",
"admin mode" => "حالت سرپرستي",
"use start date and time" => "از تاريخ و ساعت شروع استفاده كن",
"use end date and time" => "از تاريخ و ساعت پايان استفاده كن",
"use google map locator" => "از نقشه‌ياب گوگل استفاده كن",
"file_galleries" => "سرسراهاي پرونده",
"html_pages" => "صفحات HTML",
"user_messages" => "پيغام‌هاي كاربر",
"mytiki" => "تيكي من",
"surveys" => "نظرسنجي‌ها",
"featured_links" => "پيوندهاي خاص",
"newsreader" => "اخبارگو",
"workflow" => "گردش كار",
"webmail" => "پست تحت وب",
"offline since" => "از اين زمان روي خط نيامده است",
"Jan" => "ژانويه",
"cms" => "سامانه‌ي مديريت محتوا",
"save only in the theme:" => "ذخيره فقط براي قيافه‌ي ",
"currency" => "پول",
"currency_us" => "پول_كانادا",
"currency_ca" => "پول_آمريكا",
"Activity start is interactive so it must use the \$instance->complete() method" => "فعاليت آغاز تعاملي است، لذا بايد بدين شكل باشد: \$instance->complete() method",
"Note: It is not possible to delete an active process. To delete a process, deactivate it first." => "نكته: يك فرايند فعال را نمي‌توانيد حذف كنيد. براي حذف يك فرايند بايد ابتدا آن را غيرفعال سازيد.",
"UserPageadmin" => "مديريت صفحه‌ي كاربر",
"Note: You have to import security data via installation process (tiki-install.php). Import the *secdb* update files in your database" => "نكته: شما بايد داده‌هاي امنيتي را با فرايند نصب وارد كنيد (tiki-install.php). پرونده‌هاي به‌روز رسان *secdb* را به بانك اطلاعات خود وارد كنيد.",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely." => "اخطار: trackerهاي جديد و قديمي، همزمان نمي‌توانند وجود داشته باشند. Trackerهايي كه با كتابخانه‌هاي جديد ساخته مي‌شوند با كتابخانه‌هاي قديمي كار نخواهند كرد، و برعكس.",
"System Gallery" => "سرسراي سامانه(system gallery)",
"Php GD library required" => "PHP GD مورد نياز است",
"GZIP Disabled" => "GZIP غيرفعال است",
"Exact match" => "دقيقا مانند",
"Tiki initialization" => "آماده‌سازي تيكي",
"Russian Federation" => "روسيه",
"new image uploaded by" => "تصوير جديد، بارگذاري شده به‌وسيله‌ي:",
"new subscriptions" => "اشتراك جديد",
"new item in tracker" => "يك فقره‌ي جديد در tracker",
"show" => "نمايش بده",
"hide" => "مخفي كن",
"Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "اختيارات متني: options,width,height,max Option 0 يا 1 است، widthوheight حجم به حرف و خط هستند و max بيشينه مقدار تعداد حروف است كه مي‌توان ذخيره كرد.",
"Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "اختيارات: 1و2 كه 1 تنها نمايش دهنده‌ي نام كشور و 2 تنها نمايش دهنده‌ي پرچم كشور. به‌صورت پيش‌فرض، هم نام و هم پرچم نمايش داده مي‌شود.",
"message" => "پيغام",
"Include all post in a blog" => "شامل تمام الصاق‌هاي يك بلاگ",
"Include an article" => "شامل يك مقاله",
"no such attachment on this page" => "چنين پميمه‌اي در اين صفحه وجود ندارد",
"comment" => "ايراد نظر",
"select all" => "انتخاب همه",
"filter" => "فيلتر",
"missing fields list" => "فهرست ستون‌ها مفقود است",
"move %s in %s" => "%s را به %s منتقل كن",
"no such file" => "چنين فايلي وجود نداشت",
"downloads" => "دريافت",
"download" => "دريافت",
"attach" => "ضميمه",
"monitor this blog" => "اين بلاگ را ديده‌باني كن",
"hide categories" => "طبقات را مخفي كن",
"Admin categories" => "مديريت طبقات",
"browse category" => "مرور طبقه",
"reply" => "پاسخ",
"monitor this topic" => "اين عنوان را ديده‌باني كن",
"active perms" => "حقوق دسترسي فعال",
"with checked" => "تيك خورده‌ها را...",
"Dls" => "دريافت‌ها",
"move selected files" => "پرونده‌هاي انتخاب شده را منتقل كن",
"Thank you for you registration. You may log in now." => "از ثبت‌نام شما سپاس‌گزاريم. هم‌اكنون شما مي‌توانيم وارد سامانه شويد.",
"Zoom out x4" => "بزرگنمايي 4برابر",
"Zoom out x3" => "بزرگنمايي 3برابر",
"Zoom in x3" => "بزرگنمايي 3برابر",
"Zoom in x4" => "بزرگنمايي 4برابر",
"from\nthe mapfile:" => "از \nthe پرونده‌ي نقشه‌ي:",
"compare" => "مقايسه كن",
"diff" => "تغييرات",
"older version" => "نسخ قبلي",
"Click the :: options in the Menu for more options." => "براي اختيارهاي بيشتر روي اختيار :: در منو كليك كنيد",
"Please, also see" => "لطفا نگاهي هم بياندازيد به",
"for more setup details." => "براي جزئيات بيشتر نصب و برپاسازي.",
"You can remove this module in" => "اين ماژول را مي‌توانيد در اين‌جا حذف كنيد",
"as well as assign or edit many others." => "همان‌گونه كه مي‌توانيد بسياري ماژول‌هاي ديگر را تخصيص دهيد يا ويرايش كنيد.",
"del" => "حذف",
"Create pdf" => "ساخت PDF",
"pdf" => "PDF",
"1 file attached" => "1 پرونده ضميمه شد",
"categories" => "طبقه",
"List pages where I am a creator" => "فهرست صفحاتي را كه من ايجاد كرده‌ام، نمايش بده",
"by creator" => "به‌وسيله‌ي ايجاد كننده",
"List pages where I am a modificator" => "فهرست صفحاتي را كه من تغيير داده‌ام، نمايش بده",
"by modificator" => "به‌وسيله‌ي تغيير دهنده",
"at tracker" => "در tracker",
"check / uncheck all" => "انتخاب همه/هيچكدام",
"Tiki sections and features" => "خصيصه‌ها و بخش‌هاي تيكي",
"tikiwiki.org help" => "كمك در tikiwiki.org",
"Site Logo and Identity" => "هويت و نماد پايگاه",
"please read" => "لطفا بخوانيد",
"yes" => "بله",
"Click here for more details." => "براي جزئيات بيشتر اين‌جا را كليك كنيد",
"Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "بيشينه مقدار حروف ويكي در بانك اطلاعاتي، به‌صورت پيش‌فرض 250 حرف تعيين گرديده است كه به محتواي كد متناسب‌سازي شده نيز اعمال مي‌شود. اگر مي‌خواهيد بيش از از اين تعداد حرف وارد كنيد، اين گزينه را انتخاب كنيد. (گرچه افزايش اين مقدار بر روي mysql آزمايش شده و نتيجه‌ي مطلوبي داشته، پيشنهاد مي‌شود كه قبل از تغيير در بانك اطلاعاتي، به‌صورت دستي از اطلاعات خود نسخه‌ي پشتيبان تهيه كنيد.)",
"Users &amp; groups" => "كاربران و تيم‌هاي كاري",
"UTC" => "ساعت هماهنگ فراگير(UTC)",
"Local" => "محلي(Local)",
"private" => "شخصي",
"<b>Item</b>" => "<b>مورد</b>",
"<b>Value</b>" => "<b>مقدار</b>",
"This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or" => "اين صفحه براي پيكربندي تنظيمات تغذيه‌هاي توليد/صادر شده به‌وسيله‌ي تيكي است. براي خواندن/وارد كردن تغذيه‌هاي RSS، به دنبال \"ماژول‌هاي RSS\" در منوي برنامه بگرديد. يا",
"<b>Feed</b>" => "<b>تغذيه</b>",
"<b>enable/disable</b>" => "<b>فعال/غيرفعال</b>",
"<b>Max number of items</b>" => "<b>بيشينه تعداد اقلام</b>",
"Feed for Articles" => "تغذيه براي مقالات",
"Feed for Weblogs" => "تغذيه براي وبلاگ‌ها",
"Feed for Image Galleries" => "تغذيه براي سرسراهاي تصاوير",
"Feed for File Galleries" => "تغذيه براي سرسراهاي پرونده‌ها",
"Feed for the Wiki" => "تغذيه براي ويكي",
"Feed for individual Image Galleries" => "تغذيه براي تك تك سرسرهاي تصوير",
"Feed for individual File Galleries" => "تغذيه براي تك تك سرسرهاي پرونده",
"Feed for individual weblogs" => "تغذيه براي تك تك وبلاگ‌ها",
"Feed for individual forums" => "تغديه براي تك تك انجمن‌ها",
"Feed for mapfiles" => "تغذيه براي پرنده‌هاي نقشه",
"Feed for directories" => "تغذيه براي پوشه‌ها",
"Caching time :" => "زمان Cache",
"Prefix breadcrumbs with 'Location:' label?" => "آيا برچسب 'مكان:' پيشوند خرده‌نان‌ها باشد؟",
"Site Search" => "جستجوي پايگاه",
"Change style only" => "فقط سبك(Style) رو تغيير بده",
"PDF generation" => "توليد PDF",
"IP not displayed in history" => "آدرس اينترنتي(IP) در تاريخچه نمايش داده نشود",
"Use in CMS" => "استفاده در سامانه‌ي مديريت محتوا",
"Use in Wiki" => "استفاده در ويكي",
"Use in newsletters" => "استفاده در خبرنامه‌ها؟",
"Use in events" => "استفاده در رويدادها؟",
"Use in HTML pages" => "استفاده در اين صفحات HTML",
"Edit Existing Forums" => "انجمن كنوني را ويرايش كن",
"Refresh rate (if dynamic) [secs]" => "نرخ تازه كردن-Refresh- (در صورت پويا بودن) [ثانيه]",
"configure repositories" => "پيكربندي مخازن",
"configure this repository" => "پيكربيندي اين مخزن",
"copy rules" => "كپي قوانين",
"Create/edit newsletters" => "ايجاد/تغيير خبرنامه‌ها",
"subscriptions" => "مشتركين",
"archives" => "بايگاني‌ها",
"Use Admin Email" => "از پست الكترونيك سرپرست استفاده كن",
"Edit or add poll options" => "افزودن يا ويرايش اختيارات راي‌گيري‌ها",
"configure polls" => "پيكربندي راي‌گيري‌ها",
"Create/edit Polls" => "ايجاد/ويرايش راي‌گيري",
"Rss channels" => "كانال‌هاي RSS",
"show pubdate" => "تاريخ انتشار را نمايش بده",
"activate" => "فعال‌سازي",
"Admin tracker" => "مديريت tracker",
"Edit this tracker" => "ويرايش اين tracker",
"View this tracker items" => "نمايش اقلام اين tracker",
"Edit tracker fields" => "ويرايش ستون‌هاي tracker",
"visible by admin only" => "تنها به‌وسيله‌ي سرپرست قابل مشاهده است",
"Import/export trackers fields" => "وارد/صادر كردن ستون‌هاي tracker",
"Edit tracker" => "ويرايش tracker",
"Create trackers" => "ايجاد trackerها",
"Import/export" => "واردات/صادرات",
"fields" => "ستون‌ها",
"active permissions" => "حقوق دسترسي فعال",
"Create/edit trackers" => "ايجاد/ويرايش trackerها",
"filename" => "نام پرونده",
"filesize" => "حجم پرونده",
"filetype" => "نوع پرونده",
"longdesc" => "توضيحات",
"Add a new group" => "افزودن يك گروه جديد",
"Edit item" => "ويرايش فقره",
"List all members" => "فهرست تمام اعضا",
"Add a new user" => "اضافه كردن يك كاربر جديد",
"manage group assignments" => "عضويت گروه‌هايشان رو مديريت كن",
"set default groups" => "غضو گروه‌هاي كاربري پيش‌فرض كن",
"Popup Window" => "پنجره‌ي popup",
"details" => "جزئيات",
"change focus" => "تغيير تمركز",
"quater" => "يك چهارم",
"quarter" => "چهارم",
"semester" => "نيم‌سال",
"No individual permissions global permissions apply" => "بدون حقوق دسترسي فردي. حقوق دسترسي عمومي اعمال مي‌شوند.",
"Welcome to the Tiki Chat Rooms" => "به اتاق‌هاي گفتگوي تيكي خوش‌آمديد‌",
"Please select a chat channel" => "لطفا يك كانال گپ‌زني انتخاب كنيد",
"enter chat room" => "وارد اتاق گپ‌زني شو",
"There are no channels setup, please contact a site admin" => "هيج كانالي آماده نيست، لطفا با مدير پايگاه تماس بگيريد",
"Chatroom" => "اتاق گپ‌زني",
"Active Channels" => "كانال‌هاي فعال",
"Users in this channel" => "كاربران اين كانال",
"Channel Information" => "اطلاعات كانال",
"Channel" => "كانال",
"Ratio" => "نرخ",
"Use :nickname:message for private messages" => "براي پيغام‌هاي شخصي، از تركيب :نام متسعار:پيغام استفاده كنيد.",
"Use [URL|description] or [URL] for links" => "براي پيوندها از [URL|description] يا [URL] استفاده كنيد.",
"Use (:smileyname:) for smileys" => "براي صورتك‌ها از (:نام صورتك:) استفاده كنيد:",
"Create PDF" => "ساخت PDF",
"PDF Settings" => "تنظيمات PDF",
"Select Wiki Pages" => "انتخاب صفحات ويكي",
"Remove Page" => "صفحه را حذف كن",
"click here to send us an email" => "براي ارسال يك پست الكترونيكي به ما، اين‌جا را كليك كنيد",
"Add or edit a site" => "افزودن يا ويرايش يك پايگاه وب",
"sites" => "پايگاه‌ها",
"cool sites" => "پايگاه‌هاي بامزه(cool)",
"Use ...page... to separate pages in a multi-page article" => "از ...page... براي جداكردن صفحات در يك مقاله‌ي چندصفحه‌اي استفاده كنيد",
"Create Zone" => "ايجاد قلمرو",
"use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "از كروشه براي ويكي‌هاي خارجي استفاده كن: [URL] يا [URL|توضيح پيوند] يا [URL|توضيح|nocache] (كه مورد آخر از cache كردن صفحه توسط ويكي محلي جلوگيري مي‌كند؛ لطفا براي صفحات بزرگ از اين گزينه استفاده كنيد!).",
"browse image" => "مرور تصوير",
"translate" => "ترجمه كن",
"Create or edit content" => "ساخت يا ايجاد محتوي",
"this quiz stats" => "آمار اين آزمون",
"answer" => "پاسخ",
"Edit Translation:" => "ويررايش ترجمه:",
"Use this section to set the language of the version you are currently working on." => "از اين بخش براي تنظيم نسخه‌ي از زبان كه برروي آن كار مي‌كنيد استفاده كنيد",
"Set of Translations" => "مجموعه‌ي ترجمه‌ها",
"Select the article for which the current article is the translation." => "مقاله‌اي كه اين مقاله ترجمه‌ي آن است را انتخاب كنيد",
"Translation of:" => "ترجمه‌ي",
"Enter the name of the page for which the current page is the translation." => "نام صفحه‌اي كه اين صفحه ترجمه‌ي آن است را وارد كنيد",
"Add to the Set" => "افزودن به مجموعه",
"graph" => "نگار(نمودار)",
"Edit FAQ questions" => "ويرايش سئوالات اين FAQ",
"Edit this file gallery:" => "ويرايش اين سرسراي پرونده:",
"icon" => "تمثال",
"Other users can upload files to this gallery" => "ساير كاربران مي‌توانند به اين سرسرا پرونده اضافه كنند",
"Available File Galleries" => "سرسراهاي پرونده‌ي موجود",
"configure forum" => "پيكربندي انجمن‌ها",
"start" => "آغاز",
"end" => "پايان",
"roles" => "قوانين",
"Add role" => "افزودن قانون",
"active process" => "فرايندهاي فعال",
"invalid" => "نامعتبر",
"invalid process" => "فرايند نامعتبر",
"valid process" => "فرايند معتبر",
"activities" => "فعاليت‌ها",
"aborted" => "منقطع شده",
"value" => "مقدار",
"proc" => "فرايند",
"exceptions" => "استثنا",
"rollback" => "عقب‌گرد",
"Create or edit content block" => "ايجاد يا ويرايش بلاك محتوي",
"Listing Gallery" => "فهرست كردن سرسراها",
"Gallery Files" => "پروده‌هاي سرسرا",
"Last ver" => "آخرين نسخه",
"Com" => "نوع",
"Vers" => "نسخ",
"subscribe" => "عضويت",
"Sent edition" => "ويرايشات ارسال شده",
"Subscribe to newsletter" => "عضويت در خبرنامه",
"Add or edit a news server" => "افزودن يا ويرايش يك سرور اخبار",
"Print Wiki Pages" => "چاپ صفحات ويكي",
"add page" => "صفحه را اضافه كن",
"entire site" => "تمام پايگاه",
"click to navigate" => "براي هدايت اين‌جا را كليك كنيد",
"Total threads" => "مجموع رگه‌ها",
"Average threads per topic" => "متوسط رگه‌ها در هر موضوع",
"You can include the file in an HTML/Tiki page using" => "بدين‌وسيله مي‌توانيد پرونده‌اي را در يك صفحه‌ي HTML يا تيكي بگنجانيد",
"Now enter the file URL" => "هم اكنون URL پرونده را وارد كنيد",
" or upload a local file from your disk" => " يا يك پرونده از دستگاه خود بارگذاري كنيد",
"Add or edit folder" => "افزودن يا ويرايش پوشه",
"Add or edit a URL" => "افزودن يا ويرايش يك URL",
"received" => "دريافت شده‌ها",
"submitted" => "ارائه شده",
"shared" => "مشترك",
"accepted by task user and creator" => "پذيرفته شده از طرف كاربر وظيفه و ايجاد كننده",
"not accepted by one user" => "از طرف يك كاربر پذيرفته شده است",
"waiting for me" => "منتظر من هستند",
"waiting for other user" => "منتظر ساير كاربران",
"move into trash" => "انتقال به خاكروبه",
"waiting / not started" => "درحال انتظار/هنوز آغاز نشده است",
"waiting" => "انتظار",
"shared for group" => "مشترك براي گروه",
"accepted by user" => "پذيرفته شده از طرف كاربر",
"no / rejected" => "خير / رد شده",
"accepted by creator" => "پذيرفته شده از طرف ايجاد كننده",
"priority" => "اولويت",
"select one" => "يكي را انتخاب كنيد",
"undo trash" => "بازگشت از خاكروبه",
"show:" => "نمايش بده:",
"all shared tasks" => "تمام وظايف مشترك",
"previous chart" => "نمودار قبلي",
"next chart" => "نمودار بعدي",
"pos" => "رديف",
"pre" => "قبلي",
"permanency" => "قطعيت",
"avg" => "معدل",
"post new comment" => "الصاق نظريه جديد",
"Post New Comment" => "الصاق نظريه جديد",
"HTML tags are not allowed inside comments" => "تگ‌هاي HTML درون نظرات مجاز نيستند",
"moderator actions" => "اعمال ناظم",
"move selected topics" => "عناوين منتخب را انتقال بده",
"unlock selected topics" => "قفل عنواين منتخب را باز كن",
"lock selected topics" => "عناوين منتخب را قفل كن",
"merge" => "ادغام",
"merge selected topics" => "عناوين منتخب را اذغام كن",
"reported messages:" => "پيغام‌هاي گزارش شده:",
"queued messages:" => "پيغام‌هاي در صف",
"emot" => "احساسات",
"Edit fields" => "ويرايش ستون‌ها",
"Insert new item" => "درج فقره‌ي جديد",
"View item" => "مشاهده‌ي فقره",
"Add a comment" => "ايراد نظر",
"account" => "حساب",
"pop" => "درگاه pop",
"Projects" => "پروژه‌ها",
"Site Identity features" => "خصيصه‌هاي عينيت پايگاه",
"Click here to delete this category" => "براي حذف اين طبقه، اين‌جا را كليك كنيد",
"Group doesnt exist" => "گروه وجود ندارد",
"User doesnt exist" => "كاربر وجود ندارد",
"Event without Name" => "رويداد بدون نام",
"Invalid old password" => "كلمه‌ي عبور قبلي اشتباه است",
"No channel indicated" => "هيچ كانالي مشخص نشده است.",
"No nickname indicated" => "هيچ نام مستعاري مشخص نشده است.",
"No permission to view the page" => "حقوق دسترسي‌اي براي ديدن اين صفحه وجود ندارد",
"I have refused your friendship request!" => "من درخواست رفاقت شما را رد كرده‌ام!",
"Please create a directory named \$map_path to hold your map files." => "لطفا يك پوشه با عنوان \$map_path براي نگه‌داري پرونده‌هاي نقشه‌ها بسازيد.",
"Permision denied" => "دسترسي ممنوع",
"Phillippines" => "فيليپين",
"sender" => "فرستنده",
"subject" => "موضوع",
"date" => "تاريخ",
"flagged" => "علامت‌دار",
"mark" => "علامت بزن",
"find replied message" => "پاسخ ارسالي را بياب",
"replied" => "پاسخ داده‌شده",
"Click" => "كليك",
"posted by" => "الصاق شده توسط",
"email this post" => "اين الصاق را با پست الكترونيكي بفرست",
"Tag name" => "نام برچسب",
"Enable wiki 3D browser" => "مرورگر 3بعدي ويكي فعال باشد",
"Load page on navigation" => "هنگام مرور صفحه را بار كن",
"Existing page node color" => "رنگ گره‌ي صفحه‌ي موجود",
"Missing page node color" => " رنگ گره‌ي صفحه‌ي مفقود",
"Anonymous editors must input anti-bot code" => "ويراستاران بي‌نام، بايد كدهاي ضد-روباتيكي را وارد كنند",
"MultiPrint" => "چاپ چندگانه",
"Warn on edit conflict" => "هنگام بهوجود آمدن تضاد در ويرايش‌ها، هشدار بده",
"Edit idle timeout" => "مهلت ويرايش",
"Pictures" => "عكس",
"Use page description" => "از شرح صفحه استفاده كن",
"Show page title" => "عنوان صفحه را نمايش بده",
"Show page ID" => "شناسه‌ي صفحه را نمايش بده",
"Cache wiki pages (global)" => "صفحات ويكي را cache كن(عمومي)",
"Individual cache" => "cache تك-تك",
"Footnotes" => "تبصره‌ها",
"Users can lock pages (if perm)" => "كاربران مي‌توانند صفحات را قفل كنند(اگر دسترسي داشته باشند)",
"Use WikiWords" => "از ويكي-كلمه استفاده كن",
"Accept dashes and underscores in WikiWords" => "خط تيره و زيرخط در ويكي -كلمه‌ها مجاز است",
"Link plural WikiWords to their singular forms" => "ويكي-كلمات جمع را به مفرد آن‌ها متصل كن",
"Use Wiki paragraph formatting" => "از شكل‌سازي پاراگراف‌هاي ويكي استفاده كن",
"Automonospaced text" => "متون autospaceشده‌ي خودكار",
"Tables syntax" => "نحو جداول",
"Open page as structure" => "صفحه را به عنوان ساختار باز كن",
"Use external link icons" => "از تمثال پيوند خارجي استفاده كن",
"User's Page" => "صفحات كاربران",
"UserPage prefix" => "پيشوند صفحات كاربران",
"Page creators are admin of their pages" => "سازنده‌هاي صفحات، همان مالكان آن‌ها هستند",
"List authors" => "مؤلفان را فهرست كن...",
"Print Page" => "چاپ صفحه",
"Maximum number of versions for history" => "بيشينه تعداد نسخ براي تاريخچه",
"Never delete versions younger than days" => "هرگز صفحات جديدتر از اين تعداد روز را حذف نكن",
"Diff style" => "سبك تفاوت",
"Create watch for author on page creation" => "براي ويراستار هنگام ساخت صفحات، ديده‌بان بساز",
"Enable watch events when I am the editor" => "هنگامي كه من ويراستار هستم، ديده‌بان رويدادها فعال باشد",
"Enable watches on comments" => "ديده‌بان در 'نظرات' فعال باشد",
"Old vers" => "نسخ قديمي",
"Add or edit event" => "افزودن يا ويرايش رويداد",
"merge selected notes into" => "يادداشت‌هاي انتخابي را ادغام كن و بريز داخل",
"Faq Stats" => "آمار سئوالات متداول",
"Edit User Files" => "ويرايش پرونده‌هاي كاربر",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "پيغام شما براي تاييد در صف قرار گرفته است و پس از تاييد ناظم الصاق خواهد شد.",
"Webmail Doc" => "مستندات پست تحت وب",
"Webmail Doc template" => "الگوي مستندات پست تحت وب",
"settings" => "تنظيمات",
"mailbox" => "صندوق پستي",
"compose" => "تهيه‌ي نامه",
"contacts" => "تماس‌ها",
"clip" => "كليپ",
"back to mailbox" => "بازگشت به صندوق پستي",
"full headers" => "سرصفحه‌هاي كامل",
"normal headers" => "سرصفحه‌هاي معمولي",
"reply all" => "پايه به همه",
"forward" => "ارجاع",
"select from address book" => "از كتابچه‌ي آدرس انتخاب كن",
"cc" => "رونوشت",
"bcc" => "رونوشت مخفي",
"Please login" => "لطفا وارد شويد",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Your post has not been posted" => "Your post has not been posted",
// "Cookies must be allowed to vote" => "Cookies must be allowed to vote",
// "You have mistyped the anti-bot verification code; please try again." => "You have mistyped the anti-bot verification code; please try again.",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "A contribution is mandatory" => "A contribution is mandatory",
// "Copyright management" => "Copyright management",
// "Uploaded" => "Uploaded",
// "Last editor" => "Last editor",
// "Explorer" => "Explorer",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Albania" => "Albania",
// "Andorra" => "Andorra",
// "Anguilla" => "Anguilla",
// "Antarctica" => "Antarctica",
// "Aruba" => "Aruba",
// "Azerbaijan" => "Azerbaijan",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bhutan" => "Bhutan",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "Bulgaria" => "Bulgaria",
// "Burkina Faso" => "Burkina Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Cape Verde" => "Cape Verde",
// "Catalan Countries" => "Catalan Countries",
// "Central African Republic" => "Central African Republic",
// "Chad" => "Chad",
// "Christmas Island" => "Christmas Island",
// "Cocos Islands" => "Cocos Islands",
// "Comoros" => "Comoros",
// "Congo" => "Congo",
// "Congo Democratic" => "Congo Democratic",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Eritrea" => "Eritrea",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Faroe Islands" => "Faroe Islands",
// "French Guiana" => "French Guiana",
// "French Southern Territories" => "French Southern Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guernsey" => "Guernsey",
// "Guinea" => "Guinea",
// "Guinea Bissau" => "Guinea Bissau",
// "Guyana" => "Guyana",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Hong Kong" => "Hong Kong",
// "Isle of Man" => "Isle of Man",
// "Jersey" => "Jersey",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mayotte" => "Mayotte",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Netherlands Antilles" => "Netherlands Antilles",
// "Niger" => "Niger",
// "Norfolk Island" => "Norfolk Island",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "North Korea" => "North Korea",
// "Oman" => "Oman",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Reunion" => "Reunion",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "San Marino" => "San Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "Sudan" => "Sudan",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Swaziland" => "Swaziland",
// "Syria" => "Syria",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tunisia" => "Tunisia",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Uganda" => "Uganda",
// "United Nations Organization" => "United Nations Organization",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "US Virgin Islands" => "US Virgin Islands",
// "Uzbekistan" => "Uzbekistan",
// "Vatican" => "Vatican",
// "Viet Nam" => "Viet Nam",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Western Sahara" => "Western Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "Galician" => "Galician",
// "Pijin Solomon" => "Pijin Solomon",
// "Process %s %s imported" => "Process %s %s imported",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "file gallery" => "file gallery",
// "survey" => "survey",
// "Cannot write to this file: " => "Cannot write to this file: ",
// "(not registered)" => "(not registered)",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to:" => "Select a Wiki page to link to:",
// "Cannot open this file:" => "Cannot open this file:",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "Contributions" => "Contributions",
// "Query point:" => "Query point:",
// "layer:" => "layer:",
// "Record:" => "Record:",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it." => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it.",
// "menu" => "menu",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "section edit" => "section edit",
// "This poll is closed." => "This poll is closed.",
// "The passwords do not match" => "The passwords do not match",
// "Feed provided by %s. Click to visit." => "Feed provided by %s. Click to visit.",
// "Tracker item" => "Tracker item",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "Help page:" => "Help page:",
// "View tpl:" => "View tpl:",
// "Admin Feature" => "Admin Feature",
// "Invert Sort" => "Invert Sort",
// "sec" => "sec",
// "km" => "km",
// "Edit Section" => "Edit Section",
// "index" => "index",
// "You are not allowed to upload this type of file." => "You are not allowed to upload this type of file.",
// "The file you are trying upload was only partially uploaded." => "The file you are trying upload was only partially uploaded.",
// "You must select a file." => "You must select a file.",
// "Status:" => "Status:",
// "Upload was not successful. Duplicate file content ?" => "Upload was not successful. Duplicate file content ?",
// "(unchanged)" => "(unchanged)",
// "Field is not numeric" => "Field is not numeric",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "Textarea options: quicktags,width,height,max,listmax,wordmax - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax is the maximum number of characters that are displayed in list mode, wordmax>0 alert if word count exceeded, wordmax<0 display word count." => "Textarea options: quicktags,width,height,max,listmax,wordmax - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax is the maximum number of characters that are displayed in list mode, wordmax>0 alert if word count exceeded, wordmax<0 display word count.",
// "Default value is specified by having the value indicated twice consecutively" => "Default value is specified by having the value indicated twice consecutively",
// "drop down with other textfield" => "drop down with other textfield",
// "radio buttons" => "radio buttons",
// "Radio buttons options: list of items separated with commas." => "Radio buttons options: list of items separated with commas.",
// "User Selector options: automatic field feeding,email - feeding=1 for author login or feeding=2 for modificator login - email=1 to send an email to the user if the tracker is modified" => "User Selector options: automatic field feeding,email - feeding=1 for author login or feeding=2 for modificator login - email=1 to send an email to the user if the tracker is modified",
// "IP selector" => "IP selector",
// "IP Selector: use options for automatic field feeding : you can use 1 for author IP or 2 for modificator IP." => "IP Selector: use options for automatic field feeding : you can use 1 for author IP or 2 for modificator IP.",
// "Country Selector options: name/flag, sortorder - name/flag is 0,1 or 2 where 1 shows only country name, 2 shows only country flag, 0 shows both (default). sortorder is 0 or 1 where 0 sorts according to translated text (default) and 1 sorts according to english country names even if country names are translated" => "Country Selector options: name/flag, sortorder - name/flag is 0,1 or 2 where 1 shows only country name, 2 shows only country flag, 0 shows both (default). sortorder is 0 or 1 where 0 sorts according to translated text (default) and 1 sorts according to english country names even if country names are translated",
// "Date Time options: date_time,year0,year1 where date_time=d|dt(default), d displays only date, year0 is the first year, year1 the last" => "Date Time options: date_time,year0,year1 where date_time=d|dt(default), d displays only date, year0 is the first year, year1 the last",
// "Jscalendar options: date_time where date_time=d|dt(default), d displays only date" => "Jscalendar options: date_time where date_time=d|dt(default), d displays only date",
// "static text" => "static text",
// "Static text options: Wikisyntax,listmax - Use Wikisyntax is 1 or 0, listmax is the maximum number of characters that are displayed in list mode." => "Static text options: Wikisyntax,listmax - Use Wikisyntax is 1 or 0, listmax is the maximum number of characters that are displayed in list mode.",
// "Category options: parentId,d|m|radio|checkbox(default),1|0(default) to have a select all button, d for dropdown, m for multiple drop down" => "Category options: parentId,d|m|radio|checkbox(default),1|0(default) to have a select all button, d for dropdown, m for multiple drop down",
// "Item Link options: trackerId,fieldId,linkToItem,displayedfieldslist links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing.  Display displayedfieldslist(separate with |) instead of the target item" => "Item Link options: trackerId,fieldId,linkToItem,displayedfieldslist links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing.  Display displayedfieldslist(separate with |) instead of the target item",
// "dynamic items list" => "dynamic items list",
// "dynamic items list options: trackerId, filterFieldIdThere, filterFieldIdHere, listFieldIdThere, statusThere insert the list of listFieldIdThere from item in tracker trackerId where filterFieldIdThere matches filterFieldIdHere where status is statusThere." => "dynamic items list options: trackerId, filterFieldIdThere, filterFieldIdHere, listFieldIdThere, statusThere insert the list of listFieldIdThere from item in tracker trackerId where filterFieldIdThere matches filterFieldIdHere where status is statusThere.",
// "multimedia" => "multimedia",
// " 0|1|2|3|4|5 0,xsize,ysize. First record :0 for URL in file gal of MP3 only, 1 for URL of FLV in file gal video only , 2 for URL of MP3 or Video in file gal, 3 donwload MP3 only, 4 donwload FLV video only, 5 download FLV or MP3 (default is 0). Second record : X size of flash applet(default is 200) , Y size of flash applet (default is 100) " => " 0|1|2|3|4|5 0,xsize,ysize. First record :0 for URL in file gal of MP3 only, 1 for URL of FLV in file gal video only , 2 for URL of MP3 or Video in file gal, 3 donwload MP3 only, 4 donwload FLV video only, 5 download FLV or MP3 (default is 0). Second record : X size of flash applet(default is 200) , Y size of flash applet (default is 100) ",
// "auto-increment" => "auto-increment",
// "Sequential auto-increment number:initial_value,prepend,append,itemId: initial_value default is 1, prepend will be displayed before the field, append will be displayed just after, itemId will use the item Id" => "Sequential auto-increment number:initial_value,prepend,append,itemId: initial_value default is 1, prepend will be displayed before the field, append will be displayed just after, itemId will use the item Id",
// "user subscription" => "user subscription",
// "Allow registered user to subscribe to an item. They can add a number of friends." => "Allow registered user to subscribe to an item. They can add a number of friends.",
// "Use Google Maps." => "Use Google Maps.",
// "computed field" => "computed field",
// "Formula for computation, using # for indicating fields and +,*,/,- and parenthesis for operations." => "Formula for computation, using # for indicating fields and +,*,/,- and parenthesis for operations.",
// "user preference" => "user preference",
// "listview=nst, n to see name/t to see type/s to see type/u to see user in list mode" => "listview=nst, n to see name/t to see type/s to see type/u to see user in list mode",
// "Added:" => "Added:",
// "Removed:" => "Removed:",
// "Remaining:" => "Remaining:",
// "Old:" => "Old:",
// "New:" => "New:",
// "The administrator has not yet validated your account. Please wait." => "The administrator has not yet validated your account. Please wait.",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "Zip Code" => "Zip Code",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// " where Id is the blog Id and Items is the max number of posts to display" => " where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Lists files in a directory" => "Lists files in a directory",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Save changes to annotations" => "Save changes to annotations",
// "Creates an annotation block for an image." => "Creates an annotation block for an image.",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading." => "Id is optional. If not given, last article is used. Default field is heading.",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc)}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc)}{ARTICLES}~/np~",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description" => "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "equation" => "equation",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Formula" => "Formula",
// "No formula specified." => "No formula specified.",
// "Impossible to render the graphic." => "Impossible to render the graphic.",
// "View graphic" => "View graphic",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "List wiki pages." => "List wiki pages.",
// "Displays a map" => "Displays a map",
// "Displays a SWF myspace mp3 playlist on the wiki page" => "Displays a SWF myspace mp3 playlist on the wiki page",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "blogId is mandatory" => "blogId is mandatory",
// "Includes blog posts listing into a wiki page" => "Includes blog posts listing into a wiki page",
// "~np~{POSTS(max=>5, blogId=>id)}{POSTS}~/np~" => "~np~{POSTS(max=>5, blogId=>id)}{POSTS}~/np~",
// " wrote:" => " wrote:",
// "Quote:" => "Quote:",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect:" => "RSS Id incorrect:",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "Edit Sheet" => "Edit Sheet",
// "Clickable Skype link" => "Clickable Skype link",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Missing parameter" => "Missing parameter",
// "Incorrect param" => "Incorrect param",
// "Displays text in superscript." => "Displays text in superscript.",
// "Displays text between an html tag" => "Displays text between an html tag",
// "List top scoring users" => "List top scoring users",
// "Translate a string" => "Translate a string",
// "Incorrect fieldId:" => "Incorrect fieldId:",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Other:" => "Other:",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Filters the items of a tracker, fields are indicated with numeric ids." => "Filters the items of a tracker, fields are indicated with numeric ids.",
// "missing parameters" => "missing parameters",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Wiki text" => "Wiki text",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)." => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker).",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields." => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields.",
// "Displays some stat of a tracker content, fields are indicated with numeric ids." => "Displays some stat of a tracker content, fields are indicated with numeric ids.",
// "incorrect fieldId" => "incorrect fieldId",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored." => "A wildcard pattern of originating pages to be ignored.",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated." => "The character, by which ignored patterns are separated.",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list." => "Whether to include external wikis in the list.",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column." => "Collect either originating or wanted pages in a cell and display them in the second column.",
// "Switch-on debug output with details about the items." => "Switch-on debug output with details about the items.",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell." => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex." => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.",
// "A custom filter for wanted pages to be listed (only used when level=>custom)." => "A custom filter for wanted pages to be listed (only used when level=>custom).",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output." => "End of debug output.",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Sent box is full. Archive or delete some sent messages first if you want to send more messages.",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first." => "Archive is full. Delete some messages from archive first.",
// "list topics with links to the articles" => "list topics with links to the articles",
// "Article Topics" => "Article Topics",
// "Categorize %s in %s" => "Categorize %s in %s",
// "new posts" => "new posts",
// "new submissions" => "new submissions",
// "new tracker items" => "new tracker items",
// "new calendar events" => "new calendar events",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Admin live support system" => "Admin live support system",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Autovalidate suggestions" => "Autovalidate suggestions",
// "Can  receive tasks from other users" => "Can  receive tasks from other users",
// "Can abort a process instance" => "Can abort a process instance",
// "Can access site when closed" => "Can access site when closed",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can admin any mypage" => "Can admin any mypage",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can admin blogs" => "Can admin blogs",
// "Can admin categories" => "Can admin categories",
// "Can admin charts" => "Can admin charts",
// "Can admin contributions" => "Can admin contributions",
// "Can admin cookies" => "Can admin cookies",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Can admin drawings" => "Can admin drawings",
// "Can admin faqs" => "Can admin faqs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can admin forums" => "Can admin forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin games" => "Can admin games",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can admin newsletters" => "Can admin newsletters",
// "Can admin polls" => "Can admin polls",
// "Can admin public tasks" => "Can admin public tasks",
// "Can admin quicktags" => "Can admin quicktags",
// "Can admin quizzes" => "Can admin quizzes",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can admin rss modules" => "Can admin rss modules",
// "Can admin sheet" => "Can admin sheet",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can admin surveys" => "Can admin surveys",
// "Can admin the cms" => "Can admin the cms",
// "Can admin the directory" => "Can admin the directory",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can admin the wiki" => "Can admin the wiki",
// "Can admin trackers" => "Can admin trackers",
// "Can admin users" => "Can admin users",
// "Can admin workflow processes" => "Can admin workflow processes",
// "Can approve submissions" => "Can approve submissions",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can assign perms to mypage" => "Can assign perms to mypage",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Can ban users or ips" => "Can ban users or ips",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can browse freetags" => "Can browse freetags",
// "Can browse the calendar" => "Can browse the calendar",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can change tracker items" => "Can change tracker items",
// "Can clean cache" => "Can clean cache",
// "Can configure modules" => "Can configure modules",
// "Can create a blog" => "Can create a blog",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can create and edit structures" => "Can create and edit structures",
// "Can create file galleries" => "Can create file galleries",
// "Can create image galleries" => "Can create image galleries",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can create new mapfile" => "Can create new mapfile",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can declare an instance as exception" => "Can declare an instance as exception",
// "Can delete comments" => "Can delete comments",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can edit all comments" => "Can edit all comments",
// "Can edit any mypage" => "Can edit any mypage",
// "Can edit articles" => "Can edit articles",
// "Can edit content templates" => "Can edit content templates",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit drawings" => "Can edit drawings",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can edit items in categories" => "Can edit items in categories",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit object permissions" => "Can edit object permissions",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can edit pages" => "Can edit pages",
// "Can edit site templates" => "Can edit site templates",
// "Can edit submissions" => "Can edit submissions",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can execute workflow activities" => "Can execute workflow activities",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can list file galleries" => "Can list file galleries",
// "Can list image galleries" => "Can list image galleries",
// "Can list mypages" => "Can list mypages",
// "Can list registered users" => "Can list registered users",
// "Can list trackers" => "Can list trackers",
// "Can lock pages" => "Can lock pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can play games" => "Can play games",
// "Can post in forums" => "Can post in forums",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can post new comments" => "Can post new comments",
// "Can post to a blog" => "Can post to a blog",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can read article headings" => "Can read article headings",
// "Can read articles" => "Can read articles",
// "Can read blogs" => "Can read blogs",
// "Can read comments" => "Can read comments",
// "Can read forums" => "Can read forums",
// "Can remove" => "Can remove",
// "Can remove articles" => "Can remove articles",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can remove submissions" => "Can remove submissions",
// "Can rename pages" => "Can rename pages",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can rollback pages" => "Can rollback pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can search" => "Can search",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send instances after completion" => "Can send instances after completion",
// "Can send newsletters" => "Can send newsletters",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can start threads in forums" => "Can start threads in forums",
// "Can submit articles" => "Can submit articles",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can suggest items" => "Can suggest items",
// "Can tag objects" => "Can tag objects",
// "Can take quizzes" => "Can take quizzes",
// "Can take surveys" => "Can take surveys",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload files" => "Can upload files",
// "Can upload images" => "Can upload images",
// "Can upload personal files" => "Can upload personal files",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can use content templates" => "Can use content templates",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can use Directoy Batch Load" => "Can use Directoy Batch Load",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can use live support system" => "Can use live support system",
// "Can use tasks" => "Can use tasks",
// "Can use the chat system" => "Can use the chat system",
// "Can use the directory" => "Can use the directory",
// "Can use the messaging system" => "Can use the messaging system",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the newsreader" => "Can use the newsreader",
// "Can use the notepad" => "Can use the notepad",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can use webmail" => "Can use webmail",
// "Can validate submited links" => "Can validate submited links",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view any mypage" => "Can view any mypage",
// "Can view categories" => "Can view categories",
// "Can view categorized items" => "Can view categorized items",
// "Can view charts" => "Can view charts",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can view events details" => "Can view events details",
// "Can view faqs" => "Can view faqs",
// "Can view file galleries" => "Can view file galleries",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view HTML pages" => "Can view HTML pages",
// "Can view image galleries" => "Can view image galleries",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view page/pages" => "Can view page/pages",
// "Can view poll results" => "Can view poll results",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can view referer stats" => "Can view referer stats",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can view shoutbox" => "Can view shoutbox",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can view survey stats" => "Can view survey stats",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can view user quiz results" => "Can view user quiz results",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view/edit only one's own mypages" => "Can view/edit only one's own mypages",
// "Can vote" => "Can vote",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can vote comments" => "Can vote comments",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can vote polls" => "Can vote polls",
// "Can watch structure" => "Can watch structure",
// "Can watch tracker" => "Can watch tracker",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Submited links are valid" => "Submited links are valid",
// "Watched by categories" => "Watched by categories",
// "Hold down CTRL to select multiple categories" => "Hold down CTRL to select multiple categories",
// "Uncheck the above checkbox to uncategorize this page/object" => "Uncheck the above checkbox to uncategorize this page/object",
// "posts:" => "posts:",
// "top of page" => "top of page",
// "Report this post" => "Report this post",
// "Post new message" => "Post new message",
// "Enter your name" => "Enter your name",
// "Post as Anonymous" => "Post as Anonymous",
// "Type of contribution:" => "Type of contribution:",
// "Contributors" => "Contributors",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate perms" => "Duplicate perms",
// "View inserted gallery" => "View inserted gallery",
// "Display Properties" => "Display Properties",
// "required field for podcasts" => "required field for podcasts",
// "any file" => "any file",
// "podcast (audio)" => "podcast (audio)",
// "podcast (video)" => "podcast (video)",
// "This Gallery is Public" => "This Gallery is Public",
// "The files can be locked at download:" => "The files can be locked at download:",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "Perhaps you were looking for:" => "Perhaps you were looking for:",
// "You are not logged in." => "You are not logged in.",
// "Go to Login Page" => "Go to Login Page",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Both" => "Both",
// "Show an icon in a column" => "Show an icon in a column",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "any category" => "any category",
// "Show php error messages" => "Show php error messages",
// "Last update from SVN" => "Last update from SVN",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together." => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together.",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "Edit this page!" => "Edit this page!",
// "RSS Calendars" => "RSS Calendars",
// "Loading" => "Loading",
// "\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076C\\074/span\\076lose",
// "\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076N\\074/span\\076ext",
// "\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076revious",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Fullscreen" => "Fullscreen",
// "Information" => "Information",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Are you sure you want to delete the selected files?" => "Are you sure you want to delete the selected files?",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link:" => "To validate your account and login to the site, please click on the following link:",
// "The administrator approved your account." => "The administrator approved your account.",
// "Confirm your email at %s" => "Confirm your email at %s",
// "Author:" => "Author:",
// "Contribution" => "Contribution",
// "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now.",
// "To login with your username and password, please follow this link:" => "To login with your username and password, please follow this link:",
// "Tiki User Account Activated" => "Tiki User Account Activated",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in.",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above." => "Important: The old password remains active if you don't click the link above.",
// "Look at this link:" => "Look at this link:",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "Download the file at:" => "Download the file at:",
// "Tracker was modified at" => "Tracker was modified at",
// "Please visit this link before login again:" => "Please visit this link before login again:",
// "Confirm your account at %s" => "Confirm your account at %s",
// "You'll receive email notification once your account is activated." => "You'll receive email notification once your account is activated.",
// "Please do not attempt to login until you receive the email notification." => "Please do not attempt to login until you receive the email notification.",
// "View item calendar at:" => "View item calendar at:",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "Removed by" => "Removed by",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "Old" => "Old",
// "updated" => "updated",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}:" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}:",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "Object type" => "Object type",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure:" => "A page has been added to your watched sub-structure:",
// "A page has been removed from your watched sub-structure:" => "A page has been removed from your watched sub-structure:",
// "A page has been promoted out your watched sub-structure:" => "A page has been promoted out your watched sub-structure:",
// "A page has been demoted to your watched structure:" => "A page has been demoted to your watched structure:",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The changes in this version follow below, followed after by the current full page text." => "The changes in this version follow below, followed after by the current full page text.",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for your registration. You may log in now." => "Thank you for your registration. You may log in now.",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Zoom out" => "Zoom out",
// "Zoom in" => "Zoom in",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "from the mapfile:" => "from the mapfile:",
// "Archive is full!" => "Archive is full!",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences." => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences.",
// "ERROR" => "ERROR",
// "Separate multiple usernames with a comma (&nbsp;,&nbsp;)." => "Separate multiple usernames with a comma (&nbsp;,&nbsp;).",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Mailbox is full! Delete or archive some messages if you want to receive more messages.",
// "is reply to" => "is reply to",
// "Auto-archive age for read messages:" => "Auto-archive age for read messages:",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "\$tpl_module_title" => "\$tpl_module_title",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number !" => "You forgot your Google ad_client number !",
// "New article" => "New article",
// "Debugger console" => "Debugger console",
// "\$module_title" => "\$module_title",
// "More..." => "More...",
// "To configure your Tiki" => "To configure your Tiki",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as the Admin" => "as the Admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://www.tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://www.tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://www.tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://www.tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "Last `\$module_rows` blog comments" => "Last `\$module_rows` blog comments",
// "Last blog comments" => "Last blog comments",
// " on blogpost " => " on blogpost ",
// "\$modcattitle" => "\$modcattitle",
// "Folksonomy" => "Folksonomy",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "More Like This" => "More Like This",
// "Most popular tags" => "Most popular tags",
// "List everything tagged" => "List everything tagged",
// "My prefered tags" => "My prefered tags",
// "\$type" => "\$type",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "more" => "more",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "No avatar." => "No avatar.",
// "You" => "You",
// "Logged in as" => "Logged in as",
// "Switch User" => "Switch User",
// "applicable for this item" => "applicable for this item",
// "Switch user" => "Switch user",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID?" => "What is OpenID?",
// "Random Images" => "Random Images",
// "RSS Feeds" => "RSS Feeds",
// "Calendars" => "Calendars",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "`\$slvn_info.label`" => "`\$slvn_info.label`",
// "Nothing has changed" => "Nothing has changed",
// "click to show/hide" => "click to show/hide",
// "Site Language:" => "Site Language:",
// "Site default" => "Site default",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Page translation" => "Page translation",
// "There are no translations of this page." => "There are no translations of this page.",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages." => "Set your preferred languages.",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "The Next Event" => "The Next Event",
// "No Upcoming Events" => "No Upcoming Events",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "More" => "More",
// "on host" => "on host",
// " on page " => " on page ",
// "Changes that need to be reproduced are highlighted below." => "Changes that need to be reproduced are highlighted below.",
// "Click to see the ratings" => "Click to see the ratings",
// "[-]" => "[-]",
// "Errors" => "Errors",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "page id" => "page id",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Page last modified on" => "Page last modified on",
// "Contributors to this page" => "Contributors to this page",
// "Created by:" => "Created by:",
// "Last Modification:" => "Last Modification:",
// "For" => "For",
// "Jump to Content" => "Jump to Content",
// "Report to Webmaster" => "Report to Webmaster",
// "database queries used in " => "database queries used in ",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "Show/Hide Left Menus" => "Show/Hide Left Menus",
// "Show/Hide Right Menus" => "Show/Hide Right Menus",
// "Email this page" => "Email this page",
// "{|} Files Attached" => "{|} Files Attached",
// "RSS Trackers" => "RSS Trackers",
// "Note: if you want to use images please save the post first and you\n\twill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\n\tor use the image URL to include images using the WYSIWYG editor. " => "Note: if you want to use images please save the post first and you\n\twill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\n\tor use the image URL to include images using the WYSIWYG editor. ",
// "Show/Hide Left Modules" => "Show/Hide Left Modules",
// "Show/Hide Right Modules" => "Show/Hide Right Modules",
// "Design by" => "Design by",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Calendar View" => "Calendar View",
// "Tiki Action Calendar" => "Tiki Action Calendar",
// "Apply" => "Apply",
// "Reset" => "Reset",
// "Test" => "Test",
// "Freetags" => "Freetags",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Look &amp; Feel" => "Look &amp; Feel",
// "Text area" => "Text area",
// "Multimedia" => "Multimedia",
// "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or",
// "Blogs have a custom heading" => "Blogs have a custom heading",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Title length" => "Title length",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Default view mode" => "Default view mode",
// "Week" => "Week",
// "Month" => "Month",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "First day of the week" => "First day of the week",
// "Depends user language" => "Depends user language",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "First year in the dropdown, either year number, or relative to current year (+/- N)" => "First year in the dropdown, either year number, or relative to current year (+/- N)",
// "if no jscalendar" => "if no jscalendar",
// "Last year in the dropdown, either year number, or relative to current year (+/- N)" => "Last year in the dropdown, either year number, or relative to current year (+/- N)",
// "Use categories to regroup various Tiki objects" => "Use categories to regroup various Tiki objects",
// "Link to" => "Link to",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Exclude These Category IDs from Path (comma delimited)" => "Exclude These Category IDs from Path (comma delimited)",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Categories browse uses PhpLayers" => "Categories browse uses PhpLayers",
// "The feature must be activated" => "The feature must be activated",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Can specify notification emails when creating an article" => "Can specify notification emails when creating an article",
// "Users sort order" => "Users sort order",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "Enable Feature for Wiki" => "Enable Feature for Wiki",
// "Enable Feature for Articles" => "Enable Feature for Articles",
// "Enable Feature for Blogues" => "Enable Feature for Blogues",
// "Enable Feature for Faqs" => "Enable Feature for Faqs",
// "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or",
// "Show Country Flag" => "Show Country Flag",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site." => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site.",
// "No tabs" => "No tabs",
// "Main" => "Main",
// "Global Features" => "Global Features",
// "More Functionality" => "More Functionality",
// "Technology" => "Technology",
// "UI Enhancements" => "UI Enhancements",
// "Extra Stuff &amp; Fun" => "Extra Stuff &amp; Fun",
// "Content Related" => "Content Related",
// "Main Features" => "Main Features",
// "Site Global Features" => "Site Global Features",
// "Action Log" => "Action Log",
// "Action log setting" => "Action log setting",
// "Feature documentation links" => "Feature documentation links",
// "Help System (Feature documentation links)" => "Help System (Feature documentation links)",
// "Additional Features" => "Additional Features",
// "Copyright System" => "Copyright System",
// "Copyright system" => "Copyright system",
// "Tell a Friend" => "Tell a Friend",
// "Allow to post comments as Anonymous" => "Allow to post comments as Anonymous",
// "Technical Features" => "Technical Features",
// "Search engine friendly url" => "Search engine friendly url",
// "Swffix" => "Swffix",
// "Ajax" => "Ajax",
// "HTML Purifier" => "HTML Purifier",
// "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)",
// "User interface enhancement features" => "User interface enhancement features",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "required" => "required",
// "Mootools" => "Mootools",
// "Experimental Features" => "Experimental Features",
// "Friendship" => "Friendship",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Use File Galleries for images inclusion" => "Use File Galleries for images inclusion",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Action Calendar" => "Action Calendar",
// "Tiki action calendar" => "Tiki action calendar",
// "TikiTests" => "TikiTests",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "User Contacts" => "User Contacts",
// "User Levels" => "User Levels",
// "To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "To add/remove file galleries, go to \"File Galleries\" on the application menu, or",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory.",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Allow download limit per file" => "Allow download limit per file",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "File author" => "File author",
// "For not registered author" => "For not registered author",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "The server must be able to read/write the directory." => "The server must be able to read/write the directory.",
// "The directory can be outside the web space." => "The directory can be outside the web space.",
// "PodCast directory (must be web accessible):" => "PodCast directory (must be web accessible):",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory." => "The server must be able to read the directory.",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Enable topics archiving" => "Enable topics archiving",
// "Allow first posts of a thread to have an empty body (will be a thread title)" => "Allow first posts of a thread to have an empty body (will be a thread title)",
// "Reply posts are empty" => "Reply posts are empty",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Search some forums by name (on \"forum list\")" => "Search some forums by name (on \"forum list\")",
// "Search some forums by content on \"forum list\" (needs feature_search activated)" => "Search some forums by content on \"forum list\" (needs feature_search activated)",
// "Search in topics content on forum page (needs feature_search activated)" => "Search in topics content on forum page (needs feature_search activated)",
// "Search method when searching in content: Tiki search local to a forum" => "Search method when searching in content: Tiki search local to a forum",
// "Search method when searching in content: Non-Tiki search local to a forum" => "Search method when searching in content: Non-Tiki search local to a forum",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "Threads default preferences" => "Threads default preferences",
// "Allow to manage thread defaults in each forum configuration" => "Allow to manage thread defaults in each forum configuration",
// "Display thread configuration bar to override defaults" => "Display thread configuration bar to override defaults",
// "Configuration bar settings are kept for all forums during the user session:" => "Configuration bar settings are kept for all forums during the user session:",
// "Default thread style" => "Default thread style",
// "Default thread sort mode" => "Default thread sort mode",
// "Freetags rock!" => "Freetags rock!",
// "Freetag Browsing" => "Freetag Browsing",
// "Show Tag Cloud" => "Show Tag Cloud",
// "Random tag cloud colors (separated by comma)" => "Random tag cloud colors (separated by comma)",
// "Preload freetag random search when arriving on <a href=\"tiki-browse_freetags.php\">freetag search grid</a>" => "Preload freetag random search when arriving on <a href=\"tiki-browse_freetags.php\">freetag search grid</a>",
// "Number of Tags to show in Cloud" => "Number of Tags to show in Cloud",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Only accept alphanumeric ASCII freetags (no accents or special chars)" => "Only accept alphanumeric ASCII freetags (no accents or special chars)",
// "Accept all" => "Accept all",
// "Only accept lowercase freetags" => "Only accept lowercase freetags",
// "Handle multilingual freetags" => "Handle multilingual freetags",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "cleanup" => "cleanup",
// "More Like This/Get Similar Module" => "More Like This/Get Similar Module",
// "More Like This algorithm" => "More Like This algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Basic algorithm - Minimum amount of tags in common" => "Basic algorithm - Minimum amount of tags in common",
// "6" => "6",
// "7" => "7",
// "8" => "8",
// "9" => "9",
// "Freetag 3D Browser Configuration" => "Freetag 3D Browser Configuration",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Graph appearance" => "Graph appearance",
// "Node color" => "Node color",
// "Camera settings" => "Camera settings",
// "Physics engine" => "Physics engine",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below." => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below.",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Default scale size" => "Default scale size",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Tikiwiki version" => "Tikiwiki version",
// "PHP error reporting level:" => "PHP error reporting level:",
// "visible to admin only" => "visible to admin only",
// "smarty notice reporting" => "smarty notice reporting",
// "Log Mail in Tiki Logs:" => "Log Mail in Tiki Logs:",
// "Log SQL:" => "Log SQL:",
// "Please expect not found help-pages with the default-URL." => "Please expect not found help-pages with the default-URL.",
// "Any help with the documentation is welcome." => "Any help with the documentation is welcome.",
// "Release check" => "Release check",
// "Check frequency" => "Check frequency",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "Release checks are made when you browse admin main page only" => "Release checks are made when you browse admin main page only",
// "Force immediate check" => "Force immediate check",
// "Default timezone" => "Default timezone",
// "Fields display order" => "Fields display order",
// "When possible, show the real user name instead of login:" => "When possible, show the real user name instead of login:",
// "Examples" => "Examples",
// "Choices separator" => "Choices separator",
// "Preference syntax" => "Preference syntax",
// "Google Map setup" => "Google Map setup",
// "Default Language" => "Default Language",
// "Multilingual structures" => "Multilingual structures",
// "Show pages in user's preferred language" => "Show pages in user's preferred language",
// "Restrict supported languages" => "Restrict supported languages",
// "Available languages (Ctrl+Click to select multiple languages):" => "Available languages (Ctrl+Click to select multiple languages):",
// "Quantify change size" => "Quantify change size",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// " as master" => " as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "Known hosts" => "Known hosts",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Wysiwyg" => "Wysiwyg",
// "Text Area" => "Text Area",
// "Shibboleth" => "Shibboleth",
// "OpenID and Tiki" => "OpenID and Tiki",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>",
// "Create a group for each user <br />(with the same name as the user)" => "Create a group for each user <br />(with the same name as the user)",
// " - Php GD library required" => " - Php GD library required",
// "Use login as email" => "Use login as email",
// "Validate user email server" => "Validate user email server",
// "Crypt passwords method" => "Crypt passwords method",
// "tikihash (old)" => "tikihash (old)",
// "Minimum username length" => "Minimum username length",
// "Maximum username length" => "Maximum username length",
// "Force lowercase username" => "Force lowercase username",
// "-1 for never" => "-1 for never",
// "Re-validate user by email after days" => "Re-validate user by email after days",
// "Re-validate user by email after unsuccessful logins" => "Re-validate user by email after unsuccessful logins",
// "Generate a password option" => "Generate a password option",
// "HTTPS login" => "HTTPS login",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are in always in HTTPS, but do not check" => "Consider we are in always in HTTPS, but do not check",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "User's choice" => "User's choice",
// "Always" => "Always",
// "User can choose beyond these groups at registration time" => "User can choose beyond these groups at registration time",
// "Specify the fields that will be asked in admin->groups" => "Specify the fields that will be asked in admin->groups",
// "Displays user's contribution in the user information page" => "Displays user's contribution in the user information page",
// "Displays UserTracker information in user information page. Format: trackerId, fieldId1, fieldId2, …" => "Displays UserTracker information in user information page. Format: trackerId, fieldId1, fieldId2, …",
// "Deactivate login autocomplete (do not remember login and password)" => "Deactivate login autocomplete (do not remember login and password)",
// "On permission denied, display login box for anonymous:" => "On permission denied, display login box for anonymous:",
// "On permission denied, send to this url:" => "On permission denied, send to this url:",
// "LDAP Version" => "LDAP Version",
// "LDAP Realname Attribute" => "LDAP Realname Attribute",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/.",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "Valid Affiliations (separated by commas)" => "Valid Affiliations (separated by commas)",
// "Create with default group?" => "Create with default group?",
// "Default group: " => "Default group: ",
// "Change Shibboleth preferences" => "Change Shibboleth preferences",
// "Users Defaults" => "Users Defaults",
// "Users Default Preferences" => "Users Default Preferences",
// "default" => "default",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "Change users defaults" => "Change users defaults",
// "General Layout" => "General Layout",
// "Use transition style sheet from version" => "Use transition style sheet from version",
// "Never use transition css" => "Never use transition css",
// "Use @version:x.x specified in theme css or none if not specified" => "Use @version:x.x specified in theme css or none if not specified",
// "Use @version:x.x specified in theme css or 1.8 if not specified" => "Use @version:x.x specified in theme css or 1.8 if not specified",
// "Use @version:x.x specified in theme css or 1.9 if not specified" => "Use @version:x.x specified in theme css or 1.9 if not specified",
// "Required for all the following features" => "Required for all the following features",
// "Custom Site Header" => "Custom Site Header",
// "Site logo source (image path)" => "Site logo source (image path)",
// "Site logo background style" => "Site logo background style",
// "Site logo alignment" => "Site logo alignment",
// "on left side" => "on left side",
// "on center" => "on center",
// "on right side" => "on right side",
// "Site Search Bar" => "Site Search Bar",
// "Site Login Bar" => "Site Login Bar",
// "Top Bar" => "Top Bar",
// "Note: This feature also requires PHPLayers to be turned on in " => "Note: This feature also requires PHPLayers to be turned on in ",
// "Menu ID" => "Menu ID",
// "Users can Flip Columns" => "Users can Flip Columns",
// "Prefix breadcrumbs with 'Location : ' " => "Prefix breadcrumbs with 'Location : ' ",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Left blank to use the default sender email" => "Left blank to use the default sender email",
// "Custom Site Footer" => "Custom Site Footer",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item:" => "Max. number of links around the current item:",
// "Max. number of links after the first or before the last item:" => "Max. number of links after the first or before the last item:",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Use Icons" => "Use Icons",
// "Other options" => "Other options",
// "Use context menus for actions (icons) (only in file galleries yet)" => "Use context menus for actions (icons) (only in file galleries yet)",
// "Use context menus for actions (text) (only in file galleries yet)" => "Use context menus for actions (text) (only in file galleries yet)",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Insert freetags in keyword list" => "Insert freetags in keyword list",
// "Use the thread title in Forum pages instead" => "Use the thread title in Forum pages instead",
// "Use the image title in Image gallery pages instead" => "Use the image title in Image gallery pages instead",
// "Right &amp; left boxes" => "Right &amp; left boxes",
// "Administer modules" => "Administer modules",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Lenght" => "Flash Lenght",
// "Flash Heigth" => "Flash Heigth",
// "Video Lenght" => "Video Lenght",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Show categories" => "Show categories",
// "Show objects" => "Show objects",
// "Tikiwiki Profiles" => "Tikiwiki Profiles",
// "Configuration" => "Configuration",
// "Profile repositories" => "Profile repositories",
// "Profiles can be installed from multiple repositories. Enter one repository URL per line." => "Profiles can be installed from multiple repositories. Enter one repository URL per line.",
// "Profile repository status" => "Profile repository status",
// "Profile list" => "Profile list",
// "Repository" => "Repository",
// "Profile" => "Profile",
// "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS modules</strong> menu option, or" => "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS modules</strong> menu option, or",
// "Feed for articles" => "Feed for articles",
// "Feature is disabled." => "Feature is disabled.",
// "Enable now" => "Enable now",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Feed for maps" => "Feed for maps",
// "Map files" => "Map files",
// "Defaults" => "Defaults",
// "Image Path" => "Image Path",
// "Caching time:" => "Caching time:",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public." => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public.",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Parse the result (can be slow)" => "Parse the result (can be slow)",
// "Database Search using MySQL 'Full-Text' Feature" => "Database Search using MySQL 'Full-Text' Feature",
// "Activate MySQL Full-Text feature" => "Activate MySQL Full-Text feature",
// "Activate MySQL 'Full-Text' feature" => "Activate MySQL 'Full-Text' feature",
// "Database Independent Full Text Search or Tiki Search" => "Database Independent Full Text Search or Tiki Search",
// "This is activated by default if MySQL 'Full-Text' feature is not activated above" => "This is activated by default if MySQL 'Full-Text' feature is not activated above",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "Search refresh mode" => "Search refresh mode",
// "0 for no refresh" => "0 for no refresh",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Show quicktags over textareas (instead on left side)" => "Show quicktags over textareas (instead on left side)",
// "Default number of rows (wiki)" => "Default number of rows (wiki)",
// "Default number of rows (comments)" => "Default number of rows (comments)",
// "Default number of rows (forum)" => "Default number of rows (forum)",
// "Default number of rows (forum replies)" => "Default number of rows (forum replies)",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "No records" => "No records",
// "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or",
// "Tag name:" => "Tag name:",
// "Default number of comments per page:" => "Default number of comments per page:",
// "List displayed by default" => "List displayed by default",
// "Wiki attachments:" => "Wiki attachments:",
// "Use database to store files:" => "Use database to store files:",
// "Use a directory to store files:" => "Use a directory to store files:",
// "Path:" => "Path:",
// "Manage attachments" => "Manage attachments",
// "Forums are disabled." => "Forums are disabled.",
// "Forum for discussion:" => "Forum for discussion:",
// "No forums" => "No forums",
// "Page name display stripper: choose a character that will be used as a delimiter to strip a final part of the page name (only concerns display)" => "Page name display stripper: choose a character that will be used as a delimiter to strip a final part of the page name (only concerns display)",
// "Wiki Page Staging and Approval" => "Wiki Page Staging and Approval",
// "Use wiki page staging and approval:" => "Use wiki page staging and approval:",
// "Unique page name prefix to indicate staging copy:" => "Unique page name prefix to indicate staging copy:",
// "Hide page name prefix:" => "Hide page name prefix:",
// "Category for staging pages:" => "Category for staging pages:",
// "Category for approved pages:" => "Category for approved pages:",
// "Category for pages out of sync:" => "Category for pages out of sync:",
// "Force bounce of editing of approved pages to staging:" => "Force bounce of editing of approved pages to staging:",
// "Categorize approved pages with categories of staging copy on approval:" => "Categorize approved pages with categories of staging copy on approval:",
// "Replace freetags with that of staging pages on approval:" => "Replace freetags with that of staging pages on approval:",
// "Add new freetags of approved copy (into tags field) when editing staging pages:" => "Add new freetags of approved copy (into tags field) when editing staging pages:",
// "Delete staging pages at approval:" => "Delete staging pages at approval:",
// "If not in the group, edit is always redirected to the staging page edit:" => "If not in the group, edit is always redirected to the staging page edit:",
// "Wiki Page List Configuration" => "Wiki Page List Configuration",
// "Name length:" => "Name length:",
// "Comment length:" => "Comment length:",
// "Description length:" => "Description length:",
// "Categories path" => "Categories path",
// "Default sort order:" => "Default sort order:",
// "Enable wiki 3D browser:" => "Enable wiki 3D browser:",
// "Load page on navigation:" => "Load page on navigation:",
// "Browser width:" => "Browser width:",
// "Browser height:" => "Browser height:",
// "Navigation depth:" => "Navigation depth:",
// "Node size:" => "Node size:",
// "Text size:" => "Text size:",
// "Spring (connection) size:" => "Spring (connection) size:",
// "Existing page node color:" => "Existing page node color:",
// "Missing page node color:" => "Missing page node color:",
// "Camera distance adjusted relative to nearest node:" => "Camera distance adjusted relative to nearest node:",
// "Camera distance:" => "Camera distance:",
// "Field of view:" => "Field of view:",
// "Feed animation interval (milisecs):" => "Feed animation interval (milisecs):",
// "Friction constant:" => "Friction constant:",
// "Elastic constant:" => "Elastic constant:",
// "Eletrostatic constant:" => "Eletrostatic constant:",
// "Node mass:" => "Node mass:",
// "Node charge:" => "Node charge:",
// "Sandbox:" => "Sandbox:",
// "Anonymous editors must input anti-bot code:" => "Anonymous editors must input anti-bot code:",
// "Last changes:" => "Last changes:",
// "Dump:" => "Dump:",
// "Export:" => "Export:",
// "Rating:" => "Rating:",
// "History:" => "History:",
// "View source:" => "View source:",
// "List pages:" => "List pages:",
// "Backlinks:" => "Backlinks:",
// "Similar:" => "Similar:",
// "Rankings:" => "Rankings:",
// "Undo:" => "Undo:",
// "Save Draft:" => "Save Draft:",
// "MultiPrint:" => "MultiPrint:",
// "Comments:" => "Comments:",
// "Spellchecking:" => "Spellchecking:",
// "Use templates:" => "Use templates:",
// "Warn on edit conflict:" => "Warn on edit conflict:",
// "Edit idle timeout:" => "Edit idle timeout:",
// "Pictures:" => "Pictures:",
// "Show page title:" => "Show page title:",
// "Show page ID:" => "Show page ID:",
// "Cache wiki pages (global):" => "Cache wiki pages (global):",
// "Individual cache:" => "Individual cache:",
// "Footnotes:" => "Footnotes:",
// "Users can lock pages (if perm):" => "Users can lock pages (if perm):",
// "Use WikiWords:" => "Use WikiWords:",
// "Accept dashes and underscores in WikiWords:" => "Accept dashes and underscores in WikiWords:",
// "Link plural WikiWords to their singular forms:" => "Link plural WikiWords to their singular forms:",
// "Use Wiki paragraph formatting:" => "Use Wiki paragraph formatting:",
// "But still create line breaks within paragraphs:" => "But still create line breaks within paragraphs:",
// "Automonospaced text:" => "Automonospaced text:",
// "Tables syntax:" => "Tables syntax:",
// "Uses Slideshow:" => "Uses Slideshow:",
// "Open page as structure:" => "Open page as structure:",
// "Make structure from page:" => "Make structure from page:",
// "Categorize structure pages together:" => "Categorize structure pages together:",
// "Create webhelp from structure:" => "Create webhelp from structure:",
// "Use external link icons:" => "Use external link icons:",
// "User's Page:" => "User's Page:",
// "UserPage prefix:" => "UserPage prefix:",
// "Page creators are admin of their pages:" => "Page creators are admin of their pages:",
// "Import HTML:" => "Import HTML:",
// "Import Page:" => "Import Page:",
// "Protect email against spam:" => "Protect email against spam:",
// "When viewing a page, if it doesn't exist and has one like page, automatic redirection to this like page:" => "When viewing a page, if it doesn't exist and has one like page, automatic redirection to this like page:",
// "Show/hide heading icon displayed before the heading:" => "Show/hide heading icon displayed before the heading:",
// "Force and limit categorization to within subtree of:" => "Force and limit categorization to within subtree of:",
// "Print Page:" => "Print Page:",
// "Allow HTML:" => "Allow HTML:",
// "Show page version:" => "Show page version:",
// "Page navigation bar position (displayed when page break '...page...' are used):" => "Page navigation bar position (displayed when page break '...page...' are used):",
// "Wiki actions bar position (e.g. Save, Preview, Cancel, ...):" => "Wiki actions bar position (e.g. Save, Preview, Cancel, ...):",
// "Regex search and replace:" => "Regex search and replace:",
// "Edit section:" => "Edit section:",
// "Log bytes changes (+/-) in Action Logs (slows each page modifications)" => "Log bytes changes (+/-) in Action Logs (slows each page modifications)",
// "Maximum number of versions for history:" => "Maximum number of versions for history:",
// "Never delete versions younger than days:" => "Never delete versions younger than days:",
// "IP address displayed in history:" => "IP address displayed in history:",
// "Diff style:" => "Diff style:",
// "History only for data, description, comment change" => "History only for data, description, comment change",
// "Create watch for author on page creation:" => "Create watch for author on page creation:",
// "Enable watch events when I am the editor:" => "Enable watch events when I am the editor:",
// "Enable watches on comments:" => "Enable watches on comments:",
// "Watch minor:" => "Watch minor:",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Toolbar content" => "Toolbar content",
// "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>." => "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>.",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "More Links" => "More Links",
// "Mods" => "Mods",
// "Report" => "Report",
// "Please select some actions to view." => "Please select some actions to view.",
// "Group:" => "Group:",
// "Category:" => "Category:",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot:" => "Group Bar Plot:",
// "Accumulated Bar Plot:" => "Accumulated Bar Plot:",
// "Background color:" => "Background color:",
// "Legend background color:" => "Legend background color:",
// "Save graphs to image gallery:" => "Save graphs to image gallery:",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Contribution" => "Edit Contribution",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Help on Banning System" => "Help on Banning System",
// "Custom URL" => "Custom URL",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Custom foreground color" => "Custom foreground color",
// "Custom background color" => "Custom background color",
// "Delete events older than:" => "Delete events older than:",
// "browse the category system" => "browse the category system",
// "Current Category ID:" => "Current Category ID:",
// "Edit permissions for this category" => "Edit permissions for this category",
// "Remove from this Category" => "Remove from this Category",
// "Use in" => "Use in",
// "No features are configured to use templates." => "No features are configured to use templates.",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution:" => "Edit the contribution:",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "Admin FortuneCookie tpl" => "Admin FortuneCookie tpl",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}.",
// "Help on Drawings" => "Help on Drawings",
// "Admin Drawings tpl" => "Admin Drawings tpl",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link.",
// "Use Admin DSN to define the database to be used by the SQL plugin." => "Use Admin DSN to define the database to be used by the SQL plugin.",
// "Admin External Wikis" => "Admin External Wikis",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Max:" => "Max:",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "show threads preferences" => "show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate" => "Duplicate",
// "List Forums" => "List Forums",
// "..." => "...",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Admin Html Pages" => "Admin Html Pages",
// "Admin Html Pages Template" => "Admin Html Pages Template",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "Tiki integrator" => "Tiki integrator",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature.",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.",
// "For wiki page, use ((PageName))." => "For wiki page, use ((PageName)).",
// "Separate multiple sections with a comma ( , )." => "Separate multiple sections with a comma ( , ).",
// "Separate multiple permissions with a comma ( , )." => "Separate multiple permissions with a comma ( , ).",
// "Use Ctrl+Click to select multiple groups." => "Use Ctrl+Click to select multiple groups.",
// "Level" => "Level",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "Number of lines" => "Number of lines",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'." => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'.",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu." => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu.",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format: " => "To use a menu in a tiki format: ",
// "To use menu in a css/suckerfish format: " => "To use menu in a css/suckerfish format: ",
// "Path to the folder icon for close sections" => "Path to the folder icon for close sections",
// "Example:" => "Example:",
// "Provide also a folder icon for open sections with the same name with the letter 'o' before in the same directory (ex: folder.png and ofolder.png)" => "Provide also a folder icon for open sections with the same name with the letter 'o' before in the same directory (ex: folder.png and ofolder.png)",
// "Default:" => "Default:",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme'). Separator between params:'&'. E.g. maxlen=15&nonums=y." => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme'). Separator between params:'&'. E.g. maxlen=15&nonums=y.",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups." => "setting will override your selection of specific groups.",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// " or " => " or ",
// "to make sure users will notice any newly assigned modules." => "to make sure users will notice any newly assigned modules.",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site." => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site.",
// "Use Wiki Structure" => "Use Wiki Structure",
// "You can add several email addresses by separating them with commas." => "You can add several email addresses by separating them with commas.",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Drafts" => "Drafts",
// "Admin Email Notifications" => "Admin Email Notifications",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications." => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications.",
// "Alert" => "Alert",
// "A comment in a wiki page is posted or edited" => "A comment in a wiki page is posted or edited",
// "Preload Admin Account" => "Preload Admin Account",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Add poll to pages" => "Add poll to pages",
// "Use Ctrl+Click to select multiple pages." => "Use Ctrl+Click to select multiple pages.",
// "Lock the pages" => "Lock the pages",
// "Quicktags category filter" => "Quicktags category filter",
// "Admin RSS Modules" => "Admin RSS Modules",
// "Admin RSSmodules Template" => "Admin RSSmodules Template",
// "Tips" => "Tips",
// "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed.",
// "RSS channels" => "RSS channels",
// "Show Title?" => "Show Title?",
// "Show Date?" => "Show Date?",
// "View feed" => "View feed",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>.",
// "Security checks" => "Security checks",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database.",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments." => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments.",
// "See end of table for detailed explanations." => "See end of table for detailed explanations.",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results?" => "What to do with these check results?",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"." => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\".",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content." => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content.",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information." => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information.",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes!" => "Inodes that are not files or directories are not part of tiki. Review these Inodes!",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod." => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod.",
// "Admin structures template" => "Admin structures template",
// "The structure" => "The structure",
// "has just been created." => "has just been created.",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict:" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict:",
// "The following pages have automatically been categorized with the same categories as the structure:" => "The following pages have automatically been categorized with the same categories as the structure:",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent:" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent:",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent:" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent:",
// "Edit structure" => "Edit structure",
// "PDF" => "PDF",
// "Note" => "Note",
// "Wiki textaera" => "Wiki textaera",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value." => "For a rate, you can give the maximum value.",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)." => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed).",
// "Exterminator of cached content" => "Exterminator of cached content",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save:" => "Directories to save:",
// "Advanced feature" => "Advanced feature",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "admin Tracker fields tpl" => "admin Tracker fields tpl",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed:" => "Select list items that will be displayed:",
// "Multilingual content" => "Multilingual content",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by:" => "Visible by:",
// "Editable by:" => "Editable by:",
// "Error message:" => "Error message:",
// "Export fieldId also" => "Export fieldId also",
// "Admin Trackers tpl" => "Admin Trackers tpl",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "Duplicate Tracker" => "Duplicate Tracker",
// "with" => "with",
// "Description text is tiki-parsed:" => "Description text is tiki-parsed:",
// "Use Ratings:" => "Use Ratings:",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Format if not the default short one:" => "Format if not the default short one:",
// "Show creation date when viewing tracker item?" => "Show creation date when viewing tracker item?",
// "Show lastModif date when viewing tracker item?" => "Show lastModif date when viewing tracker item?",
// "LastModif" => "LastModif",
// "ItemId" => "ItemId",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "After:" => "After:",
// "Before:" => "Before:",
// "Do not show empty fields in item view?" => "Do not show empty fields in item view?",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items?" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items?",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Separator" => "Separator",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse" => "Parse",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "or list of fields separated by comma" => "or list of fields separated by comma",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "User Choice" => "User Choice",
// "Only directly included" => "Only directly included",
// "will have all the permissions of the included groups" => "will have all the permissions of the included groups",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)." => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>).",
// "Enable now." => "Enable now.",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Remove from Group" => "Remove from Group",
// "Download CSV export" => "Download CSV export",
// "Charset encoding:" => "Charset encoding:",
// "Assign users to group:" => "Assign users to group:",
// "User must already exist." => "User must already exist.",
// "To create users and assign them to groups, got to admin->users" => "To create users and assign them to groups, got to admin->users",
// "CSV File" => "CSV File",
// "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions",
// "Updated users" => "Updated users",
// "More Criteria" => "More Criteria",
// "Group (direct)" => "Group (direct)",
// "Need to validate email" => "Need to validate email",
// "Edit Included Group" => "Edit Included Group",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Use the email as username" => "Use the email as username",
// "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master",
// "Warning: changing the username will require the user to change his password" => "Warning: changing the username will require the user to change his password",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth." => "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth.",
// "User must change his password at first login" => "User must change his password at first login",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups:" => "Overwrite groups:",
// "Loading..." => "Loading...",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "show help" => "show help",
// "Help for Assigning Permissions" => "Help for Assigning Permissions",
// "level configuration" => "level configuration",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Assign User {\$assign_user} to Groups" => "Assign User {\$assign_user} to Groups",
// "Assign User to Group" => "Assign User to Group",
// "Directory batch upload" => "Directory batch upload",
// "available images" => "available images",
// "width" => "width",
// "height" => "height",
// "Remove File Extension from Image Name" => "Remove File Extension from Image Name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "convert the last sub directory to a sub gallery" => "convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Select a Gallery" => "Select a Gallery",
// "Browse file gallery" => "Browse file gallery",
// "Please do not use this feature to upload data into the database." => "Please do not use this feature to upload data into the database.",
// "available files" => "available files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "The TikiWiki community" => "The TikiWiki community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "Admin the Category System" => "Admin the Category System",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Upper level" => "Upper level",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Sort:" => "Sort:",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "results found" => "results found",
// "Directory batch" => "Directory batch",
// "All Images" => "All Images",
// "Monitor this Gallery" => "Monitor this Gallery",
// "Stop Monitoring this Gallery" => "Stop Monitoring this Gallery",
// "subgallery" => "subgallery",
// "Slideshow Forward" => "Slideshow Forward",
// "Cyclic" => "Cyclic",
// "Add Event" => "Add Event",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Visible Calendars" => "Visible Calendars",
// "Zoom" => "Zoom",
// "Calendar Item" => "Calendar Item",
// "Config Calendars" => "Config Calendars",
// "Edit Calendar" => "Edit Calendar",
// "View event" => "View event",
// "Edit event" => "Edit event",
// "New event" => "New event",
// "Date and time of end" => "Date and time of end",
// "or new" => "or new",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in:" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in:",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"." => "If no role is provided, default role will be \"Chair participant\".",
// "Duplicate to" => "Duplicate to",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "Categories checking is not done in the database search." => "Categories checking is not done in the database search.",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>." => "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>.",
// "The following site was added, but may require validation by the admin before appearing on the lists." => "The following site was added, but may require validation by the admin before appearing on the lists.",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "Use Ctrl+Click to select multiple categories." => "Use Ctrl+Click to select multiple categories.",
// "Perform action with selected:" => "Perform action with selected:",
// "No records." => "No records.",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie URL" => "Movie URL",
// "Movie Size" => "Movie Size",
// "Pixels" => "Pixels",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "A category is mandatory" => "A category is mandatory",
// "For more information, please see <a href=\"{\$prefs.helpurl}Wiki Page Editor\">Wiki Page Editor</a>" => "For more information, please see <a href=\"{\$prefs.helpurl}Wiki Page Editor\">Wiki Page Editor</a>",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines." => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines.",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line." => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line.",
// "Quicktag" => "Quicktag",
// "Wiki Syntax" => "Wiki Syntax",
// "Format" => "Format",
// "Bold text" => "Bold text",
// "underscores" => "underscores",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Centered text" => "Centered text",
// "colons" => "colons",
// "Underlined text" => "Underlined text",
// "equals" => "equals",
// "Text box" => "Text box",
// "One carat" => "One carat",
// "Will display using the indicated HTML color or color name" => "Will display using the indicated HTML color or color name",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus(useful in list to continue at the same level)" => "Creates an indentation for each plus(useful in list to continue at the same level)",
// "Headings" => "Headings",
// "make headings" => "make headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "Autonumbered Headings" => "Autonumbered Headings",
// "make autonumbered headings" => "make autonumbered headings",
// "row" => "row",
// "col" => "col",
// "Horizontal rule" => "Horizontal rule",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)." => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox).",
// "imalign, height, width, desc, link, rel, title, usemap, class and align are optional" => "imalign, height, width, desc, link, rel, title, usemap, class and align are optional",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "creates the editable drawing foo" => "creates the editable drawing foo",
// "to separate pages" => "to separate pages",
// "Wiki File Attachments" => "Wiki File Attachments",
// "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated.",
// "\"~pp~ data ~/pp~\" Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  \"~pre~ data ~/pre~\" also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text." => "\"~pp~ data ~/pp~\" Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  \"~pre~ data ~/pre~\" also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text.",
// "\"~tc~ Tiki Comment ~/tc~\" makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  \"~hc~ HTML Comment ~/hc~\" makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar." => "\"~tc~ Tiki Comment ~/tc~\" makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  \"~hc~ HTML Comment ~/hc~\" makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar.",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew." => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew.",
// "Plugins" => "Plugins",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt;" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt;",
// "Plugin" => "Plugin",
// "Add another image" => "Add another image",
// "Leave Fullscreen Edit" => "Leave Fullscreen Edit",
// "Fullscreen Edit" => "Fullscreen Edit",
// "Upload from disk to change the image:" => "Upload from disk to change the image:",
// "Save and Go Next" => "Save and Go Next",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one." => "The page already exists. The page that has been added to the structure is the existing one.",
// "The following pages added have automatically been categorized with the same categories as the structure:" => "The following pages added have automatically been categorized with the same categories as the structure:",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "Help on Articles" => "Help on Articles",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "Delete the copy in the theme:" => "Delete the copy in the theme:",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "Translate:" => "Translate:",
// "Language of newly translated page" => "Language of newly translated page",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "Change language for this page" => "Change language for this page",
// "Select from available options..." => "Select from available options...",
// "Change Language" => "Change Language",
// "No language is assigned to this page." => "No language is assigned to this page.",
// "Please select a language before performing translation." => "Please select a language before performing translation.",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Edit Section:" => "Edit Section:",
// "View object" => "View object",
// "Preview your changes." => "Preview your changes.",
// "Save the page." => "Save the page.",
// "Cancel the edit, you will lose your changes." => "Cancel the edit, you will lose your changes.",
// "Your edit session will expire in" => "Your edit session will expire in",
// "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits." => "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits.",
// "Update '{\$page}' based on '{\$source_page}'" => "Update '{\$page}' based on '{\$source_page}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval." => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval.",
// "This is a new staging page that has not been approved before." => "This is a new staging page that has not been approved before.",
// "The current staging copy may contain changes that have yet to be approved." => "The current staging copy may contain changes that have yet to be approved.",
// "View changes since last approval." => "View changes since last approval.",
// "You are editing the approved copy of this page." => "You are editing the approved copy of this page.",
// "There are currently changes in the staging copy that have yet to be approved." => "There are currently changes in the staging copy that have yet to be approved.",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead?" => "instead?",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Perhaps you are looking for:" => "Perhaps you are looking for:",
// "This edit session will expire in {\$edittimeout} minutes" => "This edit session will expire in {\$edittimeout} minutes",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer." => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer.",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "or use" => "or use",
// "Regex search " => "Regex search ",
// "Replace to" => "Replace to",
// "Case Insensitivity" => "Case Insensitivity",
// "Translation request" => "Translation request",
// "Send urgent translation request." => "Send urgent translation request.",
// "Lock this page" => "Lock this page",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Autodetect" => "Autodetect",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "Be carefull to set the right permissions on the files you link to" => "Be carefull to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>." => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>.",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred." => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred.",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into?" => "Which Forum Do You Wish to Import this Into?",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "No records to display" => "No records to display",
// "Perfom action with checked:" => "Perfom action with checked:",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag." => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag.",
// "Until then, they cannot be translated." => "Until then, they cannot be translated.",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Cancel friendship request" => "Cancel friendship request",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Global default" => "Global default",
// "Save clicked point" => "Save clicked point",
// "Save current view as default" => "Save current view as default",
// "Reset view to site-wide default" => "Reset view to site-wide default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal" => "Horizontal",
// "Vertical" => "Vertical",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// " To " => " To ",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "Tiki installer" => "Tiki installer",
// "Success" => "Success",
// "MultiTiki setup" => "MultiTiki setup",
// "To add a new virtual host" => "To add a new virtual host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "Please enter your database connection information" => "Please enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki." => "Select the type of database to use with Tiki.",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension." => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension.",
// "Host:" => "Host:",
// "Enter the hostname or IP for your database. Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Enter the hostname or IP for your database. Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "For SQLite, enter the path and filename to your database file" => "For SQLite, enter the path and filename to your database file",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use." => "Enter the name of the database that Tiki will use.",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your\nhosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your\nhosting provider.  Normally Tiki tables won't conflict with other product names",
// "For Oracle" => "For Oracle",
// "Enter your TNS Name here and leave Host empty" => "Enter your TNS Name here and leave Host empty",
// "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field",
// "Database User" => "Database User",
// "Enter the database user with administrator permission for the Database" => "Enter the database user with administrator permission for the Database",
// "Enter the password for the database user" => "Enter the password for the database user",
// "Connect" => "Connect",
// "Welcome to the installation{if \$tikidb_created} &amp; upgrade{/if} script!" => "Welcome to the installation{if \$tikidb_created} &amp; upgrade{/if} script!",
// "Reinstall database." => "Reinstall database.",
// "This will destroy your current database" => "This will destroy your current database",
// "Create a new database (clean install) with profile" => "Create a new database (clean install) with profile",
// "No profiles available." => "No profiles available.",
// "See the documentation for <a target=\"_blank\" href=\"http://doc.tikiwiki.org/Profiles\" class=\"link\" title=\"{tr}Description of available profiles." => "See the documentation for <a target=\"_blank\" href=\"http://doc.tikiwiki.org/Profiles\" class=\"link\" title=\"{tr}Description of available profiles.",
// "Upgrade" => "Upgrade",
// "Backup your database with mysqldump, phpmyadmin, or other before upgrading." => "Backup your database with mysqldump, phpmyadmin, or other before upgrading.",
// "Update database using script" => "Update database using script",
// "No scripts available." => "No scripts available.",
// "To upgrade from" => "To upgrade from",
// "Use this script" => "Use this script",
// "Then rerun the installer using tiki_1.9to2.0." => "Then rerun the installer using tiki_1.9to2.0.",
// "See <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Upgrade+1.7+to+1.8\">Tiki database 1.7.x to 1.8x instructions" => "See <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Upgrade+1.7+to+1.8\">Tiki database 1.7.x to 1.8x instructions",
// "For information about <strong>tiki-secdb_*.sql</strong> files, please see <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Security+Admin\">http://doc.tikiwiki.org/Security+Admin" => "For information about <strong>tiki-secdb_*.sql</strong> files, please see <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Security+Admin\">http://doc.tikiwiki.org/Security+Admin",
// "Other Options" => "Other Options",
// "Do nothing and enter Tiki" => "Do nothing and enter Tiki",
// "Reset database connection settings" => "Reset database connection settings",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Installation" => "Installation",
// "Your database has been configured and Tikiwiki is ready to run!" => "Your database has been configured and Tikiwiki is ready to run!",
// "If this is your first install, your admin password is <strong>admin</strong>." => "If this is your first install, your admin password is <strong>admin</strong>.",
// "You can now log in into Tikiwiki as user <strong>admin</strong> and start configuring the application." => "You can now log in into Tikiwiki as user <strong>admin</strong> and start configuring the application.",
// "operations executed successfully" => "operations executed successfully",
// "SQL queries" => "SQL queries",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages." => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages.",
// "Important Information" => "Important Information",
// "Please read the following notes before entering Tikiwiki." => "Please read the following notes before entering Tikiwiki.",
// "Memory" => "Memory",
// "TikiWiki requires <strong>at least</strong> 16MB of PHP memory for script execution. Use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 16M) and restart your webserver" => "TikiWiki requires <strong>at least</strong> 16MB of PHP memory for script execution. Use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 16M) and restart your webserver",
// "Allocating too little memory will cause TikiWiki to display blank pages" => "Allocating too little memory will cause TikiWiki to display blank pages",
// "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu." => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu.",
// "Entering TikiWiki" => "Entering TikiWiki",
// "Change the administrator password" => "Change the administrator password",
// "Continue in installer" => "Continue in installer",
// "Go back and run another install/upgrade script" => "Go back and run another install/upgrade script",
// "Do not use your browser's Back button." => "Do not use your browser's Back button.",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "weeks" => "weeks",
// "Admin Banners" => "Admin Banners",
// "Admin Banners tpl" => "Admin Banners tpl",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone.",
// "The cache is used by:" => "The cache is used by:",
// "Orphan" => "Orphan",
// "Help on Dynamic Content" => "Help on Dynamic Content",
// "Admin DynamicContent tpl" => "Admin DynamicContent tpl",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block.",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block." => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block.",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "SlideShow" => "SlideShow",
// "Your comment" => "Your comment",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "Flash binary (.swf or .dcr)" => "Flash binary (.swf or .dcr)",
// "Last modification" => "Last modification",
// "Page creator" => "Page creator",
// "Last ver." => "Last ver.",
// "Status of the page" => "Status of the page",
// "Vers." => "Vers.",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl." => "Backl.",
// "Page size" => "Page size",
// "Lang." => "Lang.",
// "Perform action with checked" => "Perform action with checked",
// "For security purposes we must periodically validate your email address to allow continued access to this site." => "For security purposes we must periodically validate your email address to allow continued access to this site.",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site." => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site.",
// "Thank you" => "Thank you",
// "Add event" => "Add event",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>." => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>.",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./fixperms fix\" for example)." => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./fixperms fix\" for example).",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that permission (using \"./fixperms fix\")." => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that permission (using \"./fixperms fix\").",
// "licence" => "licence",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you participate:" => "To display the objects you participate:",
// "Contacts Preferences" => "Contacts Preferences",
// "My Infos" => "My Infos",
// "My Contacts" => "My Contacts",
// "My Wiki Pages" => "My Wiki Pages",
// "My Galleries" => "My Galleries",
// "My Tracker Items" => "My Tracker Items",
// "My Messages" => "My Messages",
// "My Tasks" => "My Tasks",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Add a news server" => "Add a news server",
// "Edit news server" => "Edit news server",
// "View Permissions" => "View Permissions",
// "Edit Permissions" => "Edit Permissions",
// "These permissions override any global permissions or category permissions affecting this object." => "These permissions override any global permissions or category permissions affecting this object.",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>." => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>.",
// "No individual permissions, category permissions apply" => "No individual permissions, category permissions apply",
// "Current permissions for categories that this object belongs to" => "Current permissions for categories that this object belongs to",
// "These permissions do not apply. Special permissions apply." => "These permissions do not apply. Special permissions apply.",
// "No category permissions; special permissions apply" => "No category permissions; special permissions apply",
// "and also to all pages of the sub-structure:" => "and also to all pages of the sub-structure:",
// "Perms Help" => "Perms Help",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier." => "However, no account is associated to the OpenID identifier.",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts." => "Your identity gives you access to multiple user accounts.",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "Rollback to this version" => "Rollback to this version",
// "Source of version" => "Source of version",
// "HTML diff" => "HTML diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "Avatar:" => "Avatar:",
// "(Only .gif images, and aproximately 45px x 45px)" => "(Only .gif images, and aproximately 45px x 45px)",
// "Any" => "Any",
// "Items found:" => "Items found:",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Average:" => "Average:",
// "List Votes" => "List Votes",
// "Permission denied. You do not have permission to read complete articles." => "Permission denied. You do not have permission to read complete articles.",
// "Selected Structures" => "Selected Structures",
// "Add Structure" => "Add Structure",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected." => "No pages selected.",
// "P/F" => "P/F",
// "Question:" => "Question:",
// "Received Pages" => "Received Pages",
// "Help on Communication Center" => "Help on Communication Center",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist." => "The highlight pages already exist.",
// "Please, change the name if you want the page to be uploaded." => "Please, change the name if you want the page to be uploaded.",
// "Received Structures" => "Received Structures",
// "Prefix the checked:" => "Prefix the checked:",
// "Postfix the checked:" => "Postfix the checked:",
// "Admin Referer Stats" => "Admin Referer Stats",
// "Admin Referer Stats tpl" => "Admin Referer Stats tpl",
// "Use your email as login" => "Use your email as login",
// "Lowercase only" => "Lowercase only",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "Select your group" => "Select your group",
// "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!" => "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!",
// "Enter your username or email." => "Enter your username or email.",
// "Request Password Reset" => "Request Password Reset",
// "return to wikipage" => "return to wikipage",
// "Faqs" => "Faqs",
// "Please Confirm" => "Please Confirm",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Save as Draft" => "Save as Draft",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "Debug" => "Debug",
// "Admin Tiki Shoutbox" => "Admin Tiki Shoutbox",
// "Admin Tiki Shoutbox tpl" => "Admin Tiki Shoutbox tpl",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page." => "the approved version of this page.",
// "Viewing of changes since last approval is possible only after first approval." => "Viewing of changes since last approval is possible only after first approval.",
// "Approve changes." => "Approve changes.",
// "Latest changes will be synchronized after approval." => "Latest changes will be synchronized after approval.",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time." => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time.",
// "{icon _id=information.png style=\"vertical-align:middle\"} Content may be out of date" => "{icon _id=information.png style=\"vertical-align:middle\"} Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages:" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages:",
// "TOC" => "TOC",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "FAQ Stats" => "FAQ Stats",
// "System log help" => "System log help",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Clean" => "Clean",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses:" => "The link was sent to the following addresses:",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma." => "Separate multiple email addresses with a comma.",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like." => "I found an interesting page that I thought you would like.",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request:" => "Request:",
// "Element to compare (Xpath expression):" => "Element to compare (Xpath expression):",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "Notice" => "Notice",
// "PECL HTPP extension present" => "PECL HTPP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTPP and cURL extension not present. Replay of the TikiTest will not be possible." => "PECL HTPP and cURL extension not present. Replay of the TikiTest will not be possible.",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "File Name:" => "File Name:",
// "Start Recording Test" => "Start Recording Test",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
// "Edit File:" => "Edit File:",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "Additional Info" => "Additional Info",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "Upload big files (e.g. PodCast files) here:" => "Upload big files (e.g. PodCast files) here:",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "Unzip all zip files" => "Unzip all zip files",
// "Maximum amount of downloads" => "Maximum amount of downloads",
// "0 for no limit" => "0 for no limit",
// "Author if not the file creator" => "Author if not the file creator",
// "No gallery available." => "No gallery available.",
// "Note: Maximum image size is limited to" => "Note: Maximum image size is limited to",
// "a folder" => "a folder",
// "a URL" => "a URL",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Edit User Contacts Preferences" => "Edit User Contacts Preferences",
// "Manage Fields" => "Manage Fields",
// "Default view" => "Default view",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Forum comments" => "Forum comments",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages?" => "Can you read more languages?",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language..." => "Select language...",
// "My level" => "My level",
// "Accepted User and Creator" => "Accepted User and Creator",
// "Not Accepted User" => "Not Accepted User",
// "Red" => "Red",
// "Marked as deleted" => "Marked as deleted",
// "Use \"watches\" to monitor wiki pages or other objects." => "Use \"watches\" to monitor wiki pages or other objects.",
// "Watch new items by clicking the {icon _id=eye} button on specific pages." => "Watch new items by clicking the {icon _id=eye} button on specific pages.",
// "watched events" => "watched events",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "Watch language wiki page creations" => "Watch language wiki page creations",
// "Add watch" => "Add watch",
// "Used space:" => "Used space:",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "No articles." => "No articles.",
// "There are no questions in this FAQ." => "There are no questions in this FAQ.",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Your message has been queued for approval, the message will be posted after a moderator approves it." => "Your message has been queued for approval, the message will be posted after a moderator approves it.",
// "Another post with the same title and content already exists." => "Another post with the same title and content already exists.",
// "Please change your title or content then click Post." => "Please change your title or content then click Post.",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Show archived posts" => "Show archived posts",
// "Archived" => "Archived",
// "The post has been reported and will be reviewed by a moderator." => "The post has been reported and will be reviewed by a moderator.",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Tracker:" => "Tracker:",
// "Stop Monitor" => "Stop Monitor",
// "Tracker Items for" => "Tracker Items for",
// "Format : x,y,zoom - You can use Google Map Locator in the item view script." => "Format : x,y,zoom - You can use Google Map Locator in the item view script.",
// "Tracker Item:" => "Tracker Item:",
// "Edit/Delete" => "Edit/Delete",
// "Remove Image" => "Remove Image",
// "Google Map Locator" => "Google Map Locator",
// "fields marked with a * are mandatory" => "fields marked with a * are mandatory",
// "Edit mail account" => "Edit mail account",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Word Count:" => "Word Count:",
// "Number of voices" => "Number of voices",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled." => "Google Maps is not enabled.",
// "Use this thread to discuss the page:" => "Use this thread to discuss the page:",
// "Missing or incorrect trackerId parameter for the plugin." => "Missing or incorrect trackerId parameter for the plugin.",
// "Subscribe to a group" => "Subscribe to a group",
// "Show Filters" => "Show Filters",
// "Toggle display" => "Toggle display",
// "Start:" => "Start:",
// "Close:" => "Close:",
// "List authors:" => "List authors:",
// "Save the page as a partial translation." => "Save the page as a partial translation.",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation." => "Save the page as a completed translation.",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated." => "Save the page, but do not send notifications and do not count it as new content to be translated.",
// "Save the page as a draft." => "Save the page as a draft.",
// "Save Draft" => "Save Draft",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Wiki Attachments" => "Wiki Attachments",
// "Freetags settings" => "Freetags settings",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Current version is up to date : <b>%s</b>" => "Current version is up to date : <b>%s</b>",
// "A new %s  major release branch is available." => "A new %s  major release branch is available.",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Click here to delete the category:" => "Click here to delete the category:",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header:" => "The file does not have the required header:",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "moved %d images, %d errors occured." => "moved %d images, %d errors occured.",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "You cannot have a blank password" => "You cannot have a blank password",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "Invalid email" => "Invalid email",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "installed" => "installed",
// "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html.",
// "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement.",
// "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory.",
// "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts.",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous.",
// "This is a modified File. Cannot check version. Check if it is dangerous." => "This is a modified File. Cannot check version. Check if it is dangerous.",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "User login contains invalid characters" => "User login contains invalid characters",
// "Deleted account %s" => "Deleted account %s",
// "Login contains invalid characters" => "Login contains invalid characters",
// "Image annotations changed." => "Image annotations changed.",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s." => "Could not read image %s.",
// "Image %s upload failed." => "Image %s upload failed.",
// "Image %s uploaded successfully." => "Image %s uploaded successfully.",
// "Image %s removed from Batch directory." => "Image %s removed from Batch directory.",
// "Impossible to remove image %s from Batch directory." => "Impossible to remove image %s from Batch directory.",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images." => "Incorrect directory chosen for batch upload of images.",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator." => "Please contact the website administrator.",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s." => "Could not read file %s.",
// "Could not write to file %s." => "Could not write to file %s.",
// "File %s upload failed." => "File %s upload failed.",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory." => "File %s removed from Batch directory.",
// "Impossible to remove file %s from Batch directory." => "Impossible to remove file %s from Batch directory.",
// "Incorrect directory chosen for batch upload of files." => "Incorrect directory chosen for batch upload of files.",
// "Last modifications to the blog." => "Last modifications to the blog.",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache." => "You must clear your browser cache.",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string!",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Upcoming events." => "Upcoming events.",
// "End:" => "End:",
// "Invalid username or activation code. Maybe this code has already been used." => "Invalid username or activation code. Maybe this code has already been used.",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Problem. Try to log in again to receive new confirmation instructions." => "Problem. Try to log in again to receive new confirmation instructions.",
// "You have mistyped the anti-bot verification code; please try again. " => "You have mistyped the anti-bot verification code; please try again. ",
// "You cannot download this file right now. Your score is low or file limit was reached." => "You cannot download this file right now. Your score is low or file limit was reached.",
// "Error : The file %s doesn't exist." => "Error : The file %s doesn't exist.",
// "Invalid email:" => "Invalid email:",
// "You do not have permission to write the template:" => "You do not have permission to write the template:",
// "Translation in progress." => "Translation in progress.",
// "Page is a staging copy. Translation must begin from the approved copy." => "Page is a staging copy. Translation must begin from the approved copy.",
// "Not enable for this type of object" => "Not enable for this type of object",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Page already exists. Go back and choose a different name." => "Page already exists. Go back and choose a different name.",
// "The translation set already contains a page in this language." => "The translation set already contains a page in this language.",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Form error - no import method selected for some reason." => "Form error - no import method selected for some reason.",
// "Form error - no server-side filename entered for selected import method." => "Form error - no server-side filename entered for selected import method.",
// "Last replied forum topics" => "Last replied forum topics",
// "Not supported yet." => "Not supported yet.",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "I have refused your friendship request." => "I have refused your friendship request.",
// "I have canceled my friendship request." => "I have canceled my friendship request.",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "Invalid source path" => "Invalid source path",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required." => "No valid renderer found. GD or PDFLib required.",
// "No sheet specified." => "No sheet specified.",
// "You must select a renderer." => "You must select a renderer.",
// "Invalid Series for current graphic." => "Invalid Series for current graphic.",
// "Only the administrator can upload language files." => "Only the administrator can upload language files.",
// "%s - Version %d of this page has been saved by %s." => "%s - Version %d of this page has been saved by %s.",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Warning: Empty file:" => "Warning: Empty file:",
// "Please re-upload your file" => "Please re-upload your file",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read file:" => "Cannot read file:",
// "Cannot read the file:" => "Cannot read the file:",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "File update was successful" => "File update was successful",
// "This gallery does not exist" => "This gallery does not exist",
// "Delete those pages:" => "Delete those pages:",
// "Unable to contact remote server." => "Unable to contact remote server.",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made." => "More than %d unsuccessful login attempts have been made.",
// "An email has been sent to you with the instructions to follow." => "An email has been sent to you with the instructions to follow.",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "You are not yet validated" => "You are not yet validated",
// "Your default nickname is already in use. A new one has to be selected." => "Your default nickname is already in use. A new one has to be selected.",
// "The selected account is not associated with your identity." => "The selected account is not associated with your identity.",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Account validated successfully." => "Account validated successfully.",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile: " => "An error as occured with the mapfile: ",
// "Please create a directory named '.\$prefs['map_path'].' to hold your map files." => "Please create a directory named '.\$prefs['map_path'].' to hold your map files.",
// "map edit" => "map edit",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "You must choose a group" => "You must choose a group",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "mail adress" => "mail adress",
// "Invalid or unknown email" => "Invalid or unknown email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password." => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password.",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email " => "to the email ",
// "You cannot rename staging pages. Please rename the approved page instead." => "You cannot rename staging pages. Please rename the approved page instead.",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "Notice: this variable may not be empty:" => "Notice: this variable may not be empty:",
// "Notice: invalid variable value:" => "Notice: invalid variable value:",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Report to the webmaster" => "Report to the webmaster",
// "Tracker item:" => "Tracker item:",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Password has been changed" => "Password has been changed",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again." => "You must suggest a question; please try again.",
// "Incorrect thread" => "Incorrect thread",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "TikiTests Edit" => "TikiTests Edit",
// "You are about to delete a TikiTest file, do you want to continue ?" => "You are about to delete a TikiTest file, do you want to continue ?",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"El Salvador" => "El Salvador",
"Federated States of Micronesia" => "Federated States of Micronesia",
"tracker" => "tracker",
"faq" => "faq",
"Tracker" => "Tracker",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"RSS" => "RSS",
"LDAP" => "LDAP",
"PAM" => "PAM",
"Regex" => "Regex",
"Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
"popup" => "popup",
"+" => "+",
"hr" => "hr",
"%" => "%",
"Try to convert HTML to wiki" => "Try to convert HTML to wiki",
"Pop-up" => "Pop-up",
"/" => "/",
"tikiwiki.org" => "tikiwiki.org",
"%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
"Public for group" => "Public for group",
"%m/%d" => "%m/%d",
"%H:%M %Z" => "%H:%M %Z",
"tiki-mobile.php" => "tiki-mobile.php",
"unicode" => "unicode",
"very low" => "very low",
"low" => "low",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "اين خصلت غيرفعال است",
"Permission denied you cannot view pages" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد صفحات را ببينيد",
"Cannot write to this file:" => "نمي‌توانم در اين پرونده بنويسم:",
"Cannot upload this file maximum upload size exceeded" => "حجم اين پرونده از حد مجاز بيشتري است. نمي‌توانم آن را بارگذاري كنم.",
"Re:" => "در پاسخ به:",
"Missing title or body when trying to post a comment" => "عنوان يا متن هنكام الصاق مفقود شده است",
"You do not have permission to use this feature" => "متاسفانه نمي‌توانيد از اين خصيصه استفاده كنيد.",
"This script cannot be called directly" => "اين دستخط(script) نمي‌تواند مستقيما فراخواني شود",
"The copyright management feature is not enabled." => "خصيصه‌ي مديريت حق انحصاري چاپ(copyright) فعال نيست.",
"No page indicated" => "هيچ صفحه‌اي انتخاب نشده است.",
"You must supply all the information, including title and year." => "بايد تمام اطلاعات را فراهم كنيد، اين اطلاعات شامل سال و عنوان نيز هستند.",
"This feature is for admins only" => "اين خصيصه تنها براي سرپرستان است",
"ID" => "شناسه",
"Type" => "گونه:",
"Name" => "نام",
"Description" => "شرح",
"Size" => "حجم",
"Created" => "ايجاد شده در:",
"Last Modified" => "آخرين تغيير",
"Creator" => "ايجاد كننده",
"Author" => "مؤلف",
"Comment" => "نظر",
"Files" => "پرونده‌ها",
"Hits" => "ضربت‌ها(Hits)",
"Locked by" => "قفل شده به‌وسيله‌ي",
"Path" => "مسير",
"The text in RED is" => "متن قرمز عبارتست از",
"character(s) too long - please edit it." => "تعداد حروف بيش از حد است. لطفا اصلاح كنيد.",
"Algeria" => "الجزاير",
"American Samoa" => "ساموآي آمريكايي",
"Angola" => "آنگولا",
"Antigua" => "آنتيگا",
"Argentina" => "آرژانتين",
"Armenia" => "ارمنستان",
"Australia" => "استراليا",
"Austria" => "اتريش",
"Bahamas" => "باهاماس",
"Bahrain" => "بحرين",
"Bangladesh" => "بنگلادش",
"Barbados" => "باربادوس",
"Belarus" => "بلاروس",
"Belgium" => "بلژيك",
"Bermuda" => "برمودا",
"Bolivia" => "بوليوي",
"Brazil" => "برزيل",
"Brunei" => "برونئي",
"Canada" => "كانادا",
"Cayman Islands" => "جزاير كايمن",
"Chile" => "شيلي",
"China" => "چين",
"Colombia" => "كلمبيا",
"Cook Islands" => "جزاير كوك",
"Costa Rica" => "كاستاريكا",
"Croatia" => "كرواسي",
"Cuba" => "كوبا",
"Cyprus" => "قبرس",
"Czech Republic" => "جمهوري چك",
"Denmark" => "دانمارك",
"Dominican Republic" => "جمهوري دمنيكن",
"Ecuador" => "اكوادور",
"Egypt" => "مصر",
"Estonia" => "استووني",
"Fiji" => "جزاير فيجي",
"Finland" => "فنلاند",
"France" => "فرانسه",
"French Polynesia" => "پلینزی فرانسه",
"Germany" => "آلمان",
"Greece" => "يونان",
"Guam" => "گوآم",
"Guatemala" => "گوانتانامو",
"Haiti" => "هائیتی",
"Honduras" => "هندوراس",
"Hungary" => "مجارستان",
"Iceland" => "ايسلند",
"India" => "هند",
"Indonesia" => "اندونزي",
"Iran" => " ايران (جمهوري اسلامي)",
"Iraq" => "عراق",
"Ireland" => "ايرلند",
"Israel" => "فلستين اشغالي",
"Italy" => "ايتاليا",
"Ivory Coast" => "ساحل عاج",
"Jamaica" => "جامائيكا",
"Japan" => "ژاپن",
"Jordan" => "اردن",
"Kazakstan" => "قزاقستان",
"Kenya" => "كنيا",
"Kiribati" => "كريباتي",
"Kuwait" => "كويت",
"Latvia" => "لتوني",
"Lebanon" => "لبنان",
"Lithuania" => "ليتواني",
"Luxemburg" => "لوكرامبورگ",
"Malawi" => "مالاوی",
"Malaysia" => "مالزي",
"Malta" => "مالت",
"Marshall Islands" => "جزاير مارشال",
"Mauritius" => "موريس",
"Mexico" => "مكزيك",
"Morocco" => "مراكش",
"Mozambique" => "موزامبيك",
"Nauru" => "ناورو",
"Nepal" => "نپال",
"Netherlands" => "هلند",
"New Caledonia" => "اسكاتلند جديد",
"New Zealand" => "زلاند نو",
"Nicaragua" => "نيكاراگوئه",
"Nigeria" => "نيجريه",
"Niue" => "نیووی",
"None" => "هيچ‌كدام",
"Norway" => "نروژ",
"Other" => "ساير",
"Pakistan" => "پاكستان",
"Panama" => "پاناما",
"Papua New Guinea" => "پاپوآ گینه نو",
"Paraguay" => "پاراگوئه",
"Peru" => "پرو",
"Poland" => "لهستان",
"Portugal" => "پرتقال",
"Puerto Rico" => "پورتوریکو",
"Quatar" => "قطر",
"Romania" => "روماني",
"Russia" => "روسيه",
"Samoa" => "ساموآ",
"Saudi Arabia" => "عربستان صعنودي",
"Singapore" => "سنگاپور",
"Slovakia" => "اسلواكي",
"Slovenia" => "اسلوني",
"Solomon Islands" => "جزاير سليمان",
"Somalia" => "سومالي",
"South Africa" => "آفريقاي جنوبي",
"South Korea" => "كره‌ي جنوبي",
"Spain" => "اسپانيا",
"Sri Lanka" => "سريلانكا",
"St Vincent Grenadines" => "سنت وينسنت و گرانادينز",
"Surinam" => "سورينام",
"Sweden" => "سوئد",
"Switzerland" => "سوئيس",
"Taiwan" => "تايوان",
"Thailand" => "تايلند",
"Tonga" => "تانگو",
"Trinidad Tobago" => "تريناداد و توباگو",
"Turkey" => "تركيه",
"Tuvalu" => "تووالو",
"Ukraine" => "اوكراين",
"United Arab Emirates" => "امارات متحده عربي",
"United Kingdom" => "انگلستان",
"United States" => "ايالات متحده آمريكا",
"Uruguay" => "اروگوئه",
"Vanuatu" => "فانواتو",
"Venezuela" => "ونزوئلا",
"Wales" => "ولز",
"Yugoslavia" => "يوگوسلاوي",
"Zambia" => "زامبيا",
"Zimbabwe" => "زيمباوه",
"Arabic" => "عربي",
"Catalan" => "كاتالان",
"Simplified Chinese" => "چيني ساده‌شده",
"Chinese" => "چيني",
"Czech" => "چك",
"Danish" => "دانماركي",
"German" => "آلماني",
"English" => "انگليسي",
"English British" => "انگليسي(انگلستاني)",
"Spanish" => "اسپانايي",
"Greek" => "يواناني",
"French" => "فرانسوي",
"Hebrew" => "عبري",
"Croatian" => "كرواسيايي",
"Italian" => "ايتاليايي",
"Japanese" => "ژاپني",
"Korean" => "كره‌اي",
"Hungarian" => "مجارستاني",
"Dutch" => "هلندي",
"Norwegian" => "نروژي",
"Polish" => "لهستاني",
"Português" => "پرتقالي",
"Brazilian Portuguese" => "پرتقالي برزيلي",
"Russian" => "روسي",
"Slovak" => "اسواكي‌اي",
"Serbian" => "صربي",
"Serbian Latin" => "صربي لاتين",
"Swedish" => "سوئدي",
"Tuvaluan" => "تاوالان",
"Traditional Chinese" => "چيني سنتي",
"Ukrainian" => "اوكرايني",
"This instance of activity is already complete" => "اين نمونه از فعاليت هم‌اكنون تكميل شده است‌‌‌",
"Fatal error: cannot execute automatic activity \$activityId" => "يك خطاي مهلك رخ داد: نمي‌توانم فعاليت خودكار \$activityId را اجرا كنم.",
"Fatal error: setting next activity to an unexisting activity" => "يك خطاي مهلك رخ داد: سعي در قرار دادن فعاليتي كه وجود ندارد به عنوان فعاليت بعدي.",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "يك خطاي مهلك رخ داد: در مسيريابي خودكار فعاليع‌ها، هيچ نامزد مناسبي به عنوان فعاليت بعدي(nextActivitu) پيدا نشد.",
"Fatal error: non-deterministic decision for autorouting activity" => "يك خطاي مهلك رخ داد: تصميم غيرقطعي براي فعاليت مسيريابي خودكار",
"Fatal error: trying to send an instance to an activity but no transition found" => "يك خطاي مهلك رخ داد: هنگام تلاش براي ارسال يك نمونه به يك فعاليت، هيچ تراكنشي يافت نشد.",
"Cannot add transition only split activities can have more than one outbound transition" => "نمي‌توانم تراكنش را اضافه كنم. تنها فعاليت‌هاي انشعابي(split) مي‌توانند بيش از يك تراكنش خروجي داشته باشند.",
"Circular reference found some activity has a transition leading to itself" => "حلقه‌ي بازگشتي پيدا شد. برخي از فعاليت‌ها تراكنشي دارند كه به خود آن‌ها باز مي‌گردد!",
"Process does not have a start activity" => "فرايند، فعاليت آغازين ندارد!",
"Process does not have exactly one end activity" => "فرايند بايد تنها يك تراكنش پاياني داشته باشد!",
"End activity is not reachable from start activity" => "فعاليت پاياني از طريق فعاليت آغازين قابل دسترس نيست!",
"Activity" => "فعاليت",
" is interactive but has no role assigned" => " تعاملي است، اما هيچ قانوني به آن تخصيص داده نشده است!",
" is non-interactive and non-autorouted but has no role assigned" => " غيرتعاملي وبا مسيريابي دستي(غير خودكار) است اما هيچ قانوني به آن تخصيص داده نشده است!",
" is standalone but has transitions" => " خودمختار(standalone) است اما شامل تراكنش شده است!",
"Role" => "قانون",
" is not mapped" => " نگاشت نشده است.",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "فعاليت '.\$res['name'].' خودمختار است و از شيئ \$instance بهره مي‌گيرد.",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "فعاليت '.\$res['name'].' تعاملي است و بايد ازاسلوب \$instance->complete() استفاده كند.",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "فعاليت غيرتعاملي‌است لذا نبايد از اسلوب استفاده كند",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "فعاليت '.\$res['name'].' انتخاب(switch) شده‌است لذا بايد از اسلوب \$instance->setNextActivity(\$actname) استفاده كند.",
"Process %d has been activated" => "فرايند %d فعال شد",
"Process %d has been deactivated" => "فرايند %d غيرفعال شد",
"Process %s removed" => "فرايند %s حذف شد",
"Process %s has been updated" => "فرايند %s بروز رساني شد",
"Process %s has been created" => "فرايند %s فعال شد",
"Permission denied" => "دسترسي غيرممكن",
"The file is not a CSV file or has not a correct syntax" => "اين پرونده، يك پرونده‌ي CSV نيست يا اشكالي در نحو آن وجود دارد",
"locked" => "قفل شده",
"locked by" => "قفل شده به‌وسيله‌ي",
"Administration:" => "مديريت:",
"in" => "ميان",
"continued" => "ادامه دارد",
"New Image Uploaded by" => "تصوير جديد، بارگذاري شده به‌وسيله‌ي:",
"New Subscriptions" => "اشتراك جديد",
"New Item in Tracker" => "يك فقره‌ي جديد در tracker",
"by" => "به‌وسيله‌ي",
"Wiki" => "ويكي",
"Image Gallery" => "سرسراي تصاوير",
"Articles" => "مقالات",
"Blogs" => "بلاگ‌ها",
"Forums" => "انجمن‌ها",
"Directory" => "پوشه",
"File Gallery" => "سرسراي پرونده",
"FAQs" => "سئوالات متداول",
"Quizzes" => "آزمون‌ها",
"Trackers" => "Trackerها",
"Survey" => "نظرسنجي",
"Newsletter" => "خبرنامه",
"Charts" => "نمودارها",
"article" => "مقاله",
"blog" => "بلاگ",
"directory" => "پوشه",
"forum" => " انجمن",
"image gallery" => "سرسراي تصوير",
"newsletter" => "خبرنامه",
"poll" => "راي‌گيري",
"quiz" => "آزمون",
"wiki page" => "صفحه‌ي ويكي",
"image" => "تصوير",
"calendar" => "تقويم",
"Anonymous" => "بي‌نام",
"Use this thread to discuss the %s page." => "از اين رگه براي مطرح كردن صفحه‌ي %s استفاده كنيد",
"WikiDiff::apply: line count mismatch: %s != %s" => "تغييرات ويكي::apply:تعداد خطوط همخواني ندارد:%s != %s",
"WikiDiff::_check: failed" => "تغييرات ويكي::_check:ناموق بود",
"WikiDiff::_check: edit sequence is non-optimal" => "تغييرات ويكي::_check: ترتيب ويرايش بهينه نيست.",
"WikiDiff Okay: LCS = %s" => "تغييرات ويكي صحيح است:LCS= %s",
"Line:" => "خط:",
"Lines:" => "خطوط:",
"Newsletter subscription information at " => "اطلاعات مربوط به اشتراك خبرنامه در",
"Find" => "دنبال اين بگرد",
"find" => "بياب",
"prev" => "قبلي",
"Page" => "صفحه‌ي",
"next" => "بعدي",
"Link" => "پيوند",
"Page name" => "نام صفحه",
"Wiki Home" => "مبدا ويكي",
"Home" => "مبدا",
"Blog" => "بلاگ",
"previous page" => "صفحه‌ي قبل",
"next page" => "صفحه‌ي بعد",
"posted on" => "الصاق شده در",
"Continue" => "ادامه",
"By:" => "به‌وسيله‌ي:",
"Read" => "خوانده‌شده‌ها",
"List articles" => "فهرست مقالات",
"Last post" => "آخرين الصاق",
"Invalid imagename (using filters for filenames)" => "نام تصوير معتبر نيست (به دليل استفاده از فيلترها براي نام پرونده‌ها)",
"Errors detected" => "خطايي بوجود آمد",
"Upload was not successful" => "بارگذاري موفق نبود(Upload was not successful)",
"No image yet, sorry." => "متاسفم، هنوز هيچ تصويري وجود ندارد.",
"No valid ogr2ogr executable" => "ogr2ogr غيرقابل اجرا",
"Could not create \$tdo.mif in data directory" => "نمي‌توانم \$tdo.mif را در پوشه‌ي داده‌ها ايجاد كنم",
"Could not create \$tdo.mid in data directory" => "نمي‌توانم \$tdo.mid را در پوشه‌ي داده‌ها ايجاد كنم",
"unknown" => "ناشناخته",
"User Map Generated in:" => "نقشه‌ي كاربر توليد شده در:",
"Image Map Generated in:" => "تصوير كاربر ساخته شده در:",
"NONE" => "هيچكدام",
"File %s not found" => "پرونده‌ي %s يافت نشد",
"File %s is not a valid archive" => "پرونده‌ي %s يك بايگاني معتبر نيست",
"Impossible to open %s : %s" => "باز كردن %s غيرممكن است: %s",
"Wiki top pages" => "بهترين صفحات ويكي",
"Most relevant pages" => "مرتبط‌ترين صفحات",
"Relevance" => "رابطه",
"Wiki last pages" => "آخرين صفحات ويكي",
"Modified" => "تغيير كرده در:",
"Forums last topics" => "آخرين عناوين انجمن‌ها",
"Topic date" => "تاريخ عنوان",
"Forums last posts" => "آخرين الصاقات انجمن‌ها",
"Forums most read topics" => "پرخواننده‌ترين انجمن‌ها",
"Reads" => "تعداد دفعات مشاهده",
"Forums best topics" => "بهترين عناوين انجمن‌ها",
"Score" => "امتيازدهي",
"Forums most visited forums" => "پربيننده‌ترين انجمن‌ها",
"Visits" => "بازديدها",
"Forums with most posts" => "پر الصاق ترين پربيننده‌ترين",
"Posts" => "الصاق‌ها",
"Wiki top galleries" => "سرسراهاي برتر ويكي",
"Wiki top file galleries" => "سرسرهاي برتر پرونده‌هاي",
"Wiki top images" => "تصاوير برتر ويكي",
"Wiki top files" => "پرونده‌هاي برتر ويكي",
"Downloads" => "دريافت‌ها",
"Wiki last images" => "آخرين تصاوير ويكي",
"Upload date" => "تاريخ بارگذاري",
"Wiki last files" => "خرين پرونده‌هاي ويكي",
"Wiki top articles" => "برترين مقالات ويكي",
"Most visited blogs" => "پربيننده‌ترين بلاگ‌ها",
"Most active blogs" => "فعال‌ترين بلاگ‌ها",
"Blogs last posts" => "آخرين الصاق بلاگ",
"Post date" => "تاريخ الصاق",
"Wiki top authors" => "برترين مؤلفان ويكي",
"Pages" => "صفحات",
"Top article authors" => "برترين مؤلفان مقالات",
"User already exists" => "اين كاربر قبلا ايجاد شده بود",
"Wrong registration code" => "كد ثبت‌نام اشتباه است",
"Invalid username" => "نام كاربري معتبر نيست",
"Username is too long" => "نام كاربري پيش از حد بلند است",
"Username cannot contain whitespace" => "نام كاربر نمي‌تواند جاي خالي داشته باشد",
"Wrong passcode you need to know the passcode to register in this site" => "كدعبور اشتباه است. براي ثبت‌نام در اين پايگاه، بايد كدعبور را بدانيد",
"Invalid email address. You must enter a valid email address" => "آدرسي پست الكترونيكي معتبر نيست. بايد يك آدرس معتبر وارد كنيد",
"The registration mail can't be sent. Contact the administrator" => "پست الكترونيكي ثبت‌نام را نمي‌توانم ارسال كنيم. با سرپرست تماس بگيريد",
"Login" => "ورود",
"See other user's profile" => "مشاهده‌ي نمايه‌ي(profile) ساير كاربران",
"Have your profile seen" => " مشاهده‌ي نمايه‌ي(profile) خود توسط ديگر كاربران",
"Make friends" => "رفيق شدن",
"Receive message" => "دريافت پيغام",
"Send message" => "ارسال پپغام",
"Read an article" => "خواندن يك مقاله",
"Publish an article" => "انتشار يك مقاله",
"Have your article read" => "خوانده شدن مقاله",
"Create new file gallery" => "ايجاد يك سرسراي پرونده‌ي جديد",
"Upload new file to gallery" => "بارگذاري پرونده‌ي جديد به سرسرا",
"Download other user's file" => "دريافت پرونده‌هاي ساير كاربران",
"Have your file downloaded" => "دريافت شدن پرونده‌هاي بارگذاري شده",
"Create a new image gallery" => "ايجاد يك سرسراي جديد",
"Upload new image to gallery" => "بارگذاري تصوير جديد در سرسرا",
"See other user's gallery" => "مشاهده‌ي سرسراي تصاوير ديگر كاربران",
"See other user's image" => "مشاهده‌ي تصاوير ساير كاربران",
"Have your gallery seen by other user" => "مشاهده‌ي سرسراي خود به‌وسيله‌ي ديگر كاربران",
"Have your image seen" => "ديده‌شدن تصوير خود",
"Create new blog" => "يك بلاگ جديد ايجاد كن",
"Post in a blog" => "الصاق در يك بلاگ",
"Read other user's blog" => "خواندن بلاگ‌هاي ساير كاربران",
"Have your blog read" => "خوانده‌شدن بلاگ توسط ساير كاربران",
"Create a new wiki page" => "ساخت يك ويكي جديد",
"Edit an existing page" => "ويرايش يك صفحه‌ي موجود",
"Attach file" => "ضميمه كردن پرونده",
"Unknown" => "ناشناخته",
"Trackeritem" => "فقره‌ي tracker",
"Image" => "تصوير",
"Article" => "مقاله",
"Directory category" => "طبقه‌ي پوشه",
"FAQ" => "سئوالات متداول",
"Forum" => "انجمن",
"Gallery" => "سرسرا",
"File" => "پرونده",
"Blog post" => "الصاق بلاگ",
"Prev" => "قلي",
"Next" => "بعدي",
"Edit Template" => "ويرايش الگو",
"help" => "كمك",
"All" => "همه",
"The text is" => "متن عبارت است از",
"Date Selector" => "انتخاب‌گر تاريخ",
"phplayers are not available on this site" => "لايه‌هاي PHP در اين پايگاه فعال نيستند.",
"days" => "روز",
"day" => "روز",
"hours" => "ساعت",
"hour" => "ساعت",
"mins" => "دقيقه",
"min" => "دقيقه",
"secs" => "ثانيه",
"done" => "انجام شد",
"Text cut here" => "متن اين‌جا قطع مي‌شود",
"Task" => "وظيفه",
"from" => "از",
"for" => "براي",
"Priority" => "اولويت",
"Start date:" => "تاريخ شروع:",
"End date:" => "تاريخ پايان:",
"Friend" => "رفيق",
"Last seen on " => "آخرين بار روئيت شده در",
"(idle for %s seconds)" => "(بيكار براي %s ثانيه)",
"User information - Click for more info" => "اطلاعات كاربر – براي اطلاعات بيشتر اين‌جا را كليك كنيد",
"More info about \$other_user" => "اطلاعات بيشتر درخصوص \$other_user",
"(idle for \$idletime seconds)" => "(بيكار بري \$idletime ثانيه)",
"Use this tree to copy the structure" => "از اين درختواره براي كپي ساختار استفاده كن",
"created from structure" => "ايجاد شده از ساختار",
"Table of contents" => "فهرست",
"unknown error" => "خطاي نامشخص",
"You are not logged in" => "شما به سامانه وارد نشده‌ايد",
"Page cannot be found" => "چنين صفحه‌اي پيدا نشد",
"cannot be found" => "پيدا نشد",
"An error occured in a database query!" => "خطايي در يكي از درخواست‌ها به بانك اطلاعاتي رخ داد!",
"Help" => "كمك",
"You are banned from" => "دسترسي شما به اين بخش ممنوع شده است:",
"wiki" => "ويكي",
"img-g" => "تصوير-g",
"file-g" => "پرونده-g",
"faqs" => "سئوالات متداول",
"quizzes" => "آزمون‌ها",
"arts" => "هنرها",
"blogs" => "بلاگ‌ها",
"forums" => "انجمن‌ها",
"games" => "بازي‌ها",
"picture not found" => "تصوير پيدا نشد",
"drawing not found" => "نقاشي پيدا نشد",
"Click to edit dynamic variable" => "براي ويرايش متغيير پويا اين‌جا را كليك كنيد",
"Update variables" => "به‌روز رساني متغييرها",
"Show" => "نمايش بده",
"Hide" => "مخفي كن",
"Altering database table failed" => "دگرگون‌سازي(Altering) جدول بانك اطلاعاتي ناموفق بود",
"%d points" => " امتياز%d",
"Removed" => "حذف شد",
"__WARNING__: No such module \$plugin! " => "__اخطار__: چنين ماژولي وجود ندارد \$plugin! ",
"at" => "راس ساعت",
"new" => "جديد",
"Create page:" => "ساخت صفحه:",
"Unknown language" => "زبان ناشناخته",
"Click here to confirm your action" => "براي تاييد اين دكمه را بفشاريد",
"Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF)  كشف شدو عمليات مسدود شد.",
"Item Modification" => "تغيير فقره",
"Item" => "قلم",
"Item creation" => "ايجاد فقره",
"Tracker was modified at " => "Tracker در اين‌جا تغيير كرد  ",
"text field" => "رشته‌ي متني",
"size" => "اندازه",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "اختيارات رشته‌ي متني: 1، size، prepend،append،max. حجم(size)، به تعداد حرف؛ افزودن به ابتدا(prepend)، اطلاعات را به ابتداي ستون اضافه مي‌كند؛ افزودن به انتها(append)، اطلاعات را به انتهاي ستون اضافه مي‌كند؛ بيشينه(max)، بيشينه تعداد حروفي كه مي‌تواند ذخيره شود. 1 اوليه مشخص كننده‌ي اين مطلب كه ستون بعدي در همين سطر است",
"textarea" => "متن",
"checkbox" => "جعبه انتخاب(checkbox)",
"Checkbox options: put 1 if you need that next field is on the same row." => "انتخاب: برابر يك قرار دهيد اگر اين گزينه در همان ستون است.",
"numeric field" => "ستون عددي",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "اختيارات: 1، size، prepend،append،max. حجم(size)، به تعداد حرف؛ افزودن به ابتدا(prepend)، اطلاعات را به ابتداي ستون اضافه مي‌كند؛ افزودن به انتها(append)، اطلاعات را به انتهاي ستون اضافه مي‌كند؛ بيشينه(max)، بيشينه تعداد حروفي كه مي‌تواند ذخيره شود. 1 اوليه مشخص كننده‌ي اين مطلب كه ستون بعدي در همين سطر است",
"drop down" => "كركره‌اي",
"Dropdown options: list of items separated with commas." => "اختيارات ستون كركره‌اي: فهرست اقلام با كاما جدا مي‌شوند.",
"user selector" => "انتخاب كاربران",
"group selector" => "انتخاب گروه كاربري",
"Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "اختيارات: از اختياراتبراي تغذيه‌ي خودكار ستون استفاده كنيد. مي‌توانيد از 1 براي گروه كاربري ايجاد كننده و 2 براي گروه كاربري تغييردهنده استفاده كنيد. گروه اگر گروه كاربري پيش‌فرض تنظيم نشده باشد، اولين گروه كاربري براي هر كاربر استفاده مي‌شود و يا گروه پيش‌فرض 'ثبت‌نام كرده‌هاست'.",
"country selector" => "انتخاب كشور",
"date and time" => "زمان و تاريخ",
"jscalendar" => "تقويم JS",
"Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "اختيارات: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale همه به پيكسل.",
"action" => "عمل",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "اختيارات: Label,post,tiki-index.php,page. page:نام پرونده، highlight=متن",
"header" => "سرصفحه",
"category" => "طبقه",
"item link" => "پيوند به فقره",
"items list" => "فهرست اقلام",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "اختيارات: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere  نمايش‌گر فهرست displayFieldIdThere هستند كه اقلام در tracker مشخص‌شده با trackerId، كه fieldIdThere معادل fieldIdHere باشد.",
"email" => "پست الكترونيكي",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "اختيارات: 0،1و2. كه 0 آدرس را با عنوان متن ساده قرار مي‌دهد، 1 يك پست با كدهاي شانزده‌تايي قرار مي‌دهد(براي spamها و spiderها كار مشكل‌تر مي‌شود)، و 2 يك كد mailto با صورت عادي href قرار مي‌دهد.",
"Google Maps" => "نقشه‌هاي گوگل",
"system" => "سامانه",
"attachment" => "ضميمه",
"open" => "باز",
"pending" => "معلق",
"closed" => "بسته",
"Message" => "پيغام",
"No extra information for that attached file. " => "هيچ اطلاعات اضافي در خصوص پرونده‌ي ضميمه‌شده وجود ندارد ",
"child categories" => "طبقات فرزند",
"objects in category" => "اشياء در طبقه",
"Password should be at least" => "كلمهِ‌ي عبور بايد حداقل",
"characters long" => "حرف داشته باشد",
"Password must contain both letters and numbers" => "كلمه‌ي عبور بايد هم شامل حروف و و هم عدد باشد.",
"Company" => "سازمان",
"State" => "وضعيت",
"Country" => "كشور",
"Date" => "تاريخ",
"Title" => "عنوان",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "عبارت regex را مي‌گيرد و محتواي بين تگ‌هاي آن را تجزيه كرده با متن جايگزين مي‌كند",
"data" => "داده‌ها",
"one data per line" => "يك داده در هر خط",
"The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "pluin مربوط به SNARF، خود را جايگزين متن HTML مربوط به آن URL مي‌كند. Regex به‌صورت دلخواه",
"This data is put in a CODE caption." => "Plugin مربوط به SNARF خود را جايگزين بدنه‌ي HTML يك URL مي‌كند. جايگزيني Regex نيز با استفاده از regex يا regexres در محتوا ممكن خواهد بود كه مورد دوم به عنوان آرگوماني براي preg_replace استفاده خواهد شد.",
"Missing url parameter for SNARF plugin." => "پارامتر URL براي SNARF مفقود شده است",
"users" => "كاربران",
"Displays browser client info" => "نمايش اطلاعات مرورگر ارباب رجوع",
"Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "يك پيوند به يك لنگر(anchor) در صفحه‌اي از ويكي قرار مي‌دهد. در اتحاد با pluginاي كه نام و مكان لنگر را مشخص مي‌كند(ANAME) استفاده شود.",
"linktext" => "متن پيوند",
"Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "يك پيوند به يك لنگر(anchor) در صفحه‌اي از ويكي قرار مي‌دهد. در اتحاد با pluginاي كه پيوندبه لنگر را مي‌سازد(ALINK) استفاده شود.",
"No such attachment on this page" => "چنين پميمه‌اي در اين صفحه وجود ندارد",
"Displays an attachment or a list of them" => "يك ضميمه يا فهرستي از آن‌ها نمايش مي‌دهد",
"Displays the user Avatar" => "شكلك كاربر رو نمايش بده",
"username" => "نام كاربري",
"List all pages which link to specific pages" => "تمام صفحاتي كه به يك صفحه‌ي خاص اشاره مي‌كنند را فهرست مي‌كند",
"No pages links to" => "هيچ صفحه‌اي به اين مورد پيوند ندارد",
"One page links to" => "يك صفحه به اين مورد پيوند دارد",
"pages link to" => "صفحاتي كه به اين مورد پيوند دارند",
"Insert theme styled box on wiki page" => "جعبه‌ي سبك قيافه در صفحه‌ي ويكي قرار بگيرد",
"text" => "متن",
"Calendar" => "تقويم",
"Insert list of items for the current/given category into wiki page" => "در صفحات ويكي، فهرست اقلام طبقه‌ي جاري/انتخابي را درج كن",
"Categories are disabled" => "طبقات غيرفعال‌اند",
"Display Tiki objects that have not been categorized" => "اشياء تيكي كه طبقه‌بندي نشده‌اند را نمايش بده",
"Insert the full category path for each category that this wiki page belongs to" => "آدرس كامل طبقه را براي هر طبقه كه اين صفحه‌ي ويكي به آن تعلق دارد درج كن",
"Centers the plugin content in the wiki page" => "محتويات plugin را در مركز صفحه‌ي ويكي قرار بده",
"Chart" => "نام نمودار",
"title" => "عنوان",
"Displays a snippet of code" => "يه تيكه از كد را نمايش بده",
"code" => "دستورالعمل",
"note: colors and ln are exclusive" => "نكته: رنگ‌ها و ln اختصاصي هستند",
"Insert copyright notices" => "اطلاعيه‌ي حقوق انحصاري چاپ(copyright) را درج كن",
"Example" => "مثال",
"minutes" => "دقيقه",
"and" => "و-با-",
"seconds" => "ثانيه",
"Insert a division block on wiki page" => "يك بلاك تقسيم در صفحه‌ي ويكي قرار بده",
"Creates a definition list" => "يك فهرست تعريف تهيه كن",
"term" => "دوره",
"definition" => "معني",
"one definition per line" => "يك معني در هر خط",
"Upcoming events" => "رويدادهاي قريب‌الوقوع",
"Displays the data using the Tikiwiki odd/even table style" => "اطلاعات را با استفاده از سبك جدول زوج/فرد تيكي-ويكي نمايش بده",
"cells" => "سلول(ها)",
"heads and cells separated by ~|~" => "راس‌ها و سلول‌ها با  ~|~ از هم جدا مي‌شوند",
"Displays a SWF on the wiki page" => "نمايش يك پرونده‌ي SWF در صفحه‌ي ويكي",
"Displays a graphical GAUGE" => "يك پيمانه‌ي ترسيمي(Graphical GAUGE) نمايش بده",
"description" => "شرح",
"Include a page" => "شامل يك صفحه است",
"Displays the text only if the language matchs" => "فقط درصورتي كه زبان همخواني داشت متن را نمايش مي‌دهد",
"Feature disabled" => "خصيصه غيرفعال شد",
"Displays an miniquiz" => "يك نيم‌چه آزمون نمايش مي‌دهد",
"Please choose a module" => "لطفا يك ماژول انتخاب كنيد",
"to be used as argument" => "براي استفاده به‌عنوان آرگومان",
"Displays a module inlined in page" => "يك ماژول را در ميان صفحه نمايش مي‌دهد",
"Sorry no such module" => "متاسفانه چنين ماژولي وجود ندارد",
"Displays the data using a monospace font" => "داده‌ها را با استفاده از يك قلم monospace نمايش مي‌دهد",
"Provides a list of plugins on this wiki." => "يك فهرست از pluginهاي اين ويكي را نمايش مي‌دهد.",
"No version indicated" => "هيچ نسخه‌اي مشخص نشده است",
"No arguments indicated" => "هيچ آرگوماني مشخص نشده است",
"Displays the output of a poll, fields are indicated with numeric ids." => "خروجي يك راي‌گيري را نمايش مي‌دهد، ستون‌ها را اعداد مشخص مي‌شوند",
"missing poll ID for plugin POLL" => "شناسه‌ي راي‌گيري براي plugin راي‌گيري مفقود شده است",
"Automatically creates a link to the appropriate SourceForge object" => "به‌صورت خودكار يك پيوند به شيء مناسب در SourceForge ايجاد كن",
"TikiSheet" => "ورق‌‌هاي تيكي",
"Sheet Heading" => "سرصفحه‌ي ورق",
"List wiki pages" => "فهرست صفحات ويكي",
"Last modified by" => "آخرين بار به‌وسيله‌ي ايشان تغيير كرده است",
"Sorts the plugin content in the wiki page" => "مربت كردن محتواي يك plugin در صحفه‌ي ويكي",
"Edit" => "ويرايش",
"Split a page into rows and columns" => "انشعاب يك صفحه به سطرها و ستون‌ها",
"row1col1" => "سطر 1، ستون 1",
"row1col2" => "سطر 1، ستون 2",
"row2col1" => "سطر 2، ستون 1",
"row2col2" => "سطر 2، ستون 2",
"Missing db param" => "پارامتر بانك اطلاعاتي مفقود است",
"Run a sql query" => "اجراي يك جستار SQL",
"sql query" => "جستار SQL",
"Displays text in subscript." => "متن را در پانويس نمايش مي‌دهد",
"Displays the thumbnail for an image" => "تصويرك يك تصوير را نمايش مي‌دهد",
"Search the titles of all pages in this wiki" => "عناوين تمام صفحه‌هاي اين ويكي را جستجو كن",
"No pages found for title search" => "هيچ صفحه‌اي براي اين جستجو در عناوين يافت نشد",
"One page found for title search" => "يك صفحه در جستجوي عناوين يافت شد",
" pages found for title search" => " صفحه در جستجوي عناوين يافت شد",
"Error" => "خطا",
"Rating" => "رتبه‌بندي",
"Select All" => "انتخاب همه",
"Displays an input form for tracker submit" => "يك فرم ورودي براي ارائه‌ي tracker نمايش مي‌دهد",
"Fields marked with a * are mandatory." => "پركردن مواردي كه با * علامت زده شده‌اند اجباري است.",
"Filter" => "فيلتر",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "خروجي محتواي يك tracker را نمايش مي‌دهد، ستون‌ها با اعداد مشخص شده‌اند",
"Error in tracker ID" => "خطا در شناسه‌ي tracker",
"No field indicated" => "هيچ ستوني مشخص نشده است",
"Links to a translated content" => "به يك محتواي ترجمه شده پيوند مي‌زند",
"Displays the number of registered users" => "تعداد كاربران ثبت‌نام كرده را نمايش مي‌دهد",
"Split the text in parts visible only under some conditions" => "تنها در شرايط خاص، متن منشعب در بخش‌ها قابل روئيت است",
"External Wiki" => "ويكي‌هاي خارجي",
"valid" => "اعتبار",
"Plugin " => "Plugin مربوط به ",
"failed" => "ناموفق بود",
"ERROR: Either the subject or body must be non-empty" => "خطا: هيچ‌كدام از متن و موضوع نبايد خالي باشند",
"ERROR: No valid users to send the message" => "خطا: هيچ كاربر معتبري براي ارسال پيغام يافت نشد",
"Invalid user" => "كاربر نامعتبر است",
"Message sent to" => "پيغام ارسال شد به",
"Message will be sent to: " => "پيغام براي اين كاربران ارسال خواهد شد:",
"No more messages" => "پيغام‌هاي بيشتر مقدور نيست",
"Tiki Calendar" => "تقويم تيكي",
"Please provide an Id" => "لطفا يك شناسه فراهم كنيد",
"no object here yet" => "هنوز هيج شئيي اين‌جاي نيست",
"This module requires parameters trackerId and name set" => "اين ماژول نياز به تنظيم پارامترهاي trackerid و name دارد",
"Create/Edit" => "ايجاد/حذف",
"Quick Edit a Wiki Page" => "ويرايش سريع يك صفحه‌ي ويكي",
"new users" => "كاربران جديد",
"Since your last visit" => "از آخرين بازديد شما...",
"Changes" => "تغييرات",
"since" => "از",
"Changes since" => "تغييرات از",
"new comments" => "نظرات جديد",
"wiki pages changed" => "صفحه‌ي ويكي تغيير كرده‌اند",
"new articles" => "مقاله‌ي جديد",
"new FAQs" => "FAQ جديد",
"new sites" => "پايگاه‌هاي جديد",
"new blogs" => "بلاگ‌هاي جديد",
"new blog posts" => "الصاق‌هاي جديد بلاگ",
"new image galleries" => "سراسراهاي تصوير جديد",
"new images" => "تصاوير جديد",
"new file galleries" => "سراسراهاي پرونده‌ي جديد",
"new files" => "پرونده‌هاي جديد",
"new polls" => "راي‌گيري‌هاي جديد",
"The task title must have at least 3 characters" => "موضوع وظيفه، بايد حدااقل 3 حرف باشد",
"Invalid username or password" => "نام كاربري يا كلمه‌ي عبور معتبر نيست",
"Anti-Bot verification code" => "كد بازبيني ضد ماشيني(Anti-bot)",
"Random Image" => "تصوير تصادفي",
"Enter the code you see above" => "كدي كه در بالا مي‌بينيد را وارد كنيد",
"List of attached files" => "فهرست پرونده‌هاي ضميمه شده",
"id" => "شناسه",
"desc" => "توضيحات",
"uploaded" => "بارگذاري شده",
"View" => "مشاهده",
"Download" => "دريافت",
"Delete" => "حذف",
"Remove" => "حذف",
"Upload file" => "بارگذاري پرونده",
"Attach" => "ضميمه",
"Attach a file to this item" => "يك پرونده به اين فقره ضميمه كن",
"Version" => "نسخه",
"Attachments" => "ضمايم",
"more info" => "اطلاعات بيشتر",
"No attachments for this item" => "اين فقره هيچ ضميمه‌اي ندارد",
"debug" => "اشكال‌زدايي",
"Fatal error" => "خطاي مهلك",
"Description:" => "شرح:",
"Created by" => "ايجاد شده توسط",
" on " => " در ",
"Post" => "الصاق",
"RSS feed" => "تغذيه‌ي RSS",
"Edit blog" => "ويرايش بلاگ",
"Monitor this Blog" => "اين بلاگ را ديده‌باني كن",
"Stop Monitoring this Blog" => "ديده‌باني اين بلاگ را متوقف كن",
"Activity=" => "فعاليت=",
"Actions" => "اقدامات",
"Properties" => "خصوصيات",
"No records found" => "هيچ ركوردي يافت نشد.",
"Category" => "طبقه",
"Categorize" => "طبقات",
"Show Categories" => "طبقات را نمايش بده",
"Hide Categories" => "طبقات را مخفي كن",
"Tip" => "نكته",
"categorize this object" => "اين شيء را طبقه‌بندي كن",
"No categories defined" => "هيچ طبقه‌اي تعريف نشده است",
"Admin Categories" => "مديريت طبقه‌بندي‌ها",
"Browse Category" => "مرور طبقه",
"on" => "در",
"stars" => "شروع",
"User Level" => "سطح كاربر",
"private message" => "پيغام شخصي",
"Send eMail to User" => "ارسال پست الكترونيكي به كاربر",
"user online" => "كاربر روي خط است",
"user offline" => "كاربر خارج خط است",
"Attachment" => "ضميمه",
"Vote" => "اخذ راي",
"Reply" => "پاسخ",
"Save to notepad" => "ذخيره در دفترچه‌ي يادداشت",
"Monitor this Topic" => "اين عنوان را ديده‌باني كن",
"Stop Monitoring this Topic" => "ديده‌باني اين عنوان با متوقف كن",
"Moderator actions" => "اعمال ناظم",
"reported:" => "گزارش داده شده:",
"queued:" => "درصف قرار گرفته:",
"Move to topic:" => "به اين موضوع منتقلش كن:",
"Move" => "تغيير مكان",
"Delete Selected" => "انتخاب شده‌ها را حذف كن",
"Messages" => "پيغام",
"Style" => "سبك",
"Plain" => "ساده",
"Threaded" => "مانند نخ كشيده",
"Headers Only" => "فقط سرفصل",
"Sort" => "مرتب بر اساس",
"Newest first" => "ابتدا جديدترها",
"Oldest first" => "ابتدا قديمي‌ترها",
"Title (desc)" => "عنوان (نزولي)",
"Title (asc)" => "عنوان (صعودي)",
"Threshold" => "آستانه",
"Search" => "جستجو",
"Set" => "تنظيم",
"Replies" => "پاسخ‌ها",
"below your current threshold" => "پايين‌تر از حد آستانه‌ي شما",
"New Reply" => "پاسخ جديد",
"Editing reply" => "ويرايش پاسخ",
"Preview" => "پيش‌نمايش",
"Reply to the selected post" => "پاسخ به الصاق‌هاي انتخاب شده",
"Editing comment" => "ويرايش نظر",
"Comment on the selected post" => "ايراد نظر درمورد الصاق انتخاب شده",
"Post new comment" => "ايراد نظر جديد",
"Required" => "(اجباري)",
"Smileys" => "صورتك‌ها",
"Quicktags" => "تگ‌هاي سريع",
"Reply to parent post" => "پاسخ به نظر مادر",
"Post new reply" => "الصاق يك پاسخ جديد",
"Cancel" => "لغو",
"Posting replies" => "الصاق پاسخ",
"Posting comments" => "نظرهاي الصاقات",
"Use" => "استفاده كنيد",
"or" => "يا",
"for links" => "براي پيوندها، از",
"HTML tags are not allowed inside posts" => "كدهاي HTML داخل الصاق‌ها مجاز نيستند",
"Go back" => "به جاي قبلي بازگرد",
"Return to home page" => "به صفحه‌ي مبدا بازگرد",
"Copyrights" => "حقوق انصحاري چاپ",
"Year" => "سال",
"Authors" => "مولفين",
"Add" => "اضافه كن",
"Syntax" => "نحو",
"Page generation debugging log" => "ثبت رويداد اشكال‌زدايي توليد صفحه",
"Features state" => "آمار خصايص",
"Total" => "مجموع",
"features matched" => "خصايص هم‌خواني دارند",
"Watchlist" => "فهرست ديده‌بان‌ها",
"duplicate" => "تكراري است",
"There are individual permissions set for this file gallery" => "حقوق دسترسي فردي براي اين سرسراي پرونده تنظيم شده است",
"Save" => "ذخيره كن",
"Gallery is visible to non-admin users?" => "سرسرا براي كاربران عادي(غير سرپرست) نيز قابل ديدن است؟",
"unlimited" => "نامحدود",
"none" => "هيچكدام",
"Parent gallery" => "سرسراي مادر",
"Owner of the gallery" => "مالك سرسرا",
"Default sort order" => "مرتب‌سازي پيش‌فرض",
"descending" => "نزولي",
"ascending" => "صعودي",
"Max description display size" => "بيشينه اندازه‌ي نمايش شرح",
"Max Rows per page" => "بيشينه سطرها در هر صفحه",
"Listing configuration" => "پيكربندي فهرست‌سازي",
"There are no wiki pages similar to '{\$page}'" => "هيج صفحه‌ي ويكي مشابه '{\$page}' وجود ندارد",
"Create this page" => "اين صفحه را ايجاد كن",
"Close Window" => "پنچره را ببند",
"Active Perms" => "حقوق دسترسي فعال",
"Perms" => "حقوق دسترسي‌ها",
"Display" => "نمايش",
"Unlock" => "بازكردن قفل",
"Lock" => "قفلش كن",
"Name-filename" => "نام-نام پرونده",
"Filename only" => "تنها نام پرونده",
"Number of displayed rows" => "تعداد رديف‌هايي كه بايد نمايش داده شود",
"RSS Wiki" => "RSS براي ويكي",
"RSS Blogs" => "RSS براي بلاگ‌ها",
"RSS Articles" => "RSS براي مقالات",
"RSS Image Galleries" => "RSS براي سرسراهاي تصاوير",
"RSS File Galleries" => "RSS براي سرسراهاي تصاوير",
"RSS Forums" => "RSS برا انجمن‌ها",
"RSS Maps" => "RSS براي نقشه‌ها",
"RSS Directories" => "RSS براي پوشه‌ها",
"Perform action with checked:" => "با انتخاب شده‌ها:",
"Move Selected Files" => "پرونده‌هاي انتخاب شده را منتقل كن",
"Move to" => "انتقال به",
"Filename" => "نام پرونده",
"Hi {\$mail_user} has sent you this link:" => "سلام، {\$mail_user} براي شما اين پيوند را ارسال كرده است",
"Blog post:" => "الصاق بلاگ:",
"at:" => "در:",
"Somebody or you tried to subscribe this email address at our site:" => "شما يا شخص ديگري، سعي در مشترك كردن اين پست الكترونيكي در اين پايگاه داشته‌اند:",
"To the newsletter:" => "به خبرنامه‌ي:",
"In order to confirm your subscription you must access the following URL:" => "براي تاييد اشتراك خود، بايد اين پيوند را دنبال كنيد:",
"A new message was posted to forum" => "يك پيغام جديد به انجمن الصاق شده است",
"New topic:" => "عنوان جديد:",
"Topic:" => "عنوان:",
"You sent a request with the subject:" => "شما يك درخواست با اين موضوع فرستاده‌ايد:",
"Use the subject to indicate the operation to apply:" => "از موضوع براي مشخص كردن عملي كه بايد اجرا شود استفاده كنيد:",
"GET:WikiName to get a wiki page" => "GET:'نام ويكي'، براي گرفتن نام صفحه‌ي ويكي",
"PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:'نام ويكي'، براي به‌روز رساني/ايجاد يك صفحه‌ي ويكي (از بدنه(body) براي اطلاعات صفحه استفاده كنيد)",
"APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:'نام ويكي'، براي افزودن داده به يك صفحه‌ي ويكي (از بدنه(body) براي اطلاعات صفحه استفاده كنيد)",
"PREPEND:WikiName to append the data at the top" => "PREPEND:'نام ويكي'، براي افزودن داده با بالاي صفحه",
"Tiki mail-in instructions" => "دستورالعمل 'كنترل با پست الكترونيكي' تيكي",
"Tiki mail-in auto-reply." => "پاسخ خودكار 'كنترل با پست الكترونيكي' تيكي.",
"Page not found:" => "صفحه پيدا نشد:",
"Hi," => "سلام،",
"A new message was posted to you at {\$mail_machine}" => "يك پست الكترونيكي در {\$mail_machine} براي شما ارسال شده است",
"From" => "از طرف",
"Subject" => "موضوع",
"New message arrived from %s" => " يك پيغام جديد ازطرف %s دريافت شد",
"Hi" => "سلام",
"Enjoy the site!" => "از اين پايگاه لذت ببريد!",
"has requested an account on" => "درخواست يك حساب در اين‌جا كرده است",
"To validate that account, please follow the link:" => "براي معتبر ساخت آن حساب، لطفا اين پيوند را دنبال كنيد:",
"best regards" => "با احترام",
"your Tikiwiki" => "تيكي-ويكي شما",
"Tiki User Registration Request" => "درخواست عضويت كاربر در تيكي",
"You're invited to join my network of friends!" => "شما براي پيوستن به شبكه‌ي رفقاي من دعوت شده‌ايد!",
"The user" => "كاربر",
"registered at your site" => "در پايگاه شما ثبت‌نام كرد",
"New user registration" => "ثبت‌نام كاربر جديد",
"Bye bye!" => "خداحافظ!",
"This email address has been removed to the list of subscriptors of:" => "اين پست الكترونيكي به از فهرست مشتركين اين بخش حذف شد:",
"Newsletter:" => "خبرنامه:",
"Bye bye from %s at %s" => "از %s در %s خداحافظ",
"You can unsubscribe from this newsletter following this link" => "با دنبال كردن اين پيوند، شما مي‌توانيد عضويت خود را از اين خبرنامه لغو كنيد",
"Welcome to our newsletter!" => "به خبرنامه‌ي ما خوش‌آمديد!",
"This email address has been added to the list of subscriptors of:" => "اين آدرس پست الكترونيكي اضافه شد به فهرست اشتراك‌هاي:",
"You can always cancel your subscription using:" => "شما همواره مي‌توانيد اشتراك خود را بدين‌طريق لغو نماييد:",
"Welcome to %s at %s" => "به %s در %s خوش‌آمديد",
"Tiki email notification" => "آگاه‌ساز پست الكترونيكي تيكي",
"Your Tiki account information for %s" => "اطلاعات حساب تيكي شما براي %s",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "يك مقاله‌ي جديد به‌وسيله‌ي {\$mail_user} به {\$mail_site} در {\$mail_date|tiki_short_datetime} ارسال شد",
"You can edit the submission following this link:" => "با دنبال كردن اين پيوند مي‌تواند مورد ارسال شده را ويرايش كنيد:",
"Title:" => "عنوان:",
"Heading:" => "سرصفحه:",
"Body:" => "متن:",
"New article submitted at %s" => "مقاله‌ي جديد در %s ثبت شد",
"View the tracker item at:" => "فقره‌ي tracker را در اين‌جا مشاهده كنيد:",
"you or someone registered this email address at" => "شما يا شخص ديگري اين آدرس پست الكترونيكي را در اين‌جا ثبت كرده است:",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "درصورتي كه مي‌خواهيد در اين پايگاه ثبت‌نام كنيد، بايد از اين پيوند براي اولين ورود استفاده نماييد:",
"Your Tiki information registration" => "اطلاعات ثبت‌نام تيكي شما",
"You will receive an email with information to login for the first time into this site" => "شما يك پست الترونيكي با اطلاعات كافي براي اولين ورود به اين پايگاه دريافت خواهيد كرد",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Your account request has been stored and will be activated by the admin as soon as possible.",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "الصاق مقاله‌ي جديد: {\$mail_title} به‌وسيله‌ي {\$mail_user} در {\$mail_date|tiki_short_datetime}",
"View the article at:" => "مقاله را در اين‌جا مشاهده كنيد:",
"If you don't want to receive these notifications follow this link:" => "درصورتي كه نمي‌خواهيد اين اطلاعيه‌ها را دريافت كنيد، اين پيوند را دنبال نماييد:",
"New article post at %s" => "الصاق مقاله‌ي جديد در %s",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "الصاق جديد در بلاگ: {\$mail_title}, \"{\$mail_post_title}\", به‌وسيله‌ي {\$mail_user} در {\$mail_date|tiki_short_datetime}",
"View the blog at:" => "بلاگ را در اين‌جا مشاهده كنيد:",
"New blog post at %s" => "الصاق جديد بلاگ در %s",
"changed" => "تغيير كرد",
"created" => "ايجاد شده",
"New" => "جديد",
"File Description" => "شرح پرونده",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "نقشه‌ي {\$mail_page} به‌وسيله‌ي {\$mail_user} در {\$mail_date|tiki_short_datetime} تغيير كرد",
"You can view the updated map following this link:" => "با دنبال كردن اين پيوند، مي‌توانيد نقشه‌ي به‌روز رساني شده را مشاهده كنيد:",
"You can edit the map following this link:" => "با دنبال كردن اين پيوند، مي‌توانيد نقشه را ويرايش كنيد:",
"Object" => "شئي",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "صفحه‌ي {\$mail_page} به‌وسيله‌ي  {\$mail_user} در {\$mail_date|tiki_short_datetime} ايجاد شد",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "صفحه‌ي {\$mail_page} به‌وسيله‌ي {\$mail_user} در {\$mail_date|tiki_short_datetime} تغيير كرد.",
"Comment:" => "ايراد نظر:",
"You can view the page by following this link:" => "مي‌توانيد با دنبال كردن اين پيوند، صفحه را مشاهده كنيد:",
"You can view a diff back to the previous version by following this link:" => "مي‌توانيد اختلاف با نسخه‌ي قبل را با دنبال كردن اين پيوند مشاهده كنيد:",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-خطوط: {\$oldd}به +خطوط: {\$newd} تغيير كرد",
"The new page content follows below." => "محتواي جديد صفحه در ادامه است.",
"Wiki page %s changed" => "صفحه‌ي %s ويكي تغيير كرده است",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "نظر {\$mail_date|tiki_short_datetime} به صفحه‌ي {\$mail_page} توسط {\$mail_user} ايراد شد",
"New name" => "نام جديد",
"click on the map to zoom or pan, do not drag" => "براي بزرگنمايي يا حركت در نقشه، فقط كليك كنيد، نكشيد",
"Scale" => "مقياس",
"Query" => "جستار",
"Pan" => "حركت طولي-عرضي",
"Redraw" => "دوباره بكش",
"select zoom/pan/query and image size" => "اندازه‌ي تصوير و بزرگنمايي/حركت/جستار را انتخاب كنيد",
"Go" => "بگرد",
"View the Map Only" => "تنها نقشه را نمايش بده",
"Reset Map" => "نقشه را بازنشاني كن",
"Click on the map or click redraw" => "روي نقشه يا دكمه‌ي 'دوباره بكش' كليك كنيد",
"Comments" => "نظرات",
"Last modification date" => "تاريخ آخرين تغييرات",
"Overview" => "نمايش",
"Legend" => "علائم اختصاري",
"Layer Manager" => "مدير لايه‌ها",
"Layer" => "لايه",
"On" => "در",
"Label" => "برچسب",
"Download Layer" => "دريافت لايه",
"you have requested to download the layer:" => "شما درخواست دريافت اين لايه را داده‌ايد:",
"Here are the files to download, do not forget to rename them:" => "پرونده‌ها براي دريافت آماده‌اند، فراموش نكنيد كه نام آن‌ها را تغيير دهيد.",
"Mapfiles" => "پرونده‌هاي نقشه",
"Mapfile" => "پرونده‌ي نقشه",
"Available mapfiles" => "پرونده‌هاي نقشه‌ي موجود",
"hits last 7 days" => "ضربت در هفت روز گذشته",
"monitor this map" => "اين نقشه را ديده‌باني كن",
"Stop Monitoring this Map" => "ديده‌باني اين نقشه را متوقف كن",
"Create a new mapfile" => "ساخت يك پرونده‌ي نقشه‌ي جديد",
"Create" => "بساز",
"Mapfile listing" => "فهرست پرونده‌هاي نقشه‌ها",
"Reload" => "باركردن مجدد",
"History" => "تاريخچه",
"You can view this map in your browser using" => "با استفاده از اين مي‌توانيد اين نقشه را در مرورگر خود مشاهده كنيد",
"Zoom out x2" => "بزرگنمايي 2برابر",
"Zoom in x2" => "بزرگنمايي 2برابر",
"Mapfile History" => "تاريخچه‌ي پرونده‌ي نقشه",
"of" => "از",
"Compare" => "مقايسه كن",
"Comparing version {\$old.version} with version {\$new.version}" => "مقايسه‌ي نسخه‌ي {\$old.version} با نسخه‌ي {\$new.version}",
"Version:" => "نسخه:",
"Current" => "جاري",
"Versions are identical" => "نسخ مشابه‌اند.",
"Legend:" => "علائم:",
"v=view" => "v=مشاهده‌ي اطلاعات",
"c=compare" => "c=مقايسه",
"d=diff" => "d=تفاوت‌ها",
"Full side-by-side diff" => "اختلافات پهلو به پهلوي كامل",
"Unified diff" => "اختلافات يك‌جهته",
"Side-by-side view" => "مشاهده‌ي پهلو به پهلو",
"User" => "كاربر",
"Ip" => "آدرس اينترنتي(IP)",
"Action" => "عمل",
"Diff" => "تغييرات",
"Older Version" => "نسخ قبلي",
"Directories" => "پوشه‌ها",
"back to" => "برگشت به",
"Upload From Disk:" => "بارگذاري از دستگاه:",
"Upload Files" => "بارگذاري پرونده",
"Bytes maximum" => "بيشينه",
"Create Directory:" => "ايجاد پوشه:",
"index file (.shp):" => "پرونده‌ي ايندكس(.shp):",
"files to index (regexp):" => "پرونده‌ها براي ايندكس‌گذاري(regexp):",
"Message Archive" => "بايگاني پيغام‌ها",
"Edit template" => "ويرايش الگو",
"messages" => "پيغام‌ها",
"Unread" => "نخوانده",
"Flagged" => "علامت زده‌شده",
"Unflagged" => "بدون علامت",
"Containing" => "شامل",
"Sender" => "فرستنده",
"No messages to display" => "هيچ پيغامي براي نمايش وجود ندارد.",
"Broadcast message" => "پيغام را براي همه ارسال كن",
"Message Broadcast" => "ارسال همگاني پيغام",
"OK" => "قبول",
"Group" => "نام گروه",
"All users" => "تمام كاربران",
"Lowest" => "كم‌ترين ارزش",
"Low" => "كم",
"Normal" => "عادي",
"High" => "زياد",
"Very High" => "خيلي زياد",
"Send" => "بفرست",
"Compose message" => "ايجاد پيغام",
"Compose Message" => "ايجاد پيغام",
"Invalid" => "نامعتبر",
"To" => "به",
"CC" => "رونشت",
"BCC" => "رونوشت تاريك",
"Find replied message" => "پاسخ ارسالي را بياب",
"Archive" => "بايگاني",
"Mark as read" => "به عنوان خوانده‌شده",
"Mark as unread" => "به عنوان خوانده‌نشده",
"Mark as flagged" => "به عنوان علامت‌دار",
"Mark as unflagged" => "به عنوان بدون علامت",
"Mark" => "علامت بزن",
"Mailbox" => "صندوق پستي",
"Compose" => "ايجاد پيغام",
"Broadcast" => "ارسال همگاني",
"Sent" => "ارسال شده‌ها",
"Read message" => "خواندن پيغام",
"Return to mailbox" => "بازگشت به صندوق پستي",
"replyall" => "پاسخ به همه",
"Unflag" => "بدون علامت",
"Flag this message" => "اين پيغام را علامت بزن",
"Cc" => "رونشت",
"Sent Messages" => "پيغام‌هاي ارسال شده",
"move to archive" => "انتقال به بايگاني",
"receiver" => "گيرنده",
"No" => "خير",
"'name' parameter for tikimodule missed" => "پارامتر 'نام'(name) براي ماژول‌هاي تيكي مفقود شده است.",
"Move module up" => "ماژول را بالا ببر",
"Up" => "بالا",
"Move module down" => "ماژول را پايين ببر",
"Down" => "پايين",
"Move module to opposite side" => "ماژول را به طرف مقابل ببر",
"opp side" => "طرف مقابل",
"Unassign this module" => "اين ماژول را از انتصاي در بياور",
"Are you sure you want to unassign this module?" => "آيا از خروج انتصاب را تاييد مي‌كنيد؟",
"Admin Menu" => "مديريت منو",
"Live support" => "پشتيباني زنده",
"Banning" => "تحريم كردن",
"Users" => "كاربران",
"Groups" => "گروه‌هاي كاربري",
"Cache" => "نهان‌ها(Cache)",
"Modules" => "ماژول‌ها",
"Links" => "پيوندها",
"Hotwords" => "واژگان آتشين",
"RSS modules" => "ماژول‌هاي RSS",
"Menus" => "فهرست‌هاي انتخاب",
"Polls" => "راي‌گيري‌ها",
"Mail notifications" => "آگاه‌ساز‌هاي پستي",
"Search stats" => "آمار جستجو‌ها",
"QuickTags" => "تگ‌هاي سريع",
"Chat" => "گپ‌زني(chat)",
"Categories" => "طبقات",
"Banners" => "درفش‌ها",
"Edit templates" => "ويرايش الگوها",
"Admin drawings" => "مديريت Drawings",
"Dynamic content" => "محتوي پويا",
"Cookies" => "كوكي‌ها",
"Mail-in" => "كنترل با پست الكترونيكي",
"Content templates" => "الگوهاي محتوا",
"HTML pages" => "صفحات HTML",
"Shoutbox" => "فريادگاه",
"Shoutbox Words" => "كلمات فريادگاه",
"Referer stats" => "آمار مراجعات",
"Import PHPWiki Dump" => "وارد كردن  PHPWiki Dump",
"phpinfo" => "اطلاعات php",
"Admin dsn" => "مديريت DSNها",
"External wikis" => "ويكي‌هاي خارجي",
"System Admin" => "مديريت سامانه",
"Security Admin" => "مديريت امنيت",
"Syntax highlighting" => "برجسته‌سازي نحو",
"Menu" => "منو",
"Contact us" => "تماس با ما",
"Stats" => "آمار",
"Games" => "بازي‌ها",
"MyMenu" => "فهرست‌هاي انتخاب من",
"MyTiki" => "تيكي من",
"MyTiki home" => "مبدا تيكي من",
"Preferences" => "تنظيمات",
"Tasks" => "وظايف",
"Bookmarks" => "صفحه‌ياب‌ها",
"Newsreader" => "اخبارگو",
"Webmail" => "پست تحت وب",
"Notepad" => "دفترچه يادداشت",
"My files" => "پرونده‌هاي من",
"User menu" => "منوي كاربر",
"Mini calendar" => "تقويم جيبي",
"My watches" => "ديده‌بان‌هاي من",
"WfMenu" => "منوي WF",
"Workflow" => "گردش كار",
"Admin processes" => "مديريت فرايندها",
"Monitor processes" => "ديده‌باني فرايندها",
"Monitor activities" => "ديده‌باني فعاليت‌ها",
"Monitor instances" => "ديده‌باني نمونه‌ها",
"User processes" => "فرايندهاي كاربر",
"User activities" => "فعاليت‌هاي كاربر",
"User instances" => "نمونه‌هاي كاربر",
"FriendsMenu" => "منو رفيقان",
"Community" => "اجتماع",
"User list" => "فهرست كاربران",
"Friendship Network" => "شبكه‌ي رفاقت",
"WikiMenu" => "منو ويكي",
"Last changes" => "آخرين تغييرات",
"Dump" => "تخليه(dump)",
"Rankings" => "رتبه‌بندي‌ها",
"List pages" => "فهرست صفحات",
"Orphan pages" => "صفحات يتيم",
"Sandbox" => "دست‌گرمي",
"Print" => "چاپ",
"Send pages" => "ارسال صفحات",
"Received pages" => "صفحات دريافت شده",
"Structures" => "ساختارها",
"GalMenu" => "منوي سرسراها",
"Image Galleries" => "سرسراهاي تصاوير",
"Galleries" => "سرسراها",
"Upload image" => "بارگذاري تصوير",
"System gallery" => "سرسراي سامانه",
"Articles home" => "مبدا مقالات",
"Submit article" => "ارائه‌ي مقاله",
"View submissions" => "مشاهده‌ي ارائه‌ها",
"Send articles" => "مقالات را بفرست",
"Received articles" => "مقالات دريافت شده",
"Admin topics" => "مديريت عناوين",
"Admin types" => "مديريت انواع",
"List blogs" => "فهرست بلاگ‌ها‌",
"Create/Edit blog" => "ساخت/ويرايش بلاگ‌",
"Admin posts" => "الصاق‌هاي سرپرست",
"ForMenu" => "منوي انجمن",
"List forums" => "فهرست انجمن‌ها",
"Admin forums" => "مديريت انجمن‌ها",
"DirMenu" => "منوي پوشه",
"Submit a new link" => "ارائه‌ي يك پيوند جديد",
"Browse directory" => "مرور پوشه",
"Admin directory" => "مديريت پوشه",
"FileGalMenu" => "منوي سرسراي پرونده",
"File Galleries" => "سرسراهاي پرونده‌ها",
"List galleries" => "فهرست سرسراها",
"List FAQs" => "فهرست سئوالات متداول",
"Admin FAQs" => "مديريت سئوالات متداول",
"Maps" => "نقشه‌ها",
"Layer management" => "مديريت لايه‌ها",
"QuizMenu" => "منوي آزمون",
"List quizzes" => "فهرست آزمون‌ها",
"Quiz stats" => "‌وضعيت آزمون‌ها",
"Admin quiz" => "مديريت آزمون‌ها",
"ShtMenu" => "منوي كوتا",
"TrkMenu" => "منوي tracker",
"List trackers" => "فهرست trackerها",
"Admin trackers" => "مديريت trackerها",
"SrvMenu" => "منوي نظرسنجي",
"Surveys" => "نظرسنجي‌ها",
"List surveys" => "فهرست نظرسنجي‌ها",
"Admin surveys" => "مديريت نظرسنجي‌ها",
"Newsletters" => "خبرنامه‌ها",
"Send newsletters" => "ارسال خيرنامه‌ها",
"Admin newsletters" => "مديريت خبرنامه‌ها",
"Events" => "رويدادها",
"Send events" => "رويدادهاي را بفرست",
"Admin events" => "مديريت رويدادها",
"EphMenu" => "منوي سالمانه",
"Ephemerides" => "سالنامه",
"Ephemerides Admin" => "مديريت سالنامه",
"ChartMenu" => "فهرست نمودار",
"Charts Admin" => "مديريت نمودارها",
"AdmMenu" => "منو سرپرست",
"Admin" => "سرپرستي",
"Admin home" => "مديريت",
"Theme control" => "تنظيم قيافه(Theme)",
"Drawings" => "نقاشي‌ها",
"Edit languages" => "ويرايش زبان‌ها",
"Integrator" => "كامل كننده",
"DSN" => "DSNها",
"Mods Admin" => "مديريت ماژول‌ها",
"UsrMenu" => "منو كاربر",
"Click here to manage your personal menu" => "براي مديريت منو شخصي خود، اين‌جا را كليك كنيد.",
"User Menu" => "منو براي هر كاربر",
"Tikiwiki Assistant" => "دستيار تيكي‌ويكي",
"Thank you for installing Tikiwiki" => "از اينكه تيكي‌ويكي را نصب كرده‌ايد متشكريم",
"Select" => "انتخاب",
"Admin Modules" => "مديريت ماژول‌ها",
"Admin Menus" => "مديريت منو",
"login" => "ورود",
"Recently visited pages" => "صفحاتي كه به تازگي روئيت شده‌اند",
"January" => "ژانويه",
"February" => "فوريه",
"March" => "مارس",
"April" => "آوريل",
"May" => "مي",
"June" => "جون",
"July" => "جولاي",
"August" => "اگوست",
"September" => "سپتامبر",
"October" => "اكتبر",
"November" => "نوامبر",
"December" => "دسامبر",
"Monday" => "دو شنبه",
"Tuesday" => "سه شنبه",
"Wednesday" => "چهار شنبه",
"Thursday" => "پنج شنبه",
"Friday" => "جمعه",
"Saturday" => "شنبه",
"Sunday" => "يك شنبه",
"Today" => "امروز",
"Received objects" => "اشياء دريافت شده",
"Pages:" => "صفحات:",
"Last `\$module_rows` Sites" => "آخرين پايگاه‌هاي `\$module_rows`",
"Last Sites" => "آخرين پايگاه‌ها",
"Directory Stats" => "آمار پوشه",
"Sites" => "پايگاه‌ها",
"Sites to validate" => "پايگاهي كه بايد تعيين اعتبار شود",
"Searches" => "جستجوها",
"Visited links" => "پيوندهاي مشاهده شده",
"Top \$module_rows Sites" => "\$module_rows پايگاه برتر",
"Top Sites" => "پايگاه‌هاي برتر",
"Current events" => "رويدادهاي جاري",
"Featured links" => "پيوندهاي خاص",
"Top `\$module_rows` topics" => "موضوعات `\$module_rows` فوقاني",
"Top topics" => "برترين عناوين",
"Last `\$module_rows` forum posts" => "آخرين `\$module_rows` الصاق انجمن",
"Last forum posts" => "آخرين الصاق‌هاي انجمن",
"Last `\$module_rows` forum topics" => "آخرين `\$module_rows` موضوعات انجمن",
"Last forum topics" => "آخرين موضوعات انجمن",
"Most commented forums" => "انجمن‌هايي با بيشترين نظرات",
"Most read topics" => "پربيننده‌ترين الصاق‌ها",
"Most visited forums" => "پربيننده‌ترين انجمن‌ها",
"Google Search" => "جستجوي گوگل",
"Last `\$module_rows` actions" => "آخرين `\$module_rows` عمل",
"Last actions" => "آخرين اعمال",
"Last `\$module_rows` articles" => "آخرين `\$module_rows` مقاله",
"Last articles" => "آخرين مقالات",
"Last `\$module_rows` blog posts" => "آخرين `\$module_rows` الصاق بلاگ",
"Last blog posts" => "آخرين الصاق‌هاي بلاگ",
"Last" => "آخرين",
"Last `\$module_rows` Created blogs" => "آخرين `\$module_rows` بلاگ‌ها ساخته شده",
"Last Created blogs" => "آخرين بلاگ ساخته شده‌",
"Last `\$module_rows` Created FAQs" => "آخرين `\$module_rows` FAQي ايجاد شده",
"Last Created FAQs" => "آخرين FAQهاي ايجاد شده",
"Last `\$module_rows` Created Quizzes" => "آخرين `\$module_rows` آزمون ايجاد شده",
"Last Created Quizzes" => "آخرين آزمون‌هاي ايجاد شده",
"Last `\$module_rows` modified file galleries" => "آخرين `\$module_rows` سرسراي پرونده‌ي تغيير يافته",
"Last modified file galleries" => "آخرين سرسراهاي پرونده‌ي تغيير يافته",
"Last `\$module_rows` Files" => "`\$module_rows` پرونده‌ي آخر",
"Last Files" => "آخرين پرونده‌ها",
"Last `\$module_rows` galleries" => "`\$module_rows` سرسراي آخر",
"Last galleries" => "آخرين سرسراها",
"Last `\$module_rows` Images" => "`\$module_rows` تصوير آخر",
"Last Images" => "آخرين تصاوير",
"Last `\$module_rows` modified events" => "آخرين `\$module_rows` رويداد تغيير كرده",
"Last modifed events" => "آخرين رويدادهاي تغيير كرده",
"Last `\$module_rows` changes" => "`\$module_rows` تغيير آخر",
"Last `\$module_rows` Modified Items" => "آخرين `\$module_rows` اقلام تغيير كرده",
"Last Modified Items" => "اقلام تغيير كرده",
"Last `\$module_rows` Modified blogs" => "آخرين `\$module_rows` بلاگ تغيير كرده‌",
"Last Modified blogs" => "آخرين بلاگ‌هاي تغيير كرده‌",
"Last `\$module_rows` submissions" => "`\$module_rows` ارائه‌ي آخر",
"Last submissions" => "آخرين ارائه‌ها",
"Last `\$module_rows` Items" => "`\$module_rows` فقره‌ي آخر",
"Last Items" => "آخرين اقلام",
"Last `\$module_rows` visitors" => "`\$module_rows` بازديد كننده‌ي آخر",
"Last Visitors" => "آخرين بازديد كنندگان",
"Register" => "ثبت‌نام",
"Open operator console" => "ميركار پشتيبان را باز كن",
"Online users" => "كاربران روي خط",
"We have" => "داريم",
"online users" => "كاربران روي خط",
"Logout" => "خروج",
"Paramaters" => "پارامترها",
"Switch" => "گزينه",
"Login through CAS" => "ورود به سامانه اطلاعات طريق CAS",
"Login as admin" => "ورورد با عنوان 'سرپرست'",
"Email" => "پست الكترونيكي",
"eMail" => "پست الكترونيكي",
"Password" => "كلمه‌ي عبور",
"Remember me" => "مرا به خاطر داشته باش",
"Click here to register" => "براي ثبت‌نام اين‌جا را كليك كنيد‍",
"Click here if you've forgotten your password" => "اگر كلمه‌ي عبور خود را فراموش كرده‌ايد اين‌جا را كليك كنيد",
"I forgot my pass" => "من كلمه‌ي عبورم را فراموش كرده‌ام",
"I forgot my password" => "من كلمه‌ي عبورم را فراموش كرده‌ام",
"Click here to login using the default security protocol" => "براي ورود با استفاده از پروتكل امنيتي پيش‌فرض، اين‌جا را كليك كنيد",
"Standard" => "معمولي",
"Click here to login using a secure protocol" => "براي ورود به‌كمك يك پروتوكل امن، اين‌جا را كليك كنيد",
"Secure" => "امن",
"Stay in ssl Mode" => "در باب ssl بمان",
"Tiki Logo" => "علامت تيكي",
"You have" => "شما",
"New Messages" => "پيغام‌هاي جديد داريد",
"New Message" => "پيغام جديد داريد",
"You have 0 new messages" => "شما هيچ پيغام جديدي نداريد",
"Waiting Submissions" => "درخواست‌هاي در صف انتظار",
"submissions waiting to be examined" => "درخواست‌هايي كه منتظر بررسي هستند",
"Old articles" => "مقالات قديمي",
"Send a message to" => "ارسال پيغام براي",
"Send a message" => "ارسال پيغام",
"Random Pages" => "صفحات تصادفي",
"Register as a new user" => "ثبت‌نام به عنوان كاربر جديد",
"Your email could not be validated; make sure you email is correct and click register below." => "آدرس پست الكترونيكي شما نمي‌تواند تاييد اعتبار شود؛ اطلاعات صحت آدرس خود اطمينان حاصل كنيد و روي 'ثبت‌نام' در پايين كليك كنيد",
"Your registration code:" => "كد ثبت‌نام شما:",
"Username" => "نام كاربري",
"Passcode to register (not your user password)" => "كدعبور براي ثبت‌نام(اين كلمه‌ي عبور شما نيست)",
"Registration code" => "كد ثبت‌نام",
"Repeat password" => "تكرار ‌كلمه‌ي عبور",
"Generate a password" => "يك كلمه‌ي عبور توليد كن ",
"Wiki RSS" => "RSS ويكي",
"Blogs RSS" => "RSS بلاگ‌ها",
"Articles RSS" => "RSS مقالات ",
"Image Galleries RSS" => "RSS سرسراهاي تصاوير",
"File Galleries RSS" => "RSS سرسراهاي پرونده",
"Forums RSS" => "RSS انجمن‌ها",
"Maps RSS" => "RSS نقشه‌ها",
"in:" => "در:",
"Entire Site" => "تمام پايگاه",
"Wiki Pages" => "صفحات ويكي",
"Image Gals" => "سالن‌هاي تصاوير",
"Images" => "تصاوير",
"Blog Posts" => "الصاقات بلاگ",
"Search Wiki PageName" => "جستجو در نام صفحات ويكي",
"Read More" => "اطلاعات بيشتر",
"Since your last visit on" => "از آخرين بازديد شما در",
"New Images" => "تصاوير جديد",
"Wiki Pages Changed" => "صفحه‌ي ويكي تغيير كرده‌اند",
"New Files" => "پرونده‌هاي جديد",
"New Comments" => "نظرات جديد",
"New Users" => "كاربران جديد",
"click to edit" => "ويرايش",
"Most Active blogs" => "فعال‌ترين بلاگ‌ها",
"Top `\$module_rows` articles" => "`\$module_rows` مقاله‌ي برتر",
"Top articles" => "برترين مقالات",
"Top `\$module_rows` File Galleries" => "`\$module_rows` سرسراي پرونده‌ي برتر",
"Top File Galleries" => "برترين سرسراهاي پرونده",
"Top `\$module_rows` files" => "`\$module_rows` پرونده‌ي برتر",
"Top files" => "پرونده‌هاي برتر",
"Top `\$module_rows` Forum Posters" => "`\$module_rows` آگهي برتر انجمن",
"Top Forum Posters" => "آگهي‌هاي برتر انجمن‌ها",
"Top `\$module_rows` games" => "`\$module_rows` بازي برتر",
"Top games" => "بازي‌هاي برتر",
"Top `\$module_rows` galleries" => "Top `\$module_rows` Galleries",
"Top galleries" => "سرسراهاي برتر",
"Top `\$module_rows` Images" => "`\$module_rows` تصوير برتر",
"Top Images" => "تصاوير برتر",
"Top `\$module_rows` Pages" => "`\$module_rows` صفحات برتر",
"Top Pages" => "برترين صفحات",
"Top `\$module_rows` Quizzes" => "`\$module_rows` آزمون برتر",
"Top Quizzes" => "برترين آزمون‌ها",
"Most `\$module_rows` visited blogs" => "بيشترين `\$module_rows` بلاگ‌هاي ديده‌شده",
"Top `\$module_rows` Visited FAQs" => "`\$module_rows` FAQ پربيننده",
"Top Visited FAQs" => "پربيننده‌ترين FAQها",
"view" => "مشاهده اطلاعات",
"click to view" => "نمايش",
"My blogs" => "بلاگ‌هاي من",
"My galleries" => "سرسراهاي من",
"My Pages" => "صفحات من",
"User tasks" => "وظايف كاربر",
"Done" => "انجام شد",
"Del" => "حذف",
"Public tasks" => "وظايف عمومي",
"select" => "انتخاب",
"User informations" => "اطلاعات كاربر",
"Group informations" => "اطلاعات گروه‌ها",
"Top users" => "برترين كاربران",
"Whats related" => "What's related",
"online user" => "كاربر روي‌خط",
"Last `\$module_rows` wiki comments" => "`\$module_rows` نظر آخرين ويكي",
"Last wiki comments" => "آخرين نظرات ويكي",
"Real Name" => "نام واقعي",
"vote" => "راي دادن",
"Structures:" => "ساختارها:",
"show structures" => "ساختارها را نمايش بده",
"hide structures" => "ساختارها را پنهان كن",
"Manage structures" => "مديريت ساختارها",
"Are you sure you want to remove this module?" => "آيا مطمئن هستيد مي‌خواهيد اين ماژول را حذف كنيد؟",
"Powered by" => "فراهم شده به‌وسيله‌ي",
"Execution time" => "زمان اجرا",
"Memory usage" => "ميزان استفاده از حافظه",
"database queries used" => "درخواست ارسالي به بانك اطلاعاتي",
"Server load" => "بار سرور",
"Locked" => "قفل شده",
"Cached" => "cachشده",
"3d browser" => "مرورگر 3بعدي",
"Refresh" => "بازيابي كن",
"Monitor this Page" => "اين صفحه را ديده‌باني كن",
"Stop Monitoring this Page" => "ديده‌باني اين صفحه را متوقف كن",
"Backlinks" => "پيوندهاي معكوس",
"Previous page" => "صفحه‌ي قبلي",
"Parent page" => "صفحه‌ي مادر",
"Next page" => "صفحه‌ي بعدي",
"Child" => "فرزند",
"Add Page" => "افزودن صفحه",
"First page" => "اولين صفحه",
"page" => "صفحه",
"Last page" => "آخرين صفحه",
"To edit the copyright notices" => "براي ويرايش اخطاريه‌ي حق انحصاري چاپ",
"Click Here" => "اين‌جا را كليك كنيد",
"The content on this page is licensed under the terms of the" => "محتواي اين صفحه تحت اين شرايط قرار دارد",
"The original document is available at" => "مستند اصلي در اين‌جا قابل دسترسي است",
"Made with" => "ساخته شده با",
"powered by" => "فراهم شده به‌وسيله‌ي",
"on:" => "در:",
"Translation" => "ترجمه",
"Article image" => "تصوير مقالات",
"Topic image" => "تصوير سرفصل",
"Source" => "منبع",
"Add Comment" => "افزودن نظريه",
"1 comment" => "1 نظر",
"comments" => "نظرات",
"close" => "ببند",
"Location : " => "محل:",
"Rename" => "تغيير نام",
"Similar" => "مشابهات",
"Undo" => "برگشت عمل",
"Slides" => "اسلايدها",
"Export" => "صدور اطلاعات",
"Discuss" => "بحث",
"Attach File" => "ضميمه‌كردن پرونده",
"1 File Attached" => "1 پرونده ضميمه شد",
"{\$atts_cnt} files attached" => "{\$atts_cnt} پرونده ضميمه شد",
"Last Modification" => "آخرين تغييرات",
"logged as" => "وارد شده با عنوان",
"pass" => "كلمه عبور",
"Page generated in" => "صفحه توليد شده در",
"The newsletter was sent to {\$sent} email addresses" => "خبرنامه براي پست‌هاي الكترونيكي {\$sent} ارسال شد.",
"This newsletter will be sent to {\$subscribers} email addresses." => "اين خبرنامه براي پست‌هاي الكترونيكي {\$subscribers} ارسال خواهد شد.",
"Prepare a newsletter to be sent" => "آماده‌سازي يك خبرنامه براي ارسال",
"Apply template" => "الگوي اعمالي",
"Data" => "داده‌ها",
"Send Newsletters" => "ارسال خبرنامه‌ها",
"Sent editions" => "نسخ ارسال شده",
"sent" => "ارسال شده در",
"User List" => "فهرست كاربران",
"Homework" => "مشق شب",
"Assignments" => "انتصاب‌ها",
"Last Changes" => "آخرين تغييرات",
"Edit article" => "ويرايش مقاله",
"Backups" => "پشتيبان‌گيري",
"User files" => "پرونده‌هاي كاربر",
"Favorites" => "علاقه‌مندي‌ها",
"Watches" => "ديده‌بان‌ها",
"home" => "مبدا",
"chat" => "گپ‌زني(chat)",
"contact us" => "تماس با ما",
"Member list" => "فهرست اعضا",
"dump" => " تخليه(dump)",
"rankings" => "رتبه‌بندي‌ها",
"List Pages" => "فهرست صفحات",
"orphan pages" => "صفحات يتيم",
"sandbox" => "دست‌گرمي",
"received pages" => "صفحات دريافت شده",
"structures" => "ساختارها",
"Articles Home" => "مبدا مقالات",
"Create/Edit Blog" => "ساخت/ويرايش بلاگ‌",
"Browse Directory" => "مرور پوشه(شايدم پوشه‌ي مرور!)",
"List Quizzes" => "فهرست آزمون‌ها",
"List Trackers" => "فهرست trackerها",
"List Surveys" => "فهرست نظرسنجي‌ها",
"Back to Homepage" => "بازگشت به صفحه‌ي مبدا",
"This page is being edited by" => "اين صفحه در حال ويرايش شدن است، توسط:",
"Proceed at your own peril" => "با مسئوليت خودتان ادامه دهيد",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "'دست‌گرمي' صفحه‌اي است كه شما مي‌توانيد مهارت ويرايش خود را تمرين كنيد. از خصيصه‌ي 'پيش‌نمايش' براي روئيت شماي صفحه استفاده كنيد، هيچ نسخه‌اي براي اين صفحه نگهداري نمي‌شود.",
"My Footnotes" => "تبصره‌هاي من",
"Edit Summary" => "خلاصه‌ي ويرايش",
"Copyright" => "حق انحصاري چاپ",
"Year:" => "سال:",
"Authors:" => "مولفين:",
"Allow HTML" => "HTML مجاز است ",
"Spellcheck" => "بررسي املايي",
"Import page" => "وارد كردن صفحه",
"export all versions" => "تمام نسخ را صادر كن",
"Upload picture" => "بارگذاري تصوير",
"no cache" => "بدون cache",
"minute" => "دقيقه",
"License" => "پروانه",
"Important" => "مهم",
"Minor" => "كوچك",
"Cancel Edit" => "تغييرات را لغو كن",
"left/right" => "چپ/راست",
"Unassign module" => "ماژول تخصيص داده نشده",
"debugger console" => "ميزكار اشكال زدايي",
"Mini Calendar" => "تقويم جيبي",
"Edit mapfiles" => "ويرايش پرونده‌هاي نقشه",
"Quick edit a Wiki page" => "ويرايش سريع يك صفحه‌ي ويكي",
"Language: " => "زبان: ",
"Language" => "زبان",
"Edit Post" => "ويرايش الصاق",
"Use wysiwyg editor" => "از ويراستار WYSIWYG استفاده كن",
"Use normal editor" => "از ويراستار معمولي استفاده كن",
"View Blog" => "مشاهده‌ي بلاگ",
"List Blogs" => "فهرست بلاگ‌ها",
"Use ...page... to separate pages in a multi-page post" => "براي جدا كردن صفحات در يك الصاق چندصفحه‌اي، از ...page... استفاده كنيد",
"Upload image for this post" => "بارگذاري تصوير براي اين الصاق",
"Trash" => "خاكروبه",
"Mark entry as private:" => "اين الصاق، خصوصي است",
"Send trackback pings to:" => "pingهاي trackback را به اين URIها بفرست:",
"(comma separated list of URIs)" => "URIها را با كاما(؛)از هم جدا كنيد",
"Save and Exit" => "ذخيره كن و خارج شو",
"This is" => "اين يك",
"by the" => "توسط",
"Tiki community" => "اجتماع تيكي",
"Find:" => "جستجو:",
"Sort posts by:" => "الصاق‌ها را براين اساس مرتب كن:",
"read more" => "اطلاعات بيشتر",
"pages" => "صفحه",
"Permalink" => "دنباله‌ي ثابت",
"View Comments" => "مشاهده‌ي نظرها",
"Email This Post" => "اين الصاق را با پست الكترونيكي بفرست",
"Viewing blog post" => "مشاهده‌ي الصاقات بلاگ",
"Return to blog" => "بازگشت به بلاگ",
"Trackback pings" => "pingهاي trackback",
"URI" => "آدرس URI",
"Blog name" => "نام بلاگ",
"Last update from CVS" => "آخرين به‌روز رساني از CVS",
"Translate in" => "ترجمه شده به",
"babelfish it" => "با babelfish ترجمه‌اش كن",
"Welcome to" => "خير مقدم",
"Enlarge area height" => "ارتفاع محدوده را اضافه كن",
"Reduce area height" => "ارتفاع محدوده را كاهش بده",
"List View" => "نمايش فهرستي",
"Tools Calendars" => "تقويم‌ها ابزارها",
"Check / Uncheck All" => "انتخاب همه/هيچكدام",
"Site Ads and Banners" => "نشان‌ها و تبليغات پايگاه",
"Activate" => "فعال شود",
"Content" => "محتوا",
"Publish" => "منتشر شود",
"General" => "عمومي",
"Features" => "خصيصه‌ها",
"Meta Tags" => "فرا برچسب‌ها(meta tags)",
"Intertiki" => "بين تيكي(Inter tiki)",
"InterTiki" => "بين تيكي(Inter tiki)",
"i18n" => "بين‌الملل سازي(i18n)",
"Wysiwyg editor" => "ويرايش‌گر Wysiwyg",
"Module" => "ماژول",
"Home Blog" => "بلاگ مبدا",
"Home Blog (main blog)" => "بلاگ مبدا(بلاگ اصلي)",
"Blog features" => "خصيصه‌هاي بلاگ",
"Blog level comments" => "دسترسي براي دادن نظر(comment) در سطح بلاگ‌",
"Post level comments" => "دسترسي براي دادن نظر(comment) در سطح هر الصاق",
"Trackbacks Pings" => "pingهاي trackbackها",
"Post level trackback pings" => "pingهاي مسيريابي معكوس در سطح هر الصاق",
"Spellchecking" => "بررسي املايي",
"Not Installed" => "نصب نشده است",
"Default ordering for blog listing" => "ترتيب پيش‌فرض در فهرست بلاگ‌ها",
"Creation date (desc)" => "بر اساس تاريخ ايجاد (نزولي)",
"Last modification date (desc)" => "بر اساس آخرين تغيير (نزولي)",
"Blog title (asc)" => "عنوان بلاگ (صعودي)",
"Number of posts (desc)" => "تعداد الصاق‌ها (نزولي)",
"Visits (desc)" => "روئيت‌ها (نزولي)",
"Activity (desc)" => "فعاليت (نزولي)",
"Change preferences" => "تغيير تنظيمات",
"Blog listing configuration (when listing available blogs)" => "پيگربندي فهرست بلاگ(در بلاگ‌هاي قابل فهرست شدن)",
"Creation date" => "تاريخ ايجاد",
"Last modification time" => "زمان آخرين تغييرات",
"Disabled" => "غيرفعال",
"Plain text" => "متن ساده",
"Link to user information" => "متصل به اطلاعات كاربر",
"User avatar" => "شكلك كاربر",
"Blog comments settings" => "تنظيمات 'نظرات' بلاگ",
"Default number of comments per page" => "پيش‌فرض تعداد نظرات در هر صفحه",
"Comments default ordering" => "ترتيب پيش‌فرض نظرات",
"Points" => "امتياز",
"Group calendar sticky popup" => "popupهاي پسبان تقويم را در گروه قرار بده",
"Group calendar item view tab" => "برگ مشاهده‌ي اقلام تقويم را گروه‌‌بندي كن",
"Day" => "روز",
"Calendar manual selection of time/date" => "انتخاب دستي زمان/تاريخ تقويم",
"JsCalendar" => "تقويم js",
"5 minutes" => "5 دقيقه",
"Change settings" => "تغيير تنظيمات",
"Show Category Path" => "آدرس طبقه را نشان بده",
"Show Category Objects" => "اشياء طبقه را نمايش بده",
"Search may show forbidden results. Much better performance though." => "جستجو شامل موارد ممنوع هم باشد. كارايي به شدت افزايش مي‌يابد",
"Ignore category viewing restrictions" => "محدوديت‌هاي مشاهده‌ي طبقات را ناديده بگير",
"CMS features" => "خصيصه‌هاي سامانه‌ي مديريت محتوا(CMS)",
"Submissions" => "ارائه‌ها",
"Use templates" => "از الگوها استفاده كن",
"Print article" => "امكان چاپ مقالات",
"Settings for page articles home" => "تنظيمات صفحه‌ي مبدا مقالات",
"Maximum number of articles in home" => "بيشينه تعداد مقالات در صفحه‌ي مبدا",
"Topic" => "موضوع",
"Article comments settings" => "تنظيمات مربوط 'نظرات' مقالات",
"Fields to display on page" => "موارد نمايش داده شده در صفحه‌ي ",
"Publish Date" => "تاريخ انتشار",
"Expire Date" => "تاريخ انقضا",
"Visible" => "قابل رؤيت",
"Img" => "تصوير",
"Import CSV file" => "وارد كردن پرونده‌ي CSV",
"Batch upload (CSV file):" => " بارگذاري دسته‌اي(Batch upload)",
"Import" => "ورود اطلاعات",
"User identity features" => "خصيصه‌هاي عينيت كاربر",
"Show user's info on mouseover" => "هنگام اشاره‌ي موش‌واره، اطلاعات كاربر را نمايش بده",
"Picture" => "تصوير",
"Number of friends" => "تعداد دوستان",
"E-mail" => "آدرس پست الكترونيكي",
"Last login" => "آخرين ورود",
"Distance" => "فاصله",
"Set features" => "تنظيمات اعمال شوند",
"Copyright Management" => "مديريت حق چاپ",
"License Page" => "صفحه‌ي پروانه",
"Submit Notice" => "اخطار ارائه شود",
"Number of columns per page when listing categories" => "تعداد ستون‌ها در هر صفحه هنگام نمايش فهرست طبقه‌بندي‌ها",
"Links per page" => "پيوندها در هر صفحه",
"Validate URLs" => "URLها را تاييد اعتبار كن",
"enable cool sites" => "پايگاه‌هاي بامزه فعال باشد",
"Method to open directory links" => "روش باز كردن پيوندهاي پوشه‌ها",
"replace current window" => "در همين صفحه‌ي كنوني",
"New Window" => "پنجره‌ي جديد",
"inline frame" => "قاب دروني (inline frame)",
"Featured Help" => "كمك خاص",
"Spreadsheet" => "صفحه‌گسترده",
"Tiki Sheet" => "صفحات تيكي",
"Live Support" => "پشتيباني زنده",
"Live support system" => "سامانه‌ي پشتيباني زنده",
"XMLRPC API" => "رابط برنامه نويسي XMLRPC",
"PHPLayers" => "PHP Layers Menu System",
"PhpLayers Dynamic menus" => "منو پوياي لايه‌هايPHP",
"Workflow engine" => "موتور گردش كار",
"Mobile" => "سيار",
"Content Features" => "خصيصه‌هاي محتوا",
"Edit Templates" => "ويرايش الگوها",
"Hotwords in New Windows" => "واژگان آتشين در صفحات جديد",
"Custom Home" => "مبدا قابل متناسب‌سازي",
"HTML Pages" => "صفحات HTML",
"Dynamic Content System" => "سامانه‌ي محتواي پويا",
"Administration Features" => "خصيصه‌هاي مديريتي",
"Banning System" => "سامانه‌ي تحريم‌",
"Banning system" => "سامانه‌ي تحريم",
"Debugger Console" => "ميزكار اشكال‌زدايي",
"Referer Stats" => "آمار مراجعات",
"Contact Us" => "تماس با ما",
"Contact Us (Anonymous)" => "تماس با ما(بي‌نام)",
"Redirect On Error" => "هنگام بروز خطا، كاربر را Redirect كن",
"Communications (send/receive objects)" => "ارتباطات (ارسال/دريافت اشيائ)",
"User Features" => "خصيصه‌هاي كاربران",
"User Preferences Screen" => "صفحه‌ي تنظيمات براي هر كاربر",
"User Notepad" => "صفحه‌ي يادداشت‌برداري براي هر كاربر",
"User Bookmarks" => "صفحه‌ياب براي هر كاربر",
"User Watches" => "ديده‌بان‌هاي كاربر",
"User Watches Translations" => "ديده‌بان‌هاي كاربران را ترجمه كن",
"User Tasks" => "سامانه‌ي وظايف براي هر كاربر",
"User Messages" => "سامانه‌ي پيغام براي هر كاربر",
"User Files" => "پرونده براي هر كاربر",
"Home Gallery" => "سرسراي مبدا",
"Home Gallery (main gallery)" => "سرسراي مبدا (سرسراي اصلي)",
"Galleries features" => "خصيصه‌هاي سرسراها",
"Allow same file to be uploaded more than once" => "بارگذاري يك پرونده‌ي پيش از يك بار مجاز است",
"Never" => "هيچ‌وقت!",
"Use database to store files" => "از بانك اطلاعاتي براي نگهداري پرونده‌ها استفاده كن",
"Use a directory to store files" => "از يك پوشه براي نگهداري پرونده‌ها استفاده كن",
"Directory path" => "آدرس پوشه",
"Directory Batch Loading" => "باركردن دسته‌اي پوشه‌ها",
"Enable directory batch loading" => "باركردن دسته‌اي پوشه‌ها فعال باشد",
"Batch loading directory" => "پوشه‌ي باركردن دسته‌اي",
"Uploaded filenames must match regex" => "نام پرونده‌هاي بارگذاري شده بايد با اين اصطلاح همخواني داشته باشد",
"Uploaded filenames cannot match regex" => "نام پرونده‌هاي بارگذاري شده نبايد با اين اصطلاح همخواني داشته باشد",
"Gallery listing configuration" => "پيكربندي فهرست تصاوير",
"Change configuration" => "تغيير پيكربندي",
"File galleries comments settings" => "تنظيمات 'نظرات' سرسراهاي پرونده‌ها",
"File galleries search indexing" => "ساخت راهنماي جستجوي سرسراهاي پرونده‌ها",
"Leave command blank to delete handler" => "خط فرمان را براي حذف handler، خالي بگذاريد",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => " از %1 براي جابگزيني نام پرونده‌هاي دروني استفاده كنيد (مثال: براي تبديل سند به متن با كمك دستور unix، از اين فرمان استفاده كنيد: \"strings %1\")",
"Enable auto indexing on file upload or change" => "راهنماي جسنجو(indexing) براي پرونده‌هاي بارگذاري شده يا تغيير كرده فعال باشد",
"MIME Type" => "نوع MIME",
"System command" => "فرمان",
"Reindex all files for search" => "تمام پرونده‌ها را براي جستجو مجددا index گزاري كن",
"Home Forum" => "مبدا انجمن‌ها",
"Home Forum (main forum)" => "انجمن مبدا (انجمن اصلي)",
"Forums features" => "خصيصه‌هاي انجمن‌ها",
"Accept wiki syntax" => "نحو ويكي(wiki syntax) قابل قبول است",
"Forum quick jumps" => "پرش سريع(quick jump) در انجمن",
"Ordering for forums in the forum listing" => "ترتيب انجمن‌ها در فهرست انجمن‌ها",
"Creation Date (desc)" => "تاريخ ايجاد (نزولي)",
"Topics (desc)" => "عناوين (نزولي)",
"Threads (desc)" => "رگه(thread)ها (نزولي)",
"Last post (desc)" => "آخرين الصاق (نزولي)",
"Name (desc)" => "نام (نزولي)",
"Name (asc)" => "نام (صعودي)",
"Forum listing configuration" => "پيكربندي فهرست انجمن‌ها",
"Topics" => "عناوين",
"Posts per day" => "الصاق‌ها در روز",
"Browser width" => "عرض مرورگر",
"Browser height" => "ارتفاع مرورگر",
"Navigation depth" => "‘عمق مرور",
"Node size" => "حجم گره",
"Text size" => "حجم متن",
"Spring (connection) size" => "حجم ارتباط",
"Camera distance adjusted relative to nearest node" => "فاصله‌ي دوربين باتوجه به نزديك‌ترين گره",
"Camera distance" => "فاصله‌ي دوربين",
"Field of view" => "ميدان ديد",
"Feed animation interval (milisecs)" => "فرجه‌ي تغذيه‌ي انگيزش (ميلي ثانيه)",
"Friction constant" => "ثابت اصطحكاك",
"Elastic constant" => "ثابت ارتجاعي",
"Eletrostatic constant" => "ثابت الكترواستاتيك",
"Node mass" => "جرم گره",
"Node charge" => "هزينه‌ي گره",
"Uses Slideshow" => "از نمايش صفحه به صفحه استفاده كن(slideshow)",
"Use database to store images" => "تصاوير را در بانك اطلاعاتي نگهدار",
"Use a directory to store images" => "از يك پوشه(directory) براي نگهداري تصاوير استفاده كن",
"Library to use for processing images" => "كتابخانه‌ي مورد استفاده براي پردازش تصاوير",
"Uploaded image names must match regex" => "نام تصاوير بارگذاري شده بايد با اين اصطلاح همخواني داشته باشد",
"Uploaded image names cannot match regex" => "نام تصاوير بارگذاري شده نبايد با اين اصطلاح همخواني داشته باشد",
"Yes" => "بله",
"Images per row" => "تصاوير در هر سطر",
"Thumbnails size X" => "اندازه‌ي عرض تصويرك(thumbnail)",
"Thumbnails size Y" => "اندازه‌ي عرض تصويرك(thumbnail)",
"pixels" => "نقطه(پيكسل)",
"Exterminator" => "منهدم كننده",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "تصاويري از سرسراي سامانه كه در صفحات ويكي، مقالات و الصاق‌هاي بلاگ‌ها استفاده نمي‌شوند را حذف كن",
"Mover" => "انتقال",
"Move images from filesystem storage to database storage" => "تصاوير را به بانك اطلاعاتي منتقل كن",
"All galleries" => "تمام سرسراها",
"Parent" => "منشا",
"Last modified" => "آخرين تغيير",
"Image galleries comments settings" => "تنظيمات مربوط به توضحيات سرسراهاي تصوير",
"General Preferences" => "تنظيمات  عمومي",
"Use group homepages" => "استفاده از صفحات مبدا براي گروه‌ها",
"Go to group homepage only if login from default homepage" => "تنها در صورتي كه از صفحه‌ي پيش‌فرض وارد شدند، به صفحه‌ي مبدا گروه برو",
"Use URI as Home Page" => "از اين URI به‌عنوان صحفه‌ي مبدا استفاده كن",
"Home page" => "صحفه‌ي مبدا",
"Custom home" => "متناسب‌سازي مبدا",
"OS" => "سيستم عامل",
"Unix" => "يونيكس(Unix)",
"Windows" => "ويندوز(Windows)",
"Unknown/Other" => "نامشخص يا غيره",
"No error reporting" => "بدون گزارش خطا",
"Report all PHP errors" => "تمام خطاهاي PHP رو گزارش بده",
"Report all errors except notices" => "بجز آگاه‌سازها(Notices)، تمام خطاها را گزارش بده",
"Default charset for sending mail:" => "كاراكتر سي پيش‌فرض براي ارسال پست الكترونيكي:",
"Mail end of line:" => "انتهاي خط در پست‌هاي الكترونيكي:",
"(standard)" => "(استاندارد)",
"(some Unix MTA)" => "(برخي از MTAهاي يونيكس)",
"General Settings" => "تنظيمات عمومي",
"Disallow access to the site (except for those with permission)" => "دسترسي به اين پايگاه را -مگر براي كساني كه دسترسي دارند- ممكن نساز",
"Message to display when site is closed" => "پيغامي كه بايد هنگام تعطيل بودن پايگاه نمايش داده شود",
"Disallow access when load is above the threshold (except for those with permission)" => "هنگامي كه بار پايگاه پيش از حد مجاز مي‌شود، دسترسي به اين پايگاه را -مگر براي كساني كه دسترسي دارند- ممكن نساز",
"Max average server load threshold in the last minute" => "بيشينه بار متوسط سرور(Server Load) در دقيقه‌ي گذشته",
"Message to display when server is too busy" => "پيغامي كه بايد هنگام مشغول بودن بيش‌از حد سرور نمايش داده شود",
"Use cache for external pages" => "صفحات خارجي را در حافظه‌ي خود نگه‌دار",
"Use cache for external images" => "تصاوير خارجي را در حافظه‌ي خود نگه‌دار",
"Tikiwiki.org help" => "كمك در tikiwiki.org",
"Use gzipped output" => "از خروجي‌ها gzipped استفاده كن",
"output compression is active." => "فشرده‌يسازي خروجي‌ها فعال است.",
"compression is handled by" => "فشرده‌سازي بدين‌وسيله اداره مي‌شود",
"Count admin pageviews" => "مشاهده‌ي صفحات سرپرست را بشمار",
"Browser title" => "عنوان مرورگر",
"Temporary directory" => "پوشه‌ي موقت",
"Sender Email" => "پست الكترونيكي فرستنده",
"Contact user" => "كاربر مورد تماس",
"Allow anonymous users to \"Contact Us\"" => "بي‌نام، امكان 'تماس با ما' را فراهم كن",
"contact feature disabled" => "امكان 'تماس' غيرفعال شد",
"Store session data in database" => "اطلاعات session را در بانك اطلاعاتي نگه‌دار",
"Session lifetime in minutes" => "عمر session به دقيقه",
"Use proxy" => "از پروكسي(proxy) استفاده كن",
"Proxy Host" => "ميزبان پروكسي",
"Proxy port" => "درگاه(port) پروكسي",
"Maximum number of records in listings" => "بيشينه تعداد ركوردها در فهرست‌برداري‌ها",
"Help System" => "سامانه‌ي كمك رساني",
"Help URL" => "URL كمك",
"Date and Time Formats" => "شكل زمان و تاريخ",
"Long date format" => "شكل تاريخ طويل",
"Short date format" => "شكل تاريخ كوتاه",
"Long time format" => "شكل زمان طويل(long time)",
"Short time format" => "شكل زمان كوتا(short time)",
"Date and Time Format Help" => "كمك در زمينه‌ي شكل زمان و تاريخ",
"Locations separator" => "جداساز مكان‌ها",
"Change admin password" => "تغيير كلمه‌ي عبور سرپرست",
"New password" => "كلمه‌ي عبور جديد",
"Change password" => "كلمه‌ي عبور را تغيير بده",
"You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "براي اين پايگاه احتياج به درخواست يك 'كليد نقشه‌ي گوگل' داريد. به سادگي مي‌توانيد براي اين domain يكي در اين آدرس تهيه كنيد:",
"Google Map Key" => "كليد نقشه گوگل",
"Default x for map center" => "طول پيش‌فرض براي مركز نقشه",
"Default y from map center" => "عرض پيش‌فرض براي مركز نقشه",
"Default zoom level" => "مقدار پيش‌فرض بزرگ‌نمايي(zoom)",
"whole earth" => "تمام جهان",
"country size" => "اندازه‌ي كشور",
"city size" => "اندازه‌ي شهر",
"max zoom" => "بيشينه بزرگنمايي",
"Internationalization" => "بين‌الملل‌سازي",
"I18n setup" => "برپاسازي i18n",
"Multilingual" => "چند زبانه‌اي",
"Detect browser language" => "زبان مرورگر را تشخيص بده",
"Use database for translation" => "از بانك اطلاعاتي براي ترجمه استفاده كن",
"Edit or ex/import Languages" => "ويرايش يا وارد/صادر كردن زبان",
"Record untranslated" => "ركورد ترجمه نشده است",
"Show Babelfish Translation URLs" => "از URLهاي ترجمه‌ي Babelfish استفاده كن",
"Show Babelfish Translation Logo" => "از نماد ترجمه‌ي Babelfish استفاده كن",
"Intertiki client" => "ارباب‌رجوع(client) بين‌تيكي",
"Tiki Unique key" => "كليد يكتاي تيكي",
"InterTiki Slave mode" => "حالت برده در بين‌تيكي",
"Warning: overrides manually registered local users" => "اخطار: اين گزينه جايگزين كاربران ثبت‌نام كرده‌ي محلي(local) كه به‌صورت دستي وارد شده‌اند خواهد شد.",
"host" => "ميزبان",
"port" => "درگاه",
"Add new server" => "اضافه كردن يك سرور جديد",
"Intertiki server" => "خدمتگزار(server) بين‌تيكي",
"Intertiki Server enabled" => "سرور بين‌تيكي فعال است",
"Access Log file" => "پرونده‌ي ثبت وقايع دسترسي",
"Errors Log file" => "پرونده‌ي ثبت خطاها",
"Key" => "كليد",
"IP" => " آدرس اينترنتي(IP)",
"Contact" => "تماس",
"Admin Groups" => "مديريت گروه‌هاي كاربري",
"Admin Users" => "مديريت كاربران",
"User registration and login" => "ثبت‌نام كاربران و ورود آن‌ها",
"Authentication method" => "نحوه‌ي تصديق هويت",
"Just Tiki" => "فقط تيكي",
"Web Server" => "سرور وب(Web Server)",
"Tiki and PEAR::Auth" => " تيكي و تصديق هويت كمكي",
"Tiki and PAM" => "تيكي و PAM",
"CAS (Central Authentication Service)" => "خدمات تصديق هويت متمركز(CAS)",
"Tiki and HTTP Auth" => "تيي و تصديق هويت HTTP",
"Use WebServer authentication for Tiki" => "براي تيكي از تصديق هويت وب‌سرور استفاده كن",
"Users can register" => "كاربران مي‌توانند ثبت‌نام كنند",
"... but need admin validation" => "…اما به تاييد اعتبار مديريت نياز دارند",
"Use tracker for more user information" => "از پيوندننده(tracker) براي اطلاعات بيشتر در مورد كاربران استفاده كن",
"Use tracker for more group information" => " از پيوندننده(tracker) براي اطلاعات بيشتر در مورد گروه‌ها استفاده كن ",
"Request passcode to register" => "براي ثبت‌نام درخواست اسم رمز(passcode) كن",
"Prevent automatic/robot registration" => "از ثبت‌نام خودكار(ماشيني) جلوگيري كن",
"Validate users by email" => "به كمك پست الكترونيكي، كاربر را تاييد اعتبار كن",
"Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "اگر 'نگهداري كلمات عبور به‌صورت كدنشده' فعال است، كلمات‌عبور را بنا به درخواست به پست الكترونيكي بفرست، در غير اين صورت، به كمك پست الكترونيكي آن‌ها را عوض كن",
"Store plaintext passwords" => "كلمات عبور را به‌صورت كدنشده نگهداري كن",
"Reg users can change password" => "كاربران ثبت‌نام كرده، مي‌توانند كلمات عبور خود را تغير دهند",
"Reg users can change theme" => "كاربران ثبت‌نام كرده، مي‌توانند قيافه(theme)ي خود را تغيير دهند",
"Restrict available themes" => "قيافه(theme)هاي موجود را محدود كن",
"Available styles:" => "شيوه‌هاي موجود:",
"Reg users can change language" => "كاربان ثبت‌نام كرده، مي‌توانند زبان مربوط به خود را تغيير دهند",
"Restrict available languages" => "زبان‌هاي موجود را محدود كن",
"Available languages:" => "زبان‌هاي موجود:",
"Use challenge/response authentication" => "از تصديق هويت رقابت/پاسخي استفاده كن",
"Force to use chars and nums in passwords" => "استفاده از اعداد و حروف در كلمه‌ي عبور اجباري است",
"Minimum password length" => "حداقل طول كلمه‌ي عبور",
"Password invalid after days" => "تعداد روزهاي معتبر بودن كلمه‌ي عبور",
"Allow secure (https) login" => "ورود امن (https) مجاز است",
"Require secure (https) login" => " ورود امن (https) ضروري است ",
"HTTP port" => "درگاه HTTP",
"HTTPS port" => "درگاه HTTPS",
"Remember me feature" => "خصيصه‌ي 'مرا به‌خاطر بسپار' فعال باشد",
"Duration:" => "در طول:",
"week" => "هفته",
"month" => "ماه",
"year" => "سال",
"Remember me name" => "نام 'مرا به‌خاطر بسپار'",
"Remember me domain" => "domain  'مرا به‌خاطر بسپار'",
"Remember me path" => "آدرس 'مرا به‌خاطر بسپار'",
"Protect against CSRF with a confirmation step" => "به كمك يك مرحله تصديق، در برابر CSRF حفاظت كن",
"Protect against CSRF with a ticket" => "به كمك يك بليط، در برابر CSRF حفاظت كن",
"Highlight Group" => "گروه برجسته",
"choose a group ..." => "يك گروه انتخاب كنيد...",
"PEAR::Auth" => "تصديق هويت كمكي",
"Create user if not in Tiki?" => "كاربر را بساز، اگر در تيكي نبود",
"Create user if not in Auth?" => "كاربر را بساز، اگر در Auth نبود",
"Just use Tiki auth for admin?" => "تنها از تصديق هويت تيكي براي مديران استفاده كن",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(اگر تنظيم شود، ميزبان و درگاه مذكور در پايين را باطل مي‌كند)",
"LDAP Host" => "ميزبان LDAP",
"LDAP Port" => "درگاه LDAP",
"LDAP Scope" => " محدوده -scope- براي LDAP ",
"LDAP Base DN" => "DN پايه در LDAP",
"LDAP User DN" => "DN كاربر در LDAP",
"LDAP User Attribute" => " خصوصيت(Attribute) كاربر در LDAP ",
"LDAP User OC" => "OC كاربر در LDAP",
"LDAP Group DN" => "DN  گروه در LDAP",
"LDAP Group Attribute" => " خصوصيت(Attribute) گروه در LDAP ",
"LDAP Group OC" => " OC گروه در LDAP ",
"LDAP Member Attribute" => " خصوصيت(Attribute) عضو در LDAP ",
"LDAP Member Is DN" => "اعضاي LDAP در DN",
"LDAP Admin User" => "نام كاربري سرپرست LDAP",
"LDAP Admin Pwd" => "كلمه‌ي عبور سرپرست LDAP",
"PAM service" => "خدمات PAM",
"Currently unused" => "هم‌اكنون استفاده نمي‌شود",
"CAS server version" => "نسخه‌ي سرور CAS",
"Version 1.0" => "نسخه‌ي 1.0",
"Version 2.0" => "نسخه‌ي 2.0",
"CAS server hostname" => "نام سرور ميزبان CAS",
"CAS server port" => "درگاه سرور CAS",
"CAS server path" => "آدرس سرور CAS",
"Change CAS preferences" => "تنظيمات CAS را اعمال كن",
"Does your mail reader need a special charset" => "آيا نرم‌افزار دريافت كننده‌ي پست‌هاي الكترونيكي شما به كاراكتر خاصي نيازمند است؟",
"Theme" => "قيافه(Theme)",
"Number of visited pages to remember" => "تعداد صفحات ديده شده‌اي كه  بايد در ياد بماند",
"Displayed time zone" => "نمايش زمان",
"User information" => "اطلاعات كاربر",
"Private" => "شخصي",
"public" => "عمومي",
"Use double-click to edit pages" => "از double-click براي ويرايش صفحات استفاده كن",
"Messages per page" => "پيغام در هر صفحه",
"Allow messages from other users" => "دريافت پيغام از ساير كاربران مجاز است",
"Note author when reading his mail" => "هنگامي كه پست الكترونيكي مولف خوانده مي‌شود، به وي خبر بده",
"Send me an email for messages with priority equal or greater than" => "هنگامي كه پيامي با درجه‌ي اولويت برابر يا بزرگتر از اين دريافت مي‌كنم، آن را با يك پست الكترونيكي برايم بفرست",
"Auto-archive read messages after x days" => "پس از چند پيغام‌هاي خوانده شده را به‌صورت خودكار بايگاني كنم؟",
"never" => "هرگز",
"Tasks per page" => "وظيفه در هرصفحه",
"My Tiki" => "تيكي من",
"My pages" => "صفحات من",
"My messages" => "پيغام‌هاي من‌",
"My tasks" => "وظايف من",
"My items" => "اقلام من",
"My workflow" => "جريان كاري من",
"Slideshows theme" => "قيافه(Theme) نمايش اسلايدها",
"Edit CSS" => "ويرايش CSSها",
"Theme Control" => "تنظيم قيافه(Theme)",
"Template Viewing" => "مشاهده‌ي الگوها",
"Tiki Template Viewing" => "مشاهده‌ي الگوهاي تيكي",
"Site Identity" => "عينيت پايگاه",
"General Layout options" => "تنظيمات نماي عمومي",
"Site Logo" => "نماد پايگاه",
"Site logo background color" => "رنگ پيش‌ضمينه‌ي نماد پايگاه",
"Site logo title (on mouse over)" => "عنوان نماد پايگاه (هنگام اشاره‌ي موش‌واره)",
"Alt. description (e.g. for text browsers)" => " شرح جايگزين (مثلا براي مرورگرهاي مبتني بر متن)",
"Site menu bar" => "نوار منو پايگاه",
"Current Version" => "نسنه‌ي جاري",
"Custom code" => "كد متناسب‌سازي",
"Left column" => "ستون سمت چپ",
"always" => "همواره",
"user decides" => "بنا به تصميم كاربر",
"Site Breadcrumbs" => "خرده نان‌هاي پايگاه",
"Site location bar" => "نوار مكان پايگاه",
"at top of page" => "بالاي صفحه",
"at top of center column" => "بالاي ستون مركزي",
"Larger font for" => "قلم درشت‌تر براي",
"entire location" => "تمام محل",
"page name" => "نام صفحه",
"Use page description:" => "از توضيحات صفحه استفاده كن",
"Right column" => "ستون سمت راست",
"Bottom bar" => "نوار پايين",
"Bottom bar icons" => "تمثال‌هاي نوار پايين",
"Bottom bar debug" => "رفع اشكال نوار پايين",
"Use direct pagination links" => "دنباله‌هاي صفحه‌گذاري‌هاي مستقيم استفاده كن",
"Display menus as folders" => "منوها را مانند پوشه‌ها نمايش بده",
"Use Tabs" => "استفاده از برگه‌ها(tabs)",
"Layout per section" => "هر بخش، نماي مخصوص به خود را داشته باشد",
"Admin layout per section" => "مديريت نماهاي هر بخش",
"Favicon icon file name:" => "نام پروندهي تمثال(Icon) پايگاه(favicon filename):‌",
"Favicon icon MIME type:" => "نوع MIME تمثال پايگاه:",
"full path to mapfiles" => "آدرس كامل پرونده‌هاي نقشه",
"default mapfile" => "پرونده‌ي نقشه پيش‌فرض",
"Wiki Page for Help" => "صفحه‌ي ويكي براي كمك",
"Wiki Page for Comments" => "صفحه‌ي ويكي براي نظرات",
"Full path to gdaltindex" => "آدرس كامل به gdaltindex",
"Full path to ogr2ogr" => "آدرس كامل به ogr2ogr",
"Map Zone" => "قلمرو نقشه",
"Generate User Map" => "نقشه‌ي كاربر را توليد كن",
"Users can opt-out internal messages" => "كاربران بتوانند پيغام‌هاي داخلي را دست‌چين كنند",
"Users accept internal messages by default" => "به‌صورت پيش‌فرض، كاربران پيغام‌هاي داخلي را دريافت كنند",
"Maximum mailbox size (messages, 0=unlimited)" => "بيشينه فضاي صندوق پستي)تعداد پيغام، 0 به معني بدون محدوديت)",
"Maximum mail archive size (messages, 0=unlimited)" => "بيشينه فضاي صندوق بايگاني)تعداد پيغام، 0 به معني بدون محدوديت)",
"Maximum sent box size (messages, 0=unlimited)" => "بيشينه فضاي صندوق پيگيري(sent box))تعداد پيغام، 0 به معني بدون محدوديت)",
"Value" => "مقدار",
"Meta Keywords" => "كليدواژه",
"Meta Description" => "فرا شرح(meta desc)",
"Meta Author" => "مؤلف",
"Geourl" => "آدرس جغرافيايي",
"geo.position" => "موقعيت جغرافيايي",
"geo.region" => "منطقه‌ي جغرافيايي",
"geo.placename" => "نام جغرافيايي محلي",
"Robots" => "ماشين‌هاي خودكار",
"meta robots" => "دستگاه خودكار",
"revisit after" => "مشاهده‌ي مجدد بعد از",
"Show Module Controls" => "كنترل‌هاي ماژول‌ها را نمايش بده",
"Users can Configure Modules" => "كاربر مي‌تواند ماژول‌ها را پيكربندي كند",
"Users can Shade Modules" => "كاربران مي‌توانند ماژول‌ها را زير و بم كنند",
"module decides" => "بنا به ماژول",
"Display modules to all groups always" => "همواره ماژول‌ها را تمام گروه‌ها نشان بده",
"Hide anonymous-only modules from registered users" => "ماژول‌هاي كاربران بي‌نام را از كاربران ثبت‌نام كرده مخفي كن",
"Allow Anonymous Poll Voting" => "كاربران بي‌نام هم اجازه‌ي راي‌دادن دارند",
"List" => "فهرست",
"Image galleries" => "سرسراهاي تصاوير",
"Feed for forums" => "تغذيه براي انجمن‌ها",
"Default RDF version" => "نسخه‌ي پيش‌فرض RDF",
"Specification" => "مشخصات",
"Documentation" => "مستندات",
"Editor" => "ويراستار",
"Webmaster" => "كارفرماي وب(webmaster)",
"seconds (0 = cache inactive)" => "ثانيه (0 معادل غيرفعال است) ",
"Admin modules" => "مديريت ماژول‌ها",
"Expiration" => "انقضا",
"Referer Search Highlighting" => "علامت‌زدن اطلاعات جستجو شده",
"Performance issues" => "موارد كارايي",
"Ignore individual object permissions" => "حقوق دسترسي انفرادي اشياء را ناديده بگير",
"Refresh wiki search index now" => "راهنماي جستجوي ويكي را بازيابي كن",
"Search features" => "خصيصه‌هاي جستجو",
"SearchStats" => "آمار جستجو",
"Settings for searching content" => "تنظيمات محتواي جستجو",
"random" => "تصادفي",
"Search refresh rate" => "نرخ تازه‌كردن جستجو",
"Minimum length of search word" => "حداقل طول كلمه‌ي جستو شده",
"Max. number of words containing a syllable" => "بيشينه تعداد كلماتي كه يك هجا را مي‌سازند",
"Max. age in hours of syllable search cache" => "بيشينه عمر cache جستجوي هجا به ساعت",
"LRU list purging rate" => "نرخ پاك‌سازي فهرست LRU",
"LRU list length" => "طول فهرست LRU",
"Allow Smileys" => "استفاده از صورتك‌ها(Smiley) مجاز است",
"AutoLinks" => " پيوندهاي خودكار (AutoLinks)",
"Open external links in new window" => "پيوند(link)هاي خارجي را در پنجره‌ي جديد باز كن",
"Trackers attachments preferences" => "تنظيمات ضمايم Trackerها",
"Trackers with mirror tables" => "Trackerها با جداول آيينه‌اي",
"Use trackers with mirror tables" => "از Trackerها با جداول آيينه‌اي استفاده كن",
"Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "مقادير در جداول اختصاصي براي هر tracker نگهداري مي‌شوند. بنابراين شما مي‌توانيد به راحتي آن‌ها را خارج از تيكي‌ويكي دستكاري كنيد",
"Validate choice" => "انتخاب‌ها را تاييد اعتبار كن",
"Trackers attachments" => "ضمايم trackerها",
"dls" => "تعداد دريافت",
"Storage" => "انباره",
"Change" => "تعيير بده",
"Change all to db" => "همه را به بانك اطلاعاتي ببر",
"Change all to file" => "همه را به‌صورت پرونده در پوشه‌ها بگذار",
"Quota (Mb)" => "سهميه‌ي حجمي (به مگابايت)",
"Use database to store userfiles" => "براي نگهداري پرونده‌هاي كاربران از بانك اطلاعاتي استفاده كن",
"Use a directory to store userfiles" => "براي نگهداري پرونده‌هاي كاربران از يك پوشه استفاده كن",
"Allow viewing HTML mails?" => "اجازه‌ي مشاهده‌ي پست‌هاي الكترونيكي HTML رو بده",
"Maximum size for each attachment" => "بيشينه حجم هر ضميمه",
"Unlimited" => "نامحدود",
"Dumps" => " تخليه(dump)",
"Generate dump" => "نسخه‌ي تخليه(dump) را بساز",
"Download last dump" => "دريافت آخرين تثمال كامل تهيه‌ي شده",
"Create a Tag for the Current Wiki" => "براي ويكي كنوني يك برچسب درست كن",
"Restore the Wiki" => "بازگرداني(restore) ويكي",
"restore" => "برگردان",
"Remove a Tag" => "حذف يك برچسب",
"Wiki Comments Settings" => "تنظيمات 'نظرات' ويكي",
"Export Wiki Pages" => "صادرات صفحات ويكي",
"Wiki attachments" => "ضمايم ويكي",
"Wiki Administration" => "مديريت ويكي",
"Remove unused pictures" => "حذف عكس‌هاي استفاده نشده",
"Wiki Home Page" => "صفحه‌ي مبدا ويكي",
"Wiki Discussion" => "مناظره‌ي ويكي",
"Discuss pages on forums" => "در خصوص صفحات در انجمن‌ها بحث شود",
"Wiki Link Format" => "شكل پيوندهاي ويكي",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "از دو پرانتز براي تشخيص دنباله‌هاي ويكي استفاده مي‌شود <i>((نام صفحه))</i>.",
"complete" => "كامل",
"latin" => "لاتين",
"english" => "انگليسي",
"Id" => "شناسه",
"Last version" => "آخرين نسخه",
"Status" => "وضعيت",
"Versions" => "نسخه",
"Wiki 3D Browser Configuration" => "پيكربندي مرورگر 3بعدي ويكي",
"Wiki Features" => "خصيصه‌هاي ويكي",
"|| for rows" => "|| براي سطرها",
"\\n for rows" => "\\n براي ستون‌ها",
"Top bar" => "نوار بالا",
"Wiki History" => "تارخچه‌ي ويكي",
"Only with last version" => "تنها با آخرين نگارش",
"Any 2 versions" => "هر 2 نسخه",
"Wiki Watch" => "ديده‌بان ويكي",
"Restore defaults" => "برگرداندن پيش‌فرض‌ها",
"Crosslinks to other features and settings" => "دسترسي مستقيم به ساير خصيصه‌ها و تنظيمات",
"Other sections" => "ساير بخش‌ها",
"Administration features" => "خصيصه‌هاي مديريتي",
"Security" => "امنيت",
"System" => "سامانه",
"SysLogs" => "ثبت وقايع",
"Transversal features" => "خصيصه‌هاي نوسنجي",
"which apply to more than one section" => "آن‌هايي كه به بيش از يك‌بخش اعمال مي‌شوند",
"Navigation features" => "خصيصه‌هاي ناوبري",
"Look &amp; feel" => "ببين و حس كن",
"themes" => "قيافه‌ها",
"Text area features" => "خصيصه‌هاي فضاي متني",
"features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "خصيصه‌هايي كه مي‌توانيد در تمام فضاهاي متني مانند صفحات ويكي، بلاگ‌ها، مقالات، انجمن‌ها و غيره، استفاده كنيد",
"Stats &amp; banners" => "آمارها و درفش‌ها",
"View tpl" => "مشاهده‌ي الگو",
"Admin Groups Template" => "الگوي مديريت گروه‌هاي كاربري",
"Setting" => "تنظيمات",
"User:" => "نام كاربري:",
"bytes" => "بايت",
"Statistics" => "آمار",
"Days" => "روز",
"Weeks" => "هفته",
"viewed" => "مشاهده شده",
"Admin banning tpl" => "الگوي مديريت تحريم‌ها",
"Add or edit a rule" => "ايجاد يا تغيير قوانين",
"Rule title" => "عنوان قانون",
"Username regex matching" => "تطبيق نام كاربري",
"IP regex matching" => "تطبيق آدرس اينترنتي(IP)",
"Banned from sections" => "محروم از اين منابع",
"Rule activated by dates" => "قانون باتوجه به تاريخ فعال مي‌شود",
"Rule active from" => "قاتون از اين تارخ فعال است",
"Rule active until" => "قانون تا اين تاريخ فعال است",
"Custom message to the user" => "پيغام متناسب‌شده براي كاربر",
"Rules" => "قوانين",
"x" => "حذف",
"User/IP" => "كاربر/آدرس اينترنتي(IP)",
"Sections" => "بخش‌ها",
"Admin Calendars" => "مديريت تقويم‌ها",
"Configure/Options" => "پيكربندي/تنظيمات",
"List of Calendars" => "فهرست تقويم‌ها",
"Loc" => "مكان",
"Participants" => "شركت‌كنندگان",
"Cat" => "طبقه",
"Lang" => "زبان",
"Url" => "آدرس اينترنتي",
"Prio" => "اولويت",
"Subscription" => "اشتراك",
"Perso" => "شخصي",
"Permissions" => "دسترسي‌ها",
"Create/edit Calendars" => "ايجاد/ويرايش تقويم",
"Custom Locations" => "مكان‌هاي متناسب",
"Custom Participants" => "شركت‌كننده‌هاي متناسب",
"Custom Categories" => "طبقه‌بندي‌هاي متناسب",
"Custom Languages" => "زبان‌هاي متناسب",
"Custom Subscription List" => "فهرست اشتراك متناسب",
"Custom Priorities" => "اولويت‌هاي متناسب",
"Personal Calendar" => "تقويم شخصي",
"h" => "ساعت",
"Admin Categories tpl" => "الگوي مديريت طبقه‌بندي‌ها",
"Current category" => "طبقه‌ي جاري",
"Top" => "فوقاني",
"Child categories" => "طبقات فرزند",
"Assign Permissions" => "تخصيص حقوق دسترسي به ",
"Edit this category:" => "اين طبقه را ويرايش كن:",
"Create New" => "ساخت جديد",
"Add new category" => "افزودن طبقه‌ي جديد",
"Perms inherited from closest parent if possible or from global perms" => "درصورت امكان، حقوق دسترسي از نزديك‌ترين والد به ارث مي‌رسد، وگرنه از حقوق دسترسي‌هاي عمومي",
"Assign permissions automatically" => "حقوق دسترسي را به‌صورت خودكار اختصاص بده",
"recommended for best performance" => "براي دستيابي به بهترين عملكر، پيشنهاد مي‌شود",
"Objects in category" => "اشياء در طبقه‌ي",
"No records found." => "هيچ ركوردي يافت نشد.",
"Add objects to category" => "افزودن شيء به طبقه",
"image gal" => "سرسراي تصوير",
"file gal" => "سرسراي پرونده",
"Poll" => "راي‌گيري",
"Admin chart items" => "مديريت اقلام نمودارها",
"charts" => "نمودارها",
"Edit Chart" => "ويرايش نمودار",
"Add or edit an item" => "افزودن يا ويرايش يك قلم",
"URL" => "آدرسي اينترنتي",
"Update" => "به‌روز رساني كن",
"Chart items" => "اقلام نمودار",
"No items defined yet" => "هنوز هيچ فقره‌اي تعريف نشده است.",
"Admin charts" => "نمودارهاي سرپرست",
"View template" => "مشاهده‌ي الگو",
"Admin Charts Template" => "مديريت الگوي نمودارها",
"Add or edit a chart" => "افزوردن يا تغيير يك نمودار",
"Active" => "فعال",
"Users can vote for only one item from this chart per period" => "كاربران مي‌توانند در هر دوره تنها به يك قلم از اين نمودار راي دهند",
"Prevent users from voting for the same item more than once" => "از راي دادن بيش از يك‌بار كاربران به يك قلم جلوگيري كن",
"Users can suggest new items" => "كاربران مي‌توانند قلم جديدي را پيشنهاد كنند",
"Auto validate user suggestions" => "اعتبار پيشنهادات كاربران را به صورت خودكار كنترل كن",
"Ranking shows" => "نمايش رتبه بندي‌ها",
"All items" => "تمام اقلام",
"Top 10 items" => "10 قلم برتر",
"Top 20 items" => "20 قلم برتر",
"Top 40 items" => "40 قلم برتر",
"Top 50 items" => "50 قلم برتر",
"Top 100 items" => "100 قلم برتر",
"Top 250 items" => "250 قلم برتر",
"Voting system" => "سامانه‌ي راي گيري",
"Vote items" => "اقلام راي",
"Rank 1..5" => "امتياز 5..1 ",
"Rank 1..10" => "امتياز 10..1",
"Ranking frequency" => "تناوب امتيازدهي",
"Realtime" => "در لحظه",
"Each 5 minutes" => "هر 5 دقيقه",
"Daily" => "روزانه",
"Weekly" => "هفتگي",
"Monthly" => "ماهانه",
"Show Average" => "متوسط را نمايش بده",
"Show Votes" => "راي‌ها را نمايش بده",
"Use Cookies for unregistered users" => "كوكي‌هاي كاربران ثبت‌نام نكرده را نمايش بده",
"Users can vote again after" => "بعد از چه مدت كاربران مي‌توانند مجدداد راي دهند؟",
"Anytime" => "مهم نيست",
"1 day" => "1 روز",
"1 week" => "1 هفته",
"1 month" => "1 ماه",
"Items" => "اقلام",
"Ranks" => "امتيازها",
"No charts defined yet" => "هنوز هيچ نموداري تعريف نشده است",
"Chat Administration" => "مديريت گپ‌زني",
"Chat Admin" => "مديريت گپ‌زني",
"Chat Admin tpl" => "الگوي مديريت گپ‌زني",
"Create/edit channel" => "ايجاد/ويرايش كانال",
"Refresh rate" => "نرخ بازيابي(Refresh)",
"Half a second" => "نيم ثانيه",
"second" => "ثانيه",
"Chat channels" => "كانال‌هاي گپ‌زني",
"Admin templates" => "الگوهاي سرپرستي",
"Admin Content Templates" => "مديريت الگوهاي محتوي",
"Admin Content Templates Template" => "مديريت الگوي 'اگوهاي محتوي'",
"Edit this template:" => "اين الگو را ويرايش كن:",
"Create new template" => "ساخت الگوي جديد",
"CMS" => "سامانه‌ي مديريت محتوي",
"Template" => "الگو",
"Templates" => "الگوها",
"Last Modif" => "تاريخ آخرين تغيير",
"Settings" => "تنظيمات",
"Admin cookies" => "مديريت كوكي‌ها(cookies)",
"Cookie" => "كوكي",
"Create/edit cookies" => "ايجاد/تغيير كوكي",
"Upload Cookies from textfile" => "كوكي‌ها را از يك فايل بارگذاري كن",
"Upload from disk:" => " بارگذاري از دستگاه:",
"Upload" => "بارگذاري",
"Remove all cookies" => "تمام كوكي‌ها را حذف كن",
"cookie" => "كوكي",
"Available drawings" => "نقاشي‌هاي موجود",
"Ver" => "نسخه",
"Admin DSN" => " مديريتDSN",
"tiki-admin_dsn tpl" => "الگوي مديريت DSN تيكي",
"Create/edit dsn" => "ايجاد/ويرايش dsn",
"Admin external wikis" => "سرپرستي ويكي‌هاي خارجي",
"tiki admin external wikis template" => "الگوي مديريت ويكي‌هاي خارجي تيكي",
"Create/Edit External Wiki" => "ايجاد/تغيير ويكي‌هاي خارجي‌",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (از \$page براي جايگزيني نام صفحه در URL استفاده كنيد، مانند: http://www.example.com/tiki-index.php?page=\$page)",
"ExtWiki" => "ويكي خارجي",
"Admin Forums" => "مديريت انجمن",
"Admin Forums Template" => "مديريت الگوي انجمن‌ها",
"Create new forum" => "ايجاد انجمن جديد",
"Edit this Forum:" => "اين انجمن را ويرايش كن:",
"Create New Forum" => "ساخت يك انجمن جديد",
"There are individual permissions set for this forum" => "حقوق دسترسي فردي براي اين انجمن تنظيم شده است",
"Show description" => "شرح را نمايش بده؟",
"Prevent flooding" => "جلوگيري از طغيان",
"Minimum time between posts" => "حداقل زمان بين الصاق‌ها",
"Section" => "بخش",
"Create new" => "يكي ايجاد كن",
"Moderator user" => "كاربر ناظم",
"Moderator group" => "گروه ناظم",
"Password protected" => "حفاظت شده با كلمه‌ي عبور؟",
"Topics only" => "فقط عنوان",
"All posts" => "تمام الصاق‌ها",
"Forum password" => "كلمه‌ي عبور انجمن:",
"Send this forums posts to this email" => "الصاق‌هاي اين انجمن را به اين پست الكترونيكي بفرست",
"Prune unreplied messages after" => "پيغام‌هاي بدون جواب بايد بعد از چند روز هرس(حذف) شوند؟",
"Prune old messages after" => "پيغام‌ها بعد از چند روز قديمي هستند و بايد هرس(حذف) شوند؟",
"Topic list configuration" => "پيكربندي فهرست عناوين",
"Posts can be rated" => "الصاق‌ها مي‌توانند ارزيابي شوند‌",
"Display last post titles" => "چند تعداد از آخرين الصاق‌ها نمايش داده شوند؟",
"no display" => "هيچ",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "پيغام‌هاي الصاق شده به اين انجمن را چنان به اين آدرس ارسال كن، كه پاسخ آن‌ها بتواند به‌عنوان الصاق در انجمن قرار گيرد:",
"Send mails even when the post is generated by inbound mail" => "حتي هنگامي كه خود الصاق به وسيله‌ي پست الكترونيكي ايجاد شده است، پست الكترونيكي را ارسال كن!؟",
"Append a reply link to outbound mails" => "يك پيوند 'پاسخ' به پست‌هاي الكترونيكي خروجي اضافه كن؟",
"Originating e-mail address for mails from this forum" => "پست‌هاي الكترونيكي ارسالي از اين انجمن، از طرف اين آدرس ارسال مي‌شوند:",
"Add messages from this email to the forum" => "پيغام‌هاي اين آدرس را در اين انجمن الصاق كن",
"POP3 server" => "سرور POP3",
"Use topic smileys" => "صورتك‌هاي عناوين را نمايش بده؟",
"Show topic summary" => "خلاصه‌ي عناوين را نمايش بده؟",
"User information display" => "اطلاعات كاربر را نمايش بده؟",
"Avatar" => "شكلك",
"Flag" => "پرچم",
"Online" => "روي خط",
"Approval type" => "نوع تصويب(approval)",
"All posted" => "همه را الصاق كن (نيازي به تصويب نيست)",
"Queue anonymous posts" => "الصاق‌هاي بي‌نام را در صف قرار بده",
"Queue all posts" => "تمام الصاق‌ها را در صف قرار بده",
"No attachments" => "بدون ضميمه",
"Everybody can attach" => "همه مي‌توانند پرونده ضميمه كنند",
"Only users with attach permission" => "تنها كاربراني كه دسترسي ضميمه كردن دارند مي‌توانند ضميمه كنند",
"Moderators and admin can attach" => "مديران و ناظم‌ها نمي‌توانند ضميمه كنند",
"Store attachments in:" => "ضمايم را در اين‌جا نگهداري:",
"Database" => "بانك اطلاعاتي",
"Max attachment size (bytes)" => "بيشينه حجم ضميمه (بايت)",
"Default ordering for topics" => "ترتيب پيش‌فرض براي موضوعات",
"Date (desc)" => "تاريخ (نزولي)",
"Date (asc)" => "تاريخ (نزولي)",
"Score (desc)" => "امتياز (نزولي)",
"Replies (desc)" => "پاسخ‌ها (نزولي)",
"Reads (desc)" => "خوانده شدن (نزولي)",
"Topics per page" => "تعداد عنوان در هر صفحه",
"Default ordering for threads" => "ترتيب پيش‌‍فرض براي رگه‌ها",
"Coms" => "نظرات",
"Age" => "سن",
"PPD" => "ppd",
"Last Post" => "آخرين الصاق",
"Admin Hotwords" => "مديريت واژگان آتشين",
"Admin Hotwords Template" => "مديريت الگوي واژگان آتشين",
"Add Hotword" => "اضافه كردن واژگان آتشين",
"Word" => "واژه",
"Admin HTML pages" => "مديريت صفحات HTML",
"Edit this page" => "اين صفحه را ويرايش كن",
"View page" => "مشاهده‌ي صفحه",
"Edit zone" => "اين قلمرو را ويرايش كن",
"Zone" => "قلمرو",
"Dynamic zones" => "قلمرو پويا",
"zone" => "قلمرو",
"content" => "محتوي",
"Mass update" => "بارگذاري كيلويي!",
"Create new HTML page" => "يك صفحه‌ي HTML جديد ايجاد كن",
"Edit this HTML page:" => "ويرايش اين صفحه‌ي HTML:",
"Dynamic" => "پويا",
"Static" => "ثابت",
"Edit Repository:" => "ويرايش مخرن:",
"Create New Repository" => "ساخت مخزن جديد",
"List Repositories" => "فهرست مخازن",
"New Repository" => "مخزن جديد",
"View Repository" => "مشاهده‌ي مخزن",
"Human readable repository name" => "نام قابل خواندن مخزن",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "مسير مخزن (سامانه‌ي پرونده‌ي محلي: نسبي/مطلق ريشه‌هاي وب، از راه‌دور: بايد با 'http://' آغاز شوند)",
"File name of start page" => "نام پرونده‌ي صفحه‌ي آغازين",
"Start page" => "صفحه‌ي آغازين",
"CSS file to load when browse this repository" => "پرونده‌ي CSSاي كه بايد هنگام مرور اين مخزن بار شود",
"CSS file" => "پرونده‌ي CSS",
"Is repository visible to users" => "آيا مخزن براي كاربران عادي قابل مشاهده است؟",
"Can files from repository be cached" => "آيا پرونده‌هاي مخزن مي‌توانند cache شوند؟",
"Cacheable" => "قابل cache شدن",
"Are files from repository can be cached" => "آيا پرونده‌هاي اين مخزن قابل cache هستند؟",
"Clear all cached pages of this repository" => "تمام صفحاتي از اين مخزن كه cache شده‌اند را خالي كن",
"Clear cache" => "حافظه نهان(cache) را تخليه كن",
"Seconds count 'till cached page will be expired" => "شمارش ثانيه‌ها 'تا صفحه‌ي cache شده منقضي شود'",
"Cache expiration" => "انقضاي cache",
"Human readable text description of repository" => "متن قابل خواندن مخزن",
"Available Repositories" => "مخازن موجود",
"Start" => "شروع",
"CSS File" => "پرونده‌هاي CSS",
"Edit rules" => "ويرايش قوانين",
"Edit Rules for Repository:" => "ويرايش قوانين مخازن:",
"Configure Repositories" => "پيكربندي مخازن",
"Configure this Repository" => "پيكربيندي اين مخزن",
"View this Repository" => "مشاهده‌ي اين مخزن",
"Add new rule" => "افزودن قانون جديد",
"New Rule" => "قانون جديد",
"view/hide copy rules dialog" => "مشاهده/مخفي‌كردن رونوشت محاروه‌ي(dialog) كپي قوانين",
"Copy Rules" => "كپي قوانين",
"Source repository" => "مخزن منبع",
"Copy" => "كپي",
"According this order rules will be applied ('0' or empty = auto)" => "قوانين با توجه به اين ترتيب اعمال مي‌شوند (0 يا هيچي =خودكار)",
"Rule order" => "ترتيب قوانين",
"Text to search for" => "متن براي جستجو",
"Text to replace" => "متن براي جايگزيني",
"Replace" => "جايگزين كن",
"Is this regular expression or simple search/replacer" => "آيا اين يك مبين منظم(regular expression) است يا جستجوي/جايگزيني ساده؟",
"Is case sensitive (for simple replacer)" => "حساس به حروف؟ (براي جايگزيني ساده)",
"Case sensitive" => "حساس به حروف",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "زيرمجموعه‌اي از حروف: imsxeADSXUu، كه تعديل كننده‌ي regex است",
"Regex modifiers" => "تعديل كننده‌هاي regex",
"Human readable text description of rule" => "توضيح قابل خواندن قانون",
"Check to enable this rule" => "براي فعال كردن اين قانون اين گزينه را انتخاب كنيد",
"Enabled" => "فعال شد",
"Preview options" => "اختيارات پيش‌نمايش",
"Apply all rules or just this to generate preview" => "تمام قوانين يا فقط اين را براي توليد پيش‌نمايش اعمال كن",
"Apply all rules" => "اعمال تمام قوانين",
"View source code after rules applied" => "كداصل(sourcecode) پس از اعمال قوانين نمايش بده",
"Code preview" => "پيش‌نمايش كد",
"Generate HTML preview" => "پيش‌نمايش HTML را توليد كن",
"HTML preview" => "پيش‌نمايش HTML",
"Preview Results" => "پيش‌نمايش نتايج",
"Rules List" => "فهرست قوانين",
"Case" => "اگر",
"Admin layout" => "مديريت طرح‌بندي",
"layout options" => "اختيارات طرح‌بندي",
"Admin Featured Links" => "مديريت پيوندهاي خاص",
"Admin Featured Links Template" => "الگوي مديريت پيوندهاي خاص",
"Generate positions by hits" => "موقعيت‌ها اطلاعات طريق ضربات مشخص شود",
"List of featured links" => "فهرست پيوندهاي خاص",
"Position" => "موقعيت",
"Add Featured Link" => "افزودن پيوند خاص",
"Edit this Featured Link:" => "اين پيوند خاص را ويرايش كن:",
"Create new Featured Link" => "ايجاد پيوند خاص جديد",
"disables the link" => "پيوند را غيرفعال كن",
"Link type" => "نوع پيوند",
"replace current page" => "جايگزين صفحه‌ي كنوني شود",
"framed" => "قاب‌دار",
"open new window" => "پنجره‌ي جديد باز شود",
"Mail-in accounts" => "حساب‌هاي 'كنترل با پست الكترونيكي'",
"Admin Webmail" => "مديريت پست تحت وب",
"Admin Mailing Template" => "مديريت الگوي دريافت پست الكترونيكي",
"Account" => "حساب",
"Add new Mail-in account" => "افزودن حساب جديد 'كنترل با پست الكترونيكي'",
"Edit Mail-in account" => "ويرايش حساب 'كنترل با پست الكترونيكي'",
"Account name" => "نام حساب:",
"POP server" => "سرور POP(دريافت):",
"Port" => "درگاه(port):",
"SMTP server" => "سرور SMTP(ارسال):",
"SMTP requires authentication" => "آيا سرور SMTP نياز به تصديق هويت (authentication) دارد؟",
"article-put" => "قراردادن مقاله",
"wiki-get" => "گرفتن ويكي",
"wiki-put" => "قراردادن ويكي",
"wiki-append" => "افزودن ويكي",
"Article Topic" => "عنوان مقاله",
"Article Type" => "نوع مقاله",
"Allow anonymous acces" => "دسترسي بي‌نمام مجاز است؟",
"Allow attachments" => "ضمايم مجازند؟",
"Discard to the end from" => "از اين به بعد را دور بنداز:",
"Check Mail-in accounts" => "بررسي حساب‌هاي 'كنترل با پست الكترونيكي'",
"Check automatically" => "به‌صورت خودكار بررسي كن",
"Frequency" => "تناوب",
"mn" => "دقيقه",
"List menus" => "فهرست منوها",
"Edit this menu" => "اين منو را ويرايش كن",
"Edit menu options" => "ويرايش اختيارات منو",
"Show Quick Urls" => "URLهاي سريع را نمايش بده",
"Some useful URLs" => "چند URL سودمند",
"Hide Quick Urls" => "URLهاي سريع را مخفي كن",
"option" => "اختيارات",
"separator" => "جداكننده",
"Choose" => "انتخاب كنيد",
"Home Page" => "صفحه‌ي مبدا",
"Home Image Gal" => "سرسراي تصوير مبدا",
"Home Image Gallery" => "سرسراي تصوير مبدا",
"Home File Gal" => "سرسراي پرونده‌ي مبدا",
"Home File Gallery" => "سرسراي پرونده‌ي مبدا",
"User preferences" => "تنظيمات كاربر",
"User prefs" => "تنظيمات كاربر",
"List image galleries" => "فهرست سرسراهاي تصوير",
"Gallery Rankings" => "امتيازدهي‌هاي سرسراها",
"Browse a gallery" => "مرور سرسرا",
"All articles" => "تمام مقالات",
"Submit" => "ارائه",
"Create blog" => "ايجاد بلاگ‌",
"File galleries" => "سرسراهاي پرونده‌ها",
"View a forum" => "مشاهده‌ي انجمن",
"View a thread" => "مشاهده‌ي رگه",
"View a FAQ" => "مشاهده‌ي FAQ",
"Take a quiz" => "برگزاري آزمون",
"Stats for a Quiz" => "آمار آزمون",
"Preview menu" => "مشاهده‌ي منو",
"Menu options" => "اختيارات منو",
"Admin Menu Builder" => "مديريت سازنده‌ي منو",
"Admin Menus Template" => "الگوي مديريت منوها",
"Edit this Menu:" => "اين منو را ويرايش كن:",
"Create new Menu" => "ايجاد يك منوي جديد",
"dynamic collapsed" => "جمع‌كردن پويا",
"dynamic extended" => "بست دادن پويا",
"fixed" => "ثابت شده",
"Options" => "اختيارات",
"Admin Modules Template" => "الگوي مديريت ماژول‌ها",
"Assign Module" => "تخصيص ماژول‌ها",
"Left Modules" => "ماژول‌هاي سمت چپ",
"Right Modules" => "ماژول‌هاي سمت راست",
"Edit/Create" => "ويرايش/ساخت",
"Clear Cache" => "پاك‌سازي حافظه نهان(cache)",
"User Modules" => "ماژول‌هاي كاربران",
"Assign" => "اختصاص بده",
"Assign new module" => "تخصيص ماژول جديد",
"Edit this assigned module:" => "اين ماژول تخصيص داده شده را ويرايش كن:",
"Module Name" => "نام ماژول",
"Left" => "چپ",
"Right" => "راست",
"Order" => "ترتيب",
"Cache Time" => "زمان نگهداري در نهانگاه(Cache)",
"Rows" => "رديف",
"Parameters" => "پارامترها",
"Visibility" => "قابلت روئيت",
"Displayed now for all eligible users even with personal assigned modules" => "براي كاربران واجد شرايط كه حتي ماژولي به آن‌ها اختصاص يافته است نيز نمايش داده شود",
"Displayed for the eligible users with no personal assigned modules" => "براي كاربران واجد شرايط كه هيچ ماژول اختصاصي‌اي براي آن‌ها وجود ندارد، نمايش داده شود",
"Displayed now, can't be unassigned" => "نمايش داده مي‌شود، نمي‌تواند حذف شود",
"Not displayed until a user chooses it" => "نمايش داده نمي‌شود مگر آن‌كه كاربر انتخابش كند",
"Assigned Modules" => "ماژول‌‌هاي تخصيصي داده شده",
"Move to Right Column" => "انتقال به ستون چپ",
"Unassign" => "حذف",
"Move to Left Column" => "انتقال به ستون راست",
"Create new user module" => "يك ماژول جديد كاربري ايجاد كن",
"Edit this user module:" => "اين ماژول كاربري را ويرايش كن:",
"Must be wiki parsed" => "بايد توسط ويكي تجزيه شده باشد",
"Objects that can be included" => "اشيائي كه مي‌توانند داخل ماژول قرار بگيرند",
"Available polls" => "راي‌گيري‌هاي موجود",
"Random active poll" => "راي‌گيري فعال تصادفي",
"Random current poll" => "راي‌گيري جاري تصادفي",
"Use Poll" => "از اين راي‌گيري استفاده كن",
"Random image from" => "تصوير تصادفي از",
"Use Gallery" => "از اين سرسراها استفاده كن",
"Dynamic content blocks" => "بلوك محتواي پويا",
"Use Dynamic Content" => "از محتوي پويا استفاده كن",
"Use RSS Module" => "از اين ماژول RSS استفاده كن",
"Use Menu" => "از اين فهرست استفاده كن",
"phpLayersMenus" => "فهرست‌هاي لايه‌اي PHP",
"Use phplayermenu" => "از اين فهرست لايه‌اي PHP استفاده كن ",
"Banner zones" => "قلمرو درفش‌ها(Banner Zones)",
"Use Banner Zone" => "از قلمرو درفش استفاده كن",
"Admin newsletter subscriptions" => "مديريت اشتراك خبرنامه‌ها",
"List Newsletters" => "فهرست خبرنامه‌ها",
"Admin Newsletters" => "مديريت خبرنامه‌ها",
"Add a subscription newsletters" => "افزودن يك اشتراك خبرنامه",
"Add email:" => "افزودن پست الكترونيكي:",
"Add user:" => "افزودن كاربر:",
"Group users" => "كاربران گروه",
"Group subscription also subscribes included groups" => "عضويت در گروه‌ها باعث عضويت در گروه‌هاي شامل نيز مي‌شود",
"Don't send confirmation mail" => "پست الكترونيكي 'تصديق' را ارسال نكن",
"Subscribe group" => "گروه عضو شود",
"Included group, group users and emails will be refreshed at each newsletter sending" => "در هر ارسال خبرنامه، گروه‌ها، كاربران گره‌ها و پست‌هاي الكترونيكي را تازه كن",
"Subscriptions" => "اعضا",
"Valid" => "معتبر",
"subscribed" => "عضو شد",
"Admin Newsletters Template" => "مديريت الگوي خبرنامه‌ها",
"Create/Edit Newsletters" => "ايجاد/تغيير خبرنامه‌ها",
"There are individual permissions set for this newsletter" => "حقوق دسترسي فردي براي اين خبرنامه تنظيم شده است",
"Users can subscribe/unsubscribe to this list" => "اربران مي‌توانند عضو اين فهرست شوند و عضويت خود را لغو كنند",
"Users can subscribe any email address" => "كاربران مي‌توانند هر آدرس پست الكترونيكي را عضو كنند",
"Add unsubscribe instructions to each newsletter" => "دستورالعمل لغو عضويت را در تمام خبرنامه‌ها قرار بده",
"Validate email addresses" => "آدرس‌هاي پست الكترونيكي را تاييد اعتبار كن",
"Editions" => "نسخه‌ها",
"Last Sent" => "آخرين ارسال",
"Send Newsletter" => "خبرنامه را بفرست",
"EMail notifications" => "آگاه‌ساز‌هاي پست الكترونيكي‌اي",
"Admin Notifications Template" => "مديريت الگوي اطلاع‌رساني‌ها",
"Add notification" => "افزودن آگاه‌ساز",
"Event" => "رويداد",
"A user registers" => "ثبت‌نام يك كاربر",
"A user submits an article" => "يك كاربر، يك مقاله ارائه مي‌دهد",
"Any wiki page is changed" => "يكي از صفحات ويكي تغيير كردند",
"Any wiki page is changed, even minor changes" => "هر صفحه‌ي ويكي كه تغيير مي‌كند، حتي اگر تغييرات اندك باشند",
"PHP error" => "خطاهاي PHP",
"Email:" => "پست الكترونيكي:",
"Admin Polls" => "مديريت راي‌گيري‌ها",
"List polls" => "فهرست راي‌گيري‌ها",
"Edit this poll" => "ويرايش اين راي‌گيري",
"Preview poll" => "پيش‌نمايش راي‌گيري",
"Option" => "اختيار(Option)",
"Poll options" => "اختيارات راي‌گيري‌ها",
"Votes" => "تعداد راي‌ها",
"Admin Polls Template" => "مديريت الگوي راي‌گيري‌ها",
"Configure Polls" => "پيكربندي راي‌گيري‌ها",
"Set last poll as current" => "آخرين راي‌گيري را راي‌گيري جاري قرار بده",
"Close all polls but last" => "بجر آخرين راي‌گيري، ما بقي را ببند",
"Activate all polls" => "تمام راي‌گيري‌ها را فعال كن",
"active" => "فعال",
"current" => "جاري",
"template" => "الگو",
"object" => "شيء",
"PublishDate" => "تاريخ انتشار",
"Objects" => "شيء",
"Wiki pages" => "صفحات ويكي",
"Admin Quicktags" => " مديريت تگ‌هاي سريع ",
"tiki admin quicktags template" => "الگوي مديريت تگ‌هاي سريع تيكي",
"Create/Edit QuickTags" => "ايجاد/ويرايش تگ‌هاي سريع",
"Insert (use 'text' for figuring the selection)" => "درج (از 'متن' براي مشخص كردن محدوده‌ انتخاب استفاده كنيد)",
"Path to the tag icon" => "مسير تمثال برچسب",
"Admin RSS modules" => "مديريت ماژول RSS",
"Content for the feed" => "محتواي تغذيه",
"Edit this RSS module:" => "اين ماژول RSS را ويرايش كن",
"Create new RSS module" => "يك ماژول جديد RSS ايجاد كن",
"show feed title" => "عنوان تغذيه را نمايش بده",
"show publish date" => "تاريخ انتشار را نمايش بده",
"Last update" => "آخرين به‌روز رساني",
"Score System" => "سامانه‌ي امتيازدهي",
"security admin" => "مديريت امنيت",
"security admin tpl" => "الگوي مديريت امنيت",
"PHP settings" => "تنظيمات PHP",
"PHP variable" => "متغيير PHP",
"Risk Factor" => "ضريب خطر",
"Explanation" => "توضيحات",
"Tikiwiki settings" => "تنظيمات تيكي‌ويكي",
"Tiki variable" => "متغيير تيكي‌ويكي",
"Check all tiki files" => "تمام پرونده‌هاي تيكي را كنترل كن",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "دقت كنيد كه اين كار ممكن است زمان بسيار زيادي بگيرد. لذا بهتر است قبل از اجراي آن، تنظيم مربوط به max_execution_time در پرونده‌ي php.ini را كنترل كنيد.",
"File checks" => "بررسي‌هاي پرونده",
"type" => "نوع",
"user" => "كاربر",
"group" => "گروه",
"sticky" => "چسب‌‌ناك",
"Admin Shoutbox Words" => "مديريت كلمات فريادگاه",
"Admin Shoutbox Words Template" => "الگوي مديريت كلمات فريادگاه",
"Add Banned Word" => "افزودن كلمات ممنوعه",
"Are you sure you want to delete this word?" => "آيا درمورد حذف اين كلمه مطمئن هستيد؟",
"Destroy the structure leaving the wiki pages" => "هنگام خروجي از صفحات ويكي، ساختار آن‌ها را نابود كن",
"Destroy the structure and remove the pages" => "ساختار را نابود كن و صفحات را حذف نما",
"Structure ID" => "شناسه‌ي ساختار",
"Export Pages" => "صدور صفحه",
"Dump Tree" => "dumpكردن درختواره",
"Create WebHelp" => "ساخت كمك تحت وب",
"View WebHelp" => "مشاهده‌ي كمك وبي",
"Create new structure" => "ايجاد ساختار جديد",
"Alias" => "نام مستعار",
"Tree" => "درختواره",
"Use single spaces to indent structure levels" => "براي مشخص كردن سطوح ساختار از يك 'فاصله' استفاده كنيد",
"Create New Structure" => "ايجاد ساختار جديد",
"Edit survey questions" => "ويرايش سئوالات نظرسنجي‌",
"Survey Stats" => "آمار نظرسنجي‌",
"this survey stats" => "وضعيت اين نظرسنجي‌",
"Edit this Survey" => "ويرايش اين نظرسنجي‌",
"Admin Surveys" => "مديريت نظرسنجي‌ها",
"Create/edit questions for survey" => "ساخت/ويرايش سئوال براي نظرسنجي‌",
"Question" => "سئوال",
"One choice" => "تك انتخابي",
"Multiple choices" => "چند انتخابي",
"Short text" => "متن كوتاه",
"Rate (1..5)" => "امتياز (از 1 تا 5)",
"Rate (1..10)" => "امتياز (از 1 تا 10)",
"Rate" => "نرخ",
"Options (if apply)" => "اختيارات (اگر قابل استفاده باشند)",
"Questions" => "سئوالات",
"question" => "پرسش‌گر",
"administer surveys template" => "اداره كردن الگوي نظرسنجي‌ها",
"Edit this Survey:" => "ويرايش اين نظرسنجي:‌",
"Create New Survey" => "ايجاد نظرسنجي جديد‌",
"There are individual permissions set for this survey" => "حقوق دسترسي فردي براي اين نظرسنجي تعيين شده است‌",
"Open" => "باز",
"system admin" => "مديريت سيستم",
"system admin tpl" => "الگوي مديريت سامانه",
"Empty" => "تخليه شود",
"Templates compiler" => "گردآوري كننده‌ي الگوها",
"Compile" => "گردآوري كن(compile)",
"Fix UTF-8 Errors in Tables" => "رفع اشكالات UTF-8 در جداول",
"Warning: Make a backup of your Database before using this function!" => "اخطار: قبل از استفاده از اين تابع، يك نسخه‌ي پشتيبان از بانك اطلاعاتي خود تهيه كنيد!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "اخطار: اگر سعي در تبديل جداول بزرگ داشته داريد، بيشينه زمان اجرا را در پرونده‌ي php.ini خود بالا ببريد!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "اي تابع، رشته‌هاي كدشده با استاندارد ISO-8859-1 را در جداول شما به UTF-8 تبديل مي‌كند.",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "اگر شما محتوايي را با تيكي &lt; 1.8.4 تهيه كرده باشيد و charsetپيش‌فرض در apache هروي ISO-8859-1 باشد، اين كار احتمالا ضروري است.",
"UTF-8 Errors fixed" => "خطاهاي رفع شده‌ي UTF-8",
"Table" => "جدول",
"Field" => "ستون",
"Investigate" => "استفسار(Investigate)",
"Fix it" => "ترميمش كن",
"Admin Topics" => "مديريت عناوين",
"Admin Topics Template" => "الگوي مديريت عناوين",
"Create a new topic" => "ايجاد يك عنوان جديد",
"Topic Name" => "نام عنوان",
"Upload Image" => " بارگذاري تصوير",
"List of topics" => "فهرست عناوين",
"Active?" => "فعال؟",
"Articles (subs)" => "زير مقالات",
"topic image" => "تصوير موضوع",
"Remove with articles" => "حذف با مقالات",
"Deactivate" => "غيرفعال شود",
"Active Permissions" => "حقوق دسترسي فعال",
"Admin Tracker" => "مديريت tracker",
"edit" => "ويرايش",
"Admin Trackers" => "مديريت trackerها",
"Edit This Tracker" => "ويرايش اين tracker",
"View This Tracker's Items" => "نمايش اقلام اين tracker",
"Edit tracker field" => "ويرايش ستون‌هاي tracker",
"Is column visible when listing tracker items?" => "آيا اين ستون هنگام نمايش فهرست اقلام tracker نمايش داده شود؟",
"Column links to edit/view item?" => "از طريق اين ستون بتوان فقره را ويرايش كرد؟",
"Column is searchable?" => "ستون قابل جستجو باشد؟",
"Field is hidden?" => "ستون مخفي است؟",
"not hidden" => "مخفي نيست",
"editable by admin only" => "تنها به‌وسيله‌ي سرپرست قابل تغيير است",
"Field is mandatory?" => "پركردن اين ستون اجباري است؟",
"Tracker fields" => "ستون‌هاي tracker",
"isMain" => "اصلي؟",
"Tbl vis" => "قابل مشاهده؟",
"Searchable" => "قابل جستجو",
"Public" => "عمومي؟",
"Hidden" => "مخفي؟",
"Mandatory" => "اجباري؟",
"Import/Export Trackers Fields" => "وارد/صادر كردن ستون‌هاي tracker",
"Edit Tracker" => "ويرايش tracker",
"Import/Export" => "واردات/صادرات",
"Create Trackers" => "ايجاد trackerها",
"Found" => "پيدا شد",
"trackers" => "Trackerها",
"Fields" => "ستون‌ها",
"Create/Edit Trackers" => "ايجاد/ويرايش trackerها",
"There are individual permissions set for this tracker" => "حقوق دسترسي فردي براي اين tracker تعريف شده است",
"No individual permissions. Global permissions apply." => "بدون حقوق دسترسي فردي. حقوق دسترسي عمومي اعمال مي‌شوند.",
"with values" => "با مقادير",
"and display rating results in listing?" => "و امتيازات را در فهرست نمايش بده؟",
"Show status" => "وضعيت را نمايش بده؟",
"Default status displayed in list mode" => "وضعيت پيش‌فرض براي نمايش در حالت فهرست",
"Show status to tracker admin only" => "وضعيت را تنها به سرپرست‌ها نمايش بده",
"Send copies of all activity in this tracker to this e-mail address" => "ارسال رونوشت تمام فعاليت‌ها در اين tracker به اين آدرس:",
"Use simplified e-mail format" => "از شكل ساده شده‌ي پست الكترونيكي استفاده كن",
"New items are created with status" => "اقلام جديد با اين وضعيت ايجاد شوند:",
"Authoritative status for modified items" => "وضعيت‌ها مجاز براي اقلام ويرايش شده:",
"No change" => "بدون تغيير",
"Item creator can modify his items?" => "آيا ايجاد كننده‌ي يك فقره، مي‌تواند آن را تغيير دهد؟",
"The tracker needs a user field with the option 1" => "(tracker به يك رشته‌ي كاربري option برابر 1 نياز دارد)",
"Member of the default group of creator can modify items?" => "اعضاي گروه پيش‌فرض كاربران ايجاد كننده مي‌توانند اقلام را ويرايش كنند؟",
"The tracker needs a group field with the option 1" => "(tracker به يك رشته‌ي گروه كاربري option برابر 1 نياز دارد)",
"Show creation date when listing tracker items?" => "نمايش تاريخ ايجاد در فهرست اقلام trakcerها؟",
"Show lastModif date when listing tracker items?" => "نمايش آخرين تاريخ تغيير در فهرست اقلام trakcerها؟",
"What field is used for default sort?" => "اقلام به‌صورت پيش‌فرض به كدام ترتيب باشند؟",
"What is default sort order in list?" => "ترتيب پيش‌فرض در داخل فهرست چيست؟",
"Tracker items allow ratings?" => "امكان امتيازدهي به اقلام trackerها؟",
"Tracker items allow comments?" => "امكان نظردهي درخصوص اقلام؟",
"and display comments in listing?" => "و نظرات را در فهرست نمايش بده؟",
"Tracker items allow attachments?" => "امكان ضميمه كردن به اقلام؟",
"and display attachments in listing?" => "و نمايش ضميمه‌ها در فهرست",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "اختيارات در نمايش ضمايم (از اعداد براي ترتيب‌دهي استفاده كنيد، 0(صفر)ها نمايش داده نمي‌شوند و اعداد منفي در popupها نمايش داده مي‌شوند.",
"Filesize" => "حجم پرونده",
"Filetype" => "نوع پرونده",
"LongDesc" => "توضيحات",
"Import/export trackers" => "وارد/صادر كردن trackerها",
"Info" => "اطلاعات",
"status" => "آمار",
"lastModif" => "آخرين تغييرات",
"Admin groups" => "سرپرستي گروه‌هاي كاربران",
"Admin users" => "سرپرستي كاربران",
"Add new group" => "اضافه كردن گروه جديد",
"Edit group" => "ويرايش گروه",
"Members" => "اعضا",
"Add a New Group" => "افزودن يك گروه جديد",
"List of existing groups" => "فهرست گروه‌هاي موجود",
"Includes" => "شامل",
"Include" => "شامل",
"Group Homepage" => "صفحه‌ي مبدا گروه‌",
"Use wiki page name or full URL" => "از نام صفحات ويكي و يا URL كامل استفاده كنيد",
"Group Information Tracker" => "tracker اطلاعات گروه‌ها",
"choose a group tracker ..." => "يك tracker گروه انتخاب كنيد",
"choose a field ..." => "يك ستون انتخاب كنيد ...",
"Users Information Tracker" => "tracker اطلاعات كاربران",
"choose a users tracker ..." => "يك tracker كاربر انتخاب كنيد...",
"Group tracker item : {\$groupitemid}" => "فقره tracker فقره : {\$groupitemid}",
"Edit Item" => "ويرايش فقره",
"Group tracker item not found" => "فقره tracker گروه يافت نشد",
"Create item" => "ايجاد فقره",
"Members List" => "فهرست اعضا",
"users in group" => "كاربران در گروه",
"Admin Users Template" => "الگوي مديريت كاربران",
"Add a New User" => "اضافه كردن يك كاربر جديد",
"Batch Upload Results" => "نتيجه‌ي بارگذاري دسته‌اي",
"Rejected users" => "كاربران رد اعتبار شده",
"Reason" => "مشكل:",
"Edit user" => "ويرايش كاربر",
"Change user preferences" => "تغيير تنظيمات كاربر",
"Edit Account Settings" => "ويرايش تنظيمات حساب كاربر",
"User Information" => "اطلاعات كاربر",
"Assign Group" => "قرار دادن كاربر در گروه",
"Validate" => "تاييد",
"Remove Users and their Userpages" => "كاربران و صفحات آن‌ها را حذف كن",
"Manage Group Assignments" => "عضويت گروه‌هايشان رو مديريت كن",
"Set Default Groups" => "غضو گروه‌هاي كاربري پيش‌فرض كن",
"Assign selected to" => "انتخاب شده‌ها را منتصب كنيد به",
"Remove selected from" => "انتخاب شده‌ها را حذف كنيد از",
"the following groups:" => "گروه‌هاي ذيل:",
"Set the default group of the selected users to" => "گروه پيش‌فرض كاربران منتخب را به اين گزينه تنظيم كن",
"Assign to Groups" => "انتصاب به گروه‌ها",
"Pass" => "كلمه عبور",
"Again" => "تكرار كلمه‌ي عبور",
"Registration" => "ثبت‌نام",
"Overwrite" => "روي اطلاعات قبلي بنويس",
"User tracker item : {\$usersitemid}" => "فقره tracker كاربر: {\$usersitemid}",
"Admin Article Types" => "مديريت انواع مقالات",
"Article Types tpl" => "الگوي انواع مقالات",
"Shows up in the drop down list of article types" => "در فهرست كركره‌اي انواع مقالات نمايش داده مي‌شود.",
"Allow ratings by the author" => "اجازه‌ي امتيازدهي به‌وسيله‌ي مولف.",
"Show before publish date" => "نمايش قبل از انتشار",
"non-admins can view before the publish date" => "كاربران عادي مي‌توانند قبل از تاريخ انتشار مشاهده كنند.",
"Show after expire date" => "نمايش بعد از انقضا",
"non-admins can view after the expire date" => "كاربران عادي مي‌توانند بعد از انقضا مشاهده كنند.",
"Heading only" => "فقط سرصفحه",
"No article body, heading only" => "بدون متن، تنها سرصفحه",
"Allow comments for this type" => "نظردهي براي اين نوع مجاز است",
"Comment Can Rate Article" => "نظرات در امتياز دخيل‌اند",
"Allow comments to include a rating value" => "نظرات در تعيين امتياز مقاله تاثير دارند.",
"Show image" => "نمايش تصوير",
"Show topic or own image" => "عنوان يا تصوير خود را نمايش بده.",
"Show avatar" => "نمايش شكلك",
"Show author's avatar" => "شكلك مؤلف را نمايش بده",
"Show author" => "نمايش مؤلف",
"Show author name" => "نام مؤلف را نمايش بده",
"Show publish date" => "تاريخ تاليف را نمايش بده",
"Show expire date" => "تاريخ انقضا را نمايش بده",
"Show reads" => "نمايش خوانده‌شدن",
"Show the number of times the article was read" => "تعداد دفعاتي كه اين مقاله خوانده شده را نمايش بده",
"Show size" => "حجم را نمايش بده",
"Show the size of the article" => "حجم مقاله را نمايش بده",
"Show topline" => "نمايش خط مقدم",
"Show a small title over the title" => "يك عنوان كوچك بالاي عنوان اصلي نمايش بده",
"Show subtitle" => "نمايش زيرنويس",
"Show the subtitle" => "،نمايش زيرنويس!",
"Show source" => "نمايش منبع",
"Show link to source after article body" => "پس از متن مقاله، پيوند به منبع را نمايش بده",
"Show Image Caption" => "عنوان تصوير را نمايش بده",
"Show a legend under the image" => "علائم و اختصارات را زير تصوير نمايش بده",
"Show Language" => "نمايش زبان",
"Show the language" => "زبان را نمايش بده",
"Creator can edit" => "امكان ويرايش خالق",
"The person who submits an article of this type can edit it" => "شخصي كه مقاله‌اي از اين دسته را ارائه كرده است، بتواند آن‌را ويرايش كند",
"Delete this type" => "حذف اين نوع",
"List of types" => "فهرست انواع",
"Show lang" => "نمايش زبان",
"Review" => "مرور",
"Classified" => "طبقه‌بندي شده",
"Create a new type" => "ساخت نوع جديد",
"Assign permissions to group" => "تخصيص حقوق دسترسي به گروه كاربري ",
"Edit Article Tpl" => "الگوي ويرايش مقالات",
"Group Information" => "اطلاعات گروه",
"Desc" => "توضيحات",
"Create level" => "ايجاد مرلحه",
"all permissions in level" => "تام حقوق دسترسي در مرحله",
"level" => "مرحله",
"Default Group" => "گروه پيش‌فرض",
"Assign Perms to this Group" => "حقوق دسترسي اختصاص يافته به اين گروه",
"backlinks to" => "پيوندهاي معكوس به",
"No backlinks to this page" => "هيچ پيوند معكوسي براي اين صفحه وجود ندارد",
"Browse gallery" => "مرور سرسرا",
"Upload from disk" => " بارگذاري از دستگاه",
"Process" => "فرايند",
"Wiki Help" => "كمك از ويكي",
"Admin Category" => "مديريت طبقه",
"Browse in" => "مرور در",
"Trackers Items" => "اقلامtrackerها",
"Sheets" => "ورق‌ها",
"Hide subcategories objects" => "اشياء زيرطبقات را مخفي كن",
"Show subcategories objects" => "اشياء زيرطبقات را هم نشان بده",
"Clear" => "پاك كن",
"Browsing Gallery" => "مرور سرسرا",
"List Galleries" => "فهرست سرسراها",
"Edit Gallery" => "ويرايش سرسرا",
"Rebuild Thumbnails" => "تصويرك‌ها را مجددا بساز",
"List Gallery" => "نمايش اقلام",
"Sort Images by" => "تصاوير مرتب بر اساس",
"Subgallery" => "زير سرسرا",
"Hit" => "ضربه(hit)",
"Original Size" => "اندازه‌ي سازمان",
"rotate right" => "چرخش به راست",
"rotate" => "چرخش",
"Details" => "جزئيات",
"Browsing Image" => "مرور تصوير",
"Return to Gallery" => "بازگشت به سرسرا",
"Edit Image" => "ويرايش تصوير",
"First Image" => "اولين تصوير",
"Prev Image" => "تصوير قبلي",
"Smaller" => "كوچكتر",
"Bigger" => "بزرگتر",
"Popup window" => "پنجره‌ي Popup",
"Next Image" => "تصوير بعدي",
"Last Image" => "آخرين تصاوير",
"Stop" => "توقف",
"Direction" => "جهت",
"Click to zoom" => "براي بزرگنمايي اين‌جا را كليك كنيد",
"Image Name" => "نام تصوير",
"Image size" => "اندازه‌ي تصوير",
"Image Scale" => "مقياس تصوير",
"Latitude (WGS84/decimal degrees)" => "عرض جغرافيايي (درجه‌ي دهدهي بر اساس WGS84)",
"Longitude (WGS84/decimal degrees)" => "طول جغرافيايي (درجه‌ي دهدهي بر اساس WGS84‌)",
"Move image" => "انتقال تصوير",
"You can view this image in your browser using" => "به اين طريق مي‌توانيد تصوير را در مرورگر خود ببينيد",
"You can include the image in an HTML page using one of these lines" => "به كمك يكي از اين خطوط مي‌توانيد تصوير دلخواه خود را در يك صفحه‌ي HTML بگنجانيد",
"You can include the image in a tiki page using one of these lines" => "به كمك يكي از اين خطوط مي‌توانيد تصوير دلخواه خود را در يك صفحه‌ي تيكي بگنجانيد",
"Group Calendars" => "تقويم‌هاي گروهي",
"Change Focus" => "تغيير تمركز",
"Hours" => "ساعت",
"Edit Calendar Item" => "ويرايش فقره جديد در تقويم",
"New Calendar Item" => "ايجاد فقره‌ي جديد در تقويم",
"End" => "پايان",
"Duration" => "مدت زمان",
"Tentative" => "آزمايشي",
"Confirmed" => "تاييد شد",
"Cancelled" => "لغو شد",
"Location" => "محل",
"Organized by" => "سازماندهي شده به‌وسيله‌ي",
"Roles" => "قوانين",
"import" => "وارد كن",
"Focus:" => "تمركز:",
"Assign permissions to category" => "تخصيص حقوق دسترسي به طبقه ",
"Current permissions for this category" => "دسترسي‌هاي جاري براي اين طبقه",
"Permission" => "حقوق دسترسي",
"Remove from this Category Only" => "تنها از اين طبقه حذفش كن",
"Remove from this Category &amp; all its Children" => "از اين طبقه و طبقات فرزندش حذف كن",
"Assign permissions" => "تخصيص حقوق دسترسي به ",
"to group" => "را به گروه",
"this category &amp; all its children" => "اين طبقه و تمام طبقات فرزندانش",
"this category only" => "تنها اين طبقه",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "تخصيص حقوق دسترسي براي  <b>تمام فرزندان</b> براي رسيدن به بهترين عملكرد پيشنهاد مي‌شود",
"Change password enforced" => "تغيير كلمه‌ي عبور اجباري است",
"Old password" => "كلمه‌ي عبور قبلي",
"Again please" => "دوباره لطفا",
"Send a message to us" => "يك پيغام براي ما بفرستيد",
"Contact us by email" => "تماس با ما از طريق پست الكترونيكي",
"Click here to send us an email" => "براي ارسال يك پست الكترونيكي به ما، اين‌جا را كليك كنيد",
"Contacts" => "تماس‌ها",
"Create/edit contacts" => "ايجاد/ويرايش تماس",
"First Name" => "نام كوچك",
"Last Name" => "نام خانوادگي",
"Nickname" => "نام مستعار",
"You can browse the generated WebHelp here" => "شما مي‌توانيد 'كمك تحت‌وب' توليد شده را اينجا مرور كنيد",
"Structure" => "ساختار",
"Top page" => "صفحه‌ي بالا",
"Tiki Debugger Console" => "ميز رفع اشكال تيكي",
"Close" => "ببند",
"Current URL" => "URL كنوني",
"Command" => "دستور",
"exec" => "اجرا",
"Type <code>help</code> to get list of available commands" => "براي دريافت فهرستي از دستورات موجود، را وارد كنيد<code>help</code>",
"Add a new site" => "افزودن يك پايگاه جديد",
"You cannot add sites until Directory Categories are setup." => "قبل از تنظيم طبقات پوشه‌ها، نمي‌توانيد پايگاهي اضافه كنيد.",
"Please contact the Site Administrator" => "لظفا با سرپرست پايگاه تماس بگيريد.",
"Site added" => "پايگاه اضافه شد",
"URL:" => "آدرس اينترنتي(URL):",
"Categories:" => "طبقات:",
"Is valid" => "آيا معتبر است؟",
"Directory Administration" => "مديريت پوشه‌ها",
"Admin Directory tpl" => "الگوي مديريت پوشه",
"Edit Tpl" => "ويرايش الگو",
"There are" => "تعداد",
"invalid sites" => "پايگاه بي‌اعتبار",
"valid sites" => "پايگاه معتبر",
"Users have visited" => "كاربران ديده‌اند:",
"sites from the directory" => "عدد از اين پوشه.",
"Users have searched" => "كاربران جستجو كرده‌اند:",
"times from the directory" => "بار از اين پوشه.",
"Admin sites" => "مديريت پايگاه‌ها",
"Admin category relationships" => "مديريت ارتباط طبقات",
"Validate links" => "تاييد اعتبار پيوندها",
"Browse" => "مرور",
"Related" => "مرتبط",
"Admin directory categories" => "مديريت طبقات پوشه‌ها",
"Admin Directory Categories tpl" => "الگوي مديريت طبقات پوشه",
"Parent category" => "طبقه‌ي مادر",
"Add a directory category" => "افزودن يك طبقه‌ي پوشه‌اي",
"Edit this directory category" => "اين پوشه‌ي طبقات را ويرايش كن",
"Children type" => "انواع فرزند",
"Most visited sub-categories" => "پر بيننده‌ترين زيرطبقات",
"Category description" => "شرح طبقه",
"Random sub-categories" => "زيرطبقات تصادفي",
"Maximum number of children to show" => "بيشينه تعداد فرزنداني كه نمايش داده مي‌شود",
"Allow sites in this category" => "پايگاه‌ها در اين طبقه مجازند",
"Show number of sites in this category" => "تعداد پايگاه‌ها در اين طبقه را نمايش بده",
"Editor group" => "گروه ويراستار",
"Subcategories" => "زيرطبقات",
"cType" => "نوع طبقه",
"allow" => "مجاز",
"count" => "تعداد",
"editor" => "ويراستار",
"relate" => "ارتباط",
"Admin related categories" => "مديريت طبقات مرتبط",
"Admin Directory Related " => "مديريت پوشه‌هاي مرتبط",
"directory admin related tpl" => "الگوي مديريت پوشه‌ي مرتبط",
"Add a related category" => "افزودن يك طبقه‌ي مرتبط",
"Mutual" => "دوجانبه",
"Related categories" => "طبقات مرتبط",
"Admin Directory Sites" => "مديريت پايگاه‌هاي پوشه",
"Admin Directory Sites tpl" => "مديريت الگوي پايگاه‌هاي پوشه",
"New Sites" => "پايگاه‌هاي جديد",
"Cool Sites" => "پايگاه‌هاي بامزه(cool)",
"Add a Site" => "اضافه كردن يك پاگاه",
"Add a Category" => "اضافه كردن يك طبقه",
"any" => "هركدام از",
"in entire directory" => "در بين تمام پوشه‌ها‌",
"in current category" => "در بين طبقه‌ي جاري",
"Sort by" => "مرتب بر اساس",
"name (desc)" => "نام (نزولي)",
"name (asc)" => "نام (صعودي)",
"hits (desc)" => "ضربت-hit- (نزولي)",
"hits (asc)" => "ضربت-hit- (صعودي)",
"creation date (desc)" => "تاريخ ايجاد (نزولي)",
"creation date (asc)" => "تاريخ ايجاد (صعودي)",
"last updated (desc)" => "آخرين تغيير (نزولي)",
"last updated (asc)" => "آخرين تغيير (صعودي)",
"sort" => "مرتب كن",
"Added" => "اضافه شد",
"Last updated" => "تاريخ آخرين تغيير",
"Total categories" => "مجموع طبقهها",
"Total links" => "مجموع پيوندها",
"Links to validate" => "پيوندهايي كه بايد بررسي شوند",
"Searches performed" => "جستجو انجام شده",
"Total links visited" => "مجموعه صفحاتي كه ديده شده",
"Directory ranking" => "امتيازدهي به پوشه‌ها",
"Search results" => "نتيجه‌ي جستجو",
"Validate sites" => "پايگاه را تاييد اعتبار كنيد",
"Validate Sites" => "پايگاه را تاييد اعتبار كنيد",
"directory validate sites tpl" => "الگوي پايگاه تاييد اعتبار پوشه",
"country" => "كشور",
"Edit Article" => "ويرايش مقاله",
"List Articles" => "فهرست مقالات",
"View Articles" => "مشاهده‌ي مقالات",
"Topline" => "خط بالايي",
"Subtitle" => "زيرنويس",
"Author Name" => "نام مولف",
"Own Image" => "تصوير مخصوص",
"Use own image" => "از تصوير مخصوص استفاده كن؟",
"Float text around image" => "متن را حول تصوير شناور كن",
"Own image size x" => "طول تصوير اختصاصي",
"Own image size y" => "عرض تصوير اختصاصي",
"Image caption" => "عنوان تصوير",
"Heading" => "سرنامه(عنوان)",
"Body" => "مات",
"Expiration Date" => "تاريخ انقضا",
"Edit or create banners" => "ويرايش يا ساخت درفش‌ها",
"List banners" => "فهرست درفش‌ها",
"URL to link the banner" => "URL براي پيوند درفش",
"Client" => "نرم‌افزار بخش كاربر",
"Max impressions" => "بيشينه تعداد نمايش",
"Show the banner only between these dates" => "درفش را تنها در اين بازه‌ي تاريخي نمايش بده",
"From date" => "از تاريخ",
"To date" => "تا تاريخ",
"Use dates" => "هر هيچ حالت بعد از تاريخ فعال نباشد",
"Show the banner only in this hours" => "درفش را تنها در اين ساعات نمايش بده",
"to" => "تا",
"Show the banner only on" => "درفش را تنها در اين روزها نمايش بده",
"Mon" => "دوشنبه",
"Tue" => "سه‌شنبه",
"Wed" => "چهارشنبه",
"Thu" => "پنج‌شنبه",
"Fri" => "جمعه",
"Sat" => "شنبه",
"Sun" => "يك شنبه",
"Select ONE method for the banner" => "تك شيوه براي درفش انتخاب كنيد",
"Use HTML" => "از HTML استفاده كن",
"HTML code" => "كد HTML",
"Use image" => "از تصوير استفاده كن:",
"Image:" => "تصوير:",
"Current Image" => "تصوير كنوني",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "از تصوير توليد شده توسط URL استفاده كن.(تصوير براي هر مشاهده به‌وسيله‌ي URL درخواست خواهد شد)",
"Use text" => "از متن استفاده كن",
"Text" => "متن",
"Save the Banner" => "درفش را ذخيره كن",
"Remove Zones (you lose entered info for the banner)" => "قلمروها را حذف كن(اطلاعات مربوط به درفش‌ها را از دست خواهيد داد)",
"Edit Blog" => "ويرايش بلاگ",
"Create Blog" => "ايجاد بلاگ",
"Edit Blog Tpl" => "ويرايش الگوي بلاگ",
"Current heading" => "سرصفحه‌ي كنوني",
"There are individual permissions set for this blog" => "حقوق دسترسي فردي براي اين بلاگ تنظيم شده است",
"Number of posts to show" => "تعداد الصاق‌هايي كه بايد نشان داده شود",
"Allow other user to post in this blog" => "به ديگر كاربران اجازه‌ي الصاق در اين بلاگ را بده",
"Use titles in blog posts" => "از عنوان در الصاق‌هاي بلاگ استفاده كن",
"Allow search" => "اجازه‌ي جستجو را بده",
"Allow comments" => "اجازه‌ي نظردادن(commenting) را بده",
"Show user avatar" => "شكلك كاربر را نمايش بده",
"Blog heading" => "سرصفحه‌ي بلاگ",
"Edit Style Sheet" => "ويرايش سبك نگارش",
"Style Sheet" => "سبك نگارش",
"choose a stylesheet" => "يك سبك نگارش انتخاب كنيد",
"Try" => "تلاش",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "پرونده‌هايي كه با -{\$user} آغاز مي‌شوند، قابل تغيير هستند، باقي تنها قابل كپي‌كردن و استفاده به عنوان مدل هستند.",
"Show Plugins Help" => "نمايش كمك در مورد Pluginها",
"some text" => "برخي متون",
"Creates a box with the data" => "يك جعبه با داده بساز",
"Box content" => "محتواي جعبه",
"Title bar" => "ميله‌ي عنوان",
"creates a title bar" => "يك ميله‌ي عنوان مي‌سازد",
"Colored text" => "متن رنگي",
"Lists" => "فهرست‌ها",
"for bullet lists" => "براي فهرست گلوله‌اي",
"for numbered lists" => "براي فهرست شماره‌اي",
"for definiton lists" => "براي فهرست معنا",
"Tables" => "جداول",
"creates a table" => "يك جدول مي‌سازد",
"makes a horizontal rule" => "يك قانون افقي ايجاد كن",
"Wiki References" => "مرجع‌هاي ويكي",
"JoinCapitalizedWords or use" => "كلمات با حروف بزرگ را ادغام كن و يا از اين استفاده كن",
"page|desc" => "صفحه|توضحيات",
"for wiki references" => "براي مراجع ويكي",
"SomeName" => "نامي",
"prevents referencing" => "ممانعت از ارجاع‌دهي",
"External links" => "پيوندهاي خارجي",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "براي يك ويكي خارجي، از 'نام ويكي خارجي': نام صفحه يا ((نام ويكي خارجي': نام صفحه)) استفاده كنيد",
"displays an image" => "يك تصوير نمايش مي‌دهد",
"Non cacheable images" => "تصاوير غيرقابل Cache شدن",
"height width desc link and align are optional" => "پيوند توضيحات ارتفاع و عرض صف كردن‌ها اختياري‌اند",
"Multi-page pages" => "صفحات چندصفحه‌اي",
"RSS feeds" => "تغذيه‌ي RSS",
"displays rss feed with id=n maximum=m items" => "تغذيه‌هاي RSS اي كه شناسه‌اش برابر n و حداكثر m فقره است را نمايش مي‍دهد",
"Will be replaced by the actual value of the dynamic content block with id=n" => "به‌وسيله‌ي بلاك محتواي پويا با شناسه‌ي برابر n جايگزين خواهد شد",
"Dynamic variables" => "متغييرهاي پويا",
"Inserts an editable variable" => "يك متغيير قابل ويرايش درج مي‌كند",
"Non parsed sections" => "بخش تجزيه نشده",
"Prevents wiki parsing of the enclosed data." => "از تجزيه‌ي داده‌ي پيوست توسط ويكي ممانعت مي‌كند.",
"Preformated sections" => "شكل‌دهي اوليه‌ي بخش‌ها",
"Square Brackets" => "كروشه‌هاي مربع",
"Use [[foo] to show [foo]." => "از [[foo] براي نمايش[foo] استفاده كنيد.",
"Block Preformatting" => "شكل‌دهي اوليه را مسدود كن",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "متن پيش‌تاخته را با هر تعداد فاصله‌ي خالي را يك بلوك تك فاصله‌اي تبديل كن كه هنوز ساير دستورالعمل‌هاي شكل‌بندي ويكي را رعايت مي‌كند. از همان تعداد فاصله كه شما وارد كرده‌اي استفاده خواهد شد. توجه كنيد كه اين حالت از تك فاصله‌ها و خط شكن‌ها جلوگيري نمي‌كند؛ براي اين‌كار از ~pp~...~/pp~ استفاده كنيد.",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" فهرست محتويات صفحه‌ي جاري را مبني بر ساختار ()toc يا سرصفحه‌ي (maketoc) چاپ خواهد كرد.",
"Misc" => "متنوع",
"Show Text Formatting Rules" => "قوانين شكل‌دهي متون را نمايش بده",
"No description available" => "توضيحي موجود نيست",
"bold" => "پررنگ",
"italic" => "مورب",
"underline" => "زيرخط دار",
"table" => "جدول",
"table new" => "جدول جديد",
"external link" => "پيوند خارجي",
"wiki link'" => "پيوند ويكي'",
"heading1" => "سرصفحه‌ي 1",
"title bar" => "نوار عنوان",
"box" => "جعبه",
"rss feed" => "تعذيه‌ي RSS",
"dynamic content" => "محتواي پويا",
"tagline" => "خط برچسب(tagline)",
"center text" => "متن در وسط",
"colored text" => "متن رنگي",
"dynamic variable" => "متغيير پويا",
"New wms Metadata" => "فراداده‌ي WMS جديد",
"New Class" => "كلاس جديد",
"New Projection" => "افكنش جديد",
"New Query" => "درخواست جديد",
"New Scalebar" => "نوار مقياس جديد",
"New Layer" => "لايه‌ي جديد",
"New Label" => "برچسب جديد",
"New Reference" => "مرجع جديد",
"New Legend" => "فهرست علائم جديد",
"New Web" => "وب جديد",
"New Outputformat" => "شكل خروجي جديد",
"New Mapfile" => "پرونده‌ي نقشه‌ي جديد",
"special chars" => "حروف خاص",
"special characters" => "حروف خاص",
"Browse Images" => "مرور تصوير",
"Edit successful!" => "ويرايش موفقيت‌آميز بود!",
"The following image was successfully edited" => "تصوير مقابل با موفقيت ويرايش شد",
"Image Description" => "شرح تصوير",
"Edit and create Languages" => "ويرايش و ايجاد زبان‌ها",
"Im- Export Languages" => "واردات، صادرات زبان‌ها",
"Edit and create languages" => "ويرايش و ايجاد زبان‌ها",
"Create Language" => "ساخت زبان",
"Shortname" => "نام كوتاه",
"like" => "مانند",
"Longname" => "نام بلند",
"Select the language to edit" => "زبان را براي ويرايش انتخاب كنيد",
"Add a translation" => "يك ترجمه اضافه كن",
"Edit translations" => "ويرايش ترجمه",
"Translate recorded" => "ترجمه ظبط شد",
"Original" => "بكر",
"Translate" => "ترجمه كن",
"reset table" => "جدول را بازبنشان",
"Program dynamic content for block" => "محتواي پوياي برنامه براي بلوك",
"Create New Block" => "يك بلوك جديد ايجاد كن",
"Return to block listing" => "به فهرست بلوك‌ها بازگرد",
"Block description: " => "توضيحات بلوك: ",
"You are editing block:" => "شما در حال ويرايش اين بلاك هستيد:",
"Publishing date" => "تاريخ انتشار",
"Publishing Date" => "تاريخ انتشار",
"Edit question options" => "ويرايش اختيارات سئوالات",
"Quiz Stats" => "آمار آزمون‌ها",
"This Quiz Stats" => "آمار اين آزمون",
"Edit this Quiz" => "اين آزمون را ويرايش كن",
"Admin Quizzes" => "مديريت آزمون‌ها",
"Create/edit options for question" => "ايجاد/ويرايش اختيارات براي سئوال‌ها",
"points" => "امتياز",
"Admin quizzes" => "مديريت آزمون‌ها",
"Admin Quizzes tpl" => "الگوي مديريت آزمون‌ها",
"Create/edit quizzes" => "ايجاد/تغيير آزمون‌ها ",
"There are individual permissions set for this quiz" => "براي اين آزمون، حقوق دسترسي فردي تنظيم شده است.",
"Quiz can be repeated" => "امكان شركت مجدد در آزمون وجود دارد",
"Store quiz results" => "نتايج آزمون‌ها را نگهداري كن",
"Immediate feedback" => "نتيجه را بلافاصله به كاربر اعلام كن",
"Show correct answers" => "جواب‌هاي صحيح را نمايش بده",
"Shuffle questions" => "سئوالات را درهم‌ريخته انتخاب كن",
"Shuffle answers" => "جواب‌ها را درهم ريخته نشان بده",
"Questions per page" => "تعداد سئوالات در هر صفحه",
"Quiz is time limited" => "زمان آزمون محدود است",
"Maximum time" => "بيشينه زمان",
"Passing Percentage" => "نمره‌ي قبولي",
"canRepeat" => "قابل تكرار",
"timeLimit" => "زمان آزمون",
"Results" => "نتايج",
"Edit quiz questions" => "ويرايش سئوالات آزمون",
"Edit Quiz Questions" => "سئوالات آزمون را ويرايش كن",
"Edit Quiz Questions Tpl" => "الگوي ويرايش سئوالات آزمون",
"Create/edit questions for quiz" => "ايجاد/ويرايش سئوال‌ها براي آزمون",
"Question Type" => "نوع سئوال",
"Import questions from text" => "سئوالات را از متن دريافت كن",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "دستورالعمل: سئوالات چندگزينه‌اي خود را در زير تايپ كنيد. در خط اول سئوال و در خطوط بعدي در هر خط پاسخ‌ها را وارد كنيد. سئوال‌هاي بعدي را با يك خط خالي از هم جدا كنيد. پاسخ‌هاي صحيح را با \"*\" مشخص كنيد (ستاره‌ي خالي، بدون گيومه).",
"Input" => "ورودي",
"maxScore" => "امتياز بيشينه",
"From Points" => "از امتياز",
"To Points" => "تا امتياز",
"Answer" => "پاسخ",
"Modify Structure" => "اصلاح ساختار",
"You will remove" => "شما حذف خواهيد كرد:",
"and its subpages from the structure, now you have two options:" => "و زيرصفحات آن را از ساختار، حالا شما تو انتخاب داريد:",
"Remove only from structure" => "تنها از ساختار حذفش كن",
"Remove from structure and remove page too" => "از ساختار حذفش كن و خود صفحه را نيز حذف كن",
"Structure Layout" => "طرح‌بندي ساختار",
"Promote" => "ارتقا",
"Demote" => "تنزل",
"Previous" => "قبلي",
"Current Node" => "گره‌ي كنوني",
"Page alias" => "نام مستعار صفحه",
"Add pages to current node" => "افزودن صفحه به گره‌ي كنوني",
"After page" => "پس از صفحه",
"Create Page" => "ساخت صفحه",
"Use pre-existing page" => "از صفحات موجود استفاده كن",
"Edit Submissions Tpl" => "الگوي ويرايش ارائه‌ها",
"List Submissions" => "فهرست ارائه‌ها",
"<b>*</b>=optional" => "<b>*</b>=اختياري",
"<b>Topline</b>=small line above Title" => "<b>خط اوليه</b>=خط كوچك بالاي تيتر",
"<b>Source</b>=URL to article source" => "<b>منبع</b>=URLاي به منبع مقاله",
"EditTemplates" => "ويرايش الگوها",
"EditTemplates tpl" => "الگوي ويرايش الگوها",
"Template listing" => "فهرست الگوها",
"Available templates" => "الگوهاي موجود",
"Save Only in the Theme:" => "ذخيره فقط براي قيافه‌ي ",
"Edit a topic" => "ويرايش يك موضوع",
"Edit Translations" => "ويرايش ترجمه‌ها",
"Edit Translations Template" => "الگوي ويرايش ترجمه‌ها",
"You must specify the object language" => "بايد زبان شيء را مشخص كنيد",
"The object doesn't exist" => "شيء وجود ندارد",
"The object doesn't have a language" => "شيء زباني ندارد",
"The object has already a translation for this language" => "اين شيء قبلا براي اين زبان ترجمه شده است",
"The object is already in the set of translations" => "اين شيء از قبل در مجموعه‌ي ترجمه‌ها وجود داشته است",
"detach" => "جداسازي",
"Use rating" => "از امتيازدهي استفاده كن",
"disable" => "غيرفعال شده‌است",
"There is no available poll template." => "هيچ الگوي راي‌گيري‌اي وجود ندارد.",
"You should ask an admin to create them." => "براي ايجاد آن‌ها بايد از مديريت درخواست كنيد.",
"an existing poll" => "يك راي‌گيري موجود",
"votes" => "راي",
"Import HTML" => "واردات HTML",
"Admin FAQ" => "مديريت FAQ",
"View FAQ" => "مشاهده‌ي FAQ",
"Edit this FAQ" => "ويرايش اين FAQ",
"New Question" => "سئوال جديد",
"Use a question from another FAQ" => "استفاده از يك سئوال در FAQ ديگر",
"FAQ questions" => "سئوالات FAQ",
"Suggested questions" => "سئوالات پيشنهاد شده",
"Approve" => "تصويب",
"No suggested questions" => "بدون سئوال پيشنهادي",
"Upload File" => "بارگذاري پرونده",
"File Galleries tpl" => "الگوي سرسراهاي پرونده",
"Browse Gallery" => "مرور سرسرا",
"You can access the file gallery using the following URL" => "شما مي‌توانيد به كمك اين آدرس به سرسراهاي پرونده‌ها دسترسي پيدا كنيد",
"Message queue for" => "صف پيغام براي",
"back to forum" => "بازگشت به انجمن",
"Edit queued message" => "ويرايش پيغام‌هاي در صف",
"make this a thread of" => "اين را به يك گره تبديل كن از",
"None, this is a thread message" => "هيچ‌كدام، اين يك پيغام رگه‌اي است",
"summary" => "خلاصه",
"normal" => "معمولي",
"announce" => "اعلام",
"hot" => "برانگيخته",
"no feeling" => "بدون احساس",
"frown" => "اخمو",
"exclaim" => "متعجب",
"idea" => "متفكر",
"mad" => "قاطي",
"neutral" => "معمولي",
"sad" => "غمگين",
"happy" => "شاد",
"wink" => "چشمك",
"Save and Approve" => "ذخيره و تاييد",
"convert to topic" => "تبديل به عنوان",
"List of messages" => "فهرست پيغام‌ها",
"New Topic" => "عنوان جديد",
"no summary" => "بدون خلاصه",
"No messages queued yet" => "هنوز هيچ پيغامي در صف قرار نگرفته است",
"Reject" => "مردود",
"Configure Forum" => "پيكربندي انجمن‌ها",
"Reported messages for" => "پيغام‌هاي گزارش شده براي",
"Reported by" => "گزارش شده به‌وسيله‌ي",
"friends tpl" => "الگوي رفقا",
"Pending requests" => "درخواست‌هاي رفاقت معلق",
"Request Time" => "زمان درخواست",
"Accept" => "قبول شده",
"Refuse" => "رد مي‌كنم",
"Waiting requests" => "درخواست‌هاي در انتظار",
"Your friends" => "دوستان شما",
"break friendship" => "قطع ارتباط(رفاقت)",
"Activity completed" => "فعاليت به اتمام رسيد",
"Admin process activities" => "مديريت فعاليت‌هاي فرايند",
"Add or edit an activity" => "افزودن يا ويرايش يك فعاليت",
"activity" => "فعاليت",
"split" => "انشعاب",
"join" => "اتصال",
"standalone" => "خودمختار",
"interactive" => "تعاملي",
"auto routed" => "خودمسيرياب است",
"Expiration Time" => "تاريخ انقضا",
"Years" => "سال",
"Months" => "ماه",
"Minutes" => "دقيقه",
"Add transitions" => "افزودن تراكنش",
"Add transition from:" => "تراكنش ها را از اين‌جا اضافه كن:",
"Add transition to:" => "تراكنش‌ها را به اين‌جا اضافه كن:",
"No roles associated to this activity" => "هيچ قانوني به اين فعاليت تخصيص نگرفته است",
"Add Role" => "قانون را اضافه كن",
"Add New" => "جديد",
"Process activities" => "فعاليت‌هاي فرايند",
"Int" => "تعامل",
"Routing" => "مسيريابي",
"Interactive" => "تعاملي",
"Automatic" => "خودكار",
"Auto routed" => "خودكار",
"Manual" => "دستي",
"#" => "رديف",
"inter" => "تعامل",
"route" => "مسيريابي",
"(no roles)" => "(بدون قانون)",
"Code" => "دستورالعمل",
"No activities defined yet" => "هنوز هيچ فعاليت تعريف نشده است.",
"Process Transitions" => "تراكنش‌هاي فعاليت",
"List of transitions" => "فهرست تراكنش‌ها",
"From:" => "از:",
"Origin" => "سرچشمه",
"No transitions defined yet" => "هنوز هيچ تراكنشي تعريف نشده است.",
"Add a transition" => "افزودن يك تراكنش",
"Process Graph" => "نودار فرايند",
"Galaxia Admin Graph" => "نگار مديريت گالكسي",
"Galaxia Admin Graph tpl" => "الگوي نگار مديريت گالكسي",
"This process is invalid" => "اين فرايند نامعتبر است",
"Process Graph for" => "نگار براي فرايند",
"No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "هيچ نموداري موجود نيست. يا فرايند شامل خطا است و يا نموداري هنوز توليد نشده است و يا <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> به درستي نصب نگرديده است.",
"List of processes" => "فهرست فرايندها",
"Inactive" => "غيرفعال",
"act" => "گونه",
"val" => "معتبر؟",
"Active Process" => "فرايندهاي فعال",
"Invalid Process" => "فرايند نامعتبر",
"Valid Process" => "فرايند معتبر",
"Activities" => "فعاليت‌ها",
"New Minor" => "كهاد جديد",
"New Major" => "مهاد جديد",
"No processes defined yet" => "هنوز هيچ فرايندي تعريف نشده است.",
"Admin instance" => "مديريت نمونه‌ها",
"Process:" => "فرايند",
"Instance" => "نمونه",
"Workitems" => "اقلام كاري",
"exception" => "استثنا",
"completed" => "تكميل شده",
"Aborted" => "منقطع شده",
"Owner" => "مالك",
"Send all to" => "ارسال به همه",
"Don't move" => "حركت نكن",
"Started" => "تاريخ برپايي",
"Act status" => "وضعيت كنش",
"Ended" => "پايان يافته",
"Not Defined" => "تعريف نشده",
"Not Interactive" => "غيرتعاملي",
"Not Ended" => "پايان نپذيرفته",
"Property" => "خاصيت",
"Add property" => "افزودن خصوصيت",
"run instance" => "اجراي نمونه",
"Executed" => "اجرا",
"erase" => "پاكش كن",
"Galaxia Admin Processes" => "فرايندهاي مديريت گالكسي",
"Galaxia Admin Processes tpl" => "الگوي فرايندهاي مديريت گالكسي",
"Add or edit a process" => "افزودن يا ويرايش كردن يك فرايند",
"Process Name" => "نام فرايند",
"ver:" => "نگارش:",
"is active?" => "آيا فعال است؟",
"Or upload a process using this form" => "يا به كمك اين ورقه يك فرايند بارگذاري كنيد",
"Admin process roles" => "مديريت قوانين فرايند",
"Add or edit a role" => "ايجاد يا ويرايش يك قانون",
"Process roles" => "قوانين فرايند",
"No roles defined yet" => "هنوز هيچ قانوني تعريف نشده است.",
"Map users to roles" => "نگاشتن كاربران به قوانين",
"Map" => "نگاشت",
"map" => "بنگار",
"Map groups to roles" => "نگاشت گروه‌هاي كاربري به قوانين",
"Operation" => "عمل",
"Warning" => "اخطار",
"No roles are defined yet so no roles can be mapped" => "هنوز هيچ قانوني تعريف نشده است، لذا هيچ قانوني قابل نگاشت نيست.",
"List of mappings" => "فهرست نگاشت‌ها",
"No mappings defined yet" => "هنوز هيچ نگاشتي تعريف نشده است.",
"Admin process sources" => "مديريت منابع فرايندها",
"select source" => "انتخاب منبع",
"Shared code" => "دستورالعمل(كد)هاي به اشتراك گذاشته شده",
"Set next user" => "تنظيم كاربر بعدي(Set next user)",
"Get property" => "دريافت خصوصيت(Get property)",
"Set property" => "تنظيم خصوصيت(Set property)",
"Complete" => "كامل",
"Process form" => "فرم فرايند",
"Set Next act" => "تنظيم عمل بعدي",
"If:SetNextact" => "اگر:تنظيم‌فعالت‌بعدي",
"Switch construct" => "تعويض ساختار",
"Map process roles" => "نگاشت قوانين فرايند",
"Admin Processes" => "مديريت فرايندها",
"Admin Activities" => "مديريت فعاليت‌ها",
"Admin Roles" => "مديريت قوانين",
"Edit this Process" => "اين فرايند را ويرايش كن",
"Galaxia Monitor Activities" => "ديده‌باني فعاليت‌هاي گالكسي",
"Galaxia Monitor Activities tpl" => "الگوي ديده‌باني فعاليت‌هاي گالكسي",
"List of activities" => "فهرست فعاليت‌ها",
"Proc" => "فرايند",
"auto" => "مسيريابي",
"int" => "تعاملي",
"routing" => "خودمسيرياب",
"Instances" => "نمونه‌ها",
"run" => "اجرا",
"run activity" => "اجراي فعاليت",
"Enter the name of this instance" => "نام اين نمونه را وارد كنيد",
"The name is not valid. Please, enter the name again" => "نام معتبر نبود، لطفا مجددا سعي كنيد",
"Monitor" => "ديده‌باني",
"monitor processes" => "ديده‌باني فرايندها",
"monitor activities" => "ديده‌باني فعاليت‌ها",
"monitor instances" => "ديده‌باني نمونه‌ها",
"monitor workitems" => "ديده‌باني اقلام كاري",
"Galaxia Monitor Instances" => "ديده‌باني نمونه‌هاي گالگسي",
"Galaxia Monitor Instances tpl" => "ديده‌باني نمونه‌هاي گالگسي",
"List of instances" => "فهرست نمونه‌ها",
"Not ended" => "تمام نشده",
"No instances created yet" => "هيچ نمونه‌اي هنوز ايجاد نشده است.",
"Galaxia Monitor Processes" => "ديده‌باني فرايندهاي گالكسي",
"Galaxia Monitor Processes tpl" => "الگوي ديده‌باني فرايندهاي گالكسي",
"processes" => "فرايند",
"being run" => "آغاز شده",
"Completed" => "تكميل شده",
"Exceptions" => "استثنا",
"Monitor workitems" => "ديده‌باني اقلام كاري",
"List of workitems" => "فهرست اقلام كاري",
"instance" => "نمونه",
"Instance Id" => "شناسه‌ي نمونه",
"Instance Name" => "نام نمونه",
"Instance Status" => "وضعيت نمونه",
"Elapsed time" => "زمان صرف شده",
"My activities" => "فعاليت‌هاي من",
"Current Activity" => "فعاليت‌هاي جاري",
"Assigned To" => "منصوب به",
"exception instance" => "نمونه‌ي استثنا",
"exceptions instance" => "نمونه‌هاي استثنا",
"Send Instance" => "نمونه را ارسال كن",
"abort instance" => "نمونه را متوقف كن",
"grab instance" => "نمونه را بگير",
"release instance" => "نمونه را رها كن",
"No activities found" => "هيچ فعاليتي يافت نشد.",
"My instances" => "نمونه‌هاي من",
"No instances found" => "هيچ نمونه‌اي يافت نشد.",
"User Activities" => "فعاليت‌هاي كاربر",
"Galaxia User Activities" => "فعاليت‌هاي كاربر گالكسي",
"Galaxia User Activities tpl" => "الگوي فعاليت‌هاي كاربر گالكسي",
"process" => "فرايند",
"No processes defined or activated yet" => "هنوز هيچ فرايندي تعريف ويا فعال نشده است.",
"user processes" => "فرايندهاي كاربر",
"user activities" => "فعاليت‌هاي كاربر",
"user instances" => "نمونه‌هاي كاربر",
"Galaxia User Instances" => "نمونه‌ي كاربر Galaxia",
"Galaxia User Instances tpl" => "الگوي نمونه‌هاي كاربر گالكسي",
"Inst Status" => "وضعيت نمونه",
"Not defined" => "تعريف نشده",
"No instances defined yet" => "هنوز هيچ نمونه‌اي تعريف نشده است.",
"Galaxia User Processes" => "فرايندهاي كاربر گالكسي",
"Galaxia User Processes tpl" => "الگوي فرايندهاي كاربر گالكسي",
"Browsing Workitem" => "مرور اقلام كاري",
"Workitem information" => "اطلاعات اقلام كاري",
"galleries tpl" => "الگوي سرسراها",
"Create New Gallery" => "ايجاد سرسراي جديد",
"Create a gallery" => "ايجاد يك سرسراي جديد",
"Edit this gallery:" => "اين سرسرا را ويرايش كن",
"There are individual permissions set for this gallery" => "براي اين سرسرا، حقوق دسترسي فردي تعريف شده است",
"Geographic" => "جغرافيايي",
"Fields to show during browsing the gallery" => "هنگام مرور سرسرا، اين موارد را نشان بده",
"Image ID" => "شناسه‌ي تصوير",
"Creation Date" => "تاريخ ايجاد",
"XY-Size" => "اندازه‌ي طول و عرض(XY) ",
"Gallery Image" => "تصوير سرسرا",
"Available scales" => "مقياس‌هاي موجود",
"Bounding box" => "جعبه‌ي كران‌گزاري",
"default scale" => "ابعاد پيش‌فرض",
"No scales available" => "هيچ مقياسي موجود نيست",
"Original image is default scale" => "تصوير اصلي، مقياس پيش‌فرض است",
"Add scaled images with bounding box of square size" => "تصاوير مدرج را با كادري مربع به اين اندازه اضافه كن",
"Other users can upload images to this gallery" => "ساير كاربران مي‌توانند به اين سرسرا تصوير اضافه كنند",
"You can access the gallery using the following URL" => "شما مي‌توانيد با استفاده از اين URL به اين سرسرا دسترسي پيدا كنيد",
"Available Galleries" => "سرسراهاي(Galleries) موجود",
"Choose a filter" => "يك فيلتر انتخاب كنيد",
"Imgs" => "تصاوير",
"Make Map" => "ساخت نقشه",
"Im- Export languages" => "وارد/صادر كردن زبان‌ها",
"Select the language to Import" => "زبان را براي وارد كردن انتخاب كنيد",
"Select the language to Export" => "زبان را براي صادر كردن انتخاب كنيد",
"Import From File" => "پرونده را از اين وارد كن",
"Grab Wiki Tables" => "جداول ويكي را بگير",
"Import pages from a Structured Text Dump" => "صفحات را از يك متن Dumpشده‌ي ساختار يافته وارد كن",
"ImportingPagesPhpWikiPageAdmin" => "صفحه‌ي مديريت واردات صفحه‌ي ويكي PHP",
"tiki-import_phpwiki tpl" => "الگوي واردات PHP ويكي",
"Name of the dump file (it has to be in dump/)" => "نام پرونده‌ي dump (بايد به اين شكل باشد: dump/)",
"Overwrite existing pages if the name is the same" => "در صورتي كه صفحه‌اي با اين نام وجود دارد، روي آن بنويس",
"Previously remove existing page versions" => "نسخ قبلي اين صفحه",
"excerpt" => "گلچين كردن",
"Result" => "نتيجه",
"body" => "بدنه",
"Install" => "نصب",
"Failed" => "رد",
"Clear cached version and refresh cache" => "نسخه‌ي Cacheشده را خالي كن و Cache را تازه كن ",
"configure rules" => "پيكربندي قوانين",
"Edit Repository" => "مخزن را ويرايش كن",
"Search by Date" => "جستجو بر اساس تاريخ",
"LastChanges" => "آخرين تغييرات",
"hist" => "تاريخچه",
"v" => "نما",
"Rollback" => "عقب‌گرد",
"Pages like" => "صفحات مشابه",
"No pages found" => "صفحه‌اي پيدا نشد.",
"List Articles Tpl" => "الگوي فهرست مقالات",
"Edit New Article" => "ويرايش مقاله‌ي جديد",
"ExpireDate" => "تاريخ انقضا",
"AuthorName" => "نام مولف",
"Create banner" => "ساخت درفش",
"Method" => "اسلوب",
"Use Dates?" => "از تاريخ استفاده شود؟",
"Max Impressions" => "بيشينه تعداد نمايش",
"Impressions" => "تعداد نمايش",
"Clicks" => "كليك",
"Create New Blog" => "يك بلاگ جديد ايجاد كن",
"Admin Cache" => "مديريت Cache",
"Admin Cache tpl" => "الگوي مديريت Cashe",
"Dynamic content system" => "سامانه‌ي محتوي پويا",
"Available content blocks" => "بلوك‌هاي محتوي موجود",
"Current ver" => "نسخه‌ي جاري",
"Next ver" => "نسخه‌ي بعدي",
"Future vers" => "نسخ آينده",
"Program" => "برنامه",
"List FAQs Tpl" => "الگوي فهرست سئوالات متداول",
"Edit this FAQ:" => "ويرايش اين FAQ",
"Create new FAQ" => "ساخت FAQ جديد",
"Create New FAQ:" => "ساخت FAQ جديد:",
"Users can suggest questions" => "كاربران مي‌توانند سئوال پيشنهاد دهند؟",
"Available FAQs" => "FAQهاي موجود",
"Create a file gallery" => "ايجاد يك سرسراي پرونده",
"optional" => "اختياري",
"Gallery Images" => "تصاوير سرسرا",
"games tpl" => "الگوي بازي‌ها",
"All games are from" => "تمام بازي‌ها از اين پايگاه هستند:",
"visit the site for more games and fun" => "براي ساير بازي‌ها و سرگرمي‌ها، نگاهي به اون پايگاه بندازيد.",
"Upload a game" => "يك بازي بارگذاري كنيد",
"Upload a new game" => "بارگذاري يك بازي جديد",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "تصويرك (اگر بازي foo.swf باشد، نام تصويرك بايد foo.swf.gif يا foo.swf.png يا foo.swf.jpg شود)",
"Edit game" => "ويرايش بازي",
"Played" => "بازي شده",
"times" => "بار",
"If you can't see the game then you need a flash plugin for your browser" => "اگر نمي‌توانيد بازي را ببينيد، به plugin مربوط به flash براي مرورگر خود نياز داريد",
"List Posts Tpl" => "الگوي فهرست الصاق‌ها",
"Blog Title" => "عنوان بلاگ",
"List Quizzes Tpl" => "الگوي فهرست آزمون‌ها",
"Edit New Submission" => "ويرايش ارائه‌ي جديد",
"Edit Quiz Stats Tpl" => "ويرايش الگوي آمار آزمون",
"Survey stats" => "آمار نظرسنجي‌ها",
"Take Survey" => "به اجرا گذاشتن",
"List Trackers Tpl" => "الگوي فهرست trackerها",
"users registered" => "كاربر ثبت‌نام كرده است",
"Distance (km)" => "فاصله (به كيلومتر)",
"List Movies" => "فهرست فيلم‌ها",
"Choose a movie" => "يك فيلم انتخاب كن",
"Last mod" => "آخرين تغيير",
"Last author" => "آخرين مؤلف",
"unlocked" => "قفل نشده",
"Admin Live Support tpl" => "الگوي مديريت پشتيباني زنده",
"Open client window" => "پنجره‌ي كاربر را بازكن",
"Generate HTML" => "HTML توليد كن",
"Transcripts" => "رونوشت‌ها",
"Support tickets" => "بليط‌هاي پشتيباني",
"Online operators" => "پشتيبانان روي خط",
"Operator" => "پشتيبان",
"Accepted requests" => "درخواست‌هاي پذيرفته شده",
"transcripts" => "روشت‌ها",
"offline" => "خارج خط",
"Offline operators" => "پشتيبانان خارج از خط",
"Add an operator to the system" => "افزودن يك پشتيبان به سامانه",
"Operators must be tiki users" => "پشتيبان بايد كاربر تيكي باشد.",
"Set as Operator" => "به عنوان پشتيبان قرارش بده",
"Chat started" => "گفتگو آغاز شد",
"Operator:" => "پشتيبان",
"Live support:User window" => "پشتيباني زنده: پنجره‌ي كاربر",
"Request live support" => "درخواست پشتيباني زنده",
"Request support" => "درخواست پشتيباني",
"Open a support ticket instead" => "به‌جاي اين يك بليط پشتيباني بازكن",
"Your request is being processed" => "درخواست شما درحال جريان است",
"cancel request and exit" => "درخواست را لغو كن و خارج شو",
"cancel request and leave a message" => "درخواست را لغو كن و يك پيغام بگذار",
"Live support:Console" => "پشتيباني زنده: ميزكار",
"be online" => "وارد مدار شو",
"be offline" => "از مدار خارج شو",
"Support requests" => "درخواست پشتيباني",
"Requested" => "درخواست شده",
"Join" => "بپيوند",
"Support chat transcripts" => "رونوشت گفتگوي پشتيباني",
"back to admin" => "بازگشت به مديريت",
"operator" => "پشتيبان",
"started" => "تاريخ شروع",
"reason" => "دليل",
"msgs" => "پيغام‌ها",
"Transcript" => "رونوشت",
"Mail-in feature" => "خصيصه‌ي 'كنترل با پست الكترونيكي'",
"User Calendar" => "تقويم كاربر",
"User Calendar Doc tpl" => "الگوي مستندات تقويم جيبي",
"Prefs" => "تنظيمات",
"Remove old events" => "رويدادهاي قديمي را حذف كن",
"duration" => "مدت زمان",
"Mini Calendar: Preferences" => "تقويم جيبي: تنظيمات",
"User Calendar Doc" => "مستندات تقويم جيبي",
"User Calendar Preferences Doc tpl" => "از الگوي مستندات تنظيمات تقويم جيبي استفاده كن",
"Calendar Interval in daily view" => "بازه تقويم در نماي روزانه",
"Start hour for days" => "ساعت شروع براي روزها",
"End hour for days" => "ساعت پايان براي روزها",
"Reminders" => "يادآورها",
"no reminders" => "بدون يادآوري",
"Or enter path or URL" => "يا مسير يا URL را وارد كنيد",
"Add Topic" => "افزودن موضوع",
"Tikiwiki Mods" => "حالات تيكي‌ويكي",
"Mods Configuration" => "پيكربندي حالت",
"Update remote index" => "به‌روز رساني راهنماي از راه دور(remote index)",
"Rebuild local list" => "ساخت مجدد فهرست محلي(local)",
"Republish all" => "همه را مجددا منتشر كن",
"Publish all" => "همه را منتشر كن",
"Unpublish all" => "پس‌گرفتن تمام انتشارها",
"Attention" => "توجه",
"all types" => "تمام موارد",
"Display only this type" => "فقط اين نوع را نمايش بده",
"Unpublish" => "پس گرفتن انتشار",
"Republish" => "انتشار مجدد",
"Tikiwiki Mods Configuration" => "پيكربندي حالات تيكي‌ويكي",
"Mods Install/uninstall" => "حذف/نصب حالات",
"Enable Mods providing" => "فراهم كردن حالات، فعال باشد",
"Mods local directory" => "پوشه‌ي محلي حالات",
"Mods remote server" => "سرور راه‌دور حالات",
"Package Config" => "پيكربندي بسته‌بندي",
"my tiki tpl" => "الگوي تيكي من",
"User Pages" => "صفخات كاربران",
"y" => "بله",
"User Galleries" => "سرسراهاي كاربر",
"Assigned items" => "اقلام تخصيص داده شده",
"Unread Messages" => "پيغام‌هاي خوانده نشده",
"User Blogs" => "بلاگ‌هاي كاربر",
"MyFiles" => "پرونده‌هاي من",
"Subscribe" => "عضويت",
"Errors:" => "خطاها:",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "از عضويت شما متشكريم. به‌زودي يك پيغام الكترونيكي دريافت خواهيد كرد تا از طريق آن عضويت خود را تاييد كنيد. قبل از تاييد هيچ خبرنامه‌اي براي شما ارسال نخواهد شد.",
"Your email address was removed from the list of subscriptors." => "آدرس پست الكترونيكي شما از فهرست اعضا حذف شد",
"Subscription confirmed!" => "عضصويت تاييد شد",
"Subscribe to Newsletter" => "عضويت در خبرنامه",
"Subscribe to This Newsletter" => "عضويت",
"Available Newsletters" => "خبرنامه‌هاي موجود",
"Select news group" => "انتخاب گروه خبري",
"Back to servers" => "بازگشت به سرورها",
"Msgs" => "پيغام‌ها",
"News from" => "اخبار از",
"Back to groups" => "بازگشت به گروه‌ها",
"Save position" => "موقعيت را ذخيره كن",
"Reading article from" => "خوانده مقاله از",
"Back to list of articles" => "بازگشت به فهرست مقالات",
"First" => "اولين",
"Newsgroup" => "خبرنامه",
"Configure news servers" => "پيكربندي سرورهاي اخبار",
"Configure Newsreader" => "پيكربندي اخبارگو",
"configure newsreader server tpl" => "الگوي پيكربندي سرور اخبارگو",
"Select a news server to browse" => "يك سرور اخبار گو براي مرور انتخاب كنيد",
"server" => "سرور",
"Read the news" => "مشاهده‌ي اخبار",
"News server" => "سرور اخبار",
"Notes" => "يادداشت‌ها",
"Write a note" => "يك يادداشت بنويس",
"quota" => "سهميه",
"No notes yet" => "هنوز هيچ پيغامي وجود ندارد.",
"Merge selected notes into" => "يادداشت‌هاي انتخابي را ادغام كن و بريز داخل",
"Reading note:" => "خواندن يادداشت:",
"List notes" => "آخرين يادداشت‌ها",
"Write note" => "نوشتن يادداشت",
"Wiki Create" => "ساخت ويكي",
"Wiki Overwrite" => "نوشتن ويكي(جايگزيني روي قبلي‌ها)",
"Assign permissions to " => "تخصيص حقوق دسترسي به ",
"Back" => "بازگشت",
"Current permissions for this object" => "حقوق دسترسي كنوني براي اين شيئ",
"No category permissions; global permissions apply" => "بدون حقوق دسترسي طبقه‌اي، حقوق دسترسي عمومي اعمال خواهد شد",
"Assign permissions to this object" => " تخصيص حقوق دسترسي به اين شيئ",
"Published" => "تاريخ انتشار",
"Orphan Pages" => "صفحات يتيم",
"Browser not supported" => "مرورگر وب شما پشتيباني نمي‌شود(نمي‌توانيد با اين مرورگر از گپ‌زني‌ها استفاده كنيد)",
"s=source" => "s=منبع",
"b=rollback" => "b=برگشت تغييرات",
"Side-by-side diff" => "اختلافات پهلو به پهلو",
"Pick your avatar" => "شكلك خود را انتخاب كنيد",
"User Preferences" => "تنظيمات كاربر",
"Your current avatar" => "شكلك كنوني شما",
"no avatar" => "بدون شكلك",
"reset" => "بازنشاني",
"Pick avatar from the library" => "شكلك خود را از بين كتابخانه انتخاب كنيد",
"Pick user Avatar" => "انتخاب شكلك كاربر",
"Hide all" => "همه را پنهان كن",
"icons" => "تمثال‌ها",
"Show all" => "نمايش همه",
"Avatar Image" => "تصوير شكلك",
"Upload your own avatar" => "شكلك خود را بارگذاري كنيد",
"atts" => "خصوصيات",
"List Attachments" => "آخرين ضمايم",
"View Results" => "مشاهده‌ي نتايج",
"Vote poll" => "راي دادن",
"Other Polls" => "ساير راي‌گيري‌ها",
"Note: Remember that this is only a preview, and has not yet been saved!" => "نكته: به‌خاطر داشته‌باشيد كه اين تنها يك پيش‌نمايش است و وظيفه دخيره نشده است",
"Print multiple pages" => "چاپ چندين صفحه",
"Edit quiz" => "ويرايش آزمون",
"General Options" => "اختيارات عمومي",
"Name:" => "نام:",
"Publication Date" => "تاريخ انتشار",
"at " => "در ",
"Use " => "بهره‌گيري ",
"randomly selected questions." => "سئوالات انتخاب شده به‌صورت تصادفي",
"Test-time Options" => "اختيارات زماني",
"Limit questions displayed per page to " => "سئوالاتي كه در هر صفحه نمايش داده مي‌شوند را محدود كن به",
"&nbsp question(s)." => "سئوال(هاي) &nbsp",
"Impose a time limit of " => "تحميل محدوديت زماني  ",
"Allow students to store partial results and return to quiz." => "به دانش‌آموزيين اجازه بده نتايج را نيمه‌كاره نگه‌داريند و با آزمون برگردند.",
"Allow students to retake this quiz " => "به دانش‌آموزيين اجازه‌ي شركت مجدد در اين آزمون را بده ",
"Grading and Feedback" => "درجه‌بندي و بازخورد",
"Grading method " => "اسلوب درجه‌بندي ",
"Show students their score " => "به دانش‌آموزيين امتيازاتشان را نشان بده ",
"Show students the correct answers " => "به دانش‌آموزيين پاسخ‌هاي صحيح را نشان بده ",
"Publish statistics " => "انتشار آمار ",
"Extra Options" => "اختيارات اضافي ",
"Solicit additional questions from students" => "درخواست سئوالات اضافي از طرف دانش‌آموزيين",
"Link quiz to forum named: " => "آزمون را به اين انجمن پيوند بده: ",
"Prologue:" => "افتتاحيه",
"Epilogue:" => "اختتاميه:",
"Quiz result stats" => "آمار نتايج آزمون",
"Quiz" => "آزمون",
"Time" => "زمان",
"User answers" => "پاسخ‌هاي كاربران",
"Stats for quizzes" => "وضعيت آزمون‌ها",
"taken" => "گرفته شده؟",
"Av score" => "متوسط امتياز",
"Av time" => "زمان متوسط",
"Stats for quiz" => "آمار آزمون",
"Clear Stats" => "آمار را پاك كن",
"time taken" => "زمان گرفته شده",
"Passed" => "قبول",
"Stats for this quiz Questions " => "آمار براي اين سئوالات آزمون ",
"Average" => "معدل",
"Top 10" => "10 تاي برتر",
"Top 20" => "20 تاي برتر ",
"Top 50" => "50 تاي برتر ",
"Top 100" => "100 تاي برتر ",
"Received Articles" => "مقالات دريافت شده",
"received articles tpl" => "الگوي مقالات دريافت شده",
"Edit received article" => "ويرايش مقالات دريافت شده",
"Use Image" => "از تصوير استفاده كن",
"Image x size" => "اندازه‌ي طول تصوير",
"Image y size" => "اندازه‌ي عرض تصوير",
"Image name" => "نام تصوير",
"Accept Article" => "تاييد مقاله",
"Site" => "پايگاه",
"received pages tpl" => "الگوي صفحات دريافت شده",
"A valid email is mandatory to register" => "براي ثبت‌نام، يك پست الكترونيكي معتبر ضروري است",
"Tiki site registered" => "پايگاه تيكي ثبت شد",
"The following site was added and validation by admin may be needed before appearing on the lists" => "اين پايگاه اضافه شده است و تاييد اعتبار به‌وسيله‌ي سرپرست قبل از نمايش در فهرست لازم است",
"You don't have permission to use this feature." => "متاسفانه شما حقوق دسترسي كافي براي استفاده از اين خصيصه را نداريد",
"Please register." => "لطفا ثبت‌نام كنيد.",
"Register this site at tikiwiki.org" => "اين پايگاه رو در tikiwiki.org ثبت كن",
"Read this first!" => "ابتدا اين را بخوانيد!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "در اين صفحه مي‌توانيد پايگاه خود را به tikiwiki.org بشناسانيد. پايگاه شما در فهرست پايگاه‌هاي شناخته شده‌ي تيكي در tikiwiki.org ثبت خواهد شد.",
"Registering is voluntary." => "ثبت‌نام اختياري است",
"Registering does not give you any benefits except one more link to your site." => "ثبت‌نام سود خاصي عايد شما نمي‌كند، جز اين‌كه يك پيود اضافه به پايگاه شما ايجاد مي‌شود.",
"You don't get any emails, we don't sell the data about your site." => "شما هيچ پست الكترونيكي دريافت نخواهيد كرد، ما اطلاعات پايگاه شما را نخواهيم فروخت!",
"Registering is just for us to get an overview of Tiki's usage." => "ثبت‌نام فقط براي ماست، براي اين‌كه يك چشم‌اندازي از استفاده‌هاي تيكي داشته باشيم",
"If your site is private or inside your intranet, you should not register!" => "اگز پايگاه شما خصوصي است، يا داخل اينترانت قرار گرفته است، نبايد ثبتش كنيد!",
"Information about your site" => " اطلاعاتي درخصوص پايگاه شما",
"Send me my Password" => "براي من كلمه‌ي عبورم را ارسال كن",
"Return to HomePage" => "بازگشت به صفحه‌ي مبدا",
"Remove page" => "صفحه را حذف كن",
"Last Version" => "آخرين نسخه",
"You are about to remove the page" => "شما درحال حذف صفحه هستيد",
"permanently" => "كاملا",
"Remove all versions of this page" => "تمام نسخ اين صفحه را حذف كن",
"Rename page" => "تغيير نام",
"Replicate" => "تكرار",
"Slave" => "برده",
"Master" => "ارباب",
"Operations" => "اعمال",
"Operations Log" => "وقايع ثبت‌شده‌ي اعمال",
"Rollback page" => "صفحه را به حالت قبل برگردان",
"to_version" => "به نسخه‌ي",
"Search Stats" => "آمار جستجو",
"search stats tpl" => "الگوي آمار جستجو",
"Searched" => "جستجو شد",
"Search in" => "جستجو در",
"Simple search" => "جستجوي ساده",
"No pages matched the search criteria" => "هيچ صفحه‌اي كه شرايط جستجو را داشته باشد، يافت نشد",
"Send blog post" => "الصاق بلاگ را بفرست",
"A link to this post was sent to the following addresses:" => "يك پيوند به اين الصاق براي آدرس‌هاي ذيل ارسال شد:",
"Send post to this addresses" => "الصاق را به اين آدرس‌ها بفرست",
"List of email addresses separated by commas" => "فهرست آدرس‌هاي پست الكترونيكي، تفكيك شده با ويرگول",
"referenced by" => "مرجوع شده از",
"references" => "ارجاعات",
"Apply content template" => "اين الگوي محتوا را به خبرنامه اعمال كن",
"Send objects" => "ارسال اشياء",
"Admin Send Objects tpl" => "الگوي مديريت ارسال اشياء",
"Transmission results" => "نتايج مخابره‌ها",
"Send Wiki Pages" => "صفحات ويكي را بفرست",
"Send Articles" => "مقالات را بفرست",
"Add Article" => "مقاله را اضافه كن",
"Send objects to this site" => "اشياء را به اين پايگاه بفرست",
"sheets tpl" => "الگوي اوراق",
"Create a sheet" => "ساخت يك ورق",
"Edit this sheet:" => "ويرايش اين ورق:",
"Create New Sheet" => "ساخت ورق جديد",
"There are individual permissions set for this sheet" => "براي اين ورق حقوق دسترسي فردي تعريف شده است",
"Class Name" => "نام كلاس",
"Header Rows" => "ستون‌هاي سرصفحه",
"Footer Rows" => "ستون‌هاي پاصفحه",
"Create new Sheet" => "ساخت ورق جديد",
"You can access the sheet using the following URL" => "با استفاده از YRL روبرو مي‌توانيد به اين ورق دسترسي پيدا كنيد",
"Available Sheets" => "اوراق موجود",
"Tiki Shoutbox" => "فريادگاه تيكي",
"Change shoutbox general settings" => "تغيير تنظيمات عمومي فريادگاه",
"auto-link urls" => "URLهاي پيوند خودكار(Autolink)",
"Post or edit a message" => "الصاق يا ويرايش پيغام",
"Click to Navigate" => "براي هدايت اين‌جا را كليك كنيد",
"big grin" => "شاد",
"confused" => "گيج",
"cool" => "آرام",
"cry" => "گريه",
"eek" => "زكي",
"evil" => "شيطون",
"lol" => "قهقهه",
"mr green" => "آقاي سبز",
"razz" => "شوخ",
"redface" => "صورت صورتي",
"rolleyes" => "با چشماي چرخون",
"smile" => "لبخند",
"surprised" => "متعجب",
"twisted" => "پيچونده شده",
"arrow" => "فلش",
"santa" => "سانتا",
"Most viewed objects" => "پربيننده‌ترين اشياء",
"Most viewed objects in the last 7 days" => "پربيننده‌ترين اشياء در هفته‌ي گذشته",
"Site Stats" => "آمار پايگاه",
"Days online" => "برپا (روز)",
"Total pageviews" => "تعداد كل بازديدها",
"Average pageviews per day" => "متوسط بازديد در روز",
"pvs" => "قبلي",
"Best day" => "بهترين روز",
"Worst day" => "بدترين روز",
"Wiki Stats" => "آمار ويكي",
"Size of Wiki Pages" => "حجم صفحات ويكي",
"Mb" => "مگابايت",
"Average page length" => "متوسط طول صفحه",
"Average versions per page" => "متوسط نسخه در هر صفحه",
"Visits to wiki pages" => "بازديد از صفحات ويكي",
"Average links per page" => "متوسط پيوندها در هر صفحه",
"Image galleries Stats" => "آمار سرسراهاي تصاوير",
"Average images per gallery" => "متوسط تعداد تصوير در هر سرسرا",
"Total size of images" => "مجموع حجم تصاوير",
"Average image size" => "متوسط حجم تصاوير",
"Visits to image galleries" => "بازديد از سرسراهاي تصاوير",
"File galleries Stats" => "آمار سرسراهاي پرونده‌ها",
"Average files per gallery" => "متوسط تعداد پرونده در هر سرسرا",
"Total size of files" => "مجموع حجم پرونده‌ها",
"Average file size" => "متوسط حجم پرونده‌ها",
"Visits to file galleries" => "بازديد از سرسراهاي پرونده‌ها",
"CMS Stats" => "آمار سامانه‌ي مديريت محتوي",
"Total reads" => "مجموع قرائت‌ها",
"Average reads per article" => "متوسط قرائت هر مقاله",
"Total articles size" => "مجموع حجم مقالات",
"Average article size" => "متوسط حجم مقالات",
"Forum Stats" => "آمار انجمن‌ها",
"Total topics" => "مجموع موضوعات",
"Average topics per forums" => "متوسط تعداد موضوع در هر انجمن",
"Visits to forums" => "تعداد بازديد ار انجمن‌ها",
"Blog Stats" => "آمار بلاگ‌ها",
"Weblogs" => "وبلاگ‌ها‌",
"Total posts" => "مجموع الصاق‌ها",
"Average posts per weblog" => "متوسط الصاق در هر بلاگ‌",
"Total size of blog posts" => "حجم مجموع الصاق‌هاي بلاگ",
"Average posts size" => "متوسط حجم الصاق‌ها‌",
"Visits to weblogs" => "بازديد از وبلاگ‌ها",
"Poll Stats" => "آمار راي گيري‌ها",
"Total votes" => "مجموع راي‌ها",
"Average votes per poll" => "متوسط تعداد راي در هر راي‌گيري",
"Total questions" => "مجموع سئوالات",
"Average questions per FAQ" => "متوسط تعداد سئوال در هر بخش",
"User Stats" => "آمار كاربران",
"User bookmarks" => "صفحه‌ياب(bookmark)هاي كاربران",
"Average bookmarks per user" => "متوسط تعداد صفحه‌ياب براي هر كاربر",
"Average questions per quiz" => "متوسط تعداد سئوال در هر آزمون",
"Quizzes taken" => "مجموع آزمون‌ها",
"Average quiz score" => "متوسط امتياز آزمون‌ها",
"Average time per quiz" => "متوسط زمان هر آزمون",
"Usage chart" => "نمودار استفاده",
"Usage chart image" => "تصوير نمودار استفاده",
"Daily Usage" => "استفاده روزانه",
"Stats for surveys" => "آمار نظرسنجي‌ها",
"Last taken" => "آخرين اجرا",
"Stats for survey" => "آمار نظرسنجي",
"Stats for this survey Questions " => "آمار اين نظرسنجي",
"SysLog" => "ثبت وقايع",
"system logs" => "ثبت‌وقايع سامانه",
"system logs tpl" => "الگوي ثبت‌وقايع سامانه",
"Time Left" => "زمان باقي مانده",
"Send Answers" => "پاسخ‌ها را ارسال كن",
"Thank you for your submission" => "از ارائه‌ي شما متشكريم",
"Your email was sent" => "پست الكترونيكي شما ارسال شد",
"Theme Control Center: categories" => "مركز كنترل قيافه‌ها: طبقات",
"ThemeControl" => "كنترل قيافه",
"ThemeControl tpl" => "الگوي كنترل قيافه",
"Theme is selected as follows" => "قيافه‌ها بدين ترتيب انتخاب مي‌شوند",
"If a theme is assigned to the individual object that theme is used." => "اگر قيافه‌اي به يك شيء منفرد تخصيص داده شده باشد، آن قيفه انتخاب مي‌شود.",
"If not then if a theme is assigned to the object's category that theme is used" => "وگرنه درصورتي كه يك قيافه به طبقه‌اي از اشياء تخصيص داده شده باشد، آن قيفه انتخاب مي‌شود.",
"If not then a theme for the section is used" => "وگرنه، درصورتي كه قيافه‌اي به يك بخش تخصيص داده شده باشد، آن قيفه انتخاب مي‌شود. ",
"If none of the above was selected the user theme is used" => "درصورتي كه هيچ‌كدام از موارد فوق نباشد، قيافه‌ي منتخب كاربر انتخاب مي‌شود.",
"Finally if the user didn't select a theme the default theme is used" => "و در پايان، اگر كاربر نيز قيافه‌اي انتخاب نكرده باشد، قيافه‌ي پيش‌فرض انتخاب مي‌شود.",
"Control by Objects" => "كنترل با اشياء",
"Control by Sections" => "كنترل با بخش‌ها",
"Assign themes to categories" => "تخصيص قيافه به طبقات",
"Assigned categories" => "طبقات تحصيص‌يافته",
"theme" => "قيافه",
"Theme Control Center: Objects" => "مركز كنترل قيافه‌ها: اشياء",
"ThemeControl Objects" => "اشياء كنترل قيافه",
"theme control objects tpl" => "الگوي اشياء كنترل قيافه‌ها",
"Control by Categories" => "كنترل با طبقات",
"Assign themes to objects" => "تخصيص قيافه به اشياءظ",
"Assigned objects" => "اشياء تخصيص يافته",
"Theme Control Center: sections" => "مركز كنترل قيافه: بخش‌ها",
"theme control sections tpl" => "الگوي مركز قيافه‌ي بخش‌ها",
"Assign themes to sections" => "تخصيص قيافه‌ها به بخش‌ها",
"Assigned sections" => "بخش‌هاي تحصيص داده شده",
"The following file was successfully uploaded" => "پرونده‌ي مذكور با موفقيت بارگذاري شد",
"You can download this file using" => "بدين‌وسيله مي‌توانيد اين پرونده را بارگذاري كنيد",
"File Title" => "عنوان پرونده",
"Batch upload" => " بارگذاري دسته‌اي(Batch upload)",
"You have to create a gallery first!" => "شما بايد ابتدا يك سرسرا ايجاد كنيد",
"Image Gallery tpl" => "الگوي سرسراي تصوير",
"Upload successful!" => "بارگذاري موفقيت آميز بود!",
"The following image was successfully uploaded" => "تصوير مذكر با موفقيت بارگذاري شد",
"Thumbnail" => "تصويرك",
"Image ID thumb" => "تصويرك شناسه‌ي تصوير",
"You can include the image in an Wiki page using" => "بدين وسيله مي‌توانيد تصويري را دريك صفحه‌ي ويكي بگنجانيد",
"or use filename" => "يا از نام اصلي پرونده استفاده كن",
"Now enter the image URL" => "يك URL تصوير وارد كنيد",
" or upload a local image from your disk" => " يا از دستگاه خود يك تصوير بارگذاري كنيد",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "تصويرك (اختياري، جايگزين ساخت خودكار تصويرك مي‌شود)",
"User assigned modules" => "ماژول‌هاي تخصيص يافته‌ي كاربر",
"User Assigned Modules" => "ماژول‌هاي تخصيص يافته‌ي كاربر",
"User Assigned Modules tpl" => "الگوي ماژول‌هاي تخصيص يافته‌ي كاربر",
"Assign module" => "تخصيص ماژول",
"Column" => "ستنون",
"User Bookmarks tpl" => "الگوي صفحه‌ياب‌هاي كاربر",
"top" => "گره بالايي",
"Current folder" => "پوشه‌ي جاري",
"Folders" => "پوشه‌ها",
"Folder in" => "پوشه در",
"Remove Folder" => "پوشه را حذف كنت",
"Refresh Cache" => "بازيابي cache",
"Admin folders and bookmarks" => "مديريت پوشه‌ها و صفحه‌ياب‌ها",
"Send me a message" => "يك پيغام براي من بفرست",
"Gender" => "جنس",
"Homepage" => "صفحه‌ي مبدا",
"Users HomePage" => "صفحه‌ي مبدا كاربران",
"Personal Wiki Page" => "صفحه‌ي شخصي ويكي‌",
"Create page" => "صفحه‌ي را بساز",
"This user is your friend" => "اين كاربر رفيق شماست",
"Request friendship from this user" => "درخواست رفاقت با اين كاربر",
"UserPreferences tpl" => "الگوي تنظيمات كاربر",
"Personal Information" => "اطلاعات شخصي",
"Use Google Map locator" => "از نقشه‌ياب گوگل استفاده كن",
"Your personal Wiki Page" => "صفحه‌ي شخصي ويكي شما",
"Your personal tracker information" => "اطلاعات tracker شخصي شما",
"View extra information" => "مشاهده‌ي اطلاعات اضافي",
"Is email public? (uses scrambling to prevent spam)" => "آيا پست الكترونيكي عمومي است؟(باعث دريافت Spam مي‌شود‌",
"Unavailable - please set your e-mail below" => "در دسترس نيست – لطفا آدرس پست الكترونيك خود را در زير ثبت كنيد",
"Account Information" => "اطلاعات حساب",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "'كلمه‌ي عبور' و 'تاييد كلمه‌ي عبور' را خالي بگذاريد تا كلمه‌ي عبور كنوني باقي بماند",
"Email address" => "آدرس پست الكترونيكي",
"Confirm new password" => "كلمه‌ي عبور جديد رو تاييد كنيد",
"Current password (required)" => "كلمه‌ي عبور كنوني(ضروري)",
"Change administrative info" => "تغيير اطلاعات سرپرستي",
"User Tasks tpl" => "الگوي وظايف كاربر",
"New task" => "وظيفه‌ي جديد",
"Task list" => "فهرست وظايف",
"Admin mode off" => "حالت عادي",
"Admin mode on" => "حالت سرپرستي",
"Task help" => "كمك در وظايف",
"Empty Trash" => "تخليه‌ي خاكرويه",
"Received task" => "وظايف دريافت شده",
"You received this task, please read and execute it" => "شما اين وظيفه را دريافت كرده‌ايد، لطفا آن را مطالعه كرده و اجرا فرماييد",
"Send task" => "ارسال وظيفه",
"You send this task to a other user" => "شما اين وظيفه را به يك كاربر ديگر ارسال مي‌كند",
"Shared task" => "وظايف مشترك",
"This task is public to a special group" => "اين وظيفه براي يك گروه خاص عمومي است",
"Accepted by Task User and Creator" => "پذيرفته شده از طرف كاربر وظيفه و ايجاد كننده",
"Task is accepted by user and creator" => "اين وظيفه از طرف كاربر موظف و ايجاد كننده پذيرفته شده است",
"Not Accepted by One User" => "از طرف يك كاربر پذيرفته شده است",
"Task is rejected by one user" => "وظيفه از طرف يك كاربر رد شده است",
"Waiting for Me" => "منتظر من هستند",
"Task is not accepted by you, read the task and accept or reject it" => "اين وظيفه از طرف شما پذيرفته نشده است، لطفا آن را مطالعه كرده، سپس رد يا قبولش كنيد",
"Waiting for Other User" => "منتظر ساير كاربران",
"Task is not accepted/rejected by other user" => "وظيفه از طرف كاربر قبول يا رد نشده است",
"Admin Mode" => "حالت سرپرستي",
"Edit task" => "ويرايش وظيفه",
"NOT accept" => "قبول نشد",
"Remove from Trash" => "از خاكروبه هم حذفش كن",
"Move into Trash" => "انتقال به خاكروبه",
"Task saved" => "وظيفه ذخيره شد",
"Edit Task" => "ويرايش وظيفه",
"View Task" => "مشاهده‌ي وظيفه",
"Open a new task" => "گشايش يك وظيفه‌ي جديد",
"taskId" => "شناسه‌ي وظيفه",
"Task user" => "كاربر موظف",
"Only the creator can delete this task" => "تنها ايجاد كننده مي‌تواند اين وظيفه را حذف كند",
"Use start date and time" => "از تاريخ و ساعت شروع استفاده كن",
"Use end date and time" => "از تاريخ و ساعت پايان استفاده كن",
"Open / In Process" => "بازكردن / در فرايند",
"Waiting / Not Started" => "درحال انتظار/هنوز آغاز نشده است",
"Percentage completed" => "درصد پيشرفت",
"Waiting" => "انتظار",
"Shared for Group" => "مشترك براي گروه",
"Accepted by User" => "پذيرفته شده از طرف كاربر",
"No / Rejected" => "خير / رد شده",
"Accepted by Creator" => "پذيرفته شده از طرف ايجاد كننده",
"This message will be send to users if you are makeing changes of assigned tasks" => "درصورتي كه تغييراتي در وظايف اختصاص داده‌شده دهيد، اين پيغام براي كاربران ارسال خواهد شده",
"Send message with changes" => "پيغام را با تغييرات ارسال كن",
"Modified by" => "تغيير كرده به‌وسيله‌ي",
"Inform task user by email" => "كاربر موظف را با پست الكترونيكي آگاه كن",
"You can only view this task" => "شما تنها اين وظيفه را مي‌توانيد ببينيد",
"No tasks entered" => "هيچ وظيفه‌اي وارد نشده است.",
"Select One" => "يكي را انتخاب كنيد",
"Undo Trash" => "بازگشت از خاكروبه",
"Show:" => "نمايش بده:",
"Received" => "دريافت شده‌ها",
"Submitted" => "ارائه شده",
"Shared" => "مشترك",
"All Shared Tasks" => "تمام وظايف مشترك",
"completed (100%)" => "تماما (100%) تكميل شد",
"User Watches tpl" => "الگوي ديده‌بان‌هاي كاربر",
"Add Watch" => "افزودن ديده‌بان",
"May need to refresh twice to see changes" => "ممكن است براي ديدن تغييرات، احتياج به دو بار بازيابي باشد",
"Add top level bookmarks to menu" => "صفحه‌ياب‌هاي برتر را به منو اضافه كن",
"Pos" => "رديف",
"Mode" => "حالت",
"replace window" => "جايگزيني پنجره",
"User_versions_for" => "نسخ كاربر براي",
"Insert Row" => "درج سطر",
"Insert Column" => "درج ستون",
"Remove Row" => "حذف سطر",
"Remove Column" => "حذف ستون",
"Merge Cells" => "ادغام ستون",
"Restore Cells" => "بازيابي سلول‌ها",
"Copy Calculation" => "محاسبات را كپي كن",
"Format Cell" => "شكل‌دهي سلول",
"Before" => "قبل از",
"After" => "بعداز",
"expires:" => "منقضي در:",
"Banner stats" => "آمار درفش‌ها",
"Create new banner" => "ساخت درفش جديد",
"Banner Information" => "اطلاعات درفش",
"Click ratio" => "نرخ كليك كردن",
"Weekdays" => "روزهاي هفته",
"mon" => "دو شنبه",
"tue" => "سه شنبه",
"wed" => "چهار شنبه",
"thu" => "پنج شنبه",
"fri" => "جمعه",
"sat" => "شنبه",
"sun" => "يك شنبه",
"Banner raw data" => "داده‌ي خام درفش",
"This is a cached version of the page." => "اين يك نسخه‌ي cache شده از اين صفحه است.",
"Click here to view the Google cache of the page instead." => "اين‌جا را كليك كنيد تا cach گوگل را با جاي آن ببينيد.",
"Edit Items" => "ويرايش اقلام",
"List Charts" => "فهرست نمودارها",
"Last Chart" => "آخرين نمودار",
"Previous Chart" => "نمودار قبلي",
"Chart created" => "نموادار ايجاد شد",
"Next Chart" => "نمودار بعدي",
"Pre" => "قبلي",
"Permanency" => "قطعيت",
"chg" => "تغييرات",
"Avg" => "معدل",
"info/vote" => "مشاهده‌ي اطلاعات/دادن راي",
"Next chart will be generated on" => "نمودار بعدي در اين تاريخ توليد خواهد شد",
"View or vote items not listed in the chart" => "مشاهده يا انتخاب اقلامي كه در اين نمودار نيامده‌اند",
"Select something to vote on" => "موردي را براي راي دادن انتخاب كنيد",
"Item information" => "اطلاعات فقره",
"Dif" => "تعريف",
"Best Position" => "بهترين موقعيت",
"Vote this item" => "ارزش اين فقره",
"Highest" => "بيشترين ارزش",
"View FAQ Tpl" => "الگوي مشاهده‌ي FAQ",
"Admin Menus tpl" => "الگوي مديريت منوها",
"Answers" => "پاسخ‌ها",
"Q" => "س",
"A" => "ج",
"Add Suggestion" => "افزودن پيشنهاد",
"1 suggestion" => "1 پيشنهاد",
"suggestions" => "پيشنهاد",
"Forum List" => "فهرست انجمن",
"Edit Forum" => "ويرايش انجمن",
"You have {\$unread} unread private messages" => "شما {\$unread} عدد پيغام نخوانده‌ي شخصي داريد",
"You have to enter a title and text" => "شما بايد يك متن و عنوان وارد كنيد",
"Summary" => "خلاصه",
"Moderator Actions" => "اعمال ناظم",
"Move Selected Topics" => "عناوين منتخب را انتقال بده",
"Unlock Selected Topics" => "قفل عنواين منتخب را باز كن",
"Lock Selected Topics" => "عناوين منتخب را قفل كن",
"Delete Selected Topics" => "عناوين منتخب را حذف كن",
"Merge" => "ادغام",
"Merge Selected Topics" => "عناوين منتخب را اذغام كن",
"Reported Messages:" => "پيغام‌هاي گزارش شده:",
"Queued Messages:" => "پيغام‌هاي در صف",
"Merge into topic" => "ادغام در عنوان",
"Emot" => "احساسات",
"pts" => "امتياز",
"Announce" => "اعلام",
"Hot" => "برانگيخته",
"Sticky" => "چسب‌‌ناك",
"No topics yet" => "هنوز هيچ عنواني وجود ندارد.",
"Show posts" => "الصاق‌ها را نمايش بده",
"Last hour" => "ساعت گذشته",
"Last 24 hours" => "24 ساعت گذشته",
"Last 48 hours" => "48 ساعت گذشته",
"Jump to forum" => "به اين انجمن بپر",
" unread private messages" => " پيغام شخصي خوانده نشده",
"prev topic" => "عنوان قبلي",
"next topic" => "عنوان بعدي",
"IRC log" => "ثبت وقايع IRC",
"Show All" => "نمايش همه",
"Insert New Item" => "درج فقره‌ي جديد",
"Edit Fields" => "ويرايش ستون‌ها",
"View inserted item" => "مشاهده‌ي اقلام درج شده",
"View Item" => "مشاهده‌ي فقره",
"Filter Tracker Items" => "اقلام tracker را فيلتر كن",
"Add a Comment" => "ايراد نظر",
"Items list" => "فهرست اقلام",
"Special Operations" => "اعمال خاص",
"Add new mail account" => "اضافه كردن يك حساب پست الكترونيكي",
"User accounts" => "حساب‌هاي كاربران",
"View All" => "مشاهده‌ي همه",
"Msg" => "پيغام",
"Clip" => "كليپ",
"Back To Mailbox" => "بازگشت به صندوق پستي",
"Full Headers" => "سرصفحه‌هاي كامل",
"Normal Headers" => "سرصفحه‌هاي معمولي",
"Reply To All" => "پايه به همه",
"Forward" => "ارجاع",
"Select from address book" => "از كتابچه‌ي آدرس انتخاب كن",
"Use HTML mail" => "از پست الكترونيكي HTML استفاده كن",
"The following addresses are not in your address book" => "اين آدرس‌ها در كتابچه‌ي آدرس نيستند",
"Add Contacts" => "افزودن گيرنده",
"Attachment 1" => "ضميمه‌ي 1",
"Attachment 2" => "ضميمه‌ي 2",
"Attachment 3" => "ضميمه‌ي 3",
"Address book" => "كتابچه‌ي آدرس",
"as Creator &amp; Last Editor" => "به‌عنوان ايجادكننده و آخرين ويراستار",
"Business style" => "سبك تجاري",
"Collaborative style" => "سبك همكاري",
"no (disabled)" => "هيچكدام (غيرفعال)",
"Minor Edit" => "كوچك",
"Administration" => "سرپرستي",
"%s enabled" => "%s فعال شد",
"%s disabled" => "%s غيرفعال شد",
"Enable/disable Tiki features here, but configure them elsewhere" => "خصيصه‌هاي ويكي را در اين محل فعال/غيرفعال كنيد، اما آن‌ها را جاهاي ديگر پيكربندي نماييد.",
"General preferences and settings" => "تنظيمات  عمومي",
"User registration, login and authentication" => "ثبت‌نام كاربران، ورود و تصديق هويت",
"Wiki settings" => "تنظيمات ويكي",
"Article/CMS settings" => "تنظيمات مقالات/سامانه‌ي مديريت محتوا",
"Poll comments settings" => "تنظيمات 'نظرات' راي‌گيري‌ها",
"Configuration options for all blogs on your site" => "تنظيمات پيكربندي براي تمام بلاگ‌ها در پايگاه شما",
"Forums settings" => "تنظيمات انجمن‌ها",
"FAQ comments settings" => "تنظيمات مربوط به 'نظرات' FAQها",
"Trackers settings" => "تنظيمات Trackerها",
"RSS settings" => "تنظيمات RSS",
"Directory settings" => "تنظيمات پوشه",
"Maps configuration" => "پيكربندي نقشه‌ها",
"Meta Tags settings" => "تنظيمات فرابرچسب‌ها",
"Search settings" => "تنظيمات جستجو",
"Score settings" => "تنظيمات امتيازدهي‌ها",
"Community settings" => "تنظيمات اجتماعات",
"Calendar settings" => "تنظيمات تقويم",
"Intertiki settings" => "تنظيمات بين تيكي",
"No chart indicated" => "هيچ نموداري مشخص نشده است.",
"Upload failed" => "بارگذاري شكست خورد",
"You have to provide a hotword and a URL" => "شما بايد يك URL و يك واژه‌ي آتشين فراهم كنيد",
"Detected, Version:" => "يافت شد، نسخه:",
"Not detected." => "كشف نشد",
"Your admin password has been changed" => "كلمه‌ي عبور سرپرست تغيير كرد",
"All Fields except gdaltindex must be filled" => "تمام ستون‌ها مگر gdaltindex بايد پر شوند",
"No valid gdaltindex executable" => "gdaltindex نامعتبر و غيرقابل اجرا",
"Tag already exists" => "برچسب قبلا ايجاد شده است",
"Tag not found" => "برچسب پيدا نشد",
"Repository name can't be an empty" => "نام مخرن نمي‌تواند خالي باشد",
"Requested action is not supported on repository" => "عمل درخواستي قابل انجام بر روي مخزن نيست",
"No repository" => "هيچ مخزني نيست",
"Search is mandatory field" => "جستجوي يك ستون اجباري است",
"File not found " => "پرونده پيدا نشد ",
"Requested action in not supported on repository" => "عمل درخواستي روي مخزن پشتيباني نمي‌شود",
"Non-existent link" => "پيوند وجود ندارد",
"Mail-in account %s incorrect" => "حساب 'كنترل با پست الكترونيكي' %s ناصحيح است",
"Mail-in account %s saved" => "حساب 'كنترل با پست الكترونيكي' %s ذخيره شد",
"Frequency should be a positive integer!" => "تناوب بايد يك عدد مثبت باشد!",
"Mail-in accounts set to be checked every %s minutes" => "حساب 'كنترل با پست الكترونيكي' براي بررسي در هر %s دقيقه تنظيم شد",
"Automatic Mail-in accounts checking disabled" => "بررسي خودكار حساب 'كنترل با پست الكترونيكي' غيرفعال شد",
"No menu indicated" => "هيچ منواي مشخص نشده است",
"No newsletter indicated" => "هيچ خبرنمامه‌اي مشخص نشده است",
"No poll indicated" => "هيچ راي‌گيري‌اي مشخص نشده است",
"Insert" => "درج",
"Icon" => "تمثال",
"unsafe" => "ناامن",
"register_globals should be off by default. See the php manual for details." => "register_globals بايد  به‌صورت پيش‌فرض خاموش باشد. براي اطلاعات بيشتر سند راهنماي PHP را مطالعه كنيد",
"safe" => "امن",
"session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid بايد به‌صورت پيش‌فرض خاموش باشد. براي اطلاعات بيشتر سند راهنماي PHP را مطالعه كنيد",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir احتمالا در پوشه‌ي تيكي‌ويكي شماست. اين خطر وجود دارد كه فردي پرونده‌اي را در اين پوشه بارگذاري كرده و از طريق وي به آن دسترسي پيدا كند",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "نمي‌توانم بررسي كنم كه آيا upload_tmp_dir از طريق وب قابل دسترس است يا خير. براي اطمينان بايد تنظيمات سرور وب خود را بررسي كنيد.",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "تنظيم xbithack امن نيست! بسته به نحوه‌ي اداره كردن وب‌سرور شما و تنظيمات تيكي، ممكن است مهاجمين بتوانند پرونده‌اي به سرسراي پرونده‌ها بارگزاري كرده و آن را اجرا كنند",
"risky" => "خطرناك",
"allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen ممكن است به‌صورت بالقوه براي بارگذاري اطلاعات يا دستخط(script) از راه دور مورد استفاده قرار گيرد. اگر از بلاگ‌ها استفاده نمي‌كنيد، مي‌توانيد اين خصيصه را خاموش كنيد.",
"The Path to store files in the filegallery should be outside the tiki root directory" => "آدرس ذخيره‌ي پرونده‌ها در سرسراي پرونده بايد خارج از پوشه‌ي مادر تيكي باشد",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "آدرس ذخيره‌ي پرونده‌ها در سرسراي تصوير بايد خارج از پوشه‌ي مادر تيكي باشد",
"The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "خصيصه‌ي 'ويرايش الگوها' روشن است. به كساني كه اطمينان نداريد، امكان استفاده از اين خصيصه را ندهيد، زيرا به راحتي براي تزريق دستور به PHP مورد استفاده قرار مي‌گيرد.",
"File is not readable. Unable to check." => "پرونده قابل خواندن نيست. نمي‌توانم بررسي كنيم.",
"You have to provide a word" => "شما بايد كلمه‌اي وارد كنيد",
"Permission denied you cannot view this page" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد اين صفحه را ببينيد.",
"Permission denied you cannot edit this page" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين صفحه را ويرايش كنيد",
"You must specify a page name, it will be created if it doesn't exist." => "بايد نام صفحه را وارد كنيد، اگر وجود نداشته باشد، ساخته خواهد شد",
"page not added (Exists)" => "صفحه اضافه نشد(وجود داشت)",
"No survey indicated" => "هيچ نظرسنجي‌اي مشخص نشده است",
"You don't have permission to use this feature" => "متاسفانه شما حقوق دسترسي كافي براي استفاده از اين خصيه را نداريد",
"No Errors detected" => "هيچ خطايي يافت نشد",
"No tracker indicated" => "هيچ trackerاي مشخص نشده است",
"Group already exists" => "اين گروه قبلا ايجاد شده است.",
"User doesn't exist" => "كاربر وجود ندارد",
"No records were found. Check the file please!" => "هيچ ركوردي يافت نشد. لطفا پرونده را كنترل كنيد!",
"User login is required" => "احتياج به نام ورود براي كاربر است",
"Password is required" => "احتياج به كلمه‌ي عبور است",
"Email is required" => "اجتياج به پست الكترونيكي است",
"User is duplicated" => "كاربر تكراري است",
"Created account %s <%s>" => "حساب %s <%s> ايجاد شد",
"Assigned %s in group %s" => "%s به گروه %s منتصب شد",
"User %s already exists" => "كابر %s از قبل وجود داشت",
"New %s created with %s %s." => "%s جديد با %s %s ايجاد شد",
"Impossible to create new %s with %s %s." => "ساخت %s جديد با %s %s غير ممكن است.",
"%s %s successfully deleted." => "%s %s يا موفقيت ايجاد شد",
"%s %s removed from %s %s." => "%s %s با موفقيت از %s %s حذف شد",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> با موفقيت حذف شد.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> به  %s <b>%s</b> اختصاص يافت",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> از %s <b>%s</b> حذف شد.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "گروه <b>%s</b> با موفقيت به عنوان گروه پيش‌فرض كاربر <b>%s</b> قرار گرفت.",
"%s modified successfully." => "%s با موفقيت تغيير يافت.",
"password" => "كلمه‌ي عبور‌",
"%s modification failed." => "تغيير %s موفقيت‌آميز نبود",
"%s changed from %s to %s" => "%s از %s به %s تغيير يافت",
"Impossible to change %s from %s to %s" => "تغيير %s از %s به %s غيرممكن است",
"rss feed disabled" => "تغذيه‌ي RSS غيرفعال شد",
"Permission denied you cannot view this section" => "متاسفانه شما حقوق دسترسي لازم براي مشاهده‌ي اين بخش را نداريد",
"Tiki RSS feed for articles" => "تغذيه‌ي RSSهاي تيكي براي مقالات",
"Last articles." => "آخرين مقالات",
"Unknown group" => "گروه نامشخص",
"Group doesn't exist" => "گروه وجود ندارد",
"You have to indicate a group" => "بايد يك گروه مشخص كنيد",
"This group is invalid" => "اين گروه معتبر نيست",
"Permission denied you cannot view backlinks for this page" => "متاسفانه شما حقوق دسترسي كافي براي مشاهده‌ي backlinkهاي اين صفحه را نداريد",
"The page cannot be found" => "صفحه يافت نشد",
"Invalid directory name" => "نام پوشه معتبر نيست",
"Permission denied you cannot post" => "متاسفانه شما حقوق دسترسي لازم براي الصاق را نداريد",
"Permission denied you cannot edit this post" => "متاسفانه شما حقوق دسترسي لازم براي تغيير اين الصاق را نداريد.",
"You can't post in any blog maybe you have to create a blog first" => "شما به هيچ بلاگي نمي‌توانيد الصاق كنيد، شايد ابتدا بايستي بلاگ‌اي ايجاد نماييد.",
"Top visited blogs" => "پربيننده‌ترين بلاگ‌ها",
"Last posts" => "آخرين الصاق‌ها",
"Top active blogs" => "فعال‌ترين بلاگ‌ها",
"Tiki RSS feed for blog: " => "تغذيه‌ي RSS تيكي براي بلاگ: ",
"No blogId specified" => "هيچ بلاگي مشخص نشده است.",
"Tiki RSS feed for weblogs" => "تغذيه‌ي RSS تيكي براي وبلاگ‌ها",
"Last posts to weblogs." => "آخرين الصاق‌ها به وبلاگ‌ها",
"TOP" => "فوقاني",
"Permission denied you cannot access this gallery" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد به اين سرسرا دسترسي داشته باشيد.",
"No gallery indicated" => "هيچ سرسرايي مشخص نشده است.",
"Permission denied you can not view this section" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد اين بخش را ببينيد.",
"Permission denied you cannot remove images from this gallery" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد تصاوير را از اين سرسرا حذف كنيد.",
"Permission denied you cannot rebuild thumbnails in this gallery" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد تصويرك‌هاي اين سرسرا را از نو بسازيد.",
"Permission denied you cannot rotate images in this gallery" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد تصاوير اين سرسرا را بچرخانيد.",
"No image indicated" => "هيچ تصويري مشخص نشده است.",
"Permission denied you cannot move images from this gallery" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد تصاوير اين سرسرا را منتقل كنيد.",
"Permission denied you cannot view the calendar" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد اين تقويم را مشاهده كنيد.",
"event without name" => "رويداد بدون نام",
"Access Denied" => "دسترسي ممنوع است",
"No category indicated" => "هيچ طبقه‌اي مشخص نشده است.",
"Permission denied; you cannot assign permissions for this category" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد براي اين طبقه حقوق دسترسي تعريف كنيد",
"You can not use the same password again" => "نمي‌توانيد از همان كلمه‌ي عبور مجددا استفاده كنيد",
"Top authors" => "برترين مؤلفين",
"ERROR: you must include a subject or a message at least" => "خطا: بايد حداقل يك موضوع يا متن وارد كنيد",
"You need to change chmod 'whelp' manually to 777" => "بابد دسترسي 'whelp' را به‌صورت دستب به 777 تغيير دهيد.",
"This feature has been disabled" => "اين خصيصه غيرفعال شده است",
"Tiki RSS feed for directory sites" => "تغذيه‌ي RSS براي پايگاه‌هاي پوشه",
"Last sites." => "آخرين پايگاه‌ها",
"Must enter a name to add a site. " => "براي افزودن پايگاه بايد يك نام وارد كنيد. ",
"Must enter a url to add a site. " => "براي وارد كردن يك پايگاه بايد يك URL وارد كنيد. ",
"URL already added to the directory. Duplicate site? " => "URL قبلا به پوشه اصافه شده بود، تكراري اضافه كنم؟",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL قابل دسترس نسيت. URL اشتباه است يا پايگاه روي‌خط نيست و نمي‌تواند به پوشه اصافه شود. ",
"Must select a category. " => "بايد يك طبقه انتخاب كنيد. ",
"Must enter a name to add a site" => "براي افزودن يك پايگاه بايد يك نام وارد كنيد",
"Must enter a url to add a site" => "براي افزودن يك پايگاه بايد يك URL وارد كنيد",
"URL already added to the directory. Duplicate site?" => "URL قبلا به پوشه اصافه شده بود، تكراري اضافه كنم؟",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL قابل دسترس نسيت. URL اشتباه است يا پايگاه روي‌خط نيست و نمي‌تواند به پوشه اصافه شود. ",
"Must select a category" => "بايد يك طبقه انتخاب كنيد. ",
"No site indicated" => "هيچ پايگاهي مشخص نشده است.",
"No parent specified" => "هيچ والدي مشخص نشده است.",
"Last sites of directory \".\$rc[\"name\"].\" ." => "آخرين پايگاه‌هاي پوشه‌ي \".\$rc[\"name\"].\" .",
"You can not download files" => "شما نمي‌توانيد پرونده دريافت كنيد",
"Article not found" => "مقاله پيدا نشد.",
"Permission denied you cannot edit this article" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين مقاله را ويرايش كنيد",
"The language can't be changed as its set of translations has already this language" => "زبان نمي‌تواند تغيير كند، چراكه مجموعه‌ي ترجمه‌ها اين زبان را دارد",
"You do not have permissions to edit banners" => "شما حق دسترسي براي ويرايش درفش‌ها(banners) را نداريد",
"Banner not found" => "درفش(banner) پيدا نشد",
"You do not have permission to edit this banner" => "شما حق دسترسي براي ويرايش اين درفش(banner) را نداريد",
"Permission denied you cannot create or edit blogs" => "دسترسي غير ممكن است، شما نمي‌توانيد بلاگ بسازيد يا تغيير دهيد",
"Permission denied you cannot edit this blog" => "دسترسي غيرممكن است، شما نمي‌توانيد اين بلاگ را تغيير دهيد",
"You do not have permission to write the style sheet" => "متاسفانه شما حقوق دسترسي كافي براي نوشتن سبك نگارش(Style sheet) نداريد",
"Invalid request to edit an image" => "درخواست نامعتبر براي ويرايش يك تصوير",
"Permission denied you cannot edit images" => "دسترسي غيرممكن است، شما نمي‌توانيد تصاوير را تغيير دهيد",
"Permission denied you can edit images but not in this gallery" => "دسترسي ممنوع است: شما مي‌توانيد تصاوير را ويرايش كنيد، اما نه در اين سرسرا",
"Failed to edit the image" => "ويرايش تصوير ناموفق بود",
"Permission denied to use this feature" => " دسترسي ممنوع است:متاسفانه شما نمي‌توانيد از اين خصيصه استفاده كنيد",
"Shortname must be 2 Characters" => "نام اختصار بايد 2 حرف باشد",
"You must provide a longname" => "بايد نام مشروح را وارد كنيد",
"Language created" => "زبان ايجاد شد",
"No content id indicated" => "هيچ شناسه‌ي محتوايي مشخص نشده است.",
"No question indicated" => "هيچ سئوالي مشخص نشده است.",
"No quiz indicated" => "هيچ آزموني مشخص نشده است.",
"No structure indicated" => "هيچ ساختاري مشخص نشده است.",
"Invalid structure_id or page_ref_id" => "شناسه‌ي ساختار يا شناسه‌ي ارجاع به صفحه معتبر نيست",
"Permission denied you cannot send submissions" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد ارائه كنيد",
"Permission denied you cannot edit submissions" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد ارائه‌ها را ويرايش كنيد",
"You have to create a topic first" => "بايد ابتدا يك موضوع ايجاد كنيد",
"You do not have permission to do that" => "متاسفانه براي اين‌كار حقوق دسترسي كافي نداريد",
"You do not have permission to read the template" => "متاسفانه شما حقوق دسترسي كافي براي خواندن الگو نداريد",
"No topic id specified" => "هيچ شناسه‌ي موضوعي مشخص نشده است.",
"Invalid topic id specified" => "شناسه‌ي موضوع مشخص شده معتبر نيست",
"No object indicated" => "هيچ شيئي مشخص نشده است.",
"No type indicated" => "هيچ نوعي مشخص نشده است.",
"page imported" => "صفحه وارد شد",
"created from import" => "ساخته شده از طريق واردات",
"Can't import remote HTML page" => "نمي‌توانم صفحه‌ي راه‌دور HTML را وارد كنم",
"Can't parse remote HTML page" => "نمي‌توانم صفحه‌ي راه‌دور HTML را تجزيه كنم",
"The SandBox is disabled" => "دست‌گرمي غيرفعال است",
"Cannot edit page because it is locked" => "نمي‌توان اين صفحه را ويرايش كرد. صفحه قفل است",
"No questions group indicated" => "هيج گروه سئوالي مشخص نشده است.",
"Permission denied you cannot edit this file" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين پرونده را ويرايش كنيد",
"Permission denied you cannot remove files from this gallery" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد پرونده‌اي از اين سرسرا حذف كنيد",
"Top visited file galleries" => "پربيننده‌ترين سرسراهاي پرونده",
"Most downloaded files" => "پرونده‌هايي كه از همه بيشتري دريافت شده‌اند",
"Last files" => "آخرين پرونده‌ها",
"Tiki RSS feed for file galleries" => "تغذيه‌ي RSS تيكي براي سرسراهاي پرونده",
"Last files uploaded to the file galleries." => "آخرين پرونده‌هاي بارگذاري شده در سرسراهاي پرونده",
"No galleryId specified" => "هيچ شناسه‌ي سرسرايي مشخص نشده است.",
"Tiki RSS feed for the file gallery: " => "تغذيه‌ي RSS تيكي براي سرسراي پرونده‌ي: ",
"No forum indicated" => "هيچ انجمني مشخص نشده است.",
"Forum posts" => "الصاق‌هاي انجمن",
"No forumId specified" => "هيچ شناسه‌ي انجمني مشخص نشده است",
"Tiki RSS feed for forum: " => "تغذيه‌ي RSS براي انجمن: ",
"Tiki RSS feed for forums" => "تغذيه‌ي RSS براي انجمن‌ها",
"Last topics in forums." => "آخرين موضوعات در انجمن‌ها",
"Accepted friendship request from %s" => "درخواست رفاقت از طرف %s مورد قبول واقع شد",
"Refused friendship request from %s" => "درخواست رفاقت %s رد شد!",
"Broke friendship with %s" => "رابطه(رفاقت) را %s قطع شد",
"I have broken our friendship!" => "من رابطه‌مان(رابطه‌ي رفاقت) را قطع كردم!",
"You must be logged in to use this feature" => "براي استفاده از اين خصيصه بايد وارد سامانه شويد",
"Friendship request sent to %s" => "درخواست رفاقت به %s ارسال شد.",
"You're already friend of %s" => "شما هم‌اينك هم رفيق %s هستيد",
"I have accepted your friendship request!" => "من درخواست رفاقت شما را پذيرفته‌ام!",
"No process indicated" => "هيچ فرايندي مشخص نشده است.",
"Activity name already exists" => "فعاليتي با اين نام قبلا ايجاد شده است",
"indicates if the process is active. Invalid processes cant be active" => "مشخص مي‌كند كه آيا فرايند فعال است يا خير. فرايندهاي نامعتبر نمي‌توانند فعال شوند",
"No instance indicated" => "هيچ نمونه‌اي مشخص نشده است.",
"No activity indicated" => "هشچ فعاليتي مشخص نشده است.",
"The process name already exists" => "فعاليتي با اين نام قبلا ايجاد شده است",
"Process already exists" => "اين فرايند هم‌اينك وجود دارد",
"You cant execute this activity" => "شما نمي‌توانيد اين فعاليت را اجرا كنيد",
"You couldn't abort a instance" => "شما نمي‌توانيد يك نمونه را متوقف كنيد",
"You couldn't exception a instance" => "نمي‌توانيد يك نمونه را مستثنا كنيد",
"No user indicated" => "هيچ كاربري مشخص نشده است.",
"No title indicated" => "هيچ عنواني مشخص نشده است.",
"No comment indicated" => "هيچ نظري مشخص نشده است.",
"No date indicated" => "هيچ تاريخي مشخص نشده است.",
"No item indicated" => ".هيچ موردي انتخاب نشده است",
"first uploaded image" => "اولين تصوير بارگذاري شده",
"last uploaded image" => "آخرين تصوير بارگذاري شده",
"first image" => "اولين تصوير",
"last image" => "آخرين تصاوير",
"random image" => "يك تصوير تصادفي",
"Permission denied you cannot create galleries and so you cant edit them" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد سرسرا ايجاد كنيد، درنتيجه نمي‌توانيد آن‌ها را ويرايش كنيد",
"Permission denied you cannot edit this gallery" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين سرسرا را ويرايش كنيد",
"Permission denied you cannot remove this gallery" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين سرسرا را حذف كنيد",
"Permission denied you cannot make the map of this gallery" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد نقشه‌ي اين سرسرا را تهيه كنيد",
"Top images" => "تصاوير برتر",
"Last images" => "آخرين تصاوير",
"Tiki RSS feed for image galleries" => "تغذيه‌ي RSS تيكي براي سرسراهاي تصاوير",
"Last images uploaded to the image galleries." => "آخرين تصاوير بارگذاري شده به سرسراهاي تصاوير",
"Tiki RSS feed for the image gallery: " => "تغذيه‌ي RSS تيكي براي سرسراي تصوير: ",
"overwriting old page" => "صفحات قديمي را بازنويسي كن",
"updated from structured text import" => "به‌روز رساني شده توسط واردات متن ساختار يافته",
"page created" => "صفحه ساخته شد",
"created from structured text import" => "به‌روز رساني شده توسط واردات ساختار يافته",
"No name indicated for wiki page" => "هيچ نامي براي صفحه‌ي ويكي مشخص نشده است.",
"No repository given" => "هيچ مخزني داده نشده است.",
"Permission denied you cannot view pages like this page" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد صفحاتي مانند اين صفحه را مشاهده كنيد",
"Permission denied you cannot remove articles" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد مقالات را حذف كنيد",
"Permission denied you cannot remove banners" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد درفش‌ها را حذف كنيد",
"Permission denied you cannot remove this blog" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين بلاگ را حذف كنيد",
"Non-existent gallery" => "چنين سرسرايي وجود ندارد",
"Permission denied you can upload files but not to this file gallery" => "دسترسي ممنوع است: شما مي‌توانيد پرونده بارگذاري كنيد، اما نه به اين سرسرا",
"Could not upload the file" => "نمي‌توانم پرونده را بارگذاري كنم",
"Invalid filename (using filters for filenames)" => "نام تصوير معتبر نيست (به دليل استفاده از فيلترها براي نام پرونده‌ها",
"Could not find the file requested" => "نمي‌توانم پرونده‌ي درخواستي را پيدا كنم",
"Permission denied you can't upload files so you can't edit them" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد پرونده‌اي بارگذاري كنيد، لذا نمي‌تواندي پرونده‌ها را ويرايش كنيد",
"The game file must have .swf or .dcr extension" => "نام پرونده‌ي بازي بايد پسودي معادل .swf يا .dcr داشته باشد",
"The thumbnail name must be" => "نام تصويرك بايد ",
"Please supply both files" => "لطفا هردو پرونده را فراهم كنيد",
"You cannot admin blogs" => "شما نمي‌توانيم بلاگ‌ها را مديريت كنيد",
"Permission denied you cannot remove submissions" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد ارائه‌ها را حذف كنيد",
"Permission denied you cannot approve submissions" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد ارائه‌ها را تاييد كنيد",
"Permission denied you cannot remove pages" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد صفحات را حذف كنيد",
"You have to enable cookies to be able to login to this site" => "براي ورود به اين پايگاه، بايد كوكي‌ها را در مرورگر خود براي اين پايگاه فعال كنيد",
"Tiki mail-in auto-reply" => "پاسخ خودكار 'كنترل با پست الكترونيكي'",
"Sorry, you can't use this feature." => "متاسفم، شما نمي‌توانيد از اين خصيصه استفاده كنيد",
"You do not have permissions to view the maps" => "متاسفانه شما حقوق دسترسي كافي براي مشاهده‌ي نقشه‌ها را نداريد",
"Maps feature is not correctly setup : Maps path is missing." => "خصيصه‌ي نقشه به درستي برپا نشده است: مسير نقشه‌ها مفقود است.",
"mapfile name incorrect" => "نام پرونده‌ي نقشه ناصحيح است.",
"This mapfile already exists" => "پرونده‌ي نقشه قبل تكراري است.",
"You do not have permission to write to the mapfile" => "متاسفانه شما حقوق دسترسي كافي براي نوشتن در اين پرونده‌ي نقشه را ندارد",
"You do not have permission to delete the mapfile" => "متاسفانه شما حقوق دسترسي لازم براي حذف اين پرونده‌ي نقشه را نداريد",
"I could not make a copy" => "نمي‌توانم يك رونوشت(كپي) تهيه كنم",
"You do not have permission to read the mapfile" => "متاسفانه شما حقوق دسترسي كافي براي خواندن اين پرونده‌ي نقشه را نداريد",
"You dont have permission to do that" => "متاسفانه شما حقوق دسترسي كافي بري انجام اين كار را نداريد",
"Tiki RSS feed for maps" => "تغذيه‌ي RSSهاي تيكي براي نقشه‌ها",
"List of maps available." => "فهرست نقشه‌هاي موجود.",
"You do not have permissions to view the layers" => "متاسفانه شما حقوق دسترسي كافي براي مشاهده‌ي لايه‌ها را نداريد",
"You do not have permissions to delete a file" => "متاسفانه شما حقوق دسترسي كافي براي حذف يك پرونده را نداريد",
"File not found" => "پرونده پيدا نشد",
"You do not have permissions to create a directory" => "متاسفانه شما حقوق دسترسي كافي براي ساخت يك پوشه را نداريد",
"The Directory is not empty" => "پوشه خالي نيست",
"You do not have permissions to delete a directory" => "متاسفانه شما حقوق دسترسي كافي براي حذف يك پوشه را نداريد",
"You do not have permissions to create an index file" => "متاسفانه شما حقوق دسترسي كافي براي ساخت يك پرونده‌ي Index را نداريد",
"Invalid file name" => "نام پرونده معتبر نيست",
"Invalid files to index" => "پرونده‌ي غيرمعتبر براي ايندكس‌گذاري",
"I do not know where is gdaltindex. Set correctly the Map feature" => "من نمي‌دانم gdaltindex كجاست. لطفا خصيصه‌ي نقشه را صحيح تنظيم كنيد",
"I could not create the index file" => "نمي‌توانم پرونده‌ي Index را ايجاد كنم",
"Must be logged to use this feature" => "براي استفاده از اين خصيصه، بايد وارد سامانه شويد",
"Welcome at Hawiki" => "به 'هاويكي' خوش‌آمديد",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "استفاده از اين پايگاه تيكي‌ويكي براي دسترسي از طريق بسياري از ابزارهاي سيار مانند تلفن‌هاي WAP، PDAها، ابزارهاي i-mode و غيره آماده شده است.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "شما مي‌توانيد با هدايت مرورگر ابزار خود به آدرس مقابل، اين پايگاه را در ابزار سيار خود مرور كنيد:",
"About" => "درباره",
"You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "شما نياز به اجراي setup.sh :<br /> داريد.  كاربران متعارف apache عبارتند از: www-data, apache يا nobody",
"Your PHP installation does not have zlib enabled." => "نصب PHP شما، zlibاش فعال نيست.",
"You must log in to use this feature" => "براي استفاده از اين خصيصيه شما بايد وارد سامانه شويد",
"You do not have permission to view other users data" => "متاسفانه شما حقوق دسترسي كافي براي مشاهده‌ي اطلاعات ساير كاربران را نداريد",
"You must be logged in to subscribe to newsletters" => "براي عضويت در خبرنامه‌ها بايد وارد سامانه شويد",
"No server indicated" => "هيچ سروري مشخص نشده است",
"Cannot connect to" => "عدم توانايي در برقراري ارتباط با",
"Missing information to read news (server,port,username,password,group) required" => "اطلاعات لازم براي خواند اخبار مفقود شده است. (سرور، درگاه، نام كاربري، كلمه‌ي عبور و گروه مورد نيازاند)",
"Cannot get messages" => "نمي‌توانم پيغام‌ها را بگيرم",
"No note indicated" => "هيچ يادداشتي مشخص نشده است",
"merged note:" => "ادغام يادداشت: ",
"File is too big" => "پرونده خيلي بزرگ است",
"created from notepad" => "ايجاد شده از notepad",
"Page already exists" => "صفحه قبلا ايجاد شده بود",
"Not enough information to display this page" => "اطلاعات كافي براي نمايش در اين صفحه وجود ندارد",
"Permission denied you cannot browse this page history" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد تاريخچه‌ي اين صفحه را مرور كنيد",
"No article indicated" => "هيچ مقاله‌اي مشخص نشده است",
"Article is not published yet" => "مقاله هنوز منتشر نشده است",
"No post indicated" => "هيچ الصاقي مشخص نشده است",
"Blog not found" => "بلاگ يافت نشد",
"No pages indicated" => "هيچ صفحه‌اي مشخص نشده است.",
"Pageviews" => "مشاهدات صفحه",
"You don't have permission to edit quizzes." => "متاسفانه شما حقوق دسترسي كافي براي ويرايش اين آزمون را نداريد.",
"No result indicated" => "هيچ نتيجه‌اي مشخص نشده است.",
"Registered" => "اعضا",
"The passwords don't match" => "كلمه‌ي عبور همخواني ندارد",
"empty" => "تخليه شود",
"Invalid or unknown username" => "نام كاربري نامعتبر يا ناشناخته است",
"Unable to send mail. User has not configured email" => "امكان ارسال پست الكترونيكي وجود ندارد. كاربر پست الكترونيكي خود را پيكربندي نكرده است",
"A password and your IP address reminder email has been sent " => "پست الكتروينيكي يادآور كلمه‌ب عبور و آدرس IP شما ارسال شد ",
"to the registered email address for" => "به آدرسي‌هاي پست الكترونيكي ثبت شده براي",
"last version" => "آخرين نسخه",
"Permission denied you cannot remove versions from this page" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد نسخ اين صفحه را حذف كنيد",
"Permission denied you cannot rename this page" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد نام اين صفحه را تغيير دهيد",
"Cannot rename page because the new name begins with reserved prefix" => "از آن‌جايي كه اين نام صفحه با پيشوند اندوخته شده(reserved) آغاز مي‌‍شود، نمي‌توان نام آن را تغيير داد",
"Cannot rename page maybe new page already exists" => "نمي‌توانم صفحه را تغيير نام بدهم، احتمالا صفحه‌اي با اين نام وجود دارد.",
"changed '%s' from '%s' to '%s'" => "'%s' از '%s' به '%s' تغيير كرد",
"Non-existent version" => "نسخه وجود ندارد",
"Permission denied you cannot rollback this page" => "دسترسي ممنوع است: متاسفانه شما حق برگرداندن اين صفحه با حالت قبل را نداريد",
"Error Message" => "پيغام‌ها خطا",
"Post recommendation at" => "الصاق توصيه شده در",
"No newsletters available." => "هيچ خبرنامه‌اي موجود نيست.",
" successfully sent" => "با موفقيت ارسال شد",
" not sent" => " ارسال نشد",
"Error: " => "خطا: ",
"Page must be defined inside a structure to use this feature" => "صفحه بايد درون يك ساختار تعريف شده باشد تا بتوان از اين خصيصه استفاده كرد",
"You cannot take this quiz twice" => "نمي‌توانيد در اين آزمون دوبار شركت كنيد",
"Quiz time limit exceeded quiz cannot be computed" => "زمان آزمون به سر آمده است. آزمون به حساب نخواهد آمد",
"You cannot take this survey twice" => "شما نمي‌توانيد دوبار در اين نظرخواهي شركت كنيد",
"Please create a category first" => "لطفا ابتدا يك طبقه ايجاد كنيد",
"No permission to upload zipped file packages" => "حقوق دسترسي براي بارگذاري بسته‌هاي تصاوير فشرده شده(zipped) وجود ندارد",
"Error processing zipped image package" => "خطا در پردازش بسته‌ي تصاوير فشرده شده",
"No permission to upload zipped image packages" => "حقوق دسترسي براي بارگذاري بسته‌هاي تصاوير فشرده شده(zipped) وجود ندارد",
"The uploaded file ist not recognized as a image" => "The uploaded file is not recognized as an image",
"Permission denied you cannot upload images" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد تصويري بارگذاري كنيد.",
"Permission denied you can upload images but not to this gallery" => "دسترسي ممنوع است: شما مي‌توانيد تصوير بارگذاري كنيد، اما نه در اين سرسرا",
"Cannot get image from URL" => "نمي‌توانم از اين URL تصوير را بگيرم",
"That is not an image (or you have php < 4.0.5)" => "اين يك تصوير نيست (يا نسخه‌ي PHP شما قديمي‌تر از 4.0.5 است)",
"Usage" => "استفاده",
"No url indicated" => "No URL indicated",
"Unknown user" => "كاربر نامشخص",
"You are not logged in and no user indicated" => "شما وارد سامانه نشده اين و هيچ كاربري مشخص نشده است.",
"The user has chosen to make his information private" => "كاربر اين اطلاعات را جزو اطلاعات شخصي خود قرار داده است",
"Invalid password.  Your current password is required to change administrative information" => "كلمه‌ي عبور نامعتبر. براي تغيير اطلاعات سرپرستي كلمه‌ي عبور كنوني شما مورد نياز است",
"Email is set to %s" => "پست الكترونيكي تنظيم شده است به %s",
"The passwords did not match" => "كلمه‌ي عبور هم‌خواني ندارد",
"no" => "خير",
"was moved into trash" => "به خاكروبه منتقل شد",
"trashed by" => "منتقل شده به خاكروبه به‌وسيله‌ي",
"open / in process" => "بازكردن / در فرايند",
"Rights by creator" => "حقوق به‌وسيله‌ي ايجاد كننده",
"END" => "پايان",
"Percentage" => "درصد",
"Task accepted by creator" => "وظيفه به‌وسيله‌ي ايجاد كننده پذيرفته شد",
"Task accepted by task user" => "وظيفه از طرف كاربر موظف پذيرفته شد",
"Task NOT accepted by creator" => "وظيفه به‌وسيله‌ي ايجاد كننده پذيرفته نشد",
"Task NOT accepted by task user" => "وظيفه از طرف كاربر موظف پذيرفته نشد",
"Sorry this task does not exist or you have no rights to view this task" => "متاسفانه چنين وظيفه‌اي وجود ندارد، يا شما حقوق دسترسي كافي براي ديدن آن را نداريد",
"Task entries:" => "اقلام وظايف:",
"Changes:" => "تغييرات:",
"Info message" => "پيغام اطلاعات",
"NEW Task" => "وظيفه‌ي جديد",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "متاسفم، شما اجازه‌ي ارسال وظيفه به ساير كاربران را نداريد، يا كاربر انتخابي اجازه‌ي دريافت وظيفه را ندارد!",
"Changes on Task" => "تغييرات در وظايف",
"You received a new task" => "شما يك وظيفه‌ي جديد دريافت كرده‌ايد",
"The priority is" => "اولوست",
"high" => "بالا",
"very high" => "خيلي بالا",
"You've to start your work at least on" => "شما بايد حداقل تا اين موقع كار خود را آغاز كنيد",
"You've to finish your work on" => "شما بايد كارتان را تا اين موقع تمام كنيد",
"Login and click the link below" => "وارد سامانه شده و روي پيوند زير كليك كنيد",
"Please read the task and work on it!" => "لطفا وظيفه را بخوانيد و رويش كار كنيد!",
"Sorry, there was an error while trying to write data into the database" => "متاسفم، هنگام نوشتن در پايگاه داده با اشكال مواجه شدم.",
"Cannot upload this file not enough quota" => "نمي‌توانم اين پرونده را بارگذاري كنم. محدوديت حجم شما پر خواهد شد",
"Non-existent user" => "كاربر وجود ندارد",
"No banner indicated" => "هيچ درفشي مشخص نشده است.",
"No blog indicated" => "هيچ بلاگي مشخص نشده است.",
"Permission denied you cannot remove the post" => "دسترسي ممنوع است: متاسفانه شما نمي‌توانيد اين الصاق را حذف كنيد",
"No cache information available" => "اطلاعات cache در دسترس نيست",
"No faq indicated" => "هيچ FAQاي مشخص نشده است.",
"You are not permitted to remove someone else\\'s post!" => "شما حق حذف الصاقات شخص ديگر را نداريد!",
"Wrong password. Cannot post comment" => "كلمه‌ي عبور اشتباه است. نمي‌توانم نظر را الصاق كنم",
"Please wait 2 minutes between posts" => "لطفا بين هر دو الصاق، 2دقيقه صبر كنيد‌",
"No thread indicated" => "هيچ رگه‌اي مشخص نشده است",
"A SheetId is required." => "يك شناسه‌ي ورق لازم است.",
"That tracker don't use extras." => "That tracker doesn't use extras.",
"No subject" => "بدون موضوع",
"Top pages" => "برترين صفحات",
"Last pages" => "آخرين صفحات",
"Tiki RSS feed for the wiki pages" => "تغذيه‌ي RSS تيكي براي صفحات ويكي",
"Last modifications to the Wiki." => "آخرين تغييرات ويكي",
"###end###"=>"###end###");
?>
