/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.GPGraphTools;

public class Touch
implements Runnable {
    private GPGraph graph;
    private Hashtable deltas = new Hashtable();
    private Hashtable positions = new Hashtable();
    private Thread relaxer;
    private boolean allowedToRun = false;
    private boolean repaintNeeded = false;
    private double damper = 1.0;
    private double maxMotion = 0.0;
    private double lastMaxMotion = 0.0;
    private double motionRatio = 0.0;
    private boolean damping = true;
    private double rigidity = 1.5;
    private double newRigidity = 1.0;

    public Touch(GPGraph gPGraph) {
        this.graph = gPGraph;
        this.relaxer = null;
    }

    void setRigidity(double d) {
        this.newRigidity = d;
    }

    private synchronized void relaxEdges() {
        Object[] objectArray = this.graph.getEdges(this.graph.getAll());
        int n = 0;
        while (n < objectArray.length) {
            CellView cellView = this.graph.getSourceView(objectArray[n]);
            CellView cellView2 = this.graph.getTargetView(objectArray[n]);
            CellView cellView3 = this.graph.getGraphLayoutCache().getMapping(((Edge)objectArray[n]).getSource(), false);
            CellView cellView4 = this.graph.getGraphLayoutCache().getMapping(((Edge)objectArray[n]).getTarget(), false);
            if (cellView != null && cellView2 != null) {
                Rectangle rectangle = cellView3.getBounds();
                Rectangle rectangle2 = cellView4.getBounds();
                double d = rectangle2.x - rectangle.x;
                double d2 = rectangle2.y - rectangle.y;
                double d3 = Math.sqrt(d * d + d2 * d2);
                double d4 = d * this.rigidity;
                double d5 = d2 * this.rigidity;
                double d6 = this.getLength(objectArray[n]) * 100.0;
                this.moveView(cellView2, -(d4 /= d6) * d3, -(d5 /= d6) * d3);
                this.moveView(cellView, d4 * d3, d5 * d3);
            }
            ++n;
        }
    }

    public double getLength(Object object) {
        CellView cellView = this.graph.getGraphLayoutCache().getMapping(object, false);
        return GPGraphTools.getLength(cellView);
    }

    private synchronized void avoidLabels() {
        Object[] objectArray = this.graph.getVertices(this.graph.getAll());
        int n = 0;
        while (n < objectArray.length) {
            int n2 = n + 1;
            while (n2 < objectArray.length) {
                Point2D.Double double_;
                Point2D.Double double_2;
                CellView cellView = this.graph.getGraphLayoutCache().getMapping(objectArray[n], false);
                CellView cellView2 = this.graph.getGraphLayoutCache().getMapping(objectArray[n2], false);
                if (cellView != null && cellView2 != null && (double_2 = this.getPosition(cellView)) != null && (double_ = this.getPosition(cellView2)) != null) {
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = double_2.x - double_.x;
                    double d4 = double_2.y - double_.y;
                    double d5 = d3 * d3 + d4 * d4;
                    if (d5 == 0.0) {
                        d = 0.1;
                        d2 = 0.1;
                    } else if (d5 < 40000.0) {
                        d = d3 / d5;
                        d2 = d4 / d5;
                    }
                    double d6 = Math.max(cellView.getBounds().getWidth(), cellView2.getBounds().getWidth());
                    double d7 = Math.max(cellView.getBounds().getHeight(), cellView2.getBounds().getHeight());
                    d6 *= 4.0;
                    d7 *= 4.0;
                    d6 = d6 * d6 / 100.0;
                    d7 = d7 * d7 / 100.0;
                    d6 = Math.max(d6, d7);
                    if (Math.random() > 0.3) {
                        this.moveView(cellView, d * d6, d2 * d7);
                        this.moveView(cellView2, -d * d7, -d2 * d6);
                    } else {
                        this.moveView(cellView, d * d6 * 3.0, d2 * d7 * 3.0);
                        this.moveView(cellView2, -d * d6, -d2 * d7 * 3.0);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public void startDamper() {
        this.damping = true;
    }

    public void stopDamper() {
        this.damping = false;
        this.damper = 1.0;
    }

    public void resetDamper() {
        this.damping = true;
        this.damper = 1.0;
    }

    public void setDamper(double d) {
        this.damper = d;
    }

    public void damp() {
        if (this.damping && this.motionRatio <= 0.001) {
            if ((this.maxMotion < 0.2 || this.maxMotion > 1.0 && this.damper < 0.9) && this.damper > 0.01) {
                this.damper -= 0.01;
            } else if (this.maxMotion < 0.4 && this.damper > 0.003) {
                this.damper -= 0.003;
            } else if (this.damper > 1.0E-4) {
                this.damper -= 1.0E-4;
            }
        }
        if (this.maxMotion < 0.001 && this.damping) {
            this.damper = 0.0;
        }
    }

    private synchronized void moveNodes() {
        this.lastMaxMotion = this.maxMotion;
        double d = 0.0;
        Object[] objectArray = this.graph.getVertices(this.graph.getAll());
        int n = 0;
        while (n < objectArray.length) {
            CellView cellView = this.graph.getGraphLayoutCache().getMapping(objectArray[n], false);
            if (cellView != null) {
                Rectangle rectangle = GraphConstants.getBounds(cellView.getAllAttributes());
                Point2D.Double double_ = this.getDelta(cellView);
                Point2D.Double double_2 = this.getPosition(cellView);
                double d2 = double_.getX();
                double d3 = double_.getY();
                double_.setLocation((d2 *= this.damper) / 2.0, (d3 *= this.damper) / 2.0);
                double d4 = Math.sqrt(d2 * d2 + d3 * d3);
                if (GraphConstants.isMoveable(cellView.getAllAttributes()) && !this.graph.isCellSelected(objectArray[n]) && (d2 != 0.0 || d3 != 0.0)) {
                    double_2.x += Math.max(-5.0, Math.min(5.0, d2));
                    double_2.y += Math.max(-5.0, Math.min(5.0, d3));
                    rectangle.x = Math.max(0, (int)double_2.x - rectangle.width / 2);
                    rectangle.y = Math.max(0, (int)double_2.y - rectangle.height / 2);
                    this.repaintNeeded = true;
                    Object[] objectArray2 = DefaultGraphModel.getEdges(this.graph.getModel(), new Object[]{cellView.getCell()}).toArray();
                    CellView[] cellViewArray = this.graph.getGraphLayoutCache().getMapping(objectArray2, false);
                    int n2 = 0;
                    while (n2 < cellViewArray.length) {
                        if (cellViewArray[n2] instanceof EdgeView) {
                            ((EdgeView)cellViewArray[n2]).update();
                        }
                        ++n2;
                    }
                }
                d = Math.max(d4, d);
            }
            ++n;
        }
        this.maxMotion = d;
        this.motionRatio = this.maxMotion > 0.0 ? this.lastMaxMotion / this.maxMotion - 1.0 : 0.0;
        this.damp();
    }

    private synchronized void relax() {
        int n = 0;
        while (n < 10) {
            this.relaxEdges();
            this.avoidLabels();
            this.moveNodes();
            ++n;
        }
        if (this.rigidity != this.newRigidity) {
            this.rigidity = this.newRigidity;
        }
        if (this.repaintNeeded) {
            this.graph.repaint();
            this.repaintNeeded = false;
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.relaxer == thread && this.allowedToRun) {
            this.relax();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public void start() {
        this.relaxer = new Thread(this);
        this.allowedToRun = true;
        this.relaxer.start();
    }

    public boolean isRunning() {
        if (this.relaxer != null) {
            return this.relaxer.isAlive();
        }
        return false;
    }

    public void stop() {
        this.allowedToRun = false;
        this.relaxer = null;
    }

    public Point2D.Double getPosition(CellView cellView) {
        Point2D.Double double_ = (Point2D.Double)this.positions.get(cellView);
        Rectangle rectangle = GraphConstants.getBounds(cellView.getAllAttributes());
        if (rectangle == null) {
            return null;
        }
        Point2D.Double double_2 = new Point2D.Double(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        if (double_ != null) {
            if (Math.abs(double_.x - double_2.x) > 5.0 || Math.abs(double_.y - double_2.y) > 5.0) {
                double_.setLocation(double_2.x, double_2.y);
            }
            return double_;
        }
        this.positions.put(cellView, double_2);
        return double_2;
    }

    public Point2D.Double getDelta(CellView cellView) {
        Point2D.Double double_ = (Point2D.Double)this.deltas.get(cellView);
        if (double_ == null) {
            double_ = new Point2D.Double(0.0, 0.0);
            this.deltas.put(cellView, double_);
        }
        return double_;
    }

    public void moveView(CellView cellView, double d, double d2) {
        Point2D.Double double_ = this.getDelta(cellView);
        double_.setLocation(double_.getX() + d, double_.getY() + d2);
    }
}

