/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import org.jgraph.GPGraphpad;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;
import org.jgraph.pad.actions.AbstractActionListCell;
import org.jgraph.pad.actions.AbstractActionListCellColor;
import org.jgraph.pad.resources.Translator;

public class FormatFillColorList
extends AbstractActionListCellColor {
    public FormatFillColorList(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
    }

    public FormatFillColorList(GPGraphpad gPGraphpad, String string) {
        super(gPGraphpad, string);
    }

    public FormatFillColorList(GPGraphpad gPGraphpad, String string, Icon icon) {
        super(gPGraphpad, string, icon);
    }

    protected void fillCustomItems(Vector vector) {
        int n = 0;
        while (n < this.colors.length) {
            VertexView vertexView = new VertexView(null, AbstractActionListCell.dummyGraph, AbstractActionListCell.dummyGraph.getGraphLayoutCache());
            Map map = GraphConstants.createMap();
            GraphConstants.setBounds(map, new Rectangle(this.point, this.size));
            GraphConstants.setBackground(map, this.colors[n]);
            GraphConstants.setOpaque(map, true);
            vertexView.setAttributes(map);
            vector.add(vertexView);
            ++n;
        }
    }

    protected void fillResetMap(Map map) {
        GraphConstants.setOpaque(map, false);
    }

    protected void fillApplyMap(CellView cellView, Map map) {
        Color color = GraphConstants.getBackground(cellView.getAttributes());
        if (color == null) {
            return;
        }
        GraphConstants.setOpaque(map, true);
        GraphConstants.setBackground(map, color);
    }

    protected void selectAndFillMap(Map map) {
        Color color = JColorChooser.showDialog(this.graphpad.getFrame(), Translator.getString("ColorDialog"), null);
        if (color != null) {
            GraphConstants.setOpaque(map, true);
            GraphConstants.setBackground(map, color);
        }
    }
}

