/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.LayoutAlgorithm;
import org.jgraph.layout.ProgressDialog;
import org.jgraph.pad.resources.Translator;

public class SugiyamaLayoutAlgorithm
implements LayoutAlgorithm {
    protected final boolean verbose = false;
    public static final String SUGIYAMA_VISITED = "SugiyamaVisited";
    public static final String SUGIYAMA_CELL_WRAPPER = "SugiyamaCellWrapper";
    protected int gridAreaSize = Integer.MIN_VALUE;
    protected ProgressDialog dlgProgress = new ProgressDialog((Frame)null, Translator.getString("Progress") + ":", false);
    Vector movements = null;
    int movementsCurrentLoop = -1;
    int movementsMax = Integer.MIN_VALUE;
    int iteration = 0;

    public void perform(JGraph jGraph, boolean bl, Properties properties) {
        Object[] objectArray = bl ? jGraph.getRoots() : jGraph.getSelectionCells();
        CellView[] cellViewArray = jGraph.getGraphLayoutCache().getMapping(objectArray);
        Point point = new Point();
        point.x = Integer.parseInt(properties.getProperty("HorizontalSpacing"));
        point.y = Integer.parseInt(properties.getProperty("VerticalSpacing"));
        this.dlgProgress.setVisible(true);
        Vector vector = this.searchRoots(jGraph, cellViewArray);
        if (vector.size() == 0) {
            return;
        }
        Vector vector2 = this.fillLevels(jGraph, cellViewArray, vector);
        this.solveEdgeCrosses(jGraph, vector2);
        this.moveToBarycenter(jGraph, cellViewArray, vector2);
        Point point2 = this.findMinimumAndSpacing(cellViewArray, point);
        this.drawGraph(jGraph, vector2, point2, point);
        this.dlgProgress.setVisible(false);
    }

    protected void displayEdgeCrossesValues(Vector vector) {
        System.out.println("----------------Edge Crosses Indicator Values");
        int n = 0;
        while (n < vector.size() - 1) {
            Vector vector2 = (Vector)vector.get(n);
            System.out.print("Level (" + n + "):");
            int n2 = 0;
            while (n2 < vector2.size()) {
                CellWrapper cellWrapper = (CellWrapper)vector2.get(n2);
                System.out.print(NumberFormat.getNumberInstance().format(cellWrapper.getEdgeCrossesIndicator()) + " - ");
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    protected void displayGridPositions(Vector vector) {
        System.out.println("----------------GridPositions");
        int n = 0;
        while (n < vector.size() - 1) {
            Vector vector2 = (Vector)vector.get(n);
            System.out.print("Level (" + n + "):");
            int n2 = 0;
            while (n2 < vector2.size()) {
                CellWrapper cellWrapper = (CellWrapper)vector2.get(n2);
                System.out.print(NumberFormat.getNumberInstance().format(cellWrapper.getGridPosition()) + " - ");
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    protected void displayPriorities(Vector vector) {
        System.out.println("----------------down Priorities");
        int n = 0;
        while (n < vector.size() - 1) {
            Vector vector2 = (Vector)vector.get(n);
            System.out.print("Level (" + n + "):");
            int n2 = 0;
            while (n2 < vector2.size()) {
                CellWrapper cellWrapper = (CellWrapper)vector2.get(n2);
                System.out.print(cellWrapper.getPriority() + " - ");
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    protected Vector searchRoots(JGraph jGraph, CellView[] cellViewArray) {
        Vector<CellView> vector = new Vector<CellView>(cellViewArray.length);
        Vector vector2 = new Vector();
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n] instanceof VertexView) {
                VertexView vertexView = (VertexView)cellViewArray[n];
                vertexView.getAttributes().remove(SUGIYAMA_VISITED);
                vector.add(cellViewArray[n]);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            VertexView vertexView = (VertexView)vector.get(n2);
            if (vertexView.getAttributes().get(SUGIYAMA_VISITED) == null) {
                this.searchRoots(jGraph, vertexView, vector2);
            }
            ++n2;
        }
        if (vector2.size() == 0) {
            JOptionPane.showMessageDialog(null, Translator.getString("TheGraphIsNotADAG"), null, 0);
        }
        return vector2;
    }

    protected void searchRoots(JGraph jGraph, VertexView vertexView, Vector vector) {
        if (vertexView.getAttributes().get(SUGIYAMA_VISITED) != null) {
            return;
        }
        vertexView.getAttributes().put(SUGIYAMA_VISITED, new Boolean(true));
        GraphModel graphModel = jGraph.getModel();
        Object object = vertexView.getCell();
        int n = graphModel.getChildCount(object);
        int n2 = 0;
        while (n2 < n) {
            Object object2 = graphModel.getChild(object, n2);
            boolean bl = true;
            Iterator iterator = graphModel.edges(object2);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (graphModel.getTarget(e) != object2) continue;
                Object object3 = graphModel.getSource(e);
                Object object4 = graphModel.getParent(object3);
                CellView cellView = jGraph.getGraphLayoutCache().getMapping(object4, false);
                if (!(cellView instanceof VertexView)) continue;
                this.searchRoots(jGraph, (VertexView)cellView, vector);
                bl = false;
            }
            if (bl) {
                vector.add(vertexView);
            }
            ++n2;
        }
    }

    protected Vector fillLevels(JGraph jGraph, CellView[] cellViewArray, Vector vector) {
        Object object;
        Vector vector2 = new Vector();
        int n = 0;
        while (n < cellViewArray.length) {
            object = cellViewArray[n];
            if (object != null) {
                object.getAttributes().remove(SUGIYAMA_VISITED);
            }
            ++n;
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            VertexView vertexView = (VertexView)object.nextElement();
            this.fillLevels(jGraph, vector2, 0, vertexView);
        }
        return vector2;
    }

    protected void fillLevels(JGraph jGraph, Vector vector, int n, VertexView vertexView) {
        if (vertexView == null) {
            return;
        }
        if (vector.size() == n) {
            vector.insertElementAt(new Vector(), n);
        }
        if (vertexView.getAttributes().get(SUGIYAMA_VISITED) != null) {
            return;
        }
        vertexView.getAttributes().put(SUGIYAMA_VISITED, new Boolean(true));
        Vector vector2 = (Vector)vector.get(n);
        int n2 = vector2.size();
        CellWrapper cellWrapper = new CellWrapper(n, n2, vertexView);
        vector2.add(cellWrapper);
        vertexView.getAttributes().put(SUGIYAMA_CELL_WRAPPER, cellWrapper);
        Object object = vertexView.getCell();
        GraphModel graphModel = jGraph.getModel();
        int n3 = graphModel.getChildCount(object);
        int n4 = 0;
        while (n4 < n3) {
            Object object2 = graphModel.getChild(object, n4);
            Iterator iterator = graphModel.edges(object2);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (object2 != graphModel.getSource(e)) continue;
                Object object3 = graphModel.getTarget(e);
                Object object4 = graphModel.getParent(object3);
                VertexView vertexView2 = (VertexView)jGraph.getGraphLayoutCache().getMapping(object4, false);
                this.fillLevels(jGraph, vector, n + 1, vertexView2);
            }
            ++n4;
        }
        if (vector2.size() > this.gridAreaSize) {
            this.gridAreaSize = vector2.size();
        }
    }

    protected Point findMinimumAndSpacing(CellView[] cellViewArray, Point point) {
        try {
            int n = 1000000;
            int n2 = 1000000;
            int n3 = 0;
            while (n3 < cellViewArray.length) {
                CellView cellView = cellViewArray[n3];
                if (cellView != null) {
                    Rectangle rectangle = cellView.getBounds();
                    try {
                        if (rectangle.x < n) {
                            n = rectangle.x;
                        }
                        if (rectangle.y < n2) {
                            n2 = rectangle.y;
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("---------> ERROR in calculateValues.");
                        exception.printStackTrace();
                    }
                }
                ++n3;
            }
            return new Point(n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected void updateProgress4Movements() {
        this.movements.add(new Integer(this.movementsCurrentLoop));
        ++this.iteration;
        if (this.movementsCurrentLoop > this.movementsMax) {
            this.movementsMax = this.movementsCurrentLoop;
        }
        if (this.movements.size() > 1) {
            this.dlgProgress.setValue(this.movements.size() - 1);
        }
    }

    protected void solveEdgeCrosses(JGraph jGraph, Vector vector) {
        this.dlgProgress.setMessage(Translator.getString("SolvingCrossOverPoints"));
        this.movements = new Vector(100);
        this.movementsCurrentLoop = -1;
        this.movementsMax = Integer.MIN_VALUE;
        this.iteration = 0;
        while (this.movementsCurrentLoop != 0) {
            this.movementsCurrentLoop = 0;
            int n = 0;
            while (n < vector.size() - 1) {
                this.movementsCurrentLoop += this.solveEdgeCrosses(jGraph, true, vector, n);
                ++n;
            }
            int n2 = vector.size() - 1;
            while (n2 >= 1) {
                this.movementsCurrentLoop += this.solveEdgeCrosses(jGraph, false, vector, n2);
                --n2;
            }
            this.updateProgress4Movements();
        }
        this.dlgProgress.setToMaximum();
    }

    protected int solveEdgeCrosses(JGraph jGraph, boolean bl, Vector vector, int n) {
        Vector vector2 = (Vector)vector.get(n);
        int n2 = 0;
        Object[] objectArray = vector2.toArray();
        Collections.sort(vector2);
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (((CellWrapper)objectArray[n3]).getEdgeCrossesIndicator() != ((CellWrapper)vector2.get(n3)).getEdgeCrossesIndicator()) {
                ++n2;
            }
            ++n3;
        }
        GraphModel graphModel = jGraph.getModel();
        int n4 = vector2.size() - 1;
        while (n4 >= 0) {
            CellWrapper cellWrapper = (CellWrapper)vector2.get(n4);
            VertexView vertexView = cellWrapper.getVertexView();
            Object object = vertexView.getCell();
            int n5 = graphModel.getChildCount(object);
            int n6 = 0;
            while (n6 < n5) {
                Object object2 = graphModel.getChild(object, n6);
                Iterator iterator = graphModel.edges(object2);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Object object3 = null;
                    if (bl && object2 == graphModel.getSource(e)) {
                        object3 = graphModel.getTarget(e);
                    }
                    if (!bl && object2 == graphModel.getTarget(e)) {
                        object3 = graphModel.getSource(e);
                    }
                    if (object3 == null) continue;
                    Object object4 = graphModel.getParent(object3);
                    VertexView vertexView2 = (VertexView)jGraph.getGraphLayoutCache().getMapping(object4, false);
                    if (vertexView2 == null) continue;
                    CellWrapper cellWrapper2 = (CellWrapper)vertexView2.getAttributes().get(SUGIYAMA_CELL_WRAPPER);
                    if (bl && cellWrapper2 != null && cellWrapper2.getLevel() > n) {
                        cellWrapper2.addToEdgeCrossesIndicator(cellWrapper.getEdgeCrossesIndicator());
                    }
                    if (bl || cellWrapper2 == null || cellWrapper2.getLevel() >= n) continue;
                    cellWrapper2.addToEdgeCrossesIndicator(cellWrapper.getEdgeCrossesIndicator());
                }
                ++n6;
            }
            --n4;
        }
        return n2;
    }

    protected void moveToBarycenter(JGraph jGraph, CellView[] cellViewArray, Vector vector) {
        Object object;
        GraphModel graphModel = jGraph.getModel();
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n] instanceof VertexView) {
                VertexView vertexView = (VertexView)cellViewArray[n];
                object = (CellWrapper)vertexView.getAttributes().get(SUGIYAMA_CELL_WRAPPER);
                Object object2 = vertexView.getCell();
                int n2 = graphModel.getChildCount(object2);
                int n3 = 0;
                while (n3 < n2) {
                    Object object3 = graphModel.getChild(object2, n3);
                    Iterator iterator = graphModel.edges(object3);
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        Object object4 = null;
                        if (object3 == graphModel.getSource(e)) {
                            object4 = graphModel.getTarget(e);
                        } else {
                            if (object3 != graphModel.getTarget(e)) continue;
                            object4 = graphModel.getSource(e);
                        }
                        Object object5 = graphModel.getParent(object4);
                        VertexView vertexView2 = (VertexView)jGraph.getGraphLayoutCache().getMapping(object5, false);
                        if (vertexView2 == null || vertexView2 == vertexView) continue;
                        CellWrapper cellWrapper = (CellWrapper)vertexView2.getAttributes().get(SUGIYAMA_CELL_WRAPPER);
                        if (object == null || cellWrapper == null || ((CellWrapper)object).level == cellWrapper.level) continue;
                        ++((CellWrapper)object).priority;
                    }
                    ++n3;
                }
            }
            ++n;
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            object = (Vector)vector.get(n4);
            int n5 = 0;
            while (n5 < ((Vector)object).size()) {
                CellWrapper cellWrapper = (CellWrapper)((Vector)object).get(n5);
                cellWrapper.setGridPosition(n5);
                ++n5;
            }
            ++n4;
        }
        this.movements = new Vector(100);
        this.movementsCurrentLoop = -1;
        this.movementsMax = Integer.MIN_VALUE;
        this.iteration = 0;
        while (this.movementsCurrentLoop != 0) {
            this.movementsCurrentLoop = 0;
            int n6 = 1;
            while (n6 < vector.size()) {
                this.movementsCurrentLoop += this.moveToBarycenter(jGraph, vector, n6);
                ++n6;
            }
            int n7 = vector.size() - 1;
            while (n7 >= 0) {
                this.movementsCurrentLoop += this.moveToBarycenter(jGraph, vector, n7);
                --n7;
            }
            this.updateProgress4Movements();
        }
    }

    protected int moveToBarycenter(JGraph jGraph, Vector vector, int n) {
        int n2 = 0;
        Vector vector2 = (Vector)vector.get(n);
        GraphModel graphModel = jGraph.getModel();
        int n3 = 0;
        while (n3 < vector2.size()) {
            CellWrapper cellWrapper = (CellWrapper)vector2.get(n3);
            float f = 0.0f;
            float f2 = 0.0f;
            VertexView vertexView = cellWrapper.getVertexView();
            Object object = vertexView.getCell();
            int n4 = graphModel.getChildCount(object);
            int n5 = 0;
            while (n5 < n4) {
                Object object2 = graphModel.getChild(object, n5);
                Iterator iterator = graphModel.edges(object2);
                while (iterator.hasNext()) {
                    CellWrapper cellWrapper2;
                    Object e = iterator.next();
                    Object object3 = null;
                    if (object2 == graphModel.getSource(e)) {
                        object3 = graphModel.getTarget(e);
                    } else {
                        if (object2 != graphModel.getTarget(e)) continue;
                        object3 = graphModel.getSource(e);
                    }
                    Object object4 = graphModel.getParent(object3);
                    VertexView vertexView2 = (VertexView)jGraph.getGraphLayoutCache().getMapping(object4, false);
                    if (vertexView2 == null || (cellWrapper2 = (CellWrapper)vertexView2.getAttributes().get(SUGIYAMA_CELL_WRAPPER)) == cellWrapper || cellWrapper2 == null || cellWrapper2.getLevel() == n) continue;
                    f += (float)cellWrapper2.getGridPosition();
                    f2 += 1.0f;
                }
                ++n5;
            }
            if (f2 > 0.0f) {
                float f3 = f / f2;
                int n6 = Math.round(f3);
                boolean bl = n6 > cellWrapper.getGridPosition();
                boolean bl2 = true;
                while (n6 != cellWrapper.getGridPosition() && bl2) {
                    int n7 = cellWrapper.getGridPosition();
                    bl2 = this.move(bl, vector2, n3, cellWrapper.getPriority());
                    if (!bl2) continue;
                    ++n2;
                }
            }
            ++n3;
        }
        return n2;
    }

    protected boolean move(boolean bl, Vector vector, int n, int n2) {
        CellWrapper cellWrapper = (CellWrapper)vector.get(n);
        boolean bl2 = false;
        int n3 = n + (bl ? 1 : -1);
        int n4 = cellWrapper.getGridPosition() + (bl ? 1 : -1);
        if (0 > n4 || n4 >= this.gridAreaSize) {
            return false;
        }
        if (bl && n == vector.size() - 1 || !bl && n == 0) {
            bl2 = true;
        } else {
            CellWrapper cellWrapper2 = (CellWrapper)vector.get(n3);
            int n5 = cellWrapper2.getPriority();
            if (cellWrapper2.getGridPosition() == n4) {
                if (n5 >= n2) {
                    return false;
                }
                bl2 = this.move(bl, vector, n3, n2);
            } else {
                bl2 = true;
            }
        }
        if (bl2) {
            cellWrapper.setGridPosition(n4);
        }
        return bl2;
    }

    protected void drawGraph(JGraph jGraph, Vector vector, Point point, Point point2) {
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.get(n);
            int n2 = 0;
            while (n2 < vector2.size()) {
                CellWrapper cellWrapper = (CellWrapper)vector2.get(n2);
                VertexView vertexView = cellWrapper.vertexView;
                vertexView.getAttributes().remove(SUGIYAMA_CELL_WRAPPER);
                vertexView.getAttributes().remove(SUGIYAMA_VISITED);
                cellWrapper.vertexView = null;
                if (vertexView != null) {
                    Rectangle rectangle = (Rectangle)vertexView.getBounds().clone();
                    rectangle.x = point.x + point2.x * cellWrapper.getGridPosition();
                    rectangle.y = point.y + point2.y * n;
                    Object object = vertexView.getCell();
                    Map map = GraphConstants.createMap();
                    GraphConstants.setBounds(map, rectangle);
                    hashtable.put(object, map);
                }
                ++n2;
            }
            ++n;
        }
        jGraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    class CellWrapper
    implements Comparable {
        private double edgeCrossesIndicator = 0.0;
        private int additions = 0;
        int level = 0;
        int gridPosition = 0;
        int priority = 0;
        VertexView vertexView = null;

        CellWrapper(int n, double d, VertexView vertexView) {
            this.level = n;
            this.edgeCrossesIndicator = d;
            this.vertexView = vertexView;
            ++this.additions;
        }

        VertexView getVertexView() {
            return this.vertexView;
        }

        void resetEdgeCrossesIndicator() {
            this.edgeCrossesIndicator = 0.0;
            this.additions = 0;
        }

        double getEdgeCrossesIndicator() {
            if (this.additions == 0) {
                return 0.0;
            }
            return this.edgeCrossesIndicator / (double)this.additions;
        }

        void addToEdgeCrossesIndicator(double d) {
            this.edgeCrossesIndicator += d;
            ++this.additions;
        }

        int getLevel() {
            return this.level;
        }

        int getGridPosition() {
            return this.gridPosition;
        }

        void setGridPosition(int n) {
            this.gridPosition = n;
        }

        void incrementPriority() {
            ++this.priority;
        }

        int getPriority() {
            return this.priority;
        }

        public int compareTo(Object object) {
            if (((CellWrapper)object).getEdgeCrossesIndicator() == this.getEdgeCrossesIndicator()) {
                return 0;
            }
            double d = ((CellWrapper)object).getEdgeCrossesIndicator() - this.getEdgeCrossesIndicator();
            return (int)(d * 1000.0);
        }
    }
}

