/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;

public class DefaultGraphCell
extends DefaultMutableTreeNode
implements GraphCell,
Cloneable {
    public static final Rectangle defaultBounds = new Rectangle(10, 10, 20, 20);
    protected Map attributes = GraphConstants.createMap();

    public DefaultGraphCell() {
        this(null);
    }

    public DefaultGraphCell(Object object) {
        this(object, null);
    }

    public DefaultGraphCell(Object object, MutableTreeNode[] mutableTreeNodeArray) {
        super(object, true);
        this.setUserObject(object);
        if (mutableTreeNodeArray != null) {
            int n = 0;
            while (n < mutableTreeNodeArray.length) {
                this.add(mutableTreeNodeArray[n]);
                ++n;
            }
        }
        GraphConstants.setBounds(this.attributes, defaultBounds);
    }

    public DefaultGraphCell(Object object, boolean bl) {
        super(object, bl);
    }

    public void setUserObject(Object object) {
        if (this.userObject instanceof ValueChangeHandler) {
            ((ValueChangeHandler)this.userObject).valueChanged(object);
        } else {
            super.setUserObject(object);
        }
        object = this.getUserObject();
        if (object == null) {
            GraphConstants.setValue(this.attributes, "");
        } else {
            GraphConstants.setValue(this.attributes, object);
        }
    }

    public List getChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Map changeAttributes(Map map) {
        Object object;
        Map map2 = GraphConstants.applyMap(map, this.attributes);
        Object object2 = GraphConstants.getValue(this.attributes);
        if (this.userObject != null && object2 == null) {
            GraphConstants.setValue(this.attributes, this.userObject);
        } else if (this.userObject instanceof ValueChangeHandler) {
            object = ((ValueChangeHandler)this.userObject).valueChanged(object2);
            if (object == null || !object2.toString().equals(object.toString())) {
                GraphConstants.setValue(map2, object);
            }
            GraphConstants.setValue(this.attributes, this.userObject);
        } else {
            this.userObject = object2;
        }
        object = GraphConstants.getBounds(this.attributes);
        if (object == null) {
            GraphConstants.setBounds(this.attributes, defaultBounds);
        }
        return map2;
    }

    public void setAttributes(Map map) {
        this.attributes = map;
    }

    public Object clone() {
        DefaultGraphCell defaultGraphCell = (DefaultGraphCell)super.clone();
        defaultGraphCell.attributes = new Hashtable(this.attributes);
        defaultGraphCell.userObject = this.cloneUserObject();
        return defaultGraphCell;
    }

    protected Object cloneUserObject() {
        if (this.userObject instanceof ValueChangeHandler) {
            return ((ValueChangeHandler)this.userObject).clone();
        }
        return this.userObject;
    }

    public static interface ValueChangeHandler {
        public Object valueChanged(Object var1);

        public Object clone();
    }
}

