<?php // -*- coding:utf-8 -*-
// parameters:
// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated
// comments   : generate all comments (equal to close&module)
// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made
// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)
// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer
// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)
// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)
// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate langauage 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate langauage 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Project Group for " => "Project Groep voor ",
"Project Admin Group for " => "Projectbeheer Groep voor ",
"requested a reset of the password for the" => "heeft een reset van het wachtwoord gevraagd voor de",
"The old password remains active until you activate the new one by following this link:" => "Het oude wachtwoord blijft actief totdat u het nieuwe wachtwoord activeert door deze koppeling te volgen:",
"This is only a temporary password. After you logged in with it, you will get to the 'change password' dialog." => "Dit is slechts een tijdelijk wachtwoord. Nadat u zich heeft aangemeld, zal u een 'Verander wachtwoord' venster te zien krijgen.",
"List Courses" => "Lijst Klassen",
"Use Quote plugin for quoting" => "Gebruik Quote plugin om tekst aan te halen",
"Hide disabled sections" => "Verberg uitgeschakelde secties",
"Show disabled sections" => "Toon uitgeschakelde secties",
"Users choose project categories" => "Gebruikers kiezen projectcategorie&euml;n",
"Prefix for Project Admin groups" => "Prefix voor Project Admin groepen",
"Prefix for Project groups" => "Prefix for Project groepen",
"Prefix for Wiki project home page" => "Prefix voor Wiki project thuispagina",
"Prefix for File Galleries" => "Prefix voor Bestandgalerijen",
"Project Admins group template" => "Project Beheerders groep sjabloon",
"Create New Group" => "Maak Nieuwe Groep aan",
"Project Members group template" => "Project Leden groep sjabloon",
"Batch upload (CSV file<a {popup text='login,password,email'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Bulk aanlevering (CSV bestand<a {popup text='login,password,email'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}hulp",
"slideshow_p" => "slideshow_p",
"slideshow backward" => "slideshow achterwaarts",
"slideshow_n" => "slideshow_n",
"quater" => "kwartaal",
"{literal}{MODULE(module=>some_module)}text{MODULE}{/literal}  can be used to insert the output of module \"some_module\" into your Wiki page. See <a href=\"{\$helpurl}PluginModule\">PluginModule</a> for more information. " => "{literal}{MODULE(module=>some_module)}text{MODULE}{/literal} kan worden gebruikt om de uitvoer van de module \"some_module\" op te nemen in uw Wiki pagina. Zie <a href=\"{\$helpurl}PluginModule\">PluginModule</a> voor meet informatie. ",
"{literal}{CODE()}some code{CODE} {/literal} will render \"some code\" as program code. This plugin has other options; see <a href=\"{\$helpurl}PluginCode\">PluginCode</a>." => "{literal}{CODE()}some code{CODE} {/literal} zal \"some code\" herwerken als programma code. Deze plugin heeft andere opties; zie <a href=\"{\$helpurl}PluginCode\">PluginCode</a>.",
"Project Object Created Successfully" => "Projectobject met succes aangemaakt",
"Project Name:" => "Projectnaam:",
"Project Description:" => "Projectbeschrijving:",
"Project Active" => "Actief Project",
"Current Objects:" => "Huidige Objecten:",
"Add a File Gallery" => "Voeg een Bestandgalerij toe",
"Permission" => "Permissie",
"Project Admin" => "Project Beheerder",
"Project Members" => "Project Leden",
"Not Set" => "Niet gezet",
"Number Members" => "Aantal leden",
"Number Admins" => "Aantal beheerder",
"No projects found" => "Geen projecten gevonden",
"Edit Project" => "Bewerk Project",
"Add Blog" => "Voeg Journaal toe",
"Add Articles" => "Voeg Artikelen toe",
"Add Calendar" => "Voeg Kalender toe",
"Add FAQ" => "Voeg FAQ toe",
"Add File Gallery" => "Voeg Bestandgalerij toe",
"Add Forum" => "Voeg Forum toe",
"Add Image Gallery" => "Voeg Afbeeldinggalerij",
"Add Newsletter" => "Voeg Nieuwsbrief toe",
"Add URL" => "Voeg URL toe",
"Edit information" => "Bewerk informatie",
"Not rated yet" => "Nog niet beoordeeld",
"Jukebox preference" => "Jukebox voorkeuren",
"Removed %s from group %s" => "Verwijderd %s uit groep %s",
"Day" => "Dag",
"Invalid username or activation code" => "Ongeldige gebruikersnaam of activatie code",
"Feature" => "Kenmerk",
"Jukebox" => "Jukebox",
"TikiTabs" => "TikiTabs",
"Tracks" => "Tracks",
"Genre" => "Genre",
"LDAP Host" => "LDAP Host",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiVerschil::toepassen: verschil in lijnnummers: %s != %s",
"WikiDiff::_check: failed" => "WikiVerschil::_controle: mislukt",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiVerschil::_controle: bewerkingsvolgorde is sub-optimaal",
"WikiDiff Okay: LCS = %s" => "WikiVerschil Ok: LCS = %s",
"no description" => "geen beschrijving",
"Textarea options: options,width,height,max with option is 1 or 0, rest is size indicated in chars and lines, max is the maximum number of characters that can be saved." => "Textarea opties: opties,breedte,hoogte,max met optie is 1 of 0, de rest is de grootte aangegeven in karakters en lijnen, max is het maximum aantal karakters kan worden opgeslagen.",
"Image options: xSize,ySize indicated in pixels." => "Afbeelding opties: xSize,ySize opgegeven in pixels.",
"Item Link options: trackerId,fieldId links to item from trackerId which fieldId matches the content of that field." => "Item Koppeling opties: trackerId,fieldId verwijst naar trackerId wiens fieldId overeenkomt met de inhoud van dat veld.",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere." => "Items lijst opties: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere toont de lijst van displayFieldIdThere van items in tracker trackerId wiens fieldIdThere overeenkomt met fieldIdHere.",
"~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insluiten artikelen in een wikipagina",
"You need to supply information for : " => "U moet informatie aanleveren voor : ",
"someone coming from IP Address" => "iemand komende van IP Adres",
"requested a reminder of the password for the" => "heeft een herinnering aangevraagd voor het password voor de",
"Information:" => "Informatie:",
"Please" => "Aub",
"log in" => "meldt u aan",
"to access full functionalities" => "om toegang te krijgen tot de volledige functionaliteit",
"Skip to navigation" => "Sla over en ga naar navigatie",
"Jukebox settings" => "Jukebox instellingen",
"Jukebox tracks location" => "Jukebox tracks locatie",
"Jukebox features" => "Jukebox onderdelen",
"Default ordering for album listing" => "Standaardvolgorde van albumlijst",
"Album title (asc)" => "Albumtitel (stijgend)",
"Number of tracks (desc)" => "Aantal tracks (dalend)",
"In album listing show user as" => "In de albumlijst toon de gebruiker als",
"Jukebox listing configuration (when listing available albums)" => "Jukeboxlijst configuratie (bij het opsommen van beschikbare albums)",
"Remind passwords by email" => "Wachtwoorden in herinnering brengen via e-mail",
"LDAP Port" => "LDAP Poort",
"Like pages" => "Gelijkaardige pagina's",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Gebruik {literal}{{/literal}ed id=naam} or {literal}{{/literal}ted id=naam} om een dynamische zone in te voegen",
"Category: wiki, trackers, etc." => "Categorie: wiki, trackers, etc.",
"Field is hidden? (visible by admin only)" => "Veld is verborgen? (enkel zichtbaar voor beheerders)",
"Emphasis" => "Nadruk",
"italics" => "cursief",
"both" => "beide",
"use ...page... to separate pages" => "gebruik ...page... om te pagineren",
"make_headings" => "maak_titels",
"underlines text" => "onderstreept tekst",
"creates an editable drawing named foo" => "maak een bewerkbare tekening aan genaamd foo",
"Simple box" => "Eenvoudig tekstkader",
"Will display using the indicated HTML color" => "Zal getoond worden met de aangegeven HTML-kleur",
"Center" => "Centreren",
"Will display the text centered" => "Zal de tekst gecentreerd tonen",
"Insert Module Output" => "Voeg Module Uitvoer in",
"Rendering Program Code" => "Vertaling programmacode",
"Activs" => "Activn",
"Ins" => "Inc",
"time" => "tijd",
"You have to create a gallery first!" => "U moet eerst een galerij aanmaken!",
"You do not have permission to write the template" => "U heeft geen toestemming om de sjabloon te schrijven",
"Go to your <a href=\"tiki-friends.php\">friendship network</a> to accept or refuse this request" => "Ga naar uw <a href=\"tiki-friends.php\">vriendschapsnetwerk</a> om dit verzoek te aanvaarden of te weigeren",
"A new password and your IP address has been sent " => "Een nieuw wachtwoord en IP adres werden verzonden ",
"Invalid variable value : " => "Ongeldige waarde voor variabele : ",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Catalan_Countries" => "Catalan_Countries",
// "Finnish" => "Finnish",
// "Cannot write to this file: " => "Cannot write to this file: ",
// "This poll is closed." => "This poll is closed.",
// "Tracker item" => "Tracker item",
// "index" => "index",
// "Status:" => "Status:",
// "(unchanged)" => "(unchanged)",
// "field is not numeric" => "field is not numeric",
// "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode.",
// "country selector" => "country selector",
// "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag",
// "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels.",
// "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing",
// "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing",
// "Added:" => "Added:",
// "Removed:" => "Removed:",
// "Remaining:" => "Remaining:",
// "Old:" => "Old:",
// "New:" => "New:",
// "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage",
// "Formula" => "Formula",
// "No formula specified." => "No formula specified.",
// "Impossible to render the graphic." => "Impossible to render the graphic.",
// "View graphic" => "View graphic",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Displays a map" => "Displays a map",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Clickable Skype link" => "Clickable Skype link",
// "Displays text between an html tag" => "Displays text between an html tag",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "All fields must be from the same tracker" => "All fields must be from the same tracker",
// "Filters the items of a tracker, fields are indicated with numeric ids." => "Filters the items of a tracker, fields are indicated with numeric ids.",
// "missing parameters" => "missing parameters",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "incorrect filterfield" => "incorrect filterfield",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored.<br />" => "A wildcard pattern of originating pages to be ignored.<br />",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated.<br />" => "The character, by which ignored patterns are separated.<br />",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list.<br />" => "Whether to include external wikis in the list.<br />",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Collect either originating or wanted pages in a cell and display them in the second column.<br />",
// "Switch-on debug output with details about the items.<br />" => "Switch-on debug output with details about the items.<br />",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />",
// "A custom filter for wanted pages to be listed (only used when level=>custom).<br />" => "A custom filter for wanted pages to be listed (only used when level=>custom).<br />",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output." => "End of debug output.",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "new posts" => "new posts",
// "new tracker items" => "new tracker items",
// "Invalid server key" => "Invalid server key",
// "Post new message" => "Post new message",
// "Perhaps you were looking for:" => "Perhaps you were looking for:",
// "RSS Calendars" => "RSS Calendars",
// "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now.",
// "To login with your username and password, please follow this link:" => "To login with your username and password, please follow this link:",
// "Tiki User Account Activated" => "Tiki User Account Activated",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in.",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above." => "Important: The old password remains active if you don't click the link above.",
// "Tracker was modified at" => "Tracker was modified at",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "hits last 7 days" => "hits last 7 days",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number !" => "You forgot your Google ad_client number !",
// "Current events" => "Current events",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "local account" => "local account",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "RSS Feeds" => "RSS Feeds",
// "Calendars" => "Calendars",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "on host" => "on host",
// "logout" => "logout",
// "Edit Summary" => "Edit Summary",
// "RSS Trackers" => "RSS Trackers",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "i18n" => "i18n",
// "Post level trackback pings" => "Post level trackback pings",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Calendar manual selection of time/date" => "Calendar manual selection of time/date",
// "Print article" => "Print article",
// "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site.",
// "Google Maps" => "Google Maps",
// "Trackbacks Pings" => "Trackbacks Pings",
// "Redirect On Error" => "Redirect On Error",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Please expect not found help-pages with the default-URL." => "Please expect not found help-pages with the default-URL.",
// "Any help with the documentation is welcome." => "Any help with the documentation is welcome.",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "I18n setup" => "I18n setup",
// "Best Language" => "Best Language",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// " as master" => " as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "Contact" => "Contact",
// "New" => "New",
// "must be turned on and notification is sent to the admin's" => "must be turned on and notification is sent to the admin's",
// "inter-user message inbox" => "inter-user message inbox",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email",
// "Auth Type" => "Auth Type",
// "IMAP/POP3/LDAP Host" => "IMAP/POP3/LDAP Host",
// "IMAP/POP3/LDAP Port" => "IMAP/POP3/LDAP Port",
// "IMAP/POP3 BaseDSN" => "IMAP/POP3 BaseDSN",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/.",
// "Feed for individual tracker items" => "Feed for individual tracker items",
// "Feed for upcoming calendar events" => "Feed for upcoming calendar events",
// "Caching time :" => "Caching time :",
// "seconds (0 = cache inactive)" => "seconds (0 = cache inactive)",
// "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions." => "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions.",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Load page on navigation" => "Load page on navigation",
// "Camera distance" => "Camera distance",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Field of view" => "Field of view",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Spring (connection) size" => "Spring (connection) size",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "Similar" => "Similar",
// "Footnotes" => "Footnotes",
// "Print Page" => "Print Page",
// "Search and replace" => "Search and replace",
// "IP not displayed in history" => "IP not displayed in history",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Spreadsheet" => "Spreadsheet",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "System" => "System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look &amp; feel" => "Look &amp; feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}.",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link.",
// "Use Admin DSN to define the database to be used by the SQL plugin." => "Use Admin DSN to define the database to be used by the SQL plugin.",
// "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones" => "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature.",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.",
// "mn" => "mn",
// "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:",
// "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "parameters" => "parameters",
// "structure" => "structure",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed.",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>.",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "If your Tiki is acting weird, 1st thing to try it to clear your cache below. Also very important to clear your cache after an upgrade (by FTP/SSH if need be)." => "If your Tiki is acting weird, 1st thing to try it to clear your cache below. Also very important to clear your cache after an upgrade (by FTP/SSH if need be).",
// "Field is hidden?" => "Field is hidden?",
// "not hidden" => "not hidden",
// "visible by admin only" => "visible by admin only",
// "editable by admin only" => "editable by admin only",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL",
// "Import/Export CSV Data" => "Import/Export CSV Data",
// "Download CSV export" => "Download CSV export",
// "tracker_{\$trackerId}.csv" => "tracker_{\$trackerId}.csv",
// "Import file" => "Import file",
// "remove from group" => "remove from group",
// "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions",
// "edit included group" => "edit included group",
// "remove users and their userpages" => "remove users and their userpages",
// "Tip: hold down CTRL to select multiple" => "Tip: hold down CTRL to select multiple",
// "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master",
// "Warning: changing the username will require the user to change his password" => "Warning: changing the username will require the user to change his password",
// "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
// "advanced feature" => "advanced feature",
// "level configuration" => "level configuration",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead." => "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead.",
// "Cyclic" => "Cyclic",
// "Allow trackback pings" => "Allow trackback pings",
// "Bold text" => "Bold text",
// "underscores" => "underscores",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Centered text" => "Centered text",
// "colons" => "colons",
// "Underlined text" => "Underlined text",
// "equals" => "equals",
// "Text box" => "Text box",
// "One carat" => "One carat",
// "Will display using the indicated HTML color or color name" => "Will display using the indicated HTML color or color name",
// "make headings" => "make headings",
// "row" => "row",
// "col" => "col",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "Horizontal rule" => "Horizontal rule",
// "to separate pages" => "to separate pages",
// "save only in the theme:" => "save only in the theme:",
// "Delete the copy in the theme:" => "Delete the copy in the theme:",
// "Search " => "Search ",
// "Case Insensitivity" => "Case Insensitivity",
// "replace" => "replace",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "Owner of the gallery" => "Owner of the gallery",
// "Save clicked point" => "Save clicked point",
// "Save current view as default" => "Save current view as default",
// "Reset view to site-wide default" => "Reset view to site-wide default",
// "Users Map" => "Users Map",
// "Tiki installer" => "Tiki installer",
// "MultiTiki setup" => "MultiTiki setup",
// "To add a new virtual host" => "To add a new virtual host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "Please enter your database connection info" => "Please enter your database connection info",
// "Database type" => "Database type",
// "The type of database you intend to use" => "The type of database you intend to use",
// "Host:" => "Host:",
// "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki" => "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki",
// "If you use SQLite, insert the path and filename to your database file" => "If you use SQLite, insert the path and filename to your database file",
// "Database user" => "Database user",
// "Database password" => "Database password",
// "Database name" => "Database name",
// "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names" => "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names",
// "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above" => "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above",
// "Welcome to the installation &amp; upgrade script!" => "Welcome to the installation &amp; upgrade script!",
// "Create database (clean install) with profile" => "Create database (clean install) with profile",
// "Descriptions of the available profiles" => "Descriptions of the available profiles",
// "Upgrade" => "Upgrade",
// "backup your database" => "backup your database",
// "with mysqldump or phpmyadmin before you proceed" => "with mysqldump or phpmyadmin before you proceed",
// "Update database using script" => "Update database using script",
// "For database update from 1.8 or later" => "For database update from 1.8 or later",
// "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script" => "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script",
// "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)" => "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)",
// "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions" => "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions",
// "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity" => "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity",
// "Do nothing and enter Tiki" => "Do nothing and enter Tiki",
// "Reset database connection settings" => "Reset database connection settings",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please enter your admin password to continue" => "Please enter your admin password to continue",
// "Print operations executed successfully" => "Print operations executed successfully",
// "Print operations failed" => "Print operations failed",
// "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application" => "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application",
// "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore" => "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore",
// "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!" => "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!",
// "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!" => "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!",
// "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at only 8 Megs" => "Tiki has detected your PHP memory limit at only 8 Megs",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Note" => "Note",
// "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation" => "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation",
// "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system" => "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system",
// "Now you may proceed by clicking one of these links" => "Now you may proceed by clicking one of these links",
// "Click here to disable the install script and proceed into tiki" => "Click here to disable the install script and proceed into tiki",
// "Click here to proceed into tiki without disabling the script" => "Click here to proceed into tiki without disabling the script",
// "Go back and run another install/upgrade script" => "Go back and run another install/upgrade script",
// "do not use your Back button in your browser!" => "do not use your Back button in your browser!",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone.",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block.",
// "users registered" => "users registered",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>.",
// "Mods Configuration" => "Mods Configuration",
// "Last editor" => "Last editor",
// "Last modification" => "Last modification",
// "y" => "y",
// "Any" => "Any",
// "add structure" => "add structure",
// "P/F" => "P/F",
// "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!" => "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!",
// "trackers" => "trackers",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Usage chart" => "Usage chart",
// "Usage chart image" => "Usage chart image",
// "Daily Usage" => "Daily Usage",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
// "You have to \ncreate a gallery first!" => "You have to \ncreate a gallery first!",
// "Toggle" => "Toggle",
// "use google map locator" => "use google map locator",
// " item found" => " item found",
// " items found" => " items found",
// "fields marked with a * are mandatory" => "fields marked with a * are mandatory",
// "remove image" => "remove image",
// "Intertiki settings" => "Intertiki settings",
// "moved %d images, %d errors occured." => "moved %d images, %d errors occured.",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "You cannot have a blank password" => "You cannot have a blank password",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off.",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code.",
// "installed" => "installed",
// "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html.",
// "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement.",
// "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory.",
// "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts.",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Upcoming events." => "Upcoming events.",
// "Start:" => "Start:",
// "End:" => "End:",
// "Site No validated yet" => "Site No validated yet",
// "Error : The file %s doesn't exist." => "Error : The file %s doesn't exist.",
// "You do not have permission to write the template:" => "You do not have permission to write the template:",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "Back to preferences" => "Back to preferences",
// "No sheet specified." => "No sheet specified.",
// "This gallery does not exist" => "This gallery does not exist",
// "Unable to contact remote server." => "Unable to contact remote server.",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Invalid username or activation code. Maybe this code has already been used." => "Invalid username or activation code. Maybe this code has already been used.",
// "A new (and temporary) password and your IP address has been sent " => "A new (and temporary) password and your IP address has been sent ",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Error: " => "Error: ",
// "Use this thread to discuss the page:" => "Use this thread to discuss the page:",
// "An error occurred." => "An error occurred.",
// "Notice: invalid variable value:" => "Notice: invalid variable value:",
// "empty" => "empty",
// "Permission denied you cannot remove trackbacks" => "Permission denied you cannot remove trackbacks",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"Angola" => "Angola",
"Antigua" => "Antigua",
"Bahamas" => "Bahamas",
"Bangladesh" => "Bangladesh",
"Barbados" => "Barbados",
"Belarus" => "Belarus",
"Bermuda" => "Bermuda",
"Brunei" => "Brunei",
"Canada" => "Canada",
"Costa_Rica" => "Costa_Rica",
"Cuba" => "Cuba",
"Cyprus" => "Cyprus",
"Ecuador" => "Ecuador",
"El_Salvador" => "El_Salvador",
"Fiji" => "Fiji",
"Finland" => "Finland",
"Guam" => "Guam",
"Guatemala" => "Guatemala",
"Honduras" => "Honduras",
"Chile" => "Chile",
"China" => "China",
"India" => "India",
"Iran" => "Iran",
"Jamaica" => "Jamaica",
"Japan" => "Japan",
"Kiribati" => "Kiribati",
"Luxemburg" => "Luxemburg",
"Malawi" => "Malawi",
"Malta" => "Malta",
"Mauritius" => "Mauritius",
"Mexico" => "Mexico",
"Mozambique" => "Mozambique",
"Nauru" => "Nauru",
"Nepal" => "Nepal",
"Nicaragua" => "Nicaragua",
"Nigeria" => "Nigeria",
"Niue" => "Niue",
"Pakistan" => "Pakistan",
"Panama" => "Panama",
"Paraguay" => "Paraguay",
"Peru" => "Peru",
"Portugal" => "Portugal",
"Puerto_Rico" => "Puerto_Rico",
"Samoa" => "Samoa",
"Singapore" => "Singapore",
"Sri_Lanka" => "Sri_Lanka",
"St_Vincent_Grenadines" => "St_Vincent_Grenadines",
"Taiwan" => "Taiwan",
"Thailand" => "Thailand",
"Tonga" => "Tonga",
"Trinidad_Tobago" => "Trinidad_Tobago",
"Tuvalu" => "Tuvalu",
"Uruguay" => "Uruguay",
"Vanuatu" => "Vanuatu",
"Venezuela" => "Venezuela",
"Wales" => "Wales",
"Zambia" => "Zambia",
"Zimbabwe" => "Zimbabwe",
"Pijin Solomon" => "Pijin Solomon",
"in" => "in",
"faq" => "faq",
"forum" => "forum",
"quiz" => "quiz",
"tracker" => "tracker",
"Forums" => "Forums",
"Hits" => "Hits",
"Score" => "Score",
"tikiwiki logo" => "tikiwiki logo",
"Tracker" => "Tracker",
"Trackeritem" => "Trackeritem",
"Wiki" => "Wiki",
"FAQ" => "FAQ",
"Forum" => "Forum",
"help" => "help",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"%H:%M %Z" => "%H:%M %Z",
"km" => "km",
"Help" => "Help",
"wiki" => "wiki",
"faqs" => "faqs",
"arts" => "arts",
"forums" => "forums",
"Item" => "Item",
"max" => "max",
"jscalendar" => "jscalendar",
"open" => "open",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"code" => "code",
"term" => "term",
"Plugin " => "Plugin ",
"debug" => "debug",
"score" => "score",
"Threaded" => "Threaded",
"Top" => "Top",
"Smileys" => "Smileys",
"RSS Wiki" => "RSS Wiki",
"RSS Forums" => "RSS Forums",
"RSS Directories" => "RSS Directories",
"Type" => "Type",
"Zoom in x2" => "Zoom in x2",
"Zoom in x3" => "Zoom in x3",
"Zoom in x4" => "Zoom in x4",
"Label" => "Label",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"filter" => "filter",
"CC" => "CC",
"BCC" => "BCC",
"Cc" => "Cc",
"Modules" => "Modules",
"Hotwords" => "Hotwords",
"Cookies" => "Cookies",
"Mail-in" => "Mail-in",
"phpinfo" => "phpinfo",
"Menu" => "Menu",
"Webmail" => "Webmail",
"WfMenu" => "WfMenu",
"Workflow" => "Workflow",
"WikiMenu" => "WikiMenu",
"Dump" => "Dump",
"GalMenu" => "GalMenu",
"ForMenu" => "ForMenu",
"DirMenu" => "DirMenu",
"FAQs" => "FAQs",
"QuizMenu" => "QuizMenu",
"TrkMenu" => "TrkMenu",
"Trackers" => "Trackers",
"AdmMenu" => "AdmMenu",
"Debugger console" => "Debugger console",
"Integrator" => "Integrator",
"DSN" => "DSN",
"April" => "April",
"September" => "September",
"October" => "October",
"November" => "November",
"December" => "December",
"Filter" => "Filter",
"top" => "top",
"Sites" => "Sites",
"Top \$module_rows Sites" => "Top \$module_rows Sites",
"Top Sites" => "Top Sites",
"Open operator console" => "Open operator console",
"Tiki Logo" => "Tiki Logo",
"Wiki RSS" => "Wiki RSS",
"Forums RSS" => "Forums RSS",
"in:" => "in:",
"Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
"Top Forum Posters" => "Top Forum Posters",
"[-]" => "[-]",
"3d browser" => "3d browser",
"pdf" => "pdf",
"dump" => "dump",
"debugger console" => "debugger console",
"Permalink" => "Permalink",
"Trackback pings" => "Trackback pings",
"URI" => "URI",
"wiki help" => "wiki help",
"RSS" => "RSS",
"Tip" => "Tip",
"ok" => "ok",
"JsCalendar" => "JsCalendar",
"E-mail" => "E-mail",
"Workflow engine" => "Workflow engine",
"Live Support" => "Live Support",
"tikiwiki.org help" => "tikiwiki.org help",
"PHPLayers" => "PHPLayers",
"Debugger Console" => "Debugger Console",
"MIME Type" => "MIME Type",
"Exterminator" => "Exterminator",
"Unix" => "Unix",
"Windows" => "Windows",
"Tikiwiki.org help" => "Tikiwiki.org help",
"HTTPS Server" => "HTTPS Server",
"Help URL" => "Help URL",
"image/png" => "image/png",
"image/bmp" => "image/bmp",
"image/x-icon" => "image/x-icon",
"IP" => "IP",
"Web Server" => "Web Server",
"Tiki and PEAR::Auth" => "Tiki and PEAR::Auth",
"Tiki and HTTP Auth" => "Tiki and HTTP Auth",
"week" => "week",
"PEAR::Auth" => "PEAR::Auth",
"LDAP" => "LDAP",
"PAM" => "PAM",
"PAM service" => "PAM service",
"<b>Item</b>" => "<b>Item</b>",
"Geourl" => "Geourl",
"Robots" => "Robots",
"meta robots" => "meta robots",
"Editor" => "Editor",
"Webmaster" => "Webmaster",
"Site Logo" => "Site Logo",
"Site logo" => "Site logo",
"Site Menu" => "Site Menu",
"Quota (Mb)" => "Quota (Mb)",
"Dumps" => "Dumps",
"Status" => "Status",
"Wysiwyg editor" => "Wysiwyg editor",
"MultiPrint" => "MultiPrint",
"mins" => "mins",
"Import HTML" => "Import HTML",
"x" => "x",
"ID" => "ID",
"loc" => "loc",
"cat" => "cat",
"prio" => "prio",
"perso" => "perso",
"type" => "type",
"URL" => "URL",
"Top 10 items" => "Top 10 items",
"Top 20 items" => "Top 20 items",
"Top 40 items" => "Top 40 items",
"Top 50 items" => "Top 50 items",
"Top 100 items" => "Top 100 items",
"Top 250 items" => "Top 250 items",
"1 week" => "1 week",
"Items" => "Items",
"Cookie" => "Cookie",
"cookie" => "cookie",
"Ver" => "Ver",
"dsn" => "dsn",
"extwiki" => "extwiki",
"min" => "min",
"POP3 server" => "POP3 server",
"online" => "online",
"ppd" => "ppd",
"Zone" => "Zone",
"zone" => "zone",
"Start" => "Start",
"Regex" => "Regex",
"Mail-in accounts" => "Mail-in accounts",
"Account" => "Account",
"wiki-get" => "wiki-get",
"wiki-put" => "wiki-put",
"wiki-append" => "wiki-append",
"Parameters" => "Parameters",
"phpLayersMenus" => "phpLayersMenus",
"object" => "object",
"label" => "label",
"Alias" => "Alias",
"status" => "status",
"Id" => "Id",
"isMain" => "isMain",
"Tbl vis" => "Tbl vis",
"items" => "items",
"Pass" => "Pass",
"Trackers Items" => "Trackers Items",
"Directory batch" => "Directory batch",
"hit" => "hit",
"popup" => "popup",
"stop" => "stop",
"Focus:" => "Focus:",
"semester" => "semester",
"details" => "details",
"zoom" => "zoom",
"+" => "+",
"save_to" => "save_to",
"Ratio" => "Ratio",
"Tiki Debugger Console" => "Tiki Debugger Console",
"exec" => "exec",
"URL:" => "URL:",
"sites" => "sites",
"cType" => "cType",
"editor" => "editor",
"pixels" => "pixels",
"tagline" => "tagline",
"hr" => "hr",
"%" => "%",
"maxScore" => "maxScore",
"id" => "id",
"start" => "start",
"Int" => "Int",
"Routing" => "Routing",
"#" => "#",
"inter" => "inter",
"act" => "act",
"Act status" => "Act status",
"Pop-up" => "Pop-up",
"ver:" => "ver:",
"map" => "map",
"proc" => "proc",
"auto" => "auto",
"int" => "int",
"routing" => "routing",
"monitor" => "monitor",
"Inst Status" => "Inst Status",
"Select Graphic Type" => "Select Graphic Type",
"v" => "v",
"/" => "/",
"adm" => "adm",
"Operator" => "Operator",
"Operator:" => "Operator:",
"operator" => "operator",
"Tikiwiki Mods" => "Tikiwiki Mods",
"server" => "server",
"quota" => "quota",
"Quiz" => "Quiz",
"P" => "P",
"F" => "F",
"Top 10" => "Top 10",
"Top 20" => "Top 20",
"Top 50" => "Top 50",
"Top 100" => "Top 100",
"Site" => "Site",
"tikiwiki.org" => "tikiwiki.org",
"site" => "site",
"eek" => "eek",
"lol" => "lol",
"razz" => "razz",
"santa" => "santa",
"CMS" => "CMS",
"pvs" => "pvs",
"Mb" => "Mb",
"bytes" => "bytes",
"Object" => "Object",
"SysLog" => "SysLog",
"Module" => "Module",
"Folders" => "Folders",
"Folder in" => "Folder in",
"UTC" => "UTC",
"Info" => "Info",
"%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
"Pos" => "Pos",
"Mode" => "Mode",
"pos" => "pos",
"pre" => "pre",
"item" => "item",
"A" => "A",
"emot" => "emot",
"pts" => "pts",
"IRC log" => "IRC log",
"Tracker item:" => "Tracker item:",
"Filter Tracker Items" => "Filter Tracker Items",
"Details" => "Details",
"Webmail Doc" => "Webmail Doc",
"account" => "account",
"clip" => "clip",
"cc" => "cc",
"bcc" => "bcc",
"TOP" => "TOP",
"%m/%d" => "%m/%d",
"tiki-mobile.php" => "tiki-mobile.php",
"unicode" => "unicode",
"Percentage" => "Percentage",
"Monitor" => "Monitor",
// ###
// ### end of possibly untranslated words
// ###

"This script cannot be called directly" => "Dit script kan niet rechtstreeks worden gestart",
"Missing title or body when trying to post a comment" => "Ontbrekende titel of tekstlichaam bij poging om een bijdrage toe te voegen",
"The copyright management feature is not enabled." => "Het onderdeel ivm het beheer van de auteursrechten is niet aangezet",
"You do not have permission to use this feature." => "U heeft geen permissie om dt onderdeel te gebruiken.",
"You must supply all the information, including title and year." => "U moet alle informatie aanleveren, incluis titel en jaar.",
"You do not have permission to use this feature" => "U heeft geen permissie om dit onderdeel te gebruiken",
"The text in RED is" => "De tekst in ROOD is",
"character(s) too long - please edit it." => "karakter(s) te lang - aub verander het.",
"This feature is disabled" => "Dit onderdeel is niet actief",
"Algeria" => "Algerije",
"American_Samoa" => "Amerikaans_Samoa",
"Argentina" => "Argentine&euml;",
"Armenia" => "Armeni&euml;",
"Australia" => "Australi&euml;",
"Austria" => "Oostenrijk",
"Bahrain" => "Bahrein",
"Belgium" => "Belgi&euml;",
"Bolivia" => "Bolivi&euml;",
"Brazil" => "Brazile&euml;",
"Cayman_Islands" => "Kaaiman_Eilanden",
"Colombia" => "Colombi&euml;",
"Cook_Islands" => "Cook_Eilanden",
"Croatia" => "Kroati&euml;",
"Czech_Republic" => "Tsjechi&euml;",
"Denmark" => "Denemarken",
"Dominican_Republic" => "Dominikaanse_Republiek",
"Egypt" => "Egypte",
"Estonia" => "Estland",
"Federated_States_of_Micronesia" => "Verenigde_Staten_van_Micronesi&uml;",
"France" => "Frankrijk",
"French_Polynesia" => "Frans_Polynesi&euml;",
"Germany" => "Duitsland",
"Greece" => "Griekenland",
"Haiti" => "Ha&iuml;ti",
"Hungary" => "Hungarije",
"Iceland" => "Ijsland",
"Indonesia" => "Indonesi&euml;",
"Iraq" => "Irak",
"Ireland" => "Ierland",
"Israel" => "Isra&euml;l",
"Italy" => "Itali&euml;",
"Ivory_Coast" => "Ivoorkust",
"Jordan" => "Jordani&euml;",
"Kazakstan" => "Kazachstan",
"Kenya" => "Kenia",
"Kuwait" => "Koeweit",
"Latvia" => "Letland",
"Lebanon" => "Libanon",
"Lithuania" => "Litouwen",
"Malaysia" => "Maleisi&euml;",
"Marshall_Islands" => "Marshall_Eilanden",
"Morocco" => "Marokko",
"Netherlands" => "Nederland",
"New_Caledonia" => "Nieuw_Caledoni&euml;",
"New_Zealand" => "Nieuw_Zeeland",
"None" => "Geen",
"Norway" => "Noorwegen",
"Other" => "Andere",
"Papua_New_Guinea" => "Papoea_Nieuw_Guinea",
"Phillippines" => "Fillipijnen",
"Poland" => "Polen",
"Quatar" => "Qatar",
"Romania" => "Roemeni&euml;",
"Russia" => "Rusland",
"Saudi_Arabia" => "Saoedi_Arabi&euml;",
"Slovakia" => "Slovakije",
"Slovenia" => "Sloveni&euml;",
"Solomon_Islands" => "Solomon_Eilanden",
"Somalia" => "Somali&euml;",
"South_Africa" => "Zuid_Afrika",
"South_Korea" => "Zuid_Korea",
"Spain" => "Spanje",
"Surinam" => "Suriname",
"Sweden" => "Zweden",
"Switzerland" => "Zwitzerland",
"Turkey" => "Turkije",
"Ukraine" => "Oekraine",
"United_Arab_Emirates" => "Verenigde_Arabische_Emiraten",
"United_Kingdom" => "Vereinigd_Koningrijk",
"United_States" => "Verenigde_Staten",
"Yugoslavia" => "Joegoslavi&uml;",
"Bulgaria" => "Bulgarije",
"Arabic" => "Arabisch",
"Catalan" => "Catalaans",
"Simplified Chinese" => "Simpel Chinees",
"Chinese" => "Chinees",
"Czech" => "Czechisch",
"Danish" => "Deens",
"German" => "Duits",
"English" => "Engels",
"English British" => "Brits Engels",
"Spanish" => "Spaans",
"Greek" => "Grieks",
"French" => "Frans",
"Hebrew" => "Hebreeuws",
"Croatian" => "Kroatisch",
"Italian" => "Italiaans",
"Japanese" => "Japans",
"Korean" => "Koreaans",
"Hungarian" => "Hongaars",
"Dutch" => "Nederlands",
"Norwegian" => "Noors",
"Polish" => "Pools",
"Português" => "Portugees",
"Brazilian Portuguese" => "Braziliaans Portugees",
"Russian" => "Russisch",
"Slovak" => "Slovaaks",
"Serbian" => "Servisch",
"Serbian Latin" => "Servisch",
"Swedish" => "Zweeds",
"Tuvaluan" => "Tuvalees",
"Traditional Chinese" => "Traditioneel Chinees",
"Ukrainian" => "Oekraiens",
"This instance of activity is already complete" => "Deze incarnatie van de activiteit is reeds beeindigd",
"Fatal error: cannot execute automatic activity \$activityId" => "Fatale fout: kan automatische activiteit \$activityId niet uitvoeren",
"Fatal error: setting next activity to an unexisting activity" => "Fatale fout: markeer volgende activiteit als niet-bestaande activiteit",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatale fout: volgende activiteit komt niet overeen met enige kandidaat in de autorouting switch activiteit",
"Fatal error: non-deterministic decision for autorouting activity" => "Fatale fout: niet-deterministische beslissing voor autorouting activiteit",
"Fatal error: trying to send an instance to an activity but no transition found" => "Fatale fout: poging om een incarnatie naar een activiteit te zenden maar geen overgang gevonden",
"Cannot add transition only split activities can have more than one outbound transition" => "Kan geen overgang toevoegen, enkel gesplitste activiteiten kunnen meer dan &eacute;&eacute; uitgaande overgang hebben",
"Circular reference found some activity has a transition leading to itself" => "Circulaire verwijziging gevonden, er is een activiteit met een overgang naar zichzelf",
"Process does not have a start activity" => "Proces heeft geen start activiteit",
"Process does not have exactly one end activity" => "Proces heeft niet precies &eacute;&eacute; eind activiteit",
"End activity is not reachable from start activity" => "Eind activiteit is niet bereikbaar vanuit start activiteit",
"Activity" => "Activiteit",
" is interactive but has no role assigned" => " is interactief maar heeft geen rol toegewezen",
" is non-interactive and non-autorouted but has no role assigned" => " is niet-interactief en niet-autorouted maar heeft geen rol toegewezen",
" is standalone but has transitions" => " is op zichzelf staand maar heeft overgangen",
"Role" => "Functie",
" is not mapped" => " is niet gemapped",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Activiteit '.\$res['name'].' is op zichzelf staand en gebruikt het \$instance object",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Activiteit '.\$res['name'].' is interactief en moet de \$instance->complete() methode gebruiken",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Activiteit '.\$res['name'].' is niet-interactief en kan de \$instance->complete() methode niet gebruiken",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activiteit '.\$res['name'].' is switch en moet de \$instance->setNextActivity(\$actname) methode gebruiken",
"Process %d has been activated" => "Proces %d is geactivateerd",
"Process %d has been deactivated" => "Proces %d is gedeactivateerd",
"Process %s %s imported" => "Proces %s %s geimporteerd",
"Process %s removed" => "Proces %s verwijderd",
"Process %s has been updated" => "Proces %s bijgewerkt",
"Process %s has been created" => "Proces %s aangemaakt",
"by" => "door",
"refresh" => "verversen",
"locked" => "vergrendeld",
"locked by" => "vergrendeld door",
"Administration:" => "Beheer:",
"continued" => "vervolgt",
"new image uploaded by" => "nieuwe afbeeldingen aangeleverd door",
"uploaded by" => "aangeleverd door",
"new item in tracker" => "nieuw item in tracker",
"new subscriptions" => "nieuwe abonnementen",
"not specified" => "niet gespecifieerd",
"The file is not a CSV file or has not a correct syntax" => "Het bestand is geen CVS bestand of het heeft een fout formaat",
"article" => "artikel",
"blog" => "journaal",
"directory" => "koppelingenlijst",
"file gallery" => "bestandgalerij",
"image gallery" => "afbeeldinggalerij",
"newsletter" => "nieuwsbrief",
"poll" => "opiniepeiling",
"survey" => "opinieonderzoek",
"wiki page" => "wiki pagina",
"image" => "afbeelding",
"calendar" => "kalender",
"Cannot upload this file maximum upload size exceeded" => "Kan dit bestand niet aanleveren, maximum grootte van aanlevering overschreden",
"Anonymous" => "Anoniem",
"Use this thread to discuss the %s page." => "Gebruik deze thread om over deze pagina te discussieren.",
"Line:" => "Lijn:",
"Lines:" => "Lijnen:",
"Newsletter subscription information at " => "Nieuwsbrief abonnementsinformatie op ",
"Cannot write to this file:" => "Kan niet naar dit bestand schrijven:",
"There was a problem with your upload." => "Er is een probleem met uw aanlevering.",
"The file you are trying to upload is too big." => "Het bestand dat u wenst aan te leveren is te groot.",
"The file you are trying to upload was only partially uploaded." => "Het bestand dat u wenst aan te leveren, werd slechts gedeeltelijk getransfereerd.",
"You must select a file for upload." => "U moet een bestand opgeven voor de aanlevering.",
"Wiki Home" => "Wiki-startpagina",
"Home" => "Startpagina",
"Blogs" => "Journalen",
"Blog" => "Journaal",
"previous page" => "vorige pagina",
"next page" => "volgende pagina",
"posted on" => "toegevoegd op",
"Continue" => "Ga verder",
"Articles" => "Artikelen",
"By:" => "Door:",
"Read" => "Lezen",
"List articles" => "Artikelen opsommen",
"Last post" => "Laatste bijdrage",
"Invalid imagename (using filters for filenames)" => "Ongeldige naam afbeelding (gebruik filters voor bestandnamen)",
"Errors detected" => "Fouten opgetreden",
"Upload was not successful" => "Aanlevering was niet succesvol",
"No image yet, sorry." => "Nog geen afbeelding, sorry.",
"No valid ogr2ogr executable" => "Geen geschikt ogr2ogr programma beschikbaar",
"Could not create \$tdo.mif in data directory" => "Kon \$tdo.mif niet aanmaken in de gegevensfolder",
"Could not create \$tdo.mid in data directory" => "Kon \$tdo.mid niet aanmaken in de gegevensfolder",
"unknown" => "onbekend",
"User Map Generated in:" => "Gebruikskaart aangemaakt in:",
"Image Map Generated in:" => "Afbeeldingen aangemaakt in:",
"NONE" => "GEEN",
"File %s not found" => "Bestand %s niet gevonden",
"File %s is not a valid archive" => "Bestand %s is geen geldig archiefbestand",
"%s is an empty archive file" => "%s is een leeg archiefbestand",
"Invalid remote file on url %s" => "Ongeldig ver bestand op url %s",
"Impossible to open %s : %s" => "Kan %s : %s niet openen",
"Wiki top pages" => "Wiki top pagina's",
"Most relevant pages" => "Meest relevante pagina's",
"Relevance" => "Relevantie",
"Wiki last pages" => "Wiki laatste pagina's",
"Modified" => "Gewijzigd",
"Forums last topics" => "Forums' laatste onderwerpen",
"Topic date" => "Datum onderwerp",
"Forums last posts" => "Forums' laatste berichten",
"Forums most read topics" => "Forums' meest gelezen onderwerpen",
"Reads" => "Gelezen",
"Forums best topics" => "Forums' beste onderwerpen",
"Forums most visited forums" => "Forums' meest bezochte forums",
"Visits" => "Aantal bezoekers",
"Forums with most posts" => "Forums' met meeste berichten",
"Posts" => "Bijdragen",
"Wiki top galleries" => "Wiki top galerijen",
"Wiki top file galleries" => "Wiki top bestandgalerijen",
"Wiki top images" => "Wiki top afbeeldingen",
"Wiki top files" => "Wiki top bestanden",
"Downloads" => "Afhalingen",
"Wiki last images" => "Wiki laatste afbeeldingen",
"Upload date" => "Datum aanlevering",
"Wiki last files" => "Wiki laatste bestanden",
"Wiki top articles" => "Wiki top artikelen",
"Most visited blogs" => "Meest bezochte journalen",
"Most active blogs" => "Meest actieve journalen",
"Blogs last posts" => "Blogs laatste bijdragen",
"Post date" => "Datum toevoeging",
"Wiki top authors" => "Wiki top auteurs",
"Pages" => "Pagina's",
"Top article authors" => "Top artikelauteurs",
"Login" => "Aanmelden",
"See other user's profile" => "Zie ander gebruikersprofiel",
"Have your profile seen" => "Heb jouw profiel gezien",
"Make friends" => "Maak vrienden",
"Receive message" => "Ontvang bericht",
"Send message" => "Stuur bericht",
"Read an article" => "Lees een artikel",
"Publish an article" => "Publiceer een artikel",
"Have your article read" => "Laat uw artikel lezen door",
"Create new file gallery" => "Maak nieuwe bestandgalerij aan",
"Upload new file to gallery" => "Lever nieuw bestaand in de galerij aan",
"Download other user's file" => "Haal bestand van andere gebruikers af",
"Have your file downloaded" => "Laat uw bestand afhalen",
"Create a new image gallery" => "Maak een nieuwe beeldgalerij aan",
"Upload new image to gallery" => "Lever nieuw beeld in galerij aan",
"See other user's gallery" => "Bekijk galerij van andere gebuiker",
"See other user's image" => "Bekijk beeld van andere gebruiker",
"Have your gallery seen by other user" => "Laat uw galerij door anderen gebruiker bekijken",
"Have your image seen" => "Laat uw beeld bekijken",
"Create new blog" => "Maak nieuw journaal aan",
"Post in a blog" => "Maak bericht in journaal",
"Read other user's blog" => "Lees journal van andere gebruiker",
"Have your blog read" => "Laat uw journaal lezen",
"Create a new wiki page" => "Maak nieuwe wikipagina aan",
"Edit an existing page" => "Werk een bestaande pagina bij",
"Attach file" => "Attach bestand",
"Unknown" => "Ongekend",
"Image Gallery" => "Beeldgalerij",
"Image" => "Afbeelding",
"Article" => "Artikel",
"Directory category" => "Koppelingenlijst categorie",
"Directory" => "Koppelingenlijst",
"File Gallery" => "Bestandgalerij",
"Gallery" => "Galerij",
"File" => "Bestand",
"Blog post" => "Journaalbijdrage",
"Link" => "Koppeling",
"The text is" => "De tekst is",
"Text cut here" => "Knip tekst hier",
"Task" => "Taak",
"from" => "van",
"for" => "voor",
"Priority" => "Prioriteit",
"Start date:" => "Startdatum:",
"End date:" => "Einddatum:",
"%A %d of %B, %Y" => "%A %d van %B, %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d van %B, %Y[%H:%M:%S %Z]",
"%a %d of %b, %Y" => "%a %d van %b, %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d van %b, %Y[%H:%M %Z]",
"Friend" => "Vriend",
"Last seen on " => "Laast gezien op ",
"(idle for %s seconds)" => "(niet actief gedurende %s seconden)",
"User information - Click for more info" => "Gebruikersinformatie - Klik voor meer info",
"More info about \$other_user" => "Meer info over \$other_user",
"(idle for \$idletime seconds)" => "(niet actief gedurende \$idletime seconden)",
"unlocked" => "ontsloten",
"created from structure" => "aangemaakt vanuit struktuur",
"Use this tree to copy the structure" => "Gebruik deze indeling om de struktuur te kopieren",
"An error occured in a database query!" => "Een fout is opgetreden in een databankvraag!",
"You are banned from" => "U bent verbannen van",
"img-g" => "afbd-g",
"file-g" => "bestand-g",
"quizzes" => "quizzen",
"blogs" => "journalen",
"games" => "spelletjes",
"picture not found" => "afbeelding niet gevonden",
"drawing not found" => "tekening niet gevonden",
"Click to edit dynamic variable" => "Klik om dynamische variable te wijzigen",
"Update variables" => "Update variabelen",
"Altering database table failed" => "Aanpassing databank tabel gefaald",
"%d points" => "%d punten",
"Removed" => "Verwijderd",
"Created" => "Gemaakt",
"__WARNING__: No such module \$plugin! " => "__WAARSCHUWING__: Module \$plugin niet beschikbaar! ",
"new" => "nieuw",
"Create page:" => "Pagina aanmaken:",
"show" => "toon",
"hide" => "verberg",
"Updated" => "Bijgewerkt",
"Unknown language" => "Ongekende taal",
"Click here to confirm your action" => "Klik hier om uw actie te bestigen",
"Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) ontdekt. Handeling stopgezet.",
"Item Modification" => "Wijziging item",
"Item creation" => "Aanmaak item",
"Tracker was modified at " => "Tracker was gewijzigd op ",
"text field" => "tekstveld",
"half column" => "halve kolom",
"size" => "grootte",
"prepend" => "voeg vooraan toe",
"append" => "voeg achteraan toe",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Tekst opties: 1,grootte,prefix,suffix,max met grootte in karakters, prefix zal worden getoond voor de veldpositie suffix zal worden getoond na de veldpositie, max is het maximum aantal karakters kan worden opgeslagen, initiele 1 betekent dat het volgende tekstveld of selectieveld in dezelfde rij moet worden opgenomen.",
"textarea" => "tekstzone",
"checkbox" => "selectieveld",
"Checkbox options: put 1 if you need that next field is on the same row." => "Selectieveld opties: vul 1 in indien u wenst dat het volgende veld op dezelfde rij komt.",
"numeric field" => "numeriek veld",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numerieke opties: 1, grootte, prefix, suffix met grootte in karakter, prefix zal worden getoond voor de veldpositie suffix zal worden getoond na de veldpositie, 1 om aan te duiden dat het volgende tekstveld of selectieveld in dezelfde rij moet worden opgenomen",
"drop down" => "neerklap",
"Dropdown options: list of items separated with commas." => "Neerklaplijst opties: lijst van items gescheide door comma's",
"user selector" => "gebruikerkizer",
"User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "Gebruikerskiezer: gebruik opties voor automische veldinvoer : gebruik 1 voor auteur login of 2 voor login van editor.",
"group selector" => "groepkiezer",
"Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Groepkiezer: gebruik opties voor automische veldinvoer : gebruik 1 voor groep van aanmaak of 2 voor groep van wijziging. De standaard dient te worden gezet, of de eerste groep die voorkomt wordt gekozen voor de gebruiker, of de standaard groep is Geregistreerde gebruikers.",
"date and time" => "datum en tijd",
"action" => "actie",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Actie opties: Label,post,tiki-index.php,page:fieldname,highlight=test",
"header" => "hoofding",
"category" => "categorie",
"Category options: parentId" => "Categorie opties: ouderId",
"item link" => "item koppeling",
"items list" => "items lijst",
"email" => "e-mail",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Email adres opties: 0|1|2 waar 0 het adres invoegt als gewone tekst, 1 een hex encoded mailto koppeling invoegt (moeilijker op te pikken voor web spiders en spam bots) and 2 een normal href mailto koppeling invoegt.",
"system" => "systeem",
"pending" => "openstaande",
"closed" => "gesloten",
"message" => "bericht",
"No extra information for that attached file. " => "Geen extra information voor deze bijlage. ",
"child categories" => "kindcategorie&euml;n",
"objects in category" => "objecten in categorie",
"Include all post in a blog" => "Neem alle berichten van een journaal op",
"Date" => "Datum",
"Title" => "Titel",
"Author" => "Auteur",
"Include a page" => "Sluit een pagina in",
"Lists files in a directory" => "Lijst bestanden in een folder",
"could not be opened because it doesn't exist or permission was denied" => "kan niet worden geopend omdat het niet bestaat of wegens onvoldoende permissies",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Neemt de regex expressies en berekent de inhoud tussen de REGEX labels en vervangt deze door de tekst.",
"data" => "gegevens",
"one data per line" => "een gegeven per lijn",
"The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "De SNARF plugin vervangt zichzelf met het HTML-gedeelte van een URL. Willekeurig vervangingen op deze inhoud zijn mogelijk door gebruik te maken van regex of regexres waarbij de laatste als tweede argument dienst voor de preg_replace functie.",
"This data is put in a CODE caption." => "Deze gegevens worden in een CODE tekstkader geplaatst.",
"Missing url parameter for SNARF plugin." => "Ontbrekende url parameter voor de SNARF plugin.",
"Displays browser client info" => "Toon browser client info",
"Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Plaats een koppeling naar een anker in een wiki pagina. Gebruik in combinatie met de ANAME plugin die de locatie en naam van het anker bepaald",
"linktext" => "tekst van koppeling",
"Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Plaats een anker in een wiki pagina. Gebruik in combinatie met de ALINK plugin die de koppeling naar het anker voorziet",
"Include an article" => "Sluit een artikel in",
"no such attachment on this page" => "bijlage niet aanwezig op deze pagina",
"Displays an attachment or a list of them" => "Toont een bijlage of een bijlagelijst",
"comment" => "opmerking",
"num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "num is facultatief en stelt de rangorde voor van de bijlage in de lijst. Indien niet opgegeven; zal een lijst van alle beschikbare bijlagen worden getoond. Het commentaar kan als tekst voor de koppeling gebruikt worden.",
"Displays the user Avatar" => "Toon het gebruikerpictogram",
"username" => "gebruikernaam",
"List all pages which link to specific pages" => "Toon alle pagina's die naar specifieke pagina's verwijzen",
"Page cannot be found" => "Pagina kan niet gevonden worden",
"No pages links to" => "Geen pagina's verwijzen naar",
"One page links to" => "E&eacute; pagina verwijst naar",
"pages link to" => "pagina's verwijzen naar",
"Insert theme styled box on wiki page" => "Voeg een thema-geformatteerd tekstkader toe aan de wiki pagina",
"text" => "tekst",
"Insert list of items for the current/given category into wiki page" => "Voeg lijst van items voor de huidige categorie toe aan de wiki pagina",
"Categories are disabled" => "Categorie&euml;n zijn uitgeschakeld",
"Display Tiki objects that have not been categorized" => "Toon niet-gecategorizeerde Tik objecten",
"Insert the full category path for each category that this wiki page belongs to" => "Voeg het volledige categoriepad toe voor elke categorie waartoe deze wiki pagina behoort",
"Centers the plugin content in the wiki page" => "Centreer de plugin inhoud in de wiki pagina",
"Displays a snippet of code" => "Toont een stukje code",
"note: colors and ln are exclusive" => "opmerking: kleuren en ln zijn exclusief",
"Insert copyright notices" => "Voeg bericht over auteursrechten toe",
"Example" => "Voorbeeld",
"days" => "dagen",
"hours" => "uren",
"minutes" => "minuten",
"and" => "en",
"seconds" => "seconden",
"Insert a division block on wiki page" => "Onderdeelblok invoegen in een wiki pagina",
"Creates a definition list" => "Maak definitielijst aan",
"definition" => "definitie",
"one definition per line" => "&eacute;&eacute; definitie per lijn",
"Displays the data using the Tikiwiki odd/even table style" => "Toont de gegevens in alternerende Tikiwiki tabelstijl",
"cells" => "cellen",
"heads and cells separated by ~|~" => "hoofdingen en cellen zijn gescheiden door ~|~",
"Displays a SWF on the wiki page" => "Toont een SWF in de wiki pagina",
"Displays a graphical GAUGE" => "Toont een grafische VOLUMEMETER",
"description" => "omschrijving",
"Displays the text only if the language matchs" => "Toont enkel de tekst indien de taal overeenkomt",
"Feature disabled" => "Onderdeel niet actief",
"Displays an miniquiz" => "Toont een miniquiz",
"Please choose a module" => "Kies aub een module",
"to be used as argument" => "moet als argument gebruikt worden",
"Displays a module inlined in page" => "Toon de module in de pagina",
"Sorry no such module" => "Geen zulks module",
"Displays the data using a monospace font" => "Toont de gegevens in een monospace lettertype",
"Provides a list of plugins on this wiki." => "Geeft een lijst van plugins voor dit wiki.",
"No version indicated" => "Geen versie opgegeven",
"No arguments indicated" => "Geen argumenten aangeduidt",
"Displays the output of a poll, fields are indicated with numeric ids." => "Toont het resultaat van een opiniepeiling, velden zijn aangeduidt met numerieke ids.",
"missing poll ID for plugin POLL" => "ontbrekend ID voor opiniepeiling in de plugin OPINIEPEILING",
" wrote:" => " schreef:",
"Quote:" => "Aanhaling:",
"Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Haal tekst aan door deze in een tekstkader te plaatsen, zoals de [QUOTE] BBCode",
"~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId,max=>3,datum=>1,tekst=>1)}{RSS} Voeg rss stroom toe aan wiki pagina",
"Automatically creates a link to the appropriate SourceForge object" => "Maak automatisch een koppeling aan naar het bijbehorende SourceForge object",
"TikiSheet" => "TikiRekenblad",
"Sheet Heading" => "Rekenblad Hoofding",
"Edit Sheet" => "Bewerk Rekenblad",
"List wiki pages" => "Lijst van wiki pagina's",
"Last modified by" => "Laatst bijgewerkt door",
"Sorts the plugin content in the wiki page" => "Sorteer de inhoud van de plugin in de wiki pagina",
"Split a page into rows and columns" => "Split een pagina in rijen en kolommen",
"row1col1" => "rij1kol1",
"row1col2" => "rij1kol2",
"row2col1" => "rij2kol1",
"row2col2" => "rij2kol2",
"Missing db param" => "Ontbrekende db param",
"Run a sql query" => "Draai een sql commando",
"sql query" => "sql commando",
"Displays text in subscript." => "Toon tekst in kleinschrift.",
"Displays the thumbnail for an image" => "Voorbeeldplaatje van een afbeelding tonen",
"Search the titles of all pages in this wiki" => "Zoek door de titles van alle pagina's in dit wiki",
"No pages found for title search" => "Geen pagina's gevonden voor titel zoekopdracht",
"One page found for title search" => "E&eacute;n pagina gevonden voor titel zoekopdracht",
" pages found for title search" => " pagina's gevonden voor titel zoekopdracht",
"Displays an input form for tracker submit" => "Toon een invoerformulier voor trackeringave",
"Save" => "Bewaren",
"Fields marked with a * are mandatory." => "Velden aangeduid met een * zijn verplicht.",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "Uitvoer van tracker inhoud tonen, velden zijn aangegeven met numerieke ids.",
"missing tracker ID for plugin TRACKER" => "tracker ID voor plugin tracker ontbreekt",
"missing fields list" => "lijst van ontbrekende velden",
"at" => "aan",
"Error in tracker ID" => "Fout in tracker ID",
"No field indicated" => "Geen veld opgegeven",
"Links to a translated content" => "Koppelingen naar vertaalde inhoud",
"Displays the number of registered users" => "Toont het aantal geregistreerde gebruikers",
"Split the text in parts visible only under some conditions" => "Splits de tekst in delen die enkel onder bepaalde omstandigheden zichtbaar zijn",
"External Wiki" => "Extern Wiki",
"valid" => "geldig",
"failed" => "mislukt",
"You are not logged in" => "U bent niet aangemeld",
"Permission denied" => "Geen permissie",
"ERROR: Either the subject or body must be non-empty" => "FOUT: Onderwerp of tekstlichaam mag niet blanco zijn",
"ERROR: No valid users to send the message" => "FOUT: Geen geldige gebruikers om het bericht naar te zenden",
"Invalid user" => "Ongeldige gebruiker",
"Message will be sent to: " => "Bericht zal verstuurd worden naar: ",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Verzend postbus is vol. Verwijder of archiveer sommige berichten eerst vooraleer nieuwe te versturen.",
"User %s can not receive messages, mailbox is full" => "Gebruiker %s kan geen berichten ontvangen, haar/zijn postbus is vol",
"User %s can not receive messages" => "Gebruiker %s kan geen berichten ontvangen",
"Invalid user: %s" => "Ongeldige gebruiker: %s",
"Archive is full. Delete some messages from archive first." => "Archief is vol. Verwijder eerst een aantal berichten uit het archief.",
"No more messages" => "Einde berichten",
"move %s in %s" => "verplaats %s naar %s",
"Please provide an Id" => "Geef aub een Id op",
"no object here yet" => "nog geen object hier",
"This module requires parameters trackerId and name set" => "Deze module vereist de parameters trackerId en name set",
"edit" => "bewerken",
"Quick edit a Wiki page" => "Een wikipagina snel bewerken",
"Since your last visit" => "Sinds uw laatste bezoek",
"Changes" => "Wijzigingen",
"since" => "sinds",
"Changes since" => "Wijzigingen sinds",
"new comments" => "nieuwe opmerkingen",
"wiki pages changed" => "wikipagina's gewijzigd",
"new articles" => "nieuwe artikelen",
"new FAQs" => "nieuwe FAQs",
"new blogs" => "nieuwe journalen",
"new blog posts" => "nieuwe journaalberichten",
"new image galleries" => "nieuwe beeldgalerijen",
"new images" => "nieuwe afbeeldingen",
"new file galleries" => "nieuwe bestandgalerijen",
"new files" => "nieuwe bestanden",
"new polls" => "nieuwe opiniepeilingen",
"new users" => "nieuwe gebruikers",
"no such file" => "geen zulk bestand",
"Error" => "Foutmelding",
"The task title must have at least 3 characters" => "De takenlijst moet minimum 3 karakters bevatten",
"Invalid username or password" => "Ongeldige gebruikernaam of wachtwoord",
"List of attached files" => "Lijst van bijlagen",
"name" => "naam",
"desc" => "omschr.",
"uploaded" => "aangeleverd",
"delete" => "verwijderen",
"Remove" => "Verwijderen",
"Upload file" => "Bestand aanleveren",
"attach" => "bijlage toevoegen",
"Fatal error" => "Fatale fout",
"Description:" => "Omschrijving:",
"Created by" => "Gemaakt door",
" on " => " op ",
"Last modified" => "Laatst gewijzigd",
"Post" => "Bijdrage",
"post" => "voeg toe",
"RSS feed" => "RSS-invoer",
"Edit blog" => "Werk journaal bij",
"monitor this blog" => "monitor dit journaal",
"stop monitoring this blog" => "stop monitoring van dit journaal",
"posts" => "bijdragen",
"visits" => "aantal bezoekers",
"Activity=" => "Activiteit=",
"Categorize" => "Categorizeer",
"show categories" => "categorie&euml;n tonen",
"hide categories" => "categorie&euml;n verbergen",
"Tip: hold down CTRL to select multiple categories" => "Tip: houdt de CTRL toets ingedrukt om meerdere categorie&euml;n te selecteren",
"categorize this object" => "dit object categoriseren",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "Tip: wis het bovenstaande selectieveld leeg om deze pagina/object uit de categorie&euml;n te verwijderen",
"No categories defined" => "Geen categorie&eacute; gedefinieerd",
"Admin categories" => "Categorie&euml;n beheren",
"browse category" => "bekijk categorie",
"author" => "auteur",
"stars" => "sterren",
"user level" => "gebruikerniveau",
"private message" => "priv�bericht",
"send email to user" => "verstuur e-mail naar gebruiker",
"user online" => "gebruiker online",
"user offline" => "gebruiker offline",
"on" => "op",
"Vote" => "Stem",
"Edit" => "Bewerken",
"reply" => "beantwoorden",
"attachment" => "bijlage",
"Moderator actions" => "Moderator acties",
"delete selected" => "verwijder geselecteerde",
"Move to topic:" => "Verplaats naar onderwerp:",
"move" => "verplaatsen",
"reported:" => "gemelde:",
"queued:" => "in wachtrij geplaatste:",
"Posted messages" => "Aangeleverde berichten",
"Messages" => "Berichten",
"All" => "Alle",
"Style" => "Stijl",
"Plain" => "Gewone",
"Headers Only" => "Enkel Hoofding",
"Sort" => "Sorteren",
"Newest first" => "Nieuwste eerst",
"Oldest first" => "Oudste eerst",
"Threshold" => "Drempelwaarde",
"Find" => "Zoeken",
"set" => "Inloggen",
"Hide all" => "Verberg alles",
"replies" => "antwoorden",
"below your current threshold" => "beneden de huidige limiet",
"prev" => "vor.",
"Page" => "Pagina",
"next" => "volg.",
"new reply" => "nieuw antwoord",
"Editing reply" => "Bewerk aantwoord",
"Reply to the selected post" => "Beantwoordt het aangeduide bericht",
"Editing comment" => "Bewerking van opmerking",
"Comment on the selected post" => "Lever commentaar op het aangeduide bericht",
"Post new comment" => "Nieuwe opmerking toevoegen",
"Preview" => "Voorbeeld tonen",
"Reply to parent post" => "Beantwoordt bovenliggend bericht",
"Post new reply" => "Lever nieuw antwoord aan",
"preview" => "voorbeeld tonen",
"cancel" => "annuleren",
"Required" => "Verplicht",
"Rating" => "Beoordeling",
"Reply" => "Beantwoorden",
"Comment" => "Opmerking",
"Posting replies" => "Beantwoorden",
"Posting comments" => "Opmerkingen toevoegen",
"Use" => "Gebruik",
"or" => "of",
"for links" => "voor koppelingen",
"HTML tags are not allowed inside posts" => "HTML-labels zijn niet toegestaan in berichten",
"Go back" => "Ga terug",
"Return to home page" => "Terug naar startpagina",
"Copyrights" => "Auteursrechten",
"Year" => "Jaar",
"Authors" => "Auteurs",
"up" => "omhoog",
"down" => "omlaag",
"add" => "toevoegen",
"Syntax" => "Schrijfwijze",
"Page generation debugging log" => "Paginageneratie debugging log",
"Features state" => "Status onderdelen",
"Total" => "Totaal",
"features matched" => "overeenkomende onderdelen",
"Watchlist" => "Monitorlijst",
"There are no wiki pages similar to '{\$page}'" => "Er zijn geen gelijkwaardige wiki pagina's aan '{\$page}'",
"Create this page" => "Maak deze pagina aan",
"(page will be orphaned)" => "(pagina zal verweesd worden)",
"Close Window" => "Sluit venster",
"Last update from CVS" => "Laatste bijwerking uit CVS",
"RSS Blogs" => "RSS Journaals",
"RSS Articles" => "RSS Artikelen",
"RSS Image Galleries" => "RSS Afbeeldinggalerijen",
"RSS File Galleries" => "RSS Bestandgalerijen",
"RSS Maps" => "RSS Kaarten",
"Information" => "Informatie",
"Hi {\$mail_user} has sent you this link:" => "Hallo {\$mail_user} stuurt u deze koppeling:",
"Blog post:" => "Journaalbericht:",
"at:" => "op:",
"Somebody or you tried to subscribe this email address at our site:" => "Iemand of uzelf heeft zich onder dit e-mail addressen proberen te abonneren op onze site:",
"To the newsletter:" => "Op deze nieuwsbrief:",
"In order to confirm your subscription you must access the following URL:" => "Om uw abonnement te bevestigen gelieve naar volgende URL te gaan:",
"A new message was posted to forum" => "Een nieuwe bijdrage is aanwezig op het forum",
"New topic:" => "Nieuw onderwerp:",
"Topic:" => "Onderwerp:",
"Message" => "Bericht",
"You sent a request with the subject:" => "U stuurde een verzoek met als titel:",
"Use the subject to indicate the operation to apply:" => "Gebruik het onderwerp om aangeven welke actie te ondernemen:",
"GET:WikiName to get a wiki page" => "GET:WikiName om een wiki pagina af te halen",
"PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName om een wiki pagina aan te maken of te plaatsen (gebruik het tetstlichaam voor de tekstgegevens)",
"APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName om gegevens aan een Wiki pagina toe te voegen (gebruik het tetstlichaam voor de tekstgegevens)",
"PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName om gegevens aan het begin toe te voegen",
"Tiki mail-in instructions" => "Tiki mail-in instructies",
"Tiki mail-in auto-reply." => "Tiki mail-in auto-antwoord.",
"Page not found:" => "Pagina niet gevonden:",
"Hi," => "Hallo,",
"A new message was posted to you at {\$mail_machine}" => "Er is een nieuw bericht voor u aangekomen op {\$mail_machine}",
"From" => "Van",
"Subject" => "Betreft",
"New message arrived from %s" => "Nieuw bericht binnengekomen van %s",
"Hi" => "Hallo",
"Enjoy the site!" => "Veel plezier met de site!",
"has requested an account on" => "heeft een account aangevraagd op",
"To validate that account, please follow the link:" => "Om dit account te bevestigen gelieve deze koppeling te volgen:",
"best regards" => "met vriendelijke groeten",
"your Tikiwiki" => "uw Tikiwiki",
"Tiki User Registration Request" => "Tiki Gebruikersregistratie Verzoek",
"You're invited to join my network of friends!" => "U bent uitgenodigd om u bij mijn netwerk van vrienden aan te sluiten!",
"The user" => "De gebruiker",
"registered at your site" => "heeft zich geregistreerd op uw site",
"New user registration" => "Nieuwe gebruikerregistratie",
"Bye bye!" => "Tot ziens!",
"This email address has been removed to the list of subscriptors of:" => "Dit e-mail adres is verwijderd van de abonneelijst van:",
"Newsletter:" => "Nieuwsbrief:",
"Bye bye from %s at %s" => "Tot ziens van %s aan %s",
"You can unsubscribe from this newsletter following this link" => "U kan zich van deze nieuwsbrief afmelden via volgende koppeling",
"Welcome to our newsletter!" => "Welkom bij onze nieuwsbrief!",
"This email address has been added to the list of subscriptors of:" => "Dit e-mail adress is toegevoegd aan de abonneelijst van:",
"You can always cancel your subscription using:" => "U kan ten alle tijde uw abonnement stopzetten via:",
"Welcome to %s at %s" => "Welkom aan %s van %s",
"Tiki email notification" => "Tiki e-mail melding",
"Since this is your registered email address we inform that the password for this account is" => "Sinds dit uw geregistreerd e-mail adres is, informeren we u dat het wachtwoord voor dit account het volgende is",
"Your Tiki account information for %s" => "Uw Tiki account informatie voor %s",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Een nieuw artikel werd aangemeld door {\$mail_user} via {\$mail_site} op {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "U kan de bijdrage via deze koppeling bewerken:",
"Title:" => "Titel:",
"Heading:" => "Hoofding:",
"Body:" => "Tekstlichaam:",
"New article submitted at %s" => "Nieuw artikel aangeleverd bij %s",
"View the tracker item at:" => "Bekijk het tracker item op:",
"you or someone registered this email address at" => "uzelf of iemand anders registreerde dit e-mail adres bij",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Indien u zich als geregistreerde bezoeker op deze site wilt kenbaar maken, gelieve dan volgende koppeling te volgen om u zich voor de eerste maal aan te melden:",
"Your Tiki information registration" => "Uw Tiki informatie registratie",
"You will receive an email with information to login for the first time into this site" => "U zal een e-mail ontvangen met informatie over hoe u zich voor de eerste maal op deze site kan aanmelden",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Uw account verzoek werd opgeslagen en zal zo snel mogelijk door een beheerder behandelde worden.",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Plaatsing nieuw artikel: {\$mail_title} door {\$mail_user} op {\$mail_date|tiki_short_datetime}",
"View the article at:" => "Bekijk het artikel op:",
"If you don't want to receive these notifications follow this link:" => "Volg deze koppeling indien u deze melding niet wenst te ontvagen:",
"New article post at %s" => "Plaatsing nieuw artikel op %s",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Nieuw journaal bericht: {\$mail_title}, \"{\$mail_post_title}\", door {\$mail_user} op {\$mail_date|tiki_short_datetime}",
"View the blog at:" => "Bekijk het journaal op:",
"New blog post at %s" => "Nieuw journaalbericht bij %s",
"File Gallery %s changed" => "Verandering in bestandgalerij %s",
"A file was removed from the file gallery" => "Een bestand werd verwijderd uit de bestandgalerij",
"Removed by" => "Verwijderd door",
"Name" => "Naam",
"File Name" => "Bestandsnaam",
"A new file was posted to file gallery" => "Een nieuw bestand werd aangeleverd in de bestandgalerij",
"Posted by" => "Aangeleverd door",
"File Description" => "Bestandomschrijving",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "De landkaart {\$mail_page} werd bijgewerkt door {\$mail_user} op {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "U kan de bijgewerkte landkaart via deze koppeling bekijken:",
"You can edit the map following this link:" => "U kan de landkaart bijwerken via volgende koppeling:",
"Size" => "Grootte",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "De pagina {\$mail_page} werd aangemaakt door {\$mail_user} op {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "De pagina {\$mail_page} werd bijgewerkt door {\$mail_user} op {\$mail_date|tiki_short_datetime}",
"Comment:" => "Commentaar:",
"You can view the page by following this link:" => "U kan de pagina bekijken via volgende koppeling:",
"You can view a diff back to the previous version by following this link:" => "U kan een verschil met de vorige versie beijken via volgende koppeling:",
"The changes in this version follow below, followed after by the current full page text." => "Zie beneden voor de veranderingen in deze versie, gevolgd door de volledige versie van de huidige tekst.",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lijnen: {\$oldd} aangepast tot +Lijnen: {\$newd}",
"The new page content follows below." => "De nieuwe pagina inhoud volgt beneden.",
"Wiki page %s changed" => "Wiki pagina %s bijgewerkt",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "De pagina {\$mail_page} werd becommentarieerd door {\$mail_user} op {\$mail_date|tiki_short_datetime}",
"New name" => "Nieuwe naam",
"Thank you for you registration. You may log in now." => "Dank voor uw registratie. U kan zich nu aanmelden.",
"click on the map to zoom or pan, do not drag" => "klik op de landkaart om te zoomen or te verschuiven",
"Scale" => "Schaal",
"Zoom out x4" => "Zoom uit x4",
"Zoom out x3" => "Zoom uit x3",
"Zoom out x2" => "Zoom uit x2",
"Query" => "Vraag",
"Pan" => "Schuif",
"Redraw" => "Herteken",
"select zoom/pan/query and image size" => "selecteer zoom/verschuif/vraag en grootte afbeelding",
"Go" => "Tonen",
"View the Map Only" => "Bekijk enkel de Kaart",
"Reset Map" => "Reset Kaart",
"Click on the map or click redraw" => "Klik op de landkaart of klik herteken",
"Comments" => "Opmerkingen",
"Last modification date" => "Datum laatste wijziging",
"Overview" => "Overzicht",
"Legend" => "Legende",
"Layer Manager" => "Lagen beheren",
"Layer" => "Laag",
"On" => "Aan",
"Download" => "Afhaling",
"Download Layer" => "Haal Laag af",
"This layer has been set by the maps administrator to not be downloadable" => "Deze laag is door de kaartenbeheerder als niet afhaalbaar gevlagd",
"you have requested to download the layer:" => "u heeft gevraagd om de volgende laag af te halen:",
"from\nthe mapfile:" => "van\nhet landkaartbestand:",
"Here are the files to download, do not forget to rename them:" => "Hier zijn de bestanden om af te halen, vergeet niet om ze te hernoemen:",
"Mapfiles" => "Landkaartbestanden",
"Mapfile" => "Landkaartbestand",
"Available mapfiles" => "Beschikbare landkaartbestanden",
"Actions" => "Acties",
"hits" => "keren bezocht",
"monitor this map" => "monitor deze landkaart",
"stop monitoring this map" => "stop de monitoring van deze landkaart",
"No records found" => "Geen records gevonden",
"Create a new mapfile" => "Maak een nieuw landkaartbestand aan",
"create" => "maken",
"Mapfile listing" => "Opsommen landkaartbestanden",
"Reload" => "Herlaad",
"History" => "Geschiedenis",
"save" => "opslaan",
"You can view this map in your browser using" => "Je kan deze landkaart in je browser bekijken via",
"Mapfile History" => "Kaartenbestand Historiek",
"of" => "van",
"Version" => "Versie",
"compare" => "vergelijken",
"Comparing version {\$old.version} with version {\$new.version}" => "Vergelijk versie {\$old.version} met versie {\$new.version}",
"Version:" => "Versie:",
"current" => "huidig",
"Versions are identical" => "Versies zijn identiek",
"Legend:" => "Legende:",
"v=view" => "v=bekijk (view)",
"c=compare" => "c=vergelijk (compare)",
"d=diff" => "d=verschillen (diff)",
"Side-by-side diff" => "Zij-langs-zij verschillen",
"Full side-by-side diff" => "Volledige zij-langs-zij verschillen",
"Unified diff" => "Uniforme verschillen",
"Side-by-side view" => "Bekijk zij-langs-zij",
"User" => "Gebruiker",
"Ip" => "IP",
"Action" => "Actie",
"view" => "bekijken",
"diff" => "verschillen",
"older version" => "oudere versie",
"Directories" => "Folders",
"back to" => "terug naar",
"Files" => "Bestanden",
"Upload From Disk:" => "Lever aan van Schijf:",
"Upload Files" => "Lever Bestanden aan",
"Bytes maximum" => "maximum Bytes",
"Create Directory:" => "Maak Folder aan:",
"Create" => "Maak aan",
"index file (.shp):" => "index bestand (.shp):",
"files to index (regexp):" => "bestanden om te indexeren (regexp):",
"Message Archive" => "Brichtenarchief",
"Edit template" => "Bewerk sjabloon",
"messages" => "berichten",
"Archive is full!" => "Archief is vol!",
"Unread" => "Ongelezen",
"Flagged" => "Gevlagd",
"Unflagged" => "Niet-gevinkt",
"Containing" => "Bevat",
"download" => "Afhaling",
"sender" => "afzender",
"subject" => "betreft",
"date" => "datum",
"flagged" => "gevlagd",
"No messages to display" => "Geen berichten te tonen",
"Broadcast message" => "Stuur oproep",
"Message Broadcast" => "Bericht aan alle gebruikers",
"edit template" => "bewerk sjabloon",
"Group" => "Groep",
"All users" => "Alle gebruikers",
"Lowest" => "Laagste",
"Low" => "Laag",
"Normal" => "Normaal",
"High" => "Hoog",
"Very High" => "Zeer Hoog",
"send" => "zenden",
"Compose message" => "Bericht opstellen",
"Compose Message" => "Stel Bericht Op",
"If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "Als je wil dat gebruikers je kunnen antwoorden, zorg er dan voor dat de optie <a href='tiki-user_preferences.php'>Laat berichten toe van andere gebruikers</a> aanstaat",
"To" => "Naar",
"No messages to download" => "Geen berichten om af te halen",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Postbus is vol! Verwijder of archiveer berichten als je nog nieuwe boodschappen wil ontvangen.",
"move to archive" => "verplaats naar archief",
"Mark as read" => "Als gelezen markeren",
"Mark as unread" => "Als ongelezen markeren",
"Mark as flagged" => "Selecteer als gevinkt",
"Mark as unflagged" => "Als niet flagged markeren",
"mark" => "markeer",
"reply to" => "antwoordt op",
"find replied message" => "vind beantwoord bericht",
"Mailbox" => "Postbus",
"Compose" => "Opstellen",
"Broadcast" => "Oproep",
"Sent" => "Verzonden",
"Archive" => "Archief",
"Auto-archive age for read messages:" => "Auto-archiveer ouderdom voor gelezen berichten:",
"Read message" => "Lees bericht",
"Prev" => "Vor.",
"Next" => "Volgende",
"Return to mailbox" => "Ga terug naar postbus",
"replyall" => "antwoordallen",
"Unflag" => "Verwijder vink",
"Flag this message" => "Bericht aanvinken",
"Return to archive" => "Keer terug naar archief",
"Return to outbox" => "Keer terug naar UIT postbus",
"Sent Messages" => "Verzonden berichten",
"Replied" => "Beantwoord",
"Not replied" => "Niet beantwoord",
"receiver" => "ontvanger",
"no" => "neen",
"replied" => "beantwoordt",
"'name' parameter for tikimodule missed" => "'naam' parameter voor tikimodule ontbreekt",
"Move module up" => "Schuif module naar boven",
"Move module down" => "Schuif module naar beneden",
"Hide module contents" => "Verberd moduleinhoud",
"Move module to opposite side" => "Schuif module naar de andere kant",
"opp side" => "tegengestelde kant",
"Unassign this module" => "Toekenning van module ongedaan maken",
"Are you sure you want to unassign this module?" => "Bent u zeker dat u de toekenning van deze module wilt ongedaan maken?",
"remove" => "verwijderen",
"Admin Menu" => "Menu Beheren",
"Live support" => "Live-ondersteuning",
"Banning" => "Verbanning",
"Users" => "Gebruikers",
"Groups" => "Groepen",
"Cache" => "Buffer",
"Links" => "Koppelingen",
"RSS modules" => "RSS-modules",
"Menus" => "Menu's",
"Polls" => "Opiniepeilingen",
"Backups" => "Reservekopie&euml;n",
"Mail notifications" => "E-mail meldingen",
"Search stats" => "Zoekstatistieken",
"QuickTags" => "SnelLabels",
"Chat" => "Praatkamer",
"Categories" => "Categorie&euml;n",
"Banners" => "Advertenties",
"Edit templates" => "Sjablonen bewerken",
"Admin drawings" => "Tekeningen beheren",
"Dynamic content" => "Dynamische inhoud",
"Content templates" => "Inhoudssjablonen",
"HTML pages" => "HTML-pagina's",
"Shoutbox" => "Spreekbuis",
"Shoutbox Words" => "Spreekbuis woorden",
"Referer stats" => "Verwijzerstatistieken",
"Import PHPWiki Dump" => "Importeer PHPWiki Dump",
"Admin dsn" => "Beheer dsn",
"External wikis" => "Externe wiki's",
"System Admin" => "Systeembeheer",
"Security Admin" => "Veiligheidsbeheer",
"Syntax highlighting" => "Schrijfwijzebelichting",
"Contact us" => "Contacteer ons",
"Stats" => "Statistieken",
"Games" => "Spelletjes",
"Calendar" => "Kalender",
"MyMenu" => "MijnMenu",
"MyTiki" => "MijnTiki",
"MyTiki home" => "MijnTiki start",
"Preferences" => "Instellingen",
"Tasks" => "Taken",
"Bookmarks" => "Favorieten",
"Newsreader" => "Nieuwslezer",
"Notepad" => "Kladblok",
"My files" => "Mijn bestanden",
"User menu" => "Gebruikermenu",
"Mini calendar" => "Minikalender",
"My watches" => "Mijn wakers",
"Admin processes" => "Processen beheren",
"Monitor processes" => "Monitor processen",
"Monitor activities" => "Monitor activiteiten",
"Monitor instances" => "Monitor incarnaties",
"User processes" => "Gebruikerprocessen",
"User activities" => "Gebruikeractiviteiten",
"User instances" => "Gebruikerincarnaties",
"FriendsMenu" => "VriendenMenu",
"Community" => "Gemeenschap",
"User list" => "Gebruikerlist",
"Friendship Network" => "Vriendschapsnetwerk",
"Last changes" => "Laatste wijzigingen",
"Rankings" => "Rangordes",
"List pages" => "Pagina's opsommen",
"Orphan pages" => "Verweesde pagina's",
"Sandbox" => "Zandbak",
"Print" => "Afdrukken",
"Send pages" => "Verzend pagina's",
"Received pages" => "Ontvangen pagina's",
"Structures" => "Strukturen",
"Image Galleries" => "Beeldgalerijen",
"Galleries" => "Galerijen",
"Upload image" => "Afbeelding aanleveren",
"System gallery" => "Systeemgalerij",
"Articles home" => "Artikelen startpagina",
"Submit article" => "Artikel inleveren",
"View submissions" => "Bijdragen bekijken",
"Edit article" => "Artikel bewerken",
"Send articles" => "Artikelen verzenden",
"Received articles" => "Ontvangen artikelen",
"Admin topics" => "Onderwerpen beheren",
"Admin types" => "Types beheren",
"List blogs" => "Journalen opsommen",
"Create/Edit blog" => "Maak aan/Bewerk journaal",
"Admin posts" => "Bijdragen beheren",
"List forums" => "Opsommen forums",
"Admin forums" => "Forums beheren",
"Submit a new link" => "Lever een nieuwe koppeling in",
"Browse directory" => "Blader in koppelingenlijst",
"Admin directory" => "Koppelingenlijst beheren",
"FileGalMenu" => "BestandGalMenu",
"File Galleries" => "Bestandgalerijen",
"List galleries" => "Galerijen opsommen",
"List FAQs" => "FAQs opsommen",
"Admin FAQs" => "FAQs Beheren",
"Maps" => "Landkaarten",
"Layer management" => "Laagbeheer",
"Quizzes" => "Quizzen",
"List quizzes" => "Opsommen quizzen",
"Quiz stats" => "Statistieken voor quiz",
"Admin quiz" => "Quiz beheren",
"ShtMenu" => "RknbldMenu",
"List trackers" => "Trackers opsommen",
"Admin trackers" => "Trackers beheren",
"SrvMenu" => "EnqMenu",
"Surveys" => "Opinieonderzoeken",
"List surveys" => "Opinieonderzoeken opsommen",
"Admin surveys" => "Opinieonderzoeken beheren",
"Newsletters" => "Nieuwsbrieven",
"Send newsletters" => "Nieuwsbrieven verzenden",
"Admin newsletters" => "Nieuwsbrieven beheren",
"Events" => "Gebeurtenissen",
"Send events" => "Verzend gebeurtenissen",
"Admin events" => "Beheer gebeurtenissen",
"EphMenu" => "SprkMenu",
"Ephemerides" => "Spreuken",
"Ephemerides Admin" => "Spreuken beheren",
"ChartMenu" => "RankschkMenu",
"Charts" => "Rangschikkingen",
"Charts Admin" => "Rangschikkingen beheren",
"Admin" => "Beheer",
"Admin home" => "Beheer start",
"Theme control" => "Themacontrole",
"Drawings" => "Tekeningen",
"Edit languages" => "Wijzigen talen",
"Mods Admin" => "Mods Beheer",
"UsrMenu" => "GebrMenu",
"Click here to manage your personal menu" => "Klik hier om uw persoonlijk menu te beheren",
"User Menu" => "Gebruikermenu",
"Tikiwiki Assistant" => "Tikiwiki Assistent",
"Thank you for installing Tikiwiki" => "Dank u voor het installeren van Tikiwiki",
"Click the :: options in the Menu for more options." => "Klik de :: in het Menu voor meer opties.",
"Please, also see" => "Zie ook",
"for more setup details." => "voor meer setup details.",
"Note 1:" => "Opmerking 1:",
"You can remove this module in" => "U kan deze module verwijderen in",
"as well as assign or edit many others." => "wijs toe of bewerk meerdere andere.",
"Note 2:" => "Opmerking 2:",
"The menu module installed by default is named" => "De menu module geinstalleerd door default heet",
"it is a \"custom module\" which includes menu ID " => "het is een \"maatwerkmodule\" die het menu ID bevat",
"That menu is stored in database and it can be edited from " => "Dit menu is opgeslagen in de databank en kan bewerkt worden via ",
"Do not mix this with the original <em>application_menu</em> module" => "Mix deze niet met de originele <em>application_menu</em> module",
"That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "Deze kan manueel aangepast worden om aan de gangbare stijl te voldoen maar dit kan momenteel slechts enkel door het \"handmatig\" wijzigen van het mod-application_menu.tpl bestand",
"Recently visited pages" => "Onlangs bezochte pagina's",
"January" => "Januari",
"February" => "Februari",
"March" => "Maart",
"May" => "Mei",
"June" => "Juni",
"July" => "Juli",
"August" => "Augustus",
"Monday" => "maandag",
"Tuesday" => "dinsdag",
"Wednesday" => "woensdag",
"Thursday" => "donderdag",
"Friday" => "vrijdag",
"Saturday" => "zatedag",
"Sunday" => "zondag",
"Today" => "Vandaag",
"Received objects" => "Ontvangen objecten",
"Pages:" => "Pagina's:",
"Last `\$module_rows` Sites" => "Laatste `\$module_rows` Sites",
"Last Sites" => "Laatste Sites",
"Directory Stats" => "Koppelingenlijst Statistieken",
"Sites to validate" => "Sites te valideren",
"Searches" => "Zoekopdrachten",
"Visited links" => "Bezochte koppelingen",
"Featured links" => "Aanbevolen koppelingen",
"Top `\$module_rows` topics" => "Top `\$module_rows` onderwerpen",
"Top topics" => "Toponderwerpen",
"Last `\$module_rows` forum posts" => "Laatste `\$module_rows` forum berichten",
"Last forum posts" => "Laatste forumberichten",
"Last `\$module_rows` forum topics" => "Laatste `\$module_rows` forum onderwerpen",
"Last forum topics" => "Laatste forumonderwerpen",
"Most commented forums" => "Forums met meest opmerkingen",
"Most read topics" => "Meest gelezen onderwerpen",
"Most visited forums" => "Meest bezochte forums",
"Google Search" => "Google Zoeken",
"Last `\$module_rows` actions" => "Laaste `\$module_rows` acties",
"Last actions" => "Laaste acties",
"Last `\$module_rows` articles" => "Laatste `\$module_rows` artikelen",
"Last articles" => "Laatste artikelen",
"Last `\$module_rows` blog posts" => "Laatste `\$module_rows` journaalberichten",
"Last blog posts" => "Laatste journaalbijdragen",
"Last" => "Laatste",
"Last `\$module_rows` Created blogs" => "Laatste `\$module_rows` aangemaakte journalen",
"Last Created blogs" => "Laatst gemaakte journalen",
"Last `\$module_rows` Created FAQs" => "Laatste `\$module_rows` aangemaakte FAQs",
"Last Created FAQs" => "Laatst Gemaakte FAQs",
"Last `\$module_rows` Created Quizzes" => "Laatste `\$module_rows` aangemaakte Quizzen",
"Last Created Quizzes" => "Laatst Gemaakte Quizzen",
"Last `\$module_rows` modified file galleries" => "Laatste `\$module_rows` bijgewerkte bestandgalerijen",
"Last modified file galleries" => "Laatst gewijzigde bestandgalerijen",
"Last `\$module_rows` Files" => "Laatste `\$module_rows` Bestanden",
"Last Files" => "Laatste Bestanden",
"Last `\$module_rows` galleries" => "Laatste `\$module_rows` galerijen",
"Last galleries" => "Laatste galerijen",
"Last `\$module_rows` Images" => "Laatste `\$module_rows` Afbeeldingen",
"Last Images" => "Laatste Afbeeldingen",
"Last `\$module_rows` modified events" => "Laatste `\$module_rows` bijgewerkte gebeurtenissen",
"Last modifed events" => "Laatste bijgewerkte gebeurtenissen",
"Last `\$module_rows` changes" => "Laatste `\$module_rows` veranderingen",
"Last `\$module_rows` Modified Items" => "Laatste `\$module_rows` bijgewerkte Items",
"Last Modified Items" => "Laatst Gewijzigde Items",
"Last `\$module_rows` Modified blogs" => "Laatste `\$module_rows` bijgewerkte journalen",
"Last Modified blogs" => "Laatst gewijzigde journalen",
"Last `\$module_rows` submissions" => "Laatste `\$module_rows` Bijdragen",
"Last submissions" => "Laatste bijdragen",
"Last `\$module_rows` Items" => "Laatste `\$module_rows` Items",
"Last Items" => "Laatste Items",
"Last `\$module_rows` visitors" => "Laatste `\$module_rows` bezoekers",
"Last visitors" => "Laaste bezoekers",
"Online users" => "Gebruikers on-line",
"We have" => "We hebben",
"online users" => "online gebruikers",
"logged as" => "aangemeld als",
"Logout" => "Afmelden",
"user" => "gebruiker",
"Login through CAS" => "Aanmelding via CAS",
"Login as admin" => "Aanmelding als beheerder",
"pass" => "wachtwoord",
"login" => "aanmelden",
"Remember me" => "Onthouden login",
"Click here to register" => "Klik hier om te registeren",
"register" => "registreren",
"Click here if you've forgotten your password" => "Klik hier indien u uw wachtwoord bent vergeten",
"I forgot my pass" => "Ik ben mijn wachtwoord vergeten",
"Click here to login using the default security protocol" => "Klik hier om met het standaard veiligheidsprotocol aan te melden",
"standard" => "standaard",
"Click here to login using a secure protocol" => "Klik hier om met het beveiligde protocol aan te melden",
"secure" => "veilig",
"stay in ssl mode" => "in ssl-modus blijven",
"You have" => "U heeft",
"new messages" => "nieuwe berichten",
"new message" => "nieuw bericht",
"You have 0 new messages" => "U heeft geen nieuwe berichten",
"Waiting Submissions" => "Wachtende Bijdragen",
"submissions waiting to be examined" => "bijdragen die nog moeten bekeken worden",
"Old articles" => "Oude artikelen",
"Send a message to" => "Stuur een bericht naar",
"Random Pages" => "Toevallige Pagina's",
"Register as a new user" => "Als nieuwe gebruiker registreren",
"Your email could not be validated; make sure you email is correct and click register below." => "Uw e-mail adres kan niet worden gevalidderd; zorg er aub voor dat uw e-mail adres correct is en klik op onderstaande koppeling om u te registreren.",
"Your registration code:" => "Uw registratie code:",
"Random Image" => "Willekeurige afbeelding",
"Username" => "Gebruikernaam",
"Passcode to register (not your user password)" => "Pascode om te registreren (niet uw gebruikerwachtwoord)",
"Registration code" => "Registratie code",
"Password" => "Wachtwoord",
"Repeat password" => "Opnieuw",
"Email" => "E-mail",
"Generate a password" => "Maak een wachtwoord aan",
"Blogs RSS" => "Journaals RSS",
"Articles RSS" => "Artikelen RSS",
"Image Galleries RSS" => "Beeldgalerijnen RSS",
"File Galleries RSS" => "Bestandgalerijen RSS",
"Maps RSS" => "Landkaarten RSS",
"Search" => "Zoeken",
"Entire Site" => "Volledige Site",
"Wiki Pages" => "Wikipagina's",
"Image Gals" => "Beeldgalerijen",
"Images" => "Afbeeldingen",
"Blog Posts" => "Journaalbijdragen",
"go" => "vooruit",
"Search Wiki PageName" => "Zoek Wiki PaginaNaam",
"Exact&nbsp;match" => "Juiste&nbsp;vondst",
"Read More" => "Verderlezen",
"Since your last visit on" => "Sinds uw laatste bezoek op",
"click to edit" => "klik om te bewerken",
"Language: " => "Taal: ",
"Language" => "Taal",
"Most Active blogs" => "Actiefste journalen",
"Top `\$module_rows` articles" => "Top `\$module_rows` artikelen",
"Top articles" => "Topartikelen",
"Top `\$module_rows` File Galleries" => "Top `\$module_rows` Bestandgalerijen",
"Top File Galleries" => "Topbestandgalerijen",
"Top `\$module_rows` files" => "Top `\$module_rows` bestanden",
"Top files" => "Top bestanden",
"Top `\$module_rows` games" => "Top `\$module_rows` spellen",
"Top games" => "Topspelletjes",
"Top `\$module_rows` galleries" => "Top `\$module_rows` galerijen",
"Top galleries" => "Topgalerijen",
"Top `\$module_rows` Images" => "Top `\$module_rows` Afbeeldingen",
"Top Images" => "Topafbeeldingen",
"Top `\$module_rows` Pages" => "Top `\$module_rows` Pagina's",
"Top Pages" => "Toppagina's",
"Top `\$module_rows` Quizzes" => "Top `\$module_rows` Quizzen",
"Top Quizzes" => "Topquizzen",
"Most `\$module_rows` visited blogs" => "`\$module_rows` meest bezochte journalen",
"Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` bezochte FAQs",
"Top Visited FAQs" => "Meest Bezochte FAQs",
"Upcoming events" => "Aankomende evenementen",
"My blogs" => "Mijn journalen",
"cache" => "buffer",
"My galleries" => "Mijn galerijen",
"My Pages" => "Mijn pagina's",
"User tasks" => "Gebruikertaken",
"done" => "gedaan",
"del" => "verw",
"Public tasks" => "Publieke taken",
"select" => "selecteer",
"User informations" => "Gebruikerinformatie",
"Group informations" => "Groepinformatie",
"Top users" => "Top gebruikers",
"Whats related" => "Wat is gerelateerd",
"online user" => "online gebruikers",
"Last `\$module_rows` wiki comments" => "Laatste `\$module_rows` wiki commentaren",
"Last wiki comments" => "Laatste wiki commentaren",
" on page " => " op pagina ",
"Click to see the ratings" => "Klik om de beoordelingen te zien",
"vote" => "stemmen",
"Sent editions" => "Verzonden uitgaven",
"find" => "zoeken",
"users" => "gebruikers",
"sent" => "verzonden",
"use" => "gebruiken",
"Structures:" => "Strukturen:",
"show structures" => "toon strukturen",
"hide structures" => "verberg strukturern",
"Manage structures" => "Beheer strukturen",
"Are you sure you want to remove this module?" => "Bent u zeker dat u deze module wenst te verwijderen?",
"Powered by" => "Aangedreven door",
"Execution time" => "Uitvoertijd",
"secs" => "sec",
"Memory usage" => "Geheugengebruik",
"database queries used" => "database vragen gebruikt",
"Server load" => "Serverbelasting",
"page id" => "pagina id",
"cached" => "gebufferd",
"print" => "afdrukken",
"create pdf" => "maak pdf aan",
"Save to notepad" => "Naar kladblok opslaan",
"monitor this page" => "monitor deze pagina",
"stop monitoring this page" => "stop deze pagina te monitoren",
"backlinks" => "terugkoppelingen",
"Previous page" => "Vorige pagina",
"Parent page" => "Ouderpagina",
"Next page" => "Volgende pagina",
"Child" => "Kind",
"Add Page" => "Voeg Pagina toe",
"First page" => "Startpagina",
"page" => "pagina",
"Last page" => "Laatste pagina",
"Last edited by" => "Laatst bijgewerkt door",
"based on work by" => "gebaseerd op het werk van",
"Page last modified on" => "Pagina laatst bijgewerkt op",
"Contributors to this page" => "Leverde bijdrages tot deze pagina",
"last modification" => "laatste wijziging",
"To edit the copyright notices" => "Om de berichten mbt auteursrechten te wijzigen",
"click here" => "klik hier",
"The content on this page is licensed under the terms of the" => "De inhoud van deze pagina is gelicensieerd onder de voorwaarden van",
"The original document is available at" => "Het originele document is beschikbaar op",
"rename" => "hernoemen",
"unlock" => "ontgrendelen",
"lock" => "vergrendelen",
"perms" => "perm.",
"history" => "geschiedenis",
"similar" => "vergelijkbaar",
"undo" => "terugzetten",
"slides" => "dia's",
"export" => "exporteren",
"discuss" => "discussieer",
"add comment" => "commentaar",
"1 comment" => "1 commentaar",
"comments" => "opmerkingen",
"attach file" => "voeg bijlage toe",
"1 file attached" => "1 bestand aangehangen",
"{\$atts_cnt} files attached" => "{\$atts_cnt} bestanden aangehangen",
"translation" => "vertaling",
"Page generated in" => "Pagina aangemaakt in",
"The newsletter was sent to {\$sent} email addresses" => "De nieuwsbrief is naar {\$sent} e-mail addressen verstuurd",
"This newsletter will be sent to {\$subscribers} email addresses." => "Deze nieuwsbrief zal naar {\$subscribers} e-mail addressen verstuurd worden.",
"Prepare a newsletter to be sent" => "Een nieuwsbrief voorbereiden voor verzending",
"Newsletter" => "Nieuwsbrieven",
"Apply template" => "Sjabloon toepassen",
"none" => "geen",
"Data" => "Gegevens",
"Send Newsletters" => "Nieuwsbrieven Verzenden",
"Made with" => "Gemaakt met",
"powered by" => "aangedreven door",
"This is" => "Dit is",
"by the" => "door de",
"Tiki community" => "Tiki gemeenschap",
"User List" => "Gebruikerlijst",
"Homework" => "Huiswerk",
"Assignments" => "Taken",
"Last Changes" => "Laatste Wijzigingen",
"attachments" => "bijlagen",
"Click" => "Klik",
"User files" => "Gebruikerbestanden",
"Favorites" => "Favorieten",
"Watches" => "Monitors",
"Show/Hide Left Menus" => "Toon/Verberg Linkse Menu\\'s",
"Show/Hide Right Menus" => "Toon/Verberg Rechtse Menu\\'s",
"home" => "startpagina",
"chat" => "Praatje",
"contact us" => "contacteer ons",
"stats" => "statistieken",
"categories" => "categorie&euml;n",
"Member list" => "Ledenlijst",
"last changes" => "laatste wijzigingen",
"rankings" => "rangordes",
"list pages" => "pagina's opsommen",
"orphan pages" => "verweesde pagina's",
"sandbox" => "zandbak",
"received pages" => "ontvangen pagina's",
"structures" => "strukturen",
"Articles Home" => "Artikel-startpagina",
"Create/Edit Blog" => "Blog Maken/Bewerken",
"Browse Directory" => "Blader in Koppelingenlijst",
"List Quizzes" => "Quizzen Opsommen",
"List Trackers" => "Trackers Opsommen",
"List Surveys" => "Opinieonderzoeken Opsommen",
"Prefs" => "Voorkeuren",
"MyFiles" => "MijnBestanden",
"back to homepage" => "terug naar de thuispagina",
"This page is being edited by" => "Deze pagina wordt momenteel bewerkt door",
"Proceed at your own peril" => "Ga verder op eigen risico",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "De zandbak is een pagina waar u kan u leren hoe u pagina's kan bewerken, gebruik het voorbeeld om het uitzicht van de pagina te bekijken, er worden geen versies van deze pagina opgeslagen.",
"Description" => "Omschrijving",
"My Footnotes" => "Voetnoten",
"Copyright" => "Auteursrechten",
"Year:" => "Jaar:",
"Authors:" => "Auteurs:",
"Allow HTML" => "HTML toestaan",
"Spellcheck" => "Spellingcontrole",
"Import page" => "Pagina importeren",
"export all versions" => "alle versies exporteren",
"Upload picture" => "Afbeelding aanleveren",
"no cache" => "Geen buffer",
"minute" => "minuut",
"hour" => "uur",
"Anti-Bot verification code" => "Anti-Bot verificatie code",
"Enter the code you see above" => "Voer bovenstaande code in",
"License" => "Licentie",
"Important" => "Belangrijk",
"Minor" => "minder belangrijk",
"cancel edit" => "bewerking annuleren",
"dls" => "afhlgn",
"No attachments for this page" => "Geen bijlagen voor deze pagina",
"My Tiki" => "Mijn Tiki",
"User Pages" => "Gebruikerpagina's",
"List pages where I am a creator" => "Som pagina's op waarvan ik de auteur ben",
"by creator" => "op auteur",
"List pages where I am a modificator" => "Som pagina's waarvan ik een bijdrage heb geleverd (editor)",
"by modificator" => "op editor",
"User Galleries" => "Gebruikergalerijen",
"Assigned items" => "Toegewezen items",
"at tracker" => "bij tracker",
"Unread Messages" => "Niet-gelezen berichten",
"User Blogs" => "Gebruikerjournalen",
"left/right" => "links/rechts",
"Unassign module" => "Maak toewijzing module ongedaan",
"Mini Calendar" => "Mini-Kalender",
"Edit mapfiles" => "Bewerk landkaartbestanden",
"switch" => "draai om",
"on:" => "op:",
"reads" => "gelezen",
"Article image" => "Artikelafbeelding",
"Topic image" => "Afbeelding onderwerp",
"Refresh" => "Ververs",
"Location : " => "Locatie : ",
"Find:" => "Zoek:",
"Sort posts by:" => "Bijdragen sorteren volgens:",
"posted by" => "toegevoegd door",
"read more" => "lees meer",
"pages" => "pagina's",
"referenced by" => "gerefereerd door",
"references" => "referenties",
"view comments" => "opmerkingen bekijken",
"email this post" => "e-mail deze bijdrage",
"Viewing blog post" => "Journaalbijdrage bekijken",
"Return to blog" => "Terug naar journaal",
"Blog name" => "Journaalnaam",
"Translate in" => "Vertaal naar",
"babelfish it" => "babelfish het",
"User Bookmarks" => "Gebruikerfavorieten",
"Welcome to" => "Welkom bij",
"Click here to create it" => "Klik hier om aan te maken",
"Enlarge area height" => "Vergroot hoogte vak",
"Reduce area height" => "Verklein hoogte vak",
"Features" => "Onderdelen",
"General" => "Algemeen",
"Meta Tags" => "Meta-labels",
"Site Identity" => "Site Identeit",
"Site Calendar" => "Site Kalender",
"To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "Om journaals toe te voegen of te verwijderen, ga naar \"Maak aan/Bewerk Journaal\" onder \"Journaals\" in het applicatiemenu, of",
"Home Blog" => "Startjournaal",
"Home Blog (main blog)" => "Startjournaal (hoofdjournaal)",
"Blog features" => "Journaal-onderdelen",
"Blog level comments" => "Opmerkingen journaalniveau",
"Post level comments" => "Opmerkingen bijdrageniveau",
"Spellchecking" => "Spellingcontrole",
"Not Installed" => "Niet Geinstalleerd",
"Default ordering for blog listing" => "Standaardvolgorde van journaallijst",
"Creation date (desc)" => "Aanmaakdatum (dalend)",
"Last modification date (desc)" => "Datum laatste wijziging (dalend)",
"Blog title (asc)" => "Blogtitel (stijgend)",
"Number of posts (desc)" => "Aantal bijdragen (dalend)",
"Visits (desc)" => "Aantal bezoekers (dalend)",
"Activity (desc)" => "Activiteit (dalend)",
"Change preferences" => "Instellingen wijzigen",
"Blog listing configuration (when listing available blogs)" => "Journaallijst configuratie (bij het opsommen van beschikbare journalen)",
"Creation date" => "Aanmaakdatum",
"Last modification time" => "Tijdstip laatste wijziging",
"Disabled" => "Uitgeschakeld",
"Plain text" => "Platte tekst",
"Link to user information" => "Koppeling met gebruikerinformatie",
"User avatar" => "Gebruikerpictogram",
"Blog comments settings" => "Instellingen voor opmerkingen bij journalen",
"Default number of comments per page" => "Standaard aantal opmerkingen per pagina",
"Comments default ordering" => "Standaardvolgorde opmerkingen",
"Points" => "Punten",
"Group calendar sticky popup" => "Groepkalender plakpopup",
"Group calendar item view tab" => "Groepkalender bekijk item tab",
"Change settings" => "Wijzig instellingen",
"Look under \"Articles\" on the application menu for links to" => "Zoek onder \"Artikelen\" in het applicatie menu voor koppelingen naar",
"CMS features" => "CMS-onderdelen",
"Submissions" => "Bijdragen",
"Use templates" => "Sjablonen gebruiken",
"Settings for page articles home" => "Instellingen voor de Artikelen thuispagina",
"Maximum number of articles in home" => "Maximaal aantal artikelen in startpagina",
"Article comments settings" => "Instellingen voor opmerkingen bij artikelen",
"Fields to display on page" => "Velden om te tonen op pagina",
"Topic" => "Thema",
"Publish Date" => "Publicatiedatum",
"Expire Date" => "Verloopdatum",
"Visible" => "zichtbaar",
"Img" => "Afb.",
"User identity features" => "Kenmerken Gebruikersidentiteit",
"Show user's info on mouseover" => "Toon gebruikersinformatie bij muisover",
"Picture" => "Foto",
"Number of friends" => "Aantal vrienden",
"Country" => "Land",
"Last login" => "Laatste aanmelding",
"Distance" => "Afstand",
"Set features" => "Onderdelen instellen",
"To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "Om uw directory in te stellen, ga naar \"Beheer directory\" onder \"Directory\" in het applicatiemenu, of",
"Number of columns per page when listing categories" => "Aantal kolommen per pagina wanneer categorie&euml;n opgesomd worden",
"Links per page" => "Links per pagina",
"Validate URLs" => "URLs valideren",
"enable cool sites" => "schakel leuke sites in",
"Method to open directory links" => "Methode om koppelingen uit koppelingenlijst te openen",
"replace current window" => "huidig venster vervangen",
"new window" => "niew venster",
"inline frame" => "inline-kader",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "Om FAQs toe te voegen of te verwijderen, ga naar \"Beheer FAQs\" onder \"FAQs\" in het applicatiemenu, of",
"Tiki sections and features" => "Tikisecties en -onderdelen",
"Featured Help" => "Aanbevolen Help",
"Live support system" => "Live-ondersteuningssysteem",
"Help System" => "Help Systeem",
"Multilingual" => "Meertalig",
"Best language" => "Beste taal",
"Show Category Path" => "Toon Categorie Pad",
"Show Babelfish Translation URLs" => "Toon Babelfish Vertaal URLs",
"Show Category Objects" => "Toon Categorie Objecten",
"Show Babelfish Translation Logo" => "Toon Babelfish Vertaal Logo",
"Show Module Controls" => "Toon Module Controles",
"Tiki Calendar" => "Tiki Kalender",
"Template Viewing" => "Sjabloon Bezichtiging",
"Tiki Template Viewing" => "Tiki Sjabloon Bezichtiging",
"PhpLayers Dynamic menus" => "PhpLayers Dynamische menus",
"Use Tabs" => "Gebruik Tabs",
"Tiki Sheet" => "Tiki Rekenblad",
"Site Logo and Identity" => "Site Logo en Identiteit",
"Mobile" => "Mobiel",
"Content Features" => "Inhoud Onderdelen",
"Edit Templates" => "Sjablonen bewerken",
"Hotwords in New Windows" => "Hotwords in Nieuwe Vensters",
"Edit CSS" => "Werk CSS bij",
"Custom Home" => "Eigen Thuis",
"HTML Pages" => "HTML Pagina's",
"Dynamic Content System" => "Dynamisch Inhoud Systeem",
"Allow Smileys" => "Laat Smileys toe",
"AutoLinks" => "AutoKoppelingen",
"Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Gebruik Quote plugin eerder dan &ldquo;>&rdquo; om tekst aan te halen",
"Administration Features" => "Onderdelen Beheer",
"Banning System" => "Banning Systeem",
"Banning system" => "Verbanningsssysteem",
"Communications (send/receive objects)" => "Communicatie (objecten zenden/ontvangen)",
"Theme Control" => "Themacontrole",
"XMLRPC API" => "XMLRPC-API",
"Referer Stats" => "Verwijzerstatistieken",
"Contact Us" => "Contacteer Ons",
"Contact Us (Anonymous)" => "Contacteer Ons (Anoniem)",
"User Features" => "Gebruiker Onderdelen",
"User Preferences Screen" => "Gebruikervoorkeuren Scherm",
"Users can Configure Modules" => "Gebruikers kunnen Modules configureren",
"always" => "altijd",
"module decides" => "module beslist",
"never" => "nooit",
"Users can Shade Modules" => "Gebruikers kunnen Modules in Schaduw plaatsen",
"User Watches" => "Gebruikermonitors",
"User Watches Translations" => "Gebruikers Monitoren Vertalingen",
"User Tasks" => "Gebruikertaken",
"User Messages" => "Gebruikerboodschappen",
"User Files" => "Gebruikerbestanden",
"User Notepad" => "Gebruikerkladblok",
"General Layout options" => "Algemene lay-outopties",
"Users can Flip Columns" => "Gebruikers kunnen Kolommen Verwisselen",
"Left column" => "Kolom links",
"user decides" => "gebruiker beslist",
"Layout per section" => "Lay-out per sectie",
"Right column" => "Kolom rechts",
"Admin layout per section" => "Lay-out per sectie beheren",
"Top bar" => "Bovenbalk",
"Bottom bar" => "Onderbalk",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "Om bestandgalerijen aan te maken of te verwijderen, ga naar \"Bestadgalerijen\" n het applicatiemenu, of",
"Home Gallery" => "Thuisgalerij",
"Home Gallery (main gallery)" => "Startgalerij (hoofdgalerij)",
"Galleries features" => "Galerij-onderdelen",
"Allow same file to be uploaded more than once" => "Laat toe om hetzelfde bestand meermaals aan te leveren",
"Use database to store files" => "Databank gebruiken om bestanden op te slaan",
"Use a directory to store files" => "Een folder gebruiken om bestanden op te slaan",
"Directory path" => "Folderpad",
"Uploaded filenames must match regex" => "Namen van aangeleverde bestanden moeten overeenkomen met reguliere uitdrukking",
"Uploaded filenames cannot match regex" => "Namen van aangeleverde bestanden mogen niet overeenkomen met reguliere uitdrukking",
"Storing files in a directory" => "Sla bestanden op in een folder",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Indien u besluit om bestanden in een folder op te slaan, dient u ervoor te zorgen dat de gebruiker geen rechtstreekse toegang heeft tot deze folder.",
"You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "U heeft twee manieren om dit te bewerkstelligen:<br /><ul><li>Gebruik een folder die buiten uw \\'document root\\' ligt, zorg er dan wel voor dat het Tiki in deze folder kan lezen en schrijven</li><li>Gebruik een folder die binnen uw \\'document root\\' ligt in combinatie met een .htaccess bestand om er voor te zorgen dat gebruikers de inhoud van de folder niet kunnen lijsten</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "Om het folderpad the configureren, gebruik UNIX-achtige paden bijv. bestanden/ of c:/foo/bestanden of /www/bestanden/",
"please read" => "aub lees",
"Gallery listing configuration" => "Galerijlijst configuratie",
"Change configuration" => "Verander configuratie",
"File galleries comments settings" => "Instellingen voor opmerkingen bij bestandgalerijen",
"File galleries search indexing" => "Bestandgalerijen zoekindexering",
"Leave command blank to delete handler" => "Laat commando blanco om \\'handler\\' te verwijderen",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Gebruik %1 om aan te geven waar de interne bestandsnaam moet worden vervangen (voorbeeld: \"strings %1\" om het document te converteren naar tekst via het UNIX \\'strings\\' commando)",
"Enable auto indexing on file upload or change" => "Schakel auto-indexering in bij aanlevering of wijziging bestand",
"System command" => "Systeemcommando",
"Reindex all files for search" => "Herindexeer alle bestanden voor de zoekfunctie",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "Om forums toe te voegen of te verwijderen, ga naar \"Beheer forums\" onder \"Forums\" in het applicatiemenu, of",
"Home Forum" => "Thuisforum",
"Home Forum (main forum)" => "Startforum (hoofdforum)",
"Forums features" => "Forumkenmerken",
"Accept wiki syntax" => "Aanvaardt wiki schrijfwijze",
"Forum quick jumps" => "Forum snelkoppelingen",
"Ordering for forums in the forum listing" => "Sortering van forums in forumlijsten",
"Creation Date (desc)" => "Aanmaakdatum (dalend)",
"Topics (desc)" => "Onderwerpen (dalend)",
"Threads (desc)" => "Threads (dalend)",
"Last post (desc)" => "Laatst aangeleverd (dalend.)",
"Name (desc)" => "Naam (dalend)",
"Name (asc)" => "Naam (stijgend)",
"Forum listing configuration" => "Forumlijst configuratie",
"Topics" => "Onderwerpen",
"Posts per day" => "Bijdragen per dag",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "Om afbeeldinggalerijen toe te voegen of te verwijderen, ga naar \"Afbeeldinggalerijen\" in het applicatiemenu, of",
"You can upload images of a size of " => "U kan afbeeldingen aanleveren tot een grootte van ",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Pas de php.ini file_uploads, upload_max_filesize, post_max_size en database variables aan (max_allowed_packet voor mysql) om deze waarde te veranderen",
"Uses Slideshow" => "Gebruik Slideshow",
"Use database to store images" => "Databank gebruiken om afbeeldingen op te slaan",
"Use a directory to store images" => "Een folder gebruiken om afbeeldingen op te slaan",
"Library to use for processing images" => "Bibliotheek om afbeeldingen te verwerken",
"Uploaded image names must match regex" => "Namen van aangeleverde afbeeldingen moeten overeenkomen met reguliere uitdrukking",
"Uploaded image names cannot match regex" => "Namen van aangeleverde afbeeldingen mogen niet overeenkomen met reguliere uitdrukking",
"Directory Batch Loading" => "Folder Bulk Aanlevering",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Indien u Folder Bulk Aanlevering inschakelt, dient u een leesbare folder aan te maken (buiten uw webruimte is beter). Voorzie dan een manier om afbeeldingen aan te leveren, bijv. via scp, ftp, of een ander protokol",
"Enable directory batch loading" => "Schakel folder bulk aanlevering in",
"Batch loading directory" => "Folder bulk aanlevering",
"Enable cache images to all galleries" => "Schakel afbeeldingenbuffer in voor alle galerijen",
"Images cache directory" => "Afbeeldingenbuffer folder",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Afbeeldingen in de systeemgalerij die niet gebruikt worden in wikipagina's, artikelen en journaalbijdragen verwijderen",
"All galleries" => "Alle gallerijen",
"Move" => "Verplaats",
"images" => "afbeeldingen",
"Image galleries comments settings" => "Instellingen voor opmerkingen bij beeldgalerijen",
"General Preferences" => "Algemene Voorkeuren",
"Theme" => "Thema",
"Change style only" => "Verander enkel de stijl",
"Slideshows theme" => "Thema voor diavoorstellingen",
"Use group homepages" => "Gebruik groep thuispagina's",
"Go to group homepage only if login from default homepage" => "Ga naar de groep thuispagina enkel en alleen als de aanmelding gebeurt via de standaard thuispagina",
"Use URI as Home Page" => "URI als startpagina gebruiken",
"Home page" => "Startpagina",
"Custom home" => "Aangepaste startpagina",
"Detect browser language" => "Detecteer browser taal",
"Use database for translation" => "Gebruik databank voor vertaling",
"Record untranslated" => "Record onvertaald",
"OS" => "Besturingssysteem",
"Unknown/Other" => "Niet gekend/Andere",
"PHP error reporting level for non-admin:" => "PHP foutrapportage niveua voor niet-beheerders:",
"No error reporting" => "Geen fouten rapportage",
"Report all PHP errors" => "Rapporteer alle PHP fouten",
"Report all errors except notices" => "Rapporteer alle fouten behalve berichten",
"Report PHP errors only for admin" => "Laat PHP-fouten enkel voor beheerders zien",
"Default charset for sending mail:" => "Standaard karakterset voor het sturen van mail:",
"Mail end of line:" => "Mail regeleinde:",
"(standard)" => "(standaard)",
"(some Unix MTA)" => "(eenderwelke Unix MTA)",
"General Settings" => "Algemene Instellingen",
"Disallow access to the site (except for those with permission)" => "Verbiedt toegang tot de site (behalve voor diegenen met toestemming)",
"Message to display when site is closed" => "Bericht dat wordt getoond als de site gesloten is",
"Disallow access when load is above the threshold (except for those with permission)" => "Verbiedt toegang tot de site wanneer de belasting boven de toegestane limiet is (behalve voor diegenen met toestemming)",
"Max average server load threshold in the last minute" => "Max gemiddelde belastingslimiet in de laatste minuut",
"Message to display when server is too busy" => "Bericht dat wordt getoond wanneer de belasting te hoog is",
"Open external links in new window" => "Externe koppelingen in een nieuw venster openen",
"Display modules to all groups always" => "Modules altijd aan alle groepen tonen",
"Use cache for external pages" => "Buffer gebruiken voor externe pagina's",
"Use cache for external images" => "Buffer gebruiken voor externe afbeeldingen",
"Use direct pagination links" => "Directe pagineringskoppelingen gebruiken",
"Display menus as folders" => "Toon menu's als folders",
"Use gzipped output" => "Gecomprimeerde uitvoer (gzip) gebruiken",
"output compression is active." => "Uitvoercompressie is actief.",
"compression is handled by" => "compressie wordt gedaan door",
"Count admin pageviews" => "Paginabezichtigingen beheerder meetellen",
"Hide anonymous-only modules from registered users" => "Verberg anonieme modules voor niet-geregistreerde gebruikers",
"Server name (for absolute URIs)" => "Servernaam (voor absolute URIs)",
"Automatic (uses HTTPS variable)" => "Automatisch (gebruikt HTTPS variabele)",
"No" => "Neen",
"Yes" => "Ja",
"Browser title" => "Browsertitel",
"Wiki_Tiki_Title" => "Wiki_Tiki_Titel",
"Temporary directory" => "Voorlopige folder",
"Sender Email" => "Verzender E-mail",
"Contact user" => "Gebruiker contacteren",
"Allow anonymous users to \"Contact Us\"" => "Geen anonieme gebruikers toestemming om \"Contacteer Ons\" te gebruiken",
"contact feature disabled" => "contact-onderdeel uitgeschakeld",
"Store session data in database" => "Bewaar sessiegegevens in databank",
"Session lifetime in minutes" => "Levensduur van sessie in minuten",
"Use proxy" => "Gebruik proxy",
"Proxy Host" => "Proxy Server",
"Proxy port" => "Proxy Poort",
"Maximum number of records in listings" => "Maximaal aantal records in opsommingen",
"Date and Time Formats" => "Datum en Tijd Formaten",
"Long date format" => "Lang datumformaat",
"Short date format" => "Kort datumformaat",
"Long time format" => "Lang tijdformaat",
"Short time format" => "Kort tijdformaat",
"Date and Time Format Help" => "Datum en Tijd Formaat Help",
"Favicon icon file name:" => "Favicon ikoon bestandsnaam:",
"Favicon icon MIME type:" => "Favicon ikoon MIME type:",
"Locations separator" => "Scheidingsteken Locaties",
"Register this site at tikiwiki.org" => "Registreer deze site op tikiwiki.org",
"Click here for more details." => "Klik hier voor meer details.",
"Change admin password" => "Wachtwoord beheerder wijzigen",
"New password" => "Nieuw wachtwoord",
"Change password" => "Verander wachtwoord",
"Reg users can change language" => "Gereg. gebruikers kunnen taal wijzigen",
"Restrict available languages" => "Beperk beschikbare taken",
"Available languages:" => "Beschikbare taken:",
"Edit or ex/import Languages" => "Bewerken of im-/export Talen",
"Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Tiki instellingen waardeveld in de databank is momenteel max. 250 karakters lang. Dat geldt eveneens voor alle aangepaste inhoud. Controleer deze databank tabel indien u deze databank tabel wenst aan te passen zodat deze meer dan 250 karakters per veld ondersteunt (ook al werden aanpassingen voorheen uitgevoerd en getest met mysql zonder problemen, dient u toch eerst een reservekopie van uw databank te maken)",
"port" => "poort",
"path" => "pad",
"groups" => "groepen",
"Enable/disable Tiki features in " => "Schakel in/uit Tiki kenmerk ",
"Admin->Features" => "Beheer->Kenmerken",
", but configure them elsewhere" => ", maar configureer deze elders",
"Users &amp; groups" => "Gebruikers &amp; groepen",
"Admin groups" => "Groepen beheren",
"Admin users" => "Gebruikers beheren",
"User registration and login" => "Gebruikerregistratie en -aanmelding",
"Authentication method" => "Authenticatie methode",
"Just Tiki" => "Alleen Tiki",
"Tiki and PAM" => "Tiki en PAM",
"CAS (Central Authentication Service)" => "CAS (Centrale Authenticatie Service)",
"Use WebServer authentication for Tiki" => "Alleen WebServer authenticatie voor Tiki",
"Users can register" => "Gebruikers kunnen zich registreren",
"... but need admin validation" => "... maar heeft een validatie door beheerder nodig",
"Create a group for each user <br />(with the same\nname as the user)" => "Maak een groep aan voor elke gebruiker <br />(met dezelfde\nnaam als de gebruiker)",
"Use tracker for more user information" => "Gebruik tracker voor meer gebruikerinformatie",
"Use tracker for more group information" => "Gebruik tracker voor meer groupinformatie",
"Request passcode to register" => "Pascode voor registratie vragen",
"Prevent automatic/robot registration" => "Voorkom automatische/robot registraties",
" - Php GD library required" => " - Php GD bibliotheek vereist",
"Validate users by email" => "Gebruikers via e-mail valideren",
"Validate email address (may not work)" => "Valideer e-mail adres (werkt mogelijk niet)",
"Store plaintext passwords" => "Plaintext wachtwoorden opslaan",
"Reg users can change password" => "Geregistreerde gebruikers kunnen hun wachtwoord veranderen",
"Reg users can change theme" => "Gereg. gebruikers kunnen thema wijzigen",
"Restrict available themes" => "Beperk beschikbare thema's",
"Available styles:" => "Beschikbare stijlen:",
"Maximum mailbox size (messages, 0=unlimited)" => "Maximum grootte postbus (berichten, 0=onbeperkt)",
"Maximum mail archive size (messages, 0=unlimited)" => "Maximum grootte berichtenarchief (berichten, 0=onbeperkt)",
"Maximum sent box size (messages, 0=unlimited)" => "Maximum grootte verzend postbus (berichten, 0=onbeperkt)",
"Use challenge/response authentication" => "Challenge/response authentication gebruiken",
"Force to use chars and nums in passwords" => "Afdwingen om karakters en cijfers te gebruiken in wachtwoorden",
"Minimum password length" => "Minimale wachtwoordlengte",
"Password invalid after days" => "Wachtwoord ongeldig na aantal dagen",
"Require HTTP Basic authentication" => "HTTP basic authentication vereisen",
"Allow secure (https) login" => "Veilige (https) aanmelding toestaan",
"Require secure (https) login" => "Veilige (https) aanmelding eisen",
"HTTP server name" => "HTTP-servernaam",
"HTTP port" => "HTTP-poort",
"HTTP URL prefix" => "HTTP-URL-prefix",
"HTTPS server name" => "HTTPS-servernaam",
"HTTPS port" => "HTTPS-poort",
"HTTPS URL prefix" => "HTTPS-URL-prefix",
"Remember me feature" => "Herinner-mij onderdeel",
"Only for users" => "Enkel voor gebruikers",
"Users and admins" => "Gebruikers en beheerders",
"Duration:" => "Duur:",
"day" => "dag",
"month" => "maand",
"year" => "jaar",
"Remember me name" => "Onthoudt mijn naam",
"Remember me domain" => "Herinner mij domein",
"Remember me path" => "Herinner mij pad",
"Protect against CSRF with a confirmation step" => "Bescherm tegen CSRF met confirmatie stap",
"Protect against CSRF with a ticket" => "Bescherm tegen CSRF met een ticket",
"Highlight Group" => "Breng Groep naar voren",
"choose a group ..." => "kies een groep ...",
"Create user if not in Tiki?" => "Maak gebruiker aan indien niet in Tiki?",
"Create user if not in Auth?" => "Maak gebruiker aan indien niet in Auth?",
"Just use Tiki auth for admin?" => "Gebruik Tiki auth voor beheerder?",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(indien gebruikt zal deze waarde de benedenstaanden Host en Port instelling overschrijven)",
"LDAP Scope" => "LDAP Gebied",
"LDAP Base DN" => "LDAP Basis DN",
"LDAP User DN" => "LDAP Gebruiker DN",
"LDAP User Attribute" => "LDAP Gebruikerattributen",
"LDAP User OC" => "LDAP Gebruiker OC",
"LDAP Group DN" => "LDAP Groep DN",
"LDAP Group Attribute" => "LDAP Groep Attribuut",
"LDAP Group OC" => "LDAP Groep OC",
"LDAP Member Attribute" => "LDAP Ledenattributen",
"LDAP Member Is DN" => "LDAP Lid Is DN",
"LDAP Admin User" => "LDAP Beheerder",
"LDAP Admin Pwd" => "LDAP Beheer Pwd",
"Currently unused" => "Momenteel niet in gebruik",
"CAS server version" => "CAS server versie",
"Version 1.0" => "Versie 1.0",
"Version 2.0" => "Versie 2.0",
"CAS server hostname" => "CAS server hostnaam",
"CAS server port" => "CAS server poort",
"CAS server path" => "CAS server pad",
"Change CAS preferences" => "Wijzig CAS voorkeuren",
"full path to mapfiles" => "volledig pad naar de landkaartbestanden",
"default mapfile" => "standaard landkaartbestand",
"Wiki Page for Help" => "Wiki Pagina voor Help",
"Wiki Page for Comments" => "Wiki Pagina voor Commentaar",
"Full path to gdaltindex" => "Volledig pad naar gdaltindex",
"Full path to ogr2ogr" => "Volledig pad naar ogr2ogr",
"Map Zone" => "Kaart Zone",
"Generate User Map" => "Maak Gebruikerskaart aan",
"<b>Value</b>" => "<b>Waarde</b>",
"Meta Keywords" => "Meta Kernwoorden",
"Meta Description" => "Meta Beschrijving",
"Meta Author" => "Meta Auteur",
"geo.position" => "geo.positie",
"geo.region" => "geo.regio",
"geo.placename" => "geo.plaatsnaam",
"revisit after" => "bezoek opnieuw na",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "Om opiniepeilingen toe te voegen of te verwijderen, ga naar \"Opiniepeiligen\" onder \"Beheer\" in het applicatiemenu, of",
"Allow Anonymous Poll Voting" => "Geef anonieme gebruikers toestemming om te Stemmen in Opiniepeilingen",
"This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or" => "Deze pagina dient voor de configuratie van de RSS-invoerstromen aangemaakt door Tiki. Om RSS-invoerstromen te kunnen lezen/importeren, ga naar \"RSS-modules\" in het applicatie menu, of",
"<b>Feed</b>" => "<strong>Invoer</strong>",
"<b>enable/disable</b>" => "<strong>aanzetten/uitzetten</strong>",
"<b>Max number of items</b>" => "<strong>Max aantal items</strong>",
"Feed for Articles" => "Invoer voor Artikelen",
"Feed for Weblogs" => "Invoer voor Journalen",
"Feed for Image Galleries" => "Invoer voor Beeldgalerijen",
"Feed for File Galleries" => "Invoer voor Bestandgalerijen",
"Feed for the Wiki" => "Invoer voor de Wiki",
"Feed for individual Image Galleries" => "Invoer voor individuele Beeldgalerijen",
"Feed for individual File Galleries" => "Invoer voor individuele Bestandgalerijen",
"Feed for individual weblogs" => "Invoer voor individuele journalen",
"Feed for forums" => "Invoer voor forums",
"Feed for individual forums" => "Invoer voor individuele forums",
"Feed for mapfiles" => "Invoer voor landkaartbestanden",
"Feed for directories" => "Invoer voor directories",
"Feed for tracker items" => "Invoerstroom voor tracker items",
"Default RDF version" => "Standaard RDF versie",
"Specification" => "Specificatie",
"Documentation" => "Documentatie",
"You can see users rank by score in the module users_rank, for that go to" => "U kan de gebruikersrankschikking bekijken in de module users_rank, ga hiervoor naar",
"Admin modules" => "Beheer modules",
"Expiration" => "Verloopdatum",
"Search features" => "Zoek onderdelen",
"Full Text Search" => "Volledige Tekst Zoekfunctie",
"SearchStats" => "ZoekStats",
"Referer Search Highlighting" => "Breng Zoekverwijzer naar voeren (Referer Search)",
"Performance issues" => "Performatie problemen",
"Search may show forbidden results. Much better performance though." => "Zoekopdracht toont mogelijk verboden resultaten. Performatie is echter veel beter.",
"Ignore individual object permissions" => "Negeer individuele objectpermissies",
"Ignore category viewing restrictions" => "Negeer restrictries op bezichtiging van categorie&euml;n",
"Settings for searching content" => "Instellingen voor zoeken op inhoud",
"Search refresh rate" => "Ververs tempo voor zoeken",
"Minimum length of search word" => "Minimum lengte van zoekterm",
"Max. number of words containing a syllable" => "Max. aantal woorden met een lettergreep",
"Max. age in hours of syllable search cache" => "Max. leeftijd in uren van de lettergrepen zoekbuffer",
"LRU list purging rate" => "LRU lijst zuiveringstempo",
"LRU list length" => "LRU lijst lengte",
"Don't forget: to use feature you will need to enable it on" => "Vergeet niet: om het kenmerk te gebruiken dient u het eerst in te schakelen",
"Custom Code" => "Aangepaste Code",
"Custom code" => "Aangepaste code",
"Content" => "Inhoud",
"Publish" => "Publiceren",
"Site Breadcrumbs" => "Site Broodkruimels",
"Site breadcrumbs" => "Site broodkruimels",
"Site location bar" => "Site locatiebalk",
"at top of page" => "aan de bovenkant van de pagina",
"at top of center column" => "aan de bovenkant van de middenkolom",
"Prefix breadcrumbs with 'Location:' label?" => "Prefix broodkruimels met 'Locatie:' label?",
"Larger font for" => "Groter lettertype voor",
"entire location" => "volledige locatie",
"page name" => "paginanaam",
"Use page description:" => "Gebruik paginabeschrijving:",
"Site Search" => "Site Zoekfunctie",
"Site search bar" => "Site Zoekbalk",
"Site logo source" => "Site logo bron",
"Site logo background color" => "Site logo achtergrondkleur",
"Site logo title (on mouse over)" => "Site logo titel (bij muisaanwijzing)",
"Alt. description (e.g. for text browsers)" => "Alt. beschrijving (e.g. voor tekst browsers)",
"Site Ads and Banners" => "Site Advertenties en Banners",
"Site ads and banners" => "Site advertenties en banners",
"Site menu bar" => "Site menubalk",
"Note: This feature also requires phplayers to be turned on in Admin->Features" => "Opmerking: Dit kenmerk vereist ook dat de phplayers functionaliteit ingeschakeld is in Admin->Kenmerken",
"To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "Om de trackers te configureren, ga naar \"Admin trackers\" onder \"Trackers\" in het applicatiemenu, of",
"Trackers attachments preferences" => "Instellingen Trackers bijlagen",
"Path" => "Pad",
"Trackers attachments" => "Trackers bijlagen",
"Storage" => "Opslag",
"change" => "wijzigen",
"Change all to db" => "Verplaats alles naar db",
"Change all to file" => "Verplaats alles naar bestanden",
"Use database to store userfiles" => "Gebruik databank om gebruikerbestanden op te slaan",
"Use a directory to store userfiles" => "Gebruik een folder om gebruikerbestanden op te slaan",
"Allow viewing HTML mails?" => "Laat bezichtiging HTML e-mails toe?",
"Maximum size for each attachment" => "Maximale grootte per bijlage",
"Unlimited" => "Onbeperkt",
"To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "Om wiki pagina's toe te voegen of te bewerken, ga naar de module quick_edit via \"Modules\" in het applicatiemenu, of",
"Generate dump" => "Dump aanmaken",
"Download last dump" => "Laatste dump afhalen",
"Create a Tag for the Current Wiki" => "Maak een label aan voor het huidig Wiki",
"Tag name" => "Labelnaam",
"Restore the Wiki" => "Zet het Wiki terug",
"restore" => "herstellen",
"Remove a Tag" => "Verwijder een Label",
"Wiki Comments Settings" => "Instellingen Wiki Commentaar",
"Export Wiki Pages" => "Exporteer wikipagina's",
"Export" => "Exporteren",
"Wiki Administration" => "Wiki Beheer",
"Manage attachment preferences" => "Bijlagevoorkeuren beheren",
"Remove unused pictures" => "Ongebruikte afbeeldingen verwijderen",
"Wiki Home Page" => "Wiki-startpagina",
"Wiki Discussion" => "Wiki Discussie",
"Discuss pages on forums" => "Discussieer over pagina's in forums",
"Wiki Link Format" => "Formaat Wikikoppeling",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Bepaalt herkenning van wikikoppelingen gebruik makend van de dubbele haken schrijfwijze <i>((paginanaam))</i>.",
"complete" => "volledig",
"latin" => "latijn",
"english" => "engels",
"Wiki Page List Configuration" => "Wiki Paginalijst Configuratie",
"Creator" => "Auteur",
"Last version" => "Laatste versie",
"Versions" => "Versies",
"Backlinks" => "Terugkoppelingen",
"Wiki 3D Browser Configuration" => "Wiki 3D Browser Configuratie",
"Enable wiki 3D browser" => "Inschakelen wiki 3D browser",
"Browser width" => "Browser breedte",
"Browser height" => "Browser hoogte",
"Navigation depth" => "Navigatiediepte",
"Feed animation interval (milisecs)" => "Animatiestroom interval (milliseconden)",
"Existing page node color" => "Kleur aanwezige paginanode",
"Missing page node color" => "Kleur ontbrekende paginanode",
"HTML in Wiki Pages" => "HTML in Wiki Pagina\\'s",
"Wiki syntax used when a page contains HTML" => "Wiki syntax gebruiken wanneer een pagina HTML bevat",
"full" => "volledig",
"partial" => "gedeeltelijk",
"default" => "standaard",
"optional" => "facultatief",
"Wiki Features" => "Wiki Onderdelen",
"Anonymous editors must input anti-bot code" => "Anonieme auteurs moeten anti-bot code invoeren",
"Undo" => "Ongedaan maken",
"PDF generation" => "PDF creatie",
"Warn on edit conflict" => "Waarschuw bij conflict ivm bijwerken",
"Edit idle timeout" => "Verloop ongebruikte tijd ivm bijwerken",
"Pictures" => "Afbeeldingen",
"Use page description" => "Paginaomschrijving gebruiken",
"Show page title" => "Paginatitel tonen",
"Show page ID" => "Toon pagina ID",
"Cache wiki pages (global)" => "Buffer wiki pagina's (globaal)",
"Individual cache" => "Individuele buffer",
"Users can lock pages (if perm)" => "Gebruikers kunnen pagina's vergrendelen (indien toestemming)",
"Use WikiWords" => "gebruik WikiWoorden",
"Accept dashes and underscores in WikiWords" => "Accepteer liggend streepje en onderlijn streepje in WikiWorden",
"Link plural WikiWords to their singular forms" => "Koppel meervouds-WikiWoorden aan hun enkelvoudige varianten",
"Use Wiki paragraph formatting" => "Gebruik Wiki paragraafformattering",
"Automonospaced text" => "Auto-vastespatie tekst",
"Tables syntax" => "Tabellen schrijfwijze",
"|| for rows" => "|| voor rijen",
"\\n for rows" => "\\n voor rijen",
"Open page as structure" => "Open pagina als struktuur",
"Use external link icons" => "Gebruik ikonen voor externe koppelingen",
"User's Page" => "Gebruikerpagina",
"UserPage prefix" => "GebruikerPagina prefix",
"Page creators are admin of their pages" => "Pagina auteurs zijn beheerder van hun eigen pagina's",
"List authors" => "Lijst auteurs",
"as Creator &amp; Last Editor" => "als Auteur &amp; Laatste Bewerker",
"Business style" => "Zakelijke stijl",
"Collaborative style" => "Collaboratieve stijl",
"no (disabled)" => "neen (uitgeschakeld)",
"Wiki History" => "Wikigeschiedenis",
"Maximum number of versions for history" => "Maximaal aantal versies in geschiedenis",
"unlimited" => "onbeperkt",
"Never delete versions younger than days" => "Nooit versies verwijderen jonger dan aantal dagen",
"Diff style" => "Verschillen stijl",
"Only with last version" => "Enkel met de laatste versie",
"Any 2 versions" => "Eender welke 2 versies",
"Copyright Management" => "Auteursrechten beheren",
"Enable Feature" => "Maak optie beschikbaar",
"License Page" => "Licentiepagina",
"Submit Notice" => "Lever bericht in",
"Wiki Watch" => "Wiki Monitor",
"Create watch for author on page creation" => "Zet een waker voor auteur tijdens pagina-aanmaak",
"Enable watch events when I am the editor" => "Activeer waker wanneer ik de editor ben",
"Enable watches on comments" => "Activeer wakers voor commentaren",
"Wiki attachments preferences" => "Voorkeuren Wiki bijlagen",
"Wiki attachments" => "Wikibijlagen",
"Help on Banning System" => "Hulp voor verbanningssysteem",
"View tpl" => "Bekijk sjabloon",
"admin banning tpl" => "banning beheren sjabloon",
"Add or edit a rule" => "Maak aan/wijzig een regel",
"Rule title" => "Regel titel",
"Username regex matching" => "Gebruikernaam regex paren",
"IP regex matching" => "IP regex paren",
"Banned from sections" => "Verbannen van de secties",
"check / uncheck all" => "vink aan/ vink uit allen",
"Rule activated by dates" => "Regel geactiveerd door datums",
"Rule active from" => "Regel actief sinds",
"Rule active until" => "Regel actief tot",
"Custom message to the user" => "Aangepast bericht aan de user",
"Rules" => "Regels",
"User/IP" => "Gebruiker/IP",
"Sections" => "Secties",
"Admin Calendars" => "Kalenders beheren",
"Configure/Options" => "Instellingen/Opties",
"List of Calendars" => "Kalenderlijst",
"participants" => "deelnemers",
"lang" => "taal",
"subscription" => "abonnement",
"permissions" => "permissies",
"Create/edit Calendars" => "Maak aan/Bewerk Kalenders",
"Custom Locations" => "Aangepaste Locaties",
"yes" => "ja",
"Custom Participants" => "Manuele Deelnemers",
"Custom Categories" => "Aangepaste Categorie&euml;n",
"Custom Languages" => "Aangepaste Talen",
"Custom Subscription List" => "Manuele Deelnemerslijst",
"Custom Priorities" => "Aangepaste Prioriteiten",
"Personal Calendar" => "Persoonlijke Kalender",
"admin categories" => "categorie&euml;n beheren",
"admin categories tpl" => "beheer categorie&euml;n sjabloon",
"browse the category system" => "bekijk het categorie&euml;nsysteem",
"Current category" => "Huidige categorie",
"Child categories" => "Ondergeschikte categorie&euml;n",
"Edit this category:" => "Bewerk deze categorie:",
"create new" => "maak nieuwe aan",
"Add new category" => "Voeg nieuwe categorie toe",
"Parent" => "Ouder",
"Perms inherited from closest parent if possible or from global perms" => "Permissies ge-erfd van de kortste bijliggende ouder indien aanwezig of van globale permissies",
"Assign permissions automatically" => "Wijs permissies automatisch toe",
"recommended for best performance" => "aangewezen voor de beste performantie",
"Edit permissions for this category" => "Bewerk permissions voor deze categorie",
"Objects in category" => "Objecten in categorie",
"Add objects to category" => "Objecten aan een categorie toevoegen",
"image gal" => "beeldgal.",
"file gal" => "bestandgal.",
"Admin chart items" => "Rangschikking items beheren",
"charts" => "rangschikkingen",
"edit chart" => "bewerk rangschikking",
"Add or edit an item" => "Toevoegen/bewerken item",
"update" => "bijwerken",
"Chart items" => "Rangschikking items",
"No items defined yet" => "Nog geen items gedefinieerd",
"Admin charts" => "Rangschikkingen beheren",
"View template" => "Bekijk sjabloon",
"admin charts template" => "rangschikkingen sjabloon beheren",
"Add or edit a chart" => "Aanmaken/bewerken rangschikking",
"Active" => "Actief",
"Users can vote for only one item from this chart per period" => "Gebruikers kunnen slechts voor &eacute;&eacute; item van deze rangschikking stemmen per periode",
"Prevent users from voting for the same item more than once" => "Voorkom dat gebruikers meer dan eens voor hetzelfde item stemmen",
"Users can suggest new items" => "Gebruikers kunnen nieuwe items aanbrengen",
"Auto validate user suggestions" => "Auto-valideer gebruikersuggesties",
"Ranking shows" => "Rankschikking toont",
"All items" => "Alle items",
"Voting system" => "Stem-systeem",
"Vote items" => "Stem items",
"Rank 1..5" => "Rang 1..5",
"Rank 1..10" => "Rang 1..10",
"Ranking frequency" => "Rangschikking-frequentie",
"Realtime" => "Echte-tijd",
"Each 5 minutes" => "Elke 5 minuten",
"Daily" => "Dagelijks",
"Weekly" => "Wekelijks",
"Monthly" => "Maandelijks",
"Show Average" => "Gemiddelde Tonen",
"Show Votes" => "Stemmen Tonen",
"Use Cookies for unregistered users" => "Gebruik Cookies voor niet-geregistreerde gebruikers",
"Users can vote again after" => "Gebruikers kunnen opnieuw stemmen na",
"Anytime" => "Altijd",
"5 minutes" => "5 minuten",
"1 day" => "1 dag",
"1 month" => "1 maand",
"Ranks" => "Rangen",
"No charts defined yet" => "Nog geen rangschikkingen gedefinieerd",
"Chat Administration" => "Praatkamer beheren",
"Chat Admin" => "Praat Beheer",
"Chat Admin tpl" => "Praat Beheer sjabloon",
"Create/edit channel" => "Kanaal maken/bewerken",
"Refresh rate" => "Verversingsfrequentie",
"Half a second" => "Halve seconde",
"second" => "seconde",
"Chat channels" => "Praatkanalen",
"active" => "actief",
"Admin templates" => "Sjablonen beheren",
"admin content templates" => "inhoudsjablonen beheren",
"admin content templates template" => "inhoudsjablonen sjabloon beheren",
"Edit this template:" => "Bewerk dit sjabloon:",
"Create new template" => "Maak nieuw sjabloon aan",
"use in cms" => "in CMS gebruiken",
"use in wiki" => "in wiki gebruiken",
"use in newsletters" => "in nieuwsbrieven gebruiken",
"use in events" => "gebruik in gebeurtenissen",
"use in HTML pages" => "in HTML-pagina's gebruiken",
"template" => "sjabloon",
"Templates" => "Sjablonen",
"last modif" => "laatst gewijzigd",
"sections" => "secties",
"Admin cookies" => "Cookies beheren",
"admin FortuneCookie" => "Gelukkoekje beheren",
"admin FortuneCookie tpl" => "Gelukkoekje beheren sjabloon",
"Create/edit cookies" => "Koekjes maken/bewerken",
"Upload Cookies from textfile" => "Cookies uit tekstbestanden aanleveren",
"Upload from disk:" => "Van harde schijf aanleveren:",
"upload" => "aanleveren",
"Remove all cookies" => "Alle cookies verwijderen",
"Help on Drawings" => "Hulp voor Tekeningen",
"admin Drawings tpl" => "Tekeningen beheren sjabloon",
"Available drawings" => "Beschikbare tekeningen",
"Admin DSN" => "Beheer DSN",
"tiki-admin_dsn tpl" => "tiki-admin_dsn sjabloon",
"Create/edit dsn" => "Aanmaken/bewerken dsn",
"Admin external wikis" => "Externe wiki's beheren",
"admin External Wikis" => "beheer Externe Wiki\\'s",
"tiki admin external wikis template" => "tiki externe wiki's sjabloon beheren",
"Create/Edit External Wiki" => "Maak aan/Bewerk Extern Wiki",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (gebruik \$pagina om deze te laten vervangen door de pagina in de URL, bijv http://www.example.com/tiki-index.php?page=\$pagina)",
"Admin Forums" => "Forums Beheren",
"admin forums template" => "forums sjabloon beheren",
"Create new forum" => "Maak nieuw forum aan",
"Edit existing forums" => "Bewerk bestaande forums",
"Edit this Forum:" => "Bewerk dit Forum:",
"Create New Forum" => "Maak Nieuw Forum aan",
"There are individual permissions set for this forum" => "Er zijn individuele permissies gezet voor dit forum",
"Show description" => "Toon beschrijving",
"Prevent flooding" => "Flooding voorkomen",
"Minimum time between posts" => "Minimale tijdsspanne tussen bijdragen",
"Topics per page" => "Onderwerpen per pagina",
"Section" => "Sectie",
"Create new" => "Maak nieuw",
"Moderator user" => "Moderator gebruiker",
"Moderator group" => "Moderator groep",
"Password protected" => "Beveiligd door wachtwoord",
"Topics only" => "Alleen onderwerpen",
"All posts" => "Alle bijdragen",
"Forum password" => "Forum wachtwoord",
"Default ordering for topics" => "Standaardsortering voor onderwerpen",
"Date (desc)" => "Datum (dalend)",
"Date (asc)" => "Datum (opl)",
"Score (desc)" => "Score (dalend)",
"Replies (desc)" => "Antwoorden (dalend)",
"Reads (desc)" => "Aantal gelezen (dalend)",
"Title (desc)" => "Titel (dalend)",
"Title (asc)" => "Titel (stijgend)",
"Default ordering for threads" => "Standaardsortering voor threads",
"Send this forums posts to this email" => "Deze forumbijdragen naar het volgende e-mail adres zenden",
"Prune unreplied messages after" => "Niet beantwoorde berichten verwijderen na",
"Prune old messages after" => "Oude berichten verwijderen na",
"Topic list configuration" => "Onderwerplijst configuratie",
"Replies" => "Antwoorden",
"Posts can be rated" => "Berichten kunnen gewaardeerd worden",
"Display last post titles" => "Toon titles van laatste berichten",
"no display" => "geen vertoning",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Stuur berichten bestemd voor dit form door naar dit e-mail adres in een formaat dat kan gebruikt worden om het bericht terug te sturen naar het inkomende forum email adres",
"Send mails even when the post is generated by inbound mail" => "Stuur berichten zelfs indien de post werd aangemaakt voor intern gebruik",
"Append a reply link to outbound mails" => "Voeg een antwoordkoppeling toe aan uitgaande berichten",
"Originating e-mail address for mails from this forum" => "E-mail adres van oorsprong voor e-mails vertrekkende van dit forum",
"Add messages from this email to the forum" => "Voeg berichten via dit e-mail adres toe aan dit forum",
"Use topic smileys" => "Gebruik smilies voor onderwerpen",
"Show topic summary" => "Toon samenvatting onderwerp",
"User information display" => "Gebruikerinformatie",
"avatar" => "pictogram",
"flag" => "vlag",
"Approval type" => "Aanvaardingstype",
"All posted" => "Alle bijdragen toegevoegd",
"Queue anonymous posts" => "Plaats anonieme bijdragen in de wachtrij",
"Queue all posts" => "Plaats alle bijdragen in de wachtrij",
"Attachments" => "Bijlagen",
"No attachments" => "Geen bijlagen",
"Everybody can attach" => "Iedereen mag bijlagen toevoegen",
"Only users with attach permission" => "Alleen gebruikers met toestemming om bijlagen toe te voegen",
"Moderators and admin can attach" => "Moderatoren en beheerder kunnen bijlagen toevoegen",
"Store attachments in:" => "Bewaar bijlagen in:",
"Database" => "Databank",
"Max attachment size (bytes)" => "Max grootte bijlagen (bytes)",
"Edit Existing Forums" => "Werk bestaande forums bij",
"topics" => "onderwerpen",
"coms" => "opm.",
"age" => "ouderdom",
"last post" => "laatste bijdrage",
"Assign Permissions (Active)" => "Wijs Permissies toe (Actieve)",
"Assign Permissions" => "Wijs Permissies toe",
"Click here to delete this forum" => "Klik hier om het forum te verwijderen",
"Admin Hotwords" => "Hotwords Beheren",
"admin hotwords" => "hotwords beheren",
"admin hotwords template" => "hotwords sjabloon beheren",
"Add Hotword" => "Hotword Toevoegen",
"Word" => "Woord",
"Add" => "Toevoegen",
"admin HTML page dynamic zones" => "HTML pagina dynamische zones beheren",
"Admin HTML pages" => "HTML pagina's beheren",
"Edit this page" => "Deze pagina bewerken",
"View page" => "Pagina bekijken",
"Edit zone" => "Zone bewerken",
"Dynamic zones" => "Dynamische zones",
"content" => "inhoud",
"Mass update" => "Massabijwerking",
"admin Html Pages" => "beheer Html Pagina\\'s",
"admin Html Pages template" => "beheer Html Pagina\\s sjabloon",
"Create new HTML page" => "Maak nieuwe HTML pagina aan",
"Edit this HTML page:" => "Bewerk deze HTML pagina:",
"Page name" => "Paginanaam",
"Dynamic" => "Dynamisch",
"Static" => "Statisch",
"Refresh rate (if dynamic) [secs]" => "Frequentie waarmee geactualiseerd wordt (indien dynamisch) [sec.]",
"Edit Repository:" => "Bewerk de bewaarplaats:",
"Create New Repository" => "Maak nieuwe bewaarplaats aan",
"list repositories" => "Opsommen bewaarplaatsen",
"new repository" => "nieuwe bewaarplaats",
"view repository" => "bekijk bewaarplaats",
"Human readable repository name" => "Leesbare naam van bewaarplaats",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Pad naar de bewaarplaats (lokaal bestandsysteem: relatief/absoluut pad web folder, ver: voorafgegaan door'http://')",
"File name of start page" => "Bestandnaam van de startpagina",
"Start page" => "Startpagina",
"CSS file to load when browse this repository" => "CSS bestand dat moet worden ingeladen tijdens het bekijken van deze bewaarplaats",
"CSS file" => "CSS bestand",
"Is repository visible to users" => "Is bewaarplaats zichtbaat voor gebruikers",
"Can files from repository be cached" => "Kunnen bestanden van bewaarplaats gebufferd worden",
"Cacheable" => "Mogelijkheid tot buffering",
"Are files from repository can be cached" => "Kunnen alle bestanden van bewaarplaats gebufferd worden",
"Clear all cached pages of this repository" => "Verwijder all gebufferde pagina's van deze bewaarplaats",
"Clear cache" => "Maak buffer leeg",
"Seconds count 'till cached page will be expired" => "Aantal seconden voordat gebufferde versie van de pagina verloopt",
"Cache expiration" => "Verlooptijd van de buffer",
"Human readable text description of repository" => "Leesbare beschrijving van de bewaarplaats",
"Available Repositories" => "Beschikbar Bewaarplaatsen",
"CSS File" => "CSS bestand",
"Edit rules" => "Werk regels bij",
"Edit Rules for Repository:" => "Bewerk regels voor bewaarplaats:",
"configure repositories" => "Configureer bewaarplaatsen",
"configure this repository" => "Configureer deze bewaarplaats",
"view this repository" => "bekijk deze bewaarplaats",
"Add new rule" => "voeg nieuwe regel toe",
"new rule" => "nieuwe regel",
"view/hide copy rules dialog" => "Toon/verberg regels kopie dialoog",
"copy rules" => "kopieer regels",
"Source repository" => "Bronbewaarplaats",
"Copy" => "Kopieer",
"According this order rules will be applied ('0' or empty = auto)" => "Regels worden toegepast volgens deze rangorde ('0' or leeg = auto)",
"Rule order" => "Regel volgorde",
"Text to search for" => "Zoektekst",
"Text to replace" => "Vervangtekst",
"Replace" => "Vervang",
"Is this regular expression or simple search/replacer" => "Is dit reguliere expressie of simpele zoek/vervang opdracht",
"Is case sensitive (for simple replacer)" => "Is hoofdlettergevoelig (voor simpele vervanger)",
"Case sensitive" => "Hoofdlettergevoelig",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "subset van chars: imsxeADSXUu, welke zijn regex-bepalingen",
"Regex modifiers" => "Regex-bepalingen",
"Human readable text description of rule" => "Leesbare beschrijving van regel",
"Check to enable this rule" => "Vlag aan om deze regle in te schakelen",
"Enabled" => "Ingeschakeld",
"Preview options" => "Voorbeeldopties",
"Apply all rules or just this to generate preview" => "Pas alle regels toe of genereer enkel voorbeeld",
"Apply all rules" => "Pas alle regels toe",
"View source code after rules applied" => "Bekijk broncode nadat all regels zijn toegepast",
"Code preview" => "Code voorbeeld",
"Generate HTML preview" => "Genereer HTML voorbeeld",
"HTML preview" => "HTML voorbeeld",
"Test file from repository to generate preview for (empty = configured start page)" => "Test bestand van bewaarplaats om voorbeeld te genereren voor (leeg = ingestelde start pagina)",
"Preview Results" => "Voorbeeld Resultaten",
"Rules List" => "Regellijst",
"Case" => "Hoofdlettertype",
"Admin layout" => "Layout beheren",
"layout options" => "lay-outopties",
"admin featured links" => "aanbevolen koppelingen beheren",
"admin featured links template" => "aanbevolen koppelingen sjabloon beheren",
"Generate positions by hits" => "Posities aanmaken volgens hits",
"List of featured links" => "Lijst met aanbevolen koppelingen",
"url" => "URL",
"title" => "titel",
"position" => "positie",
"Add Featured Link" => "Aanbevolen koppeling toevoegen",
"Edit this Featured Link:" => "Werk deze Aanbevolen Koppeling bij:",
"Create new Featured Link" => "Maak nieuwe Aanbevolen Koppeling aan",
"Position" => "Positie",
"disables the link" => "maakt de koppeling inactief",
"Link type" => "Koppelingtype",
"replace current page" => "huidige pagina vervangen",
"framed" => "omkaderd",
"open new window" => "nieuw venster openen",
"admin Webmail" => "Webmail beheren",
"admin mailin template" => "mailin beheren sjabloon",
"Add new Mail-in account" => "Nieuw e-mail account toevoegen",
"Edit Mail-in account" => "Wijzig e-mail account",
"Account name" => "Accountnaam",
"POP server" => "POP-server",
"Port" => "Poort",
"SMTP server" => "SMTP-server",
"SMTP requires authentication" => "SMTP vereist authentication",
"article-put" => "artikel-put",
"Article Topic" => "Artikelonderwerp",
"Article Type" => "Artikeltype",
"Allow anonymous acces" => "Laat anonieme toegang toe",
"Allow attachments" => "Laat blijlagen toe",
"Discard to the end from" => "Negeer tot het einde vanaf",
"Check Mail-in accounts" => "Controleer Mail-in accounts",
"Check automatically" => "Controleer automatisch",
"Frequency" => "Frekwentie",
"List menus" => "Menu's opsommen",
"Edit this menu" => "Dit menu bewerken",
"Edit menu options" => "Menu-opties bewerken",
"Show Quick Urls" => "Toon Snel Urls",
"Hide Quick Urls" => "Verberg Snel Urls",
"Some useful URLs" => "Enkele nuttige URLs",
"Permissions" => "Permissies",
"section" => "sectie",
"sorted section" => "gesorteerde sectie",
"option" => "optie",
"separator" => "scheidingslijn",
"Choose" => "Kies",
"Home Page" => "Startpagina",
"Home Image Gal" => "Startbeeldgal.",
"Home Image Gallery" => "Startbeeldgalerij",
"Home File Gal" => "Startbestandgal.",
"Home File Gallery" => "Startbestandgalerij",
"User preferences" => "Gebruikerinstellingen",
"User prefs" => "Gebruikerinst.",
"List image galleries" => "Beeldgalerijen opsommen",
"Upload" => "Aanlevering",
"Gallery Rankings" => "Rangorde Galerijen",
"Browse a gallery" => "Een galerij bekijken",
"All articles" => "Alle artikelen",
"Submit" => "Inleveren",
"List Blogs" => "Journalen Opsommen",
"Create blog" => "Journaal maken",
"File galleries" => "Bestandgalerijen",
"View a forum" => "Een forum bekijken",
"View a thread" => "Een thread bekijken",
"View a FAQ" => "Een FAQ bekijken",
"Take a quiz" => "Deelnemen aan een quiz",
"Stats for a Quiz" => "Statistieken voor een quiz",
"Preview menu" => "Menuvoorbeeld",
"Menu options" => "Menu-opties",
"group" => "groep",
"Admin Menus" => "Menu's beheren",
"admin menu builder" => "menubouwer beheren",
"admin menus template" => "menu's sjabloon beheren",
"Edit this Menu:" => "Bewerk dit Menu:",
"Create new Menu" => "Maak nieuw Menu aan",
"dynamic collapsed" => "dynamisch opgevouwen",
"dynamic extended" => "dynamisch uitgevouwen",
"fixed" => "vast",
"options" => "opties",
"Admin Modules" => "Modules beheren",
"admin modules" => "modules beheren",
"admin modules template" => "modules sjabloon beheren",
"assign module" => "module toekennen",
"left modules" => "modules koppelingen",
"right modules" => "modules rechts",
"edit/create" => "bewerken/aanmaken",
"clear cache" => "buffer leegmaken",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Noot 1</b>: als u uw gebruikers toestaat om modules te configureren\ndan zullen toegekende modules niet weergegeven worden op het scherm\ntot u hen configureert vanuit MijnTiki->modules.<br />\n<b>Noot 2</b>: Als u modules toekent aan groepen zorg er dan voor dat\nu de optie 'Modules altijd aan alle groepen tonen' uitgeschakeld heeft ",
"User Modules" => "Gebruikermodules",
"assign" => "toekennen",
"Assign new module" => "Wijs nieuwe module toe",
"Edit this assigned module:" => "Wijzig deze toegewezen module:",
"Module Name" => "Modulenaam",
"left" => "links",
"right" => "rechts",
"Order" => "Volgorde",
"Cache Time" => "Buffertijd",
"Rows" => "Rijen",
"Visibility" => "Zichtbaarheid",
"Displayed for the eligible users with no personal assigned modules" => "Getoond voor gebruikers die in aanmerking komen en die geen persoonlijk toegewezen modules bezitten",
"Displayed now for all eligible users even with personal assigned modules" => "Getoond voor gebruikers die in aanmerking komen zelfs als deze persoonlijke toegewezen modules beztten",
"Displayed now, can't be unassigned" => "Nu getoond, toewijzing kan niet worden ongedaan gemaakt",
"Not displayed until a user chooses it" => "Niet getoond totdat een gebruiker het selecteert",
"Assigned Modules" => "Toegekende modules",
"Left Modules" => "Linkse Modules",
"order" => "volgorde",
"rows" => "rijen",
"Right Modules" => "Rechtse Modules",
"Create new user module" => "Maak een nieuwe gebruikermodule aan",
"Edit this user module:" => "Werk deze gebruikermodule bij:",
"Use wysiwyg editor" => "Gebruik wysiwyg editor",
"Use normal editor" => "Gebruik normale editor",
"Must be wiki parsed" => "Moet Wiki vertaald zijn",
"create/edit" => "maken/bewerken",
"Objects that can be included" => "Objecten die ingevoegd kunnen worden",
"Available polls" => "Beschikbare opiniepeilingen",
"Random active poll" => "Willekeurige active opiniepeiling",
"Random current poll" => "Willekeurige huidige opiniepeiling",
"use poll" => "opiniepeiling gebruiken",
"Random image from" => "Toevallige afbeelding uit",
"use gallery" => "galerij gebruiken",
"Dynamic content blocks" => "Dynamische inhoudsblokken",
"use dynamic  content" => "dynamische inhoud gebruiken",
"use rss module" => "RSS-module gebruiken",
"use menu" => "menu gebruiken",
"use phplayermenu" => "gebruik phplayermenu",
"Banner zones" => "Advertentiezones",
"use banner zone" => "advertentiezone gebruiken",
"Admin newsletter subscriptions" => "Nieuwsbrief-abonnementen beheren",
"list newsletters" => "nieuwsbrieven opsommen",
"admin newsletters" => "nieuwsbrieven beheren",
"send newsletters" => "nieuwsbrieven verzenden",
"Add a subscription newsletters" => "Abonnement voor nieuwsbrieven toevoegen",
"Add email:" => "Voeg e-mail toe:",
"Add user:" => "Voeg gebruiker toe:",
"Group users" => "Groepeer gebruikers",
"Group subscription also subscribes included groups" => "Groepabonnement tekent ook de ingesloten groepen in",
"Don't send confirmation mail" => "Stuur geen confirmatiebericht",
"The user email will be refreshed at each newsletter sending" => "De gebruikers e-mail zal worden ververst bij elke uitgave van een nieuwsbrief",
"Subscribe group" => "Abonneer groep",
"Included group, group users and emails will be refreshed at each newsletter sending" => "Inclusief groep, groepgebruikers en e-mails zullen worden ververst bij elke uitgave van een nieuwsbrief",
"Subscriptions" => "Abonnementen",
"subscribed" => "geabonneerd",
"admin newsletters template" => "nieuwsbrieven sjabloon beheren",
"Create/edit newsletters" => "Nieuwsbrieven maken/bewerken",
"There are individual permissions set for this newsletter" => "Er bestaan individuele permissies voor deze nieuwsbrief",
"Users can subscribe/unsubscribe to this list" => "Gebruikers kunnen zich aan-/afmelden van deze lijst",
"Users can subscribe any email address" => "Gebruikers kunnen zich met elk e-mail adres aanmelden",
"Add unsubscribe instructions to each newsletter" => "Voeg instructies om af te melden toe aan elke nieuwsbrief",
"Validate email addresses" => "Valideer e-mail adressen",
"editions" => "uitgaven",
"last sent" => "laatst verzonden",
"subscriptions" => "abonnementen",
"send newsletter" => "stuur nieuwsbrief",
"archives" => "archieven",
"EMail notifications" => "E-mail meldingen",
"admin Email Notifications" => "E-mail Meldingen beheren",
"admin notifications template" => "meldingen sjabloon beheren",
"Add notification" => "Melding toevoegen",
"Event" => "Gebeurtenis",
"A user registers" => "Een gebruiker registreert zich",
"A user submits an article" => "Een gebruiker levert een artikel in",
"Any wiki page is changed" => "Eender welke wiki pagina werd bijgewerkt",
"Any wiki page is changed, even minor changes" => "Eender welke wiki pagina werd aangepast, zelfs kleine veranderingen",
"PHP error" => "PHP-fout",
"use admin email" => "beheerders-e-mail gebruiken",
"event" => "gebeurtenis",
"No records found." => "Geen records gevonden.",
"Admin Polls" => "Opiniepeilingen beheren",
"List polls" => "Opiniepeilingen opsommen",
"Edit this poll" => "Deze opiniepeiling bewerken",
"Preview poll" => "Voorbeeld opiniepeiling",
"Edit or add poll options" => "Opties voor opiniepeilingen bewerken of toevoegen",
"Option" => "Opties",
"Poll options" => "Opties voor opiniepeilingen",
"votes" => "stemmen",
"admin polls" => "opiniepeilingen beheren",
"admin polls template" => "opiniepeiligen sjabloon beheren",
"configure polls" => "configureer opiniepeilingen",
"Set last poll as current" => "Maak laatste opniniepeiling huidig",
"Close all polls but last" => "Sluit alle opiniepeilingen behalve de laatste",
"Activate all polls" => "Activeer alle opiniepeilingen",
"Create/edit Polls" => "Opiniepeilingen Maken/Bewerken",
"PublishDate" => "PublicatieDatum",
"Admin Quicktags" => "Snellabels beheren",
"admin QuickTags" => "SnelLabels beheren",
"tiki admin quicktags template" => "tiki snellabels sjabloon beheren",
"Create/Edit QuickTags" => "maak aan/Bewerk SnelLabels",
"Insert (use 'text' for figuring the selection)" => "Voeg in (gebruik 'text' om de selectie te beschrijven)",
"Category" => "Categorie",
"Path to the tag icon" => "Pad naar het labelikoon",
"Insert" => "Voeg in",
"Icon" => "Ikoon",
"Admin RSS modules" => "RSS-modules beheren",
"admin RSS modules" => "RSS modules beheren",
"admin RSSmodules template" => "RSS-modules sjabloon beheren",
"This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "Deze pagina dient om de instellingen van de RSS-invoerstromen (door Tiki gelezen of aangemaakt) te definieren. Om RSS-invoerstromen aan te maken, ga naar \"RSS-invoerstromen\" in het beheerpanel, of",
"Content for the feed" => "Inhoud voor de invoer",
"Edit this RSS module:" => "Bewerk deze RSS-module:",
"Create new RSS module" => "Maak nieuwe RSS-module aan",
"show feed title" => "toon invoertitel",
"show publish date" => "toom publicatiedatum",
"Rss channels" => "Rss-kanalen",
"Last update" => "Laatste bijwerking",
"show pubdate" => "toon pubdatum",
"Score System" => "Scoresysteem",
"security admin" => "Veiligheidsbeheer",
"security admin tpl" => "Veiligheidsbeheer sjabloon",
"edit tpl" => "bewerk sjabloon",
"PHP settings" => "PHP-instelligen",
"PHP variable" => "PHP-variabele",
"Setting" => "Instelling",
"Risk Factor" => "Risicofactor",
"Explanation" => "Uitleg",
"Tikiwiki settings" => "Tikiwiki instellingen",
"Tiki variable" => "Tiki variabele",
"Check all tiki files" => "Controleer alle tiki-bestanden",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Merk op dat dit een lange tijd kan duren. Controleer eventueel uw \\'max_execution_time\\' instelling in php.ini.",
"Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Opmerking: U dient de veiligheidsdatabank te importeren via de installatieprocedure (<a href=\"tiki-install.php\">tiki-install.php</a>). Importeer de *secdb* bestanden in uw databank.",
"File checks" => "Controles bestanden",
"Filename" => "Bestandnaam",
"State" => "Status",
"Admin Shoutbox Words" => "Spreekbuiswoorden beheren",
"admin shoutbox words" => "spreekbuiswoorden beheren",
"admin shoutbox words template" => "spreekbuiswoorden sjabloon beheren",
"Add Banned Word" => "Voeg verbannen woord toe",
"Are you sure you want to delete this word?" => "Bent u zeker dat u dit woord wenst te verwijderen?",
"admin structures template" => "strukturen sjabloon beheren",
"Structure ID" => "Struktuur ID",
"export pages" => "export pagina's",
"dump tree" => "dump boomstruktuur",
"create webhelp" => "maak webhelp aan",
"view webhelp" => "bekijk webhelp",
"Destroy the structure leaving the wiki pages" => "Verwijder de struktuur maar behoudt de wiki pagina",
"Destroy the structure and remove the pages" => "Verwijder de struktuur en pagina's",
"Create new structure" => "Nieuwe struktuur aanmaken",
"Use single spaces to indent structure levels" => "Gebruik enkele aanhalingstekens om de struktuurniveau's in te springen",
"tree" => "boom",
"create new structure" => "maak nieuwe struktuur aan",
"Edit survey questions" => "Vragen voor opinieonderzoek beheren",
"survey stats" => "statistieken voor opinieonderzoek",
"this survey stats" => "statistieken voor dit opinieonderzoek",
"edit this survey" => "dit opinieonderzoek bewerken",
"admin surveys" => "opinieonderzoeken beheren",
"Create/edit questions for survey" => "Vragen voor opinieonderzoek aanmaken/beheren",
"Question" => "Vraag",
"One choice" => "Een keuze",
"Multiple choices" => "Meerdere keuzes",
"Short text" => "Korte tekst",
"Rate (1..5)" => "Beoordeling (1..5)",
"Rate (1..10)" => "Beoordeling (1..10)",
"Options (if apply)" => "Opties (indien van toepassing)",
"Questions" => "Vragen",
"question" => "vraag",
"administer surveys template" => "opinieonderzoeken sjabloon beheren",
"list surveys" => "opinieonderzoeken opsommen",
"Edit this Survey:" => "Bewerk dit Opinieonderzoek:",
"Create New Survey" => "Maak Nieuw Opinieonderzoek aan",
"There are individual permissions set for this survey" => "Voor dit opinieonderzoek bestaan er individuele permissies",
"questions" => "vragen",
"active perms" => "actieve perms",
"system admin" => "systeembeheer",
"system admin tpl" => "systeembeheer sjabloon",
"Empty" => "Leeg",
"files" => "bestanden",
"Templates compiler" => "Sjablooncompiler",
"Compile" => "Compileer",
"Fix UTF-8 Errors in Tables" => "Los UTF-8 Fouten op in Tabellen",
"Warning: Make a backup of your Database before using this function!" => "Waarschuwing: Maak een reservekopie van uw databank vooraleer deze functie te gebruiken!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Waarschuwing: Indien uw grote tabellen wenst te converten, zorg er dan voor dat de \\'maximum execution time\\' in uw php.ini voldoende hoog staat!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "Deze functie converteert ISO-8859-1 ge-encodeerde strings in uw tabellen naar UTF-8 formaat",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "Dit is mogelijks noodzakelijks indien uw inhoud heeft aangemaakt met tiki &lt; 1.8.4 en met de \\'Default Charset\\' instelling in apache gezet op ISO-8859-1",
"UTF-8 Errors fixed" => "UTF-8 Fouten opgelost",
"Table" => "Tabel",
"Field" => "Veld",
"Investigate" => "Onderzoek",
"Fix it" => "Los op",
"Admin Topics" => "Onderwerpen Beheren",
"admin topics template" => "onderwerpen sjabloon beheren",
"Create a new topic" => "Een nieuw onderwerp aanmaken",
"Topic Name" => "Onderwerpnaam",
"Upload Image" => "Afbeelding Aanleveren",
"List of topics" => "Lijst van onderwerpen",
"Active?" => "Actief?",
"Articles (subs)" => "Artikelen (subs)",
"topic image" => "afbeelding onderwerp",
"Remove with articles" => "Verwijder met artikelen",
"Activate" => "Activeren",
"Deactivate" => "Uitschakelen",
"Admin tracker" => "Tracker beheren",
"Edit this tracker" => "Deze tracker bewerken",
"View this tracker items" => "Items in deze tracker bekijken",
"Edit tracker fields" => "Trackervelden bewerken",
"Is column visible when listing tracker items?" => "Is kolom zichtbaar wanneer trackeritems opgesomd worden?",
"Column links to edit/view item?" => "Kolomkoppelingen om items te bewerken/bekijken?",
"Column is searchable?" => "Kolom kan doorzocht worden?",
"Field is public? (for use thru trackerlist plugin)" => "Veld is publiek? (voor gebruik in de trackerlijst plugin)",
"Field is mandatory?" => "Veld is verplicht?",
"Tracker fields" => "Trackervelden",
"Searchable" => "Kan doorzoeken",
"Public" => "Publiek",
"Hidden" => "Verborgen",
"Mandatory" => "Verplicht",
"Import/export trackers fields" => "Importeer/exporteer trackerveld",
"Import" => "Importeren",
"admin Trackers tpl" => "Trackers beheren sjabloon",
"Edit fields for tracker" => "Bewerk velden voor tracker",
"Edit tracker" => "Werk tracker bij",
"Create trackers" => "Maak trackers aan",
"Import/export" => "Importeer/exporteer",
"created" => "gemaakt",
"active permissions" => "actieve permissies",
"fields" => "velden",
"Create/edit trackers" => "Trackers maken/bewerken",
"There are individual permissions set for this tracker" => "Er bestaan individuele permissies voor deze tracker",
"Show status" => "Toon status",
"Default status displayed in list mode" => "Toon standaardstatus in lijstmode",
"Show status to tracker admin only" => "Toon trackerstatus enkel aan beheerders",
"Send copies of all activity in this tracker to this e-mail address" => "Stuur kopie&euml;n van alle activiteit in deze tracker naar dit e-mail adres",
"Use simplified e-mail format" => "Gebruik vereenvoudigd e-mail formaat",
"The tracker needs a text field named Subject" => "De tracker vereist een tekstveld met naam Subject",
"New items are created with status" => "Maak nieuwe items aan met status",
"Authoritative status for modified items" => "Beheerderstatus voor bijgewerkte items",
"No change" => "Geen wijziging",
"Item creator can modify his items?" => "Aanmaker item mag haar/zijn items wijzigen?",
"The tracker needs a user field with the option 1" => "De tracker vereist een gebruikersveld met de optie 1",
"Member of the default group of creator can modify items?" => "Lid van de standaard groep van aanmakers mag items wijzigen?",
"The tracker needs a group field with the option 1" => "De tracker vereist een groepveld met de optie 1",
"Show creation date when listing tracker items?" => "Aanmaakdatum tonen wanneer trackeritems opgesomd worden?",
"Show lastModif date when listing tracker items?" => "lastModif-datum tonen wanneer trackeritems opgesomd worden?",
"What field is used for default sort?" => "Welk veld gebruiken voor de standaard sorteervolgorde?",
"What is default sort order in list?" => "Wat is de standaard sorteervolgorde in lijst?",
"ascending" => "stijgend",
"descending" => "dalend",
"Tracker items allow ratings?" => "Tracker items laat beoordelingen toe?",
"with values" => "met waarden",
"and display rating results in listing?" => "en toon de beoordelingen in de lijst?",
"Tracker items allow comments?" => "Zijn opmerkingen toegestaan bij trackeritems?",
"and display comments in listing?" => "en toon commentaren in lijst?",
"Tracker items allow attachments?" => "Zijn bijlagen toegelaten bij trackeritems?",
"and display attachments in listing?" => "en toon bijlagen in lijst?",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Toon bijlagen opties (Gebruik nummers om items in volgorde te plaatsen, 0 wordt niet getoond, en negatieve waarden worden in een popup venster getoond)",
"filename" => "bestandnaam",
"downloads" => "afhalingen",
"filesize" => "bestandgrootte",
"version" => "versie",
"filetype" => "bestandtype",
"longdesc" => "langbeschr",
"Import/export trackers" => "Importeer/exporteer trackers",
"admin groups" => "groepen beheren",
"admin groups template" => "Groepen sjabloon beheren",
"Add new group" => "Voeg nieuwe groep toe",
"List" => "Lijst",
"Edit group" => "Wijzig groep",
"Members" => "Leden",
"Add a new group" => "Voeg nieuwe groep toe",
"List of existing groups" => "Lijst van bestaande groepen",
"Number of displayed rows" => "Aantal getoonde rijen",
"Includes" => "Omvat",
"assign permissions" => "wijs permissies toe",
"Include" => "Omvatten",
"Group Homepage" => "Groep Start pagina",
"Use wiki page name or full URL" => "Gebruik wiki paginanaam of gebruik volledige URL",
"Group Information Tracker" => "Groepinformatie Tracker",
"choose a group tracker ..." => "kies een groep tracker ...",
"choose a field ..." => "kies een veld ...",
"admin" => "beheerder",
"Users Information Tracker" => "Gebruikers Informatie Tracker",
"choose a users tracker ..." => "kies een gebruikers tracker ...",
"Group tracker item : {\$groupitemid}" => "Groep tracker item : {\$groupitemid}",
"Edit item" => "Item bewerken",
"Group tracker item not found" => "Groep tracker item niet gevonden",
"Create item" => "Maak item aan",
"Members List" => "Ledenlijst",
"users in group" => "gebruikers in groep",
"List all members" => "Lijst alle leden",
"admin users" => "gebruikers beheren",
"admin users template" => "gebruikers sjabloon beheren",
"Add a new user" => "Nieuwe gebruiker toevoegen",
"Batch Upload Results" => "Massa-aanlevering Resultaten",
"Added users" => "Toegevoegde gebruikers",
"Rejected users" => "Geweigerde gebruikers",
"Reason" => "Reden",
"Edit user" => "Wijzig gebruiker",
"Change user preferences" => "Verander gebruikersvoorkeuren",
"edit account settings" => "Bewerk account instellingen",
"Never" => "Nooit",
"Assign Group" => "Wijs Groep toe",
"select all" => "selecteer alles",
"Perform action with checked:" => "Voer actie uit met geselecteerde:",
"manage group assignments" => "beheer groeptoewijzigingen",
"set default groups" => "Zet standaardgroepen",
"Assign selected to" => "Wijs geselecteerde toe aan",
"Remove selected from" => "Maak toewijzing geselecteerde aan ongedaan",
"the following groups:" => "de volgende groepen:",
"Set the default group of the selected users to" => "Zet de standaardgroep van de geselecteerde gebruikers naar",
"assign to groups" => "wijs toe aan groepen",
"Again" => "Opnieuw",
"Registration" => "Registratie",
"Overwrite" => "Overschrijf",
"User tracker item : {\$usersitemid}" => "Gebruiker tracker item : {\$usersitemid}",
"Admin Article Types" => "Artikeltypes beheren",
"Article Types tpl" => "Artikeltypes sjabloon",
"Shows up in the drop down list of article types" => "Wordt in de neerklap lijst van artikeltypes getoond",
"Rate" => "Scoor",
"Allow ratings by the author" => "Laat beoordelingen door auteur toe",
"Show before publish date" => "Toon voor publicatiedaturm",
"non-admins can view before the publish date" => "niet-beheerders kunnen bekijken voor de publicatiedatum",
"Show after expire date" => "Toon na verloopdatum",
"non-admins can view after the expire date" => "niet-beheerders kunnen bekijken na de publicatiedatum",
"Heading only" => "Enkel hoofding",
"No article body, heading only" => "Geen artikellichaam, enkel hoofding",
"Allow comments for this type" => "Laat commentaar toe voor dit type",
"Comment Can Rate Article" => "Commentaar mag artikel scoren",
"Allow comments to include a rating value" => "Laat toe om een waardeoordeel in commentaren in te sluiten",
"Show image" => "Toon afbeelding",
"Show topic or own image" => "Toon onderwerp of eigen afbeelding",
"Show avatar" => "Toon pictogram",
"Show author's avatar" => "Toon auteur's gebruikerpictogram",
"Show author" => "Toon auteur",
"Show author name" => "Toon auteurnaam",
"Show publish date" => "Toon publicatiedatum",
"Show expire date" => "Toon verloopdatum",
"Show reads" => "Toon lezingen",
"Show the number of times the article was read" => "Toon het aantal lezingen van het artikel",
"Show size" => "Toon grootte",
"Show the size of the article" => "Toon de grootte van het artikel",
"Show topline" => "Toon kopregel",
"Show a small title over the title" => "Toon een kleine titel boven de hoofdtitel",
"Show subtitle" => "Toon subtitel",
"Show the subtitle" => "Toon de subtitel",
"Show source" => "Toon brontekst",
"Show link to source after article body" => "Toon koppeling naar brontekst na het artikellichaam",
"Show Image Caption" => "Toon afbeeldingtitel",
"Show a legend under the image" => "Toon een legende onder de afbeelding",
"Show Language" => "Toon Taal",
"Show the language" => "Toon de taal",
"Creator can edit" => "Auteur mag bewerken",
"The person who submits an article of this type can edit it" => "De person die een artikel van dit type aanlevert, mag het ook bijwerken",
"Delete" => "Verwijder",
"Delete this type" => "Verwijder dit type",
"List of types" => "Lijst van types",
"Show lang" => "Toon taal",
"Review" => "Recensie",
"Classified" => "Advertentie",
"Create a new type" => "Maak een nieuw type aan",
"Assign permissions to group" => "Permissies toekennen aan groep",
"Edit Article" => "Bewerk Artikel",
"edit article tpl" => "bewerk artikel sjabloon",
"Back to groups" => "Terug naar de groepen",
"Group Information" => "Groepinformatie",
"Desc" => "Omschr.",
"Create level" => "Niveau aanmaken",
"all permissions in level" => "alle permissies op niveau",
"all" => "alle",
"level" => "niveau",
"Assign user" => "Gebruiker toekennen",
"to groups" => "aan groepen",
"User Information" => "Gebruikergegevens",
"Default Group" => "Standaard Groep",
"Available groups" => "Beschikbare groepen",
"assign perms to this group" => "wijs permissies toe aan deze groep",
"to" => "tot",
"backlinks to" => "terugkoppeling naar",
"No backlinks to this page" => "Geen terugkoppelingen naar deze pagina",
"admin backups" => "reservekopie&eacute;n beheren",
"admin admin tpl" => "beheer beheren sjabloon",
"List of available backups" => "Lijst met beschikbare reservekopie&eacute;n",
"Restoring a backup" => "Back-up terugplaatsen",
"Warning!" => "Waarschuwing!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Het herstellen van een back-up vernietigt al de data in uw Tiki-databank. Al uw tabellen zullen vervangen worden door de informatie in de back-up.",
"Click here to confirm restoring" => "Hier klikken om het herstel te bevestigen",
"Create new backup" => "Nieuwe back-up maken",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Het maken van back-ups kan veel tijd in beslag nemen. Als het proces niet be&euml;indigd is zal u een blanco scherm zien. Als dat zo is moet u de maximale tijd voor uitvoering van een script verhogen in uw php.ini bestand",
"Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "De opslag van uw beeldgalerijen is momenteel in \"{\$gal_use_dir}\", u zal van deze een reservekopie via FTP of SCP dienen te maken.",
"Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "De opslag van uw bestandgalerijen is momenteel in \"{\$fgal_use_dir}\", u zal van deze een reservekopie via FTP of SCP dienen te maken.",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "Indien er berichten in uw forums met bijlagen aanwezig zijn, zal u van deze een aparte reserverkopie moeten maken via FTP of SCP.",
"Upload a backup" => "Een reserverkopie aanleveren",
"Upload backup" => "Reservekopie aanleveren",
"Directory batch upload" => "Directory bulk aanlevering",
"Browse gallery" => "Galerij bekijken",
"Upload from disk" => "Aanleveren van harde schijf",
"available images" => "beschikbare afbeeldingen",
"width" => "breedte",
"height" => "hoogte",
"remove file extension from image name" => "verwijder bestandsextensie van naam van afbeelding",
"eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. van \"digicam0001.jpg\" naar de naam digicam0001 zal worden gebruikt voor het naamveld",
"convert sub directories to sub galleries" => "converteer subfolders naar subgalerijen",
"eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "eg. van \"misc/screenshots/digicam0001.jpg\" zal een galerij genaamd screenshots worden aangemaakt",
"use sub directory names as description" => "gebruik subfolder namen als beschrijving",
"eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "eg. van \"misc/screenshots/digicam0001.jpg\" zal een beschrijving misc/screenshots worden aangemaakt",
"Select a Gallery" => "Selecteer een Galerij",
"Process" => "Proces",
"Edit Post" => "Bijdrage Bewerken",
"view blog" => "toon journaal",
"list blogs" => "opsommen journalen",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "Noot: indien u afbeeldingen wilt gebruiken, bewaar het bericht dan eerst en\nbewerk of voeg dan de afbeelding toe. Gebruik het &lt;img&gt; teken om afbeeldingen in de tekstbewerker in te sluiten\nof gebruik het URL om de afbeelding toe te voegen via de WYSIWYG bewerker.",
"Use ...page... to separate pages in a multi-page post" => "Gebruik ...page... om te pagineren in een multi-pagina bijdrage",
"Upload image for this post" => "Lever afbeelding aan voor dit bijdrage",
"Trash" => "Prullenmand",
"Mark entry as private:" => "Markeer invoer als priv&eacute;:",
"Send trackback pings to:" => "Stuur trackback pings naar:",
"(comma separated list of URIs)" => "(komma-gescheiden lijst van URIs)",
"save and exit" => "bewaar en verlaat",
"admin the category system" => "beheer het categoriesysteem",
"admin category" => "Categorie&euml;n beheren",
"Browse in" => "Blader in",
"Wiki pages" => "Wiki pagina\\'s",
"Image galleries" => "Beeldgalerijen",
"Sheets" => "Rekenbladen",
"search category" => "categorie doorzoeken",
"deep" => "diep",
"Hide subcategories objects" => "Verberg subcategorie objecten",
"Show subcategories objects" => "Toon subcategorie objecten",
"Upper level" => "Hoger niveau",
"Objects" => "Objecten",
"Browsing Gallery" => "Galerij bekijken",
"list galleries" => "lijst galerijen",
"edit gallery" => "galerij bewerken",
"rebuild thumbnails" => "voorbeeldplaatjes vernieuwen",
"upload image" => "afbeelding aanleveren",
"list gallery" => "galerij opsommen",
"Sort Images by" => "Afbeeldingen sorteren volgens",
"subgallery" => "subgalerij",
"Subgallery" => "Subgalerij",
"original size" => "oorspronkelijk formaat",
"rotate right" => "naar rechts draaien",
"rotate" => "verdraai",
"Browsing Image" => "Afbeelding Bekijken",
"return to gallery" => "terug naar galerij",
"edit image" => "afbeelding bewerken",
"first image" => "eerste afbeelding",
"smaller" => "kleiner",
"bigger" => "groter",
"prev image" => "vor. afbeelding",
"Popup window" => "Popup venster",
"popup window" => "popup venster",
"next image" => "volg. afbeelding",
"slideshow forward" => "slideshow voorwaarts",
"last image" => "laatste afbeelding",
"Direction" => "Richting",
"Click to zoom" => "Klik om te zoomen",
"Image Name" => "Naam Afbeelding",
"Image size" => "Afbeeldinggrootte",
"imagescale" => "schaal afbeelding",
"Latitude (WGS84/decimal degrees)" => "Breedtegraad (WGS84/decimale graden)",
"Longitude (WGS84/decimal degrees)" => "Lengtegraad (WGS84/decimale graden)",
"Move image" => "Afbeelding verplaatsten",
"You can view this image in your browser using" => "U kan deze afbeelding in uw browser bekijken met",
"You can include the image in an HTML page using one of these lines" => "U kan de afbeelding in een HTML-pagina insluiten via &eacute;&eacute;n van volgende lijnen",
"You can include the image in a tiki page using one of these lines" => "U kan de afbeelding in een tiki-pagina insluiten via &eacute;&eacute;n van volgende lijnen",
"add item" => "voeg item toe",
"Edit/Create" => "Bewerken/Aanmaken",
"Date Selector" => "Datumkiezer",
"click to navigate" => "Klik om te navigeren",
"change focus" => "verander focus",
"quarter" => "kwartaal",
"calendar view" => "bekijk kalender",
"list view" => "bekijk lijst",
"End" => "Einde",
"Hours" => "Uren",
"h" => "u",
"Group Calendars" => "Groep Kalenders",
"Tools Calendars" => "Hulpmiddelen Kalenders",
"Duration" => "Duur",
"Location" => "Locatie",
"Organized by" => "Georganizeerd volgens",
"Participants" => "Deelnemers",
"Tentative" => "Voorlopig",
"Confirmed" => "Bevestigd",
"Cancelled" => "Geannuleerd",
"Subscription List" => "Abonnementenlijst",
"Edit Calendar Item" => "Bewerk Kalender Item",
"New Calendar Item" => "Nieuw Kalendar Item",
"or create a new category" => "of maak een nieuwe categorie aan",
"or create a new location" => "of maak een nieuwe locatie aan",
"comma separated usernames" => "komma-gescheiden gebruikernamen",
"comma separated username:role" => "komma-gescheiden naam:functie",
"with roles" => "met functies",
"Chair" => "Woordvoerder",
"Optional" => "Optioneel",
"Syntax error" => "Schrijffout",
"Format: mm/dd/yyyy hh:mm<br />..." => "Formaat: mm/dd/yyyy hh:mm<br />...",
"See strtotime php function" => "Zie strtotime php functie",
"Format: mm/dd/yyy hh:mm<br />..." => "Formaat: mm/dd/yyy hh:mm<br />...",
"duplicate" => "duplicaat",
"close" => "sluit",
"click to view" => "Klik om te bekijken",
"Calendar import" => "Importeer Kalender",
"Calendar has been updated" => "Kalender werd bijgewerkt",
"CSV File" => "CSV-bestand",
"import" => "importeren",
"Assign permissions to category" => "Permissies toekennen aan categorie",
"Current permissions for this category" => "Huidige permissies voor deze categorie",
"permission" => "permissie",
"remove from this category &amp; all its children" => "verwijder alle kinderen voor deze categorie",
"remove from this category only" => "verwijder enkel van deze categorie",
"No individual permissions global permissions apply" => "Er zijn geen individuele permissies gezet, globale permissies gelden",
"Assign permissions" => "Wijs permissies toe",
"to group" => "aan groep",
"this category &amp; all its children" => "deze categorie en haar kinderen",
"this category only" => "enkel deze categorie",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "Toewijzen van permissies voor<b>alle kinderen</b>is aanbevolen voor de beste performantie.",
"Change password enforced" => "Wachtwoordwijziging verplicht",
"Old password" => "Oud wachtwoord",
"Again please" => "Nogmaals a.u.b.",
"Welcome to the Tiki Chat Rooms" => "Welkom in de Tiki Praatkamers",
"Please select a chat channel" => "Gelieve een praatkamer te kiezen",
"Nickname" => "Bijnaam",
"enter chat room" => "Praatkamer binnengaan",
"There are no channels setup, please contact a site admin" => "Er zijn geen kanalen opgezet, contacteer aub een beheerder",
"Chatroom" => "Praatkamer",
"Browser not supported" => "Browser niet ondersteund",
"Active Channels" => "Actieve Kanalen",
"Users in this channel" => "Gebruikers in deze kamer",
"Channel Information" => "Kanaalinformatie",
"Channel" => "Kanaal",
"Use :nickname:message for private messages" => "Gelieve :bijnaam:bericht te gebruiken voor priv&eacute;berichten",
"Use [URL|description] or [URL] for links" => "Gelieve [URL|omschrijving] of [URL] te gebruiken voor koppelingen",
"Use (:smileyname:) for smileys" => "Gebruik (:smileynaam:) voor smileys",
"Create PDF" => "Maak PDF aan",
"PDF Settings" => "PDF Instellingen",
"Font" => "Lettertype",
"Textheight" => "Teksthoogte",
"Height of top Heading" => "Hoogte van de bovenste Hoofding",
"Height of mid Heading" => "Hoogte van de middelste Hoofding",
"Height of inner Heading" => "Hoogte van de binnenste Hoofding",
"tbheight" => "tbhoogte",
"Automatic Page Breaks" => "Automatische Pagina-onderbrekingen ",
"Select Wiki Pages" => "Kies Wiki Pagina's",
"add page" => "pagina toevoegen",
"remove page" => "pagina verwijderen",
"reset" => "herzet",
"Send a message to us" => "Stuur ons een bericht",
"Contact us by email" => "Contacteer ons via e-mail",
"click here to send us an email" => "klik hier om ons een e-mail te sturen",
"Create WebHelp" => "Maak WebHelp Aan",
"You can browse the generated WebHelp here" => "U kan de aangemaakte WebHelp hier bekijken",
"Structure" => "Struktuur",
"Top page" => "Boven pagina",
"Close" => "Sluit",
"Current URL" => "Huidig URL",
"Command" => "Commando",
"Type <code>help</code> to get list of available commands" => "Type <code>help</code> om een lijst te bekomen van beschikbare commando's",
"Add a new site" => "Site toevoegen",
"You cannot add sites until Directory Categories are setup." => "U kan geen sites toevoegen zolang de Koppelingenlijst Categorie&euml;n niet zijn opgezet.",
"Please contact the Site Administrator" => "Gelieve de sitebeheerder te contacteren",
"Site added" => "Site toegevoegd",
"The following site was added and validation by admin may be needed before appearing on the lists" => "De volgende site is toegevoegd maar mogelijkerwijze moet deze eerst door een beheerder gevalideerd worden vooraleer deze op de lijst verschijnt",
"Add or edit a site" => "Een site toevoegen of bewerken",
"Name:" => "Naam:",
"Categories:" => "Categorie&eacute;:",
"Is valid" => "Is geldig",
"Directory Administration" => "Koppelingenlijst beheren",
"admin directory tpl" => "Koppelingenlijst beheren sjabloon",
"Statistics" => "Statistieken",
"There are" => "Er zijn",
"invalid sites" => "ongeldige sites",
"valid sites" => "geldige sites",
"Users have visited" => "Gebruikers hebben bezocht:",
"sites from the directory" => "sites van de koppelingenlijst",
"Users have searched" => "Gebruikers hebben gezocht:",
"times from the directory" => "keer van de koppelingenlijst",
"Admin sites" => "Sites beheren",
"Admin category relationships" => "Categorie-relaties beheren",
"Validate links" => "Links valideren",
"Settings" => "Instellingen",
"browse" => "bladeren",
"related" => "verwante",
"validate" => "valideren",
"Admin directory categories" => "Koppelingenlijst categorie&euml;n beheren",
"admin directory categories tpl" => "Koppelingenlijst categorie&eacute;n beheren sjabloon",
"Parent category" => "Bovenliggende categorie",
"Add a directory category" => "Voeg een koppelingenlijst categorie toe",
"Edit this directory category" => "Bewerk deze koppelingenlijst categorie",
"Children type" => "Type van kinderen",
"Most visited sub-categories" => "Meest bezochte sub-categorie&euml;n",
"Category description" => "Categoriebeschrijving",
"Random sub-categories" => "Toevallige sub-categorie&eumln",
"Maximum number of children to show" => "Maximaal aantal kinderen om te tonen",
"Allow sites in this category" => "Sites in deze categorie toestaan",
"Show number of sites in this category" => "Aantal sites in deze categorie tonen",
"Editor group" => "Groep-editor",
"Subcategories" => "Sub-categorie&euml;n",
"allow" => "toestaan",
"count" => "tellen",
"relate" => "verwantschap maken",
"Admin related categories" => "Verwante categorie&euml;n beheren",
"Admin Directory Related " => "Koppelingenlijst Gerelateerd beheren",
"directory admin related tpl" => "Koppelingenlijst gerelateerd beheren sjabloon",
"Add a related category" => "Voeg een gerelateerde categorie toe",
"Mutual" => "Wederzijds",
"Related categories" => "Verwante categorie&euml;n",
"Admin Directory Sites" => "Koppelingenlijst Sites beheren",
"Admin Directory Sites tpl" => "Koppelingenlijst Sites beheren sjabloon",
"country" => "land",
"new sites" => "nieuwe sites",
"cool sites" => "leuke sites",
"add a site" => "voeg een site toe",
"add a category" => "voeg een categorie toe",
"any" => "elke",
"in entire directory" => "in volledige koppelingenlijst",
"in current category" => "in huidige categorie",
"search" => "zoeken",
"Sort by" => "Sorteer op",
"name (desc)" => "naam (dalend)",
"name (asc)" => "naam (strijgend)",
"hits (desc)" => "hits (dalend)",
"hits (asc)" => "hits (stijgend)",
"creation date (desc)" => "aanmaakdatum (dalend)",
"creation date (asc)" => "aanmaakdatum (stijgend)",
"last updated (desc)" => "laatst bijgewerkt (dalend)",
"last updated (asc)" => "laatst bijgewerkt (stijgend)",
"sort" => "sorteer",
"Added" => "Toegevoegd",
"Last updated" => "Laatst bijgewerkt",
"Total categories" => "Totaal categorie&euml;n",
"Total links" => "Totaal koppelingen",
"Links to validate" => "Koppelingen te valideren",
"Searches performed" => "Gemaakte zoekopdrachten",
"Total links visited" => "Totale sites bezocht",
"Directory ranking" => "Koppelingenlijst rankschikking",
"Search results" => "Zoekresultaten",
"Validate sites" => "Sites valideren",
"Validate Sites" => "Valideer Sites",
"directory validate sites tpl" => "koppelingenlijst validatatie sites sjabloon",
"list articles" => "artikelen opsommen",
"view articles" => "artikelen tonen",
"Topline" => "Kopregel",
"Subtitle" => "Subtitel",
"Source" => "Brontekst",
"Author Name" => "Auteursnaam",
"Own Image" => "Eigen afbeelding",
"Use own image" => "Eigen afbeelding gebruiken",
"Float text around image" => "plaats tekst rond afbeelding",
"Own image size x" => "Eigen afbeeldinglengte x",
"Own image size y" => "Eigen afbeeldinglengte y",
"Image caption" => "Afbeeldingtitel",
"Heading" => "Hoofding",
"Body" => "Lichaam",
"Use ...page... to separate pages in a multi-page article" => "Gebruik ...page... om te pagineren in een multi-pagina artikel",
"Expiration Date" => "Verloopdatum",
"Edit or create banners" => "Bewerk of maak advertenties aan",
"List banners" => "Opsommen advertenties",
"URL to link the banner" => "URL waarmee de advertentie gekoppeld is",
"Client" => "Klant",
"Max impressions" => "Max klikken",
"create zone" => "zone maken",
"Show the banner only between these dates" => "Advertenties enkel tonen tussen deze data",
"From date" => "Van datum",
"To date" => "Tot datum",
"Use dates" => "Gebruiksdata",
"Show the banner only in this hours" => "Advertenties enkel tonen in deze tijdsspanne",
"Show the banner only on" => "Toon de advertentie enkel op",
"Mon" => "Ma",
"Tue" => "Di",
"Wed" => "Wo",
"Thu" => "Do",
"Fri" => "Vr",
"Sat" => "Za",
"Sun" => "Zo",
"Select ONE method for the banner" => "EEN methode voor de advertentie kiezen",
"Use HTML" => "HTML gebruiken",
"HTML code" => "HTML-code",
"Use image" => "Afbeelding gebruiken",
"Image:" => "Afbeelding:",
"Current Image" => "Huidige afbeelding",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Afbeelding gebruiken die door URL aangemaakt is (de afbeelding wordt bij elke oproep bij de URL opgehaald)",
"Use text" => "Tekst gebruiken",
"Text" => "Tekst",
"save the banner" => "de advertentie opslaan",
"Remove Zones (you lose entered info for the banner)" => "Verwijder Zones (u zal de reeds ingevoerde gegevens voor de advertentie verliezen)",
"Edit Blog" => "Journaal Bewerken",
"Create Blog" => "Journaal aanmaken",
"edit blog tpl" => "Bewerk journaal sjabloon",
"Current heading" => "Huidige hoofding",
"There are individual permissions set for this blog" => "Er bestaan individuele permissies voor dit journaal",
"Number of posts to show" => "Aantal bijdragen die moeten getoond worden",
"Allow other user to post in this blog" => "Andere gebruikers mogen bijdragen leveren aan dit journaal",
"Use titles in blog posts" => "Gebruik titels in journaalbijdragen",
"Allow search" => "Laat zoekopdrachten toe",
"Allow comments" => "Laat opmerkingen toe",
"Show user avatar" => "Toon gebruikerpictogram",
"Blog heading" => "Journaal hoofding",
"Edit Style Sheet" => "Bewerk Style Sheet",
"Style Sheet" => "Stijlblad",
"Cancel" => "Annuleer",
"choose a stylesheet" => "Kies een stylesheet",
"try" => "probeer",
"display" => "tonen",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Bestanden met namen gevolgd door -{\$user} zijn wijzigbaar, andere kunnen enkel gekopieerd worden en als model dienen.",
"Show Plugins Help" => "Toon Plugins Help",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "Voor meer informatie, zie ook <a href=\"{\$helpurl}WikiSyntax\">Wiki Schrijfwijze</a>",
"some text" => "wat tekst",
"Creates a box with the data" => "Maakt een tekstkader met de gegevens",
"Box content" => "Boxinhoud",
"Title bar" => "Titelbalk",
"creates a title bar" => "maakt een titelbalk",
"Colored text" => "Gekleurde tekst",
"Lists" => "Lijsten",
"for bullet lists" => "voor ongenummerde lijsten",
"for numbered lists" => "voor genummerde lijsten",
"for definiton lists" => "voor definitielijsten",
"Headings" => "Hoofdingen",
"Show/Hide" => "Toon/Verberg",
"show/hide heading section. + (shown) or - (hidden) by default" => "toon/verberg hoofdingsectie. + (toon) or - (verberg) standaard",
"Wiki References" => "Wikireferenties",
"JoinCapitalizedWords or use" => "SchrijfWoordenMetHoofdlettersAaneen of gebruik",
"page|desc" => "pagina|omschr.",
"for wiki references" => "voor wikireferenties",
"SomeName" => "EenNaam",
"prevents referencing" => "vermijdt referenties",
"External links" => "Externe koppelingen",
"use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "gebruik vierkante haken voor een externe koppeling: [URL] of [URL|beschrijving_koppeling] of [URL|bewschrijving|nocache]  (deze laatste vorm voorkomt dat de pagina lokaal wordt gebufferd door het Wiki. Gebruik deze vorm aub voor omvangrijke pagina's).",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "Voor een externe Wiki, gebruik ExternalWikiName:PageName of ((External Wiki Name: Page Name))",
"Tables" => "Tabellen",
"creates a table" => "maakt een tabel",
"displays an image" => "toont een afbeelding",
"height width desc link and align are optional" => "hoogte breedte omschr. koppeling en uitlijning zijn optioneel",
"Non cacheable images" => "Afbeeldingen die niet in buffer kunnen gebracht worden",
"makes a horizontal rule" => "maakt een horizontale regel",
"creates the editable drawing foo" => "maakt de bewerkbare tekening foo aan",
"Multi-page pages" => "Multi-pagina pagina's",
"Wiki File Attachments" => "Wiki Bijlagen",
"Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Maakt een koppeling aan naar genoemd bestand. Indien de pagina niet is opgegeven, zal het bestand aan de huidige pagina worden gehangen. Indien desc niet is opgegeven, zal de bestandsnaam worden gebruikt voor de koppelingstekst, tenzij showdesc wordt gebruikt waardoor de beschrijving het bestand dan als koppelingstekst wordt gebruikt. Als image=1 zal het opgegeven bestand als afbeelding worden beschouwd en rechtstreeks in de pagina worden getoond, zonder een koppeling aan te maken.",
"RSS feeds" => "RSS-invoer",
"displays rss feed with id=n maximum=m items" => "toont RSS-invoer met id=n maximum=m items",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Zal vervangen worden door de actuele inhoud van het dynamische inhoudsblok met id=n",
"Dynamic variables" => "Dynamische variabelen",
"Inserts an editable variable" => "Voeg een bewerkbare variabele in",
"Non parsed sections" => "Niet geparste secties",
"Prevents wiki parsing of the enclosed data." => "Voorkomt wiki vertaling van de ingesloten gegevens",
"Preformated sections" => "Voorgeformatteerde secties",
"Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Toont voorgeformatteerde tekst/code; geen wiki vertaling zal worden toegepast binnen deze secties (zie ook np) en de spati&euml;ring is vast (er wordt geen woordomslag toegepast)",
"Square Brackets" => "Verkante Haken",
"Use [[foo] to show [foo]." => "Gebruik [[foo] om [foo] te tonen.",
"Block Preformatting" => "Voorgeformatteerd blok",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Spring tekst in met een aantal spaties om het in een mono-gespatieerd blok om te zetten dat nog steeds de andere wiki opmaakregels volgt. Het zal worden getoond met hetzelfde aantal ingesprongen spaties als ingevoerd. Hou er rekening mee dat deze optie spati&euml;ring en afbrekekingregels niet respecteert; gebruik hiervoor ~pp~...~/pp~.",
"Table of contents" => "Inhoudstabel",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" toont een inhoudstabel voor de huidige pagina gebaseerd op de struktuur (toc) of ! hoofdingen (maketoc)",
"Misc" => "Misc.",
"Show Text Formatting Rules" => "Toon Tekstopmaak Regels",
"No description available" => "Geen beschrijving beschikbaar",
"Quicktags" => "SnelLabels",
"bold" => "vet",
"italic" => "schuinschrift",
"underline" => "onderstrepen",
"table" => "tabel",
"table new" => "nieuwe tabel",
"external link" => "externe koppeling",
"wiki link'" => "wiki koppeling",
"heading1" => "hoofding1",
"title bar" => "titelbalk",
"box" => "tekstkader",
"rss feed" => "rss-invoerstroom",
"dynamic content" => "dynamische inhoud",
"center text" => "centreer tekst",
"colored text" => "gekleurde tekst",
"dynamic variable" => "dynamische variabele",
"New wms Metadata" => "Nieuwe wms Metadata",
"New Class" => "Nieuws Klasse",
"New Projection" => "Nieuwe Projectie",
"New Query" => "Nieuwe Vraag",
"New Scalebar" => "Nieuwe Schaalbalk",
"New Layer" => "Nieuwe Laag",
"New Label" => "Nieuwe Label",
"New Reference" => "Nieuwe Referentie",
"New Legend" => "Nieuwe Legende",
"New Web" => "Nieuw Web",
"New Outputformat" => "Nieuw Uitvoerformaat",
"New Mapfile" => "Nieuw Kaartbestand",
"special chars" => "speciale karakters",
"special characters" => "speciale tekens",
"admin quicktags" => "Snellabels beheren",
"Edit Image" => "Afbeelding Bewerken",
"browse image" => "bekijk afbeelding image",
"Edit successful!" => "Bewerking geslaagd!",
"The following image was successfully edited" => "De volgende afbeelding werd met success bewerkt",
"Image Description" => "Omschrijving Afbeelding",
"Edit and create Languages" => "Aanmaken/bewerken Talen",
"Im- Export Languages" => "Im-/Export Talen",
"Edit and create languages" => "Aanmaken/bewerken talen",
"Create Language" => "Aanmaken Taal",
"Shortname" => "Korte naam",
"like" => "zoals",
"Longname" => "Lange naam",
"Select the language to edit" => "Taal selecteren voor bewerking",
"Add a translation" => "Toevoegen vertaling",
"Edit translations" => "Bewerk vertalingen",
"Translate recorded" => "Vertaling opgenomen",
"Original" => "Originele",
"Translation" => "Vertaling",
"translate" => "vertaal",
"reset table" => "maak tabel leeg",
"Program dynamic content for block" => "Dynamische inhoud voor een blok programmeren",
"create new block" => "nieuw blok maken",
"Return to block listing" => "Terug naar opsomming blokken",
"Block description: " => "Blokomschrijving: ",
"Create or edit content" => "Inhoud maken of bewerken",
"You are editing block:" => "U bewerkt nu blok:",
"Publishing date" => "Publicatiedatum",
"Publishing Date" => "Publicatiedatum",
"Edit question options" => "Bewerk vraag optiens",
"list quizzes" => "quizzen opsommen",
"quiz stats" => "statistieken voor quiz",
"this quiz stats" => "statistieken voor deze quiz",
"edit this quiz" => "deze quiz bewerken",
"admin quizzes" => "quizzen beheren",
"Create/edit options for question" => "Opties voor deze vraag aanmaken/bewerken",
"points" => "punten",
"Admin quizzes" => "Quizzen beheren",
"admin quizzes tpl" => "quizzen beheren sjabloon",
"Create/edit quizzes" => "Quizzen maken/bewerken",
"There are individual permissions set for this quiz" => "Voor deze quiz bestaan er individuele permissies",
"Quiz can be repeated" => "Quiz kan herhaald worden",
"Store quiz results" => "Quizresultaten opslaan",
"Immediate feedback" => "Onmiddellijke terugkoppeling",
"Show correct answers" => "Toon juiste antwoorden",
"Shuffle questions" => "Gooi vragen door mekaar",
"Shuffle answers" => "Gooi antwoorden door mekaar",
"Questions per page" => "Vragen per pagina",
"Quiz is time limited" => "Quiz is beperkt in de tijd",
"Maximum time" => "Maximale tijd",
"Passing Percentage" => "Slaagpercentage",
"canRepeat" => "kanHerhalen",
"timeLimit" => "tijdLimiet",
"results" => "resultaten",
"Edit quiz questions" => "Bewerk quiz vragen",
"edit quiz questions" => "bewerk quiz vragen",
"edit quiz questions tpl" => "bewerk quiz vragen sjabloon",
"Create/edit questions for quiz" => "Vragen voor quiz aanmaken/bewerken",
"Question Type" => "Vraag Type",
"Import questions from text" => "Importeer vragen van tekst",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instructies: Type of plak oonderstaand uw meerkeuze vragen. De eerste regel is voor de vraag, volgende regels dienen voor de antwoorden.  Scheidt opeenvolgende vragen met een blanco regel.  Geef de juiste antwoorden aan met het beginteken \"*\" (zonder de aanhalingstekens).",
"Input" => "Invoer",
"From Points" => "Van Punten",
"To Points" => "Naar Punten",
"Answer" => "Antwoord",
"Results" => "Resultaten",
"answer" => "antwoord",
"Modify Structure" => "Bewerk Struktuur",
"You will remove" => "U zal verwijderen:",
"and its subpages from the structure, now you have two options:" => "en zijn subpagina's uit de struktuur, nu heeft u twee mogelijkheden:",
"Remove only from structure" => "Enkel uit struktuur verwijderen",
"Remove from structure and remove page too" => "Uit struktuur verwijderen en bovendien pagina verwijderen",
"Current Node" => "Huidige node",
"Page alias" => "Pagina alias",
"Promote" => "Promoveer",
"Previous" => "Vorige",
"Demote" => "Degradeer",
"Add pages to current node" => "Voeg pagina's toe aan huidige node",
"After page" => "Na pagina",
"create page" => "pagina aanmaken",
"Use pre-existing page" => "Gebruik reeds bestaande pagina",
"Structure Layout" => "Struktuurlayout",
"Help on Articles" => "Hulp voor Artikelen",
"edit submissions tpl" => "bewerk bijdragen sjabloon",
"list submissions" => "bijdragen opsommen",
"<b>*</b>=optional" => "<b>*</b>=facultatief",
"<b>Topline</b>=small line above Title" => "<b>Topline</b>=smalle lijn boven de Titel",
"<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=smalle lijn beneden de Titel",
"<b>Source</b>=URL to article source" => "<b>Source</b>=URL naar de bron van het artikel",
"EditTemplates" => "BewerkSjablonen",
"EditTemplates tpl" => "BewerkSjablonen sjabloon",
"Template listing" => "Sjabloonlijst",
"Available templates" => "Beschikbare sjablonen",
"Template" => "Sjabloon",
"Edit a topic" => "Bewerk een onderwerp",
"Edit Translation:" => "Bewerk Vertaling:",
"edit translations" => "bewerk vertalingen",
"edit translations template" => "bewerk vertalingensjabloon",
"View" => "Bekijk",
"You must specify the object language" => "U dient de taal van het object op te geven",
"The object doesn't exist" => "Het object bestaat niet",
"The object doesn't have a language" => "Het object heeft geen taal",
"The object has already a translation for this language" => "Het object is reeds vertaald in deze taal",
"The object is already in the set of translations" => "Het object is reeds aanwezig in de vertalingen",
"Use this section to set the language of the version you are currently working on." => "Gebruik deze sectie om aan te duiden in welke taal de versie is geschreven waaraan momenteel wordt gewerkt.",
"Set of Translations" => "Vertalingen",
"detach" => "loskoppelen",
"add to the set" => "voeg toe aan de vertalingen",
"Select the article for which the current article is the translation." => "Selecteer het artikel waarvan het huidig artikel de vertaling is.",
"Translation of:" => "Vertaling van:",
"Enter the name of the page for which the current page is the translation." => "Voer de naam van de pagina in waarvan de huidige pagina de vertaling is.",
"Use rating" => "Gebruik beoordelingen",
"disable" => "schakel uit",
"There is no available poll template." => "Er is geen beschikbaar opiniepeilingensjabloon.",
"You should ask an admin to create them." => "U dient een beheerder te vragen deze aan te maken.",
"an existing poll" => "een bestaande opiniepeiling",
"Try to convert HTML to wiki" => "Probeer conversie van HTML naar wiki",
"Admin ephemerides" => "Spreuken beheren",
"admin Ephemerides tpl" => "Spreuken beheren sjabloon",
"All ephemerides" => "Alle spreuken",
"Browse" => "Bladeren",
"Admin FAQ" => "FAQ beheren",
"View FAQ" => "FAQ bekijken",
"Edit this FAQ" => "Deze FAQ bewerken",
"new question" => "nieuwe vraag",
"Edit FAQ questions" => "FAQ-vragen bewerken",
"Use a question from another FAQ" => "Een vraag van een andere FAQ gebruiken",
"FAQ questions" => "FAQ vragen",
"Suggested questions" => "Voorgestelde vragen",
"approve" => "aanvaarden",
"No suggested questions" => "Geen vraag suggesties",
"File Galleries tpl" => "Bestandgalerijen sjabloon",
"configure listing" => "configureer lijst",
"Create a file gallery" => "Maak een bestandgalerij aan",
"Edit this file gallery:" => "Bewerk deze bestandgalerij:",
"create new gallery" => "maak een nieuwe galerij aan",
"There are individual permissions set for this file gallery" => "Er bestaan individuele permissies voor deze bestandgalerij",
"Gallery is visible to non-admin users?" => "Is galerij is zichtbaar voor niet-beheerders?",
"Listing configuration" => "Lijst configuratie",
"icon" => "ikoon",
"Name-filename" => "Naam-bestandnaam",
"Filename only" => "Enkel bestandnaam",
"Max description display size" => "Max schermgrootte beschrijving",
"Max Rows per page" => "Max. aantal rijen per pagina",
"Other users can upload files to this gallery" => "Andere gebruikers kunnen bestanden aan deze galerij aanleveren",
"You can access the file gallery using the following URL" => "U kan de bestandgalerij bereiken met de volgende URL",
"Available File Galleries" => "Beschikbare bestandgalerijen",
"Message queue for" => "Berichtenwachtrij voor",
"back to forum" => "terug naar het forum",
"Edit queued message" => "Bewerk bericht in de wachtrij",
"topic" => "onderwerp",
"make this a thread of" => "maak dit een thread van",
"None, this is a thread message" => "Geen, dit is een thread bericht",
"summary" => "samenvatting",
"normal" => "normaal",
"announce" => "aankondigen",
"hot" => "belangrijk",
"sticky" => "plakkend",
"no feeling" => "geen gevoel",
"frown" => "fronsen",
"exclaim" => "uitdrukking",
"idea" => "idee",
"mad" => "kwaad",
"neutral" => "neutraal",
"sad" => "droevig",
"happy" => "gelukkig",
"wink" => "knipoog",
"save and approve" => "bewaar en goedgekeurd",
"convert to topic" => "converteer naar onderwerp",
"List of messages" => "Berichtenlijst",
"new topic" => "nieuw bericht",
"no summary" => "geen samenvatting",
"No messages queued yet" => "Nog geen berichten in de wachtrij gezet",
"reject" => "verwerp",
"configure forum" => "Instellen forum",
"Reported messages for" => "Gemelde berichten voor",
"Reported by" => "Gemeldt door",
"friends tpl" => "vrienden sjabloon",
"Pending requests" => "Openstaande verzoeken",
"Request Time" => "Verzoek tijdstip",
"accept" => "aanvaarden",
"refuse" => "weiger",
"Waiting requests" => "Verzoeken in wachtrij",
"Your friends" => "Uw vrienden",
"Real Name" => "Echte Naam",
"break friendship" => "verbreek vriendschap",
"Activity completed" => "Activiteit be-eindigd",
"Admin process activities" => "Proces-activiteiten beheren",
"Add or edit an activity" => "Maak aan of bewerk een activiteit",
"end" => "einde",
"activity" => "activiteit",
"split" => "splits",
"join" => "voeg samen",
"standalone" => "alleenstaand",
"interactive" => "interactief",
"auto routed" => "auto-sturing",
"Expiration Time" => "Verlooptijd",
"Years" => "Jaren",
"Months" => "Maanden",
"Days" => "Dagen",
"Minutes" => "Minuten",
"Add transitions" => "Voeg vertaling toe",
"Add transition from:" => "Voeg vertaling toe van:",
"Add transition to:" => "Voeg vertaling toe aan:",
"roles" => "functies",
"No roles associated to this activity" => "No functies geassocieerd met deze activiteit",
"Add role" => "Voeg functie toe",
"add new" => "voeg nieuwe toe",
"add role" => "voeg functie toe",
"Process activities" => "Proces activiteiten",
"Interactive" => "Interactief",
"Automatic" => "Automatisch",
"Auto routed" => "Auto-sturing",
"Manual" => "Manueel",
"route" => "sturing",
"(no roles)" => "(geen functies)",
"No activities defined yet" => "Nog geen activiteiten gedefinieerd",
"Process Transitions" => "Proces Transities",
"List of transitions" => "Lijst van transities",
"From:" => "Van:",
"Origin" => "Oorsprong",
"No transitions defined yet" => "Nog geen transities gedefinieerd",
"Add a transition" => "Voeg een transitie toe",
"Process Graph" => "Proces Grafiek",
"Galaxia Admin Graph" => "Galaxia Grafiek beheren",
"Galaxia Admin Graph tpl" => "Galaxia Grafiek beheren sjabloon",
"This process is invalid" => "Dit proces is ongeldig",
"Process Graph for" => "Proces Grafiek voor",
"No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "Geen proces grafiek aanwezig. Ofwel bevat het proces nog fouten, ofwel is de grafiek nog niet aangemaakt, ofwel is <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> niet correct geinstalleerd.",
"List of processes" => "Processenlijst",
"Inactive" => "Inactief",
"val" => "waarde",
"active process" => "actieve processen",
"invalid" => "ongeldig",
"invalid process" => "ongeldige processen",
"valid process" => "geldige processen",
"activities" => "activiteiten",
"graph" => "grafiek",
"new minor" => "nieuwe sub",
"new major" => "nieuwe hoofd",
"No processes defined yet" => "Nog geen processe gedefinieerd",
"Admin instance" => "Incarnatie beheren",
"Process:" => "Proces:",
"Instance" => "Incarnatie",
"Workitems" => "Werkitems",
"exception" => "uitzondering",
"completed" => "afgerond",
"aborted" => "afgebroken",
"Owner" => "Eigenaar",
"Send all to" => "Verzend alles naar",
"Don't move" => "Verplaats niet",
"Activities" => "Activiteiten",
"Started" => "Gestart",
"Ended" => "Be&euml;indigd",
"Not Defined" => "Niet Gedefinieerd",
"Not Interactive" => "Niet Interactief",
"Not Ended" => "Niet Be&euml;indigd",
"Properties" => "Eigenschappen",
"Property" => "Eigenschap",
"Value" => "Waarde",
"Add property" => "Voeg eigenschap toe",
"value" => "waarde",
"run instance" => "activeer incarnatie",
"Executed" => "Uitgevoerd",
"erase" => "verwijder",
"Galaxia Admin Processes" => "Galaxia Processen beheren",
"Galaxia Admin Processes tpl" => "Galaxia Processen beheren sjabloon",
"Add or edit a process" => "Voeg toe of bewerk een proces",
"Process Name" => "Procesnaam",
"is active?" => "is actief?",
"Or upload a process using this form" => "Of lever een proces aan via dit formulier",
"Admin process roles" => "Procesfuncties beheren",
"Add or edit a role" => "Voeg toe of bewerk een functie",
"Process roles" => "Processfuncties",
"No roles defined yet" => "Nog geen functies gedefinieerd",
"Map users to roles" => "Map gebruikers naar functies",
"Map" => "Landkaart",
"Roles" => "Functies",
"Map groups to roles" => "Map groepen naar functies",
"Operation" => "Operatie",
"Warning" => "Waarschuwing",
"No roles are defined yet so no roles can be mapped" => "Nog geen functies gedefinieerd dus kunnen er ook geen functies gemapd worden",
"List of mappings" => "Lijst van mappings",
"No mappings defined yet" => "Nop geen mappings gedefinieerd",
"Admin process sources" => "Procesbronnen beheren",
"select source" => "kies bron",
"Shared code" => "Gedeelde code",
"Set next user" => "Plaats volgende gebruiker",
"Get property" => "Haal eigenschap op",
"Set property" => "Definieer eigenschap",
"Complete" => "Voltooid",
"Process form" => "Procesformulier",
"Set Next act" => "Bepaal Volgende act",
"If:SetNextact" => "Indien:DefVolgendeeact",
"Switch construct" => "Draai constructie om",
"Map process roles" => "Map procesfuncties",
"admin processes" => "processen beheren",
"admin activities" => "activiteiten beheren",
"admin roles" => "functies beheren",
"edit this process" => "bewerk dit proces",
"Galaxia Monitor Activities" => "Galaxia Monitor Activiteiten",
"Galaxia Monitor Activities tpl" => "Galaxia Monitor Activiteiten sjabloon",
"List of activities" => "Activiteitenlijst",
"Instances" => "Incarnaties",
"run" => "activeer",
"run activity" => "activeer activiteit",
"Enter the name of this instance" => "Voer de naam in van deze incarnatie",
"The name is not valid. Please, enter the name again" => "De naam is ongeldig. Probeer nogmaals",
"monitor processes" => "monitor processen",
"monitor activities" => "monitor activiteiten",
"monitor instances" => "monitor incarnaties",
"monitor workitems" => "monitor werkitems",
"Galaxia Monitor Instances" => "Galaxia Monitor Incarnaties",
"Galaxia Monitor Instances tpl" => "Galaxia Monitor Incarnaties sjabloon",
"List of instances" => "Lijst van incarnaties",
"Not ended" => "Niet be&euml;indigd",
"No instances created yet" => "Nog geen incarnaties aangemaakt",
"Galaxia Monitor Processes" => "Galaxia Monitor Processen",
"Galaxia Monitor Processes tpl" => "Galaxia Monitor Processen sjabloon",
"Valid" => "Geldig",
"Invalid" => "Ongeldig",
"processes" => "processen",
"being run" => "lopende",
"exceptions" => "uitzondering",
"Monitor workitems" => "Monitor werkitems",
"List of workitems" => "Lijst van werkitems",
"instance" => "incarnatie",
"My activities" => "Mijn activiteiten",
"Current Activity" => "Huidige Activiteit",
"Assigned To" => "TOegewezen Aan",
"exception instance" => "uitzonderingsincarnatie",
"exceptions instance" => "uitzonderingenincarnatie",
"send instance" => "verstuur incarnatie",
"abort instance" => "breek incarnatie af",
"grab instance" => "grijp incarnatie",
"release instance" => "laat incarnatie vrij",
"No activities found" => "Geen activiteiten gevonden",
"My instances" => "Mijn incarnaties",
"No instances found" => "Geen incarnaties gevonden",
"activate" => "activeer",
"User Activities" => "Gebruikeractiviteiten",
"Galaxia User Activities" => "Galaxia Gebruiker Activiteiten",
"Galaxia User Activities tpl" => "Galaxia Gebruiker Activiteiten sjabloon",
"process" => "proces",
"user processes" => "gebruikerprocessen",
"user activities" => "gebruikeractiviteiten",
"user instances" => "gebruikerincarnaties",
"Galaxia User Instances" => "Galaxia Gebruiker Incarnaties",
"Galaxia User Instances tpl" => "Galaxia Gebruiker Incarnaties sjabloon",
"Not defined" => "Niet gedefinieerd",
"No instances defined yet" => "Nog geen incarnaties gedefinieerd",
"Galaxia User Processes" => "Galaxia Gebruikerprocessen",
"Galaxia User Processes tpl" => "Galaxia Gebruikerprocessen sjabloon",
"Browsing Workitem" => "Bekijken Werkitem",
"Workitem information" => "Informatie Werkitem",
"galleries tpl" => "galerijen sjabloon",
"rebuild cache" => "hermaak buffer",
"Create a gallery" => "Maak een galerij aan",
"Edit this gallery:" => "Bewerk deze galerij:",
"There are individual permissions set for this gallery" => "Er bestaan individuele permissies voor deze galerij",
"Geographic" => "Geografisch",
"Images per row" => "Afbeeldingen per rij",
"Thumbnails size X" => "Voorbeeldplaatjes X afmeting",
"Thumbnails size Y" => "Voorbeeldplaatjes Y afmeting",
"Default sort order" => "Standaard sorteervolgorde",
"Fields to show during browsing the gallery" => "Velden die getoond moeten worden tijdens het bladeren door de galerij",
"Image ID" => "Afbeelding ID",
"Creation Date" => "Aanmaakdatum",
"XY-Size" => "XY-Grootte",
"Filesize" => "Bestandgrootte",
"Gallery Image" => "Galerijafbeelding",
"Parent gallery" => "Oudergalerij",
"Available scales" => "Beschikbare schalen",
"Bounding box" => "Vormkader",
"default scale" => "standaard schaal",
"No scales available" => "Geen schalen beschikbaar",
"Original image is default scale" => "Originele afbeelding is standaard schaal",
"Add scaled images with bounding box of square size" => "Voeg geschaalde afbeeldingen toe met een vierkant vormkader",
"Other users can upload images to this gallery" => "Andere gebruikers kunnen afbeeldingen aanleveren aan deze galerij",
"You can access the gallery using the following URL" => "U kan de galerij via volgende URL bereiken",
"Available Galleries" => "Beschikbare galerijen",
"Choose a filter" => "Kies een filter",
"Imgs" => "Afb.",
"Make Map" => "Maak Kaart aan",
"Pie Chart" => "Taartgrafiek",
"Multiline" => "Multilijns",
"Multibar" => "Multibalken",
"Bar Stack" => "Gestapelde balken",
"Landscape" => "Liggend",
"Portrait" => "Staand",
"Independant Scale" => "Onafhankelijke Schaal",
"Horizontal" => "Horizontaal",
"Vertical" => "Verticaal",
"Horizontal Scale" => "Horizontale Schaal",
"Bottom" => "Laagste",
"Vertical Scale" => "Verticale Schaal",
"Left" => "Links",
"Right" => "Rechts",
"Series" => "Reeks",
"Im- Export languages" => "Im-/Export talen",
"Select the language to Import" => "Selecteer taal voor Import",
"Select the language to Export" => "Selecteer taal voor Export",
"Import From File" => "Importeer van Bestand",
"Grab Wiki Tables" => "Pak Wiki Tabellen",
"Import pages from a Structured Text Dump" => "Importeer pagina\\'s van een Gestrucutureerde Tekst Dump",
"ImportingPagesPhpWikiPageAdmin" => "ImporteerPaginasPhpWikiPageAdmin",
"tiki-import_phpwiki tpl" => "tiki-import_phpwiki sjabloon",
"Name of the dump file (it has to be in dump/)" => "Naam van het dump-bestand (moet in dump/ staan)",
"Overwrite existing pages if the name is the same" => "Bestaande pagina's overschrijven als de naam identiek is",
"Previously remove existing page versions" => "Vooraf bestaande paginaversies verwijderen",
"excerpt" => "uittreksel",
"result" => "resultaat",
"body" => "tekstlichaam",
"reload" => "herlaad",
"Install" => "Installeer",
"Clear cached version and refresh cache" => "Leef buffer versie en ververs buffer",
"configure rules" => "Configureer regels",
"edit repository" => "bewerk bewaarplaats",
"Weeks" => "Weken",
"Search by Date" => "Zoeken volgens datum",
"Found" => "Gevonden",
"LastChanges" => "LaatsteWijzigingen",
"hist" => "gesch.",
"rollback" => "terugplaatsen",
"source" => "bron",
"Pages like" => "Gelijkaardige pagina's",
"No pages found" => "Geen pagina's gevonden",
"List Articles" => "Opsommen Artikelen",
"list articles tpl" => "opsommen artikelen sjabloon",
"edit new article" => "nieuw artikel bewerken",
"ExpireDate" => "Verloopdatum",
"AuthorName" => "AuteursNaam",
"admin Banners" => "Advertenties beheren",
"admin Banners tpl" => "Advertenties beheren sjabloon",
"Create banner" => "Advertentie aanmaken",
"Method" => "Methode",
"Use Dates?" => "Data gebruiken?",
"Max Impressions" => "Max klikken",
"Impressions" => "Klikken",
"Clicks" => "Klikken",
"create new blog" => "Maak nieuw journaal aan",
"Last Modified" => "Laatst Gewijzigd",
"admin cache" => "buffer beheren",
"admin cache tpl" => "buffer beheren sjabloon",
"Dynamic content system" => "Systeem met dynamische inhoud",
"Help on Dynamic Content" => "Hulp voor Dynamische Inhoud",
"admin DynamicContent tpl" => "Dynamische Inhoud beheren sjabloon",
"Create or edit content block" => "Inhoudsblok aanmaken of beheren",
"Available content blocks" => "Beschikbare inhoudsblokken",
"Current ver" => "Huidige versie",
"Next ver" => "Volgende versie",
"Future vers" => "Toekomstige vers",
"Old vers" => "Oude versie",
"Program" => "Programma",
"list faqs tpl" => "opsommen faqs sjabloon",
"Edit this FAQ:" => "Bewerk deze FAQ:",
"Create new FAQ" => "Maak nieuwe FAQ aan",
"Create New FAQ:" => "Maak Nieuwe FAQ aan:",
"Users can suggest questions" => "Gebruikers kunnen vragen voorstellen",
"Available FAQs" => "Beschikbare FAQs",
"Listing Gallery" => "Opsomming van galerij",
"upload file" => "bestand aanleveren",
"Edit a file using this form" => "Bewerk een bestand via dit formulier",
"monitor this gallery" => "monitor deze galerij",
"stop monitoring this gallery" => "stop monitoring van deze galerij",
"Gallery Files" => "Galerijbestanden",
"move selected files" => "verplaats geselecteerde bestanden",
"delete selected files" => "verwijder geselecteerde bestanden",
"Move to" => "Verplaats naar",
"Dls" => "Afhlgn",
"browse gallery" => "galerij bekijken",
"Gallery Images" => "Galerijafbeeldingen",
"games tpl" => "spellen sjabloon",
"All games are from" => "Alle spelletjes zijn van",
"visit the site for more games and fun" => "bezoek de site voor meer spelletjes en plezier",
"Upload a game" => "Een spelletje aanleveren",
"Upload a new game" => "Een nieuw spelletje aanleveren",
"Flash binary (.sqf or .dcr)" => "Flash binair bestand (.sqf of .dcr)",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Voorbeeldplaatje (als het spelletje iets.swf is moet de thumbnail iets.swf.gif of iets.swf.png of iets.swf.jpg genoemd worden)",
"Edit game" => "Spel bewerken",
"Played" => "Gespeeld",
"times" => "keer",
"If you can't see the game then you need a flash plugin for your browser" => "Als u het spelletje niet kan zien dan heeft u een flash plugin nodig voor uw browser",
"list posts tpl" => "opsommen berichten sjabloon",
"edit blog" => "bewerk journaal",
"Blog Title" => "Journaaltitel",
"list quizzes tpl" => "quizzen lijst sjabloon",
"edit new submission" => "nieuwe bijdrage bewerken",
"Approve" => "Goedkeuren",
"edit quiz stats tpl" => "bewerken quiz stats sjabloon",
"Survey stats" => "Statistieken voor opinieonderzoek",
"actions" => "acties",
"take survey" => "neem deel aan opinieonderzoek",
"list trackers tpl" => "trackers lijst sjabloon",
"Distance (km)" => "Afstand (km)",
"List Movies" => "Opsommen Filmen",
"Choose a movie" => "Kies een film",
"Display" => "Toon",
"Last mod" => "Laatste wijz.",
"Last author" => "Laatste auteur",
"Last ver" => "Laatste ver.",
"Com" => "Opm.",
"Vers" => "Versie",
"with checked" => "met gecheckt",
"admin live support tpl" => "live ondersteuning beheren sjabloon",
"Open client window" => "Open client venster",
"Generate HTML" => "Maak HTML aan",
"Transcripts" => "Afschriften",
"Support tickets" => "Ondersteuningtickets",
"Online operators" => "Online operatoren",
"Accepted requests" => "Aanvaarde aanvragen",
"transcripts" => "afschriften",
"Offline operators" => "Offline operatoren",
"Add an operator to the system" => "Voeg een operator toe aan het systeem",
"Operators must be tiki users" => "Operatoren moeten tiki gebruikers zijn",
"set as operator" => "definieer als operator",
"Chat started" => "Praatkamer gestart",
"User:" => "Gebruiker:",
"Live support:User window" => "Live ondersteuning:gebruikervenster",
"Request live support" => "Vraag live-ondersteuning aan",
"Request support" => "Vraag ondersteuning aan",
"Open a support ticket instead" => "Open een ondersteuningsticket ipv",
"Your request is being processed" => "Uw aanvraag wordt behandeld",
"cancel request and exit" => "annuleer aanvraag en verlaat",
"cancel request and leave a message" => "annuleer aanvraag en laat een bericht achter",
"Live support:Console" => "Live-ondersteuning:Console",
"be online" => "ga online",
"be offline" => "ga offline",
"Support requests" => "Ondersteuningsaanvragen",
"Requested" => "Aangevraagd",
"Accept" => "Aanvaardt",
"Join" => "Neem deel",
"Support chat transcripts" => "Afschriften Ondersteuningskanaal",
"back to admin" => "terug naar beheer",
"started" => "gestart",
"reason" => "reden",
"msgs" => "brchtn",
"Transcript" => "Afschrift",
"Mail-in feature" => "Mail-in onderdeel",
"User Calendar" => "Gebruikerskalender",
"User Calendar Doc tpl" => "Gebruikerkalender Doc sjabloon",
"Remove old events" => "Verwijderen oude evenementen",
"duration" => "duur",
"Add or edit event" => "Toevoegen/bewerken evenement",
"Mini Calendar: Preferences" => "Mini-Kalender: Voorkeuren",
"User Calendar Doc" => "Gebruikerkalender Doc",
"User Calendar Preferences Doc tpl" => "Gebruikerkalender Voorkeuren Doc sjabloon",
"Calendar Interval in daily view" => "Kalendarinterval in dagzicht",
"Start hour for days" => "Startuur voor dagen",
"End hour for days" => "Einduur voor dagen",
"Reminders" => "Herinneringen",
"no reminders" => "geen herinneringen",
"Import CSV file" => "Importeer CSV bestand",
"Or enter path or URL" => "Of voer pad of URL in",
"add topic" => "onderwerp toevoegen",
"Update remote index" => "Werk verre index bij",
"Rebuild local list" => "Hermaal lokale lijst",
"Republish all" => "Publiceer alles opnieuw",
"Publish all" => "Publiceer alles",
"Unpublish all" => "Maak publicatie van alles ongedaan",
"Attention" => "Attentie",
"Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example)." => "Apache heeft de rechten om in uw bestandssysteem te schrijven waardoor u kan installaties, de-installaties of \nupgrades van pakketten kan uitvoeren. Wanneer u klaar bent met deze werkzaamheden, denk er dan aan om deze permissies terug te zetten naar een veiligere installing (gebruik \n\"./fixperms.sh fix\" bijv).",
"To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\")." => "Om installatie, de-installaties en upgrades van pakketten te kunnen doen, dient u de apache gebruiker de nodige rechten te geven om\nbestande aan te maken in het bestandssysteem van uw webruimte (gebruik hiervoor bijv. \"./fixperms.sh open\"). Na de installatie dient u deze rechten terug te verwijderen\n (gebruik dan \"./fixperms.sh fix\").",
"all types" => "alle types",
"Display only this type" => "Toon enkel dit type",
"Unpublish" => "Maak publicatie ongedaan",
"Republish" => "Publiceer opnieuw",
"install" => "installeer",
"Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuratie",
"Enable Mods providing" => "Schakel Mods in die voorzien in",
"Mods local directory" => "Mods lokale folder",
"Mods remote server" => "Mods verre server",
"Package Config" => "Pakket Config",
"my tiki tpl" => "mijn tiki sjabloon",
"My pages" => "Mijn pagina's",
"My items" => "Mijn items",
"My tasks" => "Mijn taken",
"subscribe" => "abonneer",
"Sent edition" => "Verzend editie",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Bedankt voor uw inschrijving. U zal binnenkort een e-mailbericht ontvangen om uw inschrijving te bevestigen. U zal geen nieuwsbrieven ontvangen tot uw inschrijving bevestigd is.",
"Your email address was removed from the list of subscriptors." => "Uw e-mail adres is verwijderd van de abonneelijst.",
"Subscription confirmed!" => "Inschrijving bevestigd!",
"Subscribe to newsletter" => "Zich op nieuwsbrief abonneren",
"Email:" => "E-mail:",
"Subscribe" => "Abonneren",
"Available Newsletters" => "Beschikbare nieuwsbrieven",
"Select news group" => "Selecteren nieuwsgroep",
"Back to servers" => "Terug naar de servers",
"Msgs" => "Brchtn",
"News from" => "Nieuws",
"Save position" => "Positie bewaren",
"Reading article from" => "Artikel lezen van",
"Back to list of articles" => "Teurg naar de lijst van artikelen",
"First" => "Eerste",
"Newsgroup" => "Nieuwsgroep",
"Configure news servers" => "Stel nieuwsservers in",
"Configure Newsreader" => "Configureer Nieuwslezer",
"configure newsreader server tpl" => "configureer nieuwslezer server sjabloon",
"Select a news server to browse" => "Selecteer een nieuwsserver om door te bladeren",
"Read the news" => "Lees het nieuws",
"Add or edit a news server" => "Bewerken/toevoegen nieuwsserver",
"News server" => "Nieuwsserver",
"Notes" => "Notities",
"Write a note" => "Notitie schrijven",
"No notes yet" => "Nog geen notities",
"merge selected notes into" => "voeg geselecteerde notities in",
"Reading note:" => "Notitie lezen",
"List notes" => "Notities tonen",
"Write note" => "Notitie schrijven",
"wiki create" => "wiki aanmaak",
"wiki overwrite" => "wiki overschrijf",
"Assign permissions to " => "Permissies toekennen aan ",
"back" => "terug",
"Current permissions for this object" => "Huidige permissies voor dit object",
"Assign permissions to this object" => "Permissies toekennen aan dit object",
"Published" => "Gepubliceerd",
"Votes" => "Stemmen",
"Orphan Pages" => "Verweesde Pagina's",
"Preview of version" => "Voorbeeld van versie",
"(current)" => "(huidige)",
"rollback to this version" => "draai terug naar deze versie",
"Source of version" => "Bron van de versie",
"s=source" => "s=bron (source)",
"b=rollback" => "b=draai terug (rollback)",
"Assign permissions to page" => "Permissies toekennen aan pagina",
"Current permissions for this page" => "Huidige permissies voor deze pagina",
"remove from this page" => "verwijder van deze pagina",
"remove from this structure" => "verwijder uit deze struktuur",
"No individual permissions; category or global permissions apply" => "Geen individuele permissies: categorie of globale permissies zijn van kracht",
"this page" => "deze pagina",
"this structure" => "deze struktuur",
"Current permissions for categories that this page belongs to" => "Huidige permissies voor categorie&uml;n waartoe deze pagina behoort",
"No category permissions; global permissions apply" => "Geen categorie permissies; globale permissies zijn van kracht",
"Send email notifications when this page changes to" => "E-mail berichtgevingen verzenden wanneer deze pagina verandert naar",
"add email" => "e-mail toevoegen",
"Notifications" => "Meldingen",
"Pick your avatar" => "Kies uw pictogram",
"Your current avatar" => "Uw huidige pictogram",
"no avatar" => "geen pictogram",
"Pick avatar from the library" => "Pictogram uit de bibliotheek kiezen",
"icons" => "ikonen",
"Show all" => "Toon alles",
"Avatar Image" => "Pictogramafbeelding",
"random" => "willekeurig",
"Upload your own avatar" => "Uw eigen pictogram aanleveren",
"lastModif" => "laatsteWijz",
"atts" => "attn",
"Number of voices" => "Aantal stemmen",
"Average" => "Gemiddelde",
"List Attachments" => "Bijlagenlijst",
"View Results" => "Bekijk Resultaten",
"Vote poll" => "Stem opiniepeiling",
"Other Polls" => "Andere Opiniepeilingen",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Opmerking: Deze voorbeeldversie werd nog niet opgeslagen!",
"Print multiple pages" => "Meerdere pagina's afdrukken",
"Print Wiki Pages" => "Wikipagina's afdrukken",
"clear" => "opruimen",
"Edit quiz" => "Bewerk quiz",
"Current Version" => "Huidige versie",
"General Options" => "Algemene opties",
"Publication Date" => "Publicatiedatum",
"at " => "aan ",
"Use " => "gebruik ",
"randomly selected questions." => "willekeurig gekozen vragen.",
"Test-time Options" => "Test-tijd Opties",
"Limit questions displayed per page to " => "Beperk aantal getoonde vragen per pagina tot ",
"&nbsp question(s)." => "&nbsp vra(a)g(en).",
"Impose a time limit of " => "Zet een tijdslimiet van ",
"Allow students to store partial results and return to quiz." => "Laat studenten toe om tussentijdse resultaten op te slaan en naar quiz terug te keren.",
"Allow students to retake this quiz " => "Laat studenten toe om deze quiz te herdoen ",
"Grading and Feedback" => "Beoordeling en terugkoppeling",
"Grading method " => "Beoordelingsmethode ",
"Show students their score " => "Toon score aan studenten ",
"Show students the correct answers " => "Toon juiste antwoorden aan studenten ",
"Publish statistics " => "Publiceer statistieken ",
"Extra Options" => "Extra Opties",
"Solicit additional questions from students" => "Verzoek om bijkomende vragen aan studenten",
"Link quiz to forum named: " => "Koppel quiz aan genaamd forum: ",
"Prologue:" => "Proloog:",
"Epilogue:" => "Epiloog:",
"Quiz result stats" => "Statistieken voor quizresultaat",
"Time" => "Tijd",
"User answers" => "Gebruikerantwoorden",
"Stats for quizzes" => "Statistieken voor quizzen",
"taken" => "uitgevoerd",
"Av score" => "Gem. score",
"Av time" => "Gem. tijd",
"Stats for quiz" => "Statistieken voor quiz",
"clear stats" => "statistieken verwijderen",
"time taken" => "verstreken tijd",
"Stats for this quiz Questions " => "Statistieken voor de vragen in deze quiz ",
"Received Articles" => "Ontvangen artikelen",
"received articles tpl" => "ontvangen artikelen sjabloon",
"Edit received article" => "Ontvangen artikelen bewerken",
"Use Image" => "Afbeelding Gebruiken",
"Image x size" => "Afbeelding x-afmeting",
"Image y size" => "Afbeelding y-afmeting",
"Image name" => "Afbeeldingnaam",
"Accept Article" => "Artikel Aanvaarden",
"Help on Communication Center" => "Hulp voor Communicatiecentrum",
"received pages tpl" => "ontvangen pagina's sjabloon",
"Edit received page" => "Ontvangen pagina bewerken",
"admin Referer stats" => "Verwijzer stats beheren",
"admin Referer stats tpl" => "Verwijzer stats beheren sjabloon",
"last" => "laatste",
"A valid email is mandatory to register" => "Een geldig e-mail adres is vereist voor registratie",
"Tiki site registered" => "Tiki site geregistreerd",
"You don't have permission to use this feature." => "U heeft geen toestemming om dit onderdeel te gebruiken.",
"Please register." => "Meldt u zich aub aan.",
"Read this first!" => "Lees dit eerst!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Op deze pagina kan u uw Tiki site kenbaar maken op tikiwiki.org. Uw site zal opgenomen worden in een lijst van gekende tiki sites.",
"Registering is voluntary." => "Registratie is vrijwillig.",
"Registering does not give you any benefits except one more link to your site." => "Registratie geeft u enkel het voordeel van een extra koppeling naar uw eigen site.",
"You don't get any emails, we don't sell the data about your site." => "U zal geen e-mails ontvangen en uw gegevens worden niet aan derden verkocht.",
"Registering is just for us to get an overview of Tiki's usage." => "De registratie dient er enkel toe een overzicht te krijgen van het Tiki-gebruik.",
"If your site is private or inside your intranet, you should not register!" => "Indien uw site prive is of zich op een intranet bevindt, registreer u dan niet!",
"Information about your site" => "Informatie omtrent uw site",
"I forgot my password" => "Ik ben mijn wachtwoord vergeten",
"send me my password" => "gelieve mijn wachtwoord op te sturen",
"Return to HomePage" => "Terug naar startpagina",
"Remove page" => "Pagina verwijderen",
"last version" => "laatste versie",
"You are about to remove the page" => "Pas op, u zal een pagina verwijderen",
"permanently" => "permanent",
"Remove all versions of this page" => "Alle versies van deze pagina verwijderen",
"Rename page" => "Hernoemen pagina",
"Replicate" => "Repliceer",
"Slave" => "Slaaf",
"Master" => "Meester",
"Change" => "Wijzig",
"Operations" => "Handelingen",
"Operations Log" => "Handelingen Log",
"Rollback page" => "Pagina terugplaatsen",
"to_version" => "naar_versie",
"Search Stats" => "Zoek Stats",
"search stats tpl" => "zoek stats sjabloon",
"searched" => "gezocht",
"Search in" => "Zoeken in",
"galleries" => "galerijen",
"blog posts" => "journaalbijdragen",
"articles" => "artikelen",
"entire site" => "volledige site",
"wiki pages" => "wiki pagina\\'s",
"Simple search" => "E&eacute; zoekopdracht",
"No pages matched the search criteria" => "Geen pagina's gevonden met deze zoekcriteria",
"Send blog post" => "Verstuur journaalbijdrage",
"A link to this post was sent to the following addresses:" => "Een koppeling naar deze bijdrage is naar volgende adressen verzonden:",
"Send post to this addresses" => "Verzend bijdrage naar deze adressen",
"List of email addresses separated by commas" => "Lijst van e-mail adressen gescheiden door komma's",
"Apply content template" => "Pas Inhoudssjabloon toe",
"Send objects" => "Objecten zenden",
"admin send objects tpl" => "verzend objecten beheren sjabloon",
"Transmission results" => "Overdrachtresultaten",
"Send objects to this site" => "Objecten naar deze pagina zenden",
"password" => "wachtwoord",
"Send Wiki Pages" => "Wikipagina's zenden",
"Send Articles" => "Artikel Zenden",
"add article" => "artikel toevoegen",
"sheets tpl" => "rekenbladen sjabloon",
"Create a sheet" => "Maak een rekenblad aan",
"Edit this sheet:" => "Bewerk dit rekenblad:",
"create new sheet" => "Aanmaken rekenblad",
"There are individual permissions set for this sheet" => "Er zijn individuele permissies actief voor dit rekenblad",
"Class Name" => "Klasnaam",
"Header Rows" => "Hoofding Rijen",
"Footer Rows" => "Voettekst Rijen",
"Create new Sheet" => "Maak nieuw Rekenblad aan",
"You can access the sheet using the following URL" => "U kan het rekenblad bereiken via volgend URL",
"Available Sheets" => "Beschikbare rekenbladen",
"Graph" => "Grafiek",
"Tiki Shoutbox" => "Tiki Spreekbuis",
"admin Tiki Shoutbox" => "Tiki Spreekbuis beheren",
"admin Tiki Shoutbox tpl" => "Tiki Spreekbuis beheren sjabloon",
"Change shoutbox general settings" => "Verander algemene instellingen spreekbuis",
"auto-link urls" => "auto-koppel urls",
"Post or edit a message" => "Een bijdragen toevoegen of bewerken",
"first" => "eerste",
"big grin" => "grote grijns",
"confused" => "verward",
"cool" => "interessante",
"cry" => "huilt",
"evil" => "kwaadaardig",
"mr green" => "mr groen",
"redface" => "aangelopen",
"rolleyes" => "roltogen",
"smile" => "lacht",
"surprised" => "verrast",
"twisted" => "ziekelijk",
"arrow" => "pijl",
"Site Stats" => "Statistieken voor de site",
"Days online" => "Dagen on-line",
"Total pageviews" => "Totaal aantal keer bekeken",
"Average pageviews per day" => "Gemiddeld aantal keer bekeken per dag",
"Best day" => "Beste dag",
"Worst day" => "Slechtste dag",
"Wiki Stats" => "Statistieken voor wiki",
"Size of Wiki Pages" => "Grootte van wikipagina's",
"Average page length" => "Gemiddelde paginalengte",
"Average versions per page" => "Gemiddeld aantal versies per pagina",
"Visits to wiki pages" => "Aantal bezoeken aan wikipagina's",
"Average links per page" => "Gemiddeld aantal koppelingen per pagina",
"Image galleries Stats" => "Statistieken voor beeldgalerijen",
"Average images per gallery" => "Gemiddeld aantal afbeeldingen per galerij",
"Total size of images" => "Grootte van alle afbeeldingen samen",
"Average image size" => "Gemiddelde grootte van afbeeldingen",
"Visits to image galleries" => "Aantal bezoeken aan beeldgalerijen",
"File galleries Stats" => "Statistieken voor bestandgalerijen",
"Average files per gallery" => "Gemiddeld aantal bestanden per galerij",
"Total size of files" => "Grootte van alle bestanden samen",
"Average file size" => "Gemiddelde bestandgrootte",
"Visits to file galleries" => "Aantal bezoeken aan bestandgalerijen",
"CMS Stats" => "Statistieken voor CMS",
"Total reads" => "Totaal aantal keer gelezen",
"Average reads per article" => "Gemiddeld aantal keer gelezen per artikel",
"Total articles size" => "Grootte van alle artikelen samen",
"Average article size" => "Gemiddelde grootte van een artikel",
"Forum Stats" => "Statistieken voor forum",
"Total topics" => "Onderwerpen samen",
"Average topics per forums" => "Gemiddeld aantal onderwerpen per forum",
"Total threads" => "Threads samen",
"Average threads per topic" => "Gemiddeld aantal threads per onderwerp",
"Visits to forums" => "Aantal bezoeken aan forums",
"Blog Stats" => "Statistieken voor journalen",
"Weblogs" => "Journalen",
"Total posts" => "Totaal aantal bijdragen",
"Average posts per weblog" => "Gemiddeld aantal berichten per journaal",
"Total size of blog posts" => "Totale grootte van de journaalbijdragen",
"Average posts size" => "Gemiddelde grootte van de bijdragen",
"Visits to weblogs" => "Aantal bezoeken aan journalen",
"Poll Stats" => "Statistieken voor opiniepeilingen",
"Total votes" => "Totaal aantal stemmen",
"Average votes per poll" => "Gemiddeld aantal stemmen per opiniepeiling",
"Faq Stats" => "Statistieken voor FAQ",
"Total questions" => "Totaal aantal vragen",
"Average questions per FAQ" => "Gemiddeld aantal vragen per FAQ",
"User Stats" => "Statistieken voor gebruiker",
"User bookmarks" => "Gebruikerfavorieten",
"Average bookmarks per user" => "Gemiddeld aantal favorieten per gebruiker",
"Quiz Stats" => "Statistieken voor quiz",
"Average questions per quiz" => "Gemiddeld aantal vragen per quiz",
"Quizzes taken" => "Uitgevoerde quizzen",
"Average quiz score" => "Gemiddelde quizscore",
"Average time per quiz" => "Gemiddelde tijd per quiz",
"Stats for surveys" => "Statistieken voor opinieonderzoeken",
"Survey" => "Opinieonderzoek",
"Last taken" => "Laatst uitgevoerd",
"Stats for survey" => "Statistieken voor opinieonderzoek",
"Stats for this survey Questions " => "Statistieken voor de vragen in dit opinieonderzoek ",
"system logs" => "systeem logs",
"system logs tpl" => "systeem logs sjabloon",
"Time Left" => "Tijd Over",
"send answers" => "antwoorden verzenden",
"Result" => "Resultaat",
"Thank you for your submission" => "Bedankt voor uw bijdrage",
"Theme Control Center: categories" => "Thema Controlepaneel: categorie&euml;n",
"ThemeControl" => "Thema Controle",
"ThemeControl tpl" => "Thema Controle sjabloon ",
"Theme is selected as follows" => "Thema is geselecteerd as volgens",
"If a theme is assigned to the individual object that theme is used." => "Een thema wordt gebruikt indien het thema is toegewezen aan een individueel object",
"If not then if a theme is assigned to the object's category that theme is used" => "Indien dit niet het geval is, wordt het thema gebruikt dat toegewezen is aan de objectcategorie",
"If not then a theme for the section is used" => "Indien dit niet het geval is, wordt het thema van de sectie gebruikt",
"If none of the above was selected the user theme is used" => "Indien geen enkele van bovenstaande mogelijkheden valabel is, wordt het gebruikerthema toegepast",
"Finally if the user didn't select a theme the default theme is used" => "Wanneer de gebruiker geen thema heeft geselecteerd, dan wordt het standaardthema gebruikt",
"Control by Objects" => "Controle per Objecten",
"Control by Sections" => "Controle per Sectie",
"Assign themes to categories" => "Thema's toewijzen aan categorie&euml;n",
"Assigned categories" => "Toegewezen categorie&euml;n",
"theme" => "thema",
"Theme Control Center: Objects" => "Thema Controlepaneel: Objecten",
"ThemeControl Objects" => "Thema-Controle Objecten",
"theme control objects tpl" => "thema-controle objecten sjabloon",
"Control by Categories" => "Controle per Categorie",
"Assign themes to objects" => "Thema's toewijzen aan objecten",
"Assigned objects" => "Toegewezen objecten",
"Theme Control Center: sections" => "Theme Controlepaneel: secties",
"theme control sections tpl" => "thema-controle secties sjabloon",
"Assign themes to sections" => "Thema's toewijzen aan secties",
"Assigned sections" => "Toegewezen secties",
"Edit File:" => "Bewerk Bestand:",
"Upload File" => "Bestand Aanleveren",
"File Title" => "Bestandtitel",
"Now enter the file URL" => "Gelieve nu de bestand-URL in te geven",
" or upload a local file from your disk" => " of een bestand van uw lokale harde schijf aan te leveren",
"Batch upload" => "Massa-aanlevering",
"The following file was successfully uploaded" => "Het volgende bestand is met success aangeleverd",
"You can download this file using" => "U kan dit bestand afhalen met",
"You can include the file in an HTML/Tiki page using" => "U kan het bestand invoegen in een HTML/Tiki pagina met",
"Image Gallery tpl" => "Beeldgalerij sjabloon",
"or use filename" => "of gebruik bestandnaam",
"Now enter the image URL" => "Geef nu de URL van de afbeelding",
" or upload a local image from your disk" => " of lever een afbeelding aan van uw harde schijf",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Voorbeeldplaatje (optioneel, overschrijft automatisch aangemaakte voorbeeldplaatjes)",
"Note: Maximum image size is limited to" => "Opmerking: Grootte van de afbeelding is beperkt tot",
"Upload successful!" => "Aanleveren gelukt!",
"The following image was successfully uploaded" => "De volgende afbeelding is met success aangeleverd",
"Thumbnail" => "Voorbeeldplaatje",
"Image ID thumb" => "Afbeelding ID voorbeeld",
"You can include the image in an Wiki page using" => "U kan de afbeelding in een Wiki pagina insluiten door gebruik te maken van",
"User assigned modules" => "Door de gebruiker toegekende modules",
"User Assigned Modules" => "Toegewezen Modules aan Gebruikers",
"User Assigned Modules tpl" => "Toegewezen Modules aan Gebruikers sjabloon",
"Restore defaults" => "Standaardinstellingen herstellen",
"move to right column" => "verplaats naar rechterkolom",
"unassign" => "toekenning ongedaan maken",
"move to left column" => "verplaats naar linkerkolom",
"Assign module" => "Module toekennen",
"Column" => "Kolom",
"User Bookmarks tpl" => "Gebruikerfavorieten sjabloon",
"Current folder" => "Huidige folder",
"remove folder" => "verwijder folder",
"refresh cache" => "ververs buffer",
"Admin folders and bookmarks" => "Folders en favorieten beheren",
"Add or edit folder" => "Folder toevoegen of bewerken",
"Add or edit a URL" => "Een URL toevoegen of bewerken",
"Avatar" => "Pictogram",
"Homepage" => "Thuispagina",
"Users HomePage" => "Gebruikersthuispagina",
"Personal Wiki Page" => "Persoonlijke Wiki Pagina",
"Create page" => "Maak pagina aan",
"Displayed time zone" => "Getoonde tijdzone",
"This user is your friend" => "Deze gebruiker is uw vriend",
"Request friendship from this user" => "Verzoek vriendschap van deze gebruiker",
"Send me a message" => "Stuur me een bericht",
"Toggle options" => "Toggle opties",
"User Preferences" => "Gebruikerinstellingen",
"UserPreferences tpl" => "GebruikerVoorkeuren sjabloon",
"Personal Information" => "Persoonlijke Informatie",
"General preferences" => "Algemene voorkeuren",
"Other preferences" => "Andere voorkeueren",
"Pick user Avatar" => "Kies gebruikerpictogram",
"HomePage" => "StartPagina",
"Your personal Wiki Page" => "Uw persoonlijke wikipagina",
"Your personal tracker information" => "Uw persoonlijke tracker informatie",
"View extra information" => "Bekijk extra informatie",
"Change information" => "Wijzig informatie",
"Is email public? (uses scrambling to prevent spam)" => "Is e-mail publiek? (gebruik vervorming om spam te voorkomen)",
"Unavailable - please set your e-mail below" => "Niet beschikbaar - stel uw e-mail adres onderstaand in",
"Does your mail reader need a special charset" => "Vereist uw e-mail programma een speciale karakterset?",
"Number of visited pages to remember" => "Aantal bezochte pagina's die moeten herinnerd worden",
"Local" => "Lokaal",
"User information" => "Gebruikerinformatie",
"private" => "privaat",
"public" => "publiek",
"Use double-click to edit pages" => "Gebruik dubbelklik om pagina's te bewerken",
"Account Information" => "Account Informatie",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Laat \"Nieuw wachtwoord\" en \"Bevestig nieuw wachtwoord\" velden open om uw huidig wachtwoord te behouden",
"Email address" => "E-mail adres",
"Confirm new password" => "Bevestig nieuw wachtwoord",
"Current password (required)" => "Huidig wachtwoord (vereist)",
"Change administrative info" => "Wijzig administratieve informatie",
"Messages per page" => "Berichten per pagina",
"Allow messages from other users" => "Berichten toestaan van andere gebruikers",
"Note author when reading his mail" => "Informeer auteur wanneer hij/zij het bericht leest",
"Send me an email for messages with priority equal or greater than" => "Mij een e-mail versturen voor berichten met prioriteit groter dan of gelijk aan",
"Auto-archive read messages after x days" => "Auto-archiveer gelezen berichten na x dagen",
"Tasks per page" => "Taken per pagina",
"My messages" => "Mijn berichten",
"My workflow" => "Mijn workflow",
"User Tasks tpl" => "Gebruikertaken sjabloon",
"New task" => "Nieuwe taak",
"Task list" => "Takenlijst",
"Admin mode off" => "Beheermodus uit",
"Admin mode on" => "Beheermodus aan",
"Task help" => "Taakhulp",
"Received task" => "Ontvangen taak",
"You received this task, please read and execute it" => "U heeft deze taak ontvangen, gelieve aandachtig te lezen en de taak op te lossen",
"Send task" => "Verzend taak",
"You send this task to a other user" => "U heeft deze taak naar een andere gebruiker verzonden",
"Shared task" => "Gedeelde taak",
"This task is public to a special group" => "Deze taak is publiek voor eens speciale groep",
"accepted by task user and creator" => "aanvaardt door de taakgebruiker en auteur",
"accepted user and creator" => "aanvaardt door de gebruiker en auteur",
"Task is accepted by user and creator" => "Taak is aanvaardt door de gebruiker en auteur",
"not accepted by one user" => "niet aanvaardt door 1 gebruiker",
"not accepted user" => "niet-aanvaarde gebruiker",
"Task is rejected by one user" => "Taak werd niet aanvaard door 1 gebruiker",
"waiting for me" => "wachtend voor mij",
"Task is not accepted by you, read the task and accept or reject it" => "Taak werd niet door u geaccepteerd, lees aub de taak en accepteer of verwerp dan de taak",
"waiting for other user" => "wachtend op een andere gebruikers",
"Task is not accepted/rejected by other user" => "Taak werd niet aanvaard/verworpen door een andere gebruiker",
"admin mode" => "beheermodus",
"trash" => "prullendmand",
"empty trash" => "maak prullendmand leeg",
"Edit task" => "Werk taak bij",
"red" => "rood",
"NOT accept" => "NIET aanvaardt",
"remove from trash" => "verwijder uit prullenmand",
"move into trash" => "verplaats naar prullenmand",
"Task saved" => "Taak opgeslagen",
"Edit Task" => "Bewerk Taak",
"View Task" => "Bekijk Taak",
"Open a new task" => "Open een nieuwe taak",
"taskId" => "taakId",
"Task user" => "Taakgebruikers",
"Only the creator can delete this task" => "Enkel de auteur kan deze taak verwijderen",
"use start date and time" => "gebruik startdatum en -tijd",
"use end date and time" => "gebruik einddatum en -tijd",
"open / in process" => "open / in uitvoering",
"waiting / not started" => "in wachtrij / niet gestart",
"Percentage completed" => "Percentage afgerond",
"waiting" => "in wachtrij",
"shared for group" => "gedeeld voor groep",
"accepted by user" => "aanvaardt door gebruiker",
"no / rejected" => "neen / verworpen",
"accepted by creator" => "aanvaardt door auteur",
"This message will be send to users if you are makeing changes of assigned tasks" => "Dit bericht zal worden verstuurd naar de gebruikers indien u veranderingen aan de toegewezen taken aanbrengt",
"Send message with changes" => "Stuur bericht met veranderingen",
"Modified by" => "Bijgewerkt door",
"Marked as deleted" => "Gemarkeerd als verwijderd",
"Inform task user by email" => "Informeer taakgebruiker via e-mail",
"You can only view this task" => "U kan deze taak enkel bekijken",
"priority" => "prioriteit",
"No tasks entered" => "Geen taken ingevoerd",
"select one" => "selecteer 1",
"undo trash" => "haal terug uit prullenmand",
"show:" => "toon:",
"received" => "ontvangen",
"submitted" => "ingeleverd",
"shared" => "gedeeld",
"all shared tasks" => "alle gedeelde taken",
"completed (100%)" => "voltooid (100%)",
"Public for group" => "Publiek voor groep",
"User Watches tpl" => "Gebruikers waak sjabloon",
"Add Watch" => "Voeg waak toe",
"A user submits a blog post" => "Een gebruiker levert een journaalbericht aan",
"A user posts a forum thread" => "Een gebruiker levert een forumonderwerp aan",
"A user posts a forum topic" => "Een gebruiker levert een forumbericht aan",
"A user edited a wiki page" => "Een gebruiker werkt een wiki pagina bij",
"edit user files" => "bewerk gebruikerbestanden",
"May need to refresh twice to see changes" => "Moet mogelijks tweemaal ververst worden om de veranderingen te zien",
"Add top level bookmarks to menu" => "Voeg hoofdniveau favorieten toe aan het menu",
"replace window" => "Vervangen venster",
"User_versions_for" => "Gebruiker_versies_voor",
"Insert Row" => "Voeg Rijd in",
"Insert Column" => "Voeg Kolom in",
"Remove Row" => "Verwijder Rij",
"Remove Column" => "Verwijder Kolom",
"Merge Cells" => "Smelt Cellen samen",
"Restore Cells" => "Herstel Cellen",
"Copy Calculation" => "Kopieer Berekening",
"Format Cell" => "Formatteer Cel",
"Before" => "Voor",
"After" => "Na",
"expires:" => "verloopt:",
"no comments" => "geen commentaar",
"Banner stats" => "Advertentie stats",
"Create new banner" => "Nieuwe advertentie aanmaken",
"Banner Information" => "Advertentie Informatie",
"Click ratio" => "Klikfrequentie",
"Weekdays" => "Weekdagen",
"mon" => "ma",
"tue" => "di",
"wed" => "wo",
"thu" => "do",
"fri" => "vr",
"sat" => "za",
"sun" => "zo",
"Banner raw data" => "Advertentie ruwe gegevens",
"Cached" => "In buffer gebracht",
"This is a cached version of the page." => "Deze paginaversie komt uit de buffer.",
"Click here to view the Google cache of the page instead." => "klik hier om de Google buffer van deze pagina te zien.",
"viewed" => "bekeken",
"edit items" => "werk items bij",
"list charts" => "opsommen rangschikkingen",
"last chart" => "laatste rangschikking",
"previous chart" => "vorige rangschikking",
"Chart created" => "Rangschikking aangemaakt",
"next chart" => "volgende rangschikking",
"permanency" => "permanentie",
"chg" => "wijz",
"avg" => "gem",
"info/vote" => "info/stem",
"Next chart will be generated on" => "Volgende rangschikking wordt aangemaakt op",
"View or vote items not listed in the chart" => "Bekijk of stem op items die in de rangschikking opgesomd staan",
"Select something to vote on" => "Selecteer iets om op te stemmen",
"Item information" => "Item informatie",
"Chart" => "Rangschikking",
"Permanency" => "Permanentie",
"Dif" => "Versch",
"Best Position" => "Beste Positie",
"Vote this item" => "Stem voor dit item",
"Highest" => "Hoogste",
"view faq" => "bekijk faq",
"view faq tpl" => "bekijk faq sjabloon",
"admin menus tpl" => "menus beheren sjabloon",
"Answers" => "Antwoorden",
"Q" => "V",
"add suggestion" => "voeg suggestie toe",
"1 suggestion" => "1 suggestie",
"suggestions" => "suggesties",
"Forum List" => "Forumlijst",
"Edit Forum" => "Forum bewerken",
"monitor this forum" => "monitor dit forum",
"stop monitoring this forum" => "stop monitoring van dit forum",
"You have {\$unread} unread private messages" => "U heeft {\$unread} ongelezen priv&eacute; berichten",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Uw bericht werd in de wachtrij geplaatst. Het bericht zal worden geplaatst\nna goedkeuring door een moderator.",
"You have to enter a title and text" => "U moet een titel en tekst invoeren",
"post new comment" => "nieuwe opmerking toevoegen",
"Summary" => "Samenvatting",
"HTML tags are not allowed inside comments" => "HTML-labels zijn niet toegestaan in opmerkingen",
"moderator actions" => "moderator acties",
"move selected topics" => "verplaats geselecteerde onderwerpen",
"unlock selected topics" => "ontgrendel geselecteerde onderwerpen",
"lock selected topics" => "vergrendel geselecteerde onderwerpen",
"delete selected topics" => "verwijder geselecteerde onderwerpen",
"merge" => "voeg samen",
"merge selected topics" => "voeg geselecteerde onderwerpen samen",
"reported messages:" => "gemelde berichten:",
"queued messages:" => "berichten in de wachtrij geplaatst:",
"Merge into topic" => "Voeg samen in het onderwerp",
"No topics yet" => "Nog geen onderwerpen",
"topics in this forum" => "onderwerpen in dit forum",
"Show posts" => "Toon bijdragen",
"Last hour" => "Laatste uur",
"Last 24 hours" => "Laatste 24 uren",
"Last 48 hours" => "Laatste 48 uren",
"Jump to forum" => "Spring naar forum",
" unread private messages" => " ongelezen private berichten",
"prev topic" => "vorig onderwerp",
"next topic" => "volgend onderwerp",
"posts:" => "berichten:",
"monitor this topic" => "monitor dit onderwerp",
"stop monitoring this topic" => "stop monitoring van dit onderwerp",
"Comments below your current threshold" => "Opmerkingen onder uw huidige drempelwaarde",
"Select" => "Selecteer",
"Show All" => "Toons Alles",
"Edit fields" => "Bewerk velden",
"Insert new item" => "Nieuwe items toevoegen",
"list attachments" => "Bijlagenlijst",
"View inserted item" => "Bekijke ingevoerd item",
"View item" => "Item bekijken",
"Add a comment" => "Een opmerking toevoegen",
"Attach a file to this item" => "Bestand als bijlage bij dit item voegen",
"more info" => "meer informatie",
"No attachments for this item" => "Geen bijlagen voor dit item",
"Special Operations" => "Speciale Handelingen",
"Webmail Doc template" => "Webmail Doc sjabloon",
"settings" => "instellingen",
"mailbox" => "postbus",
"compose" => "schrijven",
"contacts" => "contacten",
"Contacts" => "Contacten",
"Edit mail account" => "Bewerk e-mail account",
"Add new mail account" => "Nieuw e-mail account toevoegen",
"User accounts" => "Gebruikeraccounts",
"pop" => "POP",
"View All" => "Alle Bekijken",
"Msg" => "Berichten",
"back to mailbox" => "terug naar postbus",
"full headers" => "volledige hoofdingen",
"normal headers" => "normale hoofdingen",
"reply all" => "alle beantwoorden",
"forward" => "doorsturen",
"Create/edit contacts" => "Contacten maken/bewerken",
"First Name" => "Voornaam",
"Last Name" => "Achternaam",
"select from address book" => "uit adresboek selecteren",
"Use HTML mail" => "HTML-mail gebruiken",
"The following addresses are not in your address book" => "De volgende adressen bevinden zich niet in uw adresboek",
"add contacts" => "contacten toevoegen",
"Attachment 1" => "Bijlage 1",
"Attachment 2" => "Bijlage 2",
"Attachment 3" => "Bijlage 3",
"Address book" => "Adresboek",
"%s enabled" => "%s aangeschakeld",
"%s disabled" => "%s uitgeschakeld",
"Enable/disable Tiki features here, but configure them elsewhere" => "Schakel Tiki kenmerken hier in/uit, maar configureer deze elders",
"General preferences and settings" => "Algemene instellingen",
"User registration, login and authentication" => "Gebruikersregistratie, -aanmelding en -authenticatie",
"Wiki settings" => "Wiki-instellingen",
"Wiki Attachments" => "Wiki Bijlagen",
"Article/CMS settings" => "Artikel/CMS instellingen",
"Poll comments settings" => "Instellingen voor opmerkingen bij opiniepeilingen",
"Configuration options for all blogs on your site" => "Configuratie opties voor alle journaals van uw site",
"Forums settings" => "Foruminstellingen",
"FAQ comments settings" => "Instellingen FAQ commentaar",
"Trackers settings" => "Instellingen Trackers",
"RSS settings" => "Instellingen RSS-invoerstromen",
"Directory settings" => "Instellingen Directory",
"Maps configuration" => "Kaarten configuratie",
"Meta Tags settings" => "Instellingen Meta Tags",
"Search settings" => "Zoek-instellingen",
"Score settings" => "Score instellingen",
"Projects" => "Projecten",
"Projects configuration" => "Projecten configuratie",
"Community settings" => "Gemeenschap instellingen",
"Site Identity features" => "Kenmerken Site Identiteit",
"Calendar settings" => "Kalender instellingen",
"Help on \$admintitle Config" => "Hulp voor \$admintitle Config",
"Click here to delete this category" => "Klik hier om deze categorie te verwijderen",
"Category can`t be parent of itself" => "Categorie kan geen ouder zijn van zichzelf",
"No chart indicated" => "Geen rangschikking opgegeven",
"Upload failed" => "Aanlevering mislukt",
"You have to provide a hotword and a URL" => "U moet een hotword en een URL aanleveren",
"No page indicated" => "Geen pagina opgegeven",
"Detected, Version:" => "Gevonden, Versie:",
"Not detected." => "Niet vastgesteld.",
"The passwords don't match" => "De wachtwoorden komen niet overeen",
"Password should be at least" => "Wachtwoord moet ten minste",
"characters long" => "aantal karakters lang zijn",
"Your admin password has been changed" => "Uw beheerder wachtwoord is gewijzigd",
"DATE-of" => "van",
"All Fields except gdaltindex must be filled" => "Alle velden behalve gdaltindex moeten worden ingevuld",
"No valid gdaltindex executable" => "Geen geldig gdaltindex programma",
"Tag already exists" => "Label bestaat reeds",
"Tag not found" => "Label niet gevonden",
"Repository name can't be an empty" => "Naam Bewaarplaats kan niet leeg zijn",
"Requested action is not supported on repository" => "De gevraagde actie is niet geldig voor de bewaarplaats",
"No repository" => "Geen bewaarplaats",
"Search is mandatory field" => "Zoek is een verplicht veld",
"File not found " => "Bestand niet gevonden ",
"Requested action in not supported on repository" => "Gevraagde actie wordt niet ondersteund foor bewaarplaats",
"Non-existent link" => "Niet-bestaande koppeling",
"Mail-in account %s incorrect" => "Mail-in account %s niet correct",
"Mail-in account %s saved" => "Mail-in account %s opgeslagen",
"Frequency should be a positive integer!" => "Frekwentie moet een positief geheel getal zijn!",
"Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts worden elke %s minuten gecontroleerd",
"Automatic Mail-in accounts checking disabled" => "Automatische Mail-in accounts controle uitgeschakeld",
"No menu indicated" => "Geen menu opgegeven",
"No newsletter indicated" => "Geen nieuwsbrief opgegeven",
"No poll indicated" => "Geen opiniepeiling opgegeven",
"unsafe" => "onveildig",
"register_globals should be off by default. See the php manual for details." => "register_globals zou standaard uit moeten staan. Zie de php-handleiding voor meer details.",
"safe" => "veilig",
"session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid zou standaard uit moeten staan. Zie de php-handleiding voor meer details.",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir ligth waarschijnlijk binnen uw Tikiwiki folder. Er bestaat de kans dat iemand een bestand naar deze folder kan aanleveren en via een web browser het bestand kan bekijken",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "kan niet controleren of upload_tmp_dir bereikbaar is via uw web browser. Om zeker te zijn dient u uw web server configuratie na te kijken.",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "de xbithack optie aanschakelen is niet veilig. Afhankelijk van uw web server en tiki instellingen zou het kunnen dat een aanvaller bestanden naar een bestandgalerij kan aanleveren en deze kan uitvoeren",
"The Path to store files in the filegallery should be outside the tiki root directory" => "Het pad om bestanden in de bestandgalerij in op te slaan zou buiten de tiki root folder moeten liggen",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "Het pad om bestanden in de afbeeldinggalerij in op te slaan zou buiten de tiki root folder moeten liggen",
"File is not readable. Unable to check." => "Bestand is niet leesbaar. Kan niet controleren.",
"This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "Dit is geen Tikiwiki-bestand. Controleer of dit bestand buiten uw weten werd aangeleverd en/of het gevaarlijk is.",
"This is a modified File. Cannot check version. Check if it is dangerous." => "Dit bestand werd aangepast. Kan de versie niet bepalen. Controleer of het bestand gevaarlijk is.",
"This file is from another Tikiwiki version: " => "Dit bestand is van een andere Tikiwiki versie: ",
" or " => " of ",
"You have to provide a word" => "U hoeft geen woord in te vullen",
"You must specify a page name, it will be created if it doesn't exist." => "U dient een paginanaam te vermelden, indien deze nog niet bestaat zal ze aangemaakt worden",
"page not added (Exists)" => "pagina niet toegevoegd (bestaat reeds)",
"No survey indicated" => "Geen opinieonderzoek opgegeven",
"You don't have permission to use this feature" => "U heeft geen toestemming om dit onderdeel te gebruiken",
"No Errors detected" => "Geen Fouten gevonden",
"No tracker indicated" => "Geen tracker opgegeven",
"Group already exists" => "Groep bestaat reeds",
"No records were found. Check the file please!" => "Geen records gevonden. Controleer het bestand aub!",
"User login is required" => "Gebruikernaam is verplicht",
"Password is required" => "Wachtwoord is verplicht",
"Email is required" => "E-mail is verplicht",
"User is duplicated" => "Gebruiker is gekopieerd",
"Created account %s <%s>" => "Account %s <%s> aangemaakt",
"Assigned %s in group %s" => "%s toegewezen aan group %s",
"User %s already exists" => "Gebruiker %s bestaat reeds",
"New %s created with %s %s." => "Nieuwe %s aangemaakt met %s %s.",
"Impossible to create new %s with %s %s." => "Niet mogelijk om nieuwe %s met %s %s aan te maken.",
"%s %s successfully deleted." => "%s %s succesvol verwijderd.",
"%s %s removed from %s %s." => "%s %s verwijderd van %s %s.",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> verwijderd met succes.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> toegewezen aan %s <b>%s</b>.",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> verwijderd van %s <b>%s</b>.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "groep <b>%s</b> als standaard groep gezet voor gebruiker <b>%s</b>.",
"User already exists" => "Gebruiker bestaat reeds",
"The passwords dont match" => "De wachtwoorden komen niet overeen",
"Password must contain both letters and numbers" => "Wachtwoord moet zowel letters als cijfers bevatten",
"%s modified successfully." => "%s succesvol gewijzigd.",
"%s modification failed." => "%s wijziging gefaald.",
"%s changed from %s to %s" => "%s gewijzigd van %s naar %s",
"Impossible to change %s from %s to %s" => "Niet mogelijk om %s te wijzigen van %s naar %s",
"rss feed disabled" => "rss invoer uitgeschakeld",
"Permission denied you cannot view this section" => "Geen toestemming om deze sectie te bekijken",
"Tiki RSS feed for articles" => "Tiki RSS-invoer voor artikelen",
"Last articles." => "Laatste artikelen.",
"Unknown group" => "Onbekende groep",
"Group doesnt exist" => "Groep bestaat niet",
"Unknown user" => "Onbekende gebruiker",
"User doesnt exist" => "Gebruiker bestaat niet",
"You have to indicate a group" => "U moet een groep aanduiden",
"This group is invalid" => "Deze groep is ongeldig",
"Permission denied you cannot view backlinks for this page" => "Geen toestemming om terugkoppelingen te bekijken voor deze pagina",
"The page cannot be found" => "De pagina kan niet gevonden worden",
"Image Galleries Admin Panel" => "Afbeeldinggalerijen Admin Panel",
"Could not read image %s." => "Kan afbeelding %s niet lezen.",
"Image %s upload failed." => "Aanlevering van afbeelding %s mislukt.",
"Image %s uploaded successfully." => "Afbeelding %s met success aangeleverd.",
"Image %s removed from Batch directory." => "Afbeelding %s verwijderd uit Batch folder.",
"Impossible to remove image %s from Batch directory." => "Onmogelijk om afbeelding %s te verwijderen uit Batch folder.",
"Permission denied you cannot use the batch directory loading" => "Toegang geweigerd, u kan de batch folder aanlevering functie niet gebruiken",
"Incorrect directory chosen for batch upload of images." => "Incorrectie folder voor batch aanlevering van afbeeldingen gekozen.",
"Please setup that dir on " => "Gelieve deze folder te configureren op ",
"Please contact the website administrator." => "Gelieve de site beheerder te contacteren.",
"Invalid directory name" => "Ongeldige foldernaam",
"Permission denied you cannot post" => "Geen toestemming om bijdragen toe te voegen",
"Permission denied you cannot edit this post" => "Geen toestemming om deze bijdrage te bewerken",
"You can't post in any blog maybe you have to create a blog first" => "U kan aan geen enkel journaal bijdragen leveren, misschien moet u eerst een journaal aanmaken",
"Top visited blogs" => "Meest bezochte journalen",
"Last posts" => "Laatste bijdragenn",
"Top active blogs" => "Meest actieve journalen",
"No blogId specified" => "Geen journaalId opgegeven",
"Tiki RSS feed for blog: " => "Tiki RSS-invoer voor journaal: ",
"Tiki RSS feed for weblogs" => "Tiki RSS-invoer voor journalen",
"Last posts to weblogs." => "Laatste bijdrage tot  journalen.",
"Permission denied you cannot access this gallery" => "Geen toestemming om deze galerij te bekijken",
"No gallery indicated" => "Geen galerij aangegeven",
"Please login" => "Meldt u aan aub",
"Permission denied you cannot view this page" => "Geen toestemming om deze pagina te bekijken.",
"Permission denied you can not view this section" => "Geen permissie om deze sectie te bekijken",
"Permission denied you cannot remove images from this gallery" => "Geen toestemming om afbeeldingen te verwijderen uit deze galerij",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Geen permissie om de voorbeeldplaatjes in deze galerij te hercre&euml;n",
"Permission denied you cannot rotate images in this gallery" => "Geen permissien om afbeeldigen in deze galerij te verdraaien",
"No image indicated" => "Geen afbeelding opgegeven",
"Permission denied you cannot move images from this gallery" => "Geen toestemming om afbeeldingen uit deze galerij te verplaatsen",
"Permission denied you cannot view the calendar" => "Toegang tot de kalender geweigerd",
"event without name" => "gebeurtenis zonder naam",
"First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "Eerste day van de week: Zondag (haar ID is 0)!",
"Access Denied" => "Toegang geweigerd",
"No category indicated" => "Geen categorie aangegeven",
"Permission denied; you cannot assign permissions for this category" => "Toestemming geweigerd; u kan geen permissies toekennen voor deze categorie",
"The passwords didn't match" => "De wachtwoorden komen niet overeen",
"You can not use the same password again" => "U kan hetzelfde wachtwoord niet opnieuw gebruiken",
"Invalid old password" => "Ongeldig oud wachtwoord",
"Permission denied to use this feature" => "Geen toestemming om dit onderdeel te gebruiken",
"No channel indicated" => "Geen kanaal opgegeven",
"No nickname indicated" => "Geen bijnaam opgegeven",
"Top authors" => "Top auteurs",
"ERROR: you must include a subject or a message at least" => "FOUT: u moet op zijn minst een onderwerp of bericht insluiten",
"Message sent to" => "Bericht verzonden naar",
"You need to change chmod 'whelp' manually to 777" => "U moet handmatig een chmod 'whelp' 777 doen",
"This feature has been disabled" => "Dit onderdeel is niet actief",
"Tiki RSS feed for directory sites" => "Tiki RSS-invoer voor koppelingenlijst sites",
"Last sites." => "Laatste sites.",
"Must enter a name to add a site. " => "Geef een naam op om een site toe te voegen. ",
"Must enter a url to add a site. " => "Geef een URL op om een site toe te voegen. ",
"URL already added to the directory. Duplicate site? " => "URL bestaat reeds in de koppelingenlijst. Gaat het om een duplicaat? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "Kan URL niet benaderen: ofwel gaat het om een verkeerde URL ofwel is de site off-line and kan deze niet aan de koppelingenlijst worden toegevoegd. ",
"Must select a category. " => "Geef een categorie op. ",
"Must enter a name to add a site" => "U moet een naam invoeren om een site toe te voegen",
"Must enter a url to add a site" => "U moet een URL invoeren om eeen site toe te voegen",
"URL already added to the directory. Duplicate site?" => "URL reeds in koppelingenlijst aanwezig. Identieke site?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "Kan URL niet benaderen: ofwel gaat het om een verkeerde URL ofwel is de site off-line and kan deze niet aan de koppelingenlijst worden toegevoegd. ",
"Must select a category" => "U moet een categorie selecteren",
"No site indicated" => "Geen site opgegeven",
"No parent specified" => "Geen ouder opgegeven",
"Last sites of directory \".\$rc[\"name\"].\" ." => "Laatste sites van koppelingenlijst \".\$rc[\"name\"].\" .",
"You can not download files" => "U kan geen bestanden afhalen",
"Permission denied you cannot edit this article" => "Geen toestemming om deze pagina te bewerken",
"The language can't be changed as its set of translations has already this language" => "De taal kan niet worden aangepast omdat er reeds bestaande vertalingen aanwezig zijn voor deze taal",
"You do not have permissions to edit banners" => "U heeft geen toestemming om advertenties te bewerken",
"Banner not found" => "Advertentie niet gevonden",
"You do not have permission to edit this banner" => "U heeft geen toestemming om deze advertentie te bewerken",
"Permission denied you cannot create or edit blogs" => "Geen toestemming om journalen aan te maken of te bewerken",
"Permission denied you cannot edit this blog" => "Geen toestemming om dit journaal te bewerken",
"You do not have permission to write the style sheet" => "U heeft geen permissie om naar de style sheet te schrijven",
"Invalid request to edit an image" => "Ongeldig verzoek om een afbeelding te bewerken",
"Permission denied you cannot edit images" => "Geen toestemming om afbeeldingen te bewerken",
"Permission denied you can edit images but not in this gallery" => "Geen toestemming, u kan afbeeldingen bewerken maar niet in deze galerij",
"Failed to edit the image" => "Afbeelding kon niet bewerkt worden",
"Shortname must be 2 Characters" => "Korte naam moet 2 karakters zijn",
"You must provide a longname" => "U moet een lange naam invoeren",
"Language created" => "Taal aangemaakt",
"No content id indicated" => "Geen inhoud-id opgegeven",
"No question indicated" => "Geen vraag opgegeven",
"No quiz indicated" => "Geen quiz opgegeven",
"No structure indicated" => "Geen struktuur opgegeven",
"Invalid structure_id or page_ref_id" => "Ongeldig struktuur_id of pagina_ref_id",
"Permission denied you cannot send submissions" => "Geen toestemming om bijdragen te verzenden",
"Permission denied you cannot edit submissions" => "Geen toestemming om bijdragen te bewerken",
"You have to create a topic first" => "U moet eerst een onderwerp aanmaken",
"You do not have permission to do that" => "U heeft geen permissie om dat te doen",
"You do not have permission to read the template" => "U heeft geen toestemming om de sjabloon te lezen",
"No topic id specified" => "Geen onderwerp id opgegeven",
"Invalid topic id specified" => "Ongeldig onderwerp id opgegeven",
"No object indicated" => "Geen object aangegeven",
"No type indicated" => "Geen type aangegeven",
"Article not found" => "Artikel niet gevonden",
"Permission denied you cannot edit this page" => "Geen toestemming om deze pagina te bewerken",
"page imported" => "pagina geimporteerd",
"created from import" => "aangemaakt via import",
"You have mistyped the anti-bot verification code; please try again." => "U heeft de anti-bot verificatie code verkeerd ingevoerd; probeer aub opnieuw.",
"Can't import remote HTML page" => "Kan verre HTML pagina niet importeren",
"Can't parse remote HTML page" => "Kan verre HTML pagina niet lezen",
"You cannot edit this page because it is a user personal page" => "U kan deze pagina niet bewerken omdat het een persoonlijke gebruikerpagina is",
"The SandBox is disabled" => "De zandbak is niet actief",
"Cannot edit page because it is locked" => "Pagina is vergrendeld en kan niet bewerkt worden",
"unknown error" => "onbekende fout",
"cannot be found" => "kan niet gevonden worden",
"No permission to view the page" => "Geen permissie om de pagina te bekijken",
"No questions group indicated" => "Geen vraaggroup aangeduidt",
"Permission denied you cannot create galleries and so you cant edit them" => "Geen toestemming om galerijen te maken of te bewerken",
"Permission denied you cannot edit this gallery" => "Geen toestemming om deze galerij te bewerken",
"Permission denied you cannot remove this gallery" => "Geen toestemming om deze galerij te verwijderen",
"Top visited file galleries" => "Meest bezochte bestandgalerijen",
"Most downloaded files" => "Meest afgehaalde bestanden",
"Last files" => "Laatste bestanden",
"Tiki RSS feed for file galleries" => "Tiki RSS-invoer voor bestandgalerijen",
"Last files uploaded to the file galleries." => "Laatste bestanden aangeleverd aan de bestandgalerijen.",
"No galleryId specified" => "Geen galerijId opgegeven",
"Tiki RSS feed for the file gallery: " => "Tiki RSS-invoer voor de bestandgalerij: ",
"No forum indicated" => "Geen forum opgegeven",
"Forum posts" => "Forumbijdragen",
"No forumId specified" => "Geen forumId opgegeven",
"Tiki RSS feed for forum: " => "Tiki RSS-invoer voor forum: ",
"Tiki RSS feed for forums" => "Tiki RSS-invoer voor forums",
"Last topics in forums." => "Laatste onderwerpen in forums.",
"Accepted friendship request from %s" => "Verzoek tot vriendschap aanvaardt van %s",
"Refused friendship request from %s" => "Verzoek tot vriendschap geweigerd van %s",
"Broke friendship with %s" => "Vriendschap met %s verbroken",
"I have broken our friendship!" => "Ik heb onze vriendschap verbroken!",
"You must be logged in to use this feature" => "U moet zich eerst aanmelden om dit onderdeel te kunnen gebruiken",
"Friendship request sent to %s" => "Vriendschapsaanvraag verzonden naar %s",
"You're already friend of %s" => "U bent reeds een vriend van %s",
"Invalid username" => "Ongeldige gebruikernaam",
"I have accepted your friendship request!" => "Ik heb uw verzoek tot vriendschap aanvaard!",
"I have refused your friendship request!" => "Ik heb uw verzoek tot vriendschap geweigerd!",
"No process indicated" => "Geen process opgegeven",
"Activity name already exists" => "Naam activiteit bestaat reeds",
"indicates if the process is active. Invalid processes cant be active" => "geeft aan of het proces actief is. Ongeldige processen kunnen niet actief zijn",
"No instance indicated" => "Geen incarnatie opgegeven",
"No activity indicated" => "Geen activiteit opgegeven",
"The process name already exists" => "De procesnaam bestaat reeds",
"Process already exists" => "Proces bestaat reeds",
"You cant execute this activity" => "U mag deze activiteit niet uitvoeren",
"You couldn't abort a instance" => "U was niet in staat om een incarnatie af te breken",
"You couldn't exception a instance" => "U was niet in staat om een incarnatie uit te zonderen",
"No user indicated" => "Geen gebruiker opgegeven",
"No title indicated" => "Geen titel aangegeven",
"No comment indicated" => "Geen commentaar aangegeven",
"No date indicated" => "Geen datum aangegeven",
"No item indicated" => "Geen item opgegeven",
"first uploaded image" => "eerste aangeleverde afbeelding",
"last uploaded image" => "laatst aangeleverde afbeelding",
"random image" => "willekeurige afbeelding",
"Permission denied you cannot make the map of this gallery" => "Toegang geweigerd, u kan geen kaart maken van deze gallerij",
"Top images" => "Top afbeeldingen",
"Last images" => "Laatste afbeeldingen",
"No valid renderer found. GD or PDFLib required." => "Geen geldig opmaakprogramme gevonden. GD of PDFLib zijn vereist.",
"You must select a renderer." => "U dient een opmaakprogramma te selecteren.",
"Invalid Series for current graphic." => "Ongeldige Reeksen voor huidige grafiek.",
"Tiki RSS feed for image galleries" => "Tiki RSS-invoer voor beeldgalerijen",
"Last images uploaded to the image galleries." => "Laatste afbeeldingen aangeleverd aan de beeldgalerijen.",
"Tiki RSS feed for the image gallery: " => "Tiki RSS-invoer voor de beeldgalerij: ",
"overwriting old page" => "overschrijft oude pagina",
"updated from structured text import" => "bijgewerkt via gestructureerde tekstimport",
"page created" => "pagina aangemaakt",
"created from structured text import" => "aangemaakt via gestructureerde tekstimport",
"No repository given" => "Geen bewaarplaats opgegeven",
"Permission denied you cannot view pages like this page" => "Geen toestemming om pagina's zoals deze te bekijken",
"Permission denied you cannot remove articles" => "Geen toestemming om artikelen te verwijderen",
"Permission denied you cannot remove banners" => "Geen toestemming om advertenties te verwijderen",
"Permission denied you cannot remove this blog" => "Geen toestemming om dit journaal te verwijderen",
"Non-existent gallery" => "Non-bestaande galerij",
"Permission denied you cannot remove files from this gallery" => "Geen toestemming om bestanden te verwijderen uit deze galerij",
"Permission denied you can't upload files so you can't edit them" => "Geen permissie om bestanden aan te leveren of te bewerken",
"Permission denied you cannot edit this file" => "Geen permissie om dit bestand te bewerken",
"The game file must have .swf or .dcr extension" => "Het spelbestand moet de extensie .swf of .dcr hebben",
"The thumbnail name must be" => "De naam van het voorbeeldplaatje moet zijn",
"Please supply both files" => "Lever beide bestanden aan aub",
"You cannot admin blogs" => "U kan geen journalen beheren",
"Permission denied you cannot remove submissions" => "Geen toestemming om bijdragen te verwijderen",
"Permission denied you cannot approve submissions" => "Geen toestemming om bijdragen goed te keuren",
"Permission denied you cannot view pages" => "Geen toestemming om pagina's te bekijken",
"Permission denied you cannot remove pages" => "Geen permissie om pagina's te verwijderen",
"You have to enable cookies to be able to login to this site" => "U moet cookies inschakelen om zich te kunnen aanmelden op deze site",
"Account validated successfully." => "Account met success gevalideerd.",
"Tiki mail-in auto-reply" => "Tiki mail-in auto-antwoord",
"Sorry, you can't use this feature." => "Sorry, u kan dit kenmerk niet gebruiken.",
"changed" => "gewijzigd",
"You do not have permissions to view the maps" => "U heeft geen permissie om de landkaarten te bekijken",
"Maps feature is not correctly setup : Maps path is missing." => "Landkaarten onderdeel is niet correct opgezet : Landkaarten pad ontbreekt.",
"Please create a directory named \$map_path to hold your map files." => "Aub maak een folder aan met naam \$map_path om uw landkaartbestaden in op te slaan.",
"mapfile name incorrect" => "landkaartbestandnaam is niet correct",
"This mapfile already exists" => "Dit landkaartbestand bestaat reeds",
"You do not have permission to write to the mapfile" => "U heeft geen permissie om naar het landkaartbestand te schrijven",
"You do not have permission to delete the mapfile" => "U heeft geen permissie om het landkaartbestand te verwijderen",
"I could not make a copy" => "Ik kon geen kopie maken",
"You do not have permission to read the mapfile" => "U heeft geen permissie om het landkaartbestand te lezen",
"You dont have permission to do that" => "U heeft geen permissie om dat te doen",
"Tiki RSS feed for maps" => "Tiki RSS-invoer voor landkaarten",
"List of maps available." => "Liijst van beschikbare landkaarten.",
"You do not have permissions to view the layers" => "U heeft geen permissie om de lagen te bekijken",
"Could not upload the file" => "Kan bestand niet aanleveren",
"You do not have permissions to delete a file" => "U heeft geen permissie om het bestand te verwijderen",
"File not found" => "Bestand niet gevonden",
"You do not have permissions to create a directory" => "U heeft geen permissie om een folder aan te maken",
"The Directory is not empty" => "De folder is niet leeg",
"You do not have permissions to delete a directory" => "U heeft geen permissie om een folder te verwijderen",
"You do not have permissions to create an index file" => "U heeft geen permissie om een indexbestand aan te maken",
"Invalid file name" => "Ongeldige bestandnaam",
"Invalid files to index" => "Ongeldige bestanden om te indexeren",
"I do not know where is gdaltindex. Set correctly the Map feature" => "Ik weet niet waar gdaltindex is. Stel het landkaarten onderdeel juist in",
"I could not create the index file" => "Ik heb geen indexbestand kunnen aanmaken",
"Must be logged to use this feature" => "U moet aangemeld zijn om dit onderdeel te kunnnen gebruiken",
"Welcome at Hawiki" => "Welkom op Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Deze Tikiwiki site kan via een hele rits mobiele toestellen benaderd worden, e.g. WAP telefoons, PDA's, i-mode toestellen en vele andere.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "U kan deze site via uw mobiel toestel benaderen door uw mobiele browser te richten naar de volgende URL op deze site:",
"About" => "Over",
"You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "U dient setup.sh uit te voeren :<br />./setup.sh \$APACHEUSER all<br />Meest voorkomende Apache gebruikers zijn www-data, apache of nobody",
"Your PHP installation does not have zlib enabled." => "Uw PHP installatie heeft zlib niet geactiveerd.",
"You must log in to use this feature" => "U moet zich aanmelden om dit onderdeel te gebruiken",
"You do not have permission to view other users data" => "U heeft geen toestemming om permissies van andere gebruikers te bekijken",
"You must be logged in to subscribe to newsletters" => "U moet aangemeld zijn om u op nieuwsbrieven te kunnen abonneren",
"No server indicated" => "Geen server opgegeven",
"Cannot connect to" => "Kan niet connecteren aan",
"Missing information to read news (server,port,username,password,group) required" => "Informatie ontbreekt om nieuws te kunnen lezen (server, poort, gebruikernaam, wachtwoord, groep)",
"Cannot get messages" => "Kan berichten niet ontvangen",
"No note indicated" => "Geen notitie opgegeven",
"merged note:" => "samengevoegde notitie:",
"File is too big" => "Bestand is te groot",
"created from notepad" => "aangemaakt door het kladblok",
"No name indicated for wiki page" => "Geen naam opgegeven voor wiki pagina",
"Page already exists" => "Pagina bestaat reeds",
"Permission denied you cannot assign permissions for this page" => "Geen toestemming om permissies toe te kennen aan deze pagina",
"Not enough information to display this page" => "Niet genoeg informatie om deze pagina te tonen",
"Permission denied you cannot browse this page history" => "Geen toestemming om in de geschiedenis van deze pagina te bladeren",
"No article indicated" => "Geen artikel opgegeven",
"Article is not published yet" => "Artikel is nog niet gepubliceerd",
"No post indicated" => "Geen bijdrage opgegeven",
"Blog not found" => "Journaal niet gevonden",
"No pages indicated" => "Geen pagina's opgegeven",
"Pageviews" => "Paginabezichtigingen",
"You don't have permission to edit quizzes." => "U heeft geen toestemming om quizzes bij te werken.",
"No result indicated" => "Geen resultaat opgegeven",
"Permision denied" => "Toestemming geweigerd",
"Registered" => "Geregistreerd",
"Wrong registration code" => "Verkeerde registratiecode",
"Username is too long" => "Gebruikernaam is te lang",
"Username cannot contain whitespace" => "Gebruikernaam kan geen spatie bevatten",
"Wrong passcode you need to know the passcode to register in this site" => "Verkeerde pascode, u heeft de pascode nodig om voor deze site te registreren",
"Invalid email address. You must enter a valid email address" => "Ongeldig e-mail adres. U moet een geldig e-mail adres invoeren",
"The registration mail can't be sent. Contact the administrator" => "De registration e-mail kan niet worden verstuurd. Gelieve de beheerder te contacteren",
"Unable to send mail. User has not configured email" => "Niet in staat om bericht te versturen. Gebruiker heeft email niet geconfigureerd",
"A password and your IP address reminder email has been sent " => "Een wachtwoord en IP adres herinnering werden verstuurd",
"to the registered email address for" => "naar het geregistreerde e-mail adres voor",
"Invalid or unknown username" => "Onjuiste on onbekende gebruikernaam",
"Permission denied you cannot remove versions from this page" => "Geen toestemming om versies van deze pagina te verwijderen",
"Permission denied you cannot rename this page" => "Toegang geweigerd, u kan deze pagina niet hernoemen",
"Cannot rename page because the new name begins with reserved prefix" => "Kan pagina niet hernoemen omdat de nieuwe naam met een verboden prefix start",
"Cannot rename page maybe new page already exists" => "Kan pagina niet hernoemen, nieuwe pagina bestaat misschien reeds",
"changed '%s' from '%s' to '%s'" => "wijzigde '%s' van '%s' naar '%s'",
"Non-existent version" => "Niet-bestaande versie",
"Permission denied you cannot rollback this page" => "Geen toestemming om deze pagina terug te plaatsen",
"Error Message" => "Fout Bericht",
"Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS-invoerstroom Foutbericht: \$errmsg",
"Post recommendation at" => "Voeg aanbeveling toe op",
"No newsletters available." => "Geen nieuwsbrieven beschikbaar.",
" successfully sent" => " met success verzonden",
" not sent" => " niet verzonden",
"You do not have permission to edit messages" => "U heeft geen toestemming om berichten te bewerken",
"This feature is for admins only" => "Dit onderdeel is enkel voor beheerders",
"Page must be defined inside a structure to use this feature" => "Pagina moet in een struktuur gedefinieerd zijn om dit onderdeel te kunnen gebruiken",
"You cannot take this quiz twice" => "U kan deze quiz geen twee keer uitvoeren",
"Quiz time limit exceeded quiz cannot be computed" => "Quiz tijdslimiet overschreden, quiz kan niet worden berekend",
"You cannot take this survey twice" => "U kan geen twee keer aan dit opinieonderzoek deelnemen",
"Please create a category first" => "Maak eerst een categorie aan aub",
"No trackerId specified" => "Geen trackerId opgegeven",
"Tiki RSS feed for individual trackers: " => "Tiki RSS-invoerstroom voor individuele trackers: ",
"Invalid filename (using filters for filenames)" => "Ongeldige bestandnaam (gebruikt filters voor bestandnaam)",
"No permission to upload zipped file packages" => "Geen permissie op zip bestanden aan te leveren",
"Cannot read file" => "Kan bestand niet lezen",
"File update was successful" => "Bestand met succes bijgewerkt",
"Permission denied you cannot upload files" => "Geen permissie op bestanden aan te leveren",
"Could not find the file requested" => "Kan gevraagd bestand niet vinden",
"Permission denied you can upload files but not to this file gallery" => "Toestemming geweigerd, u kan bestanden aanleveren maar niet naar deze galerij",
"Error processing zipped image package" => "Fout in de verwerking van de afbeeldingen in het zip bestand",
"No permission to upload zipped image packages" => "Geen permissie om zip verpakte afbeeldingen aan te leveren",
"The uploaded file ist not recognized as a image" => "Het aangeleverde bestand werd niet als afbeelding herkend",
"Permission denied you cannot upload images" => "Geen toestemming om afbeeldingen aan te leveren",
"Permission denied you can upload images but not to this gallery" => "Toestemming geweigerd, u kan afbeeldingen aanleveren maar niet naar deze galerij",
"Cannot get image from URL" => "Kan afbeelding niet ophalen van URL",
"That is not an image (or you have php < 4.0.5)" => "Dit is geen afbeelding (of u beschikt over php < 4.0.5)",
"cannot process upload" => "kan aanleveringsproces niet afhandelen",
"Usage" => "Gebruik",
"No url indicated" => "Geen URL opgegeven",
"You are not logged in and no user indicated" => "U bent niet aangemeld en er is geen gebruiker opgegeven",
"The user has chosen to make his information private" => "De gebruiker heeft ervoor gekozen om haar/zijn informatie priv&eacute; te houden",
"Invalid password.  Your current password is required to change administrative information" => "Ongeldige wachtwoord.  Uw huidig wachtwoord is vereist om administratieve informatie bij te werken",
"Email is set to %s" => "Email is gezet op %s",
"The passwords did not match" => "De wachtwoorden komen niet overeen",
"was moved into trash" => "werd in de prullenmand geplaatst",
"trashed by" => "naar de prullenmand verwezen door",
"Rights by creator" => "Auteursrechten",
"END" => "EINDE",
"Task accepted by creator" => "Taak geaccepteerd door auteur",
"Task accepted by task user" => "Taak geaccepteerd door taakgebruiker",
"Task NOT accepted by creator" => "Taak NIET geaccepteerd door auteur",
"Task NOT accepted by task user" => "Taak NIET geaccepteerd door taakgebruiker",
"Sorry this task does not exist or you have no rights to view this task" => "Sorry deze taak bestaat niet of u heeft geen toegang om deze taak te bekijken",
"Task entries:" => "Taakopgaves:",
"Changes:" => "Veranderingen:",
"Info message" => "Infobericht",
"NEW Task" => "NIEUWE Taak",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Sorry u heeft geen permissie om taken naar andere gebruikers te sturen, of de gebruiker heeft geen permissie om taken te ontvangen!",
"Changes on Task" => "Veranderingen aan Taak",
"You received a new task" => "U heeft een nieuwe taak ontvangen",
"The priority is" => "De prioriteit is",
"very low" => "zeer laag",
"low" => "laag",
"high" => "hoog",
"very high" => "zeer hoog",
"You've to start your work at least on" => "U moet uw taak beginnen ten minste voor",
"You've to finish your work on" => "U moet uw taak beeindigen ten laatste op",
"Login and click the link below" => "Gelieve u aan te melden en op onderstaande koppeling te klikken",
"Please read the task and work on it!" => "Gelieve de taak te lezen en aan de taak te werken!",
"Sorry, there was an error while trying to write data into the database" => "Sorry, er is een fout opgetreden tijdens het schrijven van de gegevens naar de databank",
"Cannot upload this file not enough quota" => "Kan dit bestand niet aanleveren, ontoereikend quota",
"Non-existent user" => "Niet-bestaande gebruiker",
"No banner indicated" => "Geen advertentie opgegeven",
"No blog indicated" => "Geen journaal opgegeven",
"Permission denied you cannot remove the post" => "Geen toestemming om de bijdrage te verwijderen",
"No cache information available" => "Geen bufferinformatie beschikbaar",
"No faq indicated" => "Geen FAQ opgegeven",
"You are not permitted to remove someone else\\'s post!" => "U heeft geen permissie om iemand anders bericht te verwijderen!",
"Wrong password. Cannot post comment" => "Verkeerd wachtwoord. Kan commentaar niet toevoegen",
"Please wait 2 minutes between posts" => "Gelieve 2 minuten te wachten tussen elke bijdrage",
"No thread indicated" => "Geen thread opgegeven",
"A SheetId is required." => "Een RekenbladId is vereist.",
"Your email address has been removed from the list of addresses monitoring this tracker" => "Uw e-mail adres is verwijderd van de lijst van adressen die een monitor op deze tracker actief hadden",
"Your email address has been added to the list of addresses monitoring this tracker" => "Uw e-mail adres is toegevoegd aan de lijst van adressen die een monitor op deze tracker actief hebben",
"Cancel monitoring" => "Annuleer monitoring",
"Your email address has been removed from the list of addresses monitoring this item" => "Uw e-mail adres is verwijderd van de lijst van adressen die een monitor op dit item actief hadden",
"Your email address has been added to the list of addresses monitoring this item" => "Uw e-mail adres is toegevoegd aan de lijst van adressen die een monitor op dit item actief hebben",
"That tracker don't use extras." => "Deze tracker gebruikt geen extras.",
"No subject" => "Geen onderwerp",
"Your email was sent" => "Uw e-mail is verzonden",
"Top pages" => "Top pagina's",
"Last pages" => "Laatste pagina's",
"Tiki RSS feed for the wiki pages" => "Tiki RSS-invoer voor de wiki pagina\\'s",
"Last modifications to the Wiki." => "Laatste wijzigingen aan het Wiki.",
"###end###"=>"###end###");
?>
