<?php // -*- coding:utf-8 -*-
// parameters:
// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated
// comments   : generate all comments (equal to close&module)
// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made
// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)
// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer
// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)
// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)
// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate langauage 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate langauage 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Jan" => "Ιαν",
"Feb" => "Φεβ",
"Mar" => "Μαρ",
"Apr" => "Απρ",
"Jun" => "Ιουν",
"Jul" => "Ιουλ",
"Aug" => "Αυγ",
"Sep" => "Σεπ",
"Oct" => "Οκτ",
"Dec" => "Δεκ",
"Content Templates" => "Πρότυπα Περιεχομένου",
"today" => "σήμερα",
"Change your email" => "Αλλαγή e-mail",
"change email" => "αλλαγή e-mail",
"Change your password" => "Αλλαγή password",
"change password" => "αλλαγή password",
"open tasks" => "ανοιχτές εργασίες",
"no description" => "δεν υπάρχει περιγραφή",
"FAQs settings" => "ρυθμίσεις FAQs",
"Like pages" => "Παρόμοιες σελίδες",
"Administration" => "Διαχείριση",
"Day" => "Ημέρα",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "This script cannot be called directly" => "This script cannot be called directly",
// "Re:" => "Re:",
// "Missing title or body when trying to post a comment" => "Missing title or body when trying to post a comment",
// "The copyright management feature is not enabled." => "The copyright management feature is not enabled.",
// "You do not have permission to use this feature." => "You do not have permission to use this feature.",
// "You must supply all the information, including title and year." => "You must supply all the information, including title and year.",
// "You do not have permission to use this feature" => "You do not have permission to use this feature",
// "The text in RED is" => "The text in RED is",
// "character(s) too long - please edit it." => "character(s) too long - please edit it.",
// "This feature is disabled" => "This feature is disabled",
// "Algeria" => "Algeria",
// "American_Samoa" => "American_Samoa",
// "Angola" => "Angola",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Bermuda" => "Bermuda",
// "Bolivia" => "Bolivia",
// "Brazil" => "Brazil",
// "Brunei" => "Brunei",
// "Canada" => "Canada",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman_Islands" => "Cayman_Islands",
// "Colombia" => "Colombia",
// "Cook_Islands" => "Cook_Islands",
// "Costa_Rica" => "Costa_Rica",
// "Croatia" => "Croatia",
// "Cuba" => "Cuba",
// "Cyprus" => "Cyprus",
// "Czech_Republic" => "Czech_Republic",
// "Denmark" => "Denmark",
// "Dominican_Republic" => "Dominican_Republic",
// "Ecuador" => "Ecuador",
// "Egypt" => "Egypt",
// "El_Salvador" => "El_Salvador",
// "Estonia" => "Estonia",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "France" => "France",
// "French_Polynesia" => "French_Polynesia",
// "Germany" => "Germany",
// "Greece" => "Greece",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Haiti" => "Haiti",
// "Honduras" => "Honduras",
// "Hungary" => "Hungary",
// "Chile" => "Chile",
// "China" => "China",
// "Iceland" => "Iceland",
// "India" => "India",
// "Indonesia" => "Indonesia",
// "Iran" => "Iran",
// "Iraq" => "Iraq",
// "Ireland" => "Ireland",
// "Israel" => "Israel",
// "Italy" => "Italy",
// "Ivory_Coast" => "Ivory_Coast",
// "Jamaica" => "Jamaica",
// "Japan" => "Japan",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Malta" => "Malta",
// "Marshall_Islands" => "Marshall_Islands",
// "Mauritius" => "Mauritius",
// "Mexico" => "Mexico",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands" => "Netherlands",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Nicaragua" => "Nicaragua",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "None" => "None",
// "Norway" => "Norway",
// "Other" => "Other",
// "Pakistan" => "Pakistan",
// "Panama" => "Panama",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Phillippines" => "Phillippines",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto_Rico" => "Puerto_Rico",
// "Quatar" => "Quatar",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Samoa" => "Samoa",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon_Islands" => "Solomon_Islands",
// "Somalia" => "Somalia",
// "South_Africa" => "South_Africa",
// "South_Korea" => "South_Korea",
// "Spain" => "Spain",
// "Sri_Lanka" => "Sri_Lanka",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Surinam" => "Surinam",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Taiwan" => "Taiwan",
// "Thailand" => "Thailand",
// "Tonga" => "Tonga",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Turkey" => "Turkey",
// "Tuvalu" => "Tuvalu",
// "Ukraine" => "Ukraine",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_States" => "United_States",
// "Uruguay" => "Uruguay",
// "Vanuatu" => "Vanuatu",
// "Venezuela" => "Venezuela",
// "Wales" => "Wales",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "Bulgaria" => "Bulgaria",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "Chinese" => "Chinese",
// "Czech" => "Czech",
// "Danish" => "Danish",
// "German" => "German",
// "English" => "English",
// "English British" => "English British",
// "Spanish" => "Spanish",
// "Greek" => "Greek",
// "Finnish" => "Finnish",
// "French" => "French",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Italian" => "Italian",
// "Japanese" => "Japanese",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Dutch" => "Dutch",
// "Norwegian" => "Norwegian",
// "Polish" => "Polish",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Russian" => "Russian",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Swedish" => "Swedish",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "Ukrainian" => "Ukrainian",
// "This instance of activity is already complete" => "This instance of activity is already complete",
// "Fatal error: cannot execute automatic activity \$activityId" => "Fatal error: cannot execute automatic activity \$activityId",
// "Fatal error: setting next activity to an unexisting activity" => "Fatal error: setting next activity to an unexisting activity",
// "Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatal error: nextActivity does not match any candidate in autorouting switch activity",
// "Fatal error: non-deterministic decision for autorouting activity" => "Fatal error: non-deterministic decision for autorouting activity",
// "Fatal error: trying to send an instance to an activity but no transition found" => "Fatal error: trying to send an instance to an activity but no transition found",
// "Cannot add transition only split activities can have more than one outbound transition" => "Cannot add transition only split activities can have more than one outbound transition",
// "Circular reference found some activity has a transition leading to itself" => "Circular reference found some activity has a transition leading to itself",
// "Process does not have a start activity" => "Process does not have a start activity",
// "Process does not have exactly one end activity" => "Process does not have exactly one end activity",
// "End activity is not reachable from start activity" => "End activity is not reachable from start activity",
// "Activity" => "Activity",
// " is interactive but has no role assigned" => " is interactive but has no role assigned",
// " is non-interactive and non-autorouted but has no role assigned" => " is non-interactive and non-autorouted but has no role assigned",
// " is standalone but has transitions" => " is standalone but has transitions",
// "Role" => "Role",
// " is not mapped" => " is not mapped",
// "Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Activity '.\$res['name'].' is standalone and is using the \$instance object",
// "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method",
// "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method",
// "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method",
// "Process %d has been activated" => "Process %d has been activated",
// "Process %d has been deactivated" => "Process %d has been deactivated",
// "Process %s %s imported" => "Process %s %s imported",
// "Process %s removed" => "Process %s removed",
// "Process %s has been updated" => "Process %s has been updated",
// "Process %s has been created" => "Process %s has been created",
// "refresh" => "refresh",
// "locked by" => "locked by",
// "Administration:" => "Administration:",
// "continued" => "continued",
// "in" => "in",
// "new image uploaded by" => "new image uploaded by",
// "uploaded by" => "uploaded by",
// "new item in tracker" => "new item in tracker",
// "new subscriptions" => "new subscriptions",
// "not specified" => "not specified",
// "The file is not a CSV file or has not a correct syntax" => "The file is not a CSV file or has not a correct syntax",
// "blog" => "blog",
// "directory" => "directory",
// "faq" => "faq",
// "file gallery" => "file gallery",
// "forum" => "forum",
// "image gallery" => "image gallery",
// "newsletter" => "newsletter",
// "poll" => "poll",
// "quiz" => "quiz",
// "survey" => "survey",
// "tracker" => "tracker",
// "wiki page" => "wiki page",
// "Cannot write to this file: " => "Cannot write to this file: ",
// "Cannot upload this file maximum upload size exceeded" => "Cannot upload this file maximum upload size exceeded",
// "Anonymous" => "Anonymous",
// "Use this thread to discuss the %s page." => "Use this thread to discuss the %s page.",
// "Line:" => "Line:",
// "Lines:" => "Lines:",
// "Newsletter subscription information at " => "Newsletter subscription information at ",
// "Cannot write to this file:" => "Cannot write to this file:",
// "There was a problem with your upload." => "There was a problem with your upload.",
// "The file you are trying to upload is too big." => "The file you are trying to upload is too big.",
// "The file you are trying to upload was only partially uploaded." => "The file you are trying to upload was only partially uploaded.",
// "You must select a file for upload." => "You must select a file for upload.",
// "Blogs" => "Blogs",
// "Blog" => "Blog",
// "posted on" => "posted on",
// "By:" => "By:",
// "Forums" => "Forums",
// "Invalid imagename (using filters for filenames)" => "Invalid imagename (using filters for filenames)",
// "Errors detected" => "Errors detected",
// "Upload was not successful" => "Upload was not successful",
// "No image yet, sorry." => "No image yet, sorry.",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "User Map Generated in:" => "User Map Generated in:",
// "Image Map Generated in:" => "Image Map Generated in:",
// "NONE" => "NONE",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "%s is an empty archive file" => "%s is an empty archive file",
// "Invalid remote file on url %s" => "Invalid remote file on url %s",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "This poll is closed." => "This poll is closed.",
// "Wiki top pages" => "Wiki top pages",
// "Hits" => "Hits",
// "Most relevant pages" => "Most relevant pages",
// "Relevance" => "Relevance",
// "Wiki last pages" => "Wiki last pages",
// "Forums last topics" => "Forums last topics",
// "Topic date" => "Topic date",
// "Forums last posts" => "Forums last posts",
// "Forums most read topics" => "Forums most read topics",
// "Forums best topics" => "Forums best topics",
// "Forums most visited forums" => "Forums most visited forums",
// "Forums with most posts" => "Forums with most posts",
// "Wiki top galleries" => "Wiki top galleries",
// "Wiki top file galleries" => "Wiki top file galleries",
// "Wiki top images" => "Wiki top images",
// "Wiki top files" => "Wiki top files",
// "Downloads" => "Downloads",
// "Wiki last images" => "Wiki last images",
// "Upload date" => "Upload date",
// "Wiki last files" => "Wiki last files",
// "Wiki top articles" => "Wiki top articles",
// "Most visited blogs" => "Most visited blogs",
// "Most active blogs" => "Most active blogs",
// "Blogs last posts" => "Blogs last posts",
// "Post date" => "Post date",
// "Wiki top authors" => "Wiki top authors",
// "Pages" => "Pages",
// "Top article authors" => "Top article authors",
// "tikiwiki logo" => "tikiwiki logo",
// "Login" => "Login",
// "See other user's profile" => "See other user's profile",
// "Have your profile seen" => "Have your profile seen",
// "Make friends" => "Make friends",
// "Receive message" => "Receive message",
// "Read an article" => "Read an article",
// "Publish an article" => "Publish an article",
// "Have your article read" => "Have your article read",
// "Create new file gallery" => "Create new file gallery",
// "Upload new file to gallery" => "Upload new file to gallery",
// "Download other user's file" => "Download other user's file",
// "Have your file downloaded" => "Have your file downloaded",
// "Create a new image gallery" => "Create a new image gallery",
// "Upload new image to gallery" => "Upload new image to gallery",
// "See other user's gallery" => "See other user's gallery",
// "See other user's image" => "See other user's image",
// "Have your gallery seen by other user" => "Have your gallery seen by other user",
// "Have your image seen" => "Have your image seen",
// "Create new blog" => "Create new blog",
// "Post in a blog" => "Post in a blog",
// "Read other user's blog" => "Read other user's blog",
// "Have your blog read" => "Have your blog read",
// "Create a new wiki page" => "Create a new wiki page",
// "Edit an existing page" => "Edit an existing page",
// "Attach file" => "Attach file",
// "Tracker" => "Tracker",
// "Unknown" => "Unknown",
// "Trackeritem" => "Trackeritem",
// "Wiki" => "Wiki",
// "Directory category" => "Directory category",
// "FAQ" => "FAQ",
// "Forum" => "Forum",
// "Blog post" => "Blog post",
// "Tracker item" => "Tracker item",
// "Link" => "Link",
// "help" => "help",
// "The text is" => "The text is",
// "Text cut here" => "Text cut here",
// "Task" => "Task",
// "for" => "for",
// "Start date:" => "Start date:",
// "End date:" => "End date:",
// "%A %d of %B, %Y" => "%A %d of %B, %Y",
// "%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d of %B, %Y[%H:%M:%S %Z]",
// "%H:%M:%S %Z" => "%H:%M:%S %Z",
// "%a %d of %b, %Y" => "%a %d of %b, %Y",
// "%a %d of %b, %Y[%H:%M %Z]" => "%a %d of %b, %Y[%H:%M %Z]",
// "%H:%M %Z" => "%H:%M %Z",
// "Friend" => "Friend",
// "km" => "km",
// "Last seen on " => "Last seen on ",
// "(idle for %s seconds)" => "(idle for %s seconds)",
// "User information - Click for more info" => "User information - Click for more info",
// "More info about \$other_user" => "More info about \$other_user",
// "(idle for \$idletime seconds)" => "(idle for \$idletime seconds)",
// "unlocked" => "unlocked",
// "created from structure" => "created from structure",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
// "An error occured in a database query!" => "An error occured in a database query!",
// "Help" => "Help",
// "You are banned from" => "You are banned from",
// "wiki" => "wiki",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "faqs" => "faqs",
// "quizzes" => "quizzes",
// "arts" => "arts",
// "blogs" => "blogs",
// "forums" => "forums",
// "drawing not found" => "drawing not found",
// "Click to edit dynamic variable" => "Click to edit dynamic variable",
// "Update variables" => "Update variables",
// "Altering database table failed" => "Altering database table failed",
// "%d points" => "%d points",
// "Removed" => "Removed",
// "__WARNING__: No such module \$plugin! " => "__WARNING__: No such module \$plugin! ",
// "Create page:" => "Create page:",
// "index" => "index",
// "show" => "show",
// "hide" => "hide",
// "Updated" => "Updated",
// "Unknown language" => "Unknown language",
// "Click here to confirm your action" => "Click here to confirm your action",
// "Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) detected. Operation blocked.",
// "Status:" => "Status:",
// "(unchanged)" => "(unchanged)",
// "Item Modification" => "Item Modification",
// "Item creation" => "Item creation",
// "Tracker was modified at " => "Tracker was modified at ",
// "field is not numeric" => "field is not numeric",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "textarea" => "textarea",
// "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode.",
// "checkbox" => "checkbox",
// "Checkbox options: put 1 if you need that next field is on the same row." => "Checkbox options: put 1 if you need that next field is on the same row.",
// "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "drop down" => "drop down",
// "Dropdown options: list of items separated with commas." => "Dropdown options: list of items separated with commas.",
// "user selector" => "user selector",
// "User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login.",
// "group selector" => "group selector",
// "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered.",
// "country selector" => "country selector",
// "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag",
// "jscalendar" => "jscalendar",
// "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels.",
// "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test",
// "header" => "header",
// "Category options: parentId" => "Category options: parentId",
// "item link" => "item link",
// "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing",
// "items list" => "items list",
// "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing",
// "email" => "email",
// "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto.",
// "system" => "system",
// "open" => "open",
// "pending" => "pending",
// "Added:" => "Added:",
// "Removed:" => "Removed:",
// "Remaining:" => "Remaining:",
// "Old:" => "Old:",
// "New:" => "New:",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "child categories" => "child categories",
// "objects in category" => "objects in category",
// "(AT)" => "(AT)",
// "(DOT)" => "(DOT)",
// "Include all post in a blog" => "Include all post in a blog",
// "Include a page" => "Include a page",
// "Lists files in a directory" => "Lists files in a directory",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Takes regex expressions and parses the content between the REGEX tags and replaces the text.",
// "one data per line" => "one data per line",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace.",
// "This data is put in a CODE caption." => "This data is put in a CODE caption.",
// "Missing url parameter for SNARF plugin." => "Missing url parameter for SNARF plugin.",
// "Displays browser client info" => "Displays browser client info",
// "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor",
// "linktext" => "linktext",
// "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor",
// "Include an article" => "Include an article",
// "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage",
// "no such attachment on this page" => "no such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link.",
// "Displays the user Avatar" => "Displays the user Avatar",
// "username" => "username",
// "List all pages which link to specific pages" => "List all pages which link to specific pages",
// "Page cannot be found" => "Page cannot be found",
// "No pages links to" => "No pages links to",
// "One page links to" => "One page links to",
// "pages link to" => "pages link to",
// "Insert theme styled box on wiki page" => "Insert theme styled box on wiki page",
// "Insert list of items for the current/given category into wiki page" => "Insert list of items for the current/given category into wiki page",
// "Categories are disabled" => "Categories are disabled",
// "Display Tiki objects that have not been categorized" => "Display Tiki objects that have not been categorized",
// "Insert the full category path for each category that this wiki page belongs to" => "Insert the full category path for each category that this wiki page belongs to",
// "Centers the plugin content in the wiki page" => "Centers the plugin content in the wiki page",
// "Displays a snippet of code" => "Displays a snippet of code",
// "code" => "code",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "Insert copyright notices" => "Insert copyright notices",
// "Example" => "Example",
// "Insert a division block on wiki page" => "Insert a division block on wiki page",
// "Creates a definition list" => "Creates a definition list",
// "term" => "term",
// "definition" => "definition",
// "one definition per line" => "one definition per line",
// "Displays the data using the Tikiwiki odd/even table style" => "Displays the data using the Tikiwiki odd/even table style",
// "heads and cells separated by ~|~" => "heads and cells separated by ~|~",
// "Displays a SWF on the wiki page" => "Displays a SWF on the wiki page",
// "Formula" => "Formula",
// "No formula specified." => "No formula specified.",
// "Impossible to render the graphic." => "Impossible to render the graphic.",
// "View graphic" => "View graphic",
// "Displays a graphical GAUGE" => "Displays a graphical GAUGE",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Displays the text only if the language matchs" => "Displays the text only if the language matchs",
// "Displays a map" => "Displays a map",
// "Feature disabled" => "Feature disabled",
// "Displays an miniquiz" => "Displays an miniquiz",
// "Please choose a module" => "Please choose a module",
// "to be used as argument" => "to be used as argument",
// "Displays a module inlined in page" => "Displays a module inlined in page",
// "Displays the data using a monospace font" => "Displays the data using a monospace font",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Provides a list of plugins on this wiki." => "Provides a list of plugins on this wiki.",
// "No version indicated" => "No version indicated",
// "No arguments indicated" => "No arguments indicated",
// "Displays the output of a poll, fields are indicated with numeric ids." => "Displays the output of a poll, fields are indicated with numeric ids.",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// " wrote:" => " wrote:",
// "Quote:" => "Quote:",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage",
// "Automatically creates a link to the appropriate SourceForge object" => "Automatically creates a link to the appropriate SourceForge object",
// "TikiSheet" => "TikiSheet",
// "Sheet Heading" => "Sheet Heading",
// "Edit Sheet" => "Edit Sheet",
// "List wiki pages" => "List wiki pages",
// "Last modified by" => "Last modified by",
// "Clickable Skype link" => "Clickable Skype link",
// "Sorts the plugin content in the wiki page" => "Sorts the plugin content in the wiki page",
// "Split a page into rows and columns" => "Split a page into rows and columns",
// "Missing db param" => "Missing db param",
// "Displays text in subscript." => "Displays text in subscript.",
// "Displays text between an html tag" => "Displays text between an html tag",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "Search the titles of all pages in this wiki" => "Search the titles of all pages in this wiki",
// "No pages found for title search" => "No pages found for title search",
// "One page found for title search" => "One page found for title search",
// " pages found for title search" => " pages found for title search",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "Save" => "Save",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "Fields marked with a * are mandatory." => "Fields marked with a * are mandatory.",
// "All fields must be from the same tracker" => "All fields must be from the same tracker",
// "Filters the items of a tracker, fields are indicated with numeric ids." => "Filters the items of a tracker, fields are indicated with numeric ids.",
// "missing parameters" => "missing parameters",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays the output of a tracker content, fields are indicated with numeric ids." => "Displays the output of a tracker content, fields are indicated with numeric ids.",
// "missing tracker ID for plugin TRACKER" => "missing tracker ID for plugin TRACKER",
// "missing fields list" => "missing fields list",
// "at" => "at",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Links to a translated content" => "Links to a translated content",
// "Displays the number of registered users" => "Displays the number of registered users",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored.<br />" => "A wildcard pattern of originating pages to be ignored.<br />",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated.<br />" => "The character, by which ignored patterns are separated.<br />",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list.<br />" => "Whether to include external wikis in the list.<br />",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Collect either originating or wanted pages in a cell and display them in the second column.<br />",
// "Switch-on debug output with details about the items.<br />" => "Switch-on debug output with details about the items.<br />",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />",
// "A custom filter for wanted pages to be listed (only used when level=>custom).<br />" => "A custom filter for wanted pages to be listed (only used when level=>custom).<br />",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "External Wiki" => "External Wiki",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "valid" => "valid",
// "End of debug output." => "End of debug output.",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Plugin " => "Plugin ",
// "failed" => "failed",
// "You are not logged in" => "You are not logged in",
// "Permission denied" => "Permission denied",
// "ERROR: Either the subject or body must be non-empty" => "ERROR: Either the subject or body must be non-empty",
// "ERROR: No valid users to send the message" => "ERROR: No valid users to send the message",
// "Invalid user" => "Invalid user",
// "Message will be sent to: " => "Message will be sent to: ",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Sent box is full. Archive or delete some sent messages first if you want to send more messages.",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first." => "Archive is full. Delete some messages from archive first.",
// "No more messages" => "No more messages",
// "move %s in %s" => "move %s in %s",
// "Please provide an Id" => "Please provide an Id",
// "no object here yet" => "no object here yet",
// "This module requires parameters trackerId and name set" => "This module requires parameters trackerId and name set",
// "new posts" => "new posts",
// "new FAQs" => "new FAQs",
// "new blogs" => "new blogs",
// "new blog posts" => "new blog posts",
// "new polls" => "new polls",
// "new tracker items" => "new tracker items",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Invalid server key" => "Invalid server key",
// "Invalid username or password" => "Invalid username or password",
// "desc" => "desc",
// "uploaded" => "uploaded",
// "debug" => "debug",
// "Fatal error" => "Fatal error",
// "Description:" => "Description:",
// " on " => " on ",
// "post" => "post",
// "RSS feed" => "RSS feed",
// "Edit blog" => "Edit blog",
// "monitor this blog" => "monitor this blog",
// "stop monitoring this blog" => "stop monitoring this blog",
// "Activity=" => "Activity=",
// "Categorize" => "Categorize",
// "Tip: hold down CTRL to select multiple categories" => "Tip: hold down CTRL to select multiple categories",
// "Tip: uncheck the above checkbox to uncategorize this page/object" => "Tip: uncheck the above checkbox to uncategorize this page/object",
// "browse category" => "browse category",
// "stars" => "stars",
// "user level" => "user level",
// "send email to user" => "send email to user",
// "user online" => "user online",
// "user offline" => "user offline",
// "on" => "on",
// "Vote" => "Vote",
// "attachment" => "attachment",
// "Moderator actions" => "Moderator actions",
// "delete selected" => "delete selected",
// "Move to topic:" => "Move to topic:",
// "reported:" => "reported:",
// "queued:" => "queued:",
// "Posted messages" => "Posted messages",
// "Style" => "Style",
// "Plain" => "Plain",
// "Threaded" => "Threaded",
// "Headers Only" => "Headers Only",
// "Newest first" => "Newest first",
// "Oldest first" => "Oldest first",
// "Threshold" => "Threshold",
// "set" => "set",
// "Top" => "Top",
// "Hide all" => "Hide all",
// "replies" => "replies",
// "below your current threshold" => "below your current threshold",
// "new reply" => "new reply",
// "Editing reply" => "Editing reply",
// "Reply to the selected post" => "Reply to the selected post",
// "Post new message" => "Post new message",
// "Editing comment" => "Editing comment",
// "Comment on the selected post" => "Comment on the selected post",
// "Reply to parent post" => "Reply to parent post",
// "Post new reply" => "Post new reply",
// "Required" => "Required",
// "Rating" => "Rating",
// "Smileys" => "Smileys",
// "Reply" => "Reply",
// "Posting replies" => "Posting replies",
// "Posting comments" => "Posting comments",
// "Use" => "Use",
// "or" => "or",
// "for links" => "for links",
// "HTML tags are not allowed inside posts" => "HTML tags are not allowed inside posts",
// "Copyrights" => "Copyrights",
// "Page generation debugging log" => "Page generation debugging log",
// "Features state" => "Features state",
// "Total" => "Total",
// "features matched" => "features matched",
// "Watchlist" => "Watchlist",
// "Perhaps you were looking for:" => "Perhaps you were looking for:",
// "There are no wiki pages similar to '{\$page}'" => "There are no wiki pages similar to '{\$page}'",
// "Create this page" => "Create this page",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Close Window" => "Close Window",
// "Last update from CVS" => "Last update from CVS",
// "RSS Wiki" => "RSS Wiki",
// "RSS Blogs" => "RSS Blogs",
// "RSS Articles" => "RSS Articles",
// "RSS Image Galleries" => "RSS Image Galleries",
// "RSS File Galleries" => "RSS File Galleries",
// "RSS Forums" => "RSS Forums",
// "RSS Maps" => "RSS Maps",
// "RSS Directories" => "RSS Directories",
// "RSS Calendars" => "RSS Calendars",
// "Information" => "Information",
// "Hi {\$mail_user} has sent you this link:" => "Hi {\$mail_user} has sent you this link:",
// "Blog post:" => "Blog post:",
// "at:" => "at:",
// "Somebody or you tried to subscribe this email address at our site:" => "Somebody or you tried to subscribe this email address at our site:",
// "To the newsletter:" => "To the newsletter:",
// "In order to confirm your subscription you must access the following URL:" => "In order to confirm your subscription you must access the following URL:",
// "A new message was posted to forum" => "A new message was posted to forum",
// "New topic:" => "New topic:",
// "Topic:" => "Topic:",
// "Message" => "Message",
// "You sent a request with the subject:" => "You sent a request with the subject:",
// "Use the subject to indicate the operation to apply:" => "Use the subject to indicate the operation to apply:",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in instructions" => "Tiki mail-in instructions",
// "Tiki mail-in auto-reply." => "Tiki mail-in auto-reply.",
// "Page not found:" => "Page not found:",
// "Hi," => "Hi,",
// "A new message was posted to you at {\$mail_machine}" => "A new message was posted to you at {\$mail_machine}",
// "New message arrived from %s" => "New message arrived from %s",
// "Hi" => "Hi",
// "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now.",
// "To login with your username and password, please follow this link:" => "To login with your username and password, please follow this link:",
// "Enjoy the site!" => "Enjoy the site!",
// "Tiki User Account Activated" => "Tiki User Account Activated",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link:" => "To validate that account, please follow the link:",
// "best regards" => "best regards",
// "your Tikiwiki" => "your Tikiwiki",
// "Tiki User Registration Request" => "Tiki User Registration Request",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "You're invited to join my network of friends!" => "You're invited to join my network of friends!",
// "The user" => "The user",
// "registered at your site" => "registered at your site",
// "New user registration" => "New user registration",
// "Bye bye!" => "Bye bye!",
// "This email address has been removed to the list of subscriptors of:" => "This email address has been removed to the list of subscriptors of:",
// "Newsletter:" => "Newsletter:",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "You can unsubscribe from this newsletter following this link" => "You can unsubscribe from this newsletter following this link",
// "Welcome to our newsletter!" => "Welcome to our newsletter!",
// "This email address has been added to the list of subscriptors of:" => "This email address has been added to the list of subscriptors of:",
// "You can always cancel your subscription using:" => "You can always cancel your subscription using:",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Tiki email notification" => "Tiki email notification",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in.",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above." => "Important: The old password remains active if you don't click the link above.",
// "Your Tiki account information for %s" => "Your Tiki account information for %s",
// "A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}",
// "You can edit the submission following this link:" => "You can edit the submission following this link:",
// "Heading:" => "Heading:",
// "Body:" => "Body:",
// "New article submitted at %s" => "New article submitted at %s",
// "View the tracker item at:" => "View the tracker item at:",
// "Tracker was modified at" => "Tracker was modified at",
// "you or someone registered this email address at" => "you or someone registered this email address at",
// "If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "If you want to be a registered user in this site you will have to use the following link to login for the first time:",
// "Your Tiki information registration" => "Your Tiki information registration",
// "You will receive an email with information to login for the first time into this site" => "You will receive an email with information to login for the first time into this site",
// "Your account request have been stored and will be activated by the admin as soon as possible." => "Your account request have been stored and will be activated by the admin as soon as possible.",
// "New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "View the article at:" => "View the article at:",
// "If you don't want to receive these notifications follow this link:" => "If you don't want to receive these notifications follow this link:",
// "New article post at %s" => "New article post at %s",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "View the blog at:" => "View the blog at:",
// "New blog post at %s" => "New blog post at %s",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "Removed by" => "Removed by",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "File Description" => "File Description",
// "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the updated map following this link:" => "You can view the updated map following this link:",
// "You can edit the map following this link:" => "You can edit the map following this link:",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Comment:" => "Comment:",
// "You can view the page by following this link:" => "You can view the page by following this link:",
// "You can view a diff back to the previous version by following this link:" => "You can view a diff back to the previous version by following this link:",
// "The changes in this version follow below, followed after by the current full page text." => "The changes in this version follow below, followed after by the current full page text.",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "The new page content follows below." => "The new page content follows below.",
// "Wiki page %s changed" => "Wiki page %s changed",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "New name" => "New name",
// "Thank you for you registration. You may log in now." => "Thank you for you registration. You may log in now.",
// "click on the map to zoom or pan, do not drag" => "click on the map to zoom or pan, do not drag",
// "Scale" => "Scale",
// "Zoom out x4" => "Zoom out x4",
// "Zoom out x3" => "Zoom out x3",
// "Zoom out x2" => "Zoom out x2",
// "Query" => "Query",
// "Pan" => "Pan",
// "Zoom in x2" => "Zoom in x2",
// "Zoom in x3" => "Zoom in x3",
// "Zoom in x4" => "Zoom in x4",
// "Redraw" => "Redraw",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
// "Go" => "Go",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Click on the map or click redraw" => "Click on the map or click redraw",
// "Last modification date" => "Last modification date",
// "Overview" => "Overview",
// "Legend" => "Legend",
// "Layer Manager" => "Layer Manager",
// "Layer" => "Layer",
// "On" => "On",
// "Label" => "Label",
// "Download" => "Download",
// "Download Layer" => "Download Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "you have requested to download the layer:" => "you have requested to download the layer:",
// "from\nthe mapfile:" => "from\nthe mapfile:",
// "Here are the files to download, do not forget to rename them:" => "Here are the files to download, do not forget to rename them:",
// "Mapfiles" => "Mapfiles",
// "Mapfile" => "Mapfile",
// "Available mapfiles" => "Available mapfiles",
// "hits" => "hits",
// "hits last 7 days" => "hits last 7 days",
// "monitor this map" => "monitor this map",
// "stop monitoring this map" => "stop monitoring this map",
// "No records found" => "No records found",
// "Create a new mapfile" => "Create a new mapfile",
// "create" => "create",
// "Mapfile listing" => "Mapfile listing",
// "Reload" => "Reload",
// "save" => "save",
// "You can view this map in your browser using" => "You can view this map in your browser using",
// "Mapfile History" => "Mapfile History",
// "of" => "of",
// "Version" => "Version",
// "compare" => "compare",
// "Comparing version {\$old.version} with version {\$new.version}" => "Comparing version {\$old.version} with version {\$new.version}",
// "Version:" => "Version:",
// "current" => "current",
// "Versions are identical" => "Versions are identical",
// "Legend:" => "Legend:",
// "v=view" => "v=view",
// "c=compare" => "c=compare",
// "d=diff" => "d=diff",
// "Side-by-side diff" => "Side-by-side diff",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
// "Ip" => "Ip",
// "view" => "view",
// "diff" => "diff",
// "older version" => "older version",
// "Directories" => "Directories",
// "back to" => "back to",
// "Upload From Disk:" => "Upload From Disk:",
// "Upload Files" => "Upload Files",
// "Bytes maximum" => "Bytes maximum",
// "Create" => "Create",
// "index file (.shp):" => "index file (.shp):",
// "files to index (regexp):" => "files to index (regexp):",
// "Message Archive" => "Message Archive",
// "messages" => "messages",
// "Archive is full!" => "Archive is full!",
// "1" => "1",
// "2" => "2",
// "3" => "3",
// "4" => "4",
// "5" => "5",
// "Containing" => "Containing",
// "download" => "download",
// "sender" => "sender",
// "flagged" => "flagged",
// "Broadcast message" => "Broadcast message",
// "Message Broadcast" => "Message Broadcast",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "CC" => "CC",
// "BCC" => "BCC",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Mailbox is full! Delete or archive some messages if you want to receive more messages.",
// "move to archive" => "move to archive",
// "mark" => "mark",
// "reply to" => "reply to",
// "find replied message" => "find replied message",
// "Mailbox" => "Mailbox",
// "Sent" => "Sent",
// "Archive" => "Archive",
// "Auto-archive age for read messages:" => "Auto-archive age for read messages:",
// "Return to mailbox" => "Return to mailbox",
// "Unflag" => "Unflag",
// "Cc" => "Cc",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Sent Messages" => "Sent Messages",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "receiver" => "receiver",
// "no" => "no",
// "replied" => "replied",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "Move module up" => "Move module up",
// "Move module down" => "Move module down",
// "Hide module contents" => "Hide module contents",
// "Move module to opposite side" => "Move module to opposite side",
// "opp side" => "opp side",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module?" => "Are you sure you want to unassign this module?",
// "Banning" => "Banning",
// "Cache" => "Cache",
// "Hotwords" => "Hotwords",
// "RSS modules" => "RSS modules",
// "Menus" => "Menus",
// "Mail notifications" => "Mail notifications",
// "Search stats" => "Search stats",
// "QuickTags" => "QuickTags",
// "Chat" => "Chat",
// "Banners" => "Banners",
// "Admin drawings" => "Admin drawings",
// "Dynamic content" => "Dynamic content",
// "Cookies" => "Cookies",
// "Mail-in" => "Mail-in",
// "Content templates" => "Content templates",
// "Shoutbox Words" => "Shoutbox Words",
// "Referer stats" => "Referer stats",
// "Import PHPWiki Dump" => "Import PHPWiki Dump",
// "Admin dsn" => "Admin dsn",
// "Security Admin" => "Security Admin",
// "Syntax highlighting" => "Syntax highlighting",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number !" => "You forgot your Google ad_client number !",
// "Contact us" => "Contact us",
// "MyMenu" => "MyMenu",
// "MyTiki" => "MyTiki",
// "MyTiki home" => "MyTiki home",
// "Newsreader" => "Newsreader",
// "Webmail" => "Webmail",
// "Mini calendar" => "Mini calendar",
// "WfMenu" => "WfMenu",
// "Admin processes" => "Admin processes",
// "Monitor processes" => "Monitor processes",
// "Monitor activities" => "Monitor activities",
// "Monitor instances" => "Monitor instances",
// "User processes" => "User processes",
// "User activities" => "User activities",
// "User instances" => "User instances",
// "FriendsMenu" => "FriendsMenu",
// "WikiMenu" => "WikiMenu",
// "Dump" => "Dump",
// "GalMenu" => "GalMenu",
// "View submissions" => "View submissions",
// "Admin types" => "Admin types",
// "List blogs" => "List blogs",
// "Create/Edit blog" => "Create/Edit blog",
// "ForMenu" => "ForMenu",
// "DirMenu" => "DirMenu",
// "Submit a new link" => "Submit a new link",
// "Browse directory" => "Browse directory",
// "Admin directory" => "Admin directory",
// "FileGalMenu" => "FileGalMenu",
// "FAQs" => "FAQs",
// "Layer management" => "Layer management",
// "QuizMenu" => "QuizMenu",
// "Quizzes" => "Quizzes",
// "List quizzes" => "List quizzes",
// "Quiz stats" => "Quiz stats",
// "Admin quiz" => "Admin quiz",
// "ShtMenu" => "ShtMenu",
// "TrkMenu" => "TrkMenu",
// "Trackers" => "Trackers",
// "List trackers" => "List trackers",
// "Admin trackers" => "Admin trackers",
// "SrvMenu" => "SrvMenu",
// "Surveys" => "Surveys",
// "List surveys" => "List surveys",
// "Admin surveys" => "Admin surveys",
// "Newsletters" => "Newsletters",
// "Send newsletters" => "Send newsletters",
// "Admin newsletters" => "Admin newsletters",
// "Events" => "Events",
// "Send events" => "Send events",
// "Admin events" => "Admin events",
// "EphMenu" => "EphMenu",
// "Ephemerides" => "Ephemerides",
// "Ephemerides Admin" => "Ephemerides Admin",
// "ChartMenu" => "ChartMenu",
// "Charts Admin" => "Charts Admin",
// "AdmMenu" => "AdmMenu",
// "Admin home" => "Admin home",
// "Debugger console" => "Debugger console",
// "Theme control" => "Theme control",
// "Edit languages" => "Edit languages",
// "Integrator" => "Integrator",
// "DSN" => "DSN",
// "Mods Admin" => "Mods Admin",
// "UsrMenu" => "UsrMenu",
// "Click here to manage your personal menu" => "Click here to manage your personal menu",
// "Tikiwiki Assistant" => "Tikiwiki Assistant",
// "Thank you for installing Tikiwiki" => "Thank you for installing Tikiwiki",
// "Click the :: options in the Menu for more options." => "Click the :: options in the Menu for more options.",
// "Please, also see" => "Please, also see",
// "for more setup details." => "for more setup details.",
// "Note 1:" => "Note 1:",
// "You can remove this module in" => "You can remove this module in",
// "as well as assign or edit many others." => "as well as assign or edit many others.",
// "Note 2:" => "Note 2:",
// "The menu module installed by default is named" => "The menu module installed by default is named",
// "it is a \"custom module\" which includes menu ID " => "it is a \"custom module\" which includes menu ID ",
// "That menu is stored in database and it can be edited from " => "That menu is stored in database and it can be edited from ",
// "Do not mix this with the original <em>application_menu</em> module" => "Do not mix this with the original <em>application_menu</em> module",
// "That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"",
// "Recently visited pages" => "Recently visited pages",
// "Filter" => "Filter",
// "Today" => "Today",
// "top" => "top",
// "Received objects" => "Received objects",
// "Last `\$module_rows` Sites" => "Last `\$module_rows` Sites",
// "Last Sites" => "Last Sites",
// "Directory Stats" => "Directory Stats",
// "Sites" => "Sites",
// "Sites to validate" => "Sites to validate",
// "Visited links" => "Visited links",
// "Top \$module_rows Sites" => "Top \$module_rows Sites",
// "Top Sites" => "Top Sites",
// "Current events" => "Current events",
// "Featured links" => "Featured links",
// "Top `\$module_rows` topics" => "Top `\$module_rows` topics",
// "Top topics" => "Top topics",
// "Last `\$module_rows` forum posts" => "Last `\$module_rows` forum posts",
// "Last forum posts" => "Last forum posts",
// "Last `\$module_rows` forum topics" => "Last `\$module_rows` forum topics",
// "Last forum topics" => "Last forum topics",
// "Most commented forums" => "Most commented forums",
// "Most read topics" => "Most read topics",
// "Most visited forums" => "Most visited forums",
// "Google Search" => "Google Search",
// "Last `\$module_rows` actions" => "Last `\$module_rows` actions",
// "Last actions" => "Last actions",
// "Last `\$module_rows` articles" => "Last `\$module_rows` articles",
// "Last `\$module_rows` blog posts" => "Last `\$module_rows` blog posts",
// "Last blog posts" => "Last blog posts",
// "Last" => "Last",
// "Last `\$module_rows` Created blogs" => "Last `\$module_rows` Created blogs",
// "Last Created blogs" => "Last Created blogs",
// "Last `\$module_rows` Created FAQs" => "Last `\$module_rows` Created FAQs",
// "Last Created FAQs" => "Last Created FAQs",
// "Last `\$module_rows` Created Quizzes" => "Last `\$module_rows` Created Quizzes",
// "Last Created Quizzes" => "Last Created Quizzes",
// "Last `\$module_rows` modified file galleries" => "Last `\$module_rows` modified file galleries",
// "Last modified file galleries" => "Last modified file galleries",
// "Last `\$module_rows` Files" => "Last `\$module_rows` Files",
// "Last `\$module_rows` galleries" => "Last `\$module_rows` galleries",
// "Last galleries" => "Last galleries",
// "Last `\$module_rows` Images" => "Last `\$module_rows` Images",
// "Last Images" => "Last Images",
// "Last `\$module_rows` modified events" => "Last `\$module_rows` modified events",
// "Last modifed events" => "Last modifed events",
// "Last `\$module_rows` changes" => "Last `\$module_rows` changes",
// "Last `\$module_rows` Modified Items" => "Last `\$module_rows` Modified Items",
// "Last Modified Items" => "Last Modified Items",
// "Last `\$module_rows` Modified blogs" => "Last `\$module_rows` Modified blogs",
// "Last Modified blogs" => "Last Modified blogs",
// "Last `\$module_rows` submissions" => "Last `\$module_rows` submissions",
// "Last submissions" => "Last submissions",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "Last `\$module_rows` Items" => "Last `\$module_rows` Items",
// "Last Items" => "Last Items",
// "Last `\$module_rows` visitors" => "Last `\$module_rows` visitors",
// "Last visitors" => "Last visitors",
// "Open operator console" => "Open operator console",
// "We have" => "We have",
// "logged as" => "logged as",
// "Logout" => "Logout",
// "Login through CAS" => "Login through CAS",
// "Login as admin" => "Login as admin",
// "pass" => "pass",
// "login" => "login",
// "Remember me" => "Remember me",
// "Click here to register" => "Click here to register",
// "register" => "register",
// "Click here if you've forgotten your password" => "Click here if you've forgotten your password",
// "Click here to login using the default security protocol" => "Click here to login using the default security protocol",
// "standard" => "standard",
// "Click here to login using a secure protocol" => "Click here to login using a secure protocol",
// "secure" => "secure",
// "stay in ssl mode" => "stay in ssl mode",
// "local account" => "local account",
// "Tiki Logo" => "Tiki Logo",
// "Waiting Submissions" => "Waiting Submissions",
// "submissions waiting to be examined" => "submissions waiting to be examined",
// "Old articles" => "Old articles",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "Register as a new user" => "Register as a new user",
// "Your email could not be validated; make sure you email is correct and click register below." => "Your email could not be validated; make sure you email is correct and click register below.",
// "Your registration code:" => "Your registration code:",
// "Random Image" => "Random Image",
// "Username" => "Username",
// "Passcode to register (not your user password)" => "Passcode to register (not your user password)",
// "Registration code" => "Registration code",
// "Password" => "Password",
// "Repeat password" => "Repeat password",
// "Email" => "Email",
// "Generate a password" => "Generate a password",
// "RSS Feeds" => "RSS Feeds",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Articles RSS" => "Articles RSS",
// "Image Galleries RSS" => "Image Galleries RSS",
// "File Galleries RSS" => "File Galleries RSS",
// "Forums RSS" => "Forums RSS",
// "Maps RSS" => "Maps RSS",
// "Calendars" => "Calendars",
// "Blog Posts" => "Blog Posts",
// "go" => "go",
// "Search Wiki PageName" => "Search Wiki PageName",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "click to edit" => "click to edit",
// "Most Active blogs" => "Most Active blogs",
// "Top `\$module_rows` articles" => "Top `\$module_rows` articles",
// "Top articles" => "Top articles",
// "Top `\$module_rows` File Galleries" => "Top `\$module_rows` File Galleries",
// "Top File Galleries" => "Top File Galleries",
// "Top `\$module_rows` files" => "Top `\$module_rows` files",
// "Top files" => "Top files",
// "Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
// "Top Forum Posters" => "Top Forum Posters",
// "Top `\$module_rows` games" => "Top `\$module_rows` games",
// "Top games" => "Top games",
// "Top `\$module_rows` galleries" => "Top `\$module_rows` galleries",
// "Top galleries" => "Top galleries",
// "Top `\$module_rows` Images" => "Top `\$module_rows` Images",
// "Top Images" => "Top Images",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Top `\$module_rows` Pages" => "Top `\$module_rows` Pages",
// "Top Pages" => "Top Pages",
// "Top `\$module_rows` Quizzes" => "Top `\$module_rows` Quizzes",
// "Top Quizzes" => "Top Quizzes",
// "Most `\$module_rows` visited blogs" => "Most `\$module_rows` visited blogs",
// "Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` Visited FAQs",
// "Top Visited FAQs" => "Top Visited FAQs",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "Upcoming events" => "Upcoming events",
// "My blogs" => "My blogs",
// "cache" => "cache",
// "done" => "done",
// "del" => "del",
// "Public tasks" => "Public tasks",
// "select" => "select",
// "User informations" => "User informations",
// "Group informations" => "Group informations",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Top users" => "Top users",
// "Whats related" => "Whats related",
// "on host" => "on host",
// "Last `\$module_rows` wiki comments" => "Last `\$module_rows` wiki comments",
// " on page " => " on page ",
// "Click to see the ratings" => "Click to see the ratings",
// "[-]" => "[-]",
// "vote" => "vote",
// "Sent editions" => "Sent editions",
// "find" => "find",
// "use" => "use",
// "Structures:" => "Structures:",
// "show structures" => "show structures",
// "hide structures" => "hide structures",
// "Manage structures" => "Manage structures",
// "Are you sure you want to remove this module?" => "Are you sure you want to remove this module?",
// "Powered by" => "Powered by",
// "Execution time" => "Execution time",
// "Memory usage" => "Memory usage",
// "database queries used" => "database queries used",
// "Server load" => "Server load",
// "page id" => "page id",
// "cached" => "cached",
// "3d browser" => "3d browser",
// "pdf" => "pdf",
// "Save to notepad" => "Save to notepad",
// "backlinks" => "backlinks",
// "Parent page" => "Parent page",
// "Child" => "Child",
// "Add Page" => "Add Page",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Page last modified on" => "Page last modified on",
// "Contributors to this page" => "Contributors to this page",
// "To edit the copyright notices" => "To edit the copyright notices",
// "click here" => "click here",
// "The content on this page is licensed under the terms of the" => "The content on this page is licensed under the terms of the",
// "The original document is available at" => "The original document is available at",
// "slides" => "slides",
// "discuss" => "discuss",
// "1 file attached" => "1 file attached",
// "{\$atts_cnt} files attached" => "{\$atts_cnt} files attached",
// "Page generated in" => "Page generated in",
// "The newsletter was sent to {\$sent} email addresses" => "The newsletter was sent to {\$sent} email addresses",
// "This newsletter will be sent to {\$subscribers} email addresses." => "This newsletter will be sent to {\$subscribers} email addresses.",
// "Prepare a newsletter to be sent" => "Prepare a newsletter to be sent",
// "Newsletter" => "Newsletter",
// "Send Newsletters" => "Send Newsletters",
// "Made with" => "Made with",
// "powered by" => "powered by",
// "This is" => "This is",
// "by the" => "by the",
// "Tiki community" => "Tiki community",
// "User List" => "User List",
// "Assignments" => "Assignments",
// "attachments" => "attachments",
// "Click" => "Click",
// "Show/Hide Left Menus" => "Show/Hide Left Menus",
// "Show/Hide Right Menus" => "Show/Hide Right Menus",
// "chat" => "chat",
// "contact us" => "contact us",
// "stats" => "stats",
// "Member list" => "Member list",
// "dump" => "dump",
// "structures" => "structures",
// "Create/Edit Blog" => "Create/Edit Blog",
// "Browse Directory" => "Browse Directory",
// "List Quizzes" => "List Quizzes",
// "List Trackers" => "List Trackers",
// "List Surveys" => "List Surveys",
// "Prefs" => "Prefs",
// "logout" => "logout",
// "This page is being edited by" => "This page is being edited by",
// "Proceed at your own peril" => "Proceed at your own peril",
// "The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page.",
// "Edit Summary" => "Edit Summary",
// "Copyright" => "Copyright",
// "Allow HTML" => "Allow HTML",
// "Import page" => "Import page",
// "export all versions" => "export all versions",
// "Upload picture" => "Upload picture",
// "no cache" => "no cache",
// "Anti-Bot verification code" => "Anti-Bot verification code",
// "Enter the code you see above" => "Enter the code you see above",
// "License" => "License",
// "Important" => "Important",
// "Minor" => "Minor",
// "dls" => "dls",
// "No attachments for this page" => "No attachments for this page",
// "My Tiki" => "My Tiki",
// "List pages where I am a creator" => "List pages where I am a creator",
// "List pages where I am a modificator" => "List pages where I am a modificator",
// "User Galleries" => "User Galleries",
// "Assigned items" => "Assigned items",
// "at tracker" => "at tracker",
// "User Blogs" => "User Blogs",
// "RSS Trackers" => "RSS Trackers",
// "left/right" => "left/right",
// "Unassign module" => "Unassign module",
// "debugger console" => "debugger console",
// "Mini Calendar" => "Mini Calendar",
// "Edit mapfiles" => "Edit mapfiles",
// "switch" => "switch",
// "on:" => "on:",
// "reads" => "reads",
// "Article image" => "Article image",
// "Topic image" => "Topic image",
// "Refresh" => "Refresh",
// "Location : " => "Location : ",
// "posted by" => "posted by",
// "read more" => "read more",
// "Permalink" => "Permalink",
// "referenced by" => "referenced by",
// "references" => "references",
// "view comments" => "view comments",
// "email this post" => "email this post",
// "Viewing blog post" => "Viewing blog post",
// "Return to blog" => "Return to blog",
// "Trackback pings" => "Trackback pings",
// "URI" => "URI",
// "Blog name" => "Blog name",
// "Translate in" => "Translate in",
// "babelfish it" => "babelfish it",
// "User Bookmarks" => "User Bookmarks",
// "Welcome to" => "Welcome to",
// "Click here to create it" => "Click here to create it",
// "wiki help" => "wiki help",
// "Enlarge area height" => "Enlarge area height",
// "Reduce area height" => "Reduce area height",
// "Features" => "Features",
// "RSS" => "RSS",
// "Meta Tags" => "Meta Tags",
// "Site Identity" => "Site Identity",
// "Site Calendar" => "Site Calendar",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "i18n" => "i18n",
// "Tip" => "Tip",
// "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or",
// "Home Blog" => "Home Blog",
// "Home Blog (main blog)" => "Home Blog (main blog)",
// "ok" => "ok",
// "Blog features" => "Blog features",
// "Blog level comments" => "Blog level comments",
// "Post level comments" => "Post level comments",
// "Post level trackback pings" => "Post level trackback pings",
// "Not Installed" => "Not Installed",
// "Default ordering for blog listing" => "Default ordering for blog listing",
// "Creation date (desc)" => "Creation date (desc)",
// "Last modification date (desc)" => "Last modification date (desc)",
// "Blog title (asc)" => "Blog title (asc)",
// "Number of posts (desc)" => "Number of posts (desc)",
// "Blog listing configuration (when listing available blogs)" => "Blog listing configuration (when listing available blogs)",
// "Creation date" => "Creation date",
// "Last modification time" => "Last modification time",
// "Disabled" => "Disabled",
// "Link to user information" => "Link to user information",
// "User avatar" => "User avatar",
// "Blog comments settings" => "Blog comments settings",
// "Default number of comments per page" => "Default number of comments per page",
// "Comments default ordering" => "Comments default ordering",
// "Points" => "Points",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Group calendar sticky popup" => "Group calendar sticky popup",
// "Group calendar item view tab" => "Group calendar item view tab",
// "Calendar manual selection of time/date" => "Calendar manual selection of time/date",
// "JsCalendar" => "JsCalendar",
// "Change settings" => "Change settings",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "CMS features" => "CMS features",
// "Submissions" => "Submissions",
// "Print article" => "Print article",
// "Settings for page articles home" => "Settings for page articles home",
// "Maximum number of articles in home" => "Maximum number of articles in home",
// "Article comments settings" => "Article comments settings",
// "Fields to display on page" => "Fields to display on page",
// "Publish Date" => "Publish Date",
// "Expire Date" => "Expire Date",
// "Visible" => "Visible",
// "User identity features" => "User identity features",
// "Show user's info on mouseover" => "Show user's info on mouseover",
// "Picture" => "Picture",
// "Number of friends" => "Number of friends",
// "E-mail" => "E-mail",
// "Distance" => "Distance",
// "Set features" => "Set features",
// "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or",
// "enable cool sites" => "enable cool sites",
// "Method to open directory links" => "Method to open directory links",
// "replace current window" => "replace current window",
// "inline frame" => "inline frame",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site.",
// "Tiki sections and features" => "Tiki sections and features",
// "Featured Help" => "Featured Help",
// "Workflow engine" => "Workflow engine",
// "Live Support" => "Live Support",
// "Live support system" => "Live support system",
// "Help System" => "Help System",
// "tikiwiki.org help" => "tikiwiki.org help",
// "Multilingual" => "Multilingual",
// "Best language" => "Best language",
// "Show Category Path" => "Show Category Path",
// "Show Babelfish Translation URLs" => "Show Babelfish Translation URLs",
// "Show Category Objects" => "Show Category Objects",
// "Show Babelfish Translation Logo" => "Show Babelfish Translation Logo",
// "Show Module Controls" => "Show Module Controls",
// "Tiki Calendar" => "Tiki Calendar",
// "Template Viewing" => "Template Viewing",
// "Tiki Template Viewing" => "Tiki Template Viewing",
// "PHPLayers" => "PHPLayers",
// "PhpLayers Dynamic menus" => "PhpLayers Dynamic menus",
// "Use Tabs" => "Use Tabs",
// "Tiki Sheet" => "Tiki Sheet",
// "Site Logo and Identity" => "Site Logo and Identity",
// "Mobile" => "Mobile",
// "Google Maps" => "Google Maps",
// "Trackbacks Pings" => "Trackbacks Pings",
// "Content Features" => "Content Features",
// "Hotwords in New Windows" => "Hotwords in New Windows",
// "Edit CSS" => "Edit CSS",
// "Custom Home" => "Custom Home",
// "Dynamic Content System" => "Dynamic Content System",
// "Allow Smileys" => "Allow Smileys",
// "AutoLinks" => "AutoLinks",
// "Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;>&rdquo; for quoting",
// "Banning System" => "Banning System",
// "Banning system" => "Banning system",
// "Debugger Console" => "Debugger Console",
// "Theme Control" => "Theme Control",
// "XMLRPC API" => "XMLRPC API",
// "Redirect On Error" => "Redirect On Error",
// "User Features" => "User Features",
// "User Preferences Screen" => "User Preferences Screen",
// "Users can Configure Modules" => "Users can Configure Modules",
// "always" => "always",
// "module decides" => "module decides",
// "never" => "never",
// "Users can Shade Modules" => "Users can Shade Modules",
// "User Watches Translations" => "User Watches Translations",
// "User Notepad" => "User Notepad",
// "Users can Flip Columns" => "Users can Flip Columns",
// "user decides" => "user decides",
// "Layout per section" => "Layout per section",
// "Admin layout per section" => "Admin layout per section",
// "Top bar" => "Top bar",
// "Bottom bar" => "Bottom bar",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "To add/remove file galleries, go to \"File Galleries\" on the application menu, or",
// "Home Gallery" => "Home Gallery",
// "Home Gallery (main gallery)" => "Home Gallery (main gallery)",
// "Galleries features" => "Galleries features",
// "Allow same file to be uploaded more than once" => "Allow same file to be uploaded more than once",
// "Use database to store files" => "Use database to store files",
// "Use a directory to store files" => "Use a directory to store files",
// "Directory path" => "Directory path",
// "Uploaded filenames must match regex" => "Uploaded filenames must match regex",
// "Uploaded filenames cannot match regex" => "Uploaded filenames cannot match regex",
// "Storing files in a directory" => "Storing files in a directory",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory.",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "please read" => "please read",
// "Gallery listing configuration" => "Gallery listing configuration",
// "Change configuration" => "Change configuration",
// "File galleries comments settings" => "File galleries comments settings",
// "File galleries search indexing" => "File galleries search indexing",
// "Leave command blank to delete handler" => "Leave command blank to delete handler",
// "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)",
// "Enable auto indexing on file upload or change" => "Enable auto indexing on file upload or change",
// "MIME Type" => "MIME Type",
// "System command" => "System command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Home Forum" => "Home Forum",
// "Home Forum (main forum)" => "Home Forum (main forum)",
// "Forums features" => "Forums features",
// "Accept wiki syntax" => "Accept wiki syntax",
// "Forum quick jumps" => "Forum quick jumps",
// "Threads (desc)" => "Threads (desc)",
// "Forum listing configuration" => "Forum listing configuration",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Uses Slideshow" => "Uses Slideshow",
// "Use database to store images" => "Use database to store images",
// "Use a directory to store images" => "Use a directory to store images",
// "Library to use for processing images" => "Library to use for processing images",
// "Uploaded image names must match regex" => "Uploaded image names must match regex",
// "Uploaded image names cannot match regex" => "Uploaded image names cannot match regex",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "Enable cache images to all galleries" => "Enable cache images to all galleries",
// "Images cache directory" => "Images cache directory",
// "Exterminator" => "Exterminator",
// "Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Remove images in the system gallery not being used in Wiki pages, articles or blog posts",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "All galleries" => "All galleries",
// "Move" => "Move",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "images" => "images",
// "Image galleries comments settings" => "Image galleries comments settings",
// "Theme" => "Theme",
// "Change style only" => "Change style only",
// "Slideshows theme" => "Slideshows theme",
// "Use group homepages" => "Use group homepages",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "Use URI as Home Page" => "Use URI as Home Page",
// "Custom home" => "Custom home",
// "Detect browser language" => "Detect browser language",
// "Unix" => "Unix",
// "Windows" => "Windows",
// "PHP error reporting level for non-admin:" => "PHP error reporting level for non-admin:",
// "No error reporting" => "No error reporting",
// "Report all PHP errors" => "Report all PHP errors",
// "Report all errors except notices" => "Report all errors except notices",
// "Report PHP errors only for admin" => "Report PHP errors only for admin",
// "Default charset for sending mail:" => "Default charset for sending mail:",
// "Mail end of line:" => "Mail end of line:",
// "(standard)" => "(standard)",
// "(some Unix MTA)" => "(some Unix MTA)",
// "Disallow access to the site (except for those with permission)" => "Disallow access to the site (except for those with permission)",
// "Message to display when site is closed" => "Message to display when site is closed",
// "Disallow access when load is above the threshold (except for those with permission)" => "Disallow access when load is above the threshold (except for those with permission)",
// "Max average server load threshold in the last minute" => "Max average server load threshold in the last minute",
// "Message to display when server is too busy" => "Message to display when server is too busy",
// "Display modules to all groups always" => "Display modules to all groups always",
// "Use direct pagination links" => "Use direct pagination links",
// "Display menus as folders" => "Display menus as folders",
// "Tikiwiki.org help" => "Tikiwiki.org help",
// "Use gzipped output" => "Use gzipped output",
// "output compression is active." => "output compression is active.",
// "compression is handled by" => "compression is handled by",
// "Count admin pageviews" => "Count admin pageviews",
// "Hide anonymous-only modules from registered users" => "Hide anonymous-only modules from registered users",
// "Server name (for absolute URIs)" => "Server name (for absolute URIs)",
// "HTTPS Server" => "HTTPS Server",
// "Automatic (uses HTTPS variable)" => "Automatic (uses HTTPS variable)",
// "Browser title" => "Browser title",
// "Wiki_Tiki_Title" => "Wiki_Tiki_Title",
// "Temporary directory" => "Temporary directory",
// "Contact user" => "Contact user",
// "Allow anonymous users to \"Contact Us\"" => "Allow anonymous users to \"Contact Us\"",
// "contact feature disabled" => "contact feature disabled",
// "Store session data in database" => "Store session data in database",
// "Session lifetime in minutes" => "Session lifetime in minutes",
// "Use proxy" => "Use proxy",
// "Proxy Host" => "Proxy Host",
// "Proxy port" => "Proxy port",
// "Help URL" => "Help URL",
// "Please expect not found help-pages with the default-URL." => "Please expect not found help-pages with the default-URL.",
// "Any help with the documentation is welcome." => "Any help with the documentation is welcome.",
// "Date and Time Formats" => "Date and Time Formats",
// "Long date format" => "Long date format",
// "Short date format" => "Short date format",
// "Long time format" => "Long time format",
// "Short time format" => "Short time format",
// "Date and Time Format Help" => "Date and Time Format Help",
// "Favicon icon file name:" => "Favicon icon file name:",
// "Favicon icon MIME type:" => "Favicon icon MIME type:",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Locations separator" => "Locations separator",
// "Register this site at tikiwiki.org" => "Register this site at tikiwiki.org",
// "Click here for more details." => "Click here for more details.",
// "Change admin password" => "Change admin password",
// "New password" => "New password",
// "Change password" => "Change password",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "I18n setup" => "I18n setup",
// "Best Language" => "Best Language",
// "Reg users can change language" => "Reg users can change language",
// "Restrict available languages" => "Restrict available languages",
// "Available languages:" => "Available languages:",
// "Edit or ex/import Languages" => "Edit or ex/import Languages",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// " as master" => " as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "port" => "port",
// "path" => "path",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "IP" => "IP",
// "Contact" => "Contact",
// "New" => "New",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// "Admin->Features" => "Admin->Features",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Users &amp; groups" => "Users &amp; groups",
// "User registration and login" => "User registration and login",
// "Authentication method" => "Authentication method",
// "Just Tiki" => "Just Tiki",
// "Web Server" => "Web Server",
// "Tiki and PEAR::Auth" => "Tiki and PEAR::Auth",
// "Tiki and PAM" => "Tiki and PAM",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "Tiki and HTTP Auth" => "Tiki and HTTP Auth",
// "Use WebServer authentication for Tiki" => "Use WebServer authentication for Tiki",
// "Users can register" => "Users can register",
// "... but need admin validation" => "... but need admin validation",
// "must be turned on and notification is sent to the admin's" => "must be turned on and notification is sent to the admin's",
// "inter-user message inbox" => "inter-user message inbox",
// "Create a group for each user <br />(with the same\nname as the user)" => "Create a group for each user <br />(with the same\nname as the user)",
// "Use tracker for more user information" => "Use tracker for more user information",
// "Use tracker for more group information" => "Use tracker for more group information",
// "Request passcode to register" => "Request passcode to register",
// "Prevent automatic/robot registration" => "Prevent automatic/robot registration",
// " - Php GD library required" => " - Php GD library required",
// "Validate email address (may not work)" => "Validate email address (may not work)",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email",
// "Store plaintext passwords" => "Store plaintext passwords",
// "Reg users can change password" => "Reg users can change password",
// "Reg users can change theme" => "Reg users can change theme",
// "Restrict available themes" => "Restrict available themes",
// "Available styles:" => "Available styles:",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "Use challenge/response authentication" => "Use challenge/response authentication",
// "Force to use chars and nums in passwords" => "Force to use chars and nums in passwords",
// "Minimum password length" => "Minimum password length",
// "Password invalid after days" => "Password invalid after days",
// "Require HTTP Basic authentication" => "Require HTTP Basic authentication",
// "Allow secure (https) login" => "Allow secure (https) login",
// "Require secure (https) login" => "Require secure (https) login",
// "HTTP server name" => "HTTP server name",
// "HTTP port" => "HTTP port",
// "HTTP URL prefix" => "HTTP URL prefix",
// "HTTPS server name" => "HTTPS server name",
// "HTTPS port" => "HTTPS port",
// "HTTPS URL prefix" => "HTTPS URL prefix",
// "Remember me feature" => "Remember me feature",
// "month" => "month",
// "year" => "year",
// "Remember me name" => "Remember me name",
// "Remember me domain" => "Remember me domain",
// "Remember me path" => "Remember me path",
// "Protect against CSRF with a confirmation step" => "Protect against CSRF with a confirmation step",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "Highlight Group" => "Highlight Group",
// "choose a group ..." => "choose a group ...",
// "PEAR::Auth" => "PEAR::Auth",
// "LDAP" => "LDAP",
// "Auth Type" => "Auth Type",
// "IMAP/POP3/LDAP Host" => "IMAP/POP3/LDAP Host",
// "IMAP/POP3/LDAP Port" => "IMAP/POP3/LDAP Port",
// "IMAP/POP3 BaseDSN" => "IMAP/POP3 BaseDSN",
// "Create user if not in Tiki?" => "Create user if not in Tiki?",
// "Create user if not in Auth?" => "Create user if not in Auth?",
// "Just use Tiki auth for admin?" => "Just use Tiki auth for admin?",
// "LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(if set, this will override the Host and Port below)",
// "LDAP Scope" => "LDAP Scope",
// "LDAP Base DN" => "LDAP Base DN",
// "LDAP User DN" => "LDAP User DN",
// "LDAP User Attribute" => "LDAP User Attribute",
// "LDAP User OC" => "LDAP User OC",
// "LDAP Group DN" => "LDAP Group DN",
// "LDAP Group Attribute" => "LDAP Group Attribute",
// "LDAP Group OC" => "LDAP Group OC",
// "LDAP Member Attribute" => "LDAP Member Attribute",
// "LDAP Member Is DN" => "LDAP Member Is DN",
// "LDAP Admin User" => "LDAP Admin User",
// "LDAP Admin Pwd" => "LDAP Admin Pwd",
// "PAM" => "PAM",
// "PAM service" => "PAM service",
// "Currently unused" => "Currently unused",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/.",
// "CAS server version" => "CAS server version",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "CAS server hostname" => "CAS server hostname",
// "CAS server port" => "CAS server port",
// "CAS server path" => "CAS server path",
// "Change CAS preferences" => "Change CAS preferences",
// "full path to mapfiles" => "full path to mapfiles",
// "default mapfile" => "default mapfile",
// "Wiki Page for Help" => "Wiki Page for Help",
// "Wiki Page for Comments" => "Wiki Page for Comments",
// "Full path to gdaltindex" => "Full path to gdaltindex",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "Generate User Map" => "Generate User Map",
// "<b>Item</b>" => "<b>Item</b>",
// "<b>Value</b>" => "<b>Value</b>",
// "Meta Keywords" => "Meta Keywords",
// "Meta Description" => "Meta Description",
// "Meta Author" => "Meta Author",
// "Geourl" => "Geourl",
// "geo.position" => "geo.position",
// "geo.region" => "geo.region",
// "geo.placename" => "geo.placename",
// "Robots" => "Robots",
// "meta robots" => "meta robots",
// "revisit after" => "revisit after",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Allow Anonymous Poll Voting" => "Allow Anonymous Poll Voting",
// "This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or" => "This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or",
// "<b>Feed</b>" => "<b>Feed</b>",
// "<b>enable/disable</b>" => "<b>enable/disable</b>",
// "Feed for Articles" => "Feed for Articles",
// "Feed for Weblogs" => "Feed for Weblogs",
// "Feed for Image Galleries" => "Feed for Image Galleries",
// "Feed for File Galleries" => "Feed for File Galleries",
// "Feed for the Wiki" => "Feed for the Wiki",
// "Feed for individual Image Galleries" => "Feed for individual Image Galleries",
// "Feed for individual File Galleries" => "Feed for individual File Galleries",
// "Feed for individual weblogs" => "Feed for individual weblogs",
// "Feed for forums" => "Feed for forums",
// "Feed for individual forums" => "Feed for individual forums",
// "Feed for mapfiles" => "Feed for mapfiles",
// "Feed for directories" => "Feed for directories",
// "Feed for individual tracker items" => "Feed for individual tracker items",
// "Feed for tracker items" => "Feed for tracker items",
// "Feed for upcoming calendar events" => "Feed for upcoming calendar events",
// "Default RDF version" => "Default RDF version",
// "Specification" => "Specification",
// "Documentation" => "Documentation",
// "Editor" => "Editor",
// "Webmaster" => "Webmaster",
// "Caching time :" => "Caching time :",
// "seconds (0 = cache inactive)" => "seconds (0 = cache inactive)",
// "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions." => "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions.",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "Search features" => "Search features",
// "Full Text Search" => "Full Text Search",
// "SearchStats" => "SearchStats",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Performance issues" => "Performance issues",
// "Search may show forbidden results. Much better performance though." => "Search may show forbidden results. Much better performance though.",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Settings for searching content" => "Settings for searching content",
// "Search refresh rate" => "Search refresh rate",
// "Minimum length of search word" => "Minimum length of search word",
// "Max. number of words containing a syllable" => "Max. number of words containing a syllable",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
// "Don't forget: to use feature you will need to enable it on" => "Don't forget: to use feature you will need to enable it on",
// "Custom Code" => "Custom Code",
// "Custom code" => "Custom code",
// "Site Breadcrumbs" => "Site Breadcrumbs",
// "Site breadcrumbs" => "Site breadcrumbs",
// "Site location bar" => "Site location bar",
// "at top of page" => "at top of page",
// "at top of center column" => "at top of center column",
// "Prefix breadcrumbs with 'Location:' label?" => "Prefix breadcrumbs with 'Location:' label?",
// "Larger font for" => "Larger font for",
// "entire location" => "entire location",
// "page name" => "page name",
// "Use page description:" => "Use page description:",
// "Site Search" => "Site Search",
// "Site search bar" => "Site search bar",
// "Site Logo" => "Site Logo",
// "Site logo source" => "Site logo source",
// "Site logo title (on mouse over)" => "Site logo title (on mouse over)",
// "Alt. description (e.g. for text browsers)" => "Alt. description (e.g. for text browsers)",
// "Site Ads and Banners" => "Site Ads and Banners",
// "Site ads and banners" => "Site ads and banners",
// "Site Menu" => "Site Menu",
// "Site menu bar" => "Site menu bar",
// "Note: This feature also requires phplayers to be turned on in Admin->Features" => "Note: This feature also requires phplayers to be turned on in Admin->Features",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Trackers attachments preferences" => "Trackers attachments preferences",
// "Path" => "Path",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Trackers attachments" => "Trackers attachments",
// "Storage" => "Storage",
// "Change all to db" => "Change all to db",
// "Change all to file" => "Change all to file",
// "Quota (Mb)" => "Quota (Mb)",
// "Use database to store userfiles" => "Use database to store userfiles",
// "Use a directory to store userfiles" => "Use a directory to store userfiles",
// "Allow viewing HTML mails?" => "Allow viewing HTML mails?",
// "Maximum size for each attachment" => "Maximum size for each attachment",
// "Unlimited" => "Unlimited",
// "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or",
// "Dumps" => "Dumps",
// "Generate dump" => "Generate dump",
// "Download last dump" => "Download last dump",
// "Create a Tag for the Current Wiki" => "Create a Tag for the Current Wiki",
// "Tag name" => "Tag name",
// "Restore the Wiki" => "Restore the Wiki",
// "restore" => "restore",
// "Remove a Tag" => "Remove a Tag",
// "Wiki Comments Settings" => "Wiki Comments Settings",
// "Export Wiki Pages" => "Export Wiki Pages",
// "Export" => "Export",
// "Wiki Administration" => "Wiki Administration",
// "Manage attachment preferences" => "Manage attachment preferences",
// "Remove unused pictures" => "Remove unused pictures",
// "Wiki Home Page" => "Wiki Home Page",
// "Wiki Discussion" => "Wiki Discussion",
// "Discuss pages on forums" => "Discuss pages on forums",
// "Wiki Link Format" => "Wiki Link Format",
// "Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>.",
// "complete" => "complete",
// "latin" => "latin",
// "Wiki Page List Configuration" => "Wiki Page List Configuration",
// "Last version" => "Last version",
// "Status" => "Status",
// "Versions" => "Versions",
// "Backlinks" => "Backlinks",
// "Wiki 3D Browser Configuration" => "Wiki 3D Browser Configuration",
// "Enable wiki 3D browser" => "Enable wiki 3D browser",
// "Browser width" => "Browser width",
// "Browser height" => "Browser height",
// "Navigation depth" => "Navigation depth",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Existing page node color" => "Existing page node color",
// "Missing page node color" => "Missing page node color",
// "Load page on navigation" => "Load page on navigation",
// "Camera distance" => "Camera distance",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Field of view" => "Field of view",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Spring (connection) size" => "Spring (connection) size",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "HTML in Wiki Pages" => "HTML in Wiki Pages",
// "Wiki syntax used when a page contains HTML" => "Wiki syntax used when a page contains HTML",
// "full" => "full",
// "partial" => "partial",
// "Wysiwyg editor" => "Wysiwyg editor",
// "default" => "default",
// "optional" => "optional",
// "Wiki Features" => "Wiki Features",
// "Anonymous editors must input anti-bot code" => "Anonymous editors must input anti-bot code",
// "Similar" => "Similar",
// "MultiPrint" => "MultiPrint",
// "Warn on edit conflict" => "Warn on edit conflict",
// "Edit idle timeout" => "Edit idle timeout",
// "mins" => "mins",
// "Use page description" => "Use page description",
// "Show page ID" => "Show page ID",
// "Cache wiki pages (global)" => "Cache wiki pages (global)",
// "Individual cache" => "Individual cache",
// "Footnotes" => "Footnotes",
// "Users can lock pages (if perm)" => "Users can lock pages (if perm)",
// "Use WikiWords" => "Use WikiWords",
// "Accept dashes and underscores in WikiWords" => "Accept dashes and underscores in WikiWords",
// "Link plural WikiWords to their singular forms" => "Link plural WikiWords to their singular forms",
// "Use Wiki paragraph formatting" => "Use Wiki paragraph formatting",
// "Automonospaced text" => "Automonospaced text",
// "Tables syntax" => "Tables syntax",
// "|| for rows" => "|| for rows",
// "\\n for rows" => "\\n for rows",
// "Open page as structure" => "Open page as structure",
// "Use external link icons" => "Use external link icons",
// "User's Page" => "User's Page",
// "UserPage prefix" => "UserPage prefix",
// "Page creators are admin of their pages" => "Page creators are admin of their pages",
// "Import HTML" => "Import HTML",
// "List authors" => "List authors",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "no (disabled)" => "no (disabled)",
// "Print Page" => "Print Page",
// "Search and replace" => "Search and replace",
// "Wiki History" => "Wiki History",
// "Maximum number of versions for history" => "Maximum number of versions for history",
// "unlimited" => "unlimited",
// "Never delete versions younger than days" => "Never delete versions younger than days",
// "IP not displayed in history" => "IP not displayed in history",
// "Diff style" => "Diff style",
// "Only with last version" => "Only with last version",
// "Any 2 versions" => "Any 2 versions",
// "Enable Feature" => "Enable Feature",
// "License Page" => "License Page",
// "Submit Notice" => "Submit Notice",
// "Wiki Watch" => "Wiki Watch",
// "Create watch for author on page creation" => "Create watch for author on page creation",
// "Enable watch events when I am the editor" => "Enable watch events when I am the editor",
// "Enable watches on comments" => "Enable watches on comments",
// "Wiki attachments preferences" => "Wiki attachments preferences",
// "Wiki attachments" => "Wiki attachments",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Spreadsheet" => "Spreadsheet",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "System" => "System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look &amp; feel" => "Look &amp; feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Help on Banning System" => "Help on Banning System",
// "View tpl" => "View tpl",
// "admin banning tpl" => "admin banning tpl",
// "Add or edit a rule" => "Add or edit a rule",
// "Rule title" => "Rule title",
// "Username regex matching" => "Username regex matching",
// "IP regex matching" => "IP regex matching",
// "Banned from sections" => "Banned from sections",
// "check / uncheck all" => "check / uncheck all",
// "Rule activated by dates" => "Rule activated by dates",
// "Rule active from" => "Rule active from",
// "Rule active until" => "Rule active until",
// "Custom message to the user" => "Custom message to the user",
// "Rules" => "Rules",
// "x" => "x",
// "User/IP" => "User/IP",
// "Admin Calendars" => "Admin Calendars",
// "Configure/Options" => "Configure/Options",
// "List of Calendars" => "List of Calendars",
// "ID" => "ID",
// "loc" => "loc",
// "participants" => "participants",
// "cat" => "cat",
// "prio" => "prio",
// "subscription" => "subscription",
// "perso" => "perso",
// "permissions" => "permissions",
// "Create/edit Calendars" => "Create/edit Calendars",
// "Custom Locations" => "Custom Locations",
// "Custom Participants" => "Custom Participants",
// "Custom Categories" => "Custom Categories",
// "Custom Languages" => "Custom Languages",
// "Custom Subscription List" => "Custom Subscription List",
// "Custom Priorities" => "Custom Priorities",
// "Personal Calendar" => "Personal Calendar",
// "admin categories tpl" => "admin categories tpl",
// "browse the category system" => "browse the category system",
// "Current category" => "Current category",
// "Child categories" => "Child categories",
// "Edit this category:" => "Edit this category:",
// "create new" => "create new",
// "Parent" => "Parent",
// "Perms inherited from closest parent if possible or from global perms" => "Perms inherited from closest parent if possible or from global perms",
// "Assign permissions automatically" => "Assign permissions automatically",
// "recommended for best performance" => "recommended for best performance",
// "Edit permissions for this category" => "Edit permissions for this category",
// "Objects in category" => "Objects in category",
// "image gal" => "image gal",
// "file gal" => "file gal",
// "Admin chart items" => "Admin chart items",
// "edit chart" => "edit chart",
// "Add or edit an item" => "Add or edit an item",
// "URL" => "URL",
// "update" => "update",
// "Chart items" => "Chart items",
// "No items defined yet" => "No items defined yet",
// "Admin charts" => "Admin charts",
// "View template" => "View template",
// "admin charts template" => "admin charts template",
// "Add or edit a chart" => "Add or edit a chart",
// "Users can vote for only one item from this chart per period" => "Users can vote for only one item from this chart per period",
// "Prevent users from voting for the same item more than once" => "Prevent users from voting for the same item more than once",
// "Users can suggest new items" => "Users can suggest new items",
// "Auto validate user suggestions" => "Auto validate user suggestions",
// "Ranking shows" => "Ranking shows",
// "All items" => "All items",
// "Top 10 items" => "Top 10 items",
// "Top 20 items" => "Top 20 items",
// "Top 40 items" => "Top 40 items",
// "Top 50 items" => "Top 50 items",
// "Top 100 items" => "Top 100 items",
// "Top 250 items" => "Top 250 items",
// "Voting system" => "Voting system",
// "Vote items" => "Vote items",
// "Rank 1..5" => "Rank 1..5",
// "Rank 1..10" => "Rank 1..10",
// "Ranking frequency" => "Ranking frequency",
// "Realtime" => "Realtime",
// "Each 5 minutes" => "Each 5 minutes",
// "Daily" => "Daily",
// "Weekly" => "Weekly",
// "Monthly" => "Monthly",
// "Show Average" => "Show Average",
// "Show Votes" => "Show Votes",
// "Use Cookies for unregistered users" => "Use Cookies for unregistered users",
// "Users can vote again after" => "Users can vote again after",
// "Anytime" => "Anytime",
// "5 minutes" => "5 minutes",
// "1 day" => "1 day",
// "1 week" => "1 week",
// "1 month" => "1 month",
// "Items" => "Items",
// "Ranks" => "Ranks",
// "No charts defined yet" => "No charts defined yet",
// "Chat Administration" => "Chat Administration",
// "Chat Admin" => "Chat Admin",
// "Chat Admin tpl" => "Chat Admin tpl",
// "Create/edit channel" => "Create/edit channel",
// "Chat channels" => "Chat channels",
// "active" => "active",
// "admin content templates" => "admin content templates",
// "admin content templates template" => "admin content templates template",
// "Edit this template:" => "Edit this template:",
// "use in cms" => "use in cms",
// "use in wiki" => "use in wiki",
// "use in newsletters" => "use in newsletters",
// "use in events" => "use in events",
// "use in HTML pages" => "use in HTML pages",
// "template" => "template",
// "Templates" => "Templates",
// "Admin cookies" => "Admin cookies",
// "admin FortuneCookie" => "admin FortuneCookie",
// "admin FortuneCookie tpl" => "admin FortuneCookie tpl",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}.",
// "Create/edit cookies" => "Create/edit cookies",
// "Cookie" => "Cookie",
// "Upload Cookies from textfile" => "Upload Cookies from textfile",
// "Upload from disk:" => "Upload from disk:",
// "upload" => "upload",
// "Remove all cookies" => "Remove all cookies",
// "cookie" => "cookie",
// "Help on Drawings" => "Help on Drawings",
// "admin Drawings tpl" => "admin Drawings tpl",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link.",
// "Available drawings" => "Available drawings",
// "Ver" => "Ver",
// "Admin DSN" => "Admin DSN",
// "tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
// "Use Admin DSN to define the database to be used by the SQL plugin." => "Use Admin DSN to define the database to be used by the SQL plugin.",
// "Create/edit dsn" => "Create/edit dsn",
// "dsn" => "dsn",
// "Admin external wikis" => "Admin external wikis",
// "admin External Wikis" => "admin External Wikis",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "Create/Edit External Wiki" => "Create/Edit External Wiki",
// "URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)",
// "extwiki" => "extwiki",
// "Admin Forums" => "Admin Forums",
// "admin forums template" => "admin forums template",
// "Create new forum" => "Create new forum",
// "Edit existing forums" => "Edit existing forums",
// "Edit this Forum:" => "Edit this Forum:",
// "Create New Forum" => "Create New Forum",
// "There are individual permissions set for this forum" => "There are individual permissions set for this forum",
// "Show description" => "Show description",
// "Prevent flooding" => "Prevent flooding",
// "Minimum time between posts" => "Minimum time between posts",
// "min" => "min",
// "Topics per page" => "Topics per page",
// "Section" => "Section",
// "Create new" => "Create new",
// "Moderator user" => "Moderator user",
// "Moderator group" => "Moderator group",
// "Password protected" => "Password protected",
// "Topics only" => "Topics only",
// "All posts" => "All posts",
// "Forum password" => "Forum password",
// "Default ordering for threads" => "Default ordering for threads",
// "Send this forums posts to this email" => "Send this forums posts to this email",
// "Prune unreplied messages after" => "Prune unreplied messages after",
// "Prune old messages after" => "Prune old messages after",
// "Posts can be rated" => "Posts can be rated",
// "Display last post titles" => "Display last post titles",
// "no display" => "no display",
// "Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address",
// "Send mails even when the post is generated by inbound mail" => "Send mails even when the post is generated by inbound mail",
// "Append a reply link to outbound mails" => "Append a reply link to outbound mails",
// "Originating e-mail address for mails from this forum" => "Originating e-mail address for mails from this forum",
// "Add messages from this email to the forum" => "Add messages from this email to the forum",
// "POP3 server" => "POP3 server",
// "Use topic smileys" => "Use topic smileys",
// "Show topic summary" => "Show topic summary",
// "User information display" => "User information display",
// "avatar" => "avatar",
// "flag" => "flag",
// "online" => "online",
// "Approval type" => "Approval type",
// "All posted" => "All posted",
// "Queue anonymous posts" => "Queue anonymous posts",
// "Queue all posts" => "Queue all posts",
// "Attachments" => "Attachments",
// "No attachments" => "No attachments",
// "Everybody can attach" => "Everybody can attach",
// "Only users with attach permission" => "Only users with attach permission",
// "Moderators and admin can attach" => "Moderators and admin can attach",
// "Store attachments in:" => "Store attachments in:",
// "Max attachment size (bytes)" => "Max attachment size (bytes)",
// "Edit Existing Forums" => "Edit Existing Forums",
// "coms" => "coms",
// "ppd" => "ppd",
// "Assign Permissions (Active)" => "Assign Permissions (Active)",
// "Assign Permissions" => "Assign Permissions",
// "Click here to delete this forum" => "Click here to delete this forum",
// "Admin Hotwords" => "Admin Hotwords",
// "admin hotwords" => "admin hotwords",
// "admin hotwords template" => "admin hotwords template",
// "Add Hotword" => "Add Hotword",
// "admin HTML page dynamic zones" => "admin HTML page dynamic zones",
// "Admin HTML pages" => "Admin HTML pages",
// "Edit zone" => "Edit zone",
// "admin Html Pages" => "admin Html Pages",
// "admin Html Pages template" => "admin Html Pages template",
// "Refresh rate (if dynamic) [secs]" => "Refresh rate (if dynamic) [secs]",
// "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones" => "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature.",
// "Edit Repository:" => "Edit Repository:",
// "Create New Repository" => "Create New Repository",
// "list repositories" => "list repositories",
// "new repository" => "new repository",
// "view repository" => "view repository",
// "Human readable repository name" => "Human readable repository name",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "File name of start page" => "File name of start page",
// "Start page" => "Start page",
// "CSS file to load when browse this repository" => "CSS file to load when browse this repository",
// "CSS file" => "CSS file",
// "Is repository visible to users" => "Is repository visible to users",
// "Can files from repository be cached" => "Can files from repository be cached",
// "Cacheable" => "Cacheable",
// "Are files from repository can be cached" => "Are files from repository can be cached",
// "Clear all cached pages of this repository" => "Clear all cached pages of this repository",
// "Clear cache" => "Clear cache",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Cache expiration" => "Cache expiration",
// "Human readable text description of repository" => "Human readable text description of repository",
// "Available Repositories" => "Available Repositories",
// "Start" => "Start",
// "CSS File" => "CSS File",
// "Edit rules" => "Edit rules",
// "Edit Rules for Repository:" => "Edit Rules for Repository:",
// "configure repositories" => "configure repositories",
// "configure this repository" => "configure this repository",
// "view this repository" => "view this repository",
// "view/hide copy rules dialog" => "view/hide copy rules dialog",
// "copy rules" => "copy rules",
// "Source repository" => "Source repository",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Rule order" => "Rule order",
// "Text to search for" => "Text to search for",
// "Text to replace" => "Text to replace",
// "Is this regular expression or simple search/replacer" => "Is this regular expression or simple search/replacer",
// "Regex" => "Regex",
// "Is case sensitive (for simple replacer)" => "Is case sensitive (for simple replacer)",
// "Case sensitive" => "Case sensitive",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
// "Human readable text description of rule" => "Human readable text description of rule",
// "Check to enable this rule" => "Check to enable this rule",
// "Enabled" => "Enabled",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
// "Apply all rules" => "Apply all rules",
// "View source code after rules applied" => "View source code after rules applied",
// "Generate HTML preview" => "Generate HTML preview",
// "HTML preview" => "HTML preview",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
// "Preview Results" => "Preview Results",
// "Rules List" => "Rules List",
// "Case" => "Case",
// "admin featured links" => "admin featured links",
// "admin featured links template" => "admin featured links template",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.",
// "Generate positions by hits" => "Generate positions by hits",
// "List of featured links" => "List of featured links",
// "url" => "url",
// "position" => "position",
// "Add Featured Link" => "Add Featured Link",
// "Edit this Featured Link:" => "Edit this Featured Link:",
// "Create new Featured Link" => "Create new Featured Link",
// "Position" => "Position",
// "disables the link" => "disables the link",
// "Link type" => "Link type",
// "replace current page" => "replace current page",
// "framed" => "framed",
// "Mail-in accounts" => "Mail-in accounts",
// "admin Webmail" => "admin Webmail",
// "admin mailin template" => "admin mailin template",
// "Account" => "Account",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
// "Account name" => "Account name",
// "POP server" => "POP server",
// "Port" => "Port",
// "SMTP server" => "SMTP server",
// "SMTP requires authentication" => "SMTP requires authentication",
// "article-put" => "article-put",
// "wiki-get" => "wiki-get",
// "wiki-put" => "wiki-put",
// "wiki-append" => "wiki-append",
// "Article Topic" => "Article Topic",
// "Article Type" => "Article Type",
// "Allow anonymous acces" => "Allow anonymous acces",
// "Allow attachments" => "Allow attachments",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
// "Check automatically" => "Check automatically",
// "mn" => "mn",
// "Edit this menu" => "Edit this menu",
// "Edit menu options" => "Edit menu options",
// "Show Quick Urls" => "Show Quick Urls",
// "Hide Quick Urls" => "Hide Quick Urls",
// "Some useful URLs" => "Some useful URLs",
// "Permissions" => "Permissions",
// "sorted section" => "sorted section",
// "separator" => "separator",
// "Choose" => "Choose",
// "Home Image Gal" => "Home Image Gal",
// "Home Image Gallery" => "Home Image Gallery",
// "Home File Gal" => "Home File Gal",
// "Home File Gallery" => "Home File Gallery",
// "List image galleries" => "List image galleries",
// "Upload" => "Upload",
// "Gallery Rankings" => "Gallery Rankings",
// "Browse a gallery" => "Browse a gallery",
// "Submit" => "Submit",
// "List Blogs" => "List Blogs",
// "Create blog" => "Create blog",
// "View a forum" => "View a forum",
// "View a thread" => "View a thread",
// "View a FAQ" => "View a FAQ",
// "Take a quiz" => "Take a quiz",
// "Stats for a Quiz" => "Stats for a Quiz",
// "Preview menu" => "Preview menu",
// "Menu options" => "Menu options",
// "group" => "group",
// "Admin Menus" => "Admin Menus",
// "admin menu builder" => "admin menu builder",
// "admin menus template" => "admin menus template",
// "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:",
// "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "Edit this Menu:" => "Edit this Menu:",
// "Create new Menu" => "Create new Menu",
// "dynamic collapsed" => "dynamic collapsed",
// "dynamic extended" => "dynamic extended",
// "fixed" => "fixed",
// "admin modules template" => "admin modules template",
// "\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n",
// "User Modules" => "User Modules",
// "Order" => "Order",
// "Cache Time" => "Cache Time",
// "Visibility" => "Visibility",
// "Displayed for the eligible users with no personal assigned modules" => "Displayed for the eligible users with no personal assigned modules",
// "Displayed now for all eligible users even with personal assigned modules" => "Displayed now for all eligible users even with personal assigned modules",
// "Displayed now, can't be unassigned" => "Displayed now, can't be unassigned",
// "Not displayed until a user chooses it" => "Not displayed until a user chooses it",
// "Assigned Modules" => "Assigned Modules",
// "Left Modules" => "Left Modules",
// "order" => "order",
// "parameters" => "parameters",
// "Right Modules" => "Right Modules",
// "Create new user module" => "Create new user module",
// "Edit this user module:" => "Edit this user module:",
// "Use wysiwyg editor" => "Use wysiwyg editor",
// "Use normal editor" => "Use normal editor",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Objects that can be included" => "Objects that can be included",
// "Available polls" => "Available polls",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "use poll" => "use poll",
// "Random image from" => "Random image from",
// "use gallery" => "use gallery",
// "Dynamic content blocks" => "Dynamic content blocks",
// "use dynamic  content" => "use dynamic  content",
// "use rss module" => "use rss module",
// "use menu" => "use menu",
// "phpLayersMenus" => "phpLayersMenus",
// "use phplayermenu" => "use phplayermenu",
// "Banner zones" => "Banner zones",
// "use banner zone" => "use banner zone",
// "structure" => "structure",
// "Admin newsletter subscriptions" => "Admin newsletter subscriptions",
// "list newsletters" => "list newsletters",
// "admin newsletters" => "admin newsletters",
// "send newsletters" => "send newsletters",
// "Add a subscription newsletters" => "Add a subscription newsletters",
// "Add email:" => "Add email:",
// "Add user:" => "Add user:",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "Subscriptions" => "Subscriptions",
// "subscribed" => "subscribed",
// "admin newsletters template" => "admin newsletters template",
// "Create/edit newsletters" => "Create/edit newsletters",
// "There are individual permissions set for this newsletter" => "There are individual permissions set for this newsletter",
// "Users can subscribe/unsubscribe to this list" => "Users can subscribe/unsubscribe to this list",
// "Users can subscribe any email address" => "Users can subscribe any email address",
// "Add unsubscribe instructions to each newsletter" => "Add unsubscribe instructions to each newsletter",
// "Validate email addresses" => "Validate email addresses",
// "editions" => "editions",
// "last sent" => "last sent",
// "subscriptions" => "subscriptions",
// "send newsletter" => "send newsletter",
// "archives" => "archives",
// "EMail notifications" => "EMail notifications",
// "admin Email Notifications" => "admin Email Notifications",
// "admin notifications template" => "admin notifications template",
// "Add notification" => "Add notification",
// "A user registers" => "A user registers",
// "A user submits an article" => "A user submits an article",
// "Any wiki page is changed" => "Any wiki page is changed",
// "Any wiki page is changed, even minor changes" => "Any wiki page is changed, even minor changes",
// "PHP error" => "PHP error",
// "use admin email" => "use admin email",
// "No records found." => "No records found.",
// "Admin Polls" => "Admin Polls",
// "List polls" => "List polls",
// "Edit this poll" => "Edit this poll",
// "Preview poll" => "Preview poll",
// "Edit or add poll options" => "Edit or add poll options",
// "Poll options" => "Poll options",
// "votes" => "votes",
// "admin polls" => "admin polls",
// "admin polls template" => "admin polls template",
// "configure polls" => "configure polls",
// "Set last poll as current" => "Set last poll as current",
// "Close all polls but last" => "Close all polls but last",
// "Activate all polls" => "Activate all polls",
// "Create/edit Polls" => "Create/edit Polls",
// "PublishDate" => "PublishDate",
// "Admin Quicktags" => "Admin Quicktags",
// "admin QuickTags" => "admin QuickTags",
// "tiki admin quicktags template" => "tiki admin quicktags template",
// "Create/Edit QuickTags" => "Create/Edit QuickTags",
// "label" => "label",
// "Insert (use 'text' for figuring the selection)" => "Insert (use 'text' for figuring the selection)",
// "Path to the tag icon" => "Path to the tag icon",
// "Insert" => "Insert",
// "Icon" => "Icon",
// "Admin RSS modules" => "Admin RSS modules",
// "admin RSSmodules template" => "admin RSSmodules template",
// "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed.",
// "Content for the feed" => "Content for the feed",
// "Edit this RSS module:" => "Edit this RSS module:",
// "Create new RSS module" => "Create new RSS module",
// "show feed title" => "show feed title",
// "show publish date" => "show publish date",
// "Rss channels" => "Rss channels",
// "show pubdate" => "show pubdate",
// "Score System" => "Score System",
// "security admin" => "security admin",
// "security admin tpl" => "security admin tpl",
// "edit tpl" => "edit tpl",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>.",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Setting" => "Setting",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "Tikiwiki settings" => "Tikiwiki settings",
// "Tiki variable" => "Tiki variable",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini.",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database.",
// "File checks" => "File checks",
// "State" => "State",
// "Admin Shoutbox Words" => "Admin Shoutbox Words",
// "admin shoutbox words" => "admin shoutbox words",
// "admin shoutbox words template" => "admin shoutbox words template",
// "Add Banned Word" => "Add Banned Word",
// "Are you sure you want to delete this word?" => "Are you sure you want to delete this word?",
// "admin structures template" => "admin structures template",
// "Structure ID" => "Structure ID",
// "export pages" => "export pages",
// "dump tree" => "dump tree",
// "create webhelp" => "create webhelp",
// "view webhelp" => "view webhelp",
// "Destroy the structure leaving the wiki pages" => "Destroy the structure leaving the wiki pages",
// "Destroy the structure and remove the pages" => "Destroy the structure and remove the pages",
// "Create new structure" => "Create new structure",
// "Use single spaces to indent structure levels" => "Use single spaces to indent structure levels",
// "Alias" => "Alias",
// "create new structure" => "create new structure",
// "Edit survey questions" => "Edit survey questions",
// "survey stats" => "survey stats",
// "this survey stats" => "this survey stats",
// "edit this survey" => "edit this survey",
// "admin surveys" => "admin surveys",
// "Create/edit questions for survey" => "Create/edit questions for survey",
// "Short text" => "Short text",
// "Rate (1..5)" => "Rate (1..5)",
// "Rate (1..10)" => "Rate (1..10)",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "Options (if apply)" => "Options (if apply)",
// "administer surveys template" => "administer surveys template",
// "list surveys" => "list surveys",
// "Edit this Survey:" => "Edit this Survey:",
// "Create New Survey" => "Create New Survey",
// "There are individual permissions set for this survey" => "There are individual permissions set for this survey",
// "status" => "status",
// "active perms" => "active perms",
// "system admin" => "system admin",
// "system admin tpl" => "system admin tpl",
// "If your Tiki is acting weird, 1st thing to try it to clear your cache below. Also very important to clear your cache after an upgrade (by FTP/SSH if need be)." => "If your Tiki is acting weird, 1st thing to try it to clear your cache below. Also very important to clear your cache after an upgrade (by FTP/SSH if need be).",
// "Empty" => "Empty",
// "Templates compiler" => "Templates compiler",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function!" => "Warning: Make a backup of your Database before using this function!",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Table" => "Table",
// "Field" => "Field",
// "Investigate" => "Investigate",
// "Fix it" => "Fix it",
// "admin topics template" => "admin topics template",
// "Active?" => "Active?",
// "topic image" => "topic image",
// "Remove with articles" => "Remove with articles",
// "Admin tracker" => "Admin tracker",
// "Edit this tracker" => "Edit this tracker",
// "View this tracker items" => "View this tracker items",
// "Edit tracker fields" => "Edit tracker fields",
// "Is column visible when listing tracker items?" => "Is column visible when listing tracker items?",
// "Column links to edit/view item?" => "Column links to edit/view item?",
// "Column is searchable?" => "Column is searchable?",
// "Field is public? (for use thru trackerlist plugin)" => "Field is public? (for use thru trackerlist plugin)",
// "Field is hidden?" => "Field is hidden?",
// "not hidden" => "not hidden",
// "visible by admin only" => "visible by admin only",
// "editable by admin only" => "editable by admin only",
// "Field is mandatory?" => "Field is mandatory?",
// "Tracker fields" => "Tracker fields",
// "Id" => "Id",
// "isMain" => "isMain",
// "Tbl vis" => "Tbl vis",
// "Searchable" => "Searchable",
// "Public" => "Public",
// "Hidden" => "Hidden",
// "Mandatory" => "Mandatory",
// "Import/export trackers fields" => "Import/export trackers fields",
// "admin Trackers tpl" => "admin Trackers tpl",
// "Edit fields for tracker" => "Edit fields for tracker",
// "Edit tracker" => "Edit tracker",
// "Create trackers" => "Create trackers",
// "items" => "items",
// "active permissions" => "active permissions",
// "Create/edit trackers" => "Create/edit trackers",
// "There are individual permissions set for this tracker" => "There are individual permissions set for this tracker",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL",
// "Show status" => "Show status",
// "Default status displayed in list mode" => "Default status displayed in list mode",
// "Show status to tracker admin only" => "Show status to tracker admin only",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker needs a text field named Subject" => "The tracker needs a text field named Subject",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
// "No change" => "No change",
// "Item creator can modify his items?" => "Item creator can modify his items?",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "Member of the default group of creator can modify items?" => "Member of the default group of creator can modify items?",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "Show creation date when listing tracker items?" => "Show creation date when listing tracker items?",
// "Show lastModif date when listing tracker items?" => "Show lastModif date when listing tracker items?",
// "What field is used for default sort?" => "What field is used for default sort?",
// "What is default sort order in list?" => "What is default sort order in list?",
// "ascending" => "ascending",
// "descending" => "descending",
// "Tracker items allow ratings?" => "Tracker items allow ratings?",
// "with values" => "with values",
// "and display rating results in listing?" => "and display rating results in listing?",
// "Tracker items allow comments?" => "Tracker items allow comments?",
// "and display comments in listing?" => "and display comments in listing?",
// "Tracker items allow attachments?" => "Tracker items allow attachments?",
// "and display attachments in listing?" => "and display attachments in listing?",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "downloads" => "downloads",
// "filesize" => "filesize",
// "version" => "version",
// "longdesc" => "longdesc",
// "Import/export trackers" => "Import/export trackers",
// "Import/Export CSV Data" => "Import/Export CSV Data",
// "Download CSV export" => "Download CSV export",
// "tracker_{\$trackerId}.csv" => "tracker_{\$trackerId}.csv",
// "Import file" => "Import file",
// "admin groups template" => "admin groups template",
// "Edit group" => "Edit group",
// "Add a new group" => "Add a new group",
// "List of existing groups" => "List of existing groups",
// "Number of displayed rows" => "Number of displayed rows",
// "Includes" => "Includes",
// "assign permissions" => "assign permissions",
// "Include" => "Include",
// "Group Homepage" => "Group Homepage",
// "Use wiki page name or full URL" => "Use wiki page name or full URL",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker ..." => "choose a group tracker ...",
// "choose a field ..." => "choose a field ...",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker ..." => "choose a users tracker ...",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Edit item" => "Edit item",
// "Group tracker item not found" => "Group tracker item not found",
// "Create item" => "Create item",
// "Members List" => "Members List",
// "remove from group" => "remove from group",
// "users in group" => "users in group",
// "List all members" => "List all members",
// "admin users template" => "admin users template",
// "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions",
// "Batch Upload Results" => "Batch Upload Results",
// "Added users" => "Added users",
// "Rejected users" => "Rejected users",
// "Reason" => "Reason",
// "Edit user" => "Edit user",
// "Change user preferences" => "Change user preferences",
// "edit account settings" => "edit account settings",
// "Assign Group" => "Assign Group",
// "edit included group" => "edit included group",
// "select all" => "select all",
// "Perform action with checked:" => "Perform action with checked:",
// "remove users and their userpages" => "remove users and their userpages",
// "manage group assignments" => "manage group assignments",
// "set default groups" => "set default groups",
// "Assign selected to" => "Assign selected to",
// "Remove selected from" => "Remove selected from",
// "the following groups:" => "the following groups:",
// "Tip: hold down CTRL to select multiple" => "Tip: hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "assign to groups" => "assign to groups",
// "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master",
// "Warning: changing the username will require the user to change his password" => "Warning: changing the username will require the user to change his password",
// "Pass" => "Pass",
// "Again" => "Again",
// "Registration" => "Registration",
// "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
// "Overwrite" => "Overwrite",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "Admin Article Types" => "Admin Article Types",
// "Article Types tpl" => "Article Types tpl",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
// "Rate" => "Rate",
// "Allow ratings by the author" => "Allow ratings by the author",
// "Show before publish date" => "Show before publish date",
// "non-admins can view before the publish date" => "non-admins can view before the publish date",
// "Show after expire date" => "Show after expire date",
// "non-admins can view after the expire date" => "non-admins can view after the expire date",
// "Heading only" => "Heading only",
// "No article body, heading only" => "No article body, heading only",
// "Allow comments for this type" => "Allow comments for this type",
// "Comment Can Rate Article" => "Comment Can Rate Article",
// "Allow comments to include a rating value" => "Allow comments to include a rating value",
// "Show image" => "Show image",
// "Show topic or own image" => "Show topic or own image",
// "Show avatar" => "Show avatar",
// "Show author's avatar" => "Show author's avatar",
// "Show author" => "Show author",
// "Show author name" => "Show author name",
// "Show publish date" => "Show publish date",
// "Show expire date" => "Show expire date",
// "Show reads" => "Show reads",
// "Show the number of times the article was read" => "Show the number of times the article was read",
// "Show size" => "Show size",
// "Show the size of the article" => "Show the size of the article",
// "Show topline" => "Show topline",
// "Show a small title over the title" => "Show a small title over the title",
// "Show subtitle" => "Show subtitle",
// "Show the subtitle" => "Show the subtitle",
// "Show source" => "Show source",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Image Caption" => "Show Image Caption",
// "Show a legend under the image" => "Show a legend under the image",
// "Show Language" => "Show Language",
// "Show the language" => "Show the language",
// "Creator can edit" => "Creator can edit",
// "The person who submits an article of this type can edit it" => "The person who submits an article of this type can edit it",
// "Delete this type" => "Delete this type",
// "List of types" => "List of types",
// "Show lang" => "Show lang",
// "Review" => "Review",
// "Classified" => "Classified",
// "Create a new type" => "Create a new type",
// "Assign permissions to group" => "Assign permissions to group",
// "Edit Article" => "Edit Article",
// "edit article tpl" => "edit article tpl",
// "Group Information" => "Group Information",
// "Desc" => "Desc",
// "advanced feature" => "advanced feature",
// "level configuration" => "level configuration",
// "Create level" => "Create level",
// "all permissions in level" => "all permissions in level",
// "all" => "all",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "to groups" => "to groups",
// "User Information" => "User Information",
// "Default Group" => "Default Group",
// "Available groups" => "Available groups",
// "assign perms to this group" => "assign perms to this group",
// "to" => "to",
// "backlinks to" => "backlinks to",
// "No backlinks to this page" => "No backlinks to this page",
// "admin admin tpl" => "admin admin tpl",
// "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead." => "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead.",
// "List of available backups" => "List of available backups",
// "Restoring a backup" => "Restoring a backup",
// "Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup.",
// "Click here to confirm restoring" => "Click here to confirm restoring",
// "Create new backup" => "Create new backup",
// "Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file",
// "Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP.",
// "Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP.",
// "If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP.",
// "Upload a backup" => "Upload a backup",
// "Upload backup" => "Upload backup",
// "Directory batch upload" => "Directory batch upload",
// "Browse gallery" => "Browse gallery",
// "Upload from disk" => "Upload from disk",
// "available images" => "available images",
// "width" => "width",
// "height" => "height",
// "remove file extension from image name" => "remove file extension from image name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "convert sub directories to sub galleries" => "convert sub directories to sub galleries",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created",
// "use sub directory names as description" => "use sub directory names as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created",
// "Select a Gallery" => "Select a Gallery",
// "Process" => "Process",
// "Edit Post" => "Edit Post",
// "view blog" => "view blog",
// "list blogs" => "list blogs",
// "Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. ",
// "Use ...page... to separate pages in a multi-page post" => "Use ...page... to separate pages in a multi-page post",
// "Upload image for this post" => "Upload image for this post",
// "Trash" => "Trash",
// "Mark entry as private:" => "Mark entry as private:",
// "Send trackback pings to:" => "Send trackback pings to:",
// "(comma separated list of URIs)" => "(comma separated list of URIs)",
// "save and exit" => "save and exit",
// "admin the category system" => "admin the category system",
// "admin category" => "admin category",
// "Browse in" => "Browse in",
// "Wiki pages" => "Wiki pages",
// "Image galleries" => "Image galleries",
// "Trackers Items" => "Trackers Items",
// "Sheets" => "Sheets",
// "search category" => "search category",
// "deep" => "deep",
// "Hide subcategories objects" => "Hide subcategories objects",
// "Show subcategories objects" => "Show subcategories objects",
// "Upper level" => "Upper level",
// "Objects" => "Objects",
// "Browsing Gallery" => "Browsing Gallery",
// "list galleries" => "list galleries",
// "edit gallery" => "edit gallery",
// "rebuild thumbnails" => "rebuild thumbnails",
// "upload image" => "upload image",
// "Directory batch" => "Directory batch",
// "list gallery" => "list gallery",
// "Sort Images by" => "Sort Images by",
// "subgallery" => "subgallery",
// "Subgallery" => "Subgallery",
// "hit" => "hit",
// "original size" => "original size",
// "rotate right" => "rotate right",
// "rotate" => "rotate",
// "popup" => "popup",
// "Browsing Image" => "Browsing Image",
// "return to gallery" => "return to gallery",
// "edit image" => "edit image",
// "first image" => "first image",
// "smaller" => "smaller",
// "bigger" => "bigger",
// "prev image" => "prev image",
// "Popup window" => "Popup window",
// "popup window" => "popup window",
// "next image" => "next image",
// "slideshow forward" => "slideshow forward",
// "last image" => "last image",
// "stop" => "stop",
// "Cyclic" => "Cyclic",
// "Direction" => "Direction",
// "Click to zoom" => "Click to zoom",
// "Image Name" => "Image Name",
// "Image size" => "Image size",
// "imagescale" => "imagescale",
// "Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal degrees)",
// "Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal degrees)",
// "Move image" => "Move image",
// "You can view this image in your browser using" => "You can view this image in your browser using",
// "You can include the image in an HTML page using one of these lines" => "You can include the image in an HTML page using one of these lines",
// "You can include the image in a tiki page using one of these lines" => "You can include the image in a tiki page using one of these lines",
// "add item" => "add item",
// "Edit/Create" => "Edit/Create",
// "Date Selector" => "Date Selector",
// "click to navigate" => "click to navigate",
// "Focus:" => "Focus:",
// "change focus" => "change focus",
// "quarter" => "quarter",
// "semester" => "semester",
// "calendar view" => "calendar view",
// "list view" => "list view",
// "End" => "End",
// "details" => "details",
// "h" => "h",
// "zoom" => "zoom",
// "+" => "+",
// "Group Calendars" => "Group Calendars",
// "Tools Calendars" => "Tools Calendars",
// "Duration" => "Duration",
// "Location" => "Location",
// "Organized by" => "Organized by",
// "Participants" => "Participants",
// "Tentative" => "Tentative",
// "Confirmed" => "Confirmed",
// "Cancelled" => "Cancelled",
// "Subscription List" => "Subscription List",
// "Edit Calendar Item" => "Edit Calendar Item",
// "New Calendar Item" => "New Calendar Item",
// "or create a new category" => "or create a new category",
// "or create a new location" => "or create a new location",
// "comma separated usernames" => "comma separated usernames",
// "comma separated username:role" => "comma separated username:role",
// "with roles" => "with roles",
// "Chair" => "Chair",
// "Optional" => "Optional",
// "Syntax error" => "Syntax error",
// "Format: mm/dd/yyyy hh:mm<br />..." => "Format: mm/dd/yyyy hh:mm<br />...",
// "See strtotime php function" => "See strtotime php function",
// "Format: mm/dd/yyy hh:mm<br />..." => "Format: mm/dd/yyy hh:mm<br />...",
// "duplicate" => "duplicate",
// "save_to" => "save_to",
// "close" => "close",
// "click to view" => "click to view",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "CSV File" => "CSV File",
// "import" => "import",
// "Assign permissions to category" => "Assign permissions to category",
// "Current permissions for this category" => "Current permissions for this category",
// "permission" => "permission",
// "remove from this category &amp; all its children" => "remove from this category &amp; all its children",
// "remove from this category only" => "remove from this category only",
// "No individual permissions global permissions apply" => "No individual permissions global permissions apply",
// "Assign permissions" => "Assign permissions",
// "to group" => "to group",
// "this category &amp; all its children" => "this category &amp; all its children",
// "this category only" => "this category only",
// "Assigning permissions for <b>all children</b> is recommended for best performance." => "Assigning permissions for <b>all children</b> is recommended for best performance.",
// "Change password enforced" => "Change password enforced",
// "Old password" => "Old password",
// "Again please" => "Again please",
// "Welcome to the Tiki Chat Rooms" => "Welcome to the Tiki Chat Rooms",
// "Please select a chat channel" => "Please select a chat channel",
// "Nickname" => "Nickname",
// "enter chat room" => "enter chat room",
// "There are no channels setup, please contact a site admin" => "There are no channels setup, please contact a site admin",
// "Chatroom" => "Chatroom",
// "Browser not supported" => "Browser not supported",
// "Active Channels" => "Active Channels",
// "Users in this channel" => "Users in this channel",
// "Channel Information" => "Channel Information",
// "Channel" => "Channel",
// "Ratio" => "Ratio",
// "Use :nickname:message for private messages" => "Use :nickname:message for private messages",
// "Use [URL|description] or [URL] for links" => "Use [URL|description] or [URL] for links",
// "Use (:smileyname:) for smileys" => "Use (:smileyname:) for smileys",
// "Create PDF" => "Create PDF",
// "PDF Settings" => "PDF Settings",
// "Font" => "Font",
// "Textheight" => "Textheight",
// "Height of top Heading" => "Height of top Heading",
// "Height of mid Heading" => "Height of mid Heading",
// "Height of inner Heading" => "Height of inner Heading",
// "tbheight" => "tbheight",
// "Automatic Page Breaks" => "Automatic Page Breaks",
// "Select Wiki Pages" => "Select Wiki Pages",
// "add page" => "add page",
// "remove page" => "remove page",
// "reset" => "reset",
// "Send a message to us" => "Send a message to us",
// "Contact us by email" => "Contact us by email",
// "click here to send us an email" => "click here to send us an email",
// "Create WebHelp" => "Create WebHelp",
// "You can browse the generated WebHelp here" => "You can browse the generated WebHelp here",
// "Structure" => "Structure",
// "Top page" => "Top page",
// "Tiki Debugger Console" => "Tiki Debugger Console",
// "Close" => "Close",
// "Current URL" => "Current URL",
// "Command" => "Command",
// "exec" => "exec",
// "Type <code>help</code> to get list of available commands" => "Type <code>help</code> to get list of available commands",
// "Add a new site" => "Add a new site",
// "You cannot add sites until Directory Categories are setup." => "You cannot add sites until Directory Categories are setup.",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "Site added" => "Site added",
// "The following site was added and validation by admin may be needed before appearing on the lists" => "The following site was added and validation by admin may be needed before appearing on the lists",
// "Add or edit a site" => "Add or edit a site",
// "Name:" => "Name:",
// "URL:" => "URL:",
// "Categories:" => "Categories:",
// "Is valid" => "Is valid",
// "Directory Administration" => "Directory Administration",
// "admin directory tpl" => "admin directory tpl",
// "Statistics" => "Statistics",
// "There are" => "There are",
// "invalid sites" => "invalid sites",
// "valid sites" => "valid sites",
// "Users have visited" => "Users have visited",
// "sites from the directory" => "sites from the directory",
// "Users have searched" => "Users have searched",
// "times from the directory" => "times from the directory",
// "Admin sites" => "Admin sites",
// "Admin category relationships" => "Admin category relationships",
// "Validate links" => "Validate links",
// "browse" => "browse",
// "related" => "related",
// "sites" => "sites",
// "validate" => "validate",
// "Admin directory categories" => "Admin directory categories",
// "admin directory categories tpl" => "admin directory categories tpl",
// "Parent category" => "Parent category",
// "Add a directory category" => "Add a directory category",
// "Edit this directory category" => "Edit this directory category",
// "Children type" => "Children type",
// "Most visited sub-categories" => "Most visited sub-categories",
// "Category description" => "Category description",
// "Random sub-categories" => "Random sub-categories",
// "Maximum number of children to show" => "Maximum number of children to show",
// "Allow sites in this category" => "Allow sites in this category",
// "Show number of sites in this category" => "Show number of sites in this category",
// "Editor group" => "Editor group",
// "Subcategories" => "Subcategories",
// "cType" => "cType",
// "allow" => "allow",
// "count" => "count",
// "editor" => "editor",
// "relate" => "relate",
// "Admin related categories" => "Admin related categories",
// "Admin Directory Related " => "Admin Directory Related ",
// "directory admin related tpl" => "directory admin related tpl",
// "Add a related category" => "Add a related category",
// "Mutual" => "Mutual",
// "Related categories" => "Related categories",
// "Admin Directory Sites" => "Admin Directory Sites",
// "Admin Directory Sites tpl" => "Admin Directory Sites tpl",
// "country" => "country",
// "new sites" => "new sites",
// "cool sites" => "cool sites",
// "add a site" => "add a site",
// "add a category" => "add a category",
// "any" => "any",
// "in entire directory" => "in entire directory",
// "in current category" => "in current category",
// "search" => "search",
// "Sort by" => "Sort by",
// "name (desc)" => "name (desc)",
// "name (asc)" => "name (asc)",
// "hits (desc)" => "hits (desc)",
// "hits (asc)" => "hits (asc)",
// "creation date (desc)" => "creation date (desc)",
// "creation date (asc)" => "creation date (asc)",
// "last updated (desc)" => "last updated (desc)",
// "last updated (asc)" => "last updated (asc)",
// "sort" => "sort",
// "Added" => "Added",
// "Last updated" => "Last updated",
// "Total categories" => "Total categories",
// "Total links" => "Total links",
// "Links to validate" => "Links to validate",
// "Searches performed" => "Searches performed",
// "Total links visited" => "Total links visited",
// "Directory ranking" => "Directory ranking",
// "Search results" => "Search results",
// "Validate sites" => "Validate sites",
// "Validate Sites" => "Validate Sites",
// "directory validate sites tpl" => "directory validate sites tpl",
// "Topline" => "Topline",
// "Subtitle" => "Subtitle",
// "Source" => "Source",
// "Own Image" => "Own Image",
// "Use own image" => "Use own image",
// "Float text around image" => "Float text around image",
// "Own image size x" => "Own image size x",
// "pixels" => "pixels",
// "Own image size y" => "Own image size y",
// "Image caption" => "Image caption",
// "Heading" => "Heading",
// "Body" => "Body",
// "Use ...page... to separate pages in a multi-page article" => "Use ...page... to separate pages in a multi-page article",
// "Expiration Date" => "Expiration Date",
// "Edit or create banners" => "Edit or create banners",
// "List banners" => "List banners",
// "URL to link the banner" => "URL to link the banner",
// "Client" => "Client",
// "Max impressions" => "Max impressions",
// "create zone" => "create zone",
// "Show the banner only between these dates" => "Show the banner only between these dates",
// "From date" => "From date",
// "To date" => "To date",
// "Use dates" => "Use dates",
// "Show the banner only in this hours" => "Show the banner only in this hours",
// "Show the banner only on" => "Show the banner only on",
// "Select ONE method for the banner" => "Select ONE method for the banner",
// "Use HTML" => "Use HTML",
// "HTML code" => "HTML code",
// "Use image" => "Use image",
// "Image:" => "Image:",
// "Current Image" => "Current Image",
// "Use image generated by URL (the image will be requested at the URL for each impression)" => "Use image generated by URL (the image will be requested at the URL for each impression)",
// "Use text" => "Use text",
// "Text" => "Text",
// "save the banner" => "save the banner",
// "Remove Zones (you lose entered info for the banner)" => "Remove Zones (you lose entered info for the banner)",
// "Edit Blog" => "Edit Blog",
// "Create Blog" => "Create Blog",
// "edit blog tpl" => "edit blog tpl",
// "Current heading" => "Current heading",
// "There are individual permissions set for this blog" => "There are individual permissions set for this blog",
// "Number of posts to show" => "Number of posts to show",
// "Allow other user to post in this blog" => "Allow other user to post in this blog",
// "Use titles in blog posts" => "Use titles in blog posts",
// "Allow search" => "Allow search",
// "Allow comments" => "Allow comments",
// "Allow trackback pings" => "Allow trackback pings",
// "Show user avatar" => "Show user avatar",
// "Blog heading" => "Blog heading",
// "Edit Style Sheet" => "Edit Style Sheet",
// "Style Sheet" => "Style Sheet",
// "Cancel" => "Cancel",
// "choose a stylesheet" => "choose a stylesheet",
// "try" => "try",
// "display" => "display",
// "File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model.",
// "Show Plugins Help" => "Show Plugins Help",
// "For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>",
// "Bold text" => "Bold text",
// "underscores" => "underscores",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Centered text" => "Centered text",
// "colons" => "colons",
// "some text" => "some text",
// "Underlined text" => "Underlined text",
// "equals" => "equals",
// "Text box" => "Text box",
// "One carat" => "One carat",
// "Creates a box with the data" => "Creates a box with the data",
// "Box content" => "Box content",
// "Title bar" => "Title bar",
// "creates a title bar" => "creates a title bar",
// "Colored text" => "Colored text",
// "Will display using the indicated HTML color or color name" => "Will display using the indicated HTML color or color name",
// "Lists" => "Lists",
// "for bullet lists" => "for bullet lists",
// "for numbered lists" => "for numbered lists",
// "for definiton lists" => "for definiton lists",
// "Headings" => "Headings",
// "make headings" => "make headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "Wiki References" => "Wiki References",
// "JoinCapitalizedWords or use" => "JoinCapitalizedWords or use",
// "page|desc" => "page|desc",
// "for wiki references" => "for wiki references",
// "SomeName" => "SomeName",
// "prevents referencing" => "prevents referencing",
// "External links" => "External links",
// "use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!).",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "Tables" => "Tables",
// "row" => "row",
// "col" => "col",
// "creates a table" => "creates a table",
// "displays an image" => "displays an image",
// "height width desc link and align are optional" => "height width desc link and align are optional",
// "Non cacheable images" => "Non cacheable images",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "Horizontal rule" => "Horizontal rule",
// "makes a horizontal rule" => "makes a horizontal rule",
// "creates the editable drawing foo" => "creates the editable drawing foo",
// "Multi-page pages" => "Multi-page pages",
// "to separate pages" => "to separate pages",
// "Wiki File Attachments" => "Wiki File Attachments",
// "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated.",
// "RSS feeds" => "RSS feeds",
// "displays rss feed with id=n maximum=m items" => "displays rss feed with id=n maximum=m items",
// "Will be replaced by the actual value of the dynamic content block with id=n" => "Will be replaced by the actual value of the dynamic content block with id=n",
// "Dynamic variables" => "Dynamic variables",
// "Inserts an editable variable" => "Inserts an editable variable",
// "Non parsed sections" => "Non parsed sections",
// "Prevents wiki parsing of the enclosed data." => "Prevents wiki parsing of the enclosed data.",
// "Preformated sections" => "Preformated sections",
// "Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).",
// "Square Brackets" => "Square Brackets",
// "Use [[foo] to show [foo]." => "Use [[foo] to show [foo].",
// "Block Preformatting" => "Block Preformatting",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that.",
// "Table of contents" => "Table of contents",
// "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Misc" => "Misc",
// "Show Text Formatting Rules" => "Show Text Formatting Rules",
// "No description available" => "No description available",
// "Quicktags" => "Quicktags",
// "bold" => "bold",
// "italic" => "italic",
// "underline" => "underline",
// "table" => "table",
// "table new" => "table new",
// "external link" => "external link",
// "wiki link'" => "wiki link'",
// "heading1" => "heading1",
// "title bar" => "title bar",
// "box" => "box",
// "rss feed" => "rss feed",
// "dynamic content" => "dynamic content",
// "tagline" => "tagline",
// "hr" => "hr",
// "center text" => "center text",
// "colored text" => "colored text",
// "dynamic variable" => "dynamic variable",
// "New wms Metadata" => "New wms Metadata",
// "New Class" => "New Class",
// "New Projection" => "New Projection",
// "New Query" => "New Query",
// "New Scalebar" => "New Scalebar",
// "New Layer" => "New Layer",
// "New Label" => "New Label",
// "New Reference" => "New Reference",
// "New Legend" => "New Legend",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
// "New Mapfile" => "New Mapfile",
// "special chars" => "special chars",
// "special characters" => "special characters",
// "admin quicktags" => "admin quicktags",
// "Edit Image" => "Edit Image",
// "browse image" => "browse image",
// "Edit successful!" => "Edit successful!",
// "The following image was successfully edited" => "The following image was successfully edited",
// "Image Description" => "Image Description",
// "Edit and create Languages" => "Edit and create Languages",
// "Im- Export Languages" => "Im- Export Languages",
// "Edit and create languages" => "Edit and create languages",
// "Create Language" => "Create Language",
// "Shortname" => "Shortname",
// "like" => "like",
// "Longname" => "Longname",
// "Select the language to edit" => "Select the language to edit",
// "Add a translation" => "Add a translation",
// "Edit translations" => "Edit translations",
// "Translate recorded" => "Translate recorded",
// "Original" => "Original",
// "reset table" => "reset table",
// "Program dynamic content for block" => "Program dynamic content for block",
// "create new block" => "create new block",
// "Return to block listing" => "Return to block listing",
// "Block description: " => "Block description: ",
// "Create or edit content" => "Create or edit content",
// "You are editing block:" => "You are editing block:",
// "Publishing date" => "Publishing date",
// "Publishing Date" => "Publishing Date",
// "Edit question options" => "Edit question options",
// "list quizzes" => "list quizzes",
// "quiz stats" => "quiz stats",
// "this quiz stats" => "this quiz stats",
// "edit this quiz" => "edit this quiz",
// "admin quizzes" => "admin quizzes",
// "Create/edit options for question" => "Create/edit options for question",
// "points" => "points",
// "Admin quizzes" => "Admin quizzes",
// "admin quizzes tpl" => "admin quizzes tpl",
// "Create/edit quizzes" => "Create/edit quizzes",
// "There are individual permissions set for this quiz" => "There are individual permissions set for this quiz",
// "Quiz can be repeated" => "Quiz can be repeated",
// "Store quiz results" => "Store quiz results",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Questions per page" => "Questions per page",
// "Quiz is time limited" => "Quiz is time limited",
// "Maximum time" => "Maximum time",
// "Passing Percentage" => "Passing Percentage",
// "%" => "%",
// "canRepeat" => "canRepeat",
// "timeLimit" => "timeLimit",
// "results" => "results",
// "Edit quiz questions" => "Edit quiz questions",
// "edit quiz questions" => "edit quiz questions",
// "edit quiz questions tpl" => "edit quiz questions tpl",
// "Create/edit questions for quiz" => "Create/edit questions for quiz",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character.",
// "Input" => "Input",
// "maxScore" => "maxScore",
// "From Points" => "From Points",
// "To Points" => "To Points",
// "Answer" => "Answer",
// "Results" => "Results",
// "answer" => "answer",
// "Modify Structure" => "Modify Structure",
// "You will remove" => "You will remove",
// "and its subpages from the structure, now you have two options:" => "and its subpages from the structure, now you have two options:",
// "Remove only from structure" => "Remove only from structure",
// "Remove from structure and remove page too" => "Remove from structure and remove page too",
// "Current Node" => "Current Node",
// "Page alias" => "Page alias",
// "Promote" => "Promote",
// "Previous" => "Previous",
// "Demote" => "Demote",
// "Add pages to current node" => "Add pages to current node",
// "After page" => "After page",
// "create page" => "create page",
// "Use pre-existing page" => "Use pre-existing page",
// "Structure Layout" => "Structure Layout",
// "Help on Articles" => "Help on Articles",
// "edit submissions tpl" => "edit submissions tpl",
// "list submissions" => "list submissions",
// "<b>*</b>=optional" => "<b>*</b>=optional",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "EditTemplates" => "EditTemplates",
// "EditTemplates tpl" => "EditTemplates tpl",
// "Template listing" => "Template listing",
// "Available templates" => "Available templates",
// "Template" => "Template",
// "save only in the theme:" => "save only in the theme:",
// "Delete the copy in the theme:" => "Delete the copy in the theme:",
// "Edit a topic" => "Edit a topic",
// "Edit Translation:" => "Edit Translation:",
// "edit translations" => "edit translations",
// "edit translations template" => "edit translations template",
// "View" => "View",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "Use this section to set the language of the version you are currently working on." => "Use this section to set the language of the version you are currently working on.",
// "Set of Translations" => "Set of Translations",
// "detach" => "detach",
// "add to the set" => "add to the set",
// "Select the article for which the current article is the translation." => "Select the article for which the current article is the translation.",
// "Translation of:" => "Translation of:",
// "Enter the name of the page for which the current page is the translation." => "Enter the name of the page for which the current page is the translation.",
// "Use rating" => "Use rating",
// "disable" => "disable",
// "There is no available poll template." => "There is no available poll template.",
// "You should ask an admin to create them." => "You should ask an admin to create them.",
// "an existing poll" => "an existing poll",
// "Search " => "Search ",
// "Case Insensitivity" => "Case Insensitivity",
// "replace" => "replace",
// "Try to convert HTML to wiki" => "Try to convert HTML to wiki",
// "Admin ephemerides" => "Admin ephemerides",
// "admin Ephemerides tpl" => "admin Ephemerides tpl",
// "All ephemerides" => "All ephemerides",
// "approve" => "approve",
// "No suggested questions" => "No suggested questions",
// "File Galleries tpl" => "File Galleries tpl",
// "configure listing" => "configure listing",
// "Create a file gallery" => "Create a file gallery",
// "Edit this file gallery:" => "Edit this file gallery:",
// "There are individual permissions set for this file gallery" => "There are individual permissions set for this file gallery",
// "Gallery is visible to non-admin users?" => "Gallery is visible to non-admin users?",
// "Listing configuration" => "Listing configuration",
// "id" => "id",
// "Name-filename" => "Name-filename",
// "Filename only" => "Filename only",
// "Max description display size" => "Max description display size",
// "Max Rows per page" => "Max Rows per page",
// "Other users can upload files to this gallery" => "Other users can upload files to this gallery",
// "You can access the file gallery using the following URL" => "You can access the file gallery using the following URL",
// "Message queue for" => "Message queue for",
// "back to forum" => "back to forum",
// "Edit queued message" => "Edit queued message",
// "make this a thread of" => "make this a thread of",
// "None, this is a thread message" => "None, this is a thread message",
// "announce" => "announce",
// "sticky" => "sticky",
// "no feeling" => "no feeling",
// "frown" => "frown",
// "exclaim" => "exclaim",
// "idea" => "idea",
// "mad" => "mad",
// "neutral" => "neutral",
// "sad" => "sad",
// "happy" => "happy",
// "wink" => "wink",
// "save and approve" => "save and approve",
// "convert to topic" => "convert to topic",
// "List of messages" => "List of messages",
// "new topic" => "new topic",
// "no summary" => "no summary",
// "No messages queued yet" => "No messages queued yet",
// "configure forum" => "configure forum",
// "Reported messages for" => "Reported messages for",
// "Reported by" => "Reported by",
// "friends tpl" => "friends tpl",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "accept" => "accept",
// "refuse" => "refuse",
// "Waiting requests" => "Waiting requests",
// "Your friends" => "Your friends",
// "break friendship" => "break friendship",
// "Activity completed" => "Activity completed",
// "Admin process activities" => "Admin process activities",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Add or edit an activity" => "Add or edit an activity",
// "start" => "start",
// "end" => "end",
// "split" => "split",
// "join" => "join",
// "standalone" => "standalone",
// "interactive" => "interactive",
// "auto routed" => "auto routed",
// "Expiration Time" => "Expiration Time",
// "Years" => "Years",
// "Months" => "Months",
// "Days" => "Days",
// "Minutes" => "Minutes",
// "Add transitions" => "Add transitions",
// "Add transition from:" => "Add transition from:",
// "Add transition to:" => "Add transition to:",
// "roles" => "roles",
// "No roles associated to this activity" => "No roles associated to this activity",
// "Add role" => "Add role",
// "add new" => "add new",
// "add role" => "add role",
// "Process activities" => "Process activities",
// "Int" => "Int",
// "Routing" => "Routing",
// "Interactive" => "Interactive",
// "Automatic" => "Automatic",
// "Auto routed" => "Auto routed",
// "Manual" => "Manual",
// "#" => "#",
// "inter" => "inter",
// "route" => "route",
// "(no roles)" => "(no roles)",
// "No activities defined yet" => "No activities defined yet",
// "Process Transitions" => "Process Transitions",
// "List of transitions" => "List of transitions",
// "Origin" => "Origin",
// "No transitions defined yet" => "No transitions defined yet",
// "Add a transition" => "Add a transition",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "This process is invalid" => "This process is invalid",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed.",
// "List of processes" => "List of processes",
// "Inactive" => "Inactive",
// "act" => "act",
// "val" => "val",
// "active process" => "active process",
// "invalid" => "invalid",
// "invalid process" => "invalid process",
// "valid process" => "valid process",
// "activities" => "activities",
// "graph" => "graph",
// "new minor" => "new minor",
// "new major" => "new major",
// "No processes defined yet" => "No processes defined yet",
// "Admin instance" => "Admin instance",
// "Process:" => "Process:",
// "Instance" => "Instance",
// "Workitems" => "Workitems",
// "Send all to" => "Send all to",
// "Don't move" => "Don't move",
// "Started" => "Started",
// "Act status" => "Act status",
// "Ended" => "Ended",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "run instance" => "run instance",
// "Executed" => "Executed",
// "Pop-up" => "Pop-up",
// "erase" => "erase",
// "Galaxia Admin Processes" => "Galaxia Admin Processes",
// "Galaxia Admin Processes tpl" => "Galaxia Admin Processes tpl",
// "Add or edit a process" => "Add or edit a process",
// "Process Name" => "Process Name",
// "ver:" => "ver:",
// "is active?" => "is active?",
// "Or upload a process using this form" => "Or upload a process using this form",
// "Admin process roles" => "Admin process roles",
// "Add or edit a role" => "Add or edit a role",
// "Process roles" => "Process roles",
// "No roles defined yet" => "No roles defined yet",
// "Map users to roles" => "Map users to roles",
// "Map" => "Map",
// "Roles" => "Roles",
// "map" => "map",
// "Map groups to roles" => "Map groups to roles",
// "Operation" => "Operation",
// "Warning" => "Warning",
// "No roles are defined yet so no roles can be mapped" => "No roles are defined yet so no roles can be mapped",
// "List of mappings" => "List of mappings",
// "No mappings defined yet" => "No mappings defined yet",
// "Admin process sources" => "Admin process sources",
// "select source" => "select source",
// "Shared code" => "Shared code",
// "Set next user" => "Set next user",
// "Get property" => "Get property",
// "Set property" => "Set property",
// "Complete" => "Complete",
// "Process form" => "Process form",
// "Set Next act" => "Set Next act",
// "If:SetNextact" => "If:SetNextact",
// "Switch construct" => "Switch construct",
// "Map process roles" => "Map process roles",
// "admin processes" => "admin processes",
// "admin activities" => "admin activities",
// "admin roles" => "admin roles",
// "edit this process" => "edit this process",
// "Galaxia Monitor Activities" => "Galaxia Monitor Activities",
// "Galaxia Monitor Activities tpl" => "Galaxia Monitor Activities tpl",
// "List of activities" => "List of activities",
// "proc" => "proc",
// "auto" => "auto",
// "int" => "int",
// "routing" => "routing",
// "Instances" => "Instances",
// "run" => "run",
// "run activity" => "run activity",
// "Enter the name of this instance" => "Enter the name of this instance",
// "The name is not valid. Please, enter the name again" => "The name is not valid. Please, enter the name again",
// "monitor" => "monitor",
// "monitor processes" => "monitor processes",
// "monitor activities" => "monitor activities",
// "monitor instances" => "monitor instances",
// "monitor workitems" => "monitor workitems",
// "Galaxia Monitor Instances" => "Galaxia Monitor Instances",
// "Galaxia Monitor Instances tpl" => "Galaxia Monitor Instances tpl",
// "List of instances" => "List of instances",
// "Not ended" => "Not ended",
// "No instances created yet" => "No instances created yet",
// "Galaxia Monitor Processes" => "Galaxia Monitor Processes",
// "Galaxia Monitor Processes tpl" => "Galaxia Monitor Processes tpl",
// "Valid" => "Valid",
// "Invalid" => "Invalid",
// "processes" => "processes",
// "being run" => "being run",
// "exceptions" => "exceptions",
// "Monitor workitems" => "Monitor workitems",
// "List of workitems" => "List of workitems",
// "instance" => "instance",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "My activities" => "My activities",
// "Current Activity" => "Current Activity",
// "Assigned To" => "Assigned To",
// "exception instance" => "exception instance",
// "exceptions instance" => "exceptions instance",
// "send instance" => "send instance",
// "abort instance" => "abort instance",
// "grab instance" => "grab instance",
// "release instance" => "release instance",
// "No activities found" => "No activities found",
// "My instances" => "My instances",
// "No instances found" => "No instances found",
// "activate" => "activate",
// "User Activities" => "User Activities",
// "Galaxia User Activities" => "Galaxia User Activities",
// "Galaxia User Activities tpl" => "Galaxia User Activities tpl",
// "process" => "process",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "user processes" => "user processes",
// "user activities" => "user activities",
// "user instances" => "user instances",
// "Galaxia User Instances" => "Galaxia User Instances",
// "Galaxia User Instances tpl" => "Galaxia User Instances tpl",
// "Inst Status" => "Inst Status",
// "Not defined" => "Not defined",
// "No instances defined yet" => "No instances defined yet",
// "Galaxia User Processes" => "Galaxia User Processes",
// "Galaxia User Processes tpl" => "Galaxia User Processes tpl",
// "Browsing Workitem" => "Browsing Workitem",
// "Workitem information" => "Workitem information",
// "galleries tpl" => "galleries tpl",
// "rebuild cache" => "rebuild cache",
// "Create a gallery" => "Create a gallery",
// "Edit this gallery:" => "Edit this gallery:",
// "There are individual permissions set for this gallery" => "There are individual permissions set for this gallery",
// "Geographic" => "Geographic",
// "Images per row" => "Images per row",
// "Thumbnails size X" => "Thumbnails size X",
// "Thumbnails size Y" => "Thumbnails size Y",
// "Default sort order" => "Default sort order",
// "Fields to show during browsing the gallery" => "Fields to show during browsing the gallery",
// "Image ID" => "Image ID",
// "Creation Date" => "Creation Date",
// "XY-Size" => "XY-Size",
// "Filesize" => "Filesize",
// "Gallery Image" => "Gallery Image",
// "Parent gallery" => "Parent gallery",
// "Available scales" => "Available scales",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "No scales available" => "No scales available",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "Owner of the gallery" => "Owner of the gallery",
// "Other users can upload images to this gallery" => "Other users can upload images to this gallery",
// "You can access the gallery using the following URL" => "You can access the gallery using the following URL",
// "Choose a filter" => "Choose a filter",
// "Make Map" => "Make Map",
// "Save clicked point" => "Save clicked point",
// "Save current view as default" => "Save current view as default",
// "Reset view to site-wide default" => "Reset view to site-wide default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal" => "Horizontal",
// "Vertical" => "Vertical",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Left" => "Left",
// "Right" => "Right",
// "Series" => "Series",
// "Im- Export languages" => "Im- Export languages",
// "Select the language to Import" => "Select the language to Import",
// "Select the language to Export" => "Select the language to Export",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "ImportingPagesPhpWikiPageAdmin" => "ImportingPagesPhpWikiPageAdmin",
// "tiki-import_phpwiki tpl" => "tiki-import_phpwiki tpl",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "Overwrite existing pages if the name is the same" => "Overwrite existing pages if the name is the same",
// "Previously remove existing page versions" => "Previously remove existing page versions",
// "excerpt" => "excerpt",
// "result" => "result",
// "body" => "body",
// "Tiki installer" => "Tiki installer",
// "MultiTiki setup" => "MultiTiki setup",
// "To add a new virtual host" => "To add a new virtual host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "reload" => "reload",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "Please enter your database connection info" => "Please enter your database connection info",
// "Database type" => "Database type",
// "The type of database you intend to use" => "The type of database you intend to use",
// "Host:" => "Host:",
// "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki" => "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki",
// "If you use SQLite, insert the path and filename to your database file" => "If you use SQLite, insert the path and filename to your database file",
// "Database user" => "Database user",
// "Database password" => "Database password",
// "Database name" => "Database name",
// "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names" => "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names",
// "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above" => "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above",
// "Welcome to the installation &amp; upgrade script!" => "Welcome to the installation &amp; upgrade script!",
// "Install" => "Install",
// "Create database (clean install) with profile" => "Create database (clean install) with profile",
// "Descriptions of the available profiles" => "Descriptions of the available profiles",
// "Upgrade" => "Upgrade",
// "backup your database" => "backup your database",
// "with mysqldump or phpmyadmin before you proceed" => "with mysqldump or phpmyadmin before you proceed",
// "Update database using script" => "Update database using script",
// "For database update from 1.8 or later" => "For database update from 1.8 or later",
// "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script" => "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script",
// "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)" => "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)",
// "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions" => "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions",
// "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity" => "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity",
// "Do nothing and enter Tiki" => "Do nothing and enter Tiki",
// "Reset database connection settings" => "Reset database connection settings",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please enter your admin password to continue" => "Please enter your admin password to continue",
// "Print operations executed successfully" => "Print operations executed successfully",
// "Print operations failed" => "Print operations failed",
// "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application" => "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application",
// "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore" => "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore",
// "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!" => "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!",
// "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!" => "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!",
// "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at only 8 Megs" => "Tiki has detected your PHP memory limit at only 8 Megs",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Note" => "Note",
// "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation" => "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation",
// "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system" => "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system",
// "Now you may proceed by clicking one of these links" => "Now you may proceed by clicking one of these links",
// "Click here to disable the install script and proceed into tiki" => "Click here to disable the install script and proceed into tiki",
// "Click here to proceed into tiki without disabling the script" => "Click here to proceed into tiki without disabling the script",
// "Go back and run another install/upgrade script" => "Go back and run another install/upgrade script",
// "do not use your Back button in your browser!" => "do not use your Back button in your browser!",
// "Clear cached version and refresh cache" => "Clear cached version and refresh cache",
// "configure rules" => "configure rules",
// "edit repository" => "edit repository",
// "Weeks" => "Weeks",
// "Search by Date" => "Search by Date",
// "Found" => "Found",
// "LastChanges" => "LastChanges",
// "hist" => "hist",
// "v" => "v",
// "rollback" => "rollback",
// "source" => "source",
// "No pages found" => "No pages found",
// "list articles tpl" => "list articles tpl",
// "edit new article" => "edit new article",
// "ExpireDate" => "ExpireDate",
// "AuthorName" => "AuthorName",
// "admin Banners" => "admin Banners",
// "admin Banners tpl" => "admin Banners tpl",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone.",
// "Create banner" => "Create banner",
// "Method" => "Method",
// "Use Dates?" => "Use Dates?",
// "Max Impressions" => "Max Impressions",
// "Impressions" => "Impressions",
// "Clicks" => "Clicks",
// "create new blog" => "create new blog",
// "Last Modified" => "Last Modified",
// "admin cache" => "admin cache",
// "admin cache tpl" => "admin cache tpl",
// "Dynamic content system" => "Dynamic content system",
// "Help on Dynamic Content" => "Help on Dynamic Content",
// "admin DynamicContent tpl" => "admin DynamicContent tpl",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block.",
// "Create or edit content block" => "Create or edit content block",
// "Available content blocks" => "Available content blocks",
// "Current ver" => "Current ver",
// "Next ver" => "Next ver",
// "Future vers" => "Future vers",
// "Old vers" => "Old vers",
// "Program" => "Program",
// "list faqs tpl" => "list faqs tpl",
// "Edit this FAQ:" => "Edit this FAQ:",
// "Create New FAQ:" => "Create New FAQ:",
// "Users can suggest questions" => "Users can suggest questions",
// "Available FAQs" => "Available FAQs",
// "Listing Gallery" => "Listing Gallery",
// "upload file" => "upload file",
// "Edit a file using this form" => "Edit a file using this form",
// "monitor this gallery" => "monitor this gallery",
// "stop monitoring this gallery" => "stop monitoring this gallery",
// "Gallery Files" => "Gallery Files",
// "move selected files" => "move selected files",
// "delete selected files" => "delete selected files",
// "Move to" => "Move to",
// "Dls" => "Dls",
// "browse gallery" => "browse gallery",
// "Gallery Images" => "Gallery Images",
// "games tpl" => "games tpl",
// "/" => "/",
// "All games are from" => "All games are from",
// "visit the site for more games and fun" => "visit the site for more games and fun",
// "Upload a game" => "Upload a game",
// "Upload a new game" => "Upload a new game",
// "Flash binary (.sqf or .dcr)" => "Flash binary (.sqf or .dcr)",
// "Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)",
// "Edit game" => "Edit game",
// "Played" => "Played",
// "times" => "times",
// "If you can't see the game then you need a flash plugin for your browser" => "If you can't see the game then you need a flash plugin for your browser",
// "list posts tpl" => "list posts tpl",
// "edit blog" => "edit blog",
// "Blog Title" => "Blog Title",
// "list quizzes tpl" => "list quizzes tpl",
// "edit new submission" => "edit new submission",
// "Approve" => "Approve",
// "edit quiz stats tpl" => "edit quiz stats tpl",
// "Survey stats" => "Survey stats",
// "actions" => "actions",
// "take survey" => "take survey",
// "adm" => "adm",
// "list trackers tpl" => "list trackers tpl",
// "users registered" => "users registered",
// "Distance (km)" => "Distance (km)",
// "List Movies" => "List Movies",
// "Choose a movie" => "Choose a movie",
// "Display" => "Display",
// "Last mod" => "Last mod",
// "Last author" => "Last author",
// "Last ver" => "Last ver",
// "Com" => "Com",
// "Vers" => "Vers",
// "with checked" => "with checked",
// "admin live support tpl" => "admin live support tpl",
// "Open client window" => "Open client window",
// "Generate HTML" => "Generate HTML",
// "Transcripts" => "Transcripts",
// "Support tickets" => "Support tickets",
// "Online operators" => "Online operators",
// "Operator" => "Operator",
// "Accepted requests" => "Accepted requests",
// "transcripts" => "transcripts",
// "Offline operators" => "Offline operators",
// "Add an operator to the system" => "Add an operator to the system",
// "Operators must be tiki users" => "Operators must be tiki users",
// "set as operator" => "set as operator",
// "Chat started" => "Chat started",
// "User:" => "User:",
// "Operator:" => "Operator:",
// "Live support:User window" => "Live support:User window",
// "Request live support" => "Request live support",
// "Request support" => "Request support",
// "Open a support ticket instead" => "Open a support ticket instead",
// "Your request is being processed" => "Your request is being processed",
// "cancel request and exit" => "cancel request and exit",
// "cancel request and leave a message" => "cancel request and leave a message",
// "Live support:Console" => "Live support:Console",
// "be online" => "be online",
// "be offline" => "be offline",
// "Support requests" => "Support requests",
// "Requested" => "Requested",
// "Accept" => "Accept",
// "Join" => "Join",
// "Support chat transcripts" => "Support chat transcripts",
// "back to admin" => "back to admin",
// "operator" => "operator",
// "started" => "started",
// "reason" => "reason",
// "msgs" => "msgs",
// "Transcript" => "Transcript",
// "Mail-in feature" => "Mail-in feature",
// "User Calendar" => "User Calendar",
// "User Calendar Doc tpl" => "User Calendar Doc tpl",
// "Remove old events" => "Remove old events",
// "duration" => "duration",
// "Add or edit event" => "Add or edit event",
// "Mini Calendar: Preferences" => "Mini Calendar: Preferences",
// "User Calendar Doc" => "User Calendar Doc",
// "User Calendar Preferences Doc tpl" => "User Calendar Preferences Doc tpl",
// "Calendar Interval in daily view" => "Calendar Interval in daily view",
// "Start hour for days" => "Start hour for days",
// "End hour for days" => "End hour for days",
// "Reminders" => "Reminders",
// "no reminders" => "no reminders",
// "Import CSV file" => "Import CSV file",
// "Or enter path or URL" => "Or enter path or URL",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>.",
// "Tikiwiki Mods" => "Tikiwiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example)." => "Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example).",
// "To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\")." => "To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\").",
// "all types" => "all types",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "install" => "install",
// "Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuration",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "my tiki tpl" => "my tiki tpl",
// "My pages" => "My pages",
// "Last editor" => "Last editor",
// "Last modification" => "Last modification",
// "y" => "y",
// "My items" => "My items",
// "subscribe" => "subscribe",
// "Sent edition" => "Sent edition",
// "Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed.",
// "Your email address was removed from the list of subscriptors." => "Your email address was removed from the list of subscriptors.",
// "Subscription confirmed!" => "Subscription confirmed!",
// "Subscribe to newsletter" => "Subscribe to newsletter",
// "Email:" => "Email:",
// "Subscribe" => "Subscribe",
// "Available Newsletters" => "Available Newsletters",
// "Select news group" => "Select news group",
// "Back to servers" => "Back to servers",
// "News from" => "News from",
// "Save position" => "Save position",
// "Reading article from" => "Reading article from",
// "Back to list of articles" => "Back to list of articles",
// "First" => "First",
// "Newsgroup" => "Newsgroup",
// "Configure news servers" => "Configure news servers",
// "Configure Newsreader" => "Configure Newsreader",
// "configure newsreader server tpl" => "configure newsreader server tpl",
// "Select a news server to browse" => "Select a news server to browse",
// "server" => "server",
// "Read the news" => "Read the news",
// "Add or edit a news server" => "Add or edit a news server",
// "News server" => "News server",
// "quota" => "quota",
// "Write a note" => "Write a note",
// "No notes yet" => "No notes yet",
// "merge selected notes into" => "merge selected notes into",
// "Reading note:" => "Reading note:",
// "List notes" => "List notes",
// "Write note" => "Write note",
// "wiki create" => "wiki create",
// "wiki overwrite" => "wiki overwrite",
// "Assign permissions to " => "Assign permissions to ",
// "Current permissions for this object" => "Current permissions for this object",
// "Assign permissions to this object" => "Assign permissions to this object",
// "Published" => "Published",
// "Votes" => "Votes",
// "Orphan Pages" => "Orphan Pages",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "rollback to this version" => "rollback to this version",
// "Source of version" => "Source of version",
// "s=source" => "s=source",
// "b=rollback" => "b=rollback",
// "Current permissions for this page" => "Current permissions for this page",
// "remove from this page" => "remove from this page",
// "remove from this structure" => "remove from this structure",
// "No individual permissions; category or global permissions apply" => "No individual permissions; category or global permissions apply",
// "this page" => "this page",
// "this structure" => "this structure",
// "Current permissions for categories that this page belongs to" => "Current permissions for categories that this page belongs to",
// "No category permissions; global permissions apply" => "No category permissions; global permissions apply",
// "Send email notifications when this page changes to" => "Send email notifications when this page changes to",
// "add email" => "add email",
// "Notifications" => "Notifications",
// "Pick your avatar" => "Pick your avatar",
// "Your current avatar" => "Your current avatar",
// "no avatar" => "no avatar",
// "Pick avatar from the library" => "Pick avatar from the library",
// "icons" => "icons",
// "Show all" => "Show all",
// "Avatar Image" => "Avatar Image",
// "random" => "random",
// "Upload your own avatar" => "Upload your own avatar",
// "Any" => "Any",
// "lastModif" => "lastModif",
// "atts" => "atts",
// "Number of voices" => "Number of voices",
// "Average" => "Average",
// "List Attachments" => "List Attachments",
// "View Results" => "View Results",
// "Vote poll" => "Vote poll",
// "Other Polls" => "Other Polls",
// "Note: Remember that this is only a preview, and has not yet been saved!" => "Note: Remember that this is only a preview, and has not yet been saved!",
// "Print multiple pages" => "Print multiple pages",
// "Print Wiki Pages" => "Print Wiki Pages",
// "add structure" => "add structure",
// "clear" => "clear",
// "Edit quiz" => "Edit quiz",
// "Current Version" => "Current Version",
// "General Options" => "General Options",
// "Publication Date" => "Publication Date",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions." => "randomly selected questions.",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)." => "&nbsp question(s).",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz." => "Allow students to store partial results and return to quiz.",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue:" => "Prologue:",
// "Epilogue:" => "Epilogue:",
// "Quiz result stats" => "Quiz result stats",
// "Quiz" => "Quiz",
// "Time" => "Time",
// "User answers" => "User answers",
// "Stats for quizzes" => "Stats for quizzes",
// "taken" => "taken",
// "Av score" => "Av score",
// "Av time" => "Av time",
// "Stats for quiz" => "Stats for quiz",
// "clear stats" => "clear stats",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "P" => "P",
// "F" => "F",
// "Stats for this quiz Questions " => "Stats for this quiz Questions ",
// "Top 10" => "Top 10",
// "Top 20" => "Top 20",
// "Top 50" => "Top 50",
// "Top 100" => "Top 100",
// "Received Articles" => "Received Articles",
// "received articles tpl" => "received articles tpl",
// "Edit received article" => "Edit received article",
// "Image x size" => "Image x size",
// "Image y size" => "Image y size",
// "Image name" => "Image name",
// "Accept Article" => "Accept Article",
// "Site" => "Site",
// "Help on Communication Center" => "Help on Communication Center",
// "received pages tpl" => "received pages tpl",
// "Edit received page" => "Edit received page",
// "admin Referer stats" => "admin Referer stats",
// "admin Referer stats tpl" => "admin Referer stats tpl",
// "last" => "last",
// "A valid email is mandatory to register" => "A valid email is mandatory to register",
// "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!" => "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!",
// "Tiki site registered" => "Tiki site registered",
// "You don't have permission to use this feature." => "You don't have permission to use this feature.",
// "Please register." => "Please register.",
// "Read this first!" => "Read this first!",
// "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites.",
// "Registering is voluntary." => "Registering is voluntary.",
// "Registering does not give you any benefits except one more link to your site." => "Registering does not give you any benefits except one more link to your site.",
// "You don't get any emails, we don't sell the data about your site." => "You don't get any emails, we don't sell the data about your site.",
// "Registering is just for us to get an overview of Tiki's usage." => "Registering is just for us to get an overview of Tiki's usage.",
// "If your site is private or inside your intranet, you should not register!" => "If your site is private or inside your intranet, you should not register!",
// "tikiwiki.org" => "tikiwiki.org",
// "Information about your site" => "Information about your site",
// "I forgot my password" => "I forgot my password",
// "send me my password" => "send me my password",
// "Return to HomePage" => "Return to HomePage",
// "Remove page" => "Remove page",
// "last version" => "last version",
// "You are about to remove the page" => "You are about to remove the page",
// "permanently" => "permanently",
// "Remove all versions of this page" => "Remove all versions of this page",
// "Rename page" => "Rename page",
// "Replicate" => "Replicate",
// "Slave" => "Slave",
// "Master" => "Master",
// "Change" => "Change",
// "Operations" => "Operations",
// "Operations Log" => "Operations Log",
// "Rollback page" => "Rollback page",
// "to_version" => "to_version",
// "Search Stats" => "Search Stats",
// "search stats tpl" => "search stats tpl",
// "searched" => "searched",
// "Search in" => "Search in",
// "galleries" => "galleries",
// "blog posts" => "blog posts",
// "articles" => "articles",
// "trackers" => "trackers",
// "entire site" => "entire site",
// "wiki pages" => "wiki pages",
// "Simple search" => "Simple search",
// "No pages matched the search criteria" => "No pages matched the search criteria",
// "Send blog post" => "Send blog post",
// "A link to this post was sent to the following addresses:" => "A link to this post was sent to the following addresses:",
// "Send post to this addresses" => "Send post to this addresses",
// "List of email addresses separated by commas" => "List of email addresses separated by commas",
// "Apply content template" => "Apply content template",
// "Send objects" => "Send objects",
// "admin send objects tpl" => "admin send objects tpl",
// "Transmission results" => "Transmission results",
// "Send objects to this site" => "Send objects to this site",
// "site" => "site",
// "password" => "password",
// "Send Wiki Pages" => "Send Wiki Pages",
// "Send Articles" => "Send Articles",
// "add article" => "add article",
// "sheets tpl" => "sheets tpl",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet:" => "Edit this sheet:",
// "create new sheet" => "create new sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "Graph" => "Graph",
// "Tiki Shoutbox" => "Tiki Shoutbox",
// "admin Tiki Shoutbox" => "admin Tiki Shoutbox",
// "admin Tiki Shoutbox tpl" => "admin Tiki Shoutbox tpl",
// "Change shoutbox general settings" => "Change shoutbox general settings",
// "auto-link urls" => "auto-link urls",
// "Post or edit a message" => "Post or edit a message",
// "first" => "first",
// "big grin" => "big grin",
// "confused" => "confused",
// "cool" => "cool",
// "cry" => "cry",
// "eek" => "eek",
// "evil" => "evil",
// "lol" => "lol",
// "mr green" => "mr green",
// "razz" => "razz",
// "redface" => "redface",
// "rolleyes" => "rolleyes",
// "smile" => "smile",
// "surprised" => "surprised",
// "twisted" => "twisted",
// "arrow" => "arrow",
// "santa" => "santa",
// "CMS" => "CMS",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Site Stats" => "Site Stats",
// "Days online" => "Days online",
// "Total pageviews" => "Total pageviews",
// "Average pageviews per day" => "Average pageviews per day",
// "Best day" => "Best day",
// "pvs" => "pvs",
// "Worst day" => "Worst day",
// "Wiki Stats" => "Wiki Stats",
// "Size of Wiki Pages" => "Size of Wiki Pages",
// "Mb" => "Mb",
// "Average page length" => "Average page length",
// "bytes" => "bytes",
// "Average versions per page" => "Average versions per page",
// "Visits to wiki pages" => "Visits to wiki pages",
// "Average links per page" => "Average links per page",
// "Image galleries Stats" => "Image galleries Stats",
// "Average images per gallery" => "Average images per gallery",
// "Total size of images" => "Total size of images",
// "Average image size" => "Average image size",
// "Visits to image galleries" => "Visits to image galleries",
// "File galleries Stats" => "File galleries Stats",
// "Average files per gallery" => "Average files per gallery",
// "Total size of files" => "Total size of files",
// "Average file size" => "Average file size",
// "Visits to file galleries" => "Visits to file galleries",
// "CMS Stats" => "CMS Stats",
// "Average reads per article" => "Average reads per article",
// "Total articles size" => "Total articles size",
// "Average article size" => "Average article size",
// "Forum Stats" => "Forum Stats",
// "Total topics" => "Total topics",
// "Average topics per forums" => "Average topics per forums",
// "Total threads" => "Total threads",
// "Average threads per topic" => "Average threads per topic",
// "Visits to forums" => "Visits to forums",
// "Blog Stats" => "Blog Stats",
// "Weblogs" => "Weblogs",
// "Total posts" => "Total posts",
// "Average posts per weblog" => "Average posts per weblog",
// "Total size of blog posts" => "Total size of blog posts",
// "Average posts size" => "Average posts size",
// "Visits to weblogs" => "Visits to weblogs",
// "Poll Stats" => "Poll Stats",
// "Total votes" => "Total votes",
// "Average votes per poll" => "Average votes per poll",
// "Faq Stats" => "Faq Stats",
// "Total questions" => "Total questions",
// "Average questions per FAQ" => "Average questions per FAQ",
// "User Stats" => "User Stats",
// "User bookmarks" => "User bookmarks",
// "Average bookmarks per user" => "Average bookmarks per user",
// "Quiz Stats" => "Quiz Stats",
// "Average questions per quiz" => "Average questions per quiz",
// "Quizzes taken" => "Quizzes taken",
// "Average quiz score" => "Average quiz score",
// "Average time per quiz" => "Average time per quiz",
// "Object" => "Object",
// "Usage chart" => "Usage chart",
// "Usage chart image" => "Usage chart image",
// "Daily Usage" => "Daily Usage",
// "Stats for surveys" => "Stats for surveys",
// "Survey" => "Survey",
// "Last taken" => "Last taken",
// "Stats for survey" => "Stats for survey",
// "Stats for this survey Questions " => "Stats for this survey Questions ",
// "SysLog" => "SysLog",
// "system logs" => "system logs",
// "system logs tpl" => "system logs tpl",
// "Time Left" => "Time Left",
// "send answers" => "send answers",
// "Result" => "Result",
// "Thank you for your submission" => "Thank you for your submission",
// "Theme Control Center: categories" => "Theme Control Center: categories",
// "ThemeControl" => "ThemeControl",
// "ThemeControl tpl" => "ThemeControl tpl",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
// "Theme is selected as follows" => "Theme is selected as follows",
// "If a theme is assigned to the individual object that theme is used." => "If a theme is assigned to the individual object that theme is used.",
// "If not then if a theme is assigned to the object's category that theme is used" => "If not then if a theme is assigned to the object's category that theme is used",
// "If not then a theme for the section is used" => "If not then a theme for the section is used",
// "If none of the above was selected the user theme is used" => "If none of the above was selected the user theme is used",
// "Finally if the user didn't select a theme the default theme is used" => "Finally if the user didn't select a theme the default theme is used",
// "Control by Objects" => "Control by Objects",
// "Control by Sections" => "Control by Sections",
// "Assign themes to categories" => "Assign themes to categories",
// "Assigned categories" => "Assigned categories",
// "theme" => "theme",
// "Theme Control Center: Objects" => "Theme Control Center: Objects",
// "ThemeControl Objects" => "ThemeControl Objects",
// "theme control objects tpl" => "theme control objects tpl",
// "Control by Categories" => "Control by Categories",
// "Assign themes to objects" => "Assign themes to objects",
// "Assigned objects" => "Assigned objects",
// "Theme Control Center: sections" => "Theme Control Center: sections",
// "theme control sections tpl" => "theme control sections tpl",
// "Assign themes to sections" => "Assign themes to sections",
// "Assigned sections" => "Assigned sections",
// "Edit File:" => "Edit File:",
// "Upload File" => "Upload File",
// "File Title" => "File Title",
// "Now enter the file URL" => "Now enter the file URL",
// " or upload a local file from your disk" => " or upload a local file from your disk",
// "Batch upload" => "Batch upload",
// "The following file was successfully uploaded" => "The following file was successfully uploaded",
// "You can download this file using" => "You can download this file using",
// "You can include the file in an HTML/Tiki page using" => "You can include the file in an HTML/Tiki page using",
// "You have to \ncreate a gallery first!" => "You have to \ncreate a gallery first!",
// "Image Gallery tpl" => "Image Gallery tpl",
// "or use filename" => "or use filename",
// "Now enter the image URL" => "Now enter the image URL",
// " or upload a local image from your disk" => " or upload a local image from your disk",
// "Thumbnail (optional, overrides automatic thumbnail generation)" => "Thumbnail (optional, overrides automatic thumbnail generation)",
// "Note: Maximum image size is limited to" => "Note: Maximum image size is limited to",
// "Upload successful!" => "Upload successful!",
// "The following image was successfully uploaded" => "The following image was successfully uploaded",
// "Thumbnail" => "Thumbnail",
// "Image ID thumb" => "Image ID thumb",
// "You can include the image in an Wiki page using" => "You can include the image in an Wiki page using",
// "User assigned modules" => "User assigned modules",
// "User Assigned Modules" => "User Assigned Modules",
// "User Assigned Modules tpl" => "User Assigned Modules tpl",
// "Restore defaults" => "Restore defaults",
// "move to right column" => "move to right column",
// "unassign" => "unassign",
// "move to left column" => "move to left column",
// "Assign module" => "Assign module",
// "Module" => "Module",
// "Column" => "Column",
// "User Bookmarks tpl" => "User Bookmarks tpl",
// "Current folder" => "Current folder",
// "Folders" => "Folders",
// "Folder in" => "Folder in",
// "remove folder" => "remove folder",
// "refresh cache" => "refresh cache",
// "Admin folders and bookmarks" => "Admin folders and bookmarks",
// "Add or edit folder" => "Add or edit folder",
// "Add or edit a URL" => "Add or edit a URL",
// "Avatar" => "Avatar",
// "Homepage" => "Homepage",
// "Users HomePage" => "Users HomePage",
// "Personal Wiki Page" => "Personal Wiki Page",
// "Create page" => "Create page",
// "Displayed time zone" => "Displayed time zone",
// "This user is your friend" => "This user is your friend",
// "Request friendship from this user" => "Request friendship from this user",
// "Send me a message" => "Send me a message",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "UserPreferences tpl" => "UserPreferences tpl",
// "use google map locator" => "use google map locator",
// "Pick user Avatar" => "Pick user Avatar",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Change information" => "Change information",
// "Is email public? (uses scrambling to prevent spam)" => "Is email public? (uses scrambling to prevent spam)",
// "Unavailable - please set your e-mail below" => "Unavailable - please set your e-mail below",
// "Does your mail reader need a special charset" => "Does your mail reader need a special charset",
// "Number of visited pages to remember" => "Number of visited pages to remember",
// "UTC" => "UTC",
// "private" => "private",
// "public" => "public",
// "Use double-click to edit pages" => "Use double-click to edit pages",
// "Account Information" => "Account Information",
// "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password",
// "Email address" => "Email address",
// "Confirm new password" => "Confirm new password",
// "Current password (required)" => "Current password (required)",
// "Change administrative info" => "Change administrative info",
// "Allow messages from other users" => "Allow messages from other users",
// "Note author when reading his mail" => "Note author when reading his mail",
// "Send me an email for messages with priority equal or greater than" => "Send me an email for messages with priority equal or greater than",
// "Auto-archive read messages after x days" => "Auto-archive read messages after x days",
// "My messages" => "My messages",
// "My workflow" => "My workflow",
// "User Tasks tpl" => "User Tasks tpl",
// "New task" => "New task",
// "Task list" => "Task list",
// "Admin mode off" => "Admin mode off",
// "Admin mode on" => "Admin mode on",
// "Task help" => "Task help",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "accepted by task user and creator" => "accepted by task user and creator",
// "accepted user and creator" => "accepted user and creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "not accepted by one user" => "not accepted by one user",
// "not accepted user" => "not accepted user",
// "Task is rejected by one user" => "Task is rejected by one user",
// "waiting for me" => "waiting for me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "waiting for other user" => "waiting for other user",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "admin mode" => "admin mode",
// "trash" => "trash",
// "empty trash" => "empty trash",
// "Edit task" => "Edit task",
// "red" => "red",
// "NOT accept" => "NOT accept",
// "remove from trash" => "remove from trash",
// "move into trash" => "move into trash",
// "Task saved" => "Task saved",
// "Edit Task" => "Edit Task",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "use start date and time" => "use start date and time",
// "use end date and time" => "use end date and time",
// "open / in process" => "open / in process",
// "waiting / not started" => "waiting / not started",
// "Percentage completed" => "Percentage completed",
// "waiting" => "waiting",
// "shared for group" => "shared for group",
// "accepted by user" => "accepted by user",
// "no / rejected" => "no / rejected",
// "accepted by creator" => "accepted by creator",
// "Info" => "Info",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// "No tasks entered" => "No tasks entered",
// "select one" => "select one",
// "undo trash" => "undo trash",
// "show:" => "show:",
// "received" => "received",
// "submitted" => "submitted",
// "shared" => "shared",
// "all shared tasks" => "all shared tasks",
// "completed (100%)" => "completed (100%)",
// "Public for group" => "Public for group",
// "User Watches tpl" => "User Watches tpl",
// "Add Watch" => "Add Watch",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "edit user files" => "edit user files",
// "May need to refresh twice to see changes" => "May need to refresh twice to see changes",
// "Add top level bookmarks to menu" => "Add top level bookmarks to menu",
// "Pos" => "Pos",
// "Mode" => "Mode",
// "replace window" => "replace window",
// "User_versions_for" => "User_versions_for",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "Before" => "Before",
// "After" => "After",
// "expires:" => "expires:",
// "no comments" => "no comments",
// "Banner stats" => "Banner stats",
// "Create new banner" => "Create new banner",
// "Banner Information" => "Banner Information",
// "Click ratio" => "Click ratio",
// "Weekdays" => "Weekdays",
// "mon" => "mon",
// "tue" => "tue",
// "wed" => "wed",
// "thu" => "thu",
// "fri" => "fri",
// "sat" => "sat",
// "sun" => "sun",
// "Banner raw data" => "Banner raw data",
// "Cached" => "Cached",
// "This is a cached version of the page." => "This is a cached version of the page.",
// "Click here to view the Google cache of the page instead." => "Click here to view the Google cache of the page instead.",
// "viewed" => "viewed",
// "edit items" => "edit items",
// "list charts" => "list charts",
// "last chart" => "last chart",
// "previous chart" => "previous chart",
// "Chart created" => "Chart created",
// "next chart" => "next chart",
// "pos" => "pos",
// "pre" => "pre",
// "permanency" => "permanency",
// "item" => "item",
// "chg" => "chg",
// "avg" => "avg",
// "info/vote" => "info/vote",
// "Next chart will be generated on" => "Next chart will be generated on",
// "View or vote items not listed in the chart" => "View or vote items not listed in the chart",
// "Select something to vote on" => "Select something to vote on",
// "Item information" => "Item information",
// "Chart" => "Chart",
// "Permanency" => "Permanency",
// "Dif" => "Dif",
// "Best Position" => "Best Position",
// "Vote this item" => "Vote this item",
// "Highest" => "Highest",
// "view faq" => "view faq",
// "view faq tpl" => "view faq tpl",
// "admin menus tpl" => "admin menus tpl",
// "Answers" => "Answers",
// "Q" => "Q",
// "A" => "A",
// "add suggestion" => "add suggestion",
// "1 suggestion" => "1 suggestion",
// "suggestions" => "suggestions",
// "Forum List" => "Forum List",
// "Edit Forum" => "Edit Forum",
// "monitor this forum" => "monitor this forum",
// "stop monitoring this forum" => "stop monitoring this forum",
// "You have {\$unread} unread private messages" => "You have {\$unread} unread private messages",
// "Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Your message has been queued for approval, the message will be posted after\na moderator approves it.",
// "You have to enter a title and text" => "You have to enter a title and text",
// "Summary" => "Summary",
// "HTML tags are not allowed inside comments" => "HTML tags are not allowed inside comments",
// "moderator actions" => "moderator actions",
// "move selected topics" => "move selected topics",
// "unlock selected topics" => "unlock selected topics",
// "lock selected topics" => "lock selected topics",
// "delete selected topics" => "delete selected topics",
// "merge" => "merge",
// "merge selected topics" => "merge selected topics",
// "reported messages:" => "reported messages:",
// "queued messages:" => "queued messages:",
// "Merge into topic" => "Merge into topic",
// "emot" => "emot",
// "pts" => "pts",
// "No topics yet" => "No topics yet",
// "topics in this forum" => "topics in this forum",
// "Show posts" => "Show posts",
// "Last hour" => "Last hour",
// "Last 24 hours" => "Last 24 hours",
// "Last 48 hours" => "Last 48 hours",
// "Jump to forum" => "Jump to forum",
// " unread private messages" => " unread private messages",
// "prev topic" => "prev topic",
// "next topic" => "next topic",
// "posts:" => "posts:",
// "monitor this topic" => "monitor this topic",
// "stop monitoring this topic" => "stop monitoring this topic",
// "Comments below your current threshold" => "Comments below your current threshold",
// "IRC log" => "IRC log",
// "Select" => "Select",
// "Show All" => "Show All",
// "Edit fields" => "Edit fields",
// "Insert new item" => "Insert new item",
// " item found" => " item found",
// " items found" => " items found",
// "list attachments" => "list attachments",
// "View inserted item" => "View inserted item",
// "fields marked with a * are mandatory" => "fields marked with a * are mandatory",
// "Tracker item:" => "Tracker item:",
// "View item" => "View item",
// "Filter Tracker Items" => "Filter Tracker Items",
// "Add a comment" => "Add a comment",
// "Attach a file to this item" => "Attach a file to this item",
// "more info" => "more info",
// "No attachments for this item" => "No attachments for this item",
// "remove image" => "remove image",
// "Special Operations" => "Special Operations",
// "Webmail Doc" => "Webmail Doc",
// "Webmail Doc template" => "Webmail Doc template",
// "settings" => "settings",
// "mailbox" => "mailbox",
// "compose" => "compose",
// "contacts" => "contacts",
// "Contacts" => "Contacts",
// "Edit mail account" => "Edit mail account",
// "Add new mail account" => "Add new mail account",
// "User accounts" => "User accounts",
// "account" => "account",
// "pop" => "pop",
// "View All" => "View All",
// "Msg" => "Msg",
// "clip" => "clip",
// "back to mailbox" => "back to mailbox",
// "full headers" => "full headers",
// "normal headers" => "normal headers",
// "reply all" => "reply all",
// "forward" => "forward",
// "Create/edit contacts" => "Create/edit contacts",
// "First Name" => "First Name",
// "Last Name" => "Last Name",
// "select from address book" => "select from address book",
// "cc" => "cc",
// "bcc" => "bcc",
// "Use HTML mail" => "Use HTML mail",
// "The following addresses are not in your address book" => "The following addresses are not in your address book",
// "add contacts" => "add contacts",
// "Attachment 1" => "Attachment 1",
// "Attachment 2" => "Attachment 2",
// "Attachment 3" => "Attachment 3",
// "Address book" => "Address book",
// "%s enabled" => "%s enabled",
// "%s disabled" => "%s disabled",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "General preferences and settings" => "General preferences and settings",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Wiki settings" => "Wiki settings",
// "Wiki Attachments" => "Wiki Attachments",
// "Article/CMS settings" => "Article/CMS settings",
// "Poll comments settings" => "Poll comments settings",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "Forums settings" => "Forums settings",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "RSS settings" => "RSS settings",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Search settings" => "Search settings",
// "Score settings" => "Score settings",
// "Projects" => "Projects",
// "Projects configuration" => "Projects configuration",
// "Community settings" => "Community settings",
// "Site Identity features" => "Site Identity features",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Click here to delete this category" => "Click here to delete this category",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "No chart indicated" => "No chart indicated",
// "Upload failed" => "Upload failed",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "No page indicated" => "No page indicated",
// "moved %d images, %d errors occured." => "moved %d images, %d errors occured.",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Detected, Version:" => "Detected, Version:",
// "Not detected." => "Not detected.",
// "The passwords don't match" => "The passwords don't match",
// "You cannot have a blank password" => "You cannot have a blank password",
// "Password should be at least" => "Password should be at least",
// "characters long" => "characters long",
// "Your admin password has been changed" => "Your admin password has been changed",
// "All Fields except gdaltindex must be filled" => "All Fields except gdaltindex must be filled",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Tag already exists" => "Tag already exists",
// "Tag not found" => "Tag not found",
// "Repository name can't be an empty" => "Repository name can't be an empty",
// "Requested action is not supported on repository" => "Requested action is not supported on repository",
// "No repository" => "No repository",
// "Search is mandatory field" => "Search is mandatory field",
// "File not found " => "File not found ",
// "Requested action in not supported on repository" => "Requested action in not supported on repository",
// "Non-existent link" => "Non-existent link",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer!" => "Frequency should be a positive integer!",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "No menu indicated" => "No menu indicated",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "No newsletter indicated" => "No newsletter indicated",
// "No poll indicated" => "No poll indicated",
// "unsafe" => "unsafe",
// "register_globals should be off by default. See the php manual for details." => "register_globals should be off by default. See the php manual for details.",
// "safe" => "safe",
// "session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid should be off by default. See the php manual for details.",
// "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config.",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off.",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code.",
// "installed" => "installed",
// "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html.",
// "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement.",
// "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory.",
// "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts.",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "File is not readable. Unable to check." => "File is not readable. Unable to check.",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous.",
// "This is a modified File. Cannot check version. Check if it is dangerous." => "This is a modified File. Cannot check version. Check if it is dangerous.",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// " or " => " or ",
// "You have to provide a word" => "You have to provide a word",
// "You must specify a page name, it will be created if it doesn't exist." => "You must specify a page name, it will be created if it doesn't exist.",
// "page not added (Exists)" => "page not added (Exists)",
// "No survey indicated" => "No survey indicated",
// "You don't have permission to use this feature" => "You don't have permission to use this feature",
// "No Errors detected" => "No Errors detected",
// "No tracker indicated" => "No tracker indicated",
// "Group already exists" => "Group already exists",
// "No records were found. Check the file please!" => "No records were found. Check the file please!",
// "User login is required" => "User login is required",
// "Password is required" => "Password is required",
// "Email is required" => "Email is required",
// "User is duplicated" => "User is duplicated",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "User %s already exists" => "User %s already exists",
// "New %s created with %s %s." => "New %s created with %s %s.",
// "Impossible to create new %s with %s %s." => "Impossible to create new %s with %s %s.",
// "%s %s successfully deleted." => "%s %s successfully deleted.",
// "%s %s removed from %s %s." => "%s %s removed from %s %s.",
// "%s <b>%s</b> successfully deleted." => "%s <b>%s</b> successfully deleted.",
// "%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> assigned to %s <b>%s</b>.",
// "%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> removed from %s <b>%s</b>.",
// "group <b>%s</b> set as the default group of user <b>%s</b>." => "group <b>%s</b> set as the default group of user <b>%s</b>.",
// "User already exists" => "User already exists",
// "The passwords dont match" => "The passwords dont match",
// "Password must contain both letters and numbers" => "Password must contain both letters and numbers",
// "%s modified successfully." => "%s modified successfully.",
// "%s modification failed." => "%s modification failed.",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "rss feed disabled" => "rss feed disabled",
// "Permission denied you cannot view this section" => "Permission denied you cannot view this section",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Last articles." => "Last articles.",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Permission denied you cannot view backlinks for this page" => "Permission denied you cannot view backlinks for this page",
// "The page cannot be found" => "The page cannot be found",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s." => "Could not read image %s.",
// "Image %s upload failed." => "Image %s upload failed.",
// "Image %s uploaded successfully." => "Image %s uploaded successfully.",
// "Image %s removed from Batch directory." => "Image %s removed from Batch directory.",
// "Impossible to remove image %s from Batch directory." => "Impossible to remove image %s from Batch directory.",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images." => "Incorrect directory chosen for batch upload of images.",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator." => "Please contact the website administrator.",
// "Invalid directory name" => "Invalid directory name",
// "Permission denied you cannot post" => "Permission denied you cannot post",
// "Permission denied you cannot edit this post" => "Permission denied you cannot edit this post",
// "You can't post in any blog maybe you have to create a blog first" => "You can't post in any blog maybe you have to create a blog first",
// "Top visited blogs" => "Top visited blogs",
// "Top active blogs" => "Top active blogs",
// "No blogId specified" => "No blogId specified",
// "Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs." => "Last posts to weblogs.",
// "TOP" => "TOP",
// "Permission denied you cannot access this gallery" => "Permission denied you cannot access this gallery",
// "No gallery indicated" => "No gallery indicated",
// "Please login" => "Please login",
// "Permission denied you cannot view this page" => "Permission denied you cannot view this page",
// "Permission denied you can not view this section" => "Permission denied you can not view this section",
// "Permission denied you cannot remove images from this gallery" => "Permission denied you cannot remove images from this gallery",
// "Permission denied you cannot rebuild thumbnails in this gallery" => "Permission denied you cannot rebuild thumbnails in this gallery",
// "Permission denied you cannot rotate images in this gallery" => "Permission denied you cannot rotate images in this gallery",
// "No image indicated" => "No image indicated",
// "Permission denied you cannot move images from this gallery" => "Permission denied you cannot move images from this gallery",
// "Permission denied you cannot view the calendar" => "Permission denied you cannot view the calendar",
// "event without name" => "event without name",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string!",
// "%m/%d" => "%m/%d",
// "Access Denied" => "Access Denied",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Upcoming events." => "Upcoming events.",
// "Start:" => "Start:",
// "End:" => "End:",
// "No category indicated" => "No category indicated",
// "Permission denied; you cannot assign permissions for this category" => "Permission denied; you cannot assign permissions for this category",
// "The passwords didn't match" => "The passwords didn't match",
// "You can not use the same password again" => "You can not use the same password again",
// "Invalid old password" => "Invalid old password",
// "Permission denied to use this feature" => "Permission denied to use this feature",
// "No channel indicated" => "No channel indicated",
// "No nickname indicated" => "No nickname indicated",
// "Top authors" => "Top authors",
// "ERROR: you must include a subject or a message at least" => "ERROR: you must include a subject or a message at least",
// "Message sent to" => "Message sent to",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "This feature has been disabled" => "This feature has been disabled",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "Last sites." => "Last sites.",
// "Must enter a name to add a site. " => "Must enter a name to add a site. ",
// "Must enter a url to add a site. " => "Must enter a url to add a site. ",
// "URL already added to the directory. Duplicate site? " => "URL already added to the directory. Duplicate site? ",
// "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. ",
// "Must select a category. " => "Must select a category. ",
// "Must enter a name to add a site" => "Must enter a name to add a site",
// "Must enter a url to add a site" => "Must enter a url to add a site",
// "URL already added to the directory. Duplicate site?" => "URL already added to the directory. Duplicate site?",
// "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory",
// "Must select a category" => "Must select a category",
// "No site indicated" => "No site indicated",
// "Site No validated yet" => "Site No validated yet",
// "No parent specified" => "No parent specified",
// "Last sites of directory \".\$rc[\"name\"].\" ." => "Last sites of directory \".\$rc[\"name\"].\" .",
// "You can not download files" => "You can not download files",
// "Error : The file %s doesn't exist." => "Error : The file %s doesn't exist.",
// "Permission denied you cannot edit this article" => "Permission denied you cannot edit this article",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "You do not have permissions to edit banners" => "You do not have permissions to edit banners",
// "Banner not found" => "Banner not found",
// "You do not have permission to edit this banner" => "You do not have permission to edit this banner",
// "Permission denied you cannot create or edit blogs" => "Permission denied you cannot create or edit blogs",
// "Permission denied you cannot edit this blog" => "Permission denied you cannot edit this blog",
// "You do not have permission to write the style sheet" => "You do not have permission to write the style sheet",
// "Invalid request to edit an image" => "Invalid request to edit an image",
// "Permission denied you cannot edit images" => "Permission denied you cannot edit images",
// "Permission denied you can edit images but not in this gallery" => "Permission denied you can edit images but not in this gallery",
// "Failed to edit the image" => "Failed to edit the image",
// "Shortname must be 2 Characters" => "Shortname must be 2 Characters",
// "You must provide a longname" => "You must provide a longname",
// "Language created" => "Language created",
// "No content id indicated" => "No content id indicated",
// "No question indicated" => "No question indicated",
// "No quiz indicated" => "No quiz indicated",
// "No structure indicated" => "No structure indicated",
// "Invalid structure_id or page_ref_id" => "Invalid structure_id or page_ref_id",
// "Permission denied you cannot send submissions" => "Permission denied you cannot send submissions",
// "Permission denied you cannot edit submissions" => "Permission denied you cannot edit submissions",
// "You have to create a topic first" => "You have to create a topic first",
// "You do not have permission to do that" => "You do not have permission to do that",
// "You do not have permission to write the template:" => "You do not have permission to write the template:",
// "You do not have permission to read the template" => "You do not have permission to read the template",
// "No topic id specified" => "No topic id specified",
// "Invalid topic id specified" => "Invalid topic id specified",
// "No object indicated" => "No object indicated",
// "No type indicated" => "No type indicated",
// "Article not found" => "Article not found",
// "Permission denied you cannot edit this page" => "Permission denied you cannot edit this page",
// "page imported" => "page imported",
// "created from import" => "created from import",
// "You have mistyped the anti-bot verification code; please try again." => "You have mistyped the anti-bot verification code; please try again.",
// "Can't import remote HTML page" => "Can't import remote HTML page",
// "Can't parse remote HTML page" => "Can't parse remote HTML page",
// "You cannot edit this page because it is a user personal page" => "You cannot edit this page because it is a user personal page",
// "Cannot edit page because it is locked" => "Cannot edit page because it is locked",
// "unknown error" => "unknown error",
// "cannot be found" => "cannot be found",
// "No permission to view the page" => "No permission to view the page",
// "No questions group indicated" => "No questions group indicated",
// "Permission denied you cannot create galleries and so you cant edit them" => "Permission denied you cannot create galleries and so you cant edit them",
// "Permission denied you cannot edit this gallery" => "Permission denied you cannot edit this gallery",
// "Permission denied you cannot remove this gallery" => "Permission denied you cannot remove this gallery",
// "Top visited file galleries" => "Top visited file galleries",
// "Most downloaded files" => "Most downloaded files",
// "Last files" => "Last files",
// "Tiki RSS feed for file galleries" => "Tiki RSS feed for file galleries",
// "Last files uploaded to the file galleries." => "Last files uploaded to the file galleries.",
// "No galleryId specified" => "No galleryId specified",
// "Tiki RSS feed for the file gallery: " => "Tiki RSS feed for the file gallery: ",
// "No forum indicated" => "No forum indicated",
// "Forum posts" => "Forum posts",
// "No forumId specified" => "No forumId specified",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums." => "Last topics in forums.",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship!" => "I have broken our friendship!",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request!" => "I have accepted your friendship request!",
// "I have refused your friendship request!" => "I have refused your friendship request!",
// "No process indicated" => "No process indicated",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "Activity name already exists" => "Activity name already exists",
// "indicates if the process is active. Invalid processes cant be active" => "indicates if the process is active. Invalid processes cant be active",
// "No instance indicated" => "No instance indicated",
// "No activity indicated" => "No activity indicated",
// "The process name already exists" => "The process name already exists",
// "Process already exists" => "Process already exists",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "You cant execute this activity" => "You cant execute this activity",
// "You couldn't abort a instance" => "You couldn't abort a instance",
// "You couldn't exception a instance" => "You couldn't exception a instance",
// "No user indicated" => "No user indicated",
// "No title indicated" => "No title indicated",
// "No comment indicated" => "No comment indicated",
// "No date indicated" => "No date indicated",
// "No item indicated" => "No item indicated",
// "first uploaded image" => "first uploaded image",
// "last uploaded image" => "last uploaded image",
// "random image" => "random image",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Top images" => "Top images",
// "Last images" => "Last images",
// "Back to preferences" => "Back to preferences",
// "No valid renderer found. GD or PDFLib required." => "No valid renderer found. GD or PDFLib required.",
// "No sheet specified." => "No sheet specified.",
// "You must select a renderer." => "You must select a renderer.",
// "Invalid Series for current graphic." => "Invalid Series for current graphic.",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries." => "Last images uploaded to the image galleries.",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "overwriting old page" => "overwriting old page",
// "updated from structured text import" => "updated from structured text import",
// "page created" => "page created",
// "created from structured text import" => "created from structured text import",
// "No repository given" => "No repository given",
// "Permission denied you cannot view pages like this page" => "Permission denied you cannot view pages like this page",
// "Permission denied you cannot remove articles" => "Permission denied you cannot remove articles",
// "Permission denied you cannot remove banners" => "Permission denied you cannot remove banners",
// "Permission denied you cannot remove this blog" => "Permission denied you cannot remove this blog",
// "Non-existent gallery" => "Non-existent gallery",
// "Permission denied you cannot remove files from this gallery" => "Permission denied you cannot remove files from this gallery",
// "Permission denied you can't upload files so you can't edit them" => "Permission denied you can't upload files so you can't edit them",
// "Permission denied you cannot edit this file" => "Permission denied you cannot edit this file",
// "This gallery does not exist" => "This gallery does not exist",
// "The game file must have .swf or .dcr extension" => "The game file must have .swf or .dcr extension",
// "The thumbnail name must be" => "The thumbnail name must be",
// "Please supply both files" => "Please supply both files",
// "You cannot admin blogs" => "You cannot admin blogs",
// "Permission denied you cannot remove submissions" => "Permission denied you cannot remove submissions",
// "Permission denied you cannot approve submissions" => "Permission denied you cannot approve submissions",
// "Permission denied you cannot view pages" => "Permission denied you cannot view pages",
// "Permission denied you cannot remove pages" => "Permission denied you cannot remove pages",
// "You have to enable cookies to be able to login to this site" => "You have to enable cookies to be able to login to this site",
// "Unable to contact remote server." => "Unable to contact remote server.",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Account validated successfully." => "Account validated successfully.",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Sorry, you can't use this feature." => "Sorry, you can't use this feature.",
// "changed" => "changed",
// "You do not have permissions to view the maps" => "You do not have permissions to view the maps",
// "Maps feature is not correctly setup : Maps path is missing." => "Maps feature is not correctly setup : Maps path is missing.",
// "Please create a directory named \$map_path to hold your map files." => "Please create a directory named \$map_path to hold your map files.",
// "mapfile name incorrect" => "mapfile name incorrect",
// "This mapfile already exists" => "This mapfile already exists",
// "You do not have permission to write to the mapfile" => "You do not have permission to write to the mapfile",
// "You do not have permission to delete the mapfile" => "You do not have permission to delete the mapfile",
// "I could not make a copy" => "I could not make a copy",
// "You do not have permission to read the mapfile" => "You do not have permission to read the mapfile",
// "You dont have permission to do that" => "You dont have permission to do that",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available." => "List of maps available.",
// "You do not have permissions to view the layers" => "You do not have permissions to view the layers",
// "Could not upload the file" => "Could not upload the file",
// "You do not have permissions to delete a file" => "You do not have permissions to delete a file",
// "File not found" => "File not found",
// "You do not have permissions to create a directory" => "You do not have permissions to create a directory",
// "The Directory is not empty" => "The Directory is not empty",
// "You do not have permissions to delete a directory" => "You do not have permissions to delete a directory",
// "You do not have permissions to create an index file" => "You do not have permissions to create an index file",
// "Invalid files to index" => "Invalid files to index",
// "I do not know where is gdaltindex. Set correctly the Map feature" => "I do not know where is gdaltindex. Set correctly the Map feature",
// "I could not create the index file" => "I could not create the index file",
// "Must be logged to use this feature" => "Must be logged to use this feature",
// "Welcome at Hawiki" => "Welcome at Hawiki",
// "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more.",
// "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:",
// "tiki-mobile.php" => "tiki-mobile.php",
// "About" => "About",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled." => "Your PHP installation does not have zlib enabled.",
// "You must log in to use this feature" => "You must log in to use this feature",
// "You do not have permission to view other users data" => "You do not have permission to view other users data",
// "You must be logged in to subscribe to newsletters" => "You must be logged in to subscribe to newsletters",
// "No server indicated" => "No server indicated",
// "Cannot connect to" => "Cannot connect to",
// "Missing information to read news (server,port,username,password,group) required" => "Missing information to read news (server,port,username,password,group) required",
// "Cannot get messages" => "Cannot get messages",
// "No note indicated" => "No note indicated",
// "merged note:" => "merged note:",
// "File is too big" => "File is too big",
// "created from notepad" => "created from notepad",
// "No name indicated for wiki page" => "No name indicated for wiki page",
// "Page already exists" => "Page already exists",
// "Permission denied you cannot assign permissions for this page" => "Permission denied you cannot assign permissions for this page",
// "Not enough information to display this page" => "Not enough information to display this page",
// "Permission denied you cannot browse this page history" => "Permission denied you cannot browse this page history",
// "No article indicated" => "No article indicated",
// "Article is not published yet" => "Article is not published yet",
// "No post indicated" => "No post indicated",
// "Blog not found" => "Blog not found",
// "No pages indicated" => "No pages indicated",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes." => "You don't have permission to edit quizzes.",
// "No result indicated" => "No result indicated",
// "Permision denied" => "Permision denied",
// "Registered" => "Registered",
// "Wrong registration code" => "Wrong registration code",
// "Username is too long" => "Username is too long",
// "Username cannot contain whitespace" => "Username cannot contain whitespace",
// "Wrong passcode you need to know the passcode to register in this site" => "Wrong passcode you need to know the passcode to register in this site",
// "Invalid email address. You must enter a valid email address" => "Invalid email address. You must enter a valid email address",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "Invalid username or activation code. Maybe this code has already been used." => "Invalid username or activation code. Maybe this code has already been used.",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "A password and your IP address reminder email has been sent " => "A password and your IP address reminder email has been sent ",
// "A new (and temporary) password and your IP address has been sent " => "A new (and temporary) password and your IP address has been sent ",
// "to the registered email address for" => "to the registered email address for",
// "Invalid or unknown username" => "Invalid or unknown username",
// "Permission denied you cannot remove versions from this page" => "Permission denied you cannot remove versions from this page",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "Cannot rename page maybe new page already exists" => "Cannot rename page maybe new page already exists",
// "changed '%s' from '%s' to '%s'" => "changed '%s' from '%s' to '%s'",
// "Non-existent version" => "Non-existent version",
// "Permission denied you cannot rollback this page" => "Permission denied you cannot rollback this page",
// "Error Message" => "Error Message",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "Post recommendation at" => "Post recommendation at",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "No newsletters available." => "No newsletters available.",
// " successfully sent" => " successfully sent",
// " not sent" => " not sent",
// "Use this thread to discuss the page:" => "Use this thread to discuss the page:",
// "An error occurred." => "An error occurred.",
// "Notice: invalid variable value:" => "Notice: invalid variable value:",
// "You do not have permission to edit messages" => "You do not have permission to edit messages",
// "This feature is for admins only" => "This feature is for admins only",
// "Page must be defined inside a structure to use this feature" => "Page must be defined inside a structure to use this feature",
// "You cannot take this quiz twice" => "You cannot take this quiz twice",
// "Quiz time limit exceeded quiz cannot be computed" => "Quiz time limit exceeded quiz cannot be computed",
// "You cannot take this survey twice" => "You cannot take this survey twice",
// "Please create a category first" => "Please create a category first",
// "empty" => "empty",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "Invalid filename (using filters for filenames)" => "Invalid filename (using filters for filenames)",
// "No permission to upload zipped file packages" => "No permission to upload zipped file packages",
// "Cannot read file" => "Cannot read file",
// "File update was successful" => "File update was successful",
// "Permission denied you cannot upload files" => "Permission denied you cannot upload files",
// "Could not find the file requested" => "Could not find the file requested",
// "Permission denied you can upload files but not to this file gallery" => "Permission denied you can upload files but not to this file gallery",
// "Error processing zipped image package" => "Error processing zipped image package",
// "No permission to upload zipped image packages" => "No permission to upload zipped image packages",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "Permission denied you cannot upload images" => "Permission denied you cannot upload images",
// "Permission denied you can upload images but not to this gallery" => "Permission denied you can upload images but not to this gallery",
// "Cannot get image from URL" => "Cannot get image from URL",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "cannot process upload" => "cannot process upload",
// "Usage" => "Usage",
// "No url indicated" => "No url indicated",
// "You are not logged in and no user indicated" => "You are not logged in and no user indicated",
// "The user has chosen to make his information private" => "The user has chosen to make his information private",
// "Invalid password.  Your current password is required to change administrative information" => "Invalid password.  Your current password is required to change administrative information",
// "Email is set to %s" => "Email is set to %s",
// "The passwords did not match" => "The passwords did not match",
// "unicode" => "unicode",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries:" => "Task entries:",
// "Changes:" => "Changes:",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it!" => "Please read the task and work on it!",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "Cannot upload this file not enough quota" => "Cannot upload this file not enough quota",
// "Non-existent user" => "Non-existent user",
// "No banner indicated" => "No banner indicated",
// "No blog indicated" => "No blog indicated",
// "Permission denied you cannot remove the post" => "Permission denied you cannot remove the post",
// "Permission denied you cannot remove trackbacks" => "Permission denied you cannot remove trackbacks",
// "No cache information available" => "No cache information available",
// "No faq indicated" => "No faq indicated",
// "You are not permitted to remove someone else\\'s post!" => "You are not permitted to remove someone else\\'s post!",
// "Wrong password. Cannot post comment" => "Wrong password. Cannot post comment",
// "Please wait 2 minutes between posts" => "Please wait 2 minutes between posts",
// "No thread indicated" => "No thread indicated",
// "A SheetId is required." => "A SheetId is required.",
// "Your email address has been removed from the list of addresses monitoring this tracker" => "Your email address has been removed from the list of addresses monitoring this tracker",
// "Your email address has been added to the list of addresses monitoring this tracker" => "Your email address has been added to the list of addresses monitoring this tracker",
// "Cancel monitoring" => "Cancel monitoring",
// "Monitor" => "Monitor",
// "Your email address has been removed from the list of addresses monitoring this item" => "Your email address has been removed from the list of addresses monitoring this item",
// "Your email address has been added to the list of addresses monitoring this item" => "Your email address has been added to the list of addresses monitoring this item",
// "That tracker don't use extras." => "That tracker don't use extras.",
// "No subject" => "No subject",
// "Your email was sent" => "Your email was sent",
// "Top pages" => "Top pages",
// "Tiki RSS feed for the wiki pages" => "Tiki RSS feed for the wiki pages",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"sent" => "sent",
// ###
// ### end of possibly untranslated words
// ###

"by" => "από",
"locked" => "κλειδωμένο",
"article" => "άρθρο",
"image" => "εικόνα",
"calendar" => "ημερολόγιο",
"Wiki Home" => "Αρχικό Wiki",
"Home" => "Αρχή",
"previous page" => "προηγούμενη σελίδα",
"next page" => "επόμενη σελίδα",
"Continue" => "Συνέχισε",
"Articles" => "Άρθρα",
"Read" => "Αναγνωσμένα",
"List articles" => "Λίστα άρθρων",
"Last post" => "Τελευταία δημοσίευση",
"unknown" => "άγνωστο",
"Modified" => "Τροποποιήθηκε",
"Reads" => "Αναγνώσεις",
"Score" => "Βαθμολογία",
"Visits" => "Επισκέψεις",
"Posts" => "Δημοσιεύσεις",
"Send message" => "Αποστολή μυνήματος",
"Image Gallery" => "Συλλογή Εικόνων",
"Image" => "Εικόνα",
"Article" => "Άρθρο",
"Directory" => "Σύνδεσμοι",
"File Gallery" => "Συλλογή Αρχείων",
"Gallery" => "Συλλογή",
"File" => "Αρχείο",
"from" => "από",
"Priority" => "Προτεραιότητα",
"games" => "παιχνίδια",
"picture not found" => "η εικόνα δεν βρέθηκε",
"Created" => "Δημιουργήθηκε",
"new" => "νέο",
"Item" => "Αντικείμενο",
"text field" => "πεδίο κειμένου",
"size" => "μέγεθος",
"numeric field" => "αριθμητικό πεδίο",
"date and time" => "ημερομηνία και ώρα",
"action" => "ενέργεια",
"category" => "κατηγορία",
"closed" => "κλειστό",
"message" => "μύνημα",
"Date" => "Ημερομηνία",
"Title" => "Τίτλος",
"Author" => "Συγγραφέας",
"data" => "δεδομένα",
"comment" => "σχόλιο",
"text" => "κείμενο",
"days" => "μέρες",
"hours" => "ώρες",
"minutes" => "λεπτά",
"and" => "και",
"seconds" => "δευτερόλεπτα",
"cells" => "κελιά",
"description" => "περιγραφή",
"Sorry no such module" => "Δεν υπάρχει τέτοιο άρθρωμα",
"row1col1" => "γραμμή1στήλη1",
"row1col2" => "γραμμή1στήλη2",
"row2col1" => "γραμμή2στήλη1",
"row2col2" => "γραμμή2στήλη2",
"Run a sql query" => "Εκτέλεση sql επερώτησης",
"sql query" => "sql επερώτηση",
"edit" => "τροποποίηση",
"Quick edit a Wiki page" => "Ανάπτυξη σελίδας wiki",
"Since your last visit" => "Από την τελευταία σου επίσκεψη",
"Changes" => "Αλλαγές",
"since" => "από",
"Changes since" => "Αλλαγές από",
"new comments" => "νέα σχόλια",
"wiki pages changed" => "μεταβολές σε σελίδες wiki",
"new articles" => "νέα άρθρα",
"new image galleries" => "νέες συλλογές εικόνων",
"new images" => "νέες εικόνες",
"new file galleries" => "νέες συλλογές αρχείων",
"new files" => "νέα αρχεία",
"new users" => "νέοι χρήστες",
"no such file" => "δεν υπάρχει τέτοιο αρχείο",
"Error" => "Σφάλμα",
"List of attached files" => "Λίστα συνδεδεμένων αρχείων",
"name" => "όνομα",
"delete" => "διαγραφή",
"Remove" => "Αφαίρεση",
"Upload file" => "Νέο αρχείο",
"attach" => "επισύναψη",
"Created by" => "Δημιουργήθηκε από",
"Last modified" => "Τελευταία τροποποίηση",
"Post" => "Δημοσίευση",
"posts" => "δημοσιεύσεις",
"visits" => "επισκέψεις",
"show categories" => "προβολή κατηγοριών",
"hide categories" => "απόκρυψη κατηγοριών",
"categorize this object" => "θέσε αυτό το αντικείμενο σε κατηγορία",
"No categories defined" => "Δεν έχουν οριστεί κατηγορίες",
"Admin categories" => "Διαχείριση κατηγοριών",
"author" => "συντάκτης",
"private message" => "προσωπικό μύνημα",
"score" => "βαθμολογία",
"Edit" => "Τροποποίηση",
"reply" => "απάντηση",
"move" => "μετακίνηση",
"Messages" => "Μυνήματα",
"All" => "Όλα",
"Sort" => "Κατάταξη",
"Find" => "Αναζήτηση",
"prev" => "προηγούμενο",
"Page" => "Σελίδα",
"next" => "επόμενο",
"Post new comment" => "Αποστολή νέου σχολίου",
"Preview" => "Προεπισκόπηση",
"preview" => "προεπισκόπηση",
"cancel" => "άκυρο",
"Comment" => "Σχόλιο",
"Go back" => "Πήγαινε πίσω",
"Return to home page" => "Επιστροφή στην αρχική σελίδα",
"Year" => "Έτος",
"Authors" => "Συντάκτες",
"up" => "πάνω",
"down" => "κάτω",
"add" => "προσθήκη",
"Syntax" => "Σύνταξη",
"From" => "Από",
"Subject" => "Θέμα",
"Title:" => "Τίτλος:",
"Name" => "Όνομα",
"Type" => "Τύπος",
"Size" => "Μέγεθος",
"Comments" => "Σχόλια",
"Actions" => "Ενέργειες",
"History" => "Ιστορικό",
"User" => "Χρήστης",
"Action" => "Ενέργεια",
"Files" => "Αρχεία",
"Create Directory:" => "Δημιουργία Καταλόγου:",
"Edit template" => "Τροποποίηση προτύπου",
"Unread" => "Μη αναγνωσμένα",
"Flagged" => "Μαρκαρισμένα",
"Unflagged" => "Μη μαρκαρισμένα",
"filter" => "φίλτρο",
"subject" => "θέμα",
"date" => "ημερομηνία",
"No messages to display" => "Κανένα μύνημα προς εμφάνιση",
"edit template" => "τροποποίηση προτύπου",
"Group" => "Ομάδα",
"All users" => "Όλοι οι χρήστες",
"Lowest" => "Ελάχιστη",
"Low" => "Χαμηλή",
"Normal" => "Κανονική",
"High" => "Υψηλή",
"Very High" => "Πολύ υψηλή",
"send" => "αποστολή",
"Compose message" => "Νέο Μύνημα",
"Compose Message" => "Σύνταξη Μυνήματος",
"To" => "Προς",
"Mark as read" => "Όρισέ το 'Αναγνωσμένο'",
"Mark as unread" => "Όρισέ το 'Μη αναγνωσμένο'",
"Mark as flagged" => "Όρισέ το 'μαρκαρισμένο'",
"Mark as unflagged" => "Όρισέ το 'Μη μαρκαρισμένο'",
"Compose" => "Νέο μύνημα",
"Broadcast" => "Νέα ενημέρωση",
"Read message" => "Ανάγνωση Μυνήματος",
"Prev" => "Προηγούμενο",
"Next" => "Επόμενο",
"replyall" => "απάντηση σε όλους",
"Flag this message" => "Μάρκαρε αυτό το μύνημα",
"remove" => "διαγραφή",
"Admin Menu" => "Διαχείριση Menu",
"Live support" => "Ζωντανή υποστήριξη",
"Users" => "Χρήστες",
"Groups" => "Ομάδες",
"Modules" => "Αρθρώματα",
"Links" => "Σύνδεσμοι",
"Polls" => "Δημοσκοπήσεις",
"Backups" => "Αντίγραφα ασφαλείας",
"Categories" => "Κατηγορίες",
"Edit templates" => "Τροποποίηση προτύπων",
"HTML pages" => "HTML σελίδες",
"Shoutbox" => "Φωναχτήρι",
"phpinfo" => "Πληροφορίες php",
"External wikis" => "Εξωτερικά wikis",
"System Admin" => "Διαχείριση Συστήματος",
"Menu" => "Μενού",
"Stats" => "Στατιστικά",
"Games" => "Παιχνίδια",
"Calendar" => "Ημερολόγιο",
"Preferences" => "Προτιμήσεις",
"Tasks" => "Εργασίες",
"Bookmarks" => "Σελιδοδείκτες",
"Notepad" => "Σημειώσεις",
"My files" => "Αρχεία",
"User menu" => "Μενού χρήστη",
"My watches" => "Ρουφιάνοι",
"Workflow" => "Ροές Εργασίας",
"Community" => "Κοινότητα",
"User list" => "Λίστα χρηστών",
"Friendship Network" => "Δίκτυο Φιλίας",
"Last changes" => "Τελευταίες αλλαγές",
"Rankings" => "Κατάταξεις",
"List pages" => "Λίστα σελίδων",
"Orphan pages" => "Ορφανές σελίδες",
"Sandbox" => "Δοκιμαστικός Σωλήνας",
"Print" => "Εκτύπωση",
"Send pages" => "Απεσταλμένες σελίδες",
"Received pages" => "Ληφθείσες σελίδες",
"Structures" => "Δομές",
"Image Galleries" => "Συλλογές Εικόνων",
"Galleries" => "Συλλογές",
"Upload image" => "Νέα εικόνα",
"System gallery" => "Συλλογή συστήματος",
"Articles home" => "Αρχική σελίδα άρθρων",
"Submit article" => "Προσθήκη άρθρου",
"Edit article" => "Σύνταξη άρθρου",
"Send articles" => "Αποστολή άρθρων",
"Received articles" => "Ληφθέντα άρθρα",
"Admin topics" => "Θεματικές κατηγορίες",
"Admin posts" => "Διαχείριση δημοσιεύσεων",
"List forums" => "Προβολή",
"Admin forums" => "Διαχείριση",
"File Galleries" => "Αρχεία",
"List galleries" => "Λίστα Συλλογών",
"List FAQs" => "Λίστα FAQs",
"Admin FAQs" => "Διαχείριση FAQs",
"Maps" => "Χάρτες",
"Charts" => "Διαγράμματα",
"Admin" => "Διαχείριση",
"Drawings" => "Ζωγραφιές",
"User Menu" => "Μενού Χρήστη",
"January" => "Ιανουάριος",
"February" => "Φεβρουάριος",
"March" => "Μάρτιος",
"April" => "Απρίλιος",
"May" => "Μαϊ",
"June" => "Ιούνιος",
"July" => "Ιούλιος",
"August" => "Αύγουστος",
"September" => "Σεπτέμβριος",
"October" => "Οκτώβριος",
"November" => "Νοέμβριος",
"December" => "Δεκέμβριος",
"Monday" => "Δευτέρα",
"Tuesday" => "Τρίτη",
"Wednesday" => "Τετάρτη",
"Thursday" => "Πέμπτη",
"Friday" => "Παρασκευή",
"Saturday" => "Σάββατο",
"Sunday" => "Κυριακή",
"Pages:" => "Σελίδες:",
"Searches" => "Αναζητήσεις",
"Last articles" => "Τελευταία άρθρα",
"Last Files" => "Αρχεία",
"Online users" => "Συνδεδεμένοι χρήστες",
"online users" => "συνδεδεμένοι χρήστες",
"user" => "χρήστης",
"I forgot my pass" => "Ξέχασα τον κωδικό μου!",
"You have" => "Έχεις",
"new messages" => "νέα μυνήματα",
"new message" => "νέο μύνημα",
"You have 0 new messages" => "Κανένα νέο μύνημα",
"Send a message to" => "Αποστολή μυνήματος προς",
"Random Pages" => "Τυχαίες Σελίδες",
"Search" => "Αναζήτηση",
"in:" => "σε:",
"Entire Site" => "Ολόκληρο το site",
"Wiki Pages" => "Σελίδες wiki",
"Image Gals" => "Εικόνες",
"Images" => "Εικόνες",
"Read More" => "Περισσότερα",
"Since your last visit on" => "Από την τελευταία σου επίσκεψη την",
"Language: " => "Γλώσσα: ",
"Language" => "Γλώσσα",
"My galleries" => "Οι συλλογές μου",
"My Pages" => "Οι σελίδες μου",
"User tasks" => "Εργασίες χρήστη",
"online user" => "συνδεδεμένος χρήστης",
"Last wiki comments" => "Τελευταία σχόλια στο wiki",
"users" => "χρήστες",
"secs" => "δευτερόλεπτα",
"print" => "εκτύπωση",
"create pdf" => "δημιουργία pdf",
"monitor this page" => "ανάθεση ρουφιάνου",
"stop monitoring this page" => "αποδέσμευση ρουφιάνου",
"Previous page" => "Προηγούμενη σελίδα",
"Next page" => "Επόμενη σελίδα",
"First page" => "Πρώτη σελίδα",
"page" => "σελίδα",
"Last page" => "Τελευταία σελίδα",
"last modification" => "τελευταία τροποποίηση",
"rename" => "μετονομασία",
"unlock" => "ξεκλείδωμα",
"lock" => "κλείδωμα",
"perms" => "δικαιώματα",
"history" => "ιστορικό",
"similar" => "παρόμοιες σελίδες",
"undo" => "αναίρεση",
"export" => "εξαγωγή",
"add comment" => "προσθήκη σχολίου",
"1 comment" => "1 σχόλιο",
"comments" => "σχόλια",
"attach file" => "επισύναψη αρχείου",
"translation" => "μετάφραση",
"Apply template" => "Εφαρμογή προτύπου",
"none" => "κανένα",
"Data" => "Δεδομένα",
"Homework" => "Ασκήσεις",
"Last Changes" => "Σελίδες Wiki",
"User files" => "Αρχεία Χρηστών",
"Favorites" => "Αγαπημένα",
"Watches" => "Ρουφιάνοι",
"home" => "αρχή",
"categories" => "κατηγορίες",
"last changes" => "τελευταίες αλλαγές",
"rankings" => "κατατάξεις",
"list pages" => "λίστα σελίδων",
"orphan pages" => "ορφανές σελίδες",
"sandbox" => "δοκιμαστικός σωλήνας",
"received pages" => "ληφθήσες σελίδες",
"Articles Home" => "Αρχική Σελίδα",
"MyFiles" => "Προσωπικά αρχεία",
"back to homepage" => "επιστροφή στην αρχική σελίδα",
"Description" => "Περιγραφή",
"My Footnotes" => "Υποσημειώσεις",
"Year:" => "Έτος:",
"Authors:" => "Συντάκτες:",
"Spellcheck" => "Ορθογραφικός έλεγχος",
"minute" => "λεπτό",
"hour" => "ώρα",
"cancel edit" => "άκυρο",
"User Pages" => "Σελίδες wiki",
"by creator" => "που δημιούργησα",
"by modificator" => "που τροποποίησα",
"Unread Messages" => "Νέα μυνήματα",
"Find:" => "Αναζήτηση:",
"Sort posts by:" => "Ταξινόμηση κατά:",
"pages" => "σελίδες",
"General" => "Γενικά",
"Spellchecking" => "Ορθογραφικός έλεγχος",
"Visits (desc)" => "Επισκέψεις (desc)",
"Activity (desc)" => "Δραστηριότητα (desc)",
"Change preferences" => "Αλλαγή προτιμήσεων",
"Plain text" => "Απλό κείμενο",
"Use templates" => "Χρήση προτύπων",
"Topic" => "Θεματική ενότητα",
"Img" => "Εικόνα",
"Country" => "Χώρα",
"Last login" => "Τελευταίο login",
"Number of columns per page when listing categories" => "Αριθμός στηλών ανά σελίδα κατά την προβολή κατηγοριών",
"Links per page" => "Links ανά σελίδα",
"Validate URLs" => "Πιστοποίηση URLs",
"new window" => "νέο παράθυρο",
"Edit Templates" => "Τροποποίηση Προτύπων",
"HTML Pages" => "HTML Σελίδες",
"Administration Features" => "Δυνατότητες Διαχείρισης",
"Communications (send/receive objects)" => "Επικοινωνίες (αντικείμενα αποστολής/λήψης)",
"Referer Stats" => "Αναφορικά Στατιστικά",
"Contact Us" => "Επικοινωνία",
"Contact Us (Anonymous)" => "Επικοινωνία (Ανώνυμη)",
"User Watches" => "Ρυθμίσεις Ρουφιάνων",
"User Tasks" => "Εργασίες Χρήστη",
"User Messages" => "μυνήματα Χρήστη",
"User Files" => "Αρχεία Χρήστη",
"General Layout options" => "Επιλογές Γενικού Layout",
"Left column" => "Αριστερή στήλη",
"Right column" => "Δεξιά στήλη",
"Ordering for forums in the forum listing" => "Ταξινόμηση της λίστας των forums",
"Creation Date (desc)" => "Ημερομηνία Δημιουργίας (desc)",
"Topics (desc)" => "Θεματικές κατηγορίες (desc)",
"Last post (desc)" => "Τελευταία δημοσίευση (desc)",
"Name (desc)" => "Όνομα (desc)",
"Name (asc)" => "Όνομα (asc)",
"Topics" => "Θεματικές κατηγορίες",
"Posts per day" => "Δημοσιεύσεις ανά ημέρα",
"General Preferences" => "Γενικές Προτιμήσεις",
"Home page" => "Αρχική σελίδα",
"Use database for translation" => "Χρήση της βάσης δεδομένων για μετάφραση",
"Record untranslated" => "Καταγραφή μη μεταφρασμένων",
"OS" => "Λειτουργικό Σύστημα",
"Unknown/Other" => "Άγνωστο/Άλλο",
"General Settings" => "Γενικές Επιλογές",
"Open external links in new window" => "Άνοιγε τις εξωτερικές συνδέσεις σε νέα παράθυρα",
"Use cache for external pages" => "Χρήση cache για εξωτερικές σελίδες",
"Use cache for external images" => "Χρήση cache για εξωτερικές εικόνες",
"No" => "Όχι",
"Yes" => "Ναι",
"Sender Email" => "Email αποστολέα",
"Maximum number of records in listings" => "Μέγιστος αριθμός εγγραφών στις παρουσιάσεις λιστών",
"groups" => "ομάδες",
"Admin groups" => "Διαχείριση ομάδων",
"Admin users" => "Διαχείριση χρηστών",
"Validate users by email" => "Επαλήθευση χρηστών μέσω email",
"Only for users" => "Μόνο για χρήστες",
"Users and admins" => "Χρήστες και διαχειριστές",
"Duration:" => "Διάρκεια:",
"day" => "ημέρα",
"week" => "εβδομάδα",
"<b>Max number of items</b>" => "<b>Μέγιστος αριθμός αντικειμένων</b>",
"Content" => "Περιεχόμενο",
"Publish" => "Δημοσίευση",
"Site logo" => "Λογότυπο δικτυακού τόπου",
"Site logo background color" => "Χρώμα υποβάθρου του λογότυπου",
"change" => "αλλαγή",
"english" => "αγγλικά",
"Creator" => "Δημιουργός",
"Undo" => "Αναίρεση",
"PDF generation" => "παραγωγή PDF",
"Pictures" => "Εικόνες",
"Show page title" => "Προβολή τίτλου σελίδας",
"Copyright Management" => "Διαχείριση Copyright",
"Sections" => "Ενότητες",
"lang" => "γλώσσα",
"yes" => "ναι",
"admin categories" => "διαχείριση κατηγοριών",
"Add new category" => "Δημιουργία κατηγορίας",
"type" => "τύπος",
"Add objects to category" => "Πρόσθεσε αντικείμενα στην κατηγορία",
"charts" => "διαγράμματα",
"Active" => "Ενεργό",
"Refresh rate" => "Ρυθμός ανανέωσης",
"Half a second" => "Μισό δευτερόλεπτο",
"second" => "δευτερόλεπτο",
"Admin templates" => "Διαχείριση προτύπων",
"Create new template" => "Δημιουργία νέου προτύπου",
"last modif" => "τελευταία τροποποίηση",
"sections" => "ενότητες",
"Default ordering for topics" => "Προεπιλεγμένη ταξινόμηση θεματικών κατηγοριών",
"Date (desc)" => "Ημερομηνία (desc)",
"Date (asc)" => "Ημερομηνία (asc)",
"Score (desc)" => "Βαθμολογία (desc)",
"Replies (desc)" => "Απαντήσεις (desc)",
"Reads (desc)" => "Αναγνώσεις (desc)",
"Title (desc)" => "Τίτλος (desc)",
"Title (asc)" => "Τίτλος (asc)",
"Topic list configuration" => "Ρυθμίσεις λίστας θεματικών κατηγοριών",
"Replies" => "Απαντήσεις",
"Database" => "Βάση Δεδομένων",
"topics" => "θέματα",
"age" => "ηλικία",
"last post" => "τελευταία δημοσίευση",
"Word" => "Λέξη",
"Add" => "Προσθήκη",
"Edit this page" => "Τροποποίησε αυτήν την σελίδα",
"View page" => "Προβολή σελίδας",
"Zone" => "Ζώνη",
"Dynamic zones" => "Δυναμικές ζώνες",
"zone" => "ζώνη",
"content" => "περιεχόμενο",
"Mass update" => "Μαζική ενημέρωση",
"Create new HTML page" => "Δημιουργία νέας σελίδας HTML",
"Edit this HTML page:" => "Τροποποίηση σελίδας:",
"Page name" => "Όνομα σελίδας",
"Dynamic" => "Δυναμικό",
"Static" => "Στατικό",
"Add new rule" => "Προσθήκη νέου κανόνα",
"new rule" => "νέος κανόνας",
"Copy" => "Αντιγραφή",
"Replace" => "Αντικατάσταση",
"Preview options" => "Επιλογές προεπισκόπησης",
"Code preview" => "Προεπισκόπηση κώδικα",
"Admin layout" => "Διαχείριση layout",
"layout options" => "επιλογές layout",
"title" => "τίτλος",
"open new window" => "άνοιξε νέο παράθυρο",
"Frequency" => "Συχνότητα",
"List menus" => "Λίστα menu",
"section" => "ενότητα",
"option" => "επιλογή",
"Home Page" => "Αρχική Σελίδα",
"User preferences" => "Επιλογές χρηστών",
"User prefs" => "Επιλογές χρηστών",
"All articles" => "Όλα τα άρθρα",
"File galleries" => "Συλλογές Αρχείων",
"options" => "επιλογές",
"Admin Modules" => "Διαχείριση Αρθρωμάτων",
"admin modules" => "διαχείριση αρθρωμάτων",
"assign module" => "ανάθεση αρθρώματος",
"left modules" => "αριστερά αρθρώματα",
"right modules" => "δεξιά αρθρώματα",
"edit/create" => "τροποποίηση/δημιουργία",
"clear cache" => "καθαρισμός cache",
"assign" => "ανάθεση",
"Assign new module" => "Ανάθεση νέου αρθρώματος",
"Edit this assigned module:" => "Τροποποίηση:",
"Module Name" => "Όνομα Αρθρώματος",
"left" => "αριστερά",
"right" => "δεξιά",
"Rows" => "Σειρές",
"Parameters" => "Παράμετροι",
"rows" => "σειρές",
"create/edit" => "δημιουργία/τροποποίηση",
"Event" => "Συμβάντα",
"event" => "συμβάν",
"object" => "αντικείμενο",
"Option" => "Επιλογή",
"Category" => "Κατηγορία",
"admin RSS modules" => "διαχείριση RSS αρθρωμάτων",
"Last update" => "Τελευταία τροποποίηση",
"Filename" => "Όνομα αρχείου",
"tree" => "δέντρο",
"Question" => "Ερώτηση",
"One choice" => "Μία επιλογή",
"Multiple choices" => "Πολλαπλές επιλογές",
"Questions" => "Ερωτήσεις",
"question" => "ερώτηση",
"questions" => "ερωτήσεις",
"files" => "αρχεία",
"Compile" => "Μεταγλώττιση",
"Admin Topics" => "Διαχείριση Θεματικών Κατηγοριών",
"Create a new topic" => "Δημιουργία Νέας Θεματικής Κατηγορίας",
"Topic Name" => "Όνομα",
"Upload Image" => "Νέα Εικόνα",
"List of topics" => "Λίστα θεματικών κατηγοριών",
"Articles (subs)" => "Άρθρα (subs)",
"Activate" => "Ενεργοποίηση",
"Deactivate" => "Απενεργοποίηση",
"Import" => "Εισαγωγή",
"Import/export" => "Εισαγωγή/εξαγωγή",
"created" => "δημιουργήθηκε",
"fields" => "πεδία",
"filename" => "όνομα αρχείου",
"filetype" => "τύπος αρχείου",
"admin groups" => "διαχείριση ομάδων",
"Add new group" => "Δημιουργία νέας ομάδας",
"List" => "Λίστα",
"Members" => "Μέλη",
"admin" => "διαχείριση",
"admin users" => "διαχείριση χρηστών",
"Add a new user" => "Προσθήκη νέου χρήστη",
"Never" => "Ποτέ",
"Delete" => "Διαγραφή",
"Back to groups" => "Επιστροφή στις ομάδες",
"level" => "επίπεδο",
"Assign user" => "Ανάθεση χρήστη",
"admin backups" => "διαχείριση αντιγράφων ασφαλείας",
"Warning!" => "Προσοχή!",
"Hours" => "Ώρες",
"Settings" => "Ρυθμίσεις",
"list articles" => "λίστα άρθρων",
"view articles" => "εμφάνιση άρθρων",
"Author Name" => "Όνομα Συγγραφέα",
"Mon" => "Δευ",
"Tue" => "Τρι",
"Wed" => "Τετ",
"Thu" => "Πεμ",
"Fri" => "Παρ",
"Sat" => "Σαβ",
"Sun" => "Κυρ",
"Translation" => "Μετάφραση",
"translate" => "μετάφραση",
"Browse" => "Πλοήγηση",
"Admin FAQ" => "Διαχείριση FAQ",
"View FAQ" => "Προβολή FAQ",
"Edit this FAQ" => "Τροποποίηση FAQ",
"new question" => "νέα ερώτηση",
"Edit FAQ questions" => "Τροποποίηση ερωτήσεων",
"Use a question from another FAQ" => "Χρήση ερώτησης από άλλο FAQ",
"FAQ questions" => "Ερωτήσεις",
"Suggested questions" => "Προτεινόμενες ερωτήσεις",
"create new gallery" => "δημιουργία νέας συλλογής",
"icon" => "εικονίδιο",
"Available File Galleries" => "Διαθέσιμες Συλλογές Αρχείων",
"topic" => "θεματική ενότητα",
"summary" => "περίληψη",
"normal" => "κανονικό",
"hot" => "καυτό",
"reject" => "απόρριψη",
"Real Name" => "Ονοματεπώνυμο",
"activity" => "δραστηριότητα",
"From:" => "Από:",
"exception" => "εξαίρεση",
"completed" => "ολοκληρώθηκε",
"aborted" => "ακυρώθηκε",
"Owner" => "Ιδιοκτήτης",
"Activities" => "Δραστηριότητες",
"Properties" => "Ιδιότητες",
"Property" => "Ιδιότητα",
"Value" => "Αξία",
"Add property" => "Προσθήκη ιδιότητας",
"value" => "αξία",
"Available Galleries" => "Διαθέσιμες Συλλογές",
"Imgs" => "Εικόνες",
"Pages like" => "Σελίδες παρόμοιες με την",
"List Articles" => "Λίστα Άρθρων",
"Create new FAQ" => "Δημιουργία νέου FAQ",
"add topic" => "προσθήκη θεματικής κατηγορίας",
"My tasks" => "Εργασίες",
"Msgs" => "μυνήματα",
"Notes" => "Σημειώσεις",
"back" => "πίσω",
"Assign permissions to page" => "Ανάθεση δικαιωμάτων για την σελίδα",
"Use Image" => "Χρήση Εικόνας",
"Total reads" => "Συνολικές αναγνώσεις",
"User Preferences" => "Προτιμήσεις Χρήστη",
"Personal Information" => "Προσωπικές Πληροφορίες",
"General preferences" => "Γενικές Προτιμήσεις",
"Other preferences" => "Άλλες Επιλογές",
"HomePage" => "ΑρχικήΣελίδα",
"Your personal Wiki Page" => "Η προσωπική σου σελίδα Wiki",
"Local" => "Τοπική",
"User information" => "Πληροφορίες χρήστη",
"Messages per page" => "μυνήματα ανά σελίδα",
"Tasks per page" => "Εργασίες ανά σελίδα",
"priority" => "προτεραιότητα",
"post new comment" => "αποστολή νέου σχολίου",
"Details" => "Λεπτομέρειες",
"DATE-of" => "of",
"Unknown group" => "Άγνωστη ομάδα",
"Group doesnt exist" => "Δεν υπάρχει τέτοια ομάδα",
"Unknown user" => "Άγνωστος χρήστης",
"User doesnt exist" => "Δεν υπάρχει τέτοιος χρήστης",
"Last posts" => "Τελευταίες δημοσιεύσεις",
"The SandBox is disabled" => "Ο Δοκιμαστικός Σωλήνας είναι απενεργοποιημένος",
"Invalid username" => "Μη έγκυρο όνομα χρήστη",
"Invalid file name" => "Μη έγκυρο όνομα αρχείου",
"Error: " => "Σφάλμα: ",
"Last pages" => "Τελευταίες σελίδες",
"Last modifications to the Wiki." => "Τελευταίες αλλαγές στο wiki",
"###end###"=>"###end###");
?>
