<?php // -*- coding:utf-8 -*-
// parameters:
// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated
// comments   : generate all comments (equal to close&module)
// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made
// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)
// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer
// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)
// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)
// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate langauage 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate langauage 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Wiki page" => "Sivu",
"pageviews" => "sivunäyttöjä",
"Security check failed!" => "Turvallisuus tarkistus epäonnistui!",
"Your Tiki account information for" => "Sinun tilisi tiedot",
"A password reminder email has been sent " => "Salasanan muistutus lähetetty ",
"A new password has been sent " => "Uusi salasana on lähetetty ",
"You have to type a searchword" => "Kirjoita etsintä sana",
"Upload was not successful (maybe a duplicate file)" => "Lähetys ei onnistunut (ehkä sillä nimellä on tiedosto)",
"You have to provide a name to the image" => "Sinun on annettava nimi kuvalle",
"Invalid password.  You current password is required to change your email address." => "Väärä salasana.  Nykyinen salasanasi tarvitaan voidaksesi muuttaa sähköpostiosoitetta.",
" new topic:" => " uusi aihe:",
"topic:" => "aihe:",
"You are not permitted to edit someone else\\'s post!" => "Et voi muokata kenenkään toisen posteja!",
"Only an admin can remove a thread." => "Vain ylläpito voi poistaa ketjun.",
"forum topic" => "foorumin aihe",
"New article submitted at " => "Uusi artikkeli lisätty ",
" line " => " rivi ",
"Error: Invalid" => "Virhe: Väärä",
"Error: No" => "Virhe: Ei",
"permission." => "lupa.",
"Error: Call to hw_page_fetch_by_id failed!" => "Virhe: Kutsu hw_page_fetch_by_id epäonnistui!",
"New message arrived from " => "Uusi viesti vastaanotettu: ",
"Welcome to " => "Tervetuloa ",
"Bye bye from " => "Heippa ",
" at " => "  ",
"Insert articles into a wikipage" => "Lisää artikkeli sivulle",
"note: those parameters are exclusive" => "huomio: nuo parametrit ovat valikoivia",
"__key__ | __defaults__ | __comments__\n" => "__key__ | __oletus__ | __kommentit__\n",
"Are you sure you want to delete this attachment?" => "Oletko varma, että haluat poistaa liitteen?",
"Click here to delete this attachment" => "Paina tästä, poistaaksesi liitteen",
"Posted comments" => "Lähetetyt kommentit",
"Are you sure you want to delete this comment?" => "Oletko varma, että haluat poistaa kommentin?",
"Click here to delete this comment" => "Paina tästä, poistaaksesi kommentin",
"reply to this" => "vastaa tähän",
"parent" => "isäntä",
"Reply to parent comment" => "Vastaa isäntä kommenttiin",
"Are you sure you want to delete this copyright?" => "Oletko varma, että haluat poistaa tämän copyrightin?",
"Click here to delete this copyright" => "Paina tästä, poistaaksesi copyright",
"compose message tpl" => "muodosta viesti tpl",
"messages tpl" => "viestien tpl",
"Return to messages" => "Palaa viesteihin",
"Unflagg" => "Poista merkki",
"Click here to unassign this module" => "Paina tästä, poistaaksesi modulin",
"Admin structures" => "Hallitse rakenteita",
"Reduce area width" => "Pienennä alueen leveyttä",
"Enlarge area width" => "Suurenna alueen leveyttä",
"Blog settings" => "Blogi asetukset",
"In blog listing show user as" => "Blogi listalla näytä käyttäjät",
"CMS settings" => "CMS asetukset",
"FAQs settings" => "UKK asetukset",
"FAQ comments" => "UKK kommentit",
"Email Encoding" => "Sähköpostin koodaus",
"Time Zone" => "Aika Vyöhyke",
"Server time zone" => "Palvelimen Aika Vyöhyke",
"Time Zone Map" => "Aika Vyöhyke Kartta",
"Remind passwords by email" => "Muistuta salasanoista sähköpostilla",
"Poll settings" => "Poll settings",
"Append CSS file to feed urls" => "Lisää CSS urlin syötteeseen",
"Publisher" => "Julkaisija",
"Create a tag for the current wiki" => "Luo kiinnike nykyiseen sivustoon",
"Restore the wiki" => "Palauta wiki",
"Tag Name" => "Kiinnikkeen nimi",
"Remove a tag" => "Poista kiinnike",
"Wiki comments settings" => "Wiki kommenttien asetukset",
"Wiki page list configuration" => "Wiki sivulistaus asetukset",
"Ranking" => "Arvostus",
"Warn on edit" => "Varoita muokkauksesta",
"Set" => "Aseta",
"Administration" => "Ylläpito",
"Are you sure you want to delete this rule?" => "Oletko varma, että haluat poistaa tämän säännön?",
"List Calendars" => "Listaa Kalenterit",
"Are you sure you want to delete this calendar?" => "Oletko varma, että haluat poistaa tämän kalenterin?",
"Delete item from category?" => "Poista luokan osa?",
"Are you sure you want to delete this category?" => "Oletko varma, että haluat poistaa tämän luokan?",
"admin charts tpl" => "ylläpidä kaavio tpl",
"ChatAdmin" => "JutYlläp",
"ChatAdmin tpl" => "JutYlläp tpl",
"Click here to delete this channel" => "Paina tästä poistaaksesi tämän kanavan",
"Are you sure you want to delete this channel?" => "Oletko varma, että haluat poistaa tämän kanavan?",
"admin content templates tpl" => "ylläpidä sisältö mallien tpl",
"Click here to delete this template" => "Paina tästä poistaaksesi tämän mallin",
"Are you sure you want to delete this template?" => "Oletko varma, että haluat poistaa tämän mallin?",
"Are you sure you want to delete this cookie?" => "Oletko varma, että haluat poistaa tämän keksin?",
"Click here to delete this cookie" => "Paina tästä poistaaksesi tämän keksin",
"admin Drawings" => "ylläpidä Piirroksia",
"Are you sure you want to delete this drawing?" => "Oletko varma, että haluat poistaa tämän piirroksen?",
"Click here to delete this drawing" => "Paina tästä poistaaksesi tämän piirroksen",
"AdminDSN" => "YlläpidäDSN",
"Are you sure you want to delete this dsn?" => "Oletko varma, että haluat poistaa tämän dsn:n?",
"admin ExternalWiki" => "ylläpidä UlkoinenWiki",
"tiki admin external wikis tpl" => "tiki ylläpidä ulkoinen wiki tpl",
"Are you sure you want to delete this external wiki?" => "Oletko varma, että haluat poistaa tämän ulkoisen wikin?",
"admin forums tpl" => "ylläpidä foorumien tpl",
"Threads can be voted" => "Ketjuja voi äänestää",
"Are you sure you want to delete this forum?" => "Oletko varma, että haluat poistaa tämän foorumin?",
"admin hotwords tpl" => "ylläpidä hotwords tpl",
"Are you sure you want to delete this hotword?" => "Oletko varma, että haluat poistaa tämän hotword?",
"admin HtmlPages" => "ylläpidä HtmlSivuja",
"admin HtmlPages tpl" => "ylläpidä HtmlSivun tpl",
"Are you sure you want to delete this HTML page?" => "Oletko varma että haluat poistaa tämän HTML sivun?",
"Are you sure you want to delete this repository?" => "Oletko varma, että haluat poistaa tämän säilytyspaikan?",
"Click here to delete this repository" => "Paina tästä poistaaksesi tämän säilytyspaikan",
"Click here to delete this rule" => "Paina tästä poistaaksesi tämän säännön",
"admin featured links tpl" => "ylläpidä ominaisuus linkkien tpl",
"WebMail accounts" => "WebMail tilit",
"admin mailin tpl" => "ylläpidä mail tpl",
"Are you sure you want to delete this menu?" => "Oletko varma, että haluat poistaa tämän valikon?",
"Click here to delete this menu" => "Paina tästä poistaaksesi tämän valikon",
"Edit tpl" => "Muuta tpl",
"Click here to edit this menu" => "Paina tästä muokataksesi tätä valikkoa",
"Click here to configure this menu" => "Paina tästä muuttaaksesi tämän valikon kokoonpanoa",
"admin modules tpl" => "ylläpidä moduulien tpl",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br/>\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Huomaa 1</b>: jos annat käyttäjien muokata moduuleja liitetyt\nmoduulit eivät reagoi näytöllä ennen kuin muokkaat niitä\nMyTiki->modules valikosta.<br/>\n<b>Huomaa 2</b>: Jos liität moduuleja ryhmille pidä huoli että sinulla on \nvalinta merkattuna 'näytä kaikki moduulit kaikille aina'\nYlläpito->Yleiset\n",
"Add all your site users to this newsletter (broadcast)" => "Lisää kaikki sivuston käyttäjät tähän uutislehteen (lähetykseen)",
"Add users" => "Lisää käyttäjiä",
"admin newsletters tpl" => "ylläpidä uutislehden tpl",
"admin notifications tpl" => "ylläpidon ilmoitus tpl",
"admin polls tpl" => "ylläpidä äänestyksien tpl",
"tiki admin quicktags tpl" => "ylläpidä pikalisien tpl",
"admin RSSmodules tpl" => "ylläpidä RSSmoduulien tpl",
"admin structures tpl" => "ylläpidä rakenne tpl",
"admin surveys tpl" => "ylläpidä tutkimusten tpl",
"Create New Survey:" => "Luo Uusi Tutkimus:",
"stat" => "tila",
"admin topics tpl" => "ylläpidä aiheiden tpl",
"(Dropdown options : list of items separated with commas)" => "(Alasveto vaihtoehdot : lista osista eroteltuna pilkulla)",
"(Image options : xSize,ySize indicated in pixels)" => "(Kuva vaihtoehdot : xKoko,yKoko annetaan pixeleinä)",
"Show status when listing tracker items?" => "Näytä tila kun listataan kortiston osia?",
"admin groups tpl" => "ylläpidä ryhmien tpl",
"Add New Group" => "Lisää Uusi Ryhmä",
"Edit this group:" => "Muokkaa tätä ryhmää:",
"Are you sure you want to delete this group?" => "Oletko varma, että haluat poistaa tämän ryhmän?",
"admin users tpl" => "ylläpidä käyttäjä tpl",
"Batch upload (CSV file)" => "Joukko lähetys (CSV tiedosto)",
"File gals" => "Tiedosto gal",
"Image gals" => "Kuva gal",
"Comm" => "Komm",
"Cms" => "Cms",
"Content Templates" => "Sisältö Mallit",
"ExtWikis" => "ExtWikit",
"assgn" => "assgn",
"Klick to enlarge" => "Paina suurentaaksesi",
"You can include the image in an HTML or Tiki page using" => "Voit lisätä kuvan HTML tai normaali sivulle käyttäen",
"Calendars Panel" => "Kalenterien Paneeli",
"Events Panel" => "Tapahtumien Paneeli",
"Add Calendar Item" => "Lisää Kalenterin Osa",
"-1m" => "-1m",
"-7d" => "-7d",
"-1d" => "-1d",
"+1d" => "+1d",
"+7d" => "+7d",
"+1m" => "+1m",
"today" => "tänään",
"save a custom copy" => "tallenna muunneltu kopio",
"For more information, please see <a\nhref=\"http://www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\non <a href=\"http://www.tikiwiki.org\">Tikiwiki.org</a>." => "Lisätietoja, katso <a\nhref=\"http://www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\non <a href=\"http://www.tikiwiki.org\">Tikiwiki.org</a>.",
"use square brackets for an" => "käytä hakasulkuja",
"link_description" => "linkki_kuvaus",
"Prevents parsing data" => "Estää tiedon jäsentämisen",
"Reuse question" => "Uudellen käytä kysymys",
"Edit Submissions" => "Muokkaa Ehdotuksia",
"file galleries tpl" => "tiedosto galleria tpl",
"act status" => "act tila",
"running" => "käynnissä",
"Add scaled images size X x Y" => "Lisää muutetut kuvat kokoa X x Y",
"admin DynamicContent" => "ylläpidä MuuttuvaSisältö",
"op" => "op",
"MyTikiDoc" => "OmaSivuOhje",
"Comparing versions" => "Verrataan versioita",
"Actual_version" => "Varsinainen_versio",
"Diff to version" => "Erot versioon",
"Received Pages" => "Vastaanotetut Sivut",
"Send Objects" => "Lähetä Kohteet",
"The cord" => "Nauha",
"Show chart for the last " => "Näytä kaavio jossa viimeiset ",
"days (0=all)" => "päivää (0=all)",
"Control by Object" => "Hallinta Kohteella",
"Control by category" => "Hallinta Luokalla",
"use filename" => "käytä tiedostonimeä",
"remove bookmark" => "poista kirjanmerkki",
"Use dbl click to edit pages" => "Käytä kaksoisklikkausta muokataksesi sivuja",
"Change your email" => "Muuta sähköposti osoitettasi",
"change email" => "muuta sähköposti",
"Change your password" => "Muuta salasanasi",
"change password" => "muuta salasana",
"Configure this page" => "Konfiguroi tätä sivua",
"All tasks" => "Kaikki tehtävät",
"mark as done" => "merkitse tehdyksi",
"open tasks" => "avaa tehtävät",
"Add or edit a task" => "Lisää tai muokkaa tehtävää",
"Start date" => "Aloitus päivä",
"Completed" => "Valmis",
"perm" => "pysyvä",
"FAQ Questions" => "UKK kysymykset",
"FAQ Answers" => "UKK Vastaukset",
"Show suggested questions/suggest a question" => "Näytä ehdotettuja kysymyksiä/ehdotettua kysymystä",
"Hide suggested questions" => "Piilota ehdotetut kysymykset",
"this post was reported" => "tämä lähetys oli raportoitu",
"report this post" => "raportoi tämä lähetys",
"Tracker Items" => "Kortiston osat",
"Filters" => "Suotimet",
"checked" => "merkitty",
"unchecked" => "merkitsemätön",
"Are you sure you want to delete this tracker?" => "Oletko varma, että haluat poistaa tämän kortiston?",
"Click here to delete this tracker" => "Paina tästä poistaaksesi tämän kortiston",
"Editing tracker item" => "Muuta kortiston osaa",
"Click here to edit this comment" => "Paina tästä muokataksesi tätä kommenttia",
"Webmail Doc tpl" => "Webmail Doc tpl",
"Are you sure you want to delete this contact?" => "Oletko varma, että haluat poistaa tämän yhteyden?",
"Click here to delete this contact" => "Paina tästä poistaaksesi yhteys",
"someone from" => "joku",
"requested a reminder of the password for the" => "pyydetty muistutus salasanasta",
"since this is your registered email address we inform that the" => "mikäli tämä on sinun rekisteröity sähköpostiosoitteesi tiedotamme",
"password for this account is" => "salasana tähän jäsenyyteen on",
"Information:" => "Tiedot:",
"You can edit the page following this link:" => "Voit muokata sivua seuraamalla tätä linkkiä:",
"Diff:" => "Erot:",
"The new page content is:" => "Uuden sivun sisältö on:",
"You can view the page following this link:" => "Voit katsoa sivua seuraavasta linkistä:",
"You can view the page by following this link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}" => "Voit katsoa sivua seuraamalla tätä linkkiä:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "Voit muokata sivua seuraamalla linkkiä:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "Voit katsoa erot edelliseen versioon\ntästä linkistä:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"Are you sure you want to delete this directory?" => "Oletko varma, että haluat poistaa tämän hakemiston?",
"Are you sure you want to delete this file?" => "Oletko varma, että haluat poistaa tämän tiedoston?",
"More info about" => "Lisää tietoa koskien",
"idle" => "odottava",
"Click the :: option on the menu for more options." => "Paina :: vaihtoehtoa valikosta saadaksesi lisää vaihtoehtoja.",
"Please also see" => "Katso myös",
"Admin->Modules" => "Ylläpidä->Moduuleja",
"Insert javascript into a page on the fly! You can both include an external file and/or just type the javascript in between the tags" => "Lisää javascript:in lennossa sivulle! Voit molempia joko antaa tiedostonimen/tai kirjoittaa suoraan javascripti tagien väliin",
"typed-inline javascript" => "kirjoitettu-sisä javascript",
"%A %d %B, %Y" => "%A %d %B, %Y",
"%A %d %B, %Y[%H:%M:%S %Z]" => "%A %d %B, %Y[%H:%M:%S %Z]",
"%a %d %b, %Y" => "%a %d %b, %Y",
"%a %d %b, %Y[%H:%M %Z]" => "%a %d %b, %Y[%H:%M %Z]",
"You do not have permission to write the template\".': '.\$file));\n\t\t\$smarty->display('error.tpl');\n\t\tdie;\n\t}\n\t\$_REQUEST[\"data\"] = str_replace(\"\r\n" => "Oikeutesi eivät riitä kirjoittamaan malleja\".': '.\$file));\n\t\t\$smarty->display('error.tpl');\n\t\tdie;\n\t}\n\t\$_REQUEST[\"data\"] = str_replace(\"\r\n",
"Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\r\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\r\n\r\nDone! You should be logged in." => "Paina seuraavaa linkkiä varmistaaksesi toivomuksesi uudesta salasanasta ja mene ruudulle kirjoittamaan uusi \"pysyvä\" salasana. Valitse salasanaksi sellainen jonka vain sinä tiedät äläkä kerro sitä muille.\r\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\r\n\r\nTehty! Olet kirjautunut sisään.",
"from\r\nthe mapfile:" => "\r\nkarttatiedostosta:",
"Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://dev.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Katso <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://dev.tikiwiki.org/tiki-index.php?page=Features\">ominaisuuden kehittelystä</a> Tikin kehittäjien toimesta.",
"Create a group for each user <br />(with the same\r\nname as the user)" => "Luo ryhmä jokaiselle käyttäjälle <br />(jolla on sama\r\nnimi kuin käyttäjä)",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library\r\nwill not work with old library and conversely" => "WAROITUS : Vanha ja Uusi kortisto eivät voi esiintyä yhtaikaa. Uudella kirjastolla luodut kortistot\r\neivät toimi vanhojen kanssa ja päinvastoin",
"An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">ominaisuus linkki</a> ominaisuus." => "Helpoin tapa tuoda aineistoa toiselta sivustolta suoraan sivuston sivuksi <a class=\"rbox-link\" href=\"tiki-admin_links.php\">ominaisuuslinkit</a> ominaisuus.",
"To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "Käyttääksesi <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduulia</a> tai mallia, käytä {literal}{menu id=x}{/literal}, missä x on valikon ID. Käyttääksesi <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, voit käyttää yhtä näistä kolmesta esitystavasta:",
"\r\n<b>Note 1</b>: if you allow your users to configure modules then assigned\r\nmodules won't be reflected in the screen until you configure them\r\nfrom MyTiki->modules.<br />\r\n<b>Note 2</b>: If you assign modules to groups make sure that you\r\nhave turned off the option 'display modules to all groups always'\r\nfrom Admin->General\r\n" => "\r\n<b>Huomaa 1</b>: jos annat käyttäjien muokata moduulien asetuksia\r\nmoduulit eivät reagoi näytöllä ennen kuin ne määritellään\r\nOmaValikko->moduulit.<br />\r\n<b>Huomaa 2</b>: Jos liität moduuleja ryhmille \r\non valinta 'näytä moduulit kaikille aina' pois päältä\r\nYlläpito->Yleiset\r\n",
"tracker name must be unique, field names must be unique \r\nfor a tracker and they must be valid in SQL" => "kortiston nimi on oltava ainutkertainen, samoin kenttien nimet \r\nkortistossa, nimien on sovelluttava SQL kyselyyn",
"Note: if you want to use images please save the post first and you\r\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\r\nor use the image URL to include images using the WYSIWYG editor. " => "Huomaa: jos haluat käytää kuvia niin tallenna lähetys ensin ja voit\r\nmuokata/lähetettyjä kuvia. Käytä &lt;img&gt; leikettä lisätäksesi kuva tekstialueelle\r\ntai käytä kuvan URL osoitetta suoraan WYSIWYG muokkaimessa. ",
"Apache has the right to write in your file tree, which enables the installation, removal or \r\nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \r\n\"./fixperms.sh fix\" for example)." => "Apachella on oikeus kirjoittaa hakemistopuuhusi, mikä sallii asennuksen, poiston tai \r\npakettien päivityksen. Kun nuo asennukset on tehty, kannattaa oikeudet palauttaa turvalliseen tilaan (käyttäen \r\n\"./fixperms.sh fix\" esimerkiksi).",
"To install, remove or upgrade packages you need to give the apache user the right\r\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\r\npermission (using \"./fixperms.sh fix\")." => "Asentaaksesi, poistaaksesi tai päivittääksesi paketteja sinun on annettava apache käyttäjälle oikeudet\r\nkirjoittaa tiedostoja web puuhun (voit käyttää \"./fixperms.sh open\" komentoa). Asennuksen jälkeen palauta\r\noikeudet (käyttäen \"./fixperms.sh fix\").",
"Your message has been queued for approval, the message will be posted after\r\na moderator approves it." => "Viestisi on laitettu hyväksyntä jonoon, se lähetetään kun\r\na ylläpitäjä hyväksyy sen.",
"www.plazes.com" => "www.plazes.com",
"ver" => "ver",
"Jukebox" => "Jukebox",
"Workspace not selected" => "Työaluetta ei valittu",
"Permission denied you cannot edit assignments" => "Oikeutesi eivät riitä liitosten muokkaamiseen",
"Permission denied you cannot create assignments" => "Oikeuteisi eivät riitä luomaan liitoksia",
"Permission denied you cannot remove assignments" => "Oikeutesi eivär riitä poistamaan liitoksia",
"Workspace not found" => "Työaluetta ei löytynyt",
"Resource name not selected" => "Resurssin nimeä ei valittu",
"Resource not found" => "Resurssia ei löytynyt",
"Name requiered" => "Tarvitaan nimi",
"Module not set" => "Moduulia ei ole asetettu",
"Closed Workspace" => "Suljettu Työalue",
"Workspace type not found" => "Työalue tyyppiä ei löytynyt",
"Code in use, please select a different code" => "Koodi on käytössä, valitse toinen koodi",
"Code not selected" => "Koodia ei valittu",
"Sorry, the currency \$currency is not available." => "Valitan, valuutta \$currency ei ole saatavilla.",
"Sorry, you are not registered into currency \$currency." => "Valitan, et ole rekisteröitynyt valuuttaan \$currency.",
"DNS check failed for %s" => "DNS tarkistus epäonnistui %s",
"Request failed for %s" => "Pyyntö epäonnistui %s",
"WikiDiff::apply: line count mismatch: %s != %s" => "Diff::lisää: rivilaskuri sopimaton: %s != %s",
"WikiDiff::_check: failed" => "Diff::_tarkistus: epäonnistui",
"WikiDiff::_check: edit sequence is non-optimal" => "Diff::_tarkistus: muokkaus järjestys ei optimaalinen",
"WikiDiff Okay: LCS = %s" => "Diff Okei: LCS = %s",
"Project Group for " => "Ryhmä Hanke ",
"Project Admin Group for " => "Hankkeen Ylläpito Ryhmä ",
"no description" => "ei kuvausta",
"Image options: xListSize,yListSize,xDetailsSize,yDetailsSize indicated in pixels." => "Kuva vaihtoehdot: xListaaKoko,yListaaKoko,xYksityiskohtainenKoko,yYksityiskohtainenKoko näytetään pixeleinä.",
"Puts an anchor and links to the anchor onto a wiki page" => "Laittaa ankkurin ja linkittää ankkurin sivulle",
"~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,aihe=>aiheNimi)}{ARTICLES} Laittaa artikkelit sivulle",
"Insert CSS styles into a wiki page on the fly! You can both include an external file and/or just type the CSS in between the tags" => "Liittää CSS tyylin sivulle lennossa! Voit molempia joko liittää ulkoisen tiedoston/tai kirjoittaa CSS määrittelyn tagien väliin",
"typed-inline style" => "kirjoitettu-sisä tyylinä",
"Insert an iframe into a wiki page. Put the web address in between the tags (the URL of the page you want to show." => "Laittaa iframe:in sivulle. Laittaa verkko osoitteen tagien väliin (eli URL:in sivusta jonka haluat näyttää.",
"Insert an AUTO-SIZING iframe into a wiki page. Only works right for internal pages (those under the same domain as your Tiki.)<br />The iframe height sizes to the height of the contained page. Put the web address in between the tags (the URL of the page you want to show." => "Laittaa AUTO-SIZING iframe:in sivulle. Toimii oikein vain sisäisillä sivuilla (omalla sivustolla.)<br />iframe korkeus on sisältönä olevan sivun korkeus. Laittaa verkko osoitteen tagien väliin (sivun URL jonka haluat näyttää.",
"Insert a javascript file or/and some javascript code." => "Lisää javascript tiedosto tai/ja jotain javascript koodia.",
"javascript code" => "javascript koodi",
"Insert javascript into a page." => "Lisää javascript sivulle.",
"Loads a complete WebPage into the Wiki page.<BR>Parameter: page=Page to load, replaceLink=add this URL to all Links, onlyBody='yes' search for body tag to diplay only body." => "Lataa koko verkkosivun sivuston sivulle.<BR>Parametri: sivu=Ladattava sivu, korvaaLinkki=lisää tämä URL kaikkiin Linkkeihin, vainRunko='kyllä' etsii runko tagin näyttääkseen vain rungon.",
"Displays a Quicktime Movie on the wiki page" => "Näyttää Quicktime Elokuvan sivulla",
"URL to Movie" => "Elokuvan URL",
"with and height is optional if leaving blank 320 x 240 is used. controller is set to true by default." => "leveys ja korkeus ovat vaihtoehtoisia jos jätät tyhjäksi käytetään 320 x 240. Oletuksena hallinta on tosi.",
"Scroll" => "Vierittäjä",
"Put this on the page to modify the text size of the page on demand, by clicking on an Increase or Decrease Font Size link" => "Laittaa tämän sivulle tekstin koon muutosta varten, paina Suurenna tai Pienennä Kirjasimen Koko linkkiä",
"Displays an alphabetically sorted list of registered users" => "Näyttää aakkostetun luettelon rekisteröityneistä jäsenistä",
"Renders a graph, with linked pages navigation visually figured.\n" => "Luo kaavion, jossa sivut linkkeinä visuaalista siirtymistä varten.\n",
"the number of hops the graph follows\n" => "hyppyjen määrä joita seurataan\n",
"the title of the map\n" => "kartan otsikko\n",
"the space between nodes\n" => "sanaväli solmujen väliin\n",
"Left to Right, the direction of graph\n" => "Vasemmalta oikealle, kaavion suunta\n",
"the background color, use #rrvvbb color types.\n" => "taustaväri, käytä #rrvvbb väri arvoja.\n",
"nothing there, unlimited size. use 5,3 type sizes in inches\n" => "ei mitään siellä, rajoittamaton koko. käytä 5,3 koko tuumina\n",
"the font size in pts presumably\n" => "kirjasimen koko pisteinä\n",
"the name of the font used for labels\n" => "kirjasimen nimeä käytetään etiketeissä\n",
"the shape of a node. can be " => "solmun muoto. voi olla ",
"plaintext ellipse circle egg triangle box diamond trapezium parallelogram house hexagon octagon\n" => "tavallinenteksti ellipsi ympyrä muna kolmio laatikko timantti trapetsi rinnakkais talo hexagon octagon\n",
"style for drawing nodes.\n" => "solmujen piirtotyyli.\n",
"color of the border\n" => "kehyksen väri\n",
"background color of the node\n" => "solmun taustaväri\n",
"sortof relative width ??\n" => "lajitellaan suhteellinen leveys ??\n",
"same mystery as above\n" => "sama mysteerio kuin yllä\n",
"color for links (called edges here)\n" => "linkkien väri (kutsutaan reunoiksi täällä)\n",
"shape of the arrow that come with the link\n" => "nuolen muoto joka tulee linkin mukana\n",
"Displays an alphabetically sorted list of WikiPages" => "Näyttää aakkostetun listan sivuista",
"Resource type not selected" => "Resurssin tyyppiä ei valittu",
"Permission denied you cannot create new resources" => "Oikeutesi eivät riitä luomaan uutta resurssia",
"Permission denied, you cannot admin the workspace" => "Oikeutesi eivät riitä ylläpitämään resursseja",
"Not a portfolio workspace" => "Ei työnäyte työalue",
"Assignment not found" => "Liitosta ei löydy",
"Page not found\".\" \".\$page));\n\t}\n}else{\n\t\$smarty->assign('error_msg', tra(\"Param name not found" => "Sivua ei löydy\".\" \".\$page));\n\t}\n}tai{\n\t\$smarty->assign('error_msg', tra(\"Param nimeä ei löydy",
"Assignments Administration" => "Liitosten Ylläpito",
"are you sure to remove the assigment" => "oletko varma, että haluat poistaa liitoksen",
"Period" => "Ajanjakso",
"Grade Weight" => "Laatu Vaatimus",
"Start Date" => "Aloitus Päivä",
"End Date" => "Lopetus Päivä",
"Exam" => "Koe",
"Exercise" => "Harjoitus",
"New Assignment" => "Uusi Liitos",
"Weight" => "Taso",
"Cuaderno de Problemas de" => "Niputetut Ongelmat",
"Admin resource" => "Ylläpidä resurssia",
"Error:" => "Virhe:",
"My Workspaces" => "Oma Työalueeni",
"Code" => "Koodi",
"Object type:" => "Kohteen tyyppi:",
"Roles Administration" => "Roolien Ylläpito",
"Permission levels" => "Oikeustasot",
"Subject Administration" => "Otsikon Ylläpito",
"Studies" => "Opinnot",
"Send" => "Lähetä",
"Gradebook" => "Arvostelukirja",
"Select period" => "Valitse ajanjakso",
"Save grades" => "Tallenna arvostelut",
"Workspace path:" => "Työalue polku:",
"Workspace Types Administration" => "Työalue Tyyppien Ylläpito",
"MenuID" => "ValikkoID",
"Hide" => "Piilota",
"Allow Anonymous" => "Salli Nimettömyys",
"Allow Registered" => "Salli Rekisteröityneet",
"Allow private user zone" => "Salli yksityinen käyttäjä alue",
"Workspace resources" => "Työalue resurssit",
"Workspace Types Resources" => "Työalue Tyyppien Resurssit",
"Workspace type name" => "Työalue tyypin nimi",
"Resource name" => "Resurssin nimi",
"Resource description" => "Resurssin kuvaus",
"Resource type" => "Resurssin tyyppi",
"Workspaces Administration" => "Työalueiden Ylläpito",
"Closed" => "Suljettu",
"User workspace" => "Käyttäjän työalue",
"Hide workspace" => "Piilota työalue",
"Assigned modules" => "Liitetyt moduulit",
"Remove all" => "Poista kaikki",
"Cache time" => "Puskurointi aika",
"Params" => "Param",
"AulaWiki Assistant" => "Aula Avustus",
"Welcome to AulaWiki" => "Tervetuloa Aulaan",
"First configuration steps" => "Kokoonpanon ensi askeleet",
"Workspace Calendar" => "Työalue Kalenteri",
"List events" => "Listaa tapahtumat",
"Child Workspaces" => "Ali Työtilat",
"Inactive workspace" => "Ei aktiivinen työtila",
"Clipboard" => "Leikepöytä",
"Workspace History" => "Työtila Historia",
"\$title" => "\$otsikko",
"Current workspace:" => "Nykyinen työtila:",
"Active workspace" => "Aktiivinen työtila",
"My workspaces:" => "Omat työtilat:",
"Resources" => "Resurssit",
"Category:" => "Luokka:",
"are you sure to remove object " => "haluatko varmasti poistaa kohteen ",
"UserGroups" => "KäyttäjäRyhmät",
"Group Name:" => "Ryhmän Nimi:",
"User name:" => "Käyttäjä nimi:",
"are you sure to remove group " => "haluatko varmasti poista ryhmän ",
"are you sure to remove user from group " => "haluatko varmasti poistaa käyttäjän ryhmästä ",
"User Workspaces" => "Käyttäjän Työtilat",
"Assignment details" => "Liitos yksityiskohdat",
"Grade" => "Arvostelu",
"Save Grades" => "Tallenna Arvostelut",
"Grade for" => "Arvostele",
"View Page" => "Näytä Sivu",
"View Structure" => "Näytä Rakenne",
"Workspace Members" => "Työtilan Jäsenet",
"offline users" => "koti käyttäjät",
"Personal portfolio" => "Oma työnäyte",
"Edit information" => "Muuta tietoja",
"Personal Learning Folder" => "Oma Opiskelu Kansio",
"Currencies Admin" => "Valuuttojen Ylläpito",
"Currency Provider Unique Name" => "Valuutan Tarjoajan uniikki nimi",
"Contact email" => "Yhteys sähköposti",
"Domain for list of CC service providers" => "Domain lista Valuutta palvelujen tarjoajista",
"Register" => "Rekisteröity",
"Approval?" => "Hyväksy?",
"Listed?" => "Listattu?",
"Population" => "Asukasluku",
"Transaction" => "Tapahtuma",
"Examine" => "Tutki",
"Unregister" => "Poista rekisteröinti",
"Reregister" => "Uudelleen rekisteröi",
"Pending Registration" => "Odottava Rekisteröinti",
"Modify a Currency" => "Muokkaa Valuuttaa",
"Create a new Currency" => "Luo uusi Valuutta",
"List Currencies" => "Listaa Valuutat",
"My Currencies" => "Omat Valuutat",
"Requires approval" => "Tarvitsee hyväksynnän",
"Listed publicly" => "Listattu julkisesti",
"Register Owner" => "Rekisterin Omistaja",
"Examine Currency" => "Tutki Valuuttaa",
"Edit currency" => "Muokkaa valuuttaa",
"Balance" => "Vaihtotase",
"Amount of transactions" => "Tapahtumien määrä",
"Number of transactions" => "Tapahtumien lukumäärä",
"Last transaction" => "Viimeinen tapahtuma",
"Approved?" => "Hyväksytty?",
"Main Ledger" => "PääKirja",
"New Transaction with" => "Uusi Tapahtuma",
"last transaction date" => "viimeisen tapahtuman päiväys",
"balance" => "vaihtotase",
"total volume" => "kokonaismäärä",
"transactions" => "tapahtumia",
"Show" => "Näytä",
"with" => " ",
"out" => "ulos",
"{\$thelist[i].age|duration} ago" => "{\$thelist[i].age|duration} sitten",
"Revert Transaction" => "Palauta Tapahtuma",
"record" => "tallenne",
"revert" => "palauta",
"Displays your Plazes info" => "Näyttää Paikkasi tiedot",
"Displays your Plazes WhereIs page" => "Näyttää paikkasi MissäOn sivun",
"New blog post: {\$mail_title}: {\$title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Uusi blogi kirjoitus: {\$mail_title}: {\$title} , {\$mail_user}: {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at\n{\$mail_date|tiki_short_datetime}" => "Sivua {\$mail_page} on muuttanut {\$mail_user}  \n{\$mail_date|tiki_short_datetime}",
"You can view the page by following this link:\n    {\$mail_machine}tiki-index.php?page={\$mail_page|escape:\"url\"}" => "Voit katsoa sivua seuraamalla tätä linkkiä:\n    {\$mail_machine}tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n    {\$mail_machine}tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "Voit muokata sivua seuraamalla tätä linkkiä:\n    {\$mail_machine}tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "Voit katsoa edellisiä versioita seuraamalla\ntätä linkkiä:\n    {\$mail_machine}tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"List Courses" => "Listaa Kurssit",
"Upcoming `\$module_rows` modified events" => "Tulossa olevat `\$module_rows` muutetut tapahtumat",
"Go \r\n                    back" => "Mene \r\n                    takaisin",
"Return to home \r\n                    page" => "Palaa etu \r\n                    sivulle",
"Confirmation required" => "Tarvitaan varmistus",
"Wiki quick help" => "Wiki pika apu",
"Quicklinks" => "Pikalinkit",
"Please" => "Pyydän",
"log in" => "kirjaudu",
"to access full functionalities" => "käyttääksesi täyttä toiminnallisuutta",
"Go \n                    back" => "Mene \n                    takaisin",
"Return to home \n                    page" => "Palaa omalle \n                    sivulle",
"Skip to navigation" => "Hyppää siirtymiin",
"MyTiki (click!)" => "OmatSivut (paina!)",
"Admin (click!)" => "Ylläpito (paina!)",
"TikiTabs" => "TikiTabit",
"Use Quote plugin for quoting" => "Käytä Lainaus plugia lainaukseen",
"LDAP Host" => "LDAP Isäntä",
"LDAP Port" => "LDAP Portti",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Käytä {literal}{{/literal}ed id=nimi} tai {literal}{{/literal}ted id=nimi} lisätäksesi muuttuvia alueita",
"Field is hidden? (visible by admin only)" => "Kenttä on piilotettu? (näkyy vain ylläpidolle)",
"slideshow backward" => "kuvaesitys taaksepäin",
"Emphasis" => "Korostaa",
"italics" => "kallistettu",
"both" => "molemmat",
"use ...page... to separate pages" => "käytä ...sivu... erottaaksesi sivut",
"make_headings" => "tee_pääosia",
"underlines text" => "alleviivaa tekstin",
"Simple box" => "Yksikertainen laatikko",
"Will display using the indicated HTML color" => "Näytetään käyttäen osoitettuja HTML värejä",
"Center" => "Keskitä",
"Will display the text centered" => "Näytetään teksti keskitettynä",
"Insert Module Output" => "Liitä Moduuli Tulostus",
"{literal}{MODULE(module=>some_module)}text{MODULE}{/literal}  can be used to insert the output of module \"some_module\" into your Wiki page. See <a href=\"{\$helpurl}PluginModule\">PluginModule</a> for more information. " => "{literal}{MODUULI(module=>some_module)}text{MODUULI}{/literal}  käytetään lisätäksesi moduulin tulostus \"some_module\" sivullesi. Katso <a href=\"{\$helpurl}PluginModule\">PluginModule</a> lisätietoihin. ",
"Rendering Program Code" => "Muodosta Ohjelma Koodi",
"{literal}{CODE()}some code{CODE} {/literal} will render \"some code\" as program code. This plugin has other options; see <a href=\"{\$helpurl}PluginCode\">PluginCode</a>." => "{literal}{CODE()}jotain koodia{CODE} {/literal} muodostaa \"jotain koodia\" ohjelmakoodin. Tällä plugilla on muita vaihtoehtoja; katso <a href=\"{\$helpurl}PluginCode\">PluginCode</a>.",
"Import pages from a PHPWiki Dump" => "Tuo sivuja PHPWiki Dumpista",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "Polku missä dumppi tiedostot ovat (suhteellinen tiki basedir kautta viivan kanssa ex: dump/)",
"You have to create a gallery first!" => "Sinun on luotava galleria ensin!",
"updated by the phpwiki import process" => "päivitetty phpwiki tuontiprosessissa",
"created from phpwiki import" => "luotu phpwiki tuonnista",
"Invalid variable value : " => "Väärä muuttujan arvo : ",
"Textarea options: quicktags,width,height,max - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved." => "Tekstialue valinnat: pikatagit,leveys,korkeus,max - Käytä Pikatageja on 1 tai 0, leveys ilmoitetaan merkkeinä, korkeus riveinä, max on maksimi määrä merkkejä jotka voidaan tallentaa.",
"You need to supply information for : " => "Sinun on annettava tietoja : ",
"Lists ''wanted'' Wiki pages" => "Listaus ''halutaan'' sivuja",
"Please follow the steps below to have your password properly reset:\n\n1. Click the following link to confirm you wish to reset your password:\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\n2. Click the following link to go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user}&oldpass={\$mail_pass}\n\nAlternatively, go to {\$mail_site} and login using your username and temporary password:\n Username:   {\$mail_user}\n Temporary password:  {\$mail_pass}\n\n3. Done! You should be logged in." => "Ole hyvä ja seuraa alla olevia ohjeita salasanan muuttamiseksi:\n\n1. Paina seuraavaa linkkiä varmistaaksesi salasanan vaihdon:\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\n2. Paina seuraavaa linkkiä päästäksesi ruudulle johon kirjoitat uuden \"pysyvän\" salasanan. Valitse salasana jonka vain sinä tiedät, äläkä kerro sitä muille.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user}&oldpass={\$mail_pass}\n\nVaihtoehtoisesti mene {\$mail_site} ja kirjaudu käyttäen käyttäjänimeäsi ja väliaikaista salasanaa:\n Käyttäjänimi:   {\$mail_user}\n Väliaikainen salasana:  {\$mail_pass}\n\n3. Tehty! Olet kirjautunut sisään.",
"Like pages" => "Sivut kuin",
"quater" => "neljäsosa",
"creates an editable drawing named foo" => "luo muokattavan piirroksen nimeltä foo",
"Activs" => "Toimint",
"Ins" => "Pyy",
"time" => "aikka",
"Preview Poll" => "Äänestyksen esikatselu",
"Jukebox preference" => "Jukebox asetukset",
"You do not have permission to write the template" => "Oikeutesi eivät riitä kirjoittamaan mallia",
"Go to your <a href=\"tiki-friends.php\">friendship network</a> to accept or refuse this request" => "Mene <a href=\"tiki-friends.php\">ystävä verkosto</a> hyväksyäksesi tai hylätäksesi pyyntö",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Tracker item" => "Tracker item",
// "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels.",
// "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Clickable Skype link" => "Clickable Skype link",
// "All fields must be from the same tracker" => "All fields must be from the same tracker",
// "Filters the items of a tracker, fields are indicated with numeric ids." => "Filters the items of a tracker, fields are indicated with numeric ids.",
// "missing parameters" => "missing parameters",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "incorrect filterfield" => "incorrect filterfield",
// "RSS Calendars" => "RSS Calendars",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "Current events" => "Current events",
// "RSS Feeds" => "RSS Feeds",
// "Calendars" => "Calendars",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "logout" => "logout",
// "i18n" => "i18n",
// "Print article" => "Print article",
// "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site.",
// "Google Maps" => "Google Maps",
// "Trackbacks Pings" => "Trackbacks Pings",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "I18n setup" => "I18n setup",
// "Best Language" => "Best Language",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Auth Type" => "Auth Type",
// "IMAP/POP3/LDAP Host" => "IMAP/POP3/LDAP Host",
// "IMAP/POP3/LDAP Port" => "IMAP/POP3/LDAP Port",
// "IMAP/POP3 BaseDSN" => "IMAP/POP3 BaseDSN",
// "Caching time :" => "Caching time :",
// "seconds (0 = cache inactive)" => "seconds (0 = cache inactive)",
// "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions." => "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions.",
// "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones" => "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature.",
// "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "Field is hidden?" => "Field is hidden?",
// "not hidden" => "not hidden",
// "visible by admin only" => "visible by admin only",
// "editable by admin only" => "editable by admin only",
// "Import/Export CSV Data" => "Import/Export CSV Data",
// "Download CSV export" => "Download CSV export",
// "tracker_{\$trackerId}.csv" => "tracker_{\$trackerId}.csv",
// "Import file" => "Import file",
// "remove users and their userpages" => "remove users and their userpages",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Cyclic" => "Cyclic",
// "Allow trackback pings" => "Allow trackback pings",
// "Bold text" => "Bold text",
// "underscores" => "underscores",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Centered text" => "Centered text",
// "colons" => "colons",
// "Underlined text" => "Underlined text",
// "equals" => "equals",
// "Text box" => "Text box",
// "One carat" => "One carat",
// "Will display using the indicated HTML color or color name" => "Will display using the indicated HTML color or color name",
// "make headings" => "make headings",
// "row" => "row",
// "col" => "col",
// "Horizontal rule" => "Horizontal rule",
// "to separate pages" => "to separate pages",
// "Save clicked point" => "Save clicked point",
// "Save current view as default" => "Save current view as default",
// "Reset view to site-wide default" => "Reset view to site-wide default",
// "Users Map" => "Users Map",
// "Tiki installer" => "Tiki installer",
// "MultiTiki setup" => "MultiTiki setup",
// "To add a new virtual host" => "To add a new virtual host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "Please enter your database connection info" => "Please enter your database connection info",
// "Database type" => "Database type",
// "The type of database you intend to use" => "The type of database you intend to use",
// "Host:" => "Host:",
// "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki" => "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki",
// "If you use SQLite, insert the path and filename to your database file" => "If you use SQLite, insert the path and filename to your database file",
// "Database user" => "Database user",
// "Database password" => "Database password",
// "Database name" => "Database name",
// "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names" => "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names",
// "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above" => "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above",
// "Welcome to the installation &amp; upgrade script!" => "Welcome to the installation &amp; upgrade script!",
// "Create database (clean install) with profile" => "Create database (clean install) with profile",
// "Descriptions of the available profiles" => "Descriptions of the available profiles",
// "Upgrade" => "Upgrade",
// "backup your database" => "backup your database",
// "with mysqldump or phpmyadmin before you proceed" => "with mysqldump or phpmyadmin before you proceed",
// "Update database using script" => "Update database using script",
// "For database update from 1.8 or later" => "For database update from 1.8 or later",
// "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script" => "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script",
// "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)" => "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)",
// "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions" => "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions",
// "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity" => "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity",
// "Do nothing and enter Tiki" => "Do nothing and enter Tiki",
// "Reset database connection settings" => "Reset database connection settings",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please enter your admin password to continue" => "Please enter your admin password to continue",
// "Print operations executed successfully" => "Print operations executed successfully",
// "Print operations failed" => "Print operations failed",
// "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application" => "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application",
// "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore" => "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore",
// "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!" => "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!",
// "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!" => "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!",
// "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at only 8 Megs" => "Tiki has detected your PHP memory limit at only 8 Megs",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Note" => "Note",
// "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation" => "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation",
// "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system" => "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system",
// "Now you may proceed by clicking one of these links" => "Now you may proceed by clicking one of these links",
// "Click here to disable the install script and proceed into tiki" => "Click here to disable the install script and proceed into tiki",
// "Click here to proceed into tiki without disabling the script" => "Click here to proceed into tiki without disabling the script",
// "Go back and run another install/upgrade script" => "Go back and run another install/upgrade script",
// "do not use your Back button in your browser!" => "do not use your Back button in your browser!",
// "Any" => "Any",
// "You have to \ncreate a gallery first!" => "You have to \ncreate a gallery first!",
// "use google map locator" => "use google map locator",
// "moved %d images, %d errors occured." => "moved %d images, %d errors occured.",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Site No validated yet" => "Site No validated yet",
// "Error : The file %s doesn't exist." => "Error : The file %s doesn't exist.",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "Back to preferences" => "Back to preferences",
// "An error occurred." => "An error occurred.",
// "Notice: invalid variable value:" => "Notice: invalid variable value:",
// "Permission denied you cannot remove trackbacks" => "Permission denied you cannot remove trackbacks",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Algeria" => "Algeria",
"Angola" => "Angola",
"Antigua" => "Antigua",
"Armenia" => "Armenia",
"Australia" => "Australia",
"Bahrain" => "Bahrain",
"Bangladesh" => "Bangladesh",
"Barbados" => "Barbados",
"Belarus" => "Belarus",
"Bermuda" => "Bermuda",
"Bolivia" => "Bolivia",
"Brunei" => "Brunei",
"Catalan_Countries" => "Catalan_Countries",
"Colombia" => "Colombia",
"Costa_Rica" => "Costa_Rica",
"El_Salvador" => "El_Salvador",
"Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
"Fiji" => "Fiji",
"Guatemala" => "Guatemala",
"Haiti" => "Haiti",
"Honduras" => "Honduras",
"Chile" => "Chile",
"Indonesia" => "Indonesia",
"Iran" => "Iran",
"Israel" => "Israel",
"Kazakstan" => "Kazakstan",
"Kiribati" => "Kiribati",
"Kuwait" => "Kuwait",
"Latvia" => "Latvia",
"Luxemburg" => "Luxemburg",
"Malawi" => "Malawi",
"Malta" => "Malta",
"Mauritius" => "Mauritius",
"Nauru" => "Nauru",
"Nicaragua" => "Nicaragua",
"Nigeria" => "Nigeria",
"Niue" => "Niue",
"Pakistan" => "Pakistan",
"Panama" => "Panama",
"Peru" => "Peru",
"Puerto_Rico" => "Puerto_Rico",
"Romania" => "Romania",
"Samoa" => "Samoa",
"Saudi_Arabia" => "Saudi_Arabia",
"Singapore" => "Singapore",
"Slovakia" => "Slovakia",
"Slovenia" => "Slovenia",
"Somalia" => "Somalia",
"Sri_Lanka" => "Sri_Lanka",
"Surinam" => "Surinam",
"Taiwan" => "Taiwan",
"Tonga" => "Tonga",
"Trinidad_Tobago" => "Trinidad_Tobago",
"Tuvalu" => "Tuvalu",
"Vanuatu" => "Vanuatu",
"Venezuela" => "Venezuela",
"Wales" => "Wales",
"Zambia" => "Zambia",
"Zimbabwe" => "Zimbabwe",
"Bulgaria" => "Bulgaria",
"Pijin Solomon" => "Pijin Solomon",
"tikiwiki logo" => "tikiwiki logo",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"%H:%M %Z" => "%H:%M %Z",
"km" => "km",
"index" => "index",
"max" => "max",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
", " => ", ",
"debug" => "debug",
"Top" => "Top",
"RSS Wiki" => "RSS Wiki",
"Hi," => "Hi,",
"Hi" => "Hi",
"Bye bye!" => "Bye bye!",
"Ip" => "Ip",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"phpinfo" => "phpinfo",
"Debugger console" => "Debugger console",
"DSN" => "DSN",
"Tiki Logo" => "Tiki Logo",
"Wiki RSS" => "Wiki RSS",
"[-]" => "[-]",
"Powered by" => "Powered by",
"pdf" => "pdf",
"chat" => "chat",
"Copyright" => "Copyright",
"dls" => "dls",
"debugger console" => "debugger console",
"URI" => "URI",
"RSS" => "RSS",
"Intertiki" => "Intertiki",
"InterTiki" => "InterTiki",
"ok" => "ok",
"Mobile" => "Mobile",
"Debugger Console" => "Debugger Console",
"XMLRPC API" => "XMLRPC API",
"OS" => "OS",
"Unix" => "Unix",
"Windows" => "Windows",
"IP" => "IP",
"CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
"PEAR::Auth" => "PEAR::Auth",
"LDAP" => "LDAP",
"LDAP Base DN" => "LDAP Base DN",
"LDAP User DN" => "LDAP User DN",
"PAM" => "PAM",
"Geourl" => "Geourl",
"Webmaster" => "Webmaster",
"latin" => "latin",
"english" => "english",
"MultiPrint" => "MultiPrint",
"x" => "x",
"ID" => "ID",
"URL" => "URL",
"Ver" => "Ver",
"tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
"dsn" => "dsn",
"extwiki" => "extwiki",
"min" => "min",
"ppd" => "ppd",
"Regex" => "Regex",
"url" => "url",
"mn" => "mn",
"Alias" => "Alias",
"Id" => "Id",
"Tbl vis" => "Tbl vis",
"popup" => "popup",
"h" => "h",
"zoom" => "zoom",
"+" => "+",
"Tiki Debugger Console" => "Tiki Debugger Console",
"URL:" => "URL:",
"Sun" => "Sun",
"%" => "%",
"id" => "id",
"idea" => "idea",
"Int" => "Int",
"#" => "#",
"inter" => "inter",
"Pop-up" => "Pop-up",
"ver:" => "ver:",
"auto" => "auto",
"int" => "int",
"hist" => "hist",
"v" => "v",
"Dls" => "Dls",
"/" => "/",
"adm" => "adm",
"Top 10" => "Top 10",
"Top 20" => "Top 20",
"Top 50" => "Top 50",
"Top 100" => "Top 100",
"tikiwiki.org" => "tikiwiki.org",
"eek" => "eek",
"lol" => "lol",
"mr green" => "mr green",
"razz" => "razz",
"santa" => "santa",
"CMS" => "CMS",
"Mb" => "Mb",
"bytes" => "bytes",
"SysLog" => "SysLog",
"UTC" => "UTC",
"Info" => "Info",
"%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
"Pos" => "Pos",
"sun" => "sun",
"pop" => "pop",
"TOP" => "TOP",
"%m/%d" => "%m/%d",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"This script cannot be called directly" => "Tätä merkkijonoa ei voi kutsua suoraan",
"Re:" => "Vast:",
"Missing title or body when trying to post a comment" => "Puuttuu joko otsikko tai kuva kommentista",
"The copyright management feature is not enabled." => "Copyright hallintaominaisuus ei ole käytössä.",
"You do not have permission to use this feature." => "Oikeutesi eivät riitä käyttämään tätä ominaisuutta.",
"You must supply all the information, including title and year." => "On lisättävä kaikki tieto, myös otsikko ja vuosi.",
"You do not have permission to use this feature" => "Oikeutesi eivät riitä käyttämääm tätä ominaisuutta",
"The text in RED is" => "PUNAINEN teksti on",
"character(s) too long - please edit it." => "liikaa kirjaimia - muokkaa sitä.",
"This feature is disabled" => "Tämä ominaisuus ei ole käytössä",
"American_Samoa" => "Amerikan_Samoa",
"Argentina" => "Argentiina",
"Austria" => "Itävalta",
"Bahamas" => "Bahama",
"Belgium" => "Belgia",
"Brazil" => "Brasilia",
"Canada" => "Kanada",
"Cayman_Islands" => "Cayman_Saaret",
"Cook_Islands" => "Cook_Saaret",
"Croatia" => "Kroatia",
"Cuba" => "Kuuba",
"Cyprus" => "Kypros",
"Czech_Republic" => "Tsekin_Tasavalta",
"Denmark" => "Tanska",
"Dominican_Republic" => "Dominikaaninen_Tasavalta",
"Ecuador" => "Ekuadori",
"Egypt" => "Egypti",
"Estonia" => "Eesti",
"Finland" => "Suomi",
"France" => "Ranska",
"French_Polynesia" => "Ranskan_Polynesia",
"Germany" => "Saksa",
"Greece" => "Kreikka",
"Guam" => "Guami",
"Hungary" => "Unkari",
"China" => "Kiina",
"Iceland" => "Islanti",
"India" => "Intia",
"Iraq" => "Irak",
"Ireland" => "Irlanti",
"Italy" => "Italia",
"Ivory_Coast" => "Norsunluu_Rannikko",
"Jamaica" => "Jamaika",
"Japan" => "Japani",
"Jordan" => "Jordania",
"Kenya" => "Kenia",
"Lebanon" => "Libanon",
"Lithuania" => "Liettua",
"Malaysia" => "Malesia",
"Marshall_Islands" => "Marshall_Saaret",
"Mexico" => "Mexiko",
"Morocco" => "Marocco",
"Mozambique" => "Mozambiq",
"Nepal" => "Nepali",
"Netherlands" => "Alankomaat",
"New_Caledonia" => "Uusi_Kaledonia",
"New_Zealand" => "Uusi_Seelanti",
"None" => "EiMitään",
"Norway" => "Norja",
"Other" => "Muu",
"Papua_New_Guinea" => "Papua_Uusi_Ginea",
"Paraguay" => "Paraguai",
"Phillippines" => "Filippiinit",
"Poland" => "Puola",
"Portugal" => "Portugali",
"Quatar" => "Qatari",
"Russia" => "Venäjä",
"Solomon_Islands" => "Salomon_Saaret",
"South_Africa" => "Etelä_Afrikka",
"South_Korea" => "Etelä_Korea",
"Spain" => "Espanja",
"St_Vincent_Grenadines" => "St_Vincent_Grenadiinit",
"Sweden" => "Ruotsi",
"Switzerland" => "Sveitsi",
"Thailand" => "Thaimaa",
"Turkey" => "Turkki",
"Ukraine" => "Ukraina",
"United_Arab_Emirates" => "Yhdistyneet_Arab_Emiraatit",
"United_Kingdom" => "Yhdistynyt_Kuningaskunta",
"United_States" => "Yhdysvallat",
"Uruguay" => "Uruguai",
"Yugoslavia" => "Jugoslavia",
"Arabic" => "Arabia",
"Catalan" => "Katalonia",
"Simplified Chinese" => "Yksinkertaistettu Kiina",
"Chinese" => "Kiina",
"Czech" => "Tsekki",
"Danish" => "Tanska",
"German" => "Saksa",
"English" => "Englanti",
"English British" => "Brittiläinen Englanti",
"Spanish" => "Espanja",
"Greek" => "Kreikka",
"Finnish" => "Suomi",
"French" => "Ranska",
"Hebrew" => "Hebrea",
"Croatian" => "Kroatialainen",
"Italian" => "Italia",
"Japanese" => "Japani",
"Korean" => "Korealainen",
"Hungarian" => "Unkarilainen",
"Dutch" => "Hollanti",
"Norwegian" => "Norja",
"Polish" => "Puola",
"Português" => "Portugalilainen",
"Brazilian Portuguese" => "Brazilian Portugali",
"Russian" => "Venäjä",
"Slovak" => "Slovakia",
"Serbian" => "Serbia",
"Serbian Latin" => "Serbian Latino",
"Swedish" => "Ruotsi",
"Tuvaluan" => "Tuvalualainen",
"Traditional Chinese" => "Perinteinen Kiina",
"Ukrainian" => "Ukrainalainen",
"This instance of activity is already complete" => "Tämä esimerkki toiminnon kohde on jo valmis",
"Fatal error: cannot execute automatic activity \$activityId" => "Vakava virhe: ei voi käynnistää automaattista toimintoa \$activityId",
"Fatal error: setting next activity to an unexisting activity" => "Vakava virhe: asetettu seuraava toiminto on olematon",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Vakava virhe: seuraava toiminto ei täsmää minkään ehdokkaan kanssa",
"Fatal error: non-deterministic decision for autorouting activity" => "Vakava virhe: väärä valinta automaattiseksi toiminteeksi",
"Fatal error: trying to send an instance to an activity but no transition found" => "Vakava virhe: yritys lähettää juttua toimintoon ei onnistu, koska siirtymää ei löydy",
"Cannot add transition only split activities can have more than one outbound transition" => "Ei voi lisätä siirtoa jaettuihin toimintoihin joilla voi olla useampi siirtymä",
"Circular reference found some activity has a transition leading to itself" => "Rengas asetus löydetty toiminto osoittaa itseään",
"Process does not have a start activity" => "Prosessilla ei ole käynnistävää toimintoa",
"Process does not have exactly one end activity" => "Prosessilla ei ole tasan yhtä lopetus toimintoa",
"End activity is not reachable from start activity" => "lopetus toiminto ei ole tavoitettavissa käynnistys toiminnosta",
"Activity" => "Toiminto",
" is interactive but has no role assigned" => " ei ole aktiivinen, mutta ei ole tehtävää liitettynä",
" is non-interactive and non-autorouted but has no role assigned" => " ei ole vuorovaikutteinen eikä ole tehtävää liitettynä",
" is standalone but has transitions" => " on yksinäinen, mutta sisältää siirtymiä",
"Role" => "Tehtävä",
" is not mapped" => " ei ole kartoitettu",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Toiminto '.\$res['name'].' on yksittäinen käyttäen \$instance object",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Toiminto '.\$res['name'].' on vuorovaikutteinen joten on käytettävä \$instance->complete() työtapaa",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Toiminto '.\$res['name'].' ei ole vuorovaikutteinen joten ei voi käyttää \$instance->complete() työtapaa",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Toiminto '.\$res['name'].' on kytkin joten on käytettävä \$instance->setNextActivity(\$actname) työtapaa",
"Process %d has been activated" => "Prosessi %d on käynnistetty",
"Process %d has been deactivated" => "Prosessi %d on suljettu",
"Process %s %s imported" => "Prosessi %s %s tuotu",
"Process %s removed" => "Prosessi %s poistettu",
"Process %s has been updated" => "Prosessi %s on päivitetty",
"Process %s has been created" => "Prosessi %s on luotu",
"by" => " ",
"refresh" => "päivitä",
"locked" => "lukittu",
"locked by" => "lukitsijana",
"Administration:" => "Ylläpito:",
"continued" => "jatkuu",
"in" => "sisään",
"new image uploaded by" => "uuden kuvan lähettäjä",
"uploaded by" => "lähettänyt",
"new item in tracker" => "uusi osa kortistossa",
"new subscriptions" => "uudet tilaukset",
"not specified" => "ei määritelty",
"The file is not a CSV file or has not a correct syntax" => "Tiedosto ei ole CSV tai parametrit ovat väärin",
"article" => "artikkeli",
"blog" => "blogi",
"directory" => "hakemisto",
"faq" => "ukk",
"file gallery" => "tiedosto galleria",
"forum" => "foorumi",
"image gallery" => "kuva galleria",
"newsletter" => "uutiskirja",
"poll" => "äänestys",
"quiz" => "visailu",
"survey" => "tutkimus",
"tracker" => "kortisto",
"wiki page" => "sivu",
"image" => "kuva",
"calendar" => "kalenteri",
"Cannot write to this file: " => "Et voi tallentaa tähän tiedostoon: ",
"Cannot upload this file maximum upload size exceeded" => "Et voi lähettää tiedostoa, maximi lähetyskoko ylittyy",
"Anonymous" => "Nimetön",
"Use this thread to discuss the %s page." => "Käytä tätä ketjua keskusteluun %s sivusta.",
"Line:" => "Viiva:",
"Lines:" => "Viivat:",
"Newsletter subscription information at " => "Tilaustiedot uutislehdestä ",
"Cannot write to this file:" => "Tähän tiedostoon ei voi kirjoittaa:",
"There was a problem with your upload." => "Ilmeni ongelmia lähetyksesi kanssa.",
"The file you are trying to upload is too big." => "Tiedosto jota yrität lähettää on liian suuri.",
"The file you are trying to upload was only partially uploaded." => "Tiedosto jota yrität lähettää tuli vain osittain.",
"You must select a file for upload." => "On valittava tiedosto lähetettäväksi.",
"Wiki Home" => "EtuSivu",
"Home" => "Etusivu",
"Blogs" => "Blogit",
"Blog" => "Blogi",
"previous page" => "edellinen sivu",
"next page" => "seuraava sivu",
"posted on" => "lähettänyt",
"Continue" => "Jatkuu",
"Articles" => "Artikkelit",
"By:" => " :",
"Read" => "Lukijaa",
"List articles" => "Listaa artikkelit",
"Forums" => "Foorumit",
"Last post" => "Viimeiset lähetykset",
"Invalid imagename (using filters for filenames)" => "Väärä kuvanimi (käyttäen suodinta tiedostonimissä)",
"Errors detected" => "Virheitä havaittu",
"Upload was not successful" => "Lähetys ei onnistunut",
"No image yet, sorry." => "Ei kuvaa vielä, valitan.",
"No valid ogr2ogr executable" => "Ei hyväksyttävä ogr2ogr ohjelma",
"Could not create \$tdo.mif in data directory" => "Ei voi luoda \$tdo.mif tietohakemistoon",
"Could not create \$tdo.mid in data directory" => "Ei voi luoda \$tdo.mid tietohakemistoon",
"unknown" => "tuntematon",
"User Map Generated in:" => "Käyttäjäkartta muodostettu:",
"Image Map Generated in:" => "Kuvakartta muodostettu:",
"NONE" => "EIMITÄÄN",
"File %s not found" => "Tiedostoa %s ei löydy",
"File %s is not a valid archive" => "Tiedosto %s ei ole arkistoitavissa",
"%s is an empty archive file" => "%s on tyhjä tiedosto",
"Invalid remote file on url %s" => "Väärä ulkoinen tiedosto url %s",
"Impossible to open %s : %s" => "Mahdoton aukaista %s : %s",
"This poll is closed." => "Tämä äänestys on suljettu.",
"Wiki top pages" => "Top sivut",
"Hits" => "Osumia",
"Most relevant pages" => "Eniten asiaan kuuluvat sivut",
"Relevance" => "Asianmukainen",
"Wiki last pages" => "Viimeiset sivut",
"Modified" => "Muokattu",
"Forums last topics" => "Foorumin viimeiset aiheet",
"Topic date" => "Aihee päiväys",
"Forums last posts" => "Foorumin viime lähetykset",
"Forums most read topics" => "Foorumin eniten luetut aiheet",
"Reads" => "Lukijaa",
"Forums best topics" => "Foorumin parhaat aiheet",
"Score" => "Pisteytys",
"Forums most visited forums" => "Luetuimmat foorumit",
"Visits" => "Vierailut",
"Forums with most posts" => "Vastatuimmat foorumit",
"Posts" => "Lähetyksiä",
"Wiki top galleries" => "Top galleriat",
"Wiki top file galleries" => "Top tiedosto galleriat",
"Wiki top images" => "Top kuvat",
"Wiki top files" => "Top tiedostot",
"Downloads" => "Imuroinnit",
"Wiki last images" => "Viimeiset kuvat",
"Upload date" => "Lähetys päivä",
"Wiki last files" => "Viimeiset tiedostot",
"Wiki top articles" => "Top artikkelit",
"Most visited blogs" => "Luetuimmat blogit",
"Most active blogs" => "Aktiivisimmat blogit",
"Blogs last posts" => "Blogien viimeiset postit",
"Post date" => "Postitus päivä",
"Wiki top authors" => "Top kirjoittajat",
"Pages" => "Sivut",
"Top article authors" => "Top artikkelikirjoittajat",
"Login" => "Kirjautuminen",
"See other user's profile" => "Katso muiden käyttäjien profiileja",
"Have your profile seen" => "Voiko profiiliasi katsoa",
"Make friends" => "Ystävysty",
"Receive message" => "Vastaanota viesti",
"Send message" => "Lähetä viesti",
"Read an article" => "Lue artikkeli",
"Publish an article" => "Julkaise artikkeli",
"Have your article read" => "Onko artikkeliasi luettu",
"Create new file gallery" => "Luo uusi tiedosto galleria",
"Upload new file to gallery" => "Lähetä uusi tiedosto galleriaan",
"Download other user's file" => "Imuroi toisen käyttäjän tiedosto",
"Have your file downloaded" => "Onko tiedostoasi imuroitu",
"Create a new image gallery" => "Luo uusi kuva galleria",
"Upload new image to gallery" => "Lähetä uusi kuva galleriaan",
"See other user's gallery" => "Katso toisen käyttäjän galleriaa",
"See other user's image" => "Katso toisen käyttäjän kuvaa",
"Have your gallery seen by other user" => "Onko galleriaasi katsonut toinen käyttäjä",
"Have your image seen" => "Onko kuvaasi katsottu",
"Create new blog" => "Luo uusi blogi",
"Post in a blog" => "Postita blogiin",
"Read other user's blog" => "Lue toisen käyttäjän blogia",
"Have your blog read" => "Onko blogiasi luettu",
"Create a new wiki page" => "Luo uusi sivu",
"Edit an existing page" => "Muokkaa olemassa olevaa sivua",
"Attach file" => "Liitä tiedosto",
"Tracker" => "Kortisto",
"Unknown" => "Tuntematon",
"Trackeritem" => "Kortistonosa",
"Image Gallery" => "Kuva Galleria",
"Image" => "Kuva",
"Article" => "Artikkeli",
"Wiki" => "Sivusto",
"Directory category" => "Hakemisto luokittelu",
"Directory" => "Hakemisto",
"FAQ" => "UKK",
"Forum" => "Foorumi",
"File Gallery" => "Tiedosto Galleria",
"Gallery" => "Galleria",
"File" => "Tiedosto",
"Blog post" => "Blogi lähetys",
"Link" => "Linkki",
"help" => "auta",
"The text is" => "Teksti on",
"Text cut here" => "Teksti katkaistaan tästä",
"Task" => "Tehtävä",
"from" => "keneltä",
"for" => "varten",
"Priority" => "Ensisijaisuus",
"Start date:" => "Aloitus päivä:",
"End date:" => "Lopetus päivä:",
"%A %d of %B, %Y" => "%A %d %B, %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d %B, %Y[%H:%M:%S %Z]",
"%a %d of %b, %Y" => "%a %d %b, %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d %b, %Y[%H:%M %Z]",
"Friend" => "Ystävä",
"Last seen on " => "Katsottu viimeksi ",
"(idle for %s seconds)" => "(odottanut %s sekuntia)",
"User information - Click for more info" => "Käyttäjä tiedot - Painamalla lisää tietoa",
"More info about \$other_user" => "Lisää tietoa \$other_user",
"(idle for \$idletime seconds)" => "(odottanut \$idletime sekuntia)",
"unlocked" => "lukitsematon",
"created from structure" => "luotu rakenteesta",
"Use this tree to copy the structure" => "Käytä tätä puuta kopioidaksesi rakenteen",
"An error occured in a database query!" => "Virhe tietokanta kyselyssä!",
"Help" => "Auta",
"You are banned from" => "Sinut on poistettu",
"wiki" => "sivusto",
"img-g" => "kuva-g",
"file-g" => "tied-g",
"faqs" => "ukk:sta",
"quizzes" => "visailuista",
"arts" => "artik",
"blogs" => "blogeista",
"forums" => "foorumeilta",
"games" => "peleistä",
"picture not found" => "kuvaa ei löydy",
"drawing not found" => "piirrosta ei löydy",
"Click to edit dynamic variable" => "Paina muokataksesi dynaamista muuttujaa",
"Update variables" => "Päivitä muuttujat",
"Altering database table failed" => "Tietokannan muutos epäonnistui",
"%d points" => "%d pistettä",
"Removed" => "Poistettu",
"Created" => "Luotu",
"__WARNING__: No such module \$plugin! " => "__WAROITUS__: Ei sellaista moduuli \$plugia! ",
"new" => "uusi",
"Create page:" => "Luo sivu:",
"show" => "näytä",
"hide" => "piilota",
"Updated" => "Päivitetty",
"Unknown language" => "Tuntematon kieli",
"Click here to confirm your action" => "Paina tästä, varmistaaksesi toiminnon",
"Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) havaittu. Menetelmä suljettu.",
"Status:" => "Tila:",
"(unchanged)" => "(muuttamattomat)",
"Item Modification" => "Osan Muokkaus",
"Item" => "Osa",
"Item creation" => "Osan luonti",
"Tracker was modified at " => "Kortiston muokkaajana ",
"field is not numeric" => "kenttä ei ole numeerinen",
"text field" => "teksti kenttä",
"half column" => "puoli palstaa",
"size" => "koko",
"prepend" => "lisäalkuun",
"append" => "lisäys",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Tekstivaihtoehdot: 1,koko,lisäalkuun,lisäys,maximi merkkien määränä, lisäysalkuun näytetään ensin, lisäys kenttä näytetään heti sen jälkeen, max on maksimi määrä merkkejä jotka voidaan tallentaa, ja merkintä 1 seuraavan kentän tai merkintälaatikon samalle riville. Jos valintasi on 1 se tarkoittaa, että seuraava kenttä on samalla rivillä myös.",
"textarea" => "tekstialue",
"Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "Tekstialueen vaihtoehdot: pikatagit,leveys,korkeus,max,listaa maksimi - Käytä pikatagian on 1 tai 0, tämän leveys osoitetaan merkkeinä, korkeus osoitetaan riveinä, max on tallennettavissa olevien merkkien suurin määrä, listaa maksimi on maksimi määrä merkkejä jotka näytetään listauksessa.",
"checkbox" => "merkintäneliö",
"Checkbox options: put 1 if you need that next field is on the same row." => "Merkintälaatikko valinnat: laita 1 jos tarvitset kentän samalle riville.",
"numeric field" => "numeerinen kenttä",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numeeriset valinnat: 1,koko,lisäalkuun,lisäys maximi merkkien määränä, lisäys alkuun näytetään ensin, lisäys kenttä näytetään heti sen jälkeen, ja merkintä 1 tehdäksesi seuraavan kentän tai merkintälaatikon samalle riville. Jos valitaan vain 1 se tarkoittaa, että seuraava kenttä on samalla rivillä myös.",
"drop down" => "alas veto",
"Dropdown options: list of items separated with commas." => "Alasveto valinnat: listaus osista eroteltuna pilkulla.",
"user selector" => "käyttäjä valitsin",
"User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "Käyttäjä Valitsin: käytä valintoja automaattiseen kenttien täyttöön : valitse 1 kirjoittajan kirjautumiseksi tai 2 muokkaajan kirjautumiseksi.",
"group selector" => "ryhmä valitsin",
"Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Ryhmä Valitsin: käytä valintoja automaattiseen kenttien täyttöön : valitse 1 luoja ryhmälle ja 2 muokkaaja ryhmälle. Oletus ryhmä on asetettava, tai ryhmä jonka käyttäjä valitsee, tai oletus ryhmä on rekisteröityneet.",
"country selector" => "maa valitsin",
"Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "Maa Valitsimen vaihtoehdot: 1|2 missä 1 näyttää vain maan nimen ja 2 näyttää vain maan lipun. Oletuksena näytetään molemmat",
"date and time" => "päivä ja aika",
"jscalendar" => "jskalenteri",
"action" => "toiminto",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Toiminto vaihtoehdot: Etiketti,postitukset,tiki-index.php,sivu:kenttänimi,korosta=testi",
"header" => "pääosa",
"category" => "luokka",
"Category options: parentId" => "Luokan vaihtoehdot: isäntäId",
"item link" => "osan linkki",
"Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "Osa Linkki vaihtoehdot: kortistoId,kenttäId,linkkiOsaan linkittää osan kortistoId:stä jonka kenttäId täsmää kenttä osan kanssa. linkkiOsan 1|0 luodaksesi linkin osaan näytöllä ja listalla",
"items list" => "osien lista",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Osien listaus vaihtoehdot: kortistoId,kenttäIdSiellä, kenttäIdTäällä, näyttökenttäIdSiellä, linkkiOsiin näyttää listauksen näyttöKenttäIdSiellä osasta kortistoa jonka kortistoId:n kenttäIdSiellä täsmää kenttäIdTäällä. linkkiOsiin 1|0 luodaksesi linkin näytöllä olevan osaan ja listaukseen",
"email" => "sähköposti",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Sähköposti Osoitteen vaihtoehdot: 0|1|2 missä 0 on tavallista tekstiä, 1 tekee hex-koodatun linkin osoitteeseen (vaikeampi vakoojille selvittää joten vähemmän roskapostia) ja 2 tekee normaalin href mailto linkin.",
"system" => "järjestelmä",
"open" => "avaa",
"pending" => "vireillä",
"closed" => "suljettu",
"Added:" => "Lisätty:",
"Removed:" => "Poistettu:",
"Remaining:" => "Jäljellä:",
"Old:" => "Vanha:",
"New:" => "Uusi:",
"message" => "viesti",
"No extra information for that attached file. " => "Ei lisätietoja tälle tiedostoliitteelle. ",
"child categories" => "alaluokat",
"objects in category" => "kohteita",
"Include all post in a blog" => "Sisällytä kaikki blogin lähetykset",
"Date" => "Päiväys",
"Title" => "Otsikko",
"Author" => "Kirjoittaja",
"Include a page" => "Sisällytä sivu",
"Lists files in a directory" => "Listaa kaikki tiedostot hakemistosta",
"could not be opened because it doesn't exist or permission was denied" => "ei voida avata, tiedostoa ei ole tai lupa avaamiseen puuttuu",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Ottaa oikean ilmaisun ja muokkaa sisällön REGEX tagien väliin ja korvaa tekstin.",
"data" => "tieto",
"one data per line" => "yksi tieto per rivi",
"The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "SNARF plugi korvaa itsensä HTML rungolla URL:sta.  Mielivaltainen regex korvaus voidaan tehdä käyttäen regex ja regexres, viimeisintä käytetään argumenttina korvauksessa preg_replace.",
"This data is put in a CODE caption." => "Tämä tieto on pantu KOODI kapseliin.",
"Missing url parameter for SNARF plugin." => "Puuttuu url parametri SNARF plugiin.",
"Displays browser client info" => "Näyttää selain asiakkaan tiedot",
"Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Laittaa linkkiankkurin sivulle. Käytetään ANAME pluginin yhteydessä, joka laittaa paikan ja nimen ankkuriin",
"linktext" => "linkinteksti",
"Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Laittaa ankkurin sivulle. Käytetään ALINK pluginin yhteydessä, joka tekee linkin ankkuriin",
"Include an article" => "Sisällytä artikkeli",
"no such attachment on this page" => "ei sellaista liitettä sivulla",
"Displays an attachment or a list of them" => "Näyttää liitteen tai listan niistä",
"comment" => "kommentti",
"num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "numero on vaihtoehtoinen ja on järjestysnumero liite listalla. Jos se puuttuu, lista kaikista liitteistä näytetään. Tekee kommentista tekstin linkin.",
"Displays the user Avatar" => "Näyttää käyttäjän Hahmon",
"username" => "käyttäjänimi",
"List all pages which link to specific pages" => "Listaa kaikki sivut jotka osoittavat kyseiselle sivuille",
"Page cannot be found" => "Sivua ei löytynyt",
"No pages links to" => "Ei linkkejä sivuille",
"One page links to" => "Yksi linkki sivulle",
"pages link to" => "linkit sivuille",
"Insert theme styled box on wiki page" => "Lisää teeman mukainen laatikko sivulle",
"text" => "teksti",
"Insert list of items for the current/given category into wiki page" => "Lisää lista osista nykyisen/annetun luokittelun sivulle",
"Categories are disabled" => "Luokittelut poistettu",
"Display Tiki objects that have not been categorized" => "Näyttää luokittelemattomat kohteet",
"Insert the full category path for each category that this wiki page belongs to" => "Lisää koko luokittelupolku jokaiseen luokkaan johon tämä sivu kuuluu",
"Centers the plugin content in the wiki page" => "Keskittää plugin sisällön sivulle",
"Displays a snippet of code" => "Näyttää palan koodia",
"code" => "koodi",
"note: colors and ln are exclusive" => "huomaa: värit ja linja ovat valikoivia",
"Insert copyright notices" => "Lisää copyright huomautus",
"Example" => "Esimerkki",
"days" => "päivää",
"hours" => "tuntia",
"minutes" => "minuuttia",
"and" => "ja",
"seconds" => "sekuntia",
"Insert a division block on wiki page" => "Laittaa jaottelun eston sivulle",
"Creates a definition list" => "Luo määrittelylistan",
"term" => "ehto",
"definition" => "määrittely",
"one definition per line" => "yksi määrittely per rivi",
"Displays the data using the Tikiwiki odd/even table style" => "Näyttää tiedot käyttäen pariton/parillinen taulukko tyyliä",
"cells" => "solut",
"heads and cells separated by ~|~" => "pääosat ja solut erotellaan käyttäen ~|~",
"Displays a SWF on the wiki page" => "Näyttää SWF sivulla",
"Formula" => "Kaava",
"No formula specified." => "Ei kaavaa määritelty.",
"Impossible to render the graphic." => "Mahdotonta muodostaa grafiikkaa.",
"View graphic" => "Näytä grafiikka",
"Displays a graphical GAUGE" => "Näyttää graafisen PALKIN",
"description" => "kuvaus",
"Display wiki text if user is in one of listed groups" => "Näyttää sivutekstin jos käyttäjä kuuluu johonkin listan ryhmistä",
"Displays the text only if the language matchs" => "Näyttää tekstin vain jos kieli täsmää",
"Displays a map" => "Näyttää kartan",
"Feature disabled" => "Ominaisuus poistettu",
"Displays an miniquiz" => "Näyttää minivisailun",
"Please choose a module" => "Valitse moduuli",
"to be used as argument" => "käytettäväksi perustana",
"Displays a module inlined in page" => "Näyttää modulin sivun sisällä",
"Sorry no such module" => "Ei ole sellaista moduulia",
"Displays the data using a monospace font" => "Näyttää tiedot käyttäen vakio levyistä kirjasinta",
"Displays object hit info by object and days" => "Näyttää kohteen osumatiedot kohteelle ja päivät",
"Provides a list of plugins on this wiki." => "Näyttää listan plugeista tällä sivustolla.",
"No version indicated" => "Ei versiota osoitettu",
"No arguments indicated" => "Ei perustetta osoitettu",
"Displays the output of a poll, fields are indicated with numeric ids." => "Näyttää äänestyksen tulokset, kentät on merkitty numeerisella id:llä.",
"missing poll ID for plugin POLL" => "puuttuu äänestys ID POLL plugille",
" wrote:" => " kirjoitti:",
"Quote:" => "Lainaus:",
"Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Ympäröi lainattavan tekstin laatikolla, kuten [QUOTE] BBCode",
"~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>syöteId,max=>3,päivä=>1,runko=>1)}{RSS} Laittaa rss syötteen tuloksen sivulle",
"Automatically creates a link to the appropriate SourceForge object" => "Luo automaattisesti linkin SourceForge kohteeseen",
"TikiSheet" => "LaskentaTaulukko",
"Sheet Heading" => "Taulukon Pääosa",
"Edit Sheet" => "Muokkaa Taulukkoa",
"List wiki pages" => "Listaa sivut",
"Last modified by" => "Viimeksi muokannut",
"Sorts the plugin content in the wiki page" => "Lajittelee plugin sisällön sivulle",
"Split a page into rows and columns" => "Jaa sivu riveihin ja palstoihin",
"row1col1" => "riv1pal1",
"row1col2" => "riv1pal2",
"row2col1" => "riv2pal1",
"row2col2" => "riv2pal2",
"Missing db param" => "Puuttuu db parametrit",
"Run a sql query" => "Aja sql kysely",
"sql query" => "sql kysely",
"Displays text in subscript." => "Näyttää tekstin subscriptinä.",
"Displays text between an html tag" => "Näyttää tekstin html tagin sisällä",
"Displays the thumbnail for an image" => "Näyttää kuvan minikuvan",
"Search the titles of all pages in this wiki" => "Etsi otsikoita kaikilta sivuilta tällä sivustolla",
"No pages found for title search" => "Sivuja ei löytynyt aihe haulla",
"One page found for title search" => "Yksi sivu löytyi otsikkohaulla",
" pages found for title search" => " sivua löytynyt otsikkohaulla",
"Following mandatory fields are missing" => "Seuraavat pakolliset kentät puuttuvat",
"Following fields are incorrect" => "Seuraavat kentät ovat väärin",
"Displays an input form for tracker submit" => "Näyttää kortiston syöttölomakkeen",
"Save" => "Tallenna",
"You do not have permission to insert an item" => "Oikeutesi eivät riitä lisäämään osaa",
"Fields marked with a * are mandatory." => "Kentät jotka on merkitty * ovat pakollisia.",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "Näyttää kortiston sisällön, kentät on merkitty numeerisella id:llä.",
"missing tracker ID for plugin TRACKER" => "puuttuu kortiston ID TRACKER plugille",
"missing fields list" => "puuttuu kenttä lista",
"at" => " ",
"Error in tracker ID" => "Virhe kortisto ID:ssä",
"No field indicated" => "Ei kenttää",
"Links to a translated content" => "Linkki käännös sisältöön",
"Displays the number of registered users" => "Näyttää rekisteröityneiden käyttäjien määrän",
"Split the text in parts visible only under some conditions" => "Jakaa tekstin osiin, jotka näytetään vain joissakin tapauksissa",
"Lists ''wanted'' Wiki pages: " => "Listaa ''halutaan'' sivut: ",
"Page-Pattern" => "Sivu-Kuvio",
"Custom-Level-Regex" => "Erikois-Tason-Regex",
"^Parameters: key=>value,...\n" => "^Parametrit: key=>arvo,...\n",
"__key__ | __default__ | __comments__\n" => "__avain__ | __oletus__ | __kommentit__\n",
"empty string" => "tyhjä merkkijono",
"A wildcard pattern of originating pages to be ignored.<br />" => "Jokerimerkki kuvio huomiotta jätettävistä sivuista.<br />",
"(refer to PHP function fnmatch() for details)\n" => "(tarkista PHP functioiden fnmatch() yksityiskohdat)\n",
"The character, by which ignored patterns are separated.<br />" => "Merkki, jolla huomiotta jätettävät kuviot on eroteltu.<br />",
"possible values: characters\n" => "mahdolliset arvot: merkit\n",
"Whether to include external wikis in the list.<br />" => "Liittääksesi ulkoiset sivut listaan.<br />",
"possible values: " => "mahdolliset arvot: ",
"Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Kootaan lähtöarvojen tai haluttujen sivujen mukaan kennoon ja näytetään ne toisella palstalla.<br />",
"Switch-on debug output with details about the items.<br />" => "Laita yksityiskohtainen osien debug tulostus päälle.<br />",
"Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Useat kerätyt osat on eroteltu taulukko riveillä, tai pilkulla tai rivityksellä yhdessä kennossa.<br />",
"Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Suodattaa haluttujen sivujen listan näyte sivu_regex:llä tai omalla suotimella. Oletus arvo on sivuston __nykyinen__ sivu_regex.<br />",
"A custom filter for wanted pages to be listed (only used when level=>custom).<br />" => "Oma suodin haluttujen sivujen listaukseen (käytetään vain kun taso on =>muokattu).<br />",
"a valid regex-expression (PCRE)" => "hyväksytty regex-ilmaisu (PCRE)",
"non-valid custom regex" => "ei hyväksytty muokattu regex",
"ignored" => "huomioimaton",
"External Wiki" => "Ulkoinen Wiki",
"dash-WikiWord" => "viiva-WSana",
"WikiWord" => "WSana",
"not in level" => "ei tasolla",
"valid" => "hyväksytty",
"End of debug output." => "Debug tulostuksen päätös.",
"Wanted Page" => "Haluttu Sivu",
"Referenced By Page" => "Lainaus Sivulta",
"Plugin " => "Plugi ",
"failed" => "epäonnistui",
"You are not logged in" => "Et ole kirjautunut sisään",
"Permission denied" => "Lupa evätty",
"ERROR: Either the subject or body must be non-empty" => "VIRHE: Kumpaakaan osikkoa tai tekstiä ei voi jättää tyhjäksi",
"ERROR: No valid users to send the message" => "VIRHE: Ei hyväksyttyjä jäseniä joille lähettää viesti",
"Invalid user" => "Väärä käyttäjä",
"Message will be sent to: " => "Viesti lähetetään: ",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Postilaatikko on täynnä. Arkistoi tai poista vanhempia viestejä ensin jos haluat lähettää lisää viestejä.",
"You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "Sinun on voitava vastaanottaa viestejä lähettääksesi niitä. Mene omiin asetuksiisi ja valitse 'Salli viestit muilta jäseniltä'",
"User %s can not receive messages, mailbox is full" => "Käyttäjä %s ei voi vastaanottaa viestejä, postilaatikko on täynnä",
"User %s can not receive messages" => "Käyttäjä %s ei voi vastaanottaa viestejä",
"Invalid user: %s" => "Väärä käyttäjä: %s",
"Archive is full. Delete some messages from archive first." => "Arkisto on täynnä. Poista vanhempia viestejä ensin.",
"No more messages" => "Ei enempää viestejä",
"move %s in %s" => "siirrä %s -> %s",
"Please provide an Id" => "Anna Id",
"no object here yet" => "ei kohteita täällä vielä",
"This module requires parameters trackerId and name set" => "Tämä moduuli tarvitsee kortistoId:n ja nimen",
"edit" => "muokkaa",
"Quick edit a Wiki page" => "PikaMuutos sivuun",
"Since your last visit" => "Viime käyntisi jälkeen",
"Changes" => "Muutokset",
"since" => "jälkeen",
"Changes since" => "Muutokset jälkeen",
"new comments" => "uusia kommentteja",
"new posts" => "uudet postit",
"wiki pages changed" => "wiki sivuja muuttunut",
"new articles" => "uudet artikkelit",
"new FAQs" => "uudet UKK:ot",
"new blogs" => "uudet blogit",
"new blog posts" => "uudet blogi lähetykset",
"new image galleries" => "uudet kuva galleriat",
"new images" => "uudet kuvat",
"new file galleries" => "uudet tiedosto galleriat",
"new files" => "uusia tiedostoja",
"new polls" => "uudet äänestykset",
"new users" => "uusia käyttäjiä",
"new tracker items" => "uudet kortiston osat",
"no such file" => "ei sellaista tiedostoa",
"Error" => "Virhe",
"The task title must have at least 3 characters" => "Tehtävä otsikon oltava vähintään 3 merkkiä",
"Invalid server key" => "Väärä palvelin avain",
"Invalid username or password" => "Väärä käyttäjänimi tai salasana",
"List of attached files" => "Listaus tiedostoliitteistä",
"name" => "nimi",
"desc" => "aleneva",
"uploaded" => "lähetetty",
"delete" => "poista",
"Remove" => "Poista",
"Upload file" => "Lähetä tiedosto",
"attach" => "liitä",
"Fatal error" => "Vakava virhe",
"Description:" => "Kuvaus:",
"Created by" => "Luonut",
" on " => "  ",
"Last modified" => "Viimeksi muokattu",
"Post" => "Lähetä",
"post" => "lähetä",
"RSS feed" => "RSS syöte",
"Edit blog" => "Muokkaa blogia",
"monitor this blog" => "tarkkaile tätä blogia",
"stop monitoring this blog" => "Lopeta tämän blogin tarkkailu",
"posts" => "lähetyksiä",
"visits" => "vierailut",
"Activity=" => "Toiminto=",
"Categorize" => "Luokittele",
"show categories" => "näytä luokittelut",
"hide categories" => "piilota luokittelut",
"Tip: hold down CTRL to select multiple categories" => "Vinkki: paina CTRL:ia valitaksesi useita luokitteluja",
"categorize this object" => "luokittele tämä kohde",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "Vinkki: poista merkintä alla olevasta laatikosta poistaaksesi luokittelun sivulta/kohteelta",
"No categories defined" => "Ei luokittelua määritelty",
"Admin categories" => "Admin luokittelut",
"browse category" => "selaa luokkaa",
"author" => "kirjoittaja",
"stars" => "tähtiä",
"user level" => "käyttäjä taso",
"private message" => "yksityis viesti",
"send email to user" => "lähetä viesti käyttäjälle",
"user online" => "käyttäjä linjalla",
"user offline" => "käyttäjä pois linjalta",
"on" => " ",
"score" => "tilanne",
"Vote" => "Äänestä",
"Edit" => "Muokkaa",
"reply" => "vastaa",
"attachment" => "liite",
"Moderator actions" => "Moderaattorin toiminnot",
"delete selected" => "poista valitut",
"Move to topic:" => "Siirrä aiheeksi:",
"move" => "siirrä",
"reported:" => "raportoitu:",
"queued:" => "jonossa:",
"Posted messages" => "Lähetetyt viestit",
"Messages" => "Viestit",
"All" => "Kaikki",
"Style" => "Tyyli",
"Plain" => "Tavallinen",
"Threaded" => "Ketjutettu",
"Headers Only" => "Vain Pääosat",
"Sort" => "lajittele",
"Newest first" => "Uusin ensimmäiseksi",
"Oldest first" => "Vanhin ensimmäiseksi",
"Threshold" => "Kynnys",
"Find" => "Etsi",
"set" => "aseta",
"Hide all" => "Piilota kaikki",
"replies" => "vastauksia",
"below your current threshold" => "alle nykyisen kynnyksesi",
"prev" => "edellinen",
"Page" => "Sivu",
"next" => "seuraava",
"new reply" => "uusi vastaus",
"Editing reply" => "Muokkaa vastausta",
"Reply to the selected post" => "Vastaa valittuihin lähetyksiin",
"Post new message" => "Lähetä uusi viesti",
"Editing comment" => "Muokkaa kommenttia",
"Comment on the selected post" => "Kommentoi valittuja lähetyksiä",
"Post new comment" => "Lähetä uusi kommentti",
"Preview" => "Näytä",
"Reply to parent post" => "Vastaa isäntä lähetykseen",
"Post new reply" => "Lähetä uusi vastaus",
"preview" => "näytä",
"cancel" => "peruuta",
"Required" => "Pakollinen",
"Rating" => "Arvostus",
"Smileys" => "Hymiöt",
"Reply" => "Vastaa",
"Comment" => "Kommentti",
"Posting replies" => "Lähettää vastauksia",
"Posting comments" => "Lähetetään kommentteja",
"Use" => "Käytä",
"or" => "tai",
"for links" => "linkkeihin",
"HTML tags are not allowed inside posts" => "HTML tagit eivät ole sallittuja lähetyksissä",
"Go back" => "Takaisin",
"Return to home page" => "Palaa EtuSivulle",
"Copyrights" => "Copyright",
"Year" => "Vuosi",
"Authors" => "Kirjoittajat",
"up" => "ylös",
"down" => "alas",
"add" => "lisää",
"Syntax" => "Syntaksi",
"Page generation debugging log" => "Sivun luoma debugging logi",
"Features state" => "Ominaisuuksien tilanne",
"Total" => "Kaikkiaan",
"features matched" => "ominaisuuksia osui",
"Watchlist" => "Vahtilista",
"Perhaps you were looking for:" => "Ehkä etsit:",
"There are no wiki pages similar to '{\$page}'" => "Ei ole samanlaisia sivuja kuin '{\$page}'",
"Create this page" => "Luo tämä sivu",
"(page will be orphaned)" => "(sivu muuttuu yksittäiseksi)",
"Close Window" => "Sulje Ikkuna",
"Last update from CVS" => "Viimeksi päivitetty CVS:stä",
"RSS Blogs" => "RSS Blogit",
"RSS Articles" => "RSS Artikkelit",
"RSS Image Galleries" => "RSS Kuva Galleriat",
"RSS File Galleries" => "RSS Tiedosto Galleriat",
"RSS Forums" => "RSS Foorumit",
"RSS Maps" => "RSS Kartat",
"RSS Directories" => "RSS Hakemistot",
"Information" => "Tiedot",
"Hi {\$mail_user} has sent you this link:" => "Hi {\$mail_user} lähetti sinulle linkin:",
"Blog post:" => "Blogi lähetys:",
"at:" => " :",
"Somebody or you tried to subscribe this email address at our site:" => "Joku tai sinä yrität tilata tällä sähköpostiosoitteella:",
"To the newsletter:" => "uutislehden:",
"In order to confirm your subscription you must access the following URL:" => "Varmistaaksesi tilauksesi sinun on käytettävä tätä URL:ia:",
"A new message was posted to forum" => "Uusi viesti oli lähetetty foorumille",
"New topic:" => "Uusi aihe:",
"Topic:" => "Aihe:",
"Message" => "Viesti",
"You sent a request with the subject:" => "Lähetit pyynnön otsikolla:",
"Use the subject to indicate the operation to apply:" => "Käytä otsikkoa osoittaaksesi lisättävän käsittelyn:",
"GET:WikiName to get a wiki page" => "HAE:SivuNimi saadaksesi sivun",
"PUT:WikiName to update/create a wiki page (use the body for the page data)" => "VIE:SivuNimi päivittääksesi/luodaksesi (käytä runkona sivun tietoja)",
"APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "LISÄÄ:SivuNimi lisätäksesi tietoja sivun loppuun (käytä runkona sivun tietoja lisäykseen)",
"PREPEND:WikiName to append the data at the top" => "LISALK:SivuNimi lisätäksesi tietoja sivun alkuun",
"Tiki mail-in instructions" => "Tiki postit sisään ohjeet",
"Tiki mail-in auto-reply." => "Sivuston-sisään autom-vastaus.",
"Page not found:" => "Sivua ei löydy:",
"A new message was posted to you at {\$mail_machine}" => "Uusi viesti on lähetetty sinulle {\$mail_machine}",
"From" => "Keneltä",
"Subject" => "Otsake",
"New message arrived from %s" => "Uuden viestin lähettänyt %s",
"Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Rekisteröinti pyyntösi {\$mail_site} käsitelty ylläpidon toimesta ja jäsenyytesi on aktivoitu.",
"To login with your username and password, please follow this link:" => "Kirjautuaksesi käyttäjänimeä ja salasanaa käyttäen, seuraa tätä linkkiä:",
"Enjoy the site!" => "Nauti sivustosta!",
"Tiki User Account Activated" => "Käyttäjä Tili Aktivoitu",
"has requested an account on" => "on pyytänyt jäsenyyttä",
"To validate that account, please follow the link:" => "Varmistaaksesi jäsenyys, seuraa tätä linkkiä:",
"best regards" => "parhain terveisin",
"your Tikiwiki" => "sinun sivustosi",
"Tiki User Registration Request" => "Käyttäjä Rekisteröinti Pyyntö",
"Go to your friendship network to accept or refuse this request" => "Mene ystävä verkostoosi ja hyväksy tai hylkää tämä pyyntö",
"You're invited to join my network of friends!" => "Sinut on kutsuttu liittymään ystävyysverkostooni!",
"The user" => "Käyttäjä",
"registered at your site" => "rekisteröity sinun sivustollesi",
"New user registration" => "Uuden käyttäjän rekisteröinti",
"This email address has been removed to the list of subscriptors of:" => "Tämä sähköpostiosoite on poistettu seuraavista tilaajien listalta:",
"Newsletter:" => "Uutislehti:",
"Bye bye from %s at %s" => "Terveisin %s -> %s",
"You can unsubscribe from this newsletter following this link" => "Voit peruuttaa uutislehden tilauksen painamalla tätä linkkiä",
"Welcome to our newsletter!" => "Tervetuloa Uutislehteemme!",
"This email address has been added to the list of subscriptors of:" => "Tämä sähköpostiosoite on liitetty tilaajien listalle:",
"You can always cancel your subscription using:" => "Voit peruuttaa tilauksen aina käyttäen:",
"Welcome to %s at %s" => "Tervetuloa %s , %s",
"Tiki email notification" => "Sähköposti ilmoitus",
"Someone coming from IP Address" => "Joku osoitteesta IP Osoite",
"requested a reminder of the password for your account" => "rekisteröinnistäsi on pyydetty salasana muistutusta",
"requested password reset for your account" => "rekisteröintisi salasana muutettu",
"Since this is your registered email address we inform that the password for this account is" => "Tämä on rekisteröity sähköpostiosoitteesi ja salasanasi on",
"Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Paina seuraavaa linkkiä varmistaaksesi salasanan uudelleen asetuksen ja mene näytölle jolla voit vaihtaa \"pysyvän\" salasanan. Valitse salasana jonka vain itse tiedät, äläkä kerro sitä kenellekään.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nTehty! Olet kirjautunut sisään.",
"Important: Username & password are CaSe SenSitiVe" => "Tärkeää: Käyttäjänimi & salasana ovat Tarkkoja oikeinkirjoituksesta",
"Important: The old password remains active if you don't click the link above." => "Tärkeää: Vanha salasana pysyy aktiivisena jos et seuraa alla olevaa linkkiä.",
"Your Tiki account information for %s" => " %s sinun tilitietosi ovat",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Uuden artkkelin lähettäjänä {\$mail_user}   {\$mail_site}   {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Voit muokata ehdotuksia seuraamalla tätä linkkiä:",
"Title:" => "Otsikko:",
"Heading:" => "Pääosa:",
"Body:" => "Runko:",
"New article submitted at %s" => "Uutta artikkelia ehdottanut %s",
"View the tracker item at:" => "Näytä kortisto osa:",
"Tracker was modified at" => "Koristoa muokattu",
"you or someone registered this email address at" => "sinä tai joku muu on rekisteröitynyt tällä sähköpostiosoitteella",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Jos haluat olla rekisteröitynyt käyttäjä tällä sivustolla sinun on seurattava tätä linkkiä kirjautuaksesi ensimmäisen kerran:",
"Your Tiki information registration" => "Sinun tietosi rekisteröintiin",
"You will receive an email with information to login for the first time into this site" => "Saat kohta sähköpostia, jossa on linkki ensimmäistä kirjautumista varten tälle sivustolle",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Rekisteröinti pyyntösi on tallennettu ja ylläpito käsittelee ja aktivoi sen mahdollisimman pian.",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Uuden artikkelin lähettänyt: {\$mail_user} {\$mail_date|tiki_short_datetime} {\$mail_title} ",
"View the article at:" => "Näytä artikkeli:",
"If you don't want to receive these notifications follow this link:" => "Jos et halua vastaanotta näitä ilmoituksia seuraa tätä linnkiä:",
"New article post at %s" => "Uuden artikkelin lähettänyt %s",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Uudet blogi lähetykset: {\$mail_title}, \"{\$mail_post_title}\",   {\$mail_user}   {\$mail_date|tiki_short_datetime}",
"View the blog at:" => "Näytä blogia:",
"New blog post at %s" => "Uuden blokikirjoituksen lähettänyt %s",
"File Gallery %s changed" => "Tiedosto Galleria %s muuttunut",
"A file was removed from the file gallery" => "Tiedosto on poistettu tiedosto galleriasta",
"Removed by" => "Poistanut",
"Name" => "Nimi",
"File Name" => "Tiedosto Nimi",
"A new file was posted to file gallery" => "Uusi tiedosto lähetetty tiedosto galleriaan",
"Posted by" => "Lähettänyt",
"File Description" => "Tiedoston Kuvaus",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Karttaa {\$mail_page} on muuttanut {\$mail_user}  {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "Voit katsoa päivitettyä karttaa seuraamalla tätä linkkiä:",
"You can edit the map following this link:" => "Voit muokata karttaa seuraamalla tätä linkkiä:",
"Type" => "Tyyppi",
"Size" => "Koko",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Sivun {\$mail_page} on luonut {\$mail_user}: {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Sivua {\$mail_page} on muuttanut {\$mail_user}  {\$mail_date|tiki_short_datetime}",
"Comment:" => "Kommentti:",
"You can view the page by following this link:" => "Voit katsoa sivua seuraamalla tätä linkkiä:",
"You can view a diff back to the previous version by following this link:" => "Voit katsoa edellisiä versioita seuraamalla tätä linkkiä:",
"The changes in this version follow below, followed after by the current full page text." => "Tämän version muutokset seuraavat alla, nykyisen koko sivun tekstin jälkeen.",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Riviä: {\$oldd} muutettu +Riviä: {\$newd}",
"The new page content follows below." => "Uuden sivun sisältö seuraa alla.",
"Wiki page %s changed" => "Sivu %s muuttunut",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Sivua {\$mail_page} on kommentoinut {\$mail_user}  {\$mail_date|tiki_short_datetime}",
"Wiki page renamed" => "Sivu uudelleen nimetty",
"Old name" => "Vanha nimi",
"New name" => "Uusi nimi",
"Thank you for you registration. You may log in now." => "Kiitos rekisteröinnistäsi. Nyt voi kirjautua normaalisti.",
"click on the map to zoom or pan, do not drag" => "klikkaa karttaa zoomataksesi tai pan, älä tartu karttaan",
"Scale" => "Muunnos",
"Zoom out x4" => "Suurenna x4",
"Zoom out x3" => "Suurenna x3",
"Zoom out x2" => "Suurenna x2",
"Query" => "Kysely",
"Pan" => "Panoroi",
"Zoom in x2" => "Pienennä x2",
"Zoom in x3" => "Pienennä x3",
"Zoom in x4" => "Pienennä x4",
"Redraw" => "Päivitä",
"select zoom/pan/query and image size" => "valitse zoom/pan/kysely ja kuvan koko",
"Go" => "Mene",
"View the Map Only" => "Näytä Vain Kartta",
"Reset Map" => "Palauta Kartta",
"Click on the map or click redraw" => "Klikkaa karttaa tai klikkaa päivittääksesi",
"Comments" => "Kommentit",
"Last modification date" => "Viimeinen muokkaus päivä",
"Overview" => "Yleiskuva",
"Legend" => "Seloste",
"Layer Manager" => "Tason Hallinta",
"Layer" => "Taso",
"On" => " ",
"Label" => "Etiketti",
"Download" => "Imurointi",
"Download Layer" => "Imuroi Taso",
"This layer has been set by the maps administrator to not be downloadable" => "Tämän tason on asettanut kartan ylläpitäjä eikä sitä voi imuroida",
"you have requested to download the layer:" => "olet pyytänyt tason imurointia:",
"from\nthe mapfile:" => " \nkarttatiedostosta:",
"Here are the files to download, do not forget to rename them:" => "Tässä ovat tiedostot imurointia varten, älä unohda nimetä niitä:",
"Mapfiles" => "Karttatiedostot",
"Mapfile" => "Karttatiedosto",
"Available mapfiles" => "Saatavat karttatiedostot",
"Actions" => "Toiminnot",
"hits" => "osumia",
"hits last 7 days" => "osumia viimeisenä 7 päivänä",
"monitor this map" => "tarkkaile tätä karttaa",
"stop monitoring this map" => "lopeta tämän kartan tarkkailu",
"No records found" => "Ei löytynyt tallennetta",
"Create a new mapfile" => "Luo uusi karttatiedosto",
"create" => "luo",
"Mapfile listing" => "Karttatiedoston listaus",
"Reload" => "Lataa uudelleen",
"History" => "Historia",
"save" => "tallenna",
"You can view this map in your browser using" => "Voit katsoa kartaa selaimelle käyttäen ",
"Mapfile History" => "Karttatiedoston Historia",
"of" => " ",
"Version" => "Versio",
"compare" => "vertaa",
"Comparing version {\$old.version} with version {\$new.version}" => "Verrataan versiota {\$old.version} versioon {\$new.version}",
"Version:" => "Versio:",
"current" => "nykyinen",
"Versions are identical" => "Versiot ovat identtiset",
"Legend:" => "Seloste:",
"v=view" => "n=näyttö",
"c=compare" => "v=vertaa",
"d=diff" => "e=erot",
"Side-by-side diff" => "Erot rinnakkain",
"Full side-by-side diff" => "Kaikki erot rinnakkain",
"Unified diff" => "Yhdistetyt erot",
"Side-by-side view" => "Rinnakkaisnäyttö",
"User" => "Käyttäjä",
"Action" => "Toiminto",
"view" => "näytä",
"diff" => "erot",
"older version" => "vanhempi versio",
"Directories" => "Hakemistot",
"back to" => "takaisin",
"Files" => "Tiedostot",
"Upload From Disk:" => "Lähetä Kovalevyltä:",
"Upload Files" => "Lähetä Tiedostot",
"Bytes maximum" => "Suurin koko",
"Create Directory:" => "Luo Hakemisto:",
"Create" => "Luo",
"index file (.shp):" => "index tiedosto (.shp):",
"files to index (regexp):" => "tiedostot index:iin (regexp):",
"Message Archive" => "Viesti Arkisto",
"Edit template" => "Muokkaa mallia",
"messages" => "viestejä",
"Archive is full!" => "Arkisto on täynnä!",
"Unread" => "Lukemattomat",
"Flagged" => "Merkityt",
"Unflagged" => "Merkitsemättömät",
"Containing" => "Sisältäen",
"filter" => "suodin",
"download" => "imuroi",
"sender" => "lähettäjä",
"subject" => "otsake",
"date" => "päiväys",
"flagged" => "merkitty",
"No messages to display" => "Ei näytettäviä viestejä",
"Broadcast message" => "Lähetys viesti",
"Message Broadcast" => "Viestilähetys",
"edit template" => "muokkaa mallia",
"Group" => "Ryhmä",
"All users" => "Kaikki käyttäjät",
"Lowest" => "Alin",
"Low" => "Alhainen",
"Normal" => "Normaali",
"High" => "Korkea",
"Very High" => ">Korkein",
"send" => "lähetä",
"Compose message" => "Muodosta viesti",
"Compose Message" => "Muodosta viesti",
"If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "Jos haluatte, että teille vastataan, teidän on merkittävä <a href='tiki-user_preferences.php'>Salli viestit muilta käyttäjiltä</a>",
"To" => "Kenelle",
"CC" => "Kopio",
"BCC" => "Varmuuskopio",
"No messages to download" => "Ei imuroitavia viestejä",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Postilaatikko on täynnä! Poista tai arkistoi viestejä jotta voit vastaanottaa lisää.",
"move to archive" => "siirrä arkistoon",
"Mark as read" => "Merkitse luetuksi",
"Mark as unread" => "Merkitse lukemattomaksi",
"Mark as flagged" => "Merkitse merkityksi",
"Mark as unflagged" => "Merkitse merkitsemättömäksi",
"mark" => "merkitse",
"reply to" => "vastaa",
"find replied message" => "etsi vastatut viestit",
"Mailbox" => "Postilaatikko",
"Compose" => "Muodosta",
"Broadcast" => "Lähetys",
"Sent" => "Lähtenyt",
"Archive" => "Arkisto",
"Auto-archive age for read messages:" => "Auto-arkistoi iän mukaan luetut viestit:",
"Read message" => "Lue viesti",
"Prev" => "Edel",
"Next" => "Seuraava",
"Return to mailbox" => "Palaa postilaatikkoon",
"replyall" => "vastaakaikille",
"Unflag" => "Merkitsemätön",
"Flag this message" => "Merkitse tämä viesti",
"Cc" => "Kopio",
"Return to archive" => "Palaa arkistoon",
"Return to outbox" => "Palaa lähteneisiin",
"Sent Messages" => "Lähteneet Viestit",
"Replied" => "Vastatut",
"Not replied" => "Vastaamattomat",
"receiver" => "vastaanottaja",
"no" => "ei",
"replied" => "vastattu",
"'name' parameter for tikimodule missed" => "'nimi' parametri puuttuvalle moduulille",
"Move module up" => "Siirrä moduuli ylöspäin",
"Move module down" => "Siirrä moduuli alaspäin",
"Hide module contents" => "Piilota moduulin kommentit",
"Move module to opposite side" => "Siirrä moduuli toiselle puolelle",
"opp side" => "vastakkainen puoli",
"Unassign this module" => "Poista tämä moduuli",
"Are you sure you want to unassign this module?" => "Oletko varma, että haluat poistaa modulin?",
"remove" => "poista",
"Admin Menu" => "Ylläpito Valikko",
"Live support" => "Elävä tuki",
"Banning" => "Esto",
"Users" => "Käyttäjät",
"Groups" => "Ryhmät",
"Cache" => "Puskuri",
"Modules" => "Moduulit",
"Links" => "Linkit",
"Hotwords" => "Kuumasanat",
"RSS modules" => "RSS moduulit",
"Menus" => "Valikot",
"Polls" => "Äänestykset",
"Backups" => "Varmuuskopio",
"Mail notifications" => "Posti ilmoitukset",
"Search stats" => "Etsintä tilastot",
"QuickTags" => "PikaLisät",
"Chat" => "Juttele",
"Categories" => "Luokittelut",
"Banners" => "Bannerit",
"Edit templates" => "Muuta mallia",
"Admin drawings" => "Ylläpidä piirroksia",
"Dynamic content" => "Muuttuva sisältö",
"Cookies" => "Keksit",
"Mail-in" => "Posti-sisään",
"Content templates" => "Sisältö mallit",
"HTML pages" => "HTML sivut",
"Shoutbox" => "Pikaviestin",
"Shoutbox Words" => "Pikaviestin Sanat",
"Referer stats" => "Suosittelu tilastot",
"Import PHPWiki Dump" => "Tuo PHPWiki Dumppi",
"Admin dsn" => "Ylläpidä dsn",
"External wikis" => "Ulkoiset wikit",
"System Admin" => "Järjestelmän Ylläpito",
"Security Admin" => "Turvallisuus Ylläpito",
"Syntax highlighting" => "Syntaksi korostus",
"Display type unknown, you have to enter the banner type" => "Tuntematon näyttö tyyppi, anna bannerin tyyppi",
"You forgot your Google ad_client number !" => "Olet unohtanut Google ad_client numeron !",
"Menu" => "Valikko",
"Contact us" => "Ota yhteyttä",
"Stats" => "Tilastot",
"Games" => "Pelit",
"Calendar" => "Kalenteri",
"MyMenu" => "OmaValikko",
"MyTiki" => "OmatSivut",
"MyTiki home" => "OmaSivu perus",
"Preferences" => "Kokoonpanot",
"Tasks" => "Tehtävät",
"Bookmarks" => "Kirjanmerkit",
"Newsreader" => "Uutislukija",
"Webmail" => "Verkkoposti",
"Notepad" => "Muistio",
"My files" => "Omat tiedostot",
"User menu" => "Käyttäjä valikko",
"Mini calendar" => "Mini kalenteri",
"My watches" => "Omat vahdit",
"WfMenu" => "WfValikko",
"Workflow" => "Työvuo",
"Admin processes" => "Ylläpidä prosesseja",
"Monitor processes" => "Tarkkaile prosesseja",
"Monitor activities" => "Tarkkaile toimintoja",
"Monitor instances" => "Tarkkaile pyyntöjä",
"User processes" => "Käyttäjä prosessit",
"User activities" => "Käyttäjän toiminteet",
"User instances" => "Käyttäjä pyynnöt",
"FriendsMenu" => "YstäväValikko",
"Community" => "Yhteisö",
"User list" => "Käyttäjä lista",
"Friendship Network" => "Ystävä Verkosto",
"WikiMenu" => "WikiValikko",
"Last changes" => "Viimeiset muutokset",
"Dump" => "Dumppi",
"Rankings" => "Arvostukset",
"List pages" => "Sivu listaus",
"Orphan pages" => "Yksinäiset sivut",
"Sandbox" => "Hiekkaloota",
"Print" => "Tulosta",
"Send pages" => "Lähetä sivut",
"Received pages" => "Vastaanotetut sivut",
"Structures" => "Rakenteet",
"GalMenu" => "GalValikko",
"Image Galleries" => "Kuva Galleriat",
"Galleries" => "Galleriat",
"Upload image" => "Lähetä kuva",
"System gallery" => "Järjestelmä galleria",
"Articles home" => "Artikkelien koti",
"Submit article" => "Lähetä artikkeli",
"View submissions" => "Näytä ehdotukset",
"Edit article" => "Muokkaa artikkelia",
"Send articles" => "Lähetä artikkelit",
"Received articles" => "Vastaanotetut artikkelit",
"Admin topics" => "Ylläpidon aiheet",
"Admin types" => "Ylläpidon tyypit",
"List blogs" => "Listaa blogit",
"Create/Edit blog" => "Luo/Muokkaa blogia",
"Admin posts" => "Ylläpidä posteja",
"ForMenu" => "Valikolle",
"List forums" => "Listaa foorumit",
"Admin forums" => "Ylläpidä foorumit",
"DirMenu" => "HakValikko",
"Submit a new link" => "Lähetä uusi linkki",
"Browse directory" => "Selaa hakemistoa",
"Admin directory" => "Ylläpidä hakemistoa",
"FileGalMenu" => "TiedostoGalValikko",
"File Galleries" => "Tiedosto Galleriat",
"List galleries" => "Listaa galleriat",
"FAQs" => "UKK:t",
"List FAQs" => "Listaa UKK:t",
"Admin FAQs" => "Ylläpidä UKK:iä",
"Maps" => "Kartat",
"Layer management" => "Tasojen hallinta",
"QuizMenu" => "VisailuValikko",
"Quizzes" => "Visailut",
"List quizzes" => "Listaa visailut",
"Quiz stats" => "Visailu tilastot",
"Admin quiz" => "Ylläpidä visailua",
"ShtMenu" => "ShtValikko",
"TrkMenu" => "KorValikko",
"Trackers" => "Kortistot",
"List trackers" => "Listaa kortistot",
"Admin trackers" => "Ylläpidä kortistoja",
"SrvMenu" => "PalValikko",
"Surveys" => "Tutkimukset",
"List surveys" => "Listaa tutkimukset",
"Admin surveys" => "Ylläpidä tutkimuksia",
"Newsletters" => "Uutiskirje",
"Send newsletters" => "Lähetä uutislehti",
"Admin newsletters" => "Ylläpidä uutislehteä",
"Events" => "Tapahtumat",
"Send events" => "Laita tapahtumat",
"Admin events" => "Ylläpidä tapahtumia",
"EphMenu" => "EphValikko",
"Ephemerides" => "Lyhytaikaiset",
"Ephemerides Admin" => "Lyhytaikaisten Ylläpito",
"ChartMenu" => "KaavioValikko",
"Charts" => "Kaaviot",
"Charts Admin" => "Kaavioiden Ylläpito",
"AdmMenu" => "YllValikko",
"Admin" => "Ylläpitäjä",
"Admin home" => "perus Ylläpito",
"Theme control" => "Teema hallinta",
"Drawings" => "Piirrokset",
"Edit languages" => "Muokkaa kieliä",
"Integrator" => "Yhdistäjä",
"Mods Admin" => "Modien Ylläpito",
"UsrMenu" => "KäytValikko",
"Click here to manage your personal menu" => "Paina tästä hallitaksesi henkilökohtaista valikkoa",
"User Menu" => "Käyttäjän Valikko",
"Tikiwiki Assistant" => "Tikiwiki Avustaja",
"Thank you for installing Tikiwiki" => "Kiitos kun installoit Tikiwikin",
"Click the :: options in the Menu for more options." => "Paina :: vaihtoehdosta saadaksesi lisää valikko vaihtoehtoja.",
"Please, also see" => "Katso myös",
"for more setup details." => "lisää asetus yksityiskohtia.",
"Note 1:" => "Huomio 1:",
"You can remove this module in" => "Voit poistaa moduulin täältä",
"as well as assign or edit many others." => "tai liitä ja muokkaa monia muita.",
"Note 2:" => "Huomio 2:",
"The menu module installed by default is named" => "Oletuksena asennettu valikko moduuli on nimetty",
"it is a \"custom module\" which includes menu ID " => "se on \"muokattu moduuli\" jolla on valikko ID ",
"That menu is stored in database and it can be edited from " => "Se valikko on varastoitu tietokantaan ja voi muuttaa ",
"Do not mix this with the original <em>application_menu</em> module" => "Älä sekoita tätä alkuperäiseen <em>ohjelmat valikko</em> moduuliin",
"That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "Sitä voi muokata jotta se sopisi tyyliin, mutta sen voi tehdä vain muokkaamalla mod-application_menu.tpl tiedostoa \"käsin\"",
"Recently visited pages" => "Äskettäin vieraillut sivut",
"January" => "Tammikuu",
"February" => "Helmikuu",
"March" => "Maaliskuu",
"April" => "Huhtikuu",
"May" => "Toukokuu",
"June" => "Kesäkuu",
"July" => "Heinäkuu",
"August" => "Elokuu",
"September" => "Syyskuu",
"October" => "Lokakuu",
"November" => "Marraskuu",
"December" => "Joulukuu",
"Monday" => "Maanantai",
"Tuesday" => "Tiistai",
"Wednesday" => "Keskiviikko",
"Thursday" => "Torstai",
"Friday" => "Perjantai",
"Saturday" => "Lauantai",
"Sunday" => "Sunnuntai",
"Filter" => "Suodin",
"Today" => "Tänään",
"top" => "ylä",
"Received objects" => "Vastaanotetut kohteet",
"Pages:" => "Sivut:",
"Last `\$module_rows` Sites" => "Viimeksi `\$module_rows` Sivustoja",
"Last Sites" => "Viimeiset Sivustot",
"Directory Stats" => "Hakemisto Tilastot",
"Sites" => "Sivustot",
"Sites to validate" => "Vahvistettavat sivustot",
"Searches" => "Etsinnät",
"Visited links" => "Vieraillut linkit",
"Top \$module_rows Sites" => "Top \$module_rows Sivustot",
"Top Sites" => "Top Sivustot",
"Featured links" => "Ominaisuus linkit",
"Top `\$module_rows` topics" => "Top `\$module_rows` aiheet",
"Top topics" => "Top aiheet",
"Last `\$module_rows` forum posts" => "Viimeiset `\$module_rows` foorumin lähetykset",
"Last forum posts" => "Viime foorumin lähetykset",
"Last `\$module_rows` forum topics" => "Viimeiset `\$module_rows` foorumin aiheet",
"Last forum topics" => "Viimeiset foorumin aiheet",
"Most commented forums" => "Eniten kommentoidut foorumit",
"Most read topics" => "Luetuimmat aiheet",
"Most visited forums" => "Luetuimmat foorumit",
"Google Search" => "Google Etsintä",
"Last `\$module_rows` actions" => "Viimeiset `\$module_rows` toiminnot",
"Last actions" => "Viime toiminnot",
"Last `\$module_rows` articles" => "Viimeiset `\$module_rows` artikkelit",
"Last articles" => "Viimeiset artikkelit",
"Last `\$module_rows` blog posts" => "Viimeiset `\$module_rows` blogi lähetykset",
"Last blog posts" => "Viimeiset blogi lähetykset",
"Last" => "Viimeksi",
"Last `\$module_rows` Created blogs" => "Viimeiset `\$module_rows` Luodut blogit",
"Last Created blogs" => "Viimeiset Luodut blogit",
"Last `\$module_rows` Created FAQs" => "Viimeiset `\$module_rows` Luodut UKK:t",
"Last Created FAQs" => "Viimeksi Luodut UKK:t",
"Last `\$module_rows` Created Quizzes" => "Viimeksi `\$module_rows` Luodut Visailut",
"Last Created Quizzes" => "Viimeksi Luodut Visailut",
"Last `\$module_rows` modified file galleries" => "Viimeksi `\$module_rows` muokatut tiedosto galleriat",
"Last modified file galleries" => "Viimeksi muokatut tiedosto galleriat",
"Last `\$module_rows` Files" => "Viimeiset `\$module_rows` Tiedostot",
"Last Files" => "Viimeiset Tiedostot",
"Last `\$module_rows` galleries" => "Viimeiset `\$module_rows` galleriat",
"Last galleries" => "Viimeiset galleriat",
"Last `\$module_rows` Images" => "Viimeiset `\$module_rows` Kuvat",
"Last Images" => "Viime Kuvat",
"Last `\$module_rows` modified events" => "Viimeiset `\$module_rows` muutetut tapahtumat",
"Last modifed events" => "Viime muutetut tapahtumat",
"Last `\$module_rows` changes" => "Viimeiset `\$module_rows` muutokset",
"Last `\$module_rows` Modified Items" => "Viimeksi `\$module_rows` Muokatut Osat",
"Last Modified Items" => "Viimeksi Muokatut Osat",
"Last `\$module_rows` Modified blogs" => "Viimeksi `\$module_rows` Muokatut blogit",
"Last Modified blogs" => "Viimeksi muokatut blogit",
"Last `\$module_rows` submissions" => "Viimeiset `\$module_rows` ehdotukset",
"Last submissions" => "Viimeiset ehdotukset",
"Last `\$module_rows` Modified Comments" => "Viimeiset `\$module_rows` Muutetut Kommentit",
"Last Modified Comments" => "Viimeksi Muutetut Kommentit",
"Last `\$module_rows` Items" => "Viimeiset `\$module_rows` Osat",
"Last Items" => "Viimeiset Osat",
"Last `\$module_rows` visitors" => "Viimeiset `\$module_rows` vierailijat",
"Last visitors" => "Viime vierailijat",
"Open operator console" => "Avaa operaattorin konsoli",
"Online users" => "Käyttäjät linjalla",
"We have" => "Meillä on",
"online users" => "linjalla olevaa käyttäjää",
"logged as" => "kirjautunut",
"Logout" => "Poistu",
"user" => "käyttäjä",
"Login through CAS" => "Kirjautuminen CAS:in kautta",
"Login as admin" => "Kirjautunut ylläpitäjänä",
"pass" => "salasana",
"login" => "kirjaus",
"Remember me" => "Muista minut",
"Click here to register" => "Paina tästä rekisteröityäksesi",
"register" => "rekisteröi",
"Click here if you've forgotten your password" => "Paina tästä jos olet unohtanut salasanasi",
"I forgot my pass" => "Olen unohtanut salasanani",
"Click here to login using the default security protocol" => "Paina tästä kirjautuaksesi oletuksena olevaa turvallisuus protokollaa käyttäen",
"standard" => "standardi",
"Click here to login using a secure protocol" => "Paina tästä kirjautuaksesi käyttäen salattua protokollaa",
"secure" => "salattu",
"stay in ssl mode" => "pysy ssl moodissa",
"local account" => "paikallinen tili",
"You have" => "Sinulla on",
"new messages" => "uusia viestejä",
"new message" => "uusi viesti",
"You have 0 new messages" => "Sinulla on 0 uutta viestiä",
"Waiting Submissions" => "Odottaa Ehdotuksia",
"submissions waiting to be examined" => "ehdotukset odottavat käsittelyä",
"Old articles" => "Vanhat artikkelit",
"Send a message to" => "Lähetä viesti",
"Send a message" => "Lähetä viesti",
"Random Images" => "Satunnais Kuvat",
"Random Pages" => "Satunnais Sivut",
"Register as a new user" => "Rekisteröi uutena käyttäjänä",
"Your email could not be validated; make sure you email is correct and click register below." => "Sähköpostiosoitettasi ei voida varmistaa; tarkista että sähköpostiosoite on oikein ja paina alhaalta rekisteröi.",
"Your registration code:" => "Rekisteröinti koodisi:",
"Random Image" => "Satunnais Kuva",
"Username" => "Käyttäjänimi",
"Passcode to register (not your user password)" => "Passikoodi rekisteröintiin (ei ole salasana)",
"Registration code" => "Rekisteröinti koodi",
"Password" => "Salasana",
"Repeat password" => "Toista salasana",
"Email" => "Sähköposti",
"Generate a password" => "Luo salasana",
"Blogs RSS" => "Blogit RSS",
"Articles RSS" => "Artikkelien RSS",
"Image Galleries RSS" => "Kuva Gallerioiden RSS",
"File Galleries RSS" => "Tiedosto Gallerioiden RSS",
"Forums RSS" => "Foorumien RSS",
"Maps RSS" => "Karttojen RSS",
"Search" => "Etsi",
"in:" => " :",
"Entire Site" => "Koko Sivusto",
"Wiki Pages" => "Wiki Sivut",
"Image Gals" => "Kuva Gal",
"Images" => "Kuvat",
"Blog Posts" => "Blogi Lähetykset",
"go" => "mene",
"Search Wiki PageName" => "Etsi Wiki SivuNimeä",
"Exact&nbsp;match" => "Tarkka&nbsp;täsmäys",
"Read More" => "Lue Lisää",
"Since your last visit on" => "Sen jälkeen kun viimeksi olet käynyt",
"click to edit" => "paina muokataksesi",
"Language: " => "Kieli: ",
"Language" => "Kieli",
"Most Active blogs" => "Aktiivisimmat blogit",
"Top `\$module_rows` articles" => "Top `\$module_rows` artikkelit",
"Top articles" => "Top artikkelit",
"Top `\$module_rows` File Galleries" => "Top `\$module_rows` Tiedosto Galleriat",
"Top File Galleries" => "Top Tiedosto Galleriat",
"Top `\$module_rows` files" => "Top `\$module_rows` tiedostot",
"Top files" => "Top tiedostot",
"Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Foorumin Lähettäjät",
"Top Forum Posters" => "Top Foorumin Lähettäjät",
"Top `\$module_rows` games" => "Top `\$module_rows` pelit",
"Top games" => "Top pelit",
"Top `\$module_rows` galleries" => "Top `\$module_rows` galleriat",
"Top galleries" => "Top galleriat",
"Top `\$module_rows` Images" => "Top `\$module_rows` Kuvat",
"Top Images" => "Top Kuvat",
"Top `\$module_rows` Objects" => "Top `\$module_rows` Kohteet",
"Top Objects" => "Top Kohteet",
"Top `\$module_rows` Pages" => "Top `\$module_rows` Sivut",
"Top Pages" => "Top Sivut",
"Top `\$module_rows` Quizzes" => "Top `\$module_rows` Visailut",
"Top Quizzes" => "Top Visailut",
"Most `\$module_rows` visited blogs" => "Most `\$module_rows` vieraillut blogit",
"Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` Vieraillut UKK:t",
"Top Visited FAQs" => "Top Vieraillut UKK:t",
"Upcoming events" => "Tulossa olevat tapahtumat",
"My blogs" => "Omat blogit",
"cache" => "puskuri",
"My galleries" => "Omat galleriat",
"My Pages" => "Omat Sivut",
"User tasks" => "Käyttäjä tehtävät",
"done" => "tehty",
"del" => "pois",
"Public tasks" => "Julkisia tehtäviä",
"select" => "valitse",
"User informations" => "Käyttäjän tiedot",
"Group informations" => "Ryhmän tiedot",
"Top users" => "Top käyttäjät",
"Whats related" => "Mikä on liittyvää",
"online user" => "käyttäjä linjalla",
"on host" => "järjestäjänä",
"Last `\$module_rows` wiki comments" => "Viimeiset `\$module_rows` wiki kommentit",
"Last wiki comments" => "Viimeiset wiki kommentit",
" on page " => " sivulle ",
"Click to see the ratings" => "Paina nähdäksesi luokitukset",
"vote" => "äänestä",
"Sent editions" => "Lähetä muokatut",
"find" => "löytyi",
"users" => "käyttäjät",
"sent" => "lähetä",
"use" => "käytä",
"Structures:" => "Rakenteet:",
"show structures" => "näytä rakenteet",
"hide structures" => "piilota rakenteet",
"Manage structures" => "Hallitse rakenteita",
"Are you sure you want to remove this module?" => "Oletko varma, että haluat poistaa tämän moduulin?",
"Execution time" => "Ajo aika",
"secs" => "sek",
"Memory usage" => "Muistin käyttö",
"database queries used" => "tietokanta kyselyjä",
"Server load" => "Palvelin kuorma",
"page id" => "sivu id",
"cached" => "puskuroitu",
"3d browser" => "3d selain",
"print" => "tulosta",
"create pdf" => "luo pdf",
"Save to notepad" => "Tallenna muistioon",
"monitor this page" => "tarkkaile tätä sivua",
"stop monitoring this page" => "lopeta tämän sivun tarkkailu",
"backlinks" => "paluulinkit",
"Previous page" => "Edellinen sivu",
"Parent page" => "Isäntä sivu",
"Next page" => "Seuraava sivu",
"Child" => "Ala",
"Add Page" => "Lisää Sivu",
"First page" => "Ensimmäinen sivu",
"page" => "sivu",
"Last page" => "Viimeinen sivu",
"Last edited by" => "Viimeksi muokannut",
"based on work by" => "perustyön tehnyt",
"Page last modified on" => "Sivua viimeksi muutettu",
"Contributors to this page" => "Tämän sivun avustajat",
"last modification" => "muokattu viimeksi",
"To edit the copyright notices" => "Muuttaaksesi copyright huomautusta",
"click here" => "paina tästä",
"The content on this page is licensed under the terms of the" => "Tämän sivun sisältö on lisenssoitu seuraavien ehtojen mukaan",
"The original document is available at" => "Alkuperäinen asiakirja on saatavilla",
"rename" => "nimeä",
"unlock" => "aukaise",
"lock" => "lukitse",
"perms" => "oikeud",
"history" => "historia",
"similar" => "samanlainen",
"undo" => "peru",
"slides" => "kuvat",
"export" => "vie",
"discuss" => "pohtia",
"add comment" => "lisää kommentti",
"1 comment" => "1 kommentti",
"comments" => "kommenttia",
"attach file" => "liite tiedosto",
"1 file attached" => "1 liite tiedosto",
"{\$atts_cnt} files attached" => "{\$atts_cnt} liite tiedostoa",
"translation" => "käännös",
"Page generated in" => "Sivu luotu",
"The newsletter was sent to {\$sent} email addresses" => "Uutislehti on lähetetty {\$sent} sähköposti osoitteisiin",
"This newsletter will be sent to {\$subscribers} email addresses." => "Tämä uutislehti lähetetään {\$subscribers} sähköposti osoitteisiin.",
"Prepare a newsletter to be sent" => "Valmistele uutislehti lähetettäväksi",
"Newsletter" => "Uutislehti",
"Apply template" => "Lisää malli",
"none" => "eimitään",
"Data" => "Tietue",
"Send Newsletters" => "Lähetä Uutislehti",
"Made with" => "Tehty",
"powered by" => "moottorina",
"This is" => "Tämä on",
"by the" => " ",
"Tiki community" => "Tiki yhteisö",
"User List" => "Käyttäjä Lista",
"Homework" => "Kotitehtävä",
"Assignments" => "Liitokset",
"Last Changes" => "Viimeiset Muutokset",
"attachments" => "liitteet",
"Click" => "Paina",
"User files" => "Käyttäjä tiedostot",
"Favorites" => "Mieltymykset",
"Watches" => "Vahdit",
"Show/Hide Left Menus" => "Näytä/Piilota Valikot Vasemmalla",
"Show/Hide Right Menus" => "Näytä/Piilota Valikot Oikealla",
"home" => "koti",
"contact us" => "ota yhteyttä",
"stats" => "tilastot",
"categories" => "luokkaa",
"Member list" => "Jäsen luettelo",
"last changes" => "viimeiset muutokset",
"dump" => "dumppi",
"rankings" => "arvostukset",
"list pages" => "listaa sivut",
"orphan pages" => "yksinäiset sivut",
"sandbox" => "hiekkaloota",
"received pages" => "vastaanotetut sivut",
"structures" => "rakenteet",
"Articles Home" => "Artikkelien Koti",
"Create/Edit Blog" => "Luo/Muokkaa Blogia",
"Browse Directory" => "Selaa Hakemistoa",
"List Quizzes" => "Listaa Visailut",
"List Trackers" => "Listaa Kortistot",
"List Surveys" => "Listaa Tutkimukset",
"Prefs" => "Kokoonp",
"MyFiles" => "OmatTiedostot",
"back to homepage" => "takaisin etusivulle",
"This page is being edited by" => "Tätä sivua on muokannut",
"Proceed at your own peril" => "Jatka omalla vastuulla",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Hiekkalaatikko on sivu jolla voi harjoitella sivun muokkaus taitoja, käyttää mahdollisuutta katsoa eri kokeiluja, mitään versiota tästä sivusta ei tallenneta.",
"Description" => "Kuvaus",
"My Footnotes" => "Omat Alaviitteet",
"Edit Summary" => "Muokkaa Yhteenvetoa",
"Year:" => "Vuosi:",
"Authors:" => "Kirjoittajat:",
"Allow HTML" => "Salli HTML",
"Spellcheck" => "Oikeinkirjoitus",
"Import page" => "Tuo sivu",
"export all versions" => "vie kaikki versiot",
"Upload picture" => "Lähetä kuva",
"no cache" => "ei puskuri",
"minute" => "minuutti",
"hour" => "tunti",
"Anti-Bot verification code" => "Anti-Bot varmistus coodi",
"Enter the code you see above" => "Kirjoita alla näkyvä koodi",
"License" => "Lisenssi",
"Important" => "Tärkeää",
"Minor" => "Pieni",
"cancel edit" => "peruuta muutos",
"No attachments for this page" => "Ei liitteitä tälle sivulle",
"My Tiki" => "OmatSivut",
"User Pages" => "Käyttäjä Sivut",
"List pages where I am a creator" => "Listaa sivut joilla olen luojana",
"by creator" => "luojana",
"List pages where I am a modificator" => "Listaa sivut joita olen muokannut",
"by modificator" => "muokkaajana",
"User Galleries" => "Käyttäjä Galleriat",
"Assigned items" => "Liitetyt osat",
"at tracker" => "kortistossa",
"Unread Messages" => "Lukemattomat Viestit",
"User Blogs" => "Käyttäjä Blogit",
"RSS Trackers" => "RSS Kortistot",
"left/right" => "vasen/oikea",
"Unassign module" => "poista moduuli",
"Mini Calendar" => "Mini Kalenteri",
"Edit mapfiles" => "Muokkaa karttatiedostoja",
"switch" => "kytkin",
"on:" => ":",
"reads" => "lukijaa",
"Article image" => "Artikkeli kuva",
"Topic image" => "Aiheen kuva",
"Refresh" => "Päivitä",
"Location : " => "Sijainti : ",
"Find:" => "Löytyi:",
"Sort posts by:" => "Lajittele postit:",
"posted by" => "lähettänyt",
"read more" => "lue listää",
"pages" => "sivuja",
"Permalink" => "Peruslinkki",
"referenced by" => "lainattu",
"references" => "viittaukset",
"view comments" => "näytä kommentit",
"email this post" => "sähköpostita tämä lähetys",
"Viewing blog post" => "Näyttää blogilähetyksiä",
"Return to blog" => "Palaa blogiin",
"Trackback pings" => "Viittaustoiminnon pingit",
"Blog name" => "Blogin nimi",
"Translate in" => "Käännä",
"babelfish it" => "babelfish se",
"User Bookmarks" => "Käyttäjän Kirjanmerkit",
"Welcome to" => "Tervetuloa",
"Click here to create it" => "Paina tästä luodaksesi sen",
"wiki help" => "wiki apu",
"Enlarge area height" => "Suurenna alueen korkeutta",
"Reduce area height" => "Pienennä alueen korkeutta",
"Features" => "Ominaisuudet",
"General" => "Yleiset",
"Meta Tags" => "Meta Tagit",
"Site Identity" => "Sivusto Identity",
"Site Calendar" => "Sivusto Kalenteri",
"Tip" => "Vihje",
"To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "Lisätäksesi/poistaaksesi blogeja, mene \"Luo/Muokkaa blogia\" siellä \"Blogit\" ohjelma valikossa, tai",
"Home Blog" => "OmaBlogi",
"Home Blog (main blog)" => "Koti Blogi (pää blogi)",
"Blog features" => "Blogi ominaisuudet",
"Blog level comments" => "Blogi tason kommentit",
"Post level comments" => "Lähetys tason kommentit",
"Post level trackback pings" => "Lähetys tason viittaustoiminnon pingit",
"Spellchecking" => "Oikeinkirjoitus",
"Not Installed" => "Ei Asennettu",
"Default ordering for blog listing" => "Oletus järjestys blogilistalle",
"Creation date (desc)" => "Luontipäivä (aleneva)",
"Last modification date (desc)" => "Viimeisin muokkaus päivä (aleneva)",
"Blog title (asc)" => "Blogin aihe (nouseva)",
"Number of posts (desc)" => "Lähetysten määrä (aleneva)",
"Visits (desc)" => "Vierailuja (aleneva)",
"Activity (desc)" => "Aktiivisuus (aleneva)",
"Change preferences" => "Muuta asetuksia",
"Blog listing configuration (when listing available blogs)" => "Blogi listauksen asetukset (kun listataan saatavilla olevia blogeja)",
"Creation date" => "Luonti päivä",
"Last modification time" => "Muokattu viimeksi",
"Disabled" => "Poistettu",
"Plain text" => "Tavallinen teksti",
"Link to user information" => "Linkki käyttäjä tietoihin",
"User avatar" => "Käytä Hahmoa",
"Blog comments settings" => "Blogi kommenttien asetukset",
"Default number of comments per page" => "Oletus määrä kommentteja per sivu",
"Comments default ordering" => "Kommenttien oletus järjestys",
"Points" => "Pisteet",
"To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "Lisätäksesi/poistaaksesi kalentereita, katso \"Ylläpito\" \"Kalenteri\" ohjelmavalikosta, tai",
"Group calendar sticky popup" => "Ryhmä kalenterin pysyvä popup",
"Group calendar item view tab" => "Ryhmä kalenterin osan näyttö tabi",
"Calendar manual selection of time/date" => "Kalenterin ajan/päiväyksen valinta käsin",
"JsCalendar" => "JsKalenteri",
"Change settings" => "Muuta asetuksia",
"Look under \"Articles\" on the application menu for links to" => "Katso \"Artikkelit\" ohjelma valikon linkit",
"CMS features" => "CMS ominaisuudet",
"Submissions" => "Ehdotukset",
"Use templates" => "Käytä malleja",
"Settings for page articles home" => "Asetukset artikkelien perus sivulle",
"Maximum number of articles in home" => "Artikkeleiden suurin määrä kotona",
"Article comments settings" => "Artikkeli kommenttien asetukset",
"Fields to display on page" => "Sivulla näytettävät kentät",
"Topic" => "Aihe",
"Publish Date" => "Julkaisu päivä",
"Expire Date" => "Poistumis päivä",
"Visible" => "Näkyvä",
"Img" => "Kuva",
"User identity features" => "Käyttäjän yksilöinti ominaisuudet",
"Show user's info on mouseover" => "Näyttää käyttäjän tiedot kun hiiri on päällä",
"Picture" => "Kuva",
"Number of friends" => "Ystävien lukumäärä",
"Country" => "Maa",
"E-mail" => "Sähköposti",
"Last login" => "Viimeksi kirjautunut",
"Distance" => "Etäisyys",
"Set features" => "Aseta ominaisuudet",
"To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "Muokataksesi hakemistoasi, etsi \"Ylläpidä hakemistoja\" \"Hakemiston\" alta ohjelmisto valikosta, tai",
"Number of columns per page when listing categories" => "Palstojen määrä kun listataan luokkia",
"Links per page" => "Linkkiä per sivu",
"Validate URLs" => "Tarkista URL:it",
"enable cool sites" => "valitse siistit sivustot",
"Method to open directory links" => "Menetelmä avataksesi hakemisto linkkejä",
"replace current window" => "korvaa nykyinen ikkuna",
"new window" => "uusi ikkuna",
"inline frame" => "sisäinen kehys",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "Lisätäksesi/poistaaksesi UKK:siä, katso \"Ylläpidä UKK\" \"UKK:on\" alta ohjelmisto valikosta, tai",
"Tiki sections and features" => "Osastot ja ominaisuudet",
"Featured Help" => "Ominaisuus Apu",
"Workflow engine" => "Työvuo moottori",
"Live Support" => "Elävä Tuki",
"Live support system" => "Elävä tuki systeemi",
"Help System" => "Avuste Systeemi",
"tikiwiki.org help" => "tikiwiki.org apu",
"Multilingual" => "Monikielinen",
"Best language" => "Paras kieli",
"Show Category Path" => "Näytä Luokan Polku",
"Show Babelfish Translation URLs" => "Näytä Babelfish käännös URL:it",
"Show Category Objects" => "Näytä Luokan Kohteet",
"Show Babelfish Translation Logo" => "Näytä Babelfish käännös Logo",
"Show Module Controls" => "Näytä Moduulin hallinta",
"Tiki Calendar" => "Kalenteri",
"Template Viewing" => "Mallin näyttö",
"Tiki Template Viewing" => "Mallin näyttö",
"PHPLayers" => "PHPTasot",
"PhpLayers Dynamic menus" => "PhpTasojen Muuttuvat valikot",
"Use Tabs" => "Käytä Tabeja",
"Tiki Sheet" => "Laskenta Taulukko",
"Site Logo and Identity" => "Sivusto Logo ja Identity",
"Content Features" => "Sisältö Ominaisuudet",
"Edit Templates" => "Muokkaa malleja",
"Hotwords in New Windows" => "Hotwords Uudessa Ikkunassa",
"Edit CSS" => "Muokkaa CSS",
"Custom Home" => "Muunneltu Koti",
"HTML Pages" => "HTML Sivut",
"Dynamic Content System" => "Muuttuvan Sisällön Systeemi",
"Allow Smileys" => "Salli Hymiöt",
"AutoLinks" => "AutoLinkit",
"Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Käytä Lainaus plugia mieluummin kuin &ldquo;>&rdquo; lainauksiin",
"Administration Features" => "Ylläpidon Ominaisuudet",
"Banning System" => "Esto Järjestelmä",
"Banning system" => "Esto järjestelmä",
"Communications (send/receive objects)" => "Yhteistoiminta (lähetä/vastaanota kohteita)",
"Theme Control" => "Teeman Hallinta",
"Referer Stats" => "Suositus Tilastot",
"Contact Us" => "Ota Yhteyttä",
"Contact Us (Anonymous)" => "Ota Yhteyttä (Nimettömänä)",
"Redirect On Error" => "Uudelleen suuntaa virheet",
"User Features" => "Käyttäjä Ominaisuudet",
"User Preferences Screen" => "Käyttäjän Asetusnäyttö",
"Users can Configure Modules" => "Käyttäjä voi hallita Moduuleja",
"always" => "aina",
"module decides" => "moduuli valitsee",
"never" => "ei koskaan",
"Users can Shade Modules" => "Käyttäjät voivat pienentää Moduulit",
"User Watches" => "Käyttäjän Vahdit",
"User Watches Translations" => "Käyttäjä Vahtien Käännökset",
"User Tasks" => "Käyttäjän Tehtävät",
"User Messages" => "Käyttäjän Viestit",
"User Files" => "Käyttäjän Tiedostot",
"User Notepad" => "Käyttäjän Muistio",
"General Layout options" => "Yleiset ulkoasun valinnat",
"Users can Flip Columns" => "Käyttäjä voi Vaihtaa Palstoja",
"Left column" => "Vasen palsta",
"user decides" => "käyttäjä valitsee",
"Layout per section" => "Ulkoasu osastoittain",
"Right column" => "Oikea palsta",
"Admin layout per section" => "Ylläpidon ulkoasu osastoittain",
"Top bar" => "Ylä palkki",
"Bottom bar" => "Ala palkki",
"Bottom bar icons" => "Alareunan ikonit",
"Bottom bar debug" => "Alareunan debug",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "Lisätäksesi/poistaaksesi tiedoston galleriasta, mene \"Tiedosto Galleriat\" ohjelmisto valikossa, tai",
"Home Gallery" => "Perus Galleria",
"Home Gallery (main gallery)" => "Koti Galleria (pää galleria)",
"Galleries features" => "Gallerioiden ominaisuudet",
"Allow same file to be uploaded more than once" => "Sallii saman tiedoston lähetyksen useammin kuin kerran",
"Use database to store files" => "Käytä tietokantaa tiedostojen varastointiin",
"Use a directory to store files" => "Käytä hakemistoa tiedostojen varastointiin",
"Directory path" => "Hakemisto polku",
"Uploaded filenames must match regex" => "Lähetettyjen tiedostojen nimien täytyy sopia yhteen regex kanssa",
"Uploaded filenames cannot match regex" => "Lähetettyjen tiedostojen nimet eivät saa sopia yhteen regex kanssa",
"Storing files in a directory" => "Tiedostot varastoidaan hakemistoon",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Jos valitset tallennuspaikaksi hakemiston sinun on oltava varma ettei käyttäjät pääse suoraan siihen hakemistoon.",
"You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "Sinulla on kaksi vaihtoehtoa tähän:<br /><ul><li>Käytä hakemistoa joka on sivuston ulkopuolella, varmista, että php scripti voi lukea ja kirjoittaa siihen hakemistoon</li><li>Käytä hakemistoa sivuston sisäpuolella ja käytä .htaccess tiedostoa sulkemaan ulkopuoliset pois</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "Muokatessasi hakemisto polkua käytä UNIX polkuja esimerkki tiedostoissa/ tai c:/foo/tiedostot tai /www/tiedostot/",
"please read" => "ole hyvä ja lue",
"Gallery listing configuration" => "Gallerian listaus asetukset",
"Change configuration" => "Muuta kokoonpanoa",
"File galleries comments settings" => "Tiedosto gallerian kommentti asetukset",
"File galleries search indexing" => "Tiedosto gallerioiden etsintä indeksointi",
"Leave command blank to delete handler" => "Jätä kehote tyhjäksi poistaaksesi käsittelijän",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Käytä %1 jolloin sisäinen tiedostonimi korvataan (esimerkki: \"strings %1\" muuntaa asiakirjan tekstiksi käyttäen unix strings komentoja)",
"Enable auto indexing on file upload or change" => "Valitse auto indeksointi tiedosto lähetyksiin tai muutoksiin",
"MIME Type" => "MIME Tyyppi",
"System command" => "Järjestelmän komento",
"Reindex all files for search" => "Uudelleen indeksoi kaikki tiedostot etsintää varten",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "Lisätäksesi/poistaaksesi foorumeja, katso \"Ylläpidä foorumeja\"  \"Foorumien\" alta ohjelmisto valikosta, tai",
"Home Forum" => "Perus Foorumi",
"Home Forum (main forum)" => "Koti Foorumi (pää foorumi)",
"Forums features" => "Foorumin ominaisuudet",
"Accept wiki syntax" => "Hyväksy syntaksi",
"Forum quick jumps" => "Foorumin nopea vaihto",
"Ordering for forums in the forum listing" => "Valitsee foorumit foorumi listalta",
"Creation Date (desc)" => "Luonti Päivä (aleneva)",
"Topics (desc)" => "Aiheet (aleneva)",
"Threads (desc)" => "Ketjut (aleneva)",
"Last post (desc)" => "Viimeiset lähetykset (aleneva)",
"Name (desc)" => "Nimi (aleneva)",
"Name (asc)" => "Nimi (nouseva)",
"Forum listing configuration" => "Foorumi listauksen asetukset",
"Topics" => "Aiheet",
"Posts per day" => "Lähetystä päivässä",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "Lisätäksesi/poistaaksesi kuva gallerioita, mene \"Kuva Galleriat\" ohjelmisto valikosta, tai",
"You can upload images of a size of " => "Voit lähettää kuvia joiden koko on max ",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Muokkaa php.ini muuttujaa file_uploads, upload_max_filesize, post_max_size ja tietokanta muuttujaa (max_allowed_packet for mysql) muuttaaksesi tätä arvoa",
"Uses Slideshow" => "Käytä Kuvaesitystä",
"Use database to store images" => "Käytä tietokantaa kuvien varastointiin",
"Use a directory to store images" => "Käytä hakemistoa kuvien varastointiin",
"Library to use for processing images" => "Kirjasto jota käytetään kuvien käsittelyyn",
"Uploaded image names must match regex" => "Lähetettyjen kuvien nimien täytyy olla yhteen sopiva regex kanssa",
"Uploaded image names cannot match regex" => "Lähetettyjen kuvien nimet eivät saa olla yhteen sopivia regex kanssa",
"Directory Batch Loading" => "Hakemiston Ryhmä Lataus",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Jos käytät Hakemisto Ryhmä Latausta, sinun on tehtävä hakemisto sivuston ulkopuolelle (ulkopuolinen hakemisto on parempi). Aseta polku siihen hakemistoon, molemmat scp, ftp, tai muut protokollat",
"Enable directory batch loading" => "Oikeuta hakemisto ryhmä lataus",
"Batch loading directory" => "Ryhmä lataus hakemisto",
"Enable cache images to all galleries" => "Oikeuta puskurointi kaikille kuva gallerioille",
"Images cache directory" => "Kuvien puskuri hakemisto",
"Exterminator" => "Tuhoaja",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Poista kuvat sivuston galleriasta jos niitä ei ole käytetty sivuilla, artikkeleissa tai blogi lähetyksissä",
"All galleries" => "Kaikki galleriat",
"Move" => "Siirrä",
"images" => "kuvista",
"Image galleries comments settings" => "Kuva gallerian kommenttien asetukset",
"General Preferences" => "Yleiset Oikeudet",
"Theme" => "Teema",
"Change style only" => "Muuta vain tyyli",
"Slideshows theme" => "Kuvaesityksen teema",
"Use group homepages" => "Käytä ryhmä etusivuja",
"Go to group homepage only if login from default homepage" => "Mene ryhmä etusivulle vain jos kirjautuminen tapahtuu oletus etusivulle",
"Use URI as Home Page" => "Käytä URI EtuSivuna",
"Home page" => "EtuSivu",
"Custom home" => "Muunneltu etusivu",
"Detect browser language" => "Katso selaimen kieli",
"Use database for translation" => "Käytä tietokantaa käännökseen",
"Record untranslated" => "Tallenne kääntämättä",
"Unknown/Other" => "Tuntematon/Muu",
"PHP error reporting level for non-admin:" => "PHP virhe raportointi taso ei ylläpidolle:",
"No error reporting" => "Ei virhe raportointia",
"Report all PHP errors" => "Raportoi kaikki PHP virheet",
"Report all errors except notices" => "Raportoi kaikki virheet muttei huomautuksia",
"Report PHP errors only for admin" => "Raportoi PHP virheet vain ylläpidolle",
"Default charset for sending mail:" => "Oletus kirjainasetus postin lähetykseen:",
"Mail end of line:" => "Lähetä lopetus:",
"(standard)" => "(standardi)",
"(some Unix MTA)" => "(jotkin Unix MTA)",
"General Settings" => "Yleiset Asetukset",
"Disallow access to the site (except for those with permission)" => "Älä salli pääsyä sivustolle (paitsi niiltä joilla on lupa)",
"Message to display when site is closed" => "Näytettävä viesti kun sivusto on suljettu",
"Disallow access when load is above the threshold (except for those with permission)" => "Älä salli palvelimen käyttöä kun kuormituskynnys ylittyy (paitsi niiltä joilla on lupa)",
"Max average server load threshold in the last minute" => "Palvelimen kuormituskynnys on juuri ylittynyt",
"Message to display when server is too busy" => "Viesti joka näytetään, kun palvelin on ylikuormitettu",
"Open external links in new window" => "Avaa ulkoiset linkit uuteen ikkunaan",
"Display modules to all groups always" => "Näyttää kaikki moduulit kaikille ryhmille aina",
"Use cache for external pages" => "Käytä puskuria ulkoisille sivuille",
"Use cache for external images" => "Käytä puskuria ulkoisille kuville",
"Use direct pagination links" => "Käytä suoria sivutuslinkkejä",
"Display menus as folders" => "Näytä valikot kansioina",
"Tikiwiki.org help" => "Tikiwiki.org apu",
"Use gzipped output" => "Käytä pakattua tulostusta",
"output compression is active." => "tulostuksen pakkaus on päällä.",
"compression is handled by" => "pakkauksen käsittelee",
"Count admin pageviews" => "Laske ylläpidon sivunäytöt",
"Hide anonymous-only modules from registered users" => "Piilota nimettömien moduulit rekisteröityneiltä käyttäjiltä",
"Server name (for absolute URIs)" => "Palvelimen Nimi (tarkkaa URI:ia varten)",
"HTTPS Server" => "HTTPS Palvelin",
"Automatic (uses HTTPS variable)" => "Automaattinen (käyttää HTTPS muuttujaa)",
"No" => "Ei",
"Yes" => "Kyllä",
"Browser title" => "Selain otsikko",
"Wiki_Tiki_Title" => "Wiki_Tiki_Otsikko",
"Temporary directory" => "Väliaikainen hakemisto",
"Sender Email" => "Lähettäjän Sähköposti",
"Contact user" => "Ota yhteys käyttäjään",
"Allow anonymous users to \"Contact Us\"" => "Sallii nimettömien käyttäjien \"Ottaa Yhteyttä\"",
"contact feature disabled" => "yhteyden otto ominaisuus poistettu",
"Store session data in database" => "Varastoi istunnon tiedot tietokantaan",
"Session lifetime in minutes" => "Istunnon elinikä minuutteina",
"Use proxy" => "Käytä proxyä",
"Proxy Host" => "Proxy Isäntä",
"Proxy port" => "Proxy portti",
"Maximum number of records in listings" => "Asiakirjojen suurin määrä listauksessa",
"Help URL" => "Apu URL",
"Please expect not found help-pages with the default-URL." => "Ei löytynyt avustesivuja oletus URL osoitteella.",
"Any help with the documentation is welcome." => "Kaikki apu ohjeiden tekoon on tervetullutta.",
"Date and Time Formats" => "Päiväys ja Aika Muodot",
"Long date format" => "Pitkä päiväys muoto",
"Short date format" => "Lyhyt päiväys muoto",
"Long time format" => "Pitkä aika muoto",
"Short time format" => "Lyhyt aika muoto",
"Date and Time Format Help" => "Päiväys ja Aika Muoto Apu",
"Favicon icon file name:" => "Favicon icon tiedostonimi:",
"Favicon icon MIME type:" => "Favicon icon MIME tyyppi:",
"image/png" => "kuva/png",
"image/bmp" => "kuva/bmp",
"image/x-icon" => "kuva/x-icon",
"Locations separator" => "Sijainnin erottelija",
"Register this site at tikiwiki.org" => "Rekisteröi tämä sivusto tikiwiki.org:iin",
"Click here for more details." => "Paina tästä saadaksesi lisätietoja.",
"Change admin password" => "Muuta admin salasana",
"New password" => "Uusi salasana",
"Change password" => "Muuta Salasana",
"Reg users can change language" => "Rekisteröityneet käyttäjät voivat vaihtaa kieltä",
"Restrict available languages" => "Rajoita saatavilla olevia kieliä",
"Available languages:" => "Saatavilla olevat kielet:",
"Edit or ex/import Languages" => "Muokkaa tai vie/tuo Kieliä",
"Intertiki exchange feature" => "Intertiki keskus ominaisuus",
"Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Sivuston kokoonpanon kenttäarvo tietokannassa on asetettu max. 250 pituiseksi oletuksena nyt. Se on myös muokatussa koodisisällössä. Tarkista tämä kenttä jos haluat päivittää kokoonpanoasi että tietokanta tukee suurempia kuin 250 merkkiä (testattu ja toimii ainakin mysql, Aina kun teet tietokanta muutoksia tee käsin varmuuskopiot)",
"Intertiki client" => "Intertiki asiakas",
"Tiki Unique key" => "Tiki Ainutkertainen avain",
"InterTiki Slave mode" => "InterTiki Orja muoto",
"Warning: overrides manually registered local users" => "Waroitus: ylikirjoittaa käsin liitetyt paikalliset käyttäjät",
" as master" => " mestarina",
"Import user preferences" => "Tuo käyttäjä kokoonpanot",
"Import user groups" => "Tuo käyttäjäryhmät",
"InterTiki Server" => "InterTiki Palvelin",
"host" => "isäntä",
"port" => "portti",
"path" => "polku",
"groups" => "ryhmät",
"Add new server" => "Lisää uusi palvelin",
"Intertiki server" => "Intertiki palvelin",
"Intertiki Server enabled" => "Intertiki Palvelin käynnissä",
"Access Log file" => "Avaa Logi tiedosto",
"Errors Log file" => "Virheiden Logi tiedosto",
"Known hosts" => "Tunnetut isännät",
"Key" => "Avain",
"Contact" => "Yhteys",
"New" => "Uusi",
"Enable/disable Tiki features in " => "Päälle/pois Tiki ominaisuudet ",
"Admin->Features" => "Ylläpito->Ominaisuudet",
", but configure them elsewhere" => ", mutta muokkaa kokoonpanoa muualla",
"Users &amp; groups" => "Käyttäjät &amp; ryhmät",
"Admin groups" => "Ylläpidä ryhmiä",
"Admin users" => "Ylläpidä käyttäjiä",
"User registration and login" => "Käyttäjän rekisteröinti ja kirjautuminen",
"Authentication method" => "Varmennus menetelmä",
"Just Tiki" => "Vain Tiki",
"Web Server" => "Web Palvelin",
"Tiki and PEAR::Auth" => "Tiki ja PEAR::Auth",
"Tiki and PAM" => "Tiki ja PAM",
"Tiki and HTTP Auth" => "Tiki ja HTTP Auth",
"Use WebServer authentication for Tiki" => "Käytä palvelinta varmennukseen",
"Users can register" => "Käyttäjät voivat rekisteröityä",
"... but need admin validation" => "... mutta tarvitsee ylläpidon hyväksynnän",
"must be turned on and notification is sent to the admin's" => "on oltava päällä ja ilmoitus ylläpidolle lähetetään",
"inter-user message inbox" => "inter-käyttäjän postilaatikko",
"Create a group for each user <br />(with the same\nname as the user)" => "Luo ryhmä jokaiselle <br />(samalla\nnimellä kuin käyttäjä)",
"Use tracker for more user information" => "Käytä kortistoa muulle käyttäjä tiedoille",
"Use tracker for more group information" => "Käytä kortistoa muulle ryhmä tiedoille",
"Request passcode to register" => "Pyydä passikoodi rekisteröityäksesi",
"Prevent automatic/robot registration" => "Estä automaattinen/robotin rekisteröinti",
" - Php GD library required" => " - Php GD kirjasto tarvitaan",
"Validate users by email" => "Varmista käyttäjät sähköpostilla",
"Validate email address (may not work)" => "Varmista sähköposti osoite (ei ehkä toimi)",
"Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Muistuta salasanasta sähköpostilla (jos \"Tallenna teksti salasanat\" on aktivoitu.) Muutoin, Lähetä uusi salasana sähköpostilla",
"Store plaintext passwords" => "Varastoi teksti salasanat",
"Reg users can change password" => "Rekisteröitynyt käyttäjä voi vaihtaa salasanaa",
"Reg users can change theme" => "Rekisteröityneet käyttäjät voivat vaihtaa teemaa",
"Restrict available themes" => "Rajoita saatavilla olevia teemoja",
"Available styles:" => "Saatavilla olevat tyylit:",
"Maximum mailbox size (messages, 0=unlimited)" => "Postilaatikon suurin koko (viestiä, 0=rajoittamaton)",
"Maximum mail archive size (messages, 0=unlimited)" => "Arkiston suurin koko (viestiä, 0=rajoittamaton)",
"Maximum sent box size (messages, 0=unlimited)" => "Lähetyslaatikon suurin koko (viestiä, 0=rajoittamaton)",
"Use challenge/response authentication" => "Käytä mahdollisuus/vastine varmistusta",
"Force to use chars and nums in passwords" => "Pakota käyttämään kirjaimia ja numeroita salasanassa",
"Minimum password length" => "Salasanan minimi pituus",
"Password invalid after days" => "Salasana vanhenee päivien jälkeen",
"Require HTTP Basic authentication" => "Vaaditaan HTTP perus varmistus",
"Allow secure (https) login" => "Salli salattu (https) kirjautuminen",
"Require secure (https) login" => "Vaaditaan salattu (https) kirjautuminen",
"HTTP server name" => "HTTP palvelin nimi",
"HTTP port" => "HTTP portti",
"HTTP URL prefix" => "HTTP URL etuliite",
"HTTPS server name" => "HTTPS palvelin nimi",
"HTTPS port" => "HTTPS portti",
"HTTPS URL prefix" => "HTTPS URL etuliite",
"Remember me feature" => "Muista minut",
"Only for users" => "Vain käyttäjille",
"Users and admins" => "Käyttäjät ja Ylläpitäjät",
"Duration:" => "Kesto:",
"day" => "päivä",
"week" => "viikko",
"month" => "kuukausi",
"year" => "vuosi",
"Remember me name" => "Muista minut nimi",
"Remember me domain" => "Muista minut domain",
"Remember me path" => "Muista minut polku",
"Protect against CSRF with a confirmation step" => "Suojele CSRF varmistus portain",
"Protect against CSRF with a ticket" => "Suojele CSRF:ta vastaan lipulla",
"Highlight Group" => "Korosta Ryhmä",
"choose a group ..." => "valitse ryhmä ...",
"Create user if not in Tiki?" => "Luo käyttäjä jos ei ole?",
"Create user if not in Auth?" => "Luo käyttäjä jos ei Auth?",
"Just use Tiki auth for admin?" => "Käytä vain varmistusta ylläpitäjälle?",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(jos asetettu, tämä ylikirjoittaa isännän ja portin alhaalta)",
"LDAP Scope" => "LDAP Kattavuus",
"LDAP User Attribute" => "LDAP Käyttäjä Ominaisuudet",
"LDAP User OC" => "LDAP Käyttäjä OC",
"LDAP Group DN" => "LDAP Ryhmä DN",
"LDAP Group Attribute" => "LDAP Ryhmä Ominaisuudet",
"LDAP Group OC" => "LDAP Ryhmä OC",
"LDAP Member Attribute" => "LDAP Jäsen Ominaisuudet",
"LDAP Member Is DN" => "LDAP Jäsen Is DN",
"LDAP Admin User" => "LDAP Ylläpito Käyttäjä",
"LDAP Admin Pwd" => "LDAP Ylläpito Pwd",
"PAM service" => "PAM palvelu",
"Currently unused" => "Nyt käyttämätön",
"You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "Sinun on lähetettävä myös <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> erikseen lib/phpcas/.",
"CAS server version" => "CAS palvelin versio",
"Version 1.0" => "Versio 1.0",
"Version 2.0" => "Versio 2.0",
"CAS server hostname" => "CAS palvelimen isäntänimi",
"CAS server port" => "CAS palvelimen portti",
"CAS server path" => "CAS palvelimen polku",
"Change CAS preferences" => "Muuta CAS kokoonpanoa",
"full path to mapfiles" => "täydellinen polku karttatiedostoihin",
"default mapfile" => "oletus karttatiedosto",
"Wiki Page for Help" => "Apu Sivu",
"Wiki Page for Comments" => "Sivu kommenteille",
"Full path to gdaltindex" => "Koko polku gdaltindexiin",
"Full path to ogr2ogr" => "Koko polku ogr2ogr",
"Map Zone" => "Kartta Vyöhyke",
"Generate User Map" => "Luo Käyttäjä Kartta",
"<b>Item</b>" => "<b>Osa</b>",
"<b>Value</b>" => "<b>Arvo</b>",
"Meta Keywords" => "Meta Avainsanat",
"Meta Description" => "Meta Kuvaus",
"Meta Author" => "Meta Kirjoittaja",
"geo.position" => "geo.sijainti",
"geo.region" => "geo.alue",
"geo.placename" => "geo.paikkanimi",
"Robots" => "Robotit",
"meta robots" => "meta robotit",
"revisit after" => "uudelleen vieraillut",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "Lisätäksesi/poistaaksesi äänestyksiä, katso \"Äänestykset\" \"Ylläpito\" ohjelmisto valikossa, tai",
"Allow Anonymous Poll Voting" => "Sallii nimettömien äänestää",
"This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or" => "Tämä sivu on kokoonpano sivu RSS syötteille jotka muodostetaa/tulostetaan sivuston. Lukeaksesi/hakeaksesi RSS syötteen, katso \"RSS moduulit\" ohjelmisto valikossa, tai",
"<b>Feed</b>" => "<b>Syöte</b>",
"<b>enable/disable</b>" => "<b>päälle/pois</b>",
"<b>Max number of items</b>" => "<b>Maksimi määrä osia</b>",
"Feed for Articles" => "Syöte Artikkeleille",
"Feed for Weblogs" => "Syöte Weblogeille",
"Feed for Image Galleries" => "Syöte Kuva Gallerioille",
"Feed for File Galleries" => "Syöte Tiedosto Gallerioille",
"Feed for the Wiki" => "Syöte Wiki",
"Feed for individual Image Galleries" => "Syöte yksittäiselle Kuva Gallerialle",
"Feed for individual File Galleries" => "Syöte yksittäiselle Tiedosto Gallerialle",
"Feed for individual weblogs" => "Syöte yksittäiselle weblogille",
"Feed for forums" => "Syöte foorumeille",
"Feed for individual forums" => "Syöte yksittäiselle foorumille",
"Feed for mapfiles" => "Syöte karttatiedostoille",
"Feed for directories" => "Hakemistojen syöte",
"Feed for individual tracker items" => "Syöte yksittäisen kortiston osille",
"Feed for tracker items" => "Kortisto osien syöte",
"Feed for upcoming calendar events" => "Syöte tuleville kalenteri tapahtumille",
"Default RDF version" => "Oletus RDF versio",
"Specification" => "Tuoteseloste",
"Documentation" => "Käsikirja",
"Editor" => "Muokkaaja",
"You can see users rank by score in the module users_rank, for that go to" => "Voit nähdä käyttäjien arvostuksen pisteinä käyttäen users_rank moduulia.",
"Admin modules" => "Ylläpidä moduuleja",
"Expiration" => "Päättyminen",
"Search features" => "Etsintä ominaisuudet",
"Full Text Search" => "Täysi Teksti Haku",
"SearchStats" => "EtsintäTilastot",
"Referer Search Highlighting" => "Etsintä Viittausten Korostus",
"Refresh wiki search index now" => "Päivitä etsintä indeksi nyt",
"Performance issues" => "Suorituskyky asiat",
"Search may show forbidden results. Much better performance though." => "Etsintä voi näyttää kiellettyjä tuloksia. Parempi suorituskyky.",
"Ignore individual object permissions" => "Älä huomio yksittäisen kohteen oikeuksia",
"Ignore category viewing restrictions" => "Älä huomio luokittelunäytön rajoituksia",
"Settings for searching content" => "Asetukset sisällön etsintään",
"Search refresh rate" => "Etsinnän päivitys väli",
"Minimum length of search word" => "Etsittävän sanan minimi pituus",
"Max. number of words containing a syllable" => "´Maksimi määrä sanoja sisältäen tavuja",
"Max. age in hours of syllable search cache" => "Maksimi ikä tunteina tavutus etsinnän puskurille",
"LRU list purging rate" => "LRU listaa tyhjennys välit",
"LRU list length" => "LRU listan pituus",
"Don't forget: to use feature you will need to enable it on" => "Äläkä unohda: käytääksesi ominaisuutta se on pantava päälle täältä",
"Custom Code" => "Muokattu Koodi",
"Custom code" => "Muokattu koodi",
"Content" => "Sisältö",
"Publish" => "Julkaise",
"Site Breadcrumbs" => "Sivusto Palat",
"Site breadcrumbs" => "Sivusto palat",
"Site location bar" => "Sivuston sijainti palkki",
"at top of page" => "sivun yläosassa",
"at top of center column" => "sivun yläosassa keskipalstalla",
"Prefix breadcrumbs with 'Location:' label?" => "Etuliite palasta ja 'Sijainti:' etiketti?",
"Larger font for" => "Suurempi kirjasin",
"entire location" => "koko sijainti",
"page name" => "sivu nimi",
"Use page description:" => "Käytä sivun kuvausta:",
"Site Search" => "Sivusto Etsintä",
"Site search bar" => "Sivuston etsintä palkki",
"Site Logo" => "Sivusto Logo",
"Site logo" => "Sivusto logo",
"Site logo source" => "Sivusto logo lähde",
"Site logo background color" => "Sivusto logo taustaväri",
"Site logo title (on mouse over)" => "Sivusto logo otsikko (kun hiiri päällä)",
"Alt. description (e.g. for text browsers)" => "Alt. kuvaus (e.g. teksti selaimille)",
"Site Ads and Banners" => "Sivuston Mainokset ja Bannerit",
"Site ads and banners" => "Sivuston mainokset ja bannerit",
"Site Menu" => "Sivusto Valikko",
"Site menu bar" => "Sivusto valikko palkki",
"Note: This feature also requires phplayers to be turned on in Admin->Features" => "Huomio: Tämä ominaisuus tarvitsee myös phplayers päällä olon se löytyy Ylläpitä->Ominaisuudet",
"To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "Muokataksesi kortistoja, katso \"Ylläpidä kortistoja\" \"Kortiston\" alla ohjelmisto valikossa, tai",
"Trackers attachments preferences" => "Kortisto liitteiden kokoonpanot",
"Path" => "Polku",
"Trackers with mirror tables" => "Kortistot ja peilaus taulukot",
"Use trackers with mirror tables" => "Käyttäjä kortistot ja peilaus taulukot",
"Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Arvot tallennetaan niille omistettuun taulukkoon jokaiseen kortistoon, joten voi helposti muokata niitä sivuston ulkopuolella",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely" => "WAROITUS : Vanha ja uusi kortisto eivät voi esiintyä yhtaikaa. Kortistot jotka on luotu uuden kirjaston alaisena\nei näy vanhalla ja päinvastoin",
"Validate choice" => "Varmista valinta",
"Trackers attachments" => "Kortistojen liitteet",
"Storage" => "Varasto",
"change" => "vaihda",
"Change all to db" => "Muuta kaikki tietokantaan",
"Change all to file" => "Muuta kaikki tiedostoon",
"Quota (Mb)" => "Levytila (Mb)",
"Use database to store userfiles" => "Käytä tietokantaa käyttäjätiedostojen varastointiin",
"Use a directory to store userfiles" => "Käytä hakemistoa käyttäjätiedostojen varastointiin",
"Allow viewing HTML mails?" => "Salli HTML lähetysten näyttäminen?",
"Maximum size for each attachment" => "Jokaisen liitteen maksimi koko",
"Unlimited" => "Rajoittamaton",
"To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "Lisätäksesi/muokataksesi sivuja helposti, lisää moduuli quick_edit \"Moduulit\" ohjelmisto valikosta, tai",
"Dumps" => "Dumpit",
"Generate dump" => "Luo dumppi",
"Download last dump" => "Imuroi viimeisin dumppi",
"Create a Tag for the Current Wiki" => "Luo Tagi Nykyiseen sivustoon",
"Tag name" => "Tagin nimi",
"Restore the Wiki" => "Palauta Sivut",
"restore" => "palauta",
"Remove a Tag" => "Poista Tagi",
"Wiki Comments Settings" => "Kommenttien Asetukset",
"Export Wiki Pages" => "Vie Wiki Sivut",
"Export" => "Vie",
"Wiki Administration" => "Ylläpito",
"Manage attachment preferences" => "Hallitse liite kokoonpanoa",
"Remove unused pictures" => "Poista käyttämättömät kuvat",
"Wiki Home Page" => "KotiSivu",
"Wiki Discussion" => "Wiki Keskustelut",
"Discuss pages on forums" => "Keskustelua fooruminsivuista",
"Wiki Link Format" => "Wiki Linkin Muoto",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Hallitsee wiki linkin tunnistusta käyttäen sulkumerkkejä <i>((sivun nimi))</i>.",
"complete" => "valmis",
"Wiki Page List Configuration" => "Sivusto Listaus Kokoonpano",
"Creator" => "Luonut",
"Last version" => "Viimeisin versio",
"Status" => "Tila",
"Versions" => "Versiot",
"Backlinks" => "Paluulinkit",
"Wiki 3D Browser Configuration" => "3D Selain Kokoonpano",
"Enable wiki 3D browser" => "Oikeuta 3D selain",
"Browser width" => "Selain leveys",
"Browser height" => "Selain korkeus",
"Navigation depth" => "Siirtymis syvyys",
"Feed animation interval (milisecs)" => "Syötä animaation tauko (milisecs)",
"Existing page node color" => "Olemassa olevan sivun solmu väri",
"Missing page node color" => "Puuttuvan sivun solmu väri",
"Load page on navigation" => "Lataa navikointi sivu",
"Camera distance" => "Kameran etäisyys",
"Camera distance adjusted relative to nearest node" => "Kameran etäisyys annettu suhteellisesti lähimpään solmuun",
"Field of view" => "Näytön kenttä",
"Node size" => "Solmun koko",
"Text size" => "Tekstin koko",
"Friction constant" => "Pysyvä",
"Elastic constant" => "Joustava pysyvä",
"Eletrostatic constant" => "Sähköisesti pysyvä",
"Spring (connection) size" => "Lähteen (yhteys) koko",
"Node mass" => "Solmun massa",
"Node charge" => "Solmun kulutus",
"HTML in Wiki Pages" => "HTML Sivuilla",
"Wiki syntax used when a page contains HTML" => "Sivu syntaxia käytetään kun sivu sisältää HTML:ää",
"full" => "koko",
"partial" => "osittain",
"Wysiwyg editor" => "Wysiwyg muokkain",
"default" => "oletus",
"optional" => "vaihtoehtoinen",
"Wiki Features" => "Wiki Ominaisuudet",
"Anonymous editors must input anti-bot code" => "Tuntemattoman käyttäjän on annettava anti-bot koodi",
"Similar" => "Samanlainen",
"Undo" => "Peruuta",
"PDF generation" => "PDF luonti",
"Warn on edit conflict" => "Varoita muokkaus ristiriidoista",
"Edit idle timeout" => "Muokkauksen odotusaika loppui",
"mins" => "min",
"Pictures" => "Kuvat",
"Use page description" => "Käytä sivun kuvausta",
"Show page title" => "Näytä sivun otsikko",
"Show page ID" => "Näytä sivu ID",
"Cache wiki pages (global)" => "Puskuroi sivut (yleinen)",
"Individual cache" => "Yksittäinen puskuri",
"Footnotes" => "Alaviitteet",
"Users can lock pages (if perm)" => "Käyttäjä voi lukita sivut (jos lupa)",
"Use WikiWords" => "Käytä WikiSanoja",
"Accept dashes and underscores in WikiWords" => "Hyväksy alleviivaus ja keno Sanoissa",
"Link plural WikiWords to their singular forms" => "Linkitä monikko WikiSanat yksikkö muotoon",
"Use Wiki paragraph formatting" => "Käytä sivun kappale muotoilua",
"Automonospaced text" => "Autotasalevyinen teksti",
"Tables syntax" => "Taulukon syntaksi",
"|| for rows" => "|| riveille",
"\\n for rows" => "\\n riveille",
"Open page as structure" => "Avaa sivu rakenteena",
"Use external link icons" => "Käytä ulkoisia linkki iconeja",
"User's Page" => "Käyttäjän Sivu",
"UserPage prefix" => "KäyttäjäSivun etuliite",
"Page creators are admin of their pages" => "Sivu luoja on ylläpitäjä luomilleen sivuille",
"Import HTML" => "Tuo HTML",
"List authors" => "Listaa kirjoittajat",
"as Creator &amp; Last Editor" => "Luojana &amp; Viimeksi Muokannut",
"Business style" => "Bisnes tyyli",
"Collaborative style" => "Yhteisöllinen tyyli",
"no (disabled)" => "ei (poistettu)",
"Print Page" => "Tulosta Sivu",
"Search and replace" => "Etsi ja korvaa",
"Wiki History" => "Wiki Historia",
"Maximum number of versions for history" => "Maksimi määrä versio historiaa",
"unlimited" => "rajoittamaton",
"Never delete versions younger than days" => "Älä poista päivää nuorempia versioita",
"IP not displayed in history" => "IP:tä ei näytetä sivuhistoriassa",
"Diff style" => "Erilainen tyyli",
"Only with last version" => "Vain viimeisimmän version kanssa",
"Any 2 versions" => "Mitkä tahansa 2 versiota",
"Copyright Management" => "Copyright Hallinta",
"Enable Feature" => "Käytä Ominaisuutta",
"License Page" => "Lisenssi Sivu",
"Submit Notice" => "Toimita Huomautus",
"Wiki Watch" => "Wiki Vahti",
"Create watch for author on page creation" => "Luo vahti sivun luojaan",
"Enable watch events when I am the editor" => "Mahdollista vahti kun olen muokkaajana",
"Enable watches on comments" => "Salli vahdit kommenteille",
"Wiki attachments preferences" => "Liitteiden kokoonpanot",
"Wiki attachments" => "Wiki liitteet",
"Crosslinks to other features and settings" => "Ristiviittaukset muihin ominaisuuksiin ja asetuksiin",
"Other sections" => "Muut osastot",
"Spreadsheet" => "Laskentataulukko",
"Administration features" => "Ylläpidon ominaisuudet",
"Security" => "Turvallisuus",
"System" => "Järjestelmä",
"SysLogs" => "JärLogit",
"Mods" => "Modulit",
"Transversal features" => "Käännös ominaisuudet",
"which apply to more than one section" => "jotka lisätään useampaan kuin yhteen osastoon",
"Navigation features" => "Siirtymis omaisuudet",
"Look &amp; feel" => "Ulkonäkö &amp; fiilis",
"themes" => "teemat",
"Text area features" => "Tekstialue ominaisuudet",
"features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "ominaisuudet joita voi käyttää kaikkialla, sivuston sivuilla, blogeissa, artikkeleissa, foorumeilla, jne",
"Stats &amp; banners" => "Tilastot &amp; bannerit",
"Help on Banning System" => "Avusta Poisto Järjestelmässä",
"View tpl" => "Näytä tpl",
"admin banning tpl" => "ylläpidon esto tpl",
"Add or edit a rule" => "Lisää tai muuta sääntö",
"Rule title" => "Säännön otsikko",
"Username regex matching" => "Käyttänimi regex yhdenmukaisuuus",
"IP regex matching" => "IP regex yhdenmukaisuus",
"Banned from sections" => "Osastot estetty",
"check / uncheck all" => "merkitse / poista merkintä kaikista",
"Rule activated by dates" => "Säännön aktivointi päivä",
"Rule active from" => "Sääntö voimassa",
"Rule active until" => "Sääntö voimassa kunnes",
"Custom message to the user" => "Muunneltu viesti käyttäjälle",
"Rules" => "Säännöt",
"User/IP" => "Käyttäjä/IP",
"Sections" => "Osastot",
"Admin Calendars" => "Ylläpidä Kalentereita",
"Configure/Options" => "Kokoonpano/Asetukset",
"List of Calendars" => "Kalenterien lista",
"loc" => "pai",
"participants" => "osallistujat",
"cat" => "luet",
"lang" => "kieli",
"prio" => "ensis",
"subscription" => "tilaukset",
"perso" => "henkilö",
"permissions" => "oikeudet",
"Create/edit Calendars" => "Luo/muokkaa Kalentereita",
"Custom Locations" => "Muunnellut Sijainnit",
"yes" => "kyllä",
"Custom Participants" => "Muutetut Osallistujat",
"Custom Categories" => "Muunnellut Luokittelut",
"Custom Languages" => "Muunnellut Kielet",
"Custom Subscription List" => "Muutettujen Tilausten Lista",
"Custom Priorities" => "Muunnellut Etuoikeudet",
"Personal Calendar" => "Henkilökohtainen Kalenteri",
"admin categories" => "ylläpidä luokitteluja",
"admin categories tpl" => "ylläpidä luokittelujen tpl",
"browse the category system" => "selaa luokittelu järjestelmää",
"Current category" => "Nykyinen luokka",
"Child categories" => "Ala luokittelut",
"Edit this category:" => "Muokkaa tätä luokkaa:",
"create new" => "luo uusi",
"Add new category" => "Lisää uusi luokka",
"Parent" => "Isäntä",
"Perms inherited from closest parent if possible or from global perms" => "Oikeudet katsotaan lähimmästä isännästä tai yleisistä oikeuksista",
"Assign permissions automatically" => "Anna oikeudet automaattisesti",
"recommended for best performance" => "suositellaan parhaan suorituskyvyn vuoksi",
"Edit permissions for this category" => "Muokkaa tämän luokan oikeuksia",
"Objects in category" => "Kohteita luokassa",
"type" => "tyyppi",
"Add objects to category" => "Lisää kohteita luokkaan",
"image gal" => "kuva gal",
"file gal" => "tied gal",
"Admin chart items" => "Ylläpidä kaavion osia",
"charts" => "kaaviot",
"edit chart" => "muuta kaavio",
"Add or edit an item" => "Lisää tai muuta osaa",
"update" => "päivitä",
"Chart items" => "Kaavion osat",
"No items defined yet" => "Ei määritelyjä osia vielä",
"Admin charts" => "Ylläpidä kaavioita",
"View template" => "Näytä malli",
"admin charts template" => "ylläpidä kaavion mallia",
"Add or edit a chart" => "Lisää tai muuta kaavio",
"Active" => "Aktiivinen",
"Users can vote for only one item from this chart per period" => "Käyttäjä voi äänestää vain yhtä osaa kaaviosta per aikajakso",
"Prevent users from voting for the same item more than once" => "Estä käyttäjää äänestämästä samaa osaa enemmän kuin kerran",
"Users can suggest new items" => "Käyttäjät voivat ehdottaa uusia osia",
"Auto validate user suggestions" => "Vahvista automaattisesti käyttäjä ehdotukset",
"Ranking shows" => "Arvostus näyttää",
"All items" => "Kaikki osat",
"Top 10 items" => "Top 10 osat",
"Top 20 items" => "Top 20 osat",
"Top 40 items" => "Top 40 osat",
"Top 50 items" => "Top 50 osat",
"Top 100 items" => "Top 100 osat",
"Top 250 items" => "Top 250 osat",
"Voting system" => "Äänestys järjestelmä",
"Vote items" => "Äänestä osia",
"Rank 1..5" => "Arvo 1..5",
"Rank 1..10" => "Arvo 1..10",
"Ranking frequency" => "Arvostus väli",
"Realtime" => "Reaaliaika",
"Each 5 minutes" => "Joka 5 minuutti",
"Daily" => "Päivittäin",
"Weekly" => "Viikottain",
"Monthly" => "Kuukausittain",
"Show Average" => "Näytä Keskiarvo",
"Show Votes" => "Näytä Äänet",
"Use Cookies for unregistered users" => "Käytä keksejä rekisteröimättömille käyttäjille",
"Users can vote again after" => "Käyttäjä voi äänestää uudelleen kun",
"Anytime" => "Koskavain",
"5 minutes" => "5 minuutin kuluttua",
"1 day" => "1 päivän kuluttua",
"1 week" => "1 viikon kuluttua",
"1 month" => "1 kuukauden kuluttua",
"Items" => "Osat",
"Ranks" => "Arvostukset",
"No charts defined yet" => "Ei kaaviota määritelty vielä",
"Chat Administration" => "Juttelu Ylläpidolle",
"Chat Admin" => "Puhu Ylläpidolle",
"Chat Admin tpl" => "Puhu Ylläpidolle tpl",
"Create/edit channel" => "Luo/muokkaa kanavaa",
"Refresh rate" => "Päivitys väli",
"Half a second" => "Puoli sekuntia",
"second" => "sekunti",
"Chat channels" => "Juttu kanavat",
"active" => "aktiivinen",
"Admin templates" => "Ylläpidä malleja",
"admin content templates" => "ylläpidä sisältö malleja",
"admin content templates template" => "ylläpidä sisälltö mallin mallia",
"Edit this template:" => "Muuta tätä mallia:",
"Create new template" => "Luo uusi malli",
"use in cms" => "käytä cms:ssä",
"use in wiki" => "käytä wikissä",
"use in newsletters" => "käytä uutislehdessä",
"use in events" => "käytä tapahtumia",
"use in HTML pages" => "käytä HTML sivuilla",
"template" => "malli",
"Templates" => "Mallit",
"last modif" => "viimeki muokannut",
"sections" => "osastot",
"Admin cookies" => "Ylläpidä keksejä",
"admin FortuneCookie" => "ylläpidä OnnenKeksejä",
"admin FortuneCookie tpl" => "ylläpidä OnnenKeksi tpl",
"To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "Keksien käyttö tekstialueella kuten (sivulla, jne), <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduuli</a> tai malli, käytä {literal}{cookie}{/literal}.",
"Create/edit cookies" => "Luo/muuta keksejä",
"Cookie" => "Keksi",
"Upload Cookies from textfile" => "Lähetä Keksit tekstiedostosta",
"Upload from disk:" => "Lähetä kovalevyltä:",
"upload" => "lähetä",
"Remove all cookies" => "Poista kaikki keksit",
"cookie" => "keksi",
"Help on Drawings" => "Auta Piirroksissa",
"admin Drawings tpl" => "ylläpidä Piirros tpl",
"To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "Luodaksesi piirroksen sivulle, käytä {literal}{draw name=foo}{/literal}, missä foo piirroksen nimi. Tallennuksen jälkeen, paina piirroslinkkiä.",
"Available drawings" => "Saatavilla olevat piirrokset",
"Admin DSN" => "Ylläpidä DSN",
"Use Admin DSN to define the database to be used by the SQL plugin." => "Käytä Ylläpidä DSN määrittääksesi tietokannan jota SQL plugin käyttää.",
"Create/edit dsn" => "Luo/muokkaa dsn",
"Admin external wikis" => "Ylläpidä ulkoiset wikit",
"admin External Wikis" => "ylläpidä ulkoisia sivuja",
"tiki admin external wikis template" => "sivusto ylläpito ulkoisten sivujen malli",
"Create/Edit External Wiki" => "Luo/muuta Ulkoinen Wiki",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (käytä \$sivua korvaamaan sivun nimeltä URL esimerkki: http://www.example.com/tiki-index.php?page=\$page)",
"Admin Forums" => "Ylläpidä Foorumeja",
"admin forums template" => "ylläpidä foorumien malli",
"Create new forum" => "Luo uusi foorumi",
"Edit existing forums" => "Muokka olemassa olevia foorumeja",
"Edit this Forum:" => "Muokkaa tätä Foorumia:",
"Create New Forum" => "Luo Uusi Foorumi",
"There are individual permissions set for this forum" => "Tälle foorumille on erityisoikeudet",
"Show description" => "Näytä kuvaus",
"Prevent flooding" => "Estä vuoto",
"Minimum time between posts" => "Minimi aika lähetysten välillä",
"Topics per page" => "Aihetta per sivu",
"Section" => "Osasto",
"Create new" => "Luo uusi",
"Moderator user" => "Esimies käyttäjä",
"Moderator group" => "Esimies ryhmä",
"Password protected" => "Salasana suojattu",
"Topics only" => "Vain aiheet",
"All posts" => "Kaikki lähetykset",
"Forum password" => "Foorumin salasana",
"Default ordering for topics" => "Aiheiden oletus järjestys",
"Date (desc)" => "Päiväys (aleneva)",
"Date (asc)" => "Päiväys (nouseva)",
"Score (desc)" => "Tilanne (aleneva)",
"Replies (desc)" => "Vastaukset (aleneva)",
"Reads (desc)" => "Lukijaa (aleneva)",
"Title (desc)" => "Otsikko (aleneva)",
"Title (asc)" => "Otsikko (nouseva)",
"Default ordering for threads" => "Oletus järjestys ketjuille",
"Send this forums posts to this email" => "Lähetä tämän foorumin lähetykset tähän sähköpostiosoitteeseen",
"Prune unreplied messages after" => "Poista vastaamattomat viestit kun täyttyy",
"Prune old messages after" => "Poista vanhat viestit kun täyttyy",
"Topic list configuration" => "Aihe listan kokoonpano",
"Replies" => "Vastauksia",
"Posts can be rated" => "Lähetykset voi arvostella",
"Display last post titles" => "Näytä viimeiset otsikot",
"no display" => "ei näytettävää",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Lähetä tämän foorumin lähetykset tähän osoitteeseen, siinä muodossa, että vastauksen voi lähettää sähköpostilla foorumille",
"Send mails even when the post is generated by inbound mail" => "Lähetä viestit vaikka posti olisi luotu saapuneista",
"Append a reply link to outbound mails" => "Lisää vastaus linkki lähteviin posteihin",
"Originating e-mail address for mails from this forum" => "Alkuperäinen sähköpostiosoite lähetyksille tältä foorumilta",
"Add messages from this email to the forum" => "Liisää viestit tästä sähköpostiosoitteesta foorumille",
"POP3 server" => "POP3 palvelin",
"Use topic smileys" => "Käytä aihe hymiöitä",
"Show topic summary" => "Näytä aiheen yhteenveto",
"User information display" => "Käyttäjä tietojen näyttö",
"avatar" => "hahmo",
"flag" => "lippu",
"online" => "linjalla",
"Approval type" => "Hyväksyttävä tyyppi",
"All posted" => "Kaikki lähetetyt",
"Queue anonymous posts" => "Nimettömien postit jonoon",
"Queue all posts" => "Kaikki postit jonoon",
"Attachments" => "Liitteet",
"No attachments" => "Ei liitteitä",
"Everybody can attach" => "Kaikki voivat liittää",
"Only users with attach permission" => "Vain käyttäjät joilla on liite lupa",
"Moderators and admin can attach" => "Esimiehet ja ylläpito voivat liittää",
"Store attachments in:" => "Varastoi liitteet:",
"Database" => "Tietokanta",
"Max attachment size (bytes)" => "Liitteen suurin koko (bytes)",
"Edit Existing Forums" => "Muuta olemassa olevia foorumeja",
"topics" => "aiheet",
"coms" => "kom",
"age" => "ikä",
"last post" => "viimeinen lähetys",
"Assign Permissions (Active)" => "Anna Oikeudet (Aktivoi)",
"Assign Permissions" => "Anna Oikeudet",
"Click here to delete this forum" => "Paina tästä poistaaksesi tämän foorumin",
"Admin Hotwords" => "Ylläpidä Hotwords",
"admin hotwords" => "ylläpidä hotwords",
"admin hotwords template" => "ylläpidä kuumasanojen malli",
"Add Hotword" => "Lisää Hotword",
"Word" => "Sana",
"Add" => "Lisää",
"admin HTML page dynamic zones" => "ylläpidä HTML muuttuvia alueita",
"Admin HTML pages" => "Ylläpidä HTML sivuja",
"Edit this page" => ">Muokkaa tätä sivua",
"View page" => "Näytä sivu",
"Edit zone" => "Muokkaa aluetta",
"Zone" => "Alue",
"Dynamic zones" => "Muuttuvat alueet",
"zone" => "alue",
"content" => "sisältö",
"Mass update" => "Massa päivitys",
"admin Html Pages" => "ylläpidä Html Sivuja",
"admin Html Pages template" => "ylläpidä Html Sivujen malli",
"Create new HTML page" => "Luo uusi HTML sivu",
"Edit this HTML page:" => "Muokkaa tätä HTML sivua:",
"Page name" => "Sivun nimi",
"Dynamic" => "Muuttuva",
"Static" => "Muuttumaton",
"Refresh rate (if dynamic) [secs]" => "Päivitys väli (jos muuttuva) [sek]",
"Edit Repository:" => "Muokkaa Säilytyspaikkaa:",
"Create New Repository" => "Luo Uusi Säilytyspaikka",
"list repositories" => "lista säilytyspaikoista",
"new repository" => "uusi säilytyspaikka",
"view repository" => "näytä säilytyspaikka",
"Human readable repository name" => "Luettavissa oleva säilytyspaikan nimi",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Polku säilytyspaikkaan (paikallinen järjestelmä: suhteellinen/täydellinen web root, etäinen: alkuosa 'http://')",
"File name of start page" => "Aloitus sivun tiedosto nimi",
"Start page" => "Aloitus sivu",
"CSS file to load when browse this repository" => "CSS tiedosto joka ladataan kun selataan tätä säilytyspaikkaa",
"CSS file" => "CSS tiedosto",
"Is repository visible to users" => "Onko tämä säilytyspaikka kaikille näkyvä",
"Can files from repository be cached" => "Voiko säilytyspaikan tiedostoja puskuroida",
"Cacheable" => "Puskuroitavissa",
"Are files from repository can be cached" => "Onko säilytyspaikan tiedostot puskuroitavissa",
"Clear all cached pages of this repository" => "Tyhjennä sivu puskurit tästä tallennuspaikasta",
"Clear cache" => "Tyhjennä puskuri",
"Seconds count 'till cached page will be expired" => "Aika laskuri 'kunnes puskurointi päättyy",
"Cache expiration" => "Puskuroinnin päättyminen",
"Human readable text description of repository" => "Luettavissa oleva säilytyspaikan kuvaus",
"Available Repositories" => "Saatavilla olevat säilytyspaikat",
"Start" => "Aloitus",
"CSS File" => "CSS tiedosto",
"Edit rules" => "Muuta sääntöjä",
"Edit Rules for Repository:" => "Muuta Säilytyspaikan Sääntöjä:",
"configure repositories" => "säilytyspaikan kokoonpano",
"configure this repository" => "Muuta säilytyspaikan kokoonpanoa",
"view this repository" => "näytä tämä säilytyspaikka",
"Add new rule" => "Lisää uusi sääntö",
"new rule" => "uusi sääntö",
"view/hide copy rules dialog" => "näytä/piilota kopio sääntöjen vuoropuhelusta",
"copy rules" => "kopio säännöt",
"Source repository" => "Lähde säilytyspaikka",
"Copy" => "Kopio",
"According this order rules will be applied ('0' or empty = auto)" => "Tämän määräyksen mukaan sääntöjä käytetään ('0' tai tyhjä = auto)",
"Rule order" => "Sääntö järjestys",
"Text to search for" => "Teksti jota etsitään",
"Text to replace" => "Korvattava teksti",
"Replace" => "Korvaa",
"Is this regular expression or simple search/replacer" => "Onko tämä normaali ilmaisu vai yksinkertainen etsi ja korvaa",
"Is case sensitive (for simple replacer)" => "Erotetaanko isot ja pienet (yksinkertaiseen korvaamiseen)",
"Case sensitive" => "Erota isot ja pienet",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "osajoukko kirjaimia: imsxeADSXUu, jotka ovaat regex modifiers",
"Regex modifiers" => "Regex muokkaajat",
"Human readable text description of rule" => "Luettavissa oleva teksti kuvauksen sääntö",
"Check to enable this rule" => "Merkitse sääntö käyttöön",
"Enabled" => "Käynnistetty",
"Preview options" => "Näyttö asetukset",
"Apply all rules or just this to generate preview" => "Lisää kaikki säännöt tai vain tähän näytön muodostukseen",
"Apply all rules" => "Liitä kaikki säännöt",
"View source code after rules applied" => "Näytä koodi sääntöjen lisäämisen jälkeen",
"Code preview" => "Koodi näyttö",
"Generate HTML preview" => "Muodosta HTML näyttö",
"HTML preview" => "HTML näyttö",
"Test file from repository to generate preview for (empty = configured start page)" => "Testaa säilytyspaikan tiedosto muodostaaksesi näyttö (tyhjä = aloitus sivun asetukset)",
"Preview Results" => "Näytä Tulokset",
"Rules List" => "Sääntö luettelo",
"Case" => "Tapaus",
"Admin layout" => "Ylläpidä layout",
"layout options" => "layout asetukset",
"admin featured links" => "ylläpidä ominaisuus linkit",
"admin featured links template" => "ylläpidä ominaisuus linkkien malli",
"To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "Käyttääksesi näitä linkkejä, on ominaisuus linkki liitettävä modulina <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> moduuli</a>.",
"Generate positions by hits" => "Muodosta paikat osumien perusteella",
"List of featured links" => "Ominaisuuslinkkien lista",
"title" => "otsikko",
"position" => "paikka",
"Add Featured Link" => "Lisää Ominaisuus Linkki",
"Edit this Featured Link:" => "Muuta tätä Ominaisuus Linkkiä:",
"Create new Featured Link" => "Luo Uusi Ominaisuus Linkki",
"Position" => "Paikka",
"disables the link" => "poistaa linkin",
"Link type" => "Linkin tyyppi",
"replace current page" => "korvaa nykyisen sivun",
"framed" => "kehystetty",
"open new window" => "avaa uuden ikkunan",
"Mail-in accounts" => "Postit-sisään tilit",
"admin Webmail" => "ylläpidä Webmail",
"admin mailin template" => "ylläpidä postitsisään malli",
"Account" => "Tili",
"Add new Mail-in account" => "Lisää uusi postit-sisään tili",
"Edit Mail-in account" => "Muokkaa postit-sisään tiliä",
"Account name" => "Tilin nimi",
"POP server" => "POP palvelin",
"Port" => "Portti",
"SMTP server" => "SMTP palvelin",
"SMTP requires authentication" => "SMTP tarvitsee kirjautumisen",
"article-put" => "artikkeli-laita",
"wiki-get" => "w-get",
"wiki-put" => "w-put",
"wiki-append" => "w-append",
"Article Topic" => "Artikkelin Aihe",
"Article Type" => "Artikkelin Tyyppi",
"Allow anonymous acces" => "Salli nimetön pääsy",
"Allow attachments" => "Salli liitteet",
"Discard to the end from" => "Poista loppuosa tästä",
"Check Mail-in accounts" => "Tarkista postit-sisään tilit",
"Check automatically" => "Tarkista automaattisesti",
"Frequency" => "Yleisyys",
"List menus" => "Listaa valikot",
"Edit this menu" => "Muokkaa tätä valikkoa",
"Edit menu options" => "Muuta valikko asetuksia",
"Show Quick Urls" => "Näytä Pika Url:it",
"Hide Quick Urls" => "Piilota Pika Url:it",
"Some useful URLs" => "Käyttökelpoisia URL:ja",
"Permissions" => "Oikeudet",
"section" => "osasto",
"sorted section" => "lajiteltu osasto",
"option" => "valinnainen",
"separator" => "erotin",
"Choose" => "Valitse",
"Home Page" => "EtuSivu",
"Home Image Gal" => "Oma Kuva Gal",
"Home Image Gallery" => "Oma Kuva Galleria",
"Home File Gal" => "Oma Tiedosto Gal",
"Home File Gallery" => "Oma Tiedosto Galleria",
"User preferences" => "Käyttäjä kokoonpano",
"User prefs" => "Käyttäjä kokoonpano",
"List image galleries" => "Listaa kuva galleriat",
"Upload" => "Lähetä",
"Gallery Rankings" => "Galleria Arvostukset",
"Browse a gallery" => "Selaa galleriaa",
"All articles" => "Kaikki artikkelit",
"Submit" => "Lähetä",
"List Blogs" => "Listaa Blogit",
"Create blog" => "Luo blogi",
"File galleries" => "Tiedosto galleriat",
"View a forum" => "Näytä foorumi",
"View a thread" => "Näytä ketju",
"View a FAQ" => "Näytä UKK",
"Take a quiz" => "Ota visailu",
"Stats for a Quiz" => "Tilastot visailuun",
"Preview menu" => "Edellinen valikko",
"Menu options" => "Valikko valinnat",
"group" => "ryhmä",
"Admin Menus" => "Ylläpidä Valikoita",
"admin menu builder" => "ylläpidä valikon rakentajaa",
"admin menus template" => "ylläpidä valikko malli",
"This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "Tämä toimii hyvin (tai ei!) riippuen käyttämästäsi teemasta. Oppiaksesi lisää <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
"Edit this Menu:" => "Muuta tätä Valikkoa:",
"Create new Menu" => "Luo uusi Valikko",
"dynamic collapsed" => "muuttuva kokoon taittuva",
"dynamic extended" => "muuttuva laajentuva",
"fixed" => "vakio",
"options" => "vaihtoehdot",
"Admin Modules" => "Ylläpidä Moduuleja",
"admin modules" => "ylläpidä moduuleja",
"admin modules template" => "ylläpidä moduulien malli",
"assign module" => "liitä moduuli",
"left modules" => "moduulit vasemmalla",
"right modules" => "moduulit oikealla",
"edit/create" => "muokkaa/luo",
"clear cache" => "tyhjennä puskuri",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Huomaa 1</b>: jos annat käyttäjien muokata moduuleja silloin liitetyt\nmoduulit eivät reagoi muutoksiin ennen kuin muutat niitä vastaavasti\nOmaSivu->moduulit.<br />\n<b>Huomaa 2</b>: Jos liität moduuleja ryhmille pidä huoli että\nnäytä kaikki 'moduulit kaikille ryhmille aina on päällä'\nYlläpidä->Yleiset\n",
"User Modules" => "Käyttäjä Moduulit",
"assign" => "liitä",
"Assign new module" => "Liitä uusi moduuli",
"Edit this assigned module:" => "Muokkaa tätä liitettyä moduulia:",
"Module Name" => "Moduulin Nimi",
"left" => "vasen",
"right" => "oikea",
"Order" => "Järjestys",
"Cache Time" => "Puskurointi Aika",
"Rows" => "Rivejä",
"Parameters" => "Kokoonpanot",
"Visibility" => "Näkyvyys",
"Displayed for the eligible users with no personal assigned modules" => "Näytetään halutuille käyttäjille joilla ei ole omia moduuleja",
"Displayed now for all eligible users even with personal assigned modules" => "Näytetään halutuille käyttäjille vaikka heillä on omia moduuleja",
"Displayed now, can't be unassigned" => "Näytetään nyt, ei voi poistaa liitosta",
"Not displayed until a user chooses it" => "Ei näytetä ellei käyttäjä valitse sitä",
"Assigned Modules" => "Liitetyt Moduulit",
"Left Modules" => "Moduulit Vasemmalla",
"order" => "järjestys",
"rows" => "rivit",
"parameters" => "parametrit",
"Right Modules" => "Moduulit Oikealla",
"Create new user module" => "Luo uusi käyttäjä moduuli",
"Edit this user module:" => "Muokkaa tätä käyttäjä moduulia:",
"Use wysiwyg editor" => "Käytä wysiwyg muokkainta",
"Use normal editor" => "Käytä tavallista muokkainta",
"Must be wiki parsed" => "Oltava wiki jäsennetty",
"create/edit" => "luo/muokkaa",
"Objects that can be included" => "Kohteet jotka voidaan lisätä",
"Available polls" => "Saatavilla olevat äänestykset",
"Random active poll" => "Satunnaisaktiivinen äänestys",
"Random current poll" => "Satunnasinykyinen äänestys",
"use poll" => "käytä äänestystä",
"Random image from" => "Satunnais kuva",
"use gallery" => "käytä galleriaa",
"Dynamic content blocks" => "Muuttuva sisältöiset palat ",
"use dynamic  content" => "käytä muuttuvaa sisältöä",
"use rss module" => "käytä rss moduulia",
"use menu" => "käyttäjä valikko",
"phpLayersMenus" => "phpLayersValikko",
"use phplayermenu" => "käytä phplayervalikkoa",
"Banner zones" => "Banneri alueet",
"use banner zone" => "käytä banneri aluetta",
"structure" => "rakenne",
"Admin newsletter subscriptions" => "Ylläpidä uutislehden tilauksia",
"list newsletters" => "listaa uutislehdet",
"admin newsletters" => "ylläpidä uutislehtiä",
"send newsletters" => "lähetä uutislehdet",
"Add a subscription newsletters" => "Lisää tilaus uutislehtiin",
"Add email:" => "Lisää sähköposti:",
"Add user:" => "Lisää käyttäjä:",
"Group users" => "Ryhmitä käyttäjät",
"Group subscription also subscribes included groups" => "Ryhmä tilaus sisältää myös sisältävät ryhmät",
"Don't send confirmation mail" => "Älä lähetä varmistus postia",
"The user email will be refreshed at each newsletter sending" => "Käyttäjän sähköposti varmistetaan jokaisen uutiskirjeen yhteydessä",
"Subscribe group" => "Tilaa ryhmälle",
"Included group, group users and emails will be refreshed at each newsletter sending" => "Sisällytetyt ryhmät, ryhmän jäsenet ja sähköpostit varmistetaan jokaisen uutiskirjeen yhteydessä",
"Subscriptions" => "Tilaukset",
"subscribed" => "tilattu",
"admin newsletters template" => "ylläpidä uutiskirjeen malli",
"Create/edit newsletters" => "<Luo/muokkaa uutislehteä",
"There are individual permissions set for this newsletter" => "Tälle uutislehdelle on asetettu erityioikeudet",
"Users can subscribe/unsubscribe to this list" => "Käyttäjät voivat tilata/peruuttaa tämän listan",
"Users can subscribe any email address" => "Käyttäjä voi tilata millä tahansa sähköpostiosoitteella",
"Add unsubscribe instructions to each newsletter" => "Lisää peruutus ohjeet jokaiseen uutislehteen",
"Validate email addresses" => "Varmista sähköpostiosoitteet",
"editions" => "laitokset",
"last sent" => "viimeksi lähetetty",
"subscriptions" => "tilaus",
"send newsletter" => "lähetä uutiskirje",
"archives" => "arkistot",
"EMail notifications" => "Sähköposti ilmoitus",
"admin Email Notifications" => "ylläpidon sähköposti ilmoitus",
"admin notifications template" => "ylläpidon huomautus malli",
"Add notification" => "Lisää ilmoitus",
"Event" => "Tapahtuma",
"A user registers" => "Käyttäjän rekisteröinti",
"A user submits an article" => "Käyttäjä ehdottaa artikkelia",
"Any wiki page is changed" => "Mikä tahansa sivu muuttuu",
"Any wiki page is changed, even minor changes" => "Mikä tahansa sivu muuttuu, jopa pienet muutokset",
"PHP error" => "PHP virhe",
"use admin email" => "käytä ylläpidon sähköpostia",
"event" => "tapahtuma",
"object" => "kohde",
"No records found." => "Ei löydy tallennetta.",
"Admin Polls" => "Ylläpidä Äänestyksiä",
"List polls" => "Listaa äänestykset",
"Edit this poll" => "Muokkaa tätä äänestystä",
"Preview poll" => "Näytä äänestystä",
"Edit or add poll options" => "Muuta tai lisää äänestys vaihtoehtoja",
"Option" => "Vaihtoehto",
"Poll options" => "Äänestys vaihtoehdot",
"votes" => "ääniä",
"admin polls" => "ylläpidä äänestyksiä",
"admin polls template" => "ylläpidä äänestys malli",
"configure polls" => "muokkaa äänestyksiä",
"Set last poll as current" => "Aseta viimeisin äänestys nykyiseksi",
"Close all polls but last" => "Sulje kaikki äänestykset paitsi viimeinen",
"Activate all polls" => "Käynnistä kaikki äänestykset",
"Create/edit Polls" => "Luo/muuta Äänestyksiä",
"PublishDate" => "JulkaisuPäivä",
"Admin Quicktags" => "Ylläpidä Pikalisiä",
"admin QuickTags" => "ylläpidä PikaLisiä",
"tiki admin quicktags template" => "sivusto ylläpito pikatagien malli",
"Create/Edit QuickTags" => "Luo/muokkaa PikaLisiä",
"label" => "etiketti",
"Insert (use 'text' for figuring the selection)" => "Lisää (käytä 'teksti' kuvaamaan valintaa)",
"Category" => "Luokka",
"Path to the tag icon" => "Polku lisän kuvakkeeseen",
"Insert" => "Lisäys",
"Icon" => "Kuvake",
"Admin RSS modules" => "Ylläpidä RSS moduuleja",
"admin RSS modules" => "ylläpidä RSS moduuleje",
"admin RSSmodules template" => "ylläpidä RSSmoduulien malli",
"This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "Tämä sivu on kokoonpano muutoksiin RSS syötteissä lue/tuo sivustosta. Luodaksesi/viedäksesi RSS syöte, katso \"RSS syötteet\" ylläpito paneelista, tai",
"To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "Käyttääksesi RSS syötettä teksti alueella (Sivu, jne), <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduuli</a> tai malli, käytä {literal}{rss id=x}{/literal}, missä x on RSS syötteen ID.",
"Content for the feed" => "Syötteen sisältö",
"Edit this RSS module:" => "Muokkaa tätä RSS moduulia:",
"Create new RSS module" => "Luo uusi RSS moduuli",
"show feed title" => "näytä syötteen otsikko",
"show publish date" => "näytä julkaisu päivä",
"Rss channels" => "Rss kanavat",
"Last update" => "Viimeisin päivitys",
"show pubdate" => "näytä julkaisupäivä",
"Score System" => "Piste Järjestelmä",
"security admin" => "turvallisuus ylläpito",
"security admin tpl" => "turvallisuus ylläpito tpl",
"edit tpl" => "muuta tpl",
"To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "<a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">ilmoita turvallisuus aiheista</a>.",
"PHP settings" => "PHP asetukset",
"PHP variable" => "PHP muuttujat",
"Setting" => "Asetus",
"Risk Factor" => "Riski Kerroin",
"Explanation" => "Selvitys",
"Tikiwiki settings" => "Sivusto asetukset",
"Tiki variable" => "Sivusto muuttuja",
"Check all tiki files" => "Tarkista kaikki sivuston tiedostot",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Huomaa, tämä voi viedä kauan aikaa. Sinun on tarkistettava max_execution_time asetus php.ini:ssä.",
"Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Huomaa: Sinun on annettava turvallisuus tiedot asennuksen yhteydessä (<a href=\"tiki-install.php\">tiki-install.php</a>). Tuo *secdb* päivittää tiedostot tietokantaan.",
"File checks" => "Tiedosto tarkistukset",
"Filename" => "Tiedostonimi",
"State" => "Tila",
"Admin Shoutbox Words" => "Ylläpidä Pikaviestin Sanoja",
"admin shoutbox words" => "ylläpidä pikaviestin sanoja",
"admin shoutbox words template" => "ylläpidä pikaviesti sanojen malli",
"Add Banned Word" => "Lisää Poisto Sana",
"Are you sure you want to delete this word?" => "Oletko varma, että haluat poistaa tämän sanan?",
"admin structures template" => "ylläpidä rakenne malli",
"Structure ID" => "Rakenne ID",
"export pages" => "tulosta sivut",
"dump tree" => "dumppi puu",
"create webhelp" => "luo webapu",
"view webhelp" => "näytä webapu",
"Destroy the structure leaving the wiki pages" => "Poista rakenne poistuessa sivuilta",
"Destroy the structure and remove the pages" => "Poista rakenne ja poista sivut poistuessa",
"Create new structure" => "Luo uusi rakenne",
"Use single spaces to indent structure levels" => "Käytä sanaväliä sisennykseen osoittamaan rakenne tasoja",
"tree" => "puu",
"create new structure" => "luo uusi rakenne",
"Edit survey questions" => "Muuta tutkimuksen kysymyksiä",
"survey stats" => "tutkimus tilastot",
"this survey stats" => "tämän tutkimuksen tilastot",
"edit this survey" => "muuta tätä tutkimusta",
"admin surveys" => "ylläpidä tutkimuksia",
"Create/edit questions for survey" => "Luo/muuta tutkimuksen kysymyksiä",
"Question" => "Kysymys",
"One choice" => "Yksi valinta",
"Multiple choices" => "Moni valinta",
"Short text" => "Lyhyt teksti",
"Rate (1..5)" => "Luokittele (1..5)",
"Rate (1..10)" => "Luokittele (1..10)",
"Options (if apply)" => "Vaihtoehdot (jos lisätty)",
"Questions" => "Kysymykset",
"question" => "kysymys",
"administer surveys template" => "ylläpidä tutkimuksen malli",
"list surveys" => "listaa tutkimukset",
"Edit this Survey:" => "Muokkaa tätä tutkimusta:",
"Create New Survey" => "Luo Uusi Tutkimus",
"There are individual permissions set for this survey" => "Tälle tutkimukselle on erityisoikeudet",
"status" => "tila",
"questions" => "kysymykset",
"active perms" => "aktiiviset oikeudet",
"system admin" => "järjestelmän ylläpito",
"system admin tpl" => "järjestelmän ylläpito tpl",
"If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)." => "Jos sivustosi käyttäytyy oudosti, kokeile ensimmäiseksi tyhjentää puskuri alhaalta. Tärkeää on myös päivityksen jälkeinen puskurin tyhjennys (FTP/SSH tarvittaessa).",
"Empty" => "Tyhjennä",
"files" => "tiedostot",
"Templates compiler" => "Mallien muodostaja",
"Compile" => "Muodosta",
"Fix UTF-8 Errors in Tables" => "Korjaa UTF-8 Virheet taulukoihin",
"Warning: Make a backup of your Database before using this function!" => "Waroitus: Tee varmuuskopio tietokannastasi ennen kuin käytät tätä!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Waroitus: Jos yrität muuntaa suuria taulukoita, nosta scriptin maximi ajoaikaa php.ini:ssä!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "Tämä muuntaa ISO-8859-1 merkkijonot tietokannassa UTF-8 muotoon",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "Tämä voi olla välttämätöntä jos olet käyttänyt aiemmin &lt; 1.8.4 ja Oletus kirjaimisto oli ISO-8859-1",
"UTF-8 Errors fixed" => "UTF-8 Virheet korjattu",
"Table" => "Taulukko",
"Field" => "Kenttä",
"Investigate" => "Tutki",
"Fix it" => "Korjaa se",
"Admin Topics" => "Ylläpidä Aiheita",
"admin topics template" => "ylläpidä aiheiden malli",
"Create a new topic" => "Luo uusi aihe",
"Topic Name" => "Aiheen Nimi",
"Upload Image" => "Lähetä Kuva",
"List of topics" => "Listaa aiheet",
"Active?" => "Aktiivinen?",
"Articles (subs)" => "Artikkelit (subs)",
"topic image" => "aihe kuva",
"Remove with articles" => "Poista artikkelin mukana",
"Activate" => "Aktivoi",
"Deactivate" => "PuraAktivointi",
"Admin tracker" => "Ylläpidä kortistoa",
"Edit this tracker" => "Muokkaa tätä kortistoa",
"View this tracker items" => "Näytä tämän kortiston osat",
"Edit tracker fields" => "Muokkaa kortiston kenttiä",
"Is column visible when listing tracker items?" => "Onko palsta näkyvä kun listataan kortiston osia?",
"Column links to edit/view item?" => "Palstan linkit muuta/näytä osa?",
"Column is searchable?" => "Palsta on etsittävissä?",
"Field is public? (for use thru trackerlist plugin)" => "Kenttä on julkinen? (käytetään trackerlist plugin kautta)",
"Field is mandatory?" => "Kenttä on pakollinen?",
"Tracker fields" => "Kortiston kentät",
"isMain" => "onPää",
"Searchable" => "Etsittävissä",
"Public" => "Julkinen",
"Hidden" => "Piilotettu",
"Mandatory" => "Pakollinen",
"Import/export trackers fields" => "Tuonti/vienti kortiston kentistä",
"Import" => "Tuo",
"admin Trackers tpl" => "ylläpidä Kortistojen tpl",
"Edit fields for tracker" => "Muuta kortiston kenttiä",
"Edit tracker" => "Muuta kortisto",
"Create trackers" => "Luo kortistoja",
"Import/export" => "Tuonti/vienti",
"created" => "luotu",
"items" => "osat",
"active permissions" => "aktiiviset oikeudet",
"fields" => "kentät",
"Create/edit trackers" => "Luo/muokkaa kortistoja",
"There are individual permissions set for this tracker" => "Tälle kortistolle on erityisoikeudet",
"Use \"explicit\" names in the mirror table" => "Käytä \"avoimia\" nimiä peili taulukolle",
"tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "kortiston nimen on oltava yksilöllinen, kenttien nimien tulee olla yksilöllisiä \nkortistossa ja niiden käytävä SQL kyselyyn",
"Show status" => "Näytä tila",
"Default status displayed in list mode" => "Oletus tila näytetään listauksen yhteydessä",
"Show status to tracker admin only" => "Näytä kortiston tila vain ylläpitäjälle",
"Send copies of all activity in this tracker to this e-mail address" => "Lähetä kopio kaikesta toiminnosta tässä kortistossa tähän sähköpostiosoitteeseen",
"Use simplified e-mail format" => "Käytä yksinkertaista sähköposti muotoa",
"The tracker needs a text field named Subject" => "Kortisto tarvitsee kentän nimeltä Otsikko",
"New items are created with status" => "Uudet osat luodaa tilan kanssa",
"Authoritative status for modified items" => "Arvovaltainen tila muokatuille osille",
"No change" => "Ei muutosta",
"Item creator can modify his items?" => "Voiko osan luoja muokata osaansa?",
"The tracker needs a user field with the option 1" => "Kortisto tarvitsee käyttäjä kentän jolla on vaihtoehto 1",
"Member of the default group of creator can modify items?" => "Oletus ryhmän jäsen luojana voi muokata osaa?",
"The tracker needs a group field with the option 1" => "Kortisto tarvitsee ryhmä kentän jolla on vaihtoehto 1",
"Show creation date when listing tracker items?" => "Näytä luonti päivä kun listataan kortiston osia?",
"Show lastModif date when listing tracker items?" => "Näytä viimeksi muokkauspäivä kun listataan kortiston osia?",
"What field is used for default sort?" => "Mitä kenttää käytetään oletus lajittelussa?",
"What is default sort order in list?" => "Mikä on oletus järjestys listauksessa?",
"ascending" => "nouseva",
"descending" => "laskeva",
"Tracker items allow ratings?" => "Kortisto osat sallii luokitukset?",
"with values" => "arvoilla",
"and display rating results in listing?" => "ja näyttää luokitus tulokset listalla?",
"Tracker items allow comments?" => "Sallitaanko kortiston osien kommentointi?",
"and display comments in listing?" => "ja näyttää kommentit listauksessa?",
"Tracker items allow attachments?" => "Sallitaanko kortiston osien liitteet?",
"and display attachments in listing?" => "ja näyttää liitteet listauksessa?",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Liitteiden näyttö vaihtoehdot (Käytä numeroita osien järjestämiseen, 0 ei näytetä, ja negatiivinen näytetään popupeissa)",
"filename" => "tiedostonimi",
"downloads" => "imuroinnit",
"filesize" => "tiedostokoko",
"version" => "versio",
"filetype" => "tiedostoyyppi",
"longdesc" => "pitkäkuvaus",
"Import/export trackers" => "Tuo/vie kortistoja",
"admin groups" => "ylläpidä ryhmiä",
"admin groups template" => "ylläpidä ryhmä malli",
"Add new group" => "Lisää uusi ryhmä",
"List" => "Lista",
"Edit group" => "Muokkaa ryhmää",
"Members" => "Jäsenet",
"Add a new group" => "Lisää uusi ryhmä",
"List of existing groups" => "Lista olemassa olevista ryhmistä",
"Number of displayed rows" => "Näytettävien rivien määrä",
"Includes" => "Sisältää",
"assign permissions" => "anna oikeudet",
"Include" => "Sisällytä",
"Group Homepage" => "Ryhmä Etusivu",
"Use wiki page name or full URL" => "Käytä sivunnimeä tai koko URL polkua",
"Group Information Tracker" => "Ryhmä Tietojen Kortisto",
"choose a group tracker ..." => "valitse ryhmä kortisto ...",
"choose a field ..." => "valitse kenttä ...",
"admin" => "ylläpitäjä",
"Users Information Tracker" => "Käyttäjän Tietojen Kortisto",
"choose a users tracker ..." => "valitse käyttäjien kortisto ...",
"Group tracker item : {\$groupitemid}" => "Ryhmitä kortisto osa : {\$groupitemid}",
"Edit item" => "Muuta osaa",
"Group tracker item not found" => "Ryhmä kortiston osaa ei löydy",
"Create item" => "Luo osa",
"Members List" => "Jäsen luettelo",
"remove from group" => "poista ryhmäsät",
"users in group" => "käyttäjät ryhmässä",
"List all members" => "Listaa kaikki jäsenet",
"admin users" => "ylläpidä käyttäjiä",
"admin users template" => "ylläpidä käyttäjien malli",
"Add a new user" => "Lisää uusi käyttäjä",
"Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Waroitus: koska tämä sivusto on orja muodossa, kaikki käsin lisätyt käyttäjätiedot ylikirjoitetaan isäntä sivuston tiedoilla, mukaan lukien käyttäjä oikeudet",
"Batch Upload Results" => "Joukko Lähetyksen Tulokset",
"Added users" => "Lisätyt käyttäjät",
"Rejected users" => "Poistetut käyttäjät",
"Reason" => "Syy",
"Edit user" => "Muokkaa käyttäjää",
"Change user preferences" => "Muuta käyttäjän asetuksia",
"edit account settings" => "muokkaa tili asetuksia",
"Never" => "EiKoskaan",
"Assign Group" => "Liitä Ryhmä",
"edit included group" => "muokkaa sisällytettyä ryhmää",
"select all" => "valitse kaikki",
"Perform action with checked:" => "Suorita toiminnot valituilla:",
"manage group assignments" => "hallitse ryhmä liitoksia",
"set default groups" => "aseta oletus ryhmät",
"Assign selected to" => "Liitä valitut",
"Remove selected from" => "Poista valitut",
"the following groups:" => "seuraaviin ryhmistä:",
"Tip: hold down CTRL to select multiple" => "Vihje: paina CTRL alas valitaksesi useampia",
"Set the default group of the selected users to" => "Aseta valittujen käyttäjien oletusryhmä->",
"assign to groups" => "liitä ryhmiä",
"Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Waroitus: nimen muutokseen tarvitaan käyttäjä vaihtamaan salasana ja sekoittaa orja intertiki sivuston joka käyttää tätä isäntänä",
"Warning: changing the username will require the user to change his password" => "Waroitus: jos muutat käyttäjänimen tarvitaan käyttäjä muuttamaan salasana",
"Pass" => "Salasana",
"Again" => "Uudelleen",
"Registration" => "Rekisteröinti",
"Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Ryhmä lähetys (CSV tiedosto<a {popup text='kirjaus,salasana,sähköposti,ryhmät<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
"Overwrite" => "Päällekirjoita",
"User tracker item : {\$usersitemid}" => "Käyttäjän kortiston osa : {\$usersitemid}",
"Admin Article Types" => "Ylläpidä Artikkeli Tyyppejä",
"Article Types tpl" => "Artikkeli Tyyppien tpl",
"Shows up in the drop down list of article types" => "Tulee näkyviin artikkeli tyyppien alasveto valikossa",
"Rate" => "Kerroin",
"Allow ratings by the author" => "Sallii arvostelun kirjoittajalta",
"Show before publish date" => "Näytä ennen julkaisu päivää",
"non-admins can view before the publish date" => "muut kuin ylläpito voivat nähdä ennen julkaisupäivää",
"Show after expire date" => "Näytä poistumis päivän jälkeen",
"non-admins can view after the expire date" => "muut kuin ylläpito voivat nähdä päättymispäivän jälkeen",
"Heading only" => "Vain pääosat",
"No article body, heading only" => "Ei artikkelirunkoa, vain pääosa",
"Allow comments for this type" => "Salli kommentit tälle tyypille",
"Comment Can Rate Article" => "Kommentti voi vauhdittaa Artikkelia",
"Allow comments to include a rating value" => "Salli kommentin sisältävän arvostus arvon",
"Show image" => "Näytä kuva",
"Show topic or own image" => "Näytä aihe tai kuva",
"Show avatar" => "Näytä hahmo",
"Show author's avatar" => "Näytä kirjoittajan hahmo",
"Show author" => "Näytä kirjoittaja",
"Show author name" => "Näytä kirjoittajan nimi",
"Show publish date" => "Näytä julkaisu päivä",
"Show expire date" => "Näytä poistumis päivä",
"Show reads" => "Lukijoita",
"Show the number of times the article was read" => "Näytä montako kertaa artikkeli on luettu",
"Show size" => "Näytä koko",
"Show the size of the article" => "Näytä artikkelin koko",
"Show topline" => "Näytä ylärivi",
"Show a small title over the title" => "Näytä pieni aihe varsinaisen aiheen yläpuolella",
"Show subtitle" => "Näytä alaotsikko",
"Show the subtitle" => "Näytä Alaotsikko",
"Show source" => "Näytä lähde",
"Show link to source after article body" => "Näytä lähteen linkki artikkelin lopussa",
"Show Image Caption" => "Näytä KuvaTeksti",
"Show a legend under the image" => "Näytä seloste kuvan alla",
"Show Language" => "Näytä Kieli",
"Show the language" => "Näytä kieli",
"Creator can edit" => "Luoja voi muokata",
"The person who submits an article of this type can edit it" => "Henkilö, joka lähettää tämän tyypin artikkelin voi myös muokata sitä",
"Delete" => "Poista",
"Delete this type" => "Poista tämä tyyppi",
"List of types" => "Listaa tyypit",
"Show lang" => "Näytä kieli",
"Review" => "EsiKatselu",
"Classified" => "Luokiteltu",
"Create a new type" => "Luo uusi tyyppi",
"Assign permissions to group" => "Liitä oikeudet ryhmälle",
"Edit Article" => "Muokkaa Artikkelia",
"edit article tpl" => "muokkaa artikkeli tpl",
"Back to groups" => "Takaisin ryhmiin",
"Group Information" => "Ryhmän Tiedot",
"Desc" => "Aleneva",
"advanced feature" => "kehittyneempi ominaisuus",
"level configuration" => "taso kokoonpano",
"Create level" => "Luo taso",
"all permissions in level" => "kaikki oikeudet tasolla",
"all" => "kaikki",
"level" => "taso",
"Assign user" => "Liitä käyttäjä",
"to groups" => "ryhmiin",
"User Information" => "Käyttäjä Tiedot",
"Default Group" => "Oletus Ryhmä",
"Available groups" => "Saatavilla olevat ryhmät",
"assign perms to this group" => "anna oikeudet tälle ryhmälle",
"to" => " ",
"backlinks to" => "paluulinkit",
"No backlinks to this page" => "Ei paluulinkkejä tälle sivulle",
"admin backups" => "ylläpidon varmuuskopio",
"admin admin tpl" => "ylläpidä ylläpitäjän tpl",
"Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead." => "Tämän ominaisuuden käyttöä EI suositella. Käytä ohjelmaa phpMyAdmin tai mysqldump tämän sijasta.",
"List of available backups" => "Listaa saatavilla olevat varmuuskopiot",
"Restoring a backup" => "Palautetaan varmuuskopio",
"Warning!" => "Varoitus!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Tietojen palautus varmuuskopiosta tuhoaa kaiken uudemman tiedon. Kaikki tiedot korvataan varmuuskopion teko hetken aikaisilla tiedoilla.",
"Click here to confirm restoring" => "Paina tästä aloittaaksesi palautus",
"Create new backup" => "Luo uusi varmuuskopio",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Varmuuskopion luominen kestää kauan. Jos kopiointi ei mene loppuun asti näet tyhjän ruudun. Sinun on lisättävä scriptin maksimi ajo aikaa php.ini tiedostossa",
"Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "Sinun kuvagalleriasi levytila on \"{\$gal_use_dir}\", tee varmuuskopio käyttäen FTP:tä tai SCP:tä.",
"Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "Sinun tiedostogalleriasi levytila on \"{\$fgal_use_dir}\", tee varmuuskopio käyttäen FTP:tä tai SCP:tä.",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "Jos foorumiesi liitetiedostot on tallennettu hakemistoon tee varmuuskopio käyttäen FTP:tä tai SCP:tä.",
"Upload a backup" => "Lähetä varmuuskopio",
"Upload backup" => "Lähetä varmuuskopio",
"Directory batch upload" => "Hakemisto ryhmä lataus",
"Browse gallery" => "Selaa galleriaa",
"Upload from disk" => "Lähetä kovalevyltä",
"available images" => "saatavilla olevat kuvat",
"width" => "leveys",
"height" => "korkeus",
"remove file extension from image name" => "poista tiedostopääte kuvan nimestä",
"eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "esim. \"digicam0001.jpg\" joten nimeä digicam0001 käytetään nimikentässä",
"convert sub directories to sub galleries" => "muuntaa alihakemistot aligallerioiksi",
"eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "esim. \"misc/screenshots/digicam0001.jpg\" ja galleria nimeltä screenshots luodaan",
"use sub directory names as description" => "käyttää alihakemiston nimiä kuvauksena",
"eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "esim. \"misc/screenshots/digicam0001.jpg\" ja luodaan kuvaus misc/screenshots ",
"Select a Gallery" => "Valitse Galleria",
"Process" => "Prosessi",
"Edit Post" => "Muokkaa lähetystä",
"view blog" => "näytä blogi",
"list blogs" => "listaa blogit",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "Huomio: jos haluat käyttää kuvia tallenna lähetys ensin ja sinä\nvoit muokata/lähettää kuvia. Käytä &lt;img&gt; palaa lisätäksesi lähettämäsi kuvat editorin tekstialueelle\ntai voit käyttää URL lisätäksesi kuvat WYSIWYG editoriin. ",
"Use ...page... to separate pages in a multi-page post" => "Käytä ...sivu... erotellaksesi sivut monisivuisessa lähetyksessä",
"Upload image for this post" => "Lähetä kuva tähän lähetykseen",
"Trash" => "Roskis",
"Mark entry as private:" => "Merkitse sisäänpääsy yksityiseksi:",
"Send trackback pings to:" => "Lähetä viittaustoiminnon pingit:",
"(comma separated list of URIs)" => "(pilkku erottelee listan URI:ja)",
"save and exit" => "tallenna ja poistu",
"admin the category system" => "ylläpidä luokka järjestelmää",
"admin category" => "ylläpidä luokittelua",
"Browse in" => "Selaa",
"Wiki pages" => "Sivuja",
"Image galleries" => "Kuva galleriat",
"Trackers Items" => "Kortiston Osia",
"Sheets" => "Arkit",
"search category" => "etsi luokka",
"deep" => "syvä",
"Hide subcategories objects" => "Piilota aliluokkien kohteet",
"Show subcategories objects" => "Näytä aliluokkien kohteet",
"Upper level" => "Ylempi taso",
"Objects" => "Kohteet",
"Browsing Gallery" => "Gallerian Selaus",
"list galleries" => "listaa galleriat",
"edit gallery" => "muokkaa galleriaa",
"rebuild thumbnails" => "rakenna minikuvat",
"upload image" => "lähetä kuva",
"Directory batch" => "Hakemisto erä",
"list gallery" => "listaa galleria",
"Sort Images by" => "Lajittele Kuvat",
"subgallery" => "aligalleria",
"Subgallery" => "Aligalleria",
"hit" => "osuma",
"original size" => "alkuperäinen kuva",
"rotate right" => "pyöritä oikealle",
"rotate" => "pyöritä",
"Browsing Image" => "Kuvan Selaus",
"return to gallery" => "palaa galleriaan",
"edit image" => "muokkaa kuvaa",
"first image" => "ensimmäinen kuva",
"smaller" => "pienempi",
"bigger" => "suurempi",
"prev image" => "edellinen kuva",
"Popup window" => "Popup ikkuna",
"popup window" => "popup ikkuna",
"next image" => "seuraava kuva",
"slideshow forward" => "kuvaesitys eteenpäin",
"last image" => "viimeisin kuva",
"stop" => "seis",
"Direction" => "Suunta",
"Click to zoom" => "Paina, zoom",
"Image Name" => "Kuvan Nimi",
"Image size" => "Kuvan koko",
"imagescale" => "kuvamuunnos",
"Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/desimaali astetta)",
"Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/desimaali astetta)",
"Move image" => "Siirrä kuva",
"You can view this image in your browser using" => "Voit katsoa kuvaa selaimessasi käyttäen",
"You can include the image in an HTML page using one of these lines" => "Voit käyttää kuvaa HTML sivulla, käyttämällä yhtä näistä riveistä",
"You can include the image in a tiki page using one of these lines" => "Voit käyttää kuvaa normaali sivulla käyttäen yhtä näistä riveistä",
"add item" => "lisää osa",
"Edit/Create" => "Muokkaa/Luo",
"Date Selector" => "Päivä Valitsin",
"click to navigate" => "paina siirtyäksesi",
"Focus:" => "Keskitys:",
"change focus" => "muuta keskitystä",
"quarter" => "neljännes",
"semester" => "puolivuotis",
"calendar view" => "kalenteri näyttö",
"list view" => "listaus näyttö",
"End" => "Loppu",
"details" => "yksityiskohdat",
"Hours" => "Tuntia",
"Group Calendars" => "Ryhmä Kalenterit",
"Tools Calendars" => "Työkalu Kalenterit",
"Duration" => "Kesto",
"Location" => "Sijainti",
"Organized by" => "Järjestänyt",
"Participants" => "Osalliset",
"Tentative" => "Alustava",
"Confirmed" => "Hyväksytty",
"Cancelled" => "Peruttu",
"Subscription List" => "Tilaaja Lista",
"Edit Calendar Item" => "Muokkaa Kalenterin Osaa",
"New Calendar Item" => "Uusi Kalenterin Osa",
"or create a new category" => "tai luo uusi luokka",
"or create a new location" => "tai luo uusi sijainti",
"comma separated usernames" => "pilkku erottaa käyttäjänimet",
"comma separated username:role" => "pilkku erottaa käyttäjänimen:tehtävän",
"with roles" => "ja tehtävät",
"Chair" => "Istuin",
"Optional" => "Vaihtoehtoinen",
"Syntax error" => "Syntaxi virhe",
"Format: mm/dd/yyyy hh:mm<br />..." => "Muoto: kk/pp/vvvv tt:mm<br />...",
"See strtotime php function" => "Katso strtotime php toiminto",
"Format: mm/dd/yyy hh:mm<br />..." => "Muoto: kk/pp/vvv tt:mm<br />...",
"duplicate" => "kaksoiskappale",
"save_to" => "tallenna",
"close" => "sulje",
"click to view" => "paina katsoaksesi",
"Calendar import" => "Tuo kalenteri",
"Calendar has been updated" => "Kalenteri on päivitetty",
"CSV File" => "CSV Tiedosto",
"import" => "tuo",
"Assign permissions to category" => "Anna oikeudet luokalle",
"Current permissions for this category" => "Luokan nykyiset oikeudet",
"permission" => "oikeudet",
"remove from this category &amp; all its children" => "poista tästä luokasta &amp; ja kaikki alaluokat",
"remove from this category only" => "poista vain tästä luokasta",
"No individual permissions global permissions apply" => "Ei erityisoikeuksia yleiset oikeudet liitetään",
"Assign permissions" => "Liitä oikeudet",
"to group" => "ryhmälle",
"this category &amp; all its children" => "tämä luokka &amp; ja kaikki alaluokat",
"this category only" => "vain tämä luokka",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "Anna oikeudet <b>kaikille alaluokille</b> paras tehokkuus.",
"Change password enforced" => "Vaihda salasana pakottamatta",
"Old password" => "Vanha salasana",
"Again please" => "Uudelleen, kiitos",
"Welcome to the Tiki Chat Rooms" => "Tervetuloa Sivuston JuttuHuoneisiin",
"Please select a chat channel" => "Valitse juttu kanava",
"Nickname" => "Lempinimi",
"enter chat room" => "mene juttu huoneeseen",
"There are no channels setup, please contact a site admin" => "Ei ole kanava asetusta, ota yhteyttä ylläpitoon",
"Chatroom" => "Juttuhuone",
"Browser not supported" => "Selaimesi ei ole tuettu",
"Active Channels" => "Aktiiviset Kanavat",
"Users in this channel" => "Käyttäjiä tällä kanavalla",
"Channel Information" => "Kanava tiedot",
"Channel" => "Kanava",
"Ratio" => "Suhde",
"Use :nickname:message for private messages" => "Käytä :lempinimi:viesti yksityis viesteille",
"Use [URL|description] or [URL] for links" => "Käytä [URL|kuvaus] tai [URL] linkkejä",
"Use (:smileyname:) for smileys" => "Käytä (:hymiönimi:) hymiöille",
"Create PDF" => "Luo PDF",
"PDF Settings" => "PDF Asetukset",
"Font" => "Kirjasin",
"Textheight" => "Tekstinkorkeus",
"Height of top Heading" => "Ylimmän pääosan korkeus",
"Height of mid Heading" => "Medium pääosan korkeus",
"Height of inner Heading" => "Sisäisen pääosan korkeus",
"tbheight" => "tbkorkeus",
"Automatic Page Breaks" => "Automaattiset Sivu Jaot",
"Select Wiki Pages" => "Valitse Sivu",
"add page" => "lisää sivu",
"remove page" => "poista sivu",
"reset" => "nollaus",
"Send a message to us" => "Lähetä meille viesti",
"Contact us by email" => "Ota yhteyttä sähköpostilla",
"click here to send us an email" => "paina, lähettääksesi meille sähköpostia",
"Create WebHelp" => "Luo WebApu",
"You can browse the generated WebHelp here" => "Voit selata WebApua tästä",
"Structure" => "Rakenne",
"Top page" => "Ylin sivu",
"Close" => "Sulje",
"Current URL" => "Nykyinen URL",
"Command" => "Komento",
"exec" => "suorita",
"Type <code>help</code> to get list of available commands" => "Kirjoita <code>help</code> saadaksesi listan komennoista",
"Add a new site" => "Lisää uusi sivusto",
"You cannot add sites until Directory Categories are setup." => "Et voi lisätä sivustoja ennen kuin Hakemisto Luokittelut on tehty.",
"Please contact the Site Administrator" => "Ota yhteyttä Sivuston Ylläpitäjään",
"Site added" => "Sivusto lisätty",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Seuraava sivusto on lisätty ja ylläpidon hyväksyntä ennen kuin se ilmestyy listalle",
"Add or edit a site" => "Lisää tai muokkaa sivustoa",
"Name:" => "Nimi:",
"Categories:" => "Luokittelut:",
"Is valid" => "On hyväksytty",
"Directory Administration" => "Hakemisto Ylläpito",
"admin directory tpl" => "ylläpidä hakemisto tpl",
"Statistics" => "Tilastot",
"There are" => "Siellä on",
"invalid sites" => "kelpaamaton sivusto",
"valid sites" => "hyväksytty sivusto",
"Users have visited" => "Käyttäjät vierailleet",
"sites from the directory" => "hakemiston sivustoilla",
"Users have searched" => "Käyttäjät etsineet",
"times from the directory" => "kertaa hakemistosta",
"Admin sites" => "Ylläpidä sivustoja",
"Admin category relationships" => "Ylläpidä luokan suhteita",
"Validate links" => "Vahvista linkit",
"Settings" => "Asetukset",
"browse" => "selaa",
"related" => "liittyvä",
"sites" => "sivustot",
"validate" => "vahvista",
"Admin directory categories" => "Ylläpidä hakemisto luokitteluja",
"admin directory categories tpl" => "ylläpidä hakemisto luokittelujen tpl",
"Parent category" => "Isäntä luokka",
"Add a directory category" => "Lisää hakemisto luokka",
"Edit this directory category" => "Muokkaa tätä hakemisto luokkaa",
"Children type" => "Ali tyyppi",
"Most visited sub-categories" => "Eniten vieraillut alaluokat",
"Category description" => "Luokan kuvaus",
"Random sub-categories" => "Satunnais alaluokka",
"Maximum number of children to show" => "Näytettävien alaluokkien maksimi määrä",
"Allow sites in this category" => "Salli sivustot tässä luokassa",
"Show number of sites in this category" => "Näytä montako sivustoa on tässä luokassa",
"Editor group" => "Muokkaa ryhmää",
"Subcategories" => "Alaluokat",
"cType" => "cTyyppi",
"allow" => "salli",
"count" => "laske",
"editor" => "editori",
"relate" => "liitä",
"Admin related categories" => "Ylläpitoon liittyvät luokat",
"Admin Directory Related " => "Ylläpidä Hakemistoon Liittyvät ",
"directory admin related tpl" => "hakemiston ylläpitoon liittyvä tpl",
"Add a related category" => "Lisää liittyvä luokka",
"Mutual" => "Samanlainen",
"Related categories" => "Asiaanliittyvät luokittelut",
"Admin Directory Sites" => "Ylläpidä Hakemisto Sivustoja",
"Admin Directory Sites tpl" => "Ylläpidä Hakemisto Sivusto tpl",
"country" => "maa",
"new sites" => "uudet sivustot",
"cool sites" => "siistit sivustot",
"add a site" => "lisää sivusto",
"add a category" => "lisää luokka",
"any" => "mikävain",
"in entire directory" => "koko hakemisto",
"in current category" => "nykyiseen luokkaan",
"search" => "etsi",
"Sort by" => "Lajittele",
"name (desc)" => "nimi (aleneva)",
"name (asc)" => "nimi (nouseva)",
"hits (desc)" => "osumia (aleneva)",
"hits (asc)" => "osumia (nouseva)",
"creation date (desc)" => "luonti päivä (aleneva)",
"creation date (asc)" => "luonti päivä (nouseva)",
"last updated (desc)" => "viimeksi päivitetty (aleneva)",
"last updated (asc)" => "viimeksi päivitetty (nouseva)",
"sort" => "lajiteltu",
"Added" => "Lisätty",
"Last updated" => "Viimeksi päivitetty",
"Total categories" => "Luokitteluja kaikkiaan",
"Total links" => "Linkkejä kaikkiaan",
"Links to validate" => "Linkkejä hyväksyttäväksi",
"Searches performed" => "Etsintöjä suoritettu",
"Total links visited" => "Linkki vierailuja kaikkiaan",
"Directory ranking" => "Hakemisto arvostus",
"Search results" => "Etsintä tulokset",
"Validate sites" => "Hyväksy sivustot",
"Validate Sites" => "Hyväksy Sivustot",
"directory validate sites tpl" => "hakemisto hyväksy sivustot tpl",
"list articles" => "listaa artikkelit",
"view articles" => "näytä artikkelit",
"Topline" => "Ylärivi",
"Subtitle" => "Alaotsikko",
"Source" => "Lähde",
"Author Name" => "Kirjoittajan Nimi",
"Own Image" => "Oma Kuva",
"Use own image" => "Käytä omaa kuvaa",
"Float text around image" => "Kuljeta teksti kuvan ympäri",
"Own image size x" => "Oman kuvan koko x",
"pixels" => "pixeliä",
"Own image size y" => "Oman kuvan koko y",
"Image caption" => "Kuvateksti",
"Heading" => "Pääosa",
"Body" => "Runko",
"Use ...page... to separate pages in a multi-page article" => "Käytä ...sivu... erotellaksesi sivut monisivuisessa artikkelissa",
"Expiration Date" => "Viimeinen Päivä",
"Edit or create banners" => "Muokkaa tai luo bannereita",
"List banners" => "Listaa bannerit",
"URL to link the banner" => "URL linkki banneriin",
"Client" => "Asiakas",
"Max impressions" => "Maksimi vaikutelmat",
"create zone" => "luo alue",
"Show the banner only between these dates" => "Näytä banneri vain näiden päivämäärien välissä",
"From date" => "Alkaen päivästä",
"To date" => "Päättyen päivään",
"Use dates" => "Käytä päiviä",
"Show the banner only in this hours" => "Näytä banneri vain näinä tunteina",
"Show the banner only on" => "Näytä banneri vain",
"Mon" => "Maa",
"Tue" => "Tii",
"Wed" => "Kes",
"Thu" => "Tor",
"Fri" => "Per",
"Sat" => "Lau",
"Select ONE method for the banner" => "Valitse vain YKSI menetelmä",
"Use HTML" => "Käytä HTML",
"HTML code" => "HTML koodi",
"Use image" => "Käytä kuvaa",
"Image:" => "Kuva:",
"Current Image" => "Nykyinen Kuva",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Käytä URL osoitteesta luotua kuvaa (kuva haetaan URL osoitteesta jokaista näyttökertaa varten)",
"Use text" => "Käytä tekstiä",
"Text" => "Teksti",
"save the banner" => "tallenna banneri",
"Remove Zones (you lose entered info for the banner)" => "Poista Alueet (menetät bannerin tiedot)",
"Edit Blog" => "Muokkaa Blogia",
"Create Blog" => "Luo Blogi",
"edit blog tpl" => "muuuta blog tpl",
"Current heading" => "Nykyinen pääosa",
"There are individual permissions set for this blog" => "Tähän blogiin on erityisoikeudet",
"Number of posts to show" => "Näytettävien lähetysten määrä",
"Allow other user to post in this blog" => "Salli muiden käyttäjien lähettää tähän blogiin",
"Use titles in blog posts" => "Käytä otsikoita blogi lähetyksissä",
"Allow search" => "Salli etsintä",
"Allow comments" => "Salli kommentit",
"Show user avatar" => "Näytä käyttäjän hahmo",
"Blog heading" => "Blogin pääosa",
"Edit Style Sheet" => "Muuta Tyyli Arkkia",
"Style Sheet" => "Tyyli Arkki",
"Cancel" => "Peruuta",
"choose a stylesheet" => "valitse tyyliarkki",
"try" => "kokeile",
"display" => "näytä",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Tiedoston nimien kanssa lisännyt -{\$user} muokattavissa, muut voivat kopioida tai käyttää mallina.",
"Show Plugins Help" => "Näyttää Plugi Avun",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "Saadaksesi lisää tietoja, katso <a href=\"{\$helpurl}WikiSyntax\">SivuSyntaxi</a>",
"some text" => "joku teksti",
"Creates a box with the data" => "Luo laatikon tietoineen",
"Box content" => "Laatikon sisältö",
"Title bar" => "Otsikko palkki",
"creates a title bar" => "luo otsikko palkin",
"Colored text" => "Värillinen teksti",
"Lists" => "Listat",
"for bullet lists" => "sisennettyjä listauksia varten",
"for numbered lists" => "numeroituja listauksia varten",
"for definiton lists" => "määrittely listauksia varten",
"Headings" => "Pääosat",
"Show/Hide" => "Näytä/Piilota",
"show/hide heading section. + (shown) or - (hidden) by default" => "näytä/piilota pääosat. + (näyttää) tai - (piilottaa) oletuksena",
"Wiki References" => "Wiki Suositukset",
"JoinCapitalizedWords or use" => "JoinCapitalizedWords tai käytä",
"page|desc" => "sivu|kuvaus",
"for wiki references" => "wiki suosituksia varten",
"SomeName" => "JokuNimi",
"prevents referencing" => "estää suositukset",
"External links" => "Ulkoiset linkit",
"use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "käytä hakasulkuja ulkoisia linkkejä varten: [URL] tai [URL|linkin_kuvaus] tai [URL|kuvaus|eipuskuria]  (viimeisin muoto estää sivustoa puskuroimasta sivua; käytä sitä kun sivulla on paljon tavaraa!).",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "Ulkoiset Wikit, käytä ExternalWikiName:SivuNimi tai ((External Wiki Name: Sivu Nimi))",
"Tables" => "Taulukot",
"creates a table" => "luo taulukko",
"displays an image" => "näyttää kuvan",
"height width desc link and align are optional" => "korkeus leveys kuvaus linkki ja keskitys ovat vaihtoehtoja",
"Non cacheable images" => "Puskuroimattomia kuvia",
"Line break" => "Rivin katkaisu",
"(very useful especially in tables)" => "(erittäin käyttökelpoinen taulukoissa)",
"makes a horizontal rule" => "tekee vaaka viivan",
"creates the editable drawing foo" => "luo muokattavat piirroksen",
"Multi-page pages" => "MoniSivu sivut",
"Wiki File Attachments" => "Tiedosto Liitteet",
"Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Luo linkin nimettyyn tiedostoon.  Jos sivua ei anneta, tiedosto on liitettävä nykyiseen sivuun.  Jos kuvausta ei anneta, tiedoston nimeä käytetään linkin tekstissä, kunnes näytäkuvaus käytetään, jolloin kuvausta käytetään liitteen linkkitekstinä.  Jos kuva=1 on annettu, liite toimii kuten kuva ja näytetään suoraan sivulla; linkkiä ei muodosteta.",
"RSS feeds" => "RSS syötteet",
"displays rss feed with id=n maximum=m items" => "näyttää rss syötteen id=n maximum=m osaa",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Korvataan arvolla, joka saadaan muuttuva sisältöisestä osasta jolla on id=n",
"Dynamic variables" => "Muuttuvat muuttujat",
"Inserts an editable variable" => "Lisää muokattavan muuttujan",
"Non parsed sections" => "Jäsentämättömät osastot",
"Prevents wiki parsing of the enclosed data." => "Estää sivustoa jäsentämästä oheista tietuetta.",
"Preformated sections" => "Esimuotoillut osastot",
"Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Näyttää esimuotoillun tekstin/koodin; mitään prosesseja ei suoriteta näillä osastoilla (kuin np), ja tila on vakio (ei automaattista rivitystä).",
"Square Brackets" => "HakaSulut",
"Use [[foo] to show [foo]." => "Käytä [[foo] näyttääksesi [foo].",
"Block Preformatting" => "Estä Esimuotoilu",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Tee sisennys sanavälejä lisäten muuttaaksesi sen tasalevyiseksi plokiksti joka muutoin tekee muotoilut. Sisennys tehdään sen mukaan montako sanaväliä on käytetty.  Huomaa, että tämä muoto ei säilytä tarkkoja välejä eikä rivivaihtoja; käytä ~pp~...~/pp~ siihen.",
"Table of contents" => "Sisällysluettelo",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" tulostaa sisällysluettelon sivusta perustuen rakenteeseen (toc) tai ! pääosiin (maketoc)",
"Misc" => "Sekal",
"Show Text Formatting Rules" => "Näyttää tekstin muotoilu säännöt",
"No description available" => "Ei kuvausta saatavilla",
"Quicktags" => "Pikatagit",
"bold" => "lihava",
"italic" => "kallistus",
"underline" => "alleviivaus",
"table" => "taulukko",
"table new" => "uusi taulukko",
"external link" => "ulkoinen linkki",
"wiki link'" => "linkki'",
"heading1" => "pääosa1",
"title bar" => "aihe palkki",
"box" => "laatikko",
"rss feed" => "rss syöte",
"dynamic content" => "muuttuva sisältö",
"tagline" => "tagirivi",
"hr" => "linja",
"center text" => "keskitä teksti",
"colored text" => "värillinen teksti",
"dynamic variable" => "muuttuva muuttuja",
"New wms Metadata" => "Uusi wms Metadata",
"New Class" => "Uusi Class",
"New Projection" => "Uusi Arvio",
"New Query" => "Uusi Kysely",
"New Scalebar" => "Uusi Muutospalkki",
"New Layer" => "Uusi Taso",
"New Label" => "Uusi Etiketti",
"New Reference" => "Uusi Viittaus",
"New Legend" => "Uusi Seloste",
"New Web" => "Uusi Verkko",
"New Outputformat" => "Uusi Tulostumuoto",
"New Mapfile" => "Uusi Karttatiedosto",
"special chars" => "erikoismerkit",
"special characters" => "erikois merkit",
"admin quicktags" => "ylläpidon pikatagit",
"Edit Image" => "Muokkaa Kuvaa",
"browse image" => "katso kuva",
"Edit successful!" => "Muutos onnistui!",
"The following image was successfully edited" => "Seuraava kuva on onnistuneesti muutettu",
"Image Description" => "Kuvan Kuvaus",
"Edit and create Languages" => "Muuta ja luo Kieliä",
"Im- Export Languages" => "Tuo- Vie Kieliä",
"Edit and create languages" => "Muuta ja luo kieliä",
"Create Language" => "Luo Kieli",
"Shortname" => "Lyhytnimi",
"like" => "kuten",
"Longname" => "Pitkänimi",
"Select the language to edit" => "Valitse muokattava kieli",
"Add a translation" => "Lisää käännös",
"Edit translations" => "Muuta käännöstä",
"Translate recorded" => "Käännös taltioitu",
"Original" => "Alkuperäinen",
"Translation" => "Käännös",
"translate" => "käännä",
"reset table" => "nollaa taulukko",
"Program dynamic content for block" => "Ohjelmoi muuttuva sisältö blokille",
"create new block" => "luo uusi blokki",
"Return to block listing" => "Palaa blokki listaukseen",
"Block description: " => "Blokin kuvaus: ",
"Create or edit content" => "Luo tai muuta sisältöä",
"You are editing block:" => "Olet muuttamassa blokkia:",
"Publishing date" => "Julkaisu päivä",
"Publishing Date" => "Julkaisu Päivä",
"Edit question options" => "Muokkaa kysymys vaihtoehtoja",
"list quizzes" => "listaa visailut",
"quiz stats" => "visailu tilastot",
"this quiz stats" => "tämän visailut tilasto",
"edit this quiz" => "muuta tätä visailua",
"admin quizzes" => "ylläpidä visailuja",
"Create/edit options for question" => "Luo/muuta kysymys vaihtoehtoja",
"points" => "pisteitä",
"Admin quizzes" => "Ylläpidä visailuja",
"admin quizzes tpl" => "ylläpidä visailut tpl",
"Create/edit quizzes" => "Luo/muuta visailuja",
"There are individual permissions set for this quiz" => "Visailulle on asetettu erikoisoikeudet",
"Quiz can be repeated" => "Visailun voi toistaa",
"Store quiz results" => "Tallenna visailu tulokset",
"Immediate feedback" => "Välitön palaute",
"Show correct answers" => "Näytä oikeat vastaukset",
"Shuffle questions" => "Sekoita kysymykset",
"Shuffle answers" => "Sekoita vastaukset",
"Questions per page" => "Kysymyksiä per sivu",
"Quiz is time limited" => "Visailulla on aikaraja",
"Maximum time" => "Maksimi aika",
"Passing Percentage" => "Läpäisy Prosentti",
"canRepeat" => "voiToistaa",
"timeLimit" => "aikaRaja",
"results" => "tulokset",
"Edit quiz questions" => "Muuta visailun kysymyksiä",
"edit quiz questions" => "muokkaa visailun kysymyksiä",
"edit quiz questions tpl" => "muokkaa visailun kysymyksiä tpl",
"Create/edit questions for quiz" => "Luo/muuta visailun kysymyksiä",
"Question Type" => "Kysymyksen Tyyppi",
"Import questions from text" => "Tuo kysymykset tekstinä",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Ohjeet: Kirjoita, tai liitä, monivalinta kysymyksesi alle.  Yksi kysymys riviä kohti, aloita vastaus vaihtoehdot seuraaville riveille.  Erottele lisäkysymykset tyhjällä rivillä.  Merkitse oikea vastaus aloittamalla rivi \"*\" (ilman lainausmerkkejä) merkillä.",
"Input" => "Syötä",
"maxScore" => "maxTilanne",
"From Points" => "Pisteistä",
"To Points" => "Pisteiksi",
"Answer" => "Vastaus",
"Results" => "Tulokset",
"answer" => "vastaus",
"Modify Structure" => "Muokkaa Rakennetta",
"You will remove" => "Sinä poistat",
"and its subpages from the structure, now you have two options:" => "ja sen alasivut rakenteesta, nyt sinulla on kaksi vaihtoehtoa:",
"Remove only from structure" => "Poista vain rakenteesta",
"Remove from structure and remove page too" => "Poista rakenteesta ja poista myös sivu",
"Current Node" => "Nykyinen Solmu",
"Page alias" => "Sivun lisänimi",
"Promote" => "Mainosta",
"Previous" => "Edellinen",
"Demote" => "Alenna",
"Add pages to current node" => "Lisää sivuja nykyiseen solmuun",
"After page" => "Sivun jälkeen",
"create page" => "luo sivu",
"Use pre-existing page" => "Käytä aiemmin ollutta sivua",
"Structure Layout" => "Rakenteen Layout",
"Help on Articles" => "Auta Artikkeleissa",
"edit submissions tpl" => "muokkaa ehdotus tpl",
"list submissions" => "listaa ehdotukset",
"<b>*</b>=optional" => "<b>*</b>=vaihtoehtoinen",
"<b>Topline</b>=small line above Title" => "<b>Ylärivi</b>=pieni rivi Aiheen yllä",
"<b>Subtitle</b>=small line below Title" => "<b>Alaotsikko</b>=pieni rivi Aiheen alla",
"<b>Source</b>=URL to article source" => "<b>Lähde</b>=artikkeli lähteen URL osoite",
"EditTemplates" => "MuutaMallia",
"EditTemplates tpl" => "MuutaMallia tpl",
"Template listing" => "Malli listaus",
"Available templates" => "Saatavilla olevat mallit",
"Template" => "Malli",
"save only in the theme:" => "tallenna vain teemaan:",
"Delete the copy in the theme:" => "Poista kopio teemasta:",
"Edit a topic" => "Muuta aihe",
"Edit Translation:" => "Muokkaa Käännöstä:",
"edit translations" => "muokkaa käännöksiä",
"edit translations template" => "muokkaa käännöksiä malli",
"View" => "Näytä",
"You must specify the object language" => "On valittava kohde kieli",
"The object doesn't exist" => "Kohdetta ei ole",
"The object doesn't have a language" => "Kohteella ei ole kieltä",
"The object has already a translation for this language" => "Kohteella on jo käännös tällä kielellä",
"The object is already in the set of translations" => "Kohde on jo kieliluettelossa",
"Use this section to set the language of the version you are currently working on." => "Käytä tätä osastoa asettaaksesi kielen versio jota työstät.",
"Set of Translations" => "Käännökset",
"detach" => "erota",
"add to the set" => "lisää sarjaan",
"Select the article for which the current article is the translation." => "Valitse artikkeli josta nykyinen artikkeli on käännös.",
"Translation of:" => "Käännetty:",
"Enter the name of the page for which the current page is the translation." => "Kirjoita sivun nimi josta nykyinen sivu on käännös.",
"Use rating" => "Käytä arvostelua",
"disable" => "poista käytöstä",
"There is no available poll template." => "Ei ole saatavilla äänestys mallia.",
"You should ask an admin to create them." => "Pyydä ylläpitoa luomaan ne.",
"an existing poll" => "olemassa oleva äänestys",
"Search " => "Etsi ",
"Case Insensitivity" => "Voi olla isot tai pienet",
"replace" => "korvaa",
"Try to convert HTML to wiki" => "Yritä muuttaa HTML normaali sivuksi",
"Admin ephemerides" => "Ylläpidä ephemerides",
"admin Ephemerides tpl" => "ylläpidä Ephemerides tpl",
"All ephemerides" => "Kaikki ephemerides",
"Browse" => "Selaa",
"Admin FAQ" => "Ylläpidä UKK:ä",
"View FAQ" => "Näytä UKK",
"Edit this FAQ" => "Muuta tätä UKK:ta",
"new question" => "uusi kysymys",
"Edit FAQ questions" => "Muokkaa UKK kysymyksiä",
"Use a question from another FAQ" => "Käytä kysymystä toisesta UKK:sta",
"FAQ questions" => "UKK kysymykset",
"Suggested questions" => "Ehdotetut kysymykset",
"approve" => "hyväksy",
"No suggested questions" => "Ei ehdotettuja kysymyksiä",
"File Galleries tpl" => "Tiedosto Galleria tpl",
"configure listing" => "kokoonpano listaus",
"Create a file gallery" => "Luo tiedosto galleria",
"Edit this file gallery:" => "Muokkaa tätä tiedosto galleriaa:",
"create new gallery" => "luo uusi galleria",
"There are individual permissions set for this file gallery" => "Tälle gallerialle on asetettu erikoisoikeudet",
"Gallery is visible to non-admin users?" => "Näytetäänkö galleria muille kuin ylläpijille?",
"Listing configuration" => "Kokoonpano listaus",
"icon" => "kuvake",
"Name-filename" => "Nimi-tiedostonimi",
"Filename only" => "Vain tiedostonimi",
"Max description display size" => "Suurin kuvauksen näyttökoko",
"Max Rows per page" => "Suurin rivi määrä per sivu",
"Other users can upload files to this gallery" => "Muut käyttäjät voivat lähettää tiedostoja galleriaan",
"You can access the file gallery using the following URL" => "Pääset käsiksi tiedosto galleriaan seuraavasta URL:sta",
"Available File Galleries" => "Saatavilla olevat Tiedosto Galleriat",
"Message queue for" => "Viesti jono",
"back to forum" => "takaisin foorumille",
"Edit queued message" => "Muokkaa jonottavia viestejä",
"topic" => "aihe",
"make this a thread of" => "Laita tämä ketju",
"None, this is a thread message" => "EiMitään, tämä on ketjuviesti",
"summary" => "yhteenveto",
"normal" => "normaali",
"announce" => "tiedote",
"hot" => "kuuma",
"sticky" => "pysyvä",
"no feeling" => "ei tunnetta",
"frown" => "paheksuva",
"exclaim" => "huudahdus",
"mad" => "vihainen",
"neutral" => "neutraali",
"sad" => "surullinen",
"happy" => "onnellinen",
"wink" => "silmänisku",
"save and approve" => "tallenna ja hyväksy",
"convert to topic" => "muuta aiheeksi",
"List of messages" => "Lista viesteistä",
"new topic" => "uusi aihe",
"no summary" => "ei yhteenvetoa",
"No messages queued yet" => "Ei viestejä jonossa vielä",
"reject" => "hylätty",
"configure forum" => "foorumin kokoonpano",
"Reported messages for" => "Raportoidut viestit",
"Reported by" => "Raportoijana",
"friends tpl" => "ystävät tpl",
"Pending requests" => "Odotus pyynnöt",
"Request Time" => "Pyyntö Aika",
"accept" => "hyväksy",
"refuse" => "hylkää",
"Waiting requests" => "Odottavat pyynnöt",
"Your friends" => "Ystäväsi",
"Real Name" => "Oikea Nimi",
"break friendship" => "riko ystävyys",
"Activity completed" => "Toiminto valmis",
"Admin process activities" => "Ylläpidä prosessi toimintoja",
"To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "Oppiaksesi lisää <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
"Add or edit an activity" => "Lisää tai muokkaa toimintoa",
"start" => "aloita",
"end" => "loppu",
"activity" => "toiminto",
"split" => "jaa",
"join" => "liity",
"standalone" => "itsenäinen",
"interactive" => "vuorovaikutteinen",
"auto routed" => "autom reititetty",
"Expiration Time" => "PäättymisAika",
"Years" => "Vuotta",
"Months" => "Kuukautta",
"Days" => "Päivää",
"Minutes" => "Minuuttia",
"Add transitions" => "Lisää siirtymä",
"Add transition from:" => "Lisää siirtymä:",
"Add transition to:" => "Lisää siirtymä:",
"roles" => "tehtävät",
"No roles associated to this activity" => "Tähän toimintoon ei liity tehtäviä",
"Add role" => "Lisää tehtävä",
"add new" => "lisää uusi",
"add role" => "lisää tehtävä",
"Process activities" => "Prosessi toiminnot",
"Routing" => "Reititys",
"Interactive" => "vuorovaikutteinen",
"Automatic" => "Automaattisesti",
"Auto routed" => "Autom reititetty",
"Manual" => "Käsin",
"route" => "reitti",
"(no roles)" => "(ei tehtäviä)",
"No activities defined yet" => "Ei määritelytjä toimintoja vielä",
"Process Transitions" => "Prosessin Siirrot",
"List of transitions" => "Lista siirroista",
"From:" => "Keneltä:",
"Origin" => "Alkup",
"No transitions defined yet" => "Ei määriteltyjä siirtoja vielä",
"Add a transition" => "Lisää siirto",
"Process Graph" => "Menetelmä Käyrä",
"Galaxia Admin Graph" => "Galaxia Ylläpito Käyrä",
"Galaxia Admin Graph tpl" => "Galaxia Ylläpito Käyrä tpl",
"This process is invalid" => "Tämä prosessi ei toimi",
"Process Graph for" => "Menetelmä Käyrä",
"No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "Ei sellaista käyrää saatavilla. Menetelmä sisältää virheitä, käyrää ei luotu vielä, tai <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> ei ole asennettu.",
"List of processes" => "Listaa prosessit",
"Inactive" => "EiAktiivinen",
"act" => "toi",
"val" => "arv",
"active process" => "aktiivinen prosessi",
"invalid" => "toimimaton",
"invalid process" => "toimimaton prosessi",
"valid process" => "toimiva prosessi",
"activities" => "toiminnot",
"graph" => "graafi",
"new minor" => "uusi pieni",
"new major" => "uusi iso",
"No processes defined yet" => "Ei määriteltyä prosessia vielä",
"Admin instance" => "Ylläpidä tapauksia",
"Process:" => "Prosessi:",
"Instance" => "Tapaus",
"Workitems" => "Työkohteet",
"exception" => "poikkeus",
"completed" => "valmis",
"aborted" => "keskeytetty",
"Owner" => "Omistaja",
"Send all to" => "Lähetä kaikille",
"Don't move" => "Älä siirrä",
"Activities" => "Toiminnot",
"Started" => "Aloitettu",
"Act status" => "Act tila",
"Ended" => "Loppu",
"Not Defined" => "Ei Määritelty",
"Not Interactive" => "Ei Vuorovaikutteinen",
"Not Ended" => "Ei Lopussa",
"Properties" => "Tarpeisto",
"Property" => "Ominaisuus",
"Value" => "Arvo",
"Add property" => "Lisää ominaisuus",
"value" => "arvo",
"run instance" => "aja pyyntö",
"Executed" => "Käynnistetty",
"erase" => "hävitä",
"Galaxia Admin Processes" => "Ylläpidä Galaxia Prosesseja",
"Galaxia Admin Processes tpl" => "Ylläpidä Galaxia Prosessi tpl",
"Add or edit a process" => "Lisää tai muokkaa prosessia",
"Process Name" => "Prosessin Nimi",
"is active?" => "onko aktiivinen?",
"Or upload a process using this form" => "Tai lähetä prosessi käyttäen tätä lomaketta",
"Admin process roles" => "Ylläpidä prosessi tehtäviä",
"Add or edit a role" => "Lisää tai muokkaa tehtävää",
"Process roles" => "Prosessin tehtävät",
"No roles defined yet" => "Ei määriteltyjä tehtäviä vielä",
"Map users to roles" => "Kartoita käyttäjät tehtäviin",
"Map" => "Kartta",
"Roles" => "Tehtävät",
"map" => "kartta",
"Map groups to roles" => "Kartoita ryhmät tehtäviin",
"Operation" => "Toimenpide",
"Warning" => "Varoitus",
"No roles are defined yet so no roles can be mapped" => "Tehtäviä ei ole määritelty vielä, joten tehtäviä ei voi kartoittaa",
"List of mappings" => "Lista kartoituksista",
"No mappings defined yet" => "Ei kartoituksia määritelty vielä",
"Admin process sources" => "Ylläpidä prosessin lähteitä",
"select source" => "valitse lähde",
"Shared code" => "Jaettu koodi",
"Set next user" => "Aseta seuraava käyttäjä",
"Get property" => "Ota ominaisuus",
"Set property" => "Aseta ominaisuus",
"Complete" => "Valmis",
"Process form" => "Prosessi lomake",
"Set Next act" => "Aseta Seuraava toiminto",
"If:SetNextact" => "Jos:AsSeutoim",
"Switch construct" => "Vaihda käsite",
"Map process roles" => "Kartoita prosessin tehtävät",
"admin processes" => "ylläpidä prosesseja",
"admin activities" => "ylläpidä toimintoja",
"admin roles" => "ylläpidä tehtäviä",
"edit this process" => "muuta tätä prosessia",
"Galaxia Monitor Activities" => "Galaxia Tarkkaile Toimintoja",
"Galaxia Monitor Activities tpl" => "Galaxia Tarkkaile Toiminto tpl",
"List of activities" => "Lista toiminnoista",
"proc" => "pros",
"routing" => "reititys",
"Instances" => "Pyyntö",
"run" => "aja",
"run activity" => "aja toiminto",
"Enter the name of this instance" => "Anna pyynnön nimi",
"The name is not valid. Please, enter the name again" => "Nimi ei kelpaa. Anna nimi uudelleen",
"monitor" => "tarkkailija",
"monitor processes" => "tarkkaile prosesseja",
"monitor activities" => "tarkkaile toimintoja",
"monitor instances" => "tarkkaile pyyntöjä",
"monitor workitems" => "tarkkaile työkohteita",
"Galaxia Monitor Instances" => "Galaxia Tarkkaile Pyyntöjä",
"Galaxia Monitor Instances tpl" => "Galaxia Tarkkail Pyyntöjen tpl",
"List of instances" => "Lista pyyntöjä",
"Not ended" => "Ei lopussa",
"No instances created yet" => "Ei pyyntöjä luotu vielä",
"Galaxia Monitor Processes" => "Galaxia Tarkkaile Prosesseja",
"Galaxia Monitor Processes tpl" => "Galaxia Tarkkaile Prosessien tpl",
"Valid" => "Hyväksytty",
"Invalid" => "Toimimaton",
"processes" => "prosessit",
"being run" => "on käynnissä",
"exceptions" => "poikkeukset",
"Monitor workitems" => "Tarkkaile työkohteita",
"List of workitems" => "Listaa työkohteet",
"instance" => "pyyntä",
"Instance Id" => "Esimerkki Id",
"Instance Name" => "Esimerkki Nimi",
"Instance Status" => "Esimerkin Tila",
"Elapsed time" => "Kulunut aika",
"My activities" => "Omat toiminnot",
"Current Activity" => "Nykyinen Toiminto",
"Assigned To" => "Liitetty",
"exception instance" => "poikkeus pyyntö",
"exceptions instance" => "pyyntö poikkeukset",
"send instance" => "lähetä pyyntö",
"abort instance" => "keskeytä pyyntö",
"grab instance" => "nappaa pyyntö",
"release instance" => "vapauta pyyntö",
"No activities found" => "Ei löydy toimintoja",
"My instances" => "Omat pyynnöt",
"No instances found" => "Ei löydy pyyntöjä",
"activate" => "aktivoi",
"User Activities" => "Käyttäjä Toiminnot",
"Galaxia User Activities" => "Galaxia Käyttäjä Toiminnot",
"Galaxia User Activities tpl" => "Galaxia Käyttäjä Toiminnot tpl",
"process" => "prosessi",
"No processes defined or activated yet" => "Prosessia ei ole määritelty tai se ei ole aktiivinen",
"user processes" => "käyttäjä prosessit",
"user activities" => "käyttäjä toiminteet",
"user instances" => "käyttäjä pyynnöt",
"Galaxia User Instances" => "Galaxia Käyttäjä Pyynnöt",
"Galaxia User Instances tpl" => "Galaxia Käyttäjä Pyyntö tpl",
"Inst Status" => "Pyynt Tila",
"Not defined" => "Ei määritelty",
"No instances defined yet" => "Ei määriteltyjä pyyntöjä vielä",
"Galaxia User Processes" => "Galaxia Käyttäjä Prosessit",
"Galaxia User Processes tpl" => "Galaxia Käyttäjä Prosessi tpl",
"Browsing Workitem" => "Selataan Työkohteita",
"Workitem information" => "Työkohteen tiedot",
"galleries tpl" => "galleriat tpl",
"rebuild cache" => "rakenna puskuri",
"Create a gallery" => "Luo galleria",
"Edit this gallery:" => "Muokkaa tätä galleriaa:",
"There are individual permissions set for this gallery" => "Tälle gallerialle on asetettu erikoisoikeudet",
"Geographic" => "Maantieteellinen",
"Images per row" => "Kuvia rivillä",
"Thumbnails size X" => "Minikuvien koko X",
"Thumbnails size Y" => "Minikuvien koko Y",
"Default sort order" => "Oletus lajittelu järjestys",
"Fields to show during browsing the gallery" => "Kentät jotka näytetään selattaessa galleriaa",
"Image ID" => "Kuva ID",
"Creation Date" => "Luonti Päivä",
"XY-Size" => "XY-Koko",
"Filesize" => "Tiedostokoko",
"Gallery Image" => "Galleria Kuva",
"Parent gallery" => "Isäntä galleria",
"Available scales" => "Saatavat muutokset",
"Bounding box" => "Ympäröivä laatikko",
"default scale" => "oletus koko",
"No scales available" => "Ei muutoksia tarjolla",
"Original image is default scale" => "Alkuperäinen kuva on oletuskoko",
"Add scaled images with bounding box of square size" => "Lisää muunnetut kuvat suorakaide laatikkoon",
"Owner of the gallery" => "Gallerian omistaja",
"Other users can upload images to this gallery" => "Muut käyttäjät voivat lähettää kuvia tähän galleriaan",
"You can access the gallery using the following URL" => "Voit päästä käsiksi galleriaan seuraavasta URL:sta",
"Available Galleries" => "Saatavilla olevat Galleriat",
"Choose a filter" => "Valitse suodin",
"Imgs" => "Kuvia",
"Make Map" => "Tee Kartta",
"Select Graphic Type" => "Valitse Grafiikan Tyyppi",
"Pie Chart" => "Piirakka kaavio",
"Multiline" => "Monilinjainen",
"Multibar" => "Monipalkki",
"Bar Stack" => "Palkki Pino",
"Landscape" => "Vaakamalli",
"Portrait" => "Pystymalli",
"Independant Scale" => "Riippumaton Muunnos",
"Horizontal" => "Vaakasuora",
"Vertical" => "Pystysuora",
"Horizontal Scale" => "Vaakasuora Muunnos",
"Bottom" => "Alaosa",
"Vertical Scale" => "Pystysuora Muunnos",
"Left" => "Vasen",
"Right" => "Oikea",
"Series" => "Sarjat",
"Im- Export languages" => "Tuo- Vie kieliä",
"Select the language to Import" => "Valitse tuotava kieli",
"Select the language to Export" => "Valitse vietävä kieli",
"Import From File" => "Tuo Tiedostosta",
"Grab Wiki Tables" => "Tartu Taulukkoon",
"Import pages from a Structured Text Dump" => "Tuo sivuja Teksti Dumpista jossa on rakenne",
"ImportingPagesPhpWikiPageAdmin" => "TuoSivutPhpWikiSivuYlläpito",
"tiki-import_phpwiki tpl" => "tiki-tuonti_phpwiki tpl",
"Name of the dump file (it has to be in dump/)" => "Dumpin nimi (on oltava dumpissa/)",
"Overwrite existing pages if the name is the same" => "Päällekirjoitetaan jos tuotavalla sivulla on sama nimi",
"Previously remove existing page versions" => "Poista aiemmin olemassa olevat sivuversiot",
"excerpt" => "ote",
"result" => "tulos",
"body" => "runko",
"reload" => "lataa uudelleen",
"Install" => "Asenna",
"Clear cached version and refresh cache" => "Poista puskuroidut versiot ja päivitä puskuri",
"configure rules" => "kokoonpano säännöt",
"edit repository" => "muuta tallennuspaikka",
"Weeks" => "Viikkoa",
"Search by Date" => "Etsintä Päiväyksen mukaan",
"Found" => "Löytyi",
"LastChanges" => "ViimeisetMuutokset",
"rollback" => "taaksekelaus",
"source" => "lähde",
"Pages like" => "Sivut kuin",
"No pages found" => "Ei löytynyt sivuja",
"List Articles" => "Listaa Artikkelit",
"list articles tpl" => "listaa artikkelit tpl",
"edit new article" => "muuta uutta artikkelia",
"ExpireDate" => "PoistumisPäivä",
"AuthorName" => "KirjoittajaNimi",
"admin Banners" => "ylläpidä Bannerit",
"admin Banners tpl" => "ylläpidä Bannerit tpl",
"To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "Käyttääksesi <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduulia</a> tai mallia, käytä {literal}{banner zone=ABC}{/literal}, missä ABC on alueen nimi.",
"Create banner" => "Luo banneri",
"Method" => "Menetelmä",
"Use Dates?" => "Käytä Päiväystä?",
"Max Impressions" => "Max Vaikutelmat",
"Impressions" => "Vaikutelmat",
"Clicks" => "Klikkejä",
"create new blog" => "luo uusi blogi",
"Last Modified" => "Viimeksi muokannut",
"admin cache" => "ylläpidä puskuri",
"admin cache tpl" => "ylläpidä puskuri tpl",
"Dynamic content system" => "Muuttuvan sisällön järjestelmä",
"Help on Dynamic Content" => "Auta Muuttuvassa Sisällössä",
"admin DynamicContent tpl" => "ylläpidä MuuttuvaSisältö tpl",
"To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "Käyttääksesi sisältö plokkeja tekstialueella (sivulla, jne), <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduuli</a> tai malli, käytä {literal}{content id=x}{/literal}, missä x on sisältöplokin ID.",
"Create or edit content block" => "Luo tai muokkaa sisältö blokkia",
"Available content blocks" => "Saatavilla olevat blokit",
"Current ver" => "Nykyinen ver",
"Next ver" => "Seuraava ver",
"Future vers" => "Tulevaisuuden versiot",
"Old vers" => "Vanha vers",
"Program" => "Ohjelma",
"list faqs tpl" => "listaa ukk tpl",
"Edit this FAQ:" => "Muuta tätä UKK:ta:",
"Create new FAQ" => "Luo uusi UKK",
"Create New FAQ:" => "Luo Uusi UKK:",
"Users can suggest questions" => "Käyttäjät voivat ehdottaa kysymyksiä",
"Available FAQs" => "Saatavilla olevat UKK:t",
"Listing Gallery" => "Galleria Listaus",
"upload file" => "Lähetä tiedosto",
"Edit a file using this form" => "Muokkaa tiedostoa käyttäen tätä lomaketta",
"monitor this gallery" => "tarkkaile tätä galleriaa",
"stop monitoring this gallery" => "lopeta tämän gallerian tarkkailu",
"Gallery Files" => "Gallerian Tiedostot",
"move selected files" => "siirrä valitut tiedostot",
"delete selected files" => "poista valitut tiedostot",
"Move to" => "Siirrä",
"browse gallery" => "selaa galleriaa",
"Gallery Images" => "Gallerian Kuvat",
"games tpl" => "pelit tpl",
"All games are from" => "Kaikki pelit ovat",
"visit the site for more games and fun" => "käy sivustolla, lisää pelejä ja hauskaa",
"Upload a game" => "Lähetä peli",
"Upload a new game" => "Lähetä uusi peli",
"Flash binary (.sqf or .dcr)" => "Flash binary (.sqf tai .dcr)",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Minikuva (jos peli on foo.swf minikuva on nimettävä foo.swf.gif tai foo.swf.png tai foo.swf.jpg)",
"Edit game" => "Muokkaa peliä",
"Played" => "Pelattu",
"times" => "kertaa",
"If you can't see the game then you need a flash plugin for your browser" => "Jos et nää peliä, tarvitset flash-plugin selaimeesi",
"list posts tpl" => "listaa lähetys tpl",
"edit blog" => "muokkaa blogia",
"Blog Title" => "Blogin Otsikko",
"list quizzes tpl" => "listaa visailu tpl",
"edit new submission" => "muuta uutta ehdotusta",
"Approve" => "Hyväksy",
"edit quiz stats tpl" => "muokkaa visailu tilastoja tpl",
"Survey stats" => "Tutkimus tilastot",
"actions" => "toiminnot",
"take survey" => "ota tutkimus",
"list trackers tpl" => "listaa kortistot tpl",
"users registered" => "käyttäjät rekisteröityneet",
"Distance (km)" => "Suunta (km)",
"List Movies" => "Listaa Elokuvat",
"Choose a movie" => "Valitse elokuva",
"Display" => "Näytä",
"Last mod" => "Viimeksi muok",
"Last author" => "Viimeisin kirjoittaja",
"Last ver" => "Viimeisin ver",
"Com" => "Kom",
"Vers" => "Ver",
"with checked" => "merkityt",
"admin live support tpl" => "ylläpidä elävä tuki tpl",
"Open client window" => "Avaa asiakas ikkuna",
"Generate HTML" => "Muodosta HTML",
"Transcripts" => "Käsikirjoitukset",
"Support tickets" => "Tuki lipuille",
"Online operators" => "Online operaattorit",
"Operator" => "Operaattori",
"Accepted requests" => "Hyväksytyt pyynnöt",
"transcripts" => "käsikirjoitukset",
"Offline operators" => "Offline operaattorit",
"Add an operator to the system" => "Lisää operaattori järjestelmään",
"Operators must be tiki users" => "Operaattorin oltava sivuston jäsen",
"set as operator" => "aseta operaattoriksi",
"Chat started" => "Juttelu aloitettu",
"User:" => "Käyttäjä:",
"Operator:" => "Operaatori:",
"Live support:User window" => "Elävä tuki:Käyttäjän ikkuna",
"Request live support" => "Pyydä elävä tuki",
"Request support" => "Pyydä tukea",
"Open a support ticket instead" => "Avaa sen sijaan tukilippu",
"Your request is being processed" => "Pyyntösi on käsitelty",
"cancel request and exit" => "peruuta pyyntö ja poistu",
"cancel request and leave a message" => "peruuta pyyntö ja jätä viesti",
"Live support:Console" => "Elävä tuki:Konsoli",
"be online" => "pysy linjalla",
"be offline" => "poissa linjalta",
"Support requests" => "Tukee pyyntöjä",
"Requested" => "Pyydetty",
"Accept" => "Hyväksy",
"Join" => "Liity",
"Support chat transcripts" => "Tukee jutun käsikirjoitusta",
"back to admin" => "takaisin ylläpitoon",
"operator" => "operaattori",
"started" => "aloitettu",
"reason" => "syy",
"msgs" => "viesti",
"Transcript" => "Käsikirjoitus",
"Mail-in feature" => "Posti-sisään ominaisuus",
"User Calendar" => "Käyttäjä Kalenteri",
"User Calendar Doc tpl" => "Käyttäjä Kalenteri Doc tpl",
"Remove old events" => "Poista vanhat tapahtumat",
"duration" => "kesto",
"Add or edit event" => "Lisää tai muuta tapahtumaa",
"Mini Calendar: Preferences" => "Mini Kalenteri: Kokoonpano",
"User Calendar Doc" => "Käyttäjä Kalenteri Doc",
"User Calendar Preferences Doc tpl" => "Käyttäjä Kalenteri Kokoonpano Doc tpl",
"Calendar Interval in daily view" => "Kalenterin aikaväli päivittäis näytössä",
"Start hour for days" => "Päivän aloitusaika",
"End hour for days" => "Päivän lopetusaika",
"Reminders" => "Muistutukset",
"no reminders" => "ei muistuksia",
"Import CSV file" => "Tuo CSV tiedosto",
"Or enter path or URL" => "Tai kirjoita polku tai URL",
"add topic" => "lisää aihe",
"To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>." => "Oppiaksesi lisää <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>.",
"Tikiwiki Mods" => "Sivusto Modit",
"Mods Configuration" => "Moduulien Kokoonpano",
"Update remote index" => "Päivitä ulkoinen indexi",
"Rebuild local list" => "Rakenna paikallinen listaus",
"Republish all" => "Uudelleen julkaise kaikki",
"Publish all" => "Julkaise kaikki",
"Unpublish all" => "Äläjulkaise mitään",
"Attention" => "Huomio",
"Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example)." => "Apachella on oikeus kirjoittaa hakemistopuuhusi, joka mahdollistaa asennukset, poiston tai \npakettien päivitykse. Kun nämä toimenpiteet on tehty, muuta oikeudet takaisin turvalliseen tilaan (käyttäen \n\"./fixperms.sh fix\" esimerkiksi).",
"To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\")." => "Asentaaksesi, poistaaksesi tai päivittääksesi paketteja apache tarvitsee oikeudet\nkirjoittaa tiedostoja hakemistopuuhusi (voit käyttää \"./fixperms.sh open\" antaaksesi oikeudet). Asennuksen jälkeen palauta \noikeudet (käyttäen \"./fixperms.sh fix\").",
"all types" => "kaikki tyypit",
"Display only this type" => "Näytä vain tämän tyypin",
"Unpublish" => "Äläjulkaise",
"Republish" => "Uusintajulkaisu",
"install" => "asenna",
"Tikiwiki Mods Configuration" => "Modien Kokoonpano",
"Enable Mods providing" => "Oikeuta Modien tarjonta",
"Mods local directory" => "Modien paikallinen hakemisto",
"Mods remote server" => "Modien ulkoinen palvelin",
"Package Config" => "Paketti Kokoonopano",
"my tiki tpl" => "oma sivu tpl",
"My pages" => "Omat sivut",
"Last editor" => "Viimeksi muokannut",
"Last modification" => "Viimeisin muokkaus",
"y" => "k",
"My items" => "Omat osat",
"My tasks" => "Omat tehtävät",
"subscribe" => "tilaa",
"Sent edition" => "Lähetä esitys",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Kiitos tilauksestasi. Saat kohta sähköpostia jolla varmistetaan tilauksesi. Uutislehteä ei lähetetä ennen kuin tilaus on varmistettu.",
"Your email address was removed from the list of subscriptors." => "Sähköpostiosoitteesi on poistettu tilaajien listalta.",
"Subscription confirmed!" => "Tilaus varmistettu!",
"Subscribe to newsletter" => "Tilaa uutislehti",
"Email:" => "Sähköposti:",
"Subscribe" => "Tilaa",
"Available Newsletters" => "Saatavilla olevat Uutislehdet",
"Select news group" => "Valitse uutisryhmä",
"Back to servers" => "Takaisin palvelimelle",
"Msgs" => "Viestit",
"News from" => "Uutisia",
"Save position" => "Tallenna paikka",
"Reading article from" => "Luetaan artikkeli",
"Back to list of articles" => "Takaisin artikkelien listaukseen",
"First" => "Ensimmäinen",
"Newsgroup" => "Uutisryhmä",
"Configure news servers" => "Muuta uutispalvelimien kokoonpanoa",
"Configure Newsreader" => "Uutislukijan kokoonpano",
"configure newsreader server tpl" => "muokkaa uutislukijan tpl",
"Select a news server to browse" => "Valitse uutispalvelin selattavaksi",
"server" => "palvelin",
"Read the news" => "Lue uutisia",
"Add or edit a news server" => "Lisää tai muuta uutispalvelinta",
"News server" => "Uutispalvelin",
"Notes" => "Huomiot",
"quota" => "levytila",
"Write a note" => "Kirjoita huomio",
"No notes yet" => "Ei huomioita vielä",
"merge selected notes into" => "yhdistä valitut huomiot",
"Reading note:" => "Lukee huomiota:",
"List notes" => "Listaa huomiot",
"Write note" => "Kirjoita huomio",
"wiki create" => "wiki luonti",
"wiki overwrite" => "wiki päällekirjoitus",
"Assign permissions to " => "Liitä oikeudet ",
"back" => "takaisin",
"Current permissions for this object" => "Kohteen nykyiset oikeudet",
"Assign permissions to this object" => "Liitä oikeudet tälle kohteelle",
"Published" => "Julkaistu",
"Votes" => "Ääniä",
"Orphan Pages" => "Yksinäiset Sivut",
"Preview of version" => "Version esikatselu",
"(current)" => "(nykyinen)",
"rollback to this version" => "takaisin tähän versioon",
"Source of version" => "Versio Lähde",
"s=source" => "l=lähde",
"b=rollback" => "t=takaisin",
"Assign permissions to page" => "Liitä sivuun oikeudet",
"Current permissions for this page" => "Nykyiset oikeudet tälle sivulle",
"remove from this page" => "poista tältä sivulta",
"remove from this structure" => "poista tästä rakenteesta",
"No individual permissions; category or global permissions apply" => "Ei yksittäisoikeuksia; luokka tai yleiset oikeudet annetaan",
"this page" => "tämä sivu",
"this structure" => "tämä rakenne",
"Current permissions for categories that this page belongs to" => "Nykyiset oikeudet tämän sivun luokkiin kuuluvat",
"No category permissions; global permissions apply" => "Ei luokka oikeuksia; yleiset oikeudet annetaan",
"Send email notifications when this page changes to" => "Lähetä sähköposti ilmoitus kun tämä sivu muuttuu tänne",
"add email" => "lisää sähköposti",
"Notifications" => "Huomautukset",
"Pick your avatar" => "Valitse hahmosi",
"Your current avatar" => "Nykyinen hahmosi",
"no avatar" => "ei hahmoa",
"Pick avatar from the library" => "Valitse hahmo kirjastosta",
"icons" => "ikonit",
"Show all" => "Näytä kaikki",
"Avatar Image" => "Hahmo Kuva",
"random" => "satunnainen",
"Upload your own avatar" => "Lähetä oma hahmosi",
"lastModif" => "viimeksiMuokannut",
"atts" => "liite",
"Number of voices" => "Ääniä kaikkiaan",
"Average" => "Keskimäärin",
"List Attachments" => "Listaa Liitteet",
"View Results" => "Näytä Tulokset",
"Vote poll" => "Ota äänestys",
"Other Polls" => "Muut äänestykset",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Huomaa: Muista, että tämä on vasta esikatselu, ja sitä ei ole tallennettu!",
"Print multiple pages" => "Tulosta useita sivuja",
"Print Wiki Pages" => "Tulosta Wiki Sivut",
"add structure" => "lisää rakenne",
"clear" => "tyhjennä",
"Edit quiz" => "Muokka visailua",
"Current Version" => "Nykyinen Versio",
"General Options" => "Yleiset Vaihtoehdot",
"Publication Date" => "Julkaisupäivä",
"at " => " ",
"Use " => "Käytä ",
"randomly selected questions." => "satunnaisesti valitut kysymykset.",
"Test-time Options" => "Testin-aika Vaihtoehdot",
"Limit questions displayed per page to " => "Rajoita kysymysten määrä per sivu ",
"&nbsp question(s)." => "&nbsp kysymys(tä).",
"Impose a time limit of " => "Määrää aikaraja ",
"Allow students to store partial results and return to quiz." => "Salli opiskelijoiden tallentaa osittaiset tulokset ja palata visailuun.",
"Allow students to retake this quiz " => "Salli opiskelijoiden ottaa uudelleen visailu ",
"Grading and Feedback" => "Arvostelu ja Palaute",
"Grading method " => "Arvostelu menetelmä ",
"Show students their score " => "Näytä opiskelijoille heidän pisteensä ",
"Show students the correct answers " => "Näytä opiskelijoille oikeat vastaukset ",
"Publish statistics " => "Julkaise tilastot ",
"Extra Options" => "Lisä Vaihtoehdot",
"Solicit additional questions from students" => "Pyydä lisäkysymyksiä opiskelijoilta",
"Link quiz to forum named: " => "Linkitä visailu foorumiin nimeltä: ",
"Prologue:" => "Esipuhe:",
"Epilogue:" => "Jälkipuhe:",
"Quiz result stats" => "Visailu tulosten tilasto",
"Quiz" => "Visailu",
"Time" => "Aika",
"User answers" => "Käyttäjä vastaukset",
"Stats for quizzes" => "Visailujen tilastot",
"taken" => "otettu",
"Av score" => "Keskim tilanne",
"Av time" => "Keskim aika",
"Stats for quiz" => "Visailun tilasto",
"clear stats" => "tyhjennä tilastot",
"time taken" => "aikaa meni",
"P/F" => "Osittain/Koko",
"P" => "Os",
"F" => "Ko",
"Stats for this quiz Questions " => "Tämän visailun kysymysten tilasto ",
"Received Articles" => "Vastaanotetut Artikkelit",
"received articles tpl" => "vastaanotetut artikkelit tpl",
"Edit received article" => "Muokkaa vastaanotettua artikkelia",
"Use Image" => "Käytä Kuvaa",
"Image x size" => "Kuva x koko",
"Image y size" => "Kuva y koko",
"Image name" => "Kuvan nimi",
"Accept Article" => "Hyväksy Artikkeli",
"Site" => "Sivusto",
"Help on Communication Center" => "Auta Yhteistoiminta Keskuksessa",
"received pages tpl" => "vastaanotetut sivut tpl",
"Edit received page" => "Muokkaa vastaanotettua sivua",
"admin Referer stats" => "ylläpidä Suositus tilastoja",
"admin Referer stats tpl" => "ylläpidä Suositus tilastoja tpl",
"last" => "viimeinen",
"A valid email is mandatory to register" => "Voimassa oleva sähköposti osoite on pakollinen rekisteröinnissä",
"NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!" => "HUOMAA: Pidä huoli domain listauksesta estääksesi<br />rekisteröinti viestien menemisen roskapostiin!",
"Tiki site registered" => "Tiki sivusto rekisteröity",
"You don't have permission to use this feature." => "Oikeutesi eivät riitä käyttämään tätä ominaisuutta.",
"Please register." => "Ole Hyvä ja rekisteröidy.",
"Read this first!" => "Lue tämä ensin!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Tällä sivulla voit tehdä sivustosi tunnetuksi tikiwiki.org:iin. Se tulee sinne näkyviin tunnettuna sivustona.",
"Registering is voluntary." => "Rekisteröinti on vapaaehtoinen.",
"Registering does not give you any benefits except one more link to your site." => "Rekisteröinti ei tuo mitään lisäetua vain yhden linkin lisää.",
"You don't get any emails, we don't sell the data about your site." => "Et saa mitään postituksia, me emme myy sivustosi tietoja eteenpäin.",
"Registering is just for us to get an overview of Tiki's usage." => "Rekisteröinti on vain meille jotta saamme paremman kuvat Tiki:en käytöstä.",
"If your site is private or inside your intranet, you should not register!" => "Jos sivustosi on yksityinen tai vain sisäisessä verkossa sitä ei pidä rekisteröidä!",
"Information about your site" => "Tietoja sivustostasi",
"I forgot my password" => "Unohdin salasanan",
"send me my password" => "lähetä salasanani",
"Return to HomePage" => "Palaa EtuSivulle",
"Remove page" => "Poista sivu",
"last version" => "viimeinen versio",
"You are about to remove the page" => "Olet aikeissa poistaa sivun",
"permanently" => "pysyvästi",
"Remove all versions of this page" => "Poista kaikki versiot tästä sivusta",
"Rename page" => "Nimeä sivu",
"Replicate" => "Jäljennös",
"Slave" => "Alainen",
"Master" => "Mestari",
"Change" => "Muuta",
"Operations" => "Toimenpiteet",
"Operations Log" => "Toimenpiteiden Logi",
"Rollback page" => "Takaisinkelaa sivu",
"to_version" => "versioon",
"Search Stats" => "Etsintä Tilastot",
"search stats tpl" => "etsintä tilastot tpl",
"searched" => "etsitty",
"Search in" => "Etsitty",
"galleries" => "gallerioista",
"blog posts" => "blogi lähetyksistä",
"articles" => "artikkeleista",
"trackers" => "kortistot",
"entire site" => "koko sivusto",
"wiki pages" => "sisäiset sivut",
"Simple search" => "Yksikertainen haku",
"No pages matched the search criteria" => "Ei sivuja näillä hakuehdoilla",
"Send blog post" => "Lähetä blogi lähetys",
"A link to this post was sent to the following addresses:" => "Linkki tähän lähetykseen on lähetetty osoitteeseen:",
"Send post to this addresses" => "Lähetä posti näihin osoitteisiin",
"List of email addresses separated by commas" => "Sähköposti osoitteiden lista eroteltuna pilkuilla",
"Apply content template" => "Liitä sisältö malli",
"Send objects" => "Lähetä kohteet",
"admin send objects tpl" => "ylläpidä lähetä kohteet tpl",
"Transmission results" => "Siirtojen tulokset",
"Send objects to this site" => "Lähetä kohteet tälle sivustolle",
"site" => "sivusto",
"password" => "salasana",
"Send Wiki Pages" => "Lähetä Wiki Sivut",
"Send Articles" => "Lähetä Artikkelit",
"add article" => "lisää artikkeli",
"sheets tpl" => "arkkien tpl",
"Create a sheet" => "Luo arkki",
"Edit this sheet:" => "Muokkaa tätä arkkia:",
"create new sheet" => "luo uusi arkki",
"There are individual permissions set for this sheet" => "Tälle arkille on erityisoikeudet",
"Class Name" => "Luokka Nimi",
"Header Rows" => "Pääosan Rivejä",
"Footer Rows" => "Alaosan Rivejä",
"Create new Sheet" => "Luo uusi Arkki",
"You can access the sheet using the following URL" => "Voit päästä arkille seuraamalla tätä URL",
"Available Sheets" => "Saatavilla olevat Arkit",
"Graph" => "Graafi",
"Tiki Shoutbox" => "Pikaviestitn",
"admin Tiki Shoutbox" => "ylläpidä Pikaviestintä",
"admin Tiki Shoutbox tpl" => "ylläpidä Pikaviestintä tpl",
"Change shoutbox general settings" => "Muuta pikaviestimen yleisiä asetuksia",
"auto-link urls" => "auto-link url:it",
"Post or edit a message" => "Lähetä tai muokkaa viestiä",
"first" => "ensimmäinen",
"big grin" => "iso hymy",
"confused" => "hämmentynyt",
"cool" => "siisti",
"cry" => "itku",
"evil" => "paha",
"redface" => "punakka",
"rolleyes" => "silmitys",
"smile" => "hymy",
"surprised" => "yllättynyt",
"twisted" => "kierto",
"arrow" => "nuoli",
"Most viewed objects" => "Eniten näytetyt kohteet",
"Most viewed objects in the last 7 days" => "Eniten näytetyt kohteet viimeisten 7 päivän aikana",
"Site Stats" => "Sivuston Tilastot",
"Days online" => "Päivää linjalla",
"Total pageviews" => "Sivunäytöt kaikkiaan",
"Average pageviews per day" => "Sivunäyttöjä keskimäärin päivässä",
"Best day" => "Paras päivä",
"pvs" => "snp",
"Worst day" => "Huonoin päivä",
"Wiki Stats" => "Wiki Tilastot",
"Size of Wiki Pages" => "Wiki Sivujen koko",
"Average page length" => "Keskimääräinen sivun pituus",
"Average versions per page" => "Versioita keskimäärin per sivu",
"Visits to wiki pages" => "Vierailut wikisivuilla",
"Average links per page" => "Linkkejä keskimäärin per sivu",
"Image galleries Stats" => "Kuva galleria Tilastot",
"Average images per gallery" => "Kuvia keskimäärin per galleria",
"Total size of images" => "Kuvien koko kaikkiaan",
"Average image size" => "Kuvien keskimääräinen koko",
"Visits to image galleries" => "Vierailuja kuva gallerioissa",
"File galleries Stats" => "Tiedosto galleria Tilastot",
"Average files per gallery" => "Tiedostoja keskimäärin per galleria",
"Total size of files" => "Tiedostojen koko kaikkiaan",
"Average file size" => "Tiedoston koko keskimäärin",
"Visits to file galleries" => "Vierailuja tiedosto gallerioissa",
"CMS Stats" => "CMS Tilastot",
"Total reads" => "Luettu kaikkiaan",
"Average reads per article" => "Lukijoita keskimäärin per artikkeli",
"Total articles size" => "Artikkelien koko kaikkiaan",
"Average article size" => "Artikkelin koko keskimäärin",
"Forum Stats" => "Foorumin Tilastot",
"Total topics" => "Aiheita kaikkiaan",
"Average topics per forums" => "Aiheita keskimäärin per foorumi",
"Total threads" => "Ketjuja kaikkiaan",
"Average threads per topic" => "Ketjuja keskimäärin per aihe",
"Visits to forums" => "Vierailuja foorumeilla",
"Blog Stats" => "Blogi Tilastot",
"Weblogs" => "Weblogit",
"Total posts" => "Lähetyksiä kaikkiaan",
"Average posts per weblog" => "Lähetyksiä keskimäärin per webblogi",
"Total size of blog posts" => "Blogi lähetysten koko kaikkiaan",
"Average posts size" => "Keskimääräinen lähetyksen koko",
"Visits to weblogs" => "Vierailua weblogeissa",
"Poll Stats" => "Äänestys Tilastot",
"Total votes" => "Ääniä kaikkiaan",
"Average votes per poll" => "Ääniä keskimäärin per äänestys",
"Faq Stats" => "Ukk Tilastot",
"Total questions" => "Kysymyksiä kaikkiaan",
"Average questions per FAQ" => "Kysymyksiä keskimäärin per UKK",
"User Stats" => "Käyttäjä Tilastot",
"User bookmarks" => "Käyttäjän kirjanmerkit",
"Average bookmarks per user" => "Kirjanmerkkejä keskimäärin per käyttäjä",
"Quiz Stats" => "Visailu Tilastot",
"Average questions per quiz" => "Kysymyksiä keskimäärin per visailu",
"Quizzes taken" => "Visailuja otettu",
"Average quiz score" => "Keskimääräinen visailu tilanne",
"Average time per quiz" => "Keskimääräinen aika per visailu",
"Object" => "Kohde",
"Usage chart" => "Kaavion käyttö",
"Usage chart image" => "Kaavio kuvan käyttö",
"Daily Usage" => "Päivittäinen Käyttö",
"Stats for surveys" => "Tutkimusten Tilasto",
"Survey" => "Tutkimukset",
"Last taken" => "Viimeksi otettu",
"Stats for survey" => "Tutkimuksen tilasto",
"Stats for this survey Questions " => "Tämän tutkimuksen kysymysten tilasto ",
"system logs" => "järjestelmä logit",
"system logs tpl" => "järjestelmä logit tpl",
"Time Left" => "Aikaa Jäljellä",
"send answers" => "lähetä vastaukset",
"Result" => "Tulos",
"Thank you for your submission" => "Kiitoksia ehdotuksestasi",
"Theme Control Center: categories" => "Teeman Hallinta Keskus: luokittelut",
"ThemeControl" => "TeemaHallinta",
"ThemeControl tpl" => "TeemaHallinta tpl",
"To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "Oppiaksesi lisää <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
"Theme is selected as follows" => "Teema on valittu seuraaviin",
"If a theme is assigned to the individual object that theme is used." => "Jos teema on liitetty teeman kohteita käytetään.",
"If not then if a theme is assigned to the object's category that theme is used" => "Jos ei niin kohteen luokittelun teemaa käytetään",
"If not then a theme for the section is used" => "Jos ei niin kohteen osaston teemaa käytetään",
"If none of the above was selected the user theme is used" => "Jos mitään näistä ei ole käytetään käyttäjän teemaa",
"Finally if the user didn't select a theme the default theme is used" => "Lopuksi jos mikään näistä ei täyty käytetään oletus teemaa",
"Control by Objects" => "Hallinta Kohteella",
"Control by Sections" => "Hallinta Osastolla",
"Assign themes to categories" => "Liitä teemaa luokkiin",
"Assigned categories" => "Liitetyt luokat",
"theme" => "teema",
"Theme Control Center: Objects" => "Teeman Hallinta Keskus: Kohteet",
"ThemeControl Objects" => "TeemaHallinta Kohteet",
"theme control objects tpl" => "teeman hallinta kohteet tpl",
"Control by Categories" => "Hallinta luokilla",
"Assign themes to objects" => "Liitä teema kohteille",
"Assigned objects" => "Liitetyt kohteet",
"Theme Control Center: sections" => "Teeman Hallinta Keskus: osastot",
"theme control sections tpl" => "teeman hallinta osastot tpl",
"Assign themes to sections" => "Liitä teema osastoihin",
"Assigned sections" => "Liitetyt osastot",
"Edit File:" => "Muokkaa Tiedostoa:",
"Upload File" => "Lähetä Tiedosto",
"File Title" => "Tiedosto Otsikko",
"Now enter the file URL" => "Kirjoita tiedoston URL",
" or upload a local file from your disk" => " tai lähetä oma tiedostosi kovalevyltäsi",
"Batch upload" => "Joukko lähetys",
"The following file was successfully uploaded" => "Seuraavat tiedostot onnistuneesti vastaanotettu",
"You can download this file using" => "Voit imuroida tiedoston käyttäen",
"You can include the file in an HTML/Tiki page using" => "Voit lisätä tiedoston HTML/normaali sivulle käyttäen",
"Image Gallery tpl" => "Kuva Galleria tpl",
"or use filename" => "tai käytä tiedostonimeä",
"Now enter the image URL" => "Kirjoita kuvan URL",
" or upload a local image from your disk" => " tai lähetä oma kuva kovalevyltäsi",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Minikuva (vaihtoehtoinen, ohittaa automaattisen minikuvan luonnin)",
"Note: Maximum image size is limited to" => "Huomaa: Suurin mahdollinen kuvankoko on",
"Upload successful!" => "Lähetys onnistui!",
"The following image was successfully uploaded" => "Seuraavat kuvat on onnistuneesti vastaanotettu",
"Thumbnail" => "Minikuva",
"Image ID thumb" => "Kuva ID mini",
"You can include the image in an Wiki page using" => "Voit lisätä kuvan sivulle käyttäen",
"User assigned modules" => "Käyttäjän liittämät moduulit",
"User Assigned Modules" => "Käyttäjän Liittämät Moduulit",
"User Assigned Modules tpl" => "Käyttäjän Liittämät Moduulit tpl",
"Restore defaults" => "Palauta oletukset",
"move to right column" => "siirrä oikeaan palstaan",
"unassign" => "poistaliitos",
"move to left column" => "siirrä vasempaan palstaan",
"Assign module" => "Liitä moduuli",
"Module" => "Moduuli",
"Column" => "Palsta",
"User Bookmarks tpl" => "Käyttäjän Kirjanmerkki tpl",
"Current folder" => "Nykyinen kansio",
"Folders" => "Kansiot",
"Folder in" => "Kansio",
"remove folder" => "poista kansio",
"refresh cache" => "päivitä puskuri",
"Admin folders and bookmarks" => "Ylläpidö kansioita ja kirjanmerkkejä",
"Add or edit folder" => "Lisää tai muokka kansiota",
"Add or edit a URL" => "Lisää tai muokkaa URL:ia",
"Avatar" => "Hahmo",
"Homepage" => "EtuSivu",
"Users HomePage" => "Käyttäjän EtuSivu",
"Personal Wiki Page" => "Henkilökohtainen Sivu",
"Create page" => "Luo sivu",
"Displayed time zone" => "Näytä aika vyöhyke",
"This user is your friend" => "Tämä käyttäjä on ystävä",
"Request friendship from this user" => "Pyydä ystävyyttä tältä käyttäjältä",
"Send me a message" => "Lähetä minulle viesti",
"Toggle options" => "Nappula vaihtoehdot",
"Toggle" => "Nappurla",
"User Preferences" => "Käyttäjä Kokoonpanot",
"UserPreferences tpl" => "KäyttäjäKokoonpanot tpl",
"Personal Information" => "Henkilökohtaiset Tiedot",
"General preferences" => "Yleiset asetukset",
"Other preferences" => "Muut asetukset",
"Pick user Avatar" => "Ota käyttäjä Hahmo",
"HomePage" => "EtuSivu",
"Your personal Wiki Page" => "Henkilökohtainen Sivusi",
"Your personal tracker information" => "Henkilökohtaiset kortistotiedot",
"View extra information" => "Näytä lisätiedot",
"Change information" => "Muuta tietoja",
"Is email public? (uses scrambling to prevent spam)" => "Onko sähköposti julkinen? (käytä sekoitusta roskapostin estoon)",
"Unavailable - please set your e-mail below" => "EiSaatavilla - anna sähköpostiosoite alle",
"Does your mail reader need a special charset" => "Tarvitseeko postiohjelmasi erikois merkistöä",
"Number of visited pages to remember" => "Muistettavien sivujen määrä",
"Local" => "Paikallinen",
"User information" => "Käyttäjä tiedot",
"private" => "yksityinen",
"public" => "julkinen",
"Use double-click to edit pages" => "Käytä kaksoisklikkausta muokataksesi",
"Account Information" => "Tili Tiedot",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Jätä \"Uusi salasana\" ja \"Toista uusi salasana\" kentät tyhjiksi säilyttääksesi nykyinen salasanasi",
"Email address" => "Sähköposti osoite",
"Confirm new password" => "Toista uusi salasana",
"Current password (required)" => "Nykyinen salasana (pakollinen)",
"Change administrative info" => "Muuta ylläpidollista tietoa",
"Messages per page" => "Viestejä per sivu",
"Allow messages from other users" => "Salli viestit muilta käyttäjiltä",
"Note author when reading his mail" => "Ilmoita kirjoittajalle kun hänen viestiään luetaan",
"Send me an email for messages with priority equal or greater than" => "Lähetä minulle sähköpostia viesteistä joiden ensisijaisuus on sama tai suurempi kuin",
"Auto-archive read messages after x days" => "Auto-arkistoi luetut viestit x päivän jälkeen",
"Tasks per page" => "Tehtäviä per sivu",
"My messages" => "Omat viestit",
"My workflow" => "Oma työvuo",
"User Tasks tpl" => "Käyttäjä Tehtävät tpl",
"New task" => "Uusi tehtävä",
"Task list" => "Tehtävä lista",
"Admin mode off" => "Ylläpito pois",
"Admin mode on" => "Ylläpito päällä",
"Task help" => "Tehtävä apu",
"Received task" => "Vastaanotettu tehtävä",
"You received this task, please read and execute it" => "Olet vastaanottanut tämän tehtävän, lue ja tee se",
"Send task" => "Lähetä tehtävä",
"You send this task to a other user" => "Lähetit tämän tehtävän toiselle käyttäjälle",
"Shared task" => "Jaettu tehtävä",
"This task is public to a special group" => "Tämä tehtävä on julkinen määrätylle ryhmälle",
"accepted by task user and creator" => "hyväksytty tehtävän tekijän ja luojan puolesta",
"accepted user and creator" => "hyväksytyt käyttäjä ja luoja",
"Task is accepted by user and creator" => "Tehtävä on hyväksytty sekä käyttäjän että luojan puolesta",
"not accepted by one user" => "yksi käyttäjä ei ole hyväksynyt",
"not accepted user" => "ei hyväksyntää käyttäjä",
"Task is rejected by one user" => "Yksi käyttäjä on hylännyt tehtävän",
"waiting for me" => "odottaa minua",
"Task is not accepted by you, read the task and accept or reject it" => "Et ole hyväksynyt tehtävää, lue tehtävä ja hyväksy tai hylkää se",
"waiting for other user" => "odottaa muita käyttäjiä",
"Task is not accepted/rejected by other user" => "Muut käyttäjät eivä ole hyväksyneet/hylänneet tehtävää",
"admin mode" => "ylläpidollinen",
"trash" => "roskis",
"empty trash" => "tyhjennä roskis",
"Edit task" => "Muokkaa tehtävää",
"red" => "punainen",
"NOT accept" => "EI hyväksytty",
"remove from trash" => "poista roskiksesta",
"move into trash" => "siirrä roskikseen",
"Task saved" => "Tehtävä tallennettu",
"Edit Task" => "Muokka Tehtävää",
"View Task" => "Näytä Tehtävä",
"Open a new task" => "Avaa uusi tehtävä",
"taskId" => "tehtäväId",
"Task user" => "Tehtävän käyttäjä",
"Only the creator can delete this task" => "Vain tehtävän luoja voi sen poistaa",
"use start date and time" => "käytä aloituspäivää ja aikaa",
"use end date and time" => "käytä lopetuspäivää ja aikaa",
"open / in process" => "avaa / menetelmään",
"waiting / not started" => "odottaa / ei käynnistetty",
"Percentage completed" => "Valmistuminen prosentteina",
"waiting" => "odottaa",
"shared for group" => "jaettu ryhmälle",
"accepted by user" => "hyväksynyt käyttäjä",
"no / rejected" => "ei / hylätty",
"accepted by creator" => "hyväksynyt luojana",
"This message will be send to users if you are makeing changes of assigned tasks" => "Tämä viesti lähetetään käyttäjille jos teet muutoksia annettuihin tehtäviin",
"Send message with changes" => "Lähetä viesti ja muutokset",
"Modified by" => "Muokkaajana",
"Marked as deleted" => "Merkitty poistetuksi",
"Inform task user by email" => "Tiedota tehtävän käyttäjää sähköpostilla",
"You can only view this task" => "Voit katsoa vain tätä tehtävää",
"priority" => "ensisijaisuus",
"No tasks entered" => "Ei lisättyjä tehtäviä",
"select one" => "valitse yksi",
"undo trash" => "peruuta roskis",
"show:" => "näytä:",
"received" => "vastaanotettu",
"submitted" => "lähetetty",
"shared" => "jaettu",
"all shared tasks" => "kaikki jaetut tehtävät",
"completed (100%)" => "valmis (100%)",
"Public for group" => "Julkaistu ryhmälle",
"User Watches tpl" => "Käyttäjä Vahdit tpl",
"Add Watch" => "Lisää Vahti",
"A user submits a blog post" => "Käyttäjä ehdottaa bloki lähetystä",
"A user posts a forum thread" => "Käyttäjä lähetti foorumi ketjun",
"A user posts a forum topic" => "Käyttäjä lähetti foorumin aiheen",
"A user edited a wiki page" => "Käyttäjä muokkasi sivuston sivua",
"edit user files" => "muokkaa käyttäjä tiedostoja",
"May need to refresh twice to see changes" => "Saattaa tarvita kaksi päivitystä nähdäksesi muutoksen",
"Add top level bookmarks to menu" => "Lisää ylimmän tason kirjanmerkki valikkoon",
"Mode" => "Moodi",
"replace window" => "korvaa ikkuna",
"User_versions_for" => "Käyttäjä_versio",
"Insert Row" => "Lisää Rivi",
"Insert Column" => "Lisää Palsta",
"Remove Row" => "Poista Rivi",
"Remove Column" => "Poista Palsta",
"Merge Cells" => "Yhdistä Kennot",
"Restore Cells" => "Palauta Kennot",
"Copy Calculation" => "Kopio Kaava",
"Format Cell" => "Kennon Muoto",
"Before" => "Ennen",
"After" => "Jälkeen",
"expires:" => "sulkeutuu:",
"no comments" => "ei kommentteja",
"Banner stats" => "Banneri tilastot",
"Create new banner" => "Luo uusi banneri",
"Banner Information" => "Bannerin Tiedot",
"Click ratio" => "Paina suhde",
"Weekdays" => "Viikopäivät",
"mon" => "maa",
"tue" => "tii",
"wed" => "kes",
"thu" => "tor",
"fri" => "per",
"sat" => "lau",
"Banner raw data" => "Bannerin raaka data",
"Cached" => "Puskuroitu",
"This is a cached version of the page." => "Tämä on puskuroitu versio sivusta.",
"Click here to view the Google cache of the page instead." => "Paina tästä nähdäksesi Googlen puskuroiman version sivusta.",
"viewed" => "näytetty",
"edit items" => "muokkaa osia",
"list charts" => "listaa kaaviot",
"last chart" => "viimeisin kaavio",
"previous chart" => "edellinen kaavio",
"Chart created" => "Kaavio luotu",
"next chart" => "seuraava kaavio",
"pos" => "paik",
"pre" => "edel",
"permanency" => "pysyvyys",
"item" => "osa",
"chg" => "muuta",
"avg" => "keskim",
"info/vote" => "tieto/ääni",
"Next chart will be generated on" => "Seuraava kaavio muodostetaan",
"View or vote items not listed in the chart" => "Katso tai äänestä osia joita ei ole kaaviossa",
"Select something to vote on" => "Valitse jotakin äänestettävää",
"Item information" => "Osan tiedot",
"Chart" => "Kaavio",
"Permanency" => "Pysyvä",
"Dif" => "Erot",
"Best Position" => "Paras Sijainti",
"Vote this item" => "Äänestä tätä osaa",
"Highest" => "Korkein",
"view faq" => "näytä ukk",
"view faq tpl" => "näytä ukk tpl",
"admin menus tpl" => "ylläpidä valikoiden tpl",
"Answers" => "Vastaukset",
"Q" => "K",
"A" => "V",
"add suggestion" => "lisää ehdotus",
"1 suggestion" => "1 ehdotus",
"suggestions" => "ehdotusta",
"Forum List" => "Foorumin Lista",
"Edit Forum" => "Muokkaa Foorumia",
"monitor this forum" => "tarkkaile tätä foorumia",
"stop monitoring this forum" => "lopeta tämän foorumin tarkkailu",
"You have {\$unread} unread private messages" => "Sinulla on {\$unread} lukematonta yksityisviestiä",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Viestisi on laitettu jonoon hyväksyntää varten, viesti lähtetetään kun \na ylläpito hyväksyy sen.",
"You have to enter a title and text" => "Kirjoita otsikko ja teksti",
"post new comment" => "lähetä uusi kommentti",
"Summary" => "Yhteenveto",
"HTML tags are not allowed inside comments" => "HTML tagit eivät ole sallittuja kommenteissa",
"moderator actions" => "moderaattorin toiminnot",
"move selected topics" => "siirrä valitut aiheet",
"unlock selected topics" => "avaa valitut aiheet",
"lock selected topics" => "lukitse valitut aiheet",
"delete selected topics" => "poista valitut aiheet",
"merge" => "yhdistä",
"merge selected topics" => "yhdistä valitut aiheet",
"reported messages:" => "raportoidut viestit:",
"queued messages:" => "Viestit jonossa:",
"Merge into topic" => "Yhdistä aiheeseen",
"emot" => "tunt",
"pts" => "pist",
"No topics yet" => "Ei aiheita vielä",
"topics in this forum" => "Tämän foorumin aiheet",
"Show posts" => "Näytä lähetykset",
"Last hour" => "Viime tunti",
"Last 24 hours" => "Viimeiset 24 tuntia",
"Last 48 hours" => "Viimeiset 48 tuntia",
"Jump to forum" => "Hyppää foorumille",
" unread private messages" => " lukematonta yksityisviestiä",
"prev topic" => "edel aihe",
"next topic" => "seur aihe",
"posts:" => "lähetyksiä:",
"monitor this topic" => "tarkkaile tätä aihetta",
"stop monitoring this topic" => "lopeta tämän aiheen tarkkailu",
"Comments below your current threshold" => "Kommentit nykyisen kynnyksen alta",
"IRC log" => "IRC logi",
"Select" => "Valitse",
"Show All" => "Näytä Kaikki",
"Edit fields" => "Muuta kenttiä",
"Insert new item" => "Liitä uusi osa",
" item found" => " osa löytynyt",
" items found" => " osaa löytynyt",
"list attachments" => "listaa liitteet",
"View inserted item" => "Näytä lisätty osa",
"fields marked with a * are mandatory" => "kentät jotka on merkitty * ovat pakollisia",
"Tracker item:" => "Kortisto osa:",
"View item" => "Näytä osa",
"Filter Tracker Items" => "Suodata Kortisto osia",
"Add a comment" => "Lisää kommentti",
"Attach a file to this item" => "Liitä tiedosto tähän osaan",
"more info" => "lisä info",
"No attachments for this item" => "Ei liitteitteitä tähän osaan",
"remove image" => "poista kuva",
"Special Operations" => "Erikois Menetelmät",
"Details" => "Yksityiskohdat",
"Webmail Doc" => "Verkkoposti Doc",
"Webmail Doc template" => "Verkkoposti Doc malli",
"settings" => "asetukset",
"mailbox" => "postilaatikko",
"compose" => "muodosta",
"contacts" => "yhteydet",
"Contacts" => "Yhteydet",
"Edit mail account" => "Muokkaa postitiliä",
"Add new mail account" => "Lisää uusi postitili",
"User accounts" => "Käyttäjä tilit",
"account" => "tili",
"View All" => "Näytä Kaikki",
"Msg" => "Viesti",
"clip" => "pala",
"back to mailbox" => "takaisin postilaatikkoon",
"full headers" => "täydet pääosat",
"normal headers" => "tavalliset pääosat",
"reply all" => "vastaa kaikille",
"forward" => "lähetä edelleen",
"Create/edit contacts" => "Luo/muokkaa yhteyksiä",
"First Name" => "Etu Nimi",
"Last Name" => "SukuNimi",
"select from address book" => "valitse osoitekirjasta",
"cc" => "kopio",
"bcc" => "varmuuskopio",
"Use HTML mail" => "Käytä HTML lähetystä",
"The following addresses are not in your address book" => "Seuraava osoite ei ole osoitekirjassa",
"add contacts" => "lisää yhtyeksiin",
"Attachment 1" => "Liite 1",
"Attachment 2" => "Liite 2",
"Attachment 3" => "Liite 3",
"Address book" => "Osoite kirja",
"%s enabled" => "%s päälle",
"%s disabled" => "%s poispäältä",
"Enable/disable Tiki features here, but configure them elsewhere" => "Aseta Tikin ominaisuudet päälle/poispäältä täällä, mutta muokkaa ominaisuutta muualla",
"General preferences and settings" => "Yleiset oikeudet ja asetukset",
"User registration, login and authentication" => "Käyttäjän rekisteröinti, kirjaus ja varmistus",
"Wiki settings" => "WAsetukset",
"Wiki Attachments" => "Sivusto Liitteet",
"Article/CMS settings" => "Artikkeli/CMS asetukset",
"Poll comments settings" => "Äänestys kommenttien asetukset",
"Configuration options for all blogs on your site" => "Kokoonpano vaihtoehdot sivuston kaikille blogeille",
"Forums settings" => "Foorumin asetukset",
"FAQ comments settings" => "UKK kommenttien asetukset",
"Trackers settings" => "Kortiston asetukset",
"RSS settings" => "RSS asetukset",
"Directory settings" => "Hakemisto asetukset",
"Maps configuration" => "Karttojen kokoonpano",
"Meta Tags settings" => "Meta Tagien asetukset",
"Search settings" => "Etsintä asetukset",
"Score settings" => "Piste asetukset",
"Projects" => "Projektit",
"Projects configuration" => "Projektien kokoonpano",
"Community settings" => "Yhteisö asetukset",
"Site Identity features" => "Sivusto Yksilöinti ominaisuus",
"Calendar settings" => "Kalenteri asetukset",
"Intertiki settings" => "Intertiki asetukset",
"Help on \$admintitle Config" => "Auta \$ylläpitoaiheen asetuksessa",
"Click here to delete this category" => "Paina tästä poistaaksei tämäm luokan",
"Category can`t be parent of itself" => "Luokka ei voi olla itsensä isäntä",
"No chart indicated" => "Ei kaaviota osoitettu",
"Upload failed" => "Lähetys epäonnistui",
"You have to provide a hotword and a URL" => "Sinun on osoitettava hotword ja URL",
"No page indicated" => "Ei sivua osoitettu",
"Detected, Version:" => "Löydetty, Versio:",
"Not detected." => "Ei löytynyt.",
"The passwords don't match" => "Salasana ei kelpaa",
"You cannot have a blank password" => "Salasana ei voi olla tyhjä",
"Password should be at least" => "Salasanan oltava vähintään",
"characters long" => "merkkiä pitkä",
"Your admin password has been changed" => "Admin salasanasi on vaihdettu",
"DATE-of" => "PÄIVÄYS",
"All Fields except gdaltindex must be filled" => "Kaikki kentät paitsi gdaltindex on täytettävä",
"No valid gdaltindex executable" => "Ei oikea gdaltindex ohjelma",
"You cannot mix old and new trackers" => "Et voi sekoittaa uusia ja vanhoja kortistoja",
"Tag already exists" => "Lisäys on jo olemassa",
"Tag not found" => "Lisäystä ei löydy",
"Repository name can't be an empty" => "Säilytyspaikan nimi ei voi olla tyhjä",
"Requested action is not supported on repository" => "Pyydetty toiminto ei ole tuettu säilytyspaikalle",
"No repository" => "Ei säilytyspaikkaa",
"Search is mandatory field" => "Etsintäkenttä on pakollinen",
"File not found " => "Tiedostoa ei löydy ",
"Requested action in not supported on repository" => "Pyydetty toiminto ei ole tuettu säilytyspaikalle",
"Non-existent link" => "Olematon linkki",
"Mail-in account %s incorrect" => "Posti-sisään tili %s väärä",
"Mail-in account %s saved" => "Posti-sisään tili %s tallennettu",
"Frequency should be a positive integer!" => "Muutosväli on oltava positiivinen kokonaisluku!",
"Mail-in accounts set to be checked every %s minutes" => "Postit-sisään tilit tarkistetaan joka %s minuutti",
"Automatic Mail-in accounts checking disabled" => "Automaattinen postit-sisään tilien tarkistus pois päältä",
"No menu indicated" => "Ei valikkoa osoitettu",
"No newsletter indicated" => "Ei uutislehteä osoitettu",
"No poll indicated" => "Ei äänestystä osoitettu",
"unsafe" => "turvaton",
"register_globals should be off by default. See the php manual for details." => "register_globals pitää olla pois päältä oletuksena. Katso php:n käsikirjasta tarkemmin.",
"safe" => "turvallinen",
"session.use_trans_sid should be off by default. See the php manual for details." => "istunnon.use_trans_sid pitää olla pois päältä oletuksena. Katso php:n käsikirjasta tarkemmin.",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir on sivustohakemiston sisällä. On olemassa vaara, että joku voi lähettää minkätahansa tiedoston sinne ja päästä sinne selaimella",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "ei voi tarkistaa onko upload_tmp_dir selattavissa selaimella. Ollaksesi varma tarkista palvelimen asetukset.",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "asetus xbithack ei ole turvallinen. Riippuen tiedoston käsittelystä palvelimella ja sivuston asetuksista, saattaa hyökkääjä voida lähettää tiedoston galleriaan ja käynnistää se sieltä",
"risky" => "riski",
"allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen mahdollistaa ohjelmien ja skripitien lähetyksen. Jos blogit eivät ole käytössä, voit ottaa sen pois päältä.",
"The Path to store files in the filegallery should be outside the tiki root directory" => "Tiedostojen tallennuspolku on oltava sivuston juuren ulkopuolella",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "Kuvien tallennuspolku on oltava sivuston juuren ulkopuolella",
"The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "Ominaisuus \"Muuta Malleja\" on päällä. Älä anna kenenkään johon et varmasti luota käyttää tätä. Sitä voi helposti käyttää ajamaan php koodia.",
"installed" => "asennettu",
"The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => " \"Snarf plugi\" on asennettu. Sitä voi ylläpito käyttää sisällyttämään sivuja paikallisesta verkosta ja regex korvaukseen mistätahansa html:stä.",
"The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => " \"Regex plugi\" on asennettu. Sitä voi ylläpito käyttää minkätahansa html:n regex korvaamiseen.",
"The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => " \"Lsdir plugi\" on asennettu. Sitä voi ylläpito käyttää katsoakseen minkätahansa hakemiston sisältöä",
"The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => " \"Bloglist plugi\" on asennettu. Sitä voi ylläpito käyttää avaamaan yksityis blogin postia.",
"Path disclosure" => "Polun näyttäminen",
"Path disclosure through error message" => "Polku näytetään virheviestissä",
"SQL injection" => "SQL lisäys",
"SQL injection by authenticated user" => "SQL lisäys varmistetulta käyttäjältä",
"SQL injection by authenticated user with special privileges" => "SQL lisäys varmistetulta käyttäjältä, jolla on erikoisoikeudet",
"SQL injection without authentication" => "SQL lisäys ilman varmistusta",
"PHP command injection" => "PHP komentolisäys",
"PHP command injection by authenticated user" => "PHP komentolisäys varmistetulta käyttäjältä",
"PHP command injection by authenticated user with special privileges" => "PHP komentolisäys varmistetulta käyttäjältä, jolla on erikoisoikeudet",
"PHP command injection without authentication" => "PHP komentolisäys ilman varmistusta",
"File upload" => "Tiedosto lähetys",
"File is not readable. Unable to check." => "Tiedosto ei ole luettavissa. Ei voi tarkistaa.",
"This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "Tämä ei ole normaali tiedosto. Tarkista onko tiedosto lähetetty, jos niin saattaa olla vaaraksi.",
"This is a modified File. Cannot check version. Check if it is dangerous." => "Tätä Tiedostoa on muokattu. Ei voi tarkistaa versiota. Tarkista onko vaaraksi.",
"This file is from another Tikiwiki version: " => "Tämä tiedosto on sivustoversiosta: ",
" or " => " tai ",
"You have to provide a word" => "Sinun on annettava sana",
"You must specify a page name, it will be created if it doesn't exist." => "Sinun on annettava sivulle nimi, jos sitä ei ole ennestään se luodaan.",
"page not added (Exists)" => "sivua ei lisätty (On olemassa)",
"No survey indicated" => "Ei tutkimusta osoitettu",
"You don't have permission to use this feature" => "Oikeutesi eivät riitä käyttämään tätä ominaisuutta",
"No Errors detected" => "Virheitä Ei havaittu",
"No tracker indicated" => "Ei kortistoa osoitettu",
"Group already exists" => "Ryhmä on jo olemassa",
"No records were found. Check the file please!" => "Tallennusta ei löytynyt. Tarkista tiedosto!",
"User login is required" => "Tarvitaan kirjautuminen",
"Password is required" => "Tarvitaan salasana",
"Email is required" => "Tarvitaan sähköpostiosoite",
"User is duplicated" => "Käyttäjä on kopioitu",
"Created account %s <%s>" => "Luotu tili %s <%s>",
"Assigned %s in group %s" => "Liitetty %s ryhmään %s",
"User %s already exists" => "Käyttäjä %s on jo olemassa",
"New %s created with %s %s." => "Uusi %s luotu jolla on %s %s.",
"Impossible to create new %s with %s %s." => "Mahdotonta luoda uutta %s jolla on %s %s.",
"%s %s successfully deleted." => "%s %s on onnistuneesti poistettu.",
"%s %s removed from %s %s." => "%s %s poistettu %s %s.",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> on onnistuneesti poistettu.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> liitetty %s <b>%s</b>.",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> poistettu %s <b>%s</b>.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "ryhmä <b>%s</b> on asetettu oletusryhmäksi käyttäjälle <b>%s</b>.",
"User already exists" => "Käyttäjä on jo olemassa",
"The passwords dont match" => "Salasana ei kelpaa",
"Password must contain both letters and numbers" => "Salasanaan käytettävä sekä kirjaimia että numeroita",
"%s modified successfully." => "%s on muutettu onnistuneesti.",
"%s modification failed." => "%s muutos ei onnistunut.",
"%s changed from %s to %s" => "%s vaihdettu %s  %s",
"Impossible to change %s from %s to %s" => "Mahdotonta vaihtaa %s  %s  %s",
"rss feed disabled" => "rss syöte poistettu",
"Permission denied you cannot view this section" => "Ei oikeutta katsoa tätä osastoa",
"Tiki RSS feed for articles" => "RSS artikkelien syöte",
"Last articles." => "Viimeiset artikkelit.",
"Unknown group" => "Tuntematon ryhmä",
"Group doesnt exist" => "Ryhmää ei ole olemassa",
"Unknown user" => "Tuntematon käyttäjä",
"User doesnt exist" => "Käyttäjää ei ole olemassa",
"You have to indicate a group" => "On osoitettava ryhmä",
"This group is invalid" => "Tämä ryhmä on väärä",
"Permission denied you cannot view backlinks for this page" => "Oikeutesi eivät riitä paluulinkkien katsomiseen tältä sivulta",
"The page cannot be found" => "Sivua ei löydy",
"Image Galleries Admin Panel" => "Kuva Gallerioiden Ylläpito Paneeli",
"Could not read image %s." => "Kuvaa %s ei voi lukea.",
"Image %s upload failed." => "Kuvan %s lähetys epäonnistui.",
"Image %s uploaded successfully." => "Kuvan %s lähetys onnistui.",
"Image %s removed from Batch directory." => "Kuva %s on poistettu ryhmälähetys hakemistosta.",
"Impossible to remove image %s from Batch directory." => "Mahdotonta poistaa kuvaa %s ryhmälähetys hakemistosta.",
"Permission denied you cannot use the batch directory loading" => "Sinulla ei ole oikeutta käyttää ryhmälähetys hakemisto latausta",
"Incorrect directory chosen for batch upload of images." => "Väärä hakemisto valittu kuvien ryhmälähetystä varten.",
"Please setup that dir on " => "Tee hakemisto asetukset ",
"Please contact the website administrator." => "Ota yhteyttä sivuston ylläpitoon.",
"Invalid directory name" => "Väärä hakemiston nimi",
"Permission denied you cannot post" => "Oikeutesi eivät riitä lähettämiseen",
"Permission denied you cannot edit this post" => "Oikeutesi eivät riitä lähetyksen muokkamiseen",
"You can't post in any blog maybe you have to create a blog first" => "Et voi lähettää mihinkään blogiin, ehkä sinun on luotava blogi ensin",
"Top visited blogs" => "Eniten katsotut blogit",
"Last posts" => "Viimeiset lähetykset",
"Top active blogs" => "Aktiivisimmat blogit",
"No blogId specified" => "Ei blogId tarkennusta",
"Tiki RSS feed for blog: " => "RSS syöte blogille: ",
"Tiki RSS feed for weblogs" => "RSS syöte verkkoblogeille",
"Last posts to weblogs." => "Viimeiset lähetykset verkkoblogeihin.",
"Permission denied you cannot access this gallery" => "Oikeutesi eivät riitä tähän galleriaan",
"No gallery indicated" => "Ei galleriaa osoitettu",
"Please login" => "Ole Hyvä ja kirjaudu",
"Permission denied you cannot view this page" => "Oikeutesi eivät riitä katsomaan tätä sivua",
"Permission denied you can not view this section" => "Oikeutesi eivät riitä katsomaan tätä osastoa",
"Permission denied you cannot remove images from this gallery" => "Oikeutesi eivät riitä poistamaan kuvia tästä galleriasta",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Oikeutesi eivät riitä tekemään minikuvia tästä galleriasta",
"Permission denied you cannot rotate images in this gallery" => "Oikeutesi eivät riitä kääntämään kuvia tässä galleriassa",
"No image indicated" => "Ei kuvaa osoitettu",
"Permission denied you cannot move images from this gallery" => "Oikeutesi eivät riitä siirtämään kuvia tästä galleriasta",
"Permission denied you cannot view the calendar" => "Oikeutesi eivät riitä katsomaan kalenteria",
"event without name" => "nimetön tapahtuma",
"First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "Viikon ensimmäinen päivä: Sunnuntai (sen ID on 0) - kääntäjät muuttakaa paikalliseksi!",
"Access Denied" => "Pääsy Estetty",
"Tiki RSS feed for calendars" => "RSS syöte kalentereille",
"Upcoming events." => "Tulossa olevat tapahtumat.",
"Start:" => "Aloitus:",
"End:" => "Lopetus:",
"No category indicated" => "Ei luokkaa osoitettu",
"Permission denied; you cannot assign permissions for this category" => "Lupa evätty; et voi antaa oikeuksia tälle luokalle",
"The passwords didn't match" => "Salasana ei täsmää",
"You can not use the same password again" => "Et voi käyttää samaa salasanaa uudelleen",
"Invalid old password" => "Väärä vanha salasana",
"Permission denied to use this feature" => "Oikeutesi eivät riitä käyttämään tätä ominaisuutta",
"No channel indicated" => "Ei kanavaa osoitettu",
"No nickname indicated" => "Ei lempinimeä osoitettu",
"Top authors" => "Top kirjoittajat",
"ERROR: you must include a subject or a message at least" => "VIRHE: otsikko on oltava tai viesti vähintään",
"Message sent to" => "Viesti lähetetty",
"You need to change chmod 'whelp' manually to 777" => "Sinun muutettava chmod 'whelp' oikeudet käsin 777",
"This feature has been disabled" => "Tämä ominaisuus poistettu",
"Tiki RSS feed for directory sites" => "RSS syöte hakemisto sivustoille",
"Last sites." => "Viimeiset sivustot.",
"Must enter a name to add a site. " => "Annettava nimi lisätäksesi sivuston. ",
"Must enter a url to add a site. " => "Annettava url lisätäksesi sivuston. ",
"URL already added to the directory. Duplicate site? " => "URL on jo hakemistossa. Kopio sivusto? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL osoite ei toimi URL on väärin tai sivusto ei ole verkossa eikä sitä voi lisätä hakemistoon. ",
"Must select a category. " => "On valittava luokittelu. ",
"Must enter a name to add a site" => "Annettava nimi lisätäksesi sivuston",
"Must enter a url to add a site" => "Annettava url lisätäksesi sivuston",
"URL already added to the directory. Duplicate site?" => "URL on jo olemassa. Kopioidaanko sivusto?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL osoite ei toimi URL on väärin tai sivusto ei ole verkossa eikä sitä voi lisätä hakemistoon",
"Must select a category" => "On valittava luokittelu",
"No site indicated" => "Ei sivustoa osoitettu",
"No parent specified" => "Ei isäntää",
"Last sites of directory \".\$rc[\"name\"].\" ." => "Viimeiset sivustot hakemistossa \".\$rc[\"nimi\"].\" .",
"You can not download files" => "Et voi imuroida tiedostoja",
"Permission denied you cannot edit this article" => "Oikeutesi eivät riitä tämän artikkelin muokkaamiseen",
"The language can't be changed as its set of translations has already this language" => "Kieltä ei voi muuttaa, koska sen niminen on jo kieli hakemistossa",
"You do not have permissions to edit banners" => "Oikeutesi eivät riitä bannerien muokkaamiseen",
"Banner not found" => "Banneria ei löydy",
"You do not have permission to edit this banner" => "Oikeutesi eivät riitä tämän bannerin muokkaamiseen",
"Permission denied you cannot create or edit blogs" => "Oikeutesi eivät riitä blogien luomiseen tai muokkaamiseen",
"Permission denied you cannot edit this blog" => "Oikeutesi eivät riitä tämän blogin muokkaamiseen",
"You do not have permission to write the style sheet" => "Oikeutesi eivät riitä tyylitiedoston kirjoittamiseen",
"Invalid request to edit an image" => "Väärä pyyntö muokataksesi kuvaa",
"Permission denied you cannot edit images" => "Oikeutesi eivät riitä kuvan muokkaamiseen",
"Permission denied you can edit images but not in this gallery" => "Oikeutesi riittävät kuvan muokkaamiseen, muttei tässä galleriassa",
"Failed to edit the image" => "Kuvan muokkaus epäonnistui",
"Shortname must be 2 Characters" => "Lyhenne pitää olla 2 merkkiä",
"You must provide a longname" => "Tarjottava pitempi nimi",
"Language created" => "Kieli luotu",
"No content id indicated" => "Ei sisältö id:tä osoitettu",
"No question indicated" => "Ei kysymystä osoitettu",
"No quiz indicated" => "Ei visailua osoitettu",
"No structure indicated" => "Ei rakennetta osoitettu",
"Invalid structure_id or page_ref_id" => "Väärä rakenne_id tai sivu_ref_id",
"Permission denied you cannot send submissions" => "Oikeutesi eivät riitä ehdotuksen lähettämiseen",
"Permission denied you cannot edit submissions" => "Oikeutesi eivät riitä ehdotuksen muokkaamiseen",
"You have to create a topic first" => "On luotava ensin aihe",
"You do not have permission to do that" => "Oikeutesi eivät riitä siihen",
"You do not have permission to write the template:" => "Sinulla ei ole oikeutta kirjoittaa mallia:",
"You do not have permission to read the template" => "Oikeutesi eivät riitä lukemaan mallia",
"No topic id specified" => "Ei aihe id:tä määritelty",
"Invalid topic id specified" => "Väärä aiha id määritelty",
"No object indicated" => "Ei kohdetta osoitettu",
"No type indicated" => "Ei tyyppiä osoitettu",
"Article not found" => "Artikkelia ei löytynyt",
"Permission denied you cannot edit this page" => "Oikeutesi eivät riitä tämän sivun muokkaamiseen",
"page imported" => "sivu tuotu",
"created from import" => "luotu tuodusta",
"You have mistyped the anti-bot verification code; please try again." => "Sinulla on kirjoitusvirhe anti-bot varmistus koodissa; yritä uudelleen.",
"Can't import remote HTML page" => "Ei voi tuoda ulkoista HTML sivua",
"Can't parse remote HTML page" => "Ei voi jäsentää ulkoista HTML sivua",
"You cannot edit this page because it is a user personal page" => "Et voi muokata tätä sivua, koska se on käyttäjän oma sivu",
"The SandBox is disabled" => "Hiekkaloota poistettu",
"Cannot edit page because it is locked" => "Et voi muokata tätä sivua, koska se on lukittu",
"unknown error" => "tuntematon virhe",
"cannot be found" => "ei löydy",
"No permission to view the page" => "Ei oikeutta katsoa sivua",
"No questions group indicated" => "Ei kysymysten ryhmää osoitettu",
"Permission denied you cannot create galleries and so you cant edit them" => "Oikeutesi eivät riitä gallerian luomiseen,joten et voi myöskään muokata",
"Permission denied you cannot edit this gallery" => "Oikeutesi eivät riitä gallerian muokkaamiseen",
"Permission denied you cannot remove this gallery" => "Oikeutesi eivät riitä gallerian poistamiseen",
"Top visited file galleries" => "Katsotuimmat tiedosto galleriat",
"Most downloaded files" => "Imuroiduimmat tiedostot",
"Last files" => "Viimeiset tiedostot",
"Tiki RSS feed for file galleries" => "RSS syöte tiedosto gallerioille",
"Last files uploaded to the file galleries." => "Viimeksi lähetetyt tiedostot tiedostogallerioissa.",
"No galleryId specified" => "Ei galleriaId tarkennusta",
"Tiki RSS feed for the file gallery: " => "RSS syöte tiedostogallerialle: ",
"No forum indicated" => "Ei foorumia osoitettu",
"Forum posts" => "Foorumi lähetykset",
"No forumId specified" => "Ei foorumiId tarkennusta",
"Tiki RSS feed for forum: " => "RSS syöte foorumille: ",
"Tiki RSS feed for forums" => "RSS syöte foorumeille",
"Last topics in forums." => "Viimeiset foorumien aiheet.",
"Accepted friendship request from %s" => "Hyväksytty ystävyyspyyntö %s :lta",
"Refused friendship request from %s" => "Hylätty ystävyyspyyntö from %s :lta",
"Broke friendship with %s" => "Riko ystävyys %s :n",
"I have broken our friendship!" => "Olen rikkonut ystävyytemme!",
"You must be logged in to use this feature" => "Sinun on kirjauduttava sisään käyttääksesi tätä ominaisuutta",
"Friendship request sent to %s" => "Ystävyys pyyntö on lähetetty %s :lle",
"You're already friend of %s" => "Olet jo %s :n ystävä",
"Invalid username" => "Väärä käyttäjänimi",
"I have accepted your friendship request!" => "Olen hyväksynyt ystävyyspyyntösi!",
"I have refused your friendship request!" => "Olen hylännyt ystävyyspyyntösi!",
"No process indicated" => "Ei prosessia osoitettu",
"Role name cannot be empty" => "Tehtävä nimi ei voi olla tyhjä",
"Activity name cannot be empty" => "Toiminnon nimi ei voi olla tyhjä",
"Activity name already exists" => "Toiminto tällä nimellä on olemassa",
"indicates if the process is active. Invalid processes cant be active" => "osoittaa, että menetelmä toimii, väärä menetelmä ei voi toimia",
"No instance indicated" => "Ei pyyntöä osoitettu",
"No activity indicated" => "Ei toimintoa osoitettu",
"The process name already exists" => "Prosessi tällä nimellä on olemassa",
"Process already exists" => "Prosessi on jo olemassa",
"You cant execute this activity" => "Et voi käynnistää toimintoa",
"You couldn't abort a instance" => "Et voi keskeyttää pyyntöä",
"You couldn't exception a instance" => "Et voi tehdä poikkeusta pyyntöön",
"No user indicated" => "Ei käyttäjää osoitettu",
"No title indicated" => "Ei otsikkoa osoitettu",
"No comment indicated" => "Ei kommenttia osoitettu",
"No date indicated" => "Ei päiväystä osoitettu",
"No item indicated" => "Ei osaa osoitettu",
"first uploaded image" => "lähetä ensin kuva",
"last uploaded image" => "viimeksi lähetetty kuva",
"random image" => "satunnais kuva",
"Permission denied you cannot make the map of this gallery" => "Lupa evätty, et voi tehdä karttaa tästä galleriasta",
"Top images" => "Top kuvat",
"Last images" => "Viimeiset kuvat",
"No valid renderer found. GD or PDFLib required." => "Ei löytynyt muodostajaa. GD tai PDFLib tarvitaan.",
"No sheet specified." => "Ei määriteltyä arkkia.",
"You must select a renderer." => "Valitse muodostaja.",
"Invalid Series for current graphic." => "Viallinen sarja nykyiselle grafiikalle.",
"Tiki RSS feed for image galleries" => "RSS syöte kuva gallerioille",
"Last images uploaded to the image galleries." => "Viimeiset lähetetyt kuvat kuva gallerioihin.",
"Tiki RSS feed for the image gallery: " => "RSS syöte kuva gallerialle: ",
"overwriting old page" => "päällekirjoitetaan vanha sivu",
"updated from structured text import" => "päivitetty rakenteen sisältävästä tekstituonnista",
"page created" => "sivu luotu",
"created from structured text import" => "luotu rakenteen sisältävästä tekstituonnista",
"No repository given" => "Ei säilytyspaikkaa annettu",
"Permission denied you cannot view pages like this page" => "Oikeutesi eivät riitä tämän kaltaisten sivujen katsomiseen",
"Permission denied you cannot remove articles" => "Oikeutesi eivät riitä poistamaan artikkeleja",
"Permission denied you cannot remove banners" => "Oikeutesi eivät riitä poistamaan bannereita",
"Permission denied you cannot remove this blog" => "Oikeutesi eivät riitä poistamaan tätä blogia",
"Non-existent gallery" => "Ei olemassa oleva galleria",
"Permission denied you cannot remove files from this gallery" => "Oikeutesi eivät riitä poistamaan tiedostoja tästä galleriasta",
"Permission denied you can't upload files so you can't edit them" => "Oikeutesi eivät riitä lähtettämään tiedostoja, joten et voi myöskään muokata niitä",
"Permission denied you cannot edit this file" => "Oikeutesi eivät riitä muokkaamaan tätä tiedostoa",
"This gallery does not exist" => "Tällaista galleriaa ei ole",
"The game file must have .swf or .dcr extension" => "Peli tiedostolla on oltava .swf tai .dcr pääte",
"The thumbnail name must be" => "Minikuvan nimi on oltava",
"Please supply both files" => "Lähetä molemmat tiedostot",
"You cannot admin blogs" => "Et voi hallinnoida blogeja",
"Permission denied you cannot remove submissions" => "Oikeutesi eivät riitä poistamaan ehdotuksia",
"Permission denied you cannot approve submissions" => "Oikeutesi eivät riitä hyväksymään ehdotuksia",
"Permission denied you cannot view pages" => "Oikeutesi eivät riitä katsomaan sivuja",
"Permission denied you cannot remove pages" => "Oikeutesi eivät riitä poistamaan sivuja",
"You have to enable cookies to be able to login to this site" => "Sinun on hyväksyttävä keksit voidaksesi kirjautua tälle sivustolle",
"Unable to contact remote server." => "Yhteyttä ulkoisiin palvelimiin ei saada.",
"XMLRPC Error: " => "XMLRPC Virhe: ",
"Account validated successfully." => "Tili varmistettu onnistuneesti.",
"Tiki mail-in auto-reply" => "Postit-sisään autom-vastaus",
"Sorry, you can't use this feature." => "Valitan, et voi käyttää tätä ominaisuutta.",
"changed" => "muutettu",
"You do not have permissions to view the maps" => "Oikeutesi eivät riitä katsomaan karttoja",
"Maps feature is not correctly setup : Maps path is missing." => "Kartta ominaisuuden asetukset ovat väärin : Karttojen polku puuttuu.",
"Please create a directory named \$map_path to hold your map files." => "Luo hakemisto nimeltä \$map_path säilyttääksesi karttatiedostoja.",
"mapfile name incorrect" => "karttatiedoston nimi väärin",
"This mapfile already exists" => "Karttatiedosto on jo olemassa",
"You do not have permission to write to the mapfile" => "Oikeutesi eivät riitä karttatiedoston kirjoittamiseen",
"You do not have permission to delete the mapfile" => "Oikeutesi eivät riitä poistamaan karttatiedostoa",
"I could not make a copy" => "Ei voitu kopioida",
"You do not have permission to read the mapfile" => "Oikeutesi eivät riitä lukemaan karttatiedostoa",
"You dont have permission to do that" => "Oikeutesi eivät riitä sen tekemiseen",
"Tiki RSS feed for maps" => "RSS syöte kartoille",
"List of maps available." => "Saatavilla olevien karttojen luettelo.",
"You do not have permissions to view the layers" => "Oikeutesi eivär riitä katsomaan tasoja",
"Could not upload the file" => "Ei voi lähettää tiedostoa",
"You do not have permissions to delete a file" => "Oikeutesi eivät riitä poistamaan tiedostoa",
"File not found" => "Tiedostoa ei löydy",
"You do not have permissions to create a directory" => "Oikeutesi eivät riitä luomaan hakemistoa",
"The Directory is not empty" => "Hakemisto ei ole tyhjä",
"You do not have permissions to delete a directory" => "Oikeutesi eivät riitä poistamaan hakemistoa",
"You do not have permissions to create an index file" => "Oikeutesi eivät riitä luomaan index tiedostoa",
"Invalid file name" => "Väärä tiedoston nimi",
"Invalid files to index" => "Väärä tiedosto indeksiksi",
"I do not know where is gdaltindex. Set correctly the Map feature" => "En tiedä missä on gdaltindex. Aseta oikea kartta ominaisuus",
"I could not create the index file" => "Ei voi luoda index tiedostoa",
"Must be logged to use this feature" => "On kirjauduttava käyttääksesi ominaisuutta",
"Welcome at Hawiki" => "Tervetuloa Mobileen",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Sivusto on luotu käytettäväksi myös, esimerkiksi WAP puhelimilla, PDA, i-mode laitteilla ja paljon muuta.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "Voit selata sivustoa mobiili laitteella osoittamalla seuraavalle sivulle:",
"tiki-mobile.php" => "mobile.php",
"About" => " ",
"You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "Sinun on ajettava setup.sh :<br />./setup.sh \$APACHEUSER all<br />Yleinen Apache käyttäjä on www-data, apache tai nobody",
"Your PHP installation does not have zlib enabled." => "Sinun PHP asennuksessa ei ole zlib päällä.",
"You must log in to use this feature" => "On kirjauduttava käyttääksesi tätä ominaisuutta",
"You do not have permission to view other users data" => "Oikeutesi eivät riitä katsomaan muiden käyttäjien tietoja",
"You must be logged in to subscribe to newsletters" => "On kirjauduttava tilataksesi uutislehden",
"No server indicated" => "Ei palvelinta osoitettu",
"Cannot connect to" => "Ei voi yhdistää",
"Missing information to read news (server,port,username,password,group) required" => "Tietoja puuttuu lukeaksesi uutisia (palvelin,portti,käyttäjänimi,salasana,ryhmä) tarvitaan",
"Cannot get messages" => "Viestejä ei saatu",
"No note indicated" => "Ei merkintää osoitettu",
"merged note:" => "yhdistetty merkintä:",
"File is too big" => "Tiedosto liian suuri",
"created from notepad" => "luotu muistiosta",
"No name indicated for wiki page" => "Ei nimeä osoitettu wiki sivulle",
"Page already exists" => "Sivu on jo olemassa",
"Permission denied you cannot assign permissions for this page" => "Oikeutesi eivät riitä asettamaan oikeuksia tälle sivulle",
"Not enough information to display this page" => "Ei tarpeeksi tietoja sivun näyttämiseen",
"Permission denied you cannot browse this page history" => "Oikeutesi eivät riitä selaamaan tämän sivun historiaa",
"No article indicated" => "Ei artikkelia osoitettu",
"Article is not published yet" => "Artikkelia ei ole vielä julkaistu",
"No post indicated" => "Ei postia osoitettu",
"Blog not found" => "Blogia ei löydy",
"No pages indicated" => "Ei sivuja osoitettu",
"Pageviews" => "Sivunäyttöjä",
"You don't have permission to edit quizzes." => "Oikeutesi eivät riitä muokkaamaan visailuja.",
"No result indicated" => "Ei tulosta osoitettu",
"Permision denied" => "Lupa evätty",
"Registered" => "Rekisteröity",
"Wrong registration code" => "Väärä rekisteröinti koodi",
"Username is too long" => "Käyttäjänimi liian pitkä",
"Username cannot contain whitespace" => "Käyttäjänimi ei voi sisältää sanavälejä",
"Wrong passcode you need to know the passcode to register in this site" => "Väärä passikoodi, sinulla on oltava oikea passikoodi rekisteröityäksesi sivustolle",
"Invalid email address. You must enter a valid email address" => "Väärä sähköpostiosoite. On käytettävä voimassa olevaa sähköpostiosoitetta",
"The registration mail can't be sent. Contact the administrator" => "Rekisteröinti sähköpostia ei voida lähettää. Ota yhteys ylläpitoon",
"Invalid username or activation code. Maybe this code has already been used." => "Väärä käyttäjänimi tai aktivointi koodi. Ehkä tämä koodi on jo käytetty.",
"Unable to send mail. User has not configured email" => "Sähköpostia ei voi lähettää. Käyttäjä ei ole antanut sähköpostiosoitetta",
"A password and your IP address reminder email has been sent " => "Salasana ja IP osoite muistutus on lähetetty ",
"A new (and temporary) password and your IP address has been sent " => "Uusi (ja väliaikainen) salasana ja IP osoite on lähetetty ",
"to the registered email address for" => "rekisteröityyn sähköpostiosoitteeseen",
"Invalid or unknown username" => "Väärä tai tuntematon käyttäjänimi",
"Permission denied you cannot remove versions from this page" => "Oikeutesi eivät riitä poistamaan tämän sivun versioita",
"Permission denied you cannot rename this page" => "Oikeutesi eivät riitä muuttamaan sivun nimeä",
"Cannot rename page because the new name begins with reserved prefix" => "Et voi uudelleen nimetä sivua koska uusi nimi alkaa jo varatulla etuliitteellä",
"Cannot rename page maybe new page already exists" => "Ei voi nimetä uudelleen sivua, kenties sillä nimellä on jo sivu",
"changed '%s' from '%s' to '%s'" => "vaihdettu '%s' '%s':sta '%s':oon",
"Non-existent version" => "Olemanton versio",
"Permission denied you cannot rollback this page" => "Oikeutesi eivät riitä kelata takaisin tätä sivua",
"Error Message" => "Virhe Viesti",
"Tiki RSS Feed Error Message: \$errmsg" => "RSS Syötteen Virhe Viesti: \$errmsg",
"Post recommendation at" => "Lähetä suositus",
"One of the email addresses you typed is invalid" => "Jokin kirjoittamistasi sähköposti osoiteista on väärin",
"No newsletters available." => "Ei uutislehtiä saatavilla.",
" successfully sent" => " onnistuneesti lähetetty",
" not sent" => " ei lähetetty",
"Error: " => "Virhe: ",
"Use this thread to discuss the page:" => "Käytä tätä ketjua keskustellaksesi sivusta:",
"You do not have permission to edit messages" => "Oikeutesi eivät riitä muokkaamaan viestiä",
"This feature is for admins only" => "Tämä ominaisuus on vain ylläpidolle",
"Page must be defined inside a structure to use this feature" => "Sivu on määriteltävä rakenteen sisällä käyttääksesi tätä ominaisuutta",
"You cannot take this quiz twice" => "Et voi osallistua visailuun kahdesti",
"Quiz time limit exceeded quiz cannot be computed" => "Visailun aikaraja ylitetty, ei voi pisteyttää",
"You cannot take this survey twice" => "Et voi ottaa tutkimusta kahdesti",
"Please create a category first" => "Luo luokittelu ensin",
"empty" => "tyhjennä",
"No trackerId specified" => "Ei kortistoId määrittelyä",
"Tiki RSS feed for individual trackers: " => "RSS syöte yksittäis kortistoille: ",
"Invalid filename (using filters for filenames)" => "Väärä tiedostonimi (käyttäen suodinta tiedostonimissä)",
"No permission to upload zipped file packages" => "Ei oikeutta lähettää zip-paketteja",
"Cannot read file" => "Tiedostoa ei voi lukea",
"File update was successful" => "Tiedosto päivitys onnistui",
"Permission denied you cannot upload files" => "Et voi lähettää tiedostoja",
"Could not find the file requested" => "Pyydettyä tiedostoa ei löytynyt",
"Permission denied you can upload files but not to this file gallery" => "Voit lähettää tiedostoja, mutta et tähän galleriaan",
"Error processing zipped image package" => "Virhe zip-pakettien purkamisessa",
"No permission to upload zipped image packages" => "Ei oikeutta lähettää zip-pakattuja kuvatiedostoja",
"The uploaded file ist not recognized as a image" => "Lähetettyä tiedostoa ei tunnistettu kuvaksi",
"Permission denied you cannot upload images" => "Et voi lähettää kuvia",
"Permission denied you can upload images but not to this gallery" => "Voit lähettää kuvia, mutta et tähän galleriaan",
"Cannot get image from URL" => "Kuvaa ei saatu osoitteesta URL",
"That is not an image (or you have php < 4.0.5)" => "Tämä ei ole kuva (tai sinulla on php < 4.0.5)",
"cannot process upload" => "ei voi käsitellä lähetystä",
"Usage" => "Käyttö",
"No url indicated" => "Ei url osoitettu",
"You are not logged in and no user indicated" => "Et ole kirjautunut eikä käytäjää ole osoitettu",
"The user has chosen to make his information private" => "Käyttäjä on valinnut tietonsa yksityisiksi",
"Invalid password.  Your current password is required to change administrative information" => "Väärä salasana.  Nykyinen salasanasi tarvitaan muuttaaksesi ylläpidollisa tietoja",
"Email is set to %s" => "Sähköpostiksi on asetettu %s",
"The passwords did not match" => "Salasana ei täsmää",
"was moved into trash" => "on siirretty roskiin",
"trashed by" => "siirtänyt roskiin",
"Rights by creator" => "Oikeudet luojalla",
"END" => "LOPPU",
"Percentage" => "Prosentteina",
"Task accepted by creator" => "Tehtävän hyväksynyt sen luoja",
"Task accepted by task user" => "Tehtävän hyväksynyt tehtävän käyttäjä",
"Task NOT accepted by creator" => "Tehtävää EI hyväksynyt sen luoja",
"Task NOT accepted by task user" => "Tehtävää EI hyväksynyt tehtävän käyttäjä",
"Sorry this task does not exist or you have no rights to view this task" => "Valitan tällaista tehtävää ei ole tai sinulla ei ole oikeutta nähdä sitä",
"Task entries:" => "Tehtävät:",
"Changes:" => "Muutokset:",
"Info message" => "Info viesti",
"NEW Task" => "UUSI Tehtävä",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Valitan, mutta et voi lähettää tehtäviä muille käyttäjille, tai käyttäjällä ei ole oikeutta vastaanottaa tehtävää!",
"Changes on Task" => "Tehtävän Muutokset",
"You received a new task" => "Olet vastaanottanut uuden tehtävän",
"The priority is" => "Kiireellisyys",
"very low" => "erittäin alhainen",
"low" => "alhainen",
"high" => "korkea",
"very high" => "erittäin korkea",
"You've to start your work at least on" => "Sinun on aloitettava työsi viimeistään",
"You've to finish your work on" => "Työsi on saatava valmiiksi",
"Login and click the link below" => "Kirjaudu ja paina linkkiä alhaalta",
"Please read the task and work on it!" => "Lue tehtävä ja tee se!",
"Sorry, there was an error while trying to write data into the database" => "Valitan, ilmeni virhe kirjoitettaessa tietokantaan",
"Cannot upload this file not enough quota" => "Et voi lähettää tiedostoa, levytilasi on liian pieni",
"Non-existent user" => "Olematon käyttäjä",
"No banner indicated" => "Ei banneria osoitettu",
"No blog indicated" => "Ei blogia osoitettu",
"Permission denied you cannot remove the post" => "Et voi poistaa lähetystä",
"No cache information available" => "Ei puskuritietoja saatavilla",
"No faq indicated" => "Ei ukk:ta osoitettu",
"You are not permitted to remove someone else\\'s post!" => "Et voi poistaa kenenkään toisen posteja!",
"Wrong password. Cannot post comment" => "Väärä salasana. Et voi lähettää kommenttia",
"Please wait 2 minutes between posts" => "Odota 2 minuuttia lähetysten välillä",
"No thread indicated" => "Ei ketjua osoitettu",
"A SheetId is required." => "ArkkiId tarvitaan.",
"Your email address has been removed from the list of addresses monitoring this tracker" => "Sähköpostiosoitteesi on poistettu tarkkailtavien listalta",
"Your email address has been added to the list of addresses monitoring this tracker" => "Sähköpostiosoitteesi on lisätty tarkkailtavien listalle",
"Cancel monitoring" => "Peruuta tarkkailu",
"Monitor" => "Tarkkale",
"Your email address has been removed from the list of addresses monitoring this item" => "Sähköpostiosoitteesi on poistettu tämän osan tarkkailtavien listalta",
"Your email address has been added to the list of addresses monitoring this item" => "Sähköpostiosoitteesi on lisätty tämän osan tarkkailtavien listalle",
"That tracker don't use extras." => "Se kortisto ei käytä ekstroja.",
"No subject" => "Ei otsaketta",
"Your email was sent" => "Sähköpostiosoitteesi on lähetetty",
"Top pages" => "Top sivut",
"Last pages" => "Viimeiset sivut",
"Tiki RSS feed for the wiki pages" => "RSS syöte sivuston sivuille",
"Last modifications to the Wiki." => "Viimeiset muutokset sivustolla.",
"###end###"=>"###end###");
?>
