/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;

class ButtonPanel
extends Panel
implements ActionListener {
    VncViewer viewer;
    Button disconnectButton;
    Button optionsButton;
    Button clipboardButton;
    Button ctrlAltDelButton;
    Button refreshButton;

    ButtonPanel(VncViewer vncViewer) {
        this.viewer = vncViewer;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.disconnectButton = new Button("Disconnect");
        this.disconnectButton.setEnabled(false);
        this.add(this.disconnectButton);
        this.disconnectButton.addActionListener(this);
        this.optionsButton = new Button("Options");
        this.add(this.optionsButton);
        this.optionsButton.addActionListener(this);
        this.clipboardButton = new Button("Clipboard");
        this.clipboardButton.setEnabled(false);
        this.add(this.clipboardButton);
        this.clipboardButton.addActionListener(this);
        this.ctrlAltDelButton = new Button("Send Ctrl-Alt-Del");
        this.ctrlAltDelButton.setEnabled(false);
        this.add(this.ctrlAltDelButton);
        this.ctrlAltDelButton.addActionListener(this);
        this.refreshButton = new Button("Refresh");
        this.refreshButton.setEnabled(false);
        this.add(this.refreshButton);
        this.refreshButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.disconnectButton) {
            this.viewer.disconnect();
        } else if (actionEvent.getSource() == this.optionsButton) {
            ((Component)this.viewer.options).setVisible(this.viewer.options.isVisible() ^ true);
        } else if (actionEvent.getSource() == this.clipboardButton) {
            ((Component)this.viewer.clipboard).setVisible(this.viewer.clipboard.isVisible() ^ true);
        } else if (actionEvent.getSource() == this.ctrlAltDelButton) {
            try {
                int n = 10;
                KeyEvent keyEvent = new KeyEvent(this, 401, 0L, 10, 127);
                this.viewer.rfb.writeKeyEvent(keyEvent);
                keyEvent = new KeyEvent(this, 402, 0L, 10, 127);
                this.viewer.rfb.writeKeyEvent(keyEvent);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (actionEvent.getSource() == this.refreshButton) {
            try {
                RfbProto rfbProto = this.viewer.rfb;
                rfbProto.writeFramebufferUpdateRequest(0, 0, rfbProto.framebufferWidth, rfbProto.framebufferHeight, false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.viewer.moveFocusToDesktop();
    }

    public void enableButtons() {
        this.disconnectButton.setEnabled(true);
        this.clipboardButton.setEnabled(true);
        this.refreshButton.setEnabled(true);
    }

    void enableRemoteAccessControls(boolean bl) {
        this.ctrlAltDelButton.setEnabled(bl);
    }
}

