#ifndef THCRUT_COMMON_H
#define THCRUT_COMMON_H 1

#define BOOTP_PLEN          308
#define MAX_PAYLOAD_SIZE    1024
#define ETHDLTLEN			14
#define ETH_ALEN    		6
#define PCAP_FILTER 		"arp or icmp or udp"
#define ETHBCAST            "\xff\xff\xff\xff\xff\xff"
#define DEFAULTMACSTR       "00:00:02:00:00:01"

#define OPT_RARP            0x01
#define OPT_BOOTP           0x02
#define OPT_DHCP            0x04
#define OPT_ICMPADDR        0x08
#define OPT_ICMPPING        0x10
#define OPT_ARPD            0x20
#define OPT_BARP            0x40
#define OPT_ICMPRS          0x80


/*
 * this is already defined on hpux and *bsd.
 * The syntax is nearly posix - no problem to use the system wide MIN macro
 */
#ifndef MIN
# define MIN(a,b)    ((a)<(b)?(a):(b))
#endif

struct _spfmac
{
    u_char  mac[6];
    int     prfxlen;
};

struct _spfip
{
    u_long  addr;
};

struct _opt
{
    char *device;
    u_char *macrangestr;
	int dlt_len;
    struct libnet_link_int  *network;
    unsigned int flags;
    unsigned int vendorlen;
    char **argvlist;
    pid_t   arpdpid;
    int pps;        /* packets per seconds */
	int (*handle_ip) (u_char *, int );	/* ip-packet, len */
    int (*handle_arp) (u_char *, int ); /* obsolete. handle_ip also */
};


struct _lnet
{
	char err_buf[LIBNET_ERRBUF_SIZE];   /* error buffer */
	u_char *packet;                     /* pointer to our packet buffer */
	int packet_size;
	u_char payload[MAX_PAYLOAD_SIZE];
};

#ifdef lib_pcap_h
struct _pcap
{
	char err_buf[PCAP_ERRBUF_SIZE];
	pcap_t	*ip_socket;
};
#endif

struct Ether_header
{
    uint8_t ether_dhost[ETH_ALEN];
    uint8_t ether_shost[ETH_ALEN];
    uint16_t ether_type;
};

#define ETH_ARP_H   28
/*
 * we store Arp info in here only. we cannot just match the pointer
 * of this structure to the u_char packet field from pcap.
 * (struct variable alignment).
 */
struct Arpnfo
{
//    unsigned short ar_hrd;  /* Format of hardware address.  */
//    unsigned short ar_pro;  /* Format of protocol address.  */
//    unsigned char ar_hln;   /* Length of hardware address.  */
//    unsigned char ar_pln;   /* Length of protocol address.  */
    unsigned short ar_op;   /* ARP opcode (command).  */
    unsigned char *ar_sha; /* Sender hardware address.  */
    unsigned long ar_sip;    /* Sender IP address.  */
    unsigned char *ar_tha; /* Target hardware address.  */
    unsigned long ar_tip;    /* Target IP address.  */
};


void die(int, char *, ...);
void start_arpd();
void sig_waitchld(int);
void do_signal(int);
int handle_ip(u_char *, int);
int handle_arp(u_char *, int);
int list_dhcp();

#endif  /* !THCRUT_COMMONT_H */
