#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <libnet.h>
#include <thcrut/network_raw.h>

/*
 * return 0 if ip-header is valid [length only]
 * len = length from the begin of the ip-header [20 for normal ip header]
 */
int
vrfy_ip (struct ip *ip, uint32_t len, u_short * ip_options)
{
    u_short _ip_options;
    
    if (len < sizeof (*ip))

    return (-1);
    _ip_options = ip->ip_hl << 2;

    if (_ip_options > len)
    return (-1);

    if (_ip_options > 0xefff)   /* NO, we dont accept this ! */
        return -1;

    if (_ip_options < sizeof (*ip))
    _ip_options = 0;
    else
    _ip_options -= sizeof (*ip);

    *ip_options = _ip_options;

    return (0);

}

int
vrfy_udp (struct udphdr *udp, uint32_t len)
{
    if (len < sizeof(*udp))
        return (-1);

    return (0);
}

/*
 * return 0 if header is valid
 * return -1 if not 
 * and -2 is unknown
 * this function should _only_ be used with thc-rut!
 * this function is _not_ portable...we only check for icmp-codes/types
 * we are interested in.
 */
int
vrfy_icmp (struct icmp *icmp, uint32_t len)
{
    if (len < ICMP_MINLEN)
        return (-1);

    switch (icmp->icmp_type)
    {
        case ICMP_MASKREPLY:
            if (icmp->icmp_code != 0)
                return -2;
            if (len >= ICMP_MASKLEN)
                return 0;
            else
                return -1;
            /* check _ALL_ icmp_type == 18 types HERE */
            return -2;
        case ICMP_ECHOREPLY:
            if (icmp->icmp_code == 0)
                return 0;
            return -2;
        case ICMP_ECHO:
            if (icmp->icmp_code == 0)
                return 0;
            return -2;
            break;
        default:
            return -2;      /* header invalid if type/code not known */
    }

    return 0;
}

/*
 * slow inet_ntoa but in function-supplied buffer and not
 * static buffer like inet_ntoa
 */
char *
int_ntop(char *buf, struct in_addr in)
{

    sprintf(buf, "%s", inet_ntoa(*((struct in_addr *)&(in))));

    return buf;
}


/*
 * convert a mac to a colon seperated string
 */
char *
val2mac(unsigned char *ptr)
{
	static char buf[64];

	sprintf(buf, "%2.2x:%2.2x:%2.2x:%2.2x:%2.2x:%2.2x",
		(u_char)ptr[0],
		(u_char)ptr[1],
		(u_char)ptr[2],
		(u_char)ptr[3],
		(u_char)ptr[4],
		(u_char)ptr[5]);

	return buf;
}

