/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-2000, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/exec.e,v 4.12 2000/07/29 14:48:02 william Exp $
 */

#ifndef _EXEC_E_
#define _EXEC_E_

extern int		execAnimating;
extern int		execAnimateRedraw;
extern int		execCurDepth;
extern int		replaceAttrFirstValueRedraw;
extern int		execNavigateBack;
extern int		userAbortExec;

extern struct AttrRec	* warpToAttr;

extern char		* cmdToExecAfterHyperJump;

extern struct StrRec	* topTmpStr;
extern struct StrRec	* botTmpStr;

typedef struct tagReplAttrValueCallbackInfo {
   struct ObjRec *obj_ptr; /* a top level object */
   struct AttrRec *attr_ptr;
   char *new_attr_value;
   void *pv_userdata;
} ReplAttrValueCallbackInfo;

typedef int (ReplAttrValueCallback)ARGS_DECL((ReplAttrValueCallbackInfo*));

#ifdef _INCLUDE_FROM_EXEC_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_EXEC_C_*/

extern void	CleanTmpStr ARGS_DECL((void));
extern int	PrependToTmpStr ARGS_DECL((char*));
extern int	AppendToTmpStr ARGS_DECL((char*));
extern struct ObjRec	* FindObjWithName ARGS_DECL((struct ObjRec *BotObj,
			                             struct ObjRec *ObjPtr,
			                             char *ObjName,
			                             int InsideRootObj,
			                             int InsideThisObj,
			                             struct ObjRec **OwnerObj,
			                             struct ObjRec **TopOwner));

extern int	PipeReachedEOF ARGS_DECL((FILE*));
extern int	WaitForEvent ARGS_DECL((FILE*, int fp_is_pipe, int *pn_quit,
		                        int what_to_do_with_x_events,
		                        AbortCallbackFunc*, void*));
extern int	DoLaunch ARGS_DECL((struct AttrRec *, struct ObjRec *));
extern void	SetReplaceAttrValueCallback ARGS_DECL((ReplAttrValueCallback*,
		                                       void *pv_userdata));
extern int	ReplaceAttrFirstValue ARGS_DECL((struct ObjRec *,
		                                 struct AttrRec *, char *));
extern int	ReplaceAttrAllValues ARGS_DECL((struct ObjRec *,
		                                struct AttrRec *,
		                                struct StrRec **ppTopStr,
		                                struct StrRec **ppBotStr));
extern void	JustReadFileIntoAttr ARGS_DECL((FILE*, struct AttrRec *attr_ptr,
		                                struct ObjRec *attr_owner_obj));
extern int	DoExec ARGS_DECL((struct AttrRec *, struct ObjRec *));
extern void	ResetExec ARGS_DECL((int nStart));
extern void	ExecCmdsFromFile ARGS_DECL((char*));
extern void	StartExecCmdsFromFile ARGS_DECL((void));
extern int	BeginExecCommandsFromBuffer ARGS_DECL((void));
extern int	ExecACommandFromBuffer ARGS_DECL((char *buf, int *pn_quit));
extern void	EndExecCommandsFromBuffer ARGS_DECL((void));
extern void	CleanUpExec ARGS_DECL((void));
extern void	InitExec ARGS_DECL((void));

#ifdef _INCLUDE_FROM_EXEC_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_EXEC_C_*/

#endif /*_EXEC_E_*/
