/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-2000, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/cutpaste.e,v 4.23 2000/07/03 21:13:15 william Exp $
 */

#ifndef _CUTPASTE_E_
#define _CUTPASTE_E_

extern int	copyingToCutBuffer;
extern int	pastingFile;

extern char	gszFilesIniFile[MAXPATHLENGTH];
extern char	*gpszRecentFilesSec;
extern char	*gpszRecentFilesCountKey;

#ifdef _INCLUDE_FROM_CUTPASTE_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_CUTPASTE_C_*/

extern int	WriteBufToCutBuffer ARGS_DECL((char *buf, int buf_sz));
extern int	CopyToCutBuffer ARGS_DECL((void));
extern int	CopyPlainTextAsObject ARGS_DECL((void));
extern void	CutToCutBuffer ARGS_DECL((void));
extern void	PasteString ARGS_DECL((char*, int highlight, int record_cmd));
extern void	AssignNewObjIds ARGS_DECL((struct ObjRec *));
extern char	* FetchCutBuffer ARGS_DECL((int *));
extern int	PasteFromCutBuffer ARGS_DECL((void));
extern int	PasteFromFile ARGS_DECL((void));
extern char	* GetCompoundTextBytesFromSelection ARGS_DECL((unsigned long*));
extern int	PasteCompoundText ARGS_DECL((void));
extern void	CleanUpCutBuffer ARGS_DECL((void));

extern void	SetIntPropertyMask ARGS_DECL((long lWhich, int nValue,
		                              char *pszValue, long *plMask,
		                              long *plSkip,
		                              struct PropertiesRec *pProp));
extern void	SetFontPropertyMask ARGS_DECL((int nDoubleByte, int nFont,
		                               int nStyle, long *plMask,
		                               long *plSkip,
		                               struct PropertiesRec *pProp));
extern void	SetCTMPropertyMask ARGS_DECL((struct XfrmMtrxRec *ctm,
		                              long *plMask, long *plSkip,
		                              struct PropertiesRec *pProp));
extern void	SetTextPropMask ARGS_DECL((struct ObjRec *, long *plMask,
		                           long *plSkip,
		                           struct PropertiesRec *pProp));
extern void	CleanUpProperties ARGS_DECL((void));
extern void	InitProperties ARGS_DECL((void));
extern void	DoGetProperty ARGS_DECL((int index));
extern EditAttrInfo	*CreateGetPropertyInfo ARGS_DECL((void));
extern void	CopyProperties ARGS_DECL((int nPrompt));
extern void	SaveProperties ARGS_DECL((void));
extern void	PasteProperties ARGS_DECL((int nPrompt));
extern void	RestoreProperties ARGS_DECL((void));

extern void	BackupCopiedProperties ARGS_DECL((void));
extern void	RestoreCopiedProperties ARGS_DECL((void));
extern int	EditIniSection ARGS_DECL((char *pszTitle, char *pszSection,
		                          char *pszIniFile, AfterLoopFunc*));
extern char	*SelectFromIniSection ARGS_DECL((char *pszTitle,
		                                 char *pszSection,
		                                 char *pszIniFile));

extern void	FreeRecentFilesListing ARGS_DECL((KeyValInfo*, int));
extern KeyValInfo	*RecentFilesListing ARGS_DECL((int *pnEntries));
extern void	OpenARecentlyUsedFile ARGS_DECL((int file_index));
extern void	AddARecentlyUsedFile ARGS_DECL((char *path));
extern int	InitRecentFiles ARGS_DECL((void));
extern void	CleanUpRecentFiles ARGS_DECL((void));

extern int	CreateSimpleStringObj ARGS_DECL((char*));
extern void	SaveSimpleStringObj ARGS_DECL((FILE*, struct ObjRec *));
extern void	ReadSimpleStringObj ARGS_DECL((FILE*, char*, struct ObjRec **));
extern void	FreeSimpleStringObj ARGS_DECL((struct ObjRec *));

extern void	ReplaceGraphic ARGS_DECL((void));

#ifdef _INCLUDE_FROM_CUTPASTE_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_CUTPASTE_C_*/

#endif /*_CUTPASTE_E_*/
