/***************************************************************************
 *   copyright            : (C) 2004 by Pascal Brachet & Joel Amblard      *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "webpublishdialog.h"

#include <qvariant.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qtextedit.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qtextstream.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qregexp.h> 
#include <qevent.h>
#include <qeventloop.h> 
#include <qsettings.h> 
#include <qstringlist.h>

webpublishdialog::webpublishdialog(QWidget *parent, const char *name)
    :QDialog( parent, name, true)
{
    frame3 = new QFrame(this, "frame3" );
    frame3->setGeometry( QRect( 10, 10, 620, 490 ) );
    frame3->setFrameShape( QFrame::StyledPanel );
    frame3->setFrameShadow( QFrame::Raised );

    LaunchButton = new QPushButton( frame3, "LaunchButton" );
    LaunchButton->setGeometry( QRect( 410, 360, 120, 31 ) );
   

    inputfileLabel = new QLabel( frame3, "inputfileLabel" );
    inputfileLabel->setGeometry( QRect( 10, 10, 80, 21 ) );

    htmlgroupBox = new QGroupBox( frame3, "htmlgroupBox" );
    htmlgroupBox->setGeometry( QRect( 10, 50, 600, 90 ) );

    alignmentLabel = new QLabel( htmlgroupBox, "alignmentLabel" );
    alignmentLabel->setGeometry( QRect( 10, 20, 70, 21 ) );

    titleLabel = new QLabel( htmlgroupBox, "titleLabel" );
    titleLabel->setGeometry( QRect( 10, 50, 40, 21 ) );

    indexLabel = new QLabel( htmlgroupBox, "indexLabel" );
    indexLabel->setGeometry( QRect( 200, 20, 90, 21 ) );

    footnoteLabel = new QLabel( htmlgroupBox, "footnoteLabel" );
    footnoteLabel->setGeometry( QRect( 300, 50, 70, 21 ) );

    navigationLabel = new QLabel( htmlgroupBox, "navigationLabel" );
    navigationLabel->setGeometry( QRect( 370, 20, 70, 21 ) );

    indexcomboBox = new QComboBox( FALSE, htmlgroupBox, "indexcomboBox" );
    indexcomboBox->setGeometry( QRect( 300, 20, 60, 21 ) );

    alignmentcomboBox = new QComboBox( FALSE, htmlgroupBox, "alignmentcomboBox" );
    alignmentcomboBox->setGeometry( QRect( 90, 20, 90, 21 ) );

    navigationBox = new QComboBox( FALSE, htmlgroupBox, "navigationBox" );
    navigationBox->setGeometry( QRect( 450, 20, 130, 21 ) );

    titleEdit = new QLineEdit( htmlgroupBox, "titleEdit" );
    titleEdit->setGeometry( QRect( 60, 50, 180, 24 ) );

    footnoteEdit = new QLineEdit( htmlgroupBox, "footnoteEdit" );
    footnoteEdit->setGeometry( QRect( 380, 50, 180, 24 ) );

    groupBox3 = new QGroupBox( frame3, "groupBox3" );
    groupBox3->setGeometry( QRect( 10, 150, 600, 60 ) );

    colordepthLabel = new QLabel( groupBox3, "colordepthLabel" );
    colordepthLabel->setGeometry( QRect( 410, 20, 90, 21 ) );

    widthLabel = new QLabel( groupBox3, "widthLabel" );
    widthLabel->setGeometry( QRect( 12, 20, 100, 21 ) );

    widthspinBox = new QSpinBox( groupBox3, "widthspinBox" );
    widthspinBox->setGeometry( QRect( 120, 20, 80, 21 ) );
    widthspinBox->setMaxValue( 2048 );
    widthspinBox->setLineStep( 10 );
    widthspinBox->setValue( 700 );

    interlacecomboBox = new QComboBox( FALSE, groupBox3, "interlacecomboBox" );
    interlacecomboBox->setGeometry( QRect( 340, 20, 61, 21 ) );

    colordepthcomboBox = new QComboBox( FALSE, groupBox3, "colordepthcomboBox" );
    colordepthcomboBox->setGeometry( QRect( 510, 20, 81, 21 ) );

    interlaceLabel = new QLabel( groupBox3, "interlaceLabel" );
    interlaceLabel->setGeometry( QRect( 212, 20, 120, 21 ) );

    groupBox4 = new QGroupBox( frame3, "groupBox4" );
    groupBox4->setGeometry( QRect( 10, 350, 390, 130 ) );

    messagetextEdit = new QTextEdit( groupBox4, "messagetextEdit" );
    messagetextEdit->setGeometry( QRect( 10, 20, 370, 100 ) );

    browserLabel = new QLabel( frame3, "browserLabel" );
    browserLabel->setGeometry( QRect( 10, 320, 70, 21 ) );

    browserEdit = new QLineEdit( frame3, "browserEdit" );
    browserEdit->setGeometry( QRect( 100, 320, 210, 24 ) );

    inputfileButton = new QPushButton( frame3, "inputfileButton" );
    inputfileButton->setGeometry( QRect( 390, 10, 90, 30 ) );
   

    inputfileEdit = new QLineEdit( frame3, "inputfileEdit" );
    inputfileEdit->setGeometry( QRect( 90, 10, 270, 24 ) );

    latexgroupBox = new QGroupBox( frame3, "latexgroupBox" );
    latexgroupBox->setGeometry( QRect( 10, 220, 600, 90 ) );

    contentLabel = new QLabel( latexgroupBox, "contentLabel" );
    contentLabel->setGeometry( QRect( 250, 20, 100, 21 ) );

    compilationspinBox = new QSpinBox( latexgroupBox, "compilationspinBox" );
    compilationspinBox->setGeometry( QRect( 180, 20, 50, 21 ) );
    compilationspinBox->setMaxValue( 3 );
    compilationspinBox->setMinValue( 1 );

    tocdepthspinBox = new QSpinBox( latexgroupBox, "tocdepthspinBox" );
    tocdepthspinBox->setGeometry( QRect( 100, 50, 50, 21 ) );
    tocdepthspinBox->setMaxValue( 3 );
    tocdepthspinBox->setMinValue( 1 );
    tocdepthspinBox->setValue( 2 );

    startindexspinBox = new QSpinBox( latexgroupBox, "startindexspinBox" );
    startindexspinBox->setGeometry( QRect( 360, 50, 61, 21 ) );
    startindexspinBox->setMaxValue( 5000 );
    startindexspinBox->setMinValue( 1 );

    startindexLabel = new QLabel( latexgroupBox, "startindexLabel" );
    startindexLabel->setGeometry( QRect( 250, 50, 90, 21 ) );

    tocdepthLabel = new QLabel( latexgroupBox, "tocdepthLabel" );
    tocdepthLabel->setGeometry( QRect( 10, 50, 81, 21 ) );

    compilationLabel = new QLabel( latexgroupBox, "compilationLabel" );
    compilationLabel->setGeometry( QRect( 10, 20, 160, 21 ) );

    contentEdit = new QLineEdit( latexgroupBox, "contentEdit" );
    contentEdit->setGeometry( QRect( 360, 20, 180, 24 ) );

    aboutButton = new QPushButton( frame3, "aboutButton" );
    aboutButton->setGeometry( QRect( 410, 449, 80, 31 ) );
    
    quitButton = new QPushButton( frame3, "quitButton" );
    quitButton->setGeometry( QRect( 510, 449, 80, 31 ) );
    
    resize( QSize(638, 515).expandedTo(minimumSizeHint()) );

    // signals and slots connections
    connect( aboutButton, SIGNAL( clicked() ), this, SLOT( aboutSlot() ) );
    connect( quitButton, SIGNAL( clicked() ), this, SLOT( close() ) );
    connect( LaunchButton, SIGNAL( clicked() ), this, SLOT( proceedSlot() ) );
    connect( inputfileButton, SIGNAL( clicked() ), this, SLOT( browseSlot() ) );

    // tab order
    setTabOrder( inputfileEdit, inputfileButton );
    setTabOrder( inputfileButton, alignmentcomboBox );
    setTabOrder( alignmentcomboBox, indexcomboBox );
    setTabOrder( indexcomboBox, navigationBox );
    setTabOrder( navigationBox, titleEdit );
    setTabOrder( titleEdit, footnoteEdit );
    setTabOrder( footnoteEdit, widthspinBox );
    setTabOrder( widthspinBox, interlacecomboBox );
    setTabOrder( interlacecomboBox, colordepthcomboBox );
    setTabOrder( colordepthcomboBox, compilationspinBox );
    setTabOrder( compilationspinBox, contentEdit );
    setTabOrder( contentEdit, tocdepthspinBox );
    setTabOrder( tocdepthspinBox, startindexspinBox );
    setTabOrder( startindexspinBox, browserEdit );
    setTabOrder( browserEdit, messagetextEdit );
    setTabOrder( messagetextEdit, aboutButton );
    setTabOrder( aboutButton, quitButton );
    setTabOrder( quitButton, LaunchButton );
    
    setCaption( "Convert to Html");
    latexgroupBox->setTitle( "LaTeX options");
    contentLabel->setText( "Content name :");
    QToolTip::add( compilationspinBox, "Number of latex compilations for the input file" );
    QToolTip::add( contentEdit, "Latex code for the title of the table of contents" );
    QToolTip::add( tocdepthspinBox, "Set the value of the LaTeX tocdepth counter" );
    QToolTip::add( startindexspinBox, "The number of the ps page corresponding to the first numberline indexed in the toc file" );
    startindexLabel->setText( "Start Index :" );
    QToolTip::add( startindexLabel, QString::null );
    tocdepthLabel->setText( "Tocdepth :" );
    QToolTip::add( tocdepthLabel, QString::null );
    compilationLabel->setText( "Number of compilations :" );
    htmlgroupBox->setTitle( "Html options" );
    alignmentLabel->setText( "Alignment :" );
    titleLabel->setText( "Title :" );
    indexLabel->setText( "Create index :" );
    footnoteLabel->setText( "Footnote :" );
    navigationLabel->setText( "Navigation :" );
    indexcomboBox->clear();
    indexcomboBox->insertItem( "Yes" );
    indexcomboBox->insertItem( "No" );
    QToolTip::add( indexcomboBox, "Create an index page ?" );
    alignmentcomboBox->clear();
    alignmentcomboBox->insertItem( "Left" );
    alignmentcomboBox->insertItem( "Center" );
    alignmentcomboBox->insertItem( "Right" );
    QToolTip::add( alignmentcomboBox, "Alignment in the html files" );
    navigationBox->clear();
    navigationBox->insertItem( "Icons" );
    navigationBox->insertItem( "Page numbers" );
    QToolTip::add( navigationBox, "Navigation mode" );
    QToolTip::add( titleEdit, "Title of the html files" );
    QToolTip::add( footnoteEdit, "Text displayed at the bottom of each html files " );
    groupBox3->setTitle( "Images options" );
    colordepthLabel->setText( "Color depth :" );
    interlaceLabel->setText( "Interlace images :" );
    widthLabel->setText( "Images Width :" );
    QToolTip::add( widthspinBox, "Width of the largest image" );
    interlacecomboBox->clear();
    interlacecomboBox->insertItem( "Yes" );
    interlacecomboBox->insertItem( "No" );
    QToolTip::add( interlacecomboBox, "Generate interlaced images ?" );
    colordepthcomboBox->clear();
    colordepthcomboBox->insertItem( "4" );
    colordepthcomboBox->insertItem( "8" );
    colordepthcomboBox->insertItem( "32" );
    colordepthcomboBox->insertItem( "128" );
    colordepthcomboBox->insertItem( "256" );
    colordepthcomboBox->setCurrentItem( 2 );
    QToolTip::add( colordepthcomboBox, "Specify the color depth of the images" );
    groupBox4->setTitle( "Messages" );
    inputfileLabel->setText( "Input File :" );
    inputfileButton->setText( "Browse" );
    aboutButton->setText( "About" );
    QToolTip::add( aboutButton, QString::null );
    quitButton->setText( "Close" );
    LaunchButton->setText( "Launch" );
    browserLabel->setText( "Browser :" );
    QToolTip::add( browserEdit,  "Browser command. Let's empty to not run the browser at the end of the conversion" );
    init();
}

webpublishdialog::~webpublishdialog(){
}

void webpublishdialog::init()
{
readsettings();
titleEdit->setText(TITLE );
footnoteEdit->setText(ADDRESS);
browserEdit->setText(BROWSER);
contentEdit->setText(CONTENTNAME);
if (NOINDEX) indexcomboBox->setCurrentItem(1);
else indexcomboBox->setCurrentItem(0);
if(ALIGN=="left") alignmentcomboBox->setCurrentItem(0);
if(ALIGN=="center") alignmentcomboBox->setCurrentItem(1);
if(ALIGN=="right") alignmentcomboBox->setCurrentItem(2);
if (NAVIGATION==1) navigationBox->setCurrentItem(0);
else navigationBox->setCurrentItem(1);
if (NOINTERLACE) interlacecomboBox->setCurrentItem(1);
else interlacecomboBox->setCurrentItem(0);
if(COLORDEPTH==4) colordepthcomboBox->setCurrentItem(0);
if(COLORDEPTH==8) colordepthcomboBox->setCurrentItem(1);
if(COLORDEPTH==32) colordepthcomboBox->setCurrentItem(2);
if(COLORDEPTH==128) colordepthcomboBox->setCurrentItem(3);
if(COLORDEPTH==256) colordepthcomboBox->setCurrentItem(4);
widthspinBox->setValue( USERWIDTH );
compilationspinBox->setValue( COMPIL );
tocdepthspinBox->setValue(TOCDEPTH);
startindexspinBox->setValue(STARTINDEX);
MAXWIDTH=0;
COLORLINK="1 0 0"; 
nb_pages=0;
nb_content_pages=0;
id_page=1;
DEPTH="\\{part\\}|\\{chapter\\}|\\{section\\}";
}

void webpublishdialog::convert( const QString &fileName )
{
ERROR=false;
messagetextEdit->clear();
QString firstpage;
QFileInfo fi(fileName);
if (fi.exists() && fi.isReadable()) 
	{
	WORKDIR=fi.dirPath();
	LASTDIR=WORKDIR;
	BASE=fi.baseName();
	HTMLDIR=WORKDIR+"/"+BASE+"_html";
	QDir HDir(HTMLDIR);
	if (HDir.exists())
		{
		const QFileInfoList * files = HDir.entryInfoList();
		if ( files ) 
			{
			QFileInfoListIterator it( *files );
			QFileInfo * finfo;
			while( (finfo=it.current()) != 0 ) 
				{
				QString fn=finfo->filePath();
				QFile f(fn);
				f.remove();
				++it;
				}
			}
		}
		else
		{
		HDir.mkdir(HTMLDIR,true);
		}
	copyFile(PROGRAMDIR+"/style.css",HTMLDIR+"/style.css");
	copyFile(PROGRAMDIR+"/up.gif",HTMLDIR+"/up.gif");
	copyFile(PROGRAMDIR+"/up_d.gif",HTMLDIR+"/up_d.gif");
	copyFile(PROGRAMDIR+"/psheader.txt",WORKDIR+"/psheader.txt");
	if (NAVIGATION==1) 
		{
		copyFile(PROGRAMDIR+"/next.gif",HTMLDIR+"/next.gif");
		copyFile(PROGRAMDIR+"/next_d.gif",HTMLDIR+"/next_d.gif");
		copyFile(PROGRAMDIR+"/prev.gif",HTMLDIR+"/prev.gif");
		copyFile(PROGRAMDIR+"/prev_d.gif",HTMLDIR+"/prev_d.gif");
		}
	if (TITLE=="") TITLE=BASE;
	if (TOCDEPTH==2) 
		{
		DEPTH=DEPTH+"|\\{subsection\\}";
		}
	else if (TOCDEPTH==3) 
		{
		DEPTH=DEPTH+"|\\{subsection\\}|\\{subsubsection\\}";
		}
	writepages("content");
	if (ERROR) return;
	if (!NOINDEX) writepages("index");
	if (ERROR) return;
	clean();
	messagetextEdit->append("Conversion done.\nThe html files are located in the "+HTMLDIR+" directory.\n");
	if (!NOINDEX) firstpage=HTMLDIR+"/index.html";
	else firstpage=HTMLDIR+"/page1.html";
	QFileInfo fip(firstpage);
	if (fip.exists() && fip.isReadable() && (!BROWSER.isEmpty()) ) 
		{
		messagetextEdit->append("Running browser .\n");
		RunCommand(BROWSER+" "+firstpage,false);
		}
	}
else 
	{
	messagetextEdit->append("Input file not found.\n");
	}
}




void webpublishdialog::closeEvent( QCloseEvent* ce )
{
writesettings();
ce->accept();
return;
}


void webpublishdialog::RunCommand(QString comd,bool waitendprocess)
{
FINPROCESS=false;
proc = new QProcess(QString("/bin/sh"));
proc->setWorkingDirectory(WORKDIR);
proc->addArgument("-c");
proc->addArgument(comd);
connect( proc, SIGNAL(processExited()),this, SLOT(SlotEndProcess()) );
if ( !proc->start() )
	{
	fatalerror("The command : "+comd+" has failed.");
	return;
	}
else
	{
	if (waitendprocess)
		{
		while (!FINPROCESS) 
			{
			qApp->eventLoop()->processEvents(QEventLoop::ExcludeUserInput);
			}
		}
	}
}

void webpublishdialog::copyFile(QString from_file, QString to_file)
{
QUrlOperator *op = new QUrlOperator();
op->copy("file:"+from_file,"file:"+to_file,false,false);
}

void webpublishdialog::removeFile(QString file)
{
if (QFile::exists(file))
	{
	QFile fi(file);
	fi.open( IO_ReadOnly );
	fi.remove();
	}
}

QString webpublishdialog::header()
{
QString result="<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'> \n";
result+="<html>\n";
result+="<head>\n";
result+="<META NAME='Generator' CONTENT='TeXToWebPublishing (ttwp)'>\n";
result+="<TITLE>"+TITLE+"</TITLE>\n";
result+="<link rel=StyleSheet href='style.css' type='text/css'>\n";
result+="</head>\n";
result+="<body bgcolor='white'>\n";
return result;
}

QString webpublishdialog::footer()
{
QString result="<div align='"+ALIGN+"' id='address'> "+ADDRESS+" </div>\n";
result+="</body>\n";
result+="</html>";
return result;
}

QString webpublishdialog::content_navigation(int page,int numpages,QString up_page)
{
QString result;
QString leftcode="";
QString rightcode="";
QString upcode ="";
int prev_page=page-1;
int next_page=page+1;
if (NAVIGATION==1) 
	{
	if (page > 1) 
		{
		leftcode= "<A HREF='page"+QString::number(prev_page)+".html'><IMG src='prev.gif' align='middle' border='0'></A>";
		}
	else
		{
		leftcode="<IMG src='prev_d.gif' align='middle' border='0'>";
		}
		
	if (page < numpages) 
		{
		rightcode="<A HREF='page"+QString::number(next_page)+".html'><IMG src='next.gif' align='middle' border='0'></A>";
		}
	else
		{
		rightcode="<IMG src='next_d.gif' align='middle' border='0'>" ;
		}
	}
else
	{
	if (page > 1)
		{
		leftcode ="<A HREF='page"+QString::number(prev_page)+".html'>&nbsp;"+QString::number(prev_page)+"/"+QString::number(nb_content_pages)+"&nbsp;<</A>" ;
		}
	else
		{
		leftcode ="&nbsp;";
		}
	if (page < numpages) 
		{
		rightcode ="<A HREF='page"+QString::number(next_page)+".html'>>&nbsp;"+QString::number(next_page)+"/"+QString::number(nb_content_pages)+"&nbsp;</A>" ;
		}
	else
		{
		rightcode ="&nbsp;";
		}
	}
if (page>0) 
	{
	upcode ="<A HREF='"+up_page+"'><IMG src='up.gif' align='middle' border='0'></A>" ;
	}
else
	{
	upcode ="<IMG src='up_d.gif' align='middle' border='0'>";
	}
result="<div id='navigation'>\n <table border=0 cellpadding=2 cellspacing=0 width='100%'>\n ";
result+="<tr valign='middle'>\n ";
result+="<td align='left' valign='middle' width='100'>"+leftcode+"</td>\n";
result+="<td align='center' valign='middle' width='100'>"+upcode+"</td>\n";
result+="<td align='right' valign='middle' width='100'>"+rightcode+"</td>\n";
result+="</tr>\n";
result+="</table>\n";
result+="</div>\n";
return result;
}

int webpublishdialog:: nbpagesps(QString psfile)
{
QString line;
QString captured="0";
int result;
bool ok;
QFile f( psfile);
QRegExp rx( "^\%\%Pages:\\s+(-?\\d+)" );
if ( !f.open( IO_ReadOnly ) ) 
	{
	fatalerror(psfile+" not found.");
	return 0; 
	}
else
	{
	QTextStream PS( &f );
	while ( !PS.atEnd() ) 
		{
		line=PS.readLine();
		if (rx.search(line)>-1) 
			{
			captured = rx.cap( 1 );
			}
		}
	f.close();
	result=captured.toInt( &ok );
	if (ok  && (result>0)) 
		{
		return result;
		}
	else 
		{
		return 0;
		}
	}
}

QString webpublishdialog::codepic(QString pic_name, QString map_name)
{
QString result="<div id='content' align='"+ALIGN+"'><IMG src='"+pic_name+"' align='middle' border='0'";
if (map_name!="") result+=" usemap='#"+map_name+"'"; 
result+="></div>\n";
return result;
}

void webpublishdialog::ps2gif(QString input,QString output,int id_page,int w,int h,int maxw)
{
RunCommand("psselect -p"+QString::number(id_page)+" "+input+" page.ps",true);
if (ERROR) return;
float resolution=72*USERWIDTH/maxw;
float scale=USERWIDTH/maxw;
int gx=int(w*resolution/72+0.5); 
int gy=int(h*resolution/72+0.5); 
QFile psf(WORKDIR+"/page.ps");
if ( !psf.open( IO_ReadOnly ) ) {fatalerror(WORKDIR+"/page.ps"+" not found.");return;}
else
	{
	QTextStream PS( &psf );
	QFile outf(WORKDIR+"/tmp.ps");
	if ( !outf.open( IO_WriteOnly ) ) {fatalerror("Can't open "+WORKDIR+"/tmp.ps");return;}
	else
		{
		QTextStream OUT( &outf );
		bool flag=false;
		QString line;
		while ( !PS.atEnd() ) 
			{
			line=PS.readLine();
			if (line.find(QRegExp("^%%BoundingBox:\\s(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)/)"),0) !=-1) 
				{
				OUT << "%%BoundingBox: 0 0 "+QString::number(w)+" "+QString::number(h)+"\n";
				}
			else if ( (!flag) && ( (line.find(QRegExp("^%%EndSetup"),0) >-1) || (line.find(QRegExp("^%%Page:"),0) >-1) ) )
				{
				OUT << line+"\n";
				OUT << QString::number(x1)+" neg "+QString::number(y1)+" neg translate\n";
				flag=true;
				}
			else if (line.find(QRegExp("/uscale\\s+([0-9eE\\.\\-]+)\\s+N"),0) !=-1)
				{
				OUT << "/uscale "+QString::number(scale)+" N\n";
				}
			else
				{
				OUT << line+"\n";
				}
			}
		psf.close();
		outf.close();
		if (w!=0) 
			{
			RunCommand("gs -q -dSAFER -dBATCH -dNOPAUSE -sDEVICE=ppmraw  -g"+QString::number(gx)+"x"+QString::number(gy)+" -r"+QString::number(resolution)+" -dTextAlphaBits=4 -dGraphicsAlphaBits=4 -sOutputFile=tmp.ppm tmp.ps > link.txt",true);
			if (ERROR) return;
			if (NOINTERLACE) 
				{
				RunCommand("ppmquant -quiet -floyd "+QString::number(COLORDEPTH)+" tmp.ppm | ppmtogif -quiet > "+output+QString::number(id_page)+".gif",true);
				if (ERROR) return;
				}
			else
				{
				RunCommand("ppmquant -quiet -floyd "+QString::number(COLORDEPTH)+" tmp.ppm | ppmtogif -interlace -quiet > "+output+QString::number(id_page)+".gif",true);
				if (ERROR) return;
				}
			}
		else 
			{
				copyFile(PROGRAMDIR+"/blank.gif",HTMLDIR+"/"+output+QString::number(id_page)+".gif");
			}
		removeFile(WORKDIR+"/page.ps");
		removeFile(WORKDIR+"/tmp.ps");
		removeFile(WORKDIR+"/tmp.ppm");
		}
	}
}

void webpublishdialog::writepages(QString mode)
{
bool match=false;
bool ok;
int counter=1;
MAXWIDTH=1;
QString line;
QString captured1, captured2, captured3, captured4;
x1box.clear();
y1box.clear();
x2box.clear();
y2box.clear();

if (mode=="content")
	{
	QFile outf(WORKDIR+"/"+BASE+"_"+mode+".tex");
	if ( !outf.open( IO_WriteOnly ) ) {fatalerror("Can't open "+WORKDIR+"/"+BASE+"_"+mode+".tex");return;}
	else
		{
		QTextStream OUT( &outf );
		QFile texf(WORKDIR+"/"+BASE+".tex");
		if ( !texf.open( IO_ReadOnly ) ) {fatalerror(WORKDIR+"/"+BASE+".tex"+" not found.");return;}
		else
			{
			QTextStream TEX( &texf );
			while ( !TEX.atEnd() ) 
				{
				line=TEX.readLine();
				if (  !match && (line.find(QRegExp("^\\\\begin\\{document\\}"),0)!=-1)) 
					{
					OUT << "\\newbox\\bwk\\edef\\tempd#1pt{#1\\string p\\string t}\\tempd\\def\\nbextr#1pt{#1}\n";
					OUT << "\\def\\npts#1{\\expandafter\\nbextr\\the#1\\space}\n";
					OUT << "\\def\\ttwplink#1#2{\\special{ps:"+COLORLINK+" setrgbcolor}#2\\special{ps:0 0 0 setrgbcolor}\\setbox\\bwk=\\hbox{#2}\\special{ps:( linkto #1)\\space\\npts{\\wd\\bwk} \\npts{\\dp\\bwk} -\\npts{\\ht\\bwk} true\\space Cpos}}\n";
					match=true;
					}
				OUT << line+"\n";
				}
			texf.close();
			outf.close();
			messagetextEdit->append("Compiling input file. Please wait...\n");
			while (counter <= COMPIL) 
				{
				RunCommand("latex -interaction=nonstopmode "+BASE+"_"+mode+".tex",true);
				latexerror(WORKDIR+"/"+BASE+"_"+mode+".log");
				if (ERROR) break;
				counter++;
				}
			if (ERROR) return;
			QFile auxf(WORKDIR+"/"+BASE+"_content.aux");
			if ( !auxf.open( IO_ReadOnly ) ) {fatalerror(mode+WORKDIR+"/"+BASE+"_content.aux"+" not found.");return;}
			else
				{
				QTextStream AUX( &auxf );
				QRegExp rx( "\\\\newlabel\\{(.*)\\}\\{\\{.*\\}\\{(\\d+)\\}\\}" );
				while ( !AUX.atEnd() ) 
					{
					QString line=AUX.readLine();
					if (rx.search(line)!=-1) 
						{
						QString captured1 = rx.cap( 1 );
						QString captured2 = rx.cap( 2 );
						loc[captured1] = "page"+captured2+".html";
						}
					}
				auxf.close();
				}
			}
		}
	}
else if (mode=="index")
	{
	QFile outf(WORKDIR+"/"+BASE+"_"+mode+".tex");
	if ( !outf.open( IO_WriteOnly ) ) {fatalerror("Can't open "+WORKDIR+"/"+BASE+"_"+mode+".tex");return;}
	else
		{
		QTextStream OUT( &outf );
		QFile texf(WORKDIR+"/"+BASE+".tex");
		if ( !texf.open( IO_ReadOnly ) ) {fatalerror(WORKDIR+"/"+BASE+".tex"+" not found.");return;}
		else
			{
			QTextStream TEX( &texf );
			match=false;
			while ( !TEX.atEnd() ) 
				{
				line=TEX.readLine();
				if (line.find(QRegExp("^\\\\begin\\{document\\}"),0) >-1) 
					{
					match=true;
					}
				if (!match) 
					{
					OUT << line+"\n";
					}
				}
			texf.close();
			OUT << "\\pagestyle{empty}\n";
			OUT << "\\setcounter{tocdepth}{"+QString::number(TOCDEPTH)+"} \n";
			OUT << "\\newbox\\bwk\\edef\\tempd#1pt{#1\\string p\\string t}\\tempd\\def\\nbextr#1pt{#1}\n";
			OUT << "\\def\\npts#1{\\expandafter\\nbextr\\the#1\\space}\n";
			OUT << "\\def\\ttwplink#1#2{#2\\setbox\\bwk=\\vbox{#2}\\special{ps:( linkto #1)\\space\\npts{\\wd\\bwk} \\npts{\\dp\\bwk} -\\npts{\\ht\\bwk} false\\space Cpos}}\n";
			OUT << "\\begin{document}\n";
			OUT << "\\section*{"+CONTENTNAME+"}\n";
			OUT << "\\makeatletter\n\\parindent = 0.0 in\n";
			QFile auxf(WORKDIR+"/"+BASE+"_content.aux");
			if ( !auxf.open( IO_ReadOnly ) ) {fatalerror(mode+WORKDIR+"/"+BASE+"_content.aux"+" not found.");return;}
			else
				{
				QTextStream AUX( &auxf );
				QRegExp rx( "\\\\@writefile\\{toc\\}.*("+DEPTH+").*\\{(\\d+)\\}\\}" );
				while ( !AUX.atEnd() ) 
					{
					line=AUX.readLine();
					if (rx.search(line)>-1) 
						{
						captured2 = rx.cap( 2 );
						id_page=captured2.toInt( &ok );
						line.remove(QRegExp("\\\\@writefile\\{toc\\}"));
						if (line.find(QRegExp("\\\\numberline"),0) >-1) 
							{
							id_page=id_page+STARTINDEX-1;
							OUT << "\\ttwplink{page"+QString::number(id_page)+".html}";
							}
						else
							{
							OUT << "\\ttwplink{none}";
							}
						OUT << line+"\n\n";
						}
					}
				auxf.close();
				OUT << "\\end{document}" ;  
				outf.close();
				RunCommand("latex -interaction=nonstopmode "+BASE+"_"+mode+".tex",true);
				latexerror(WORKDIR+"/"+BASE+"_"+mode+".log");
				if (ERROR) return;
				}
			}
		}
	}
RunCommand("dvips -q "+DVIOPT+" -h psheader.txt -o "+BASE+"_"+mode+".ps "+BASE+"_"+mode+".dvi",true) ;
if (ERROR) return;
QString link="none";
int nb_link=0;
int W,H;
nb_pages=nbpagesps(WORKDIR+"/"+BASE+"_"+mode+".ps");
if (ERROR) return;
id_page=1;
messagetextEdit->append("Scanning files. Please wait...\n");
while ( id_page <= nb_pages ) 
	{
	RunCommand("psselect -p"+QString::number(id_page)+" "+BASE+"_"+mode+".ps page.ps",true);
	if (ERROR) return;
	RunCommand("gs -q -dBATCH -dNOPAUSE -sDEVICE=bbox -sOutputFile=-_ -f page.ps -c quit 2> bbox.txt",true);
	if (ERROR) return;
	QFile bboxf(WORKDIR+"/bbox.txt");
	if ( !bboxf.open( IO_ReadOnly ) ) {fatalerror(WORKDIR+"/bbox.txt"+" not found.");return;}
	else
		{
		QTextStream BBOX( &bboxf );
		QRegExp rx( "%%BoundingBox:\\s*([0-9eE\\.\\-]+)\\s+([0-9eE\\.\\-]+)\\s+([0-9eE\\.\\-]+)\\s+([0-9eE\\.\\-]+)" );
		while ( !BBOX.atEnd() ) 
			{
			QString line=BBOX.readLine();
			if (rx.search(line)!=-1) 
					{
					captured1 = rx.cap( 1 );
					x1=captured1.toInt( &ok );
					captured2 = rx.cap( 2 );
					y1=captured2.toInt( &ok );
					captured3 = rx.cap( 3 );
					x2=captured3.toInt( &ok );
					captured4 = rx.cap( 4 );
					y2=captured4.toInt( &ok );
					}
			}
		bboxf.close();
		x1box.append(x1);
		y1box.append(y1);
		x2box.append(x2);
		y2box.append(y2);
		W=x2-x1;
		if ( W > MAXWIDTH ) 
			{
			MAXWIDTH=W ;
			}
		}
	removeFile(WORKDIR+"/page.ps");
	removeFile(WORKDIR+"/bbox.txt");
	id_page++;  
	}
if (mode=="content")
	{
	id_page=1;
	nb_content_pages=nb_pages;
	while ( id_page <= nb_pages ) 
		{
		messagetextEdit->append("Writing page "+QString::number(id_page)+" of "+QString::number(nb_pages)+"\n");
		x1=x1box[id_page-1];
		y1=y1box[id_page-1];
		x2=x2box[id_page-1];
		y2=y2box[id_page-1];
		W=x2-x1;
		H=y2-y1;
		ps2gif(BASE+"_"+mode+".ps",HTMLDIR+"/image",id_page,W,H,MAXWIDTH);
		if (ERROR) return;
		QFile htmf(HTMLDIR+"/page"+QString::number(id_page)+".html");
		if ( !htmf.open( IO_WriteOnly ) ) {fatalerror("Can't open "+HTMLDIR+"/page"+QString::number(id_page)+".html");return;}
		else
			{
			QTextStream HTM( &htmf );
			HTM << header();
			if (NOINDEX)
				{
				HTM << content_navigation(id_page,nb_pages,"page1.html");
				}
			else
				{
				HTM << content_navigation(id_page,nb_pages,"index.html");
				}
			QFile linkf(WORKDIR+"/link.txt");
			if ( !linkf.open( IO_ReadOnly ) ) {fatalerror(WORKDIR+"/link.txt"+" not found.");return;}
			else
				{
				QTextStream LINK( &linkf );
				QRegExp rx( "x1=([0-9eE\\.\\-]+)\\s+y1=([0-9eE\\.\\-]+)\\s+x2=([0-9eE\\.\\-]+)\\s+y2=([0-9eE\\.\\-]+)\\s+linkto\\s+(.*)$" );
				nb_link = 0 ;
				HTM << "<map name='carte"+QString::number(id_page)+"'>\n" ;
				while ( !LINK.atEnd() ) 
					{
					line=LINK.readLine();
					if (rx.search(line)>-1) 
						{
						captured1 = rx.cap( 1 );
						x1=int(captured1.toFloat( &ok )+0.5);
						captured2 = rx.cap( 2 );
						y1=int(captured2.toFloat( &ok )+0.5);
						captured3 = rx.cap( 3 );
						x2=int(captured3.toFloat( &ok )+0.5);
						captured4 = rx.cap( 4 );
						y2=int(captured4.toFloat( &ok )+0.5);
						link=rx.cap( 5 );
						if (link !="none")
							{
							LinkMap::Iterator it=loc.find(link);
								if (it !=loc.end())
								{
								HTM << "<area shape='rect' coords='"+QString::number(x1)+","+QString::number(y1)+","+QString::number(x2)+","+QString::number(y2)+"' href='"+it.data()+"' >\n"  ;
								}
								else
								{
								HTM << "<area shape='rect' coords='"+QString::number(x1)+","+QString::number(y1)+","+QString::number(x2)+","+QString::number(y2)+"' href='"+link+"' >\n"  ;
								}
							}
						nb_link++;
						}
					}
				linkf.close();
				HTM << "</map>\n" ;
				if (nb_link >0) 
					{
					HTM << codepic("image"+QString::number(id_page)+".gif","carte"+QString::number(id_page));
					}
				else
					{
					HTM << codepic("image"+QString::number(id_page)+".gif","");
					}
				if (NOINDEX)
					{
					HTM << content_navigation(id_page,nb_pages,"page1.html");
					}
				else
					{
					HTM << content_navigation(id_page,nb_pages,"index.html");
					}
				HTM << footer();
				htmf.close() ;
				
				}
			}
		id_page++; 
		}
	}
else if (mode=="index")
	{
	messagetextEdit->append("Writing index page\n");
	QFile htmf(HTMLDIR+"/index.html");
	if ( !htmf.open( IO_WriteOnly ) ) {fatalerror("Can't open "+HTMLDIR+"/index.html");return;}
	else
		{
		QTextStream HTM( &htmf );
		HTM << header();
		HTM << content_navigation(0,1,"");
		id_page=1;
		while ( id_page <= nb_pages ) 
			{
			x1=x1box[id_page-1];
			y1=y1box[id_page-1];
			x2=x2box[id_page-1];
			y2=y2box[id_page-1];
			W=x2-x1;
			H=y2-y1;
			ps2gif(BASE+"_"+mode+".ps",HTMLDIR+"/"+mode+"image",id_page,W,H,MAXWIDTH);
			if (ERROR) return;
			QFile linkf(WORKDIR+"/link.txt");
			if ( !linkf.open( IO_ReadOnly ) ) {fatalerror(WORKDIR+"/link.txt"+" not found.");return;}
			else
				{
				QTextStream LINK( &linkf );
				QRegExp rx( "x1=([0-9eE\\.\\-]+)\\s+y1=([0-9eE\\.\\-]+)\\s+x2=([0-9eE\\.\\-]+)\\s+y2=([0-9eE\\.\\-]+)\\s+linkto\\s+(.*)$" );
				nb_link = 0 ;
				HTM << "<map name='carte"+QString::number(id_page)+"'>\n" ;
				while ( !LINK.atEnd() ) 
					{
					line=LINK.readLine();
					if (rx.search(line)>-1) 
						{
						captured1 = rx.cap( 1 );
						x1=int(captured1.toFloat( &ok )+0.5);
						captured2 = rx.cap( 2 );
						y1=int(captured2.toFloat( &ok )+0.5);
						captured3 = rx.cap( 3 );
						x2=int(captured3.toFloat( &ok )+0.5);
						captured4 = rx.cap( 4 );
						y2=int(captured4.toFloat( &ok )+0.5);
						link=rx.cap( 5 );
						if (link !="none")
							{
							HTM << "<area shape='rect' coords='"+QString::number(x1)+","+QString::number(y1)+","+QString::number(x2)+","+QString::number(y2)+"' href='"+link+"' >\n"  ;
							}
						nb_link++;
						}
					}
				linkf.close();
				HTM << "</map>\n" ;
				}
			id_page++; 
			}
		id_page=1;
		while ( id_page <= nb_pages ) 
		{
			HTM << codepic(mode+"image"+QString::number(id_page)+".gif","carte"+QString::number(id_page));
			id_page++; 
		}
		HTM << content_navigation(0,1,"");
		HTM << footer();
		htmf.close();
		}
	}
}

void webpublishdialog::SlotEndProcess()
{
FINPROCESS=true;
}

void webpublishdialog::fatalerror(QString msg)
{
clean();
messagetextEdit->append("Fatal error : "+msg);
ERROR=true;
}

void webpublishdialog::clean()
{
removeFile(WORKDIR+"/psheader.txt");
removeFile(WORKDIR+"/link.txt");
QStringList extension=QStringList::split( ",",".tex,.log,.aux,.dvi,.lof,.lot,.bit,.idx,.glo,.bbl,.ilg,.toc,.ind,.ps");
for ( QStringList::Iterator it = extension.begin(); it != extension.end(); ++it ) 
		{
		removeFile(WORKDIR+"/"+BASE+"_content"+*it);
		removeFile(WORKDIR+"/"+BASE+"_index"+*it);
		}
}

void webpublishdialog::latexerror(QString logfile)
{
QString text;
QFile logf(logfile);
if ( !logf.open( IO_ReadOnly ) ) {fatalerror(logfile+" not found.");}
else
	{
	QTextStream LOG( &logf );
	text=LOG.read();
	if (text.find("!",0)!=-1) {fatalerror("LaTeX errors detected.");}
	}
}
void webpublishdialog::aboutSlot()
{
 QMessageBox::about(this,"About...", "<h3>LaTeX to Html conversion tool</h3>"
  "This program is licensed to you under the terms of the "
  "GNU General Public License Version 2 as published "
  "by the Free Software Foundation. <br>"
  "<br><i>Copyright (c) 2004 by P.Brachet & J.Amblard</i>" );
}

void webpublishdialog::proceedSlot()
{
messagetextEdit->clear();
applyusersettings();
convert(inputfileEdit->text());
}

void webpublishdialog::browseSlot()
{
QString fn = QFileDialog::QFileDialog::getOpenFileName(LASTDIR,"TeX files (*.tex);;All files (*.*)",this,"Open File","Open File" );
if ( !fn.isEmpty() ) 
	{
	inputfileEdit->setText( fn );
	}
}

void webpublishdialog::writesettings()
{
applyusersettings();
QSettings settings;
settings.setPath( "xm1", "qttwp" );
settings.beginGroup( "/qttwp" );
settings.writeEntry("/colordepth",COLORDEPTH);
settings.writeEntry("/userwidth",USERWIDTH);
settings.writeEntry("/compil",COMPIL);
settings.writeEntry("/tocdepth",TOCDEPTH);
settings.writeEntry("/startindex",STARTINDEX);
settings.writeEntry("/navigation",NAVIGATION);
settings.writeEntry("/nointerlace",NOINTERLACE);
settings.writeEntry("/noindex",NOINDEX);
settings.writeEntry("/title",TITLE);
settings.writeEntry("/address",ADDRESS);
settings.writeEntry("/browser",BROWSER);
settings.writeEntry("/contentname",CONTENTNAME);
settings.writeEntry("/align",ALIGN);
settings.writeEntry("/lastdir",LASTDIR);
settings.writeEntry("/dviopt",DVIOPT);
settings.endGroup();
}

void webpublishdialog::readsettings()
{
QSettings settings;
settings.setPath( "xm1", "qttwp" );
settings.beginGroup( "/qttwp" );
COLORDEPTH=settings.readNumEntry("/colordepth",32);
USERWIDTH=settings.readNumEntry("/userwidth",700);
COMPIL=settings.readNumEntry("/compil",1);
TOCDEPTH=settings.readNumEntry("/tocdepth",2);
STARTINDEX=settings.readNumEntry("/startindex",1);
NAVIGATION=settings.readNumEntry("/navigation",1);
NOINTERLACE=settings.readBoolEntry("/nointerlace",false);
NOINDEX=settings.readBoolEntry("/noindex",false);
TITLE=settings.readEntry("/title","");
ADDRESS=settings.readEntry("/address","");
#ifdef Q_WS_X11
BROWSER=settings.readEntry("/browser","mozilla");
#endif
#ifdef Q_WS_MACX
BROWSER=settings.readEntry("/browser","/Applications/Safari.app/Contents/MacOS/Safari");
#endif
#if defined(Q_WS_WIN)
BROWSER=settings.readEntry("/browser","");
#endif
CONTENTNAME=settings.readEntry("/contentname","\\contentsname");
ALIGN=settings.readEntry("/align","center");
LASTDIR=settings.readEntry("/lastdir",QDir::homeDirPath());
DVIOPT=settings.readEntry("/dviopt"," -Ppk -V");
PROGRAMDIR=PREFIX"/share/texmaker";
settings.endGroup();
}

void webpublishdialog::applyusersettings()
{
TITLE=titleEdit->text();
ADDRESS=footnoteEdit->text();
BROWSER=browserEdit->text();
CONTENTNAME=contentEdit->text();
if (indexcomboBox->currentItem()==0) NOINDEX=false;
else NOINDEX=true;
if (alignmentcomboBox->currentItem()==0) ALIGN="left";
if (alignmentcomboBox->currentItem()==1) ALIGN="center";
if (alignmentcomboBox->currentItem()==2) ALIGN="right";
if (navigationBox->currentItem()==0) NAVIGATION=1;
else NAVIGATION=0;
if (interlacecomboBox->currentItem()==0) NOINTERLACE=false;
else NOINTERLACE=true;
if (colordepthcomboBox->currentItem()==0) COLORDEPTH=4;
if (colordepthcomboBox->currentItem()==1) COLORDEPTH=8;
if (colordepthcomboBox->currentItem()==2) COLORDEPTH=32;
if (colordepthcomboBox->currentItem()==3) COLORDEPTH=128;
if (colordepthcomboBox->currentItem()==4) COLORDEPTH=256;
USERWIDTH=widthspinBox->value();
COMPIL=compilationspinBox->value();
TOCDEPTH=tocdepthspinBox->value();
STARTINDEX=startindexspinBox->value();  
}
