/***************************************************************************
 *   copyright            : (C) 2003 by Pascal Brachet                     *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "toolsoptionsdialog.h"

#include <qvariant.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qfontdatabase.h>
#include <qstringlist.h>
#include <qtextcodec.h>

toolsoptionsdialog::toolsoptionsdialog( QWidget* parent,  const char* name)
    :QDialog( parent, "Configure Texmaker",true )
{
    setSizeGripEnabled( TRUE );
    ToolDialogLayout = new QGridLayout( this, 1, 1, 11, 6, "ToolDialogLayout"); 

    tabWidget = new QTabWidget( this, "tabWidget" );

    Widget2 = new QWidget( tabWidget, "Widget2" );

    buttonGroupQuickBuild = new QButtonGroup( Widget2, "buttonGroupQuickBuild" );
    buttonGroupQuickBuild->setGeometry( QRect( 11, 9, 500, 190 ) );
    buttonGroupQuickBuild->setExclusive( TRUE );

    checkBox5 = new QCheckBox( buttonGroupQuickBuild, "checkBox5" );
    checkBox5->setGeometry( QRect( 20, 150, 260, 21 ) );

    checkBox4 = new QCheckBox( buttonGroupQuickBuild, "checkBox4" );
    checkBox4->setGeometry( QRect( 20, 120, 250, 21 ) );

    checkBox3 = new QCheckBox( buttonGroupQuickBuild, "checkBox3" );
    checkBox3->setGeometry( QRect( 20, 90, 260, 21 ) );

    checkBox2 = new QCheckBox( buttonGroupQuickBuild, "checkBox2" );
    checkBox2->setGeometry( QRect( 20, 60, 260, 21 ) );

    checkBox1 = new QCheckBox( buttonGroupQuickBuild, "checkBox1" );
    checkBox1->setGeometry( QRect( 20, 30, 260, 21 ) );

    groupBoxCommands = new QGroupBox( Widget2, "groupBoxCommands" );
    groupBoxCommands->setGeometry( QRect( 11, 209, 500, 210 ) );

    textLabelPsviewer = new QLabel( groupBoxCommands, "textLabelPsviewer" );
    textLabelPsviewer->setGeometry( QRect( 10, 140, 80, 21 ) );

    textLabelDviviewer = new QLabel( groupBoxCommands, "textLabelDviviewer" );
    textLabelDviviewer->setGeometry( QRect( 10, 110, 80, 21 ) );

    textLabeldvips = new QLabel( groupBoxCommands, "textLabeldvips" );
    textLabeldvips->setGeometry( QRect( 10, 50, 80, 21 ) );

    textLabelLatex = new QLabel( groupBoxCommands, "textLabelLatex" );
    textLabelLatex->setGeometry( QRect( 10, 20, 80, 21 ) );

    lineEditLatex = new QLineEdit( groupBoxCommands, "lineEditLatex" );
    lineEditLatex->setGeometry( QRect( 100, 20, 140, 24 ) );

    lineEditDvips = new QLineEdit( groupBoxCommands, "lineEditDvips" );
    lineEditDvips->setGeometry( QRect( 100, 50, 141, 24 ) );

    textLabelps2pdf = new QLabel( groupBoxCommands, "textLabelps2pdf" );
    textLabelps2pdf->setGeometry( QRect( 10, 80, 80, 21 ) );

    lineEditPs2pdf = new QLineEdit( groupBoxCommands, "lineEditPs2pdf" );
    lineEditPs2pdf->setGeometry( QRect( 100, 80, 141, 24 ) );

    lineEditDviviewer = new QLineEdit( groupBoxCommands, "lineEditDviviewer" );
    lineEditDviviewer->setGeometry( QRect( 100, 110, 141, 24 ) );

    lineEditPsviewer = new QLineEdit( groupBoxCommands, "lineEditPsviewer" );
    lineEditPsviewer->setGeometry( QRect( 100, 140, 141, 24 ) );

    textLabelPdflatex = new QLabel( groupBoxCommands, "textLabelPdflatex" );
    textLabelPdflatex->setGeometry( QRect( 260, 20, 81, 21 ) );

    textLabeldvipdfm = new QLabel( groupBoxCommands, "textLabeldvipdfm" );
    textLabeldvipdfm->setGeometry( QRect( 260, 50, 81, 21 ) );

    textLabelbibtex = new QLabel( groupBoxCommands, "textLabelbibtex" );
    textLabelbibtex->setGeometry( QRect( 260, 80, 81, 21 ) );

    textLabelmakeindex = new QLabel( groupBoxCommands, "textLabelmakeindex" );
    textLabelmakeindex->setGeometry( QRect( 260, 110, 81, 21 ) );

    textLabelPdfviewer = new QLabel( groupBoxCommands, "textLabelPdfviewer" );
    textLabelPdfviewer->setGeometry( QRect( 260, 140, 81, 21 ) );

    textLabelmetapost = new QLabel( groupBoxCommands, "textLabelmetapost" );
    textLabelmetapost->setGeometry( QRect( 10, 170, 81, 21 ) );

    lineEditPdflatex = new QLineEdit( groupBoxCommands, "lineEditPdflatex" );
    lineEditPdflatex->setGeometry( QRect( 340, 20, 141, 24 ) );

    lineEditDvipdfm = new QLineEdit( groupBoxCommands, "lineEditDvipdfm" );
    lineEditDvipdfm->setGeometry( QRect( 340, 50, 141, 24 ) );

    lineEditBibtex = new QLineEdit( groupBoxCommands, "lineEditBibtex" );
    lineEditBibtex->setGeometry( QRect( 340, 80, 141, 24 ) );

    lineEditMakeindex = new QLineEdit( groupBoxCommands, "lineEditMakeindex" );
    lineEditMakeindex->setGeometry( QRect( 340, 110, 141, 24 ) );

    lineEditPdfviewer = new QLineEdit( groupBoxCommands, "lineEditPdfviewer" );
    lineEditPdfviewer->setGeometry( QRect( 340, 140, 141, 24 ) );

    lineEditMetapost = new QLineEdit( groupBoxCommands, "lineEditMetapost" );
    lineEditMetapost->setGeometry( QRect( 100, 170, 141, 24 ) );
    tabWidget->insertTab( Widget2, QString("") );

    Widget3 = new QWidget( tabWidget, "Widget3" );

    comboBoxFont = new QComboBox( FALSE, Widget3, "comboBoxFont" );
    comboBoxFont->setGeometry( QRect( 210, 20, 200, 21 ) );
    QFontDatabase fdb;
    comboBoxFont->insertStringList( fdb.families() );
    comboBoxFont->setEditable( TRUE );

    textLabelFont = new QLabel( Widget3, "textLabelFont" );
    textLabelFont->setGeometry( QRect( 20, 20, 160, 20 ) );

    textLabelSize = new QLabel( Widget3, "textLabelSize" );
    textLabelSize->setGeometry( QRect( 20, 60, 160, 21 ) );

    textLabelEncoding = new QLabel( Widget3, "textLabelEncoding" );
    textLabelEncoding->setGeometry( QRect( 20, 100, 160, 21 ) );

    comboBoxEncoding = new QComboBox( FALSE, Widget3, "comboBoxEncoding" );
    comboBoxEncoding->setGeometry( QRect( 210, 100, 201, 21 ) );
    QTextCodec *codec;
    for (int i = 0; (codec = QTextCodec::codecForIndex(i)); i++) comboBoxEncoding->insertItem(codec->name(),0);
    
    spinBoxSize = new QSpinBox( Widget3, "spinBoxSize" );
    spinBoxSize->setGeometry( QRect( 310, 60, 101, 21 ) );
    spinBoxSize->setMinValue( 1 );
    spinBoxSize->setValue( 12 );

    checkBoxWordwrap = new QCheckBox( Widget3, "checkBoxWordwrap" );
    checkBoxWordwrap->setGeometry( QRect( 20, 140, 160, 21 ) );

    checkBoxLinenumber = new QCheckBox( Widget3, "checkBoxLinenumber" );
    checkBoxLinenumber->setGeometry( QRect( 20, 180, 160, 21 ) );
    tabWidget->insertTab( Widget3, QString("") );

    ToolDialogLayout->addWidget( tabWidget, 0, 1 );

    Layout1 = new QHBoxLayout( 0, 0, 6, "Layout1"); 
    Horizontal_Spacing2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( Horizontal_Spacing2 );

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setAutoDefault( TRUE );
    buttonOk->setDefault( TRUE );
    Layout1->addWidget( buttonOk );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setAutoDefault( TRUE );
    Layout1->addWidget( buttonCancel );

    ToolDialogLayout->addMultiCellLayout( Layout1, 1, 1, 0, 1 );
    resize( QSize(558, 524).expandedTo(minimumSizeHint()) );

    // signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    
    setCaption( "Configure Texmaker");
    buttonGroupQuickBuild->setTitle( "Quick Build Command");
    checkBox5->setText( "LaTeX + dvips + ps2pdf + View PDF");
    checkBox4->setText( "LaTeX + dvipdfm + View PDF");
    checkBox3->setText( "PdfLaTeX + View PDF" );
    checkBox2->setText( "LaTeX + View DVI" );
    checkBox1->setText( "LaTeX + dvips + View PS" );
    groupBoxCommands->setTitle( "Commands (% : filename without extension)" );
    textLabelPsviewer->setText( "PS Viewer" );
    textLabelDviviewer->setText( "Dvi Viewer" );
    textLabeldvips->setText( "dvips" );
    textLabelLatex->setText( "LaTeX" );
    textLabelps2pdf->setText( "ps2pdf" );
    textLabelPdflatex->setText( "PdfLaTeX" );
    textLabeldvipdfm->setText( "Dvipdfm" );
    textLabelbibtex->setText( "bibtex" );
    textLabelmakeindex->setText( "makeindex" );
    textLabelPdfviewer->setText( "Pdf Viewer" );
    textLabelmetapost->setText( "metapost" );
    tabWidget->changeTab( Widget2, "Commands" );
    textLabelFont->setText( "Editor Font Family" );
    textLabelSize->setText( "Editor Font Size" );
    textLabelEncoding->setText( "Editor Font Encoding" );
    checkBoxWordwrap->setText( "Word Wrap" );
    checkBoxLinenumber->setText( "Show Line Numbers" );
    tabWidget->changeTab( Widget3, "Editor" );
    buttonOk->setText( "OK" );
    buttonCancel->setText( "Cancel" );
}

toolsoptionsdialog::~toolsoptionsdialog()
{

}
