/***************************************************************************
 *   copyright            : (C) 2003 by Pascal Brachet                     *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/



#include <stdlib.h>
#include "texmaker.h"

#include <qiconset.h>
#include <qtimer.h>
#include <qpopupmenu.h>
#include <qtabwidget.h>
#include <qapplication.h>
#include <qfontdatabase.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qheader.h>
#include <qregexp.h>
#include <qtooltip.h>
#include <qvaluelist.h>
#include <qmap.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qtextstream.h>
#include <qtextcodec.h>
#include <qmetaobject.h>
#include <qstatusbar.h>
#include <qaction.h>
#include <qtoolbar.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qtoolbutton.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qsimplerichtext.h>
#include <qsettings.h>
#include <qevent.h>
#include <qeventloop.h> 

Texmaker::Texmaker( QWidget *parent, const char *name ):QMainWindow( parent, name )
{
ReadSettings();
setupActions();
setIcon(QPixmap::fromMimeSource( "appicon.png"));
QStatusBar * status=statusBar();
stat1=new QLabel( status );
stat2=new QLabel( status );
stat3=new QLabel( status );
status->addWidget(stat1, 0, true );
status->addWidget(stat2, 0, true );
status->addWidget(stat3, 0, true );
topWidgetStack = new QWidgetStack( this );
topWidgetStack->setFocusPolicy(QWidget::NoFocus);
splitter1=new QSplitter(QSplitter::Horizontal,topWidgetStack, "splitter1" );


Structview=new QFrame(splitter1);
Structview->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
Structview->setLineWidth( 2 );
Structview_layout=0;
ButtonBar=new KMultiVertTabBar(Structview);

ButtonBar->insertTab(QPixmap::fromMimeSource( "structure.png"),0,"Structure");
connect(ButtonBar->getTab(0),SIGNAL(clicked(int)),this,SLOT(showVertPage(int)));
outstruct = new QListView( Structview );
outstruct->setFocusPolicy(QWidget::ClickFocus);
outstruct->header()->hide();
outstruct->addColumn("Structure",-1);
outstruct->setSorting(-1,true);
connect( outstruct, SIGNAL(clicked(QListViewItem *)), SLOT(ClickedOnStructure(QListViewItem *)));
connect( outstruct, SIGNAL(doubleClicked(QListViewItem *)), SLOT(DoubleClickedOnStructure(QListViewItem *)));
QToolTip::add(outstruct, "Click to jump to the line");
mpview = new metapostview( Structview );
connect(mpview, SIGNAL(clicked(QListBoxItem *)), SLOT(InsertMetaPost(QListBoxItem *)));


symbol_present=false;
ButtonBar->insertTab(QPixmap::fromMimeSource( "math1.png"),1,"Relation symbols");
connect(ButtonBar->getTab(1),SIGNAL(clicked(int)),this,SLOT(showVertPage(int)));
ButtonBar->insertTab(QPixmap::fromMimeSource( "math2.png"),2,"Arrow symbols");
connect(ButtonBar->getTab(2),SIGNAL(clicked(int)),this,SLOT(showVertPage(int)));
ButtonBar->insertTab(QPixmap::fromMimeSource( "math3.png"),3,"Miscellaneous symbols");
connect(ButtonBar->getTab(3),SIGNAL(clicked(int)),this,SLOT(showVertPage(int)));
ButtonBar->insertTab(QPixmap::fromMimeSource( "math4.png"),4,"Delimiters");
connect(ButtonBar->getTab(4),SIGNAL(clicked(int)),this,SLOT(showVertPage(int)));
ButtonBar->insertTab(QPixmap::fromMimeSource( "math5.png"),5,"Greek letters");
connect(ButtonBar->getTab(5),SIGNAL(clicked(int)),this,SLOT(showVertPage(int)));
ButtonBar->insertTab(QPixmap::fromMimeSource( "metapost.png"),6,"MetaPost Commands");
connect(ButtonBar->getTab(6),SIGNAL(clicked(int)),this,SLOT(showVertPage(int)));

splitter2=new QSplitter(QSplitter::Vertical,splitter1 , "splitter2" );
tabWidget=new QTabWidget(splitter2);
tabWidget->setFocusPolicy(QWidget::ClickFocus);
tabWidget->setFocus();
connect( tabWidget, SIGNAL( currentChanged( QWidget * ) ), this, SLOT(UpdateCaption()) );

Outputview=new QTabWidget(splitter2);
Outputview->setFocusPolicy(QWidget::ClickFocus);
OutputWidget = new MessageWidget( Outputview );
OutputWidget->setFocusPolicy(QWidget::ClickFocus);
OutputWidget->setMinimumHeight(40);
OutputWidget->setReadOnly(true);
Outputview->addTab(OutputWidget,QPixmap::fromMimeSource( "viewlog.png"), "Messages / Log File");
logpresent=false;
errorlist=new QStrList();
connect(OutputWidget, SIGNAL(clicked(int,int)),this,SLOT(ClickedOnOutput(int,int)));
QValueList<int> sizes;
sizes << split2_top << split2_bottom;
splitter2->setSizes( sizes );
sizes.clear();
sizes << split1_left << split1_right;
splitter1->setSizes( sizes );

topWidgetStack->addWidget(splitter1 , 0);
setCentralWidget(topWidgetStack);
ShowOutputView(false);
ShowStructView(false);
Outputview->showPage(OutputWidget);
lastvtab=1;
UpdateCaption();
showVertPage(0);
singlemode=true;
MasterName=getName();
show();
stat1->setText("Line : Col :");
stat2->setText("Normal Mode");
stat3->setText("Ready");
}

Texmaker::~Texmaker()
{
}

void Texmaker::setupActions()
{
    QStringList list;
    QToolBar *tb1 = new QToolBar( this );
    tb1->setLabel( "File Actions" );
    QPopupMenu *menu1 = new QPopupMenu( this );
    menuBar()->insertItem( "&File" , menu1 );

    QAction *a;
    a = new QAction( "New" , QPixmap::fromMimeSource( "filenew.png"), "&New..." , CTRL + Key_N, this, "fileNew" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileNew() ) );
    a->addTo( tb1 );
    a->addTo( menu1 );
    a = new QAction( "Open" , QPixmap::fromMimeSource( "fileopen.png"), "&Open..." , CTRL + Key_O, this, "fileOpen" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileOpen() ) );
    a->addTo( tb1 );
    a->addTo( menu1 );
    menu1->insertSeparator();

    recent = new QPopupMenu();
    for (uint i=0; i<recentFilesList->count(); i++)
    recent->insertItem(recentFilesList->at(i));
    menu1->insertItem ("Open Recent", recent);
    connect(recent, SIGNAL(activated(int)), SLOT(fileOpenRecent(int)));
    menu1->insertSeparator();


    a = new QAction( "Save" , QPixmap::fromMimeSource( "filesave.png"), "&Save..." , CTRL + Key_S, this, "fileSave" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileSave() ) );
    a->addTo( tb1 );
    a->addTo( menu1 );
    a = new QAction( "Save As" , "Save &As..." , 0, this, "fileSaveAs" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileSaveAs() ) );
    a->addTo( menu1 );
    menu1->insertItem("Save All", this, SLOT(fileSaveAll()));
    menu1->insertSeparator();
    a = new QAction( "Print Source" , "&Print Source" , CTRL + Key_P, this, "filePrint" );
    connect( a, SIGNAL( activated() ), this, SLOT( filePrint() ) );
    a->addTo( menu1 );
    a = new QAction( "Close" , QPixmap::fromMimeSource( "fileclose.png"), "C&lose" , CTRL + Key_W, this, "fileClose" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileClose() ) );
    a->addTo( tb1 );
    a->addTo( menu1 );
    menu1->insertItem("Close All", this, SLOT(fileCloseAll()));
    menu1->insertSeparator();
    a = new QAction( "Exit" ,QPixmap::fromMimeSource( "exit.png"), "E&xit" , 0, this, "fileExit" );
    connect( a, SIGNAL( activated() ), this, SLOT( fileExit() ) );
    a->addTo( menu1 );
    tb1->addSeparator();

        QPopupMenu *menu2 = new QPopupMenu( this );
    menuBar()->insertItem( "&Edit" , menu2 );

    a = new QAction( "Undo" , QPixmap::fromMimeSource( "undo.png" ), "&Undo" , CTRL + Key_Z, this, "undo" );
    connect( a, SIGNAL( activated() ), this, SLOT( editUndo() ) );
    a->addTo( tb1 );
    a->addTo( menu2 );
    a = new QAction( "Redo" , QPixmap::fromMimeSource( "redo.png" ), "&Redo" , CTRL + Key_Y, this, "redo" );
    connect( a, SIGNAL( activated() ), this, SLOT( editRedo() ) );
    a->addTo( tb1 );
    a->addTo( menu2 );
    menu2->insertSeparator();
    a = new QAction( "Copy" , QPixmap::fromMimeSource( "editcopy.png" ), "&Copy" , CTRL + Key_C, this, "editCopy" );
    connect( a, SIGNAL( activated() ), this, SLOT( editCopy() ) );
    a->addTo( tb1 );
    a->addTo( menu2 );
    a = new QAction( "Cut" , QPixmap::fromMimeSource( "editcut.png" ), "Cu&t" , CTRL + Key_X, this, "editCut" );
    connect( a, SIGNAL( activated() ), this, SLOT( editCut() ) );
    a->addTo( tb1 );
    a->addTo( menu2 );
    a = new QAction( "Paste" , QPixmap::fromMimeSource( "editpaste.png" ), "&Paste" , CTRL + Key_V, this, "editPaste" );
    connect( a, SIGNAL( activated() ), this, SLOT( editPaste() ) );
    a->addTo( tb1 );
    a->addTo( menu2 );
    a = new QAction( "Select All" , "Select &All" , CTRL + Key_A, this,0 );
    connect( a, SIGNAL( activated() ), this, SLOT(editSelectAll() ) );
    a->addTo( menu2 );
    menu2->insertSeparator();
    a = new QAction( "Comment" , "C&omment Selection" , 0, this, 0 );
    connect( a, SIGNAL( activated() ), this, SLOT( editComment() ) );
    a->addTo( menu2 );
    a = new QAction( "Uncomment" ,"Unco&mment Selection" , 0, this, 0 );
    connect( a, SIGNAL( activated() ), this, SLOT( editUncomment() ) );
    a->addTo( menu2 );
a = new QAction( "Indent" ,"&Indent Selection" , 0, this, 0 );
    connect( a, SIGNAL( activated() ), this, SLOT( editIndent() ) );
    a->addTo( menu2 );
    menu2->insertSeparator();
    a = new QAction(  "Find" , "&Find..." , CTRL + Key_F, this, 0 );
    connect( a, SIGNAL( activated() ), this, SLOT( editFind() ) );
    a->addTo( menu2 );
a = new QAction(  "FindNext" , "Find &Next" , CTRL + Key_M, this, 0 );
    connect( a, SIGNAL( activated() ), this, SLOT(editFindNext() ) );
    a->addTo( menu2 );
    a = new QAction( "Replace" ,"&Replace..." , CTRL + Key_R, this, 0 );
    connect( a, SIGNAL( activated() ), this, SLOT( editReplace() ) );
    a->addTo( menu2 );
    a = new QAction( "Goto Line" ,QPixmap::fromMimeSource( "goto.png" ),"&Goto Line..." , CTRL + Key_G, this, 0 );
    connect( a, SIGNAL( activated() ), this, SLOT( editGotoLine() ) );
    a->addTo( menu2 );
    menu2->insertSeparator();
    menu2->insertItem("Refresh Structure", this, SLOT(UpdateStructure()));

    QToolBar *tb3 = new QToolBar( this );
    tb3->setLabel( "Tool Actions" );
    QToolButton *but;
    but = new QToolButton(QPixmap::fromMimeSource( "quick.png" ), "Quick Build", 0, this, SLOT(QuickBuild()),tb3, "Quick Build" );
    tb3->addSeparator();
    but = new QToolButton(QPixmap::fromMimeSource( "viewlog.png" ), "View Log File", 0, this, SLOT(ViewLog()),tb3, "View Log File" );
    but = new QToolButton(QPixmap::fromMimeSource( "errorprev.png" ) , "Previous LaTeX Error", 0, this, SLOT(PreviousError()),tb3, "Previous LaTeX Error" );
    but = new QToolButton(QPixmap::fromMimeSource( "errornext.png" ) , "Next LaTeX Error", 0, this, SLOT(NextError()),tb3, "Next LaTeX Error" );
    tb3->addSeparator();
    but = new QToolButton(QPixmap::fromMimeSource( "latex.png" ) , "LaTeX", 0, this, SLOT(Latex()),tb3, "LaTeX" );
    but = new QToolButton(QPixmap::fromMimeSource( "viewdvi.png" ) , "View DVI", 0, this, SLOT(ViewDvi()),tb3, "View DVI" );
    but = new QToolButton(QPixmap::fromMimeSource( "dvips.png" ) , "DVI to PS", 0, this, SLOT(DviToPS()),tb3, "DVI to PS" );
    but = new QToolButton(QPixmap::fromMimeSource( "viewps.png" ) , "View PS", 0, this, SLOT(ViewPS()),tb3, "View PS" );
    tb3->addSeparator();
    but = new QToolButton(QPixmap::fromMimeSource( "pdflatex.png" ) , "PDFLaTeX", 0, this, SLOT(PDFLatex()),tb3, "PDFLaTeX" );
    but = new QToolButton(QPixmap::fromMimeSource( "viewpdf.png" ) , "View PDF", 0, this, SLOT(ViewPDF()),tb3, "View PDF" );

    QPopupMenu *menu3 = new QPopupMenu( this );
    menuBar()->insertItem( "&Tools" , menu3 );

    a = new QAction(  "Quick Build",QPixmap::fromMimeSource( "quick.png" ) , "&Quick Build" , Key_F1, this, "Quick Build" );
    connect( a, SIGNAL( activated() ), this, SLOT(QuickBuild() ) );
    a->addTo( menu3 );
    menu3->insertSeparator();

    a = new QAction( "LaTeX" ,QPixmap::fromMimeSource( "latex.png" ) , "&LaTeX" , Key_F2, this, "Latex" );
    connect( a, SIGNAL( activated() ), this, SLOT(Latex() ) );
    a->addTo( menu3 );

    a = new QAction( "View Dvi" ,QPixmap::fromMimeSource( "viewdvi.png" ) , "View &Dvi" , Key_F3, this, "ViewDvi" );
    connect( a, SIGNAL( activated() ), this, SLOT(ViewDvi() ) );
    a->addTo( menu3 );

    a = new QAction( "Dvi to PS" ,QPixmap::fromMimeSource( "dvips.png" ), "Dvi &to PS" , Key_F4, this, "DviToPS" );
    connect( a, SIGNAL( activated() ), this, SLOT(DviToPS() ) );
    a->addTo( menu3 );

    a = new QAction( "View PS" ,QPixmap::fromMimeSource( "viewps.png" ) , "View &PS" , Key_F5, this, "ViewPS" );
    connect( a, SIGNAL( activated() ), this, SLOT(ViewPS() ) );
    a->addTo( menu3 );
    menu3->insertSeparator();
    a = new QAction( "PDFLaTeX" ,QPixmap::fromMimeSource( "pdflatex.png" ) , "PD&FLaTeX" , Key_F6, this, "PDFLatex" );
    connect( a, SIGNAL( activated() ), this, SLOT(PDFLatex() ) );
    a->addTo( menu3 );

    a = new QAction( "View PDF" ,QPixmap::fromMimeSource( "viewpdf.png" ) , "&View PDF" , Key_F7, this, "ViewPDF" );
    connect( a, SIGNAL( activated() ), this, SLOT(ViewPDF() ) );
    a->addTo( menu3 );

    a = new QAction( "PStoPDF" , QPixmap::fromMimeSource( "ps2pdf.png" ),"PStoPDF" , Key_F8, this, "PStoPDF" );
    connect( a, SIGNAL( activated() ), this, SLOT(PStoPDF() ) );
    a->addTo( menu3 );

    a = new QAction( "DVItoPDF" ,QPixmap::fromMimeSource( "dvipdf.png"), "DVItoPDF" , Key_F9, this, "DVItoPDF" );
    connect( a, SIGNAL( activated() ), this, SLOT(DVItoPDF() ) );
    a->addTo( menu3 );
    menu3->insertSeparator();
    a = new QAction( "View Log" ,QPixmap::fromMimeSource( "viewlog.png") , "View Lo&g" , Key_F10, this, "ViewLog" );
    connect( a, SIGNAL( activated() ), this, SLOT(ViewLog() ) );
    a->addTo( menu3 );

    a = new QAction( "BibTeX" , "BibTeX" , Key_F11, this, "MakeBib" );
    connect( a, SIGNAL( activated() ), this, SLOT(MakeBib() ) );
    a->addTo( menu3 );

    a = new QAction( "MakeIndex" , "MakeIndex" , Key_F12, this, "MakeIndex" );
    connect( a, SIGNAL( activated() ), this, SLOT(MakeIndex() ) );
    a->addTo( menu3 );
    menu3->insertSeparator();
    menu3->insertItem("MPost", this, SLOT(MetaPost()));
    menu3->insertSeparator();
    menu3->insertItem("Clean", this, SLOT(CleanAll()));
    #ifdef Q_WS_X11
    menu3->insertSeparator();
    menu3->insertItem("Convert to Html", this, SLOT(WebPublish()));
    #endif
    #ifdef Q_WS_MACX
    menu3->insertSeparator();
    menu3->insertItem("Convert to Html", this, SLOT(WebPublish()));
    #endif

QPopupMenu *latex1=new QPopupMenu();
int id;

id = latex1->insertItem("\\documentclass", this, SLOT(Insert1()));
id = latex1->insertItem("\\usepackage{}", this, SLOT(Insert1bis()));
id = latex1->insertItem("AMS packages", this, SLOT(Insert1ter()));
id = latex1->insertItem("\\begin{document}", this, SLOT(Insert2()));
id = latex1->insertItem("\\author{}", this, SLOT(Insert45()));
id = latex1->insertItem("\\title{}", this, SLOT(Insert46()));
id = latex1->insertItem("\\maketitle", this, SLOT(Insert51()));
id = latex1->insertItem("\\tableofcontents", this, SLOT(Insert52()));


QPopupMenu *latex11=new QPopupMenu();
id = latex11->insertItem("\\part", this, SLOT(Insert3()));
id = latex11->insertItem("\\chapter", this, SLOT(Insert4()));
id = latex11->insertItem("\\section", this, SLOT(Insert5()));
id = latex11->insertItem("\\subsection", this, SLOT(Insert6()));
id = latex11->insertItem("\\subsubsection", this, SLOT(Insert6bis()));
id = latex11->insertItem("\\paragraph", this, SLOT(Insert7()));
id = latex11->insertItem("\\subparagraph", this, SLOT(Insert8()));
latex1->insertItem("Sectionning", latex11);

QPopupMenu *latex12=new QPopupMenu();
id = latex12->insertItem("\\begin{center}", this, SLOT(Insert9()));
id = latex12->insertItem("\\begin{flushleft}", this, SLOT(Insert10()));
id = latex12->insertItem("\\begin{flushright}", this, SLOT(Insert11()));
id = latex12->insertItem("\\begin{quote}", this, SLOT(Insert12()));
id = latex12->insertItem("\\begin{quotation}", this, SLOT(Insert13()));
id = latex12->insertItem("\\begin{verse}", this, SLOT(Insert14()));
id = latex12->insertItem("\\begin{verbatim}", this, SLOT(Insert15()));
id = latex12->insertItem("\\begin{table}", this, SLOT(Insert42()));
id = latex12->insertItem("\\begin{figure}", this, SLOT(Insert43()));
id = latex12->insertItem("\\begin{titlepage}", this, SLOT(Insert44()));
latex1->insertItem("Environment", latex12);

QPopupMenu *latex13=new QPopupMenu();
id = latex13->insertItem(QPixmap::fromMimeSource( "itemize.png"),"\\begin{itemize}", this, SLOT(Insert16()));
id = latex13->insertItem(QPixmap::fromMimeSource( "enumerate.png"),"\\begin{enumerate}", this, SLOT(Insert17()));
id = latex13->insertItem("\\begin{description}", this, SLOT(Insert18()));
id = latex13->insertItem("\\begin{list}", this, SLOT(Insert19()));
id = latex13->insertItem(QPixmap::fromMimeSource( "item.png"),"\\item", this, SLOT(Insert20()), CTRL+ALT+Key_H);
latex1->insertItem("List Environment", latex13);

QPopupMenu *latex14=new QPopupMenu();
id = latex14->insertItem("\\textit - Italics", this, SLOT(Insert21()), CTRL+ALT+Key_I);
id = latex14->insertItem("\\textsl - Slanted", this, SLOT(Insert22()), CTRL+ALT+Key_S);
id = latex14->insertItem("\\textbf - Boldface", this, SLOT(Insert23()), CTRL+ALT+Key_B);
id = latex14->insertItem("\\texttt - Typewriter", this, SLOT(Insert24()), CTRL+ALT+Key_T);
id = latex14->insertItem("\\textsc - Small caps", this, SLOT(Insert25()), CTRL+ALT+Key_C);
latex1->insertItem("Font Styles", latex14);

QPopupMenu *latex15=new QPopupMenu();
id = latex15->insertItem("\\begin{tabbing}", this, SLOT(Insert26()));
id = latex15->insertItem("\\begin{tabular}", this, SLOT(Insert27()));
id = latex15->insertItem("\\multicolumn", this, SLOT(Insert28()));
id = latex15->insertItem("\\hline", this, SLOT(Insert29()));
id = latex15->insertItem("\\vline", this, SLOT(Insert30()));
id = latex15->insertItem("\\cline", this, SLOT(Insert31()));
latex1->insertItem("Tabular Environment", latex15);

QPopupMenu *latex16=new QPopupMenu();
id = latex16->insertItem("\\newpage", this, SLOT(Insert32()));
id = latex16->insertItem("\\linebreak", this, SLOT(Insert33()));
id = latex16->insertItem("\\pagebreak", this, SLOT(Insert34()));
id = latex16->insertItem("\\bigskip", this, SLOT(Insert35()));
id = latex16->insertItem("\\medskip", this, SLOT(Insert36()));
id = latex16->insertItem("New line", this, SLOT(NewLine()),CTRL+Key_Return);
latex1->insertItem("Spacing", latex16);
latex1->insertSeparator();
id = latex1->insertItem("\\includegraphics{file.eps}", this, SLOT(Insert37()));
id = latex1->insertItem("\\include{file}", this, SLOT(Insert37bis()));
id = latex1->insertItem("\\input{file}", this, SLOT(Insert37ter()));
latex1->insertSeparator();
id = latex1->insertItem("\\label{}", this, SLOT(Insert41()));
id = latex1->insertItem("\\cite{}", this, SLOT(Insert38()));
id = latex1->insertItem("\\bibliographystyle{}", this, SLOT(Insert39()));
id = latex1->insertItem("\\bibliography{}", this, SLOT(Insert40()));
menuBar()->insertItem("&LaTeX", latex1);

QPopupMenu *math1=new QPopupMenu();

id = math1->insertItem("$...$", this, SLOT(InsertMath1()), CTRL+ALT+Key_M);
id = math1->insertItem("$$...$$", this, SLOT(InsertMath2()),SHIFT+ALT+Key_M);
id = math1->insertItem("\\begin{equation}", this, SLOT(InsertMath74()));
id = math1->insertItem("\\begin{eqnarray}", this, SLOT(InsertMath75()));
math1->insertSeparator();
id = math1->insertItem("_{} - subscript", this, SLOT(InsertMath3()),CTRL+ALT+Key_D);
id = math1->insertItem("^{} - superscript", this, SLOT(InsertMath4()),CTRL+ALT+Key_U);
id = math1->insertItem("\\frac{}{}", this, SLOT(InsertMath5()), SHIFT+ALT+Key_F);
id = math1->insertItem("\\dfrac{}{}", this, SLOT(InsertMath6()), CTRL+ALT+Key_F);
id = math1->insertItem("\\sqrt{}", this, SLOT(InsertMath7()),CTRL+ALT+Key_S);
id = math1->insertItem("\\left", this, SLOT(InsertMath8()),CTRL+ALT+Key_L);
id = math1->insertItem("\\right", this, SLOT(InsertMath9()),CTRL+ALT+Key_R);
id = math1->insertItem("\\begin{array}", this, SLOT(InsertMath10()));

QPopupMenu *math15=new QPopupMenu();
id = math15->insertItem("\\mathrm{}", this, SLOT(InsertMath66()));
id = math15->insertItem("\\mathit{}", this, SLOT(InsertMath67()));
id = math15->insertItem("\\mathbf{}", this, SLOT(InsertMath68()));
id = math15->insertItem("\\mathsf{}", this, SLOT(InsertMath69()));
id = math15->insertItem("\\mathtt{}", this, SLOT(InsertMath70()));
id = math15->insertItem("\\mathcal{}", this, SLOT(InsertMath71()));
id = math15->insertItem("\\mathbb{}", this, SLOT(InsertMath72()));
id = math15->insertItem("\\mathfrak{}", this, SLOT(InsertMath73()));
math1->insertItem("Math Font Styles", math15);

QPopupMenu *math17=new QPopupMenu();
id = math17->insertItem(QPixmap::fromMimeSource( "acute.png"),"\\acute{}", this, SLOT(InsertMath76()));
id = math17->insertItem(QPixmap::fromMimeSource( "grave.png"),"\\grave{}", this, SLOT(InsertMath77()));
id = math17->insertItem(QPixmap::fromMimeSource( "tilde.png"),"\\tilde{}", this, SLOT(InsertMath78()));
id = math17->insertItem(QPixmap::fromMimeSource( "bar.png"),"\\bar{}", this, SLOT(InsertMath79()));
id = math17->insertItem(QPixmap::fromMimeSource( "vec.png"),"\\vec{}", this, SLOT(InsertMath80()));
id = math17->insertItem(QPixmap::fromMimeSource( "hat.png"),"\\hat{}", this, SLOT(InsertMath81()));
id = math17->insertItem(QPixmap::fromMimeSource( "check.png"),"\\check{}", this, SLOT(InsertMath82()));
id = math17->insertItem(QPixmap::fromMimeSource( "breve.png"),"\\breve{}", this, SLOT(InsertMath83()));
id = math17->insertItem(QPixmap::fromMimeSource( "dot.png"),"\\dot{}", this, SLOT(InsertMath84()));
id = math17->insertItem(QPixmap::fromMimeSource( "ddot.png"),"\\ddot{}", this, SLOT(InsertMath85()));
math1->insertItem("Math Accents", math17);
QPopupMenu *math18=new QPopupMenu();
id = math18->insertItem("small", this, SLOT(InsertMath86()));
id = math18->insertItem("medium", this, SLOT(InsertMath87()));
id = math18->insertItem("large", this, SLOT(InsertMath88()));
id = math18->insertItem("\\quad", this, SLOT(InsertMath89()));
id = math18->insertItem("\\qquad", this, SLOT(InsertMath90()));
math1->insertItem("Math Spaces", math18);
menuBar()->insertItem("&Math", math1);

QPopupMenu *wizard=new QPopupMenu();
id = wizard->insertItem("Quick Start", this, SLOT(QuickDocument()));
id = wizard->insertItem("Quick Letter", this, SLOT(QuickLetter()));
wizard->insertSeparator();
id = wizard->insertItem("Quick Tabular", this, SLOT(QuickTabular()));
id = wizard->insertItem("Quick Tabbing", this, SLOT(QuickTabbing()));
id = wizard->insertItem("Quick Array", this, SLOT(QuickArray()));

menuBar()->insertItem("&Wizard", wizard);

QPopupMenu *bibmenu=new QPopupMenu();

id = bibmenu->insertItem("Article in Journal", this, SLOT(InsertBib1()));
id = bibmenu->insertItem("Article in Conference Proceedings", this, SLOT(InsertBib2()));
id = bibmenu->insertItem("Article in a collection", this, SLOT(InsertBib3()));
id = bibmenu->insertItem("Chapter or Pages in a Book", this, SLOT(InsertBib4()));
id = bibmenu->insertItem("Conference Proceedings", this, SLOT(InsertBib5()));
id = bibmenu->insertItem("Book", this, SLOT(InsertBib6()));
id = bibmenu->insertItem("Booklet", this, SLOT(InsertBib7()));
id = bibmenu->insertItem("PhD. Thesis", this, SLOT(InsertBib8()));
id = bibmenu->insertItem("Master's Thesis", this, SLOT(InsertBib9()));
id = bibmenu->insertItem("Technical Report", this, SLOT(InsertBib10()));
id = bibmenu->insertItem("Technical Manual", this, SLOT(InsertBib11()));
id = bibmenu->insertItem("Unpublished", this, SLOT(InsertBib12()));
id = bibmenu->insertItem("Miscellaneous", this, SLOT(InsertBib13()));
id = bibmenu->insertItem("Clean", this, SLOT(CleanBib()));
menuBar()->insertItem("&Bibliography", bibmenu);

QPopupMenu *usermenu = new QPopupMenu();
usermenu1= new QPopupMenu();
usermenu1->insertItem("1: "+UserMenuName[0],this,SLOT(InsertUserTag1()), SHIFT+Key_F1);
usermenu1->insertItem("2: "+UserMenuName[1],this,SLOT(InsertUserTag2()), SHIFT+Key_F2);
usermenu1->insertItem("3: "+UserMenuName[2],this,SLOT(InsertUserTag3()), SHIFT+Key_F3);
usermenu1->insertItem("4: "+UserMenuName[3],this,SLOT(InsertUserTag4()), SHIFT+Key_F4);
usermenu1->insertItem("5: "+UserMenuName[4],this,SLOT(InsertUserTag5()), SHIFT+Key_F5);
usermenu1->insertItem("6: "+UserMenuName[5],this,SLOT(InsertUserTag6()), SHIFT+Key_F6);
usermenu1->insertItem("7: "+UserMenuName[6],this,SLOT(InsertUserTag7()), SHIFT+Key_F7);
usermenu1->insertItem("8: "+UserMenuName[7],this,SLOT(InsertUserTag8()), SHIFT+Key_F8);
usermenu1->insertItem("9: "+UserMenuName[8],this,SLOT(InsertUserTag9()), SHIFT+Key_F9);
usermenu1->insertItem("10: "+UserMenuName[9],this,SLOT(InsertUserTag10()), SHIFT+Key_F10);
usermenu1->insertSeparator();
usermenu1->insertItem("Edit User Tags",this, SLOT(EditUserMenu()));
usermenu->insertItem ("User &Tags", usermenu1);
usermenu2= new QPopupMenu();
usermenu2->insertItem("1: "+UserToolName[0],this,SLOT(UserTool1()), SHIFT+ALT+Key_F1);
usermenu2->insertItem("2: "+UserToolName[1],this,SLOT(UserTool2()), SHIFT+ALT+Key_F2);
usermenu2->insertItem("3: "+UserToolName[2],this,SLOT(UserTool3()), SHIFT+ALT+Key_F3);
usermenu2->insertItem("4: "+UserToolName[3],this,SLOT(UserTool4()), SHIFT+ALT+Key_F4);
usermenu2->insertItem("5: "+UserToolName[4],this,SLOT(UserTool5()), SHIFT+ALT+Key_F5);
usermenu2->insertSeparator();
usermenu2->insertItem("Edit User Commands",this, SLOT(EditUserTool()));
usermenu->insertItem ("User &Commands", usermenu2);
menuBar()->insertItem ("&User", usermenu);

view=new QPopupMenu();
view->insertItem("Next Document",this,SLOT(gotoNextDocument()), ALT+Key_PageDown);
view->insertItem("Previous Document",this,SLOT(gotoPrevDocument()), ALT+Key_PageUp);
view->insertSeparator();
id = view->insertItem("Show Structure View",this,SLOT(ToggleStructView()),0,ID_VIEW_STRUCTVIEW);
id = view->insertItem("Show Output View",this,SLOT(ToggleOutputView()),0,ID_VIEW_OUTPUTVIEW);
if (showstructview) {view->setItemChecked(ID_VIEW_STRUCTVIEW,true);}
else {view->setItemChecked(ID_VIEW_STRUCTVIEW,false);}
if (showoutputview) {view->setItemChecked(ID_VIEW_OUTPUTVIEW,true);}
else {view->setItemChecked(ID_VIEW_OUTPUTVIEW,false);}
menuBar()->insertItem("&View", view);

options=new QPopupMenu();
options->insertItem(QPixmap::fromMimeSource( "configure.png"),"Configure Texmaker",this,SLOT(GeneralOptions()));
options->insertSeparator();
id = options->insertItem("Define Current Document as 'Master Document'", this, SLOT(ToggleMode()),0,ID_MODE);
options->insertSeparator();
menuBar()->insertItem("&Options", options);

QToolBar *QuickToolBar = new QToolBar( this );
QuickToolBar->setLabel( "Quick ToolBar" );

  list.clear();
  list.append("part");
  list.append("chapter");
  list.append("section");
  list.append("subsection");
  list.append("subsubsection");
  list.append("paragraph");
  list.append("subparagraph");
QComboBox* combo4 = new QComboBox(FALSE,QuickToolBar);
combo4->insertStringList(list,0);
connect(combo4, SIGNAL(activated(const QString&)),this,SLOT(SectionCommand(const QString&)));
combo4->setFocusPolicy(QWidget::ClickFocus);

QuickToolBar->addSeparator();

 list.clear();
  list.append("label");
  list.append("ref");
  list.append("pageref");
  list.append("index");
  list.append("cite");
  list.append("footnote");
QComboBox* combo5 = new QComboBox(FALSE,QuickToolBar);
combo5->insertStringList(list,0);
connect(combo5, SIGNAL(activated(const QString&)),this,SLOT(OtherCommand(const QString&)));
combo5->setFocusPolicy(QWidget::ClickFocus);

QuickToolBar->addSeparator();

  list.clear();
  list.append("tiny");
  list.append("scriptsize");
  list.append("footnotesize");
  list.append("small");
  list.append("normalsize");
  list.append("large");
  list.append("Large");
  list.append("LARGE");
  list.append("huge");
  list.append("Huge");
QComboBox* combo3 = new QComboBox(FALSE,QuickToolBar);
combo3->insertStringList(list,0);
connect(combo3, SIGNAL(activated(const QString&)),this,SLOT(SizeCommand(const QString&)));
combo3->setFocusPolicy(QWidget::ClickFocus);

QuickToolBar->addSeparator();
but=new QToolButton(QPixmap::fromMimeSource( "text_bold.png"),"Bold", 0,this,SLOT(Insert23()), QuickToolBar, "Bold");
but=new QToolButton(QPixmap::fromMimeSource( "text_italic.png"),"Italic", 0, this,SLOT(Insert21()), QuickToolBar, "Italic");
but=new QToolButton(QPixmap::fromMimeSource( "text_under.png"),"Underline", 0, this,SLOT(InsertMath16()), QuickToolBar, "Underline");
but=new QToolButton(QPixmap::fromMimeSource( "text_left.png"),"Left", 0, this,SLOT(Insert10()), QuickToolBar, "Left");
but=new QToolButton(QPixmap::fromMimeSource( "text_center.png"),"Center", 0, this,SLOT(Insert9()), QuickToolBar, "Center");
but=new QToolButton(QPixmap::fromMimeSource( "text_right.png"),"Right", 0, this,SLOT(Insert11()), QuickToolBar, "Right");

QToolBar *MathToolBar = new QToolBar( this );
but=new QToolButton(QPixmap::fromMimeSource( "mathmode.png"),"Inline Math ($...$)", 0, this,SLOT(InsertMath1()), MathToolBar, "Inline Math ($...$)");
but=new QToolButton(QPixmap::fromMimeSource( "indice.png"),"Subscript", 0, this,SLOT(InsertMath3()), MathToolBar, "Subscript");
but=new QToolButton(QPixmap::fromMimeSource( "puissance.png"),"Superscript", 0,this,SLOT(InsertMath4()), MathToolBar, "Superscript");
but=new QToolButton(QPixmap::fromMimeSource( "smallfrac.png"),"frac", 0,this,SLOT(InsertMath5()), MathToolBar, "frac");
but=new QToolButton(QPixmap::fromMimeSource( "dfrac.png"),"dfrac", 0,this,SLOT(InsertMath6()), MathToolBar, "dfrac");
but=new QToolButton(QPixmap::fromMimeSource( "racine.png"),"sqrt", 0, this,SLOT(InsertMath7()), MathToolBar, "sqrt");

MathToolBar->addSeparator();


  list.clear();
  list.append("left (");
  list.append("left [");
  list.append("left {");
  list.append("left <");
  list.append("left )");
  list.append("left ]");
  list.append("left }");
  list.append("left >");
  list.append("left.");
QComboBox* combo1 =new QComboBox(FALSE,MathToolBar);
combo1->insertStringList(list,0);
connect(combo1,SIGNAL(activated(const QString&)),this,SLOT(LeftDelimiter(const QString&)));
combo1->setFocusPolicy(QWidget::ClickFocus);

MathToolBar->addSeparator();

  list.clear();
  list.append("right )");
  list.append("right ]");
  list.append("right }");
  list.append("right >");
  list.append("right (");
  list.append("right [");
  list.append("right {");
  list.append("right <");
  list.append("right.");
QComboBox* combo2 = new QComboBox(FALSE,MathToolBar);
combo2->insertStringList(list,0);
connect(combo2,SIGNAL(activated(const QString&)),this,SLOT(RightDelimiter(const QString&)));
combo2->setFocusPolicy(QWidget::ClickFocus);
MathToolBar->addSeparator();
but=new QToolButton(QPixmap::fromMimeSource( "newline.png"),"New Line",0, this,SLOT(NewLine()), MathToolBar, "New Line");

menuhelp = new QPopupMenu( this );
menuBar()->insertItem( "&Help" , menuhelp );
menuhelp->insertItem(QPixmap::fromMimeSource( "help.png"),"LaTeX Reference", this, SLOT(LatexHelp()));
menuhelp->insertSeparator();
menuhelp->insertItem(QPixmap::fromMimeSource( "help.png"),"User Manual", this, SLOT(UserManualHelp()));
menuhelp->insertItem(QPixmap::fromMimeSource( "appicon.png"),"About Texmaker", this, SLOT(HelpAbout()));
}

////////////////////////////// FILE /////////////////////////////
void Texmaker::load( const QString &f )
{
    raise();
    if (FileAlreadyOpen(f) || !QFile::exists( f )) return;
    LatexEditorView *edit = new LatexEditorView( tabWidget,"",EditorFont,showline);
    edit->editor->setReadOnly(false);
    edit->editor->setEncoding(input_encoding);
    if (wordwrap) {edit->editor->setWordWrap(LatexEditor::WidgetWidth);}
    else {edit->editor->setWordWrap(LatexEditor::NoWrap);}
    tabWidget->addTab( edit, QFileInfo( f ).fileName() );
    QFile file( f );
    if ( !file.open( IO_ReadOnly ) )
       {
       QMessageBox::warning( this,"Error", "You do not have read permission to this file.");
       return;
       }
    QTextStream ts( &file );
    QTextCodec* codec = QTextCodec::codecForName(input_encoding);
    if(!codec) codec = QTextCodec::codecForLocale();
    ts.setEncoding(QTextStream::Locale);
    ts.setCodec(codec);
    edit->editor->setText( ts.read() );
    tabWidget->showPage( edit );
    edit->editor->viewport()->setFocusPolicy(StrongFocus);
    edit->editor->viewport()->setFocus();
    filenames.replace( edit, f );
    edit->editor->setModified(false);
    doConnections( edit->editor );
    UpdateCaption();
    UpdateLineColStatus();
    AddRecentFile(f);
    ShowStructure();
}

LatexEditorView *Texmaker::currentEditorView() const
{
    if ( tabWidget->currentPage() &&
	 tabWidget->currentPage()->inherits( "LatexEditorView" ) )
	return (LatexEditorView*)tabWidget->currentPage();
    return 0;
}

void Texmaker::setLine( const QString &line )
{
bool ok;
int l=line.toInt(&ok,10);
if (currentEditorView() && ok)
  {
    if ( !gotoLineDialog ) gotoLineDialog = new GotoLineDialog(this, 0,TRUE );
    gotoLineDialog->SetEditor(currentEditorView()->editor);
    gotoLineDialog->show();
    gotoLineDialog->raise();
    gotoLineDialog->spinLine->setFocus();
    gotoLineDialog->spinLine->setMinValue( 1 );
    gotoLineDialog->spinLine->setMaxValue( currentEditorView()->editor->paragraphs() );
    gotoLineDialog->spinLine->setValue(l );
    gotoLineDialog->spinLine->selectAll();
  }
}

void Texmaker::doConnections( LatexEditor *e )
{
connect(e, SIGNAL(cursorPositionChanged(int,int)), this, SLOT(UpdateLineColStatus()));
connect(e, SIGNAL(modificationChanged(bool)), this, SLOT(NewDocumentStatus(bool)));
}

void Texmaker::fileNew()
{
    LatexEditorView *edit = new LatexEditorView( tabWidget,"",EditorFont,showline);
    edit->editor->setReadOnly(false);
    edit->editor->setEncoding(input_encoding);
    doConnections( edit->editor );
    tabWidget->addTab( edit, "untitled" );
    tabWidget->showPage( edit );
    edit->editor->viewport()->setFocusPolicy(StrongFocus);
    edit->editor->viewport()->setFocus();
    if (wordwrap) {edit->editor->setWordWrap(LatexEditor::WidgetWidth);}
    else {edit->editor->setWordWrap(LatexEditor::NoWrap);}
    filenames.replace( edit, "untitled" );
    edit->editor->setModified(false);
    doConnections( edit->editor );
    UpdateCaption();
    UpdateLineColStatus();
}

void Texmaker::fileOpen()
{
QString currentDir=QDir::currentDirPath();
if (!lastDocument.isEmpty())
  {
  QFileInfo fi(lastDocument);
  if (fi.exists() && fi.isReadable()) currentDir=fi.dirPath();
  }
QString fn = QFileDialog::getOpenFileName( currentDir,"TeX files (*.tex *.bib *.sty *.cls *.mp);;All files (*.*)",this,"Open File","Open File" );
if ( !fn.isEmpty() ) load( fn );
}

void Texmaker::fileOpenRecent(int id)
{
QString fn(recent->text(id));
if ( !fn.isEmpty() ) load( fn );
}


void Texmaker::AddRecentFile(const QString &f)
{
if (recentFilesList->find(f)!=-1) return;

if (recentFilesList->count() < 5)
recentFilesList->prepend(f);
else
 {
	recentFilesList->removeLast();
	recentFilesList->prepend(f);
 }
recent->clear();
for (uint i=0; i < recentFilesList->count(); i++)
recent->insertItem(recentFilesList->at(i));

}

bool Texmaker::FileAlreadyOpen(QString f)
{
bool rep=false;
FilesMap::Iterator it;
for( it = filenames.begin(); it != filenames.end(); ++it )
 {
 if (filenames[it.key()]==f)
    {
     tabWidget->showPage( it.key() );
     rep=true;
    }
 }
return rep;
}

void Texmaker::fileSave()
{
if ( !currentEditorView() )	return;
QString fn;
if ( getName()=="untitled" ) {fileSaveAs();}
else
  {
	QFile file( *filenames.find( currentEditorView() ) );
  if ( !file.open( IO_WriteOnly ) )
      {
       QMessageBox::warning( this,"Error","The file could not be saved. Please check if you have write permission.");
       return;
      }
	QTextStream ts( &file );
	ts.setEncoding(QTextStream::Locale);
	QTextCodec* codec = QTextCodec::codecForName(currentEditorView()->editor->getEncoding());
  ts.setCodec(codec ? codec : QTextCodec::codecForLocale());
	ts << currentEditorView()->editor->text();
  currentEditorView()->editor->setModified(false);
  fn=getName();
  AddRecentFile(fn);
  }
UpdateCaption();
UpdateLineColStatus();
}

void Texmaker::fileSaveAs()
{
int query=0;
if ( !currentEditorView() ) 	return;
QString fn = QFileDialog::getSaveFileName( QString::null,"TeX files (*.tex *.bib *.sty *.cls *.mp);;All files (*.*)", this,"Save As","Save As" );
if ( !fn.isEmpty() )
    {
     QFileInfo fic(fn);
     if( fic.exists() ) query =QMessageBox::warning(this, "Texmaker","A Document with this name already exists.\nDo you want to overwrite it? ","Yes", "No", "Cancel", 0,2 );
     if (query==0)
         {
         filenames.replace( currentEditorView(), fn );
	       fileSave();
	       tabWidget->setTabLabel( currentEditorView(), fic.fileName() );
         }
    }
UpdateCaption();
UpdateLineColStatus();
}

void Texmaker::fileSaveAll()
{
LatexEditorView *temp = new LatexEditorView( tabWidget,"",EditorFont,showline);
temp=currentEditorView();
FilesMap::Iterator it;
for( it = filenames.begin(); it != filenames.end(); ++it )
   {
   tabWidget->showPage( it.key() );
   fileSave();
   }
tabWidget->showPage(temp);
UpdateCaption();
UpdateLineColStatus();
}

void Texmaker::filePrint()
{
    if ( !currentEditorView() )
	return;
#ifndef QT_NO_PRINTER
    QPrinter printer;
    printer.setFullPage(TRUE);
    if ( printer.setup( this ) ) {
	QPainter p( &printer );
	QPaintDeviceMetrics metrics( p.device() );
	int dpix = metrics.logicalDpiX();
	int dpiy = metrics.logicalDpiY();
	const int margin = 72; // pt
	QRect body( margin * dpix / 72, margin * dpiy / 72,
		    metrics.width() - margin * dpix / 72 * 2,
		    metrics.height() - margin * dpiy / 72 * 2 );
	QFont font=EditorFont;
	QSimpleRichText richText( currentEditorView()->editor->text(), font, currentEditorView()->editor->context(), currentEditorView()->editor->styleSheet(),
				  currentEditorView()->editor->mimeSourceFactory(), body.height() );
	richText.setWidth( &p, body.width() );
	QRect view( body );
	int page = 1;
	do {
	    richText.draw( &p, body.left(), body.top(), view, colorGroup() );
	    view.moveBy( 0, body.height() );
	    p.translate( 0 , -body.height() );
	    p.setFont( font );
	    p.drawText( view.right() - p.fontMetrics().width( QString::number( page ) ),
			view.bottom() + p.fontMetrics().ascent() + 5, QString::number( page ) );
	    if ( view.top()  >= richText.height() )
		break;
	    printer.newPage();
	    page++;
	} while (TRUE);
    }
#endif
}

void Texmaker::fileClose()
{
if ( !currentEditorView() )	return;
if (currentEditorView()->editor->isModified())
{
switch(  QMessageBox::warning(this, "Texmaker",
				     "The document contains unsaved work. "
				     "Do you want to save it before closing?",
				     "Save and Close", "Don't Save and Close", "Cancel",
				     0,      // Enter == button 0
				     2 ) )
   {
       case 0:
	   fileSave();
     filenames.remove(currentEditorView());
	   delete currentEditorView();
	   break;
       case 1:
     filenames.remove(currentEditorView());
	   delete currentEditorView();
	   break;
       case 2:
       default: // just for sanity
	   return;
	   break;
   }
  }
else
{
filenames.remove(currentEditorView());
delete currentEditorView();
}

if ( currentEditorView() )	currentEditorView()->editor->viewport()->setFocus();
UpdateCaption();
UpdateLineColStatus();
}

void Texmaker::fileCloseAll()
{
bool go=true;
while (currentEditorView() && go)
 {
	if (currentEditorView()->editor->isModified())
      {
      switch(  QMessageBox::warning(this, "Texmaker",
       				     "The document contains unsaved work. "
       				     "Do you want to save it before exiting?",
       				     "Save and Close", "Don't Save and Close", "Cancel",
       				     0,      // Enter == button 0
       				     2 ) )
          {
          case 0:
       	    fileSave();
            filenames.remove(currentEditorView());
       	    delete currentEditorView();
            break;
          case 1:
            filenames.remove(currentEditorView());
       	    delete currentEditorView();
            break;
          case 2:
          default:
            go=false;
       	    return;
       	    break;
          }
   }
	else
			{
      filenames.remove(currentEditorView());
      delete currentEditorView();
      }

 }
UpdateCaption();
UpdateLineColStatus();
}

void Texmaker::fileExit()
{
SaveSettings();
bool accept=true;
    while (currentEditorView() && accept)
    {
      if (currentEditorView()->editor->isModified())
      {
      switch(  QMessageBox::warning(this, "Texmaker",
				     "The document contains unsaved work. "
				     "Do you want to save it before exiting?",
				     "Save and Close", "Don't Save and Close", "Cancel",
				     0,      // Enter == button 0
				     2 ) )
      {
       case 0:
	     fileSave();
       filenames.remove(currentEditorView());
	     delete currentEditorView();
	     break;
       case 1:
       filenames.remove(currentEditorView());
	     delete currentEditorView();
	     break;
       case 2:
       default: // just for sanity
	     accept=false;
	     break;
     }

     }
     else
        {
        filenames.remove(currentEditorView());
        delete currentEditorView();
        }
    }
    if (accept) qApp->quit();
}

void Texmaker::closeEvent(QCloseEvent *e)
{
SaveSettings();
bool accept=true;
    while (currentEditorView() && accept)
    {
      if (currentEditorView()->editor->isModified())
      {
      switch(  QMessageBox::warning(this, "Texmaker",
				     "The document contains unsaved work. "
				     "Do you want to save it before exiting?",
				     "Save and Close", "Don't Save and Close", "Cancel",
				     0,      // Enter == button 0
				     2 ) )
      {
       case 0:
	     fileSave();
       filenames.remove(currentEditorView());
	     delete currentEditorView();
	     break;
       case 1:
       filenames.remove(currentEditorView());
	     delete currentEditorView();
	     break;
       case 2:
       default: // just for sanity
	     accept=false;
	     break;
     }
   }
     else
        {
         filenames.remove(currentEditorView());
         delete currentEditorView();
         }
    }
    if (accept) e->accept();
}

//////////////////////////// EDIT ///////////////////////
void Texmaker::editUndo()
{
    if ( !currentEditorView() )
	return;
    currentEditorView()->editor->undo();
}

void Texmaker::editRedo()
{
    if ( !currentEditorView() )
	return;
    currentEditorView()->editor->redo();
}

void Texmaker::editCut()
{
    if ( !currentEditorView() )
	return;
    currentEditorView()->editor->cut();
}

void Texmaker::editCopy()
{
    if ( !currentEditorView() )
	return;
    currentEditorView()->editor->copy();
}

void Texmaker::editPaste()
{
    if ( !currentEditorView() )
	return;
    currentEditorView()->editor->paste();
}

void Texmaker::editSelectAll()
{
    if ( !currentEditorView() )
	return;
    currentEditorView()->editor->selectAll(true);
}

void Texmaker::editFind()
{
    if ( !currentEditorView() )	return;
    if (!findDialog) findDialog = new FindDialog(this, 0, TRUE );
    findDialog->SetEditor(currentEditorView()->editor);
    findDialog->show();
    findDialog->raise();
    findDialog->comboFind->setFocus();
    findDialog->comboFind->lineEdit()->selectAll();
}

void Texmaker::editFindNext()
{
    if ( !currentEditorView() )	return;
    if (!findDialog)
       {
       findDialog = new FindDialog(this, 0, true );
       findDialog->SetEditor(currentEditorView()->editor);
       findDialog->show();
       findDialog->raise();
       findDialog->comboFind->setFocus();
       findDialog->comboFind->lineEdit()->selectAll();
       }
    else
       {
       findDialog->SetEditor(currentEditorView()->editor);
       findDialog->doFind();
       }
}


void Texmaker::editReplace()
{
    if ( !currentEditorView() )	return;
    if ( !replaceDialog )  replaceDialog = new ReplaceDialog(this, 0, TRUE );
    replaceDialog->SetEditor(currentEditorView()->editor);
    replaceDialog->show();
    replaceDialog->raise();
    replaceDialog->comboFind->setFocus();
    replaceDialog->comboFind->lineEdit()->selectAll();
}

void Texmaker::editGotoLine()
{
    if ( !currentEditorView() )	return;
    if ( !gotoLineDialog ) gotoLineDialog = new GotoLineDialog(this, 0,TRUE );
    gotoLineDialog->SetEditor(currentEditorView()->editor);
    gotoLineDialog->show();
    gotoLineDialog->raise();
    gotoLineDialog->spinLine->setFocus();
    gotoLineDialog->spinLine->setMinValue( 1 );
    gotoLineDialog->spinLine->setMaxValue( currentEditorView()->editor->paragraphs() );
    gotoLineDialog->spinLine->selectAll();
}

void Texmaker::editComment()
{
    if ( !currentEditorView() )	return;
    currentEditorView()->editor->commentSelection();
    UpdateLineColStatus();
}

void Texmaker::editUncomment()
{
    if ( !currentEditorView() )	return;
    currentEditorView()->editor->uncommentSelection();
    UpdateLineColStatus();
}

void Texmaker::editIndent()
{
    if ( !currentEditorView() )	return;
    currentEditorView()->editor->indentSelection();
    UpdateLineColStatus();
}
////////////////// GENERAL SLOTS //////////////
void Texmaker::UpdateLineColStatus()
{
 if ( !currentEditorView() )
  {
  stat3->setText("Ready");
  }
else
  {
  QString linenumber;
	int para=0;
  int index=0;
  currentEditorView()->editor->viewport()->setFocus();
  currentEditorView()->editor->getCursorPosition( &para, &index);
  linenumber.sprintf("Line: %d Col: %d", para + 1, index + 1);
  stat1->setText(linenumber.data());
  }
}

void Texmaker::NewDocumentStatus(bool m)
{
if ( !currentEditorView() )	return;
if (m) tabWidget->changeTab( currentEditorView(),QPixmap::fromMimeSource( "modified.png"), QFileInfo( getName() ).fileName() );
else tabWidget->changeTab( currentEditorView(),QPixmap::fromMimeSource( "empty.png"), QFileInfo( getName() ).fileName() );
}

QString Texmaker::getName()
{
QString title;
if ( !currentEditorView() )	{title="";}
else {title=filenames[currentEditorView()];}
return title;
}

void Texmaker::UpdateCaption()
{
QString title;
if   ( !currentEditorView() )	{title="No Document";}
else
   {
   title="Document : "+getName();
   //input_encoding=currentEditorView()->editor->getEncoding();
   }
setCaption(title);
UpdateStructure();
if (singlemode)
 {
 OutputWidget->clear();
 logpresent=false;
 }
QString finame=getName();
if (finame!="untitled" && finame!="") lastDocument=finame;
UpdateLineColStatus();
}

void Texmaker::gotoNextDocument()
{
  if ( tabWidget->count() < 2 )
    return;

  int cPage = tabWidget->currentPageIndex() + 1;
  if ( cPage >= tabWidget->count() )
    tabWidget->setCurrentPage( 0 );
  else
    tabWidget->setCurrentPage( cPage );
}

void Texmaker::gotoPrevDocument()
{
  if ( tabWidget->count() < 2 )
    return;

  int cPage = tabWidget->currentPageIndex() - 1;
  if ( cPage < 0 )
    tabWidget->setCurrentPage( tabWidget->count() - 1 );
  else
    tabWidget->setCurrentPage( cPage );
}


/////////////////// QUICK /////////////////////////
void Texmaker::QuickBuild()
{
stat3->setText("Quick Build");
switch (quickmode)
 {
  case 1:
    {
    stat3->setText("Latex");
    RunCommand(latex_command,true);
    ViewLog();
    QuickLatexError();
    if (errorlist->isEmpty()) 
    	{
	stat3->setText("Dvips");
    	RunCommand(dvips_command,true);
	ViewPS();
	}
    else {NextError();}
    }break;
  case 2:
    {
    stat3->setText("Latex");
    RunCommand(latex_command,true);
    ViewLog();
    QuickLatexError();
    if (errorlist->isEmpty()) 
    	{
	ViewDvi();
	}
    else {NextError();}
    }break;
 case 3:
    {
    stat3->setText("Pdf Latex");
    RunCommand(pdflatex_command,true);
    ViewLog();
    QuickLatexError();
    if (errorlist->isEmpty()) 
    	{
	ViewPDF();
	}
    else {NextError();}
    }break;
 case 4:
    {
    stat3->setText("Latex");
    RunCommand(latex_command,true);
    ViewLog();
    QuickLatexError();
    if (errorlist->isEmpty()) 
    	{
	stat3->setText("Dvi to Pdf");
	RunCommand(dvipdf_command,true);
	ViewPDF();
	}
    else {NextError();}
    }break;
 case 5:
    {
    stat3->setText("Latex");
    RunCommand(latex_command,true);
    ViewLog();
    QuickLatexError();
    if (errorlist->isEmpty()) 
    	{
	stat3->setText("Dvips");
	RunCommand(dvips_command,true);
	stat3->setText("Ps to Pdf");
	RunCommand(ps2pdf_command,true);
	ViewPDF();
	}
    else {NextError();}
    }break;
 }
}

/////////////////// TOOLS /////////////////////////
void Texmaker::RunCommand(QString comd,bool waitendprocess)
{
FINPROCESS=false;
QString finame;
QString commandline=comd;
if (singlemode) {finame=getName();}
else {finame=MasterName;}
if ((singlemode && !currentEditorView()) || finame=="untitled" || finame=="")
{
QMessageBox::warning( this,"Error","Can't detect the file name");
return;
}
fileSave();
QFileInfo fi(finame);
QString basename=fi.baseName();
commandline.replace("%",basename);
proc = new QProcess( this );
proc->setWorkingDirectory(fi.dir());
QStringList command=QStringList::split(" ", commandline);
proc->setArguments(command);
connect( proc, SIGNAL(readyReadStderr()),this, SLOT(readFromStderr()) );
connect( proc, SIGNAL(processExited()),this, SLOT(SlotEndProcess()) );
if ( !proc->start() )
	{
	QMessageBox::warning( this,"Error","Could not start the command.");
	stat3->setText("Ready");
	}
else
	{
	OutputWidget->clear();
	logpresent=false;
	OutputWidget->insertLine("Process launched");
	if (waitendprocess)
		{
		while (!FINPROCESS) 
			{
			qApp->eventLoop()->processEvents(QEventLoop::ExcludeUserInput);
			}
		}
	}
}

void Texmaker::readFromStderr()
{
QString r;
if (proc->canReadLineStderr())
  {
   r=proc->readLineStderr();
   OutputWidget->insertLine(r+"\n");
  }
}

void Texmaker::SlotEndProcess()
{
QString result="";
if (proc->normalExit())
  {
  result= ((proc->exitStatus()) ? "Process failed" : "Process exited normally");
  }
else
  {
   result= "Process exited with error(s)";
  }
OutputWidget->insertLine(result);
stat3->setText("Ready");
UpdateLineColStatus();
FINPROCESS=true;
}

void Texmaker::Latex()
{
stat3->setText("Latex");
RunCommand(latex_command,false);
}

void Texmaker::ViewDvi()
{
stat3->setText("View Dvi file");
RunCommand(viewdvi_command,false);
}

void Texmaker::DviToPS()
{
stat3->setText("Dvips");
RunCommand(dvips_command,false);
}

void Texmaker::ViewPS()
{
stat3->setText("View PS file");
RunCommand(viewps_command,false);
}

void Texmaker::PDFLatex()
{
stat3->setText("Pdf Latex");
RunCommand(pdflatex_command,false);
}

void Texmaker::ViewPDF()
{
stat3->setText("View Pdf file");
RunCommand(viewpdf_command,false);
}

void Texmaker::MakeBib()
{
stat3->setText("Bibtex");
RunCommand(bibtex_command,false);
}

void Texmaker::MakeIndex()
{
stat3->setText("Make index");
RunCommand(makeindex_command,false);
}

void Texmaker::PStoPDF()
{
stat3->setText("Ps to Pdf");
RunCommand(ps2pdf_command,false);
}

void Texmaker::DVItoPDF()
{
stat3->setText("Dvi to Pdf");
RunCommand(dvipdf_command,false);
}

void Texmaker::MetaPost()
{
stat3->setText("Mpost");
QString finame=getName();
QFileInfo fi(finame);
RunCommand(metapost_command+fi.baseName()+"."+fi.extension(),false);
}

void Texmaker::CleanAll()
{
  QString finame,f;
  if (singlemode) {finame=getName();}
  else {finame=MasterName;}
  if ((singlemode && !currentEditorView()) || finame=="untitled" || finame=="")
  {
  QMessageBox::warning( this,"Error","Can't detect the file name");
  return;
  }
  fileSave();
  QFileInfo fi(finame);
  QString name=fi.absFilePath();
  QString ext=fi.extension(FALSE);
  QString basename=name.left(name.length()-ext.length()-1);
  QStringList extension=QStringList::split( ",",".log,.aux,.dvi,.lof,.lot,.bit,.idx,.glo,.bbl,.ilg,.toc,.ind");
  int query =QMessageBox::warning(this, "Texmaker", "Delete the output files generated by LaTeX ?\n(.log,.aux,.dvi,.lof,.lot,.bit,.idx,.glo,.bbl,.ilg,.toc,.ind)","Delete Files", "Cancel" );
  if (query==0)
	{
	stat3->setText("Clean");
	for ( QStringList::Iterator it = extension.begin(); it != extension.end(); ++it ) 
		{
		f=basename+*it;
		if (QFile::exists(f))
			{
			QFile file(f);
			file.open( IO_ReadOnly );
			file.remove();
			}
		}
	
	}
}


void Texmaker::UserTool1()
{
RunCommand(UserToolCommand[0],false);
}

void Texmaker::UserTool2()
{
RunCommand(UserToolCommand[1],false);
}

void Texmaker::UserTool3()
{
RunCommand(UserToolCommand[2],false);
}

void Texmaker::UserTool4()
{
RunCommand(UserToolCommand[3],false);
}

void Texmaker::UserTool5()
{
RunCommand(UserToolCommand[4],false);
}

void Texmaker::WebPublish()
{
QString finame;
fileSave();
if (singlemode) {finame=getName();}
else {finame=MasterName;}
if (finame=="untitled") finame="";
ttwpDlg = new webpublishdialog(this,"Convert to Html"); 
ttwpDlg->inputfileEdit->setText(finame);
int i=ttwpDlg->exec();
delete ttwpDlg;
}
////////////////// STRUCTURE ///////////////////
void Texmaker::ShowStructure()
{
showVertPage(0);
}
void Texmaker::UpdateStructure()
{
outstruct->clear();
if ( !currentEditorView() ) return;
QString shortName = getName();
if ((shortName.right(4)!=".tex") && (shortName!="untitled"))  return;
int pos;
while ( (pos = (int)shortName.find('/')) != -1 )
shortName.remove(0,pos+1);
QListViewItem *top=  new QListViewItem( outstruct, shortName,"0",0 );
top->setOpen(TRUE);
top->setPixmap(0,QPixmap::fromMimeSource( "doc.png"));
Child=lastChild=parent_level[0]=parent_level[1]=parent_level[2]=parent_level[3]=parent_level[4]=top;
structlist.clear();
structitem.clear();
labelitem.clear();
structlist.append(QString::number(0));
structitem.append(shortName);
QListViewItem *toplabel=  new QListViewItem(top,"LABELS","0",0 );
structlist.append(QString::number(0));
structitem.append("LABELS");
QString s;
for(int i = 0; i < currentEditorView()->editor->paragraphs(); i++)
 {
  int tagStart, tagEnd;
 //// label ////
 tagStart=tagEnd=0;
 s=currentEditorView()->editor->text(i);
 tagStart=s.find("\\label{", tagEnd);
 if (tagStart!=-1)
  {
    s=s.mid(tagStart+7,qstrlen(s));
    tagStart=s.find("}", tagEnd);
    if (tagStart!=-1)
    {
    s=s.mid(0,tagStart);
    labelitem.append(s);
    structlist.append(QString::number(i));
    s=s+" (line "+QString::number(i+1)+")";
    structitem.append(s);
    Child = toplabel->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    Child=new QListViewItem( toplabel,lastChild,s );
    }
  };

 //// include ////
 tagStart=tagEnd=0;
 s=currentEditorView()->editor->text(i);
 tagStart=s.find("\\include{", tagEnd);
 if (tagStart!=-1)
  {
    s=s.mid(tagStart+8,qstrlen(s));
    tagStart=s.find("}", tagEnd);
    if (tagStart!=-1)
    {
    s=s.mid(0,tagStart+1);
    structlist.append("include");
    structitem.append(s);
    Child = top->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    Child=new QListViewItem( top,lastChild,s );
    Child->setPixmap(0,QPixmap::fromMimeSource( "include.png"));
    }
  };
 //// input ////
 tagStart=tagEnd=0;
 s=currentEditorView()->editor->text(i);
 tagStart=s.find("\\input{", tagEnd);
 if (tagStart!=-1)
  {
    s=s.mid(tagStart+6,qstrlen(s));
    tagStart=s.find("}", tagEnd);
    if (tagStart!=-1)
    {
    s=s.mid(0,tagStart+1);
    structlist.append("input");
    structitem.append(s);
    Child = top->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    Child=new QListViewItem( top,lastChild,s );
    Child->setPixmap(0,QPixmap::fromMimeSource( "include.png"));
    }
  };
 //// part ////
 tagStart=tagEnd=0;
 s=currentEditorView()->editor->text(i);
 tagStart=s.find(QRegExp("\\\\"+struct_level1+"\\*?[\\{\\[]"), tagEnd);
 if (tagStart!=-1)
  {
    structlist.append(QString::number(i));
    tagStart=s.find(struct_level1, tagEnd);
    s=s.mid(tagStart+qstrlen(struct_level1),qstrlen(s));
    s=s+" (line "+QString::number(i+1)+")";
    structitem.append(s);
    Child = top->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    parent_level[0]=new QListViewItem( top,lastChild,s );
    parent_level[0]->setPixmap(0,QPixmap::fromMimeSource( "part.png"));
    parent_level[1]=parent_level[2]=parent_level[3]=parent_level[4]=parent_level[0];
  };
 //// chapter ////
 tagStart=tagEnd=0;
 s=currentEditorView()->editor->text(i);
 tagStart=s.find(QRegExp("\\\\"+struct_level2+"\\*?[\\{\\[]"), tagEnd);
 if (tagStart!=-1)
  {
    structlist.append(QString::number(i));
    tagStart=s.find(struct_level2, tagEnd);
    s=s.mid(tagStart+qstrlen(struct_level2),qstrlen(s));
    s=s+" (line "+QString::number(i+1)+")";
    structitem.append(s);
    Child = parent_level[0]->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    parent_level[1]=new QListViewItem(parent_level[0],lastChild , s );
    parent_level[1]->setPixmap(0,QPixmap::fromMimeSource( "chapter.png"));
    parent_level[2]=parent_level[3]=parent_level[4]=parent_level[1];
  };
 //// section ////
 tagStart=tagEnd=0;
 s=currentEditorView()->editor->text(i);
 tagStart=s.find(QRegExp("\\\\"+struct_level3+"\\*?[\\{\\[]"), tagEnd);
 if (tagStart!=-1)
  {
    structlist.append(QString::number(i));
    tagStart=s.find(struct_level3, tagEnd);
    s=s.mid(tagStart+qstrlen(struct_level3),qstrlen(s));
    s=s+" (line "+QString::number(i+1)+")";
    structitem.append(s);
    Child = parent_level[1]->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    parent_level[2]=new QListViewItem( parent_level[1],lastChild, s);
    parent_level[2]->setPixmap(0,QPixmap::fromMimeSource( "section.png"));
    parent_level[3]=parent_level[4]=parent_level[2];
  };
 //// subsection ////
 tagStart=tagEnd=0;
 s=currentEditorView()->editor->text(i);
 tagStart=s.find(QRegExp("\\\\"+struct_level4+"\\*?[\\{\\[]"), tagEnd);
 if (tagStart!=-1)
  {
    structlist.append(QString::number(i));
    tagStart=s.find(struct_level4, tagEnd);
    s=s.mid(tagStart+qstrlen(struct_level4),qstrlen(s));
    s=s+" (line "+QString::number(i+1)+")";
    structitem.append(s);
    Child = parent_level[2]->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    parent_level[3]=new QListViewItem( parent_level[2],lastChild, s);
    parent_level[3]->setPixmap(0,QPixmap::fromMimeSource( "subsection.png"));
    parent_level[4]=parent_level[3];
  };
 //// subsubsection ////
 tagStart=tagEnd=0;
 s=currentEditorView()->editor->text(i);
 tagStart=s.find(QRegExp("\\\\"+struct_level5+"\\*?[\\{\\[]"), tagEnd);
 if (tagStart!=-1)
  {
    structlist.append(QString::number(i));
    tagStart=s.find(struct_level5, tagEnd);
    s=s.mid(tagStart+qstrlen(struct_level5),qstrlen(s));
    s=s+" (line "+QString::number(i+1)+")";
    structitem.append(s);
    Child = parent_level[3]->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    parent_level[4]=new QListViewItem( parent_level[3],lastChild, s);
    parent_level[4]->setPixmap(0,QPixmap::fromMimeSource( "subsubsection.png"));
  };
 }
if (currentEditorView() ){currentEditorView()->editor->viewport()->setFocus();}
}

void Texmaker::ClickedOnStructure(QListViewItem *)
{
if ( !currentEditorView() ) return;
QListViewItem *item = outstruct->currentItem();
QString it;
if ((item) && (!structlist.isEmpty()))
 {
 QStringList::ConstIterator it1 = structitem.begin();
 QStringList::ConstIterator it2 = structlist.begin();
 for ( ; it1 !=structitem.end(); ++it1 )
    {
    if (*it1==item->text(0)) break;
    ++it2;
    }
bool ok;
QString s=*it2;
if (s!="include" && s!="input")
 {
 int l=s.toInt(&ok,10);
 if (ok && l<=currentEditorView()->editor->paragraphs())
  {
  currentEditorView()->editor->viewport()->setFocus();
  currentEditorView()->editor->setCursorPosition(l, 0);
  UpdateLineColStatus();
  }
 }
 }
}

void Texmaker::DoubleClickedOnStructure(QListViewItem *)
{
QString finame;
if (singlemode) {finame=getName();}
else {finame=MasterName;}
if ((singlemode && !currentEditorView()) || finame=="untitled" || finame=="")
{
return;
}
QFileInfo fi(finame);
QString name=fi.absFilePath();
QString flname=fi.fileName();
QString basename=name.left(name.length()-flname.length());
QListViewItem *item = outstruct->currentItem();
QString it;
if ((item) && (!structlist.isEmpty()))
 {
 QStringList::ConstIterator it1 = structitem.begin();
 QStringList::ConstIterator it2 = structlist.begin();
 for ( ; it1 !=structitem.end(); ++it1 )
    {
    if (*it1==item->text(0)) break;
    ++it2;
    }
QString s=*it2;
if (s=="include")
    {
    QString fname=*it1;
    if (fname.right(5)==".tex}") fname=basename+fname.mid(1,qstrlen(fname)-2);
    else fname=basename+fname.mid(1,qstrlen(fname)-2)+".tex";
    QFileInfo fi(fname);
    if (fi.exists() && fi.isReadable())
      {
      load(fname);
      }
    }
else if (s=="input")
    {
    QString fname=*it1;
    if (fname.right(5)==".tex}") fname=basename+fname.mid(1,qstrlen(fname)-2);
    else fname=basename+fname.mid(1,qstrlen(fname)-2)+".tex";
    QFileInfo fi(fname);
    if (fi.exists() && fi.isReadable())
      {
      load(fname);
      }
    }
}
}
//////////////// MESSAGES - LOG FILE///////////////////////
void Texmaker::ViewLog()
{
Outputview->showPage(OutputWidget);
OutputWidget->clear();
logpresent=false;
QString finame;
  if (singlemode) {finame=getName();}
  else {finame=MasterName;}
if ((singlemode && !currentEditorView()) ||finame=="untitled" || finame=="")
   {
   QMessageBox::warning( this,"Error","Could not start the command.");
   return;
   }
QFileInfo fi(finame);
QString name=fi.absFilePath();
QString ext=fi.extension(FALSE);
QString basename=name.left(name.length()-ext.length()-1);
QString logname=basename+".log";
QFileInfo fic(logname);
if (fic.exists() && fic.isReadable() )
	{
	OutputWidget->insertLine("************** LOG FILE *************** :");
	QFile f(logname);
	if ( f.open(IO_ReadOnly) )
		{
		QTextStream t( &f );
		OutputWidget->append( t.read() );
		OutputWidget->scrollToBottom ();
		}
		f.close();
	logpresent=true;
	LatexError();
	}
else {QMessageBox::warning( this,"Error","Log File not found !");}
UpdateLineColStatus();
}

void Texmaker::ClickedOnOutput(int parag, int index)
{

if ( !currentEditorView() ) return;
 int Start, End;
 bool ok;
 QString s;
 QString line="";
 //// l. ///
 s = OutputWidget->text(parag);
 Start=End=0;
 Start=s.find(QRegExp("l.[0-9]"), End);
 if (Start!=-1)
  {
  Start=Start+2;
  s=s.mid(Start,qstrlen(s));
  End=s.find(QRegExp("[ a-zA-Z.\\-]"),0);
  if (End!=-1)
    line=s.mid(0,End);
  else
    line=s.mid(0,qstrlen(s));
  };
 //// line ///
 s = OutputWidget->text(parag);
 Start=End=0;
 Start=s.find(QRegExp("line [0-9]"), End);
 if (Start!=-1)
  {
  Start=Start+5;
  s=s.mid(Start,qstrlen(s));
  End=s.find(QRegExp("[ a-zA-Z.\\-]"),0);
  if (End!=-1)
    line=s.mid(0,End);
  else
    line=s.mid(0,qstrlen(s));
  };
 //// lines ///
 s = OutputWidget->text(parag);
 Start=End=0;
 Start=s.find(QRegExp("lines [0-9]"), End);
 if (Start!=-1)
  {
  Start=Start+6;
  s=s.mid(Start,qstrlen(s));
  End=s.find(QRegExp("[ a-zA-Z.\\-]"),0);
  if (End!=-1)
    line=s.mid(0,End);
  else
    line=s.mid(0,qstrlen(s));
  };
int l=line.toInt(&ok,10)-1;
if (ok && l<=currentEditorView()->editor->paragraphs())
 {
 currentEditorView()->editor->viewport()->setFocus();
 currentEditorView()->editor->setCursorPosition(l, 0);
 UpdateLineColStatus();
 }
}
////////////////////////// ERRORS /////////////////////////////
void Texmaker::LatexError()
{
errorlist->clear();
QString s;
for(int i = 0; i < OutputWidget->paragraphs(); i++)
 {
 s = OutputWidget->text(i);
 int tagStart, tagEnd;
 //// ! ////
 tagStart=tagEnd=0;
 tagStart=s.find("!", tagEnd);
 if (tagStart==0)
  {
    errorlist->append(QString::number(i));
  };
 //// latex warning ////
 tagStart=tagEnd=0;
 tagStart=s.find("LaTeX Warning", tagEnd);
 if (tagStart!=-1)
  {
    errorlist->append(QString::number(i));
  };
 }
}

void Texmaker::QuickLatexError()
{
errorlist->clear();
QString s;
for(int i = 0; i < OutputWidget->paragraphs(); i++)
 {
 s = OutputWidget->text(i);
 int tagStart, tagEnd;
 //// ! ////
 tagStart=tagEnd=0;
 tagStart=s.find("!", tagEnd);
 if (tagStart==0)
  {
    errorlist->append(QString::number(i));
  };
 }
}


void Texmaker::NextError()
{
QString line="";
bool ok;
if (!logpresent) {ViewLog();}
if (logpresent && !errorlist->isEmpty())
  {
  Outputview->showPage(OutputWidget);
  int id=errorlist->findRef(errorlist->next());
  if (id>=0)
  {
  line=errorlist->at(id);
  }
  else
  {
  line=errorlist->at(0);
  }
  int l=line.toInt(&ok,10);
  if (ok && l<=OutputWidget->paragraphs())
    {
    OutputWidget->setCursorPosition(0 , 0);
    OutputWidget->setCursorPosition(l+3 , 0);
    }
  }
if (logpresent && errorlist->isEmpty())
  {
OutputWidget->insertLine("No LaTeX errors detected !");
  }
}

void Texmaker::PreviousError()
{
QString line="";
bool ok;
if (!logpresent) {ViewLog();}
if (logpresent && !errorlist->isEmpty())
  {
  Outputview->showPage(OutputWidget);
  int id=errorlist->findRef(errorlist->prev());
  if (id>=0)
  {
  line=errorlist->at(id);
  }
  else
  {
  line=errorlist->at(errorlist->count()-1);
  }
  int l=line.toInt(&ok,10);
  if (ok && l<=OutputWidget->paragraphs())
    {
    OutputWidget->setCursorPosition(0 , 0 );
    OutputWidget->setCursorPosition(l+3 , 0);
    }
  }

if (logpresent && errorlist->isEmpty())
  {
OutputWidget->insertLine("No LaTeX errors detected !");
  }
}
/////////////////////// LATEX TAGS ///////////////////
void Texmaker::InsertTag(QString Entity, int dx, int dy)
{
 if ( !currentEditorView() )	return;
	int para=0;
  int index=0;
  currentEditorView()->editor->viewport()->setFocus();
  currentEditorView()->editor->getCursorPosition( &para, &index);
  currentEditorView()->editor->insertAt(Entity,para,index);
  currentEditorView()->editor->setCursorPosition(para+dy,index+dx);
  currentEditorView()->editor->viewport()->setFocus();
  OutputWidget->clear();
  Outputview->showPage(OutputWidget);
  logpresent=false;
  UpdateLineColStatus();
}

void Texmaker::QuickDocument()
{
QString opt="";
int li=3;
  if ( !currentEditorView() )	return;
  QString tag=QString("\\documentclass[");
	startDlg = new quickdocumentdialog(this,"Quick Start");
  startDlg->otherClassList=userClassList;
  startDlg->otherPaperList=userPaperList;
  startDlg->otherEncodingList=userEncodingList;
  startDlg->otherOptionsList=userOptionsList;
  startDlg->Init();
  startDlg->combo1->setCurrentText(document_class);
  startDlg->combo2->setCurrentText(typeface_size);
  startDlg->combo3->setCurrentText(paper_size);
  startDlg->combo4->setCurrentText(document_encoding);
  startDlg->checkbox1->setChecked(ams_packages);
  startDlg->checkbox2->setChecked(makeidx_package);
  startDlg->LineEdit1->setText(author);
  if ( startDlg->exec() )
  {
  tag+=startDlg->combo2->currentText()+QString(",");
  tag+=startDlg->combo3->currentText();
  for ( uint j=0;j<=startDlg->availableBox->count();j++)
      {
      if (startDlg->availableBox->isSelected(j)) opt+=QString(",")+startDlg->availableBox->item(j)->text();
      }
  tag+=opt+QString("]{");
  tag+=startDlg->combo1->currentText()+QString("}");
  tag+=QString("\n");
  if (startDlg->combo4->currentText()!="NONE") tag+=QString("\\usepackage[")+startDlg->combo4->currentText()+QString("]{inputenc}");
  tag+=QString("\n");
  if (startDlg->combo4->currentText()=="utf8")
  	{
	tag+=QString("\\usepackage{ucs}\n");
	li=li+1;
	}
  if (startDlg->checkbox1->isChecked())
     {
     tag+=QString("\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\usepackage{amssymb}\n");
     li=li+3;
     }
  if (startDlg->checkbox2->isChecked())
     {
     tag+=QString("\\usepackage{makeidx}\n");
     li=li+1;
     }
  if (startDlg->LineEdit1->text()!="")
     {
     tag+="\\author{"+startDlg->LineEdit1->text()+"}\n";
     li=li+1;
     }
  if (startDlg->LineEdit2->text()!="")
     {
     tag+="\\title{"+startDlg->LineEdit2->text()+"}\n";
     li=li+1;
     }
  tag+=QString("\\begin{document}\n\n\\end{document}");
  InsertTag(tag,0,li);
  document_class=startDlg->combo1->currentText();
  typeface_size=startDlg->combo2->currentText();
  paper_size=startDlg->combo3->currentText();
  document_encoding=startDlg->combo4->currentText();
  ams_packages=startDlg->checkbox1->isChecked();
  makeidx_package=startDlg->checkbox2->isChecked();
  author=startDlg->LineEdit1->text();
  userClassList=startDlg->otherClassList;
  userPaperList=startDlg->otherPaperList;
  userEncodingList=startDlg->otherEncodingList;
  userOptionsList=startDlg->otherOptionsList;
  }
  delete( startDlg);
}


void Texmaker::QuickTabular()
{
  if ( !currentEditorView() )	return;
  QString al="";
  QString vs="";
  QString hs="";
	quickDlg = new tabdialog(this,"Tabular");
  if ( quickDlg->exec() )
  {
    int	y = quickDlg->spinBoxRows->value();
    int	x = quickDlg->spinBoxCollums->value();
    if  ((quickDlg->combo2->currentItem ())==0) vs=QString("|");
    if  ((quickDlg->combo2->currentItem ())==1) vs=QString("||");
    if  ((quickDlg->combo2->currentItem ())==2) vs=QString("");
    if  ((quickDlg->combo2->currentItem ())==3) vs=QString("@{}");
  	QString tag = QString("\\begin{tabular}{")+vs;
    if  ((quickDlg->combo1->currentItem ())==0) al=QString("c")+vs;
    if  ((quickDlg->combo1->currentItem ())==1) al=QString("l")+vs;
    if  ((quickDlg->combo1->currentItem ())==2) al=QString("r")+vs;
    if  ((quickDlg->combo1->currentItem ())==3) al=QString("p{}")+vs;
    if (quickDlg->checkbox1->isChecked()) hs=QString("\\hline ");
 		for ( int j=0;j<x;j++) {tag +=al;}
    tag +=QString("}\n");
 	  for ( int i=0;i<y;i++) {
 		  tag +=hs;
 		  for ( int j=0;j<x-1;j++)
 			  tag +=quickDlg->Table1->text(i,j)+ QString(" & ");
 		  tag +=quickDlg->Table1->text(i,x-1)+ QString(" \\\\ \n");
 	  }
 	  if (quickDlg->checkbox1->isChecked()) tag +=hs+QString("\n\\end{tabular} ");
    else tag +=QString("\\end{tabular} ");
  InsertTag(tag,0,0);
  }

  delete( quickDlg);

}

void Texmaker::QuickTabbing()
{
  if ( !currentEditorView() )	return;
  tabDlg = new tabbingdialog(this,"Tabbing");
  if ( tabDlg->exec() )
 {
  int	x = tabDlg->spinBoxCollums->value();
  int	y = tabDlg->spinBoxRows->value();
  QString s=tabDlg->LineEdit1->text();
  QString tag = QString("\\begin{tabbing}\n");
  for ( int j=1;j<x;j++) {tag +="\\hspace{"+s+"}\\=";}
  tag+="\\kill\n";
 	for ( int i=0;i<y-1;i++)
   {
   for ( int j=1;j<x;j++) {tag +=" \\> ";}
   tag+="\\\\ \n";
   }
   for ( int j=1;j<x;j++) {tag +=" \\> ";}
  tag += QString("\n\\end{tabbing} ");
  InsertTag(tag,0,2);
 }
  delete( tabDlg);
}

void Texmaker::QuickArray()
{
  if ( !currentEditorView() )	return;
  QString al;
	arrayDlg = new arraydialog(this,"Array");
  if ( arrayDlg->exec() ) {
  	int y = arrayDlg->spinBoxRows->value();
  	int x = arrayDlg->spinBoxCollums->value();
    QString env=arrayDlg->combo2->currentText();
  	QString tag = QString("\\begin{")+env+"}";
    if (env=="array")
    {
      tag+="{";
      if  ((arrayDlg->combo->currentItem ())==0) al=QString("c");
      if  ((arrayDlg->combo->currentItem ())==1) al=QString("l");
      if  ((arrayDlg->combo->currentItem ())==2) al=QString("r");
   		for ( int j=0;j<x;j++) {tag +=al;}
      tag+="}";
    }
    tag +=QString("\n");
 	  for ( int i=0;i<y-1;i++) {
  		  for ( int j=0;j<x-1;j++)
 			  tag +=arrayDlg->Table1->text(i,j)+ QString(" & ");
 		  tag +=arrayDlg->Table1->text(i,x-1)+ QString(" \\\\ \n");
 	  }
  		  for ( int j=0;j<x-1;j++)
 			  tag +=arrayDlg->Table1->text(y-1,j)+ QString(" & ");
 	  tag +=arrayDlg->Table1->text(y-1,x-1)+ QString("\n\\end{")+env+"} ";
  InsertTag(tag,0,0);
  }
  delete( arrayDlg);

}

void Texmaker::QuickLetter()
{
  if ( !currentEditorView() )	return;
  QString tag=QString("\\documentclass[");
	ltDlg = new letterdialog(this,"Letter");
  if ( ltDlg->exec() )
  {
  tag+=ltDlg->combo2->currentText()+QString(",");
  tag+=ltDlg->combo3->currentText()+QString("]{letter}");
  tag+=QString("\n");
  if (ltDlg->combo4->currentText()!="NONE") tag+=QString("\\usepackage[")+ltDlg->combo4->currentText()+QString("]{inputenc}");
  tag+=QString("\n");
  if (ltDlg->checkbox1->isChecked()) tag+=QString("\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\usepackage{amssymb}\n");
  tag+="\\address{your name and address} \n";
  tag+="\\signature{your signature} \n";
  tag+="\\begin{document} \n";
  tag+="\\begin{letter}{name and address of the recipient} \n";
  tag+="\\opening{saying hello} \n \n";
  tag+="write your letter here \n \n";
  tag+="\\closing{saying goodbye} \n";
  tag+="%\\cc{Cclist} \n";
  tag+="%\\ps{adding a postscript} \n";
  tag+="%\\encl{list of enclosed material} \n";
  tag+="\\end{letter} \n";
  tag+="\\end{document}";
  if (ltDlg->checkbox1->isChecked()) {InsertTag(tag,9,5);}
  else {InsertTag(tag,9,2);}
  }
  delete( ltDlg);
}

void Texmaker::Insert1()
{
InsertTag("\\documentclass[10pt]{}",21,0);
OutputWidget->insertLine( "\\documentclass[options]{class}" );
OutputWidget->insertLine( "class : article,report,book,letter" );
OutputWidget->insertLine( "size options : 10pt, 11pt, 12pt" );
OutputWidget->insertLine( "paper size options: a4paper, a5paper, b5paper, letterpaper, legalpaper, executivepaper" );
OutputWidget->insertLine("other options: ");
OutputWidget->insertLine("landscape -- selects landscape format. Default is portrait. ");
OutputWidget->insertLine("titlepage, notitlepage -- selects if there should be a separate title page.");
OutputWidget->insertLine("leqno -- equation number on left side of equations. Default is right side.");
OutputWidget->insertLine("fleqn -- displayed formulas flush left. Default is centred.");
OutputWidget->insertLine("onecolumn, twocolumn -- one or two columns. Defaults to one column");
OutputWidget->insertLine("oneside, twoside -- selects one- or twosided layout.");
}
void Texmaker::Insert1bis()
{
InsertTag("\\usepackage{} ",12,0);
OutputWidget->insertLine("\\usepackage[options]{pkg}");
OutputWidget->insertLine("Any options given in the \\documentclass command that are unknown by the selected document class");
OutputWidget->insertLine("are passed on to the packages loaded with \\usepackage.");
}
void Texmaker::Insert1ter()
{
InsertTag("\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\usepackage{amssymb}\n",0,3);
OutputWidget->insertLine("The principal American Mathematical Society packages");
}
void Texmaker::Insert2()
{
InsertTag("\\begin{document}\n\n\\end{document} ",0,1);
OutputWidget->insertLine("Text is allowed only between \\begin{document} and \\end{document}.");
OutputWidget->insertLine("The 'preamble' (before \\begin{document}} ) may contain declarations only.");
}

void Texmaker::Insert3()
{
if ( !currentEditorView() )	return;
currentEditorView()->editor->viewport()->setFocus();
QString tag;
stDlg = new structdialog(this," \\part");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\part{");}
  else
  {tag=QString("\\part*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("}\n");
  InsertTag(tag,0,1);
  UpdateStructure();
  }
OutputWidget->insertLine( "\\part{title}");
OutputWidget->insertLine( "\\part*{title} : do not include a number and do not make an entry in the table of contents");
delete( stDlg);
}

void Texmaker::Insert4()
{
 if ( !currentEditorView() )	return;
currentEditorView()->editor->viewport()->setFocus();
QString tag;
stDlg = new structdialog(this," \\chapter");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\chapter{");}
  else
  {tag=QString("\\chapter*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("}\n");
  InsertTag(tag,0,1);
  UpdateStructure();
  }
OutputWidget->insertLine( "\\chapter{title}");
OutputWidget->insertLine( "\\chapter*{title} : do not include a number and do not make an entry in the table of contents");
OutputWidget->insertLine( "Only for 'report' and 'book' class document.");
delete( stDlg);
}

void Texmaker::Insert5()
{
 if ( !currentEditorView() )	return;
currentEditorView()->editor->viewport()->setFocus();
QString tag;
stDlg = new structdialog(this," \\section");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\section{");}
  else
  {tag=QString("\\section*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("}\n");
  InsertTag(tag,0,1);
  UpdateStructure();
  }
OutputWidget->insertLine( "\\section{title}");
OutputWidget->insertLine( "\\section*{title} : do not include a number and do not make an entry in the table of contents");
delete( stDlg);
}

void Texmaker::Insert6()
{
 if ( !currentEditorView() )	return;
currentEditorView()->editor->viewport()->setFocus();
QString tag;
stDlg = new structdialog(this," \\subsection");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\subsection{");}
  else
  {tag=QString("\\subsection*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("}\n");
  InsertTag(tag,0,1);
  UpdateStructure();
  }
OutputWidget->insertLine( "\\subsection{title}");
OutputWidget->insertLine( "\\subsection*{title} : do not include a number and do not make an entry in the table of contents");
delete( stDlg);
}

void Texmaker::Insert6bis()
{
 if ( !currentEditorView() )	return;
currentEditorView()->editor->viewport()->setFocus();
QString tag;
stDlg = new structdialog(this," \\subsubsection");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\subsubsection{");}
  else
  {tag=QString("\\subsubsection*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("}\n");
  InsertTag(tag,0,1);
  UpdateStructure();
  }
OutputWidget->insertLine( "\\subsubsection{title}");
OutputWidget->insertLine( "\\subsubsection*{title} : do not include a number and do not make an entry in the table of contents");
delete( stDlg);
}

void Texmaker::Insert7()
{
 if ( !currentEditorView() )	return;
currentEditorView()->editor->viewport()->setFocus();
QString tag;
stDlg = new structdialog(this," \\paragraph");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\paragraph{");}
  else
  {tag=QString("\\paragraph*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("}\n");
  InsertTag(tag,0,1);
  UpdateStructure();
  }
OutputWidget->insertLine( "\\paragraph{title}");
OutputWidget->insertLine( "\\paragraph*{title} : do not include a number and do not make an entry in the table of contents");
delete( stDlg);
}

void Texmaker::Insert8()
{
 if ( !currentEditorView() )	return;
currentEditorView()->editor->viewport()->setFocus();
QString tag;
stDlg = new structdialog(this," \\subparagraph");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\subparagraph{");}
  else
  {tag=QString("\\subparagraph*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("}\n");
  InsertTag(tag,0,1);
  UpdateStructure();
  }
OutputWidget->insertLine( "\\subparagraph{title}");
OutputWidget->insertLine( "\\subparagraph*{title} : do not include a number and do not make an entry in the table of contents");
delete( stDlg);
}

void Texmaker::Insert9()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
   InsertTag("\\begin{center}\n\n\\end{center} ",0,1);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\begin{center}\n",0,1);
   currentEditorView()->editor->paste();
   InsertTag("\n\\end{center}",0,0);
   }
OutputWidget->insertLine( "Each line must be terminated with the string \\\\.");
}

void Texmaker::Insert10()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
   InsertTag("\\begin{flushleft}\n\n\\end{flushleft} ",0,1);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\begin{flushleft}\n",0,1);
   currentEditorView()->editor->paste();
   InsertTag("\n\\end{flushleft}",0,0);
   }
OutputWidget->insertLine( "Each line must be terminated with the string \\\\.");
}

void Texmaker::Insert11()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
   InsertTag("\\begin{flushright}\n\n\\end{flushright} ",0,1);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\begin{flushright}\n",0,1);
   currentEditorView()->editor->paste();
   InsertTag("\n\\end{flushright}",0,0);
   }
OutputWidget->insertLine( "Each line must be terminated with the string \\\\.");
}

void Texmaker::Insert12()
{
InsertTag("\\begin{quote}\n\n\\end{quote} ",0,1);
OutputWidget->insertLine("The text is justified at both margins.");
OutputWidget->insertLine(" Leaving a blank line between text produces a new paragraph.");
}

void Texmaker::Insert13()
{
InsertTag("\\begin{quotation}\n\n\\end{quotation} ",0,1);
OutputWidget->insertLine("The text is justified at both margins and there is paragraph indentation.");
OutputWidget->insertLine(" Leaving a blank line between text produces a new paragraph.");
}

void Texmaker::Insert14()
{
InsertTag("\\begin{verse}\n\n\\end{verse} ",0,1);
OutputWidget->insertLine("The verse environment is designed for poetry.");
OutputWidget->insertLine("Separate the lines of each stanza with \\\\, and use one or more blank lines to separate the stanzas.");
}

void Texmaker::Insert15()
{
InsertTag("\\begin{verbatim}\n\n\\end{verbatim} ",0,1);
OutputWidget->insertLine("Environment that gets LaTeX to print exactly what you type in.");
}

void Texmaker::Insert16()
{
InsertTag("\\begin{itemize}\n\\item \n\\end{itemize} ",6,1);
OutputWidget->insertLine("The itemize environment produces a 'bulleted' list.");
OutputWidget->insertLine("Each item of an itemized list begins with an \\item command.");
}

void Texmaker::Insert17()
{
InsertTag("\\begin{enumerate}\n\\item \n\\end{enumerate} ",6,1);
OutputWidget->insertLine("The enumerate environment produces a numbered list.");
OutputWidget->insertLine("Each item of an enumerated list begins with an \\item command.");
}

void Texmaker::Insert18()
{
InsertTag("\\begin{description}\n\\item[]\n\\end{description} ",6,1);
OutputWidget->insertLine("The description environment is used to make labelled lists.");
OutputWidget->insertLine("Each item of the list begins with an \\item[label] command.");
OutputWidget->insertLine("The 'label' is bold face and flushed right.");
}

void Texmaker::Insert19()
{
InsertTag("\\begin{list}{}{}\n\\item \n\\end{list} ",13,0);
OutputWidget->insertLine("\\begin{list}{label}{spacing}");
OutputWidget->insertLine("The {label} argument is a piece of text that is inserted in a box to form the label. ");
OutputWidget->insertLine("The {spacing} argument contains commands to change the spacing parameters for the list.");
OutputWidget->insertLine("Each item of the list begins with an \\item command.");
}

void Texmaker::Insert20()
{
InsertTag("\\item ",6,0);
OutputWidget->insertLine("\\item[label] Hello!");
}

void Texmaker::Insert21()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\textit{} ",8,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\textit{",8,0);
   currentEditorView()->editor->paste();
   InsertTag("}",0,0);
   }
OutputWidget->insertLine("\\textit{italic text}");
}

void Texmaker::Insert22()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\textsl{} ",8,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\textsl{",8,0);
   currentEditorView()->editor->paste();
   InsertTag("}",0,0);
   }
OutputWidget->insertLine("\\textsl{slanted text}");
}

void Texmaker::Insert23()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\textbf{} ",8,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\textbf{",8,0);
   currentEditorView()->editor->paste();
   InsertTag("}",0,0);
   }
OutputWidget->insertLine("\\textbf{boldface text}");
}

void Texmaker::Insert24()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\texttt{} ",8,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\texttt{",8,0);
   currentEditorView()->editor->paste();
   InsertTag("}",0,0);
   }
OutputWidget->insertLine("\\texttt{typewriter text}");
}

void Texmaker::Insert25()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\textsc{} ",8,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\textsc{",8,0);
   currentEditorView()->editor->paste();
   InsertTag("}",0,0);
   }
OutputWidget->insertLine("\\textsc{small caps text}");
}

void Texmaker::Insert26()
{
InsertTag("\\begin{tabbing}\n\n\\end{tabbing} ",0,1);
OutputWidget->insertLine("The tabbing environment provides a way to align text in columns.");
OutputWidget->insertLine("\\begin{tabbing}");
OutputWidget->insertLine("text \\= more text \\= still more text \\= last text \\\\");
OutputWidget->insertLine("second row \\>  \\> more \\\\");
OutputWidget->insertLine("\\end{tabbing}");
OutputWidget->insertLine("Commands :");
OutputWidget->insertLine("\\=  Sets a tab stop at the current position.");
OutputWidget->insertLine("\\>  Advances to the next tab stop.");
OutputWidget->insertLine("\\<  Allows you to put something to the left of the local margin without changing the margin. Can only be used at the start of the line.");
OutputWidget->insertLine("\\+  Moves the left margin of the next and all the following commands one tab stop to the right");
OutputWidget->insertLine("\\-  Moves the left margin of the next and all the following commands one tab stop to the left");
OutputWidget->insertLine("\\'  Moves everything that you have typed so far in the current column to the right of the previous column, flush against the current column's tab stop. ");
OutputWidget->insertLine("\\`  Allows you to put text flush right against any tab stop, including tab stop 0");
OutputWidget->insertLine("\\kill  Sets tab stops without producing text.");
OutputWidget->insertLine("\\a  In a tabbing environment, the commands \\=, \\' and \\` do not produce accents as normal. Instead, the commands \\a=, \\a' and \\a` are used.");
}

void Texmaker::Insert27()
{
InsertTag("\\begin{tabular}{}\n\n\\end{tabular} ",16,0);
OutputWidget->insertLine("\\begin{tabular}[pos]{cols}");
OutputWidget->insertLine("column 1 entry & column 2 entry ... & column n entry \\\\");
OutputWidget->insertLine("...");
OutputWidget->insertLine("\\end{tabular}");
OutputWidget->insertLine("pos : Specifies the vertical position; default is alignment on the centre of the environment.");
OutputWidget->insertLine("     t - align on top row");
OutputWidget->insertLine("     b - align on bottom row");
OutputWidget->insertLine("cols : Specifies the column formatting.");
OutputWidget->insertLine("     l - A column of left-aligned items.");
OutputWidget->insertLine("     r - A column of right-aligned items.");
OutputWidget->insertLine("     c - A column of centred items.");
OutputWidget->insertLine("     | - A vertical line the full height and depth of the environment.");
OutputWidget->insertLine("     @{text} - This inserts text in every row.");
OutputWidget->insertLine("The \\hline command draws a horizontal line the width of the table.");
OutputWidget->insertLine("The \\cline{i-j} command draws horizontal lines across the columns specified, beginning in column i and ending in column j,");
OutputWidget->insertLine("The \\vline command draws a vertical line extending the full height and depth of its row.");

}

void Texmaker::Insert28()
{
InsertTag("\\multicolumn{}{}{} ",13,0);
OutputWidget->insertLine("\\multicolumn{cols}{pos}{text}");
OutputWidget->insertLine("col, specifies the number of columns to span.");
OutputWidget->insertLine("pos specifies the formatting of the entry: c for centred, l for flushleft, r for flushright.");
OutputWidget->insertLine("text specifies what text is to make up the entry.");
}

void Texmaker::Insert29()
{
InsertTag("\\hline ",7,0);
OutputWidget->insertLine("The \\hline command draws a horizontal line the width of the table.");
}

void Texmaker::Insert30()
{
InsertTag("\\vline ",7,0);
OutputWidget->insertLine("The \\vline command draws a vertical line extending the full height and depth of its row.");
}

void Texmaker::Insert31()
{
InsertTag("\\cline{-} ",7,0);
OutputWidget->insertLine("The \\cline{i-j} command draws horizontal lines across the columns specified, beginning in column i and ending in column j,");
}

void Texmaker::Insert32()
{
InsertTag("\\newpage ",9,0);
OutputWidget->insertLine("The \\newpage command ends the current page");
}

void Texmaker::Insert33()
{
InsertTag("\\linebreak ",11,0);
OutputWidget->insertLine("The \\linebreak command tells LaTeX to break the current line at the point of the command.");
}

void Texmaker::Insert34()
{
InsertTag("\\pagebreak ",11,0);
OutputWidget->insertLine("The \\pagebreak command tells LaTeX to break the current page at the point of the command.");
}

void Texmaker::Insert35()
{
InsertTag("\\bigskip ",9,0);
OutputWidget->insertLine("The \\bigskip command adds a 'big' vertical space.");
}

void Texmaker::Insert36()
{
InsertTag("\\medskip ",9,0);
OutputWidget->insertLine("The \\medskip command adds a 'medium' vertical space.");
}

void Texmaker::Insert37()
{
if ( !currentEditorView() )	return;
QString currentDir=QDir::currentDirPath();
QString finame;
if (singlemode) {finame=getName();}
else {finame=MasterName;}
QFileInfo fi(finame);
if (finame!="untitled") currentDir=fi.dirPath();
sfDlg = new FileChooser(this,"Select an image File");
sfDlg->setFilter("Graphic files (*.eps *.pdf *.png);;All files (*.*)");
sfDlg->setDir(currentDir);
if (sfDlg->exec() )
  {
   QString fn=sfDlg->fileName();
   QFileInfo fi(fn);
   InsertTag("\\includegraphics[scale=1]{"+fi.baseName()+"."+fi.extension()+"} ",26,0);
   OutputWidget->insertLine("This command is used to import image files (\\usepackage{graphicx} is required)");
   OutputWidget->insertLine("Examples :");
   OutputWidget->insertLine("\\includegraphics{file} ; \\includegraphics[width=10cm]{file} ; \\includegraphics*[scale=0.75]{file}");
   if (fi.extension()=="eps")
     {
     OutputWidget->insertLine("*************  ABOUT THIS IMAGE  *************");
     OutputWidget->insertLine(DetectEpsSize(fn));
     }
  }
delete sfDlg;
}

void Texmaker::Insert37bis()
{
if ( !currentEditorView() )	return;
QString currentDir=QDir::currentDirPath();
QString finame;
if (singlemode) {finame=getName();}
else {finame=MasterName;}
QFileInfo fi(finame);
if (finame!="untitled") currentDir=fi.dirPath();
sfDlg = new FileChooser(this,"Select a File");
sfDlg->setFilter("TeX files (*.tex);;All files (*.*)");
sfDlg->setDir(currentDir);
if (sfDlg->exec() )
  {
QString fn=sfDlg->fileName();
QFileInfo fi(fn);
InsertTag("\\include{"+fi.baseName()+"}",9,0);
  }
delete sfDlg;
UpdateStructure();
OutputWidget->insertLine("\\include{file}");
OutputWidget->insertLine("The \\include command is used in conjunction with the \\includeonly command for selective inclusion of files.");
}

void Texmaker::Insert37ter()
{
if ( !currentEditorView() )	return;
QString currentDir=QDir::currentDirPath();
QString finame;
if (singlemode) {finame=getName();}
else {finame=MasterName;}
QFileInfo fi(finame);
if (finame!="untitled") currentDir=fi.dirPath();
sfDlg = new FileChooser(this,"Select a File");
sfDlg->setFilter("TeX files (*.tex);;All files (*.*)");
sfDlg->setDir(currentDir);
if (sfDlg->exec() )
  {
QString fn=sfDlg->fileName();
QFileInfo fi(fn);
InsertTag("\\input{"+fi.baseName()+"}",7,0);
  }
delete sfDlg;
UpdateStructure();
OutputWidget->insertLine("\\input{file}");
OutputWidget->insertLine("The \\input command causes the indicated file to be read and processed, exactly as if its contents had been inserted in the current file at that point.");
}

void Texmaker::Insert38()
{
InsertTag("\\cite{} ",6,0);
OutputWidget->insertLine("\\cite{ref} :");
OutputWidget->insertLine("This command generates an in-text citation to the reference associated with the ref entry in the bib file");
OutputWidget->insertLine("You can open the bib file with Texmaker to see all the available references");
}

void Texmaker::Insert39()
{
InsertTag("\\bibliographystyle{} ",19,0);
OutputWidget->insertLine("The argument to \\bibliographystyle refers to a file style.bst, which defines how your citations will look");
OutputWidget->insertLine("The standard styles distributed with BibTeX are:");
OutputWidget->insertLine("alpha : sorted alphabetically. Labels are formed from name of author and year of publication.");
OutputWidget->insertLine("plain  : sorted alphabetically. Labels are numeric.");
OutputWidget->insertLine("unsrt : like plain, but entries are in order of citation.");
OutputWidget->insertLine("abbrv  : like plain, but more compact labels.");
}
void Texmaker::Insert40()
{
if ( !currentEditorView() )	return;
currentEditorView()->editor->viewport()->setFocus();
QString tag;
QFileInfo fi(getName());
tag=QString("\\bibliography{");
tag +=fi.baseName();
tag +=QString("}\n");
InsertTag(tag,0,1);
OutputWidget->insertLine("The argument to \\bibliography refers to the bib file (without extension)");
OutputWidget->insertLine("which should contain your database in BibTeX format.");
OutputWidget->insertLine("Texmaker inserts automatically the base name of the TeX file");
}
void Texmaker::Insert41()
{
InsertTag("\\label{} ",7,0);
OutputWidget->insertLine("\\label{key}");
}
void Texmaker::Insert42()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
   InsertTag("\\begin{table}\n\n\\caption{}\n\\end{table} ",0,1);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\begin{table}\n",0,1);
   currentEditorView()->editor->paste();
   InsertTag("\n\\caption{}\n\\end{table}",9,1);
   }
OutputWidget->insertLine( "\\begin{table}[placement]");
OutputWidget->insertLine( "body of the table");
OutputWidget->insertLine( "\\caption{table title}");
OutputWidget->insertLine( "\\end{table}");
OutputWidget->insertLine( "Tables are objects that are not part of the normal text, and are usually floated to a convenient place");
OutputWidget->insertLine( "The optional argument [placement] determines where LaTeX will try to place your table");
OutputWidget->insertLine( "h : Here - at the position in the text where the table environment appear");
OutputWidget->insertLine( "t : Top - at the top of a text page");
OutputWidget->insertLine( "b : Bottom - at the bottom of a text page");
OutputWidget->insertLine( "p : Page of floats - on a separate float page, which is a page containing no text, only floats");
OutputWidget->insertLine( "The body of the table is made up of whatever text, LaTeX commands, etc., you wish.");
OutputWidget->insertLine( "The \\caption command allows you to title your table.");

}
void Texmaker::Insert43()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
   InsertTag("\\begin{figure}\n\n\\caption{}\n\\end{figure} ",0,1);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\begin{figure}\n",0,1);
   currentEditorView()->editor->paste();
   InsertTag("\n\\caption{}\n\\end{figure}",9,1);
   }
OutputWidget->insertLine( "\\begin{figure}[placement]");
OutputWidget->insertLine( "body of the figure");
OutputWidget->insertLine( "\\caption{figure title}");
OutputWidget->insertLine( "\\end{figure}");
OutputWidget->insertLine( "Figures are objects that are not part of the normal text, and are usually floated to a convenient place");
OutputWidget->insertLine( "The optional argument [placement] determines where LaTeX will try to place your figure");
OutputWidget->insertLine( "h : Here - at the position in the text where the figure environment appear");
OutputWidget->insertLine( "t : Top - at the top of a text page");
OutputWidget->insertLine( "b : Bottom - at the bottom of a text page");
OutputWidget->insertLine( "p : Page of floats - on a separate float page, which is a page containing no text, only floats");
OutputWidget->insertLine( "The body of the figure is made up of whatever text, LaTeX commands, etc., you wish.");
OutputWidget->insertLine( "The \\caption command allows you to title your figure.");
}
void Texmaker::Insert44()
{
InsertTag("\\begin{titlepage}\n\n\\end{titlepage} ",0,1);
OutputWidget->insertLine( "\\begin{titlepage}");
OutputWidget->insertLine( "text");
OutputWidget->insertLine( "\\end{titlepage}");
OutputWidget->insertLine( "The titlepage environment creates a title page, i.e. a page with no printed page number or heading.");
}
void Texmaker::Insert45()
{
InsertTag("\\author{}",8,0);
OutputWidget->insertLine( "\\author{names}");
OutputWidget->insertLine( "The \\author command declares the author(s), where names is a list of authors separated by \\and commands.");
}
void Texmaker::Insert46()
{
InsertTag("\\title{}",7,0);
OutputWidget->insertLine( "\\title{text}");
OutputWidget->insertLine( "The \\title command declares text to be the title.");
OutputWidget->insertLine( "Use \\\\ to tell LaTeX where to start a new line in a long title.");
}
void Texmaker::Insert47()
{
InsertTag("\\index{}",7,0);
OutputWidget->insertLine( "\\index{word}");
}

void Texmaker::Insert48()
{
UpdateStructure();
QString tag="";
refDlg = new refdialog(this,"Labels");
refDlg->combo1->insertStringList(labelitem);
if (!labelitem.isEmpty() && refDlg->exec() )
  {
  tag="\\ref{"+refDlg->combo1->currentText()+"}";
  InsertTag(tag,qstrlen(tag),0);
  }
else InsertTag("\\ref{}",5,0);
delete refDlg;
OutputWidget->insertLine( "\\ref{key}");
}

void Texmaker::Insert49()
{
UpdateStructure();
QString tag="";
refDlg = new refdialog(this,"Labels");
refDlg->combo1->insertStringList(labelitem);
if (!labelitem.isEmpty() && refDlg->exec() )
  {
  tag="\\pageref{"+refDlg->combo1->currentText()+"}";
  InsertTag(tag,qstrlen(tag),0);
  }
else InsertTag("\\pageref{}",9,0);
delete refDlg;
OutputWidget->insertLine( "\\pageref{key}");
}

void Texmaker::Insert50()
{
InsertTag("\\footnote{}",10,0);
OutputWidget->insertLine( "\\footnote{text}");
}

void Texmaker::Insert51()
{
InsertTag("\\maketitle",10,0);
OutputWidget->insertLine( "This command generates a title on a separate title page\n- except in the article class, where the title normally goes at the top of the first page.");
}

void Texmaker::Insert52()
{
InsertTag("\\tableofcontents",16,0);
OutputWidget->insertLine( "Put this command where you want the table of contents to go");
}

void Texmaker::SizeCommand(const QString& text)
{
if ( !currentEditorView() )	return;
if (text=="tiny")
    {
    if (!currentEditorView()->editor->hasSelectedText())
       {
       InsertTag("\\begin{tiny}\\end{tiny}",12,0);
       }
    else
       {
       currentEditorView()->editor->cut();
       InsertTag("\\begin{tiny}",12,0);
       currentEditorView()->editor->paste();
       InsertTag("\\end{tiny}",0,0);
       }
    }

if (text=="scriptsize")
    {
    if (!currentEditorView()->editor->hasSelectedText())
       {
       InsertTag("\\begin{scriptsize}\\end{scriptsize}",18,0);
       }
    else
       {
       currentEditorView()->editor->cut();
       InsertTag("\\begin{scriptsize}",18,0);
       currentEditorView()->editor->paste();
       InsertTag("\\end{scriptsize}",0,0);
       }
    }

if (text=="footnotesize")
    {
    if (!currentEditorView()->editor->hasSelectedText())
       {
       InsertTag("\\begin{footnotesize}\\end{footnotesize}",20,0);
       }
    else
       {
       currentEditorView()->editor->cut();
       InsertTag("\\begin{footnotesize}",20,0);
       currentEditorView()->editor->paste();
       InsertTag("\\end{footnotesize}",0,0);
       }
    }

if (text=="small")
    {
    if (!currentEditorView()->editor->hasSelectedText())
       {
       InsertTag("\\begin{small}\\end{small}",13,0);
       }
    else
       {
       currentEditorView()->editor->cut();
       InsertTag("\\begin{small}",13,0);
       currentEditorView()->editor->paste();
       InsertTag("\\end{small}",0,0);
       }
    }

if (text=="normalsize")
    {
    if (!currentEditorView()->editor->hasSelectedText())
       {
       InsertTag("\\begin{normalsize}\\end{normalsize}",18,0);
       }
    else
       {
       currentEditorView()->editor->cut();
       InsertTag("\\begin{normalsize}",18,0);
       currentEditorView()->editor->paste();
       InsertTag("\\end{normalsize}",0,0);
       }
    }

if (text=="large")
    {
    if (!currentEditorView()->editor->hasSelectedText())
       {
       InsertTag("\\begin{large}\\end{large}",13,0);
       }
    else
       {
       currentEditorView()->editor->cut();
       InsertTag("\\begin{large}",13,0);
       currentEditorView()->editor->paste();
       InsertTag("\\end{large}",0,0);
       }
    }

if (text=="Large")
    {
    if (!currentEditorView()->editor->hasSelectedText())
       {
       InsertTag("\\begin{Large}\\end{Large}",13,0);
       }
    else
       {
       currentEditorView()->editor->cut();
       InsertTag("\\begin{Large}",13,0);
       currentEditorView()->editor->paste();
       InsertTag("\\end{Large}",0,0);
       }
    }

if (text=="LARGE")
    {
    if (!currentEditorView()->editor->hasSelectedText())
       {
       InsertTag("\\begin{LARGE}\\end{LARGE}",13,0);
       }
    else
       {
       currentEditorView()->editor->cut();
       InsertTag("\\begin{LARGE}",13,0);
       currentEditorView()->editor->paste();
       InsertTag("\\end{LARGE}",0,0);
       }
    }

if (text=="huge")
    {
    if (!currentEditorView()->editor->hasSelectedText())
       {
       InsertTag("\\begin{huge}\\end{huge}",12,0);
       }
    else
       {
       currentEditorView()->editor->cut();
       InsertTag("\\begin{huge}",12,0);
       currentEditorView()->editor->paste();
       InsertTag("\\end{huge}",0,0);
       }
    }

if (text=="Huge")
    {
    if (!currentEditorView()->editor->hasSelectedText())
       {
       InsertTag("\\begin{Huge}\\end{Huge}",12,0);
       }
    else
       {
       currentEditorView()->editor->cut();
       InsertTag("\\begin{Huge}",12,0);
       currentEditorView()->editor->paste();
       InsertTag("\\end{Huge}",0,0);
       }
    }
}

void Texmaker::SectionCommand(const QString& text)
{
if ( !currentEditorView() )	return;
if (text=="part") Insert3();
if (text=="chapter") Insert4();
if (text=="section") Insert5();
if (text=="subsection") Insert6();
if (text=="subsubsection") Insert6bis();
if (text=="paragraph") Insert7();
if (text=="subparagraph") Insert8();
}

void Texmaker::OtherCommand(const QString& text)
{
if ( !currentEditorView() )	return;
if (text=="label") Insert41();
if (text=="ref") Insert48();
if (text=="pageref") Insert49();
if (text=="index") Insert47();
if (text=="cite") Insert38();
if (text=="footnote") Insert50();
}

void Texmaker::NewLine()
{
InsertTag("\\\\\n",0,1);
}
//////////////////////////// MATHS TAGS/////////////////////////////////////
void Texmaker::InsertMath1()
{
InsertTag("$  $",2,0);
}

void Texmaker::InsertMath2()
{
InsertTag("$$  $$",3,0);
}

void Texmaker::InsertMath3()
{
InsertTag("_{}",2,0);
}

void Texmaker::InsertMath4()
{
InsertTag("^{}",2,0);
}

void Texmaker::InsertMath5()
{
InsertTag("\\frac{}{}",6,0);
}

void Texmaker::InsertMath6()
{
InsertTag("\\dfrac{}{}",7,0);
}

void Texmaker::InsertMath7()
{
InsertTag("\\sqrt{}",6,0);
}
void Texmaker::InsertMath8()
{
InsertTag("\\left ",6,0);
}

void Texmaker::InsertMath9()
{
InsertTag("\\right ",7,0);
}

void Texmaker::InsertMath10()
{
InsertTag("\\begin{array}{}\n\n\\end{array}",14,0);
OutputWidget->insertLine("\\begin{array}{col1col2...coln}");
OutputWidget->insertLine("column 1 entry & column 2 entry ... & column n entry \\\\");
OutputWidget->insertLine("...");
OutputWidget->insertLine("\\end{array}");
OutputWidget->insertLine("Each column, coln, is specified by a single letter that tells how items in that row should be formatted.");
OutputWidget->insertLine("     c -- for centered ");
OutputWidget->insertLine("     l -- for flush left ");
OutputWidget->insertLine("     r -- for flush right");
}
void Texmaker::InsertMath16()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\underline{}",11,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\underline{",11,0);
   currentEditorView()->editor->paste();
   InsertTag("}",1,0);
   }
}

void Texmaker::InsertMath66()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\mathrm{}",8,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\mathrm{",8,0);
   currentEditorView()->editor->paste();
   InsertTag("}",1,0);
   }
}
void Texmaker::InsertMath67()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\mathit{}",8,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\mathit{",8,0);
   currentEditorView()->editor->paste();
   InsertTag("}",1,0);
   }
}
void Texmaker::InsertMath68()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\mathbf{}",8,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\mathbf{",8,0);
   currentEditorView()->editor->paste();
   InsertTag("}",1,0);
   }
}
void Texmaker::InsertMath69()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\mathsf{}",8,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\mathsf{",8,0);
   currentEditorView()->editor->paste();
   InsertTag("}",1,0);
   }
}
void Texmaker::InsertMath70()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\mathtt{}",8,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\mathtt{",8,0);
   currentEditorView()->editor->paste();
   InsertTag("}",1,0);
   }
}
void Texmaker::InsertMath71()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\mathcal{}",9,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\mathcal{",9,0);
   currentEditorView()->editor->paste();
   InsertTag("}",1,0);
   }
}
void Texmaker::InsertMath72()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\mathbb{}",8,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\mathbb{",8,0);
   currentEditorView()->editor->paste();
   InsertTag("}",1,0);
   }
}
void Texmaker::InsertMath73()
{
if ( !currentEditorView() )	return;
if (!currentEditorView()->editor->hasSelectedText())
   {
    InsertTag("\\mathfrak{} ",10,0);
   }
else
   {
   currentEditorView()->editor->cut();
   InsertTag("\\mathfrak{",10,0);
   currentEditorView()->editor->paste();
   InsertTag("}",1,0);
   }
}
void Texmaker::InsertMath74()
{
InsertTag("\\begin{equation}\n\n\\end{equation} ",0,1);
}
void Texmaker::InsertMath75()
{
InsertTag("\\begin{eqnarray}\n\n\\end{eqnarray} ",0,1);
}
void Texmaker::InsertMath76()
{
InsertTag("\\acute{}",7,0);
}
void Texmaker::InsertMath77()
{
InsertTag("\\grave{}",7,0);
}
void Texmaker::InsertMath78()
{
InsertTag("\\tilde{}",7,0);
}
void Texmaker::InsertMath79()
{
InsertTag("\\bar{}",5,0);
}
void Texmaker::InsertMath80()
{
InsertTag("\\vec{}",5,0);
}
void Texmaker::InsertMath81()
{
InsertTag("\\hat{}",5,0);
}
void Texmaker::InsertMath82()
{
InsertTag("\\check{}",7,0);
}
void Texmaker::InsertMath83()
{
InsertTag("\\breve{}",7,0);
}
void Texmaker::InsertMath84()
{
InsertTag("\\dot{}",5,0);
}
void Texmaker::InsertMath85()
{
InsertTag("\\ddot{}",6,0);
}
void Texmaker::InsertMath86()
{
InsertTag("\\,",2,0);
}
void Texmaker::InsertMath87()
{
InsertTag("\\:",2,0);
}
void Texmaker::InsertMath88()
{
InsertTag("\\;",2,0);
}
void Texmaker::InsertMath89()
{
InsertTag("\\quad",5,0);
}
void Texmaker::InsertMath90()
{
InsertTag("\\qquad",6,0);
}

void Texmaker::LeftDelimiter(const QString& text)
{
if (text=="left (") InsertTag("\\left( ",7,0);
if (text=="left [") InsertTag("\\left[ ",7,0);
if (text=="left {") InsertTag("\\left\\lbrace ",13,0);
if (text=="left <") InsertTag("\\left\\langle ",13,0);
if (text=="left )") InsertTag("\\left) ",7,0);
if (text=="left ]") InsertTag("\\left] ",7,0);
if (text=="left }") InsertTag("\\left\\rbrace ",13,0);
if (text=="left >") InsertTag("\\left\\rangle ",13,0);
if (text=="left.") InsertTag("\\left. ",7,0);
}
void Texmaker::RightDelimiter(const QString& text)
{
if (text=="right (") InsertTag("\\right( ",8,0);
if (text=="right [") InsertTag("\\right[ ",8,0);
if (text=="right {") InsertTag("\\right\\lbrace ",14,0);
if (text=="right <") InsertTag("\\right\\langle ",14,0);
if (text=="right )") InsertTag("\\right) ",8,0);
if (text=="right ]") InsertTag("\\right] ",8,0);
if (text=="right }") InsertTag("\\right\\rbrace ",14,0);
if (text=="right >") InsertTag("\\right\\rangle ",14,0);
if (text=="right.") InsertTag("\\right. ",8,0);
}

void Texmaker::InsertSymbol()
{
QString code_symbol=symbol_view->getSymbolCode();
InsertTag(code_symbol,qstrlen(code_symbol),0);
}

void Texmaker::InsertMetaPost(QListBoxItem *)
{
QString mpcode=mpview->currentText();
if (mpcode!="----------") InsertTag(mpcode,qstrlen(mpcode),0);
}

////////////////////////// BIBLIOGRAPHY //////////////////////////
void Texmaker::InsertBib1()
{
QString tag = QString("@Article{,\n");
tag+="author = {},\n";
tag+="title = {},\n";
tag+="journal = {},\n";
tag+="year = {},\n";
tag+="OPTkey = {},\n";
tag+="OPTvolume = {},\n";
tag+="OPTnumber = {},\n";
tag+="OPTpages = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTnote = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,9,0);
OutputWidget->insertLine("Bib fields - Article in Journal");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
void Texmaker::InsertBib2()
{
QString tag = QString("@InProceedings{,\n");
tag+="author = {},\n";
tag+="title = {},\n";
tag+="booktitle = {},\n";
tag+="OPTcrossref = {},\n";
tag+="OPTkey = {},\n";
tag+="OPTpages = {},\n";
tag+="OPTyear = {},\n";
tag+="OPTeditor = {},\n";
tag+="OPTvolume = {},\n";
tag+="OPTnumber = {},\n";
tag+="OPTseries = {},\n";
tag+="OPTaddress = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTorganization = {},\n";
tag+="OPTpublisher = {},\n";
tag+="OPTnote = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,15,0);
OutputWidget->insertLine("Bib fields - Article in Conference Proceedings");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
void Texmaker::InsertBib3()
{
QString tag = QString("@InCollection{,\n");
tag+="author = {},\n";
tag+="title = {},\n";
tag+="booktitle = {},\n";
tag+="OPTcrossref = {},\n";
tag+="OPTkey = {},\n";
tag+="OPTpages = {},\n";
tag+="OPTpublisher = {},\n";
tag+="OPTyear = {},\n";
tag+="OPTeditor = {},\n";
tag+="OPTvolume = {},\n";
tag+="OPTnumber = {},\n";
tag+="OPTseries = {},\n";
tag+="OPTtype = {},\n";
tag+="OPTchapter = {},\n";
tag+="OPTaddress = {},\n";
tag+="OPTedition = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTnote = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,14,0);
OutputWidget->insertLine("Bib fields - Article in a Collection");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
void Texmaker::InsertBib4()
{
QString tag = QString("@InBook{,\n");
tag+="ALTauthor = {},\n";
tag+="ALTeditor = {},\n";
tag+="title = {},\n";
tag+="chapter = {},\n";
tag+="publisher = {},\n";
tag+="year = {},\n";
tag+="OPTkey = {},\n";
tag+="OPTvolume = {},\n";
tag+="OPTnumber = {},\n";
tag+="OPTseries = {},\n";
tag+="OPTtype = {},\n";
tag+="OPTaddress = {},\n";
tag+="OPTedition = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTpages = {},\n";
tag+="OPTnote = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,8,0);
OutputWidget->insertLine("Bib fields - Chapter or Pages in a Book");
OutputWidget->insertLine( "ALT.... : you have the choice between these two fields");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
void Texmaker::InsertBib5()
{
QString tag = QString("@Proceedings{,\n");
tag+="title = {},\n";
tag+="year = {},\n";
tag+="OPTkey = {},\n";
tag+="OPTeditor = {},\n";
tag+="OPTvolume = {},\n";
tag+="OPTnumber = {},\n";
tag+="OPTseries = {},\n";
tag+="OPTaddress = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTorganization = {},\n";
tag+="OPTpublisher = {},\n";
tag+="OPTnote = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,13,0);
OutputWidget->insertLine("Bib fields - Conference Proceedings");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
void Texmaker::InsertBib6()
{
QString tag = QString("@Book{,\n");
tag+="ALTauthor = {},\n";
tag+="ALTeditor = {},\n";
tag+="title = {},\n";
tag+="publisher = {},\n";
tag+="year = {},\n";
tag+="OPTkey = {},\n";
tag+="OPTvolume = {},\n";
tag+="OPTnumber = {},\n";
tag+="OPTseries = {},\n";
tag+="OPTaddress = {},\n";
tag+="OPTedition = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTnote = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,6,0);
OutputWidget->insertLine("Bib fields - Book");
OutputWidget->insertLine( "ALT.... : you have the choice between these two fields");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
void Texmaker::InsertBib7()
{
QString tag = QString("@Booklet{,\n");
tag+="title = {},\n";
tag+="OPTkey = {},\n";
tag+="OPTauthor = {},\n";
tag+="OPThowpublished = {},\n";
tag+="OPTaddress = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTyear = {},\n";
tag+="OPTnote = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,9,0);
OutputWidget->insertLine("Bib fields - Booklet");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
void Texmaker::InsertBib8()
{
QString tag = QString("@PhdThesis{,\n");
tag+="author = {},\n";
tag+="title = {},\n";
tag+="school = {},\n";
tag+="year = {},\n";
tag+="OPTkey = {},\n";
tag+="OPTtype = {},\n";
tag+="OPTaddress = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTnote = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,11,0);
OutputWidget->insertLine("Bib fields - PhD. Thesis");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
void Texmaker::InsertBib9()
{
QString tag = QString("@MastersThesis{,\n");
tag+="author = {},\n";
tag+="title = {},\n";
tag+="school = {},\n";
tag+="year = {},\n";
tag+="OPTkey = {},\n";
tag+="OPTtype = {},\n";
tag+="OPTaddress = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTnote = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,15,0);
OutputWidget->insertLine("Bib fields - Master's Thesis");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
void Texmaker::InsertBib10()
{
QString tag = QString("@TechReport{,\n");
tag+="author = {},\n";
tag+="title = {},\n";
tag+="institution = {},\n";
tag+="year = {},\n";
tag+="OPTkey = {},\n";
tag+="OPTtype = {},\n";
tag+="OPTnumber = {},\n";
tag+="OPTaddress = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTnote = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,12,0);
OutputWidget->insertLine("Bib fields - Technical Report");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
void Texmaker::InsertBib11()
{
QString tag = QString("@Manual{,\n");
tag+="title = {},\n";
tag+="OPTkey = {},\n";
tag+="OPTauthor = {},\n";
tag+="OPTorganization = {},\n";
tag+="OPTaddress = {},\n";
tag+="OPTedition = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTyear = {},\n";
tag+="OPTnote = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,8,0);
OutputWidget->insertLine("Bib fields - Technical Manual");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
void Texmaker::InsertBib12()
{
QString tag = QString("@Unpublished{,\n");
tag+="author = {},\n";
tag+="title = {},\n";
tag+="note = {},\n";
tag+="OPTkey = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTyear = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,13,0);
OutputWidget->insertLine("Bib fields - Unpublished");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
void Texmaker::InsertBib13()
{
QString tag = QString("@Misc{,\n");
tag+="OPTkey = {},\n";
tag+="OPTauthor = {},\n";
tag+="OPTtitle = {},\n";
tag+="OPThowpublished = {},\n";
tag+="OPTmonth = {},\n";
tag+="OPTyear = {},\n";
tag+="OPTnote = {},\n";
tag+="OPTannote = {}\n";
tag+="}\n";
InsertTag(tag,6,0);
OutputWidget->insertLine("Bib fields - Miscellaneous");
OutputWidget->insertLine( "OPT.... : optionnal fields (use the 'Clean' command to remove them)");
}
//////////////// USER //////////////////
void Texmaker::InsertUserTag1()
{
if (UserMenuTag[0].left(1)=="%")
 {
 QString t=UserMenuTag[0];
 t=t.remove(0,1);
 QString s="\\begin{"+t+"}\n\n\\end{"+t+"}\n";
 InsertTag(s,0,1);
 }
else
 {
 InsertTag(UserMenuTag[0],0,0);
 }
}

void Texmaker::InsertUserTag2()
{
if (UserMenuTag[1].left(1)=="%")
 {
 QString t=UserMenuTag[1];
 t=t.remove(0,1);
 QString s="\\begin{"+t+"}\n\n\\end{"+t+"}\n";
 InsertTag(s,0,1);
 }
else
 {
 InsertTag(UserMenuTag[1],0,0);
 }
}

void Texmaker::InsertUserTag3()
{
if (UserMenuTag[2].left(1)=="%")
 {
 QString t=UserMenuTag[2];
 t=t.remove(0,1);
 QString s="\\begin{"+t+"}\n\n\\end{"+t+"}\n";
 InsertTag(s,0,1);
 }
else
 {
 InsertTag(UserMenuTag[2],0,0);
 }
}

void Texmaker::InsertUserTag4()
{
if (UserMenuTag[3].left(1)=="%")
 {
 QString t=UserMenuTag[3];
 t=t.remove(0,1);
 QString s="\\begin{"+t+"}\n\n\\end{"+t+"}\n";
 InsertTag(s,0,1);
 }
else
 {
 InsertTag(UserMenuTag[3],0,0);
 }
}

void Texmaker::InsertUserTag5()
{
if (UserMenuTag[4].left(1)=="%")
 {
 QString t=UserMenuTag[4];
 t=t.remove(0,1);
 QString s="\\begin{"+t+"}\n\n\\end{"+t+"}\n";
 InsertTag(s,0,1);
 }
else
 {
 InsertTag(UserMenuTag[4],0,0);
 }
}

void Texmaker::InsertUserTag6()
{
if (UserMenuTag[5].left(1)=="%")
 {
 QString t=UserMenuTag[5];
 t=t.remove(0,1);
 QString s="\\begin{"+t+"}\n\n\\end{"+t+"}\n";
 InsertTag(s,0,1);
 }
else
 {
 InsertTag(UserMenuTag[5],0,0);
 }
}

void Texmaker::InsertUserTag7()
{
if (UserMenuTag[6].left(1)=="%")
 {
 QString t=UserMenuTag[6];
 t=t.remove(0,1);
 QString s="\\begin{"+t+"}\n\n\\end{"+t+"}\n";
 InsertTag(s,0,1);
 }
else
 {
 InsertTag(UserMenuTag[6],0,0);
 }
}

void Texmaker::InsertUserTag8()
{
if (UserMenuTag[7].left(1)=="%")
 {
 QString t=UserMenuTag[7];
 t=t.remove(0,1);
 QString s="\\begin{"+t+"}\n\n\\end{"+t+"}\n";
 InsertTag(s,0,1);
 }
else
 {
 InsertTag(UserMenuTag[7],0,0);
 }
}

void Texmaker::InsertUserTag9()
{
if (UserMenuTag[8].left(1)=="%")
 {
 QString t=UserMenuTag[8];
 t=t.remove(0,1);
 QString s="\\begin{"+t+"}\n\n\\end{"+t+"}\n";
 InsertTag(s,0,1);
 }
else
 {
 InsertTag(UserMenuTag[8],0,0);
 }
}

void Texmaker::InsertUserTag10()
{
if (UserMenuTag[9].left(1)=="%")
 {
 QString t=UserMenuTag[9];
 t=t.remove(0,1);
 QString s="\\begin{"+t+"}\n\n\\end{"+t+"}\n";
 InsertTag(s,0,1);
 }
else
 {
 InsertTag(UserMenuTag[9],0,0);
 }
}
//////////////// HELP /////////////////
void Texmaker::LatexHelp()
{
#ifdef Q_WS_X11
QString docfile=PREFIX"/share/texmaker/latexhelp.html";
#endif
#if defined(Q_WS_WIN)
QString docfile=QDir::currentDirPath() + "/latexhelp.html";
#endif
#ifdef Q_WS_MACX
QString docfile=PREFIX"/share/texmaker/latexhelp.html";
#endif
QFileInfo fic(docfile);
    if (fic.exists() && fic.isReadable() )
      {
      if (help_widget)
          {
          help_widget->close();
          }
      help_widget=new HelpWidget(docfile,".", 0, "help viewer");
      help_widget->setIcon(QPixmap::fromMimeSource( "appicon.png"));
      help_widget->setCaption("Texmaker : LaTeX Reference");
      help_widget->raise();
      help_widget->show();
      }
    else { QMessageBox::warning( this,"Error","File not found");}
}

void Texmaker::UserManualHelp()
{
#ifdef Q_WS_X11
QString docfile=PREFIX"/share/texmaker/usermanual.html";
#endif
#if defined(Q_WS_WIN)
QString docfile=QDir::currentDirPath() + "/usermanual.html";
#endif
#ifdef Q_WS_MACX
QString docfile=PREFIX"/share/texmaker/usermanual.html";
#endif
QFileInfo fic(docfile);
    if (fic.exists() && fic.isReadable() )
      {
      if (help_widget)
          {
          help_widget->close();
          }
      help_widget=new HelpWidget(docfile,".", 0, "help viewer");
      help_widget->setIcon(QPixmap::fromMimeSource( "appicon.png"));
      help_widget->setCaption("Texmaker : User Manual");
      help_widget->raise();
      help_widget->show();
      }
    else { QMessageBox::warning( this,"Error","File not found");}
}

void Texmaker::HelpAbout()
{
  QMessageBox::about(this,"About...", "<h3>Texmaker : LaTeX Development Environment</h3>"
  "This program is licensed to you under the terms of the "
  "GNU General Public License Version 2 as published "
  "by the Free Software Foundation. <br>"
  "<br><i>Copyright (c) 2004 by Pascal Brachet</i>" 
  "<br><i>with the contribution of J.Amblard (html conversion)</i>");
}

///////////////////// USER ///////////////
void Texmaker::EditUserMenu()
{
umDlg = new usermenudialog(this,"Edit User Tags");
for ( int i = 0; i <= 9; i++ )
    {
    umDlg->Name[i]=UserMenuName[i];
    umDlg->Tag[i]=UserMenuTag[i];
    umDlg->init();
    }
if ( umDlg->exec() )
 {
for ( int i = 0; i <= 9; i++ )
    {
    UserMenuName[i]=umDlg->Name[i];
    UserMenuTag[i]=umDlg->Tag[i];
    }

  usermenu1->clear();
  usermenu1->insertItem("1: "+UserMenuName[0],this,SLOT(InsertUserTag1()), SHIFT+Key_F1);
usermenu1->insertItem("2: "+UserMenuName[1],this,SLOT(InsertUserTag2()), SHIFT+Key_F2);
usermenu1->insertItem("3: "+UserMenuName[2],this,SLOT(InsertUserTag3()), SHIFT+Key_F3);
usermenu1->insertItem("4: "+UserMenuName[3],this,SLOT(InsertUserTag4()), SHIFT+Key_F4);
usermenu1->insertItem("5: "+UserMenuName[4],this,SLOT(InsertUserTag5()), SHIFT+Key_F5);
usermenu1->insertItem("6: "+UserMenuName[5],this,SLOT(InsertUserTag6()), SHIFT+Key_F6);
usermenu1->insertItem("7: "+UserMenuName[6],this,SLOT(InsertUserTag7()), SHIFT+Key_F7);
usermenu1->insertItem("8: "+UserMenuName[7],this,SLOT(InsertUserTag8()), SHIFT+Key_F8);
usermenu1->insertItem("9: "+UserMenuName[8],this,SLOT(InsertUserTag9()), SHIFT+Key_F9);
usermenu1->insertItem("10: "+UserMenuName[9],this,SLOT(InsertUserTag10()), SHIFT+Key_F10);
usermenu1->insertSeparator();
usermenu1->insertItem("Edit User Tags",this, SLOT(EditUserMenu()));
 }
delete umDlg;
}

void Texmaker::EditUserTool()
{
utDlg = new usertooldialog(this,"Edit User Commands");
for ( int i = 0; i <= 4; i++ )
    {
    utDlg->Name[i]=UserToolName[i];
    utDlg->Tool[i]=UserToolCommand[i];
    utDlg->init();
    }
if ( utDlg->exec() )
 {
for ( int i = 0; i <= 4; i++ )
    {
    UserToolName[i]=utDlg->Name[i];
    UserToolCommand[i]=utDlg->Tool[i];
    }
 usermenu2->clear();
 usermenu2->insertItem("1: "+UserToolName[0],this,SLOT(UserTool1()), SHIFT+ALT+Key_F1);
usermenu2->insertItem("2: "+UserToolName[1],this,SLOT(UserTool2()), SHIFT+ALT+Key_F2);
usermenu2->insertItem("3: "+UserToolName[2],this,SLOT(UserTool3()), SHIFT+ALT+Key_F3);
usermenu2->insertItem("4: "+UserToolName[3],this,SLOT(UserTool4()), SHIFT+ALT+Key_F4);
usermenu2->insertItem("5: "+UserToolName[4],this,SLOT(UserTool5()), SHIFT+ALT+Key_F5);
usermenu2->insertSeparator();
usermenu2->insertItem("Edit User Commands",this, SLOT(EditUserTool()));
 }
delete utDlg;
}

/////////////// CONFIG ////////////////////
void Texmaker::ReadSettings()
{
QSettings config;
config.setPath( "xm1", "texmaker" );
config.beginGroup( "/texmaker" );
singlemode=true;
QRect screen = QApplication::desktop()->screenGeometry();

int w= config.readNumEntry( "/Geometries/MainwindowWidth",screen.width()-100);
int h= config.readNumEntry( "/Geometries/MainwindowHeight",screen.height()-100) ;
resize(w,h);
split1_left=config.readNumEntry("/Geometries/Splitter1_left",100);
split1_right=config.readNumEntry("/Geometries/Splitter1_right",350);
split2_top=config.readNumEntry("/Geometries/Splitter2_top",350);
split2_bottom=config.readNumEntry("/Geometries/Splitter2_bottom",100);


QString fam=config.readEntry("/Editor/Font Family",qApp->font().family());
int si=config.readNumEntry( "/Editor/Font Size",qApp->font().pointSize());
QFont F(fam,si);
EditorFont=F;
wordwrap=config.readBoolEntry( "/Editor/WordWrap",true);
parenmatch=config.readBoolEntry( "/Editor/Parentheses Matching",true);
showline=config.readBoolEntry( "/Editor/Line Numbers",true);

showoutputview=config.readBoolEntry("/Show/Outputview",true);
showstructview=config.readBoolEntry( "/Show/Structureview",true);

quickmode=config.readNumEntry( "/Tools/Quick Mode",1);
latex_command=config.readEntry("/Tools/Latex","latex -interaction=nonstopmode %.tex");
dvips_command=config.readEntry("/Tools/Dvips","dvips -o %.ps %.dvi");
ps2pdf_command=config.readEntry("/Tools/Ps2pdf","ps2pdf %.ps");
makeindex_command=config.readEntry("/Tools/Makeindex","makeindex %.idx");
bibtex_command=config.readEntry("/Tools/Bibtex","bibtex %.aux");
pdflatex_command=config.readEntry("/Tools/Pdflatex","pdflatex -interaction=nonstopmode %.tex");
dvipdf_command=config.readEntry("/Tools/Dvipdf","dvipdfm %.dvi");
metapost_command=config.readEntry("/Tools/Metapost","mpost --interaction nonstopmode ");
userClassList=config.readListEntry("/Tools/User Class");
userPaperList=config.readListEntry("/Tools/User Paper");
userEncodingList=config.readListEntry("/Tools/User Encoding");
userOptionsList=config.readListEntry("/Tools/User Options");
#if defined(Q_WS_WIN)
viewdvi_command=config.readEntry("/Tools/Dvi","C:/TeX/bin/win32/windvi.exe %.dvi");
viewps_command=config.readEntry("/Tools/Ps","C:/gstools/gsview/gsview32.exe %.ps");
viewpdf_command=config.readEntry("/Tools/Pdf","C:/Program Files/Adobe/Acrobat 5.0/Reader/AcroRd32.exe %.pdf");
#endif
#ifdef Q_WS_X11
viewdvi_command=config.readEntry("/Tools/Dvi","xdvi %.dvi");
viewps_command=config.readEntry("/Tools/Ps","gv %.ps");
viewpdf_command=config.readEntry("/Tools/Pdf","xpdf %.pdf");
#endif
#ifdef Q_WS_MACX
viewdvi_command=config.readEntry("/Tools/Dvi","? %.dvi");
viewps_command=config.readEntry("/Tools/Ps","? %.ps");
viewpdf_command=config.readEntry("/Tools/Pdf","/Applications/Preview.app/Contents/MacOS/Preview %.pdf");
#endif

lastDocument=config.readEntry("/Files/Last Document","");
QStringList temp1;
recentFilesList=new QStrList();
temp1=config.readListEntry("/Files/Recent Files");
QStringList::ConstIterator it1 = temp1.begin();
for ( ; it1 != temp1.end(); ++it1 )  recentFilesList->append(*it1);
while (recentFilesList->count()>5) recentFilesList->removeFirst();
input_encoding=config.readEntry("/Files/Input Encoding", QTextCodec::codecForLocale()->name());
UserMenuName[0]=config.readEntry("/User/Menu1","");
UserMenuTag[0]=config.readEntry("/User/Tag1","");
UserMenuName[1]=config.readEntry("/User/Menu2","");
UserMenuTag[1]=config.readEntry("/User/Tag2","");
UserMenuName[2]=config.readEntry("/User/Menu3","");
UserMenuTag[2]=config.readEntry("/User/Tag3","");
UserMenuName[3]=config.readEntry("/User/Menu4","");
UserMenuTag[3]=config.readEntry("/User/Tag4","");
UserMenuName[4]=config.readEntry("/User/Menu5","");
UserMenuTag[4]=config.readEntry("/User/Tag5","");
UserMenuName[5]=config.readEntry("/User/Menu6","");
UserMenuTag[5]=config.readEntry("/User/Tag6","");
UserMenuName[6]=config.readEntry("/User/Menu7","");
UserMenuTag[6]=config.readEntry("/User/Tag7","");
UserMenuName[7]=config.readEntry("/User/Menu8","");
UserMenuTag[7]=config.readEntry("/User/Tag8","");
UserMenuName[8]=config.readEntry("/User/Menu9","");
UserMenuTag[8]=config.readEntry("/User/Tag9","");
UserMenuName[9]=config.readEntry("/User/Menu10","");
UserMenuTag[9]=config.readEntry("/User/Tag10","");
UserToolName[0]=config.readEntry("/User/ToolName1","");
UserToolCommand[0]=config.readEntry("/User/Tool1","");
UserToolName[1]=config.readEntry("/User/ToolName2","");
UserToolCommand[1]=config.readEntry("/User/Tool2","");
UserToolName[2]=config.readEntry("/User/ToolName3","");
UserToolCommand[2]=config.readEntry("/User/Tool3","");
UserToolName[3]=config.readEntry("/User/ToolName4","");
UserToolCommand[3]=config.readEntry("/User/Tool4","");
UserToolName[4]=config.readEntry("/User/ToolName5","");
UserToolCommand[4]=config.readEntry("/User/Tool5","");

struct_level1=config.readEntry("/Structure/Structure Level 1","part");
struct_level2=config.readEntry("/Structure/Structure Level 2","chapter");
struct_level3=config.readEntry("/Structure/Structure Level 3","section");
struct_level4=config.readEntry("/Structure/Structure Level 4","subsection");
struct_level5=config.readEntry("/Structure/Structure Level 5","subsubsection");


document_class=config.readEntry("/Quick/Class","article");
typeface_size=config.readEntry("/Quick/Typeface","10pt");
paper_size=config.readEntry("/Quick/Papersize","a4paper");
document_encoding=config.readEntry("/Quick/Encoding","latin1");
ams_packages=config.readBoolEntry( "/Quick/AMS",true);
makeidx_package=config.readBoolEntry( "/Quick/MakeIndex",false);
author=config.readEntry("/Quick/Author","");

config.endGroup();
}

void Texmaker::SaveSettings()
{
QSettings config;
config.setPath( "xm1", "texmaker" );
config.beginGroup( "/texmaker" );
QValueList<int> sizes;
QValueList<int>::Iterator it;

config.writeEntry("/Geometries/MainwindowWidth", width() );
config.writeEntry("/Geometries/MainwindowHeight", height() );
sizes=splitter1->sizes();
it = sizes.begin();
split1_left=*it;
++it;
split1_right=*it;
sizes.clear();
sizes=splitter2->sizes();
it = sizes.begin();
split2_top=*it;
++it;
split2_bottom=*it;
config.writeEntry("/Geometries/Splitter1_left", split1_left );
config.writeEntry("/Geometries/Splitter1_right", split1_right );
config.writeEntry("/Geometries/Splitter2_top", split2_top );
config.writeEntry("/Geometries/Splitter2_bottom", split2_bottom );

config.writeEntry("/Editor/Font Family",EditorFont.family());
config.writeEntry( "/Editor/Font Size",EditorFont.pointSize());
config.writeEntry( "/Editor/WordWrap",wordwrap);
config.writeEntry( "/Editor/Parentheses Matching",parenmatch);
config.writeEntry( "/Editor/Line Numbers",showline);

config.writeEntry("/Show/Outputview",showoutputview);
config.writeEntry( "/Show/Structureview",showstructview);

config.writeEntry("/Tools/Quick Mode",quickmode);
config.writeEntry("/Tools/Latex",latex_command);
config.writeEntry("/Tools/Dvi",viewdvi_command);
config.writeEntry("/Tools/Dvips",dvips_command);
config.writeEntry("/Tools/Ps",viewps_command);
config.writeEntry("/Tools/Ps2pdf",ps2pdf_command);
config.writeEntry("/Tools/Makeindex",makeindex_command);
config.writeEntry("/Tools/Bibtex",bibtex_command);
config.writeEntry("/Tools/Pdflatex",pdflatex_command);
config.writeEntry("/Tools/Pdf",viewpdf_command);
config.writeEntry("/Tools/Dvipdf",dvipdf_command);
config.writeEntry("/Tools/Metapost",metapost_command);
config.writeEntry("/Tools/User Class",userClassList);
config.writeEntry("/Tools/User Paper",userPaperList);
config.writeEntry("/Tools/User Encoding",userEncodingList);
config.writeEntry("/Tools/User Options",userOptionsList);


config.writeEntry("/Files/Last Document",lastDocument);
QStringList temp1;
for (uint i=0; i<recentFilesList->count(); i++) temp1.append(recentFilesList->at(i));
config.writeEntry("/Files/Recent Files",temp1);

config.writeEntry("/Files/Input Encoding", input_encoding);

config.writeEntry("/User/Menu1",UserMenuName[0]);
config.writeEntry("/User/Tag1",UserMenuTag[0]);
config.writeEntry("/User/Menu2",UserMenuName[1]);
config.writeEntry("/User/Tag2",UserMenuTag[1]);
config.writeEntry("/User/Menu3",UserMenuName[2]);
config.writeEntry("/User/Tag3",UserMenuTag[2]);
config.writeEntry("/User/Menu4",UserMenuName[3]);
config.writeEntry("/User/Tag4",UserMenuTag[3]);
config.writeEntry("/User/Menu5",UserMenuName[4]);
config.writeEntry("/User/Tag5",UserMenuTag[4]);
config.writeEntry("/User/Menu6",UserMenuName[5]);
config.writeEntry("/User/Tag6",UserMenuTag[5]);
config.writeEntry("/User/Menu7",UserMenuName[6]);
config.writeEntry("/User/Tag7",UserMenuTag[6]);
config.writeEntry("/User/Menu8",UserMenuName[7]);
config.writeEntry("/User/Tag8",UserMenuTag[7]);
config.writeEntry("/User/Menu9",UserMenuName[8]);
config.writeEntry("/User/Tag9",UserMenuTag[8]);
config.writeEntry("/User/Menu10",UserMenuName[9]);
config.writeEntry("/User/Tag10",UserMenuTag[9]);
config.writeEntry("/User/ToolName1",UserToolName[0]);
config.writeEntry("/User/Tool1",UserToolCommand[0]);
config.writeEntry("/User/ToolName2",UserToolName[1]);
config.writeEntry("/User/Tool2",UserToolCommand[1]);
config.writeEntry("/User/ToolName3",UserToolName[2]);
config.writeEntry("/User/Tool3",UserToolCommand[2]);
config.writeEntry("/User/ToolName4",UserToolName[3]);
config.writeEntry("/User/Tool4",UserToolCommand[3]);
config.writeEntry("/User/ToolName5",UserToolName[4]);
config.writeEntry("/User/Tool5",UserToolCommand[4]);

config.writeEntry("/Structure/Structure Level 1",struct_level1);
config.writeEntry("/Structure/Structure Level 2",struct_level2);
config.writeEntry("/Structure/Structure Level 3",struct_level3);
config.writeEntry("/Structure/Structure Level 4",struct_level4);
config.writeEntry("/Structure/Structure Level 5",struct_level5);

config.writeEntry( "/Quick/Class",document_class);
config.writeEntry( "/Quick/Typeface",typeface_size);
config.writeEntry( "/Quick/Papersize",paper_size);
config.writeEntry( "/Quick/Encoding",document_encoding);
config.writeEntry( "/Quick/AMS",ams_packages);
config.writeEntry( "/Quick/MakeIndex",makeidx_package);
config.writeEntry( "/Quick/Author",author);

config.endGroup();
}

/////////////////  OPTIONS ////////////////////
void Texmaker::ToggleMode()
{
if (!singlemode)
     {
     options->changeItem(ID_MODE,"Define Current Document as 'Master Document'");
     OutputWidget->clear();
     Outputview->showPage(OutputWidget);
     logpresent=false;
     singlemode=true;
     stat2->setText("Normal Mode");
     return;
     }
if (singlemode && currentEditorView())  {
      MasterName=getName();
      if (MasterName=="untitled" || MasterName=="")
       {
       QMessageBox::warning( this,"Error","Could not start the command.");
       return;
       }
      QString shortName = MasterName;
      int pos;
      while ( (pos = (int)shortName.find('/')) != -1 )
      shortName.remove(0,pos+1);
      options->changeItem(ID_MODE,"Normal Mode (current master document :"+shortName+")");
      singlemode=false;
      stat2->setText("Master Document :"+shortName);
      return;
      }
}

void Texmaker::ToggleOutputView()
{
ShowOutputView(true);
}

void Texmaker::ToggleStructView()
{
ShowStructView(true);
}

void Texmaker::ShowOutputView(bool change)
{
if (change) showoutputview=!showoutputview;
if (showoutputview)
    {
    view->setItemChecked(ID_VIEW_OUTPUTVIEW,true);
    Outputview->show();
    }
else
   {
   view->setItemChecked(ID_VIEW_OUTPUTVIEW,false);
   Outputview->hide();
   }
}

void Texmaker::ShowStructView(bool change)
{
if (change) showstructview=!showstructview;
if (showstructview)
   {
   view->setItemChecked(ID_VIEW_STRUCTVIEW,true);
   Structview->show();
   }
else
   {
   view->setItemChecked(ID_VIEW_STRUCTVIEW,false);
   Structview->hide();
   }
}

void Texmaker::GeneralOptions()
{
toDlg = new toolsoptionsdialog(this,"Configure Texmaker");
toDlg->lineEditLatex->setText(latex_command);
toDlg->lineEditPdflatex->setText(pdflatex_command);
toDlg->lineEditDvips->setText(dvips_command);
toDlg->lineEditDviviewer->setText(viewdvi_command);
toDlg->lineEditPsviewer->setText(viewps_command);
toDlg->lineEditDvipdfm->setText(dvipdf_command);
toDlg->lineEditPs2pdf->setText(ps2pdf_command);
toDlg->lineEditBibtex->setText(bibtex_command);
toDlg->lineEditMakeindex->setText(makeindex_command);
toDlg->lineEditPdfviewer->setText(viewpdf_command);
toDlg->lineEditMetapost->setText(metapost_command);

 toDlg->comboBoxFont->lineEdit()->setText(EditorFont.family() );
 toDlg->comboBoxEncoding->setCurrentText(input_encoding);
 toDlg->spinBoxSize->setValue(EditorFont.pointSize() );
if (quickmode==1) {toDlg->checkBox1->setChecked(true);}
if (quickmode==2) {toDlg->checkBox2->setChecked(true);}
if (quickmode==3) {toDlg->checkBox3->setChecked(true);}
if (quickmode==4)  {toDlg->checkBox4->setChecked(true);}
if (quickmode==5)  {toDlg->checkBox5->setChecked(true);}
if (wordwrap) {toDlg->checkBoxWordwrap->setChecked(true);}
else {toDlg->checkBoxWordwrap->setChecked(false);}
if (showline) {toDlg->checkBoxLinenumber->setChecked(true);}
else {toDlg->checkBoxLinenumber->setChecked(false);}
if (toDlg->exec())
  {
   if (toDlg->checkBox1->isChecked()) quickmode=1;
   if (toDlg->checkBox2->isChecked()) quickmode=2;
   if (toDlg->checkBox3->isChecked()) quickmode=3;
   if (toDlg->checkBox4->isChecked()) quickmode=4;
   if (toDlg->checkBox5->isChecked()) quickmode=5;
   latex_command=toDlg->lineEditLatex->text();
   pdflatex_command=toDlg->lineEditPdflatex->text();
   dvips_command=toDlg->lineEditDvips->text();
   viewdvi_command=toDlg->lineEditDviviewer->text();
   viewps_command=toDlg->lineEditPsviewer->text();
   dvipdf_command=toDlg->lineEditDvipdfm->text();
   ps2pdf_command=toDlg->lineEditPs2pdf->text();
   bibtex_command=toDlg->lineEditBibtex->text();
   makeindex_command=toDlg->lineEditMakeindex->text();
   viewpdf_command=toDlg->lineEditPdfviewer->text();
   metapost_command=toDlg->lineEditMetapost->text();

   QString fam=toDlg->comboBoxFont->lineEdit()->text();
   int si=toDlg->spinBoxSize->value();
   QFont F(fam,si);
   EditorFont=F;
   
   input_encoding=toDlg->comboBoxEncoding->currentText();
   
   wordwrap=toDlg->checkBoxWordwrap->isChecked();
   showline=toDlg->checkBoxLinenumber->isChecked();
   if (currentEditorView())
  {
   LatexEditorView *temp = new LatexEditorView( tabWidget,"",EditorFont,showline);
   temp=currentEditorView();
   FilesMap::Iterator it;
   for( it = filenames.begin(); it != filenames.end(); ++it )
      {
        tabWidget->showPage( it.key() );
        bool  MODIFIED =currentEditorView()->editor->isModified();
        QString tmp =currentEditorView()->editor->text();
        if (wordwrap) {currentEditorView()->editor->setWordWrap(LatexEditor::WidgetWidth);}
        else {currentEditorView()->editor->setWordWrap(LatexEditor::NoWrap);}
        currentEditorView()->changeSettings(EditorFont,showline);
        currentEditorView()->editor->clear();
        currentEditorView()->editor->setText( tmp );
        if( MODIFIED ) currentEditorView()->editor->setModified(TRUE );
        else currentEditorView()->editor->setModified( FALSE );
      }
   tabWidget->showPage(temp);
   UpdateCaption();
   UpdateLineColStatus();
   }
  }
delete toDlg;
}
////////////// VERTICAL TAB /////////////////
void Texmaker::showVertPage(int page)
{
ButtonBar->setTab(lastvtab,false);
ButtonBar->setTab(page,true);
lastvtab=page;
if (page==0)
   {
   UpdateStructure();
   mpview->hide();
   if (symbol_view && symbol_present) delete symbol_view;
   symbol_present=false;
   if (Structview_layout) delete Structview_layout;
   Structview_layout=new QHBoxLayout(Structview);
   Structview_layout->add(outstruct);
   Structview_layout->add(ButtonBar);
   ButtonBar->setPosition(KMultiVertTabBar::Right);
   outstruct->show();
   }
else if (page==6)
   {
   outstruct->hide();
   if (symbol_view && symbol_present) delete symbol_view;
   symbol_present=false;
   if (Structview_layout) delete Structview_layout;
   Structview_layout=new QHBoxLayout(Structview);
   Structview_layout->add(mpview);
   Structview_layout->add(ButtonBar);
   ButtonBar->setPosition(KMultiVertTabBar::Right);
   mpview->show();
   }
else
   {
      outstruct->hide();
      mpview->hide();
      if (symbol_view && symbol_present) delete symbol_view;
      if (Structview_layout) delete Structview_layout;
      Structview_layout=new QHBoxLayout(Structview);
      symbol_view = new SymbolView(page,Structview,"Symbols");
      connect(symbol_view, SIGNAL(SymbolSelected()), SLOT(InsertSymbol()));
      symbol_present=true;
      Structview_layout->add(symbol_view);
      Structview_layout->add(ButtonBar);
      ButtonBar->setPosition(KMultiVertTabBar::Right);
      symbol_view->show();
   }
}

// void Texmaker::changeInputEncoding()
// {
// if (currentEditorView())
//   {
//    QTextCodec* codec1 = QTextCodec::codecForName(currentEditorView()->editor->getEncoding());
//    if(!codec1) codec1 = QTextCodec::codecForLocale();
//    QString tmp =currentEditorView()->editor->text();
//    QString unicodetmp=codec1->toUnicode(tmp);
//    QTextCodec* codec2 = QTextCodec::codecForName(input_encoding);
//    if(!codec2) codec2 = QTextCodec::codecForLocale();
//    QString newtmp= codec2->fromUnicode( unicodetmp );
//    currentEditorView()->editor->clear();
//    currentEditorView()->editor->setText( newtmp );
//    currentEditorView()->editor->setModified(TRUE );
//    currentEditorView()->editor->setEncoding(input_encoding);
//   }
// }

////////////////// EPS SIZE ///////////////////
QString Texmaker::DetectEpsSize(const QString &epsfile)
{
int tagStart;
float  el, et, er, eb, w1, h1, w2, h2;
QString win, hin, wcm, hcm;
QString l="0";
QString t="0";
QString r="0";
QString b="0";
bool ok;
QFileInfo fic(epsfile);
if (fic.exists() && fic.isReadable() )
  {
  QFile f( epsfile );
  if ( !f.open( IO_ReadOnly ) )
  {
  return "";
  }
  QTextStream text(&f);
    while ( !text.eof() )
    {
    QString line = text.readLine();
    tagStart=0;
    tagStart=line.find("%%BoundingBox: ",0);
    if (tagStart!=-1)
       {
       line=line.right(qstrlen(line)-15);
       /// l ///
       tagStart=line.find(" ",0);
       if (tagStart!=-1)
           {
           l=line.left(tagStart);
           line=line.right(qstrlen(line)-tagStart-1);
           }
       /// t ///
       tagStart=line.find(" ",0);
       if (tagStart!=-1)
           {
           t=line.left(tagStart);
           line=line.right(qstrlen(line)-tagStart-1);
           }
       /// r ///
       tagStart=line.find(" ",0);
       if (tagStart!=-1)
           {
           r=line.left(tagStart);
           line=line.right(qstrlen(line)-tagStart-1);
           }
       /// b ///
       b=line;
       break;
       }
    }
 f.close();
 }
el = l.toFloat( &ok );
if (!ok) return "";
et = t.toFloat( &ok);
if (!ok) return "";
er = r.toFloat( &ok);
if (!ok) return "";
eb = b.toFloat( &ok);
if (!ok) return "";
if ((er-el>0) && (eb-et>0))
   {
     w1= (float) ((er-el)/72.27);
     h1= (float) ((eb-et)/72.27);
     w2= (float) (w1*2.54);
     h2= (float) (h1*2.54);
     win=win.setNum(w1,'f',2);
     hin=hin.setNum(h1,'f',2);
     wcm=wcm.setNum(w2,'f',2);
     hcm=hcm.setNum(h2,'f',2);
     return "Original size : [width="+win+"in,height="+hin+"in] or [width="+wcm+"cm,height="+hcm+"cm]";
    }
else return "";
}

//////////////////// CLEAN BIB /////////////////////
void Texmaker::CleanBib()
{
QString s;
if ( !currentEditorView() )	return;
int i=0;
while(i < currentEditorView()->editor->paragraphs())
   {
    s = currentEditorView()->editor->text(i);
    s=s.left(3);
    if (s=="OPT" || s=="ALT")
        {
        currentEditorView()->editor->removeParagraph (i );
        currentEditorView()->editor->setModified(true);
        }
    else i++;
   }
}
