/***************************************************************************
 *   copyright            : (C) 2003 by Pascal Brachet                     *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "syntaxlog.h"
#include <qcolor.h>
#include <qregexp.h>

SyntaxLog::SyntaxLog(QTextEdit * textEdit) : QSyntaxHighlighter(textEdit)
{
	ColorStandard = QColor(0x00, 0x00, 0x00);
	ColorFile = QColor(0x00,0x80, 0x00);
	ColorError=QColor(0xFF, 0x00, 0x00);
	ColorWarning=QColor(0x00, 0x00, 0xCC);
};



int SyntaxLog::highlightParagraph(const QString & text, int endStateOfLastPara)
{
if (text.find("!",0)!=-1) 
	{
	setFormat(0, text.length(),ColorError);
	}
else if (text.find("LaTeX Warning",0)!=-1) 
	{
	setFormat(0, text.length(),ColorWarning);
	}
else if (text.find(".tex",0)!=-1) 
	{
	setFormat(0, text.length(),ColorFile);
	}
return 0;
};


