/***************************************************************************
 *   copyright            : (C) 2003 by Pascal Brachet                     *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __linenumberwidget_h
#define __linenumberwidget_h

#include <qwidget.h>
#include <qpixmap.h>
#include <qfont.h>
#include "latexeditor.h"


class LineNumberWidget: public QWidget
{
    Q_OBJECT
public:
    LineNumberWidget(LatexEditor*, QWidget* =0, const char* =0);
    virtual ~LineNumberWidget();

public slots:
    void doRepaint() { repaint( FALSE ); }
    void setFont(QFont efont);

protected:
    virtual void resizeEvent( QResizeEvent* );
    virtual void paintEvent( QPaintEvent* );

private:
    LatexEditor* m_editor;
    QFont numfont;
    QPixmap buffer;
};

#endif // __linenumberwidget_h
