/***************************************************************************
 *   copyright            : (C) 2003 by Pascal Brachet                     *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "linenumberwidget.h"

#include <private/qrichtext_p.h>

LineNumberWidget::LineNumberWidget(LatexEditor* editor, QWidget* parent, const char* name)
	: QWidget( parent, name, WRepaintNoErase | WStaticContents | WResizeNoErase ) ,
	  m_editor( editor )
{
	connect( m_editor->verticalScrollBar(), SIGNAL( valueChanged( int ) ),
			 this, SLOT( doRepaint() ) );
	connect( m_editor, SIGNAL( textChanged() ),
			 this, SLOT( doRepaint() ) );
        doRepaint();
}

LineNumberWidget::~LineNumberWidget()
{
}

void LineNumberWidget::paintEvent( QPaintEvent* /*e*/ )
{
	buffer.fill();

	QTextParagraph *p = m_editor->document()->firstParagraph();
	QPainter painter( &buffer );
	int yOffset = m_editor->contentsY();
	while ( p ) {
		if ( !p->isVisible() ) {
			p = p->next();
			continue;
		}
		if ( p->rect().y() + p->rect().height() - yOffset < 0 ) {
			p = p->next();
			continue;
		}
		if ( p->rect().y() - yOffset > height() )
			break;
    painter.setFont(numfont);
		painter.drawText( 0, p->rect().y() - yOffset,
				  buffer.width() - 10, p->rect().height(),
				  AlignRight | AlignTop,
				  QString::number(p->paragId()+1) );
		p = p->next();
	}

	painter.end();
	bitBlt( this, 0, 0, &buffer );
}

void LineNumberWidget::resizeEvent( QResizeEvent *e )
{
	buffer.resize( e->size() );
	QWidget::resizeEvent( e );
}

void LineNumberWidget::setFont(QFont efont)
{
numfont=efont;
}  
