/***************************************************************************
 *   copyright            : (C) 2003 by Pascal Brachet                     *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LATEXEDITOR_H
#define LATEXEDITOR_H

#include <qwidget.h>
#include <qtextedit.h>
#include <qstring.h>
#include <qcolor.h>
#include <private/qrichtext_p.h>
#include "syntaxlatex.h"

class LatexEditor : public QTextEdit  {
   Q_OBJECT
public:
LatexEditor(QWidget *parent, const char *name, QFont & efont);
~LatexEditor();
   void gotoLine( int line );
   bool search( const QString &expr, bool cs, bool wo, bool forward, bool startAtCursor );
   void replace( const QString &r);
  void commentSelection();
  void uncommentSelection();
  void indentSelection();
  void changeFont(QFont & new_font);
  QString getEncoding();
  void setEncoding(QString enc);
  QTextDocument *document() const { return QTextEdit::document(); }
  
private:
  QString encoding;
  SyntaxLatex *sy;

};

#endif
