/***************************************************************************
 *   copyright            : (C) 2003 by Pascal Brachet                     *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "latexeditor.h"
#include "syntaxlatex.h"
#include <qpopupmenu.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qaccel.h>

LatexEditor::LatexEditor(QWidget *parent, const char *name,QFont & efont) : QTextEdit(parent,name)
{
    encoding="";  
    setPaletteBackgroundColor(QColor(0xFF, 0xFF, 0xFF));
    setPaletteForegroundColor(QColor(0x00, 0x00, 0x00));
    viewport()->setBackgroundMode(PaletteBackground);

    sy=new SyntaxLatex(this,efont);
    setTextFormat(Qt::PlainText);
    setVScrollBarMode( QScrollView::AlwaysOn );
}
LatexEditor::~LatexEditor(){

}

bool LatexEditor::search( const QString &expr, bool cs, bool wo, bool forward, bool startAtCursor )
{
    if ( startAtCursor )
	return find( expr, cs, wo, forward );
    int dummy = 0;
    return find( expr, cs, wo, forward, &dummy, &dummy );
}

void LatexEditor::replace( const QString &r)
{
removeSelectedText();
insert( r, FALSE, FALSE );
}

void LatexEditor::gotoLine( int line )
{
setCursorPosition( line, 0 );
ensureCursorVisible();
}

void LatexEditor::commentSelection()
{
    QTextParagraph *start = document()->selectionStartCursor( QTextDocument::Standard ).paragraph();
    QTextParagraph *end = document()->selectionEndCursor( QTextDocument::Standard ).paragraph();
    if ( !start || !end )
	start = end = textCursor()->paragraph();
    while ( start ) {
	if ( start == end && textCursor()->index() == 0 )
	    break;
	start->insert( 0, "%" );
	if ( start == end )
	    break;
	start = start->next();
    }
    document()->removeSelection( QTextDocument::Standard );
    repaintChanged();
    setModified( TRUE );
}

void LatexEditor::indentSelection()
{
    QTextParagraph *start = document()->selectionStartCursor( QTextDocument::Standard ).paragraph();
    QTextParagraph *end = document()->selectionEndCursor( QTextDocument::Standard ).paragraph();
    if ( !start || !end )
	start = end = textCursor()->paragraph();
    while ( start ) {
	if ( start == end && textCursor()->index() == 0 )
	    break;
	start->insert( 0, "\t" );
	if ( start == end )
	    break;
	start = start->next();
    }
    document()->removeSelection( QTextDocument::Standard );
    repaintChanged();
    setModified( TRUE );
}

void LatexEditor::uncommentSelection()
{
    QTextParagraph *start = document()->selectionStartCursor( QTextDocument::Standard ).paragraph();
    QTextParagraph *end = document()->selectionEndCursor( QTextDocument::Standard ).paragraph();
    if ( !start || !end )
	start = end = textCursor()->paragraph();
    while ( start ) {
	if ( start == end && textCursor()->index() == 0 )
	    break;
	while ( start->at( 0 )->c == '%' )
	    start->remove( 0, 1 );
	if ( start == end )
	    break;
	start = start->next();
    }
    document()->removeSelection( QTextDocument::Standard );
    repaintChanged();
    setModified( TRUE );
}

void LatexEditor::changeFont(QFont & new_font)
{
sy->setFont(new_font);
viewport()->repaint( FALSE );
}

QString LatexEditor::getEncoding()
{
 return encoding;
}

void LatexEditor::setEncoding(QString enc)
{
 encoding=enc;
}  

