/***************************************************************************
 *   copyright            : (C) 2003 by Pascal Brachet                     *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILECHOOSER_H
#define FILECHOOSER_H

#include <qdialog.h>

class QLineEdit;
class QPushButton;

class FileChooser : public QDialog
{
    Q_OBJECT

 public:
    FileChooser( QWidget *parent = 0, const char *name = 0);

    QString fileName() const;
    QString filter,dir;

public slots:
    void setDir( const QString &di );
    void setFilter( const QString &fil );

signals:
    void fileNameChanged( const QString & );

private slots:
    void chooseFile();

private:
    QLineEdit *lineEdit;
    QPushButton *button;
	  QPushButton *buttonOk;
	  QPushButton *buttonCancel;
};

#endif
