/***************************************************************************
 *   copyright            : (C) 2003 by Pascal Brachet                     *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "arraydialog.h"

arraydialog::arraydialog(QWidget *parent, const char *name)
    :QDialog( parent,name, true)
{
	setCaption(name);

  QGridLayout *gbox = new QGridLayout( this, 6, 2,5,5,"");
  gbox->addRowSpacing( 0, fontMetrics().lineSpacing() );
  gbox->addColSpacing( 0, fontMetrics().lineSpacing() );

  Table1 = new QTable( this, "Table1" );
  Table1->setNumRows( 2 );
  Table1->setNumCols( 2 );

  spinBoxRows= new QSpinBox(this,"NoName");
  spinBoxRows->setValue(2);
  spinBoxRows->setRange(1,99);
  connect( spinBoxRows, SIGNAL(valueChanged(int)),this, SLOT(NewRows(int)));

  spinBoxCollums= new QSpinBox(this,"NoName");
  spinBoxCollums->setValue(2);
  spinBoxCollums->setRange(1,99);
  connect( spinBoxCollums, SIGNAL(valueChanged(int)),this, SLOT(NewCollums(int)));

  QLabel_1= new QLabel(this,"NoName");
  QLabel_1->setText("Num of Rows");

  QLabel_2= new QLabel(this,"NoName");
  QLabel_2->setText("Num of Columns");

  QLabel_3= new QLabel(this,"NoName");
  QLabel_3->setText("Columns Alignment");

  combo = new QComboBox( FALSE, this, "comboBox" );
  combo->insertItem("Center");
  combo->insertItem("Left");
  combo->insertItem("Right");

  QLabel_4= new QLabel(this,"NoName");
  QLabel_4->setText("Environment");

  combo2 = new QComboBox( FALSE, this, "comboBox2" );
  combo2->insertItem("array");
  combo2->insertItem("matrix");
  combo2->insertItem("pmatrix");
  combo2->insertItem("bmatrix");
  combo2->insertItem("vmatrix");
  combo2->insertItem("Vmatrix");  

  buttonOk= new QPushButton(this,"NoName");
  buttonOk->setMinimumSize(0,0);
  buttonOk->setText("Ok");
  buttonOk->setDefault(true);

  buttonCancel= new QPushButton(this,"NoName");
  buttonCancel->setMinimumSize(0,0);
  buttonCancel->setText("Cancel");

	connect( buttonOk, SIGNAL(clicked()), SLOT(accept()) );
	connect( buttonCancel, SIGNAL(clicked()), SLOT(reject()) );

  gbox->addMultiCellWidget(Table1,0,0,0,1,0);
  gbox->addWidget(QLabel_1 , 1, 0 );
  gbox->addWidget(spinBoxRows , 1, 1 );
  gbox->addWidget(QLabel_2 , 2, 0 );
  gbox->addWidget(spinBoxCollums , 2, 1 );
  gbox->addWidget(QLabel_3 , 3, 0 );
  gbox->addWidget(combo , 3, 1 );
  gbox->addWidget(QLabel_4 , 4, 0 );
  gbox->addWidget(combo2 , 4, 1 );
  gbox->addWidget(buttonOk , 5, 0,Qt::AlignLeft );
  gbox->addWidget(buttonCancel , 5, 1,Qt::AlignRight );
  this->resize(460,320);
}

arraydialog::~arraydialog(){
}
void arraydialog::NewRows(int num)
{
  Table1->setNumRows( num );
}
void arraydialog::NewCollums(int num)
{
  Table1->setNumCols( num );
}

