/***************************************************************************
 *   copyright            : (C) 2003 by Pascal Brachet                     *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "addoptiondialog.h"
#include <qlayout.h>

AddOptionDialog::AddOptionDialog(QWidget *parent, const char *name)
    : QDialog( parent, name,true )
{
   setCaption(name);
   QGridLayout *gbox = new QGridLayout( this, 2, 2,5,5,"" );
   gbox->addRowSpacing( 0, fontMetrics().lineSpacing() );

   lineEdit = new QLineEdit( this, "" );
   lineEdit->setText("");
   lineEdit->setFixedWidth(250);
   gbox->addMultiCellWidget( lineEdit,0,0,0,1,1 );

   buttonOk= new QPushButton(this,"NoName");
   buttonOk->setMinimumSize(0,0);
   buttonOk->setText("Ok");
   buttonOk->setDefault(true);

   buttonCancel= new QPushButton(this,"NoName");
   buttonCancel->setMinimumSize(0,0);
   buttonCancel->setText("Cancel");

   connect( buttonOk, SIGNAL(clicked()), SLOT(accept()) );
   connect( buttonCancel, SIGNAL(clicked()), SLOT(reject()) );

   gbox->addWidget(buttonOk , 1, 0,Qt::AlignLeft );
   gbox->addWidget(buttonCancel , 1, 1,Qt::AlignRight);

   setFocusProxy( lineEdit );

}
AddOptionDialog::~AddOptionDialog()
{
}

