#!/usr/bin/perl -w

push @ARGV, "";

if($ARGV[0] eq "--help")
{
print STDERR <<EOT;
usage:	bdftopsf [+u|-u] [+o|-o OUTPUT] [--] [INPUT [TABLE...]]

+h	PSF mode - write a PSF header. This is the default.
  +u	Write an unicode table. Default for 512 character
	fonts.
  -u	Don't write an unicode table. Default for 256
	character fonts.

-h	RAW mode - write no PSF header (and no unicode table,
	of course).
  +r	Reject 512 character fonts. This is the default. Most
	(if not all) UNIX systems won't handle these properly.
  -r	Allow 512 character fonts.

+o	Output to INPUT.psf or INPUT.raw (replacing the .bdf in
	INPUT if any).
-o NAME	Output to NAME.

--	Terminate the option list.

INPUT	A 256 or 512 (PSF only) character BDF file with width 8
	and height between 1 and 255.

TABLE	A duplicate unicodes table. Each line must either be
	blank on contain two 4-digit hexadecimal unicodes. PSF
	with unicode data only.

If no output is specified, the standard output is used.

Any options not specified in the above order are treated as
non-option arguments.

Warning: this program is not compatible with bdf2psf.pl!
EOT
	exit 0;
}

if($ARGV[0] eq "--version")
{
print STDERR <<EOT;
bdftopsf.pl 0.0.6, Copyright (C) 2003 Dimitar Zhekov

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

This program is not based on bdf2psf.pl or any other program.

Report bugs to jimmy\@is-vn.bg
EOT
	exit 0;
}

if($ARGV[0] eq "-h")
{
	$header = 0;
	$suffix = ".raw";
	$unicode = 0;
	shift @ARGV;

	if($ARGV[0] eq "-r")
	{
		$reject = 0;
		shift @ARGV;
	}
	else
	{
		$reject = 1;
		if($ARGV[0] eq "+r") { shift @ARGV; }
	}
}
else
{
	$header = 1;
	$suffix = ".psf";
	$reject = 0;
	if($ARGV[0] eq "+h") { shift @ARGV; }

	if($ARGV[0] eq "+u")
	{
		$unicode = 2;
		shift @ARGV;
	}
	elsif($ARGV[0] eq "-u")
	{
		$unicode = 0;
		shift @ARGV;
	}
}

if($ARGV[0] eq "+o")
{
	$output = "";
	shift @ARGV;
}
elsif($ARGV[0] eq "-o")
{
	shift @ARGV;

	$ARGV[0] ne "" || die("$0: -o requires a non-empty argument\n");
	$output = $ARGV[0];
	shift @ARGV;
}

if($ARGV[0] eq "--") { shift @ARGV; }
pop @ARGV;

if($#ARGV < 0) { $ARGV[0] = "-"; }

open(BDF, "<$ARGV[0]") || die("$0: $ARGV[0]: $!\n");

while(<BDF>)
{
	if(/^FONTBOUNDINGBOX\s([0-9]+)\s([0-9]+).*$/)
	{
		$width = $1;
		$height = $2;
	}
	elsif(/^CHARS\s([0-9]+)$/)
	{
		$chars = $1;
		last;
	}
}

$width == 8 || die("$0: $ARGV[0]: invalid font width $width\n");
($height > 0 && $height < 256) || die("$0: $ARGV[0]: invalid font height $height\n");
$chars == 256 || ($chars == 512 && $reject == 0) || die("$0: $ARGV[0]: invalid CHARS $chars\n");
if(!defined($unicode)) { $unicode = $chars == 256 ? 0 : 2; }

if(!defined($output)) { $output = "-"; }
elsif($output eq "") { if($ARGV[0] =~ /^(.*).bdf$/) { $output = "$1$suffix" ; } else { $output = "$ARGV[0]$suffix"; } }

open(OUT, ">$output") || die("$0: $output: $!\n");
binmode(OUT) || die("$0: $output: $!\n");
if($header) { printf OUT "%c%c%c%c", 0x36, 0x04, ($chars == 512) + $unicode, $height; }

$bytes = 0;
while(<BDF>)
{
	if(/^([0-9a-fA-F]{2})$/)
	{
		printf OUT "%c", hex($1);
		$bytes++;
	}
	elsif(/^ENCODING\s([0-9]+)$/) { push @unimap, $1; }
	elsif(/^ENDFONT$/) { last; }
}
close BDF;

if($#ARGV > 0)
{
	if($unicode)
	{
		do
		{
			shift @ARGV;

			open(DUP, "<$ARGV[0]") || die("$0: $ARGV[0]: $!\n");
			while(<DUP>)
			{
				next if /^\s*$/;
				/^([0-9a-fA-F]{1,4})\s+([0-9a-fA-F]{1,4})\s*$/ || die("$0: $ARGV[0]: invalid unicode(s) $_\n");
				hex($1) != hex($2) || die("$0: $ARGV[0]: invalid duplicate entry $_\n");
				foreach(@{$unidup{hex($1)}}) { if($_ == hex($2)) { $2 = "65535"; last; } }
				if(hex($2) != 65535) { push @{$unidup{hex($1)}}, hex($2); }
			}
			close DUP;
		} while($#ARGV > 0);
	}
	else { die("$0: invalid number of arguments\n"); }
}

@unimap == $chars || die("$0: $output: invalid number of chars @unimap\n");
@unimap * $height == $bytes || die("$0: $output: invalid number of bytes $bytes\n");

if($unicode)
{
	foreach(@unimap)
	{
		if($_ != 65535) { printf OUT "%c%c", $_ & 0xFF, $_ >> 8; }
		foreach(@{$unidup{$_}}) { printf OUT "%c%c", $_ & 0xFF, $_ >> 8; }
		printf OUT "%c%c", 0xFF, 0xFF;
	}
}

close OUT;
