/*
 * Copyright (c) 2002, The Tendra Project <http://www.tendra.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice unmodified, this list of conditions, and the following
 *    disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *    		 Crown Copyright (c) 1997
 *    
 *    This TenDRA(r) Computer Program is subject to Copyright
 *    owned by the United Kingdom Secretary of State for Defence
 *    acting through the Defence Evaluation and Research Agency
 *    (DERA).  It is made available to Recipients with a
 *    royalty-free licence for its use, reproduction, transfer
 *    to other parties and amendment for any purpose not excluding
 *    product development provided that any such use et cetera
 *    shall be deemed to be acceptance of the following conditions:-
 *    
 *        (1) Its Recipients shall ensure that this Notice is
 *        reproduced upon any copies or amended versions of it;
 *    
 *        (2) Any amended version of it shall be clearly marked to
 *        show both the nature of and the organisation responsible
 *        for the relevant amendment or amendments;
 *    
 *        (3) Its onward transfer from a recipient to another
 *        party shall be deemed to be that party's acceptance of
 *        these conditions;
 *    
 *        (4) DERA gives no warranty or assurance as to its
 *        quality or suitability for any purpose and DERA accepts
 *        no liability whatsoever in relation to any use to which
 *        it may be put.
 *
 * $TenDRA: tendra/src/utilities/sid/c-out-types.h,v 1.2 2002/12/21 21:49:39 nonce Exp $
*/


/*** c-out-types.h --- Output type objects.
 *
 ** Author: Steve Folkes <smf@hermes.mod.uk>
 *
 *** Commentary:
 *
 * See the file "c-out-types.c" for more information.
 *
 *** Change Log:*/

/****************************************************************************/

#ifndef H_C_OUT_TYPES
#define H_C_OUT_TYPES

#include "os-interface.h"
#include "c-output.h"
#include "rstack.h"
#include "rule.h"
#include "table.h"
#include "types.h"

/*--------------------------------------------------------------------------*/

extern void			c_output_assign
	PROTO_S ((COutputInfoP, EntryP, EntryP, SaveRStackP, SaveRStackP,
		  unsigned));
extern void			c_output_type_decl
	PROTO_S ((COutputInfoP, TypeTupleP, TypeTupleP));
extern void			c_output_type_defn
	PROTO_S ((COutputInfoP, TypeTupleP, TypeTupleP));
extern void			c_output_result_assign
	PROTO_S ((COutputInfoP, TypeTupleP, unsigned));
extern void			c_output_alt_names
	PROTO_S ((COutputInfoP, TypeTupleP, TypeTupleP, SaveRStackP,
		  unsigned));
extern void			c_output_rule_params
	PROTO_S ((COutputInfoP, TypeTupleP, TypeTupleP, SaveRStackP));
extern void			c_output_rename
	PROTO_S ((COutputInfoP, TypeTupleP, TypeTupleP, SaveRStackP,
		  unsigned));
extern void			c_output_tail_decls
	PROTO_S ((COutputInfoP, TypeTupleP, SaveRStackP, TypeTupleP,
		  SaveRStackP, unsigned));
extern BoolT			c_output_required_copies
	PROTO_S ((COutputInfoP, TypeTupleP, TypeTupleP, RStackP, SaveRStackP,
		  unsigned, TableP));
	      
#endif /* !defined (H_C_OUT_TYPES) */

/*
 * Local variables(smf):
 * eval: (include::add-path-entry "../os-interface" "../library")
 * eval: (include::add-path-entry "../transforms" "../output" "../generated")
 * end:
**/
