/*
 * MediaSignalling page for channel notebook.
 *
 * Copyright (C) 2008 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2008 Nokia Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_PAGE_MEDIA_SIGNALLING_H__
#define __TI_PAGE_MEDIA_SIGNALLING_H__

#include <gtk/gtk.h>
#include <glib-object.h>
#include <telepathy-glib/channel.h>

#include "page.h"

typedef struct _TIPageMediaSignalling TIPageMediaSignalling;
typedef struct _TIPageMediaSignallingClass TIPageMediaSignallingClass;
typedef struct _TIPageMediaSignallingPrivate TIPageMediaSignallingPrivate;

GType ti_page_media_signalling_get_type (void);

#define TI_TYPE_PAGE_MEDIA_SIGNALLING \
  (ti_page_media_signalling_get_type ())
#define TI_PAGE_MEDIA_SIGNALLING(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), TI_TYPE_PAGE_MEDIA_SIGNALLING, \
                               TIPageMediaSignalling))
#define TI_PAGE_MEDIA_SIGNALLING_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_PAGE_MEDIA_SIGNALLING, \
                            TIPageMediaSignallingClass))
#define TI_IS_PAGE_MEDIA_SIGNALLING(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TI_TYPE_PAGE_MEDIA_SIGNALLING))
#define TI_IS_PAGE_MEDIA_SIGNALLING_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_PAGE_MEDIA_SIGNALLING))
#define TI_PAGE_MEDIA_SIGNALLING_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), TI_TYPE_PAGE_MEDIA_SIGNALLING, \
                              TIPageMediaSignallingClass))

struct _TIPageMediaSignalling {
    TIPage parent;
    TIPageMediaSignallingPrivate *priv;
};

TIPageMediaSignalling *ti_page_media_signalling_new (
    GtkNotebook *parent_notebook,
    TpChannel *channel);

#endif
