/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test properties managers.
 * 
 * ti-properties.h:
 * GObject wrapper for D-Bus method calls to org.freedesktop.Telepathy.Properties
 * 
 * Copyright (C) 2007 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_PROPERTIES_H__
#define __TI_PROPERTIES_H__

#include <glib-object.h>

/*
 * Type macros.
 */

typedef struct _TIProperties TIProperties;
typedef struct _TIPropertiesClass TIPropertiesClass;

#define TI_TYPE_PROPERTIES               ti_properties_get_type()
#define TI_PROPERTIES(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_PROPERTIES, TIProperties))
#define TI_PROPERTIES_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_PROPERTIES, TIPropertiesClass))
#define TT_IS_PROPERTIES(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_PROPERTIES))
#define TT_IS_PROPERTIES_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_PROPERTIES))
#define TI_PROPERTIES_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_PROPERTIES, TIPropertiesClass))

struct _TIProperties {
  GObject parent;
};

GType ti_properties_get_type (void);

/**
 * Creates a new properties
 */
TIProperties* ti_properties_new (const gchar* service_name, const gchar* obj_path);

/**
 * Get Properties
 */
GPtrArray* ti_properties_get_properties (TIProperties* properties, GArray* prop_ids, GError** error);

/**
 * List Properties
 */
GPtrArray* ti_properties_list_properties (TIProperties* properties, GError** error);

/**
 * Set Properties
 */
void ti_properties_set_properties (TIProperties* properties, GPtrArray* props, GError** error);

#endif
