/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-dlg-add-members.h:
 * Dialog to add members to a Channel.Interface.Group
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_DLG_ADD_MEMBERS_H__
#define __TI_DLG_ADD_MEMBERS_H__

#include "ti-handle-mapper.h"

#include <gtk/gtk.h>

/*
 * Type macros.
 */

typedef struct _TIDlgAddMembers TIDlgAddMembers;
typedef struct _TIDlgAddMembersClass TIDlgAddMembersClass;

#define TI_TYPE_DLG_ADD_MEMBERS               ti_dlg_add_members_get_type()
#define TI_DLG_ADD_MEMBERS(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_DLG_ADD_MEMBERS, TIDlgAddMembers))
#define TI_DLG_ADD_MEMBERS_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_DLG_ADD_MEMBERS, TIDlgAddMembersClass))
#define TI_IS_DLG_ADD_MEMBERS(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_DLG_ADD_MEMBERS))
#define TI_IS_DLG_ADD_MEMBERS_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_DLG_ADD_MEMBERS))
#define TI_DLG_ADD_MEMBERS_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_DLG_ADD_MEMBERS, TIDlgAddMembersClass))

struct _TIDlgAddMembers
{
    GObject parent;
};

struct _TIDlgAddMembersClass
{
    GObjectClass parent;
};

GType ti_dlg_add_members_get_type (void);

TIDlgAddMembers* ti_dlg_add_members_new (GtkWindow* parent, TIHandleMapper* handle_mapper);

/**
 * Shows the "Get Entry" dialog.
 *
 * @param text Entered text. Must be freed after use.
 * @param handles Entered handles. An array of guint. Must be freed after use.
 * @return TRUE if the user clicked "OK" and FALSE otherwise.
 */
gboolean ti_dlg_add_members_run (TIDlgAddMembers* dlg_add_members, GArray* in_handles, GArray** out_handles, gchar** message);

#endif
