/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-conn-manager.h:
 * ConnManager - GObject wrapper for D-Bus method calls to
 *               org.freedesktop.Telepathy.ConnectionManager
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_CONN_MANAGER_H__
#define __TI_CONN_MANAGER_H__

#include <glib-object.h>

#include "ti-connection.h"

/*
 * Type macros.
 */

typedef struct _TIConnManager TIConnManager;
typedef struct _TIConnManagerClass TIConnManagerClass;

#define TI_TYPE_CONN_MANAGER               ti_conn_manager_get_type()
#define TI_CONN_MANAGER(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_CONN_MANAGER, TIConnManager))
#define TI_CONN_MANAGER_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_CONN_MANAGER, TIConnManagerClass))
#define TT_IS_CONN_MANAGER(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_CONN_MANAGER))
#define TT_IS_CONN_MANAGER_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_CONN_MANAGER))
#define TI_CONN_MANAGER_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_CONN_MANAGER, TIConnManagerClass))

struct _TIConnManager {
  GObject parent;
  /* instance members */
};

struct _TIConnManagerClass {
  GObjectClass parent;
  /* class members */
};

GType ti_conn_manager_get_type (void);


/**
 * Creates a new access wrapper for the specified connection manager.
 *
 * @param name Connection manager's name (e.g., "gabble").
 * @return A new TIConnManager or NULL if an error occurred.
 */
TIConnManager* ti_conn_manager_new (const gchar* name);

/**
 * List Protocols
 *
 * @return Protocol names. Must be freed after use.
 */
GStrv ti_conn_manager_list_protocols (TIConnManager* conn_manager);

/**
 * Get Parameters
 *
 * Get a list of the parameters which must or may be provided to the RequestConnection
 * method when connecting to the given protocol, or registering.
 *
 * @param protocol Protocol's name.
 * @return An array of d-bus struts. Must be freed after use.
 *         Each d-bus struct is a GValueArray (GValue(string), GValue(uint), GValue(String), GValue(?))
 */
GPtrArray* ti_conn_manager_get_parameters (TIConnManager* conn_manager, const gchar* protocol);

/**
 * Request Connection
 *
 * @param error Address of a pointer. It will be set to a GError if an error occurred and to NULL otherwise.
 */
TIConnection* ti_conn_manager_request_connection (TIConnManager* conn_manager,
                                                  const gchar* protocol,
                                                  GHashTable* parameters);

#endif
