#   include <appUtilConfig.h>

#   include <utilJenkinsHash.h>

#   include "docRtfTagHash.h"

#   define ub4 UtilUint32
#   define ub2 UtilUint16
#   define ub1 unsigned char

#   define CHECKSTATE 8

/* smax= 1024, blen= 256 */

/* small adjustments to _a_ to make values distinct */
static const ub2 tab[] = {
674,641,89,792,801,0,674,165,311,165,0,258,674,167,409,496,
311,0,331,981,133,370,118,814,677,801,0,331,77,340,14,0,
381,253,0,258,0,331,674,711,311,159,334,288,381,674,821,409,
873,295,670,488,543,767,571,258,549,635,1011,331,845,697,311,796,
60,571,165,0,258,370,924,571,358,515,370,128,98,381,721,486,
366,0,670,618,836,739,96,279,670,381,427,331,311,515,750,706,
869,192,238,331,370,742,821,358,253,0,192,873,670,340,331,706,
381,578,1019,165,14,165,258,0,331,670,801,516,670,358,569,331,
741,282,130,0,0,258,753,674,58,674,0,769,334,709,706,693,
232,165,801,0,0,258,670,331,492,41,625,825,188,670,571,674,
674,90,373,331,471,641,305,0,1023,674,515,14,484,70,741,253,
836,180,801,674,796,57,769,601,14,674,313,180,36,9,30,0,
515,981,373,295,796,674,0,144,209,674,513,253,515,635,741,515,
0,8,533,710,0,907,693,0,869,183,156,927,674,238,192,940,
183,14,258,144,645,0,579,365,617,232,790,520,386,0,0,287,
381,649,340,92,497,822,362,927,932,721,36,311,427,207,1011,503,
};

/* map back array */

static int mapBack[]=
    {
     652L,	/*     0: "levelpicture" */
     272L,	/*     1: "clbgdkfdiag" */
     580L,	/*     2: "deflang" */
     447L,	/*     3: "headery" */
     483L,	/*     4: "linex" */
     497L,	/*     5: "lineppage" */
     368L,	/*     6: "tbllklastrow" */
     472L,	/*     7: "colsx" */
     811L,	/*     8: "dplinecor" */
     171L,	/*     9: "tposx" */
     739L,	/*    10: "bullet" */
     371L,	/*    11: "irow" */
     334L,	/*    12: "trspdfb" */
     707L,	/*    13: "piccropb" */
     607L,	/*    14: "rtldoc" */
     213L,	/*    15: "posnegy" */
     143L,	/*    16: "bgdkcross" */
     666L,	/*    17: "listoverridecount" */
      11L,	/*    18: "caps" */
     518L,	/*    19: "sftnnchi" */
      76L,	/*    20: "revdttm" */
     489L,	/*    21: "vertalt" */
     599L,	/*    22: "otblrul" */
     422L,	/*    23: "bdrrlswsix" */
     411L,	/*    24: "truncex" */
     584L,	/*    25: "formshade" */
     258L,	/*    26: "ltrrow" */
     657L,	/*    27: "levelprevspace" */
     173L,	/*    28: "tposxl" */
     400L,	/*    29: "deff" */
     322L,	/*    30: "trbrdrr" */
     611L,	/*    31: "subfontbysize" */
     745L,	/*    32: "ldblquote" */
     567L,	/*    33: "ansicpg" */
     655L,	/*    34: "levelold" */
     149L,	/*    35: "bghoriz" */
     692L,	/*    36: "jpegblip" */
     100L,	/*    37: "chbgdkvert" */
     444L,	/*    38: "pnuldb" */
     629L,	/*    39: "subdocument" */
     241L,	/*    40: "af" */
     141L,	/*    41: "bgdcross" */
     747L,	/*    42: "ltrmark" */
     424L,	/*    43: "sprstsm" */
     840L,	/*    44: "shpwr" */
     500L,	/*    45: "lndscpsxn" */
     626L,	/*    46: "noline" */
     467L,	/*    47: "pgnlcltr" */
     696L,	/*    48: "pmmetafile" */
     337L,	/*    49: "trpaddt" */
     279L,	/*    50: "clcbpat" */
     216L,	/*    51: "posyil" */
     511L,	/*    52: "saftnrstcont" */
     256L,	/*    53: "hich" */
     124L,	/*    54: "qc" */
     136L,	/*    55: "hyphpar" */
     234L,	/*    56: "tx" */
     812L,	/*    57: "dplinecog" */
     242L,	/*    58: "afs" */
     407L,	/*    59: "pgbrdrl" */
     690L,	/*    60: "wmetafile" */
     133L,	/*    61: "slmult" */
     694L,	/*    62: "dibitmap" */
     201L,	/*    63: "phcol" */
     365L,	/*    64: "tbllkcolor" */
     275L,	/*    65: "clbgfdiag" */
     295L,	/*    66: "clvmrg" */
     249L,	/*    67: "aul" */
     806L,	/*    68: "dpxsize" */
     306L,	/*    69: "clpadfl" */
     691L,	/*    70: "pngblip" */
     520L,	/*    71: "saftnnalc" */
     493L,	/*    72: "binsxn" */
     355L,	/*    73: "trbgdkvert" */
     778L,	/*    74: "dparc" */
      44L,	/*    75: "pngbnum" */
     107L,	/*    76: "chcfpat" */
     490L,	/*    77: "sectlinegrid" */
       1L,	/*    78: "f" */
     289L,	/*    79: "cltxbtlr" */
     248L,	/*    80: "astrike" */
     296L,	/*    81: "clNoWrap" */
     119L,	/*    82: "fi" */
     654L,	/*    83: "leveltemplateid" */
     513L,	/*    84: "sftnnar" */
     428L,	/*    85: "nobrkwrptbl" */
     382L,	/*    86: "gutter" */
     662L,	/*    87: "listsimple" */
      83L,	/*    88: "uld" */
     197L,	/*    89: "overlay" */
     120L,	/*    90: "ri" */
     676L,	/*    91: "tlth" */
     536L,	/*    92: "ftnrstpg" */
     818L,	/*    93: "dpfillfggray" */
     736L,	/*    94: "objcropr" */
     466L,	/*    95: "pgnucltr" */
     598L,	/*    96: "notabind" */
     549L,	/*    97: "aftnnauc" */
      38L,	/*    98: "pndbnumk" */
     544L,	/*    99: "ftnnrlc" */
     377L,	/*   100: "margr" */
     628L,	/*   101: "sbys" */
     527L,	/*   102: "enddoc" */
     186L,	/*   103: "tposyin" */
     616L,	/*   104: "viewzk" */
     569L,	/*   105: "lin" */
     247L,	/*   106: "ashad" */
     644L,	/*   107: "levelstartat" */
     268L,	/*   108: "clbgdcross" */
     144L,	/*   109: "bgdkdcross" */
     679L,	/*   110: "fnil" */
     689L,	/*   111: "macpict" */
     236L,	/*   112: "ab" */
     804L,	/*   113: "dpy" */
     769L,	/*   114: "chdpa" */
     175L,	/*   115: "tposxc" */
     298L,	/*   116: "clwWidth" */
     373L,	/*   117: "ts" */
     273L,	/*   118: "clbgdkhor" */
     162L,	/*   119: "sbauto" */
     187L,	/*   120: "tposyout" */
     381L,	/*   121: "paperw" */
     445L,	/*   122: "pnulnone" */
     437L,	/*   123: "noxlattoyen" */
     557L,	/*   124: "slink" */
     349L,	/*   125: "trbgdcross" */
     523L,	/*   126: "saftnnruc" */
      70L,	/*   127: "dn" */
      16L,	/*   128: "pncf" */
     267L,	/*   129: "clbgcross" */
     469L,	/*   130: "pgnrestart" */
     314L,	/*   131: "trkeepfollow" */
     821L,	/*   132: "dpfillbgcb" */
     516L,	/*   133: "sftnnrlc" */
     526L,	/*   134: "endnotes" */
     329L,	/*   135: "trspdt" */
     771L,	/*   136: "dolock" */
     786L,	/*   137: "dplinesolid" */
     498L,	/*   138: "linerestart" */
      89L,	/*   139: "expnd" */
     125L,	/*   140: "pagebb" */
     592L,	/*   141: "linkstyles" */
     354L,	/*   142: "trbgdkhor" */
     363L,	/*   143: "tbllkshading" */
     204L,	/*   144: "posxl" */
     441L,	/*   145: "nospaceforul" */
     682L,	/*   146: "fmodern" */
     673L,	/*   147: "tldot" */
     647L,	/*   148: "leveljcn" */
     755L,	/*   149: "zwj" */
     660L,	/*   150: "listid" */
     311L,	/*   151: "trrh" */
     190L,	/*   152: "tdfrmtxtRight" */
     820L,	/*   153: "dpfillbgcg" */
     702L,	/*   154: "picwgoal" */
     430L,	/*   155: "wrppunct" */
     606L,	/*   156: "revprot" */
     517L,	/*   157: "sftnnruc" */
     111L,	/*   158: "facenter" */
     726L,	/*   159: "objicemb" */
     287L,	/*   160: "cltxlrtb" */
     138L,	/*   161: "shading" */
     826L,	/*   162: "shptop" */
     831L,	/*   163: "shpfhdr" */
     450L,	/*   164: "pghsxn" */
     787L,	/*   165: "dplinehollow" */
     343L,	/*   166: "trwWidthB" */
     177L,	/*   167: "tposxo" */
     115L,	/*   168: "pard" */
     388L,	/*   169: "jcompress" */
     429L,	/*   170: "snaptogridincell" */
     461L,	/*   171: "sbkeven" */
     496L,	/*   172: "linemod" */
     635L,	/*   173: "yr" */
     315L,	/*   174: "trautofit" */
     151L,	/*   175: "cfpat" */
     539L,	/*   176: "aftnrstcont" */
     292L,	/*   177: "clmgf" */
     335L,	/*   178: "trpaddl" */
      98L,	/*   179: "chbgdcross" */
     203L,	/*   180: "posnegx" */
     559L,	/*   181: "shidden" */
     359L,	/*   182: "trcfpat" */
     313L,	/*   183: "trkeep" */
     709L,	/*   184: "piccropr" */
     134L,	/*   185: "outlinelevel" */
       0L,	/*   186: "plain" */
     503L,	/*   187: "sectunlocked" */
     713L,	/*   188: "picbmp" */
      42L,	/*   189: "pnirohad" */
     521L,	/*   190: "saftnnauc" */
     805L,	/*   191: "dodhgt" */
     274L,	/*   192: "clbgdkvert" */
     531L,	/*   193: "aenddoc" */
     600L,	/*   194: "prcolbl" */
     699L,	/*   195: "wbmwidthbytes" */
     397L,	/*   196: "dgmargin" */
     735L,	/*   197: "objcropl" */
     155L,	/*   198: "brdrl" */
     528L,	/*   199: "ftntj" */
     477L,	/*   200: "pgnhnsp" */
     142L,	/*   201: "bgdkbdiag" */
     453L,	/*   202: "margrsxn" */
     714L,	/*   203: "picbpp" */
     146L,	/*   204: "bgdkhoriz" */
     160L,	/*   205: "adjustright" */
     196L,	/*   206: "nowrap" */
     510L,	/*   207: "sftnrstcont" */
     703L,	/*   208: "pichgoal" */
     434L,	/*   209: "rempersonalinfo" */
     476L,	/*   210: "pgnhnsh" */
     281L,	/*   211: "clcfpatraw" */
     775L,	/*   212: "dobypage" */
     385L,	/*   213: "twoonone" */
     405L,	/*   214: "pgbrdrt" */
     624L,	/*   215: "level" */
     593L,	/*   216: "ltrdoc" */
      86L,	/*   217: "v" */
     742L,	/*   218: "emspace" */
     399L,	/*   219: "deftab" */
     403L,	/*   220: "stshfhich" */
     824L,	/*   221: "dppty" */
     519L,	/*   222: "saftnnar" */
     360L,	/*   223: "trcbpat" */
     148L,	/*   224: "bgfdiag" */
     180L,	/*   225: "tpvpg" */
     460L,	/*   226: "sbkpage" */
     487L,	/*   227: "vertalc" */
     799L,	/*   228: "dpastartw" */
      96L,	/*   229: "chbgbdiag" */
     446L,	/*   230: "sectd" */
     209L,	/*   231: "pvmrg" */
     625L,	/*   232: "ltrpar" */
     770L,	/*   233: "chdpl" */
     780L,	/*   234: "dpellipse" */
      95L,	/*   235: "chbgfdiag" */
     494L,	/*   236: "linebetcol" */
     309L,	/*   237: "trgaph" */
     612L,	/*   238: "swpbdr" */
     226L,	/*   239: "pnrdate" */
     687L,	/*   240: "cpg" */
     465L,	/*   241: "pgnlcrm" */
     488L,	/*   242: "vertalj" */
     732L,	/*   243: "objscaley" */
     722L,	/*   244: "objlink" */
     512L,	/*   245: "saftnrestart" */
     827L,	/*   246: "shpbottom" */
     168L,	/*   247: "tphmrg" */
     369L,	/*   248: "tbllkhdrcols" */
     396L,	/*   249: "dgvshow" */
     202L,	/*   250: "posx" */
      53L,	/*   251: "pnaiueod" */
     843L,	/*   252: "shplockanchor" */
     542L,	/*   253: "ftnnalc" */
     471L,	/*   254: "cols" */
     350L,	/*   255: "trbgdkbdiag" */
      84L,	/*   256: "uldb" */
     744L,	/*   257: "enspace" */
     270L,	/*   258: "clbgdkcross" */
     154L,	/*   259: "brdrb" */
     754L,	/*   260: "softpage" */
      63L,	/*   261: "noproof" */
      80L,	/*   262: "ltrch" */
     796L,	/*   263: "dpaendl" */
     425L,	/*   264: "pgbrdropt" */
     630L,	/*   265: "hr" */
     583L,	/*   266: "formprot" */
     509L,	/*   267: "sftnrestart" */
      54L,	/*   268: "pnbidia" */
     675L,	/*   269: "tlhyph" */
     378L,	/*   270: "margt" */
     640L,	/*   271: "sectrsid" */
     563L,	/*   272: "ansi" */
     534L,	/*   273: "ftnstart" */
     169L,	/*   274: "tphpg" */
     838L,	/*   275: "shpbypara" */
     621L,	/*   276: "rtlgutter" */
     499L,	/*   277: "linestarts" */
     139L,	/*   278: "bgbdiag" */
     121L,	/*   279: "ql" */
     651L,	/*   280: "levelnorestart" */
     639L,	/*   281: "charrsid" */
     540L,	/*   282: "aftnrestart" */
     781L,	/*   283: "dpline" */
     602L,	/*   284: "psover" */
     127L,	/*   285: "widctlpar" */
     229L,	/*   286: "pnrpnbr" */
     715L,	/*   287: "blipupi" */
     761L,	/*   288: "column" */
     246L,	/*   289: "ascaps" */
     390L,	/*   290: "horzdoc" */
     358L,	/*   291: "trbgvert" */
     468L,	/*   292: "pgncont" */
       5L,	/*   293: "b" */
     605L,	/*   294: "revprop" */
     106L,	/*   295: "chcbpat" */
     336L,	/*   296: "trpaddr" */
     253L,	/*   297: "aulw" */
     288L,	/*   298: "cltxtbrl" */
     834L,	/*   299: "shpbxcolumn" */
     317L,	/*   300: "trqr" */
     408L,	/*   301: "pgbrdrr" */
     793L,	/*   302: "dpaendsol" */
      27L,	/*   303: "pnucltr" */
     293L,	/*   304: "clmrg" */
     681L,	/*   305: "fswiss" */
     749L,	/*   306: "rquote" */
     731L,	/*   307: "objscalex" */
     546L,	/*   308: "ftnnchi" */
     199L,	/*   309: "phmrg" */
     665L,	/*   310: "liststyleid" */
     554L,	/*   311: "additive" */
     284L,	/*   312: "clvertalt" */
     161L,	/*   313: "adjustleft" */
     568L,	/*   314: "itap" */
     416L,	/*   315: "htmautsp" */
     601L,	/*   316: "printdata" */
     753L,	/*   317: "softline" */
     150L,	/*   318: "bgvert" */
     620L,	/*   319: "ogutter" */
     588L,	/*   320: "hyphconsec" */
     830L,	/*   321: "shpz" */
      37L,	/*   322: "pndbnumt" */
      36L,	/*   323: "pndbnuml" */
     537L,	/*   324: "ftnrestart" */
     277L,	/*   325: "clbgvert" */
     704L,	/*   326: "picscalex" */
     582L,	/*   327: "formdisp" */
     594L,	/*   328: "makebackup" */
     372L,	/*   329: "irowband" */
     278L,	/*   330: "clcfpat" */
      40L,	/*   331: "pndecd" */
     214L,	/*   332: "posyb" */
     538L,	/*   333: "ftnrstcont" */
     803L,	/*   334: "dpx" */
     423L,	/*   335: "oldas" */
     721L,	/*   336: "objemb" */
     362L,	/*   337: "tbllkborder" */
     122L,	/*   338: "qr" */
     650L,	/*   339: "levellegal" */
     356L,	/*   340: "trbgfdiag" */
     495L,	/*   341: "linecont" */
     671L,	/*   342: "tqc" */
     147L,	/*   343: "bgdkvert" */
     672L,	/*   344: "tqdec" */
     491L,	/*   345: "endnhere" */
     558L,	/*   346: "sautoupd" */
     328L,	/*   347: "trspdr" */
     225L,	/*   348: "pnrauth" */
     401L,	/*   349: "stshfdbch" */
     442L,	/*   350: "pnhang" */
     118L,	/*   351: "li" */
     194L,	/*   352: "absh" */
     686L,	/*   353: "fcharset" */
     758L,	/*   354: "line" */
      13L,	/*   355: "strike" */
     438L,	/*   356: "expshrtn" */
     387L,	/*   357: "psz" */
     208L,	/*   358: "posxo" */
     819L,	/*   359: "dpfillbgcr" */
     232L,	/*   360: "pnrstop" */
      41L,	/*   361: "pnaiud" */
     412L,	/*   362: "nolead" */
     393L,	/*   363: "dghorigin" */
     410L,	/*   364: "pgbrdrfoot" */
      61L,	/*   365: "pnprev" */
     570L,	/*   366: "rin" */
     459L,	/*   367: "sbkcol" */
     562L,	/*   368: "spersonal" */
      82L,	/*   369: "fcs" */
      93L,	/*   370: "chbghoriz" */
     597L,	/*   371: "noextrasprl" */
     282L,	/*   372: "clcbpatraw" */
     345L,	/*   373: "trftsWidthB" */
     553L,	/*   374: "ftnalt" */
     701L,	/*   375: "pich" */
     791L,	/*   376: "dplinedadodo" */
       6L,	/*   377: "i" */
      19L,	/*   378: "pnul" */
     102L,	/*   379: "chbgdkbdiag" */
     779L,	/*   380: "dpcallout" */
     222L,	/*   381: "dfrmtxty" */
     832L,	/*   382: "shpbxmargin" */
     205L,	/*   383: "posxr" */
     765L,	/*   384: "chpgn" */
     108L,	/*   385: "chshdng" */
     797L,	/*   386: "dpastartl" */
     674L,	/*   387: "tlul" */
      71L,	/*   388: "outl" */
     667L,	/*   389: "listoverridestartat" */
     129L,	/*   390: "keepn" */
      47L,	/*   391: "pngbnumk" */
     357L,	/*   392: "trbghoriz" */
     238L,	/*   393: "acf" */
     524L,	/*   394: "saftnnchi" */
     451L,	/*   395: "marglsxn" */
      97L,	/*   396: "chbgcross" */
     297L,	/*   397: "clshdrawnil" */
     470L,	/*   398: "pgnstarts" */
     353L,	/*   399: "trbgdkfdiag" */
     166L,	/*   400: "aspnum" */
     772L,	/*   401: "dobxpage" */
     319L,	/*   402: "trbrdrt" */
     751L,	/*   403: "softcol" */
     481L,	/*   404: "pgnx" */
     506L,	/*   405: "sftnstart" */
     514L,	/*   406: "sftnnalc" */
     720L,	/*   407: "rslthtml" */
     581L,	/*   408: "fldalt" */
     776L,	/*   409: "dobypara" */
       7L,	/*   410: "ul" */
     332L,	/*   411: "trspdfr" */
     723L,	/*   412: "objautlink" */
     615L,	/*   413: "wraptrsp" */
     760L,	/*   414: "page" */
     101L,	/*   415: "chbgdkfdiag" */
     835L,	/*   416: "shpbxignore" */
     240L,	/*   417: "aexpnd" */
     206L,	/*   418: "posxc" */
     347L,	/*   419: "trbgbdiag" */
     548L,	/*   420: "aftnnalc" */
     443L,	/*   421: "pnuld" */
      51L,	/*   422: "pnchosung" */
     730L,	/*   423: "objh" */
     486L,	/*   424: "vertalb" */
     153L,	/*   425: "brdrt" */
     310L,	/*   426: "trleft" */
     325L,	/*   427: "trwWidth" */
     656L,	/*   428: "levelprev" */
     454L,	/*   429: "margbsxn" */
     492L,	/*   430: "binfsxn" */
       3L,	/*   431: "cf" */
     637L,	/*   432: "rsidroot" */
       4L,	/*   433: "cs" */
     783L,	/*   434: "dppolyline" */
     591L,	/*   435: "linestart" */
     541L,	/*   436: "ftnnar" */
     634L,	/*   437: "mo" */
     738L,	/*   438: "rsltmerge" */
     462L,	/*   439: "sbkodd" */
     395L,	/*   440: "dghshow" */
      43L,	/*   441: "pnganada" */
     391L,	/*   442: "dghspace" */
     163L,	/*   443: "saauto" */
      31L,	/*   444: "pnordt" */
     266L,	/*   445: "clbgbdiag" */
      22L,	/*   446: "pnstrike" */
      15L,	/*   447: "pnfs" */
     646L,	/*   448: "levelnfc" */
     572L,	/*   449: "langfe" */
     132L,	/*   450: "sl" */
     458L,	/*   451: "sbknone" */
     717L,	/*   452: "rslttxt" */
     348L,	/*   453: "trbgcross" */
     114L,	/*   454: "fafixed" */
     185L,	/*   455: "tposyil" */
     323L,	/*   456: "trbrdrh" */
     417L,	/*   457: "useltbaln" */
     431L,	/*   458: "asianbrkrule" */
     158L,	/*   459: "brdrbtw" */
     330L,	/*   460: "trspdb" */
     638L,	/*   461: "delrsid" */
     719L,	/*   462: "rsltbmp" */
      68L,	/*   463: "cchs" */
     254L,	/*   464: "aup" */
     302L,	/*   465: "clpadl" */
     485L,	/*   466: "colsr" */
     456L,	/*   467: "ds" */
     291L,	/*   468: "cltxtbrlv" */
     794L,	/*   469: "dpastarthol" */
     210L,	/*   470: "pvpara" */
     170L,	/*   471: "tphcol" */
     455L,	/*   472: "guttersxn" */
     218L,	/*   473: "posyout" */
     418L,	/*   474: "alntblind" */
     440L,	/*   475: "dntblnsbdb" */
     324L,	/*   476: "trbrdrv" */
     740L,	/*   477: "chatn" */
     176L,	/*   478: "tposxi" */
     817L,	/*   479: "dpfillfgcb" */
     807L,	/*   480: "dpysize" */
     609L,	/*   481: "sprsspbf" */
     590L,	/*   482: "landscape" */
     457L,	/*   483: "titlepg" */
      10L,	/*   484: "nosupersub" */
     698L,	/*   485: "wbmplanes" */
     622L,	/*   486: "deflangfe" */
     285L,	/*   487: "clvertalc" */
      21L,	/*   488: "pnscaps" */
     795L,	/*   489: "dpastartsol" */
     800L,	/*   490: "dpfillpat" */
     301L,	/*   491: "clpadb" */
     727L,	/*   492: "objhtml" */
     550L,	/*   493: "aftnnrlc" */
     683L,	/*   494: "fscript" */
     837L,	/*   495: "shpbypage" */
     614L,	/*   496: "ight" */
     230L,	/*   497: "pnrrgb" */
      34L,	/*   498: "pnaiu" */
     825L,	/*   499: "shpleft" */
     842L,	/*   500: "shpfblwtxt" */
     619L,	/*   501: "lytprtmet" */
     608L,	/*   502: "sprslnsp" */
      48L,	/*   503: "pnzodiac" */
     421L,	/*   504: "lnbrkrule" */
      77L,	/*   505: "revdttmdel" */
     326L,	/*   506: "trftsWidth" */
     525L,	/*   507: "fet" */
     340L,	/*   508: "trpaddfr" */
     276L,	/*   509: "clbghoriz" */
     823L,	/*   510: "dpptx" */
     338L,	/*   511: "trpaddb" */
     110L,	/*   512: "fahang" */
     555L,	/*   513: "sbasedon" */
     645L,	/*   514: "levelnfcn" */
     649L,	/*   515: "levelfollow" */
     706L,	/*   516: "piccropt" */
      99L,	/*   517: "chbgdkhoriz" */
     265L,	/*   518: "clbrdrr" */
     697L,	/*   519: "wbmbitspixel" */
      17L,	/*   520: "pnb" */
     304L,	/*   521: "clpadft" */
     507L,	/*   522: "saftnstart" */
     113L,	/*   523: "favar" */
     664L,	/*   524: "listrestarthdn" */
     502L,	/*   525: "rtlsect" */
     195L,	/*   526: "abslock" */
     432L,	/*   527: "newtblstyruls" */
     575L,	/*   528: "allprot" */
     663L,	/*   529: "listhybrid" */
     427L,	/*   530: "allowfieldendsel" */
     452L,	/*   531: "margtsxn" */
     135L,	/*   532: "ilvl" */
      72L,	/*   533: "revauth" */
     260L,	/*   534: "cellx" */
     167L,	/*   535: "tabsnoovrlp" */
     244L,	/*   536: "alang" */
     532L,	/*   537: "aftntj" */
     759L,	/*   538: "lbr" */
     566L,	/*   539: "pca" */
     366L,	/*   540: "tbllkbestfit" */
     342L,	/*   541: "trpaddfb" */
     189L,	/*   542: "tdfrmtxtLeft" */
     237L,	/*   543: "acaps" */
     211L,	/*   544: "pvpg" */
     402L,	/*   545: "stshfloch" */
     131L,	/*   546: "sa" */
     790L,	/*   547: "dplinedado" */
     126L,	/*   548: "nowidctlpar" */
     653L,	/*   549: "fbias" */
     243L,	/*   550: "ai" */
     413L,	/*   551: "msmcap" */
     305L,	/*   552: "clpadfb" */
      74L,	/*   553: "crdate" */
     294L,	/*   554: "clvmgf" */
     829L,	/*   555: "shplid" */
     290L,	/*   556: "cltxlrtbv" */
     700L,	/*   557: "picw" */
     610L,	/*   558: "sprstsp" */
     117L,	/*   559: "ls" */
     839L,	/*   560: "shpbyignore" */
     505L,	/*   561: "sftnbj" */
     389L,	/*   562: "jexpand" */
     763L,	/*   563: "chftnsepc" */
     318L,	/*   564: "trqc" */
     159L,	/*   565: "brdrbar" */
     220L,	/*   566: "dxfrtext" */
     574L,	/*   567: "nolnhtadjtbl" */
     585L,	/*   568: "fracwidth" */
     752L,	/*   569: "softlheight" */
     712L,	/*   570: "bliptag" */
     227L,	/*   571: "pnrnot" */
      35L,	/*   572: "pniroha" */
     128L,	/*   573: "keep" */
     757L,	/*   574: "tab" */
     595L,	/*   575: "margmirror" */
     814L,	/*   576: "dplinegray" */
     530L,	/*   577: "aendnotes" */
     728L,	/*   578: "objocx" */
      64L,	/*   579: "ulnone" */
      18L,	/*   580: "pni" */
     836L,	/*   581: "shpbymargin" */
     245L,	/*   582: "aoutl" */
     137L,	/*   583: "intbl" */
     659L,	/*   584: "levelspace" */
      24L,	/*   585: "pndec" */
      75L,	/*   586: "revauthdel" */
     556L,	/*   587: "snext" */
     750L,	/*   588: "rtlmark" */
     221L,	/*   589: "dfrmtxtx" */
     409L,	/*   590: "pgbrdrhead" */
     152L,	/*   591: "cbpat" */
     764L,	/*   592: "chdate" */
     231L,	/*   593: "pnrstart" */
      81L,	/*   594: "shad" */
     785L,	/*   595: "dptxbx" */
     718L,	/*   596: "rsltpict" */
      46L,	/*   597: "pngbnuml" */
      50L,	/*   598: "pnzodiacl" */
     439L,	/*   599: "noultrlspc" */
     398L,	/*   600: "pgnstart" */
     708L,	/*   601: "piccropl" */
     261L,	/*   602: "celld" */
     406L,	/*   603: "pgbrdrb" */
     716L,	/*   604: "rsltrtf" */
     473L,	/*   605: "colw" */
     436L,	/*   606: "doctype" */
     561L,	/*   607: "ssemihidden" */
     200L,	/*   608: "phpg" */
     184L,	/*   609: "tposyc" */
     631L,	/*   610: "min" */
     547L,	/*   611: "aftnnar" */
     367L,	/*   612: "tbllkhdrrows" */
     474L,	/*   613: "sectdefaultcl" */
     813L,	/*   614: "dplinecob" */
     104L,	/*   615: "chbgdkdcross" */
     183L,	/*   616: "tposyb" */
     565L,	/*   617: "pc" */
      55L,	/*   618: "pnbidib" */
      69L,	/*   619: "deleted" */
     543L,	/*   620: "ftnnauc" */
     303L,	/*   621: "clpadr" */
      12L,	/*   622: "scaps" */
     181L,	/*   623: "tposy" */
     316L,	/*   624: "trql" */
     341L,	/*   625: "trpaddft" */
     109L,	/*   626: "faauto" */
     361L,	/*   627: "trshdng" */
     207L,	/*   628: "posxi" */
     743L,	/*   629: "endash" */
     384L,	/*   630: "widowctrl" */
     415L,	/*   631: "ftnlytwnine" */
      29L,	/*   632: "pnord" */
     808L,	/*   633: "dptxbxmar" */
     767L,	/*   634: "chftn" */
     756L,	/*   635: "zwnj" */
      58L,	/*   636: "pnqr" */
     578L,	/*   637: "cvmme" */
     484L,	/*   638: "colno" */
     352L,	/*   639: "trbgdkdcross" */
     193L,	/*   640: "absw" */
     394L,	/*   641: "dgvorigin" */
     252L,	/*   642: "aulnone" */
     711L,	/*   643: "picscaled" */
     522L,	/*   644: "saftnnrlc" */
     327L,	/*   645: "trspdl" */
     515L,	/*   646: "sftnnauc" */
     504L,	/*   647: "sftntj" */
     157L,	/*   648: "box" */
     596L,	/*   649: "nocolbal" */
      66L,	/*   650: "cgrid" */
     788L,	/*   651: "dplinedash" */
      49L,	/*   652: "pnzodiacd" */
       9L,	/*   653: "super" */
     351L,	/*   654: "trbgdkcross" */
      67L,	/*   655: "cb" */
     571L,	/*   656: "langnp" */
     217L,	/*   657: "posyin" */
      52L,	/*   658: "pnaiueo" */
      25L,	/*   659: "pnucrm" */
     198L,	/*   660: "absnoovrlp" */
      60L,	/*   661: "pnsp" */
     766L,	/*   662: "chtime" */
      30L,	/*   663: "pncard" */
     741L,	/*   664: "emdash" */
      28L,	/*   665: "pnlcltr" */
     344L,	/*   666: "trwWidthA" */
     426L,	/*   667: "pgbrdrsnap" */
     435L,	/*   668: "nojkernpunct" */
     623L,	/*   669: "uc" */
     748L,	/*   670: "rdblquote" */
     479L,	/*   671: "pgnhnsm" */
     103L,	/*   672: "chbgdkcross" */
     105L,	/*   673: "chbrdr" */
     478L,	/*   674: "pgnhnsc" */
     636L,	/*   675: "insrsid" */
     648L,	/*   676: "leveljc" */
     710L,	/*   677: "defshp" */
     188L,	/*   678: "tposyt" */
     789L,	/*   679: "dplinedot" */
     223L,	/*   680: "dropcapli" */
     239L,	/*   681: "adn" */
     802L,	/*   682: "dparcflipy" */
      62L,	/*   683: "lang" */
     576L,	/*   684: "annotprot" */
     308L,	/*   685: "trowd" */
     233L,	/*   686: "pnrxst" */
      92L,	/*   687: "highlight" */
     375L,	/*   688: "trauth" */
     333L,	/*   689: "trspdft" */
      73L,	/*   690: "crauth" */
     545L,	/*   691: "ftnnruc" */
     560L,	/*   692: "slocked" */
     383L,	/*   693: "facingp" */
      87L,	/*   694: "webhidden" */
     312L,	/*   695: "trhdr" */
     617L,	/*   696: "viewkind" */
     414L,	/*   697: "splytwnine" */
     370L,	/*   698: "tbllklastcol" */
     178L,	/*   699: "tpvmrg" */
     364L,	/*   700: "tbllkfont" */
     529L,	/*   701: "ftnbj" */
     448L,	/*   702: "footery" */
     737L,	/*   703: "objsetsize" */
     705L,	/*   704: "picscaley" */
     191L,	/*   705: "tdfrmtxtTop" */
      59L,	/*   706: "pnindent" */
     809L,	/*   707: "dplinew" */
     792L,	/*   708: "dpaendhol" */
     801L,	/*   709: "dparcflipx" */
     482L,	/*   710: "pgny" */
     116L,	/*   711: "s" */
     346L,	/*   712: "trftsWidthA" */
     777L,	/*   713: "dobymargin" */
     464L,	/*   714: "pgnucrm" */
     156L,	/*   715: "brdrr" */
     463L,	/*   716: "pgndec" */
     215L,	/*   717: "posyc" */
      79L,	/*   718: "rtlch" */
     263L,	/*   719: "clbrdrb" */
     828L,	/*   720: "shpright" */
     773L,	/*   721: "dobxcolumn" */
     433L,	/*   722: "nogrowautofit" */
     774L,	/*   723: "dobxmargin" */
     746L,	/*   724: "lquote" */
     684L,	/*   725: "fdecor" */
     174L,	/*   726: "tposxr" */
     762L,	/*   727: "chftnsep" */
     587L,	/*   728: "hyphcaps" */
     380L,	/*   729: "paperh" */
     300L,	/*   730: "clpadt" */
     573L,	/*   731: "langfenp" */
     678L,	/*   732: "jclisttab" */
      65L,	/*   733: "up" */
     255L,	/*   734: "loch" */
     677L,	/*   735: "tleq" */
     280L,	/*   736: "clshdng" */
     724L,	/*   737: "objsub" */
     586L,	/*   738: "hyphauto" */
      20L,	/*   739: "pncaps" */
      94L,	/*   740: "chbgvert" */
     833L,	/*   741: "shpbxpage" */
     670L,	/*   742: "tqr" */
      33L,	/*   743: "pndbnumd" */
     182L,	/*   744: "tposnegy" */
      57L,	/*   745: "pnqc" */
     262L,	/*   746: "clbrdrt" */
     643L,	/*   747: "styrsid" */
     695L,	/*   748: "wbitmap" */
      26L,	/*   749: "pnlcrm" */
     449L,	/*   750: "pgwsxn" */
      56L,	/*   751: "pnql" */
     145L,	/*   752: "bgdkfdiag" */
     259L,	/*   753: "rtlrow" */
     725L,	/*   754: "objpub" */
     680L,	/*   755: "froman" */
      39L,	/*   756: "pncnum" */
      85L,	/*   757: "ulw" */
      23L,	/*   758: "pnstart" */
      14L,	/*   759: "pnf" */
     475L,	/*   760: "pgnhn" */
      32L,	/*   761: "pndbnum" */
     661L,	/*   762: "listtemplateid" */
     589L,	/*   763: "hyphhotz" */
     212L,	/*   764: "posy" */
     508L,	/*   765: "sftnrstpg" */
     815L,	/*   766: "dpfillfgcr" */
      90L,	/*   767: "expndtw" */
     179L,	/*   768: "tpvpara" */
     688L,	/*   769: "fprq" */
     552L,	/*   770: "aftnnchi" */
     420L,	/*   771: "lyttblrtgr" */
     320L,	/*   772: "trbrdrb" */
     734L,	/*   773: "objcropb" */
     627L,	/*   774: "rtlpar" */
     250L,	/*   775: "auld" */
     816L,	/*   776: "dpfillfgcg" */
     192L,	/*   777: "tdfrmtxtBottom" */
     331L,	/*   778: "trspdfl" */
     235L,	/*   779: "tb" */
     604L,	/*   780: "revisions" */
     618L,	/*   781: "viewscale" */
     810L,	/*   782: "dppolycount" */
     613L,	/*   783: "transmf" */
     379L,	/*   784: "margb" */
     228L,	/*   785: "pnrnfc" */
     374L,	/*   786: "lastrow" */
     251L,	/*   787: "auldb" */
      91L,	/*   788: "charscalex" */
     386L,	/*   789: "doctemp" */
     822L,	/*   790: "dpfillbggray" */
     339L,	/*   791: "trpaddfl" */
     224L,	/*   792: "dropcapt" */
     729L,	/*   793: "objw" */
     123L,	/*   794: "qj" */
     419L,	/*   795: "lytcalctblwd" */
     535L,	/*   796: "aftnstart" */
      88L,	/*   797: "kerning" */
     286L,	/*   798: "clvertalb" */
     283L,	/*   799: "clshdngraw" */
     641L,	/*   800: "pararsid" */
     841L,	/*   801: "shpwrk" */
     219L,	/*   802: "posyt" */
     501L,	/*   803: "ltrsect" */
     782L,	/*   804: "dppolygon" */
     733L,	/*   805: "objcropt" */
     579L,	/*   806: "defformat" */
     768L,	/*   807: "sectnum" */
     392L,	/*   808: "dgvspace" */
     564L,	/*   809: "mac" */
     271L,	/*   810: "clbgdkdcross" */
     321L,	/*   811: "trbrdrl" */
     577L,	/*   812: "brkfrm" */
     632L,	/*   813: "sec" */
     164L,	/*   814: "nooverflow" */
     551L,	/*   815: "aftnnruc" */
       8L,	/*   816: "sub" */
       2L,	/*   817: "fs" */
     130L,	/*   818: "sb" */
     658L,	/*   819: "levelindent" */
     603L,	/*   820: "revbar" */
     633L,	/*   821: "dy" */
     257L,	/*   822: "dbch" */
     376L,	/*   823: "margl" */
      45L,	/*   824: "pngbnumd" */
     668L,	/*   825: "listoverrideformat" */
     140L,	/*   826: "bgcross" */
     798L,	/*   827: "dpaendw" */
     669L,	/*   828: "tql" */
     299L,	/*   829: "clftsWidth" */
     172L,	/*   830: "tposnegx" */
     480L,	/*   831: "pgnhnsn" */
     533L,	/*   832: "aftnbj" */
     165L,	/*   833: "aspalpha" */
     784L,	/*   834: "dprect" */
     112L,	/*   835: "faroman" */
     642L,	/*   836: "tblrsid" */
     693L,	/*   837: "emfblip" */
     264L,	/*   838: "clbrdrl" */
     307L,	/*   839: "clpadfr" */
      78L,	/*   840: "revised" */
     404L,	/*   841: "stshfbi" */
     685L,	/*   842: "ftech" */
     269L,	/*   843: "clbgdkbdiag" */
    };

/* The hash function */

unsigned long docRtfTagHash(const unsigned char * key, int len )
{
    const ub4 initlev= 0x8bc994ff;
    ub4 rsl= 0;
    ub4 val = utilJenkinsHash( key, len, initlev );
    rsl = ((val>>24)^tab[val&0xff]);
    return rsl;
}

int docRtfTagIndex( const unsigned char * key, int len )
{
    ub4 rsl= docRtfTagHash( key, len );

    if  ( rsl >= sizeof(mapBack)/sizeof(int) )
	{ return -1;	}

    return mapBack[rsl];
}

