#   include	"config.h"

#   include	"bmintern.h"
#   include	<string.h>

#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	<appDebugon.h>

/************************************************************************/
/*  Apply convolution filters to an image.				*/
/************************************************************************/
typedef void (*BM_FILTER_3x3)(	unsigned char *		to,
				const unsigned char *	prevRow,
				const unsigned char *	thisRow,
				const unsigned char *	nextRow,
				int			wide );

/************************************************************************/
/*									*/
/*  Fill a row from the image.						*/
/*									*/
/************************************************************************/

static void bmFilterFillRowGray8(	unsigned char *		to,
					const unsigned char *	from,
					int			wide )
    {
    to[-1]= from[0]; to[wide]= from[wide-1];
    memcpy( to, from, wide );
    }

static void bmFilterFillRowRgb24(	unsigned char *		to,
					const unsigned char *	from,
					int			w )
    {
    to[-3]= from[0]; to[-2]= from[1]; to[-1]= from[2];
    to[3*w+0]= from[3*w-3]; to[3*w+1]= from[3*w-2]; to[3*w+2]= from[3*w-1];

    memcpy( to, from, 3*w );
    }

/************************************************************************/
/*									*/
/*  Apply a sharpening filter.						*/
/*									*/
/************************************************************************/

static void bmLaplaceGray8(	unsigned char *		to,
				const unsigned char *	prevRow,
				const unsigned char *	thisRow,
				const unsigned char *	nextRow,
				int			wide )
    {
    int		i;

    for ( i= 0; i < wide; i++ )
	{
	int	val= 0;

	val += -1* (int)prevRow[-1]+ -1* (int)prevRow[0]+ -1* (int)prevRow[1];
	val += -1* (int)thisRow[-1]+  8* (int)thisRow[0]+ -1* (int)thisRow[1];
	val += -1* (int)nextRow[-1]+ -1* (int)nextRow[0]+ -1* (int)nextRow[1];

	if  ( val < 0 )		{ val= 0;	}
	if  ( val > 255 )	{ val= 255;	}

	*(to++)= val; prevRow++; thisRow++; nextRow++;
	}
    }

static void bmLaplaceRgb24(	unsigned char *		to,
				const unsigned char *	prevRow,
				const unsigned char *	thisRow,
				const unsigned char *	nextRow,
				int			wide )
    {
    int		i;

    for ( i= 0; i < 3* wide; i++ )
	{
	int	val= 0;

	val += -1* (int)prevRow[-3]+ -1* (int)prevRow[0]+ -1* (int)prevRow[3];
	val += -1* (int)thisRow[-3]+  8* (int)thisRow[0]+ -1* (int)thisRow[3];
	val += -1* (int)nextRow[-3]+ -1* (int)nextRow[0]+ -1* (int)nextRow[3];

	if  ( val < 0 )		{ val= 0;	}
	if  ( val > 255 )	{ val= 255;	}

	*(to++)= val; prevRow++; thisRow++; nextRow++;
	}
    }

/************************************************************************/
/*  Apply a smoothing filter.						*/
/************************************************************************/

static void bmSmootheGray8(	unsigned char *		to,
				const unsigned char *	prevRow,
				const unsigned char *	thisRow,
				const unsigned char *	nextRow,
				int			wide )
    {
    int		i;

    for ( i= 0; i < wide; i++ )
	{
	int	val= 0;

	val +=  1* (int)prevRow[-1]+  1* (int)prevRow[0]+  1* (int)prevRow[1];
	val +=  1* (int)thisRow[-1]+  1* (int)thisRow[0]+  1* (int)thisRow[1];
	val +=  1* (int)nextRow[-1]+  1* (int)nextRow[0]+  1* (int)nextRow[1];

	val= ( val+ 4 )/ 9;

	if  ( val < 0 )		{ val= 0;	}
	if  ( val > 255 )	{ val= 255;	}

	*(to++)= val; prevRow++; thisRow++; nextRow++;
	}
    }


static void bmSmootheRgb24(	unsigned char *		to,
				const unsigned char *	prevRow,
				const unsigned char *	thisRow,
				const unsigned char *	nextRow,
				int			wide )
    {
    int		i;

    for ( i= 0; i < 3* wide; i++ )
	{
	int	val= 0;

	val +=  1* (int)prevRow[-3]+  1* (int)prevRow[0]+  1* (int)prevRow[3];
	val +=  1* (int)thisRow[-3]+  1* (int)thisRow[0]+  1* (int)thisRow[3];
	val +=  1* (int)nextRow[-3]+  1* (int)nextRow[0]+  1* (int)nextRow[3];

	val= ( val+ 4 )/ 9;

	if  ( val < 0 )		{ val= 0;	}
	if  ( val > 255 )	{ val= 255;	}

	*(to++)= val; prevRow++; thisRow++; nextRow++;
	}
    }

/************************************************************************/
/*  Apply the Sobel filter.						*/
/************************************************************************/

static void bmSobelGray8(	unsigned char *		to,
				const unsigned char *	prevRow,
				const unsigned char *	thisRow,
				const unsigned char *	nextRow,
				int			wide )
    {
    int		i;

    for ( i= 0; i < wide; i++ )
	{
	int	valh= 0;
	int	valv= 0;

	int	val;

	valh += -1* (int)prevRow[-1]+  0* (int)prevRow[0]+  1* (int)prevRow[1];
	valh += -2* (int)thisRow[-1]+  0* (int)thisRow[0]+  2* (int)thisRow[1];
	valh += -1* (int)nextRow[-1]+  0* (int)nextRow[0]+  1* (int)nextRow[1];

	valv += -1* (int)prevRow[-1]+ -2* (int)prevRow[0]+ -1* (int)prevRow[1];
	valv +=  0* (int)thisRow[-1]+  0* (int)thisRow[0]+  0* (int)thisRow[1];
	valv +=  1* (int)nextRow[-1]+  2* (int)nextRow[0]+  1* (int)nextRow[1];

	/*
	val= sqrt( valh*valh+ valv*valv );
	*/
	if  ( valh < 0 )	{ valh= -valh;	}
	if  ( valv < 0 )	{ valv= -valv;	}

	val= ( valh+ valv )/ 2;

	*(to++)= val; prevRow++; thisRow++; nextRow++;
	}
    }


static void bmSobelRgb24(	unsigned char *		to,
				const unsigned char *	prevRow,
				const unsigned char *	thisRow,
				const unsigned char *	nextRow,
				int			wide )
    {
    int		i;

    for ( i= 0; i < 3* wide; i++ )
	{
	int	valh= 0;
	int	valv= 0;

	int	val;

	valh += -1* (int)prevRow[-3]+  0* (int)prevRow[0]+  1* (int)prevRow[3];
	valh += -2* (int)thisRow[-3]+  0* (int)thisRow[0]+  2* (int)thisRow[3];
	valh += -1* (int)nextRow[-3]+  0* (int)nextRow[0]+  1* (int)nextRow[3];

	valv += -1* (int)prevRow[-3]+ -2* (int)prevRow[0]+ -1* (int)prevRow[3];
	valv +=  0* (int)thisRow[-3]+  0* (int)thisRow[0]+  0* (int)thisRow[3];
	valv +=  1* (int)nextRow[-3]+  2* (int)nextRow[0]+  1* (int)nextRow[3];

	/*
	val= sqrt( valh*valh+ valv*valv );
	*/
	if  ( valh < 0 )	{ valh= -valh;	}
	if  ( valv < 0 )	{ valv= -valv;	}

	val= ( valh+ valv )/ 2;

	*(to++)= val; prevRow++; thisRow++; nextRow++;
	}
    }

/************************************************************************/
/*									*/
/*  Apply a 3x3 filter to the image.					*/
/*									*/
/************************************************************************/

static int bmFilter3x3Gray8(	BitmapDescription *		bdOut,
				const BitmapDescription *	bdIn,
				unsigned char **		pBufOut,
				const unsigned char *		bufIn,
				BM_FILTER_3x3			how )
    {
    unsigned char *		to;
    const unsigned char *	from;
    int				row;
    unsigned char * 		bufOut;

    unsigned char * 		prevRow;
    unsigned char * 		thisRow;
    unsigned char * 		nextRow;

    bufOut= malloc( bdIn->bdBufferLength );
    prevRow= malloc( bdIn->bdBytesPerRow+ 2 );
    thisRow= malloc( bdIn->bdBytesPerRow+ 2 );
    nextRow= malloc( bdIn->bdBytesPerRow+ 2 );
    if  ( ! bufOut || ! prevRow || ! thisRow || ! nextRow )
	{
	LLDEB(bdIn->bdBufferLength,bdIn->bdPixelsWide);
	if  ( bufOut )	{ free( bufOut );	}
	if  ( prevRow )	{ free( prevRow );	}
	if  ( thisRow )	{ free( thisRow );	}
	if  ( nextRow )	{ free( nextRow );	}
	return -1;
	}

    row= 0; from= bufIn+ ( row+ 1 )* bdIn->bdBytesPerRow;
    bmFilterFillRowGray8( prevRow+ 1, bufIn, bdIn->bdPixelsWide );
    bmFilterFillRowGray8( thisRow+ 1, bufIn, bdIn->bdPixelsWide );
    bmFilterFillRowGray8( nextRow+ 1, from, bdIn->bdPixelsWide );

    for ( row= 0; row < bdIn->bdPixelsHigh- 1; row++ )
	{
	to= bufOut+ row* bdIn->bdBytesPerRow;
	from= bufIn+ ( row+ 1 )* bdIn->bdBytesPerRow;

	(*how)( to, prevRow+ 1, thisRow+ 1, nextRow+ 1, bdIn->bdPixelsWide );

	to= prevRow; prevRow= thisRow; thisRow= nextRow; nextRow= to;
	bmFilterFillRowGray8( nextRow+ 1, from, bdIn->bdPixelsWide );
	}

    to= bufOut+ row* bdIn->bdBytesPerRow;
    (*how)( to, prevRow+ 1, thisRow+ 1, nextRow+ 1, bdIn->bdPixelsWide );

    bmCopyDescription( bdOut, bdIn ); *pBufOut= bufOut;

    free( prevRow ); free( thisRow ); free( nextRow );

    return 0;
    }

static int bmFilter3x3Gray_x_8(	BitmapDescription *		bdOut,
				const BitmapDescription *	bdIn,
				unsigned char **		pBufOut,
				const unsigned char *		bufIn,
				BM_FILTER_3x3			how )
    {
    unsigned char *		to;
    const unsigned char *	from;
    int				row;
    unsigned char * 		bufOut;

    unsigned char * 		prevRow;
    unsigned char * 		thisRow;
    unsigned char * 		nextRow;

    BitmapDescription		bd;
    unsigned char *		line;

    bmInitDescription( &bd );
    bmCopyDescription( &bd, bdIn );

    bd.bdBitsPerPixel= 8;
    bd.bdBytesPerRow= bd.bdPixelsWide;
    bd.bdBufferLength= bd.bdPixelsHigh* bd.bdBytesPerRow;

    bufOut= malloc( bd.bdBufferLength );
    prevRow= malloc( bd.bdBytesPerRow+ 2 );
    thisRow= malloc( bd.bdBytesPerRow+ 2 );
    nextRow= malloc( bd.bdBytesPerRow+ 2 );
    line= malloc( bd.bdBytesPerRow+ 7 );
    if  ( ! bufOut || ! prevRow || ! thisRow || ! nextRow || ! line )
	{
	LLDEB(bd.bdBufferLength,bd.bdPixelsWide);
	if  ( bufOut )	{ free( bufOut );	}
	if  ( prevRow )	{ free( prevRow );	}
	if  ( thisRow )	{ free( thisRow );	}
	if  ( nextRow )	{ free( nextRow );	}
	if  ( line )	{ free( line );		}
	return -1;
	}

    row= 0;
    bmInflateTo8bitGray( line, bufIn, bdIn );
    bmFilterFillRowGray8( prevRow+ 1, line, bd.bdPixelsWide );
    bmFilterFillRowGray8( thisRow+ 1, line, bd.bdPixelsWide );

    from= bufIn+ ( row+ 1 )* bdIn->bdBytesPerRow;
    bmInflateTo8bitGray( line, from, bdIn );
    bmFilterFillRowGray8( nextRow+ 1, line, bd.bdPixelsWide );

    for ( row= 0; row < bd.bdPixelsHigh- 1; row++ )
	{
	to= bufOut+ row* bd.bdBytesPerRow;
	from= bufIn+ ( row+ 1 )* bdIn->bdBytesPerRow;

	(*how)( to, prevRow+ 1, thisRow+ 1, nextRow+ 1, bd.bdPixelsWide );

	to= prevRow; prevRow= thisRow; thisRow= nextRow; nextRow= to;
	bmInflateTo8bitGray( line, from, bdIn );
	bmFilterFillRowGray8( nextRow+ 1, line, bd.bdPixelsWide );
	}

    to= bufOut+ row* bd.bdBytesPerRow;
    (*how)( to, prevRow+ 1, thisRow+ 1, nextRow+ 1, bd.bdPixelsWide );

    bmCopyDescription( bdOut, &bd ); *pBufOut= bufOut;

    free( prevRow ); free( thisRow ); free( nextRow ); free( line );

    return 0;
    }

static int bmFilter3x3Rgb24(	BitmapDescription *		bdOut,
				const BitmapDescription *	bdIn,
				unsigned char **		pBufOut,
				const unsigned char *		bufIn,
				BM_FILTER_3x3			how )
    {
    unsigned char *		to;
    const unsigned char *	from;
    int				row;
    unsigned char * 		bufOut;

    unsigned char * 		prevRow;
    unsigned char * 		thisRow;
    unsigned char * 		nextRow;

    bufOut= malloc( bdIn->bdBufferLength );
    prevRow= malloc( bdIn->bdBytesPerRow+ 6 );
    thisRow= malloc( bdIn->bdBytesPerRow+ 6 );
    nextRow= malloc( bdIn->bdBytesPerRow+ 6 );
    if  ( ! bufOut || ! prevRow || ! thisRow || ! nextRow )
	{
	LLDEB(bdIn->bdBufferLength,bdIn->bdPixelsWide);
	if  ( bufOut )	{ free( bufOut );	}
	if  ( prevRow )	{ free( prevRow );	}
	if  ( thisRow )	{ free( thisRow );	}
	if  ( nextRow )	{ free( nextRow );	}
	return -1;
	}

    row= 0; from= bufIn+ ( row+ 1 )* bdIn->bdBytesPerRow;
    bmFilterFillRowRgb24( prevRow+ 3, bufIn, bdIn->bdPixelsWide );
    bmFilterFillRowRgb24( thisRow+ 3, bufIn, bdIn->bdPixelsWide );
    bmFilterFillRowRgb24( nextRow+ 3, from, bdIn->bdPixelsWide );

    for ( row= 0; row < bdIn->bdPixelsHigh- 1; row++ )
	{
	to= bufOut+ row* bdIn->bdBytesPerRow;
	from= bufIn+ ( row+ 1 )* bdIn->bdBytesPerRow;

	(*how)( to, prevRow+ 3, thisRow+ 3, nextRow+ 3, bdIn->bdPixelsWide );

	to= prevRow; prevRow= thisRow; thisRow= nextRow; nextRow= to;
	bmFilterFillRowRgb24( nextRow+ 3, from, bdIn->bdPixelsWide );
	}

    to= bufOut+ row* bdIn->bdBytesPerRow;
    (*how)( to, prevRow+ 3, thisRow+ 3, nextRow+ 3, bdIn->bdPixelsWide );

    bmCopyDescription( bdOut, bdIn ); *pBufOut= bufOut;

    free( prevRow ); free( thisRow ); free( nextRow );

    return 0;
    }

int bmFilterSobel(	BitmapDescription *		bdOut,
			const BitmapDescription *	bdIn,
			unsigned char **		pBufOut,
			const unsigned char *		bufIn,
			int				ignoredInt	)
    {
    if  ( bdIn->bdColorEncoding == BMcoBLACKWHITE	||
	  bdIn->bdColorEncoding == BMcoWHITEBLACK	)
	{
	if  ( bdIn->bdBitsPerPixel == 8 )
	    {
	    if  ( bmFilter3x3Gray8( bdOut, bdIn, pBufOut, bufIn,
							    bmSobelGray8 ) )
		{ LDEB(1); return -1;	}

	    return 0;
	    }
	else{
	    if  ( bmFilter3x3Gray_x_8( bdOut, bdIn, pBufOut, bufIn,
							    bmSobelGray8 ) )
		{ LDEB(1); return -1;	}

	    return 0;
	    }
	}

    if  ( bdIn->bdColorEncoding == BMcoRGB )
	{
	if  ( bdIn->bdBitsPerPixel == 24 )
	    {
	    if  ( bmFilter3x3Rgb24( bdOut, bdIn, pBufOut, bufIn,
							    bmSobelRgb24 ) )
		{ LDEB(1); return -1;	}

	    return 0;
	    }
	}

    LLDEB(bdIn->bdColorEncoding,bdIn->bdBitsPerPixel); return -1;
    }

int bmFilterLaplace(	BitmapDescription *		bdOut,
			const BitmapDescription *	bdIn,
			unsigned char **		pBufOut,
			const unsigned char *		bufIn,
			int				ignoredInt	)
    {
    if  ( bdIn->bdColorEncoding == BMcoBLACKWHITE	||
	  bdIn->bdColorEncoding == BMcoWHITEBLACK	)
	{
	if  ( bdIn->bdBitsPerPixel == 8 )
	    {
	    if  ( bmFilter3x3Gray8( bdOut, bdIn, pBufOut, bufIn,
							    bmLaplaceGray8 ) )
		{ LDEB(1); return -1;	}

	    return 0;
	    }
	else{
	    if  ( bmFilter3x3Gray_x_8( bdOut, bdIn, pBufOut, bufIn,
							    bmLaplaceGray8 ) )
		{ LDEB(1); return -1;	}

	    return 0;
	    }
	}

    if  ( bdIn->bdColorEncoding == BMcoRGB )
	{
	if  ( bdIn->bdBitsPerPixel == 24 )
	    {
	    if  ( bmFilter3x3Rgb24( bdOut, bdIn, pBufOut, bufIn,
							    bmLaplaceRgb24 ) )
		{ LDEB(1); return -1;	}

	    return 0;
	    }

	LLDEB(bdIn->bdColorEncoding,bdIn->bdBitsPerPixel); return -1;
	}

    LLDEB(bdIn->bdColorEncoding,bdIn->bdBitsPerPixel); return -1;
    }

int bmFilterSmoothe(	BitmapDescription *		bdOut,
			const BitmapDescription *	bdIn,
			unsigned char **		pBufOut,
			const unsigned char *		bufIn,
			int				ignoredInt	)
    {
    if  ( bdIn->bdColorEncoding == BMcoBLACKWHITE	||
	  bdIn->bdColorEncoding == BMcoWHITEBLACK	)
	{
	if  ( bdIn->bdBitsPerPixel == 8 )
	    {
	    if  ( bmFilter3x3Gray8( bdOut, bdIn, pBufOut, bufIn,
							    bmSmootheGray8 ) )
		{ LDEB(1); return -1;	}

	    return 0;
	    }
	else{
	    if  ( bmFilter3x3Gray_x_8( bdOut, bdIn, pBufOut, bufIn,
							    bmSmootheGray8 ) )
		{ LDEB(1); return -1;	}

	    return 0;
	    }
	}

    if  ( bdIn->bdColorEncoding == BMcoRGB )
	{
	if  ( bdIn->bdBitsPerPixel == 24 )
	    {
	    if  ( bmFilter3x3Rgb24( bdOut, bdIn, pBufOut, bufIn,
							    bmSmootheRgb24 ) )
		{ LDEB(1); return -1;	}

	    return 0;
	    }

	LLDEB(bdIn->bdColorEncoding,bdIn->bdBitsPerPixel); return -1;
	}

    LLDEB(bdIn->bdColorEncoding,bdIn->bdBitsPerPixel); return -1;
    }
