#ifndef GIF_LIB_PRIVATE_H
#define GIF_LIB_PRIVATE_H

#include <sioGeneral.h>
#include "bm_gif_lib.h"

#define PROGRAM_NAME	"GIFLIB"

#define FILE_STATE_WRITE    0x01
#define FILE_STATE_SCREEN   0x02
#define FILE_STATE_IMAGE    0x04
#define FILE_STATE_READ     0x08

#define IS_READABLE(Private)    (Private->FileState & FILE_STATE_READ)
#define IS_WRITEABLE(Private)   (Private->FileState & FILE_STATE_WRITE)

typedef struct GifFilePrivateType {
    int				FileState;
    unsigned long		PixelCount;
				    /* Number of pixels in image.	*/
				    /* Actually those not read/written.	*/

    SimpleOutputStream *	gfptSos;
    SimpleOutputStream *	gfptSosBlocked;
    SimpleOutputStream *	gfptSosLzw;

    SimpleInputStream *		gfptSis;
    SimpleInputStream *		gfptSisBlocked;
    SimpleInputStream *		gfptSisLzw;
} GifFilePrivateType;

extern int _GifError;

#if 0
#ifdef SYSV
static char *VersionStr =
        "Gif library module,\t\tEric S. Raymond\n\
	(C) Copyright 1997 Eric S. Raymond\n";
#else
static char *VersionStr =
	PROGRAM_NAME
	"	IBMPC "
	GIF_LIB_VERSION
	"	Eric S. Raymond,	"
	__DATE__ ",   " __TIME__ "\n"
	"(C) Copyright 1997 Eric S. Raymond\n";
#endif /* SYSV */
#endif

#endif /* GIF_LIB_PRIVATE_H */
