/************************************************************************/
/*									*/
/*  sioSmtp.[ch]:	Send an e-mail message using the SMTP protocol.	*/
/*  Author:		Robert A. Vonk (rvonk@knoware.nl)		*/
/*			( Adapted by Mark de Does to fit in the sio	*/
/*			framework. )					*/
/*									*/
/*									*/
/*  SimpleOutputStream * sioOutSmtpOpen(char *	smtpServer,		*/
/*					char *	From,			*/
/*					char *	To,			*/
/*					char *	Cc,			*/
/*					char *	Bcc,			*/
/*					char *	Subject,		*/
/*					char *	TypeSlashSubtype,	*/
/*					char *	mimeBoundary )		*/
/*	ARGUMENTS:							*/
/*	  smtpServer:	The name of the SMTP server.			*/
/*			DEFAULT: "mailhost".				*/
/*	  From:		The e-mail address of the sender.		*/
/*			DEFAULT: no default, obligatory.		*/
/*	  To:		The e-mail address(es) of the recipient(s).	*/
/*			DEFAULT: no default, obligatory.		*/
/*	  Cc:		The e-mail address(es) of the persons that are	*/
/*			carbon copied.					*/
/*			DEFAULT: none.					*/
/*	  Bcc:		The e-mail address(es) of the persons that are	*/
/*			blind carbon copied (do not appear in mail	*/
/*			headers).					*/
/*			DEFAULT: none.					*/
/*	  Subject:	The subject of the mail message			*/
/*			DEFAULT: none.					*/
/*	  mimeType:	The MIME type of the mail message		*/
/*			DEFAULT: none.					*/
/*	  mimeBoundary:	The MIME sub-type of the mail message		*/
/*			DEFAULT: none.					*/
/*	RETURN VALUES:							*/
/*	  (void *)0:	On failure.					*/
/*	  (void *)ptr:	On success.					*/
/*									*/
/*									*/
/************************************************************************/

#   ifndef	SIO_SMTP_H
#   define	SIO_SMTP_H

#   include     <appSystem.h>
#   include     <sioGeneral.h>

extern SimpleOutputStream * sioOutSmtpOpen(	const char *	relay,
						const char *	from,
						const char *	to,
						const char *	cc,
						const char *	bcc,
						const char *	subject,
						const char *	typeSlashSub,
						const char *	mimeBoundary,
						void *		through,
						APP_COMPLAIN	complain );

extern char * sioSmtpGuessMailAddress( void );

#   endif
