/************************************************************************/
/*									*/
/*  Various definitions relating to document geometry.			*/
/*									*/
/************************************************************************/

#   ifndef	APP_GEO_H
#   define	APP_GEO_H

typedef struct DocumentRectangle
    {
    int		drX0;
    int		drY0;
    int		drX1;
    int		drY1;
    } DocumentRectangle;

typedef struct DocumentGeometry
    {
    int			dgPageWideTwips;
    int			dgPageHighTwips;

    int			dgLeftMarginTwips;
    int			dgTopMarginTwips;
    int			dgRightMarginTwips;
    int			dgBottomMarginTwips;

    int			dgHeaderPositionTwips;
    int			dgFooterPositionTwips;

    int			dgGutterTwips;
    } DocumentGeometry;

/************************************************************************/
/*									*/
/*  Update masks for document geometry.					*/
/*									*/
/*  NOTE: This range is continued in Ted/docBuf.h for the section and	*/
/*	document properties. Adding a bit here may make it necessary to	*/
/*	shift the masks there as well.					*/
/*									*/
/************************************************************************/

typedef enum GeometryProperty
    {
    DGprop_NONE= -1,

    DGpropPAGE_WIDTH= 0,
    DGpropPAGE_HEIGHT,
    DGpropLEFT_MARGIN,
    DGpropRIGHT_MARGIN,
    DGpropTOP_MARGIN,
    DGpropBOTTOM_MARGIN,
    DGpropHEADER_POSITION,
    DGpropFOOTER_POSITION,
    DGpropGUTTER,

    DGprop_COUNT
    } GeometryProperty;

#   define	DGupdNONE		(0)

#   define	DGupdPAGE_SIZE		((1<<DGpropPAGE_WIDTH)		|\
					 (1<<DGpropPAGE_HEIGHT)		)

#   define	DGupdMARGINS		((1<<DGpropLEFT_MARGIN)		|\
					 (1<<DGpropRIGHT_MARGIN)	|\
					 (1<<DGpropTOP_MARGIN)		|\
					 (1<<DGpropBOTTOM_MARGIN)	)

#   define	DGupdHEADFOOT_POSITIONS	((1<<DGpropHEADER_POSITION)	|\
					 (1<<DGpropFOOTER_POSITION)	)

#   define	DGupdALL		(DGupdPAGE_SIZE			|\
					 DGupdMARGINS			|\
					 DGupdHEADFOOT_POSITIONS	|\
					 (1<<DGpropGUTTER)		)

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitRectangle(	DocumentRectangle *		dr );

extern void docUnionRectangle(	DocumentRectangle *		dr,
				const DocumentRectangle *	dr1,
				const DocumentRectangle *	dr2	);

extern int docIntersectRectangle(	DocumentRectangle *		dr,
					const DocumentRectangle *	dr1,
					const DocumentRectangle *	dr2 );

extern void appInitDocumentGeometry(	DocumentGeometry *	dg );

extern void appSetDocumentGeometry(	DocumentGeometry *		dgTo,
					const DocumentGeometry *	dgFrom,
					unsigned int *			pCh,
					unsigned int			msk );

#   endif
