#   include	"config.h"
#   include	"appGeo.h"
#   include	"utilPropMask.h"

void docInitRectangle(	DocumentRectangle *		dr )
    { dr->drX0= dr->drY0= dr->drX1= dr->drY1= 0; return; }

void docUnionRectangle(	DocumentRectangle *		dr,
			const DocumentRectangle *	dr1,
			const DocumentRectangle *	dr2 )
    {
    if  ( dr1->drX0 < dr2->drX0 )
	{ dr->drX0= dr1->drX0;	}
    else{ dr->drX0= dr2->drX0;	}

    if  ( dr1->drY0 < dr2->drY0 )
	{ dr->drY0= dr1->drY0;	}
    else{ dr->drY0= dr2->drY0;	}

    if  ( dr1->drX1 < dr2->drX1 )
	{ dr->drX1= dr2->drX1;	}
    else{ dr->drX1= dr1->drX1;	}

    if  ( dr1->drY1 < dr2->drY1 )
	{ dr->drY1= dr2->drY1;	}
    else{ dr->drY1= dr1->drY1;	}
    }

int docIntersectRectangle(	DocumentRectangle *		dr,
				const DocumentRectangle *	dr1,
				const DocumentRectangle *	dr2 )
    {
    DocumentRectangle	res= *dr1;

    if  ( dr1->drX1 < dr2->drX0 )
	{ return 0;	}

    if  ( dr2->drX1 < dr1->drX0 )
	{ return 0;	}

    if  ( dr1->drY1 < dr2->drY0 )
	{ return 0;	}

    if  ( dr2->drY1 < dr1->drY0 )
	{ return 0;	}

    if  ( ! dr )
	{ return 1;	}

    if  ( dr1->drX0 < dr2->drX0 )
	{ res.drX0= dr2->drX0;	}
    else{ res.drX0= dr1->drX0;	}

    if  ( dr1->drY0 < dr2->drY0 )
	{ res.drY0= dr2->drY0;	}
    else{ res.drY0= dr1->drY0;	}

    if  ( dr1->drX1 < dr2->drX1 )
	{ res.drX1= dr1->drX1;	}
    else{ res.drX1= dr2->drX1;	}

    if  ( dr1->drY1 < dr2->drY1 )
	{ res.drY1= dr1->drY1;	}
    else{ res.drY1= dr2->drY1;	}

    *dr= res; return 1;
    }

void appInitDocumentGeometry(	DocumentGeometry *	dg )
    {
    dg->dgPageWideTwips= 12240;
    dg->dgPageHighTwips= 15840;

    dg->dgLeftMarginTwips= 1800;
    dg->dgTopMarginTwips= 1440;
    dg->dgRightMarginTwips= 1800;
    dg->dgBottomMarginTwips= 1440;

    dg->dgHeaderPositionTwips= 720;
    dg->dgFooterPositionTwips= 720;

    dg->dgGutterTwips= 0;
    }

/************************************************************************/
/*									*/
/*  Copy a document Geometry.						*/
/*									*/
/************************************************************************/

void appSetDocumentGeometry(	DocumentGeometry *		dgTo,
				const DocumentGeometry *	dgFr,
				unsigned int *			pChanged,
				unsigned int			updMask )
    {
    unsigned int		changedMask= 0;

    if  ( PROPmaskISSET( updMask, DGpropPAGE_WIDTH ) )
	{
	if  ( dgTo->dgPageWideTwips != dgFr->dgPageWideTwips )
	    {
	    dgTo->dgPageWideTwips= dgFr->dgPageWideTwips;
	    PROPmaskADD( &changedMask, DGpropPAGE_WIDTH );
	    }
	}

    if  ( PROPmaskISSET( updMask, DGpropPAGE_HEIGHT ) )
	{
	if  ( dgTo->dgPageHighTwips != dgFr->dgPageHighTwips )
	    {
	    dgTo->dgPageHighTwips= dgFr->dgPageHighTwips;
	    PROPmaskADD( &changedMask, DGpropPAGE_HEIGHT );
	    }
	}
    if  ( PROPmaskISSET( updMask, DGpropLEFT_MARGIN ) )
	{
	if  ( dgTo->dgLeftMarginTwips != dgFr->dgLeftMarginTwips )
	    {
	    dgTo->dgLeftMarginTwips= dgFr->dgLeftMarginTwips;
	    PROPmaskADD( &changedMask, DGpropLEFT_MARGIN );
	    }
	}
    if  ( PROPmaskISSET( updMask, DGpropRIGHT_MARGIN ) )
	{
	if  ( dgTo->dgRightMarginTwips != dgFr->dgRightMarginTwips )
	    {
	    dgTo->dgRightMarginTwips= dgFr->dgRightMarginTwips;
	    PROPmaskADD( &changedMask, DGpropRIGHT_MARGIN );
	    }
	}
    if  ( PROPmaskISSET( updMask, DGpropTOP_MARGIN ) )
	{
	if  ( dgTo->dgTopMarginTwips != dgFr->dgTopMarginTwips )
	    {
	    dgTo->dgTopMarginTwips= dgFr->dgTopMarginTwips;
	    PROPmaskADD( &changedMask, DGpropTOP_MARGIN );
	    }
	}
    if  ( PROPmaskISSET( updMask, DGpropBOTTOM_MARGIN ) )
	{
	if  ( dgTo->dgBottomMarginTwips != dgFr->dgBottomMarginTwips )
	    {
	    dgTo->dgBottomMarginTwips= dgFr->dgBottomMarginTwips;
	    PROPmaskADD( &changedMask, DGpropBOTTOM_MARGIN );
	    }
	}
    if  ( PROPmaskISSET( updMask, DGpropHEADER_POSITION ) )
	{
	if  ( dgTo->dgHeaderPositionTwips != dgFr->dgHeaderPositionTwips )
	    {
	    dgTo->dgHeaderPositionTwips= dgFr->dgHeaderPositionTwips;
	    PROPmaskADD( &changedMask, DGpropHEADER_POSITION );
	    }
	}
    if  ( PROPmaskISSET( updMask, DGpropFOOTER_POSITION ) )
	{
	if  ( dgTo->dgFooterPositionTwips != dgFr->dgFooterPositionTwips )
	    {
	    dgTo->dgFooterPositionTwips= dgFr->dgFooterPositionTwips;
	    PROPmaskADD( &changedMask, DGpropFOOTER_POSITION );
	    }
	}
    if  ( PROPmaskISSET( updMask, DGpropGUTTER ) )
	{
	if  ( dgTo->dgGutterTwips != dgFr->dgGutterTwips )
	    {
	    dgTo->dgGutterTwips= dgFr->dgGutterTwips;
	    PROPmaskADD( &changedMask, DGpropGUTTER );
	    }
	}

    *pChanged= changedMask;

    return;
    }

