#   include	<appFrame.h>

/************************************************************************/
/*									*/
/*  A paper chooser to be embedded in another window.			*/
/*									*/
/************************************************************************/

typedef struct PaperChooser
    {
    APP_WIDGET		pcFrame;
    APP_WIDGET		pcVerticalColumn;

    AppOptionmenu	pcOptionmenu;
    APP_WIDGET		pcSizeText;

    APP_WIDGET		pcOrientationRow;
    APP_WIDGET		pcPortraitRadio;
    APP_WIDGET		pcLandscapeRadio;

    int			pcCustomPaperSize;
    int			pcSizeChosen;
    int			pcSizeSet;
    int			pcLandscapeChosen;
    int			pcLandscapeSet;

    int			pcSizeOptionCount;
    APP_WIDGET *	pcSizeOptions;
    } PaperChooser;

# define appPaperChooserRetreshMenuWidth( pc ) \
			    appOptionmenuRefreshWidth( &((pc)->pcOptionmenu) )

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void appPaperChooserShowWidthHeight( PaperChooser *	pc,
				const DocumentGeometry *	dg,
				int				unitInt );

extern void appPaperChooserShowSize(	PaperChooser *		pc,
					int			sizeChosen );

extern int appPaperChooserGetSize(	unsigned int *		pUpdMask,
					PaperChooser *		pc,
					int			unitInt,
					DocumentGeometry *	dg );

extern void appPaperChooserFillMenu(	PaperChooser *		pc,
					const char *		customLabel,
					APP_BUTTON_CALLBACK	callback,
					void *			through );

extern void appPaperChooserAdaptToGeometry( PaperChooser *	pc,
					int			unitType,
					const DocumentGeometry * dg,
					int			set );

extern void appPaperSizeChosen(		APP_WIDGET		w,
					PaperChooser *		pc,
					DocumentGeometry *	dg,
					int			unitType );

extern void appPaperSizeChanged(	PaperChooser *		pc,
					DocumentGeometry *	dg,
					int			unitType );

extern void appMakePaperChooserWidgets(	APP_WIDGET		parent,
					const char *		title,
					PaperChooser *		pc,
					APP_TEXT_ACTIVATE_CALLBACK
								changedCallback,
					void *			through );

extern void appPaperChooserAddOrientationToggles( PaperChooser * pc,
					const char *		portrait,
					const char *		landscape,
					APP_TOGGLE_CALLBACK	callback,
					void *			through );

extern void appPageToolShowOrientation(	PaperChooser *	pc );

extern void appPaperOrientationChosen(	APP_WIDGET		w,
					void *			voidtbcs,
					int *			pChanged,
					PaperChooser *		pc,
					int			unitType,
					DocumentGeometry *	dg );

extern void appInitPaperChooser(	PaperChooser *		pc );
extern void appCleanPaperChooser(	PaperChooser *		pc );

