#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<appDebugon.h>

#   include	"appFrame.h"
#   include	"appSystem.h"
#   include	<appGeoString.h>

#   ifdef USE_GTK

/************************************************************************/
/*									*/
/*  Used to get around Motif's ridiculous resize behavior. Probably	*/
/*  not needed for GTK.							*/
/*									*/
/************************************************************************/

void appOptionmenuRefreshWidth(	AppOptionmenu *		aom )
    { return;	}

void appPixmapOptionmenuSetButtonMargins(	AppOptionmenu *	aom )
    { return;	}

void appMakeOptionmenuInColumn(		AppOptionmenu *	aom,
					APP_WIDGET	column )
    {
    APP_WIDGET	pulldown;
    APP_WIDGET	inplace;

    pulldown= gtk_menu_new();

    inplace= gtk_option_menu_new();

    gtk_box_pack_start( GTK_BOX( column ), inplace, FALSE, TRUE, 0 );

    gtk_widget_show( inplace );

    gtk_option_menu_set_menu( GTK_OPTION_MENU( inplace ), pulldown );

    aom->aomPulldown= pulldown; aom->aomInplace= inplace; return;
    }

void appMakeOptionmenuInRow(		AppOptionmenu *	aom,
					APP_WIDGET	row,
					int		column,
					int		colspan )
    {
    APP_WIDGET	pulldown;
    APP_WIDGET	inplace;

    pulldown= gtk_menu_new();

    inplace= gtk_option_menu_new();

    gtk_table_attach( GTK_TABLE( row ),
			inplace,
			column, column+ colspan,
			0, 1,
			GTK_FILL | GTK_EXPAND | GTK_SHRINK,
			GTK_FILL | GTK_EXPAND | GTK_SHRINK,
			ROW_XPADDING_GTK, ROW_YPADDING_GTK );

    gtk_widget_show( inplace );

    gtk_option_menu_set_menu( GTK_OPTION_MENU( inplace ), pulldown );

    aom->aomPulldown= pulldown; aom->aomInplace= inplace; return;
    }

/************************************************************************/
/*									*/
/*  Add an option to a pulldown.					*/
/*									*/
/************************************************************************/

APP_WIDGET appAddItemToOptionmenu(	AppOptionmenu *		aom,
					const char *		label,
					APP_BUTTON_CALLBACK	callBack,
					void *			target )
    {
    APP_WIDGET	item;

    item= gtk_menu_item_new_with_label( label );

    gtk_menu_append( GTK_MENU( aom->aomPulldown ), item );

    gtk_widget_show( item );

    if  ( callBack )
	{
	gtk_signal_connect( GTK_OBJECT( item ), "activate", callBack, target );
	}

    return item;
    }

APP_WIDGET appAddPixmapItemToOptionmenu( AppOptionmenu *	aom,
					APP_BUTTON_CALLBACK	callBack,
					void *			target )
    {
    APP_WIDGET	item;

    item= gtk_menu_item_new();

    gtk_menu_append( GTK_MENU( aom->aomPulldown ), item );

    gtk_widget_show( item );

    /*
    pixmap= gtk_pixmap_new( (GdkPixmap *)0, (GdkBitmap *)0 );

    gtk_container_add( GTK_CONTAINER( item ), pixmap );

    gtk_widget_show( pixmap );
    */

    if  ( callBack )
	{
	gtk_signal_connect( GTK_OBJECT( item ), "activate", callBack, target );
	}

    return item;
    }

/************************************************************************/
/*									*/
/*  Select a particular option in an option menu.			*/
/*									*/
/************************************************************************/

void appSetOptionmenu(	AppOptionmenu *	aom,
			int		num )
    {
    gtk_option_menu_set_history( GTK_OPTION_MENU( aom->aomInplace ), num );

    return;
    }

void appEmptyOptionmenu(	AppOptionmenu *		aom )
    {
    appEmptyParentWidget( aom->aomPulldown );
    }

void appGuiEnableOptionmenu(	AppOptionmenu *		aom,
				int			sensitive )
    {
    gtk_widget_set_sensitive( aom->aomInplace, sensitive != 0 );
    }

void appInitOptionmenu(		AppOptionmenu *		aom )
    {
    aom->aomPulldown= (APP_WIDGET)0;
    aom->aomInplace= (APP_WIDGET)0;
    }

#   endif
