/************************************************************************/
/*									*/
/*  A group of widgets to manipulate page margins.			*/
/*									*/
/************************************************************************/

#   include	<stdlib.h>
#   include	<stdio.h>

#   include	<appGuiBase.h>

#   include	"appUnit.h"
#   include	<appGeo.h>
#   include	<appGeoString.h>

typedef struct AppMarginTool
    {
    APP_WIDGET			amtLeftColumn;
    APP_WIDGET			amtRightColumn;
    APP_WIDGET			amtInsideWidget;
    APP_WIDGET			amtMarginFrame;

    APP_WIDGET			amtLeftMarginText;
    APP_WIDGET			amtTopMarginText;
    APP_WIDGET			amtRightMarginText;
    APP_WIDGET			amtBottomMarginText;
    } AppMarginTool;

typedef struct MarginToolResources
    {
    char *	mtrTitleText;
    char *	mtrLeftMarginText;
    char *	mtrTopMarginText;
    char *	mtrRightMarginText;
    char *	mtrBottomMarginText;
    } MarginToolResources;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void appMarginToolShowMargins(	AppMarginTool *			amt,
					int				unitInt,
					const DocumentGeometry *	dg );

extern int appMarginToolGetMargins(	unsigned int *		pUpdMask,
					unsigned int		chgMask,
					int			unitType,
					AppMarginTool *		amt,
					DocumentGeometry *	dg );

extern int appMarginToolCheckMargins(	const DocumentGeometry * dg );

extern void appMakeMarginToolWidgets(	APP_WIDGET		parent,
					const MarginToolResources * mtr,
					AppMarginTool *		amt,
					APP_TEXT_ACTIVATE_CALLBACK changed,
					void *			through );
