#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<appDebugon.h>

#   include	"appFrame.h"
#   include	"appSystem.h"
#   include	<appGeoString.h>

#   ifdef USE_GTK

void appInspectorMakePageParent(	AppInspector *	ai )
    {
    GtkWidget *		notebook;

    notebook= gtk_notebook_new();

    gtk_notebook_set_show_tabs( GTK_NOTEBOOK( notebook ), FALSE );
    gtk_notebook_set_show_border( GTK_NOTEBOOK( notebook ), FALSE );

    gtk_widget_show( notebook );

    gtk_box_pack_start( GTK_BOX( ai->aiPaned ), notebook, FALSE, TRUE, 0 );

    ai->aiPageParent= notebook;

    return;
    }

void appInspectorChoosePage(	AppInspector *		ai,
				int			andMenu,
				int			pageNumber )
    {
    gtk_notebook_set_page( GTK_NOTEBOOK( ai->aiPageParent ), pageNumber );

    if  ( andMenu )
	{ appSetOptionmenu( &(ai->aiSubjectOptionmenu), pageNumber );	}

    return;
    }

static void appInspectorPageChosen(	APP_WIDGET	w,
					void *		vai,
					void *		call_data )
    {
    AppInspector *	ai= (AppInspector *)vai;

    int			n;

    const int		andMenu= 0;

    for ( n= 0; n < ai->aiSubjectCount; n++ )
	{
	if  ( w == ai->aiSubjects[n].isMenuitem )
	    { break;	}
	}

    if  ( n >= ai->aiSubjectCount )
	{ LDEB(ai->aiSubjectCount); return;	}

    appInspectorChoosePage( ai, andMenu, n );

    ai->aiCurrentSubject= n;

    return;
    }

void appMakeVerticalInspectorPage(	APP_WIDGET *	pPage,
					APP_WIDGET *	pMenuitem,
					AppInspector *	ai,
					const char *	label )
    {
    GtkWidget *		item;
    GtkWidget *		page;

    page= gtk_vbox_new( FALSE, COLUMN_SPACING_GTK );

    gtk_notebook_append_page( GTK_NOTEBOOK( ai->aiPageParent ),
						    page, (GtkWidget *)0 );

    gtk_widget_show( page );

    item= appAddItemToOptionmenu( &(ai->aiSubjectOptionmenu), label,
				    appInspectorPageChosen, (void *)ai );

    *pPage= page; *pMenuitem= item; return;
    }

void appInspectorEnablePage(	AppInspector *	ai,
				int		pageNumber,
				int		enabled )
    {
    GtkWidget *		page;

    page= gtk_notebook_get_nth_page( GTK_NOTEBOOK( ai->aiPageParent ),
								pageNumber );

    gtk_widget_set_sensitive( page, enabled != 0 );

    gtk_widget_set_sensitive( ai->aiSubjects[pageNumber].isMenuitem,
							    enabled != 0 );

    return;
    }

#   endif /*  USE_GTK	*/
