/************************************************************************/
/*  Color mangement on X11: Try to get around the limitations.		*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	"appDraw.h"

#   include	<appDebugon.h>

#   ifdef	USE_MOTIF

/************************************************************************/
/*									*/
/*  Allocate approximate colors.					*/
/*									*/
/************************************************************************/

static int appColorRgb111(	AllocatorColor *	ac,
				ColorAllocator *	ca,
				unsigned int		r,
				unsigned int		g,
				unsigned int		b )
    {
    unsigned int	col111= C111( r, g, b );

    if  ( ca->ca222Colors[col111].acAllocated == AC_UNALOCATED )
	{
	XColor		xc;
	AppColors *	acSys= (AppColors *)ca->caSystemPrivate;

	r= ( 255* ( r & 0xc0 ) + 0xc0/ 2 )/ 0xc0;
	g= ( 255* ( g & 0xc0 ) + 0xc0/ 2 )/ 0xc0;
	b= ( 255* ( b & 0xc0 ) + 0xc0/ 2 )/ 0xc0;

	xc.red=		( r << 8 ) | r;
	xc.green=	( g << 8 ) | g;
	xc.blue=	( b << 8 ) | b;
	xc.flags=	DoRed | DoGreen | DoBlue;

	if  ( ! XAllocColor( acSys->acDisplay, acSys->acColormap, &xc ) )
	    { LDEB(col111); return -1;	}

	ca->ca222Colors[col111].acAllocated= AC_ALOCATED;
	ca->ca222Colors[col111].acRed= xc.red;
	ca->ca222Colors[col111].acGreen= xc.green;
	ca->ca222Colors[col111].acBlue= xc.blue;
	ca->ca222Colors[col111].acColorNumber= xc.pixel;
	}


    *ac= ca->ca222Colors[col111];

    return 0;
    }

static int appColorRgb222(	AllocatorColor *	ac,
				ColorAllocator *	ca,
				unsigned int		r,
				unsigned int		g,
				unsigned int		b )
    {
    unsigned int	col222= C222( r, g, b );

    if  ( ca->ca222Colors[col222].acAllocated == AC_UNALOCATED )
	{
	XColor		xc;
	AppColors *	acSys= (AppColors *)ca->caSystemPrivate;

	r= ( 255* ( r & 0xc0 ) + 0xc0/ 2 )/ 0xc0;
	g= ( 255* ( g & 0xc0 ) + 0xc0/ 2 )/ 0xc0;
	b= ( 255* ( b & 0xc0 ) + 0xc0/ 2 )/ 0xc0;

	xc.red=		( r << 8 ) | r;
	xc.green=	( g << 8 ) | g;
	xc.blue=	( b << 8 ) | b;
	xc.flags=	DoRed | DoGreen | DoBlue;

	if  ( ! XAllocColor( acSys->acDisplay, acSys->acColormap, &xc ) )
	    { LDEB(col222); return -1;	}

	ca->ca222Colors[col222].acAllocated= AC_ALOCATED;
	ca->ca222Colors[col222].acRed= xc.red;
	ca->ca222Colors[col222].acGreen= xc.green;
	ca->ca222Colors[col222].acBlue= xc.blue;
	ca->ca222Colors[col222].acColorNumber= xc.pixel;
	}


    *ac= ca->ca222Colors[col222];
    return 0;
    }

static int appColorRgb555(	AllocatorColor *	ac,
				ColorAllocator *	ca,
				unsigned int		r,
				unsigned int		g,
				unsigned int		b )
    {
    unsigned int	col555= C555( r, g, b );

    if  ( ca->caColors[col555].acAllocated == AC_UNALOCATED )
	{
	XColor		xc;
	AppColors *	acSys= (AppColors *)ca->caSystemPrivate;

	r= ( 255* ( r & 0xf1 ) + 0xf1/ 2 )/ 0xf1;
	g= ( 255* ( g & 0xf1 ) + 0xf1/ 2 )/ 0xf1;
	b= ( 255* ( b & 0xf1 ) + 0xf1/ 2 )/ 0xf1;

	xc.red=		( r << 8 ) | r;
	xc.green=	( g << 8 ) | g;
	xc.blue=	( b << 8 ) | b;
	xc.flags=	DoRed | DoGreen | DoBlue;

	if  ( ! XAllocColor( acSys->acDisplay, acSys->acColormap, &xc ) )
	    {
	    if  ( appColorRgb222( ca->caColors+ col555, ca, r, g, b ) )
		{ LDEB(col555); return -1;	}

	    ca->caColors[col555].acAllocated= AC_COPIED;
	    }
	else{
	    ca->caColors[col555].acAllocated= AC_ALOCATED;
	    ca->caColors[col555].acRed= xc.red;
	    ca->caColors[col555].acGreen= xc.green;
	    ca->caColors[col555].acBlue= xc.blue;
	    ca->caColors[col555].acColorNumber= xc.pixel;
	    }
	}

    *ac= ca->caColors[col555];
    return 0;
    }

static int appColorRgb332(	AllocatorColor *	ac,
				ColorAllocator *	ca,
				unsigned int		r,
				unsigned int		g,
				unsigned int		b )
    {
    unsigned int	col332= C332( r, g, b );

    if  ( ca->caColors[col332].acAllocated == AC_UNALOCATED )
	{
	XColor		xc;
	AppColors *	acSys= (AppColors *)ca->caSystemPrivate;

	r= ( 255* ( r & 0xe0 ) + 0xe0/ 2 )/ 0xe0;
	g= ( 255* ( g & 0xe0 ) + 0xe0/ 2 )/ 0xe0;
	b= ( 255* ( b & 0xc0 ) + 0xc0/ 2 )/ 0xc0;

	xc.red=		( r << 8 ) | r;
	xc.green=	( g << 8 ) | g;
	xc.blue=	( b << 8 ) | b;
	xc.flags=	DoRed | DoGreen | DoBlue;

	if  ( ! XAllocColor( acSys->acDisplay, acSys->acColormap, &xc ) )
	    {
	    if  ( appColorRgb222( ca->caColors+ col332, ca, r, g, b ) )
		{ LDEB(col332); return -1;	}

	    ca->caColors[col332].acAllocated= AC_COPIED;
	    }
	else{
	    ca->caColors[col332].acAllocated= AC_ALOCATED;
	    ca->caColors[col332].acRed= xc.red;
	    ca->caColors[col332].acGreen= xc.green;
	    ca->caColors[col332].acBlue= xc.blue;
	    ca->caColors[col332].acColorNumber= xc.pixel;
	    }
	}

    *ac= ca->caColors[col332];
    return 0;
    }

int appColorRgb(	XColor *		xc,
			AppColors *		acSys,
			unsigned int		r,
			unsigned int		g,
			unsigned int		b )
    {
    AllocatorColor	ac;
    ColorAllocator *	ca= &(acSys->acAllocator);

    if  ( acSys->acVisualClass ==	TrueColor	||
	  acSys->acVisualClass ==	DirectColor	)
	{
	bmColorRgbDirect( &ac, ca, r, g, b );
	}
    else{
	if  ( ! ca->caSystemAllocator )
	    { XDEB(ca->caSystemAllocator); return -1;	}

	if  ( (*ca->caSystemAllocator)( &ac, ca, r, g, b ) )
	    { LLLDEB(r,g,b); return -1;	}
	}

    xc->red= ac.acRed;
    xc->green= ac.acGreen;
    xc->blue= ac.acBlue;
    xc->pixel= ac.acColorNumber;

    return 0;
    }

int appColorNamed(	XColor *		xc,
			AppColors *		acSys,
			const char *		name )
    {
    XColor	exact;
    XColor	screen;

    if  ( ! XLookupColor( acSys->acDisplay, acSys->acColormap, name,
							&exact, &screen ) )
	{ SDEB(name); return -1;	}

    return appColorRgb( xc, acSys,
			exact.red/257, exact.green/257, exact.blue/257 );
    }

/************************************************************************/
/*									*/
/*  Allocate colors for an image.					*/
/*									*/
/************************************************************************/

static int appPixCmp(		const void *	vpix1,
				const void *	vpix2 )
    {
    Pixel	pix1= *(Pixel *)vpix1;
    Pixel	pix2= *(Pixel *)vpix2;

    if  ( pix1 > pix2 )
	{ return  1;	}
    if  ( pix1 < pix2 )
	{ return -1;	}

    return 0;
    }

static void appTry222Color(	Display *		display,
				Colormap		cmap,
				ColorAllocator *	ca,
				AppColors *		acSys,
				double			dists[64],
				Pixel			l )
    {
    XColor		xc;
    int			col222;

    xc.pixel= l;
    xc.red= xc.green= xc.blue= 0;

    XQueryColor( display, cmap, &xc );

    col222= C222( (int)(xc.red/256), (int)(xc.green/256), (int)(xc.blue/256) );

    if  ( ca->ca222Colors[col222].acAllocated == AC_ALOCATED )
	{
	double		c;
	double		d= 0;

	c= xc.red-   (256*256-1)* ( ( ( col222 & 0x30 ) >> 4 ) / 3 ); d += c* c;
	c= xc.green- (256*256-1)* ( ( ( col222 & 0x0c ) >> 2 ) / 3 ); d += c* c;
	c= xc.blue-  (256*256-1)* ( ( ( col222 & 0x03 ) >> 0 ) / 3 ); d += c* c;

	if  ( sqrt( d ) > dists[col222] )
	    { return;	}
	}

    if  ( XAllocColor( display, cmap, &xc )	)
	{
	if  ( xc.pixel == l )
	    {
	    if  ( ca->ca222Colors[col222].acAllocated == AC_UNALOCATED )
		{
		ca->ca222Colors[col222].acAllocated= AC_ALOCATED;
		ca->ca222Colors[col222].acRed= xc.red;
		ca->ca222Colors[col222].acGreen= xc.green;
		ca->ca222Colors[col222].acBlue= xc.blue;
		ca->ca222Colors[col222].acColorNumber= xc.pixel;
		}
	    else{ XFreeColors( display, cmap, &(xc.pixel), 1, 0L ); }
	    }
	else{ XFreeColors( display, cmap, &(xc.pixel), 1, 0L ); }
	}
    }

static char *APP_VisualClasses[]=
    {
    "StaticGray",
    "GrayScale",
    "StaticColor",
    "PseudoColor",
    "TrueColor",
    "DirectColor",
    };

int appAllocateColors(	AppDrawingData *	add,
			AppColors *		acSys )
    {
    Display *		display= add->addDisplay;
    int			screen= DefaultScreen( display );
    int			depth= DefaultDepth( display, screen );
    Colormap		cmap= DefaultColormap( display, screen );
    Visual *		vis= DefaultVisual( display, screen );

    XVisualInfo		visualInfo;
    XVisualInfo *	visuals;

    int			count;
    int			i;

    double		d[64];

    int			l, m, r;
    Pixel *		pxx;

    ColorAllocator *	ca= &(acSys->acAllocator);

    visualInfo.visualid= XVisualIDFromVisual( vis );
    visuals= XGetVisualInfo( display, VisualIDMask, &visualInfo, &count );
    if  ( count != 1 )
	{ LDEB(count); return -1;	}
    visualInfo= *visuals;
    XFree( visuals );

    acSys->acDisplay= display;
    acSys->acColormap= cmap;
    ca->caSystemPrivate= acSys;

#   ifdef __cplusplus
    acSys->acVisualClass= visualInfo.c_class;
#   else
    acSys->acVisualClass= visualInfo.class;
#   endif

    ca->caDepth= depth;

    switch( acSys->acVisualClass )
	{
	case StaticGray:
	case GrayScale:
	    ca->caAllocationType= AC_ALOCATED;
	    switch( ca->caDepth )
		{
		case 1: case 2: case 4: case 8:
		    break;
		default:
		    SLDEB(APP_VisualClasses[acSys->acVisualClass],ca->caDepth);
		}
	    break;

	case StaticColor:
	    SDEB(APP_VisualClasses[acSys->acVisualClass]);

	    ca->caAllocationType= AC_ALOCATED;
	    break;

	case PseudoColor:

	    ca->caAllocationType= AC_ALOCATED;
	    break;

	case TrueColor:
	case DirectColor:
	    ca->caAllocationType= AC_CALCULATED;

	    bmSetCalculatedShifts( ca, visualInfo.red_mask,
			    visualInfo.green_mask, visualInfo.blue_mask );

	    return 0;
	}

    switch( depth )
	{
	case  1:
	    count= 2;
	    ca->caSystemAllocator= appColorRgb111;
	    break;

	case  2:
	    count= 4;
	    ca->caSystemAllocator= appColorRgb111;
	    break;
	case  4:
	    count= 16;
	    ca->caSystemAllocator= appColorRgb222;
	    break;

	case  8:
	    count= 256;
	    ca->caSystemAllocator= appColorRgb332;
	    break;

	case 16:
	    count= 256* 256;
	    ca->caSystemAllocator= appColorRgb555;
	    break;

	case 24:
	case 32:
	    return 0;

	default:
	    LDEB(depth); return -1;
	}

    for ( l= 0; l < 64; l++ )
	{ d[l]= 300000;	}

    ca->caColors= (AllocatorColor *)malloc( count* sizeof(AllocatorColor) );

    if  ( ! ca->caColors )
	{ LXDEB(count,ca->caColors); return -1;	}

    ca->caColorCount= count;

    for ( i= 0; i < count; i++ )
	{
	ca->caColors[i].acColorNumber= 0;
	ca->caColors[i].acAllocated= AC_UNALOCATED;
	}

    XGrabServer( display );

    l= 0; r= count; m= ( l+ r )/2;
    pxx= (Pixel *)malloc( count* sizeof( Pixel ) );
    while( l < m )
	{
	if  ( ! XAllocColorCells( display, cmap, False,
						(unsigned long *)0, 0,
						pxx, (unsigned)m ) )
	    { r= m; }
	else{
	    XFreeColors( display, cmap, pxx, m, 0L );
	    l= m;
	    }

	m= ( l+ r )/2;
	}

    if  ( m > 0 )
	{
	if  ( ! XAllocColorCells( display, cmap, False,
					    (unsigned long *)0, 0,
					    pxx, (unsigned)m ) )
	    { LDEB(m); XUngrabServer( display ); return -1; }
	}

    XUngrabServer( display );

    qsort( pxx, m, sizeof(Pixel), appPixCmp );
    pxx[m]= count;

    l= 0; r= 0;
    if  ( m > 0 ) while( r <= m )
	{
	while( (unsigned)l < pxx[r] )
	    {
	    appTry222Color( display, cmap, ca, acSys, d, l );

	    l++;
	    }

	l++; r++;
	}
    else{
	if  ( count <= 256 )
	    {
	    for ( l= 0; l < count; l++ )
		{ appTry222Color( display, cmap, ca, acSys, d, l ); }
	    }
	}

    if  ( m > 0 )
	{
	XFreeColors( display, cmap, pxx, m, 0L ); }

    free( pxx );

    return 0;
    }

void appCleanColors(	AppColors *		acSys )
    {
    Display *		display= acSys->acDisplay;
    Colormap            cmap= acSys->acColormap;
    int			i;

    ColorAllocator *	ca= &(acSys->acAllocator);

    if  ( ! display )
	{ return;	}

    for ( i= 0; i < 64; i++ )
	{
	if  ( ca->ca222Colors[i].acAllocated == AC_ALOCATED )
	    {
	    Pixel	pix= ca->ca222Colors[i].acColorNumber;

	    XFreeColors( display, cmap, &pix, 1, 0L );
	    ca->ca222Colors[i].acAllocated= AC_UNALOCATED;
	    }
	}

    for ( i= 0; i < ca->caColorCount; i++ )
	{
	if  ( ca->caColors[i].acAllocated == AC_ALOCATED )
	    {
	    Pixel	pix= ca->caColors[i].acColorNumber;

	    XFreeColors( display, cmap, &pix, 1, 0L );
	    ca->caColors[i].acAllocated= AC_UNALOCATED;
	    }
	}

    bmCleanColorAllocator( ca );
    }

void appInitColors(	AppColors *	acSys )
    {
    ColorAllocator *	ca= &(acSys->acAllocator);

    bmInitColorAllocator( ca );

    acSys->acDisplay= (Display *)0;
    acSys->acColormap= None;
    }

int appColorFindRgb(	XColor *	xc,
			AppColors *	acSys,
			unsigned int	r,
			unsigned int	g,
			unsigned int	b )
    {
    ColorAllocator *	ca= &(acSys->acAllocator);
    int			d;
    int			col;

    for ( d= 0; d < 128; d++ )
	{
	AllocatorColor *	ac;

	ac= ca->ca222Colors;
	for ( col= 0; col < 64; ac++, col++ )
	    {
	    if  ( ac->acAllocated == AC_UNALOCATED )
		{ continue;	}

	    if  ( ac->acRed	> 256* ( r- d )		&&
		  ac->acRed	< 256* ( r+ d )		&&
		  ac->acGreen	> 256* ( g- d )		&&
		  ac->acGreen	< 256* ( g+ d )		&&
		  ac->acBlue	> 256* ( b- d )		&&
		  ac->acBlue	< 256* ( b+ d )		)
		{
		xc->red= ac->acRed;
		xc->green= ac->acGreen;
		xc->blue= ac->acBlue;
		xc->pixel= ac->acColorNumber;

		return 0;
		}
	    }

	ac= ca->caColors;
	for ( col= 0; col < ca->caColorCount; ac++, col++ )
	    {
	    if  ( ac->acAllocated == AC_UNALOCATED )
		{ continue;	}

	    if  ( ac->acRed	> 256* ( r- d )		&&
		  ac->acRed	< 256* ( r+ d )		&&
		  ac->acGreen	> 256* ( g- d )		&&
		  ac->acGreen	< 256* ( g+ d )		&&
		  ac->acBlue	> 256* ( b- d )		&&
		  ac->acBlue	< 256* ( b+ d )		)
		{
		xc->red= ac->acRed;
		xc->green= ac->acGreen;
		xc->blue= ac->acBlue;
		xc->pixel= ac->acColorNumber;

		return 0;
		}
	    }
	}

    return -1;
    }

#   endif
