/************************************************************************/
/*									*/
/*  A Format Tool.							*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<appDebugon.h>

#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Refresh the 'Table' page of the format tool.			*/
/*									*/
/************************************************************************/

static void tedFormatToolRefreshTablePage(	TableTool *	tt )
    {
    RowProperties *	rp= &(tt->ttPropertiesChosen);

    char		scratch[50];

    appGeoLengthToString( scratch, rp->rpHalfGapWidthTwips, UNITtyPOINTS );
    appStringToTextWidget( tt->ttCellMarginText, scratch );

    appGeoLengthToString( scratch, rp->rpLeftIndentTwips, UNITtyPOINTS );
    appStringToTextWidget( tt->ttLeftIndentText, scratch );
    }

void tedFormatToolRefreshTableTool(	TableTool *		tt,
					InspectorSubject *	is,
					const TableRectangle *	tr,
					const BufferSelection *	bs )
    {
    const RowProperties *	rp;
    const DocumentGeometry *	dg;

    const BufferItem *		rowBi;
    const BufferItem *		sectBi;

    rowBi= bs->bsBegin.bpBi;
    rowBi= rowBi->biParent;
    rowBi= rowBi->biParent;
    sectBi= rowBi->biParent;

    dg= &(sectBi->biSectDocumentGeometry);

    tt->ttPageRight= dg->dgPageWideTwips-
			    dg->dgLeftMarginTwips- dg->dgRightMarginTwips;
    tt->ttPageLeftMargin= dg->dgLeftMarginTwips;

    rp= &(rowBi->biRowProperties);

    if  ( docCopyRowProperties( &(tt->ttPropertiesChosen), rp ) )
	{ LDEB(1); return;	}
    if  ( docCopyRowProperties( &(tt->ttPropertiesSet), rp ) )
	{ LDEB(1); return;	}

    tt->ttTableRectangle= *tr;

    tedFormatToolRefreshTablePage( tt );

    return;
    }

/************************************************************************/
/*  Set/Revert buttons have been pushed.				*/
/************************************************************************/

static void tedTableChangeTablePushed(	APP_WIDGET	w,
					void *		voidtt,
					void *		voidpbcs	 )
    {
    TableTool *			tt= (TableTool *)voidtt;
    RowProperties *		rp= &(tt->ttPropertiesChosen);
    const TableRectangle *	tr= &(tt->ttTableRectangle);

    int			width;
    int			res;

    res= tedFormatToolGetRowLeftIndent( rp, tt->ttPageLeftMargin,
					    &width, tt->ttLeftIndentText );
    if  ( res != 0 )
	{ return;	}
    rp->rpLeftIndentTwips= width;

    res= tedFormatToolGetGapWidth( rp, &width, tt->ttCellMarginText );
    if  ( res != 0 )
	{ return;	}
    rp->rpHalfGapWidthTwips= width;

    tedAppSetTableProperties( tt->ttApplication, tr, rp );

    return;
    }

static void tedFormatRevertTablePushed(	APP_WIDGET	w,
					void *		voidtt,
					void *		voidpbcs )
    {
    TableTool *	tt= (TableTool *)voidtt;

    docCopyRowProperties( &(tt->ttPropertiesChosen), &(tt->ttPropertiesSet) );

    tedFormatToolRefreshTablePage( tt );

    return;
    }

/************************************************************************/
/*									*/
/*  Check the cell margin that was entered on the 'Table' page of the	*/
/*  format tool.							*/
/*									*/
/************************************************************************/

static void tedTableCellMarginChanged(	APP_WIDGET	w,
					void *		voidtt,
					void *		voidpbcs )
    {
    TableTool *		tt= (TableTool *)voidtt;
    RowProperties *	rp= &(tt->ttPropertiesChosen);

    int			value;

    if  ( ! tedFormatToolGetGapWidth( rp, &value, tt->ttCellMarginText ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	appStringToTextWidget( tt->ttCellMarginText, scratch );
	}
    }

/************************************************************************/
/*									*/
/*  Check the left indent that was entered on the 'Table' page of the	*/
/*  format tool.							*/
/*									*/
/************************************************************************/

static void tedTableLeftIndentChanged(	APP_WIDGET	w,
					void *		voidtt,
					void *		voidpbcs )
    {
    TableTool *		tt= (TableTool *)voidtt;
    RowProperties *	rp= &(tt->ttPropertiesChosen);

    int			value;

    if  ( ! tedFormatToolGetRowLeftIndent( rp, tt->ttPageLeftMargin, &value,
						    tt->ttLeftIndentText ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, value, UNITtyPOINTS );
	appStringToTextWidget( tt->ttLeftIndentText, scratch );
	}
    }

/************************************************************************/
/*									*/
/*  Delete/Select Table buttons have been pushed.			*/
/*									*/
/************************************************************************/

static void tedTableDeleteTable(	APP_WIDGET	w,
					void *		voidtt,
					void *		voidpbcs )
    {
    TableTool *			tt= (TableTool *)voidtt;
    EditApplication *		ea= tt->ttApplication;
    EditDocument *		ed= ea->eaCurrentDocument;

    const TableRectangle *	tr= &(tt->ttTableRectangle);

    if  ( tedDeleteRowsFromTable( ed, tr->trRow00, tr->trRow11 ) )
	{ LLDEB(tr->trRow00,tr->trRow11); return;	}

    appDocumentChanged( ed, 1 );

    return;
    }

static void tedTableSelectTable(	APP_WIDGET	w,
					void *		voidtt,
					void *		voidpbcs )
    {
    TableTool *			tt= (TableTool *)voidtt;
    EditApplication *		ea= tt->ttApplication;
    EditDocument *		ed= ea->eaCurrentDocument;
    TedDocument *		td;

    TableRectangle		trSet= tt->ttTableRectangle;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    td= (TedDocument *)ed->edPrivateData;

    docExpandTableRectangleToWholeTable( &trSet );

    tedAppSetTableSelection( ed, &(td->tdSelectionScope), &trSet );
    }

/************************************************************************/
/*									*/
/*  Make the 'Table' page of the format tool.				*/
/*									*/
/************************************************************************/

void tedFormatFillTablePage(	TableTool *			tt,
				const TablePageResources *	tpr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr )
    {
    APP_WIDGET	widthLabel;
    APP_WIDGET	leftLabel;

    APP_WIDGET	row= (APP_WIDGET )0;

    const int	textColumns= 10;

    /**************/
    docInitTableRectangle( &(tt->ttTableRectangle) );

    docInitRowProperties( &(tt->ttPropertiesSet) );
    docInitRowProperties( &(tt->ttPropertiesChosen) );

    /**************/
    appMakeLabelAndTextRow( &row, &leftLabel, &(tt->ttLeftIndentText),
			pageWidget, tpr->tprLeftIndent, textColumns, 1 );

    appGuiSetGotValueCallbackForText( tt->ttLeftIndentText,
				tedTableLeftIndentChanged, (void *)tt );

    /**************/
    appMakeLabelAndTextRow( &row, &widthLabel, &(tt->ttCellMarginText),
		    pageWidget, tpr->tprCellMargin, textColumns, 1 );

    appGuiSetGotValueCallbackForText( tt->ttCellMarginText,
				tedTableCellMarginChanged, (void *)tt );

    /**************/
    appInspectorMakeButtonRow( &row, pageWidget,
		&(is->isSelectButton), &(is->isDeleteButton),
		isr->isrSelectButtonText, isr->isrDeleteButtonText,
		tedTableSelectTable, tedTableDeleteTable, (void *)tt );

    appInspectorMakeButtonRow( &row, pageWidget,
		&(is->isRevertButton), &(is->isApplyButton),
		isr->isrRevert, isr->isrApplyToSubject,
		tedFormatRevertTablePushed, tedTableChangeTablePushed,
		(void *)tt );

    return;
    }
