/************************************************************************/
/*									*/
/*  The Row page of the Format Tool.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stddef.h>
#   include	<limits.h>

#   include	<appDebugon.h>

#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

#   define	DRH_MM		45

/************************************************************************/
/*									*/
/*  Refresh the section page.						*/
/*									*/
/************************************************************************/

static void tedFormatToolRefreshPageLayoutPage(	PageLayoutTool *	plt )
    {
    EditApplication *		ea= plt->pltApplication;
    AppDrawingData *		add= &(plt->pltDrawingData);
    DocumentGeometry *		dg= &(plt->pltGeometryChosen);
    const int			set= 1;

    char		scratch[50];

    appPaperChooserAdaptToGeometry( &(plt->pltPaperChooser),
						    plt->pltUnitType, dg, set );

    appMarginToolShowMargins( &(plt->pltMarginTool), plt->pltUnitType, dg );

    appExposeRectangle( add, 0, 0, 0, 0 );

    appGeoLengthToString( scratch, dg->dgHeaderPositionTwips, ea->eaUnitInt );
    appStringToTextWidget( plt->pltHeaderPositionText, scratch );

    appGeoLengthToString( scratch, dg->dgFooterPositionTwips, ea->eaUnitInt );
    appStringToTextWidget( plt->pltFooterPositionText, scratch );

    return;
    }

void tedFormatToolRefreshPageLayoutTool(	PageLayoutTool *	plt,
						InspectorSubject *	is,
						const BufferSelection *	bs,
						const DocumentProperties * dp )
    {
    BufferItem *			sectBi;

    sectBi= bs->bsBegin.bpBi;
    while( sectBi && sectBi->biLevel > DOClevSECT )
	{ sectBi= sectBi->biParent;	}

    if  ( ! sectBi )
	{ XDEB(sectBi); return;	}

    plt->pltGeometryChosen= sectBi->biSectDocumentGeometry;
    plt->pltGeometrySetSelection= sectBi->biSectDocumentGeometry;
    plt->pltGeometrySetDocument= dp->dpGeometry;

    tedFormatToolRefreshPageLayoutPage( plt );

    return;
    }

/************************************************************************/
/*									*/
/*  The 'Change' button of the row tool has been pushed.		*/
/*									*/
/************************************************************************/

static void tedFormatChangeLayoutPushed(	APP_WIDGET	w,
						void *		voidplt,
						void *		voidpbcs )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    EditApplication *		ea= plt->pltApplication;

    int				changed;

    unsigned int		sizeUpdMask= 0;
    unsigned int		margUpdMask= 0;

    TextAttribute		taNew;
    SectionProperties		spNew;

    const int			minValue= 1;
    const int			adaptToMin= 0;
    const int			maxValue= INT_MAX;
    const int			adaptToMax= 0;

    docInitTextAttribute ( &taNew );
    docInitSectionProperties( &spNew );

    spNew.spDocumentGeometry= plt->pltGeometryChosen;

    if  ( appPaperChooserGetSize( &sizeUpdMask, &(plt->pltPaperChooser),
			    plt->pltUnitType, &(spNew.spDocumentGeometry) ) )
	{ LDEB(1); return;	}

    if  ( appMarginToolGetMargins( &margUpdMask, DGupdALL, plt->pltUnitType,
			 &(plt->pltMarginTool), &(spNew.spDocumentGeometry) ) )

    if  ( appMarginToolCheckMargins( &(spNew.spDocumentGeometry) ) )
	{ return;	}

    if  ( appGetLengthFromTextWidget( plt->pltHeaderPositionText,
			    &(spNew.spDocumentGeometry.dgHeaderPositionTwips),
			    &changed, ea->eaUnitInt,
			    minValue, adaptToMin, maxValue, adaptToMax ) )
	{ return;	}

    if  ( appGetLengthFromTextWidget( plt->pltFooterPositionText,
			    &(spNew.spDocumentGeometry.dgFooterPositionTwips),
			    &changed, ea->eaUnitInt,
			    minValue, adaptToMin, maxValue, adaptToMax ) )
	{ return;	}

    if  ( w == plt->pltChangeSelectionWidget )
	{
	unsigned int	updMask;

	PROPmaskCLEAR( &updMask );
	PROPmaskFILL( &updMask, DGprop_COUNT );

	if  ( tedAppChangeSectionProperties( ea, updMask, &spNew ) )
	    { LDEB(1);	}
	}
    else{
	EditDocument *		ed= ea->eaCurrentDocument;

	if  ( ! ed )
	    { XDEB(ed); return;	}

	tedSetPageLayout( ed, DGupdALL, &(spNew.spDocumentGeometry) );
	}


    return;
    }

static void tedSectHeaderFooterPosChanged(	APP_WIDGET	w,
						void *		voidplt,
						void *		voidpbcs )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    EditApplication *		ea= plt->pltApplication;
    DocumentGeometry *		dgSect= &(plt->pltGeometryChosen);

    int				width;
    int				changed;

    const int			minValue= 1;
    const int			adaptToMin= 0;
    const int			maxValue= INT_MAX;
    const int			adaptToMax= 0;

    if  ( w == plt->pltHeaderPositionText )
	{ width= dgSect->dgHeaderPositionTwips;	}
    if  ( w == plt->pltFooterPositionText )
	{ width= dgSect->dgFooterPositionTwips;	}

    if  ( ! appGetLengthFromTextWidget( w, &width, &changed, ea->eaUnitInt,
				minValue, adaptToMin, maxValue, adaptToMax ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, width, ea->eaUnitInt );
	appStringToTextWidget( w, scratch );
	}
    }

/************************************************************************/
/*									*/
/*  One of the margins has been changed by the user.			*/
/*									*/
/************************************************************************/

static void tedPaperMarginChanged(	APP_WIDGET	w,
					void *		voidplt,
					void *		voidcbs	 )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    AppDrawingData *		add= &(plt->pltDrawingData);
    DocumentGeometry *		dgSect= &(plt->pltGeometryChosen);
    unsigned int		dgUpdMask= 0;

    DocumentGeometry		dg;

    dg= *dgSect;

    if  ( appMarginToolGetMargins( &dgUpdMask, DGupdALL,
			    plt->pltUnitType, &(plt->pltMarginTool), &dg ) )
	{ return;	}

    if  ( ! dgUpdMask )
	{ return;	}

    if  ( appMarginToolCheckMargins( &dg ) )
	{ return;	}

    dgSect->dgLeftMarginTwips= dg.dgLeftMarginTwips;
    dgSect->dgTopMarginTwips= dg.dgTopMarginTwips;
    dgSect->dgRightMarginTwips= dg.dgRightMarginTwips;
    dgSect->dgBottomMarginTwips= dg.dgBottomMarginTwips;

    appExposeRectangle( add, 0, 0, 0, 0 );

    return;
    }

/************************************************************************/
/*									*/
/*  The 'Revert' button of the row tool has been pushed.		*/
/*									*/
/************************************************************************/

static void tedFormatRevertLayoutPushed(	APP_WIDGET	w,
						void *		voidplt,
						void *		voidpbcs )
    {
    PageLayoutTool *	plt= (PageLayoutTool *)voidplt;

    if  ( w == plt->pltRevertSelectionWidget )
	{ plt->pltGeometryChosen= plt->pltGeometrySetSelection;	}
    else{ plt->pltGeometryChosen= plt->pltGeometrySetDocument;	}

    tedFormatToolRefreshPageLayoutPage( plt );

    return;
    }

/************************************************************************/
/*									*/
/*  Draw a schematic view of the page.					*/
/*									*/
/************************************************************************/

static APP_EVENT_HANDLER( tedPageLayoutToolDrawPage, w, voidplt, exposeEvent )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    AppDrawingData *		add= &(plt->pltDrawingData);
    DocumentGeometry *		dg= &(plt->pltGeometryChosen);

    appDrawPageDiagram( w, add, DRH_MM, dg );
    }

/************************************************************************/
/*									*/
/*  A paper size was chosen.						*/
/*									*/
/************************************************************************/

static void tedPageLayoutToolPaperSizeChosen(	APP_WIDGET	w,
						void *		voidplt,
						void *		voidpbcs )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    AppDrawingData *		add= &(plt->pltDrawingData);
    DocumentGeometry *		dg= &(plt->pltGeometryChosen);

    appPaperSizeChosen( w, &(plt->pltPaperChooser), dg, plt->pltUnitType );

    appExposeRectangle( add, 0, 0, 0, 0 );

    return;
    }

static void tedPageLayoutToolPaperSizeChanged(	APP_WIDGET	w,
						void *		voidplt,
						void *		voidcbs )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    AppDrawingData *		add= &(plt->pltDrawingData);
    DocumentGeometry *		dg= &(plt->pltGeometryChosen);

    const int			set= 0;

    appPaperSizeChanged( &(plt->pltPaperChooser), dg, plt->pltUnitType );

    appPaperChooserAdaptToGeometry( &(plt->pltPaperChooser),
						plt->pltUnitType, dg, set );

    appExposeRectangle( add, 0, 0, 0, 0 );

    return;
    }

/************************************************************************/
/*									*/
/*  One of the orientation toggle buttons has been pushed.		*/
/*									*/
/************************************************************************/

static void tedPageLayoutToolOrientationChosen(	APP_WIDGET	w,
						void *		voidplt,
						void *		voidtbcs  )
    {
    PageLayoutTool *		plt= (PageLayoutTool *)voidplt;
    AppDrawingData *		add= &(plt->pltDrawingData);
    DocumentGeometry *		dg= &(plt->pltGeometryChosen);

    int					changed;

    appPaperOrientationChosen( w, voidtbcs, &changed,
						&(plt->pltPaperChooser),
						plt->pltUnitType, dg );

    if  ( changed )
	{ appExposeRectangle( add, 0, 0, 0, 0 );	}

    return;
    }

/************************************************************************/
/*									*/
/*  Make the frame for the header and footer positions.			*/
/*									*/
/************************************************************************/

static void tedSectMakeHeaderFooterWidgets(
				APP_WIDGET			parent,
				const PageLayoutPageResources *	plpr,
				PageLayoutTool *		plt )
    {
    APP_WIDGET	label;
    APP_WIDGET	row;

    appMakeRowFrameInColumn( &(plt->pltHeaderFooterFrame),
					&(plt->pltHeaderFooterInside),
					parent, 2, plpr->plprPositionsText );

    appMakeColumnInRow( &(plt->pltHeaderFooterLeftColumn),
					plt->pltHeaderFooterInside, 0 );

    appMakeColumnInRow( &(plt->pltHeaderFooterRightColumn),
					plt->pltHeaderFooterInside, 1 );

    /**********************/
#   define	TW	7

    appMakeLabelAndTextRow( &row, &label, &(plt->pltHeaderPositionText),
				    plt->pltHeaderFooterLeftColumn,
				    plpr->plprHeaderPositionText, TW, 1 );

    appMakeLabelAndTextRow( &row, &label, &(plt->pltFooterPositionText),
				    plt->pltHeaderFooterRightColumn,
				    plpr->plprFooterPositionText, TW, 1 );

    appGuiSetGotValueCallbackForText( plt->pltHeaderPositionText,
				tedSectHeaderFooterPosChanged, (void *)plt );

    appGuiSetGotValueCallbackForText( plt->pltFooterPositionText,
				tedSectHeaderFooterPosChanged, (void *)plt );

    return;
    }

/************************************************************************/
/*									*/
/*  Make a section tool. I.E. the 'Section' page of the format tool.	*/
/*									*/
/************************************************************************/

void tedFormatFillPageLayoutPage( PageLayoutTool *		plt,
				const PageLayoutPageResources *	plpr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr )
    {
    EditApplication *	ea= plt->pltApplication;
    APP_WIDGET		row;

    /**************/

    plt->pltUnitType= appUnitTypeInt( plpr->plprUnitType );
    if  ( plt->pltUnitType < 0 )
	{ SDEB(plpr->plprUnitType); plt->pltUnitType= UNITtyINCH;	}

    /**************/

    appInitDrawingData( &(plt->pltDrawingData) );

    appInitDocumentGeometry( &(plt->pltGeometrySetDocument) );
    appInitDocumentGeometry( &(plt->pltGeometrySetSelection) );
    appInitDocumentGeometry( &(plt->pltGeometryChosen) );

    appInitPaperChooser( &(plt->pltPaperChooser) );

    /**************/

    plt->pltPageDrawing= appMakePageDrawing( pageWidget, ea, DRH_MM,
				    tedPageLayoutToolDrawPage, (void *)plt );

    appMakePaperChooserWidgets( pageWidget, plpr->plprPage,
					    &(plt->pltPaperChooser),
					    tedPageLayoutToolPaperSizeChanged,
					    (void *)plt );

    appPaperChooserAddOrientationToggles( &(plt->pltPaperChooser),
					    plpr->plprPortraitText,
					    plpr->plprLandscapeText,
					    tedPageLayoutToolOrientationChosen,
						(void *)plt );

    /**************/

    appMakeMarginToolWidgets( pageWidget, &(plpr->plprMarginToolResources),
					    &(plt->pltMarginTool),
					    tedPaperMarginChanged,
					    (void *)plt );

    tedSectMakeHeaderFooterWidgets( pageWidget, plpr, plt );

    /**************/

    appInspectorMakeButtonRow( &row, pageWidget,
	    &(plt->pltRevertSelectionWidget), &(plt->pltChangeSelectionWidget),
	    plpr->plprRevertSelectionText, plpr->plprChangeSelectionText,
	    tedFormatRevertLayoutPushed, tedFormatChangeLayoutPushed,
	    (void *)plt );

    appInspectorMakeButtonRow( &row, pageWidget,
	    &(is->isRevertButton), &(is->isApplyButton),
	    isr->isrRevert, isr->isrApplyToSubject,
	    tedFormatRevertLayoutPushed, tedFormatChangeLayoutPushed,
	    (void *)plt );
    plt->pltChangeDocumentWidget= is->isApplyButton;

    return;
    }

/************************************************************************/
/*									*/
/*  Finish the page layout page.					*/
/*									*/
/************************************************************************/

void tedFormatFillPageLayoutChoosers(	PageLayoutTool *		plt,
					const PageLayoutPageResources *	plpr )
    {
    appPaperChooserFillMenu( &(plt->pltPaperChooser),
			plpr->plprCustomPageSizeText,
			tedPageLayoutToolPaperSizeChosen, (void *)plt );

    return;
    }

void tedFormatFinishPageLayoutPage(	PageLayoutTool *		plt,
					TedFormatTool *			tft,
					const PageLayoutPageResources *	plpr )
    {
    AppDrawingData *	add= &(plt->pltDrawingData);
    const double	magnification= 1.0;

    appPaperChooserRetreshMenuWidth( &(plt->pltPaperChooser) );

    if  ( appSetDrawingDataForWidget( plt->pltPageDrawing,
						    magnification, add ) )
	{ LDEB(1);				}
    else{ plt->pltDrawingDataAllocated= 1;	}

    return;
    }

/************************************************************************/
/*									*/
/*  Get page layout tool resources.					*/
/*									*/
/************************************************************************/

static AppConfigurableResource TED_TedPageSubjectResourceTable[]=
    {
    APP_RESOURCE( "tableToolPageLayout",
		offsetof(InspectorSubjectResources,isrSubjectName),
		"Page Layout" ),
    APP_RESOURCE( "tableToolChangeDocumentPageLayout",
		offsetof(InspectorSubjectResources,isrApplyToSubject),
		"Apply to Document" ),
    APP_RESOURCE( "tableToolRevertDocumentPageLayout",
		offsetof(InspectorSubjectResources,isrRevert),
		"Revert to Document" ),
    };

static AppConfigurableResource TED_TedPageToolResourceTable[]=
    {
    APP_RESOURCE( "tableToolRevertSection",
		offsetof(PageLayoutPageResources,plprRevertSelectionText),
		"Revert to Selection" ),
    APP_RESOURCE( "tableToolChangeSelection",
		offsetof(PageLayoutPageResources,plprChangeSelectionText),
		"Apply to Selection" ),
    /**/
    APP_RESOURCE( "unit",
		offsetof(PageLayoutPageResources,plprUnitType),
		"inch" ),
    APP_RESOURCE( "formatToolPageLayoutPage",
		offsetof(PageLayoutPageResources,plprPage),
		"Page" ),
    APP_RESOURCE( "pageToolCustom",
		offsetof(PageLayoutPageResources,plprCustomPageSizeText),
		"Custom" ),
    APP_RESOURCE( "pageToolPortrait",
		offsetof(PageLayoutPageResources,plprPortraitText),
		"Portrait" ),
    APP_RESOURCE( "pageToolLandscape",
		offsetof(PageLayoutPageResources,plprLandscapeText),
		"Landscape" ),
    /**/
    APP_RESOURCE( "pageToolMargins",
		offsetof(PageLayoutPageResources,
				plprMarginToolResources.mtrTitleText),
		"Margins" ),
    APP_RESOURCE( "pageToolLeftMargin",
		offsetof(PageLayoutPageResources,
				plprMarginToolResources.mtrLeftMarginText),
		"Left" ),
    APP_RESOURCE( "pageToolTopMargin",
		offsetof(PageLayoutPageResources,
				plprMarginToolResources.mtrTopMarginText),
		"Top" ),
    APP_RESOURCE( "pageToolRightMargin",
		offsetof(PageLayoutPageResources,
				plprMarginToolResources.mtrRightMarginText),
		"Right" ),
    APP_RESOURCE( "pageToolBottomMargin",
		offsetof(PageLayoutPageResources,
				plprMarginToolResources.mtrBottomMarginText),
		"Bottom" ),
    /**/
/*!*/
    APP_RESOURCE( "formatToolSectHeaderFooterPositions",
		offsetof(PageLayoutPageResources,plprPositionsText),
		"Positions" ),
    APP_RESOURCE( "formatToolSectHeaderPosition",
		offsetof(PageLayoutPageResources,plprHeaderPositionText),
		"Header" ),
    APP_RESOURCE( "formatToolSectFooterPosition",
		offsetof(PageLayoutPageResources,plprFooterPositionText),
		"Footer" ),
    };

void tedFormatToolGetPageResourceTable(	EditApplication *		ea,
					PageLayoutPageResources *	plpr,
					InspectorSubjectResources *	isr )
    {
    appGuiGetResourceValues( ea, (void *)plpr,
				TED_TedPageToolResourceTable,
				sizeof(TED_TedPageToolResourceTable)/
				sizeof(AppConfigurableResource) );

    appGuiGetResourceValues( ea, (void *)isr,
				TED_TedPageSubjectResourceTable,
				sizeof(TED_TedPageSubjectResourceTable)/
				sizeof(AppConfigurableResource) );

    return;
    }
